<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'zoom', language 'de', version '4.2'.
 *
 * @package     zoom
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Aktionen';
$string['activitydate:ended'] = 'Beendet:';
$string['activitydate:started'] = 'Gestartet:';
$string['activitydate:starts'] = 'Startet:';
$string['addparticipant'] = 'Teilnehmer/in hinzufügen';
$string['addparticipantgroup'] = 'Teilnehmergruppe hinzufügen';
$string['addroom'] = 'Raum hinzufügen';
$string['addroomalert'] = 'Fügen Sie einen Raum durch Klicken hinzu.';
$string['addtocalendar'] = 'Zum Kalender hinzufügen';
$string['allmeetings'] = 'Alle Meetings';
$string['allmeetings_desc'] = 'Mit dieser Einstellung steuern Sie, ob ein Link zur Zoom Aktivität Indexseite am Ende jeder Zoom Aktivitäts-Übersichtsseite angezeigt wird oder nicht. Diese Einstellung beeinflusst nur die Ausgabe des Links auf den Zoom Aktivitäts-Übersichtsseiten. Selbst wenn Sie sich dazu entscheiden den Link dort nicht anzuzeigen könnte der Nutzer die Zoom Aktivität Indexseite trotzdem über andere Links innerhalb des Kurses erreichen.';
$string['allmeetings_disable'] = 'Alle Meetings Link deaktivieren';
$string['allmeetings_enable'] = 'Alle Meetings Link aktivieren';
$string['alternative_hosts'] = 'Alternative Veranstalter/innen';
$string['alternative_hosts_desc'] = 'Mit dieser Einstellung steuern Sie, ob die Option zur Auswahl alternativer Veranstalter/innen in den Aktivitätseinstellungen angezeigt wird oder nicht. Dabei stehen zwei Varianten zur Verfügung: Einmal ein einfaches Eingabefeld welches kommaseparierte E-Mail-Adressen akzeptiert. Und ein Nutzer-Auswahlfeld mit Auto-Vervollständigung welches die einfache Auswahl von Nutzern, welche im Kurs eingeschrieben sind, einen Zoom Account haben und eine der Rollen {$a->roles} haben, ermöglicht. Alternative Veranstalter/innen welche vom Trainer in Zoom direkt hinzugefügt wurden aber im Auswahlfeld in Moodle nicht zur Auswahl stehen, werden trotzdem auf der Zoom Aktivität Übersichtsseite ausgegeben und werden auch im Rahmen der Aktualisierung eines Zoom Meeting aus Moodle heraus nicht überschrieben.';
$string['alternative_hosts_disable'] = 'Alternative Veranstalter/innen deaktivieren';
$string['alternative_hosts_help'] = 'Die Option der alternativen Veranstalter/innen erlaubt es Ihnen, Meetings zu planen und andere Zoom Nutzer/innen zu ermächtigen das Meeting an Stelle von Ihnen zu starten. Diese Nutzer/innen erhalten eine E-Mail von Zoom in welcher Sie informiert werden dass sie als alternative/r Veranstalter/in hinzugefügt wurden und in der ein Link zum Starten des Meetings enthalten ist. Als Eingabeformat geben Sie bitte die E-Mail Adresse(n) der alternativen Veranstalter/innen an. Mehrere E-Mail Adressen separieren Sie bitte mit Kommas ohne Leerzeichen.';
$string['alternative_hosts_inputfield'] = 'Alternative Veranstalter/innen als einfaches Eingabefeld anzeigen';
$string['alternative_hosts_picker'] = 'Alternative Veranstalter/innen als Nutzer-Auswahlfeld mit Auto-Vervollständigung anzeigen';
$string['alternative_hosts_picker_help'] = 'Die Option der alternativen Veranstalter/innen erlaubt es Ihnen, Meetings zu planen und andere Zoom Nutzer/innen zu ermächtigen das Meeting an Stelle von Ihnen zu starten. Diese Nutzer/innen erhalten eine E-Mail von Zoom in welcher Sie informiert werden dass sie als alternative/r Veranstalter/in hinzugefügt wurden und in der ein Link zum Starten des Meetings enthalten ist. Sie können eine/n oder mehrere alternative Veranstalter/innen benennen. Falls Sie eine/n bestimmte/n Nutzer/in in diesem Auswahlfeld nicht finden können, ist diese/r Nutzer/in entweder nicht im Kurs mit einer geeigneten Rolle eingeschrieben oder hat keinen berechtigten Zoom Account.';
$string['alternative_hosts_picker_noneselected'] = 'Kein/e alternative/r Veranstalter/in ausgewählt';
$string['alternative_hosts_picker_placeholder'] = 'Nutzer/innen auswählen';
$string['apiendpoint'] = 'Zoom-API-Endpunkt';
$string['apiendpoint_desc'] = 'Wählen Sie, mit welchem Zoom-API-Endpunkt sich die Zoom-Aktivität verbinden wird. Der globale API Endpunkt sollte für alle Nutzer/innen funktionieren. Der EU (Europäische Union) API-Endpunkt ist ausschließlich für die Nutzung gedacht, welche eine Zoom-Lizenz mit EU-Provisionierung haben. Falls Sie unsicher sind, nutzen Sie bitte den globalen API Endpunkt.';
$string['apiendpoint_eu'] = 'EU-API-Endpunkt';
$string['apiendpoint_global'] = 'Globaler API-Endpunkt';
$string['apiidentifier'] = 'Zoom-API-Identifikator';
$string['apiidentifier_desc'] = 'Das Nutzerprofilfeld, welches beim Aufruf der Zoom-API als Identifikator herangezogen wird';
$string['apiurl'] = 'Zoom API URL';
$string['audio_both'] = 'Computeraudio und Telefon';
$string['audio_telephony'] = 'Nur Telefon';
$string['audio_voip'] = 'Nur Computeraudio';
$string['audiodefault'] = 'Audio Standard';
$string['authentication'] = 'Authentifizierung';
$string['cachedef_zoomid'] = 'Zoom-ID des Benutzers';
$string['cachedef_zoommeetingsecurity'] = 'Sicherheiteinstellungen der Zoom Meetings, einschließlich der Meeting Kenncode Anforderungen des Accounts';
$string['calendardescriptionURL'] = 'Beitritts-URL zum Meeting: {$a}.';
$string['calendardescriptionintro'] = 'Beschreibung: {$a}';
$string['calendariconalt'] = 'Kalender-Symbol';
$string['changehost'] = 'Veranstalter ändern';
$string['clickjoin'] = 'Taste "Meeting beitreten" geklickt';
$string['connectionfailed'] = 'Verbindung fehlgeschlagen:';
$string['connectionok'] = 'Verbindung funktioniert';
$string['connectionsettings'] = 'Verbindungseinstellungen';
$string['connectionsettings_desc'] = 'Diese Einstellungen definieren wie Moodle sich mit Zoom verbindet.';
$string['connectionstatus'] = 'Verbindungsstatus';
$string['day'] = 'Tag(e)';
$string['defaultsettings'] = 'Zoom-Standardeinstellungen';
$string['defaultsettings_help'] = 'Diese Einstellungen definieren den Standard für alle neuen Zoom Meetings und Webinare.';
$string['deletemeetingrecordings'] = 'Meeting-Aufzeichnungen aus Moodle löschen';
$string['deleteroom'] = 'Raum löschen';
$string['displayleadtime'] = 'Vorlaufzeit anzeigen';
$string['displayleadtime_desc'] = 'Wenn diese Einstellung aktiviert ist wird die Vorlaufzeit den Nutzer/innen angezeigt. Auf diesem Wege werden Nutzer/innen informiert dass / ab wann sie das Meeting vor dem geplanten Start des Meetings vorab betreten können. Dies kann dazu beitragen, dass Nutzer/innen nicht ständig die Seite neu laden bis sie schließlich beitreten können.';
$string['displayleadtime_nohideif'] = 'Bitte beachten: Diese Einstellung wird nur verarbeitet, wenn die Einstellung \'{$a}\' auf einen Wert größer null gesetzt ist.';
$string['displaypassword'] = 'Kenncode anzeigen';
$string['displaypassword_help'] = 'Wenn diese Einstellung aktiviert ist, wird der Kenncode auch für Nicht-Veranstalter immer angezeigt.';
$string['downloadical'] = 'Download iCal';
$string['downloadical_desc'] = 'Mit dieser Einstellung steuern Sie, ob ein Link zum Download einer iCal Datei zu einem Meeting auf der Zoom Aktivitäts-Übersichtsseite angezeigt wird oder nicht. Diese Einstellung beeinflusst nur die Möglichkeit eine iCal Datei für Drittsyteme herunterzuladen. Ungeachtet von dieser Einstellung wird die Zoom Aktivität einen Eintrag zum Moodle Kalender vornehmen sobald ein Startzeitpunkt für ein Meeting festgelegt ist.';
$string['downloadical_disable'] = 'Download iCal Link deaktivieren';
$string['downloadical_enable'] = 'Download iCal Link aktivieren';
$string['duration'] = 'Dauer (in Minuten)';
$string['encryptiontype'] = 'Verschlüsselungs-Typ';
$string['encryptiontype_alwaysshow'] = 'Auswahl des Verschlüsselungs-Typ immer anzeigen auch wenn der Nutzer es nicht nutzen kann';
$string['encryptiontype_desc'] = 'Mit dieser Einstellung steuern Sie, ob die Option zur Aktivierung von Ende-zu-Ende-Verschlüsselung im Gegensatz zur erweiterten Verschlüsselung in den Aktivitätseinstellungen angezeigt wird oder nicht. Diese Einstellung beeinflusst nur die Aktivitäts-Einstellungen in Moodle. Selbst wenn Sie sich dazu entscheiden die Option dort immer anzuzeigen wird der Nutzer vorab Ende-zu-Ende-Verschlüsselung auch in Zoom selbst freischalten müssen um es aus Moodle heraus nutzen zu können.';
$string['encryptiontype_disable'] = 'Auswahl des Verschlüsselungs-Typ deaktivieren';
$string['encryptiontype_showonlyife2epossible'] = 'Auswahl des Verschlüsselungs-Typ nur anzeigen wenn der Nutzer es auch nutzen kann';
$string['end_date_option_after'] = 'Nach';
$string['end_date_option_by'] = 'Am';
$string['end_date_option_occurrences'] = 'Ereignisse';
$string['enddate'] = 'Enddatum';
$string['endtime'] = 'Beendigungszeit';
$string['err_downloadicaldisabled'] = 'Der Download von iCal Dateien wurde deaktiviert.';
$string['err_downloadicalrecurringempty'] = 'Die Zoom iCal Datei für dieses Meeting kann nicht heruntergeladen werden, da sie kein einziges Ereignis enthält.';
$string['err_downloadicalrecurringnofixed'] = 'Die Zoom iCal Datei für dieses Meeting kann nicht heruntergeladen werden, da dies ein Meeting ohne bestimmte Zeit ist.';
$string['err_duration_nonpositive'] = 'Die Dauer muss einen positiven Wert haben.';
$string['err_duration_too_long'] = 'Die Dauer darf 150 Stunden nicht überschreiten.';
$string['err_end_date'] = 'Das Enddatum der Wiederkehr kann nicht in der Vergangenheit liegen.';
$string['err_end_date_before_start'] = 'Das Enddatum der Wiederkehr kann nicht vor dem Startdatum liegen.';
$string['err_invalid_password'] = 'Der Kenncode beinhaltet ungültige Zeichen.';
$string['err_long_timeframe'] = 'Der abgefragte Zeitrahmen ist zu groß, angezeigt werden die Resultate des letzten Monats.';
$string['err_password'] = 'Der Kenncode darf nur folgende Zeichen enthalten:  [a-z A-Z 0-9 @ - _ *]. Maximal 10 Zeichen.';
$string['err_password_required'] = 'Ein Kenncode ist erforderlich.';
$string['err_repeat_monthly_interval'] = 'Der maximale Interval für monatlich wiederkehrende Meetings beträgt 3 Monate.';
$string['err_repeat_weekly_interval'] = 'Der maximale Interval für wöchentlich wiederkehrende Meetings beträgt 12 Wochen.';
$string['err_start_time_past'] = 'Der Startzeitpunkt darf nicht in der Vergangenheit liegen.';
$string['err_start_time_past_recurring'] = 'Für wiederkehrende Meetings stellt der Datumsabschnitt dieses Feldes das frühestmögliche Datum für das nächste Meeting dar. Dieses Datum muss heute sein oder in der Zukunft liegen.';
$string['err_weekly_days'] = 'Wählen Sie den Tag bzw. die Tage für das wöchtlich wiederkehrende Meeting';
$string['erroraddinstance'] = 'Das Zoom Meeting konnte nicht erstellt werden. Für das wiederkehrende Meeting wurden ungültige Optionen gesetzt.';
$string['errorwebservice'] = 'Zoom-Webservice-Fehler: {$a}.';
$string['errorwebservice_badrequest'] = 'Zoom erhielt eine ungültige Anfrage: {$a}';
$string['errorwebservice_notfound'] = 'Die Ressource existiert nicht';
$string['export'] = 'Export';
$string['externaluser'] = 'Externe/r Nutzer/in';
$string['firstjoin'] = 'Beitritt zum Meeting möglich ab';
$string['firstjoin_desc'] = 'Der früheste Zeitpunkt, zu dem ein Benutzer einem anberaumten Meeting beitreten kann (Minuten vor dem Beginn).';
$string['getmeetingrecordings'] = 'Meeting-Aufzeichnungen von Zoom abrufen';
$string['getmeetingreports'] = 'Meeting Bericht von Zoom abrufen';
$string['globalsettings'] = 'Allgemeine Einstellungen';
$string['globalsettings_desc'] = 'Diese Einstellungen gelten für das Zoom Plugin als Ganzes.';
$string['host'] = 'Veranstalter/in';
$string['hostintro'] = '<a target="_blank" href="https://support.zoom.us/hc/de/articles/208220166">Alternative Veranstalter/innen</a> können Zoom Meetings starten und das Wartezimmer verwalten.';
$string['invalid_status'] = 'Ungültiger Status, Datenbank prüfen!';
$string['invalidscheduleuser'] = 'Sie können für den angegebenen Nutzer kein Meeting planen.';
$string['invitation_dialin'] = '\'Telefoneinwahl\' Ausdruck';
$string['invitation_dialin_help'] = 'Der reguläre Ausdruck um die Zoom Einwahlnummern zu finden.';
$string['invitation_h323'] = '\'H.323\' Ausdruck';
$string['invitation_h323_help'] = 'Der reguläre Ausdruck um die H.323 Informationen zum Zoom Meeting zu finden. Falls Ihre Einladungen keine SIP oder H.323 Informationen enthalten, setzen Sie die Ausdrücke auf eine leere Zeichenkette. (Dies gilt insbesondere für Server auf welchen Debugging aktiviert ist weil ansonsten die Formatierung von speziellen Dateitypen wie den iCal Exports zerbrechen kann.)';
$string['invitation_icallink'] = '\'iCal Link\' Ausdruck';
$string['invitation_icallink_help'] = 'Der reguläre Ausdruck um den iCal Link zum Zoom Meeting zu finden.';
$string['invitation_invite'] = '\'Einladungszeile\' Ausdruck';
$string['invitation_invite_help'] = 'Der reguläre Ausdruck um die Einladungszeile zum Zoom Meeting zu finden.';
$string['invitation_joinurl'] = '\'Link zum Beitritt\' Ausdruck';
$string['invitation_joinurl_help'] = 'Der reguläre Ausdruck um den Link zum Beitritt zum Zoom Meeting zu finden.';
$string['invitation_onetapmobile'] = '\'One tap mobile\' Ausdruck';
$string['invitation_onetapmobile_help'] = 'Der reguläre Ausdruck um die One tap mobile Informationen zum Zoom Meeting zu finden.';
$string['invitation_sip'] = '\'SIP\' Ausdruck';
$string['invitation_sip_help'] = 'Der reguläre Ausdruck um die SIP Informationen zum Zoom Meeting zu finden. Falls Ihre Einladungen keine SIP oder H.323 Informationen enthalten, setzen Sie die Ausdrücke auf eine leere Zeichenkette. (Dies gilt insbesondere für Server auf welchen Debugging aktiviert ist weil ansonsten die Formatierung von speziellen Dateitypen wie den iCal Exports zerbrechen kann.)';
$string['invitationmatchnotfound'] = 'Für das Element "{$a->element}" wurde mit dem Ausdruck "{$a->pattern}" kein Treffer in der Zoom Einladung gefunden.';
$string['invitationmodificationfailed'] = 'Fehler im Ausdruck "{$a->pattern}" für das Element "{$a->element}".';
$string['invitationregex'] = 'Zoom Einladung: Reguläre Ausdrücke und Berechtigungen';
$string['invitationregex_help'] = 'Hier definieren Sie die regulären Ausdrücke mit welchen Sie die Teile der Zoom Einladung separieren mit dem Ziel die Anzeige der einzelnen Informationsteile durch Berechtigungen zu steuern.';
$string['invitationregex_nohideif'] = 'Bitte beachten: Die regulären Ausdrücke werden nur verarbeitet, wenn die Einstellung \'{$a}\' aktiviert ist.';
$string['invitationregexenabled'] = 'Reguläre Ausdrücke und Berechtigungen für Zoom Einladungen aktivieren';
$string['invitationregexenabled_help'] = 'Wenn diese Einstellung aktiviert ist, wird die Zoom Einladung in Elemente aufgeteilt. Anhand der folgenden regulären Ausdrücke und Berechtigungen wird entschieden, ob ein bestimmter Teil einer Person angezeigt wird oder nicht. Sehen Sie auch die zoom/viewjoinurl und zoom/viewdialin Berechtigungen an.';
$string['invitationremoveicallink'] = 'iCal Link aus der Einladung entfernen';
$string['invitationremoveicallink_help'] = 'Wenn diese Einstellung aktiviert ist, wird der iCal Link der Zoom Einladung anhand des invitation_icallink Ausdrucks entfernt werden.';
$string['invitationremoveinvite'] = 'Einladungszeile aus der Einladung entfernen';
$string['invitationremoveinvite_help'] = 'Wenn diese Einstellung aktiviert ist, wird die Einladungszeile der Zoom Einladung anhand des invitation_invite Ausdrucks entfernt werden.';
$string['join'] = 'Beitreten';
$string['join_meeting'] = 'Dem Meeting beitreten';
$string['joinbeforehost'] = 'Meeting vor Veranstalter/in betreten';
$string['joinbeforehostenable'] = 'Teilnehmer/innen können jederzeit beitreten';
$string['joinlink'] = 'Link zum Beitritt';
$string['jointime'] = 'Zeitpunkt des Beitritts';
$string['leavetime'] = 'Zeitpunkt des Verlassens';
$string['licenseonjoin'] = 'Wählen Sie diese Option aus, wenn Sie wollen, dass der/die Veranstalter/in eine Lizenz sowohl beim Start des Meetings <i>als auch</i> beim Erstellen des Meetings erhält.';
$string['licensesettings'] = 'Lizenz-Einstellungen';
$string['licensesettings_desc'] = 'Diese Einstellungen definieren wie Moodle mit Ihrer Zoom Lizenz umgeht.';
$string['licensesnumber'] = 'Anzahl der Lizenzen';
$string['lowlicenses'] = 'Wenn die Anzahl Ihrer Lizenzen die erforderliche Anzahl übersteigt, wird bei der Erstellung jeder neuen Aktivität durch den Nutzer eine PRO-Lizenz zugewiesen, indem der Status eines anderen Nutzers herabgesetzt wird. Diese Option ist wirksam, wenn die Anzahl der aktiven PRO-Lizenzen mehr als 5 beträgt.';
$string['maskparticipantdata'] = 'Nutzerdaten verbergen';
$string['maskparticipantdata_help'] = 'Verhindert, dass Nutzerdaten in Berichten auftauchen (nützlich für Seiten, die Nutzerdaten aus Datenschutzgründen verbergen)';
$string['media'] = 'Medien';
$string['meeting_finished'] = 'Beendet';
$string['meeting_invite'] = 'Details zur Telefoneinwahl';
$string['meeting_invite_hide'] = 'Meeting-Einladung verbergen';
$string['meeting_invite_show'] = 'Meeting-Einladung anzeigen';
$string['meeting_nonexistent_on_zoom'] = 'Das Meeting ist nicht auf Zoom verfügbar';
$string['meeting_not_started'] = 'Noch nicht begonnen';
$string['meeting_started'] = 'Läuft';
$string['meeting_time'] = 'Startzeit';
$string['meetingcapacitywarning'] = 'Meeting Kapazitätswarnung';
$string['meetingcapacitywarning_desc'] = 'Mit dieser Einstellung können Sie eine Warnung anzeigen lassen, falls der Kurs mehr aktive und eingeschriebene Teilnehmer/innen hat als die Zoom Lizenz des Veranstalters zulässt. Die Warnung wird dem Veranstalter (und den alternativen Veranstalter/innen) auf der Zoom Aktivitäts-Übersichtsseite angezeigt werden. Sie wird dem Veranstalter empfehlen sich an den Zoom Account Inhaber zu wenden um nötigenfalls eine größere Zoom Lizenz zu erhalten. Sie können diese Nachricht über die Moodle Sprachanpassung anpassen.';
$string['meetingcapacitywarning_disable'] = 'Meeting Kapazitätswarnung deaktivieren';
$string['meetingcapacitywarning_enable'] = 'Meeting Kapazitätswarnung aktivieren';
$string['meetingcapacitywarningbodyalthost'] = 'Die Zoom Lizenz des Veranstalters dieses Meetings, {$a->hostname}, hat eine Kapazität von <strong>{$a->meetingcapacity} Meeting Teilnehmer/innen</strong>, aber dieser Kurs hat <strong><a href="{$a->courseparticipantsurl}">{$a->eligiblemeetingparticipants} eingeschriebene und aktive Teilnehmer/innen</a></strong>.';
$string['meetingcapacitywarningbodyrealhost'] = 'Ihre Zoom Lizenz hat eine Kapazität von <strong>{$a->meetingcapacity} Meeting Teilnehmer/innen</strong>, aber dieser Kurs hat <strong><a href="{$a->courseparticipantsurl}">{$a->eligiblemeetingparticipants} eingeschriebene und aktive Teilnehmer/innen</a></strong>.';
$string['meetingcapacitywarningcontactalthost'] = 'Bitte bitten Sie den Veranstalter sich an den Zoom Account Verwalter zu wenden um eine größere Zoom Lizenz zu erhalten, falls alle diese Kursteilnehmer/innen wirklich an Ihrem Meeting teilnehmen sollen.';
$string['meetingcapacitywarningcontactrealhost'] = 'Bitte wenden Sie sich an den Zoom Account Verwalter um eine größere Zoom Lizenz zu erhalten, falls alle diese Kursteilnehmer/innen wirklich an Ihrem Meeting teilnehmen sollen.';
$string['meetingcapacitywarningheading'] = 'Meeting Kapazitätswarnung:';
$string['meetingparticipantsdeleted'] = 'Nutzerdaten desto Person gelöscht.';
$string['modulename'] = 'Zoom Meeting';
$string['modulename_help'] = 'Zoom ist eine Video- und Web-Plattform, die authorisierten Benutzern ermöglicht, online Meetings anzubieten.';
$string['modulenameplural'] = 'Zoom Meetings';
$string['month'] = 'Monat(e)';
$string['month_day_text'] = 'des Monats';
$string['newmeetings'] = 'Neue Meetings';
$string['nextoccurrence'] = 'Nächstes Ereignis';
$string['nomeetinginstances'] = 'Es wurden keine Sitzungen zu diesem Meeting gefunden.';
$string['nooccurrenceleft'] = 'Das letzte Ereignis ist bereits vorüber.';
$string['noparticipants'] = 'Zur Zeit sind noch keine Teilnehmer vorhanden.';
$string['norecordings'] = 'Zur Zeit sind noch keine Aufzeichnungen vorhanden.';
$string['norooms'] = 'Keine Räume';
$string['nosessions'] = 'Keine Sitzungen im gewählten Zeitrahmen vorhanden';
$string['nozooms'] = 'Keine Meetings';
$string['nozoomsfound'] = 'Keine Meetings im angegebenen Kurs gefunden.';
$string['occurson'] = 'Ereignet sich am';
$string['off'] = 'Aus';
$string['oldmeetings'] = 'Beendete Meetings';
$string['on'] = 'Ein';
$string['option_audio'] = 'Audio-Optionen';
$string['option_audio_help'] = 'Mit dieser Option können Sie den Nutzern erlauben, sich per Computeraudio, per Telefon oder mit beidem zum Meeting zu verbinden';
$string['option_authenticated_users'] = 'Authentifizierung zum Beitritt erforderlich';
$string['option_authenticated_users_help'] = 'Wenn diese Option aktiviert ist müssen alle Teilnehmer/innen sich mit ihrem Zoom Account autorisieren um das Meeting betreten zu können. Diese Option bezieht sich <em>nicht</em> auf den Login in Moodle.';
$string['option_encryption_type'] = 'Verschlüsselung';
$string['option_encryption_type_endtoendencryption'] = 'Ende-zu-Ende Verschlüsselung';
$string['option_encryption_type_enhancedencryption'] = 'Erweiterte Verschlüsselung';
$string['option_encryption_type_help'] = 'Mit dieser Option können Sie das Verschlüsselungsniveau des Meetings steuern.

*Erweiterte Verschlüsselung* bedeutet dass der Verschlüsselungs-Schlüssel in der Zoom Cloud gespeichert wird.

*Ende-zu-Ende Verschlüsselung* bedeutet dass der Verschlüsselungs-Schlüssel auf Ihrem lokalen Endgerät gespeichert wird und niemand, auch nicht Zoom, diesen erlangen kann.

Bitte beachten Sie dass, wenn Sie Ende-zu-Ende Verschlüsselung aktivieren, mehrere Funktionen innerhalb des Meetings nicht zur Verfügung stehen - [Die Details finden Sie in der Zoom Dokumentation](https://support.zoom.us/hc/de/articles/360048660871).';
$string['option_host_video'] = 'Veranstalter-Video';
$string['option_host_video_help'] = 'Wenn diese Option aktiviert ist wird das Video des Veranstalters beim Beitritt zum Meeting aktiviert werden. Aber auch wenn Sie diese Option deaktivieren wird der Veranstalter sein Video jederzeit aktivieren können.';
$string['option_jbh'] = 'Beitritt vor Veranstalter/in';
$string['option_jbh_help'] = 'Wenn diese Option aktiviert ist werden die Teilnehmer/innen dem Meeting schon vor dem Veranstalter beitreten können. Ebenso können sie beitreten wenn der Veranstalter gar nicht selbst am Meeting teilnimmt. Diese Option schließt sich mit der Option "Wartezimmer" gegenseitig aus, das Aktivieren der einen Option wird die andere deaktivieren.';
$string['option_mute_upon_entry'] = 'Teilnehmer/innen bei Beitritt stummschalten';
$string['option_mute_upon_entry_help'] = 'Wenn diese Option aktiviert ist werden alle Teilnehmer/innen stummgeschaltet wenn Sie dem Meeting beitreten. Die Teilnehmer/innen können sich nach dem Beitritt selbst auf laut schalten.';
$string['option_participants_video'] = 'Teilnehmer-Video';
$string['option_participants_video_help'] = 'Wenn diese Option aktiviert ist wird das Video der Teilnehmer/innen beim Beitritt zum Meeting aktiviert werden. Aber auch wenn Sie diese Option deaktivieren werden die Teilnehmer/innen ihr Video jederzeit aktivieren können.';
$string['option_proxyhost'] = 'Proxy benutzen';
$string['option_proxyhost_desc'] = 'Der hier als \'<code>&lt;hostname&gt;:&lt;port&gt;</code>\' eingestellte Proxy wird nur für die Kommunikation mit Zoom genutzt. Leer lassen um die Moodle Standardeinstellungen für Proxys zu nutzen. Dies muss nur eingestellt werden, wenn kein globaler Proxy in Moodle eingestellt wird.';
$string['option_view_recordings'] = 'Zulassen, dass Aufzeichnungen angezeigt werden';
$string['option_waiting_room'] = 'Wartezimmer';
$string['option_waiting_room_help'] = 'Wenn diese Option aktiviert ist wird der Veranstalter den Beitritt jedes einzelnen Teilnehmers prüfen und freigeben können. Diese Option schließt sich mit der Option "Beitritt vor Veranstalter/in ermöglichen" gegenseitig aus, das Aktivieren der einen Option wird die andere deaktivieren.';
$string['participantdatanotavailable'] = 'Details nicht verfügbar';
$string['participantdatanotavailable_help'] = 'Für diese Sitzung sind keine Teilnehmerprotokolle verfügbar';
$string['participantgroups'] = 'Teilnehmergruppen';
$string['participants'] = 'Teilnehmer/innen';
$string['password'] = 'Kenncode';
$string['password_allowed_char'] = 'Kenncode darf nur folgende Zeichen enthalten: [a-z A-Z 0-9 @ - _ *].';
$string['password_consecutive'] = 'Maximale Anzahl von {$a} fortlaufenden Zeichen hintereinander (abcd, 1111, 1234, etc.).';
$string['password_length'] = 'Minimum von {$a} Zeichen.';
$string['password_letter'] = 'Kenncode muss mindestens einen Buchstaben enthalten.';
$string['password_lower_upper'] = 'Kenncode muss sowohl Klein- als auch Großbuchstaben enthalten.';
$string['password_max_length'] = 'Maximum von 10 Zeichen.';
$string['password_number'] = 'Kenncode muss mindestens eine Ziffer enthalten.';
$string['password_only_numeric'] = 'Kenncode darf nur Ziffern und keine anderen Zeichen enthalten.';
$string['password_special'] = 'Kenncode muss mindestens ein Sonderzeichen (@-_*) enthalten.';
$string['passwordprotected'] = 'Kenncode geschützt';
$string['pluginadministration'] = 'Zoom Meeting verwalten';
$string['pluginname'] = 'Zoom Meeting';
$string['privacy:metadata:zoom_meeting_details'] = 'Die Datenbanktabelle, die Informationen über jede Meeting-Instanz speichert.';
$string['privacy:metadata:zoom_meeting_details:topic'] = 'Der Name des Meetings, welches die Person besucht hat.';
$string['privacy:metadata:zoom_meeting_participants'] = 'Die Datenbank-Tabelle, welche Informationen über die Teilnehmer/innen des Meetings speichert.';
$string['privacy:metadata:zoom_meeting_participants:duration'] = 'Die Zeit, wie lange die Person an dem Meeting teilgenommen hat.';
$string['privacy:metadata:zoom_meeting_participants:join_time'] = 'Die Zeit, zu der die Person dem Meeting beigetreten ist.';
$string['privacy:metadata:zoom_meeting_participants:leave_time'] = 'Die Zeit, zu der die Person das Meeting verlassen hat.';
$string['privacy:metadata:zoom_meeting_participants:name'] = 'Name der Person';
$string['privacy:metadata:zoom_meeting_participants:user_email'] = 'E-Mail-Adresse der Person';
$string['recording'] = 'Aufzeichnung';
$string['recordingadd'] = 'Aufzeichnung hinzufügen';
$string['recordingdate'] = 'Aufzeichnungsdatum';
$string['recordingdelete'] = 'Möchten Sie die Aufzeichnung "{$a}" wirklich löschen?';
$string['recordinghide'] = 'Aufzeichnung verbergen (derzeit sichtbar)';
$string['recordinglink'] = 'Link zur Aufzeichnung';
$string['recordingname'] = 'Titel';
$string['recordingnotfound'] = 'Aufzeichnung wurde nicht gefunden';
$string['recordingnotvisible'] = 'Aufzeichnung ist nicht sichtbar. Wenden Sie sich bitte an Ihre Systemadministrator/innen, wenn Sie der Meinung sind, dass dies ein Fehler ist.';
$string['recordingpasscode'] = 'Kennwort der Aufzeichnung';
$string['recordings'] = 'Aufzeichnungen';
$string['recordingshow'] = 'Aufzeichnung anzeigen (derzeit verborgen)';
$string['recordingurl'] = 'URL der Aufzeichnung';
$string['recordingview'] = 'Aufzeichnungen ansehen';
$string['recordingvisibility'] = 'Sind Aufzeichnungen für dieses Meeting standardmäßig sichtbar?';
$string['recordingvisibility_help'] = 'Wenn neue Aufzeichnungen für dieses Meeting abgerufen werden, sollten sie standardmäßig in Moodle sichtbar sein?';
$string['recreatesuccessful'] = 'Meeting erfolgreich neu erstellt';
$string['recurrence_option_daily'] = 'Täglich';
$string['recurrence_option_monthly'] = 'Monatlich';
$string['recurrence_option_no_time'] = 'Keine bestimmte Zeit';
$string['recurrence_option_weekly'] = 'Wöchentlich';
$string['recurrencetype'] = 'Wiederkehr';
$string['recurringmeeting'] = 'Wiederkehrendes Meeting';
$string['recurringmeeting_help'] = 'Wenn diese Option aktiviert ist wird das Meeting als wiederkehrend angelegt und wird kein Enddatum und keinen Schlusszeitpunkt haben. Es wird jederzeit betreten werden können.';
$string['recurringmeetingexplanation'] = 'Das Meeting hat kein Enddatum und keinen Schlusszeitpunkt';
$string['recurringmeetinglong'] = 'Wiederkehrendes Meeting (Meeting ohne Enddatum oder Schlusszeitpunkt)';
$string['recurringmeetingthisis'] = 'Dies ist ein wiederkehrendes Meeting';
$string['recycleonjoin'] = 'Lizenz bei Beitritt wiederverwenden';
$string['redefinelicenses'] = 'Lizenzen neu definieren';
$string['refreshreports'] = 'Sitzungsbericht aktualisieren';
$string['register'] = 'Registrierung';
$string['registration'] = 'Registrierung erforderlich';
$string['registration_help'] = 'Wenn diese Option ausgewählt wird, müssen sich Teilnehmer/innen vor dem Betreten eines Meetings oder Webinars registrieren.';
$string['registration_text'] = 'Teilnehmer/innen zwingen, sich für das Meeting/Webinar zu registrieren';
$string['repeatinterval'] = 'Wiederholen alle';
$string['report'] = 'Berichte';
$string['reportapicalls'] = 'Meldung API-Aufrufe ausgeschöpft';
$string['requirepasscode'] = 'Meeting Kenncode erforderlich';
$string['requirepasscode_help'] = 'Wenn diese Einstellung aktiviert ist, muss der Veranstalter für das Meeting einen Kenncode vergeben. Beitretende Teilnehmer/innen müssen diesen Kenncode eingeben bevor sie das Meeting betreten können. Teilnehmer/innen, die das Meeting aber direkt aus der Moodle Aktivität betreten, müssen den Kenncode nicht eingeben.';
$string['resetapicalls'] = 'Anzahl der verfügbaren API-Aufrufe zurücksetzen';
$string['schedule'] = 'Zeitplan';
$string['schedulefor'] = 'Meeting planen für';
$string['schedulefor_help'] = 'Sie können Meetings im Namen eines anderen Nutzers planen. Als Voraussetzung muss dieser Nutzer Ihnen einmalig die Planungsberechtigung in Zoom erteilt haben. Der ausgewählte Nutzer wird dann der Veranstalter des Meetings und es wird auch seine Zoom Lizenz für das Meeting genutzt werden.';
$string['scheduleforself'] = 'Sie selbst';
$string['schedulingprivilege'] = 'Planungsberechtigung';
$string['schedulingprivilege_desc'] = 'Mit dieser Einstellung steuern Sie, ob die Planungsberechtigungs-Option in den Aktivitätseinstellungen angezeigt wird oder nicht. Diese Einstellung beeinflusst nur die Aktivitäts-Einstellungen in Moodle. Selbst wenn Sie sich dazu entscheiden die Option dort immer anzuzeigen wird der Nutzer vorab die Planungsberechtigung in Zoom selbst von einem anderen Nutzer zugeteilt bekommen um aus Moodle heraus schlussendlich ein Meeting in dessen Namen planen zu können.';
$string['schedulingprivilege_disable'] = 'Planungsberechtigung deaktivieren';
$string['schedulingprivilege_enable'] = 'Planungsberechtigung aktivieren';
$string['search:activity'] = 'Zoom - Aktivitäts-Informationen';
$string['security'] = 'Sicherheit';
$string['selectionarea'] = 'Keine Auswahl';
$string['sessions'] = 'Sitzungen';
$string['sessionsreport'] = 'Sitzungsbericht';
$string['sesskeyinvalid'] = 'Ungültige Sitzung erkannt.';
$string['setpasscode'] = 'Kenncode setzen';
$string['showmedia'] = 'Abschnitt \'Medien\' anzeigen';
$string['showmedia_help'] = 'Wenn diese Option aktiviert, ist wird der Abschnitt \'Medien\' auf der Meetingseite angezeigt.';
$string['showmediaonview'] = 'Abschnitt \'Medien\' auf Meetingseite anzeigen';
$string['showschedule'] = 'Abschnitt \'Zeitplan\' anzeigen';
$string['showschedule_help'] = 'Wenn diese Option aktiviert ist, wird der Abschnitt \'Zeitplan\' auf der Meetingseite angezeigt.';
$string['showscheduleonview'] = 'Abschnitt \'Zeitplan\' auf Meetingseite anzeigen';
$string['showsecurity'] = 'Abschnitt \'Sicherheit\' anzeigen';
$string['showsecurity_help'] = 'Wenn diese Option aktiviert ist, wird der Abschnitt \'Sicherheit\' auf der Meetingseite angezeigt.';
$string['showsecurityonview'] = 'Abschnitt \'Sicherheit\' auf Meetingseite anzeigen';
$string['start'] = 'Start';
$string['start_meeting'] = 'Meeting starten';
$string['start_time'] = 'Wann';
$string['starthostjoins'] = 'Video starten, wenn der Veranstalter beitritt';
$string['startpartjoins'] = 'Video starten, sobald Teilnehmer/in beitritt';
$string['starttime'] = 'Startzeit';
$string['status'] = 'Status';
$string['supplementaryfeaturessettings'] = 'Ergänzende Funktionen';
$string['supplementaryfeaturessettings_desc'] = 'Diese Einstellungen steuern ob und wie ergänzende Zoom Funktionen den Nutzern angeboten werden.';
$string['title'] = 'Titel';
$string['topic'] = 'Thema';
$string['unavailable'] = 'Sie können aktuell nicht beitreten.';
$string['unavailablefinished'] = 'Das Meeting ist schon beendet.';
$string['unavailablefirstjoin'] = 'Sie können frühestens {$a->mins} Minuten vor der geplanten Startzeit beitreten.';
$string['unavailablenotstartedyet'] = 'Das Meeting wurde noch nicht gestartet.';
$string['updatemeetings'] = 'Meeting-Einstellungen von Zoom aktualisieren';
$string['usepersonalmeeting'] = 'Die persönliche Meeting ID {$a} nutzen';
$string['waitingroom'] = 'Wartezimmer';
$string['waitingroomenable'] = 'Wartezimmer aktivieren';
$string['webinar'] = 'Webinar';
$string['webinar_already_false'] = '<p><b>Diese Sitzung wurde als Meeting, nicht als Webinar angelegt. Sie können diese Einstellung nicht ändern, nachdem das Meeting angelegt wurde.</b></p>';
$string['webinar_already_true'] = '<p><b>Diese Sitzung wurde als Webinar, nicht als Meeting angelegt. Sie können diese Einstellung nicht ändern, nachdem das Webinar angelegt wurde.</b></p>';
$string['webinar_alwaysshow'] = 'Webinar Option immer anzeigen auch wenn der Nutzer keine Lizenz für Webinare hat';
$string['webinar_by_default'] = 'Webinar als default';
$string['webinar_by_default_desc'] = 'Zoom-Aktivität standardmäßig als Webinar erstellen.';
$string['webinar_desc'] = 'Mit dieser Einstellung steuern Sie ob die Option um Webinare anzulegen in den Aktivitätseinstellungen bei der Erstellung eines Meetings angeboten wird oder nicht. Diese Einstellung beeinflusst nur die Aktivitäts-Einstellungen in Moodle. Selbst wenn Sie sich dazu entscheiden die Option dort immer anzuzeigen wird der Nutzer trotzdem noch eine gültige Lizenz für Webinare benötigen um ein Webinar anbieten zu können.';
$string['webinar_disable'] = 'Webinare deaktivieren';
$string['webinar_help'] = 'Mit Webinaren haben Veranstalter erweiterte Kontrollmöglichkeiten und Flexibilität bei Meetings mit großen Teilnehmerzahlen. Diese Option ist nur für dafür freigeschaltete Zoom Accounts verfügbar.';
$string['webinar_showonlyiflicense'] = 'Webinar Option nur anzeigen wenn der Nutzer auch eine Lizenz für Webinare hat';
$string['webinarthisis'] = 'Dies ist ein Webinar';
$string['week'] = 'Woche(n)';
$string['weekoption_first'] = 'Erster';
$string['weekoption_fourth'] = 'Vierter';
$string['weekoption_last'] = 'Letzter';
$string['weekoption_second'] = 'Zweiter';
$string['weekoption_third'] = 'Dritter';
$string['zoom:addinstance'] = 'Ein neues Zoom-Meeting hinzufügen';
$string['zoom:eligiblealternativehost'] = 'Als alternative/r Veranstalter/in in Zoom Meetings auswählbar';
$string['zoom:refreshsessions'] = 'Zoom Meetings Bericht aktualisieren';
$string['zoom:view'] = 'Zoom-Meetings ansehen';
$string['zoom:viewdialin'] = 'Zoom Einwahlinformationen sehen';
$string['zoom:viewjoinurl'] = 'Zoom Link zum Beitritt sehen';
$string['zoomerr'] = 'Ein Fehler mit Zoom ist aufgetreten.';
$string['zoomerr_alternativehostusernotfound'] = 'Der Nutzer {$a} wurde auf Zoom nicht gefunden.';
$string['zoomerr_apilimit'] = 'Das tägliche Limit für diese API ist erreicht. Versuchen Sie es erneut um {$a}';
$string['zoomerr_id_missing'] = 'Sie müssen eine Kursmodul-ID oder eine Instanz-ID angeben';
$string['zoomerr_licensesnumber_missing'] = 'Die Zoom \'utmost\' Einstellung wurde gefunden, aber die \'licensesnumber\' Einstellung wurde nicht gefunden';
$string['zoomerr_maxretries'] = 'Versuchte {$a->maxretries} mal den Anruf zu machen, aber scheiterte: {$a->response}';
$string['zoomerr_meetingnotfound'] = 'Das Meeting kann auf Zoom nicht gefunden werden. Sie können es <a href="{$a->recreate}">hier neu erstellen</a> oder <a href="{$a->delete}">es komplett löschen</a>.';
$string['zoomerr_meetingnotfound_info'] = 'Dieses Meeting konnte nicht auf Zoom gefunden werden. Bei Fragen wenden Sie sich bitte an den Veranstalter.';
$string['zoomerr_usernotfound'] = 'Ihr Konto konnte auf Zoom nicht gefunden werden. Wenn Sie Zoom zum ersten Mal verwenden, müssen Sie Ihr Konto aktivieren, indem Sie sich bei <a href="{$a}" target="_blank">{$a}</a> anmelden. Sobald Sie Ihr Zoom-Konto aktiviert haben, laden Sie diese Seite erneut und fahren Sie mit der Einrichtung Ihres Meetings fort. Andernfalls stellen Sie sicher, dass Ihre E-Mail-Adresse auf Zoom mit Ihrer E-Mail Adresse in diesem System übereinstimmt.';
$string['zoomerr_viewrecordings_off'] = 'Aufzeichnungen anzeigen ist ausgeschaltet. Die Aufgabe kann nicht ausgeführt werden.';
$string['zoomurl'] = 'URL der Zoom-Homepage';
