<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'ja', version '4.2'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = '私について';
$string['actingasrole'] = '現在、あなたは異なるロールとして操作しています。';
$string['activatetemplateoverride'] = '「 {$a} 」のテンプレートオーバーライドを有効にする';
$string['activatetemplateoverridedesc'] = 'この設定を有効にしてテキストを含む場合、「 {$a->setting} 」設定の値が「 {$a->template} 」テンプレートの値として使用されます。';
$string['activebreadcrumb'] = 'アクティブブレッドクラム背景色';
$string['activebreadcrumbdesc'] = 'アクティブブレッドクラム色およびブレッドクラムバーのリマインダの背景色を設定します。';
$string['activitiesheading'] = '活動';
$string['alertaccess'] = '警告可視性';
$string['alertaccessadmins'] = '管理者に表示する';
$string['alertaccessdesc'] = '警告ボックス可視性のアクセス制限タイプを設定します。注意: 「カスタムプロファイルフィールド制限を追加する」を使用している場合、あなたは以下の値をプロファイルフィールドに追加する必要があります。';
$string['alertaccessglobal'] = 'すべての人に表示する';
$string['alertaccessprofile'] = 'カスタムプロファイルフィールド制限を追加する';
$string['alertaccessusers'] = 'ログインユーザに表示する';
$string['alertannounce'] = 'アナウンスメント';
$string['alertannouncedesc'] = '警告ボックスにアナウンスメントを表示する';
$string['alertbackgroundcolorinfo'] = '情報背景色';
$string['alertbackgroundcolorinfodesc'] = '情報タイプ警告ボックスの背景色です。';
$string['alertbackgroundcolorsuccess'] = 'アナウンスメント背景色';
$string['alertbackgroundcolorsuccessdesc'] = 'アナウンスメントタイプ警告ボックスの背景色です。';
$string['alertbackgroundcolorwarning'] = '警告背景色';
$string['alertbackgroundcolorwarningdesc'] = '警告タイプ警告ボックスの背景色です。';
$string['alertbordercolorinfo'] = '情報枠線色';
$string['alertbordercolorinfodesc'] = '情報タイプ警告ボックスの枠線色です。';
$string['alertbordercolorsuccess'] = 'アナウンスメント枠線色';
$string['alertbordercolorsuccessdesc'] = 'アナウンスメントタイプ警告ボックスの枠線色です。';
$string['alertbordercolorwarning'] = '警告枠線色';
$string['alertbordercolorwarningdesc'] = '警告タイプ警告ボックスの枠線色です。';
$string['alertcolorinfo'] = '情報色';
$string['alertcolorinfodesc'] = '情報タイプ警告ボックスのアイコン色です。';
$string['alertcolorsheading'] = '上部警告ボックスをカスタマイズする';
$string['alertcolorsuccess'] = 'アナウンスメント色';
$string['alertcolorsuccessdesc'] = 'アナウンスメントタイプ警告ボックスのアイコン色';
$string['alertcolorwarning'] = '警告色';
$string['alertcolorwarningdesc'] = '警告タイプ警告ボックスのアイコン色';
$string['alertcount'] = '警告カウント';
$string['alertcountdesc'] = '以下の編集エリアに表示する警告数です。';
$string['alertdesc'] = 'サイト上部に警告として表示するテキストを入力または修正してください。2つ以上の警告を異なるユーザタイプに設定できます。また、あなたはサイト全体またはホームページのみの警告表示を選択できます。<br /><br /><strong>注意:</strong> 現在、非表示のコースで教師にも警告を表示できます。';
$string['alertdisabled'] = '無効';
$string['alertdisabledesc'] = 'この警告を無効にします。';
$string['alerthiddencourse'] = 'コース警告を有効にする';
$string['alerthiddencoursedesc'] = 'コースページに警告を表示します。';
$string['alerticoninfo'] = '情報アイコン';
$string['alerticoninfodesc'] = '情報タイプ警告ボックスに使用する<a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesomeアイコン</a>を設定します。「fa-」接頭辞をつけずにアイコン名を入力してください。';
$string['alerticonsuccess'] = 'アナウンスメントアイコン';
$string['alerticonsuccessdesc'] = 'アナウンスメントタイプ警告ボックスに使用する<a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesomeアイコン</a>を設定します。「fa-」接頭辞をつけずにアイコン名を入力してください。';
$string['alerticonwarning'] = '警告アイコン';
$string['alerticonwarningdesc'] = '警告タイプ警告ボックスに使用する<a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesomeアイコン</a>を設定します。「fa-」接頭辞をつけずにアイコン名を入力してください。';
$string['alertinfo'] = '情報';
$string['alertinfodesc'] = '警告ボックスに情報を表示します。';
$string['alertkeyvalue'] = '警告キー';
$string['alertkeyvalue_details'] = '前の警告からこの警告を特定するためのキーです。あなたがこれを変更した場合、前の警告を解除したすべてのユーザに警告が表示されます。あなたが警告を修正した場合、すべてのユーザが確実に修正を確認するようこれを変更しても良いでしょう。';
$string['alertprofilefield'] = 'カスタムプロファイルフィールド名=値 (任意)';
$string['alertprofilefielddesc'] = 'カスタムプロファイルフィールドで使用するアクセスルールを追加します。例) usertype=student';
$string['alertsettings'] = '警告ボックス {$a}';
$string['alertsettingscourse'] = 'コース警告設定';
$string['alertsettingsgeneral'] = '一般警告設定';
$string['alertsettingsheading'] = '上部警告ボックスをカスタマイズします。<a href="./../theme/adaptable/pix/layout.png" target="_blank">ここ</a>でレイアウトを確認してください。';
$string['alerttext'] = '警告テキスト';
$string['alerttextdesc'] = '警告ボックスに表示するテキストを入力してください。';
$string['alerttype'] = '警告ボックスタイプ';
$string['alerttypedesc'] = '警告タイプを選択してください: 情報 (青), 警告 (黄色), アナウンスメント (緑)';
$string['alertwarning'] = '警告';
$string['alertwarningdesc'] = '警告ボックスに警告を表示します。';
$string['analyticscount'] = 'アナリティクスカウント';
$string['analyticscountdesc'] = '以下の編集エリアに表示するアナリティクスフィールド数です。';
$string['analyticsprofilefield'] = 'カスタムプロファイルフィールド Name=Value (任意)';
$string['analyticsprofilefielddesc'] = 'カスタムプロファイルフィールドを使用してアクセスルールを追加します。例) usertype=student';
$string['analyticssettings'] = 'アナリティクス';
$string['analyticssettingsdesc'] = 'あなたは複数のGoogleアナリティクスコードをセットアップしてユーザプロファイルフィールドで使用できます。また、あなたはオープンソースアナリティクスのMatomoを使用できます。';
$string['analyticssettingsheading'] = 'GoogleアナリティクスまたはMatomoをセットアップする';
$string['analyticstext'] = 'アナリティクスID';
$string['analyticstextdesc'] = 'GoogleアナリティクスIDを入力してください。';
$string['anonymizega'] = 'ユーザIPを匿名化する';
$string['anonymizegadesc'] = 'Googleアナリティクスに送信されるユーザのIPを匿名化します。';
$string['backcolor'] = '背景色';
$string['backcolordesc'] = '背景色を設定します。';
$string['bcustyle'] = 'BCUスタイル';
$string['blockbackgroundcolor'] = 'ブロック背景色';
$string['blockbackgroundcolordesc'] = 'すべてのブロックの背景色を設定します。';
$string['blockbordercolor'] = 'ブロック枠線色';
$string['blockbordercolordesc'] = 'ブロック枠線色を設定します。';
$string['blockheaderbackgroundcolor'] = 'ブロックヘッディング背景色';
$string['blockheaderbackgroundcolordesc'] = 'すべてのブロックのヘッディング背景色を設定します。';
$string['blockheaderborderbottom'] = 'ブロックヘッダ下部枠線幅';
$string['blockheaderborderbottomdesc'] = 'ブロックヘッダ下部の枠線の幅を設定します。';
$string['blockheaderborderleft'] = 'ブロックヘッダ左側枠線幅';
$string['blockheaderborderleftdesc'] = 'ブロックヘッダ左側の枠線の幅を設定します。';
$string['blockheaderborderright'] = 'ブロックヘッダ右側枠線幅';
$string['blockheaderborderrightdesc'] = 'ブロックヘッダ右側の枠線の幅を設定します。';
$string['blockheaderbordertop'] = 'ブロックヘッダ上部枠線幅';
$string['blockheaderbordertopdesc'] = 'ブロックヘッダ上部の枠線の幅を設定します。';
$string['blockheaderbordertopstyle'] = 'ブロックヘッダ枠線スタイル';
$string['blockheaderbordertopstyledesc'] = 'ブロックヘッダの枠線のスタイルを設定します。';
$string['blockheaderbottomradius'] = 'ブロックヘッダ下部レディアス';
$string['blockheaderbottomradiusdesc'] = '湾曲/曲線効果を適用するため、ヘッダブロック下部のレディアスを設定します。';
$string['blockheadercolor'] = 'ブロックヘッダフォント色';
$string['blockheadercolordesc'] = 'ブロックヘッダのフォント色を設定します。';
$string['blockheadertopradius'] = 'ブロックヘッダ上部レディアス';
$string['blockheadertopradiusdesc'] = '湾曲/曲線効果を適用するため、ヘッダブロック上部のレディアスを設定します。';
$string['blockicons'] = 'ブロックアイコン';
$string['blockiconsdesc'] = 'ブロックヘッダ領域にブロックアイコンを表示するにはこれを設定してください。';
$string['blockiconsheadersize'] = 'ブロックヘッダアイコンサイズ';
$string['blockiconsheadersizedesc'] = 'Moodleブロックヘッダで使用されるフォントアイコンサイズを設定します。リストから値を選択してください。';
$string['blocklayoutbuilder'] = 'フロントブロック領域';
$string['blocklayoutbuilderdesc'] = '以下、あなたはフロントページのブロック領域の独自レイアウトを構築できます。これらの領域にコンテンツを追加する場合、あなたは<strong>Moodleフロントページで編集モードを有効</strong>にする必要があります。そして、あなたが作成する領域にブロックをドラッグ&ドロップできます!';
$string['blocklayoutlayoutcheck'] = 'あなたのレイアウトをチェックする';
$string['blocklayoutlayoutcheckdesc'] = 'あなたが使用しているブロック数および新しいレイアウトの表示を確認するには以下のツールを使用してください。';
$string['blocklayoutlayoutcount1'] = 'あなたは最大ブロック領域を設定できます。';
$string['blocklayoutlayoutcount2'] = '現在次を使用しています:';
$string['blocklayoutlayoutrow'] = 'ブロック領域行';
$string['blocklayoutlayoutrowdesc'] = 'フロントページのブロック領域行のレイアウトを追加/設定します。';
$string['blockmainborderbottom'] = 'メインブロック下部枠線幅';
$string['blockmainborderbottomdesc'] = 'メインブロック領域下部の枠線幅を設定します。';
$string['blockmainborderleft'] = 'メインブロック左枠線幅';
$string['blockmainborderleftdesc'] = 'メインブロック領域左側の枠線幅を設定します。';
$string['blockmainborderright'] = 'メインブロック右枠線幅';
$string['blockmainborderrightdesc'] = 'メインブロック領域右側の枠線幅を設定します。';
$string['blockmainbordertop'] = 'メインブロック上部枠線幅';
$string['blockmainbordertopdesc'] = 'メインブロック領域上部の枠線幅を設定します。';
$string['blockmainbordertopstyle'] = 'メインブロック枠線スタイル';
$string['blockmainbordertopstyledesc'] = 'ブロックコンテンツ領域の枠線スタイルを設定します。';
$string['blockmainbottomradius'] = 'メインブロック下部レイディアス';
$string['blockmainbottomradiusdesc'] = '湾曲/曲線効果を適用するため、メインブロック領域下部のレディアス設定します。';
$string['blockmaintopradius'] = 'メインブロック上部レイディアス';
$string['blockmaintopradiusdesc'] = '湾曲/曲線効果を適用するため、メインブロック領域上部のレディアス設定します。';
$string['blockregionbackground'] = 'ブロック領域背景色';
$string['blockregionbackgrounddesc'] = 'フロントページでカスタムブロックレイアウトを保持するコンテナの背景色です。';
$string['blockside'] = 'ブロックの場所';
$string['blocksidedesc'] = 'ブロックをページの左右どちらに表示するか管理します。';
$string['breadcrumb'] = 'ブレッドクラム';
$string['breadcrumbbackgroundcolor'] = 'ブレッドクラム背景色';
$string['breadcrumbbackgroundcolordesc'] = 'ブレッドクラムの背景色を設定します。';
$string['breadcrumbdisplay'] = 'ブレッドクラム表示';
$string['breadcrumbdisplaydesc'] = 'コースのブレッドクラムに何を表示するか設定します。';
$string['breadcrumbhome'] = 'ブレッドクラムホーム';
$string['breadcrumbhomedesc'] = 'ホームブレッドクラムをアイコンまたはテキストとして表示します。';
$string['breadcrumbhomeicon'] = 'アイコン';
$string['breadcrumbhometext'] = 'テキスト';
$string['breadcrumbseparator'] = 'ブレッドクラムセパレータ';
$string['breadcrumbseparatordesc'] = 'ブレッドクラムに使用する<a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesomeアイコン</a>を設定します。「fa-」接頭辞をつけずにアイコン名を入力してください。';
$string['breadcrumbtextcolor'] = 'ブレッドクラムテキスト色';
$string['breadcrumbtextcolordesc'] = 'ブレッドクラムのテキスト色を設定します。';
$string['breadcrumbtitle'] = 'ブレッドクラムコース名';
$string['breadcrumbtitledesc'] = 'ブレッドクラムにコースタイトルを表示するよう設定します。';
$string['bs4all'] = '極小- 極大';
$string['bs4extralarge'] = '特大のみ';
$string['bs4large'] = '大 - 特大';
$string['bs4medium'] = '中 - 特大';
$string['bs4none'] = 'なし';
$string['bs4small'] = '小 - 特大';
$string['buttoncolor'] = 'ボタン色';
$string['buttoncolorcancel'] = 'キャンセルボタン色';
$string['buttoncolordesc'] = 'サイト全体で使用されるメインボタン色です。';
$string['buttoncolordesccancel'] = 'キャンセルボタンの背景色です。<br />透明にするにはボックスに「transparent」と入力してください。';
$string['buttoncolordescscnd'] = 'サイト全体で使用される第2ボタン色です。';
$string['buttoncolorscnd'] = '第2ボタン色';
$string['buttondesc'] = 'このテーマで使用されるボタンのアピアランスを変更します。';
$string['buttondropshadow'] = 'ボタン下部のドロップシャドウ装飾';
$string['buttondropshadowdesc'] = 'ボタン下部にドロップシャドウ (陰影) を表示します。';
$string['buttonhovercolor'] = 'ボタン色 (ホバー時)';
$string['buttonhovercolorcancel'] = 'キャンセルボタン色 (ハボリング時)';
$string['buttonhovercolordesc'] = 'ボタンの上にカーソルが置かれた場合のボタンの色です。';
$string['buttonhovercolordesccancel'] = 'ボタンの上にカーソルが置かれた場合のキャンセルボタン色です。<br />透明にするにはボックスに「transparent」と入力してください。';
$string['buttonhovercolordescscnd'] = 'ボタンの上にカーソルが置かれた場合の第2ボタンの色です。';
$string['buttonhovercolorscnd'] = '第2ボタン色 (ホバー時)';
$string['buttonlogincolor'] = 'ログインボタン色';
$string['buttonlogincolordesc'] = 'ログインボタンの色を設定します。';
$string['buttonloginheight'] = 'ログインボタンをヘッダを設定する';
$string['buttonloginheightdesc'] = 'ヘッダ上部にログインフォームを使用する場合のみ有効です。';
$string['buttonloginhovercolor'] = 'ログインボタンホバー色';
$string['buttonloginhovercolordesc'] = 'ログインボタンのホバー色です。';
$string['buttonloginmargintop'] = 'ログインボタンの上部マージンを設定する';
$string['buttonloginmargintopdesc'] = 'ログインボタンの間隔/位置を変更できるようにします。';
$string['buttonloginpadding'] = 'ログインボタンのパディングを設定する';
$string['buttonloginpaddingdesc'] = '数字大 = ボタン大';
$string['buttonlogintextcolor'] = 'ログインボタンテキスト色';
$string['buttonlogintextcolordesc'] = 'ログインボタンで使用されるテキスト色です。';
$string['buttonradius'] = 'ボタンレディアスを設定する';
$string['buttonradiusdesc'] = '高いレディアス = 曲線ボタン, 低いレディアス = 直角ボタン';
$string['buttonsettings'] = 'ボタン';
$string['buttonsettingsheading'] = 'このテーマのボタンをカスタマイズします。';
$string['buttontextcolor'] = 'ボタンテキスト色';
$string['buttontextcolorcancel'] = 'キャンセルボタンテキスト色';
$string['buttontextcolordesc'] = 'ボタンに使用するテキストの色です。';
$string['buttontextcolordesccancel'] = 'キャンセルボタンに使用するテキストの色です。';
$string['buttontextcolordescscnd'] = '第2ボタンに使用するテキストの色です。';
$string['buttontextcolorscnd'] = '第2ボタンテキスト色';
$string['categoryhavecustomheader'] = 'カテゴリカスタムヘッダ';
$string['categoryhavecustomheaderdesc'] = 'カスタムヘッダのあるトップレベルのカテゴリを選択してください。複数カテゴリを選択または選択解除するには「Ctrl」キーを使用してください。更新するには保存してページを再読み込みしてください。注意: 選択されたサブカテゴリは設定値を継承します。';
$string['categoryheaderbgimage'] = 'カテゴリ「 {$a->name} 」 (ID: {$a->id}) の背景イメージ';
$string['categoryheaderbgimagedesc'] = 'ヘッダのトップレベルカテゴリ「 {$a->name} 」 (ID: {$a->id}) の背景イメージを設定します。最小サイズは1600x180px (1900x180px推奨) です。イメージはヘッダ全体に表示されます。';
$string['categoryheaderbgimagedescchildren'] = 'ヘッダのトップレベルカテゴリ「 {$a->name} 」 (ID: {$a->id}) および子カテゴリ「 {$a->children} 」の背景イメージを設定します。最小サイズは1600x180px (1900x180px推奨) です。イメージはヘッダ全体に表示されます。';
$string['categoryheadercustomcss'] = 'カテゴリ「 {$a->name} 」 (ID: {$a->id}) のカスタムCSS';
$string['categoryheadercustomcssdesc'] = 'トップレベルカテゴリ「 {$a->name} 」 (ID: {$a->id}) のカスタムCSSを設定します。これは接頭辞「.category-{$a->id}」のテーマセレクタでCSSを生成します。CSSが適用されない場合、PHPログファイルをチェックしてください。';
$string['categoryheadercustomcssdescchildren'] = 'トップレベルカテゴリ「 {$a->name} 」 (ID: {$a->id}) および子カテゴリ「 {$a->children} 」のカスタムCSSを設定します。これは接頭辞「.category-{$a->id}」のテーマセレクタでCSSを生成します。CSSが適用されない場合、PHPログファイルをチェックしてください。';
$string['categoryheadercustomtitle'] = 'カテゴリ「 {$a->name} 」 (ID: {$a->id}) のカスタムタイトル';
$string['categoryheadercustomtitledesc'] = 'ヘッダのトップレベルカテゴリ「 {$a->name} 」(ID: {$a->id}) のカスタムタイトルを設定します。空白にした場合、非コースページまたは「enableheading」が無効にされたコースの「sitetitle」および「sitetitletext」に何が設定されているか表示されます。非コースカテゴリにリンクされたページに表示される場合、サイトタイトルに置換されます。コースページに表示される場合、「enableheading」設定に基づきタイトルの上に表示されます。モバイルデバイスでは「responsivecoursetitle」設定が有効にされた場合のみ表示されます。';
$string['categoryheadercustomtitledescchildren'] = 'ヘッダのトップレベルカテゴリ「 {$a->name} 」(ID: {$a->id}) および子カテゴリ「 {$a->children} 」のカスタムタイトルを設定します。空白にした場合、非コースページまたは「enableheading」が無効にされたコースの「sitetitle」および「sitetitletext」に何が設定されているか表示されます。非コースカテゴリにリンクされたページに表示される場合、サイトタイトルに置換されます。コースページに表示される場合、「enableheading」設定に基づきタイトルの上に表示されます。モバイルデバイスでは「responsivecoursetitle」設定が有効にされた場合のみ表示されます。';
$string['categoryheaderheader'] = 'トップレベルカテゴリ「 {$a->name} 」 (ID: {$a->id}) 設定';
$string['categoryheaderheaderdesc'] = 'トップレベルカテゴリ「 {$a->name} 」 (ID: {$a->id}) を設定します。';
$string['categoryheaderheaderdescchildren'] = 'トップレベルカテゴリ「 {$a->name} 」 (ID: {$a->id}) および子カテゴリ「 {$a->children} 」設定';
$string['categoryheaderlogo'] = 'カテゴリ「 {$a->name} 」 (ID: {$a->id}) のロゴ';
$string['categoryheaderlogodesc'] = 'ヘッダのトップレベルカテゴリ「 {$a->name} 」 (ID: {$a->id}) のロゴを設定します。推奨サイズは200px x 80pxです。';
$string['categoryheaderlogodescchildren'] = 'ヘッダのトップレベルカテゴリ「 {$a->name} 」 (ID: {$a->id}) および子カテゴリ「 {$a->children} 」のロゴを設定します。推奨サイズは200px x 80pxです。';
$string['categoryheaderssettings'] = 'カテゴリヘッダ';
$string['categoryheaderssettingsdesc'] = 'カテゴリ内のヘッダを設定します。';
$string['categoryheaderssettingsheading'] = '1つ以上のトップレベルカテゴリおよび下位カテゴリのヘッダを変更します。';
$string['cdefaulticon'] = 'マイコースデフォルトアイコン';
$string['cdefaulticondesc'] = '「fa-」接頭辞なしのFont Awesome 4アイコンはアイコンが存在しない場合にコースに使用されます。空白の場合、デフォルトが使用されます。';
$string['cfrozenicon'] = 'マイコース利用停止アイコン';
$string['cfrozenicondesc'] = '「fa-」接頭辞なしのFont Awesome 4アイコンは利用停止コースに使用されます。空白の場合、デフォルトが使用されます。';
$string['chiddenicon'] = 'マイコース非表示アイコン';
$string['chiddenicondesc'] = '「fa-」接頭辞なしのFont Awesome 4アイコンは非表示コースに使用されます。空白の場合、デフォルトが使用されます。';
$string['choosereadme'] = '<div class="clearfix"> <div class="well"> <h2>Adaptable</h2> <p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p> </div> <div class="well"> <h3>About</h3> <p>Adaptable is a Moodle 2-columns responsive theme highly customizable and based in the popular BCU theme. Version 2 is using Boost as a base theme and therefore Bootstrap 4.</p> <p>The theme is licensed under the GPL (GNU General Public License). You can find a complete licence copy <a href="http://www.gnu.org/licenses/" target="_HERE">blank</a></p> <br> <h4>Modify it! - Improve it! - Share it!</h4> <br> <h3>Credits</h3> <p>This theme has been developed by:<br> Jeremy Hopkins (Coventry University)<br> Fernando Acedo (<a href="https://3-bits.com" target="_blank">3-bits.com</a>)</p> Manoj Solanki (Coventry University)<br> <br> <h2>Other Credits</h2> <p>In the development of version 2 they have also collaborated:<br> Gareth J. Barnard (http://moodle.org/user/profile.php?id=442195) Stuart Lamour Alistair Spark (University College London) <br> <p>among many other developers, testers, translators and volunteers (See <a href="adaptable/README.txt" target="_blank">README.txt</a>)</p> <br> <h3>Bugs Report</h3> <p>You can report bugs (and please, <b>ONLY</b> bugs) in our <a href="https://gitlab.com/3bits/moodle-theme_adaptable2" target="_blank">repository</a></p> <br> <h3>Technical Support</h3> <p>You can ask your questions in the moodle forum:</p> <ul> <li>English: <a href="https://moodle.org/mod/forum/discuss.php?d=340404" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340404</a> <li>Español: <a href="https://moodle.org/mod/forum/discuss.php?d=326804" target="_blank">https://moodle.org/mod/forum/discuss.php?d=326804</a> <li>Català: <a href="https://moodle.org/mod/forum/discuss.php?d=340406" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340406</a> </ul> <br> <h3>Demo</h3> <p>You can see a demo version <a href="https://adaptable.ws/demo" target="_blank">HERE</a></p> </div> </div>';
$string['cneveraccessedicon'] = 'マイコース未アクセスアイコン';
$string['cneveraccessedicondesc'] = '「fa-」接頭辞なしのFont Awesome 4アイコンはユーザ登録済みでアクセスのないコースに使用されます。空白の場合、デフォルトが使用されます。';
$string['collapsedtopicscoloursenabled'] = '折りたたみトピックトグル前面および背景色設定';
$string['collapsedtopicscoloursenableddesc'] = 'Adaptableの「sectionheadingcolor」および「coursesectionheaderbg」設定の代わりに折りたたみトピック前面および背景色設定を使用します。';
$string['colordesc'] = 'あなたはテーマ全体で使用したい色を選択できます。16進コードまたは標準表記法を使用してください。あなたは代替オプションとして「transparent」および「inherited」を使用できます。';
$string['colorsettings'] = '色';
$string['colorsettingsheading'] = 'テーマ全体で使用されるメイン色を修正します。';
$string['configtabtitle'] = 'Adaptable設定';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'コース';
$string['coursepageactivitybottomblockregionheading'] = 'カスタムコース活動ブロック下部領域';
$string['coursepageactivitybottomblockregionheadingdesc'] = '活動の最後に表示されるカスタムブック領域です。';
$string['coursepageblockactivitybottomenabled'] = 'コースページのコース活動ブロック下部領域を有効にする';
$string['coursepageblockactivitybottomenableddesc'] = 'すべてのコースページでこの領域を有効にします。';
$string['coursepageblocklayoutbuilder'] = 'コースページブロック領域';
$string['coursepageblocklayoutbuilderdesc'] = '以下、あなたはコースページのブロック領域の独自レイアウトを構築できます。これらの領域にコンテンツを追加するにはあなたは<strong>Moodleフロントページで編集モードを有効</strong>にする必要があります。そして、あなたが作成した領域にブロックをドラッグ&ドロップできます!';
$string['coursepageblocklayoutlayoutbottomrow'] = 'コースページブロック下部領域行';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'コースページのブロック領域行のレイアウトを追加/設定します。';
$string['coursepageblocklayoutlayouttoprow'] = 'コースページブロック上部領域行';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'コースページのブロック領域行のレイアウトを追加/設定します。';
$string['coursepageblockregionsettings'] = 'コースページブロック領域ビルダ';
$string['coursepageblocksenabled'] = 'コースページのカスタムブロック領域を有効にする';
$string['coursepageblocksenableddesc'] = 'あなたはコースページのカスタムブロック領域 (上部および下部) を有効/無効にできます。そして、あなたが作成した領域にブロックをドラッグ&ドロップできます。';
$string['coursepageblocksliderenabled'] = 'コースページのカスタムスライダブロック領域を有効にします。';
$string['coursepageblocksliderenableddesc'] = 'すべてのコースページでこの領域を有効にします。';
$string['coursepageheaderhidesitetitle'] = 'コースページのサイトタイトルを非表示にする';
$string['coursepageheaderhidesitetitledesc'] = 'コースページのサイトタイトル、ロゴおよび検索バーを非表示にします。コース関連ページに小さなヘッダを表示するにはこの設定と共にページヘッダ高設定を使用してください。';
$string['coursepagenewssliderblockregionheading'] = 'カスタムニューススライダブロック領域';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Adaptable UIの一部であるニューススライダと使用するためにデザインされたカスタムブロック領域です。この領域はコースページのコース活動の上に表示されます。ニューススライダブロックを追加するには最初に<strong><a href="https://moodle.org/plugins/block_news_slider">Adaptable UI ニューススライダ</a></strong>をインストールしてすべてのコースページの「コースページスライダ領域」に表示するよう設定してください。';
$string['coursepagesidebarinfooterenabled'] = 'サイドバーをコースページのフッタに移動する';
$string['coursepagesidebarinfooterenableddesc'] = 'サイドバーをフッタに移動してコースページレイアウトの幅を広げます。';
$string['coursepagesidebarinfooterenabledsection'] = '一般設定';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'コースフォーマットの大部分の一般設定です。';
$string['courses'] = 'コース';
$string['coursesectionactivityassignbgcolor'] = '課題活動背景色';
$string['coursesectionactivityassignbgcolordesc'] = '課題活動の背景色を設定します。<br />透明にするにはボックスに「transparent」と入力してください。';
$string['coursesectionactivityassignleftbordercolor'] = '課題活動左枠線表示色';
$string['coursesectionactivityassignleftbordercolordesc'] = '左枠線の色を設定します。';
$string['coursesectionactivitybordercolor'] = 'コースセクション活動下部枠線色';
$string['coursesectionactivitybordercolordesc'] = 'コースセクション活動下部枠線の色を設定します。';
$string['coursesectionactivityborderstyle'] = 'コースセクション活動下部枠線スタイル';
$string['coursesectionactivityborderstyledesc'] = 'コースセクション活動下部枠線のスタイルを設定します。';
$string['coursesectionactivityborderwidth'] = 'コースセクション活動下部枠線幅';
$string['coursesectionactivityborderwidthdesc'] = 'コースセクション活動下部枠線の幅を設定します。';
$string['coursesectionactivitycolors'] = 'コースセクション活動オプション';
$string['coursesectionactivityforumbgcolor'] = 'フォーラム活動背景色';
$string['coursesectionactivityforumbgcolordesc'] = 'フォーラム活動の背景色を設定します。透明にするにはボックスに「transparent」と入力してください。';
$string['coursesectionactivityforumleftbordercolor'] = 'フォーラム活動左枠線表示色';
$string['coursesectionactivityforumleftbordercolordesc'] = '左枠線の色を設定します。';
$string['coursesectionactivityheadingcolour'] = 'コースセクション活動ヘッディング色';
$string['coursesectionactivityheadingcolourdesc'] = 'コースホームページに表示されるクリック可能活動の色です。';
$string['coursesectionactivityiconsize'] = 'コースセクション活動アイコンサイズ';
$string['coursesectionactivityiconsizedesc'] = '活動/リソースのアイコンサイズを設定します (例 値「16px」には「16px x 16px」が設定されます)。';
$string['coursesectionactivityleftborderwidth'] = 'コースセクション活動左枠線幅';
$string['coursesectionactivityleftborderwidthdesc'] = 'コースセクション活動の左側に表示される枠線の幅を設定します。';
$string['coursesectionactivitymarginbottom'] = '下部マージン活動間隔';
$string['coursesectionactivitymarginbottomdesc'] = '活動間の下部マージン間隔です。';
$string['coursesectionactivitymargintop'] = '上部マージン活動間隔';
$string['coursesectionactivitymargintopdesc'] = '活動間の上部マージン間隔です。';
$string['coursesectionactivityquizbgcolor'] = '小テスト活動背景色';
$string['coursesectionactivityquizbgcolordesc'] = '小テスト活動の背景色を設定します。透明にするにはボックスに「transparent」と入力してください。';
$string['coursesectionactivityquizleftbordercolor'] = '小テスト左枠線表示色';
$string['coursesectionactivityquizleftbordercolordesc'] = '左枠線の色を設定します。';
$string['coursesectionbgcolor'] = 'コースセクション背景';
$string['coursesectionbgcolordesc'] = 'コースセクションの背景色を設定します。';
$string['coursesectionbordercolor'] = 'コースセクション枠線色';
$string['coursesectionbordercolordesc'] = 'コースセクションの枠線色を設定します。';
$string['coursesectionborderradius'] = 'コースセクション枠線レディアス';
$string['coursesectionborderradiusdesc'] = 'コースセクション枠線のレディアスを設定します (角丸)。';
$string['coursesectionborderstyle'] = 'コースセクション枠線スタイル';
$string['coursesectionborderstyledesc'] = 'コースセクションの枠線スタイルを設定します。';
$string['coursesectionborderwidth'] = 'コースセクション枠線幅';
$string['coursesectionborderwidthdesc'] = 'コースセクションの枠線幅を設定します。';
$string['coursesectionheaderbg'] = 'コースセクションヘッダ背景';
$string['coursesectionheaderbgdesc'] = 'コースセクションヘッダの背景色を設定します。';
$string['coursesectionheaderbordercolor'] = 'コースセクションヘッダ枠線色';
$string['coursesectionheaderbordercolordesc'] = 'コースセクションヘッダ枠線の色を設定します (外側のコンテナにも枠線があるため枠線下部のみ使用されます)。';
$string['coursesectionheaderborderradiusbottom'] = 'コースヘッダセクション枠線下部レディアス';
$string['coursesectionheaderborderradiusbottomdesc'] = 'コースセクションヘッダ枠線の下部レディアスを設定します (角丸)。';
$string['coursesectionheaderborderradiustop'] = 'コースヘッダセクション枠線上部レディアス';
$string['coursesectionheaderborderradiustopdesc'] = 'コースセクションヘッダ枠線の上部レディアスを設定します (角丸)。';
$string['coursesectionheaderborderstyle'] = 'コースセクションヘッダ枠線スタイル';
$string['coursesectionheaderborderstyledesc'] = 'コースセクションヘッダ枠線のスタイルを設定します (外側のコンテナにも枠線があるため枠線下部のみ使用されます)';
$string['coursesectionheaderborderwidth'] = 'コースセクションヘッダ枠線幅';
$string['coursesectionheaderborderwidthdesc'] = 'コースセクションヘッダ枠線の幅を設定します (外側のコンテナにも枠線があるため枠線下部のみに使用されます)。';
$string['coursesections'] = 'コースセクション';
$string['coursesettings'] = 'コースフォーマット';
$string['coursesettingsdesc'] = '最も使用されているMoodleコースフォーマットをメインのデザインに合わせてカスタマイズします。';
$string['coursesettingsheading'] = 'コースフォーマット設定';
$string['coursetitlefullname'] = 'コースフルネーム';
$string['coursetitlemaxwidth'] = 'コースタイトル最大幅';
$string['coursetitlemaxwidthdesc'] = 'コースタイトル領域の最大文字数を設定します。';
$string['coursetitleshortname'] = 'コース省略名/コード';
$string['covbkcolor'] = 'コンベントリタイルタイトル背景色';
$string['covbkcolordesc'] = 'コンベントリタイルレンダラが選択された場合のタイトル背景色を設定します。';
$string['coventrystyle'] = 'コンベントリスタイル';
$string['covfontcolor'] = 'コンベントリタイルフォント色';
$string['covfontcolordesc'] = 'コンベントリタイルレンダラが選択された場合のタイトルフォント色を設定します。';
$string['covhidebutton'] = 'コンベントリタイルコースボタン';
$string['covhidebuttondesc'] = 'コンベントリタイル選択時にコースボタンを非表示にする場合、これを設定してください。';
$string['currentcolor'] = '現在のコースセクション強調色';
$string['currentcolordesc'] = '現在のコースセクションの強調色を設定します。';
$string['customcoursesubtitle'] = 'カスタムコースサブタイトル';
$string['customcoursesubtitledesc'] = 'コースサブタイトルのユーザプロファイルカスタムフィールド名です。';
$string['customcoursetitle'] = 'カスタムコースタイトル';
$string['customcoursetitledesc'] = 'コースタイトルのユーザプロファイルカスタムフィールド名です。';
$string['customcss'] = 'カスタムCSS';
$string['customcssdesc'] = 'このテーマのカスタマイズを容易にするため、あなたがこのテキスト領域アに追加したCSSルールはすべてのページに反映されます。';
$string['dangericoncolor'] = '警告アイコン色';
$string['dangericoncolordesc'] = '主に必須フィールドで使用される警告/危険アイコンの色を設定します。';
$string['dashblocklayoutbuilder'] = 'ダッシュボードブロック領域';
$string['dashblocklayoutbuilderdesc'] = '以下、あなたはダッシュボードページのブロック領域の独自レイアウトを構築できます。これらの領域にコンテンツを追加するには<strong>Moodleフロントページで編集モードを有効</strong>にする必要があります。そして、あなたが作成した領域にブロックをドラッグ&ドロップできます!';
$string['dashblocklayoutlayoutrow'] = 'ダッシュボードブロック領域行';
$string['dashblocklayoutlayoutrowdesc'] = 'ダッシュボードページのブロック領域行のレイアウトを追加/設定します。';
$string['dashblocksabovecontent'] = 'メインコンテンツの上に表示する';
$string['dashblocksbelowcontent'] = 'メインコンテンツの下に表示する';
$string['dashblocksenabled'] = 'ダッシュボードページのカスタムブロック領域を有効にする';
$string['dashblocksenableddesc'] = 'あなたはダッシュボードページのカスタムブロック領域を有効/無効にできます。そして、あなたが作成した領域にブロックをドラッグ&ドロップできます。';
$string['dashblocksposition'] = 'カスタムブロック領域ポジション';
$string['dashblockspositiondesc'] = 'ダッシュボードページのカスタムブロック領域が有効にされた場合、ポジションを選択してください。';
$string['dashboardblockregionsettings'] = 'ダッシュボードブロック領域ビルダ';
$string['defaultzoom'] = 'デフォルトズーム';
$string['defaultzoomdesc'] = '「ズームを有効にする」が無効にされた場合、またはユーザがプリファレンスを選択しない場合のデフォルト画面サイズです。フルスクリーンまたは固定幅を選択してください。';
$string['disablecustommenu'] = 'Moodleカスタムメニューを無効にする';
$string['disablecustommenudesc'] = 'ナビゲーションバーのMoodleカスタムメニューを無効にします (あなたがインストールした他のテーマには描画されます)。';
$string['disabled'] = '無効';
$string['disablemenuscoursepages'] = 'コースページのメニューを無効にする';
$string['disablemenuscoursepagesdesc'] = 'このオプションを有効にした場合、トップメニューはサイトページ、ホームページおよびダッシュボード (マイホーム) 等に表示が制限されます。すべてのコースページには表示されません。';
$string['discardbuttontext'] = 'キャンセル';
$string['displayeditingbuttontext'] = '編集ボタンテキスト';
$string['displayeditingbuttontextdesc'] = 'テキストの編集ボタンを表示または非表示にします。注意: コース編集ボタンのみに適用されます。';
$string['displaygrades'] = '評定を表示する';
$string['displaygradesdesc'] = 'メニューに評定アイテムを表示します。';
$string['displaylogin'] = 'ログインを表示する';
$string['displayloginbox'] = 'ログインボックス';
$string['displayloginbutton'] = 'ボタン';
$string['displaylogindesc'] = 'ヘッダにどのようにログインボックスを表示するか選択してください。';
$string['displayloginno'] = 'ログインボックスなし';
$string['displayparticipants'] = '参加者を表示する';
$string['displayparticipantsdesc'] = 'メニューに参加者アイテムを表示します。';
$string['dividingline'] = 'ヘッダの区切り線';
$string['dividingline2'] = 'フッタの区切り線';
$string['dividingline2desc'] = 'フッタの区切り線の色です。';
$string['dividinglinedesc'] = 'ヘッダの区切り線の色です。';
$string['editfont'] = 'このページの編集およびカスタマイズボタンフォント色';
$string['editfontdesc'] = 'このページの編集およびカスタマイズボタンのフォント色を設定します。';
$string['edithorizontalpadding'] = '編集ボタンの水平方向のパディングを設定する';
$string['editoffbk'] = 'このページの編集およびカスタマイズOFFボタン背景色';
$string['editoffbkdesc'] = 'このページの編集およびカスタマイズボタンのOFF状態での背景色を設定します。';
$string['editonbk'] = 'このページの編集およびカスタマイズボタン背景色';
$string['editonbkdesc'] = 'このページの編集およびカスタマイズボタンの背景色を設定します。';
$string['editsettingsbutton'] = '設定およびボタン表示を編集する';
$string['editsettingsbuttondesc'] = 'ここでは設定編集時にナビゲーションバーに何を表示するか設定します。これらのオプションはダッシュボードページ等、関連していない設定には適用されない点に留意してください。';
$string['editsettingsbuttonshowbutton'] = '編集ボタンのみ表示します。例) コースページの「編集モードの開始」ボタン';
$string['editsettingsbuttonshowcog'] = '編集設定アイコン (歯車アイコン) のみ表示します。';
$string['editsettingsbuttonshowcogandbutton'] = '編集設定アイコンおよび歯車を表示します。ナビゲーションに多くのスペースを必要とすることに留意してください。';
$string['emoticonsize'] = 'エモーティコンサイズ';
$string['emoticonsizedesc'] = 'Moodleエモーティコンの高さおよび幅を設定します。';
$string['enableaccesstool'] = 'アクセシビリティツール';
$string['enableaccesstooldesc'] = 'ユーザの「アクセシビリティツール」プリファレンスページへのリンクを表示する - 注意: これには<a href="https://github.com/sharpchi/moodle-local_accessibilitytool" target="blank">アクセシビリティツールプラグイン</a>が必要です。';
$string['enablealert'] = '警告ボックス {$a} を有効にする';
$string['enablealertdesc'] = '警告ボックス {$a} を有効にします。';
$string['enablealerts'] = '警告を有効/無効にする';
$string['enablealertsdesc'] = 'コースではなく、サイト警告を有効/無効にします。「alerthiddencourse」をご覧ください。';
$string['enablealertstriptags'] = '警告から自動的にHTMLタグを削除する';
$string['enablealertstriptagsdesc'] = 'この設定を有効にした場合、警告メッセージが自動的にクリーンアップされます。無効にした場合、あなたはメッセージ内にHTML/リンクを使用できますが、HTMLビューで手動でクリーンアップする必要があります。';
$string['enableanalytics'] = 'Googleアナリティクスを有効にする';
$string['enableanalyticsdesc'] = 'あなたのMoodleサイトでGoogleアナリティクス設定を有効にします。';
$string['enableavailablecourses'] = '「利用可能なコース」を表示する';
$string['enableavailablecoursesdesc'] = 'フロントページに「利用可能なコース」テキストを表示します。';
$string['enablebadges'] = 'バッジ';
$string['enablebadgesdesc'] = 'ユーザバッジへのリンクを表示します。';
$string['enableblog'] = 'マイブログを有効にする';
$string['enableblogdesc'] = 'ユーザブログページへのリンクを表示します。';
$string['enablecalendar'] = 'ユーザカレンダ';
$string['enablecalendardesc'] = 'ユーザカレンダへのリンクを表示します。';
$string['enablecompetencieslink'] = 'コンピテンシーリンク';
$string['enablecompetencieslinkdesc'] = '「このコース」メニューにコンピテンシーリンクを表示します。注意: 「core_competency|enabled」を有効にする必要があります。';
$string['enablecoursesectionsdesc'] = '「このコース」メニューにそれぞれ表示されているセクションへのリンクを含むサブメニューを表示します。';
$string['enabledtabbedprofileeditprofilelink'] = 'プロファイルを編集するリンクを有効にする';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'タブ付きプロファイル編集リンクを有効にします。注意: この設定を有効にした場合、ユーザにプロファイル編集のパーミッションがある場合のみ表示されます。';
$string['enabledtabbedprofileuserpreferenceslink'] = 'プリファレンスリンクを有効にする';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'タブ付きプロファイルユーザプリファレンスリンクを有効にします。';
$string['enableeditprofile'] = 'プロファイルを編集する';
$string['enableeditprofiledesc'] = 'ユーザプロファイルを編集するためのリンクを表示します。';
$string['enableeventsdesc'] = 'カレンダーへのリンクを表示します。';
$string['enablefeed'] = 'マイフィードバック';
$string['enablefeeddesc'] = 'ユーザの「マイフィードバック」ページへのリンクを表示する - 注意: これには<a href="https://moodle.org/plugins/report_myfeedback" target="blank">マイフィードバックプラグイン</a>が必要です。';
$string['enablegrades'] = '評定';
$string['enablegradesdesc'] = 'ユーザ評定へのリンクを表示します。';
$string['enableheading'] = 'ヘッダコースタイトル';
$string['enableheadingdesc'] = 'デフォルトMoodleサイトタイトルが有効な場合、ヘッダにコースタイトルを表示するモードを設定します。';
$string['enablehelp'] = 'ヘルプリンク「 {$a->number} 」';
$string['enablehelpdesc'] = 'ナビゲーションバーにヘルプリンク「 {$a->number} 」を追加します。';
$string['enablehomedesc'] = 'フロントページへのリンクを表示します。';
$string['enablehomeredirect'] = 'ホーム「redirect=0」を有効にする';
$string['enablehomeredirectdesc'] = 'ホームの「redirect=0」を有効にします。マイホームがデフォルトページの場合に使用してください。これによりユーザがホームリンクをクリックしても「マイホーム/ダッシュボード」へリダイレクトされないようにします。';
$string['enablemenus'] = 'メニューを有効にする';
$string['enablemenusdesc'] = 'パフォーマンスの理由でメニューが使用されていない場合、この設定を無効にすることをお勧めします。';
$string['enablemy'] = 'ダッシュボード';
$string['enablemydesc'] = 'ダッシュボードページへのリンクを表示します。';
$string['enablemysitesdesc'] = 'ユーザコースのドロップダウンを表示します。';
$string['enablemysitesrestriction'] = 'ユーザのコースドロップダウンをカスタムプロファイルフィールドに制限する';
$string['enablemysitesrestrictiondesc'] = 'ユーザのコースドロップダウンをカスタムプロファイルフィールドに制限します。例) usertype=staff';
$string['enablenavbarwhenloggedout'] = 'ログアウト時のナビゲーションバーを有効にする';
$string['enablenavbarwhenloggedoutdesc'] = 'ログアウト時にナビゲーションバーを表示します。ヘルプおよびツールメニューのみに制限されます。';
$string['enablenote'] = 'マイ通知';
$string['enablenotedesc'] = 'ユーザ通知ページへのリンクを表示します。';
$string['enableposts'] = 'マイ投稿';
$string['enablepostsdesc'] = 'マイ投稿ページへのリンクを表示します。';
$string['enablepref'] = 'マイプリファレンス';
$string['enableprefdesc'] = 'ユーザプリファレンスページへのリンクを表示します。';
$string['enableprivatefiles'] = 'プライベートファイル';
$string['enableprivatefilesdesc'] = 'ユーザプライベートファイルへのリンクを表示します。';
$string['enableprofile'] = 'ユーザプロファイル';
$string['enableprofiledesc'] = 'ユーザプロファイルへのリンクを表示します。';
$string['enablesavecanceloverlay'] = '設定ページの保存/キャンセルオーバーレイを有効にする';
$string['enablesavecanceloverlaydesc'] = '簡単に設定を保存できるよう設定ページの最上部に保存/キャンセルボタンをオーバーレイ表示します。';
$string['enableshowhideblocks'] = 'ブロックを表示非表示にするを有効にする';
$string['enableshowhideblocksdesc'] = 'ユーザがすべてのブロックを表示/非表示できるようにします。';
$string['enableshowhideblockstext'] = 'ブロックを表示非表示にするにテキストを表示する';
$string['enableshowhideblockstextdesc'] = 'ボタンの隣にテキストを表示します。';
$string['enabletabbedprofile'] = 'タブ付きプロファイルを有効にする';
$string['enabletabbedprofiledesc'] = 'タブ付きプロファイル機能を有効にします。';
$string['enablethiscoursedesc'] = '現在のコースからの活動ドロップダウンを表示します。';
$string['enableticker'] = 'ホームページのニュースティッカを有効にする';
$string['enabletickerc'] = '内部ページのニュースティッカを有効にする';
$string['enabletickercdesc'] = '内部ページのニュースティッカを有効にするにはチェックしてください。';
$string['enabletickerdesc'] = 'ホームページのニュースティッカを有効にするにはチェックしてください。';
$string['enabletickermy'] = 'マイホーム/ダッシュボードページのニュースティッカを有効にする';
$string['enabletickermydesc'] = 'マイホーム/ダッシュボードのニュースティッカを有効にするにはチェックしてください。';
$string['enabletoolsmenus'] = 'ツールメニューを有効にする';
$string['enabletoolsmenusdesc'] = 'パフォーマンスの理由でメニューが使用されていない場合、この設定を無効にすることをお勧めします。';
$string['enablezoom'] = 'ズームを有効にする';
$string['enablezoomdesc'] = 'ユーザがフルスクリーンおよび固定幅を切り替えれるようにします。';
$string['enablezoomshowtext'] = '「ズームを有効にする」にテキストを表示する';
$string['enablezoomshowtextdesc'] = 'ボタンの横にテキストを表示します。';
$string['events'] = 'イベント';
$string['expandable'] = '拡張可';
$string['favicon'] = 'ファビコン';
$string['favicondesc'] = 'あなたのサイトで使用するファビコンをアップロードします。';
$string['fontblockheadercolor'] = 'ブロックヘッダフォント色';
$string['fontblockheadercolordesc'] = 'Moodleブロックのヘッダフォント色を設定します。16進コードを使用してください。この設定はアイコン色にも適用されることに留意してください。';
$string['fontblockheadersize'] = 'ブロックヘッダフォントサイズ';
$string['fontblockheadersizedesc'] = 'Moodleブロックヘッダで使用するフォントのサイズを設定します。リストから値を選択してください。';
$string['fontblockheaderweight'] = 'ブロックヘッダフォントの太さ';
$string['fontblockheaderweightdesc'] = 'Moodleブロックヘッダに使用されるフォントの太さを設定します。選択されたフォントに応じて100から900の間で値を選択してください。';
$string['fontcolor'] = 'メインフォント色';
$string['fontcolordesc'] = 'テーマのフォント色を設定します。16進コードを使用してください。';
$string['fontdesc'] = 'あなたがテーマ全体で使用したい<a href="https://www.google.com/fonts" target="_blank">Googleフォント</a>を選択できます。必要に応じてサブセットを選択してください (常にlatinが含まれます)。正しいフォントの太さを入力しない限り、フォントは表示されません。';
$string['fontheadercolor'] = 'ヘッダフォント色';
$string['fontheadercolordesc'] = 'テーマのヘッダフォント色を設定します。16進コードを使用してください。';
$string['fontheadername'] = 'ヘッダフォント';
$string['fontheadernamedesc'] = 'テキストおよびブロックヘッダで使用されるデフォルトフォント、「sans-serif」または<a href="https://www.google.com/fonts" target="_blank">Googleフォント</a>を選択してください。';
$string['fontheaderweight'] = 'ヘッダフォントの太さ';
$string['fontheaderweightdesc'] = 'サイトで使用されるヘッダフォントの太さです。選択されたフォントに応じて100から900の間で値を選択してください。';
$string['fontname'] = 'メインフォント';
$string['fontnamedesc'] = 'サイトで使用されるデフォルトフォント、「sans-serif」または<a href="https://www.google.com/fonts" target="_blank">Googleフォント</a>を選択してください。';
$string['fontsettings'] = 'フォント';
$string['fontsettingsheading'] = 'テーマ全体で使用するフォントを修正します。';
$string['fontsize'] = 'メインフォントサイズ';
$string['fontsizedesc'] = 'サイト全体で使用されるデフォルトフォントサイズ (パーセンテージ) を選択してください。';
$string['fontsubset'] = 'Googleフォントサブセット';
$string['fontsubsetdesc'] = 'すべてのフォントに適用されるラテン文字以外の文字サブセットを選択してください。ラテン文字のサブセットはすでにデフォルトで含まれています。';
$string['fonttitlecolor'] = 'サイト/コースタイトルフォント色';
$string['fonttitlecolorcourse'] = 'コースタイトルフォント色';
$string['fonttitlecolorcoursedesc'] = 'テーマのコースタイトルフォント色を設定します。16進コードを使用してください。';
$string['fonttitlecolordesc'] = 'テーマのサイトタイトルおよびコースタイトルのフォント色を設定します。16進コードを使用してください。';
$string['fonttitlename'] = 'サイト/コースタイトルフォント';
$string['fonttitlenamedesc'] = 'サイトおよびコースタイトルで使用されるデフォルトフォント、「sans-serif」または<a href="https://www.google.com/fonts" target="_blank">Googleフォント</a>を選択してください。';
$string['fonttitlesize'] = 'サイト/コースタイトルフォントサイズ';
$string['fonttitlesizedesc'] = 'サイトで使用されるサイトタイトルおよびコースタイトルのフォントサイズです。値をリストから選択してください。';
$string['fonttitleweight'] = 'サイト/コースタイトルフォントの太さ';
$string['fonttitleweightdesc'] = 'サイトタイトルおよびコースタイトルに使用されるフォントの太さを設定します。選択したフォントに応じて100から900の間で値を選択してください。';
$string['fontweight'] = 'メインフォントの太さ';
$string['fontweightdesc'] = 'サイトに使用されるフォントの太さを設定します。選択したフォントに応じて100から900の間で値を選択してください。';
$string['footerbkcolor'] = 'フッタ背景色';
$string['footerbkcolordesc'] = 'フッタ背景色を設定します。';
$string['footerblocksplacement'] = 'フッタブロック配置';
$string['footerblocksplacement1'] = 'サイト全体';
$string['footerblocksplacement2'] = 'ホームページのみ';
$string['footerblocksplacement3'] = 'なし';
$string['footerblocksplacementdesc'] = '上部フッタブロックを表示する場所を管理します。サイト全体がデフォルトです。';
$string['footercontent'] = 'フッタコンテンツセクション';
$string['footercontentdesc'] = 'フッタセクションにコンテンツを追加します。';
$string['footerdesc'] = 'フッタセクションにタイトルを追加します。';
$string['footerheader'] = 'フッタタイトルセクション';
$string['footerlayoutrow'] = 'フッタレイアウトビルダ';
$string['footerlayoutrowdesc'] = 'あなたのフッタブロック領域のレイアウトをデザインします。';
$string['footerlinkcolor'] = 'フッタブロックリンク色';
$string['footerlinkcolordesc'] = 'フッタブロックのリンク色です。';
$string['footersettings'] = 'フッタ';
$string['footersettingsheading'] = 'フッタに表示されるコンテンツを設定します。<a href="./../theme/adaptable/pix/layout.png" target="_blank">ここ</a>でレイアウトを確認してください。';
$string['footertextcolor'] = 'フッタテキスト色';
$string['footertextcolor2'] = 'フッタ下部テキスト色';
$string['footertextcolor2desc'] = 'フッタ下部のテキスト色です。';
$string['footertextcolordesc'] = 'フッタ内のテキストの色です。HTML16進コードを使用してください。';
$string['footnote'] = 'フットノート';
$string['footnotedesc'] = 'フッタにテキストを追加します。';
$string['forumbodybackgroundcolor'] = 'フォーラム投稿本文背景';
$string['forumbodybackgroundcolordesc'] = 'フォーラム投稿の背景色です。';
$string['forumheaderbackgroundcolor'] = 'フォーラム投稿ヘッダ背景';
$string['forumheaderbackgroundcolordesc'] = 'フォーラム投稿ヘッダの背景色です。';
$string['frnt-footer'] = 'この領域のブロックは管理ユーザにのみ表示されます。';
$string['frontpageblockregionsettings'] = 'ブロック領域ビルダ';
$string['frontpageblocksenabled'] = 'フロントページのカスタムブロック領域を有効にする';
$string['frontpageblocksenableddesc'] = 'あなたはフロントボードページのカスタムブロック領域を有効/無効にできます。そして、あなたが作成した領域にブロックをドラッグ&ドロップできます。';
$string['frontpageblocksettings'] = 'マーケティングブロック';
$string['frontpagecoursesettings'] = 'フッタコースリスト';
$string['frontpagedesc'] = 'フロントページでのコースボックス描画方法を設定します。';
$string['frontpagemarketenabled'] = 'マーケティングブロックを有効にする';
$string['frontpagemarketenableddesc'] = 'フロントページにマーケティングブロックを設定します。';
$string['frontpagemarketoption'] = 'マーケティングブロックのスタイルを選択する';
$string['frontpagemarketoptiondesc'] = 'あなたは異なるスタイルをマーケティングブロックに適用できます。注意: BCUスタイルはブロック上部のイメージを設置した場合に動作するようデザインされています。';
$string['frontpagenumbertiles'] = '1行あたりのコースタイル数';
$string['frontpagenumbertilesdesc'] = 'フロントページコース一覧に表示される1行あたりのコースタイル数です。';
$string['frontpagerenderer'] = 'フロントコースボックス';
$string['frontpagerendererdefaultimage'] = 'デフォルトコースイメージ';
$string['frontpagerendererdefaultimagedesc'] = 'コースイメージがない場合に使用するデフォルトイメージです (タイル w/オーバーレイのみに適用されます)。';
$string['frontpagerendererdesc'] = 'コースボックスのフロントページでの描画方法を管理します。';
$string['frontpagerendereroption1'] = 'タイル';
$string['frontpagerendereroption2'] = 'タイル w/ オーバーレイ';
$string['frontpagerendereroption3'] = 'Moodleデフォルト';
$string['frontpagerendereroption4'] = 'コンベントリタイル';
$string['frontpagesettingsheading'] = 'フロントページ描画';
$string['frontpageslidersettings'] = 'フロントページスライダ';
$string['frontpagetiles1'] = '1タイル';
$string['frontpagetiles2'] = '2タイル';
$string['frontpagetiles3'] = '3タイル';
$string['frontpagetiles4'] = '4タイル';
$string['frontpagetiles6'] = '6タイル';
$string['fullscreen'] = 'フルスクリーン';
$string['fullscreenwidth'] = 'フルスクリーン幅';
$string['fullscreenwidthdesc'] = 'フルスクリーンモード/ズーム時のテーマの最大幅を設定します。';
$string['future'] = '未来';
$string['gdprbutton'] = 'データ保持概要ボタン';
$string['gdprbuttondesc'] = 'フッタにデータ保持概要ボタンを表示します。';
$string['googleanalyticssettings'] = 'Googleアナリティクス';
$string['googleanalyticssettingsdesc'] = 'あなたはGoogleアナリティクスに複数のコードを設定してユーザプロファイルフィールドにターゲティングできます。';
$string['googleanalyticssettingsheading'] = 'あなたのサイトのGoogleアナリティクスを設定する';
$string['headerbgimage'] = '背景イメージ';
$string['headerbgimagedesc'] = 'ヘッダ背景画像を設定します。最小サイズは1600x180px (1900x180px推奨) です。画像はヘッダ全体をカバーします。あなたはヘッダ上部背景色に色を追加するか、「transparent」にして背景画像を表示できます。この場合、イメージ上で正しく表示させるためテキスト色を修正してください。';
$string['headerbkcolor'] = 'ヘッダ上部背景色';
$string['headerbkcolor2'] = 'ヘッダ下部背景色';
$string['headerbkcolor2desc'] = 'ヘッダ下部の背景色を設定します。これによりヘッダスタイル2の背景色も設定されることに留意してください。';
$string['headerbkcolordesc'] = 'ヘッダ上部背景色を設定します。';
$string['headerdesc'] = 'あなたのファビコン、ロゴをアップロードおよびヘッダのログインフォームに設定してヘッダタイトルを調整します。あなたは<a href="./../admin/settings.php?section=theme_adaptable_font">フォント</a>設定ページでフォントサイズおよびタイトルを設定できます。';
$string['headernavbarhelpheading'] = 'ヘルプリンクおよびオプション';
$string['headernavbarhelpheadingdesc'] = 'ヘルプメニューリンクのオプションです。';
$string['headernavbarmycoursesheading'] = 'マイコースメニュー';
$string['headernavbarmycoursesheadingdesc'] = '現在のユーザのコース一覧を表示するマイコース (マイサイト) メニューオプションのすべてのオプションです。';
$string['headernavbarthiscourseheading'] = 'このコースメニュー';
$string['headernavbarthiscourseheadingdesc'] = 'このメニューで学生はすべてのコース活動、参加者一覧および自分の評定に直接アクセスできます。';
$string['headersettings'] = 'ヘッダ';
$string['headersettingsheading'] = 'このテーマのヘッダをカスタマイズします。レイアウトの詳細は<a href="./../theme/adaptable/pix/layout.png" target="_blank">ここ</a>をご覧ください。';
$string['headerstyle'] = 'ヘッダスタイル';
$string['headerstyle1'] = 'ヘッダ1 (オリジナル3行ヘッダ)';
$string['headerstyle2'] = 'ヘッダ2 (2行ヘッダ)';
$string['headerstyledesc'] = 'ヘッダスタイルを選択してください。ヘッダ1はオリジナルの3行Adaptableヘッダを参照します。ヘッダ2は最小限の2行ヘッダです。ヘッダ2を使用して「検索ボックスまたは特別アイコンを使用する」を設定する場合、これは常に検索ボックスを使用することに留意してください。';
$string['headerstyleheading'] = 'ヘッダスタイル設定';
$string['headerstyleheadingdesc'] = 'Adaptableは2つのヘッダスタイル、オリジナルの3行ヘッダおよび新しいシンプルな2行のヘッダをサポートします。あなたが新しい2行のヘッダに切り替える場合、次ができないことに留意してください::<br /> <ol><li>ヘッダに特別アイコンを表示する</li><li>モバイルデバイスにサイトロゴを表示する</li></ol>';
$string['headertextcolor'] = '上部ヘッダブロックテキストおよびリンク色';
$string['headertextcolor2'] = '下部ヘッダブロックテキストおよびリンク色';
$string['headertextcolor2desc'] = '下部ヘッダブロックテキストおよびリンク色を設定します。';
$string['headertextcolordesc'] = '上部ヘッダブロックテキストおよびリンク色を設定します。';
$string['help'] = 'ヘルプ';
$string['helplinkscount'] = 'ヘルプリンク数';
$string['helplinkscountdesc'] = 'あなたがメインナビゲーションバーに追加したいヘルプリンク数を設定します。';
$string['helplinktitle'] = 'ヘルプリンク「 {$a->number} 」タイトル';
$string['helplinktitledesc'] = 'ナビゲーションバーのヘルプリンク「 {$a->number} 」のタイトルです。空白の場合、デフォルトは「ヘルプ {$a->number}」となります。';
$string['helpprofilefield'] = 'ヘルプリンク「 {$a->number} 」カスタムプロファイルフィールド (任意)';
$string['helpprofilefielddesc'] = 'カスタムプロファイルフィールドを使用してヘルプリンク「 {$a->number} 」アクセスルールを追加します。例) usertype=student';
$string['helptarget'] = 'ヘルプターゲット';
$string['helptargetdesc'] = 'ヘルプリンクを新しいウィンドウで開きますか?';
$string['helptitle'] = 'ヘルプ {$a->number}';
$string['hiddencourses'] = '非表示コース';
$string['hiddenfromview'] = '非表示にする';
$string['hide'] = '非表示';
$string['hidefootersocial'] = 'ソーシャルアイコンを表示する';
$string['hidefootersocialdesc'] = 'ブロックフッタの下にソーシャルアイコンを表示します。';
$string['hideinforum'] = 'フォーラムのヘルプおよびツールを非表示にする';
$string['hideinforumdesc'] = '固定幅およびすべてのメニューオプションを使用する場合、フォーラム検索ボックスは下の行に表示されます。このオプションを有効にした場合、適切に表示するためフォーラムのツールおよびヘルプメニューアイテムは非表示にされます。';
$string['home'] = 'ホーム';
$string['homebk'] = 'フロントページ背景イメージ';
$string['homebkdesc'] = 'ホームページの背景イメージとなるイメージをアップロードします。';
$string['infobox'] = 'フロントページ情報ボックス';
$string['infobox2'] = 'フロントページ第2情報ボックス';
$string['infobox2desc'] = 'フロントページ第2情報ボックスです (追加情報およびヒントは<a href="./../theme/adaptable/README.txt" target="_blank">README</a>ファイルをご覧ください)。<br /><br /><strong>注意: </strong>このエレメントはBCUとの互換性のためにのみ使用されます。また、今後のバージョンでは削除される予定です。';
$string['infoboxdesc'] = 'フロントページ情報ブロックHTMLです (追加情報およびヒントは<a href="./../theme/adaptable/README.txt" target="_blank">README</a>ファイルをご覧ください)。<br /><br /><strong>注意: </strong>このエレメントはBCUとの互換性のためにのみ使用されます。また、今後のバージョンでは削除される予定です。';
$string['infoboxfullscreen'] = '受信ボックスをフルスクリーンにする';
$string['infoboxfullscreendesc'] = 'この設定を有効にした場合、受信ボックスがフルスクリーンになります。';
$string['infoiconcolor'] = 'ヘルプアイコン色';
$string['infoiconcolordesc'] = 'ツールチップで使用する情報/ヘルプアイコンの色を設定します。';
$string['inprogress'] = '進行中';
$string['introboxbackgroundcolor'] = 'イントロボックス背景色';
$string['introboxbackgroundcolordesc'] = 'フォーラムおよびその他の活動で使用されるイントロボックスの背景色です (活動説明を強調表示します)。';
$string['jssection'] = 'JavaScriptセクション';
$string['jssectiondesc'] = 'サイトにJavaScriptコードを追加します。';
$string['jssectionrestricted'] = '条件付きJavaScriptセクション';
$string['jssectionrestricteddashboardonly'] = 'ダッシュボードページにのみJavaScriptを含む';
$string['jssectionrestricteddashboardonlydesc'] = 'ダッシュボードページにのみJavaScriptを表示します。そうでない場合、サイト全体に表示されます。';
$string['jssectionrestricteddesc'] = 'カスタムプロファイルフィールドに基づきサイトに条件付きでJavaScriptのコードを追加します。このJavaScriptはこの条件に合致した場合のみ表示されます。';
$string['jssectionrestrictedprofilefield'] = 'JavaScriptセクションカスタムプロファイルフィールド';
$string['jssectionrestrictedprofilefielddesc'] = 'ユーザがこのカスタムプロファイルフィールド値に合致する場合のみ、上にJavaScriptを表示します。例) faculty=fbl';
$string['jumpto'] = 'ジャンプする ...';
$string['landscape'] = 'ランドスケープ';
$string['layoutaddcontent'] = 'あなたのレイアウトで大丈夫ですか? あなたのブロックにコンテンツを追加してください:';
$string['layoutaddcontentdesc1'] = 'あなたは';
$string['layoutaddcontentdesc2'] = 'マーケティングブロックを設定しました。このレイアウトで大丈夫な場合、以下のブロックにコンテンツを追加してください。レイアウトに満足できない場合、上のレイアウトビルだで変更してください。br />';
$string['layoutcheck'] = 'あなたのレイアウトをチェックする';
$string['layoutcheckdesc'] = 'あなたが使用しているブロック数および新しいレイアウトを確認するには以下のツールを使用してください。';
$string['layoutcount1'] = 'あなたは最大ブロック領域を設定できます。';
$string['layoutcount2'] = 'あなたは現在次を使用しています:';
$string['layoutdesc'] = 'ユーザに表示されるデフォルトレイアウトを設定します。';
$string['layoutsettings'] = 'レイアウト';
$string['layoutsettingsheading'] = 'サイトレイアウトを管理する';
$string['leftblocks'] = '左側';
$string['linkcolor'] = 'リンク色';
$string['linkcolordesc'] = 'テーマのリンク色を設定します。HTML16進コードを使用してください。';
$string['linkhover'] = 'リンクホバー色';
$string['linkhoverdesc'] = 'テーマのリンク色 (ホバー時) を設定します。HTML16進コードを使用してください。';
$string['linksmenu'] = 'リンクメニュー';
$string['loadingcolor'] = 'ローディング色';
$string['loadingcolordesc'] = 'ページトップのローディングバーの色です。';
$string['loginbgimage'] = '背景イメージ';
$string['loginbgimagedesc'] = 'フルサイズページに背景イメージを追加します。';
$string['loginbgopacity'] = '背景イメージがある場合のログインページ、ヘッダ、ナビゲーションバー、ログインボックスおよびフッタ背景の不透明度';
$string['loginbgopacitydesc'] = '背景イメージがある場合のヘッダ、ナビゲーションバー、ログインボックスおよびフッタの不透明度です。';
$string['loginbgstyle'] = 'ログイン背景スタイル';
$string['loginbgstyledesc'] = 'アップロードされたイメージのスタイルを選択してください。';
$string['logindesc'] = 'ログインボックスの上部および下部にイメージ背景およびテキストを追加してログインページをカスタマイズします。';
$string['loginfooter'] = 'ログインページフッタ';
$string['loginfooterdesc'] = 'ログインページフッタを表示します。';
$string['loginheader'] = 'ログインページヘッダ';
$string['loginheaderdesc'] = 'ログインページヘッダを表示します。';
$string['loginplaceholder'] = 'ユーザ名';
$string['loginsettings'] = 'ログインページ';
$string['loginsettingsheading'] = 'ログインページをカスタマイズする';
$string['logintextboxbottom'] = '下部テキストボックス';
$string['logintextboxbottomdesc'] = 'ログインボックスの下にカスタムテキストを追加します。';
$string['logintextboxtop'] = 'トップテキストボックス';
$string['logintextboxtopdesc'] = 'ログインボックスの上にカスタムテキストを追加します。';
$string['logintextbutton'] = 'ログイン';
$string['logo'] = 'ロゴ';
$string['logodesc'] = 'あなたのサイトで使用するロゴをアップロードしてください。推奨サイズは200px x 80pxです。';
$string['maincolor'] = 'メイン色';
$string['maincolordesc'] = 'ブロックおよびフッタのメイン色です。';
$string['maincoursepage'] = 'メインコースページ';
$string['market'] = 'マーケティングブロック';
$string['marketblockbordercolor'] = 'マーケティングブロック枠線色';
$string['marketblockbordercolordesc'] = 'マーケティングブロックの枠線色を設定します。';
$string['marketblocksbackgroundcolor'] = 'マーケティングブロック領域背景色';
$string['marketblocksbackgroundcolordesc'] = 'マーケティングブロック領域の背景色を設定します。';
$string['marketdesc'] = 'マーケティングブロックにHTMLを追加します (追加情報およびヒントは<a href="./../theme/adaptable/README.txt" target="_blank">README</a>ファイルをご覧ください)。';
$string['marketingbuilderdesc'] = 'あなたのマーケティングブロックを設定するには以下のツールを使用してください。ブロック設定後、さらにページ下部に設定が表示されます。';
$string['marketingbuilderheading'] = 'マーケティングブロックレイアウトビルダ';
$string['marketingdesc'] = 'あなたが使用できる2つのフル幅の情報ボックスがあります。これに加えてあなたが必要なブロック数を定義および独自のレイアウトを追加できるレイアウトビルダがあります。詳細はこのテーマに同梱される<a href="./../theme/adaptable/README.txt" target="_blank">README</a>をご覧ください。';
$string['marketingsettings'] = 'マーケティングブロック';
$string['marketingsettingsheading'] = 'フロントページに表示されるマーケティングブロックをカスタマイズします。<a href="./../theme/adaptable/pix/layout.png" target="_blank">ここ</a>でレイアウトを確認してください。';
$string['marketlayoutrow'] = 'マーケティングブロック行';
$string['marketlayoutrowdesc'] = 'フロントページのマーケティングブロック行を追加またはレイアウトを設定します。';
$string['menubkcolor'] = 'メインメニュー背景色';
$string['menubkcolordesc'] = 'メインメニュー背景色を設定します。';
$string['menubordercolor'] = 'メインメニュー下部枠線色';
$string['menubordercolordesc'] = 'メインメニュー下部枠線色を設定します。';
$string['menufontcolor'] = 'メインメニューフォント色';
$string['menufontcolordesc'] = 'メインメニューフォント色を設定します。';
$string['menufontpadding'] = 'ナビゲーションアイテムのパディング';
$string['menufontpaddingdesc'] = 'メインナビゲーションバーのアイテムのパディングを設定します。';
$string['menufontsize'] = 'ナビゲーションバーのフォントサイズ';
$string['menufontsizedesc'] = 'メインナビゲーションバーで使用されるフォントのサイズを設定します。';
$string['menuoverrideprofilefield'] = 'カスタムプロファイルフィールド名';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';
$string['menuoverrideprofilefielddesc'] = 'ユーザオーバーライドに使用されるカスタムプロファイル「リスト」フィールド名です。';
$string['menusdesc'] = '&nbsp;';
$string['menusession'] = 'セッションにアクセス詳細を保持する';
$string['menusessiondesc'] = 'パフォーマンスのため、この設定を有効にすることをお勧めします。あなたはテスト時に無効にできます。';
$string['menusessionttl'] = 'アクセスルールをセッションに保持する時間 (分)';
$string['menusessionttldesc'] = 'ユーザセッション内で何分毎にメニューアクセスルールがリフレッシュされるか設定します。';
$string['menusettings'] = 'ヘッダメニュー';
$string['menusettingsheading'] = 'このテーマのヘッダ上部のメニューをカスタマイズします。';
$string['menusheading'] = 'ヘッダ上部のリンクメニューのナビゲーションを設定する';
$string['menusheadingvisibility'] = 'トップメニュー可視性一般設定';
$string['menusheadingvisibilitydesc'] = 'あなたは次の設定でメニューを表示するかコントロールできます。また、任意でユーザが設定をカスタマイズできるようにします。';
$string['menuslinkicon'] = 'リンクメニューアイコン';
$string['menuslinkicondesc'] = 'カスタムFont Awesomeアイコンを選択してください。';
$string['menuslinkright'] = '上部右側にメニューを表示する';
$string['menuslinkrightdesc'] = 'この設定を有効にした場合、メニューへのリンクをメッセージメニュー隣の上部右側に表示します。';
$string['menustitledesc'] = 'カスタムプロファイルフィールド (任意) に基づきトップメニュー (ナビゲーションバー内) およびトップメニュー (ヘッダ上部) を制限できます。制限を追加するにはプロファイルフィールド名および期待値を入力してください。メニュー構造は一般的なMoodleフォーマットに従います: <pre> Moodle community|https://moodle.org -Moodle free support|https://moodle.org/support -Moodle development|https://moodle.org/development --Moodle Docs|http://docs.moodle.org|Moodle Docs --German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de Moodle.com|http://moodle.com/ </pre>
theme_adaptable/menustitledesc';
$string['menuuseroverride'] = 'ユーザオーバーライドを許可する';
$string['menuuseroverridedesc'] = 'これらの設定はユーザがカスタムプロファイルフィールドでメニュー表示の場所をコントロールするため使用できます。このオプションを使用するには「リスト」形式で対応する順序を値に持つカスタムプロファイルフィールドを作成する必要があります: <pre>1. サイト全体 (リストの最初の項目はサイト全体メニューを表示するためのものです) 2. ホームページのみ (リストの2番目の項目はサイト/ホームページのみ表示するよう設定します) 3. 非表示 (リストの3番目の項目はメニューを完全に非表示にします)</pre> あなたは「コースページのメニューを無効にする」をプロファイルフィールド設定と併用すべきではありません。代わりにあなたのプロファイルフィールドリスト設定時に「ホームページのみ」エントリにデフォルト値を設定してください。注意: この変更を適用するため、ユーザはMoodleをログアウトして再度ログインする必要があります。このことを説明するメモをカスタムプロファイルフィールドに追加しても良いでしょう。';
$string['messagepopupbackground'] = 'メッセージポップアップ背景色';
$string['messagepopupbackgrounddesc'] = 'メッセージポップアップヘッダの背景色を設定します。';
$string['messagepopupcolor'] = 'メッセージポップアップテキスト色';
$string['messagepopupcolordesc'] = 'メッセージポップアップヘッダのテキスト色を設定します。';
$string['messagingbackgroundcolor'] = 'メッセージメインウィンドウ背景色';
$string['messagingbackgroundcolordesc'] = 'メッセージメインチャットウィンドウの背景色を設定します。';
$string['mobilemenubkcolor'] = 'モバイルメニュー背景色';
$string['mobilemenubkcolordesc'] = 'モバイルデバイスのメインメニュー背景色を設定します (折りたたみ)。';
$string['moodledocs'] = 'Moodle Docsリンク';
$string['moodledocsdesc'] = 'フッタにMoodle Docsリンクを表示します。';
$string['more'] = 'さらに';
$string['msgbadgecolor'] = 'メッセージバッジ背景色';
$string['msgbadgecolordesc'] = 'ヘッダのメッセージバッジ/バブルの背景色を設定します (未読メッセージ数を表示します)。';
$string['myblogs'] = 'マイブログ';
$string['mycoursesmenulimit'] = 'マイコースメニュー制限';
$string['mycoursesmenulimitdesc'] = 'マイコースドロップダウンに表示される最大コース数を調整します。ゼロはすべてのコースを表示します。';
$string['mysites'] = 'マイコース';
$string['mysitesdisabled'] = '無効';
$string['mysitesexclude'] = '非表示コースを除外する';
$string['mysitesinclude'] = '非表示コースを含む';
$string['mysitesmaxlength'] = 'マイコース最大幅';
$string['mysitesmaxlengthdesc'] = 'あなたのフォントを最適化するため、マイコースドロップダウンのコース名最大幅を調整します。';
$string['mysitesmenudisplay'] = 'マイコースメニュー表示';
$string['mysitesmenudisplaydesc'] = 'メニューアイテムおよびホバー時に表示するテキストを選択してください。';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'ホバー時にフルコースタイトルおよびフルテキストを表示します。';
$string['mysitesmenudisplayfullnamenohover'] = 'ホバー時にフルコースタイトル (テキストなし) を表示します。';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'ホバー時に省略コードおよびフルコース名を表示します。';
$string['mysitesmenudisplayshortcodenohover'] = 'ホバー時に省略コード (テキストなし) を表示します。';
$string['mysitessortoverride'] = 'マイコースカスタム並べ替えを有効にする';
$string['mysitessortoverridedesc'] = 'サブメニューで過去のコースを折りたたむためにカスタムプロファイルフィールドまたは一般的な文字列 (年等) を使用します。';
$string['mysitessortoverridefield'] = 'マイコースカスタムプロファイルフィールドまたはストリング';
$string['mysitessortoverridefielddesc'] = 'コースの省略コードでチェックするためのプロファイルフィールドまたはストリングのカンマ区切りリストです。';
$string['mysitessortoverridelast'] = '最終アクセス日時、存在しない場合は登録開始日時';
$string['mysitessortoverridemyoverview'] = 'マイオーバービューのリストを使用する';
$string['mysitessortoverrideoff'] = '単一のフラットリストにすべての登録済みコースを表示する';
$string['mysitessortoverrideprofilefields'] = 'プロファイルフィールドで見つかったコースを最初に表示、その他はサブメニューに表示する';
$string['mysitessortoverrideprofilefieldscohort'] = 'プロファイルフィールドで見つかったコースおよびコーホートを最初に表示、その他はサブメニューに表示する';
$string['mysitessortoverridestrings'] = 'ストリングを含む登録済みコースを最初に表示、その他はその他はサブメニューに表示する';
$string['navbarcachetime'] = 'ナビゲーションバーキャッシュ時間';
$string['navbarcachetimedesc'] = 'ナビゲーションバーがキャッシュされる時間 (分) です。';
$string['navbardesc'] = 'あなたがナビゲーションバーに表示されるすべてのエレメント管理をできるようにします。';
$string['navbardisplayicons'] = 'アイコンを表示する';
$string['navbardisplayiconsdesc'] = 'メインメニューヘッディングの隣にアイコンを表示します。';
$string['navbardisplaysubmenuarrow'] = 'サブメニュー矢印を表示する';
$string['navbardisplaysubmenuarrowdesc'] = 'メニューヘッディングにサブメニューオプションがある場合、サブメニュー矢印 (下向き) を表示します。';
$string['navbardropdownborderradius'] = 'ドロップダウンメニュー枠線レディアス';
$string['navbardropdownborderradiusdesc'] = 'ドロップダウンメニューの枠線レディアスをコントロールします (例: 角丸)。';
$string['navbardropdownhovercolor'] = 'ドロップダウンメニュー背景ホバー色';
$string['navbardropdownhovercolordesc'] = 'メニューアイテムの上にカーソルが置かれた場合のドロップダウンメニュー背景色です。';
$string['navbardropdowntextcolor'] = 'ドロップダウンメニューテキスト色';
$string['navbardropdowntextcolordesc'] = 'ドロップダウンメニューアイテムのテキスト色です。';
$string['navbardropdowntexthovercolor'] = 'ドロップダウンメニューテキストホバー色';
$string['navbardropdowntexthovercolordesc'] = 'メニューアイテムの上にカーソルが置かれた場合のドロップダウンメニューテキスト色です。';
$string['navbardropdowntransitiontime'] = 'ナビゲーションバー遷移時間';
$string['navbardropdowntransitiontimedesc'] = 'ナビゲーションバー遷移時間 (秒) です。サブメニューのあるメニューの上にカーソルが置かれた場合にフェイドインアニメーション効果を提供します。';
$string['navbarlinksettingsdesc'] = 'あなたがナビゲーションバーに表示されるリンクをコントロールできるようにします。';
$string['navbarlinksettingsheading'] = 'ナビゲーションバーのリンクをカスタマイズする';
$string['navbarlinkssettings'] = 'ナビゲーションバーリンク';
$string['navbarsettings'] = 'ナビゲーションバー設定';
$string['navbarsettingsheading'] = 'ナビゲーションバーをカスタマイズする';
$string['navbarstyles'] = 'ナビゲーションバースタイル';
$string['navbarstylesdesc'] = 'あなたがナビゲーションバーに表示されるエレメントのスタイルをコントロールできるようにします。';
$string['navbarstylesheading'] = 'ナビゲーションバースタイルをカスタマイズする';
$string['newmenu'] = 'トップメニュードロップダウン';
$string['newmenudesc'] = 'トップヘッダメニューの下に表示されるリンクをカスタマイズします。';
$string['newmenufield'] = 'カスタムプロファイルフィールド Name=Value (任意)';
$string['newmenufielddesc'] = 'カスタムプロファイルフィールドで使用するアクセスルールを追加します。例) usertype=student';
$string['newmenuheading'] = 'トップメニュー';
$string['newmenurequirelogin'] = 'ログイン必須';
$string['newmenurequirelogindesc'] = 'この設定を有効にした場合、このメニューはログインユーザにのみ表示されます。';
$string['newmenutitle'] = 'トップメニュータイトル';
$string['newmenutitledefault'] = 'メニュー';
$string['newmenutitledesc'] = 'あなたのサイトのヘッダに表示されるドロップダウンリストのタイトルです。';
$string['newstickercount'] = 'ニュースティッカセクション数';
$string['newstickercountdesc'] = '異なるオーディエンスをターゲットとするためにアクセスルールのある複数ニュースティッカセクションを設定します。';
$string['nextactivity'] = '次の活動';
$string['nextsection'] = '次のセクション';
$string['noenrolments'] = '登録は見つかりませんでした。';
$string['none'] = 'なし';
$string['normal'] = '固定幅';
$string['nostyle'] = 'スタイルなし';
$string['originaltemplatepreview'] = 'オリジナル/オーバーライドテーマファイルプレビュー';
$string['originaltemplatesource'] = 'オリジナル/オーバーライドテーマファイルソース';
$string['overriddentemplate'] = 'オーバーライドテンプレート: {$a}';
$string['overriddentemplatedesc'] = '設定した場合、ここのテキストがテンプレート「 {$a} 」として使用されます。プレビューを動作させるにはJSONフォーマットの標準例コンテクストが必要です。';
$string['overriddentemplatenopreview'] = 'JSON例がないため、プレビューはありません。';
$string['overriddentemplatepreview'] = 'オーバーライドプレビュー設定';
$string['overridetemplate'] = 'オーバーライドテンプレート: {$a}';
$string['pageheaderalternative'] = '代替';
$string['pageheaderheight'] = 'ページヘッダ高';
$string['pageheaderheightdesc'] = 'メインヘッダ領域 (ロゴおよびタイトルを含む) の高さを設定します。';
$string['pageheaderlayout'] = 'ページヘッダレイアウト';
$string['pageheaderlayoutdesc'] = 'ページヘッダーのレイアウトです。ヘッダースタイル1にのみ影響します。ヘッダースタイル2は変更されません。注意: まだ開発中のため、「代替」は予告なく変更される場合があります。';
$string['pageheaderoriginal'] = 'オリジナル';
$string['passwordplaceholder'] = 'パスワード';
$string['past'] = '過去';
$string['pastcourses'] = '過去のコース';
$string['people'] = '参加者';
$string['piwikenabled'] = '有効';
$string['piwikenableddesc'] = 'MoodleのMatomoトラッキングを有効にします。';
$string['piwikimagetrack'] = 'イメージトラッキング';
$string['piwikimagetrackdesc'] = 'JavaScriptを無効したブラウザでMoodleイメージトラッキングを有効にします。';
$string['piwiksettings'] = 'Matomo (前Piwik) アナリティクス';
$string['piwiksettingsdesc'] = '高度なトラッキングのためのクリーンURLを生成します。';
$string['piwiksettingsheading'] = 'Matomoをセットアップする';
$string['piwiksiteid'] = 'サイトID';
$string['piwiksiteiddesc'] = 'あなたのサイトIDを入力してください。';
$string['piwiksiteurl'] = 'Matomo URL';
$string['piwiksiteurldesc'] = 'あなたのMatomoアナリティクスURLをhttp(s)または末尾のスラッシュなしで入力してください。';
$string['piwiktrackadmin'] = '管理者トラッキング';
$string['piwiktrackadmindesc'] = '管理ユーザのトラッキングを有効にします (非推奨)。';
$string['pluginname'] = 'Adaptable';
$string['portrait'] = 'ポートレイト';
$string['previousactivity'] = '前の活動';
$string['previoussection'] = '次のセクション';
$string['printbodyfontsize'] = 'ボディフォントサイズ';
$string['printbodyfontsizedesc'] = 'ボディフォントサイズを設定します。';
$string['printlineheight'] = '行の高さ';
$string['printlineheightdesc'] = '行の高さを設定します。';
$string['printmargin'] = 'マージン';
$string['printmargindesc'] = 'マージンを設定します。';
$string['printpageorientation'] = 'ページの向き';
$string['printpageorientationdesc'] = 'ページの向きを「ポートレイト」または「ランドスケープ」に設定します。';
$string['printsettings'] = '印刷';
$string['printsettingsdesc'] = '印刷に関して設定します。';
$string['printsettingsheading'] = '印刷設定';
$string['properties'] = 'Adaptable設定をインポート/エクスポートする';
$string['propertiesdesc'] = 'このセクションではあなたは現在のAdaptableテーマ設定 (プロパティ) をJSONフォーマットでインポート/エクスポートできます。また、あなたはこのMoodleインストレーションの現在の設定すべてを表示できます。';
$string['propertiesexport'] = 'プロパティをJSONストリングとしてエクスポートする';
$string['propertiesproperty'] = '属性';
$string['propertiesreturn'] = '戻る';
$string['propertiessub'] = '現在のテーマ設定';
$string['propertiesvalue'] = '値';
$string['putpropertiesadded'] = '追加:';
$string['putpropertieschanged'] = '変更:';
$string['putpropertiesdesc'] = 'JSONストリングをを貼り付けて「変更を保存」してください。警告! 設定値を検証せずに「すべてのキャッシュを削除」します。';
$string['putpropertiesfrom'] = 'from';
$string['putpropertiesheading'] = 'テーマ設定をインポートする';
$string['putpropertiesignorecti'] = 'すべてのコースタイトルイメージ設定を無視します。';
$string['putpropertiesignored'] = '無視:';
$string['putpropertiesname'] = 'プロパティをインポートする';
$string['putpropertiesreportfiles'] = '以下のファイルを忘れずに設定にアップロードしてください:';
$string['putpropertiessettingsreport'] = '設定レポート:';
$string['putpropertiesunchanged'] = '変更なし:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = '私たちの';
$string['putpropertyproperties'] = '属性';
$string['putpropertyreport'] = 'レポート';
$string['putpropertyversion'] = 'バージョン:';
$string['region-course-bottom-a'] = 'コースページ下部領域5';
$string['region-course-bottom-b'] = 'コースページ下部領域6';
$string['region-course-bottom-c'] = 'コースページ下部領域7';
$string['region-course-bottom-d'] = 'コースページ下部領域8';
$string['region-course-section-a'] = 'コースページ活動終了下部領域';
$string['region-course-tab-one-a'] = 'コースページタブ領域1';
$string['region-course-tab-two-a'] = 'コースページタブ領域2';
$string['region-course-top-a'] = 'コースページ上部領域1';
$string['region-course-top-b'] = 'コースページ上部領域2';
$string['region-course-top-c'] = 'コースページ上部領域3';
$string['region-course-top-d'] = 'コースページ上部領域4';
$string['region-frnt-footer'] = 'フッタ';
$string['region-frnt-market-a'] = 'ページ領域1';
$string['region-frnt-market-b'] = 'ページ領域2';
$string['region-frnt-market-c'] = 'ページ領域3';
$string['region-frnt-market-d'] = 'ページ領域4';
$string['region-frnt-market-e'] = 'ページ領域5';
$string['region-frnt-market-f'] = 'ページ領域6';
$string['region-frnt-market-g'] = 'ページ領域7';
$string['region-frnt-market-h'] = 'ページ領域8';
$string['region-frnt-market-i'] = 'ページ領域9';
$string['region-frnt-market-j'] = 'ページ領域10';
$string['region-frnt-market-k'] = 'ページ領域11';
$string['region-frnt-market-l'] = 'ページ領域12';
$string['region-frnt-market-m'] = 'ページ領域13';
$string['region-frnt-market-n'] = 'ページ領域14';
$string['region-frnt-market-o'] = 'ページ領域15';
$string['region-frnt-market-p'] = 'ページ領域16';
$string['region-frnt-market-q'] = 'ページ領域17';
$string['region-frnt-market-r'] = 'ページ領域18';
$string['region-frnt-market-s'] = 'ページ領域19';
$string['region-frnt-market-t'] = 'ページ領域20';
$string['region-my-tab-one-a'] = 'ダッシュボードページタブ領域1';
$string['region-my-tab-two-a'] = 'ダッシュボードページタブ領域2';
$string['region-news-slider-a'] = 'コースページスライダ領域';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
$string['regionmaincolor'] = 'メイン領域色';
$string['regionmaincolordesc'] = 'メインコンテンツ領域の背景色を設定します。';
$string['rendereroverlaycolor'] = 'オーバーレイ色';
$string['rendereroverlaycolordesc'] = '「タイル w/オーバーレイ」描画が選択された場合のオーバーレイの色です。';
$string['rendereroverlayfontcolor'] = 'オーバーレイフォント色';
$string['rendereroverlayfontcolordesc'] = '「タイル w/オーバーレイ」描画が有効にされたコースボックスの上にカーソルが置かれた場合のフォント色です。';
$string['responsivebreadcrumb'] = 'ブレッドクラムナビゲーション';
$string['responsivebreadcrumbdesc'] = 'どのサイズの画面でブレッドクラムナビゲーションを表示しますか?';
$string['responsivecoursetitle'] = 'コース/サイトタイトル';
$string['responsivecoursetitledesc'] = 'どのサイズの画面でサイト/コースタイトルを表示しますか?';
$string['responsiveheader'] = 'メインヘッダ';
$string['responsiveheaderdesc'] = 'どのサイズの画面でメインヘッダを表示しますか?<br />あなたがデフォルト/オリジナル3行ヘッダを使用している場合のみ、この設定は適用されます。<br /> ヘッダエントリを削除した場合、それに含まれるエレメントも削除されます:<br /><ul><li>ソーシャルアイコン</li><li>ロゴ</li><li>サイト/コースタイトル</li></ul>';
$string['responsivelogo'] = 'ロゴ';
$string['responsivelogodesc'] = 'どのサイズの画面でロゴを表示しますか?';
$string['responsivepagefooter'] = 'フッタ';
$string['responsivepagefooterdesc'] = 'どのサイズの画面でフッタを表示しますか?';
$string['responsivesectionnav'] = '活動/セクションナビゲーション';
$string['responsivesectionnavdesc'] = '小さなスクリーンでの「前へ」「次へ」の活動/セクションナビゲーションの<strong>テキスト</strong>を表示/非表示にします。デフォルトでは小さなスクリーンには「前へ」「次へ」リンクのアイコンのみ表示されてフルセクション/活動名は表示されません。';
$string['responsivesettings'] = 'レイアウトレスポンシブ';
$string['responsivesettingsdesc'] = 'ここであなたのサイトのレスポンシブ動作（異なるサイズの画面にどの要素が表示されるか）をコントロールできます。<br />デフォルトではほとんどの非必須項目はモバイルデバイスで非表示にされ大きなスクリーンにのみ表示されます。<br />あなたは「極小」または「小さなスクリーン」での表示の選択によりエレメントを表示できます。<br />これらの設定がどのように機能するか十分理解するにはBootstrap 4ドキュメンテーションをご覧ください<br /><br /> https://getbootstrap.com/docs/4.0/utilities/display/ <br /><br />';
$string['responsivesettingsheading'] = 'あなたのサイトの異なるスクリーンサイズでの動作をコントロールする';
$string['responsiveslider'] = 'フロントページスライダ';
$string['responsivesliderdesc'] = 'どのサイズの画面でフロントページスライダを表示しますか?';
$string['responsivesocial'] = 'ソーシャルアイコン';
$string['responsivesocialdesc'] = 'どのサイズの画面でソーシャルアイコンを表示しますか?';
$string['responsivesocialsize'] = 'モバイルのソーシャルアイコンのフォントサイズを設定する';
$string['responsivesocialsizedesc'] = '閲覧しやすくするため、希望する実際のサイズより5px大きくする必要があります。';
$string['responsiveticker'] = 'ニュースティッカ';
$string['responsivetickerdesc'] = 'どのサイズの画面でニュースティッカを表示しますか?';
$string['rightblocks'] = '右側';
$string['savebuttontext'] = '変更を保存する';
$string['searchboxpadding'] = '検索ボックスパディング';
$string['searchboxpaddingdesc'] = '検索ボックス上部のパッディングを設定します (ソーシャルアイコンの代わりに使用されている場合)。<br />例) 5px 10px 5px 10px (上部 右, 下部, 左) <br />あなたは<a href="./../admin/settings.php?section=theme_adaptable_social">ヘッダソーシャル</a>設定ページ</strong>でソーシャルアイコンを設定できます。';
$string['sectionheadingcolor'] = 'セクションヘッダテキスト色';
$string['sectionheadingcolordesc'] = 'セクションヘッディングテキストの色を設定します。';
$string['sections'] = 'セクション';
$string['selectionbackground'] = '選択背景色';
$string['selectionbackgrounddesc'] = 'スクリーンのテキスト選択時の背景色を設定します。';
$string['selectiontext'] = 'セクションテキスト色';
$string['selectiontextdesc'] = '画面テキスト選択時のテキスト色を設定します。';
$string['settingsalertbox'] = '警告ボックス';
$string['settingsanalytics'] = 'アナリティクス';
$string['settingsblockicons'] = 'アイコン';
$string['settingsblocksgeneral'] = '一般';
$string['settingsborders'] = '枠線';
$string['settingsbreadcrumbcolors'] = 'ブレッドクラム色';
$string['settingscolors'] = '色';
$string['settingscourses'] = 'コース';
$string['settingsfonts'] = 'フォント';
$string['settingsfootercolors'] = 'フッタ色';
$string['settingsforumheading'] = 'フォーラム';
$string['settingsheadercolors'] = 'ヘッダ色';
$string['settingsinfoboxcolors'] = '受信箱色';
$string['settingsmaincolors'] = 'メイン色';
$string['settingsmarketingcolors'] = 'マーケティングブロック色';
$string['settingsmessagescolors'] = 'メッセージポップアップ色';
$string['settingsmobilecolors'] = 'モバイル色';
$string['settingsnavbarcolors'] = 'ナビゲーションバー (navbar) 色';
$string['settingsoverlaycolors'] = 'オーバレイタイル色';
$string['settingssecondinfoboxcolors'] = '第2情報ボックス色';
$string['settingstopicsweeks'] = 'トピック/週';
$string['show'] = '表示';
$string['showfooterblocks'] = 'フッタブロックを表示する';
$string['showfooterblocksdesc'] = '4つの設定可能フッタブロックを表示/非表示にします。';
$string['shownavigationblockoncoursepage'] = 'コースページのナビゲーションブロックを表示する';
$string['shownavigationblockoncoursepagedesc'] = 'コースページのナビゲーションブロックを表示したい場合、この設定を有効にしてください';
$string['showusername'] = 'ユーザ名を表示する';
$string['showusernamedesc'] = 'ナビゲーションバーのユーザメニューにユーザ名を表示します。';
$string['side-post1'] = 'フッタのサイドバー';
$string['sidebaricon'] = 'サイドバーを表示/非表示にする';
$string['sitelinkslabel'] = 'サイトリンク';
$string['sitetitle'] = 'サイトタイトルを表示する';
$string['sitetitlecoursesdisabled'] = '無効 - コースページにコースタイトルのみ表示する';
$string['sitetitlecoursesenabled'] = '有効 - コースページにサイトタイトルおよびコースタイトルを表示する';
$string['sitetitlecustom'] = 'カスタムタイトルを使用する (下の「sitetitletext」ボックスに入力してください)';
$string['sitetitledefault'] = 'Moodleサイトタイトル (サイト名) を使用する';
$string['sitetitledesc'] = '<a href="./../admin/settings.php?section=frontpagesettings" target="_blank">フロントページ設定</a>のデフォルトMoodleサイトタイトルを表示するか、下のテキストボックスにカスタムサイトタイトルを入力してください。';
$string['sitetitleoff'] = 'サイトタイトルを無効にする';
$string['sitetitletext'] = 'サイトタイトル';
$string['sitetitletextdesc'] = 'ヘッダに表示されるサイトタイトルです。あなたはHTMLタグを使用してインラインスタイルを適用できます。このフィールドに何かを入力した場合にデフォルトで追加される「<p>」タグの代わりにタイトル周りには「<H1>」HTMLタグを使用してください。';
$string['slider2h3bgcolor'] = 'スライド2 H3背景色';
$string['slider2h3bgcolordesc'] = 'あなたが希望するスライダ2 H3タグの背景色を選択してください。';
$string['slider2h3color'] = 'スライダ2 H3テキスト色';
$string['slider2h3colordesc'] = 'あなたが希望するスライダ2 H3タグのテキスト色を選択してください。';
$string['slider2h4bgcolor'] = 'スライダ2 H4背景色';
$string['slider2h4bgcolordesc'] = 'あなたが希望するスライダ2 H4タグの背景色を選択してください。';
$string['slider2h4color'] = 'スライダ2 H4テキスト色';
$string['slider2h4colordesc'] = 'あなたが希望するスライダ2 H4タグのテキスト色を選択してください。';
$string['slidercaption'] = 'スライダキャプション';
$string['slidercaptiondesc'] = 'あなたのスライダのキャプションを追加します。';
$string['slidercount'] = 'スライダカウント';
$string['slidercountdesc'] = 'あなたが追加したいスライド数を選択してください。入力フィールドを読み込むには「保存」をクリックしてください。';
$string['sliderenabled'] = 'スライダを有効にする';
$string['sliderenableddesc'] = 'あなたのホームページ上部のスライダを有効にします。';
$string['sliderfullscreen'] = 'スライダフルスクリーン';
$string['sliderfullscreendesc'] = 'スライダをフルスクリーン (100%幅) にするにはこの設定を有効にしてください。';
$string['sliderh3color'] = 'スライダ1 H3色';
$string['sliderh3colordesc'] = 'あなたが希望するスライダ1 H3タグの色を選択してください。';
$string['sliderh4color'] = 'スライダ1 H4色';
$string['sliderh4colordesc'] = 'あなたが希望するスライダ1 H4タグの色を選択してください。';
$string['sliderimage'] = 'スライダ画像';
$string['sliderimagedesc'] = 'あなたのスライドにイメージを追加します。推奨サイズは1600px x 400pxまたはそれ以上です。';
$string['slidermarginbottom'] = 'スライダ下部マージン';
$string['slidermarginbottomdesc'] = 'スライダ下部のマージンのサイズを設定します。';
$string['slidermargintop'] = 'スライダ上部マージン';
$string['slidermargintopdesc'] = 'スライダ上部のマージンのサイズを設定します。';
$string['slideroption2'] = 'スライダタイプを選択する';
$string['slideroption2a'] = 'スライダスタイルオプション2矢印背景色';
$string['slideroption2adesc'] = 'スライダスタイルオプション2矢印背景色を設定します。';
$string['slideroption2color'] = 'スライダ2送信背景色';
$string['slideroption2colordesc'] = 'スライダスタイルオプションの送信テキストの背景色を設定します。';
$string['slideroption2desc'] = 'スライドタイプを選択してください。あなたが選択したスライダ色の設定を確認するには「保存」をクリックしてください。';
$string['slideroption2submitcolor'] = 'スライダ2送信テキスト';
$string['slideroption2submitcolordesc'] = 'スライダスタイルオプション2の送信テキストの背景色を設定します。';
$string['sliderstyle1'] = 'スライダスタイル1';
$string['sliderstyle2'] = 'スライダスタイル2';
$string['slidersubmitbgcolor'] = 'スライダ1送信背景色';
$string['slidersubmitbgcolordesc'] = 'スライダ1送信ボタンの背景色を選択します。';
$string['slidersubmitcolor'] = 'スライダ1送信テキスト';
$string['slidersubmitcolordesc'] = 'スライダ1送信ボタンのテキスト色を選択してください。';
$string['sliderurl'] = 'スライドリンクURL';
$string['sliderurldesc'] = 'あなたのスライドがリンクされた場合のURLを追加します。';
$string['slideshowdesc'] = 'フロントページのカルーセルにイメージをアップロード、リンクおよび説明を追加します。';
$string['slideshowsettings'] = 'スライドショー';
$string['slideshowsettingsheading'] = 'フロントページのカルーセルをカスタマイズします。<a href="./../theme/adaptable/pix/layout.png" target="_blank">ここ</a>でレイアウトを確認してください。';
$string['slight'] = '薄く';
$string['socialheading'] = 'ソーシャルアイコン設定';
$string['socialicondesc'] = 'Font Awesomeアイコンを設定します。例: fa-facebook';
$string['socialiconlist'] = 'ソーシャルアイコンリスト';
$string['socialiconlistdesc'] = 'あなたが必要とするソーシャルアイコン/リンクを設定するため、デリミタ区切りのリストを次のフォーマットで入力してください: url|title|icon';
$string['socialpaddingside'] = 'ソーシャルアイコン側面のパッディングを調整する';
$string['socialpaddingsidedesc'] = 'これはアイコンと別のエレメント間のスペースまたは2つのアイコン間のギャップです。デフォルト値はInstagramのブランディングガイドラインに従います。';
$string['socialpaddingtop'] = 'ソーシャルアイコンの上のパディングを調整する（垂直方向ポジションを変更する)';
$string['socialpaddingtopdesc'] = '最小15px （マージンを使用して設定）にこの値を追加した値です。';
$string['socialsearchicon'] = 'Moodleを検索する';
$string['socialsearchicondesc'] = 'ソーシャルアイコンの横に検索リンクを置けるようにします (ソーシャルを使用する場合、サイト全体の検索ボックスを使用できないため)';
$string['socialsettings'] = 'ヘッダソーシャル';
$string['socialsize'] = 'ソーシャルアイコンのフォントサイズを設定する';
$string['socialsizedesc'] = '閲覧しやすくするため、希望する実際のサイズより5px大きくする必要があります。';
$string['socialtarget'] = 'ソーシャルリンクオープンターゲット';
$string['socialtargetdesc'] = 'ソーシャルリンクをどのように開くか設定します (同一または新しいウィンドウ)。';
$string['socialtitledesc'] = 'あなたはサイト全体の検索ボックスを無効にして代わりにソーシャルアイコン/リンクを有効にできます。アイコンを設定するには下の「ソーシャルアイコンリスト」フィールドにデリミタ区切りのリストを入力してください。これは次のようなフォーマットになります: url|title|icon For example: <pre> https://example.com/course/search.php|Search Moodle|fa-search https://facebook.com/|Facebook|fa-facebook-square https://twitter.com/|Twitter|fa-twitter-square https://instagram.com|Instagram|fa-instagram https://example.com|My Web|fa-globe </pre> あなたは参考のため<a href="https://fortawesome.github.io/Font-Awesome/icons/">ここでFont Awesomeアイコン</a>の完全なリストを確認できます。';
$string['standard'] = '標準';
$string['standardscreenwidth'] = '標準スクリーン幅';
$string['standardscreenwidthdesc'] = '「標準」ビューに切り替えられた時のスクリーン幅を設定します (関連する「enablezoom 」および「defaultzoom」設定をご覧ください)。';
$string['standardview'] = '標準ビュー';
$string['static'] = '固定';
$string['stickynavbar'] = '上部スティッキーナビゲーションバー';
$string['stickynavbardesc'] = 'スクロールダウン時、スクリーン上部にナビゲーションバーを固定します。';
$string['stylecover'] = 'カバー';
$string['stylestretch'] = 'ストレッチ';
$string['tabbedlayoutcoursepage'] = 'コースページタブレイアウト';
$string['tabbedlayoutcoursepagedesc'] = 'コースページにタブレイアウトを使用します。これによりすべてのコンテンツが1つのタブに表示されるため、あなたは他のタブのコンテンツを調整できます。タブの順序を設定するにはこの設定を使用してください。';
$string['tabbedlayoutcoursepagelink'] = 'コースページタブレイアウトコースリンク';
$string['tabbedlayoutcoursepagelinkdesc'] = 'コースタブにコースページへのリンクを配置します。';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'コースページの選択済みタブ色';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = '現在選択されているタブの色を選択してください。';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'コースページの未選択タブ色';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = '他のすべてのタブの色を選択してください。';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'コースホームページタブ持続時間';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'コースホームページタブは非アクティブ時間がリフレッシュされるまで選択状態が続きます。ここで非アクティブ時間を設定してください。例えば30を設定した場合、30分間非アクティブ時間が継続した時点で最初のタブが選択されます。';
$string['tabbedlayoutdashboard'] = 'ダッシュボードページタブレイアウト';
$string['tabbedlayoutdashboarddesc'] = 'ダッシュボードページにタブレイアウトを使用します。これによりすべてのコンテンツが1つのタブに表示されるため、あなたは他のタブのコンテンツを調整できます。タブの順序を設定するにはこの設定を使用してください。';
$string['tabbedlayoutdashboardtab1condition'] = 'タブ1カスタムプロファイルフィールド制限 (任意)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'カスタムプロファイルフィールドを使用してタブ1を表示するアクセスルールを追加します。例) showtab1=true';
$string['tabbedlayoutdashboardtab2condition'] = 'タブ2カスタムプロファイルフィールド制限 (任意)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'カスタムプロファイルフィールドを使用してタブ2を表示するアクセスルールを追加します。例) showtab2=true';
$string['tabbedlayoutdashboardtabcolorselected'] = 'ダッシュボードタブの選択済みタブ色';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = '現在選択されているタブの色を選択してください。';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'ダッシュボードの未選択タブ色';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = '他のすべてのタブの色を選択してください。';
$string['tabbedlayoutheading'] = 'Adaptableタブレイアウト';
$string['tabbedlayouttablabelcourse'] = 'コースコンテンツ';
$string['tabbedlayouttablabelcourse1'] = 'タブ1';
$string['tabbedlayouttablabelcourse2'] = 'タブ2';
$string['tabbedlayouttablabeldashboard'] = 'ダッシュボードコンテンツ';
$string['tabbedlayouttablabeldashboard1'] = 'タブ1';
$string['tabbedlayouttablabeldashboard2'] = 'タブ2';
$string['targetnewwindow'] = '新しいウィンドウ';
$string['targetsamewindow'] = '同一ウィンドウ';
$string['templatesheading'] = 'テンプレート設定';
$string['templatesheadingdesc'] = 'テンプレートをオーバーライドします。';
$string['templatessel'] = 'オーバーライドするテンプレート';
$string['templatesseldesc'] = 'オーバーライドするテンプレートを選択してください。それぞれのテンプレートは自ページに表示されます。ここで選択しない場合、有効にされたとしてもテンプレートはオーバーライドされません。何も選択しない場合、「Ctrl」キーを使用してください。';
$string['templatessettings'] = 'テンプレート';
$string['thiscourse'] = 'このコース';
$string['ticker'] = 'アナウンスメント';
$string['tickerdefault'] = '表示するニュースアイテムはありません。';
$string['tickerdesc'] = 'ここではあなたのMoodleサイトのフロントページで動作するニュースティッカを設定できます。これは非常に小さなスペースを必要とするスライダの代わりに押し付けがましくならないことを意図しています。あなたのティッカを設定するには単に段落リストを入力ししてテキストに必要なハイパーリンクを含んでください。<strong>注意:</strong> あなたのティッカが正常に読み込まれない場合、HTMLビューに切り替えて<p>タグのみが使用されていることを確認してください: <pre> &lt;p&gt;ニュースアイテム1 .....&lt;/p&gt; &lt;p&gt;ニュースアイテム2 .....&lt;/p&gt; </pre>';
$string['tickerfullscreen'] = 'フルスクリーン幅';
$string['tickersettings'] = 'ニュースティッカ';
$string['tickersettingsheading'] = 'フロントページのニュースティッカをセットアップします。<a href="./../theme/adaptable/pix/layout.png" target="_blank">ここ</a>でレイアウトを確認してください。';
$string['tickertext'] = 'ニュースティッカテキスト';
$string['tickertextdesc'] = 'リストフォーマットにニュースティッカを追加します。詳細はREADMEをご覧ください。';
$string['tickertextprofilefield'] = 'カスタムプロファイルフィールド名 Name=Value (任意)';
$string['tickertextprofilefielddesc'] = 'カスタムプロファイルフィールドを使用してアクセスルールを追加します。例) usertype=student';
$string['tickerwidth'] = '固定幅';
$string['tickerwidthdesc'] = 'あなたはこの設定をニュースティッカを100%幅にするため使用できます。';
$string['tilesbordercolor'] = 'コースボックスタイル枠線色';
$string['tilesbordercolordesc'] = 'コースボックスタイル枠線の色を設定します。';
$string['tilescontactstitle'] = 'コース連絡先ロールを表示する';
$string['tilescontactstitledesc'] = 'コース連絡先のロールを表示/非表示にします。表示されない場合、それぞれの連絡先の前にイメージが表示されます。';
$string['tilesshowallcontacts'] = 'すべてのコース連絡先を表示する';
$string['tilesshowallcontactsdesc'] = 'すべてのコース連絡先または1つを表示します。';
$string['tilesshowcontacts'] = 'コース連絡先を表示する';
$string['tilesshowcontactsdesc'] = 'コース連絡先を表示/非表示にします。';
$string['togglenavigation'] = 'ナビゲーションを切り替える';
$string['toolsmenu'] = 'ツールメニュードロップダウン';
$string['toolsmenudesc'] = 'メインナビゲーションバーにドロップダウンメニューを追加します。';
$string['toolsmenufield'] = 'カスタムプロファイルフィールド Name=Value (任意)';
$string['toolsmenufielddesc'] = 'カスタムプロファイルフィールドを使用してアクセスルールを追加します。例) usertype=student';
$string['toolsmenuheading'] = 'ツールメニュー';
$string['toolsmenuheadingdesc'] = 'あなたは (メインナビゲーションバー) のツールメニューの下に表示されるリンクを設定できます。フォーマットはMoodleカスタムメニューで使用するものに類似していますが、あなたはメニューアイテムにFont Awesomeアイコンを追加できます: <pre> &lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen &lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock &lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock </pre><br />';
$string['toolsmenuscount'] = 'ツールメニュー数';
$string['toolsmenuscountdesc'] = 'あなたがメインナビゲーションバーに追加したいツールメニューの数を設定します。';
$string['toolsmenutitle'] = 'ツールメニュータイトル';
$string['toolsmenutitledefault'] = 'ツール';
$string['toolsmenutitledesc'] = 'あなたがメインナビゲーションバーに表示したいメニューのタイトルを追加します。';
$string['topicsweeks'] = 'トピック/週コースフォーマット';
$string['topicsweeksdesc'] = 'トピック/週コースフォーマットのスタイルを設定します。';
$string['topmenufontsize'] = 'トップメニューフォントサイズ';
$string['topmenufontsizedesc'] = 'トップメニューのフォントサイズを調整します。';
$string['topmenuscount'] = 'トップメニュー数';
$string['topmenuscountdesc'] = 'あなたがテーマヘッダに追加したいトップメニューの数を設定します。';
$string['turngradereditingoff'] = '評定編集を終了する';
$string['turngradereditingon'] = '評定編集を開始する';
$string['usermenu'] = 'ユーザメニュー';
$string['usernameposition'] = 'ユーザメニューポジション';
$string['usernamepositiondesc'] = 'ユーザ名のポジションを「左」または「右」に設定します。';
$string['usernav'] = 'ヘッダユーザ';
$string['usernavdesc'] = 'あなたがナビゲーションドロップダウンに表示されるすべてのエレメントをコントロールできるようにします。';
$string['usernavheading'] = 'ユーザナビゲーションドロップダウンをカスタマイズする';
$string['usernodescription'] = 'ユーザはまだ説明を更新していません。';
$string['usernointerests'] = 'ユーザはまだ興味のあることを更新していません。';
$string['usersettings'] = 'ユーザプロファイル';
$string['usersettingsdesc'] = 'ユーザプロファイルを設定します。';
$string['usersettingsheading'] = 'ユーザプロファイルをコントロールする';
$string['versioninfo'] = 'Moodle {$a->moodle} のリリース {$a->release} およびバージョン {$a->version}';
$string['wide'] = 'フルスクリーン';
