<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_uikit', language 'af', version '4.2'.
 *
 * @package     theme_uikit
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Aanvaar';
$string['alert-background'] = 'Agtergrondkleur';
$string['alert-border'] = 'Rantkleur';
$string['alert-color'] = 'Tekskleur';
$string['alert-danger-background'] = 'Gevaar Agtergrondkleur';
$string['alert-danger-border'] = 'Gevaar Rantkleur';
$string['alert-danger-color'] = 'Gevaar Tekskleur';
$string['alert-success-background'] = 'Sukses Agtergrondkleur';
$string['alert-success-border'] = 'Sukses Rantkleur';
$string['alert-success-color'] = 'Sukses Tekskleur';
$string['alert-warning-background'] = 'Waarskuwing Agtergrondkleur';
$string['alert-warning-border'] = 'Waarskuwing Agtergrondkleur';
$string['alert-warning-color'] = 'Waarskuwing Tekskleur';
$string['allclasses'] = 'Alle Klasse';
$string['allcourses'] = 'Alle Kursusse';
$string['allmodules'] = 'Alle Modules';
$string['allsubjects'] = 'Alle Vakke';
$string['allunits'] = 'Alle Eenhede';
$string['almost-flat'] = 'Amper plat';
$string['alwaysdisplay'] = 'Vertoon Altyd';
$string['analyticsadmin'] = 'Volg Admingebruikers';
$string['analyticsadmindesc'] = 'Ontsper om Admingebruikers ook te volg.';
$string['analyticsclean'] = 'Stuur Skoon URL\'e';
$string['analyticscleandesc'] = 'Hierdie fantasiese funksie is geskep deur <a href="https://moodle.org/user/profile.php?id=281671" target="_blank">Gavin Henrick</a> en <a href="https://moodle.org/user/view.php?id=907814" target="_blank">Bas Brands</a> en is in hierdie tema geïmplementeer. In plaas van standaard Moodle-URL\'e stuur die tema skoon URL\'e uit, wat dit makliker maak om die bladsy te identifiseer en gevorderde verslaggewing te verskaf. Meer inligting oor die gebruik van hierdie funksie en die gebruike daarvan kan <b><a href="http://www.somerandomthoughts.com/blog/2012/04/18/ireland-uk-moodlemoot-analytics-to-the-front/" target="_blank">hier</a></b> gevind word.';
$string['analyticsdesc'] = 'Hier kan jy Google Analytics vir jou Moodle-werf ontsper. Jy sal vir \'n gratis rekening op die Google Analytics-werf moet inskryf (<a href="http://analytics.google.com" target="_blank">http://analytics.google.com</a>)';
$string['analyticsheading'] = 'Google Analytics';
$string['analyticsheadingsub'] = 'Kragtige ontleding deur Google';
$string['analyticsid'] = 'Jou Spoor-ID';
$string['analyticsiddesc'] = 'Voer die verskafde Spoor-ID in. Gewoonlik geformatteer soos UA-XXXXXXXX-X';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Verskaf \'n URL na jou Moodle-toep op die Google Play Store. As jy nie jou eie het nie, kan jy oorweeg om na die gratis amptelike Moodle Mobiele toep te skakel.';
$string['auto'] = 'Outo';
$string['auto_refresh'] = 'Outoverfris';
$string['autohide'] = 'Sluit Outoversteek-funksionaliteit in';
$string['autohidedesc'] = 'Die Outoversteek-funksionaliteit is ontwerp om Moodle minder intimiderend te maak. Wanneer wysiging aangeskakel is, verskyn wysigikone slegs wanneer daar oor die item gesweef word.';
$string['backtotop'] = 'Terug na bo';
$string['base-body-background'] = 'Agtergrondkleur';
$string['base-body-color'] = 'Tekskleur';
$string['base-body-font-family'] = 'Liggaam-fontfamilie';
$string['base-body-font-size'] = 'Fontgrootte';
$string['base-body-gradient-inner'] = 'Agtergrondkleur - Gradiënt (binneste)';
$string['base-body-gradient-outer'] = 'Agtergrondkleur - Gradiënt (buitekant)';
$string['base-body-line-height'] = 'Lynhoogte';
$string['base-heading-color'] = 'Tekskleur van Opskrifte';
$string['base-heading-font-family'] = 'Fontfamilie van Opskrifte';
$string['base-heading-font-weight'] = 'Fontgewig van Opskrifte';
$string['base-link-color'] = 'Skakelkleur';
$string['base-link-hover-color'] = 'Skakelsweefkleur';
$string['base-link-hover-text-decoration'] = 'Skakelsweefversiering';
$string['base-link-text-decoration'] = 'Skakelversiering';
$string['base_theme'] = 'Base-tema';
$string['basic'] = 'Basies';
$string['bootstrapcdn'] = 'FontAwesome deur CDN';
$string['bootstrapcdndesc'] = 'Indien ontsper, sal dit dit FontAwesome vanaf die aanlyn Bootstrap CDN-bron laai. Ontsper dit as jy probleme het om FontAwesome-ikone in jou werf te laat vertoon.';
$string['breadcrumbsplacement'] = 'Breadcrumbs-plasing';
$string['breadcrumbsplacement-mainregion'] = 'Hoofarea';
$string['breadcrumbsplacement-pagenavbar'] = 'Bladsy bokant navstafie';
$string['button-active-background'] = 'Normaal - Aktiewe Agtergrond';
$string['button-active-color'] = 'Normaal - Aktiewe Teks';
$string['button-background'] = 'Normaal - Agtergrond';
$string['button-border'] = 'Rantkleur';
$string['button-border-bottom'] = 'Rantkleur (onder)';
$string['button-color'] = 'Normaal - Teks';
$string['button-contrast-hover-border'] = 'Sweefrandkleur (kontras)';
$string['button-contrast-text-shadow'] = 'Teksskadu (kontras)';
$string['button-danger-active-background'] = 'Gevaar - Aktiewe Agtergrond';
$string['button-danger-active-color'] = 'Gevaar - Aktiewe Teks';
$string['button-danger-background'] = 'Gevaar - Agtergrond';
$string['button-danger-color'] = 'Gevaar - Teks';
$string['button-danger-gradient-bottom'] = 'Gevaar - Gradiënt (onder)';
$string['button-danger-gradient-top'] = 'Gevaar - Gradiënt (bokant)';
$string['button-danger-hover-background'] = 'Gevaar - Sweefagtergrond';
$string['button-danger-hover-color'] = 'Gevaar - Sweefteks';
$string['button-disabled-background'] = 'Versper - Agtergrond';
$string['button-disabled-color'] = 'Versper - Teks';
$string['button-gradient-bottom'] = 'Normaal - Gradiënt (onder)';
$string['button-gradient-top'] = 'Normaal - Gradiënt (bokant)';
$string['button-height'] = 'Knoppiehoogte';
$string['button-hover-background'] = 'Normaal - Sweefagtergrond';
$string['button-hover-border'] = 'Sweefrantkleur';
$string['button-hover-color'] = 'Normaal - Sweefteks';
$string['button-primary-active-background'] = 'Primêr - Aktiewe Agtergrond';
$string['button-primary-active-color'] = 'Primêr - Aktiewe Teks';
$string['button-primary-background'] = 'Primêr - Agtergrond';
$string['button-primary-color'] = 'Primêr - Teks';
$string['button-primary-gradient-bottom'] = 'Primêr - Gradiënt (onder)';
$string['button-primary-gradient-top'] = 'Primêr - Gradiënt (bokant)';
$string['button-primary-hover-background'] = 'Primêr - Sweefagtergrond';
$string['button-primary-hover-color'] = 'Primêr - Sweefteks';
$string['button-small-height'] = 'Kleinknoppie-hoogte';
$string['button-success-active-background'] = 'Sukses - Aktiewe Agtergrond';
$string['button-success-active-color'] = 'Sukses - Aktiewe Teks';
$string['button-success-background'] = 'Sukses - Agtergrond';
$string['button-success-color'] = 'Sukses - Teks';
$string['button-success-gradient-bottom'] = 'Sukses - Gradiënt (onder)';
$string['button-success-gradient-top'] = 'Sukses - Gradiënt (bokant)';
$string['button-success-hover-background'] = 'Sukses - Sweefagtergrond';
$string['button-success-hover-color'] = 'Sukses - Sweefteks';
$string['button-text-shadow'] = 'Teksskadu';
$string['cancel'] = 'Kanselleer';
$string['choosereadme'] = 'Tema gebou met UIKit. Dit sluit \'n gevorderde Visuele Styl Bestuurder in.';
$string['combolistshowonlyenrrolled'] = 'Vertoon slegs ingeskrewe kursusse in die kombinasielys';
$string['combolistshowonlyenrrolleddesc'] = 'Indien gemerk, sal slegs ingeskrewe kursusse en kategorieë vertoon word wanneer die kombinasielys in die voorblad gebruik word.';
$string['componentclass-danger'] = 'Gevaar';
$string['componentclass-link'] = 'Skakel';
$string['componentclass-normal'] = 'Normaal';
$string['componentclass-primary'] = 'Primêr';
$string['componentclass-success'] = 'Sukses';
$string['componentplacement-bottom'] = 'Onder';
$string['componentplacement-center'] = 'Middel';
$string['componentplacement-left'] = 'Links';
$string['componentplacement-right'] = 'Regs';
$string['componentplacement-top'] = 'Bo';
$string['configtitle'] = 'UIKit';
$string['contactinfo'] = 'Kontakinligting';
$string['contactinfodesc'] = 'Voer jou kontakinligting in';
$string['continue_refreshing'] = 'Hou aan verfris?';
$string['copyright'] = 'Kopiereg';
$string['copyrightdesc'] = 'Die naam van jou instelling.';
$string['courselist'] = 'Vertoon eenvoudige kursuslys';
$string['custom_less'] = 'Gebruik jou eie doelgemaakte CSS/LESS-kode';
$string['custom_less_default'] = 'Jou doelgemaakte CSS- of LESS-kode hier ...
    Dit sal aan die einde van die stylvel bygevoeg word.';
$string['custommenudesc'] = 'Verstellings hier laat toe dat jy nuwe dinamiese funksionaliteit by die doelgemaakte kieslys voeg (ook bekend as Aftrekkieslys)';
$string['custommenuheading'] = 'Doelgemaakte Kieslys';
$string['custommenuheadingsub'] = 'Voeg bykomende funksionaliteit by jou doelgemaakte kieslys.';
$string['displayafterlogin'] = 'Vertoon slegs ná intekening';
$string['displaybeforelogin'] = 'Vertoon slegs voor intekening';
$string['displayloggedusermode'] = 'Vertoonmodus van Ingetekende gebruiker';
$string['displayloggedusermodecomplete'] = 'Volledige inligting';
$string['displayloggedusermodedesc'] = 'Hierdie verstelling definieer hoe die ingetekende gebruiker in die Doelgemaakte Kieslys vertoon word.';
$string['displayloggedusermodehide'] = 'Versteek';
$string['displayloggedusermodeonlylogout'] = 'Slegs uitteken';
$string['displayloggedusermodeshort'] = 'Kort inligting';
$string['displaymycourses'] = 'Vertoon ingeskrewe kursusse';
$string['displaymycoursesdesc'] = 'Vertoon ingeskrewe kursusse vir gebruikers in die Doelgemaakte Kieslys';
$string['displaymycoursesmode'] = 'Vertoonmodus van Ingeskrewe kursusse';
$string['displaymycoursesmodedesc'] = 'Hierdie verstelling definieer hoe ingeskrewe kursusse in die Doelgemaakte Kieslys vertoon word';
$string['displaymydashboard'] = 'Vertoon Paneelbord';
$string['displaymydashboarddesc'] = 'Vertoon Paneelbord van gebruikerskakels in die Doelgemaakte Kieslys';
$string['displaysitename'] = 'Vertwoon werfnaam';
$string['dontdisplay'] = 'Vertoon Nooit';
$string['dropdown-background'] = 'Agtergrondkleur van Aftreklys';
$string['dropdown-navbar-background'] = 'Agtergrond van Aftreklys';
$string['export_less'] = 'Voer LESS uit';
$string['export_less_tooltip'] = 'Voer styldoelmakings na \'n LESS-dokument uit';
$string['facebook'] = 'Facebook-URL';
$string['facebookdesc'] = 'Voer die URL van jou Facebook-blad in (d.w.s.';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Laai asseblief jou doelgemaakte favicon hier op as jy dit by die bladsy wil voeg';
$string['flickr'] = 'Flickr-URL';
$string['flickrdesc'] = 'Voer die URL van jou Flickr-blad in (d.w.s. http://www.flickr.com/mycollege)';
$string['footerbackground'] = 'Agtergrondprent van Onderskrif';
$string['footerbackgrounddesc'] = 'Laai jou eie onderskrifagtergrondprent op. Dit sal as teëls in die onderskrifagtergrond van alle bladsye vertoon word.';
$string['footerblocks'] = 'Ontsper Onderskrifblokke';
$string['footerblocksdesc'] = 'Indien ontsper, sal dit 3 nuwe blokplekke in die bladsy se onderskrif vertoon.';
$string['footerimage'] = 'Onderskrif';
$string['footerimagedesc'] = 'Laai asseblief jou doelgemaakte onderskrifprent hier op as jy dit by die onderskrif wil voeg.<br>As jy \'n onderskrif oplaai, sal dit bokant onderskrif-HTML (indien enige) geplaas word.';
$string['footerplacement'] = 'Onderskrifplasing';
$string['footerplacementaftermaincontent'] = 'Ná hoofinhoud van die bladsy';
$string['footerplacementpageend'] = 'Aan die einde van die bladsy';
$string['footnote'] = 'Voetnoot';
$string['footnotedesc'] = 'Wat jy ook al by hierdie teksarea voeg, sal regdeur jou Moodle-werf in die onderskrif vertoon word.';
$string['frontcontentarea'] = 'Voorbladinhoud';
$string['frontcontentareadesc'] = 'Wat ook al in hierdie boks getik word, sal regoor die volle breedte van die bladsy vertoon word, tussen die Skyfievertoning en Bemarkingsplekke';
$string['frontcontentdesc'] = 'Dit voeg \'n doelgemaakte inhoudarea boaan die voorblad se hoofboks, vir jou eie doelgemaakte inhoud.';
$string['frontcontentheading'] = 'Voorbladverstellings';
$string['frontcontentheadingsub'] = 'Verander die funksies wat jy op jou Moodle-voorblad wil ontsper.';
$string['frontpageblocks'] = 'Belyning van voorbladblokke';
$string['frontpageblocksdesc'] = 'Hier kan jy bepaal of die blokke op die voorblad na links of regs belyn word.';
$string['frontpagemiddleblocks'] = 'Ontsper Middelblokke van Voorblad';
$string['frontpagemiddleblocksdesc'] = 'Indien ontsper, sal dit 3 nuwe blokplekke net onder die voorbladinhoud vertoon, en 2 bykomende volbreedte blokplekke bo en onder die 3 blokke.';
$string['fullhierarchy'] = 'Vertoon kursusse in vollgedige kategoriehiërargie';
$string['geneicsettings'] = 'Algemene Verstellings';
$string['global-border'] = 'Rantkleur';
$string['global-border-radius'] = 'Rantradius';
$string['global-contrast-color'] = 'Kontraskleur';
$string['global-danger-background'] = 'Gevaar Agtergrond';
$string['global-danger-gradient-bottom'] = 'Gevaar Agtergrond Gradiënt (onder)';
$string['global-danger-gradient-top'] = 'Gevaar Agtergrond Gradiënt (bokant)';
$string['global-muted-color'] = 'Gedempte Tekskleur';
$string['global-primary-background'] = 'Primêre Agtergrond';
$string['global-primary-gradient-bottom'] = 'Primêre Agtergrond Gradiënt (onder)';
$string['global-primary-gradient-top'] = 'Primêre Agtergrond Gradiënt (bokant)';
$string['global-success-background'] = 'Sukses Agtergrond';
$string['global-success-gradient-bottom'] = 'Sukses Agtergrond Gradiënt (onder)';
$string['global-success-gradient-top'] = 'Sukses Agtergrond Gradiënt (bokant)';
$string['googlefontname'] = 'Fontnommer {$a->number}';
$string['googlefontsheading'] = 'Google Fonte';
$string['googlefontsheadingsub'] = 'Hier kan jy tot 10 Google Fonte byvoeg, wat in elke Moodle-blad beskikbaar sal wees';
$string['googlefontsnofont'] = '--Geen Font--';
$string['googleplus'] = 'Google+ URL';
$string['googleplusdesc'] = 'Voer die URL van jou Google+ Profiel in (d.w.s. http://plus.google.com/107817105228930159735)';
$string['gradient'] = 'Gradiënt';
$string['group-alerts'] = 'Waarskuwings';
$string['group-breadcrumbs'] = 'Breadcrumbs';
$string['group-buttons'] = 'Knoppies';
$string['group-global'] = 'Globaal';
$string['group-layout'] = 'Uitleg';
$string['group-login-page'] = 'Intekenblad';
$string['group-main-region'] = 'Hoofinhoud';
$string['group-marketing-spots'] = 'Bemarkingsplekke';
$string['group-mdl-blocks'] = 'Blokke';
$string['group-navbar'] = 'Navigasie (Roosteruitleg)';
$string['group-navbar-layout2'] = 'Navigasie (Flex-uitleg)';
$string['group-other'] = 'Ander';
$string['group-to-top-button'] = 'Gaan na boonste Knoppie';
$string['group-typography'] = 'Tipografie';
$string['headerbackground'] = 'Agtergrondprent van Hofie';
$string['headerbackgrounddesc'] = 'Laai jou eie hofieagtergrondprent op. Dit sal in die hofieagtergrond op alle bladsye in teëlvorm vertoon word.';
$string['headerprofilepic'] = 'Vertoon gebruiker se prent';
$string['headerprofilepicdesc'] = 'Indien gemerk, vertoon die gebruiker se profielprent in die bladsy se hofie.';
$string['hideonphone'] = 'Skyfievertoning op Mobiele Toestelle';
$string['hideonphonedesc'] = 'Kies as jy \'n skyfievertoning op mobiele toestelle wil laat vertoon.';
$string['import_less'] = 'Voer LESS in';
$string['import_less_tooltip'] = 'Voer styldoelmakings vanaf \'n LESS-dokument in';
$string['instagram'] = 'Instagram-URL';
$string['instagramdesc'] = 'Voer die URL van jou Instagram-blad in (d.w.s. http://instagram.com/mycollege)';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Verskaf \'n URL na jou mobiele Toep op die App Store. As jy nie een van jou eie het nie, kan jy oorweeg om na die gratis amptelike Moodle Mobile-toep te skakel.';
$string['iosicon'] = 'iOS-tuisskermikone';
$string['iosicondesc'] = 'Die tema verskaf \'n verstek ikoon vir iOS-, Android- en Windows-tuisskerms. Jy jou doelgemaakte ikone oplaai indien jy sou wou.';
$string['ipadicon'] = 'iPad-ikoon (Nie-retina)';
$string['ipadicondesc'] = 'Ikoon behoort \'n PNG-dokument met \'n grootte van 72 px by 72 px te wees';
$string['ipadretinaicon'] = 'iPad-ikoon (Retina)';
$string['ipadretinaicondesc'] = 'Ikoon behoort \'n PNG-dokument van 144 px by 144 px groot te wees';
$string['iphoneicon'] = 'iPhone/iPod-aanrakingikoon (Nie-Retina)';
$string['iphoneicondesc'] = 'Ikoon behoort \'n PNG-dokument van 57 px by 57 px groot te wees';
$string['iphoneretinaicon'] = 'iPhone/iPod-aanrakingikoon (Retina)';
$string['iphoneretinaicondesc'] = 'Ikoon behoort \'n PNG-dokument van 114 px by 114 px groot te wees';
$string['js-compile-error'] = '\'n Fout het voorgekom tydens die bou van die style';
$string['js-externalpage-disallowed'] = 'Jy word nie toegelaat om na \'n eksterne blad te gaan nie';
$string['js-font-family-placeholder'] = 'Tik jou font of lys van fonte';
$string['js-home'] = 'Tuis';
$string['js-less-error-help'] = 'Probeer asseblief jou blaaier se kasgeheue skoonmaak en verseker dat jou doelgemaakte CSS/LESS korrek is';
$string['js-ok'] = 'OK';
$string['js-reset-all-confirm'] = 'Herstel ALLE groepveranderlikes na verstek?';
$string['js-reset-group'] = 'Herstel groepveranderlikes na verstek';
$string['js-reset-group-confirm'] = 'Herstel groep <i>{0}</i> veranderlikes na verstek?';
$string['js-reset-var-confirm'] = 'Herstel <i>{0}</i> na verstek?';
$string['js-styles-saved'] = 'Style is suksesvol geberg!';
$string['js-styles-saved-error'] = '\'n Fout het voorgekom terwyl die style geberg is.';
$string['keep_variables'] = 'Hou veranderlikewaardes waar moontlik tussen temas';
$string['layoutheading'] = 'Uitlegopsies';
$string['left'] = 'Links';
$string['linkedin'] = 'LinkedIn-URL';
$string['linkedindesc'] = 'Voer die URL van jou LinkedIn-profiel in (d.w.s. http://www.linkedin.com/company/mycollege)';
$string['loginheaderimage'] = 'Hofieprent van Intekenboks';
$string['loginheaderimagedesc'] = 'As \'n prent opgelaai is, sal dit die intekenbokshofie vervang';
$string['loginpagehasfooter'] = 'Vertoon Onderskrif';
$string['loginpagehasheader'] = 'Vertoon Hofie';
$string['loginpagehasnavigation'] = 'Vertoon Navigasie';
$string['loginpageheading'] = 'Intekenbladverstellings';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Laai assbelief jou doelgemaakte logo hier op as jy dit by die hofie wil voeg.<br>As jy \'n logo oplaai, sal dit die standaard ikoon en naam vervang wat by verstek vertoon word.';
$string['logoshowsummary'] = 'Vertoon werfopsomming onder die logo';
$string['logout'] = 'Teken uit';
$string['marketing1'] = 'Bemarkingsplek Een';
$string['marketing2'] = 'Bemarkingsplek Twee';
$string['marketing3'] = 'Bemarkingsplek Drie';
$string['marketingbuttontext'] = 'Skakelteks';
$string['marketingbuttontextdesc'] = 'Teks wat op die knoppie moet verskyn.';
$string['marketingbuttontype'] = 'Knoppietipe';
$string['marketingbuttonurl'] = 'Skakel-URL';
$string['marketingbuttonurldesc'] = 'URL waarna die knoppie sal wys.';
$string['marketingcontent'] = 'Inhoud';
$string['marketingcontentdesc'] = 'Inhoud om in die bemarkingsboks te vertoon. Hou dit kort en kragtig.';
$string['marketingdesc'] = 'Hierdie tema bied die opsie om drie "bemarking-" of "advertensieplekke" net onder die skyfievertoning te ontsper. Dit laat jou toe om kerninligting maklik aan jou gebruikers te identifiseer en direkte skakels te verskaf.';
$string['marketingheading'] = 'Bemarkingsplekke';
$string['marketingheadingsub'] = 'Drie plekke op die voorblad om inligting en skakels by te voeg.';
$string['marketingicon'] = 'Ikoon';
$string['marketingicondesc'] = 'Naam van die ikoon wat jy wil gebruik. Die lys is <a href="http://www.getuikit.com/docs/icon.html" target="_new">hier</a>. Voer net in wat ná die "ikoon-" is.';
$string['marketingimage'] = 'Prent';
$string['marketingimagedesc'] = 'Dit bied die opsie om \'n prent bokant die teks in die bemarkingsplek te vertoon';
$string['marketinginfodesc'] = 'Voer die verstellings van jou bemarkingsplek in.';
$string['marketingtitle'] = 'Titel';
$string['marketingtitledesc'] = 'Titel om in hierdie bemarkingsplek te vertoon';
$string['mdl-block-header-font-family'] = 'Fontfamilie van Hofie';
$string['mdl-block-header-font-size'] = 'Fontgrootte van Hofie';
$string['mdl-block-header-font-weight'] = 'Fontgewig van Hofie';
$string['mdl-block-header-icon-color'] = 'Hofie -Ikoonkleur';
$string['mdl-block-header-text-color'] = 'Hofie- Tekskleur';
$string['mdl-block-icon-color'] = 'Ikoonkleur van Kieslysitem';
$string['mdl-block-link-color'] = 'Kieslysitemskakel';
$string['mdl-block-link-color-hover'] = 'Kieslysitemskakelsweef';
$string['mdl-block-menu-item-font-family'] = 'Fontfamilie van Kieslysitem';
$string['mdl-block-menu-item-font-size'] = 'Fontgrootte van Kieslysitem';
$string['mdl-block-menu-item-font-weight'] = 'Fontgewig van Kieslysitem';
$string['mdl-block-text-color'] = 'Tekskleur van Kieslysitem';
$string['mdl-breadcrumb-link-color'] = 'Skakelkleur';
$string['mdl-breadcrumb-link-hover-color'] = 'Skakelsweefkleur';
$string['mdl-layout2-left-width'] = 'Flex-uitleg - Breedte van Linkerkolom';
$string['mdl-login-box-background'] = 'Agtergrond van Intekenboks';
$string['mdl-login-box-border'] = 'Intekenboksrant';
$string['mdl-login-box-width'] = 'Breedte van Intekenboks';
$string['mdl-main-region-background'] = 'Agtergrondkleur';
$string['mdl-main-region-border'] = 'Rantkleur';
$string['mdl-main-region-padding'] = 'Opvulling';
$string['mdl-marketingspot-background'] = 'Agtergrondkleur';
$string['mdl-marketingspot-border-color'] = 'Rantkleur';
$string['mdl-marketingspot-color'] = 'Tekskleur';
$string['mdl-marketingspot-title-color'] = 'Titelkleur';
$string['mdl-max-additional-frontpage-content-width'] = 'Voorbladbemarkingsarea - Maksimum breedte';
$string['mdl-max-page-content-width'] = 'Bladsyinhoud - Maksimum breedte';
$string['mdl-max-page-footer-width'] = 'Bladsyonderskrif - Maksimum breedte';
$string['mdl-max-page-header-content-width'] = 'Bladsyhofie - Maksimum breedte';
$string['mdl-max-page-navbar-content-width'] = 'Bladsynavigasie - Maksimum breedte';
$string['mdl-navbar-side-margin'] = 'Sykantlyn';
$string['mdl-page-breadcrumbs-background'] = 'Agtergrondkleur (hoofarea)';
$string['mdl-page-breadcrumbs-border'] = 'Rantkleur (hoofarea)';
$string['mdl-page-footer-background'] = 'Bladsyonderskrif - Agtergrondkleur';
$string['mdl-page-footer-background-gradient-bottom'] = 'Bladsyonderskrif - Onderste Gradiënt';
$string['mdl-page-footer-background-gradient-top'] = 'Bladsyonderskrif - Boonste Gradiënt';
$string['mdl-page-header-background'] = 'Bladsyhofie - Agtergrondkleur';
$string['mdl-page-header-background-gradient-bottom'] = 'Bladsyhofie - Onderste Gradiënt';
$string['mdl-page-header-background-gradient-top'] = 'Bladsyhofie - Boonste Gradiënt';
$string['mdl-page-header-content-padding'] = 'Bladsyhofie - Opvulling';
$string['mdl-page-navbar-background'] = 'Agtergrondkleur (boonste area)';
$string['mdl-page-navbar-border'] = 'Rantkleur (boonste area)';
$string['mdl-page-side-margin'] = 'Bladsyinhoud - Sykantlyn';
$string['mdl-page-top-margin'] = 'Bladsyinhoud - Boonste kantlyn';
$string['mdl-social-heading-color'] = 'Kleur van Sosiale Opskrifte';
$string['mdl-to-top-background'] = 'Agtergrond';
$string['mdl-to-top-background-hover'] = 'Sweefagtergrond';
$string['mdl-to-top-color'] = 'Ikoonkleur';
$string['mdl-to-top-color-hover'] = 'Sweefikoonkleur';
$string['mdl-to-top-shadow-background'] = 'Skadu';
$string['mdl-to-top-shadow-background-hover'] = 'Sweefskadu';
$string['mobileappsdesc'] = 'Het jy \'n webtoep op die App Store of Google Play Store? Verskaf \'n skakel hier, sodat jou gebruikers die toepassings aanlyn kan kry.';
$string['mobileappsheading'] = 'Mobiele Toepassings';
$string['mobileappsheadingsub'] = 'Skakel na jou Toep om jou studente met Mobiele Toestelle te bereik';
$string['myclasses'] = 'My Klasse';
$string['mycourses'] = 'My Kursusse';
$string['mycoursesinfo'] = 'Dinamiese Ingeskrewe Kursuslys';
$string['mycoursesinfodesc'] = 'Vertoon \'n dinamiese lys van ingeskrewe kursusse aan die gebruiker.';
$string['mycoursetitle'] = 'Terminologie';
$string['mycoursetitledesc'] = 'Verander die terminologie van die "My Kursusse"-skakel in die aftrekkieslys';
$string['mydashboard'] = 'My Paneelbord';
$string['mydashboardinfo'] = 'Doelgemaakte Gebruikerpaneelbord';
$string['mydashboardinfodesc'] = 'Vertoon \'n lys algemene funksies wat deur gebruikers gebruik word.';
$string['mymodules'] = 'My Modules';
$string['mysubjects'] = 'My Vakke';
$string['myunits'] = 'My Eenhede';
$string['nav-dropdown-color'] = 'Tekskleur van Aftreklys';
$string['nav-dropdown-hover-background'] = 'Agtergrondsweefkleur van Aftreklys';
$string['nav-dropdown-hover-color'] = 'Tekssweefkleur van Aftreklys';
$string['nav-dropdown-nested-color'] = 'Geneste Skakel van Aftreklys';
$string['nav-dropdown-nested-hover-color'] = 'Sweef Geneste Skakel van Aftreklys';
$string['nav-navbar-color'] = 'Aftreklysteks';
$string['nav-navbar-hover-background'] = 'Sweefagtergrond van Aftreklys';
$string['nav-navbar-hover-color'] = 'Sweefteks van Aftreklys';
$string['nav-navbar-nested-color'] = 'Geneste Skakel van Aftreklys';
$string['nav-navbar-nested-hover-color'] = 'Sweef Geneste Skakel van Aftreklys';
$string['navbar-background'] = 'Agtergrondkleur';
$string['navbar-border'] = 'Rant';
$string['navbar-border-bottom'] = 'Rant (onder)';
$string['navbar-brand-color'] = 'Tekskleur van Handelsmerk';
$string['navbar-brand-hover-color'] = 'Tekssweefkleur van Handelsmerk';
$string['navbar-color'] = 'Tekskleur';
$string['navbar-gradient-bottom'] = 'Agtergrondkleur - Onderste Gradiënt';
$string['navbar-gradient-top'] = 'Agtergrondkleur - Boonste Gradiënt';
$string['navbar-link-color'] = 'Skakelkleur';
$string['navbar-link-hover-color'] = 'Skakelsweefkleur';
$string['navbar-nav-active-background'] = 'Aktiewe Agtergrond van Elemente';
$string['navbar-nav-active-color'] = 'Aktiewe Teks van Elemente';
$string['navbar-nav-color'] = 'Teks van Elemente';
$string['navbar-nav-font-family'] = 'Fontfamilie van Elemente';
$string['navbar-nav-font-size'] = 'Fontgrootte van Elemente';
$string['navbar-nav-font-weight'] = 'Fontgewig van Elemente';
$string['navbar-nav-hover-background'] = 'Sweefagtergrond van Elemente';
$string['navbar-nav-hover-color'] = 'Sweefteks van Elemente';
$string['navbar-nav-onclick-background'] = 'Kliekagtergrond van Elemente';
$string['navbar-nav-onclick-color'] = 'Kliekteks van Elemente';
$string['navbar-text-shadow'] = 'Teksskadu';
$string['navbar-toggle-color'] = 'Navigasietokkel van Offcanvas';
$string['navbar-toggle-hover-color'] = 'Navigasietokkelsweef van Offcanvas';
$string['navigationbuttonsclass'] = 'Klas van Navigasieknoppie';
$string['navigationbuttonsclass-danger'] = 'Gevaar';
$string['navigationbuttonsclass-link'] = 'Skakel';
$string['navigationbuttonsclass-normal'] = 'Normaal';
$string['navigationbuttonsclass-primary'] = 'Primêr';
$string['navigationbuttonsclass-success'] = 'Sukses';
$string['navigationbuttonssize'] = 'Groote van Navigasieknoppies';
$string['navigationbuttonssize-large'] = 'Groot';
$string['navigationbuttonssize-mini'] = 'Mini';
$string['navigationbuttonssize-normal'] = 'Normaal';
$string['navigationbuttonssize-small'] = 'Klein';
$string['navigationtoggletext'] = 'Navigasie';
$string['nextsection'] = 'Volgende Afdeling';
$string['noenrolments'] = 'Jy het geen huidige inskrywings nie';
$string['onlytoplevelhierarchy'] = 'Vertoon kursuslys onder hul topvlakkategorie';
$string['page_description'] = 'Hierdie bladsy is om die voorkoms en gevoel van jou werf te doelmaak.';
$string['page_description_sub'] = 'Jy kan die logo, favicon en baie ander opsies hier konfigureer.';
$string['pagebackground'] = 'Agtergrondprent van Bladsy';
$string['pagebackgrounddesc'] = 'Laai jou eie bladsyagtergrondprent op. Dit sal in teëlvorm in die agtergrond van alle bladsye vertoon word.';
$string['pagenavbarcontent'] = 'Boonste Navstafie-inhoud van Bladsy';
$string['pagenavbarcontent-custom'] = 'Doelgemaak';
$string['pagenavbarcontent-dontshow'] = 'Moet nie vertoon nie';
$string['pagenavbarcontent-pageheading'] = 'Bladsyopskrif';
$string['pagenavbarcontent-pagetitle'] = 'Bladsytitel';
$string['pagenavbarcontent-sitename'] = 'Werfnaam';
$string['pagenavbarcontent-siteshortname'] = 'Kortnaam van werf';
$string['pagenavbarcontent-sitessummary'] = 'Werfopsomming';
$string['pagenavbarcustomcontent'] = 'Doelgemaakte inhoud van Bladsy se Boonste Navstafie';
$string['panel'] = 'Paneel';
$string['panel-box-background'] = 'Agtergrondkleur';
$string['panel-box-border'] = 'Boksrant';
$string['panel-box-color'] = 'Tekskleur';
$string['panel-box-padding'] = 'Boksopvulling';
$string['panel-header-title-border'] = 'Kleur van Hofieskeier';
$string['panel-header-title-padding'] = 'Opvulling van Hofieskeiding';
$string['pinterest'] = 'Pinterest-URL';
$string['pinterestdesc'] = 'Voer die URL van jou Pinterest-blad in (d.w.s. http://pinterest.com/mycollege)';
$string['pluginname'] = 'UIKit';
$string['previoussection'] = 'Vorige Afdeling';
$string['readmore'] = 'Lees Meer';
$string['refresh'] = 'Verfris';
$string['region-footer-left'] = 'Onderskrif (Links)';
$string['region-footer-middle'] = 'Onderskrif (Middel)';
$string['region-footer-right'] = 'Onderskrif (Regs)';
$string['region-hidden-dock'] = 'Van gebruikers versteek';
$string['region-home-down'] = 'Tuis (Af)';
$string['region-home-left'] = 'Tuis (Links)';
$string['region-home-middle'] = 'Tuis (Middel)';
$string['region-home-right'] = 'Tuis (Regs)';
$string['region-home-up'] = 'Tuis (Op)';
$string['region-side-post'] = 'Regs';
$string['region-side-pre'] = 'Links';
$string['reset'] = 'Herstel';
$string['reset_all'] = 'Herstel alle';
$string['right'] = 'Regs';
$string['save_styles'] = 'Berg en gebruik style';
$string['save_styles_tooltip'] = 'Berg en gebruik huidige styldoelmakings vir die werklike werf';
$string['showmoodledocs'] = 'Vertoon "Moodle-dokumente vir hierdie bladsy"-afdeling in die onderskrif.';
$string['siteicon'] = 'Werfikoon';
$string['siteicondesc'] = 'Het jy nie \'n logo nie? Voer die naam in van die ikoon wat jy wil gebruik. Die lys is <a href="http://www.getuikit.com/docs/icon.html" target="_blank">hier</a>. Voer net in wat ná die "uk-icon-" is.';
$string['skype'] = 'Skype-Rekening';
$string['skypedesc'] = 'Voer die Skype-gebruikersnaam van jou instelling se Skype-rekening in';
$string['slidecaption'] = 'Skyfiebyskrif';
$string['slidecaptionplacement'] = 'Plasing van Skyfiebyskrif';
$string['slideheader'] = 'Skyfie {$a->n}';
$string['slideimage'] = 'Skyfieprent';
$string['slideshowanimation'] = 'Animasie van Skyfievertoning';
$string['slideshowanimation-boxes'] = 'Bokse';
$string['slideshowanimation-boxes-reverse'] = 'Bokse omgekeer';
$string['slideshowanimation-fade'] = 'Verdoof';
$string['slideshowanimation-fold'] = 'Vou';
$string['slideshowanimation-puzzle'] = 'Legkaart';
$string['slideshowanimation-random-fx'] = 'Lukrake effek';
$string['slideshowanimation-scale'] = 'Skaal';
$string['slideshowanimation-scroll'] = 'Rol';
$string['slideshowanimation-slice-down'] = 'Sny na onder';
$string['slideshowanimation-slice-up'] = 'Sny na bo';
$string['slideshowanimation-slice-up-down'] = 'Sny na bo & onder';
$string['slideshowanimation-swipe'] = 'Vee';
$string['slideshowarrowscolor'] = 'Kleur van Navigasiepyle';
$string['slideshowautoplay'] = 'Ontsper outospeel';
$string['slideshowbuttontype'] = 'Skyfie se knoppietipe';
$string['slideshowcaptioncolor'] = 'Opskrifkleur van Skyfie';
$string['slideshowdesc'] = 'Dit skep \'n dinamiese skyfievertoning van tot 4 skyfies waarmee jy belangrike elemente van jou werf kan promoveer.';
$string['slideshowheading'] = 'Voorblad Skyfievertoning';
$string['slideshowheadingsub'] = 'Dinamiese Skyfievertoning vir die Voorblad';
$string['slideshowheight'] = 'Hoogte van Skyfievertoning';
$string['slideshowkenburns'] = 'Ontsper Ken Burns Effect';
$string['slideshownumber'] = 'Aantal skyfies';
$string['slideshowsizingmode'] = 'Skyfie-omvangbepalingsmodus';
$string['slideshowsizingmode-fullheight'] = 'Gebruik volle lengte';
$string['slideshowsizingmode-fullwidth'] = 'Gebruik volle breedte';
$string['slideshowtitlecolor'] = 'Kleur van Skyfietitel';
$string['slidetitle'] = 'Skyfietitel';
$string['slideurl'] = 'Skyfieknoppieskakel';
$string['slideurltext'] = 'Skyfieknoppieteks';
$string['socialdesc'] = 'Bied direkte skakels na die sosiale netwerke wat jou handelsnaam sal bevorder. Dit sal in die hofie van elke bladsy verskyn.';
$string['socialheading'] = 'Sosiale Netwerkwerk';
$string['socialheadingsub'] = 'Kom in aanraking met jou gebruikers deur Sosiale Netwerkwerk';
$string['socialnetworks'] = 'Sosiale Netwerke';
$string['stickynavigationbar'] = 'Ontsper klewerige navigasiestafie';
$string['stickynavigationbardelay'] = 'Vertraging van klewerig navigasiestafie (px)';
$string['stickynavigationbardelaydesc'] = 'Voeg \'n vertraging by die navigasiestafie, sodat dit slegs klewerig word nadat daar \'n bepaalde afstand in beeldelemente gerol is.';
$string['stickynavigationbardesc'] = 'Laat die navigasiestafie boaan die deelvenster bly';
$string['styleswritepermissionsfail'] = 'Fout: theme/uikit/styles-lêer kan nie geskryf word nie. Kontroleer asseblief dat jou webbediener skryftoestemming in hierdie lêer het.';
$string['themedesignerenabled'] = 'Temaontwerpermodus is ontsper';
$string['themelayout'] = 'Uitlegmodus';
$string['themelayout1'] = 'Roosteruitleg';
$string['themelayout2'] = 'Flex-uitleg';
$string['themelayoutdesc'] = 'Hier kan jy tussen verskillende uitlegmodusse vir hierdie tema kies.';
$string['themenavigationelementsmode'] = 'Vertoonmodus van tema-UIKit doelgemaakte kieslysitems.';
$string['themenavigationelementsmodeafter'] = 'Ná werf-doelgemaakte kieslysitems';
$string['themenavigationelementsmodebefore'] = 'Voor werf-doelgemaakte kieslysitems';
$string['togglemarketing'] = 'Tokkel vertoon van Bemarkingsplek';
$string['togglemarketingdesc'] = 'Kies of jy die drie Bemarkingsplekke wil versteek of vertoon.';
$string['toggleslideshow'] = 'Tokkel vertoon van Skyfievertoning';
$string['toggleslideshowdesc'] = 'Kies of jy die Skyfievertoning wil versteek of vertoon.';
$string['twitter'] = 'Twitter-URL';
$string['twitterdesc'] = 'Voer die URL van jou Twitter-voer in (d.w.s. http://www.twitter.com/mycollege)';
$string['uikit_not_selected'] = 'UIKit-tema is nie tans geselekteer nie.';
$string['useanalytics'] = 'Ontsper Google Analytics';
$string['useanalyticsdesc'] = 'Ontsper of versper Google Analytics-funksionaliteit.';
$string['usefrontcontent'] = 'Ontsper Voorbladinhoud';
$string['usefrontcontentdesc'] = 'Indien ontsper, sal dit boaan die voorblad se hoofboks vertoon word.';
$string['visibleadminonly'] = 'Blokke wat na die area geskuif word, sal slegs deur admins gesien word.';
$string['visualstylemanager'] = 'UIKit Visuele Stylbestuurder';
$string['vk'] = 'VKontakte-URL';
$string['vkdesc'] = 'Voer die URL van jou VKontakte-blad in (d.w.s. http://www.vk.com/mycollege)';
$string['warning_saved_styles_different_theme_version'] = 'Dit lyk asof jy doelgemaakte style van hierdie werf met \'n ou weergawe van UIKit-tema geberg het.';
$string['warning_saved_styles_different_theme_version_action'] = 'Werk asseblief die temastyle by deur na die doelmaker te gaan en op berg te kleik. Maak jou blaaierkasgeheue skoon om korrekte gedrag te verseker.';
$string['warning_theme_designer_disable'] = 'Jy kan dit hier versper.';
$string['warning_theme_designer_enabled'] = 'Temaontwerpermodus is outomaties ontsper. Maak seker dat jy temaontwerpermodus versper wanneer jy klaar is met die doelmaak van style, vir beter prestasie.';
$string['warning_variables_changed'] = 'Jy is op die punt om base-tema te verander, en sommige veranderlikes het ander waardes as die verstek.';
$string['website'] = 'Webwerf-URL';
$string['websitedesc'] = 'Voer die URL van jou eie webwerf in (d.w.s. http://www.pukunui.com)';
$string['youtube'] = 'YouTube-URL';
$string['youtubedesc'] = 'Voer die URL van jou YouTube-kanaal in (d.w.s. http://www.youtube.com/mycollege)';
