<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'datalynx', language 'zh_cn', version '4.5'.
 *
 * @package     datalynx
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '行动';
$string['actions'] = '条目操作';
$string['activate'] = '激活';
$string['addline'] = '添加 {$a}';
$string['addoptions'] = '添加选项';
$string['admin'] = '管理员';
$string['admissibleroles'] = '可接受的角色';
$string['admissibleroles_help'] = '拥有任何选定角色的用户将被团队允许。必须至少选择一个角色。';
$string['after'] = '后';
$string['alignment'] = '对准';
$string['allof'] = '全部';
$string['allowaddoption'] = '允许添加选项';
$string['allowsubscription'] = '允许手动订阅';
$string['allowsubscription_help'] = '选中此选项可使用户将自己添加到其他人创建的团队中。这可以通过 ：subscribe 标签扩展来促进，例如 [[&lt;fieldname&gt;:subscribe]]，它修改字段以在浏览模式下显示附加链接。通过单击此链接，用户可以将自己添加到特定团队中，前提是字段设置能够并且允许他们这样做。';
$string['allowunsubscription'] = '允许手动取消订阅';
$string['allowunsubscription_help'] = '选中此选项可让用户以类似于“允许手动订阅选项”的方式取消订阅其他用户的团队。如果禁用，则团队中的用户只能由创建该团队的用户删除。';
$string['alltime'] = '所有时间';
$string['alphabeticalorder'] = '编辑条目时按字母顺序对选项进行排序？';
$string['and'] = '和';
$string['andor'] = '和/或...';
$string['anyof'] = '任何';
$string['approved'] = '批准';
$string['approvednot'] = '未获批准';
$string['ascending'] = '上升';
$string['asdisplay'] = '使用显示模板';
$string['author'] = '作者';
$string['authorinfo'] = '作者信息';
$string['authorsearch'] = '作者搜索';
$string['autocompletion'] = '自动完成';
$string['autocompletion_help'] = '选择是否在编辑模式下激活自动完成。';
$string['avoidaddanddeletesimultaneously'] = '您不得在一个步骤中添加和删除选项。首先删除选项并保存，然后重命名选项并再次保存。';
$string['before'] = '以前';
$string['behavior'] = '行为';
$string['behavioradd'] = '添加行为';
$string['behaviors'] = '行为';
$string['between'] = '之间';
$string['blankfilter'] = '空白过滤器';
$string['browse'] = '浏览';
$string['columns'] = '列';
$string['comment'] = '评论';
$string['commentadd'] = '添加评论';
$string['commentbynameondate'] = '按 {$a->name} - {$a->date}';
$string['commentdelete'] = '您确定要删除此评论吗？';
$string['commentdeleted'] = '评论已删除';
$string['commentedit'] = '编辑评论';
$string['commentempty'] = '评论为空';
$string['commentinputtype'] = '评论输入类型';
$string['comments'] = '评论';
$string['commentsallow'] = '允许评论？';
$string['commentsaved'] = '评论已保存';
$string['commentsn'] = '{$a} 评论';
$string['commentsnone'] = '没有评论';
$string['completionentries'] = '（已批准）条目数';
$string['completionentriesgroup'] = '需要（已批准）条目';
$string['completionentriesgroup_help'] = '确保为上面的条目启用批准！<br />
（已批准）条目数：用户必须进行的条目。如果设置了“需要批准”：条目数仅等于批准的条目数。';
$string['configanonymousentries'] = '此开关将启用所有 datalynx 的来宾/匿名条目的可能性。您仍然需要在每个 datalynx 的设置中手动打开匿名。';
$string['configenablerssfeeds'] = '此开关将启用所有数据lynx的RSS提要的可能性。您仍然需要在每个 datalynx 的设置中手动打开馈送。';
$string['configmaxentries'] = '此值确定可以添加到 datalynx 活动的最大条目数。';
$string['configmaxfields'] = '此值确定可以添加到 datalynx 活动的最大字段数。';
$string['configmaxfilters'] = '此值确定可以添加到 datalynx 活动的最大筛选器数。';
$string['configmaxviews'] = '此值确定可以添加到 datalynx 活动的最大视图数。';
$string['confirmbehaviordelete'] = '您将要删除此字段行为！';
$string['confirmbehaviorduplicate'] = '您将要复制此字段行为！';
$string['confirmfieldgroupdelete'] = '您将要删除此字段组！';
$string['confirmfieldgroupduplicate'] = '您将要复制此字段组！';
$string['confirmrendererdelete'] = '您将要删除此字段渲染器！';
$string['confirmrendererduplicate'] = '您将要复制此字段渲染器！';
$string['contains'] = '包含';
$string['convert'] = '转换';
$string['converttoeditor'] = '转换为编辑器字段';
$string['copyof'] = '{$a}的副本';
$string['correct'] = '正确';
$string['coursevisible'] = '该课程已获得批准，已准备好供学生使用';
$string['csscode'] = 'CSS代码';
$string['cssinclude'] = '.CSS';
$string['cssincludes'] = '包括外部 CSS';
$string['csssaved'] = '已保存的 CSS';
$string['cssupload'] = '上传 CSS 文件';
$string['csvdelimiter'] = '定界符';
$string['csvenclosure'] = '外壳';
$string['csvfailed'] = '无法从 CSV 文件中读取原始数据';
$string['csvoutput'] = 'CSV 输出';
$string['csvsettings'] = '信息通信格式设置';
$string['custom'] = '自定义模板';
$string['customfilter'] = '自定义模板';
$string['customfilteradd'] = '添加自定义筛选器';
$string['customfilterandor'] = '所有选定的选项都必须是条目的一部分';
$string['customfilterandor_help'] = '如果选中，则所有选定的选项都必须是条目的一部分。';
$string['customfilternew'] = '新的自定义筛选器';
$string['customfilters'] = '自定义过滤器';
$string['customfiltersnoneindatalynx'] = '没有为此数据林克斯定义自定义筛选器。';
$string['datalynx:addinstance'] = '添加新的数据网';
$string['datalynx:approve'] = '批准未批准的条目';
$string['datalynx:comment'] = '撰写评论';
$string['datalynx:editprivilegeadmin'] = '管理员编辑访问权限';
$string['datalynx:editprivilegeguest'] = '访客编辑访问权限';
$string['datalynx:editprivilegemanager'] = '课程管理员编辑访问权限';
$string['datalynx:editprivilegestudent'] = '学生编辑访问权限';
$string['datalynx:editprivilegeteacher'] = '教师编辑访问权限';
$string['datalynx:editrestrictedfields'] = '编辑受限字段';
$string['datalynx:exportallentries'] = '导出所有条目';
$string['datalynx:exportentry'] = '导出条目';
$string['datalynx:exportownentry'] = '导出自己的条目';
$string['datalynx:managecomments'] = '管理评论';
$string['datalynx:manageentries'] = '管理条目';
$string['datalynx:managepresets'] = '管理预设';
$string['datalynx:manageratings'] = '管理评分';
$string['datalynx:managetemplates'] = '管理模板';
$string['datalynx:notifycommentadded'] = '添加评论时通知';
$string['datalynx:notifyentryadded'] = '添加条目时通知';
$string['datalynx:notifyentryapproved'] = '批准条目时通知';
$string['datalynx:notifyentrydeleted'] = '删除条目时通知';
$string['datalynx:notifyentrydisapproved'] = '未获批准条目时通知';
$string['datalynx:notifyentryupdated'] = '更新条目时通知';
$string['datalynx:notifymemberadded'] = '通知用户被添加为团队成员';
$string['datalynx:notifymemberremoved'] = '通知用户被移除团队成员';
$string['datalynx:notifyratingadded'] = '添加评分时通知';
$string['datalynx:notifyratingupdated'] = '更新评分时通知';
$string['datalynx:notifyteamupdated'] = '团队更新时通知';
$string['datalynx:presetsviewall'] = '查看所有用户的预设';
$string['datalynx:rate'] = '条目评分';
$string['datalynx:ratingsview'] = '查看评分';
$string['datalynx:ratingsviewall'] = '查看所有评分';
$string['datalynx:ratingsviewany'] = '查看任何评分';
$string['datalynx:teamsubscribe'] = '订阅/加入团队';
$string['datalynx:viewanonymousentry'] = '查看匿名条目';
$string['datalynx:viewdrafts'] = '查看草稿';
$string['datalynx:viewentry'] = '查看条目';
$string['datalynx:viewindex'] = '查看索引';
$string['datalynx:viewprivilegeadmin'] = '管理员查看访问权限';
$string['datalynx:viewprivilegeguest'] = '访客查看访问权限';
$string['datalynx:viewprivilegemanager'] = '经理查看访问权限';
$string['datalynx:viewprivilegestudent'] = '学生查看访问权限';
$string['datalynx:viewprivilegeteacher'] = '教师查看访问权限';
$string['datalynx:viewstatistics'] = '查看统计信息';
$string['datalynx:writeentry'] = '写入条目';
$string['datalynx_csssaved'] = '自定义 CSS 已保存';
$string['datalynx_jssaved'] = '自定义 JavaScript 已保存';
$string['datalynx_team_updated'] = '团队已更新';
$string['defaultbehavior'] = '默认行为';
$string['defaultfilterlabel'] = '默认筛选器 （{$a}）';
$string['defaultrenderer'] = '默认渲染器';
$string['defaultview'] = 'D';
$string['deletefieldfilterwarning'] = '警告！您正在尝试删除以下字段：{$a->fieldlist}}但是，下面列出的筛选器仍在使用其中一些字段：{$a->filterlist}您必须先手动删除这些筛选器，然后才能继续。';
$string['deletenotenrolled'] = '删除未注册用户的条目';
$string['deleteoption'] = '删除？';
$string['deletetag'] = '删除标签';
$string['deletingbehavior'] = '删除字段行为“{$a}”';
$string['deletingfieldgroup'] = '删除字段组“{$a}”';
$string['deletingrenderer'] = '删除字段渲染器“{$a}”';
$string['descending'] = '降序';
$string['dfintervalcount'] = '间隔数';
$string['dfintervalcount_help'] = '选择应解锁的间隔数';
$string['dflateallow'] = '延迟的帖子';
$string['dflateuse'] = '允许延迟发布';
$string['dfratingactivity'] = '活动评分';
$string['dftimeavailable'] = '可从';
$string['dftimedue'] = '因为';
$string['dftimeinterval'] = '暂停直到下一个条目解锁';
$string['dftimeinterval_help'] = '选择为用户解锁下一个条目之前的时间间隔';
$string['dfupdatefailed'] = '无法更新数据！';
$string['disabled'] = '显示禁用的元素';
$string['disapproved'] = '未获批准';
$string['displaytemplate'] = '显示模板';
$string['displaytemplate_help'] = '指定 HTML 模板以在浏览模式下替换字段标记。要指定实际值的位置，请在模板中使用#value标记。';
$string['documenttype'] = '文档类型';
$string['dots'] = '...';
$string['download'] = '下载';
$string['duplicatename'] = '此名称已存在。请选择另一个。';
$string['duplicatingbehavior'] = '复制字段行为“{$a}”';
$string['duplicatingfieldgroup'] = '复制字段组“{$a}”';
$string['duplicatingrenderer'] = '复制字段渲染器“{$a}”';
$string['editable'] = '可编辑';
$string['editableby'] = '编辑者';
$string['editableby_help'] = '具有这些查看权限的用户可以编辑此字段，您可以将这些权限分配给多个角色。';
$string['editing'] = '编辑';
$string['editingbehavior'] = '编辑字段行为“{$a}”';
$string['editingfieldgroup'] = '正在编辑字段组“{$a}”';
$string['editingrenderer'] = '编辑字段渲染器“{$a}”';
$string['editmode'] = '编辑模式';
$string['editordisable'] = '禁用编辑器';
$string['editorenable'] = '启用编辑器';
$string['edittemplate'] = '编辑模板';
$string['edittemplate_help'] = '指定 HTML 模板以在编辑模式下替换字段标记。要指定实际输入元素的位置，请在模板中使用#input标签。';
$string['email'] = '电子邮件';
$string['embed'] = '嵌入';
$string['empty'] = '空';
$string['enabled'] = '启用';
$string['entries'] = '条目';
$string['entriesadded'] = '{$a} 已添加条目';
$string['entriesanonymous'] = '允许匿名条目';
$string['entriesappended'] = '{$a} 附加条目';
$string['entriesapproved'] = '{$a} 条目已批准';
$string['entriesconfirmadd'] = '您将要复制 {$a} 个条目。是否要继续？';
$string['entriesconfirmapprove'] = '您将要批准 {$a} 个条目。是否要继续？';
$string['entriesconfirmdelete'] = '您将要删除 {$a} 条目。是否要继续？';
$string['entriesconfirmduplicate'] = '您将要复制 {$a} 个条目。是否要继续？';
$string['entriesconfirmupdate'] = '您将要更新 {$a} 条目。是否要继续？';
$string['entriescount'] = '{$a} 条目';
$string['entriesdeleteall'] = '删除所有条目';
$string['entriesdeleted'] = '{$a} 条目已删除';
$string['entriesdisapproved'] = '{$a} 条目未获批准';
$string['entriesduplicated'] = '{$a} 条目重复';
$string['entriesfound'] = '找到 {$a} 个条目';
$string['entriesimport'] = '导入条目';
$string['entrieslefttoadd'] = '必须添加 {$a} 个条目才能完成此活动';
$string['entrieslefttoaddtoview'] = '必须先添加 {$a} 个条目，然后才能查看其他参与者的条目。';
$string['entriesmax'] = '最大条目数';
$string['entriesmax_help'] = '允许的条目数，-1 允许无限次输入';
$string['entriesnotsaved'] = '未保存任何条目。请检查上传文件的格式。';
$string['entriespending'] = '待定';
$string['entriesrequired'] = '必填条目';
$string['entriessaved'] = '{$a} 条目已保存';
$string['entriestoview'] = '查看前需要的条目';
$string['entriesupdated'] = '{$a} 条目已更新';
$string['entry'] = '条目';
$string['entryaddmultinew'] = '添加新条目';
$string['entryaddnew'] = '添加新条目';
$string['entryauthor'] = '条目作者';
$string['entryidzerofill'] = '带有 0000 的条目 ID 用于例如发票';
$string['entryinfo'] = '条目信息';
$string['entrylockonapproval'] = '批准后锁定';
$string['entrylockoncomments'] = '评论后锁定';
$string['entrylockonratings'] = '评分后锁定';
$string['entrylocks'] = '条目锁';
$string['entrynew'] = '新条目';
$string['entrynoneforaction'] = '未找到所请求操作的条目';
$string['entrynoneindatalynx'] = 'datalynx 中没有条目';
$string['entryrating'] = '条目评分';
$string['entrysaved'] = '您的输入已保存';
$string['entrysettings'] = '条目设置';
$string['entrysettingsupdated'] = '条目设置已更新';
$string['entrytemplate'] = '条目模板';
$string['entrytemplate_help'] = '条目模板';
$string['entrytimelimit'] = '编辑时间限制（分钟）';
$string['entrytimelimit_help'] = '禁用编辑前的分钟数，-1 设置无限制';
$string['equal'] = '平等';
$string['event_comment_created'] = '已创建评论';
$string['event_entry_approved'] = '条目获批';
$string['event_entry_created'] = '已创建条目';
$string['event_entry_deleted'] = '已删除条目';
$string['event_entry_disapproved'] = '条目未获批准';
$string['event_entry_updated'] = '条目已更新';
$string['event_rating_added'] = '已添加评分';
$string['event_rating_deleted'] = '评级已删除';
$string['event_rating_updated'] = '评分已更新';
$string['event_team_updated'] = '团队已更新';
$string['eventsettings'] = '事件设置';
$string['exactly'] = '完全';
$string['existingoptions'] = '编辑现有选项';
$string['export'] = '导出';
$string['exportadd'] = '添加新的“导出”视图';
$string['exportall'] = '全部导出';
$string['exportcontent'] = '导出内容';
$string['exportnoneindatalynx'] = '没有为此Datalynx定义导出。';
$string['exportpage'] = '导出页面';
$string['field'] = '字段';
$string['fieldadd'] = '添加字段';
$string['fieldallowautolink'] = '允许自动链接';
$string['fieldattributes'] = '字段属性';
$string['fieldcreate'] = '创建新字段';
$string['fielddescription'] = '字段描述';
$string['fieldedit'] = '正在编辑“{$a}”';
$string['fieldeditable'] = '编辑';
$string['fieldedits'] = '编辑次数';
$string['fieldgroupfields'] = '字段组字段';
$string['fieldgroupfields_help'] = '作为一个组重复的字段。字段的顺序按字母顺序排列，以便根据您的偏好对字段进行适当命名';
$string['fieldgroups'] = '字段组';
$string['fieldgroupsadd'] = '添加字段组';
$string['fieldids'] = '字段标识';
$string['fieldlabel'] = '字段标签';
$string['fieldlabel_help'] = '字段标签允许指定可以通过[[fieldname@]]字段模式添加到视图中的指定字段标签。此字段模式观察字段可见性，如果字段设置为隐藏，则隐藏该字段模式。字段标签还可以用作字段显示模板，如果包含在标签中，它将解释该字段的模式。例如，如果数字字段名为“数字”，字段标签定义为“您已获得 [[NUMBER]] 学分”，如果条目的数字值为 47，则模式 [[Number@]] 将显示为“您已获得 47 个学分”。';
$string['fieldlist'] = '可搜索字段';
$string['fieldmappings'] = '字段映射';
$string['fieldname'] = '字段名称';
$string['fieldnew'] = '新建 {$a} 字段';
$string['fieldnoneforaction'] = '未找到所请求操作的字段';
$string['fieldnoneindatalynx'] = '没有为此Datalyx定义字段。';
$string['fieldnonematching'] = '找不到匹配的字段';
$string['fieldnotmatched'] = '您文件中的以下字段在此 datalynx 中是未知的：{$a}';
$string['fieldoptions'] = '选项（每行一个）';
$string['fieldoptionsdefault'] = '默认值（每行一个）';
$string['fieldoptionsseparator'] = '选项分隔符';
$string['fieldrequired'] = '必须在此处提供一个值。';
$string['fieldrules'] = '字段编辑规则';
$string['fields'] = '字段';
$string['fieldsadded'] = '添加的字段';
$string['fieldsconfirmdelete'] = '您将要删除 {$a} 字段。是否要继续？';
$string['fieldsconfirmduplicate'] = '您将要复制 {$a} 字段。是否要继续？';
$string['fieldsdeleted'] = '已删除字段。您可能需要更新默认排序设置。';
$string['fieldsimportsettings'] = '导入设置';
$string['fieldsmax'] = '最大字段数';
$string['fieldsnonedefined'] = '未定义字段';
$string['fieldsupdated'] = '字段已更新';
$string['fieldtype'] = '字段类型';
$string['fieldvisibility'] = '可见于';
$string['fieldvisibleall'] = '每个人';
$string['fieldvisiblenone'] = '仅限经理';
$string['fieldvisibleowner'] = '所有者和经理';
$string['fieldwidth'] = '宽度';
$string['fileexist'] = '存在';
$string['filemaxsize'] = '已上传文件的总大小';
$string['filemissing'] = '丢失';
$string['filesmax'] = '上传文件的最大数量';
$string['filetypeany'] = '任何文件类型';
$string['filetypeaudio'] = '音频文件';
$string['filetypegif'] = '动图文件';
$string['filetypehtml'] = '网页文件';
$string['filetypeimage'] = '图像文件';
$string['filetypejpg'] = 'JPG 文件';
$string['filetypepng'] = 'PNG 文件';
$string['filetypes'] = '接受的文件类型';
$string['filetypevideo'] = '视频文件';
$string['filter'] = '筛选器';
$string['filteradd'] = '添加筛选器';
$string['filteradvanced'] = '自定义筛选器';
$string['filterbypage'] = '按页';
$string['filtercancel'] = '取消筛选器';
$string['filtercreate'] = '创建新筛选器';
$string['filtercurrent'] = '当前筛选器';
$string['filtercustomsearch'] = '搜索选项';
$string['filtercustomsort'] = '排序选项';
$string['filterdescription'] = '筛选器说明';
$string['filteredit'] = '正在编辑“{$a}”';
$string['filterformadd'] = '添加新的筛选器窗体';
$string['filterforms'] = '筛选表单';
$string['filtergroupby'] = '分组依据';
$string['filterincomplete'] = '必须完成搜索条件。';
$string['filtermy'] = '我的筛选器';
$string['filtername'] = 'Datalynx自动链接';
$string['filternew'] = '新筛选器';
$string['filternoneforaction'] = '未找到所请求操作的筛选器';
$string['filterperpage'] = '每页';
$string['filters'] = '筛选器';
$string['filtersadded'] = '已添加 {$a} 个筛选器';
$string['filtersave'] = '保存筛选器';
$string['filtersconfirmdelete'] = '您将要删除 {$a} 筛选器。是否要继续？';
$string['filtersconfirmduplicate'] = '您将要复制 {$a} 个筛选器。是否要继续？';
$string['filtersdeleted'] = '{$a} 已删除筛选器';
$string['filtersduplicated'] = '{$a} 筛选器重复';
$string['filtersearchfieldlabel'] = '搜索字段';
$string['filterselection'] = '选择';
$string['filtersimplesearch'] = '简单搜索';
$string['filtersmax'] = '最大筛选器数量';
$string['filtersnonedefined'] = '未定义筛选器';
$string['filtersnoneindatalynx'] = '没有为此 datalynx定义过滤器。';
$string['filtersortfieldlabel'] = '排序字段';
$string['filtersupdated'] = '{$a} 筛选器已更新';
$string['filterupdate'] = '更新现有筛选器';
$string['filterurlquery'] = '网址查询';
$string['filteruserreset'] = '** 重置我的过滤器';
$string['first'] = '第一';
$string['firstdayofweek'] = '星期一';
$string['formemptyadd'] = '您没有填写任何字段！';
$string['fromdate'] = '开始日期';
$string['fromfile'] = '从压缩文件导入';
$string['fulltextsearch'] = '全文搜索';
$string['generalactions'] = '常规操作';
$string['grade'] = '评分';
$string['gradeinputtype'] = '评分输入类型';
$string['gradeitem'] = '评分项';
$string['grading'] = '评分';
$string['gradingmethod'] = '评分方法';
$string['gradingsettings'] = '作业评分设置';
$string['greater_equal'] = '大于或等于';
$string['groupentries'] = '组条目';
$string['groupinfo'] = '组信息';
$string['guest'] = '访客';
$string['headercss'] = '适用于所有视图的自定义 CSS 样式';
$string['headerjs'] = '适用于所有视图的自定义 JavaScript';
$string['hidden'] = '隐藏';
$string['hideline'] = '隐藏最后一行';
$string['horizontal'] = '水平';
$string['iamteammember'] = '我是团队成员';
$string['id'] = 'ID';
$string['import'] = '导入';
$string['importadd'] = '添加一个新导入窗口';
$string['importnoneindatalynx'] = '这个Datalynx没有定义导入';
$string['incorrect'] = '不正确';
$string['index'] = '索引';
$string['insufficiententries'] = '查看这个Datalynx需要更多的条目';
$string['internal'] = '内部';
$string['intro'] = '介绍';
$string['invalidname'] = '请为{$a}选择一个其他的名字';
$string['invalidrate'] = '不能接受的 datalynx 评分 ({$a})';
$string['invalidurl'] = '刚输入的URL不对';
$string['is'] = 'IS';
$string['isdefault'] = '默认视图';
$string['isedit'] = '编辑视图';
$string['ismore'] = '细节视图';
$string['jscode'] = 'Javascrip代码';
$string['jsinclude'] = 'JS';
$string['jsincludes'] = '包括外部了的javascript';
$string['jssaved'] = 'Javascript已保存';
$string['jsupload'] = '上传javascript文件';
$string['label'] = '标签';
$string['less_equal'] = '少于或等于';
$string['less_than'] = '少于';
$string['limitchoice'] = '限制用户选择';
$string['limitchoice_help'] = '启用此选项可防止用户在单独的条目中选择的相同选项超过所选数字。';
$string['line'] = '线';
$string['linksettings'] = '邮件链接设置';
$string['linktoentry'] = '邮件链接设置';
$string['listformat'] = '列表格式';
$string['lock'] = '锁';
$string['manage'] = '管理';
$string['managemode'] = '管理模式';
$string['manager'] = '经理';
$string['mappingwarning'] = '所有未映射到新字段的旧字段都将丢失，并且该字段中的所有数据都将被删除。';
$string['max'] = '最大';
$string['maxsize'] = '最大尺寸';
$string['me'] = '我';
$string['mediafile'] = '媒体文件';
$string['mentor'] = '导师';
$string['message_comment_created'] = '你好，{$a->fullname}，

以下注释由{$a->senderprofilelink}添加到此条目：{$a->viewlink}：


{$a->commenttext}';
$string['message_entry_approved'] = '你好{$a->fullname}，

{$a->datalynxlink}中的内容已被{$a->senderprofilelink}批准。

以下条目已获批准：{$a->viewlink}。';
$string['message_entry_created'] = '你好{$a->fullname}，

{$a->datalynxlink} 中的内容已被 {$a->senderprofilelink} 修改。

已创建以下条目：{$a->viewlink}。';
$string['message_entry_deleted'] = '你好{$a->fullname}，

{$a->datalynxlink} 中的内容已被 {$a->senderprofilelink} 修改。

已删除条目。';
$string['message_entry_disapproved'] = '你好{$a->fullname}，

{$a->datalynxlink} 中的内容已被 {$a->senderprofilelink} 修改。

以下条目已被停用：{$a->viewlink}。';
$string['message_entry_updated'] = '你好{$a->fullname}，

{$a->datalynxlink} 中的内容已被 {$a->senderprofilelink} 修改。

以下条目已更新：{$a->viewlink}。';
$string['message_rating_added'] = '添加了评分';
$string['message_rating_updated'] = '评分已更新';
$string['message_team_updated'] = '亲爱的 {$a->fullname}，

{$a->fieldname} 成员资格已被 {$a->senderprofilelink} 更改。请访问 {$a->viewlink} 了解更多详情。';
$string['messageprovider:event_comment_created'] = '已创建注释';
$string['messageprovider:event_entry_approved'] = '条目已获批准';
$string['messageprovider:event_entry_created'] = '已创建条目';
$string['messageprovider:event_entry_deleted'] = '已删除条目';
$string['messageprovider:event_entry_disapproved'] = '条目已批准';
$string['messageprovider:event_entry_updated'] = '条目已更新';
$string['messageprovider:event_rating_added'] = '已添加评分';
$string['messageprovider:event_rating_updated'] = '评分已更新';
$string['messageprovider:event_team_updated'] = '条目团队更新';
$string['min'] = '最低';
$string['minteamsize'] = '最小团队规模';
$string['minteamsize_help'] = '在此处输入允许的最小团队成员数。';
$string['modearray'] = '显示模式';
$string['modearray_help'] = '“结束”日期在 23：59：59 之前始终被视为可用。';
$string['modulename'] = 'Datalynx';
$string['modulename_help'] = 'datalynx模块可用于创建广泛的活动/资源，允许教师/经理从各种输入元素（例如文本，数字，图像，文件，URL等）设计和创建自定义内容表单，以及参与者提交内容和查看提交的内容。';
$string['modulenameplural'] = 'Datalynxs';
$string['more'] = '更多';
$string['moreresults'] = '（{$a} 更多结果...';
$string['movezipfailed'] = '无法移动zip';
$string['multiapprove'] = '批准';
$string['multidelete'] = '删除';
$string['multidownload'] = '下载';
$string['multiduplicate'] = '重复';
$string['multiedit'] = '编辑';
$string['multiexport'] = '导出';
$string['multipletags'] = '找到多个标签！视图未保存';
$string['multiselect'] = '多选';
$string['multishare'] = '共享';
$string['newbehavior'] = '新字段行为';
$string['newfieldgroup'] = '新建字段组';
$string['newfilterform'] = '新筛选器窗体';
$string['newrenderer'] = '新的字段渲染器';
$string['newvalue'] = '新值';
$string['newvalueallow'] = '允许新值';
$string['noaccess'] = '您无权访问此页面';
$string['noautocompletion'] = '无自动完成';
$string['nocustomfilter'] = '编程错误 [nocustomfilter]。请联系您的支持人员。';
$string['nodatalynxs'] = '未找到 Datalynx 模块';
$string['noedit'] = '不可编辑';
$string['noentries'] = '没有要显示的条目。';
$string['nomatch'] = '找不到匹配的条目！';
$string['nomatchingentries'] = '选择的筛选器没有匹配的条目';
$string['nomaximum'] = '没有最大';
$string['nooptions'] = '至少需要指定一个选项';
$string['nopermission'] = '没有权限查看特定的条目';
$string['noselection'] = '未选择任何内容';
$string['nosuchentries'] = '没有可用的条目。';
$string['not'] = 'NOT';
$string['notallowedtoeditentry'] = '不允许编辑此条目。';
$string['notapproved'] = '条目尚未获批准。';
$string['noteditable'] = '不可编辑时';
$string['notemplate'] = '无模板';
$string['notificationenable'] = '启用通知';
$string['notifyteam'] = '通知规则';
$string['notifyteam_help'] = '选择要应用于在此字段中选择的所有团队成员的通知规则。';
$string['notifyteammembers'] = '通知团队成员';
$string['notifyteammembers_help'] = '选择此选项可通知团队成员其成员身份状态更改。';
$string['notinjectivemap'] = '不是注入映射';
$string['notopenyet'] = '抱歉，此活动在 {$a} 之前不可用';
$string['notrequired'] = '不需要';
$string['notvisible'] = '不可见时';
$string['novalue'] = '空时';
$string['noviewsavailable'] = '无可用视图';
$string['numapprovedentries'] = '批准的条目数量';
$string['numberrssarticles'] = 'RSS 文章';
$string['numcharsallowed'] = '字符数';
$string['numdeletedentries'] = '已删除条目数';
$string['nummax'] = '最大重复次数';
$string['numrequired'] = '所需的重复次数';
$string['numshowdefault'] = '显示重复';
$string['numtotalentries'] = '创建的条目数';
$string['numvisits'] = '访问次数';
$string['ondate'] = '日期';
$string['onefieldrequired'] = '抱歉，您必须向字段组添加至少一个字段。';
$string['option'] = '选项';
$string['optionaldescription'] = '简短描述（可选）';
$string['optionalfilename'] = '文件名（可选）';
$string['or'] = 'OR';
$string['other'] = '其他';
$string['otheruser'] = '其他用户';
$string['overwrite'] = '改写';
$string['overwritesettings'] = '覆盖当前设置';
$string['page-mod-datalynx-x'] = '任何 datalynx 活动模块页面';
$string['pagesize'] = '每页条目数';
$string['pagingbar'] = '分页栏';
$string['pagingnextslide'] = '下一张幻灯片';
$string['pagingpreviousslide'] = '上一张幻灯片';
$string['participants'] = '参与者';
$string['period'] = '时期';
$string['pleaseaddsome'] = '请在下面创建一些或{$a}以开始使用。';
$string['pluginadministration'] = '活动管理';
$string['pluginname'] = 'Datalynx';
$string['porttypeblank'] = '空白条目';
$string['porttypecsv'] = 'CSV';
$string['presetadd'] = '添加预设';
$string['presetapply'] = '应用';
$string['presetavailableincourse'] = '课程预设';
$string['presetavailableinsite'] = '网站预设';
$string['presetchoose'] = '选择预设';
$string['presetdata'] = '使用用户数据';
$string['presetdataanon'] = '匿名化使用用户数据';
$string['presetfaileddelete'] = '删除预设时出错！';
$string['presetfromdatalynx'] = '对此数据进行预设';
$string['presetfromfile'] = '从文件上传预设';
$string['presetimportsuccess'] = '已成功应用预设。';
$string['presetinfo'] = '另存为预设将发布此视图。其他用户可以在他们的 datalynx 中使用它。';
$string['presetmap'] = '地图字段';
$string['presetnodata'] = '没有用户数据';
$string['presetnodefinedfields'] = '新预设没有定义的字段！';
$string['presetnodefinedviews'] = '新预设没有定义的视图！';
$string['presetnoneavailable'] = '没有要显示的可用预设';
$string['presetplugin'] = '插入式';
$string['presetrefreshlist'] = '刷新列表';
$string['presets'] = '预设';
$string['presetshare'] = '共享';
$string['presetsharesuccess'] = '已成功保存。您的预设现在将在整个站点中可用。';
$string['presetsource'] = '预设源';
$string['presetusestandard'] = '使用预设';
$string['privacy:metadata:datalynx_contents'] = '表示在 datalynx 实例中写入的一个字段的内容。';
$string['privacy:metadata:datalynx_contents:content'] = '内容';
$string['privacy:metadata:datalynx_contents:content1'] = '附加内容 1';
$string['privacy:metadata:datalynx_contents:content2'] = '附加内容 2';
$string['privacy:metadata:datalynx_contents:content3'] = '附加内容 3';
$string['privacy:metadata:datalynx_contents:content4'] = '附加内容 4';
$string['privacy:metadata:datalynx_contents:fieldid'] = '字段定义标识';
$string['privacy:metadata:datalynx_entries'] = '表示Datalynx实例中的条目。';
$string['privacy:metadata:datalynx_entries:approved'] = '审批状态';
$string['privacy:metadata:datalynx_entries:assessed'] = '显示是否评估了条目';
$string['privacy:metadata:datalynx_entries:groupid'] = '组';
$string['privacy:metadata:datalynx_entries:status'] = '此条目的状态';
$string['privacy:metadata:datalynx_entries:timecreated'] = '创建记录的时间';
$string['privacy:metadata:datalynx_entries:timemodified'] = '上次修改记录的时间';
$string['privacy:metadata:datalynx_entries:userid'] = '创建记录的用户';
$string['privacy:metadata:filepurpose'] = '附加到 datalynx 实例的文件或图片。';
$string['random'] = '随机';
$string['randomone'] = '一个随机';
$string['rate'] = '范围';
$string['rating'] = '评分';
$string['ratingmanual'] = '手动';
$string['ratingmethod'] = '评分方法';
$string['ratingno'] = '没有评分';
$string['ratingpublic'] = '{$a} 可以看到每个人的评分';
$string['ratingpublicnot'] = '{$a}只能看到自己的评分';
$string['ratings'] = '评分';
$string['ratingsavg'] = '平均分';
$string['ratingscount'] = '评分数';
$string['ratingsmax'] = '最高评分';
$string['ratingsmin'] = '最低评分';
$string['ratingsnone'] = '---';
$string['ratingssaved'] = '已保存的评分';
$string['ratingssum'] = '评级总和';
$string['ratingsview'] = '查看评分';
$string['ratingsviewrate'] = '查看和评价';
$string['ratingvalue'] = '评分值';
$string['redirectsettings'] = '重定向提交选项';
$string['redirectsettings_help'] = '使用此字段可以指定浏览器在离开编辑视图时应重定向到哪个视图。';
$string['redirectto'] = '目标视图';
$string['reference'] = '参考';
$string['referencefield'] = '引用字段';
$string['referencefield_help'] = '选择要用作重复预防字段的字段。这将跳过为已具有与正在批准的条目相同的字段值的已批准条目的用户创建条目。';
$string['renameoption'] = '重命名为：';
$string['renderer'] = '渲染';
$string['rendereradd'] = '添加渲染器';
$string['renderers'] = '渲染器';
$string['requireapproval'] = '需要批准？';
$string['required'] = '必填';
$string['requiredall'] = '全部需要';
$string['requirednotall'] = '并非全部需要';
$string['resetsettings'] = '重置筛选器';
$string['returntoimport'] = '返回导入';
$string['rssglobaldisabled'] = '禁用。请参阅站点配置变量。';
$string['rsshowmany'] = '（要显示的最新条目数，0 表示禁用 RSS）';
$string['rsstemplate'] = 'RSS 模板';
$string['rsstitletemplate'] = 'RSS 标题模板';
$string['rule'] = '规则';
$string['ruleaction'] = '规则操作';
$string['ruleadd'] = '添加规则';
$string['rulecancel'] = '取消规则';
$string['rulecondition'] = '取消规则';
$string['rulecreate'] = '创建新规则';
$string['ruledenydelete'] = '防止条目删除';
$string['ruledenyedit'] = '阻止条目编辑';
$string['ruledenyview'] = '对所有人隐藏条目';
$string['ruledenyviewbyother'] = '对除所有者以外的所有人隐藏条目';
$string['ruledescription'] = '规则说明';
$string['ruleedit'] = '正在编辑“{$a}”';
$string['ruleenabled'] = '启用';
$string['rulename'] = '自动链接';
$string['rulenew'] = '新的 {$a} 规则';
$string['rulenoneforaction'] = '未找到所请求操作的规则';
$string['rules'] = '规则';
$string['rulesadded'] = '{$a} 已添加规则';
$string['rulesave'] = '保存规则';
$string['rulesconfirmdelete'] = '您将要删除 {$a} 条规则。是否要继续？';
$string['rulesconfirmduplicate'] = '您将要复制 {$a} 条规则。是否要继续？';
$string['rulesdeleted'] = '{$a} 已删除规则';
$string['rulesduplicated'] = '{$a} 规则重复';
$string['rulesmax'] = '最大规则数';
$string['rulesnonedefined'] = '未定义规则';
$string['rulesnoneindatalynx'] = '没有为此数据林克斯定义任何规则。';
$string['rulesupdated'] = '{$a} 规则已更新';
$string['ruleupdate'] = '更新现有规则';
$string['saveasstandardtags'] = '将标签保存为标准标签，以便在添加或更新条目时建议它们？';
$string['savecontinue'] = '保存并继续';
$string['search'] = '搜索';
$string['search:activity'] = 'Datalynx - 实例';
$string['search:entry'] = 'Datalynx - 条目';
$string['selectuser'] = '选择用户...';
$string['sendinratings'] = '发送我的最新评分';
$string['separateentries'] = '单独文件中的每个条目';
$string['separateparticipants'] = '单独的参与者';
$string['setdefault'] = '设置为默认视图';
$string['setedit'] = '设置为编辑视图';
$string['setmore'] = '设置为详细视图';
$string['settings'] = '设置';
$string['showall'] = '显示所有条目';
$string['shownothing'] = '不显示任何内容';
$string['sortable'] = '可排序';
$string['spreadsheettype'] = '电子表格类型';
$string['statistics'] = '统计';
$string['statisticsfor'] = '“{$a}”的统计信息';
$string['status'] = '状态';
$string['statusrequired'] = '必须设置状态！';
$string['student'] = '学生';
$string['submission'] = '提交';
$string['submissionsinpopup'] = '弹出窗口中的提交';
$string['submissionsview'] = '提交视图';
$string['subplugintype_datalynxfield'] = '字段类型';
$string['subplugintype_datalynxfield_plural'] = '字段类型';
$string['subplugintype_datalynxrule'] = '规则类型';
$string['subplugintype_datalynxrule_plural'] = '规则类型';
$string['subplugintype_datalynxtool'] = '工具类型';
$string['subplugintype_datalynxtool_plural'] = '工具类型';
$string['subplugintype_datalynxview'] = '视图类型';
$string['subplugintype_datalynxview_plural'] = '视图类型';
$string['subscribe'] = '订阅';
$string['tagarea_datalynx_contents'] = '条目';
$string['tagcollection_datalynx'] = '标签';
$string['tagproperties'] = '{$a->tagtype} 标签属性： {$a->tagname}';
$string['targetviewforroles'] = '链接角色的目标视图';
$string['teacher'] = '教师';
$string['teachersandstudents'] = '{$a->teachers} 和 {$a->students}';
$string['teamfield'] = '团队字段';
$string['teamfield_help'] = '选中此框可将此字段指定为团队字段。批准指定团队的条目时，该条目将被复制并分配给每个团队成员。每个 Datalynx 实例只能将一个字段指定为团队字段。';
$string['teammembercaneditentry'] = '允许团队成员编辑条目';
$string['teammembercaneditentry_help'] = '如果激活此选项，则添加到字段中的用户可以采用与条目作者完全相同的方式编辑条目';
$string['teammembers'] = '团队成员';
$string['teammemberselect'] = '团队成员选择字段';
$string['teammemberselectmultiple'] = '一个人只能被选为团队成员一次！';
$string['teams'] = '团队';
$string['teamsize'] = '最大团队规模';
$string['teamsize_help'] = '指定团队的最大规模。它必须是正整数。';
$string['textbox'] = '文本框';
$string['textfield'] = '文本字段';
$string['textfield_help'] = '要检索其自动完成数据的文本字段。';
$string['textfieldvalues'] = '文本字段值';
$string['thisdatalynx'] = '实例';
$string['thisfield'] = '此字段';
$string['timecreated'] = '创建时间';
$string['timemodified'] = '修改时间';
$string['timestring0'] = '从 {$a->from} 到 {$a->to}';
$string['timestring1'] = '在 {$a->from} 上';
$string['timestring2'] = '直到 {$a->to}';
$string['timestring3'] = '从 {$a->from} 到 now （{$a->now}）';
$string['timestring4'] = '直到现在 （{$a->now}）';
$string['todatalynx'] = '到这个表';
$string['todate'] = '迄今为止';
$string['toolnoneindatalynx'] = '没有为此Datalynx定义任何工具。';
$string['toolrun'] = '运行';
$string['tools'] = '工具';
$string['triggeringevent'] = '触发事件';
$string['trusttext'] = '信任文本';
$string['type'] = '类型';
$string['unique'] = '独特';
$string['unlock'] = '开锁';
$string['unsubscribe'] = '退订';
$string['unsupportedfield'] = '抱歉，字段组中尚不支持 {$a} 类型的字段。';
$string['updateexisting'] = '覆盖现有';
$string['updatefield'] = '更新现有字段';
$string['updateview'] = '更新现有视图';
$string['uploadfile'] = '要导入的文件';
$string['uploadtext'] = '要导入的文本';
$string['urlclass'] = 'CSS 类';
$string['urltarget'] = '“目标”属性';
$string['userfields'] = '用户定义的字段';
$string['userinfo'] = '用户信息';
$string['useristeammember'] = '用户是团队成员';
$string['userpref'] = '用户首选项';
$string['usersubmissions'] = '用户提交';
$string['usersubmissionsinpopup'] = '弹出窗口中的用户提交';
$string['usersubmissionsview'] = '用户提交视图';
$string['vertical'] = '垂直';
$string['view'] = '视图';
$string['viewadd'] = '添加视图';
$string['viewcharactertags'] = '字符标签';
$string['viewcreate'] = '添加视图';
$string['viewcurrent'] = '当前视图';
$string['viewcustomdays'] = '自定义刷新间隔：天';
$string['viewcustomhours'] = '自定义刷新间隔：小时';
$string['viewcustomminutes'] = '自定义刷新间隔：分钟';
$string['viewdescription'] = '视图说明';
$string['viewedit'] = '正在编辑“{$a}”';
$string['vieweditthis'] = '编辑此视图';
$string['viewfieldtags'] = '字段标记';
$string['viewfilter'] = '筛选器';
$string['viewfilteroverride'] = '筛选器覆盖';
$string['viewforedit'] = '查看“编辑”';
$string['viewformore'] = '查看“更多”';
$string['viewfoverride'] = '任何用户都可以覆盖此筛选器。';
$string['viewfoverride_help'] = '不当使用此功能可能会显示意外信息，如果使用时请注意。';
$string['viewfromdate'] = '可从以下位置查看';
$string['viewgeneral'] = '查看常规设置';
$string['viewgeneral_help'] = '查看常规设置';
$string['viewgeneraltags'] = '常规标签';
$string['viewgroupby'] = '分组依据';
$string['viewinterval'] = '何时刷新视图内容';
$string['viewintervalsettings'] = '间隔设置';
$string['viewlistfooter'] = '列表页脚';
$string['viewlistheader'] = '列表标题';
$string['viewmultiplefieldgroups'] = '不能使用多个字段组。';
$string['viewname'] = '视图名称';
$string['viewnew'] = '新建 {$a} 视图';
$string['viewnodefault'] = '未设置默认视图。选择 {$a} 列表中的一个视图作为默认视图。';
$string['viewnoneforaction'] = '未找到所请求操作的视图';
$string['viewnoneindatalynx'] = '没有为此Datalynx定义视图。';
$string['viewoptions'] = '查看选项';
$string['viewpagingfield'] = '分页字段';
$string['viewperpage'] = '每页';
$string['viewrepeatedfields'] = '不能多次使用该字段 {$a}。';
$string['viewresettodefault'] = '重置为默认值';
$string['viewreturntolist'] = '返回列表';
$string['views'] = '视图';
$string['viewsadded'] = '视图已添加';
$string['viewsconfirmdelete'] = '您将要删除 {$a} 视图。是否要继续？';
$string['viewsconfirmduplicate'] = '您将要复制 {$a} 视图。是否要继续？';
$string['viewsdeleted'] = '视图已删除';
$string['viewsectionpos'] = '节位置';
$string['viewslidepaging'] = '幻灯片分页';
$string['viewsmax'] = '最大观看次数';
$string['viewsupdated'] = '视图已更新';
$string['viewtemplate'] = '查看模板';
$string['viewtemplate_help'] = '查看模板';
$string['viewtodate'] = '可查看';
$string['viewvisibility'] = '能见度';
$string['visibility'] = '能见度';
$string['visibleto'] = '可见者';
$string['visibleto_help'] = '具有这些查看权限的用户可以看到此字段，您可以将这些权限分配给多个角色。';
$string['wrongdataid'] = '提供了错误的数据 ID';
