<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_ai_manager', language 'zh_cn', version '4.5'.
 *
 * @package     local_ai_manager
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinstance'] = '添加AI工具';
$string['addnavigationentry'] = '在导航栏上显示AI管理器配置工具入口';
$string['addnavigationentrydesc'] = '勾选后 AI管理器可通过主导航访问';
$string['ai_info_table_row_highlighted'] = '您在单击此页面链接时，突出显示的 AI 工具是当前AI管理器插件正在使用的工具。';
$string['ai_manager:manage'] = '为租户配置 AI 管理器';
$string['ai_manager:managetenants'] = '为所有租户配置 AI管理器';
$string['ai_manager:managevertexcache'] = '获取和更改 Google Vertex AI 缓存状态的配置';
$string['ai_manager:use'] = '使用AI管理器';
$string['ai_manager:viewprompts'] = '显示用户提示词';
$string['ai_manager:viewpromptsdates'] = '查看用户提示词时间戳';
$string['ai_manager:viewstatistics'] = '查看统计';
$string['ai_manager:viewtenantprompts'] = '查看已在租户上下文（课程外部）上使用的用户提示';
$string['ai_manager:viewusage'] = '查看使用信息';
$string['ai_manager:viewusernames'] = '在统计信息中查看非匿名化用户名';
$string['ai_manager:viewuserstatistics'] = '查看单个用户的统计信息';
$string['aiadministrationlink'] = 'AI 工具管理';
$string['aicourseeditheader'] = 'AI 功能';
$string['aiinfotitle'] = '租户中的 AI 工具';
$string['aiisbeingused'] = '您正在使用 AI 工具。输入的数据将被发送到外部 AI 工具。';
$string['airesponse'] = 'AI 响应';
$string['aitool'] = 'AI 工具';
$string['aitooldeleted'] = '已删除 AI 工具';
$string['aitoolsaved'] = '保存 AI 工具数据';
$string['aiwarning'] = 'AI 生成的内容应始终经过核验。';
$string['aiwarningurl'] = '有关 AI 生成内容的警告链接';
$string['aiwarningurldesc'] = '您可以指定一个 URL，其中包含有关 AI 生成内容问题的其他信息。';
$string['allowedtenants'] = '允许的租户';
$string['allowedtenantsdesc'] = '指定允许的租户列表：每行一个租户标识符。';
$string['alltime'] = '所有提示词';
$string['anonymized'] = '匿名化';
$string['apikey'] = 'API key';
$string['applyfilter'] = '应用过滤器';
$string['assignpurposes'] = '分配用途';
$string['assignrole'] = '分配角色';
$string['basicsettings'] = '基本设置';
$string['basicsettingsdesc'] = '配置 AI 管理器插件的基本设置';
$string['cachedef_googleauth'] = 'Google OAuth2 访问令牌的缓存';
$string['changeconfirmstate'] = '更改使用条款确认';
$string['changelockstate'] = '更改锁定状态';
$string['changescope'] = '更改使用范围';
$string['choosecontext'] = '选择要向用户显示的上下文';
$string['configure_instance'] = '配置 AI 工具实例';
$string['configureaitool'] = '配置 AI 工具';
$string['configurepurposes'] = '配置用途';
$string['confirm'] = '确认';
$string['confirmaitoolsusage_heading'] = 'AI 功能的使用量';
$string['confirmationstatuschanged'] = '您的确认状态已保存';
$string['confirmed'] = '已接受';
$string['confirmtermsofuse'] = '我接受使用条款';
$string['context'] = '课程/活动';
$string['contextdeleted'] = '已删除';
$string['currentlyusedaitools'] = '当前配置的 AI 工具';
$string['defaultrole'] = '默认角色';
$string['defaulttenantname'] = '默认租户';
$string['empty_api_key'] = '空 API Key';
$string['enable_ai_integration'] = '启用 AI 集成';
$string['endpoint'] = 'API 终端节点';
$string['error_confirmtermsofuse'] = '您必须确认使用条款';
$string['error_http400'] = '清理传递的选项时出错';
$string['error_http400contextmissing'] = '缺少上下文';
$string['error_http403blocked'] = '您的租户管理器已阻止您访问 AI 工具';
$string['error_http403coursesonly'] = '您无权在课程之外使用 AI 工具。';
$string['error_http403disabled'] = '您的租户管理器尚未启用 AI 工具功能';
$string['error_http403nocapability'] = '您没有使用 AI 管理器（“local/ai_manager：use”） 功能的权限';
$string['error_http403notconfirmed'] = '您尚未确认使用条款';
$string['error_http403usertype'] = '您的租户管理员已为您的用户类型禁用此用途';
$string['error_http409'] = 'itemid {$a} 已被占用';
$string['error_http429'] = '您已达到最大请求数。您只能在 {$a->period} 的时间段内发送 {$a->count} 个请求';
$string['error_limitreached'] = '您已达到此目的的最大请求数。请等待计数器重置。';
$string['error_noaitoolassignedforpurpose'] = '没有为"{$a}"目的分配 AI 工具';
$string['error_pleaseconfirm'] = '请在使用前接受它们。';
$string['error_purposenotconfigured'] = '没有为此目的配置 AI 工具。请联系您的租户管理员。';
$string['error_sendingrequestfailed'] = '向 AI 工具发送请求失败。';
$string['error_tenantdisabled'] = '未为您的租户启用 AI 工具。请联系您的租户管理员。';
$string['error_unavailable_noselection'] = '此工具仅在选择文本时可用。';
$string['error_unavailable_selection'] = '此工具仅在未选择任何文本时可用。';
$string['error_userlocked'] = '您的用户已被租户管理员锁定。';
$string['error_usernotconfirmed'] = '您尚未接受使用条款。';
$string['error_vertexai_serviceaccountjsonempty'] = '您需要粘贴在 Google Cloud Console 中创建服务帐户时下载的 JSON 文件的内容。';
$string['error_vertexai_serviceaccountjsoninvalid'] = '格式无效。必须是有效的 JSON。';
$string['error_vertexai_serviceaccountjsoninvalidmissing'] = '格式无效。缺少条目 "{$a}"。';
$string['exception_badmessageformat'] = '邮件以无效格式提交';
$string['exception_changestatusnotallowed'] = '您不能更改此用户的状态';
$string['exception_curl'] = '发生与外部 API 端点的连接错误';
$string['exception_curl28'] = 'API 处理您的请求时间过长或无法在合理时间内访问';
$string['exception_default'] = '尝试将请求发送到 AI 工具时发生常规错误';
$string['exception_editinstancedenied'] = '您不能编辑此 AI 工具 （实例）。';
$string['exception_http401'] = '由于凭据无效，对 API 的访问被拒绝';
$string['exception_http429'] = '在一定时间内向 AI 工具发送了太多或太大的请求。请稍后重试。';
$string['exception_http500'] = '发生 AI 工具的内部服务器错误';
$string['exception_instanceidmissing'] = '您必须指定 AI 工具（实例）的 ID';
$string['exception_instancenotexists'] = 'ID 为 {$a} 的 AI 工具（实例）不存在';
$string['exception_invalidpurpose'] = '无效的用途';
$string['exception_notenantmanagerrights'] = '您无权管理 AI 工具';
$string['exception_novalidconnector'] = '未指定有效的连接器';
$string['exception_retrievingaccesstoken'] = '尝试检索访问令牌时出错';
$string['exception_retrievingcachestatus'] = '尝试检索缓存状态时出错';
$string['exception_tenantaccessdenied'] = '您不得访问此租户 （{$a}）。';
$string['exception_tenantnotallowed'] = '管理员不允许租户';
$string['exception_usernotexists'] = '用户不存在';
$string['executeaction'] = '执行操作';
$string['executebulkuseractions'] = '对所选用户执行操作';
$string['female'] = '女性';
$string['filterroles'] = '筛选角色';
$string['formvalidation_editinstance_azureapiversion'] = '必须提供 Azure 资源的 api 版本';
$string['formvalidation_editinstance_azuredeploymentid'] = '您必须提供 Azure 资源的部署 ID';
$string['formvalidation_editinstance_azureresourcename'] = '您必须提供 Azure 资源的资源名称';
$string['formvalidation_editinstance_endpointnossl'] = '出于安全和数据隐私原因，只允许使用 HTTPS 端点';
$string['formvalidation_editinstance_name'] = '请插入 AI 工具的名称';
$string['formvalidation_editinstance_temperaturerange'] = '温度值必须介于 0 和 1 之间';
$string['general_information_heading'] = '一般信息';
$string['general_information_text'] = '截至目前，您的 moodle 实例不提供任何 AI 工具。但是，moodle 实例提供了可以在 moodle 实例中使用 AI 工具的接口。为了使租户的所有用户都能做到这一点，租户必须获取或提供此类工具。然后，租户管理器可以通过配置页面存储访问数据，从而启用 Moodle 实例中提供的 AI 功能。';
$string['general_user_settings'] = '常规用户设置';
$string['get_ai_response_failed'] = '检索 AI 响应失败';
$string['get_ai_response_failed_desc'] = '尝试从外部 AI 工具的终端节点获取结果时发生错误';
$string['get_ai_response_succeeded'] = '已成功收到 AI 响应';
$string['get_ai_response_succeeded_desc'] = '尝试从外部 AI 工具的终端节点检索响应成功';
$string['heading_home'] = 'AI 工具集';
$string['heading_purposes'] = '用途';
$string['heading_statistics'] = '统计';
$string['infolink'] = '链接了解更多信息';
$string['instanceaddmodal_heading'] = '您要添加哪个 AI 工具？';
$string['instancedeleteconfirm'] = '您确定要删除此 AI 工具吗？';
$string['instancename'] = '内部标识符';
$string['landscape'] = 'landscape';
$string['large'] = '大';
$string['lastday'] = '过去 24 小时';
$string['lastmonth'] = '过去 30 天';
$string['lastweek'] = '最近 7 天';
$string['lock'] = '锁定';
$string['locked'] = '已锁定';
$string['male'] = '男性';
$string['max_request_time_window'] = '最大请求数的时间窗口';
$string['max_requests_purpose'] = '每个时间窗口的最大请求数 （{$a}）';
$string['max_requests_purpose_heading'] = '用途{$a}';
$string['medium'] = '中';
$string['model'] = '模型';
$string['nodata'] = '无数据可显示';
$string['noprompts'] = '没有提示词可显示';
$string['notconfirmed'] = '不接受';
$string['notselected'] = '禁用';
$string['per'] = '每个';
$string['pluginname'] = 'AI 管理器';
$string['portrait'] = 'portrait';
$string['preconfiguredmodel'] = '预配置模型';
$string['privacy_table_description'] = '在下表中，您可以看到您的学校配置的 AI 工具的概述。您的租户经理可能已在 “Info link” 列中提供了有关相应 AI 工具的使用条款和隐私声明的其他说明。';
$string['privacy_terms_description'] = '以下是有关数据隐私和使用条款的说明，其形式与您确认或仍必须确认使用 AI 功能的形式完全相同。';
$string['privacy_terms_heading'] = '隐私和使用条款';
$string['privacy_terms_missing'] = '没有指定使用条款。';
$string['privacy_terms_missing_enable_anyway'] = '无需接受其他使用条款。请确认您要为您的账户启用 AI 工具。';
$string['privilegedroles'] = '特权角色';
$string['privilegedrolesdesc'] = '其他用户（包括租户管理员）无法查看在系统上下文中具有这些角色的用户的提示词。除此之外，具有这些角色的用户的名称将在用户统计信息中匿名化。';
$string['prompt'] = '提示词';
$string['promptcompletitionfilesnotavailable'] = '生成的文件在提示词视图中不可用';
$string['promptsmodalheading'] = '上下文 {$a->>contextDisplayName} 中用户 {$a--userDisplayName} 的提示和结果';
$string['purpose'] = '用途';
$string['purposesdescription'] = '您配置的哪些 AI 工具应该用于哪个用途？';
$string['purposesheading'] = '{$a->role} 的用途（{$a->currentcount}/{$a->maxcount} 已分配）';
$string['quotaconfig'] = '限制配置';
$string['quotadescription'] = '在此处设置时间窗口和每个学生和教师的最大请求数。时间窗口到期后，请求数将自动重置。';
$string['request_count'] = '请求计数';
$string['requesttimeout'] = '对 AI 终端节点的请求超时';
$string['requesttimeoutdesc'] = '向外部 AI 终端节点发出请求的最大时间（以秒为单位）';
$string['resetfilter'] = '重置过滤器';
$string['resetuserusagetask'] = '重置 AI管理器用户使用情况数据';
$string['restricttenants'] = '锁定某些租户的访问权限';
$string['restricttenantsdesc'] = '启用此选项可将 AI 工具限制为特定租户，这些租户可由 “allowedtenants” 配置选项定义。';
$string['revokeconfirmation'] = '撤销确认';
$string['rightsconfig'] = '权限配置';
$string['role'] = '角色';
$string['role_basic'] = '基本角色';
$string['role_extended'] = '扩展角色';
$string['role_unlimited'] = '无限角色';
$string['scope'] = '使用范围';
$string['scope_courses'] = '仅在课程中';
$string['scope_everywhere'] = '到处';
$string['select_tool_for_purpose'] = '用途 {$a}';
$string['selecteduserscount'] = '已选中 {$a}';
$string['serviceaccountjson'] = 'Google 服务帐户的 JSON 文件内容';
$string['small'] = '小';
$string['squared'] = 'squared';
$string['statistics_for'] = '{$a} 的统计信息';
$string['statisticsoverview'] = '全局概览';
$string['subplugintype_aipurpose'] = 'AI 用途';
$string['subplugintype_aipurpose_plural'] = 'AI 用途集';
$string['subplugintype_aitool'] = 'AI 工具';
$string['subplugintype_aitool_plural'] = 'AI 工具集';
$string['table_heading_infolink'] = '信息链接';
$string['table_heading_instance_name'] = 'AI 工具名称';
$string['table_heading_model'] = '模型';
$string['table_heading_purpose'] = '用途';
$string['technical_function_heading'] = '技能';
$string['technical_function_step1'] = '租户管理器存储用于特定目的的配置，例如，配置映像生成的选项，因为他的租户与 OpenAI 签订了合同，因此租户可以使用 Dall-E 工具。';
$string['technical_function_step2'] = '然后，此租户的用户在 moodle 实例中找到相应的 AI 功能，例如，能够直接在编辑器中通过提示生成图像并将其插入到编辑器中。';
$string['technical_function_step3'] = '如果用户现在使用此功能，则提示将发送到 moodle 实例的服务器并由它们进行评估。';
$string['technical_function_step4'] = 'moodle 实例的服务器使用租户 AI 工具的存储访问数据，并代表用户将请求发送到外部 AI 工具的服务器。';
$string['technical_function_step4_emphasized'] = '在此过程中，moodle 实例充当外部工具的最终用户，这意味着外部工具无法跟踪哪个个人用户向 AI 工具发出了相应的请求。AI 工具只能识别用户所属的租户。';
$string['technical_function_step5'] = '来自 AI 工具的响应由 moodle 实例发送回用户，或者结果（例如生成的图像）直接集成到相应的活动中。';
$string['technical_function_text'] = '在此 moodle 实例中使用 AI 函数时，技术过程如下：';
$string['temperature_creative_balanced'] = '平衡';
$string['temperature_custom_value'] = '自定义值（介于 0 和 1 之间）';
$string['temperature_defaultsetting'] = '温度默认';
$string['temperature_desc'] = '这描述了 “随机性” 或 “创造力”。低温将生成更连贯但可预测的文本。较高的数字意味着更具创意，但不准确。范围为 0 到 1。';
$string['temperature_more_creative'] = '相当有创意';
$string['temperature_more_precise'] = '更加精确';
$string['temperature_use_custom_value'] = '使用自定义温度值';
$string['tenant'] = '租户';
$string['tenantcolumn'] = '租户列';
$string['tenantcolumndesc'] = '用户表的列，其中包含用户应与之关联的租户的标识符';
$string['tenantconfig_heading'] = '租户中的 AI';
$string['tenantdisabled'] = '禁用';
$string['tenantenabled'] = '禁用';
$string['tenantenabledescription'] = '要让您的租户用户能够访问 moodle 实例的所有 AI 功能，您需要在此处启用和配置这些功能。';
$string['tenantenablednextsteps'] = '现在，已为您的租户启用 moodle 实例的 AI 功能。请注意，您现在必须定义功能实际可用的工具和用途。<br/>所有用户都将有权访问 AI 功能。但是，通过转到 {$a} 可以禁用用户。';
$string['tenantenableheading'] = '租户中的 AI 工具';
$string['tenantnotallowed'] = '该功能已为您的租户全局禁用，因此不可用。';
$string['termsofusesetting'] = '使用条款';
$string['termsofusesettingdesc'] = '您可以在此处添加 AI管理器的特定使用条款。用户必须先接受这些，然后才能使用 AI 工具。';
$string['unconfirmed'] = '未确认';
$string['unit_count'] = '请求';
$string['unit_token'] = '令牌';
$string['unlock'] = '解锁';
$string['unlockaitools'] = '我想为我的账户解锁 AI 工具';
$string['updatelist'] = '更新列表';
$string['usage'] = '用量';
$string['use_openai_by_azure_apiversion'] = 'Azure 资源的 API 版本';
$string['use_openai_by_azure_deploymentid'] = 'Azure 资源的部署 ID';
$string['use_openai_by_azure_heading'] = '通过 Azure 使用 OpenAI';
$string['use_openai_by_azure_name'] = 'Azure 资源的名称';
$string['userconfig'] = '用户配置';
$string['userconfirmation_headline'] = '确认使用 AI 工具';
$string['userstatistics'] = '用户概述';
$string['userstatusupdated'] = '用户/用户的状态已更新';
$string['userwithusageonlyshown'] = '此表中仅显示已使用此目的的用户。';
$string['verifyssl'] = '验证 SSL 证书';
$string['verifyssldesc'] = '如果启用，则只有在可以正确验证证书时，才会建立与 AI 工具的连接。仅建议禁用用于开发使用！';
$string['vertex_cachingdisabled'] = '已禁用缓存';
$string['vertex_cachingenabled'] = '已启用缓存';
$string['vertex_disablecaching'] = '禁用缓存';
$string['vertex_enablecaching'] = '启用缓存';
$string['vertex_error_cachestatus'] = '查询/更新 Vertex AI 缓存配置时出错';
$string['vertex_nocachestatus'] = '点击 refresh 按钮，查询当前 Vertex AI 缓存状态。';
$string['vertexcachestatus'] = '查询和更改 Vertex AI 缓存状态';
$string['viewprompts'] = '查看提示词';
$string['within'] = '在';
