<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_exastud', language 'es_mx', version '4.5'.
 *
 * @package     block_exastud
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Niveau'] = 'Nivel';
$string['No_suggestions'] = 'No se encontraron sugerencias';
$string['Note'] = 'Calificación';
$string['Subjects'] = 'Asignatura';
$string['Template'] = 'Certificado';
$string['Template_and_departure'] = 'Certificado / Certificado de salida';
$string['UMan'] = 'Masculino';
$string['UWoman'] = 'Femenino';
$string['acronym'] = 'Acrónimo';
$string['add'] = 'Añadir';
$string['add_class'] = 'Añadir Clase';
$string['add_class_from_course'] = 'Añadir desde Curso';
$string['addallbasic'] = 'Añadir categorías básicas';
$string['addallbasicalways'] = 'Añadir todas las nuevas categorías básicas automáticamente';
$string['additional_head_teacher'] = 'Profesor de clase Adicional';
$string['additional_head_teachers'] = 'Profesores de clase Adicionales';
$string['additional_info'] = 'Información adicional';
$string['ags'] = 'Grupos de Trabajo';
$string['allow_review'] = 'desbloquear edición';
$string['allow_review_admin_approved'] = 'aprobado';
$string['allow_review_admin_approved_for_all'] = 'para todos';
$string['allow_review_admin_notapproved_yet'] = 'aun no aprobado';
$string['allow_review_make_request'] = 'Realizar una solicitud al administrador para desbloquear la edición.';
$string['allow_review_make_request_already'] = 'Ya solicitado para desbloquear edición';
$string['allow_review_until'] = 'hasta';
$string['allow_reviewing'] = 'Permitir revisar esta clase';
$string['already_marked'] = 'Esta clase ya está marcada/calificada';
$string['assigned_to'] = 'Asignado a {$a}';
$string['attention_admin_cannot_be_classteacher'] = 'Las clases solo se pueden definir con el rol de profesor de clase. Inicie sesión como profesor de clase para definir una clase.';
$string['attention_owner_will_change'] = 'Tenga en cuenta: si cambia el profesor de su propia clase, ¡no tendrá acceso para editar esta clase!';
$string['attention_plan_will_change'] = 'Tenga en cuenta: si se modifica el plan educativo, se deben volver a ingresar todas las calificaciones.';
$string['attention_send_message_to_classteacher'] = 'No olvides <a id="exastud_link_to_class_teacher" href="{$a->messagehref}" target="_blank">enviar un mensaje</a> al nuevo profesor de la clase sobre su nueva clase.';
$string['attention_template_will_change'] = 'Tenga en cuenta: cambiar el formato de certificado estándar cambiará el formato de certificado para todos los estudiantes.';
$string['auditleader_fieldtitle'] = 'Presidente del Comité Auditor';
$string['availablecategories'] = 'Categorías de evaluación disponibles';
$string['availableusers'] = 'Usuarios disponibles';
$string['average'] = 'Promedio';
$string['average_calculate_button'] = 'Calcular';
$string['average_calculate_table_average'] = 'Promedio';
$string['average_calculate_table_factor'] = 'Factor';
$string['average_calculate_table_grading'] = 'Calificación';
$string['average_calculate_table_student'] = 'Estudiante';
$string['average_calculate_table_subjecttype'] = 'tipo';
$string['average_calculate_table_summ'] = 'Suma';
$string['average_export_button'] = 'Exportar';
$string['average_needs_calculate'] = 'Por favor hacer el cálculo de la calificación promedio del estudiante';
$string['average_needs_calculate_for_student'] = 'Por favor, calcular la calificación promedio del estudiante {$a->studentname}.';
$string['back'] = 'Regresar';
$string['backup_description'] = 'Cree una copia de seguridad de los datos de evaluación como un archivo SQL. Como administrador, puede importar esta copia de seguridad mediante una herramienta de base de datos como phpMyAdmin. Es posible realizar copias de seguridad a nivel de profesor para sus datos individuales.';
$string['backup_go'] = 'Respaldar Base de datos ahora';
$string['badclass'] = 'Usted no puede editar esta clase';
$string['badstudent'] = 'El estudiante no es miembro de ésta clase';
$string['basiccategories'] = 'Categorías básicas';
$string['block_settings'] = 'Configuraciones';
$string['blocktitle'] = 'Revisión del Estudiante';
$string['bp_leb_always_print'] = 'Imprimir siempre';
$string['bp_shorttitle'] = 'Nombre corto';
$string['bp_title'] = 'Nombre';
$string['button_interdisciplinary_skills'] = 'Habilidades interdisciplinarias';
$string['can_not_delete_subject_teacher_because_has_grading'] = 'Los profesores de esta asignatura han calificado a esta clase en esta asignatura. No es posible eliminarlo como profesor de la asignatura. Cambie de profesor de la asignatura en este caso.';
$string['categories'] = 'Categorías de evaluación';
$string['certificate_issue_date'] = 'Fecha de Emisión del Certificado';
$string['certificate_issue_date_class'] = 'Fecha de emisión del certificado';
$string['certificate_issue_date_missed_message'] = 'Aún no se ha especificado la fecha de emisión del certificado. El administrador debe ingresar la fecha de emisión del certificado para generarlo correctamente.';
$string['clas_group_add_students'] = 'Añadir estudiantes';
$string['class'] = 'Clase';
$string['class_add_students_from_group_description'] = 'Los estudiantes de este grupo de clase (ver perfil de usuario del estudiante) se agregarán a la clase.';
$string['class_default_template'] = 'Plantilla predeterminada';
$string['class_delete'] = 'Eliminar clase';
$string['class_educationplan'] = 'Plan educativo';
$string['class_group'] = 'Grupo de clase';
$string['class_import_button'] = 'Comprobar';
$string['class_import_button_confirm'] = 'Importar ahora';
$string['class_info'] = 'Editar Clase';
$string['class_logo'] = 'Logo de clase';
$string['class_marked_as_todelete'] = 'La clase marcada para eliminar por el administrador del sitio';
$string['class_marked_as_todelete_hover'] = 'Esta classe marcada para eliminar por administrador del sitio. Clic para rehacer solicitud de eliminación.';
$string['class_owner'] = 'Profesor de clase actual';
$string['class_settings_can_edit_crosscompetencies'] = 'puede editar competencias interdisciplinarias';
$string['class_settings_can_edit_learnsocial'] = 'puede editar competencias sociales y de aprendizaje';
$string['class_settings_class_teacher'] = 'Profesor de la clase';
$string['class_settings_subject_teacher'] = 'Profesor de la asignatura';
$string['class_title_for_report'] = 'Nombre de clase en Reporte';
$string['class_title_for_report_description'] = 'Este título de la clase es usado en reportes. si el campo está vacío, en reportes se usa el título de clase de arriba';
$string['class_title_limit_message'] = 'Máx. {$a} caracteres.';
$string['classleader_fieldtitle'] = 'Titular de clase';
$string['classname'] = 'Nombre de la clase';
$string['classowner_changed_message'] = 'Usted cambió el profesor de la clase "{$a->classtitle}" a {$a->owner}. ¡Por lo tanto, a partir de ahora no tiene acceso para editar esta clase!';
$string['classteacher'] = 'Profesor de la clase';
$string['classteacher_grade_interdisciplinary_competences'] = 'Profesor titular puede editar competencias interdisciplinarias';
$string['classteacher_grade_learn_and_social_behaviour'] = 'Profesor titular puede editar Comportamiento social y Aprendizaje';
$string['clear_filter'] = 'Borrar filtros';
$string['commentshouldnotbeempty'] = 'Usted tiene que escribir un comentario';
$string['competencies'] = 'Competencias interdisciplinarias';
$string['configcategories'] = 'Categorías de evaluación en {$a}';
$string['configmember'] = 'Estudiantes de {$a}';
$string['configteacher'] = 'Profesores en {$a}';
$string['configuration_classes'] = 'Clases';
$string['configuration_classes_onlyadmin'] = 'Acceso Admin';
$string['copy_class'] = 'Copiar Clase';
$string['copy_class_from_last_period'] = 'Copiar Clase del último Período';
$string['copy_class_new_title'] = 'Copia de {$a}';
$string['cross_competences_for_head'] = 'Competencias interdisciplinarias';
$string['cross_competences_maintable_title_for_grade'] = 'Esquema de calificación: Calificación';
$string['cross_competences_maintable_title_for_points'] = 'Esquema de calificación: Puntos';
$string['cross_competences_maintable_title_for_texts'] = 'Esquema de calificación: Entrada de texto';
$string['de:Bildungsstandards'] = 'Estándares educativos que pueden cumplirse';
$string['delete'] = 'Eliminar';
$string['delete_class_only_without_users'] = 'Solamente pueden ser eliminadas clases sin estudiantes';
$string['delete_class_refused'] = 'Rechazado';
$string['delete_confirmation'] = '¿Realmente desea eliminar "{$a}"?';
$string['delete_parameter'] = 'Eliminar parámetro';
$string['delete_refuse_button'] = 'Rechazar eliminación';
$string['delete_subjectteacher_confirmation'] = '¿Está seguro de que desea eliminar este profesor de la asignatura?';
$string['detailedreview'] = 'Revisión detallada';
$string['donotleave_page_message'] = 'Tienes cambios sin guardar en esta página. ¿Quieres salir de esta página y descartar los cambios o permanecer en ella?';
$string['download'] = 'Descargar';
$string['editclasscategories'] = 'Editar categorías de evaluación';
$string['editclassmemberlist'] = 'Editar lista de estudiante';
$string['editclassname'] = 'Editar clase';
$string['editclassteacherlist'] = 'Editar lista del profesor';
$string['education_plans'] = 'Planes educativos';
$string['endtime'] = 'Fecha final';
$string['errorinsertingcategories'] = 'Ocurrió un error al añadir categorías a un curso';
$string['errorinsertingclass'] = 'Error al insertar clase';
$string['errorinsertingstudent'] = 'Ocurrió un error al insertar estudiante';
$string['errorinsertingstudents'] = 'Ocurrió un error al añadir estudiante a un curso';
$string['errorremovingcategories'] = 'Ocurrió un error al remover categorías de un curso';
$string['errorremovingstudents'] = 'Ocurrió un error al remover estudiantes de un curso';
$string['errorstarttimebeforeendtime'] = '¡El período {$a->description} tiene su hora de inicio anterior a una hora de término!';
$string['errorupdatingclass'] = 'Error al actualizar clase';
$string['errorupdatingstudent'] = 'Ocurrió un error al actualizar estudiante';
$string['evaluation'] = 'Evaluación';
$string['evaluation1'] = '1 - insuficiente';
$string['evaluation10'] = '10 - muy bien';
$string['evaluation2'] = '2';
$string['evaluation3'] = '3';
$string['evaluation4'] = '4';
$string['evaluation5'] = '5';
$string['evaluation6'] = '6';
$string['evaluation7'] = '7';
$string['evaluation8'] = '8';
$string['evaluation9'] = '8';
$string['event_classassessmentcategory_added_name'] = 'Categoría de evaluación fue añadida a  la clase';
$string['event_classassessmentcategory_deleted_name'] = 'Categoría de evaluación fue eliminada de la clase';
$string['event_classcreated_name'] = 'Clase creada';
$string['event_classdatachanged_name'] = 'Los datos de la clase fueron cambiados';
$string['event_classdeleted_name'] = 'Clase eliminada';
$string['event_classmemberassigned_name'] = 'Usuario asignado a clase';
$string['event_classmemberunassigned_name'] = 'Usuario desasignado de clase';
$string['event_classownerupdated_name'] = 'Profesor titular actualizado';
$string['event_classteacherassigned_name'] = 'Profesor asignado a clase';
$string['event_classteacherchanged_name'] = 'Profesor cambiado';
$string['event_classteacherunassigned_name'] = 'Profesor desasignado de clase';
$string['event_classupdated_name'] = 'Clase actualizada';
$string['event_competencecreated_name'] = 'Competencia creada';
$string['event_competencedeleted_name'] = 'Competencia eliminada';
$string['event_competenceupdated_name'] = 'Competencia actualizada';
$string['event_educationplancreated_name'] = 'Plan educativo creado';
$string['event_educationplandeleted_name'] = 'Plan educativo eliminado';
$string['event_educationplanupdated_name'] = 'Plan educativo actualizado';
$string['event_gradingoptioncreated_name'] = 'Opción de calificación creada';
$string['event_gradingoptiondeleted_name'] = 'Opción de calificación eliminada';
$string['event_gradingoptionupdated_name'] = 'Opción de calificación actualizada';
$string['event_periodcreated_name'] = 'Período creado';
$string['event_perioddeleted_name'] = 'Período eliminado';
$string['event_periodupdated_name'] = 'Período actualizado';
$string['event_studentdatachanged_name'] = 'Los datos del estudiante no fueron cambiados';
$string['event_studenthidden_name'] = 'Estudiante oculto';
$string['event_studentreviewcategorychanged_name'] = 'Valoración de categoría de estudiante cambiada';
$string['event_studentreviewchanged_name'] = 'Valoración de estudiante cambiada';
$string['event_studentshown_name'] = 'Estudiante mostrado';
$string['event_subjectcreated_name'] = 'Asignatura creada';
$string['event_subjectdeleted_name'] = 'Asignatura eliminado';
$string['event_subjectstudentdatachanged_name'] = 'Los datos del estudiante fueron cambiados para asignatura';
$string['event_subjectupdated_name'] = 'Asignatura actualizada';
$string['exastud:addinstance'] = 'Añadir Revision de Estudiante Exabis al curso';
$string['exastud:admin'] = 'Administrador';
$string['exastud:editperiods'] = 'Editar períodos';
$string['exastud:myaddinstance'] = 'Añadir Revision de Estudiante Exabis a Mi hogar';
$string['exastud:uploadpicture'] = 'Actualizar logo';
$string['exastud:use'] = 'Uso de Revision de Estudiante Exabis';
$string['explainclassname'] = 'Editar aquí el nombre de la clase';
$string['export_class'] = 'Respaldar datos de valoración de clase';
$string['export_class_password_message'] = 'Recuerde la contraseña "<strong>{$a}</strong>" antes de continuar';
$string['export_password_message'] = 'Recuerde la contraseña "<strong>{$a}</strong>" antes de continuar';
$string['file_is_not_class_backup'] = 'El archivo no es una copia de seguridad de una clase';
$string['file_is_wrong_format'] = 'El archivo tiene un formato incorrecto';
$string['file_not_found'] = 'Archivo no encontrado';
$string['file_not_selected'] = 'Archivo no seleccionado';
$string['file_version_wrong'] = 'Lamentablemente, el formato del archivo no es compatible con esta versión de datos de evaluación.';
$string['filter_bp'] = 'Currículo';
$string['filter_button'] = 'Filtro';
$string['filter_category'] = 'Categoría';
$string['filter_empty'] = 'Vacío';
$string['filter_fieldset'] = 'Filtro';
$string['filter_search'] = 'Buscar título';
$string['filter_show_fulltable'] = 'Mostrar tabla completa';
$string['force_class_to_delete'] = 'Solo se pueden eliminar las clases sin alumnos. Sin embargo, el administrador del sitio puede marcar esta clase para que se elimine.';
$string['form_subject_teacher_form_description'] = 'Puedes transferir la asignatura {$a->subjecttitle} a otro profesor. El profesor actual es {$a->currentteacher_name}. Todas las calificaciones de {$a->currentteacher_name} se transfieren al nuevo profesor.';
$string['form_subject_teacher_form_header'] = 'Transferir asignatura a otro profesor';
$string['form_subject_teacher_form_no_head_class_teacher'] = 'También eliminar de la cátedra al profesor titular';
$string['form_subject_teacher_form_save'] = 'Transferir asignatura ahora.';
$string['form_subject_teacher_form_select_new_teacher'] = 'Nuevo profesor para {$a->subjecttitle}';
$string['form_subject_teacher_form_select_new_teacher_docu'] = 'En este menú desplegable se enumeran los usuarios que tienen un rol de profesor en algún contexto (profesor de clase, profesor en este curso, propietario de la clase, profesor en una asignatura, profesor de clase adicional, profesor de proyecto, profesor bilingüe).';
$string['gender'] = 'Género';
$string['grade_and_difflevel'] = 'Calificación y nivel de dificultad';
$string['grading'] = 'Calificar';
$string['groupleader_fieldtitle'] = 'Tutor del grupo de aprendizaje';
$string['head_teacher'] = 'Profesor titular';
$string['head_teachers'] = 'Profesores de una clase';
$string['head_teachers_description'] = 'Puede crear clases, asignar profesores y estudiantes y ver el informe de desarrollo del aprendizaje.';
$string['hidden_students'] = 'Estudiantes ocultos';
$string['hide_all'] = 'Ocultar todo';
$string['hide_uploadform'] = 'Ocultar formato para subida';
$string['html_report'] = 'Vista general';
$string['import_class'] = 'Importar clase';
$string['import_class_already_exist'] = 'La clase "{$a}" ya existe y se sobrescribirá';
$string['import_class_checked_success'] = 'Datos de clase verificados exitosamente';
$string['import_class_from_backup'] = 'Importar Clase desde respaldo';
$string['import_class_restored'] = 'Se ha restaurado la clase "{$a}"';
$string['import_class_reviewsimport'] = 'Importar revisiones';
$string['import_evaluation_will_overwrite'] = 'Se sobrescribirá una evaluación (Tipo: {$a->type}, Profesor: {$a->teacher})';
$string['info_category_without_cross_competences'] = 'Si la categoría es {$a->categorytitles}, este informe no tiene "competencias interdisciplinarias"';
$string['interdisciplinary_competences'] = 'Competencias interdisciplinarias';
$string['invalidperiodid'] = 'ID del período inválida';
$string['it_is_my_class'] = 'Mi clase';
$string['last_edited_by'] = 'Último cambio realizado por {$a->name} el {$a->time}';
$string['last_period'] = 'Último período:';
$string['leaders'] = 'Firmas';
$string['learn_and_sociale'] = 'Aprendizaje y comportamiento social';
$string['learn_and_sociale_for_head'] = 'Aprendizaje y comportamiento social';
$string['learn_and_sociale_for_head2'] = 'Aprendizaje y comportamiento social';
$string['legend'] = 'Clave';
$string['load_last_period'] = 'Cargar último período';
$string['load_last_period_done'] = 'El último período está adaptado';
$string['logging'] = 'Activar bitácoras';
$string['logosize'] = 'Par uso eficiente, el banner del logo debe ser de 840 por 100 pixeles. Por favor evite usar transparencia en archivos PNG, porque puede causar un error al crear un reporte en PDF.';
$string['man'] = 'masculino';
$string['mark_to_delete_go'] = 'Marcar para eliminar por el administrador';
$string['message_interdisciplinary_competences_notes_limit'] = 'Por favor ingrese las calificaciones 1-{$a->limit}.';
$string['message_interdisciplinary_competences_points_limit'] = 'Por favor ingrese Punto 0-{$a->limit}.';
$string['messageprovider:approve_allow_review'] = 'Aprobar la revisión de la clase del período anterior';
$string['messageprovider:prolong_allow_review'] = 'Prolongación de la revisión de clases del período anterior';
$string['mixed_bw_nonbw_class_error_2'] = 'No se ha encontrado la plantilla para la clase. Marque la opción de escuelas interconfesionales: "exastud | bw_active"';
$string['more_student_data'] = 'Mostrar más datos';
$string['more_student_data_all'] = 'Mostrar más datos para todos los estudiantes';
$string['more_student_data_all_hide'] = 'Ocultar datos detallados para todos los estudiantes';
$string['move_here'] = 'Mover aquí';
$string['name'] = 'Nombre';
$string['new_head_teacher'] = 'Nuevos profesores de clase';
$string['newperiod'] = 'Nuevo período';
$string['no_entries_found'] = 'No se encontraronentradas';
$string['no_other_users_found'] = 'No se encontraron otros usuarios';
$string['no_possible_inputs_in_report'] = 'No hay campos definidos en el Configurador de informes. No es posible introducir datos';
$string['no_project_examination_for_project'] = 'Examen de proyecto para el formato \'{$a}\' no disponible';
$string['noclassestoreview'] = 'Sin clases para revisar';
$string['noclassfound'] = '¡No se encontraron clases!';
$string['noperiods'] = 'Aun no hay período de evaluación definido. Por favor póngase en contacto con el administrador.';
$string['nostudentsfound'] = 'No se encontraron estudiantes.';
$string['nostudentstoreport'] = 'Sin estudiantes para reportar.';
$string['nostudentstoreview'] = 'Sin estudiantes para revisar.';
$string['not_assigned'] = 'No asignado';
$string['not_defined'] = 'no definido';
$string['not_enough_data_for_report'] = 'No hay datos suficientes para generación de reporte para estudiantes seleccionados';
$string['not_found_report'] = 'No se encontró ningún reporte';
$string['not_selected'] = 'Vacío';
$string['notification_allow_review_old_class_approve_body'] = 'Estimado {$a->receiver}, </br></br>La revisión de la clase "{$a->classtitle}" fue aprobada hasta el {$a->datetime}.</br></br> Este mensaje se ha generado automáticamente desde el sitio Moodle {$a->site}.';
$string['notification_allow_review_old_class_approve_context'] = 'Permitir revisar clases del período anterior';
$string['notification_allow_review_old_class_approve_subject'] = '{$a->site}: Se aprobó la revisión de la clase "{$a->classtitle}"';
$string['notification_allow_review_old_class_prolong_body'] = 'Estimado {$a->receiver}, </br></br>La revisión de la clase "{$a->classtitle}" se prolongó hasta {$a->datetime}.</br></br> Este mensaje se ha generado automáticamente desde el sitio Moodle {$a->site}.';
$string['notification_allow_review_old_class_prolong_context'] = 'Permitir revisar clases del período anterior';
$string['notification_allow_review_old_class_prolong_subject'] = '{$a->site}: Se prolongó la revisión de la clase "{$a->classtitle}"';
$string['old_subjects'] = 'Asignaturas antiguas';
$string['only_profilesubject_teacher'] = 'Sólo el profesor de la asignatura del perfil puede editar';
$string['parent'] = 'Padre';
$string['perioddesc'] = 'Descripción del período:';
$string['perioddescription'] = 'Descripción';
$string['periodinput'] = 'Entrada de períodos';
$string['periodoverlaps'] = 'El período {$a->period1} se traslapa con {$a->period2}';
$string['periodreview'] = 'Revisión para período';
$string['periods'] = 'Períodos';
$string['periods_incorrect'] = 'La definición del períodod no es correcta';
$string['periodserror'] = 'Error con la configuraciónde los períodos';
$string['pictureupload'] = 'Subida del logo';
$string['please_enter_group_name'] = '¡Por favor ingrese el nombre de la clase/grupo!';
$string['pluginname'] = 'Revisión de Estudiante Exabis';
$string['print'] = 'imprimir';
$string['printall'] = 'Imprimir todo';
$string['printversion'] = 'Versión imprimible';
$string['prof_skills'] = 'Habilidades profesionales';
$string['profilesubject'] = 'Asignatura del perfil';
$string['project_based_badclass'] = 'Usted no puede editar este proyecto';
$string['project_based_badstudent'] = 'El estudiante no es miembro de este proyecto';
$string['project_based_class'] = 'Proyecto';
$string['project_based_configmember'] = 'Estudiantes de {$a}';
$string['project_based_configteacher'] = 'Profesores en {$a}';
$string['project_based_configuration'] = 'Editar proyecto';
$string['project_based_editclassmemberlist'] = 'Editar lista de proyecto';
$string['project_based_editclassname'] = 'Editar proyecto';
$string['project_based_editclassteacherlist'] = 'Editar lista de proyecto';
$string['project_based_errorinsertingclass'] = 'Ocurrió un error al insertar proyecto';
$string['project_based_errorupdatingclass'] = 'Error al actualizar proyecto';
$string['project_based_explainclassname'] = 'Hacer clic aquí para editar el nombre del proyecto';
$string['project_based_noclassestoreview'] = 'Sin proyectos para revisar';
$string['project_based_noclassfound'] = '¡No se encontró proyecto!';
$string['project_based_redirectingtoclassinput'] = 'No se encontró información del proyecto; redireccionando al ingreso del proyecto.';
$string['project_based_reviewclass'] = 'Revisión del proyecto';
$string['project_based_studentreview'] = 'REVISIÓN DEL PROYECTO';
$string['project_based_students'] = 'Proyectos';
$string['project_based_teachers'] = 'Proyecto-Profesores';
$string['project_based_total'] = 'Puntaje total';
$string['project_based_upload_picture'] = 'Usted puede subir un logo para un reporte específico de proyecto';
$string['project_teacher_also_was_changed'] = '{$a->newteachername} también obtuvo Profesor del Proyecto en lugar de {$a->oldteachername}';
$string['redirectingtoclassinput'] = 'No se encontró información de clase, redireccionando hacia entrada de clase.';
$string['redirectingtoperiodsinput'] = 'No se encontró información de período, redireccionando hacia entrada de período.';
$string['reinstall_report_templates'] = 'Reinstalar todas las plantillas predeterminadas';
$string['report'] = 'Reporte';
$string['report_averages_header_average'] = 'Promedio';
$string['report_averages_header_factor'] = 'Factor';
$string['report_averages_header_grading'] = 'Calificaciòn';
$string['report_averages_header_student'] = 'Estudiante';
$string['report_averages_header_subjects'] = 'Asignaturas';
$string['report_averages_header_sum'] = 'Suma';
$string['report_averages_header_type'] = 'Tipo';
$string['report_averages_title'] = 'Promedios';
$string['report_bilinguales'] = 'Instrucción bilingüe';
$string['report_button_export'] = 'Reportes de exportación';
$string['report_button_import'] = 'Reportes de importación';
$string['report_column_enddate'] = 'Abandonó';
$string['report_column_template'] = 'Formato de certificado';
$string['report_cross_competences'] = 'Competencias interdisciplinarias';
$string['report_delete'] = 'Eliminar reporte: {$a}';
$string['report_delete_confirm_message'] = '¿Estás seguro de que deseas eliminar el reporte "{$ a}"';
$string['report_edit_userprofile'] = 'Editar perfil de usuario';
$string['report_edit_userprofile_noaccess'] = 'No tienes derechos para editar el perfil del usuario.';
$string['report_export_selected_templates'] = 'Exportación seleccionada';
$string['report_export_update_files'] = 'Actualizar archivos si existieran';
$string['report_export_update_reports'] = 'Actualizar reportes si existieran';
$string['report_export_with_files'] = 'Agregar fuentes (archivos) de plantillas';
$string['report_file'] = 'Archivo';
$string['report_for_additional'] = 'Campos adicionales';
$string['report_for_bilingual'] = 'Reporte para valoración bilingüe';
$string['report_for_subjects'] = 'Certificado para asignatura del perfil';
$string['report_import_file_shouldnotbeempty'] = 'El archivo no debería estar vacío.';
$string['report_import_ignored_list'] = 'Estos reportes fueron ignorados';
$string['report_import_inserted_list'] = 'Estos reportes fueron insertados';
$string['report_import_templates'] = 'Importar';
$string['report_import_updated_list'] = 'Estos reportes fueron actualizados';
$string['report_learn_and_sociale'] = 'Aprendizaje y comportamiento social';
$string['report_other_report_fields'] = 'Otros campos del reporte';
$string['report_overview_docx'] = 'Resumen de calificaciones (docx)';
$string['report_overview_xlsx'] = 'Resumen de calificaciones (xlsx)';
$string['report_preview'] = 'Previsualizar';
$string['report_report_eval'] = 'Evaluaciones de proyectos';
$string['report_report_fields'] = 'Campos del reporte';
$string['report_screen'] = 'Pantalla';
$string['report_select_all'] = 'Seleccionar todo';
$string['report_selectdeselect_all'] = 'Seleccionar/Des-seleccionar todo';
$string['report_setting_current_file'] = 'Plantilla actual';
$string['report_setting_current_title'] = 'Título actual';
$string['report_setting_type_header'] = 'Encabezado';
$string['report_setting_type_image'] = 'Imagen';
$string['report_setting_type_image_height'] = 'Altura';
$string['report_setting_type_image_maxbytes'] = 'Tamaño máximo (bytes)';
$string['report_setting_type_image_width'] = 'Ancho';
$string['report_setting_type_matrix'] = 'Matriz';
$string['report_setting_type_matrix_column_titles'] = 'Títulos de columna';
$string['report_setting_type_matrix_row_titles'] = 'Títulos de filas';
$string['report_setting_type_matrix_type'] = 'Tipo de matriz';
$string['report_setting_type_matrix_type_checkbox'] = 'Casilla de selección';
$string['report_setting_type_matrix_type_radio'] = 'Botón de selección';
$string['report_setting_type_matrix_type_text'] = 'Texto';
$string['report_setting_type_select'] = 'Seleccionar';
$string['report_setting_type_text'] = 'Texto';
$string['report_setting_type_textarea'] = 'Área de texto';
$string['report_setting_type_userdata'] = 'Campo de perfil';
$string['report_setting_type_userdata_datakey'] = 'Elegir campo del usuario';
$string['report_setting_willbe_added'] = 'No existe ahora. Será añadido.';
$string['report_settings'] = 'Configuraciones del reporte';
$string['report_settings_button_add_additional_param'] = 'Añadir un nuevo parámetro';
$string['report_settings_copy'] = 'Copiar reporte';
$string['report_settings_copy_done'] = 'Se creó un nuevo reporte "{$a->newtitle}" (id: {$a->newid}) a partir de "{$a->sourcetitle}" (id: {$a->sourceid})';
$string['report_settings_countinrow'] = 'con {$a} caracteres por fila';
$string['report_settings_countinrow_fieldtitle'] = 'Caracteres por fila';
$string['report_settings_countinrow_short'] = '{$a} caracteres';
$string['report_settings_countrows'] = '{$a} filas';
$string['report_settings_countrows_fieldtitle'] = 'Número de filas';
$string['report_settings_edit'] = 'Configuraciones del reporte';
$string['report_settings_group_description_classTeacher'] = 'Campos que debe rellenar el profesor de la clase';
$string['report_settings_group_description_default'] = 'Estos marcadores son fijos y se rellenarán con valores propios si están en el informe.';
$string['report_settings_group_title_classTeacher'] = 'Para el profesor de clase';
$string['report_settings_group_title_default'] = 'Predeterminado';
$string['report_settings_group_title_other'] = 'Campos adicionales';
$string['report_settings_maxchars'] = 'con un máximo de {$a} caracteres';
$string['report_settings_maxchars_fieldtitle'] = 'Máximo de caracteres';
$string['report_settings_maxchars_short'] = 'Máximo {$a} caracteres';
$string['report_settings_new'] = 'Configuración de nuevo reporte';
$string['report_settings_no'] = 'no';
$string['report_settings_no_template_file'] = 'No hay archivo de plantilla: {$a->filename}';
$string['report_settings_selectboxkey_fieldtitle'] = 'Clave';
$string['report_settings_selectboxvalue_fieldtitle'] = 'Valor';
$string['report_settings_setting_additional_params'] = 'Parámetros adicionales';
$string['report_settings_setting_ags'] = 'Equipo';
$string['report_settings_setting_bp'] = 'Currículo';
$string['report_settings_setting_category'] = 'Categoría';
$string['report_settings_setting_class'] = 'Clase';
$string['report_settings_setting_comments'] = 'Comentarios';
$string['report_settings_setting_dateofbirth'] = 'Fecha de nacimiento';
$string['report_settings_setting_focus'] = 'Foco';
$string['report_settings_setting_grades'] = 'Calificaciones';
$string['report_settings_setting_hidden'] = 'Oculto';
$string['report_settings_setting_learninggroup'] = 'Grupo de aprendizaje';
$string['report_settings_setting_learnsocialbehavior'] = 'Aprendizaje y comportamiento social';
$string['report_settings_setting_placeofbirth'] = 'Lugar de nacimiento';
$string['report_settings_setting_projektthema'] = 'Valoración del proyecto';
$string['report_settings_setting_reportdate'] = 'Fecha para tarjeta de reporte';
$string['report_settings_setting_studentname'] = 'Nombre y Apellido(s)';
$string['report_settings_setting_subjectelective'] = 'Asignatura electiva';
$string['report_settings_setting_subjectprofile'] = 'Asignatura del perfil';
$string['report_settings_setting_subjects'] = 'Asignaturas';
$string['report_settings_setting_template'] = 'Plantilla';
$string['report_settings_setting_title'] = 'Título';
$string['report_settings_setting_year'] = 'Año escolar';
$string['report_settings_upload_new_filetemplate'] = 'Subir nuevo archivo de plantilla';
$string['report_settings_upload_new_filetemplate_overwrite'] = 'Sobrescribir archivo si existiera';
$string['report_settings_userdata_wrong_user_parameter'] = 'El campo de perfil de usuario \'{$a->fieldname}\' no existe. Créelo o cambie el valor de un campo existente.';
$string['report_settings_userdata_wrong_user_parameter_editurl_title'] = 'Editar campos del perfil de usuario';
$string['report_settings_userdata_wrong_user_parameter_in_reports_list'] = 'Este informe tiene marcadores de datos de usuario incorrectos. Edite este informe para resolver este error.';
$string['report_settings_yes'] = 'si';
$string['report_student_template'] = 'Plantilla';
$string['report_template'] = 'Plantilla';
$string['report_userprofile_field_info'] = 'Propiedad del usuario.';
$string['reports'] = 'Reportes';
$string['reports_certs_and_attachments'] = 'Certificados y anexos';
$string['reports_overviews'] = 'Reseñas generales';
$string['reports_server_notification'] = 'Si el reporte no se genera correctamente, podría indicar una cantidad excesiva de datos o una configuración del servidor demasiado baja. En este caso, póngase en contacto con el administrador del servidor.';
$string['requests'] = 'Solicitudes del sistema';
$string['requests_class_delete'] = 'Eliminar';
$string['requests_class_delete_list'] = 'Eliminar clases';
$string['requests_class_teacher'] = 'Profesor de clase';
$string['requests_class_title'] = 'Clase';
$string['requests_for_you'] = 'Hay solicitudes del sistema para usted';
$string['requests_no_any'] = 'Sin solicitudes';
$string['requests_unlock_approve_button'] = 'Aprobar';
$string['requests_unlock_delete_button'] = 'Rechazar';
$string['requests_unlock_prolong_button'] = 'Prolongar';
$string['requests_unlock_request_created'] = 'Solicitud creada';
$string['requests_unlock_request_until'] = 'hasta';
$string['requests_unlock_requested_teacher'] = 'solicitud para profesor';
$string['requests_unlock_review_list'] = 'Desbloquear para revisar';
$string['reset_report_selected_templates'] = 'Restablecer las plantillas seleccionadas al estado predeterminado';
$string['reset_report_templates'] = 'Restablecer las plantillas predeterminadas al estado predeterminado';
$string['reset_report_templates_description'] = '¿Está seguro? Las plantillas predeterminadas se restablecerán al estado predeterminado. Las plantillas personalizadas no se modificarán.';
$string['responsibility'] = 'Responsabilidad';
$string['review'] = 'Revisión';
$string['review_button'] = 'Revisar';
$string['review_class_average_not_calculated'] = 'No se calcula calificación media';
$string['review_class_average_value'] = 'Valor promedio';
$string['review_class_averages'] = 'Cálculo de promedios';
$string['review_project_evalueations'] = 'Evaluaciones de proyectos';
$string['review_student_other_data_body'] = 'Cuerpo';
$string['review_student_other_data_footer'] = 'Pie de página';
$string['review_student_other_data_header'] = 'Encabezado';
$string['review_table_part_additional'] = 'General';
$string['review_table_part_subjects'] = 'Asignaturas';
$string['review_table_part_subjectsfromother'] = 'De otros profesores de asignatura';
$string['reviewclass'] = 'Revisión de clase';
$string['reviewcount'] = 'revisión(es) todavía';
$string['reviewstudent'] = 'Revisión de estudiante';
$string['school_logo'] = 'Logo de escuela';
$string['school_logo_description'] = 'Tamaño máximo de la imagen: {$a->width}x{$a->height} píxeles';
$string['schoollieder_fieldtitle'] = 'Director de escuela';
$string['select_all'] = 'Seleccionar todo';
$string['select_another_class'] = 'Seleccionar otra clase';
$string['select_student'] = 'Por favor seleccione al menos un estudiante';
$string['selfreliance'] = 'Auto-confianza (self-reliance)';
$string['settings_city'] = 'Reporte sobre el Desarrollo del Aprendizaje: Ciudad';
$string['settings_competence_evalpoints_limit'] = 'Puntos máximos para el tipo de evaluación "puntos"';
$string['settings_competence_evalpoints_limit_description'] = 'Si el valor de exastud/competence_evaltype se basa en puntos';
$string['settings_competence_evaltype'] = 'La evaluación de competencias se basa en';
$string['settings_competence_evaltype_grade'] = 'Calificaciones';
$string['settings_competence_evaltype_point'] = 'Puntos';
$string['settings_competence_evaltype_text'] = 'Entrada de texto';
$string['settings_detailed_review'] = 'Revisión detallada';
$string['settings_detailed_review_body'] = 'Esta configuración le permite a Usted ver todas las valoraciones de profesores en detalle';
$string['settings_edustandarts'] = 'Estándares educativos que se pueden cumplir';
$string['settings_edustandarts_description'] = 'Lista separada por comas';
$string['settings_eval_setup'] = 'Valores de calificación de evaluación';
$string['settings_eval_setup_link'] = 'Editar';
$string['settings_exacomp_assessment_categories'] = 'Usar rejilas de competencia para categorías de valoración';
$string['settings_exacomp_verbeval'] = 'Valoraciones verbalizadas de competencias exabis';
$string['settings_export_class_password'] = 'Protección con contraseña (cifrado AES-256) para copias de seguridad de clase';
$string['settings_export_class_report_password'] = 'Protección de contraseña (cifrado AES-256) para informes de clase';
$string['settings_export_class_report_password_description'] = '(sólo disponible a partir de la versión 7.2 de php)';
$string['settings_grade_interdisciplinary_competences'] = 'Mostrar competencias interdisciplinarias a los profesores de clase';
$string['settings_heading_security'] = 'Seguridad';
$string['settings_only_learnsoziale'] = 'Valoración solamente de comportamiento social y aprendizaje';
$string['settings_project_based_assessment'] = 'Evaluación basada en el proyecto';
$string['settings_project_based_assessment_body'] = 'Esta configuración le permite a Usted usar valoración basada en el proyecto en lugar de evaluación de clase';
$string['settings_shoolname'] = 'Reporte de Desarrollo del Aprendizaje: Nombre de la Escuela';
$string['settings_shooltype'] = 'Reporte de Desarrollo del Aprendizaje: Tipo de Escuela';
$string['settings_sourceId'] = 'ID de la fuente';
$string['settings_sourceId_description'] = 'ID generado automáticamente de esta instalación de Exastud. Este ID no se puede cambiar';
$string['show_all'] = 'Mostrar todo';
$string['showall'] = 'Mostrar todo';
$string['sort_parameter'] = 'Ordenar parámetros (mover)';
$string['starttime'] = 'Hora de inicio';
$string['studentgradereports'] = 'Reportes de calificación';
$string['studentreview'] = 'REVISIÓN DE ESTUDIANTE';
$string['students'] = 'Estudiantes';
$string['subject'] = 'Asignatura';
$string['subject_category'] = 'Categoría';
$string['subject_category_b'] = 'Mejor calificación';
$string['subject_category_m'] = 'Asignatura Relevante';
$string['subjectteacher_change_button'] = 'Emparejar un nuevo profesor y transmitir su calificación';
$string['subjectteacher_delete_button'] = 'Eliminar relación de este profesor y asignatura';
$string['subjectteacher_grade_interdisciplinary_competences'] = 'El profesor de asignatura puede editar competencias interdisciplinarias.';
$string['subjectteacher_grade_learn_and_social_behaviour'] = 'El profesor de la asignatura puede editar el aprendizaje y el comportamiento social.';
$string['suggestions_from_exacomp'] = 'Sugerencias de calificación desde rejilla de competencia (exacomp)';
$string['teacher'] = 'Profesor';
$string['teacher_for_bilingual'] = 'Profesor para valoración bilingüe';
$string['teacher_for_project'] = 'Profesor para valoración del proyecto';
$string['teacher_subject_role'] = 'Descripción de asignatura/rol del profesor';
$string['teachers'] = 'Profesores';
$string['teachers_options'] = 'Opciones del Profesor';
$string['teamplayer'] = 'Miembro de equipo';
$string['template_textarea_limits_error'] = 'Utilice límites definidos para los campos de área de texto';
$string['template_with_no_inputs'] = 'Esta plantilla no tiene más campos de entrada';
$string['temporary_hidden'] = 'Temporalmente no disponible';
$string['textarea_chars'] = 'Caracteres';
$string['textarea_charsleft'] = 'Caracteres restantes';
$string['textarea_charstomuch'] = 'Demasiados caracteres';
$string['textarea_limit_notation'] = 'Para mostrar el texto completo en el reporte, no escriba más de {$a->chars_per_row} signos en la última fila.';
$string['textarea_linestomuch'] = 'Demasiadas líneas';
$string['textarea_max'] = 'Máximo';
$string['textarea_maxchars'] = 'Todos los caracteres';
$string['textarea_rows'] = 'Filas';
$string['textblock'] = 'Bloque de texto';
$string['this_category_related_to_classes'] = 'Esta categoría está relacionada con clase';
$string['this_category_reviewed_for_student'] = 'Esta categoría ha sido revisada para algunos estudiantes.';
$string['total'] = 'Puntaje total';
$string['unmark_to_delete_button'] = 'Desmarcar para eliminar';
$string['unmark_to_delete_go'] = 'Desmarcar para eliminar por el administrador';
$string['upload_new_templatefile'] = 'Subir nueva plantilla';
$string['upload_picture'] = 'Usted puede subir un logo para un reporte específico de una escuela';
$string['upload_success'] = '¡El nuevo logo se subió exitosamente!';
$string['woman'] = 'femenino';
$string['wrong_password'] = 'Contraseña incorrecta';
