<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plugin', language 'sr_lt', version '4.5'.
 *
 * @package     plugin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Akcije';
$string['availability'] = 'Dostupnost';
$string['cancelinstallall'] = 'Otkaži nove instalacije ({$a})';
$string['cancelinstallhead'] = 'Otkazivanje instalacije dodataka';
$string['cancelinstallinfo'] = 'Sledeći dodaci nisu još u potpunosti instalirani, tako da njihova instaliranje može da se otkaže. Da biste to uradili, direktorijum dodatka mora sada da bude uklonjen sa servera. Proverite da li je ovo ono što zaista želite, kako bi sprečili slučajan gubitak podataka (kao što su npr. izmene u kôdu).';
$string['cancelinstallinfodir'] = 'Direktorijum koji će biti obrisan: {$a}';
$string['cancelinstallone'] = 'Otkaži ovu instalaciju';
$string['cancelupgradeall'] = 'Otkaži nadogradnje ({$a})';
$string['cancelupgradehead'] = 'Vraćanje prethodne verzije dodatka';
$string['cancelupgradeone'] = 'Otkaži ovu nadogradnju';
$string['checkforupdates'] = 'Proveri da li su dostupne nove verzije';
$string['checkforupdateslast'] = 'Poslednja provera je bila {$a}';
$string['dependencyavailable'] = 'Dostupan';
$string['dependencyfails'] = 'Neuspešno';
$string['dependencyinstall'] = 'Instaliraj';
$string['dependencyinstallhead'] = 'Instaliranje nedostajućih zavisnih dodataka';
$string['dependencyinstallmissing'] = 'Instaliraj nedostajuće zavisne dodatke ({$a})';
$string['dependencymissing'] = 'Nedostaje';
$string['dependencyunavailable'] = 'Nedostupan';
$string['dependencyupload'] = 'Učitaj';
$string['dependencyuploadmissing'] = 'Postavi ZIP datoteke';
$string['detectedmisplacedplugin'] = 'Dodatak "{$a->component}" je instaliran na neispravnom mestu "{$a->current}", očekivano mesto je "{$a->expected}"';
$string['displayname'] = 'Naziv dodatka';
$string['err_response_curl'] = 'Nije moguće preuzeti podatke o novim verzijama - neočekivana cURL greška.';
$string['err_response_format_version'] = 'Neočekivana verzija formata odgovora. Molimo, pokušajte da proverite ponoovo dostupne verzije.';
$string['err_response_http_code'] = 'Nije moguće preuzeti podatke o novim verzijama - neočekivani kôd HTTP odgovora.';
$string['filterall'] = 'Prikaži sve';
$string['filtercontribonly'] = 'Prikaži samo nestandardne dodatke';
$string['filtermissingonly'] = 'Prikaži samo dodatke koji nedostaju na disku';
$string['filternewpluginsonly'] = 'Prikaži samo dodatke koji treba da budu instalirani';
$string['filterupdatesonly'] = 'Prikaži samo dodatke koji se mogu ažurirati';
$string['incompatibleversion'] = 'Nekompatibilna verzija Moodlea: {$a}';
$string['isenabled'] = 'Omogućeno?';
$string['misdepinfoplugin'] = 'Informacije o dodatku';
$string['misdepinfoversion'] = 'Informacije o verziji';
$string['misdepsavail'] = 'Dostupni zavisni dodaci koji nedostaju';
$string['misdepsunavail'] = 'Nedostupni zavisni dodaci koji nedostaju';
$string['misdepsunavaillist'] = 'Nije pronađena nijedna verzija koja ispunjava zahteve zavisnog dodatka: {$a}.';
$string['misdepsunknownlist'] = 'Nije u direktorijumu dodataka: <strong>{$a}</strong>.';
$string['moodlebranch'] = 'Moodle {$a->min} - {$a->max}';
$string['moodleversion'] = 'Moodle {$a}';
$string['noneinstalled'] = 'Dodatak ovog tipa nije instaliran';
$string['notdownloadable'] = 'Nije moguće preuzeti paket';
$string['notdownloadable_help'] = 'ZIP arhiva sa novom verzijom dodatka ne može da preuzme automatski.';
$string['notdownloadable_link'] = 'admin/mdeploy/notdownloadable';
$string['notes'] = 'Beleške';
$string['notsupported'] = 'Dodatak možda nije kompatibilan sa verzijom Moodlea {$a}';
$string['notwritable'] = 'Nije moguće upisati datoteke dodatka';
$string['notwritable_help'] = 'Veb server ne može da upiše datoteke dodatka. Proces veb servera mora da ima pravo upisivanja nad direktorijumom dodatka i kompletnim njegovim sadržajem. Takođe, može biti potrebno i pravo upisivanja nad korenskim direktorijumom odgovarajućeg tipa dodatka.';
$string['otherplugin'] = '{$a->component}';
$string['otherpluginversion'] = '{$a->component} ({$a->version})';
$string['overviewall'] = 'Svi dodaci';
$string['overviewext'] = 'Nestandardni dodaci';
$string['overviewupdatable'] = 'Dostupne nove verzije';
$string['packagesdebug'] = 'Ispis poruka za otklanjanje grešaka omogućen';
$string['packagesdownloading'] = 'Preuzimanje {$a}';
$string['packagesextracting'] = 'Raspakivanje {$a}';
$string['packagesvalidating'] = 'Provera {$a}';
$string['packagesvalidatingfailed'] = 'Instalacija prekinuta zbog neuspešne provere ispravnosti dodatka';
$string['packagesvalidatingok'] = 'Provera uspešno obavljena. Instalacija može da se nastavi.';
$string['plugincheckall'] = 'Svi dodaci';
$string['plugincheckattention'] = 'Dodaci koji zahtevaju pažnju';
$string['pluginchecknone'] = 'Nijedan dodatak ne zahteva vašu pažnju';
$string['pluginchecknotice'] = 'Ova stranica prikazuje spisak dodataka koji mogu da traže vašu pažnju u toku nadogradnje sistema, kao što su novi dodaci koji će biti instalirani, postojeći dodaci koji će biti ažurirani, dodaci koji nedostaju itd. Takođe su označeni i nestandardni dodaci za koje su dostupne nove verzije. Pre nego što nastavite sa ovom nadogradnjom Moodlea preporučuje se da prvo proverite da li su dostupne novije verzije dodataka i ažurirate njihov izvorni kôd.';
$string['plugindisable'] = 'Onemogući';
$string['plugindisabled'] = 'Onemogućeno';
$string['pluginenable'] = 'Omogući';
$string['pluginenabled'] = 'Omogućeno';
$string['release'] = 'Izdanje';
$string['requiredby'] = 'Potreban za: {$a}';
$string['requires'] = 'Zahteva';
$string['rootdir'] = 'Direktorijum';
$string['settings'] = 'Podešavanja';
$string['source'] = 'Izvor';
$string['sourceext'] = 'Nestandardni dodatak';
$string['sourcestd'] = 'Standardni';
$string['status'] = 'Status';
$string['status_delete'] = 'Za brisanje';
$string['status_downgrade'] = 'Novija verzija je već instalirana';
$string['status_missing'] = 'Nedostaje na disku';
$string['status_new'] = 'Biće instaliran';
$string['status_nodb'] = 'Nema baze podataka';
$string['status_upgrade'] = 'Biće nadograđen';
$string['status_uptodate'] = 'Instaliran';
$string['supportedconversions'] = 'Podržane konverzije dokumenata';
$string['supportedmoodleversions'] = 'Podržane verzije Moodlea';
$string['systemname'] = 'Identifikator';
$string['type_aiplacement'] = 'Dodatak za poziciju AI servisa';
$string['type_aiplacement_plural'] = 'Dodaci za poziciju AI servisa';
$string['type_aiprovider'] = 'Dodatak za provajdera AI servisa';
$string['type_aiprovider_plural'] = 'Dodaci za provajdere AI servisa';
$string['type_antivirus'] = 'Antivirusni dodatak';
$string['type_antivirus_plural'] = 'Antivirusni dodaci';
$string['type_auth'] = 'Metod provere identiteta';
$string['type_auth_plural'] = 'Metodi provere identiteta';
$string['type_availability'] = 'Ograničenje dosupnosti';
$string['type_availability_plural'] = 'Ograničenja dostupnosti';
$string['type_block'] = 'Blok';
$string['type_block_plural'] = 'Blokovi';
$string['type_cachelock'] = 'Procedura za zaključavanje keša';
$string['type_cachelock_plural'] = 'Procedure za zaključavanje keša';
$string['type_cachestore'] = 'Skladište keša';
$string['type_cachestore_plural'] = 'Skladišta keša';
$string['type_calendartype'] = 'Tip kalendara';
$string['type_calendartype_plural'] = 'Tipovi kalendara';
$string['type_communication'] = 'Komunikacioni provajder';
$string['type_communication_plural'] = 'Komunikacioni provajderi';
$string['type_contentbank'] = 'Banka sadržaja';
$string['type_contentbank_plural'] = 'Dodaci banke sadržaja';
$string['type_contenttype'] = 'Banka sadržaja';
$string['type_contenttype_plural'] = 'Dodaci banke sadržaja';
$string['type_coursereport'] = 'Izveštaj kursa';
$string['type_coursereport_plural'] = 'Izveštaji kursa';
$string['type_customfield'] = 'Prilagođeno polje';
$string['type_customfield_plural'] = 'Prilagođena polja';
$string['type_dataformat'] = 'Format podataka';
$string['type_dataformat_plural'] = 'Formati podataka';
$string['type_editor'] = 'Editor teksta';
$string['type_editor_plural'] = 'Editori teksta';
$string['type_enrol'] = 'Metod upisa';
$string['type_enrol_plural'] = 'Metode upisa';
$string['type_fileconverter'] = 'Konvertor dokumenata';
$string['type_fileconverter_plural'] = 'Konvertori dokumenata';
$string['type_fileconvertermanage'] = 'Upravljanje konvertorima dokumenata';
$string['type_filter'] = 'Tekstualni filter';
$string['type_filter_plural'] = 'Tekstualni filteri';
$string['type_format'] = 'Format kursa';
$string['type_format_plural'] = 'Formati kursa';
$string['type_gradeexport'] = 'Metod izvoza ocena';
$string['type_gradeexport_plural'] = 'Metodi izvoza ocena';
$string['type_gradeimport'] = 'Metod uvoza ocena';
$string['type_gradeimport_plural'] = 'Metodi uvoza ocena';
$string['type_gradereport'] = 'Izveštaj iz knjige ocena';
$string['type_gradereport_plural'] = 'Izveštaji iz knjige ocena';
$string['type_gradingform'] = 'Napredni metod ocenjivanja';
$string['type_gradingform_plural'] = 'Napredni metodi ocenjivanja';
$string['type_h5plib'] = 'H5P okvir';
$string['type_h5plib_plural'] = 'H5P okviri';
$string['type_local'] = 'Lokalni dodatak';
$string['type_local_plural'] = 'Lokalni dodaci';
$string['type_media'] = 'Medija plejer';
$string['type_media_plural'] = 'Medija plejeri';
$string['type_message'] = 'Dodatak za obaveštenja';
$string['type_message_plural'] = 'Dodaci za obaveštenja';
$string['type_mlbackend'] = 'Pozadinski procesor mašinskog učenja';
$string['type_mlbackend_plural'] = 'Pozadinski procesori mašinskog učenja';
$string['type_mnetservice'] = 'MNet servis';
$string['type_mnetservice_plural'] = 'MNet servisi';
$string['type_mod'] = 'Modul aktivnosti';
$string['type_mod_plural'] = 'Moduli aktivnosti';
$string['type_paygw'] = 'Mrežni prolaz za plaćanje';
$string['type_paygw_plural'] = 'Mrežni prolazi za plaćanje';
$string['type_paygwmanage'] = 'Upravljanje mrežnim prolazima za plaćanje';
$string['type_plagiarism'] = 'Dodatak za plagijarizam ';
$string['type_plagiarism_plural'] = 'Dodaci za plagijarizam';
$string['type_portfolio'] = 'Portfolio';
$string['type_portfolio_plural'] = 'Portfolija';
$string['type_profilefield'] = 'Tip polja profila';
$string['type_profilefield_plural'] = 'Tipovi polja profila';
$string['type_qbank'] = 'Dodatak za banku pitanja';
$string['type_qbank_plural'] = 'Dodaci za banku pitanja';
$string['type_qbehaviour'] = 'Ponašanje pitanja';
$string['type_qbehaviour_plural'] = 'Ponašanja pitanja';
$string['type_qformat'] = 'Format za uvoz/izvoz pitanja';
$string['type_qformat_plural'] = 'Formati za uvoz/izvoz pitanja';
$string['type_qtype'] = 'Tip pitanja';
$string['type_qtype_plural'] = 'Tipovi pitanja';
$string['type_report'] = 'Izveštaj sajta';
$string['type_report_plural'] = 'Izveštaji';
$string['type_repository'] = 'Repozitorijum';
$string['type_repository_plural'] = 'Repozitorijumi';
$string['type_search'] = 'Pretraživač';
$string['type_search_plural'] = 'Pretraživači';
$string['type_smsgateway'] = 'Mrežni prolaz (gateway) za SMS servis';
$string['type_smsgateway_plural'] = 'Mrežni prolazi (gateways) za SMS servis';
$string['type_theme'] = 'Grafička tema';
$string['type_theme_plural'] = 'Grafičke teme';
$string['type_tool'] = 'Administratorski alat';
$string['type_tool_plural'] = 'Administratorski alati';
$string['type_webservice'] = 'Protokol Web servisa';
$string['type_webservice_plural'] = 'Protokoli Web servisa';
$string['uninstall'] = 'Deinstaliraj';
$string['uninstallconfirm'] = 'Nameravate da obrišete dodatak <em>{$a->name}</em>. To će u bazi podataka potpuno obrisati sve što je povezano sa ovim dodatkom, uključujući njegovu konfiguraciju, zapise, korisničke datoteke kojima dodatak upravlja itd. Nema povratka nazad, a sâm Moodle ne kreira nikakvu rezervnu kopiju koja bi omogućila povratak na stanje pre brisanja dodatka. Da li ste SIGURNI da želite da nastavite?';
$string['uninstalldelete'] = 'Svi podaci povezani sa dodatkom <em>{$a->name}</em> su obrisani iz baze podataka. Da bi se sprečila automatska reinstalaciju dodatka, njegov direktorijum <em>{$a->rootdir}</em> mora biti sada ručno uklonjen sa vašeg servera. Sam Moodle ne može da ukloni direktorijum zbog ograničenja ovlašćenja za upis.';
$string['uninstalldeleteconfirm'] = 'Svi podaci povezani sa dodatkom <em>{$a->name}</em> su obrisani iz baze podataka. Da bi se sprečila automatska reinstalaciju dodatka, njegov direktorijum <em>{$a->rootdir}</em> mora biti uklonjen sa vašeg servera. Da li želite da sada uklonite direktorijum dodatka?';
$string['uninstalldeleteconfirmexternal'] = 'Izgleda da je trenutna verzija dodatka dobijena proverom sistema za upravljanje izvornim kôdom ({$a}). Ukoliko uklonite direktorijum dodatka, možda ćete izgubiti važne lokalne izmene kôda. Molimo vas da proverite da li definitivno želite da uklonite direktorijum dodatka, pre nego što nastavite.';
$string['uninstallextraconfirmblock'] = 'Postoji {$a->instances} primeraka ovog bloka.';
$string['uninstallextraconfirmenrol'] = 'Postoji {$a->enrolments} upisa korisnika.';
$string['uninstallextraconfirmmod'] = 'Postoji {$a->instances} primeraka ovog modula u {$a->courses} kurseva.';
$string['uninstalling'] = 'Deinstaliranje dodatka {$a->name}';
$string['updateavailable'] = 'Dostupna je nova verzija {$a}!';
$string['updateavailable_moreinfo'] = 'Više informacija';
$string['updateavailable_release'] = 'Izdanje {$a}';
$string['updatepluginconfirm'] = 'Potvrda o novoj verziji dodatka';
$string['updatepluginconfirmexternal'] = 'Izgleda da je trenutna verzija dodatka dobijena proverom sistema za upravljanje izvornim kôdom ({$a}). Ukoliko instalirate ovu novu verziju, više nećete moći da dobijate nove verzije dodataka iz sistema za upravljanje izvornim kôdom. Molimo vas da proverite da li definitivno želite da ažurirate dodatak, pre nego što nastavite.';
$string['updatepluginconfirminfo'] = 'Nameravate da instalirate novu verziju dodatka <strong>{$a->name}</strong>. Zip arhiva sa verzijom dodatka {$a->version} biće preuzeta sa <a href="{$a->url}">{$a->url}</a> i raspakovana u direktorijum vaše Moodle instalacije tako da može da je nadogradi.';
$string['updatepluginconfirmwarning'] = 'Molimo vas da imate u vidu da Moodle, pre nadogradnje, neće automatski kreirati rezervnu kopiju vaše baze podataka. Strogo se preporučuje da odmah napravite kompletnu rezervnu kopiju baze podataka, kako biste mogli da izađete na kraj sa retkim slučajevima, kada nova verzija ima greške (bagove) koje mogu učiniti vaš sajt nedostupnim ili, čak oštetiti vašu bazu podataka. Nastavite na sopstveni rizik.';
$string['validationmsg_componentmatch'] = 'Pun naziv komponente';
$string['validationmsg_componentmismatchname'] = 'Nepoklapanje naziva dodatka';
$string['validationmsg_componentmismatchname_help'] = 'Pojedine ZIP arhive, kao što su one koje generiše Github, mogu da sadrže pogrešan naziv osnovnog direktorijuma. Potrebno je da ispravite naziv osnovnog direktorijuma tako da on odgovara deklarisanom nazivu dodatka.';
$string['validationmsg_componentmismatchname_info'] = 'Dodatak prijavljuje da je njegov naziv \'{$a}\' ali se to ne poklapa sa nazivom osnovnog direktorijuma.';
$string['validationmsg_componentmismatchtype'] = 'Nepoklapanje tipa dodatka';
$string['validationmsg_componentmismatchtype_info'] = 'Očekivan je tip \'{$a->expected}\' ali dodatak prijavljuje svoj tip kao \'{$a->found}\'.';
$string['validationmsg_filenotexists'] = 'Raspakovana datoteka nije nađena';
$string['validationmsg_filesnumber'] = 'Nije pronađeno dovoljno datoteka u arhivi';
$string['validationmsg_filestatus'] = 'Nije moguće raspakovati sve datoteke';
$string['validationmsg_filestatus_info'] = 'Покушај да се распакује датотека {$a->file} резултирао је грешком \'{$a->status}\'.';
$string['validationmsg_foundlangfile'] = 'Pronađena jezička datoteka';
$string['validationmsg_maturity'] = 'Deklarisani nivo zrelosti';
$string['validationmsg_maturity_help'] = 'Dodatak može da deklariše nivo svoje stabilnosti. Ako programer smatra da je dodatak stabilan deklarisani nivo će glasiti MATURITY_STABLE. Sve ostale nivoe (kao što su alfa i beta) treba smatrati nestabilnim, i upozorenje o tome treba navesti.';
$string['validationmsg_missingcomponent'] = 'Dodatak ne daje svoje ime komponente';
$string['validationmsg_missingcomponent_help'] = 'Svi dodaci moraju obezbediti svoj pun naziv komponente putem `$plugin->component` deklaracije u datoteci version.php.';
$string['validationmsg_missingcomponent_link'] = 'Development:version.php';
$string['validationmsg_missingexpectedlangenfile'] = 'Naziv engleske jezičke datoteke se ne poklapa';
$string['validationmsg_missingexpectedlangenfile_info'] = 'Datom tipu dodatka nedostaje engleska jezička datoteka {$a}.';
$string['validationmsg_missinglangenfile'] = 'Engleska jezička datoteka nije pronađena';
$string['validationmsg_missinglangenfolder'] = 'Nedostaje direktorijum engleskog jezika';
$string['validationmsg_missingversion'] = 'Dodatak ne prijavljuje svoju verziju';
$string['validationmsg_missingversionphp'] = 'Datoteka version.php nije pronađena';
$string['validationmsg_multiplelangenfiles'] = 'Pronađeno je više engleskih jezičkih datoteka';
$string['validationmsg_onedir'] = 'Неисптавна структура ZIP архиве';
$string['validationmsg_onedir_help'] = 'ZIP arhiva mora da ima samo jedan osnovni direktorijum koji sadrži kôd dodatka. Naziv osnovnog direktorijuma mora da se poklapa sa nazivom dodatka.';
$string['validationmsg_pathwritable'] = 'Provera pristupa za upis';
$string['validationmsg_pluginversion'] = 'Verzija dodatka';
$string['validationmsg_pluginversiontoolow'] = 'Već je instalirana novija verzija ovog dodatka';
$string['validationmsg_release'] = 'Izdanje dodatka';
$string['validationmsg_requiresmoodle'] = 'Potrebna verzija Moodlea';
$string['validationmsg_rootdir'] = 'Naziv dodatka koji će biti instaliran';
$string['validationmsg_rootdir_help'] = 'Naziv osnovnog direktorijuma u ZIP arhivi formira naziv dodatka koji će biti instaliran. Ako naziv osnovnog direktorijuma nije ispravan, možda ćete želeti ga promenite pre instalacije dodatka.';
$string['validationmsg_rootdirinvalid'] = 'Neispravan naziv dodatka';
$string['validationmsg_rootdirinvalid_help'] = 'Naziv osnovnog direktorijuma u ZIP arhivi narušava zahteve formalne sintakse. Pojedine ZIP arhive, kao što su one koje generiše Github, mogu da sadrže pogrešan naziv osnovnog direktorijuma. Potrebno je da ispravite naziv osnovnog direktorijuma tako da on odgovara nazivu dodatka.';
$string['validationmsg_targetexists'] = 'Odredišni direktorijum već postoji i biće uklonjen';
$string['validationmsg_targetexists_help'] = 'Direktorijum dodatka već postoji i biće zamenjen sadržajem ZIP arhive dodatka.';
$string['validationmsg_targetnotdir'] = 'Odredišni direktorijum je zauzet datotekom';
$string['validationmsg_unknowntype'] = 'Nepoznati tip dodatka';
$string['validationmsg_versionphpsyntax'] = 'Nepodržana sintaksa je otkrivena u datoteci version.php.';
$string['validationmsglevel_debug'] = 'Ukloni grešku';
$string['validationmsglevel_error'] = 'Greška';
$string['validationmsglevel_info'] = 'OK';
$string['validationmsglevel_warning'] = 'Upozorenje';
$string['version'] = 'Verzija';
$string['versiondb'] = 'Trenutna verzija';
$string['versiondisk'] = 'Nova verzija';
