<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'af', version '4.5'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aksie';
$string['actions'] = 'Aksies';
$string['addappointment'] = 'Voeg nog \'n student by';
$string['addcommands'] = 'Voeg gleuwe by';
$string['addondays'] = 'Voeg afsprake by op';
$string['addsession'] = 'Voeg herhaalde gleuwe by';
$string['addsingleslot'] = 'Voeg \'n enkele gleuf by';
$string['addslot'] = 'Jy kan enige tyd addisionele afspraakgleuwe byvoeg';
$string['addstudenttogroup'] = 'Voeg hierdie student by afspraakgroep';
$string['allappointments'] = 'Alle afsprake';
$string['allononepage'] = 'Alle gleuwe op een bladsy';
$string['allowgroup'] = 'Eksklusiewe gleuf - kliek om te verander';
$string['alreadyappointed'] = 'Kan nie die afspraak maak nie. Die gleuf is reeds volbespreek.';
$string['appointagroup_help'] = 'Kies of jy die afspraak slegs vir jouself of vir \'n hele groep wil maak.';
$string['appointfor'] = 'Maak afspraak vir';
$string['appointforgroup'] = 'Maak afsprake vir: {$a}';
$string['appointingstudent'] = 'Afspraak vir gleuf';
$string['appointingstudentinnew'] = 'Afspraak vir nuwe gleuf';
$string['appointment'] = 'Afspraak';
$string['appointmentmode'] = 'Die afspraakmodus word gestel';
$string['appointmentmode_help'] = '<p>Hier kan jy sommige variante waarop afsprake geneem kan word, kies.</p>
<p><ul>
<li><strong>"<emph>n</emph>afsprake in hierdie skeduleerder":</strong> Die student kan slegs \'n vasgestelde aantal afsprake in hierdie aktiwiteit bespreek. Selfs al merk die onderwyser dit as "gesien", sal hulle nie toegelaat word om verdere afsprake te bespreek nie. Die enigste manier om die vermoë van \'n student om te bespreek te herstel, is om die ou "gesien" rekords uit te wis.</li>
<li><strong>"<emph>n</emph> afsprake op \'n slag":</strong> Die student kan \'n vasgestelde aantal afsprake op \'n slag bespreek. Wanneer die ontmoeting verby is en die onderwyser die student as "gesien" merk, kan die student verdere afsprake maak. Die student word egter beperk tot <emph>n</emph> "oop" (nie gesien) gleuwe op enige gegewe tydstip.
</li>
</ul>
</p>';
$string['appointmentno'] = 'Afspraak {$a}';
$string['appointmentnote'] = 'Notas vir afspraak (aan student sigbaar)';
$string['appointments'] = 'Afsprake';
$string['appointmentsgrouped'] = 'Afsprake per gleuf gegroepeer';
$string['appointmentsummary'] = 'Afspraak op {$a->startdate} vanaf {$a->starttime} tot {$a->endtime} met {$a->teacher}';
$string['appointsolo'] = 'net ek';
$string['appointsomeone'] = 'Voeg nuwe afspraak by';
$string['areaappointmentnote'] = 'Dokumente in afspraaknotas';
$string['areaslotnote'] = 'Dokumente in gleufnotas';
$string['areateachernote'] = 'Dokumente in vetroulike notas';
$string['attendable'] = 'Kan bygewoon word';
$string['attendablelbl'] = 'Totale aantal kandidate om te skeduleer';
$string['attended'] = 'Bygewoon';
$string['attendedlbl'] = 'Aantal studente bygewoon';
$string['attendedslots'] = 'Bygewoonde gleuwe';
$string['availableslots'] = 'Beskikbare gleuwe';
$string['availableslotsall'] = 'Alle gleuwe';
$string['availableslotsnotowned'] = 'Nie besit nie';
$string['availableslotsowned'] = 'Besit';
$string['bookaslot'] = 'Bespreek \'n gleuf';
$string['bookingdetails'] = 'Besprekingsbesonderhede';
$string['bookingformoptions'] = 'Besprekingsvorm en data wat deur student verskaf is';
$string['bookinginstructions'] = 'Besprekingsinstruksies';
$string['bookinginstructions_help'] = 'Hierdie teks sal aan studente vertoon word voordat hulle \'n bespreking maak. Dit kan, byvoorbeeld, studente aantoon hoe om die opsionele boodskapveld in te vul, of watter dokumente om op te laai.';
$string['bookslot'] = 'Bespreek gleuf';
$string['bookwithteacher'] = 'Onderwyser';
$string['bookwithteacher_help'] = 'Kies \'n onderwyser vir die afspraak';
$string['break'] = 'Breuk tussen gleuwe';
$string['breaknotnegative'] = 'Die lengte van die breuk kan nie negatief wees nie';
$string['canbook1appointment'] = 'Jy kan meer as een afspraak in hierdie skeduleerder bespreek.';
$string['canbooknappointments'] = 'Jy kan {$a} meer afsprake in hierdie skeduleerder bespreek.';
$string['canbooknofurtherappointments'] = 'Jy kan nie verdere afsprake in hierdie skeduleerder bespreek nie.';
$string['canbooksingleappointment'] = 'Jy kan een afspraak in hierdie skeduleerder bespreek.';
$string['canbookunlimitedappointments'] = 'Jy kan enige hoeveelheid afsprake in hierdie skeduleerder bespreek.';
$string['cancelbooking'] = 'Kanselleer bespreking';
$string['chooseexisting'] = 'Kies bestaande';
$string['choosingslotstart'] = 'Kies aanvangstyd';
$string['choosingslotstart_help'] = 'Verander (of kies) die aanvangstyd van die afspraak. As hierdie afspraak met ander gleuwe bots, sal jy gevra word
of hierdie gleuf alle strydige afsprake vervang. Let daarop dat die nuwe gleufparameters alle vorige
verstellings oorheen sal skryf.';
$string['comments'] = 'Kommentaar';
$string['complete'] = 'Bespreek';
$string['confirmbooking'] = 'Bevestig bespreking';
$string['confirmdelete-all'] = 'Dit sal <b>alle</b> gleuwe in hierdie skeduleerder uitwis. Uitwissing kan nie ongedaan gemaak word nie. Gaan steeds voort?';
$string['confirmdelete-mine'] = 'Dit sal al jou gleuwe in hierdie skeduleerder uitwis. Uitwissing kan nie ongedaan gemaak word nie. Gaan steeds voort?';
$string['confirmdelete-myunused'] = 'Dit sal al jou ongebruikte gleuwe in hierdie skeduleerder uitwis. Uitwissing kan nie ongedaan gemaak word nie. Gaan steeds voort?';
$string['confirmdelete-one'] = 'Wis gleuf uit?';
$string['confirmdelete-selected'] = 'Dit sal die gekose gleuwe uitwis. Uitwissing kan nie ongedaan gemaak word nie. Gaan steeds voort?';
$string['confirmdelete-unused'] = 'Dit sal alle ongebruikte gleuwe in hierdie skeduleerder uitwis. Uitwissing kan nie ongedaan gemaak word nie. Gaan steeds voort?';
$string['confirmrevoke'] = 'Herroep alle afsprake in die huidige gleuf?';
$string['conflictingslots'] = 'Die gleuf op {$a} kan nie bespreek word nie weens botsende gleuwe:';
$string['conflictlocal'] = '{$a->datetime} ({$a->duration} minute) in hierdie skeduleerder';
$string['conflictremote'] = '{$a->datetime} ({$a->duration} minute) in kursus {$a->courseshortname}, skeduleerder {$a->schedulername}';
$string['contentformat'] = 'Formaat';
$string['contentformat_help'] = '<p>Daar is drie basiese keuses vir die uitvoerformaat,
     wat verskil in hoe gleuwe met etlike besprekings hanteer word.
     <dl>
         <dt>Een lyn per gleuf</dt>:
         <dd>
             Die afvoerdokument sal een lyn vir elke gleuf bevat. As \'n gleuf etlike
             afsprake bevat, sal daar - in plaas van die student se naam, ens. - \'n merker "(multiple)" vertoon word.
         </dd>
         <dt>Een lyn per afspraak</dt>:
         <dd>
             Die afvoerdokument sal een lyn vir elke afspraak bevat. As \'n gleuf etlike
             afsprake bevat, sal dit etlike keer in die lys verskyn (met die data daarin wat herhaal word).
         </dd>
         <dt>Afsprake per gleuf gegroepeer</dt>:
         <dd>
             Alle afsprake van een gleuf word saam gegroepeer, voorafgegaan met \'n opskriflyn wat
             die betrokke gleuf aandui. Dit kan moontlik nie goed werk met die CSV-afvoerformaat nie,
             aangesien die aantal kolomme nie konstant is nie.
         </dd>
    </dl>
    Jy kan die effek van hierdie opsies verken deur die "Voorskou"-knoppie te gebruik.</p>';
$string['copytomyself'] = 'Stuur \'n kopie aan myself';
$string['course'] = 'Kursus';
$string['createexport'] = 'Skep uitvoerdokument';
$string['csvfieldseparator'] = 'Veldskeier vir CSV';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'Gesamentlike duur van afsprake';
$string['datatoinclude'] = 'Data om in te sluit';
$string['datatoinclude_help'] = 'Kies die velde wat in die uitvoer ingesluit behoort te word. Elkeen sal in een kolom van die afvoerdokument verskyn.';
$string['date'] = 'Datum';
$string['datelist'] = 'Oorsig';
$string['defaultslotduration'] = 'Verstek duur van gleuf';
$string['defaultslotduration_help'] = 'Die verstek lengte (in minute) vir afspraakgleuwe wat jy opstel';
$string['deleteallslots'] = 'Wis alle gleuwe uit';
$string['deleteallunusedslots'] = 'Wis alle ongebruikte gleuwe uit';
$string['deletecommands'] = 'Wis gleuwe uit';
$string['deletedconflictingslots'] = 'Vir die gleuf op {$a} is botsende gleuwe uitgewis:';
$string['deletemyslots'] = 'Wis al my gleuwe uit';
$string['deleteonsave'] = 'Wis hierdie afspraak uit (wanneer die vorm geberg word)';
$string['deleteselection'] = 'Wis gekose gleuwe uit';
$string['deletetheseslots'] = 'Wis hierdie gleuwe uit';
$string['deleteunusedslots'] = 'Wis my ongebruikte gleuwe uit';
$string['department'] = 'Vanwaar?';
$string['disengage'] = 'Laat los my afsprake';
$string['displayfrom'] = 'Vertoon gleuf aan studente vanaf';
$string['distributetoslot'] = 'Versprei aan die hele groep';
$string['divide'] = 'Verdeel in gleuwe?';
$string['duration'] = 'Duur';
$string['durationrange'] = 'Duur van gleuf moet tussen {$a->min} en {$a->max} minute wees.';
$string['editbooking'] = 'Wysig bespreking';
$string['email_applied_html'] = '<p>Daar is aansoek gedoen om \'n afspraak op {$a->date} om {$a->time},<br/> deur die student <a href="{$a->attendee_url}">{$a->attendee}</a> vir die kursus:

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p>

<p>met die skeduleerder getitel "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" op die webwerf: <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = '<p>Daar is aansoek gedoen om \'n afspraak op {$a->date} om {$a->time},
deur die student {$a->attendee} vir die kursus:

{$a->course_short}: {$a->course}

met die geskeduleerder getitel "{$a->module}" op die webwerf: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Nuwe afspraak';
$string['email_cancelled_html'] = '<p>Jou afspraak op <strong>{$a->date}</strong> om <strong>{$a->time}</strong>,<br/>
met die student <strong><a href="{$a->attendee_url}">{$a->attendee}</a></strong> vir kursus:</p>

<p><strong>{$a->course_short} : <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>in die skeduleerder getitel "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" op die webwerf: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">is gekanselleer of geskuif</span></strong>.</p>';
$string['email_cancelled_plain'] = 'Jou afspraak op {$a->date} om {$a->time},
met die student {$a->attendee} vir kursus:

{$a->course_short} : {$a->course}

in die skeduleerder getitel "{$a->module}" op die webwerf: {$a->site}

is gekanselleer of geskuif.';
$string['email_cancelled_subject'] = '{$a->course_short}: Afspraak is deur \'n student gekanselleer of geskuif';
$string['email_invite_html'] = '<p>Kies asseblief \'n tydgleuf vir \'n afspraak by:</p> <p>{$a->scheduler_url}</p>';
$string['email_invite_subject'] = 'Uitnodiging: {$a->module}';
$string['email_invitereminder_html'] = '<p>Hierdie is net \'n herinnering dat jy nog nie jou afspraak bespreek het nie. Kies asseblief so gou moontlik \'n tydgleuf by:</p><p>{$a->scheduler_url}</p>';
$string['email_invitereminder_subject'] = 'Herinnering: {$a->module}';
$string['email_reminder_html'] = '<p>Jy het \'n naderende afspraak op <strong>{$a->date}</strong> vanaf <strong>{$a->time}</strong> tot <strong>{$a->endtime}</strong><br/>
met <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>.</p>

<p>Plek: <strong>{$a->location}</strong></p>';
$string['email_reminder_plain'] = 'Jy het \'n naderende afspraak
op {$a->date} vanaf {$a->time} tot {$a->endtime}
met {$a->attendant}.

Plek: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Herinnering van afspraak';
$string['email_teachercancelled_html'] = '<p>Jou afspraak op <strong>{$a->date}</strong> om <strong>{$a->time} </strong>,<br/>
met die {$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> vir kursus:</p>

<p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>in die skeduleerder "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" op die webwerf: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">is gekanselleer</span></strong>. Doen asseblief om \'n nuwe gleuf aansoek.</p>';
$string['email_teachercancelled_plain'] = 'Jou afspraak op {$a->date} om {$a->time},
met die {$a->staffrole} {$a->attendant} vir kursus:

{$a->course_short}: {$a->course}

in die skeduleerder getitel "{$a->module}" op die webwerf: {$a->site}

is gekanselleer. Doen asseblief om \'n nuwe gleuf aansoek.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Afspraak deur die onderwyser gekanselleer';
$string['emailreminder'] = 'E-pos \'n herinnering';
$string['emailreminderondate'] = 'E-pos \'n herinnering op';
$string['end'] = 'Einde';
$string['enddate'] = 'Herhaal tydgleuwe tot';
$string['event_appointmentlistviewed'] = 'Skeduleerder se afspraaklys is besigtig';
$string['event_bookingadded'] = 'Skeduleerderbespreking is bygevoeg';
$string['event_bookingformviewed'] = 'Skeduleerderbesprekingsvorm is besigtig';
$string['event_bookingremoved'] = 'Skeduleerder se bespreking is verwyder';
$string['event_slotadded'] = 'Skeduleerdergleuf is bygevoeg';
$string['event_slotdeleted'] = 'Skeduleerdergleuf is uitgewis';
$string['everyone'] = 'Almal';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Eksklusief';
$string['exclusivity'] = 'Eksklusiwiteit';
$string['exclusivity_help'] = '<p>Jy kan \'n beperking stel op die aantal studente wat vir \'n gegewe gleuf kan aansoek doen.</p>
<p>Deur \'n beperking van 1 te stel (verstek), sal beteken dat die gleuf eksklusief vir \'n enkele student is.</p>
<p>Deur \'n beperking van bv. 3 te stel, sal beteken dat tot drie studente daardie gleuf kan bespreek.</p>
<p>Indien versper, kan enige aantal studente die gleuf bespreek, dit sal nooit as "vol" beskou word nie.</p>';
$string['exclusivityoverload'] = 'Hierdie gleuf het {$a} aangewese studente, meer as wat deur hierdie verstelling toegelaat word.';
$string['exclusivitypositive'] = 'Die aantal studente per gleuf moet 1 of meer wees.';
$string['explaingeneralconfig'] = 'Hierdie opsies kan slegs op werfvlak opgestel word, en is van toepassing op alle skeduleerders van hierdie Moodle-installasie.';
$string['export'] = 'Voer uit';
$string['exporthdr'] = 'Voer gleuwe en afsprake uit';
$string['exporttimerange'] = 'Tydomvang';
$string['exporttimerangeall'] = 'Gleuwe in die toekoms en verlede';
$string['exporttimerangefuture'] = 'Slegs toekomstige gleuwe';
$string['exporttimerangepast'] = 'Slegs gleuwe in die verlede';
$string['field-appointmentnote'] = 'Afspraaknota (aan student)';
$string['field-attended'] = 'Bygewoon';
$string['field-date'] = 'Datum';
$string['field-endtime'] = 'Eindtyd';
$string['field-filecount'] = 'Aantal opgelaaide dokumente';
$string['field-grade'] = 'Punt';
$string['field-groupsmulti'] = 'Groepe (etlike kolomme)';
$string['field-groupssingle'] = 'Groepe';
$string['field-groupssingle-label'] = 'Groepe (een kolom)';
$string['field-location'] = 'Plek';
$string['field-maxstudents'] = 'Maks. studente';
$string['field-slotnotes'] = 'Gleufnotas';
$string['field-starttime'] = 'Aanvangstyd';
$string['field-studentemail'] = 'Student e-pos';
$string['field-studentfirstname'] = 'Student voornaam';
$string['field-studentfullname'] = 'Student volle naam';
$string['field-studentidnumber'] = 'Student ID-nommer';
$string['field-studentlastname'] = 'Student se van';
$string['field-studentnote'] = 'Boodskap deur student';
$string['field-studentusername'] = 'Student se gebruikersnaam';
$string['field-teachernote'] = 'Konfidensiële nota (slegs onderwyser)';
$string['fileformat'] = 'Dokumentformaat';
$string['fileformat_help'] = 'Die volgende dokumentformate is beskikbaar:
     <ul>
          <li>Komma-geskeide Waarde (CSV) teksdokumente. Die veldskeier, by verstek \'n komma, kan hieronder gekies word.
               CSV-dokumente kan in die meeste spreitabeltoepassings oopgemaak word;</li>
          <li>Microsoft Excel dokumente (Excel 2007 formaat);</li>
          <li>Open Dokumentspreitabelle (ODS);</li>
          <li>HTML-formaat - \'n webblad wat die afvoertabel vertoon,
                wat d.m.v. die blaaier se drukfunksie gedruk kan word;</li>
          <li>PDF-dokumente. Jy kan tussen landskap- en portretoriëntering kies.</li>
     </ul>';
$string['finalgrade'] = 'Finale punt';
$string['firstslotavailable'] = 'Die eerste gleuf sal op {$a} oopmaak';
$string['forbidgroup'] = 'Groepgleuf - kliek om te verander';
$string['forcewhenoverlap'] = 'Dwing wanneer oorvleuel';
$string['forcewhenoverlap_help'] = '<h3>Dwing gleufskepping wanneer gleuwe oorvleuel</h3>
<p>Hierdie verstelling bepaal hoe nuwe gleuwe hanteer sal word as hulle met ander, reeds bestaande gleuwe oorvleuel.</p>
<p>Indien ontsper, sal die oorvleuelende, bestaande gleuf uitgewis en die nuwe gleuf geskep word.</p>
<p>Indien versper, sal die oorvleuelende, bestaande gleuf behou word en sal \'n nuwe gleuf <em>nie</em> geskep word nie.</p>';
$string['forcewhenoverlap_link'] = 'mod/scheduler/conflict';
$string['forcourses'] = 'Kies studente in kursusse';
$string['friday'] = 'Vrydag';
$string['generalconfig'] = 'Algemene konfigurasie';
$string['grade'] = 'Punt';
$string['gradeingradebook'] = 'Punt in punteboek';
$string['gradingstrategy'] = 'Nasienstrategie';
$string['gradingstrategy_help'] = 'Kies hoe punte versamel word in \'n skeduleerder waar studente etlike afsprake kan hê.
    Die punteboek kan hetsy <ul><li>die gemiddelde punt of</li><li>die maksimum punt</li></ul> wat die student verkry het, vertoon.';
$string['group'] = 'groep';
$string['groupbookings'] = 'Bespreking in groepe';
$string['groupbookings_help'] = 'Laat studente toe om \'n gleuf vir al die lede van hul groep te bespreek.
(Let daarop dat dit apart is van die "groepmodus"-verstelling, wat die gleuwe wat \'n student kan sien, beheer.)';
$string['groupbreakdown'] = 'Volgens groepgrootte';
$string['groupmodeyourgroups'] = 'Groepmodus: {$a->groupmode}. Slegs studente in {$a->grouplist} kan afsprake met jou maak.';
$string['groupmodeyourgroupsempty'] = 'Groepmodus: {$a->groupmode}. Jy is nie \'n lid van enige groep nie, daarom kan studente nie afsprake met jou maak nie.';
$string['groupscheduling'] = 'Ontsper groepskedulering';
$string['groupscheduling_desc'] = 'Laat volledige groepe toe om tegelyk geskeduleer te word.
(Behalwe vir die globale opsie, moet die verstelling in "Bespreking in groepe" ontsper wees in die respektiewe skeduleerdereksemplaar.)';
$string['groupsession'] = 'Groepsessie';
$string['groupsize'] = 'Groepgrootte';
$string['guardtime'] = 'Bewaringstyd';
$string['guardtime_help'] = '\'n Bewaringstyd verhoed dat studente hul bespreking kort voor die afspraak verander.
<p>As die bewaringstyd ontsper is en op, byvoorbeeld, 2 ure gestel is, sal studente nie \'n gleuf kan bespreek wat binne 2 ure begin nie,
en hulle sal nie \'n afspraak kan kanselleer as dit binne 2 ure gaan begin nie.</p>';
$string['guestscantdoanything'] = 'Gaste kan niks hier doen nie.';
$string['howtoaddstudents'] = 'Om studente by die globale omvangbeplanner te voeg, gebruik die rolverstelling vir die module.<br/>Jy kan ook moduleroldefinisies gebruik om die bywoners van jou studente te definieer.';
$string['htmlformat'] = 'HTML';
$string['ignoreconflicts'] = 'Ignoreer skeduleringskonflikte';
$string['ignoreconflicts_help'] = 'As hierdie boks gemerk is, sal die gleuf na die versoekte datum en tyd geskuif word, al bestaan ander gleuwe op dieselfde tyd. Dit kan tot oorvleuelende afsprake vir sommige onderwysers of studente lei, en behoort dus versigtig gebruik te word.';
$string['ignoreconflicts_link'] = 'mod/scheduler/conflict';
$string['includeemptyslots'] = 'Sluit leë gleuwe in';
$string['includeslotsfor'] = 'Sluit gleuwe in vir';
$string['incourse'] = 'in kursus';
$string['introduction'] = 'Inleiding';
$string['isnonexclusive'] = 'Nie-eksklusief';
$string['landscape'] = 'Landskap';
$string['lengthbreakdown'] = 'Volgens tydsduur van gleuf';
$string['limited'] = 'Beperk ({$a} oor)';
$string['location'] = 'Plek';
$string['location_help'] = 'Spesifiseer die geskeduleerde plek van die afspraak.';
$string['markasseennow'] = 'Merk nou as gesien';
$string['markseen'] = 'Nadat jy \'n afspraak met \'n student gehad het, merk hulle asseblief as "Gesien" deur die merkboks naby aan hul gebruikersprent hierbo te kliek.';
$string['maxgrade'] = 'Neem die hoogste punt';
$string['maxstudentlistsize'] = 'Maksimum lengte van studentelys';
$string['maxstudentlistsize_desc'] = 'Die maksimum lengte van die lys van studente wat \'n afspraak moet maak, soos in die onderwyseraansig van die skeduleerder vertoon word. As daar meer studente as dit is, sal geen lys vertoon word nie.';
$string['maxstudentsperslot'] = 'Maksimum aantal studente per gleuf';
$string['maxstudentsperslot_desc'] = 'Groepgleuwe / nie-eksklusiewe gleuwe kan maksimum hierdie aantal studente hê. Let daarop dat die verstelling "onbeperk" ook altyd vir \'n gleuf gekies kan word.';
$string['meangrade'] = 'Neem die gemiddelde punt';
$string['meetingwith'] = 'Afspraak met jou';
$string['meetingwithplural'] = 'Afspraak met jou';
$string['message'] = 'Boodskap';
$string['messagebody'] = 'Boodskapliggaam';
$string['messageprovider:bookingnotification'] = 'Kennisgewing wanneer \'n bespreking gemaak of gekanselleer word';
$string['messageprovider:invitation'] = 'Uitnodiging om \'n gleuf te bespreek';
$string['messageprovider:reminder'] = 'Herinnering van \'n komende afspraak';
$string['messagesent'] = 'Boodskap is aan {$a} ontvangers gestuur';
$string['messagesubject'] = 'Onderwerp';
$string['minutes'] = 'minute';
$string['minutesperslot'] = 'minute per gleuf';
$string['missingstudents'] = '{$a} studente moet nog \'n afspraak maak';
$string['missingstudentsmany'] = '{$a} studente moet nog \'n afspraak maak. Weens die grootte word geen lys vertoon nie.';
$string['mixindivgroup'] = 'Meng individuele- en groepbesprekings';
$string['mixindivgroup_desc'] = 'Waar groepskedulering ontsper is, laat individuele besprekings ook toe.';
$string['mode'] = 'Modus';
$string['modeappointments'] = 'afspraak/afsprake';
$string['modeintro'] = 'Studente kan registreer';
$string['modeoneatatime'] = 'op \'n tyd';
$string['modeoneonly'] = 'in hierdie skeduleerder';
$string['modulename'] = 'Skeduleerder';
$string['modulename_help'] = 'Die skeduleerder-aktiwiteit help jou om afsprake met jou studente te skeduleer.

Onderwysers spesifiseer tydgleuwe vir afsprake, studente kies dan een daarvan op Moodle.
Onderwysers kan weer die uitkoms van die afspraak - en opsioneel \'n punt - binne die skeduleerder aanteken.

Groepskedulering word ondersteun, d.w.s. elke tydgleuf kan etlike studente akkommodeer, en opsioneel is dit moontlik om afsprake vir \'n hele groep op een slag te skeduleer.';
$string['modulename_link'] = 'mod/scheduler/view';
$string['modulenameplural'] = 'Skeduleerders';
$string['monday'] = 'Maandag';
$string['multiple'] = '(veelvuldige)';
$string['myappointments'] = 'My afsprake';
$string['myself'] = 'Ekself';
$string['name'] = 'Naam van Skeduleerder';
$string['needteachers'] = 'Gleuwe kan nie bygevoeg word nie, aangesien hierdie kursus geen onderwysers het nie';
$string['negativerange'] = 'Omvang is negatief. Dit kan nie wees nie.';
$string['never'] = 'Nooit';
$string['nfiles'] = '{$a} dokumente';
$string['noappointments'] = 'Geen afsprake';
$string['noexistingstudents'] = 'Geen studente vir skedulering beskikbaar nie';
$string['nogroups'] = 'Geen groep vir skedulering beskikbaar nie';
$string['noresults'] = 'Geen uitslae.';
$string['noschedulers'] = 'Daar is geen skeduleerders nie';
$string['noslots'] = 'Daar is geen afspraakgleuwe beskikbaar nie.';
$string['noslotsavailable'] = 'Geen gleuwe is tans vir bespreking beskikbaar nie.';
$string['noslotsopennow'] = 'Geen gleuwe is tans vir bespreking oop nie.';
$string['nostudents'] = 'Geen studente geskeduleer nie';
$string['nostudenttobook'] = 'Geen student om te bespreek nie';
$string['note'] = 'Punt';
$string['noteacherforslot'] = 'Geen onderwyser vir die gleuwe nie';
$string['noteachershere'] = 'Geen onderwyser beskikbaar nie';
$string['notenoughplaces'] = 'Jammer, daar is nie genoeg oop afsprake in hierdie gleuf nie.';
$string['notesrequired'] = 'Jy moet teks in hierdie veld invoer voordat jy die gleuf bespreek.';
$string['notifications'] = 'Kennisgewings';
$string['notifications_help'] = 'Wanneer hierdie opsie ontsper word, sal onderwysers en studente kennisgewings ontvang wanneer afsprake gemaak of gekanselleer word.';
$string['notseen'] = 'Nie gesien nie';
$string['now'] = 'Nou';
$string['occurrences'] = 'Gebeurlikhede';
$string['odsformat'] = 'ODS';
$string['on'] = 'op';
$string['onedaybefore'] = '1 dag voor gleuf';
$string['onelineperappointment'] = 'Een lyn per afspraak';
$string['onelineperslot'] = 'Een lyn per gleuf';
$string['oneslotadded'] = '1 gleuf bygevoeg';
$string['oneslotdeleted'] = '1 gleuf uitgewis';
$string['oneweekbefore'] = '1 week voor gleuf';
$string['onthemorningofappointment'] = 'Op die oggend van die afspraak';
$string['options'] = 'Opsies';
$string['otherstudents'] = 'Ander deelnemers';
$string['outlineappointments'] = '{$a->attended} afsprake bygewoon, {$a->upcoming} komend.';
$string['outlinegrade'] = 'Punt: {$a}';
$string['overall'] = 'Algeheel';
$string['overlappings'] = 'Sommige ander gleuwe oorvleuel';
$string['pageperteacher'] = 'Een bladsy vir elke {$a}';
$string['pagination'] = 'Bladsynommering';
$string['pagination_help'] = 'Kies of \'n uitvoer \'n aparte bladsy vir elke onderwyser behoort te bevat.
   In Excel en in ODS-dokumentformaat stem hierdie bladsye ooreen met oortjies (werkskaarte) in die werkboek.';
$string['pdfformat'] = 'PDF';
$string['pdforientation'] = 'PDF-bladsyoriëntering';
$string['pluginadministration'] = 'Skeduleerderadministrasie';
$string['pluginname'] = 'Skeduleerder';
$string['portrait'] = 'Portret';
$string['preview'] = 'Voorskou';
$string['previewlimited'] = '(Voorskou word beperk tot {$a} rye.)';
$string['privacy:metadata:filepurpose'] = 'Dokument gebruik in notas vir die gleuf of afspraak';
$string['privacy:metadata:scheduler_appointment'] = 'Stel \'n student se afspraak in \'n skeduleerder voor';
$string['privacy:metadata:scheduler_appointment:appointmentnote'] = 'Nota deur onderwyser (sigbaar aan student)';
$string['privacy:metadata:scheduler_appointment:appointmentnoteformat'] = 'Formaat van onderwyser se nota';
$string['privacy:metadata:scheduler_appointment:attended'] = 'Of die afspraak bygewoon is';
$string['privacy:metadata:scheduler_appointment:grade'] = 'Punt vir die afspraak';
$string['privacy:metadata:scheduler_appointment:studentid'] = 'Student wat die afspraak gemaak het';
$string['privacy:metadata:scheduler_appointment:studentnote'] = 'Nota deur student';
$string['privacy:metadata:scheduler_appointment:studentnoteformat'] = 'Formaat van student se nota';
$string['privacy:metadata:scheduler_appointment:teachernote'] = 'Nota deur onderwyser (privaat)';
$string['privacy:metadata:scheduler_appointment:teachernoteformat'] = 'Formaat van private onderwysernota';
$string['privacy:metadata:scheduler_slots'] = 'Stel een gleuf in \'n skeduleerder voor';
$string['privacy:metadata:scheduler_slots:appointmentlocation'] = 'Plek van afspraak';
$string['privacy:metadata:scheduler_slots:duration'] = 'Tydsduur van die gleuf in minute';
$string['privacy:metadata:scheduler_slots:exclusivity'] = 'Maksimum aantal studente in die gleuf';
$string['privacy:metadata:scheduler_slots:notes'] = 'Notas oor die gleuf';
$string['privacy:metadata:scheduler_slots:notesformat'] = 'Formaat van die notas';
$string['privacy:metadata:scheduler_slots:starttime'] = 'Aanvangstyd van die gleuf';
$string['privacy:metadata:scheduler_slots:teacherid'] = 'Onderwyser wat met die gleuf geassosieer word';
$string['purgeunusedslots'] = 'Maak ongebruikte gleuwe in die verlede skoon';
$string['recipients'] = 'Ontvangers';
$string['registeredlbl'] = 'Student aangestel';
$string['reminder'] = 'Herinnering';
$string['requireupload'] = 'Oplaai van dokument word vereis';
$string['resetappointments'] = 'Wis afsprake en punte uit';
$string['resetslots'] = 'Wis skeduleerdergleuwe uit';
$string['return'] = 'Terug na kursus';
$string['revealteachernotes'] = 'Onthul onderwysernotas in privaatheidsuitvoere';
$string['revealteachernotes_desc'] = 'As hierdie opsie gekies is, sal konfidensiële onderwysernotas (wat gewoonlik nie aan studente sigbaar is nie)
aan studente in datauitvoerversoeke onthul word, d.w.s. via die privaatheid-API. Jy behoort, gebaseer op individuele gebruik van hierdie veld, te besluit
of dit in datauitvoere vir studente onder die GDPR ingesluit moet word.';
$string['revoke'] = 'Kanselleer die afspraak';
$string['saturday'] = 'Saterdag';
$string['save'] = 'Berg';
$string['savechoice'] = 'Berg my keuse';
$string['saveseen'] = 'Berg gesien';
$string['schedule'] = 'Skeduleer';
$string['scheduleappointment'] = 'Skeduleer afspraak vir {$a}';
$string['schedulecancelled'] = '{$a}: Jou afspraak is gekanselleer of geskuif';
$string['schedulegroups'] = 'Skeduleer volgens groep';
$string['scheduleinnew'] = 'Skeduleer in nuwe gleuf';
$string['scheduleinslot'] = 'Skeduleer in gleuf';
$string['scheduler'] = 'Skeduleerder';
$string['scheduler:addinstance'] = 'Voeg \'n nuwe skeduleerder by';
$string['scheduler:appoint'] = 'Boekgleuwe';
$string['scheduler:attend'] = 'Bywoon studente';
$string['scheduler:canscheduletootherteachers'] = 'Skeduleer afsprake vir ander personeellede';
$string['scheduler:canseeotherteachersbooking'] = 'Sien en blaai deur ander onderwysers se besprekings';
$string['scheduler:disengage'] = 'Hierdie vermoë is verouder en doen niks';
$string['scheduler:editallattended'] = 'Merk studente in alle afsprake as bygewoon / nie bygewoon.';
$string['scheduler:editallgrades'] = 'Wysig punte in alle afsprake.';
$string['scheduler:editallnotes'] = 'Wysig afspraaknotas in alle afsprake.';
$string['scheduler:manage'] = 'Bestuur jou gleuwe en afsprake';
$string['scheduler:manageallappointments'] = 'Bestuur alle skeduleerderdata';
$string['scheduler:seeotherstudentsbooking'] = 'Sien ander studente wat op die gleuf bespreek is';
$string['scheduler:seeotherstudentsresults'] = 'Sien ander studente se uitslae';
$string['scheduler:seeoverviewoutsideactivity'] = 'Gebruik die oorsigskerm om gleuwe buite die huidige skeduleerderaktiwiteit te sien.';
$string['scheduler:viewfullslots'] = 'Sien gleuwe selfs al is hulle volbespreek (in studenteskerm)';
$string['scheduler:viewslots'] = 'Sien gleuwe wat oop vir bespreking is (in studenteskerm)';
$string['schedulestudents'] = 'Skeduleer volgens student';
$string['scopemenu'] = 'Vertoon gleuwe in: {$a}';
$string['scopemenuself'] = 'Vertoon my gleuwe in: {$a}';
$string['search:activity'] = 'Skeduleerder - aktiwiteitinligting';
$string['seen'] = 'Gesien';
$string['selectedtoomany'] = 'Jy het te veel gleuwe geskies. Jy kan nie meer as {$a} kies nie.';
$string['sendinvitation'] = 'Stuur uitnodiging';
$string['sendmessage'] = 'Stuur boodskap';
$string['sendreminder'] = 'Stuur herinnering';
$string['sendreminders'] = 'Stuur e-posherinnerings vir komende afsprake';
$string['sepcolon'] = 'Dubbelpunt';
$string['sepcomma'] = 'Komma';
$string['sepsemicolon'] = 'Kommapunt';
$string['septab'] = 'Tabelkeep';
$string['showemailplain'] = 'Vertoon e-posadresse in skoonteks';
$string['showemailplain_desc'] = 'In die onderwyser se aansig van die skeduleerder, vertoon die e-posadresse van studente wat \'n afspraak benodig in skoonteks, bykomend tot mailto: skakels.';
$string['showparticipants'] = 'Vertoon deelnemers';
$string['slot'] = 'Gleuf';
$string['slot_is_just_in_use'] = 'Jammer, die afspraak is pas deur \'n ander student gekies! Probeer asseblief weer.';
$string['slotdatetime'] = '{$a->shortdatetime} vir {$a->duration} minute';
$string['slotdatetimelabel'] = 'Datum en tyd';
$string['slotdatetimelong'] = '{$a->date}, {$a->starttime} &ndash; {$a->endtime}';
$string['slotdescription'] = '{$a->status} op {$a->startdate} vanaf {$a->starttime} tot {$a->endtime} by {$a->location} met {$a->facilitator}.';
$string['slots'] = 'Gleuwe';
$string['slotsadded'] = '{$a} gleuwe is bygevoeg';
$string['slotsdeleted'] = '{$a} gleuwe is uitgewis';
$string['slottype'] = 'Gleuftipe';
$string['slotupdated'] = '1 gleuf bygewerk';
$string['slotwarning'] = '<strong>Waarskuwing:</strong> Om hierdie gleuf na die gekose tyd te skuif, bots met die gleuf/gleuwe wat hieronder gelys is. Merk "Ignoreer skeduleringskonflikte" as jy die gleuf ten spyte daarvan wil skuif.';
$string['staffbreakdown'] = 'Deur {$a}';
$string['staffrolename'] = 'Rolnaam van die onderwyser';
$string['staffrolename_help'] = 'Die etiket vir die rol wat studente bywoon. Dit is nie noodwendig \'n "onderwyser" nie.';
$string['start'] = 'Begin';
$string['startpast'] = 'Jy kan nie \'n leë afspraakgleuf in die verlede begin nie';
$string['statistics'] = 'Statistieke';
$string['student'] = 'Student';
$string['studentbreakdown'] = 'Deur student';
$string['studentcomments'] = 'Student se boodskap';
$string['studentdetails'] = 'Student se besonderhede';
$string['studentfiles'] = 'Opgelaaide dokumente';
$string['studentmultiselect'] = 'Elke student kan slegs een maal in hierdie gleuf gekies word';
$string['studentnote'] = 'Boodskap deur student';
$string['studentprovided'] = 'Student verskaf: {$a}';
$string['students'] = 'Studente';
$string['sunday'] = 'Sondag';
$string['tab-otherappointments'] = 'Alle afsprake van hierdie student';
$string['tab-otherstudents'] = 'Studente in hierdie gleuf';
$string['tab-thisappointment'] = 'Hierdie afspraak';
$string['teacher'] = 'Onderwyser';
$string['teachernote'] = 'Konfidensiële notas (slegs aan onderwyser sigbaar)';
$string['teachersmenu'] = 'Vertoon gleuwe vir: {$a}';
$string['thiscourse'] = 'hierdie kursus';
$string['thisscheduler'] = 'hierdie skeduleerder';
$string['thissite'] = 'die hele werf';
$string['thursday'] = 'Donderdag';
$string['timefrom'] = 'Van:';
$string['timerange'] = 'Tydomvang';
$string['timeto'] = 'Na:';
$string['totalgrade'] = 'Totale punt';
$string['tuesday'] = 'Dinsdag';
$string['unattended'] = 'Nie bygewoon';
$string['unlimited'] = 'Onbeperk';
$string['unregisteredlbl'] = 'Ontoegewysde studente';
$string['upcomingslots'] = 'Komende gleuwe';
$string['updategrades'] = 'Werk punte by';
$string['updatesingleslot'] = '';
$string['uploadmaxfiles'] = 'Maksimum aantal opgelaaide dokumente';
$string['uploadmaxfiles_help'] = 'Die maksimum aantal dokumente wat \'n student in die besprekingsvorm kan oplaai. Dokumentoplaai is opsioneel tensy die "Dokument oplaai word vereis"-boks gemerk is. Indien op 0 gestel, sal studente nie \'n oplaaiboks vir dokumente sien nie.';
$string['uploadmaxfilesglobal'] = 'Maksimum aantal opgelaaide dokumente';
$string['uploadmaxfilesglobal_desc'] = 'Die maksimum aantal dokumente wat in \'n besprekingsvorm opgelaai kan word. Dit kan verder op die vlak van individuele skeduleerders verminder word.';
$string['uploadmaxsize'] = 'Maksimum dokumentgrootte';
$string['uploadmaxsize_help'] = 'Maksimum dokumentgrootte vir studentoplaaie. Hierdie beperking is per dokument van toepassing.';
$string['uploadrequired'] = 'Jy moet dokumente hier oplaai voordat jy die gleuf bespreek.';
$string['uploadstudentfiles'] = 'Laai dokumente op';
$string['usebookingform'] = 'Gebruik besprekingsvorm';
$string['usebookingform_help'] = 'Indien ontsper, sien student \'n aparte besprekingsvorm voordat hy \'n gleuf kan bespreek. Die besprekingskerm kan van hulle vereis om data in te voer, dokumente op te laai, of \'n captcha op te los; sien opsies hieronder.';
$string['usebookingform_link'] = 'mod/scheduler/bookingform';
$string['usecaptcha'] = 'Gebruik CAPTCHA vir nuwe besprekings';
$string['usecaptcha_help'] = 'Indien ontsper, sal studente \'n CAPTCHA-sekuriteitsvraag moet oplos voordat hulle \'n nuwe bespreking maak.
Gebruik hierdie verstelling as jy vermoed dat studente outomatiese programme gebruik om beskikbare gleuwe te gryp.
<p>Geen captcha sal vertoon word as die student \'n bestaande bespreking wysig nie.</p>';
$string['usenotes'] = 'Gebruik notas vir afsprake';
$string['usenotesboth'] = 'Beide soorte notas';
$string['usenotesnone'] = 'geen';
$string['usenotesstudent'] = 'Afspraaknota, aan onderwyser en student sigbaar';
$string['usenotesteacher'] = 'Konfidensiële nota, slegs aan onderwysers sigbaar';
$string['usestudentnotes'] = 'Laat studente \'n boodskap invoer';
$string['usestudentnotes_help'] = 'Indien ontsper, sal die besprekingskerm \'n teksboks bevat waarin studente \'n boodskap kan invoer. Gebruik "besprekingsinstruksies" hierbo om aan studente te toon watter inligting hulle moet verskaf.';
$string['viewbooking'] = 'Sien besonderhede';
$string['wednesday'] = 'Woensdag';
$string['welcomebackstudent'] = 'Jy kan bykomende gleuwe bespreek deur op die ooreenstemmende "Bespreek Gleuf"-knoppie hieronder te kliek.';
$string['welcomenewstudent'] = 'Die tabel hieronder toon alle beskikbare gleuwe vir \'n afspraak. Maak jou keuse deur op die ooreenstemmende "Bespreek gleuf"-knoppie te kliek. As jy later \'n verandering moet aanbring, kan jy weer hierdie bladsy besoek.';
$string['welcomenewteacher'] = 'Kliek asseblief op die knoppie hieronder om afspraakgleuwe by te voeg.';
$string['what'] = 'Wat?';
$string['whathappened'] = 'Wat het gebeur?';
$string['whatresulted'] = 'Wat was die gevolg?';
$string['when'] = 'Wanneer?';
$string['where'] = 'Waar?';
$string['who'] = 'Saam met wie?';
$string['whosthere'] = 'Wie is daar?';
$string['xdaysbefore'] = '{$a} dae voor gleuf';
$string['xweeksbefore'] = '{$a} weke voor gleuf';
$string['yesallgroups'] = 'Ja, vir alle groepe';
$string['yesingrouping'] = 'Ja, in groepering {$a}';
$string['yesoptional'] = 'Ja, opsioneel vir student';
$string['yesrequired'] = 'Ja, student moet \'n boodskap invoer';
$string['yourappointmentnote'] = 'Kommentaar slegs vir jou';
$string['yourslotnotes'] = 'Kommentaar oor die afspraak';
$string['yourstudentnote'] = 'Jou boodskap';
$string['yourtotalgrade'] = 'Jou totale punt in hierdie aktiwiteit is <strong>{$a}</strong>.';
