<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'el', version '4.5'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Όλα τα παιδιά είναι πλήρη';
$string['competencies'] = 'Προσόντα';
$string['competenciesarenotenabled'] = 'Τα προσόντα δεν έχουν ενεργοποιηθεί.';
$string['competenciessettings'] = 'Ρυθμίσεις προσόντων';
$string['competency'] = 'Προσόν';
$string['competencyframework'] = 'Πλαίσιο προσόντων';
$string['completeplanstask'] = 'Ολοκληρωμένα σχέδια μάθησης που οφείλονται';
$string['coursecompetencyoutcome_complete'] = 'Ολοκλήρωση του προσόντος';
$string['coursecompetencyoutcome_evidence'] = 'Επισυνάψτε αποδεικτικό';
$string['coursecompetencyoutcome_none'] = 'Να μην γίνει τίποτα άλλο';
$string['coursecompetencyoutcome_recommend'] = 'Αποστολή προς εξέταση';
$string['coursemodulecompetencyoutcome_complete'] = 'Ολοκλήρωση του προσόντος';
$string['coursemodulecompetencyoutcome_evidence'] = 'Επισυνάψτε αποδεικτικό';
$string['coursemodulecompetencyoutcome_none'] = 'Να μην γίνει τίποτα άλλο';
$string['coursemodulecompetencyoutcome_recommend'] = 'Αποστολή προς εξέταση';
$string['deletecompetencyratings'] = 'Διαγραφή εκτιμήσεων προσόντος';
$string['duplicateditemname'] = '{$a} (αντίγραφο)';
$string['enablecompetencies'] = 'Ενεργοποίηση προσόντων';
$string['enablecompetencies_desc'] = 'Τα προσόντα επιτρέπουν στους χρήστες να αξιολογούνται σύμφωνα με σχέδια μάθησης.';
$string['errorcannotchangeapastduedate'] = 'Η οφειλόμενη ημερομηνία έχει περάσει· δεν μπορεί να αλλάξει.';
$string['errorcannotsetduedateinthepast'] = 'Η οφειλόμενη ημερομηνία δεν μπορεί να οριστεί στο παρελθόν.';
$string['errorcannotsetduedatetoosoon'] = 'Η οφειλόμενη ημερομηνία είναι πάρα πολύ σύντομα.';
$string['errorcompetencyrule'] = 'Ο κανόνας προσόντος μαθήματος «{$a}» δεν βρέθηκε';
$string['errorcoursecompetencyrule'] = 'Ο κανόνας προσόντος μαθήματος «{$a}» δεν βρέθηκε';
$string['errorinvalidcourse'] = 'Μη έγκυρο μάθημα.';
$string['errornocompetency'] = 'Το προσόν «{$a}» δεν βρέθηκε';
$string['errorplanstatus'] = 'Άγνωστη κατάσταση σχεδίων μάθησης «{$a}»';
$string['errorscalealreadyused'] = 'Η κλίμακα δεν μπορεί να τροποποιηθεί, καθώς είναι ήδη σε χρήση.';
$string['errorscaleconfiguration'] = 'Η κλίμακα χρειάζεται να ρυθμιστεί επιλέγοντας προεπιλεγμένα και προχωρημένα στοιχεία.';
$string['errorusercomptencystatus'] = 'Η κατάσταση προσόντος χρήστη «{$a}» δεν βρέθηκε';
$string['eventcompetencycreated'] = 'Το προσόν δημιουργήθηκε.';
$string['eventcompetencydeleted'] = 'Το προσόν διαγράφηκε.';
$string['eventcompetencyframeworkcreated'] = 'Το πλαίσιο προσόντων δημιουργήθηκε.';
$string['eventcompetencyframeworkdeleted'] = 'Το πλαίσιο προσόντων διαγράφηκε.';
$string['eventcompetencyframeworkupdated'] = 'Το πλαίσιο προσόντων ενημερώθηκε.';
$string['eventcompetencyframeworkviewed'] = 'Το πλαίσιο προσόντων εμφανίστηκε.';
$string['eventcompetencyupdated'] = 'Το προσόν ενημερώθηκε.';
$string['eventcompetencyviewed'] = 'Το προσόν εμφανίστηκε.';
$string['eventevidencecreated'] = 'Το αποδεικτικό δημιουργήθηκε.';
$string['eventplanapproved'] = 'Το σχέδιο μάθησης εγκρίθηκε.';
$string['eventplancompleted'] = 'Το σχέδιο μάθησης ολοκληρώθηκε.';
$string['eventplancreated'] = 'Το σχέδιο μάθησης δημιουργήθηκε.';
$string['eventplandeleted'] = 'Το σχέδιο μάθησης διαγράφηκε.';
$string['eventplanreopened'] = 'Το σχέδιο μάθησης ξανα-άνοιξε.';
$string['eventplanreviewrequestcancelled'] = 'Το αίτημα εξέτασης του σχεδίου μάθησης ακυρώθηκε.';
$string['eventplanreviewrequested'] = 'Έγινε αίτημα εξέτασης του σχεδίου μάθησης.';
$string['eventplanreviewstarted'] = 'Η εξέταση του σχεδίου μάθησης ξεκίνησε.';
$string['eventplanreviewstopped'] = 'Η εξέταση του σχεδίου μάθησης σταμάτησε.';
$string['eventplanunapproved'] = 'Ανακλήθηκε η έγκριση του σχεδίου μάθησης.';
$string['eventplanunlinked'] = 'Το σχέδιο μάθησης αποσυνδέθηκε.';
$string['eventplanupdated'] = 'Το σχέδιο μάθησης ενημερώθηκε.';
$string['eventplanviewed'] = 'Το σχέδιο μάθησης εμφανίστηκε.';
$string['eventtemplatecreated'] = 'Το υπόδειγμα σχεδίου μάθησης δημιουργήθηκε.';
$string['eventtemplatedeleted'] = 'Το υπόδειγμα σχεδίου μάθησης διαγράφηκε.';
$string['eventtemplateupdated'] = 'Το υπόδειγμα σχεδίου μάθησης ενημερώθηκε.';
$string['eventtemplateviewed'] = 'Το υπόδειγμα σχεδίου μάθησης εμφανίστηκε.';
$string['eventusercompetencyplanviewed'] = 'Το πλάνο προσόντων χρήστη εμφανίστηκε.';
$string['eventusercompetencyrated'] = 'Το προσόν του χρήστη εκτιμήθηκε.';
$string['eventusercompetencyratedincourse'] = 'Το προσόν του χρήστη εκτιμήθηκε στο μάθημα.';
$string['eventusercompetencyratedinplan'] = 'Το προσόν του χρήστη εκτιμήθηκε σε ένα σχέδιο μάθησης.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Ακυρώθηκε το αίτημα χρήστη για επανεξέταση προσόντος.';
$string['eventusercompetencyreviewrequested'] = 'Έγινε αίτημα για επανεξέταση προσόντος χρήση.';
$string['eventusercompetencyreviewstarted'] = 'Ξεκίνησε η επανεξέταση προσόντος χρήστη.';
$string['eventusercompetencyreviewstopped'] = 'Σταμάτησε η επανεξέταση προσόντος χρήστη.';
$string['eventusercompetencyviewed'] = 'Εμφανίστηκε το προσόν χρήστη.';
$string['eventusercompetencyviewedincourse'] = 'Το προσόν χρήστη εμφανίστηκε σε ένα μάθημα.';
$string['eventusercompetencyviewedinplan'] = 'Το προσόν χρήστη εμφανίστηκε σε ένα σχέδιο μάθησης.';
$string['eventuserevidencecreated'] = 'Το αποδεικτικό προηγούμενης μάθησης δημιουργήθηκε.';
$string['eventuserevidencedeleted'] = 'Το αποδεικτικό προηγούμενης μάθησης διαγράφηκε.';
$string['eventuserevidenceupdated'] = 'Το αποδεικτικό προηγούμενης μάθησης ενημερώθηκε.';
$string['evidence_competencyrule'] = 'Ο κανόνας του προσόντος ικανοποιήθηκε.';
$string['evidence_coursecompleted'] = 'Το μάθημα «{$a}» ολοκληρώθηκε.';
$string['evidence_coursemodulecompleted'] = 'Η δραστηριότητα «{$a}» ολοκληρώθηκε.';
$string['evidence_courserestored'] = 'Η εκτίμηση επαναφέρθηκε μαζί με το μάθημα «{$a}».';
$string['evidence_evidenceofpriorlearninglinked'] = 'Το αποδεικτικό προηγούμενης μάθησης «{$a}» συνδέθηκε.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Το αποδεικτικό προηγούμενης μάθησης «{$a}» αποσυνδέθηκε.';
$string['evidence_manualoverride'] = 'Η εκτίμηση του προσόντος έγινε μη αυτόματα.';
$string['evidence_manualoverrideincourse'] = 'Η εκτίμηση του προσόντος έγινε μη αυτόματα στο μάθημα «{$a}».';
$string['evidence_manualoverrideinplan'] = 'Η εκτίμηση του προσόντος έγινε μη αυτόματα στο σχέδιο μάθησης «{$a}».';
$string['invalidevidencedesc'] = 'Περιγραφή άκυρου αποδεικτικού';
$string['invalidgrade'] = 'Μη έγκυρη εκτίμηση';
$string['invalidplan'] = 'Άκυρο σχέδιο μάθησης';
$string['invalidtaxonomy'] = 'Μη έγκυρη ταξινομία: {$a}';
$string['invalidurl'] = 'Η διεύθυνση URL δεν είναι έγκυρη. Βεβαιωθείτε ότι ξεκινά με «http://» or «https://».';
$string['nouserplanswithcompetency'] = 'Κανένα σχέδιο μάθησης δεν περιλαμβάνει αυτήν την ικανότητα.';
$string['planstatusactive'] = 'Ενεργό';
$string['planstatuscomplete'] = 'Πλήρες';
$string['planstatusdraft'] = 'Προσχέδιο';
$string['planstatusinreview'] = 'Εξετάζεται';
$string['planstatuswaitingforreview'] = 'Αναμονή για εξέταση';
$string['pointsrequiredaremet'] = 'Οι απαιτούμενοι πόντοι επιτεύχθηκαν';
$string['privacy:evidence:action:complete'] = 'Ολοκλήρωση του προσόντος αν δεν έχει εκτιμηθεί';
$string['privacy:evidence:action:log'] = 'Καταγραφή ενέργειας';
$string['privacy:evidence:action:override'] = 'Παράκαμψη εκτίμησης προσόντος';
$string['privacy:metadata:competency'] = 'Ένα ιστορικό των προσόντων';
$string['privacy:metadata:competency_coursecomp'] = 'Ένα ιστορικό των προσόντων που συνδέονται με ένα μάθημα';
$string['privacy:metadata:competency_coursecompsetting'] = 'Ένα ιστορικό των ρυθμίσεων προσόντων σε ένα μάθημα';
$string['privacy:metadata:competency_evidence'] = 'Ιστορικό αποδεικτικού που επηρεάζει την κατάσταση ενός προσόντος';
$string['privacy:metadata:competency_framework'] = 'Ένα ιστορικό των πλαισίων προσόντων';
$string['privacy:metadata:competency_modulecomp'] = 'Ένα ιστορικό των προσόντων που συνδέονται με ένα άρθρωμα';
$string['privacy:metadata:competency_plan'] = 'Ένα ιστορικό των σχεδίων μάθησης';
$string['privacy:metadata:competency_plancomp'] = 'Ένα ιστορικό των προσόντων σε ένα σχέδιο μάθησης';
$string['privacy:metadata:competency_relatedcomp'] = 'Ένα ιστορικό σχέσεων μεταξύ προσόντων';
$string['privacy:metadata:competency_template'] = 'Ένα ιστορικό των υποδειγμάτων του σχεδίου μάθησης';
$string['privacy:metadata:competency_templatecohort'] = 'Ένα ιστορικό των συνόλων χρηστών που συσχετίζονται με ένα υπόδειγμα σχεδίου μάθησης';
$string['privacy:metadata:competency_templatecomp'] = 'Ένα ιστορικό των προσόντων σε ένα υπόδειγμα σχεδίου μάθησης';
$string['privacy:metadata:competency_usercomp'] = 'Ένα ιστορικό κατάστασης των προσόντων ενός χρήστη';
$string['privacy:metadata:competency_usercompcourse'] = 'Ένα ιστορικό κατάστασης των προσόντων ενός χρήστη σε ένα μάθημα';
$string['privacy:metadata:competency_usercompplan'] = 'Ένα ιστορικό κατάστασης των προσόντων σε ένα σχέδιο μάθησης';
$string['privacy:metadata:competency_userevidence'] = 'Ιστορικό αποδεικτικού προηγούμενης μάθησης';
$string['privacy:metadata:competency_userevidencecomp'] = 'Ιστορικό προσόντων που συσχετίζονται με αποδεικτικό προηγούμενης μάθησης';
$string['privacy:metadata:core_comments'] = 'Σχόλια σχετικά με σχέδια μάθησης και ικανότητες';
$string['privacy:metadata:evidence:action'] = 'Τύπος της ενέργειας που σχετίζεται με το αποδεικτικό';
$string['privacy:metadata:evidence:actionuserid'] = 'Ο χρήστης που εκτελεί την ενέργεια';
$string['privacy:metadata:evidence:desca'] = 'Οι προαιρετικές παράμετροι της μεταφράσιμης περιγραφής αποδεικτικού';
$string['privacy:metadata:evidence:desccomponent'] = 'Το στοιχείο λογισμικού της μεταφράσιμης περιγραφής αποδεικτικού';
$string['privacy:metadata:evidence:descidentifier'] = 'Ένα αναγνωριστικό της περιγραφής της μεταφραστικής μαρτυρίας';
$string['privacy:metadata:evidence:grade'] = 'Ο βαθμός που συσχετίζεται με το αποδεικτικό';
$string['privacy:metadata:evidence:note'] = 'Μια μη μεταφρασμένη σημείωση συνημμένη στο αποδεικτικό';
$string['privacy:metadata:evidence:url'] = 'Μια διεύθυνση URL που συσχετίζεται με το αποδεικτικό';
$string['privacy:metadata:plan:description'] = 'Η περιγραφή του σχεδίου μάθησης';
$string['privacy:metadata:plan:duedate'] = 'Η οφειλόμενη ημερομηνία του σχεδίου μάθησης';
$string['privacy:metadata:plan:name'] = 'Το όνομα του σχεδίου μάθησης';
$string['privacy:metadata:plan:reviewerid'] = 'Το αναγνωριστικό του εξεταστή του σχεδίου μάθησης';
$string['privacy:metadata:plan:status'] = 'Η κατάσταση του σχεδίου μάθησης';
$string['privacy:metadata:plan:userid'] = 'Το αναγνωριστικό του χρήστη στον οποίο ανήκει το σχέδιο μάθησης';
$string['privacy:metadata:timecreated'] = 'Πότε δημιουργήθηκε το ιστορικό';
$string['privacy:metadata:timemodified'] = 'Πότε τροποποιήθηκε το ιστορικό';
$string['privacy:metadata:usercomp:grade'] = 'Ο βαθμός που δόθηκε για το προσόν';
$string['privacy:metadata:usercomp:proficiency'] = 'Εάν επιτεύχθηκε η επάρκεια';
$string['privacy:metadata:usercomp:reviewerid'] = 'Το αναγνωριστικό του εξεταστή';
$string['privacy:metadata:usercomp:status'] = 'Η κατάσταση του προσόντος';
$string['privacy:metadata:usercomp:userid'] = 'Το αναγνωριστικό του χρήστη στον οποίο ανήκει το προσόν';
$string['privacy:metadata:userevidence:description'] = 'Η περιγραφή του αποδεικτικού';
$string['privacy:metadata:userevidence:name'] = 'Το όνομα του αποδεικτικού της προηγούμενης μάθησης';
$string['privacy:metadata:userevidence:url'] = 'Μια διεύθυνση URL που συσχετίζεται με το αποδεικτικό';
$string['privacy:metadata:usermodified'] = 'Ο χρήστης που δημιούργησε ή τροποποίησε το ιστορικό';
$string['privacy:path:plans'] = 'Σχέδια μάθησης';
$string['privacy:path:relatedtome'] = 'Σε σχέση με εμένα';
$string['privacy:path:userevidence'] = 'Αποδεικτικό προηγούμενης μάθησης';
$string['proficient'] = 'Επαρκής';
$string['pushcourseratingstouserplans'] = 'Προώθηση εκτιμήσεων μαθήματος σε ατομικά σχέδια μάθησης';
$string['pushcourseratingstouserplans_desc'] = 'Προεπιλεγμένη τιμή για τη ρύθμιση μαθήματος κατά την ενημέρωση προσωπικών σχεδίων μάθησης όταν εκτιμώνται προσόντα μαθήματος.';
$string['rating'] = 'Αξιολόγηση';
$string['syncplanscohorts'] = 'Συγχρονισμός σχεδίων μέσω υποδειγμάτων σχεδίων μάθησης συνόλων χρηστών';
$string['taxonomy_behaviour'] = 'Συμπεριφορά';
$string['taxonomy_competency'] = 'Προσόν';
$string['taxonomy_concept'] = 'Έννοια';
$string['taxonomy_domain'] = 'Τομέας';
$string['taxonomy_indicator'] = 'Δείκτης';
$string['taxonomy_level'] = 'Επίπεδο';
$string['taxonomy_outcome'] = 'Μαθησιακό Αποτέλεσμα';
$string['taxonomy_practice'] = 'Πρακτική';
$string['taxonomy_proficiency'] = 'Επάρκεια';
$string['taxonomy_skill'] = 'Δεξιότητα';
$string['taxonomy_value'] = 'Τιμή';
$string['usercommentedonacompetency'] = 'Ο/Η {$a->fullname} έκανε ένα σχόλιο για τη δεξιότητα «{$a->competency}»:

{$a->comment}

Δείτε: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>Ο/Η {$a->fullname} έκανε ένα σχόλιο για το προσόν «{$a->competency}»:</p>
<div>{$a->comment}</div>
<p>Δείτε: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = 'Ο/Η {$a->fullname} έκανε ένα σχόλιο για το προσόν «{$a->competency}».';
$string['usercommentedonacompetencysubject'] = 'Ο/Η {$a} έκανε ένα σχόλιο για κάποιο προσόν.';
$string['usercommentedonaplan'] = 'Ο/Η {$a->fullname} σχολίασε για το σχέδιο μάθησης «{$a->plan}»:

{$a->comment}

Δείτε: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>Ο/Η {$a->fullname} σχολίασε για το σχέδιο μάθησης «{$a->plan}»:</p>
<div>{$a->comment}</div>
<p>Δείτε: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = 'Ο/Η {$a->fullname} σχολίασε το σχέδιο μάθησης «{$a->plan}».';
$string['usercommentedonaplansubject'] = 'Ο/Η {$a} σχολίασε για ένα σχέδιο μάθησης.';
$string['usercompetencystatus_idle'] = 'Σε αδράνεια';
$string['usercompetencystatus_inreview'] = 'Εξετάζεται';
$string['usercompetencystatus_waitingforreview'] = 'Σε αναμονή για εξέταση';
$string['userplans'] = 'Σχέδια μάθησης';
