<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_afterburner', language 'ja', version '4.5'.
 *
 * @package     theme_afterburner
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
 <div class="theme_screenshot">

 <h2>Afterburner</h2>
 <img src="afterburner/pix/screenshot.jpg" />

 <h3>Theme Discussion Forum:</h3>
 <p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

 <h3>Theme Credits</h3>
 <p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>

 <h3>Theme Documentation:</h3>
 <p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p><h3>Report a bug:</h3><p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
 </div>
 <div class="theme_description">
 <h2>About</h2>
 <p>Afterburner is a three-column, fluid-width theme coded for Moodle 2.0. It makes use of custom menus that appear below the site title on every page. An added function, which allows users to login and logout, has now been integrated into the custom menu for this theme.</p>

 <h2>Parents</h2>
 <p>This theme is built on Base, a parent theme included in the Moodle core. If you wish to modify aspects of this theme, beyond the settings offered, we advise creating a new theme using this theme and Base theme as parent themes, so any updates to these parent themes, in the core, will find their way into your new theme.</p>

 <h2>Credits</h2>
 <p>This design was originally created for Moodle 1.9 by Patrick Malley of NewSchool Learning (www.newschoollearning.com)from an original design by Rocket Themes (www.rockettheme.com) before being ported to Moodle 2.0 by Mary Evans of NewSchool Learning (contact@newschoollearning.com).</p>

 <h2>License</h2>
 <p>This, and all other themes included in the Moodle core, are licensed under the <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
 </div>
 </div>';
$string['configtitle'] = 'Afterburnerカスタム設定';
$string['customcss'] = 'カスタムCSS';
$string['customcssdesc'] = 'このテーマのカスタマイズを容易にするようあなたがここで入力したCSSはすべてのページに追加されます。';
$string['footnote'] = 'フットノート';
$string['footnotedesc'] = 'このテキストエリアのコンテンツはすべてのページのフッタに表示されます。';
$string['logo'] = 'ロゴ';
$string['logodesc'] = 'このテーマのデフォルトロゴを置換したい場合、あなたのカスタムロゴを追加してください。<br />ご参考までに、デフォルトロゴイメージの幅は320px、高さは75pxのJPGイメージです。';
$string['pluginname'] = 'Afterburner';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
