<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_outage', language 'nl', version '4.5'.
 *
 * @package     auth_outage
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allowedipsempty'] = 'Wanneer de lijst met toegestane IP\\\'s leeg is, blokkeren we niemand. Je kunt je eigen IP-adres (<i>{$a->ip}</i>) toevoegen en alle andere IP\\\'s blokkeren.';
$string['allowedipshasmyip'] = 'Jouw IP (<i>{$a->ip}</i>) staat in de lijst en je wordt niet geblokkeerd tijdens een onderhoudsvenster.';
$string['allowedipshasntmyip'] = 'Jouw IP (<i>{$a->ip}</i>) staat niet in de lijst en je wordt geblokkeerd tijdens een onderhoudsvenster.';
$string['allowedipsnoconfig'] = 'Jouw config.php heeft niet de extra setup om te blokkeren via IP.<br />Raadpleeg ons <a href="https://github.com/catalyst/moodle-auth_outage#installation" target="_blank">README.md</a> bestand voor meer informatie.';
$string['auth_outagedescription'] = 'Hulpprogramma dat gebruikers waarschuwt voor een toekomstig onderhoudsvenster en hen verhindert in te loggen zodra het onderhoud begint.';
$string['autostart'] = 'Automatisch starten van onderhoudsmodus.';
$string['autostart_help'] = 'Indien geselecteerd, zal het Moodle-onderhoudsmodus automatisch inschakelen als het onderhoudsvenster begint.';
$string['builtinallowediplist'] = 'Ingebouwde toegestane IP-lijst';
$string['builtinallowediplist_desc'] = 'Een tweede toegestane IP-lijst die het makkelijker maakt om sommige IP\\\'s geforceerd in config.php te hebben en anderen bewerkbaar in de UI';
$string['clicreateexamples'] = 'Maak een onderhoudsvenster aan dat begint over 10 seconden\\n\\n> php create.php -s=10';
$string['clicreatehelp'] = 'Maakt een nieuw onderhoudsvenster aan.';
$string['clicreateparamautostart'] = 'moet Y of N zijn, stelt in of het onderhoudsvenster automatisch de onderhoudsmodus activeert.';
$string['clicreateparamblock'] = 'blokkeert tot het onderhoudsvenster begint.';
$string['clicreateparamclone'] = 'kloon een ander onderhoudsvenster behalve voor de starttijd.';
$string['clicreateparamdescription'] = 'de beschrijving van het onderhoudsvenster.';
$string['clicreateparamduration'] = 'hoeveel seconden moet het onderhoudsvenster duren.';
$string['clicreateparamhelp'] = 'toont hulp voor parameters.';
$string['clicreateparamonlyid'] = 'toont alleen de nieuwe id van het onderhoudsvenster, handig voor scripts.';
$string['clicreateparamstart'] = 'over hoeveel seconden moet dit onderhoudsvenster beginnen of unix-tijd om onderhoudsvenster te starten. Verplicht.';
$string['clicreateparamtitle'] = 'de titel van het onderhoudsvenster.';
$string['clicreateparamwarn'] = 'hoeveel seconden voordat het onderhoud begint een waarschuwing te geven.';
$string['clierrorinvalidvalue'] = 'Ongeldige waarde voor parameter: {$a->param}';
$string['clierrorinvalidvalueemptystring'] = 'Param --{$a->param} mag geen lege string zijn';
$string['clierrorinvalidvaluenegativenumber'] = 'Param --{$a->param} moet een positief nummer zijn';
$string['clierrorinvalidvaluenotbool'] = 'Param --{$a->param} moet ingesteld worden op Y of N';
$string['clierrorinvalidvaluenotid'] = 'Param --{$a->param} moet een id-nummer zijn';
$string['clierrorinvalidvaluenotnumber'] = 'Param --{$a->param} moet een nummer zijn';
$string['clierrorinvalidvaluenotstring'] = 'Param --{$a->param} moet een string zijn';
$string['clierrormissingparamaters'] = 'U moet de starttijd specificeren, gebruik --help voor meer informatie.';
$string['clierroroutagechanged'] = 'Onderhoudsvenster is gewijzigd tijdens het wachten.';
$string['clierroroutageended'] = 'Onderhoudsvenster is al beëindigd.';
$string['clierroroutagenotfound'] = 'Onderhoudsvenster niet gevonden.';
$string['clifinishhelp'] = 'Beëindigt een actief onderhoudsvenster.';
$string['clifinishnotongoing'] = 'Er is geen actief onderhoudsvenster.';
$string['clifinishparamactive'] = 'beëindigt het momenteel actieve onderhoudsvenster.';
$string['clifinishparamhelp'] = 'toont hulp voor parameters.';
$string['clifinishparamoutageid'] = 'de id van het te beëindigen onderhoudsvenster.';
$string['cliinmaintenancemode'] = 'Moodle onderhoudsmodus is ingeschakeld. Gebruik "php admin/cli/maintenance.php --disable" om het uit te schakelen voordat u het onderhoudsvenster beëindigt.';
$string['clioutagecreated'] = 'Onderhoudsvenster aangemaakt, id: {$a->id}';
$string['cliwaitforiterroridxoractive'] = 'Je moet de parameter --outageid=# of --active gebruiken, maar niet beide.';
$string['cliwaitforithelp'] = 'Wacht tot een onderhoudsvenster begint.';
$string['cliwaitforitoutagestarted'] = 'Onderhoudsvenster gestart!';
$string['cliwaitforitoutagestartingin'] = 'Onderhoudsvenster start over {$a->countdown}.';
$string['cliwaitforitparamactive'] = 'wacht op het momenteel actieve onderhoudsvenster.';
$string['cliwaitforitparamhelp'] = 'toont parameterhulp.';
$string['cliwaitforitparamoutageid'] = 'het id van het onderhoudsvenster om te wachten tot het start.';
$string['cliwaitforitparamsleep'] = 'maximaal aantal seconden voordat statusoutput wordt weergegeven.';
$string['cliwaitforitparamverbose'] = 'schakel gedetailleerde modus in.';
$string['clone'] = 'Klonen';
$string['configurationdisabled'] = 'De authenticatieplugin \\\'Onderhoudsvenster\\\' is uitgeschakeld. Activeer deze in de site-administratie en probeer het opnieuw.';
$string['configurationinaccessiblewwwroot'] = 'Kon geen toegang krijgen tot <b>{$a->wwwroot}</b> vanaf de server, aanmaken van onderhoudsvensters kan mislukken.';
$string['configurationwarning'] = 'De plugin voor onderhoudsvenster is niet correct geconfigureerd, raadpleeg de <a href="https://github.com/catalyst/moodle-auth_outage/blob/master/README.md#installation" target="_blank">README.md</a> voor meer informatie.';
$string['datetimeformat'] = '%a %d %h %Y om %I:%M%P %Z';
$string['defaultdescription'] = 'Beschrijving';
$string['defaultdescriptiondescription'] = 'Standaard waarschuwingsbericht voor onderhoudsvensters. Gebruik {{start}} en {{stop}} placeholders indien nodig.';
$string['defaultdescriptionvalue'] = 'Er is een gepland onderhoud van {{start}} tot {{stop}} en ons systeem zal tijdens die tijd niet beschikbaar zijn.';
$string['defaultlayoutcss'] = 'Indeling CSS';
$string['defaultlayoutcssdescription'] = 'Deze CSS-code kan worden gebruikt om de CSS van de Onderhoudswaarschuwingsbalk te overschrijven.';
$string['defaultoutageautostart'] = 'Automatische start onderhoudsvenster';
$string['defaultoutageautostartdescription'] = 'Als het onderhoudsvenster automatisch de onderhoudsmodus moet activeren zodra het begint, waardoor de hele site wordt vergrendeld.';
$string['defaultoutageduration'] = 'Duur onderhoudsvenster';
$string['defaultoutagedurationdescription'] = 'Standaardduur (in minuten) van een onderhoudsvenster.';
$string['defaulttime'] = 'Standaardtijd';
$string['defaulttimedescription'] = 'De standaardtijd voor het volgende onderhoudsvenster, uitgedrukt in natuurlijke taal bijv "volgende donderdag 19u". Zie <a target=_blank href="https://www.php.net/manual/en/datetime.formats.relative.php">PHP relatieve datums</a>';
$string['defaulttitle'] = 'Titel';
$string['defaulttitledescription'] = 'Standaardtitel voor onderhoudsvensters. Gebruik {{start}} en {{stop}} placeholders indien nodig.';
$string['defaulttitlevalue'] = 'Systeem uitgeschakeld van {{start}} gedurende {{duration}}';
$string['defaultwarningduration'] = 'Duur van de waarschuwing';
$string['defaultwarningdurationdescription'] = 'Standaard waarschuwingstijd (in minuten) voor onderhoudsvensters.';
$string['description'] = 'Openbare Beschrijving';
$string['description_help'] = 'Een volledige beschrijving van het onderhoudsvenster, zichtbaar voor alle gebruikers.';
$string['finish'] = 'Beëindigen';
$string['info15secondsbefore'] = '15 seconden vooraf';
$string['infoendofoutage'] = 'einde van onderhoudsvenster';
$string['infofrom'] = 'Van:';
$string['infohidewarning'] = 'geen waarschuwingsbalk';
$string['infopagestaticgenerated'] = 'Deze waarschuwing is gegenereerd op {$a->time}.';
$string['infostart'] = 'start';
$string['infostartofwarning'] = 'start van waarschuwing';
$string['infostaticpage'] = 'statische pagina';
$string['infountil'] = 'Tot:';
$string['ips_combine'] = 'De hierboven vermelde IP\'s worden gecombineerd met de hieronder vermelde IP\'s.';
$string['logformaintmodeconfig'] = 'Update onderhoudsmodus configuratie.';
$string['logformaintmodeconfigcomplete'] = 'Updaten van onderhoudsmodus configuratie voltooid.';
$string['menumanage'] = 'Beheer onderhoudsvensters';
$string['menusettings'] = 'Instellingen';
$string['messageoutagebackonline'] = 'We zijn weer online!';
$string['messageoutagebackonlinedescription'] = 'Je kan veilig verder werken.';
$string['messageoutageongoing'] = 'Terug online op {$a->stop}.';
$string['messageoutagewarning'] = 'Sluit af in {{countdown}}';
$string['na'] = 'n/b';
$string['notfound'] = 'Geen onderhoudsvensters gevonden.';
$string['outage:viewinfo'] = 'Bekijk informatie over het onderhoudsvenster';
$string['outageclone'] = 'Kloon onderhoudsvenster';
$string['outageclonecrumb'] = 'Kloon';
$string['outagecreate'] = 'Maak een onderhoudsvenster aan';
$string['outagecreatecrumb'] = 'Aanmaken';
$string['outagedelete'] = 'Verwijder onderhoudsvenster';
$string['outagedeletewarning'] = 'Je staat op het punt om het onderstaande onderhoudsvenster permanent te verwijderen. Dit kan niet ongedaan gemaakt worden.';
$string['outageduration'] = 'Duur van het onderhoudsvenster';
$string['outageduration_help'] = 'Hoe lang het onderhoudsvenster duurt nadat het begonnen is.';
$string['outagedurationerrorinvalid'] = 'Duur van het onderhoudsvenster moet positief zijn.';
$string['outageedit'] = 'Bewerk onderhoudsvenster';
$string['outageeditcrumb'] = 'Bewerken';
$string['outagefinish'] = 'Onderhoudsvenster afsluiten';
$string['outagefinishwarning'] = 'Je staat op het punt dit onderhoudsvenster als voltooid te markeren. Het systeem zal onmiddellijk weer online zijn.';
$string['outageslistfuture'] = 'Geplande onderhoudsvensters';
$string['outageslistpast'] = 'Geschiedenis van onderhoudsvensters';
$string['pluginname'] = 'Beheerder van onderhoudsvensters';
$string['privacy:no_data_reason'] = 'De Onderhoudsvenster authenticatie plugin slaat geen persoonlijke gegevens op.';
$string['removeselectors'] = 'Selectors verwijderen';
$string['removeselectorsdescription'] = 'CSS-selectors verwijderen bij het genereren van een statische thema-onderhoudspagina. Eén selector per regel.';
$string['settingssectiondefaults'] = 'Standaardparameters voor onderhoudsvensters';
$string['settingssectiondefaultsdescription'] = 'Configureer de standaardwaarden die gebruikt worden bij het maken van nieuwe onderhoudsvensters.';
$string['settingssectionplugin'] = 'Pluginconfiguratie';
$string['settingssectionplugindescription'] = 'Algemene instellingen voor het beheren van onderhoudsvensters.';
$string['starttime'] = 'Startdatum en -tijd';
$string['starttime_help'] = 'Op welke datum en tijd het onderhoudsvenster begint, waardoor algemene toegang tot het systeem wordt voorkomen.';
$string['tableheaderduration'] = 'Duur';
$string['tableheaderdurationactual'] = 'Werkelijke duur';
$string['tableheaderdurationplanned'] = 'Geplande duur';
$string['tableheaderstartedtime'] = 'Begonnen op';
$string['tableheaderstarttime'] = 'Begint op';
$string['tableheadertitle'] = 'Titel';
$string['tableheaderwarnbefore'] = 'Waarschuwt vooraf';
$string['tablestarttimefutureformat'] = '{$a->absolute}<br />In {$a->relative}';
$string['tablestarttimepastformat'] = '{$a->absolute}<br />{$a->relative} geleden';
$string['taskupdatestaticpage'] = 'Update statische onderhoudspagina';
$string['textplaceholdershint'] = 'Je kunt {{start}}, {{stop}} en {{duration}} gebruiken als placeholders in de titel en beschrijving.';
$string['title'] = 'Titel';
$string['title_help'] = 'Een korte titel voor dit onderhoudsvenster. Deze wordt weergegeven op de waarschuwingsbalk en op de kalender.';
$string['titleerrorinvalid'] = 'Titel mag niet leeg zijn.';
$string['titleerrortoolong'] = 'Titel mag niet meer dan {$a} tekens hebben.';
$string['warningduration'] = 'Waarschuwingsduur';
$string['warningduration_help'] = 'Hoe lang voor het begin van het onderhoudsvenster moet de waarschuwing worden weergegeven.';
$string['warningdurationerrorinvalid'] = 'Waarschuwingsduur moet positief zijn.';
$string['warningreenablemaintenancemode'] = 'Let op: door dit onderhoudsvenster op te slaan, wordt de onderhoudsmodus opnieuw ingeschakeld.<br />Vink "Automatisch starten van onderhoudsmodus" uit als u dit wilt voorkomen.';
