<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_exaport', language 'sl', version '4.5'.
 *
 * @package     block_exaport
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'O meni';
$string['aboutme_description'] = 'Vnaprej določen z informacijami iz življenjepisa, vendar ga je mogoče urejati za vsak blok';
$string['accessoptions'] = 'Možnosti dostopa';
$string['add'] = 'Dodaj';
$string['addButton'] = 'Dodaj';
$string['add_directory_structure'] = 'Dodaj strukturo';
$string['add_this_file'] = 'Dodaj datoteko';
$string['addbookmark'] = 'Dodaj zaznamek';
$string['addcategory'] = 'Dodaj kategorijo';
$string['addcomment'] = 'Dodaj komentar';
$string['addposterror'] = 'Pri dodajanju objave, v bazo, se je pojavila napaka';
$string['addstdcat'] = 'Uvoz standardnih kategorij';
$string['attachincluded'] = 'Priponka?';
$string['attachment'] = 'Priponka';
$string['autofillview'] = 'Samodejno dodajte vsa razpoložljiva dokazila v ta pogled';
$string['awaiting'] = '($a čakam...)';
$string['back'] = 'Nazaj';
$string['back_to_desp'] = 'Nazaj na seznam jezikov';
$string['backtocourse'] = 'Nazaj na predmet';
$string['badges_help'] = 'Seznam z značkami, ki so vam bile podeljene<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Oglejte si svoje značke</a>
block_exaport/badges_help';
$string['badsessionkey'] = 'Nepravilen ključ seje';
$string['block_exaport_allowcustomlayout_body'] = 'Omogoča uporabo nastavitev postavitve pogleda po meri (podobno spodnjim možnostim) za lastnike pogledov';
$string['block_exaport_allowcustomlayout_head'] = 'Možnosti za postavitev Pogleda po meri za lastnike pogleda';
$string['block_exaport_app_alloweditdelete_body'] = 'Uporabno samo v kombinaciji z Exabis Competence Grid in dakoro';
$string['block_exaport_app_alloweditdelete_head'] = 'Učenci lahko urejajo in brišejo predmete po učiteljevem pregledu';
$string['block_exaport_app_externaleportfolio_body'] = 'Za aplikacijo';
$string['block_exaport_app_externaleportfolio_head'] = 'Shrani datoteke v maharo, če je označeno, shrani v exaport, če ni označeno';
$string['block_exaport_confirm_profilefield_create'] = 'Ali res želite dodati zahtevano polje profila?';
$string['block_exaport_confirm_profilefield_exists'] = 'Polje profila za zaupanja vrednega učitelja že obstaja';
$string['block_exaport_copytomyportfolio'] = 'Omogoči »Kopiraj v moj listovnik«';
$string['block_exaport_copytomyportfolio_body'] = 'Uporabnik bo lahko kopiral dokazila iz skupne kategorije v svoj listovnik';
$string['block_exaport_maxbytes'] = 'Največja velikost naložene datoteke v E-listovnik Exabis';
$string['block_exaport_maxbytes_body'] = 'To določa največjo velikost naloženih datotek v celotnem eE-listovniku Exabis.<br> Vrednost za celotno spletno mesto je: {$a->sitemaxbytes}. Glejte <a href="{$a->settingsurl}">settings</a>';
$string['block_exaport_multiplefilesinitem'] = 'Več datotek v dokazilih »Datoteka«.';
$string['block_exaport_multiplefilesinitem_body'] = 'Omejitev: 10 datotek';
$string['block_exaport_profilefield_created'] = 'Dodano je bilo polje profila za zaupanja vrednega učitelja';
$string['block_exaport_teachercanseeartifactsofstudents_body'] = 'Zaupanja vredne učitelje je treba urediti v njihovih individualnih profilih. To bo delovalo le, če je aktivirana zgornja možnost.<br />{$a}Seznam študentov za vsakega zaupanja vrednega učitelja se ustvari glede na njihove vpise v tečaje.<br />Učenci tega dostopa ne morejo onemogočiti. Dostop drugim uporabnikom je mogoče omogočiti kot prej.';
$string['block_exaport_teachercanseeartifactsofstudents_configurationlink'] = 'Dodajte zahtevano polje uporabniškega profila';
$string['block_exaport_teachercanseeartifactsofstudents_head'] = 'Učitelj lahko vidi VSA dokazila lastnih učencev';
$string['block_exaport_userquota'] = 'Uporabniška kvota za E-listovnik Exabis';
$string['block_exaport_userquota_body'] = 'Največje število bajtov, ki jih lahko uporabnik shrani v svoj E-listovnik Exabis.<br> Vrednost za celotno spletno mesto je: {$a->bytes}. Glejte <a href="{$a->settingsurl}">nastavitve</a>';
$string['blockcontent'] = 'Vsebina bloka';
$string['blocktitle'] = 'E-listovnik Exabis';
$string['blocktitle2'] = 'Naslov bloka';
$string['bookmarknotfound'] = 'Zaznamka ni bilo mogoče najti.';
$string['bookmarksall'] = 'Vse postavke';
$string['bookmarksfiles'] = 'Datoteke';
$string['bookmarkslinks'] = 'Povezave';
$string['bookmarksnotes'] = 'Opombe';
$string['browsecategory'] = 'Brskajte po tej kategoriji';
$string['browseportfolio'] = 'Prebrskajte po tem listovniku';
$string['cancelButton'] = 'Prekliči';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorije';
$string['category_not_found'] = 'Kategorija ni bila najdena';
$string['category_up'] = 'Nazaj na nadrejeno kategorijo';
$string['categorydeleted'] = 'Kategorija je izbrisana.';
$string['categoryedited'] = 'Kategorija je shranjena.';
$string['categoryhead'] = 'Ime kategorije';
$string['categorynotempty'] = 'Kategorijo morate izbrati.';
$string['categorysaved'] = 'Kategorija je dodana.';
$string['change'] = 'Spremeni';
$string['change_layout'] = 'Spremeni razpored';
$string['checkall'] = 'Preveri vse';
$string['chooselayout'] = 'Izberite postavitev stolpcev na vaši strani.';
$string['clearAllFilers'] = 'Počisti vse filtre';
$string['clicktodownloadscorm'] = 'Pritisnite gumb za prenos datoteke SCORM:';
$string['close'] = 'Zapri';
$string['cofigureblock'] = 'Nastavi blok';
$string['cofigureblock_badge'] = 'Izberi značke';
$string['cofigureblock_cvinfo'] = 'Izberite podatke o življenjepisu';
$string['cofigureblock_cvinfo_certif'] = 'Certifikati, akreditacije in nagrade';
$string['cofigureblock_cvinfo_cover'] = 'O meni';
$string['cofigureblock_cvinfo_cover_actual'] = 'Dodajte dejansko vsebino življenjepisa "O meni".';
$string['cofigureblock_cvinfo_education_history'] = 'Izobraževanje';
$string['cofigureblock_cvinfo_employment_history'] = 'Zaposlitev';
$string['cofigureblock_cvinfo_goals'] = 'Cilji';
$string['cofigureblock_cvinfo_help'] = 'Trenutno stanje izbranih postavk boste videli v svojem življenjepisu. Vsebina bloka bo posodobljena, če boste spremenili katero koli postavko v svojem življenjepisu.';
$string['cofigureblock_cvinfo_interests'] = 'Zanimanja';
$string['cofigureblock_cvinfo_mbrship'] = 'Članstva';
$string['cofigureblock_cvinfo_public'] = 'Knjige in publikacije';
$string['cofigureblock_cvinfo_skills'] = 'Moje veščine';
$string['cofigureblock_cvinfo_withfiles'] = 'S priloženimi datotekami';
$string['cofigureblock_header'] = 'Izberi naslov';
$string['cofigureblock_item'] = 'Izberi dokazilo';
$string['cofigureblock_media'] = 'Izberi medij';
$string['cofigureblock_personalinfo'] = 'Izberi osebne podatke';
$string['cofigureblock_text'] = 'Izberi besedilo';
$string['comment'] = 'Komentar';
$string['comment_delete_confirmation'] = 'Ali res želite izbrisati ta komentar?';
$string['commentnotfound'] = 'Komentarja ni bilo mogoče najti';
$string['comments'] = 'Komentarji';
$string['commentshouldnotbeempty'] = 'Komentar morate vnesti.';
$string['competenceinteraction'] = 'Dovoli interakcijo z blokom Exabis Competence Grid, če je nameščen';
$string['competences'] = 'Kompetence';
$string['competences_old_version'] = 'Na tem moodlu je nameščena zastarela različica kompetenc Exabis, ki je E-listovnik Exabis ne podpira več.';
$string['config_feature_copy_to_course'] = 'Omogočite študentom, da kopirajo datoteke E-listovnika v svoje tečaje';
$string['configureblock_cvinfo_group_by_category'] = 'Prikaz elementov življenjepisa v kategorijah';
$string['contactcomps'] = 'Strni vse';
$string['copycategory'] = 'Kopiraj v moj listovnik';
$string['copyitemtocourse'] = 'Kopiraj v predmet';
$string['couldninsertcomment'] = 'Komentarja ni bilo mogoče vstaviti!';
$string['couldntcopyfile'] = 'Datoteke za $a ni bilo mogoče kopirati. Datoteka ni uvožena.';
$string['couldntcreatedirectory'] = 'Mape ni bilo mogoče ustvariti';
$string['couldntcreatetempdir'] = 'Začasne mape ni bilo mogoče ustvariti!';
$string['couldntextractscormfile'] = 'Datoteke SCORM ni bilo mogoče razpakirati!';
$string['couldntinsert'] = '$a ni bilo mogoče dodati v podatkovno zbirko';
$string['couldntinsertcategory'] = 'Kategorije ni bilo mogoče vstaviti!';
$string['couldntinsertdesc'] = 'Opisa ni bilo mogoče vstaviti!';
$string['couldntupdatecategory'] = 'Kategorije ni bilo mogoče posodobiti!';
$string['couldntupdatedesc'] = 'Vašega opisa ni bilo mogoče posodobiti!';
$string['course'] = 'Predmet';
$string['create_as_note'] = 'Ustvari kot dokazilo';
$string['create_view_content_help_text'] = '<ul> <li><strong>Načrtujte svojo postavitev:</strong> Povlecite in spustite gradnike in jih razporedite tako, da bodo povedali svojo zgodbo. Uporabite stolpce (na voljo v razdelku »postavitev«), da načrtujete svoj listovnik.</li> <li><strong>Organizirajte za jasnost:</strong> Uporabite glave, povezave in opombe za učinkovito strukturiranje vsebine.</li > <li><strong>Prilagodite svoj slog:</strong> Izberite pisave in barve med razpoložljivimi možnostmi, da dodate pridih sebi.</li> </ul> <strong>Ne pozabite: vaš e-listovnik pripoveduje svetu o vas in vaših veščinah. Naj bo jasno, jedrnato in privlačno!</strong>';
$string['create_view_content_help_title'] = 'Ustvarite svojo zgodbo: zgradite svoj listovnik';
$string['createepxexport'] = 'Ustvari EXP datoteko';
$string['createexport'] = 'Ustvari SCORM datoteko';
$string['createexport_directory'] = 'Ustvari strukturo';
$string['createpage'] = 'Da bi ustvarili vsebino vaše strani, povlecite in spustite bloke vsebine iz spodnjih zavihkov.';
$string['current_category'] = 'Trenutna kategorija';
$string['cvgroup'] = 'Življenjepis';
$string['cvinformation'] = 'Informacije o življenjepisu';
$string['cvinformation_help'] = 'Blok s podatki vašega življenjepisa Exabis listovnik, kot so: izobrazba, zaposlitev itd.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Oglejte si svoj življenjepis</a>';
$string['date'] = 'Datum';
$string['delete'] = 'Izbriši';
$string['delete_all_shareall'] = 'Zbriši vse?';
$string['deletecategoryconfirm'] = 'Ali res želite izbrisati kategorijo "{$a->name}"? Vsi vnosi v tej kategoriji in vse podkategorije bodo izbrisani!';
$string['deletefileconfirm'] = 'Ali res želite izbrisati to datoteko?';
$string['deletelinkconfirm'] = 'Ali res želite izbrisati to povezavo?';
$string['deletenoteconfirm'] = 'Ali res želite izbrisati to opombo?';
$string['deleteposterror'] = 'Pri brisanju objave se je pojavila napaka';
$string['descriptionsaved'] = 'Opis je shranjen';
$string['deselectall'] = 'Razveljavi';
$string['desp_categories'] = 'zgodbe, igre vlog, eseji, življenjepisi, recenzije gledaliških produkcij, razstave, poročila o projektih in razmišljanja, avdio- in videoposnetki, srečanja z drugimi narodnostmi, misli o vaših jezikovnih sposobnostih, izkaznice, potrdila, zahvale, poslušanje - individualno delo - partnersko delo - skupinsko delo branje - individualno delo - partnersko delo - skupinsko delo, sodelovanje v pogovoru - individualno delo - partnersko delo - skupinsko delo tekoče govorjenje - individualno delo - partnersko delo - skupinsko delo pisanje - individualno delo - partnersko delo - skupinsko delo';
$string['desp_einleitung'] = 'To je vaš listovnik, s katerim pokažete drugim, kaj ste dosegli.';
$string['desp_pluginname'] = 'Spis';
$string['details'] = 'Podrobnosti';
$string['dontincludeurl'] = 'Potrdite to polje, če želite preklicati povezavo zaznamka z URL-jem';
$string['download'] = 'Prenesi';
$string['download_pdf'] = 'Prenesi kot PDF';
$string['duplicatedurl'] = 'Ta URL ste že shranili';
$string['edit'] = 'Uredi';
$string['editcategories'] = 'Uredi kategorije';
$string['emailaccess'] = 'Prenesi kot PDF';
$string['emailaccessdescription'] = 'V vsako vrstico vnesite e-poštni naslov<br />Vsako e-poštno sporočilo bo prejelo edinstveno povezavo z dostopom do tega pogleda. Če izbrišete e-pošto, boste odstranili dostop do tega pogleda.';
$string['emailaccessmessage'] = 'Pozdravljeni! {$a->sendername} je za vas delil pogled »{$a->viewname}«. Ogledate si ga lahko tukaj: {$a->url}';
$string['emailaccessmessageHTML'] = 'Pozdravljeni!<br />{$a->sendername} je za vas delil pogled »{$a->viewname}«.<br />Ogledate si ga lahko <a href="{$a->url}" >tukaj</a>.';
$string['emailaccessmessagesubject'] = 'Nov pogled v skupni rabi';
$string['endedit'] = 'Končaj urejanje';
$string['enrolled_courses'] = 'Povezano s tečaji';
$string['exaport:addinstance'] = 'Tečaju dodajte E-listovnik Exabis';
$string['exaport:allowposts'] = 'Dovoli objavo';
$string['exaport:competences'] = 'Dovoli kompetence';
$string['exaport:export'] = 'Izvoz datotek SCORM';
$string['exaport:import'] = 'Uvoz datotek SCORM';
$string['exaport:importfrommoodle'] = 'Uvozi iz Moodla';
$string['exaport:myaddinstance'] = 'Dodajte E-listovnik Exabis na Moj dom';
$string['exaport:shareextern'] = 'Zunanja izmenjava mnenj';
$string['exaport:shareintern'] = 'Interna izmenjava mnenj';
$string['exaport:use'] = 'Uporaba dovoljena';
$string['exaport:viewartifactsfromstudents'] = 'Lahko vidi dokazila listovnika lastnih učencev';
$string['expandcomps'] = 'Razširi vse';
$string['explaincategories'] = 'Kategorije: Tukaj lahko ustvarjate in spreminjate kategorije';
$string['explainexport'] = 'Tukaj izvozite svoj listovnik.';
$string['explainimport'] = 'Tukaj lahko uvozite datoteko SCORM v listovnik. Če so najdene oznake iz prejšnjih izvozov, uvoz poskuša uvoziti podatke v obstoječi strukturi datotek.';
$string['explaining'] = 'E-listovnik se lahko uporablja za shranjevanje spletnih naslovov, datotek in vnos opomb.';
$string['explainingall'] = 'Vsi predmeti v vašem listovniku';
$string['explainingfile'] = 'Datoteke. Te datoteke se lahko delijo z vsemi pooblaščenimi člani tečaja.';
$string['explaininglink'] = 'Povezave. Te povezave se lahko delijo z vsemi pooblaščenimi člani tečaja.';
$string['explainingmoredata'] = '<strong>To je vaš prostor o vaši učni poti.</strong> <ul> <li><strong>Dodajte svoje delo:</strong> naložite datoteke, spletne povezave ali opise projektov, predstavitev, in še več.</li> <li><strong>Razmislite o svojih izkušnjah:</strong> Pojasnite, kaj ste se naučili, izzive, s katerimi ste se srečali, in svoje dosežke za vsak del.</li> </ul> <strong> Vsak predmet si predstavljajte kot zgodbo, ki poudarja vaše sposobnosti in znanje.</strong>';
$string['explainingnote'] = 'Opombe. Te opombe lahko delite z vsemi pooblaščenimi člani tečaja.';
$string['explainingshare'] = 'Če želite udeležencu omogočiti ogled povezave, kliknite njegovo ime in nato kliknite Shrani spremembe. Izberete lahko več kot enega udeleženca.';
$string['explainingshared'] = 'Ti udeleženci so delili nekatere svoje zunanje povezave, datoteke ali zapiske.';
$string['explainingsharefile'] = 'Če želite udeležencu omogočiti ogled datoteke, kliknite njegovo ime in nato kliknite Shrani spremembe. Izberete lahko več kot enega udeleženca.';
$string['explainingsharenote'] = 'Če želite udeležencu omogočiti ogled opombe, kliknite njegovo ime in nato kliknite Shrani spremembe. Izberete lahko več kot enega udeleženca.';
$string['explainingviews'] = 'Upravljajte svoje poglede.';
$string['explainpersonal'] = 'Osebne informacije';
$string['export'] = 'Izvozi SCORM-File';
$string['export_directory'] = 'Izvozi strukturo';
$string['export_short'] = 'Izvozi';
$string['exportcomment'] = 'To je izvožena datoteka iz Exabis ePortfolio. Prosimo, ne odstranjujte komentarjev, potrebni so za uvoz!';
$string['exportepx'] = 'Izvozi datoteko EPX';
$string['exportviewselect'] = 'Če želite izvoziti vse elemente določenega pogleda, ga izberite tukaj';
$string['externaccess'] = 'Zunanji E-listovnik-Link';
$string['externalaccess'] = 'Zunanji dostop';
$string['externcomment'] = 'Delite komentarje v zunanjem listovniku';
$string['fieldstoshow'] = 'Polja za prikaz';
$string['file'] = 'Datoteka';
$string['filecopiedtocourse'] = 'Datoteka je bila kopirana v tečaj $a->coursename pod imenom $a->filename';
$string['filenotfound'] = 'Datoteke ni mogoče najti';
$string['filetypenotdetected'] = 'Vrste datoteke $a->filename ($a->title) ni bilo mogoče zaznati. Datoteka ni uvožena!';
$string['filterByTag'] = 'Filtriraj po oznaki';
$string['firstname'] = 'Ime';
$string['firstnameshared'] = 'Ime';
$string['forms.item.project_description'] = 'Namen projekta';
$string['forms.item.project_description_editor'] = 'Namen projekta';
$string['forms.item.project_description_editor_help'] = '<strong>Na kratko razložite namen svojega dela:</strong> <ul> <li>Kateri problem ste obravnavali?</li> <li>Katere veščine ste želeli razviti?</li> <li>Kaj je bil kontekst?</li> </ul>';
$string['forms.item.project_description_help'] = '<strong>Na kratko razložite namen svojega dela:</strong><ul> <li>Kateri problem ste obravnavali?</li> <li>Katere veščine ste želeli razviti?</li> <li>Kaj je bil kontekst?</li> </ul>';
$string['forms.item.project_process'] = 'Uresniči';
$string['forms.item.project_process_editor'] = 'Uresniči';
$string['forms.item.project_process_editor_help'] = '<strong>Opišite svojo pot:</strong> <ul> <li>Katere korake ste naredili, da ste dokončali ta projekt?</li> <li>Na kakšne izzive ste naleteli in kako ste jih premagali?</li > <li>Katere vire ste uporabili?</li> </ul>';
$string['forms.item.project_process_help'] = '<strong>Opišite svojo pot:</strong> <ul> <li>Katere korake ste naredili, da ste dokončali ta projekt?</li> <li>Na kakšne izzive ste naleteli in kako ste jih premagali?</li > <li>Katere vire ste uporabili?</li> </ul>';
$string['forms.item.project_result'] = 'Rezultati';
$string['forms.item.project_result_editor'] = 'Rezultati';
$string['forms.item.project_result_editor_help'] = '<strong>Na kratko povzemite rezultate svojega projekta:</strong> <ul> <li>Kaj ste dosegli?</li> <li>Katere veščine in kompetence ste razvili ali okrepili s tem delom?</li> <li>Kaj ste se naučili o sebi in svojih sposobnostih?</li> <li>Kaj bi naslednjič naredili drugače?«</li> </ul>';
$string['forms.item.project_result_help'] = '<strong>Na kratko povzemite rezultate svojega projekta:</strong> <ul> <li>Kaj ste dosegli?</li> <li>Katere veščine in kompetence ste razvili ali okrepili s tem delom?</li> <li>Kaj ste se naučili o sebi in svojih sposobnostih?</li> <li>Kaj bi naslednjič naredili drugače?«</li> </ul>';
$string['forms.item.title'] = 'Naslov';
$string['go'] = 'Pojdi!';
$string['gradeitem'] = 'Oceni delo';
$string['grouptitle'] = 'Naslov skupine';
$string['headertext'] = 'Besedilo glave';
$string['headertext_help'] = 'Preprost blok za dodajanje naslovne vrstice';
$string['height'] = 'Višina';
$string['hidesummary'] = '(skrij povzetek)';
$string['i_shared'] = 'Z vami sem delil pogled na E-listovnik';
$string['iconfile'] = 'Thumbnail';
$string['iconfile_merge'] = 'Spoji to sliko ikone z ikono mape';
$string['iconfile_merge_description'] = 'Slika ikone se bo poskusila (brez jamstva) združiti s standardno ikono mape. Ikona bo zamenjana z novo sliko.';
$string['import'] = 'Uvozi datoteko SCORM';
$string['import_short'] = 'Uvoz';
$string['importedcommentsend'] = 'Konec uvoženih komentarjev';
$string['importedcommentsstart'] = 'Uvoženi komentarji:<br /><br />';
$string['importexport'] = 'Uvoz/izvoz';
$string['incompatible_video'] = 'Za ogled tega videa uporabite neposredno povezavo: {$a->link}';
$string['incorrectlinksid'] = 'Napačen ID objave povezav';
$string['incorrectnoteid'] = 'Napačen ID opombe';
$string['internalaccess'] = 'Notranji dostop';
$string['internalaccessall'] = 'Dostop za <span class=\'block_eportfolio_bold\'>vse</span>';
$string['internalaccessgroups'] = 'Dostop samo za naslednje skupine';
$string['internalaccessusers'] = 'Dostop samo za naslednje uporabnike';
$string['intro'] = 'Vsebina';
$string['intronotempty'] = 'Vnesti morate vsebino.';
$string['invalidassignmentid'] = 'Napačen ID naloge';
$string['invalidcourseid'] = 'To je neveljaven ID tečaja';
$string['invalidfileatthisassignment'] = 'Datoteka pri tej nalogine obstaja!';
$string['invalidinstance'] = 'To je neveljaven primer';
$string['item'] = 'Postavka';
$string['item.project_information'] = 'Informacije o projektu';
$string['itemgrading'] = 'Ocenjevanje';
$string['items'] = 'Moja dokazila';
$string['items_help'] = 'Blok z vašimi dokazili<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Oglejte si svoja dokazila</a>';
$string['lastname'] = 'Priimek';
$string['layout_settings'] = 'Nastavitve postavitve';
$string['layout_settings_border_width'] = 'Širina obrobe';
$string['layout_settings_border_width_only_bottom'] = 'Samo spodnji rob';
$string['layout_settings_custom_css'] = 'CSS po meri';
$string['layout_settings_custom_css_description'] = 'Tu lahko uporabite lastna pravila CSS po meri';
$string['layout_settings_description'] = 'Tukaj lahko spremenite nekatere možnosti postavitve pogleda ali uporabite lastna pravila CSS po meri, da imate pogled, kot želite';
$string['layout_settings_font_size'] = 'Velikost pisave';
$string['layout_settings_font_weight'] = 'Odebeljeno';
$string['layout_settings_view_content'] = 'Vsebina oglednih blokov';
$string['layout_settings_view_headers'] = 'Glave blokov pogleda';
$string['link'] = 'Povezava';
$string['linkedfilenotfound'] = 'Datoteke $a->filename v $a->url ($a->title) ni bilo mogoče najti. Datoteka ni uvožena!';
$string['list'] = 'Seznam';
$string['listofartefacts'] = 'Seznam dokazil';
$string['listofbadges'] = 'Seznam značk';
$string['loginasmode'] = 'V načinu »Prijava kot« ne morete dostopati do listovnikov.';
$string['mailadress'] = 'Elektronski naslov';
$string['maincategory'] = 'Glavna kategorija';
$string['make_it_yours'] = 'Prilagodi';
$string['makeimport'] = 'Uvoz';
$string['managecategories'] = 'Upravljanje kategorij';
$string['mandatoryfields'] = 'Ime polja, kategorija in uvod so obvezni. Prosimo, da jih izpolnite.';
$string['mandatoryfieldsforcat'] = 'Obvezno vnesite ime polja.';
$string['media'] = 'Mediji';
$string['media_allowed_notes'] = 'Dovoljeni so URL-ji z naslednjih spletnih mest:';
$string['media_help'] = 'Blok z vdelanimi medijskimi podatki iz virov, kot so: Youtube, Vimeo, SlideShare itd.';
$string['mediacontent'] = 'URL ali koda za vdelavo *';
$string['membercount'] = 'Število sodelujočih';
$string['messageprovider:sharing'] = 'Obvestila o skupni rabi';
$string['moodleimport'] = 'Uvoz iz nalog Moodle';
$string['moreinfolink'] = 'Prikaži več informacij ...';
$string['movebottom'] = 'Premakni dno';
$string['movetop'] = 'Premakni vrh';
$string['myfilearea'] = 'Moje območje datoteke';
$string['myportfolio'] = 'Dokazila mojega listovnika';
$string['myportfoliotitle'] = 'Modul Exabis ePortfolio: tukaj dodajte svoje povezave in datoteke.';
$string['name'] = 'Ime';
$string['new'] = 'Novo';
$string['newfile'] = 'Dodaj novo datoteko';
$string['newlink'] = 'Dodaj novo povezavo';
$string['newnote'] = 'Dodaj novo opombo';
$string['newview'] = 'Dodaj pogled';
$string['nobookmarksall'] = '(še ni elementov)';
$string['nobookmarksfile'] = '(še ni datotek)';
$string['nobookmarkslink'] = '(še ni povezav)';
$string['nobookmarksnote'] = '(še ni opomb)';
$string['nocategories'] = '(še ni kategorij)';
$string['nocoursetogether'] = 'Brez tečaja';
$string['noemails'] = 'e-poštni naslov ni na voljo';
$string['noentry'] = 'Brez vsebine';
$string['nogroupsfound'] = 'Ni najdenih skupin';
$string['noguestpost'] = 'Gostje tukaj nimajo dostopa!';
$string['nomail'] = 'Brez elektronske pošte';
$string['nomoodleimportyet'] = 'Trenutno nimate prispevka pri nobeni nalogi!';
$string['nopicture'] = 'Brez slike';
$string['noprofilepicture'] = 'Slika profila ni na voljo';
$string['note'] = 'Opomba';
$string['notetitle'] = 'Opomba';
$string['nothingshared'] = 'Nihče ne deli listovnika z vami';
$string['nothingstructureshared'] = 'Nihče si ne deli strukture z vami';
$string['notify'] = 'Pošlji obvestilo.';
$string['nouserforaccess'] = 'Uporabnik ni bil najden (dostopna koda neznana)';
$string['nouserforid'] = 'Uporabnika ni mogoče najti (id neznan)';
$string['nousersfound'] = 'Ni najdenih uporabnikov';
$string['noviews'] = 'Ustvarite nov pogled';
$string['opencomps'] = 'Izberite svoje kompetence';
$string['other_groups_course'] = 'Drugi tečaji';
$string['other_users_course'] = 'Uporabniki, ki niso na mojih tečajih';
$string['othercourses'] = 'Drugi tečaji';
$string['pdf_customfont'] = 'Naloži pisavo po meri';
$string['pdf_customfont_help'] = 'Naložite lahko lastno datoteko .ttf. Poskušali ga bomo uporabiti za generiranje PDF.';
$string['pdf_settings'] = 'PDF nastavitve';
$string['pdf_settings_description'] = 'Če uporabljate posebne ali neobičajne jezikovne znake, ima lahko ustvarjeni pdf težave.  Poskusite uporabiti druge nastavitve pisave<br> Vaše nastavitve PDF bodo shranjene za ta pogled.<br> Če je vaš pogled v skupni rabi z drugimi uporabniki - bodo videli pdf z vašimi nastavitvami.<br> Ne -standardne pisave imajo lahko nekatere izgubljene možnosti, kot so krepko, ležeče itd.';
$string['pdf_settings_fontfamily'] = 'Družina pisave';
$string['pdf_settings_fontfamily_customgroup'] = 'Pisave, naložene po meri';
$string['pdf_settings_fontfamily_fixedgroup'] = 'Vnaprej določene pisave';
$string['pdf_settings_fontsize'] = 'Osnovna velikost pisave';
$string['pdf_settings_pageorient'] = 'Orientacija strani';
$string['pdf_settings_pagesize'] = 'Velikost strani';
$string['pdf_settings_showmetadata'] = 'Dodajte metapodatke pogleda';
$string['pdf_settings_showuseremail'] = 'E-pošta uporabnika';
$string['pdf_settings_showusername'] = 'Ime uporabnika';
$string['pdf_settings_showuserphone'] = 'Telefon uporabnika';
$string['pdf_settings_showuserpicture'] = 'Slika uporabnika';
$string['pdf_settings_uploadfont'] = 'Naloži lastno pisavo';
$string['personal'] = 'Informacije';
$string['personalinformation'] = 'Osebni podatki';
$string['personalinformation_help'] = 'Blok z vašimi osebnimi podatki, kot so: ime, e-pošta.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Oglejte si svoj profil</a>';
$string['pluginname'] = 'E-listovnik ePortfolio';
$string['privacy:metadata:block_exaportcate'] = 'Uporabniške kategorije';
$string['privacy:metadata:block_exaportcate:courseid'] = 'ID Tečaja';
$string['privacy:metadata:block_exaportcate:description'] = 'Opis';
$string['privacy:metadata:block_exaportcate:internshare'] = 'Notranje deljenje?';
$string['privacy:metadata:block_exaportcate:name'] = 'Naslov';
$string['privacy:metadata:block_exaportcate:name_short'] = 'Kratki naslov';
$string['privacy:metadata:block_exaportcate:parent_ids'] = 'Seznam nadrejenih ID-jev';
$string['privacy:metadata:block_exaportcate:parent_titles'] = 'Seznam nadrejenih naslovov';
$string['privacy:metadata:block_exaportcate:pid'] = 'ID nadrejene kategorije';
$string['privacy:metadata:block_exaportcate:shareall'] = 'deli za vse? 0 - ni v skupni rabi; 1 - skupno za vse; 2 - skupno za skupine';
$string['privacy:metadata:block_exaportcate:source'] = 'Vir';
$string['privacy:metadata:block_exaportcate:sourceid'] = 'ID vira';
$string['privacy:metadata:block_exaportcate:sourcemod'] = 'izvorni mod';
$string['privacy:metadata:block_exaportcate:stid'] = 'ID vrste šole';
$string['privacy:metadata:block_exaportcate:structure_share'] = 'Deli kot strukturo? poglej tudi \'structure_shareall\\';
$string['privacy:metadata:block_exaportcate:structure_shareall'] = 'deli kot strukturo? : 0 - ni v skupni rabi; 1 - skupno za vse; 2 - skupno za skupine';
$string['privacy:metadata:block_exaportcate:subjid'] = 'ID povezane teme';
$string['privacy:metadata:block_exaportcate:timemodified'] = 'Nazadnje spremenjeno';
$string['privacy:metadata:block_exaportcate:topicid'] = 'ID sorodne teme';
$string['privacy:metadata:block_exaportcate:userid'] = 'ID uporabnika';
$string['privacy:metadata:block_exaportitem'] = 'Dokazila uporabnika';
$string['privacy:metadata:block_exaportitem:categoryid'] = 'ID kategorije';
$string['privacy:metadata:block_exaportitem:courseid'] = 'ID tečaja';
$string['privacy:metadata:block_exaportitem:exampid'] = 'Povezan ID primera';
$string['privacy:metadata:block_exaportitem:example_url'] = 'Lastnik dokazila';
$string['privacy:metadata:block_exaportitem:externaccess'] = 'Zunanji dostop?';
$string['privacy:metadata:block_exaportitem:externcomment'] = 'Komentar za zunanje';
$string['privacy:metadata:block_exaportitem:fileurl'] = 'url v datoteko';
$string['privacy:metadata:block_exaportitem:intro'] = 'Uvod';
$string['privacy:metadata:block_exaportitem:iseditable'] = 'Je mogoče urejati?';
$string['privacy:metadata:block_exaportitem:langid'] = 'ID Jezika';
$string['privacy:metadata:block_exaportitem:name'] = 'Ime';
$string['privacy:metadata:block_exaportitem:parentid'] = 'Nadrejeni ID';
$string['privacy:metadata:block_exaportitem:shareall'] = 'Delim za vse?';
$string['privacy:metadata:block_exaportitem:source'] = 'Vir';
$string['privacy:metadata:block_exaportitem:sourceid'] = 'ID Vira';
$string['privacy:metadata:block_exaportitem:timemodified'] = 'čas zadnje spremembe';
$string['privacy:metadata:block_exaportitem:type'] = 'Tip dokazila';
$string['privacy:metadata:block_exaportitem:url'] = 'url';
$string['privacy:metadata:block_exaportitem:userid'] = 'Lastnik dokazila';
$string['privacy:metadata:block_exaportitemcomm'] = 'Komentarji za dokazila';
$string['privacy:metadata:block_exaportitemcomm:entry'] = 'Komentar';
$string['privacy:metadata:block_exaportitemcomm:itemid'] = 'ID dokazila';
$string['privacy:metadata:block_exaportitemcomm:timemodified'] = 'Nazadnje spremenjeno';
$string['privacy:metadata:block_exaportitemcomm:userid'] = 'Avtor komentarja';
$string['privacy:metadata:block_exaportresume'] = 'Nadaljuj';
$string['privacy:metadata:block_exaportresume:courseid'] = 'ID tečaja';
$string['privacy:metadata:block_exaportresume:cover'] = 'Naslovna vsebina';
$string['privacy:metadata:block_exaportresume:goalsacademic'] = 'Akademski cilji';
$string['privacy:metadata:block_exaportresume:goalscareers'] = 'Karierni cilji';
$string['privacy:metadata:block_exaportresume:goalspersonal'] = 'Osebni cilji';
$string['privacy:metadata:block_exaportresume:interests'] = 'Zanimanja';
$string['privacy:metadata:block_exaportresume:skillsacademic'] = 'Akademske veščine';
$string['privacy:metadata:block_exaportresume:skillscareers'] = 'Karierne veščine';
$string['privacy:metadata:block_exaportresume:skillspersonal'] = 'Osebne veščine';
$string['privacy:metadata:block_exaportresume:user_id'] = 'Lastnik življenjepisa';
$string['privacy:metadata:block_exaportuser'] = 'Podatki uporabnika iz e-listovnika exabis';
$string['privacy:metadata:block_exaportuser:description'] = 'Opis';
$string['privacy:metadata:block_exaportuser:user_id'] = 'ID uporabnika';
$string['privacy:metadata:block_exaportuser:view_items_layout'] = 'ID uporabnika';
$string['privacy:metadata:block_exaportview'] = 'Komentarji za dokazila';
$string['privacy:metadata:block_exaportview:autofill_artefacts'] = 'Omogočeno samodejno dopolnjevanje z dokazili';
$string['privacy:metadata:block_exaportview:description'] = 'Opis';
$string['privacy:metadata:block_exaportview:externaccess'] = 'Zunanji dostop?';
$string['privacy:metadata:block_exaportview:externcomment'] = 'Komentar za zunanji dostop';
$string['privacy:metadata:block_exaportview:langid'] = 'ID jezika';
$string['privacy:metadata:block_exaportview:layout'] = 'Postavitev pogleda';
$string['privacy:metadata:block_exaportview:name'] = 'Ime';
$string['privacy:metadata:block_exaportview:shareall'] = 'Delim z vsemi?';
$string['privacy:metadata:block_exaportview:sharedemails'] = 'Skupni seznam e-poštnih sporočil';
$string['privacy:metadata:block_exaportview:timemodified'] = 'Nazadnje spremenjeno';
$string['privacy:metadata:block_exaportview:userid'] = 'Lastnik pogleda';
$string['privacy:metadata:core_files'] = 'E-listovnik Exabis shranjuje datoteke, ki jih je naložil uporabnik, da tvorijo del dokazil, vnosov v življenjepis in komentarjev.';
$string['profilepicture'] = 'Profilna slika';
$string['project_description'] = 'Namen projekta';
$string['project_process'] = 'Uresniči';
$string['project_result'] = 'Rezultati in učenje';
$string['publishedportfolios'] = 'Objavljeni listovniki';
$string['resume_badges'] = 'Značke';
$string['resume_certif'] = 'Certifikati, akreditacije in nagrade';
$string['resume_certifdeleted'] = 'Izbrisani certifikati, akreditacije in nagrade';
$string['resume_certifsaved'] = 'Shranjeni certifikati, akreditacije in nagrade';
$string['resume_collaps'] = 'Strni vse';
$string['resume_contribution'] = 'Prispevek';
$string['resume_contributiondetails'] = 'Podrobnosti o vašem prispevku';
$string['resume_cover'] = 'O Meni';
$string['resume_coversaved'] = 'Naslovnica shranjena';
$string['resume_date'] = 'Datum';
$string['resume_deletecertifconfirm'] = 'Ali res želite izbrisati to potrdilo, akreditacijo ali nagrado?';
$string['resume_deleteeduconfirm'] = 'Ali res želite izbrisati to izobraževanje?';
$string['resume_deleteemployconfirm'] = 'Ali res želite izbrisati to zaposlitev?';
$string['resume_deletelinkedinconfirm'] = 'Ali res želite izbrisati to članstvo?';
$string['resume_deletembrshipconfirm'] = 'Ali res želite izbrisati to članstvo?';
$string['resume_deletepublicconfirm'] = 'Ali res želite izbrisati to knjigo ali publikacijo?';
$string['resume_description'] = 'Opis';
$string['resume_edu'] = 'Izobraževanje';
$string['resume_edudeleted'] = 'Izobraževanje izbrisano';
$string['resume_eduhistory'] = 'Pretekla izobraževanja';
$string['resume_edusaved'] = 'Izobraževanje shranjeno';
$string['resume_employ'] = 'Zaposlitev';
$string['resume_employdeleted'] = 'Zaposlitev izbrisana';
$string['resume_employer'] = 'Delodajalec';
$string['resume_employeraddress'] = 'Naslov delodajalca';
$string['resume_employhistory'] = 'Pretekle zaposlitve';
$string['resume_employsaved'] = 'Zaposlitev shranjena';
$string['resume_enddate'] = 'Končni datum';
$string['resume_expand'] = 'Razširi vse';
$string['resume_exportto_europass'] = 'Izvozi v Europass';
$string['resume_exportto_europass_getXML'] = 'Prenesi XML';
$string['resume_exportto_europass_intro'] = '<p>Europass profil lahko pomaga ljudem pri načrtovanju učenja in razvoja kariere. Profil lahko uporabljajo organizacije – delodajalci, prostovoljske organizacije, zaposlovalci, svetovalci, mladinske organizacije, ustanove za izobraževanje in usposabljanje ter druge – kot del podpore in storitev, ki jih ponujajo ljudem.</p> <p>Zagotavljamo način za uporabo vašega življenjepisa iz Exabis eProtfolio v Europass profilu<br> Ustvarjeno XML-datoteko morate vstaviti na stran <a href="https://europa.eu/europass/eportfolio/screen/cv-editor?lang =en" target="_blank">Ustvarite svoj življenjepis</a><br> (bolje je, da ste predhodno prijavljeni v Europass)<br> Pritisnite gumb "Uvozi Europass življenjepis" in naložite XML-datoteko, ki bo generirala gumb spodaj </p> Nekaj opomb:<br> <ul> <li>Vsekakor si morate ogledati nastali življenjepis</li> <li>Vaši osebni podatki bodo vzeti iz vašega računa Moodle</li> <li >Prosimo, preverite vse datume, telefone, naslove</li> <li>Slike iz urejevalnikov HTML ne bodo izvožene</li> <li>Večino besedil iz urejevalnikov HTML je treba preoblikovati</li> <li >Priložene datoteke niso implementirane v novi različici Europassa, zato ne bodo uvožene</li> </ul>';
$string['resume_files'] = 'Priponke';
$string['resume_goals'] = 'Cilji';
$string['resume_goalsacademic'] = 'Akademski cilji';
$string['resume_goalsacademicsaved'] = 'Akademski cilji shranjeni';
$string['resume_goalscareers'] = 'Karierni cilji';
$string['resume_goalscareerssaved'] = 'Karierni cilji shranjeni';
$string['resume_goalscomp'] = 'Izobraževalni standardi';
$string['resume_goalspersonal'] = 'Ocebni cilji';
$string['resume_goalspersonalsaved'] = 'Osebni cilji shranjeni';
$string['resume_institution'] = 'Ustanova';
$string['resume_institutionaddress'] = 'Naslov ustanove';
$string['resume_interests'] = 'Zanimanja';
$string['resume_interestssaved'] = 'Zanimanja shranjena';
$string['resume_jobtitle'] = 'Naziv delovnega mesta';
$string['resume_linkedin'] = 'LinkedIn profil';
$string['resume_linkedindeleted'] = 'LinkedIn profil izbrisan';
$string['resume_linkedinsaved'] = 'LinkedIn profil shranjen';
$string['resume_mbrship'] = 'Članstvo';
$string['resume_mbrshipdeleted'] = 'Članstvo izbrisano';
$string['resume_mbrshipsaved'] = 'Članstvo shranjeno';
$string['resume_my'] = 'Moj življenjepis';
$string['resume_mygoals'] = 'Moji cilji';
$string['resume_myskills'] = 'Moje sposobnosti';
$string['resume_position'] = 'Naziv';
$string['resume_positiondescription'] = 'Opis naziva';
$string['resume_public'] = 'Knjige in publikacije';
$string['resume_publicdeleted'] = 'Knjige in publikacije izbrisane';
$string['resume_publicsaved'] = 'Knjige in publikacije shranjene';
$string['resume_qualdescription'] = 'Opis kvalifikacije';
$string['resume_qualification'] = 'Kvalifikacija';
$string['resume_qualname'] = 'Ime kvalifikakcije';
$string['resume_qualtype'] = 'Tip kvalifikacije';
$string['resume_skills'] = 'Sposobnosti';
$string['resume_skillsacademic'] = 'Akademske sposobnosti';
$string['resume_skillsacademicsaved'] = 'Akademske sposobnosti shranjene';
$string['resume_skillscareers'] = 'Karierne sposobnosti';
$string['resume_skillscareerssaved'] = 'Karierne sposobnosti shranjene';
$string['resume_skillscomp'] = 'Izobraževalni standardi';
$string['resume_skillspersonal'] = 'Osebne sposobnosti';
$string['resume_skillspersonalsaved'] = 'Osebne sposobnosti shranjene';
$string['resume_startdate'] = 'Datum začetka';
$string['resume_template_newresume'] = '<h2>Moj novi življenjepis</h2>';
$string['resume_title'] = 'Naslov';
$string['resume_url'] = 'URL';
$string['role'] = 'Vloga';
$string['root_category'] = 'Glavna kategorija';
$string['saveButton'] = 'Shrani';
$string['saveitem'] = 'Shrani';
$string['scormhastobezip'] = 'Datoteka SCORM mora biti datoteka .zip';
$string['searchByTitle'] = 'Najdi';
$string['selectall'] = 'Izberite vse';
$string['selectcomps'] = 'Izberite kompetence, povezane z vašim nalaganjem!';
$string['selected_competencies'] = 'Dosežena kompetenca';
$string['selectitems'] = 'Izberite postavke';
$string['settings_allow_loginas_body'] = 'settings_allow_loginas_body';
$string['settings_allow_loginas_head'] = 'Dovoli prijavo kot';
$string['settings_create_desp_categories_body'] = 'settings_create_desp_categories_body';
$string['settings_create_desp_categories_head'] = 'Ustvarite kategorije Desp';
$string['settings_disable_externaccess_body'] = 'settings_disable_externaccess_body';
$string['settings_disable_externaccess_head'] = 'Onemogočite možnost skupne rabe »Zunanji dostop« za poglede';
$string['settings_disable_external_comments_body'] = 'settings_disable_external_comments_body';
$string['settings_disable_external_comments_head'] = 'Onemogoči skupno rabo komentarjev v zunanjem pogledu';
$string['settings_disable_shareall_body'] = 'Kliknite <a href="{$a}">tukaj</a>, da odstranite vse globalne skupne rabe';
$string['settings_disable_shareall_head'] = 'Onemogoči skupno rabo z vsemi uporabniki';
$string['settings_disable_shareemails_body'] = 'settings_disable_shareemails_body';
$string['settings_disable_shareemails_head'] = 'Onemogočite možnost skupne rabe »Deli po e-pošti« za oglede';
$string['settings_interaktion_exacomp_body'] = 'Interakcija z blokom Exabis Competence Grid, če je nameščen';
$string['settings_interaktion_exacomp_head'] = 'Interakcija exabis listovnika - Exabis Competence Grid';
$string['settings_layout_settings_description'] = 'Tukaj lahko spremenite nekatere možnosti postavitve pogleda ali uporabite lastna pravila CSS po meri, da imate želeni pogled.<br>Te nastavitve bodo uporabljene kot privzete nastavitve <strong>za vse poglede.</strong>';
$string['settings_layout_settings_heading'] = 'Nastavitve postavitve';
$string['share'] = 'Deli';
$string['share_to_other_users'] = 'Iskanje uporabnikov';
$string['shareallexceptthose'] = 'Dostop za <span class=\'block_eportfolio_bold\'>vse</span> (tudi tiste, ki niso navedeni tukaj), razen za naslednje uporabnike';
$string['sharedArtefacts'] = 'Skupinski listovniki, deljeni z vami';
$string['shared_categories'] = 'Skupne kategorije';
$string['shared_views'] = 'Skupni pogled';
$string['shareditems_category'] = 'Skupinski listovniki, deljeni z vami';
$string['sharedpersons'] = 'Osebe s skupnimi listovniki';
$string['sharedwith'] = 'V skupni rabi z';
$string['sharedwith_group'] = 'V skupni rabi z mojo skupino';
$string['sharedwith_group_cnt'] = 'V skupni rabi s {$a} skupinami';
$string['sharedwith_onlyme'] = 'Deljeno samo z mano';
$string['sharedwith_shareall'] = 'Deljeno z vsemi uporabniki';
$string['sharedwith_shareexternal'] = 'Deljeno z gosti';
$string['sharedwith_user_cnt'] = 'V skupni rabi z {$a} uporabniki';
$string['sharejs'] = 'Skupna raba';
$string['sharenoneexceptthose'] = 'Dostop za <span class=\'block_eportfolio_bold\'>nihče</span> razen za naslednje uporabnike';
$string['sharetoteacher'] = 'Delite z vsemi učitelji v tem tečaju';
$string['shortdescription'] = 'Kratek opis';
$string['show'] = 'Prikaži';
$string['show_mystudents'] = 'Učeči';
$string['show_sharedbyuser'] = 'Delijo uporabniki';
$string['showall'] = 'Prikaži še druge predmete';
$string['showallusers'] = 'Prikaži uporabnike vseh mojih predmetov';
$string['showcourse'] = 'Prikaži le ta predmet';
$string['showcourseusers'] = 'Prikaži le uporabnike predmeta';
$string['showsummary'] = '(prikaži povzetek)';
$string['steckbrief'] = 'Profil';
$string['strshare'] = 'Skupna raba';
$string['strunshare'] = 'Prekliči skupno rabo';
$string['studentcomps'] = 'Tukaj lahko sami ocenite, ali ste s svojim delom pridobili kompetenco.';
$string['subcategory'] = 'Podkategorija';
$string['submititem'] = 'Predloži';
$string['success'] = 'Datoteka je bila uspešno uvožena';
$string['summary'] = 'Povzetek (neobvezno)';
$string['supported'] = 'podpira';
$string['tagarea_block_exaportitem'] = 'Artefakti mojega listovnika';
$string['teachercomps'] = 'Tukaj lahko ocenite, ali so vaši učenci pridobili kompetenco s tem artefaktom.';
$string['thiscourse'] = 'Ta tečaj';
$string['tiles'] = 'Naslovi';
$string['title'] = 'Naslov';
$string['titlenotemtpy'] = 'Vnesti morate naslov.';
$string['translation:email'] = 'ariepl.work@gmail.com';
$string['translation:language'] = 'Angleščina';
$string['translation:organisation'] = 'GTN GmbH';
$string['translation:person'] = 'Andreas Riepl';
$string['type'] = 'Vrsta';
$string['unknownaction'] = 'Neznana akcija';
$string['updateposterror'] = 'Pri posodabljanju te objave v bazi podatkov je prišlo do napake';
$string['updownarrow'] = 'puščica gor dol';
$string['uploadfailed'] = 'Nalaganje ni uspelo.';
$string['url'] = 'URL';
$string['urlnotempty'] = 'Vnesti morate URL.';
$string['userdefinedsort'] = 'Določite lastno iskanje';
$string['view'] = 'Pogled';
$string['view_saved'] = 'Pogled shranjen';
$string['view_sharing'] = 'Deli v skupno rabo';
$string['view_sharing_noaccess'] = 'Brez dostopa';
$string['view_sharing_updated'] = 'Skupna raba pogleda posodobljena';
$string['view_specialitem_badge'] = 'Značka';
$string['view_specialitem_headline'] = 'Naslov';
$string['view_specialitem_headline_defaulttext'] = 'Tukaj vnesite naslov';
$string['view_specialitem_media'] = 'Mediji';
$string['view_specialitem_personal'] = 'Osebne infoormacije';
$string['view_specialitem_text'] = 'Besedilo';
$string['view_specialitem_text_defaulttext'] = 'Tukaj vnesite besedilo';
$string['view_specialitem_text_help'] = 'Blok z besedilom po meri. Besedilo lahko oblikujete, kot želite';
$string['view_specialitems'] = 'Posebni predmeti';
$string['viewand'] = 'in';
$string['viewcategories'] = 'Urejaj kategorije';
$string['viewcontent'] = 'Vsebina';
$string['viewdescription'] = 'Opis';
$string['viewdesign'] = 'Ogled oblikovanja';
$string['viewinformation'] = 'Ogled informacij';
$string['viewitem'] = 'Predmeti';
$string['viewitems'] = 'Vaši predmeti';
$string['viewlayout'] = 'Razpored';
$string['viewlayout1'] = 'Enake širine';
$string['viewlayout10'] = 'Enake širine';
$string['viewlayout2'] = 'Enake širine';
$string['viewlayout3'] = 'Večji levi stolpec';
$string['viewlayout4'] = 'Večji desni stolpec';
$string['viewlayout5'] = 'Enake širine';
$string['viewlayout6'] = 'Večji sredinski stolpec';
$string['viewlayout7'] = 'Večji sredinski stolpec';
$string['viewlayout8'] = 'Enake širine';
$string['viewlayout9'] = 'Večji sredinski stolpci';
$string['viewlayoutgroup1'] = '1 stolpec';
$string['viewlayoutgroup2'] = '2 stolpca';
$string['viewlayoutgroup3'] = '3 stolpci';
$string['viewlayoutgroup4'] = '4 stolpci';
$string['viewlayoutgroup5'] = '5 stolpcev';
$string['viewnotfound'] = 'Pogleda ni bilo mogoče najti';
$string['views'] = 'Moj pogled';
$string['viewshare'] = 'Deli';
$string['viewtitle'] = 'Naslov in opis';
$string['what_is_embed_code_content'] = '<p>Koda za vdelavo je koda, ki jo ustvari spletno mesto tretje osebe, kot sta YouTube ali Twitter, in jo lahko uporabnik kopira in prilepi na svojo spletno stran. Ta vdelana koda bo nato prikazala isti medij, aplikacijo ali vir na spletni strani uporabnika kot v izvirnem viru.</p> <p>Nudimo navodila za najbolj priljubljene ponudnike videoposnetkov, kot sta YouTube ali Vimeo.< /p> <p><strong>Iskanje kode za vdelavo v YouTubu:</strong></p> <ol> <li>Pojdite na YouTube</a>.</li> <li>Pomaknite se do videoposnetka, ki ste ga želite vdelati.</li> <li>Kliknite povezavo <strong>Skupna raba</strong> pod videoposnetkom, nato kliknite povezavo <strong>Vdelaj</strong>.</li> <li>Pritisnite <strong> Gumb Kopiraj</strong> v nogi odprtega okna.</li> <li>Povezava za vdelavo bo označena z modro in kopirana v odložišče.</li> <li>Prenesite kodo v besedilno polje exabis E-listovnika polje.</li> </ol> <p><strong>Iskanje vdelane kode na Vimeu:</strong></p> <ol> <li>Pojdite na Vimeo.</li> <li>Pomaknite se na videoposnetek, ki ga želite vdelati.</li> <li>Kliknite gumb <strong>Skupna raba</strong> v zgornjem desnem kotu videoposnetka.</li> <li>Pojavilo se bo pojavno okno z informacije o vdelani povezavi. Kopirati boste morali samo del <strong>&lt;<i>iframe</i>&gt;</strong> vdelane povezave. Primer:<br> <ol> <li> Celotna vdelana povezava prikazuje naslednje:<br> <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size: 0,75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; širina=&quote;640&quote; višina=&quote;360&quote; frameborder=&quote;0&quote; dovoli=&quote;samodejno predvajanje; celozaslonski&quot; allowfullscreen&gt;&lt;/iframe&gt;&lt;p&gt;&lt;a href=&quote;https://vimeo.com/1233456789&quote;&gt;1- Avtomatsko odpiranje[2]&lt;/a&gt; iz &lt;a href=&quote;https://vimeo.com/user98765432&quote;&gt;R1 Marketing&lt;/a&gt; na &lt;a href=&quote;https://vimeo.com&quote;&gt;Vimeo&lt;/a&gt;.&lt;/p&gt;</textarea> </li> <li> Kopirati morate samo <strong>&lt ;<i>iframe</i>&gt;</strong> del:<br> <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0,75 em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; širina=&quote;640&quote; višina=&quote;360&quote; frameborder=&quote;0&quote; dovoli=&quote;samodejno predvajanje; celozaslonski&quot; allowfullscreen&gt;&lt;/iframe&gt;</textarea> </li> </ol> <li>Prelepite to kodo v polje textarea e-listovnika exabis.</li> </ol>';
$string['what_is_embed_code_title'] = 'Kaj je embed koda?';
$string['whyEportfolio'] = 'Zakaj E-listovnik?';
$string['whyEportfolio_description'] = '<h4>Ne dovolite, da vaše trdo delo izgine: zgradite svoj digitalni listovnik</h4> <br> <p>Predstavljajte si ves trud, ki ga vložite v naloge, predstavitve in projekte. Ali se kdaj počutite, kot da ostane po oddaji preprosto zakopan v predalu?</p> <p>Tu je dobra novica: ti projekti so <strong>dokaz vaših sposobnosti in znanja</strong> ,ki jih lahko uporabite, da naredite vtis na potencialne delodajalce ali stranke!</p> <p><strong>Zgradite svoj digitalni listovnik</strong> in predstavite svoje delo, od predstavitev, nalog in projektov do videoposnetkov. Lažje je, kot si mislite!</p> <br> <h4>Kaj je E-listovnik?</h4> <br> <p><strong>E-listovnik</strong> (elektronski listovnik) je <strong>digitalni zbirka</strong>, ki prikazuje vaše <strong>spretnosti, znanje in izkušnje</strong>. Medtem ko se vaš življenjepis osredotoča na vašo izobrazbo in delovno zgodovino, vaš e-listovnik presega to in zagotavlja <strong>dokaz in kontekst</strong> za vaše sposobnosti. Omogoča vam, da hitro in učinkovito predstavite svoje vzorce dela in <strong>pokažete svoj talent</strong>. Navsezadnje je vaš E-listovnik zmogljivo orodje za <strong>poudarjanje vaših kvalifikacij</strong> in vas izloči. </p> <p><strong>Ne pozabite, da lahko različne vloge zahtevajo različne vrste e-listovnikov.</strong> Vendar nekateri ključni elementi ostajajo nespremenjeni. <strong>Exabis listovnik</strong> vam omogoča, da <strong>ustvarite več pogledov</strong>, prilagojenih določenim položajem, zaposlitvenim priložnostim ali drugim namenom. </p> <br> <h4>Kako ustvariti svoj E-listovnik</h4> <br> <ol> <li><strong>Zberite svoje delo</strong>: Začnite tako, da pregledate vse svoje projekte, predstavitve in naloge .</li> <li><strong>Izberite svoje najboljše delo</strong>: Izberite kose, ki prikazujejo vaše najmočnejše sposobnosti in tiste, ki so prejeli pozitivne povratne informacije.</li> <li><strong>Razmislite in opišite< /strong>: Pomislite na spretnosti in kompetence, ki jih izkazuje vsak kos. Napišite kratek opis, da zagotovite kontekst.</li> <li><strong>Gradite in ponavljajte</strong>: Ne bojte se eksperimentirati in izboljšati svojega listovnika, ko se učite in rastete.</li> </ol > <p><strong>Exabis listovnik</strong> vas lahko vodi skozi vsak korak, zaradi česar bo proces izdelave vašega listovnika učinkovit.</p>';
$string['width'] = 'Širina';
$string['wrongfileid'] = 'Napačen ID datoteke';
$string['wrongfilepostid'] = 'Napačen ID datoteke';
$string['wronglinkid'] = 'Napačen ID povezave';
$string['wrongnoteid'] = 'Napačen ID zapiska';
$string['wrongnotepostid'] = 'Napačna vnos za opombo';
