<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'cs', version '4.5'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = 'Přijmout a pokračovat';
$string['action'] = 'Akce';
$string['action_generate_image'] = 'Vygenerovat obrázek';
$string['action_generate_image_desc'] = 'Vygenerovat obrázek na základě textové výzvy.';
$string['action_generate_text'] = 'Vygenerovat text';
$string['action_generate_text_desc'] = 'Vygenerovat text na základě textové výzvy.';
$string['action_generate_text_instruction'] = 'Obdržíte textový vstup od uživatele. Vaším úkolem je vygenerovat text na základě jejich požadavku. Postupujte podle těchto důležitých pokynů:
  1. Vraťte shrnutí pouze jako prostý text.
  2. Nezahrnujte žádné formátování markdown, pozdravy nebo fráze.';
$string['action_summarise_text'] = 'Shrnout text';
$string['action_summarise_text_desc'] = 'Shrnuje obsah textu na stránce kurzu.';
$string['action_summarise_text_instruction'] = 'Obdržíte textový vstup od uživatele. Vaším úkolem je shrnout poskytnutý text. Postupujte podle těchto pokynů:
  1. Zestručnění: Zkraťte dlouhé pasáže do klíčových bodů.
  2. Zjednodušení: Usnadněte pochopení složitých informací, zejména pro studenty.

Důležité pokyny:
  1. Vraťte shrnutí pouze jako prostý text.
  2. Nezahrnujte žádné formátování markdown, pozdravy nebo fráze.
  3. Zaměřte se na srozumitelnost, stručnost a dostupnost.

Ujistěte se, že shrnutí je snadno čitelné a efektivně vyjadřuje hlavní body původního textu.';
$string['action_translate_text'] = 'Přeložit text';
$string['action_translate_text_desc'] = 'Přeložit poskytnutý text z jednoho jazyka do druhého.';
$string['actionsettingprovider'] = 'nastavení akce {$a}';
$string['actionsettingprovider_desc'] = 'Tato nastavení řídí, jak {$a->providername} provede akci {$a->actionname}.';
$string['ai'] = 'AI';
$string['aiplacements'] = 'Umístění AI';
$string['aiproviders'] = 'poskytovatelé AI';
$string['aiusagepolicy'] = 'Zásady používání AI';
$string['availableplacements'] = 'Vyberte, kde jsou dostupné akce AI';
$string['availableplacements_desc'] = 'Umístění definují, jak a kde lze na vašem webu použít akce AI. V nastavení si můžete vybrat, které akce jsou k dispozici v jednotlivých umístěních.';
$string['availableproviders'] = 'Spravovat poskytovatele AI připojené k vašemu LMS';
$string['availableproviders_desc'] = 'Poskytovatelé umělé inteligence přidávají na váš web funkce umělé inteligence prostřednictvím „akcí“, jako je sumarizace textu nebo generování obrázků.<br/> Akce pro každého poskytovatele můžete spravovat v jeho nastavení.';
$string['contentwatermark'] = 'Generováno AI';
$string['declineaipolicy'] = 'Odmítnout';
$string['manageaiplacements'] = 'Správa umístění AI';
$string['manageaiproviders'] = 'Správa poskytovatelů AI';
$string['noproviders'] = 'Tato akce není k dispozici. Pro tuto akci nejsou nakonfigurováni žádní <a href="{$a}">poskytovatelé AI</a>.';
$string['placement'] = 'Umístění';
$string['placementactionsettings'] = 'Akce';
$string['placementactionsettings_desc'] = 'Akce AI dostupné pro toto umístění.';
$string['placementsettings'] = 'Nastavení specifická pro umístění';
$string['placementsettings_desc'] = 'Tato nastavení řídí, jak se toto umístění AI připojuje ke službě AI a souvisejícím operacím.';
$string['privacy:metadata:ai_action_generate_image'] = 'Tabulka ukládající požadavky uživatelů na generování obrázků.';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = 'Poměr stran generovaných obrázků.';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = 'Počet vygenerovaných obrázků.';
$string['privacy:metadata:ai_action_generate_image:prompt'] = 'Výzva pro požadavek na generování obrázku.';
$string['privacy:metadata:ai_action_generate_image:quality'] = 'Kvalita generovaných obrázků.';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = 'Upravená výzva k vygenerovaným obrázkům.';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = 'Zdrojová adresa URL generovaných obrázků.';
$string['privacy:metadata:ai_action_generate_image:style'] = 'Styl generovaných obrázků.';
$string['privacy:metadata:ai_action_generate_text'] = 'Tabulka ukládající požadavky uživatelů na generování textu.';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'Tokeny dokončení použité k vygenerování textu.';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'Jedinečný hash představující stav/verzi modelu a obsahu.';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'Skutečný text generovaný modelem AI na základě vstupní výzvy.';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'Výzva pro požadavek na generování textu.';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'Tokeny výzvy používané ke generování textu.';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'ID odpovědi.';
$string['privacy:metadata:ai_action_register'] = 'Tabulka obsahující požadavky na akce provedené uživateli.';
$string['privacy:metadata:ai_action_register:actionid'] = 'ID požadavku na akci.';
$string['privacy:metadata:ai_action_register:actionname'] = 'Název akce požadavku.';
$string['privacy:metadata:ai_action_register:provider'] = 'Název poskytovatele, který požadavek zpracoval.';
$string['privacy:metadata:ai_action_register:success'] = 'Stav žádosti o akci.';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'Čas dokončení žádosti.';
$string['privacy:metadata:ai_action_register:timecreated'] = 'Čas vytvoření žádosti.';
$string['privacy:metadata:ai_action_register:userid'] = 'ID uživatele, který zadal požadavek.';
$string['privacy:metadata:ai_action_summarise_text'] = 'Tabulka obsahující souhrnné textové požadavky uživatelů.';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'Tokeny dokončení používané k shrnutí textu.';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'Jedinečný hash představující stav/verzi modelu a obsahu.';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'Skutečný text generovaný modelem AI na základě vstupní výzvy.';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'Výzva pro žádost o souhrnný text.';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'Tokeny výzvy používané k shrnutí textu.';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'ID odpovědi.';
$string['privacy:metadata:ai_policy_register'] = 'Tabulka ukládající stav přijetí zásad AI pro každého uživatele.';
$string['privacy:metadata:ai_policy_register:contextid'] = 'ID kontextu, jehož data byla uložena.';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'Čas, kdy uživatel přijal zásady AI.';
$string['privacy:metadata:ai_policy_register:userid'] = 'ID uživatele, jehož data byla uložena.';
$string['provider'] = 'Poskytovatel';
$string['provideractionsettings'] = 'Akce';
$string['provideractionsettings_desc'] = 'Vyberte a nakonfigurujte akce, které může {$a} na vašem webu provádět.';
$string['providers'] = 'Poskytovatelé';
$string['providersettings'] = 'Nastavení';
$string['userpolicy'] = '<h4><strong>Vítejte v nové funkci AI!</strong></h4>
<p>
Tato funkce umělé inteligence (AI) je založena výhradně na externích modelech velkých jazyků (LLM), aby zlepšila vaše zkušenosti s učením a výukou. Než začnete používat tyto služby AI, přečtěte si tyto zásady použití.</p>
<h4><strong>Přesnost obsahu generovaného AI</strong></h4>
<p>AI může poskytovat užitečné návrhy a informace, ale její přesnost se může lišit. Vždy byste měli znovu zkontrolovat poskytnuté informace, abyste se ujistili, že jsou přesné, úplné a vhodné pro vaši konkrétní situaci.</p>
<h4><strong>Jak jsou vaše údaje zpracovávány</strong></h4>
<p>Tato funkce umělé inteligence využívá externí modely velkých jazyků (LLM). Pokud tuto funkci použijete, s jakýmikoli informacemi nebo osobními údaji, které sdílíte, bude nakládáno v souladu se zásadami ochrany osobních údajů těchto LLM. Doporučujeme, abyste si přečetli jejich zásady ochrany osobních údajů, abyste pochopili, jak budou s vašimi údaji nakládat. Na tomto webu může být navíc uložen záznam vašich interakcí s funkcemi AI.</p>
<p>Pokud máte dotazy ohledně toho, jak jsou vaše data zpracovávána, obraťte se na své učitele nebo vzdělávací organizaci.</p>
<p>Pokračováním potvrzujete, že rozumíte těmto zásadám a souhlasíte s nimi.</p>';
