<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plagiarism_urkund', language 'no', version '4.5'.
 *
 * @package     plagiarism_urkund
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allowallsupportedfiles'] = 'Tillat alle støttede filtyper';
$string['allowallsupportedfiles_help'] = 'Dette lar læreren begrense hvilke filtyper som skal sendes til Ouriginal for behandling. Det forhindrer ikke studentene fra å laste opp andre filtyper til innleveringen.';
$string['assessmentresubmitted'] = 'Innlevering sendt inn på nytt';
$string['attempts'] = 'Gjennomførte forsøk';
$string['cannotupgradeunprocesseddata'] = '<h1>Kan ikke oppgradere til denne versjonen pga ubehandlede data. Vennligst gå tilbake til en tidligere versjon av modulen og fjern gamle hendelser.</h1><p>Denne versjonen avhenger av nye hendelses API i Moodle, men installasjonen har ubehandlede hendelser relatert til gammelt API.</p>
 Du bør tilbakestille til en eldre versjon av Ouriginal-modulen, sette portalen i vedlikeholdsmodus, kjøre cron og forsikre deg om at alle gamle hendelser kjøres ferdig. Deretter kan du oppgradere modulen til siste versjon.</p>
 <p>Mer informasjon: <a href="https://docs.moodle.org/en/Plagiarism_Prevention_Ouriginal_Settings#Installation_failed_due_to_unprocessed_data">Ouriginal installasjon mislyktes på grunn av ubehandlede data</a></p>';
$string['charcount'] = 'Minste antall tegn';
$string['confirmresetall'] = 'Dette vil tilbakestille alle filer med status: {$a}';
$string['debugfilter'] = 'Filtrer filer etter';
$string['defaultsdesc'] = 'Følgende innstillinger er standardinnstillinger ved aktivering av Ouriginal som en aktivitetsmodul';
$string['defaultupdated'] = 'Standardverdier oppdatert';
$string['deletedwarning'] = 'Denne filen ble ikke funnet, den kan ha blitt slettet av brukeren';
$string['errorcode_3'] = 'Feilkode 3 - mindre 450 tegn OG20 ord';
$string['errorcode_4'] = 'Feilkode 4 - Dokumentet rakk ikke fristen (skjer kun dersom kursfunksjonen innenfor Ouriginal web innboks har en frist)';
$string['errorcode_7001'] = 'Feilkode 7001 - Dokumentet kunne ikke indekseres. Det betyr at en feil oppstod ved uthenting av tekst fra dokumentet. Dette vil vanligvis oppstå dersom det er tegn som er Unicode-inkompatible i dokumentet.';
$string['errorcode_unknown'] = 'Feil {$a} - En feil har oppstått';
$string['explainerrors'] = 'Denne siden viser alle filer med en feilmelding. <br /> Når filer slettes fra dennes siden, de vil ikke lengre kunne leveres på nytt og elever og lærere vil ikke lengre se feilmeldingen';
$string['file'] = 'Fil';
$string['filedeleted'] = 'Fil slettet fra kø';
$string['filereset'] = 'En fil har blitt tilbakestilt for ny gransking av Ouriginal';
$string['fileresubmitted'] = 'Fil lagt i køen for ny levering';
$string['filesresubmitted'] = '{$a} filer sendt inn på nytt';
$string['filter30'] = 'Ekskluder eldre enn 30 dager';
$string['filter7'] = 'Ekskluder eldre enn 7 dager';
$string['filter90'] = 'Ekskluder eldre enn 90 dager';
$string['getallscores'] = 'Hent alle resultater';
$string['getscore'] = 'Hent resultat';
$string['getscores'] = 'Hent resultater';
$string['heldevents'] = 'Gjennomførte hendelser';
$string['heldeventsdescription'] = 'Dette er hendelser som ikke ble fullført på første gjennomgang og er satt i kø for ny gjennomgang. Disse hindrer påfølgende hendelser fra å gjennomføres og kan ha behov for ytterligere granskning. Noen av disse hendelsene kan være urelatert til Ouriginal.';
$string['id'] = 'ID';
$string['identifier'] = 'Identifikator';
$string['module'] = 'Modul';
$string['modulenotfound'] = 'Kunne ikke finne modul for {$a->module} med id {$a->modid}.';
$string['name'] = 'Navn';
$string['nofilter'] = 'Ingen filter';
$string['noreceiver'] = 'Ingen mottaksadresse ble spesifisert';
$string['optout'] = 'Ikke lagre i Ouriginal';
$string['pending'] = 'Filen venter på levering til Ouriginal';
$string['pluginname'] = 'Ouriginal plagitatkontrollmodul';
$string['previouslysubmitted'] = 'Tidligere innsendt som';
$string['privacy:metadata:plagiarism_urkund_client:email'] = 'Bruker e-post';
$string['processing'] = 'Filen er blitt sendt til Ouriginal, venter på at analyse skal bli tilgjengelig';
$string['receivernotvalid'] = 'Ikke en gyldig mottaksadresse';
$string['regenerationrequested'] = 'Alle rapporter har blitt merket for regenerering. Det kan ta noetid før oppdaterte rapporter er tilgjengelige.';
$string['report'] = 'rapportere';
$string['restrictcontent'] = 'Lever inn vedlagte filer og online tekst';
$string['restrictcontent_help'] = 'Ouriginal kan behandle opplastede filer og online tekst fra foruminnlegg eller innleveringsoppgaver. Du kan bestemme hvilke komponenter som skal sendes til URKUND.';
$string['restrictcontentfiles'] = 'Lever kun inn vedlagte filer';
$string['restrictcontentno'] = 'Lever inn alt';
$string['restrictcontenttext'] = 'Lever kun inn online tekst';
$string['restrictfiles'] = 'Tiltyper for innlevering';
$string['resubmit'] = 'Lever på nytt';
$string['resubmitall'] = 'Send inn alle med statu: {$a} på nytt';
$string['resubmitclose'] = 'Send inn alle på nytt etter sluttdato';
$string['resubmitdue'] = 'Send inn alle på nytt etter innleveringsfristen';
$string['resubmittourkund'] = 'Regenerer alle Ouriginal-rapporter';
$string['savedconfigfailed'] = 'Feil brukernavn / passord, Ouriginal har blitt deaktivert, prøv igjen.';
$string['savedconfigsuccess'] = 'Innstillinger for plagiatkontroll lagret';
$string['scoreavailable'] = 'Filen har blitt gransket av Ouriginal, og en rapport er tilgjengelig';
$string['scorenotavailableyet'] = 'Filen har ennå ikke blitt gransket av Ouriginal';
$string['sendfiles'] = 'Send filer fra kø';
$string['showall'] = 'Vis alle feil';
$string['showwhencutoff'] = 'Etter aktivitetens sluttdato';
$string['showwhendue'] = 'Etter aktivitetens frist';
$string['similarity'] = 'Ouriginal';
$string['status'] = 'Status';
$string['studentdisclosure'] = 'Brukeravsløring';
$string['studentdisclosure_help'] = 'Alle brukere vil få se denne teksten på opplastingssiden';
$string['studentdisclosuredefault'] = 'Alle filer som lastes opp vil bli gransket av plagiatkontrolltjenesten Ouriginal. Hvis du vil forhindre at dokumentet ditt blir brukt som en analysekilde for andre organisasjoner kan du klikke på "Lagre ikke i Ouriginal"-lenken som vises etter at rapporten har blitt generert.';
$string['studentemailcontent'] = 'Filen du sendte inn til {$a->modulename} i {$a->coursename} har blitt gransket av plagiatkontrollverktøyet Ouriginal. {$a->modulelink}

Om du vil forhindre at dokumentet brukes som en analysekilde for andre organisasjoner kan du klikke på denne lenken for at teksten ikke skal lagres i Ouriginal. {$a->optoutlink}';
$string['studentemailcontentnoopt'] = 'Filen du sendte inn til $a->modulename} i {$a->coursename} har nå blitt behandlet av plagiatkontrollmodulen Ouriginal. {$a->modulelink}';
$string['studentemailsubject'] = 'Fil behandlet av Ouriginal';
$string['submitondraft'] = 'Lever fil ved opplasting';
$string['submitonfinal'] = 'Lever inn fil når en elev levere inn oppgaven';
$string['timesubmitted'] = 'Innleveringstidspunkt';
$string['toolarge'] = 'Denne filen er for stor for Ouriginal';
$string['unknownwarning'] = 'En feil oppstod når filen skulles sendes inn til Ouriginal';
$string['unknownwarninggetscore'] = 'Det oppstod en feil ved henting av score for denne filen fr Ouriginal';
$string['unsupportedfiletype'] = 'Denne filtypen støttes ikke av Ouriginal';
$string['updateallowedfiletypes'] = 'Oppdater tillatte filtyper og slett urkund-oppføringer tilknyttet slettede aktiviteter.';
$string['urkund'] = 'Ouriginal plagiatkontroll-plugin';
$string['urkund:advancedsettings'] = 'Tillater læreren å vise avanserte modulinnstillinger fra Ouriginal';
$string['urkund:enable'] = 'Tillater læreren å aktivere/deaktivere Ouriginal inne i en aktivitet';
$string['urkund:resetfile'] = 'Tillat læreren å sende inn filen på nytt til Ouriginal etter en feil.';
$string['urkund:resubmitallfiles'] = 'Tillater at læreren sender inn igjen alle filene til Ouriginal';
$string['urkund:resubmitonclose'] = 'Tillater at læreren sender inn igjen alle filene til Ouriginal etter fristen/sluttdatoen';
$string['urkund:viewreport'] = 'Tillat at læreren får se fullstendig rapport fra Ouriginal';
$string['urkund_advanceditems'] = 'Innstillinger som skal regnes som avanserte';
$string['urkund_advanceditems_help'] = 'Innstillinger som regnes som avanserte vil vises som avanserte i modulens innstillinger. De vil også skjules fra lærere som ikke har rettigheten \'urkund:advancedsettings\'.';
$string['urkund_api'] = 'Ouriginal integrasjonsadresse';
$string['urkund_api_help'] = 'Dette er adressen til Ouriginal API';
$string['urkund_draft_submit'] = 'Når skal filen sendes inn til Ouriginal';
$string['urkund_enableoptout'] = 'Vis avslagslenke';
$string['urkund_enableoptoutdesc'] = 'Deaktivering av denne innstillingen vil fjerne valget studentene har for å tilgjengeliggjøre innholdet av tekstene sine i bruk for søk i andre innleveringen. Ved å deaktivere denne innstillingen bekrefter du at du vil ta ansvaret foropphavsretten til studentenes innleveringer og at dette er i henhold til gjeldende lover.';
$string['urkund_enableplugin'] = 'Aktiver Ouriginal for {$a}';
$string['urkund_hidefilename'] = 'Skjul innleveringens filnavn';
$string['urkund_hidefilenamedesc'] = 'Aktivering av dette vil sende et generisk filnavn til Ouriginal slik at studentene ikke kan se filnavnet eller noen kilder som har likheter med en eksisterende innlevering.';
$string['urkund_lang'] = 'Språk';
$string['urkund_lang_help'] = 'Språkkode fra Ouriginal';
$string['urkund_password'] = 'Passord';
$string['urkund_password_help'] = 'Passord fra Ouriginal for å få tilgang til APIet';
$string['urkund_receiver'] = 'Mottakeradresse';
$string['urkund_receiver_help'] = 'Dette er den unike adressen fra Ouriginal som læreren skal bruke';
$string['urkund_resubmit_on_close'] = 'Send inn på nytt ved avslutning';
$string['urkund_resubmit_on_close_desc'] = 'Send inn oppgaver til Ouriginal etter innleveringsperioden er utløpt.';
$string['urkund_resubmit_on_close_help'] = 'Aktivering av dette valget vil gjøre at innleveringer blir sendt inn igjen til Ouriginal når innleveringsperioden utløper.';
$string['urkund_show_student_report'] = 'Vis likhetsrapporten til eleven';
$string['urkund_show_student_report_help'] = 'Likhetsrapporten viser hvilke deler av innleveringen som er plagiat, og stedet der Ouriginal først fant dette innholdet.';
$string['urkund_show_student_score'] = 'Vis likhetsscore til eleven';
$string['urkund_show_student_score_help'] = 'Likhetsscoren er andelen av innleveringen som har likheter med andres innhold.';
$string['urkund_studentemail'] = 'Send studentepost';
$string['urkund_studentemail_help'] = 'Dette vil sende en epost til eleven når en fil har blitt gransket for at de skal få vite at en rapport er tilgjengelig. Eposten inneholder også "Ikke lagre i URKUND"-lenken.';
$string['urkund_username'] = 'Brukernavn';
$string['urkund_username_help'] = 'Brukernavn for tilgang til Ouriginal APIet';
$string['urkunddebug'] = 'Debugging';
$string['urkunddefaults'] = 'Standarder for Ouriginal';
$string['urkunddefaults_assign'] = 'Standard innleveringsinnstillinger';
$string['urkunddefaults_forum'] = 'Standard foruminnstillinger';
$string['urkunddefaults_hsuforum'] = 'Standard hsuforuminnstillinger';
$string['urkunddefaults_workshop'] = 'Standrd workshopinnstillinger';
$string['urkundexplain'] = 'For mer informasjon om denne modulen se: <a href="https://ouriginal.com" target="_blank">ouriginal.com</a>';
$string['urkundfiles'] = 'Filer i Ouriginal';
$string['useurkund'] = 'Slå på URKUND';
$string['waitingevents'] = 'Det er {$a->countallevents} ventende hendelser i cron og {$a->countheld} venter på ny levering.';
