<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'da', version '4.5'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Den angivne admin-mappe er forkert';
$string['admindirname'] = 'Admin-mappe';
$string['admindirsetting'] = 'Nogle få webhoteller bruger /admin som en speciel URL til webhotellets kontrolpanel el. lign. Det er et problem da Moodle også bruger /admin som standard til administrationssiderne. I så fald kan du omdøbe admin-mappen og skrive det nye navn her. For eksempel: <br /> <br /><b>moodleadmin</b><br /> <br />
Dette vil rette linkene til adminsiderne i Moodle.';
$string['admindirsettinghead'] = 'Opretter admin-mappen...';
$string['admindirsettingsub'] = 'Nogle få webhoteller bruger /admin som en speciel URL til webhotellets kontrolpanel el. lign. Det er et problem da Moodle også bruger /admin som standard til administrationssiderne. I så fald kan du omdøbe admin-mappen og skrive det nye navn her. For eksempel: <br /> <br /><b>moodleadmin</b><br /> <br /> Dette vil rette linkene til adminsiderne i Moodle.';
$string['availablelangs'] = 'Tilgængelige sprogpakker';
$string['caution'] = 'Pas på';
$string['chooselanguage'] = 'Vælg et sprog';
$string['chooselanguagehead'] = 'Vælg et sprog';
$string['chooselanguagesub'] = 'Vælg et sprog til brug under installationen. Dette sprog vil også blive brugt som standardsprog på webstedet, men det kan altid ændres til et andet sprog.';
$string['cliadminemail'] = 'Ny adminbrugers e-mailadresse';
$string['cliadminpassword'] = 'Ny kode til admin-bruger';
$string['cliadminusername'] = 'Adminkonto-brugernavn';
$string['clialreadyconfigured'] = 'Konfigurationsfilen config.php eksisterer allerede. Benyt venigst admin/cli/install_database.php til at installere Moodle for dette site.';
$string['clialreadyinstalled'] = 'Filen config.php eksisterer allerede, brug admin/cli/install_database.php hvis du ønsker at opgradere dette websted.';
$string['cliinstallfinished'] = 'Installationen er fuldført.';
$string['cliinstallheader'] = 'Moodle {$a} kommandolinje-installationsprogram';
$string['climustagreelicense'] = 'I ikke-interaktiv tilstand skal du acceptere licensen ved at tilføje optionen --agree-license';
$string['cliskipdatabase'] = 'Springer databaseinstallation over';
$string['clisupportemail'] = 'Supportens email-adresse';
$string['clitablesexist'] = 'Databasetabeller er allerede oprettet, CLI-installationen kan ikke fortsætte.';
$string['compatibilitysettings'] = 'Kontrollerer dine php-indstillinger...';
$string['compatibilitysettingshead'] = 'Kontrollerer dine php-indstillinger...';
$string['compatibilitysettingssub'] = 'For at Moodle kan køre tilfredsstillende skal din server "bestå" alle disse tests.';
$string['configfilenotwritten'] = 'Installationsscriptet kunne ikke oprette config.php-filen, der indeholder de valgte indstillinger, sandsynligvis fordi Moodle-mappen er skrivebeskyttet. Du kan manuelt kopiere den følgende kode ind i en fil med navnet "config.php" i roden af Moodle-mappen.';
$string['configfilewritten'] = 'config.php er blevet oprettet';
$string['configurationcomplete'] = 'Konfigurationen er færdig.';
$string['configurationcompletehead'] = 'Konfigurationen er færdig.';
$string['configurationcompletesub'] = 'Moodle har forsøgt at gemme din konfiguration i en fil i roden af Moodle-installationen.&nbsp;';
$string['database'] = 'Database';
$string['databasehead'] = 'Databaseindstillinger';
$string['databasehost'] = 'Databasevært';
$string['databasename'] = 'Databasenavn';
$string['databasepass'] = 'Databasekode';
$string['databaseport'] = 'Databaseport';
$string['databasesocket'] = 'Unixsokkel';
$string['databasetypehead'] = 'Vælg databasedriver';
$string['databasetypesub'] = 'Moodle understøtter flere typer databaser. Kontakt serverens administrator, hvis du ikke ved, hvilken type du skal bruge.';
$string['databaseuser'] = 'Databasebruger';
$string['dataroot'] = 'Datamappe';
$string['datarooterror'] = 'Datamappen du specificerede kan ikke findes eller oprettes. Ret stien til mappen eller opret den direkte.';
$string['datarootpermission'] = 'Rettighed til data mapper';
$string['datarootpublicerror'] = 'Den datamappe du har angivet, har direkte adgang fra internettet, du skal bruge en anden mappe.';
$string['dbconnectionerror'] = 'Den angive database kunne ikke kontaktes. Kontroller eller ret databaseinformationerne.';
$string['dbcreationerror'] = 'Fejl ved oprettelse af databasen. Kan ikke oprette den givne database med de angivne indstillinger.';
$string['dbhost'] = 'Værtsserver';
$string['dbpass'] = 'Adgangskode';
$string['dbport'] = 'Port';
$string['dbprefix'] = 'Præfiks for tabeller';
$string['dbtype'] = 'Type';
$string['directorysettings'] = '<p>Kontroller placeringen af Moodle-installationen.</p> <p><b>Webadresse:<b> Angiv den fulde webadresse (URL) til Moodle. Hvis sitet kan tilgås fra flere URL\'er så vælg den mest naturlige, den som de studerende oftest vil bruge. Der må ikke være en skråstreg til sidst.</p> <p><b>Moodle-mappe:</b> Angiv den fulde sti til installationen. Vær opmærksom på at angive korrekte små og store bogstaver.</p> <p><b>Datamappe:</b> Den mappe, hvori Moodle gemmer uploadede filer. Den bruger apache kører under (typisk \'nobody\' eller \'apache\'), skal have læse- og SKRIVEADGANG til mappen, og der må ikke være direkte adgang til den fra internettet.</p>';
$string['directorysettingshead'] = 'Bekræft hvor Moodle skal installeres';
$string['directorysettingssub'] = '<b>Webadresse:</b> Angiv den fulde adresse til Moodle. Hvis der skal være adgang til siden fra flere URL\'er så vælg den naturligste, den deltagerne vil bruge. Der må ikke være en skråstreg til sidst. <br /> <br /> <b>Moodle-mappe:</b> Angiv den fulde sti til installationen. Vær opmærksom på at angive korrekte små og store bogstaver. <br /> <br /> <b>Datamappe:</b> Den mappe, hvori Moodle gemmer uploadede filer. Den bruger apache kører under (typisk \'nobody\' eller \'apache\'), skal have læse- og SKRIVEADGANG til mappen. Der må ikke være direkte adgang til den fra internettet.';
$string['dirroot'] = 'Moodle-mappe';
$string['dirrooterror'] = 'Den angivne "moodle-mappe" lader ikke til at være rigtig - der er ingen Moodleinstallation der. Den nedenstående værdi er blevet nulstillet.';
$string['download'] = 'Download';
$string['downloadlanguagebutton'] = 'Download "{$a}"-sprogpakken';
$string['downloadlanguagehead'] = 'Download sprogpakke';
$string['downloadlanguagenotneeded'] = 'Du kan fortsætte installationen med standardsprogpakken,"{$a}".';
$string['downloadlanguagesub'] = 'Du har nu mulighed for at hente en sprogpakke og fortsætte installationsprocessen på dette sprog.<br /><br />Kan du ikke downloade sprogpakken vil installationen fortsætte på engelsk. (Når installationsprocessen er færdig kan du downloade og installere flere sprogpakker.)';
$string['doyouagree'] = 'Er du enig? (ja/nej):';
$string['environmenthead'] = 'Kontrollerer din serveropsætning...';
$string['environmentsub'] = 'Vi tjekker om de forskellige komponenter i dit system lever op til Moodles krav.';
$string['environmentsub2'] = 'Hver version af Moodle har nogle minimumskrav til PHP-version og nogle obligatoriske PHP-extensions.
Installationsprogrammet udfører et tjek før hver installation og opgradering. Kontakt din serveradministrator hvis ikke du ved hvordan du installerer en ny version eller aktiverer PHP-extensions.';
$string['errorsinenvironment'] = 'Systemtjekket mislykkedes!';
$string['fail'] = 'Mislykkedes';
$string['fileuploads'] = 'Fil-uploads';
$string['fileuploadserror'] = 'Denne skal være aktiveret';
$string['fileuploadshelp'] = '<p>Fil-upload lader til at være slået fra på din server.</p><p>Moodle kan stadig installeres, men uden senere mulighed for at uploade kursusfiler og profilbilleder.</p> <p>For at tillade upload skal du (eller systemadministratoren) redigere php.ini og ændre indstillingen for <b>fil_uploads</b> til \'1\'.</p>';
$string['inputdatadirectory'] = 'Datamappe:';
$string['inputwebadress'] = 'Web-adresse:';
$string['inputwebdirectory'] = 'Moodlebibliotek:';
$string['installation'] = 'Installation';
$string['invaliddbprefix'] = 'Ugyldigt præfiks. Kan kun have små og store bogstaver samt understreg.';
$string['langdownloaderror'] = 'Sproget "{$a}" blev desværre ikke downloadet. Installationen vil fortsætte på engelsk.';
$string['langdownloadok'] = 'Sproget "{$a}" blev installeret. Installationen vil fortsætte på dette sprog.';
$string['memorylimit'] = 'Hukommelsesgrænse';
$string['memorylimiterror'] = 'Den tilgængelige hukommelse til PHP er ret lav... Det kan være at der opstår problemer senere.';
$string['memorylimithelp'] = '<p>Den mængde hukommelse PHP kan bruge, er sat til {$a}.</p>

<p>Det kan forårsage at der opstår problemer senere, især hvis du har mange moduler aktiveret eller mange brugere.</p>

<p>Vi anbefaler at du konfigurerer PHP med mere hukommelse, f.eks. 40M. Der er flere måder hvorpå du kan ændre det.</p>
<ol>
<li>Hvis du har mulighed for det, kan du rekompilere PHP med <i>--enable-memory-limit</i>. Det vil tillade at Moodle selv kan definere hvor meget hukommelse der er brug for.</li>
<li>Hvis du har adgang til php.ini filen kan du ændre <b>memory_limit</b>-indstillingen til noget i retning af 40M. Hvis du ikke har direkte adgang til den kan du bede systemadministratoren om at gøre det for dig.</li>
<li>På nogle servere kan du oprette en \'.htaccess\'-fil og gemme den i moodle-mappen med linjen: <blockquote><div>php_value memory_limit 40M</div></blockquote>

<p>Det kan dog på nogle servere forhindre <b>alle</b> PHP-siderne i at virke (du vil se fejl når du ser på siderne). I så fald kan du blive nødt til at fjerne \'.htaccess\'filen igen.</p></li> </ol>';
$string['mysqliextensionisnotpresentinphp'] = 'PHP er ikke konfigureret korrekt med MySqli-extensionen så den kan kommunikere med MySql. Tjek php.ini eller rekompiler PHP.';
$string['nativeauroramysql'] = 'Aurora MySQL (native/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p>I databasen gemmes de fleste af Moodles indstillinger og data, og den skal konfigureres her.</p> <p>Databasenavnet, brugernavn og adgangskode er obligatoriske felter, tabelpræfiks er frivilligt at udfylde.</p> <p>Databasenavnet må indeholde alfanumeriske tegn, dollar ($) og understregning (_).</p> <p>Hvis ikke databasen allerede er oprettet og den angivne bruger har tilladelse til det, vil Moodle søge at oprette en ny database med de korrekte tilladelser og indstillinger.</p> <p>Denne driver er ikke kompatibel med legacy MyISAM engine.</p>';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>Databasen gemmer de fleste Moodleindstillinger og -data og den skal konfigureres her.</p>
<p>Databasenavn, brugernavn og adgangskode er obligatoriske felter, tabel-præfiks er frivillig.</p>
<p>Databasenavnet kan bestå af alfanumeriske tegn, dollar ($) og \'underscore\' (_).</p>
<p>Hvis ikke databasen allerede eksisterer, og hvis den specificerede bruger har tilladelse til det, vil Moodle forsøge at oprette en ny database med de rigtige tilladelser og indstillinger.</p>
<p>Denne driver er ikke kompatibel med legacy MyISAM engine.</p>';
$string['nativemysqli'] = 'Forbedret MySQL (native/mysqli)';
$string['nativemysqlihelp'] = '<p>Databasen gemmer de fleste Moodleindstillinger og -data og den skal konfigureres her.</p>
<p>Databasenavn, brugernavn og adgangskode er obligatoriske felter, tabel-præfiks er frivillig.</p>
<p>Databasenavnet kan bestå af alfanumeriske tegn, dollar ($) og \'underscore\' (_).</p>
<p>Hvis ikke databasen allerede eksisterer, og hvis den specificerede bruger har tilladelse til det, vil Moodle forsøge at oprette en ny database med de rigtige tilladelser og indstillinger.</p>';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Nu skal du konfigurere den database, hvor de fleste Moodledata vil blive gemt. Denne database skal allerede været oprettet sammen med et brugernavn og en adgangskode til at få adgang til den. Tabelpræfiks er obligatorisk.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = '<p>Databasen gemmer de fleste Moodleindstillinger og -data og den skal konfigureres her.</p>
<p>Databasenavnet, brugernavn, adgangskode and tabelpræfiks er obligatoriske felter.</p> <p>Databasen skal være oprettet i forvejen og brugeren skal have både læse- og skriveadgang til den.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Nu skal du konfigurere den database, hvor de fleste Moodledata vil blive gemt. Denne database skal allerede været oprettet sammen med et brugernavn og en adgangskode til at få adgang til den. Tabelpræfiks er obligatorisk.';
$string['nativesqlsrvnodriver'] = 'Microsoft Drivere til SQL Server for PHP er ikke installeret eller ikke konfigureret korrekt.';
$string['ociextensionisnotpresentinphp'] = 'PHP er ikke konfigureret korrekt med OCI8-extensionen så den kan kommunikere med Oracle. Tjek din php.ini-fil eller kompiler PHP igen.';
$string['pass'] = 'OK';
$string['paths'] = 'Stier';
$string['pathserrcreatedataroot'] = 'Datamappen ({$a->dataroot}) kan ikke oprettes af installationsprogrammet.';
$string['pathshead'] = 'Bekræft stier';
$string['pathsrodataroot'] = 'Datamappen er skrivebeskyttet.';
$string['pathsroparentdataroot'] = 'Den overordnede mappe ({$a->parent}) er skrivebeskyttet. Datamappen ({$a->dataroot}) kan ikke oprettes af installationsprogrammet.';
$string['pathssubadmindir'] = 'Enkelte webhoteller bruger /admin som speciel URL til kontrolpanelet el. lign. Desværre konflikter det med Moodles standardplacering af admin-sider. Du kan klare dette ved at give admin-mappen et andet navn i din installation og skrive det her. Det kan f.eks. være <em>moodleadmin</em>. Det vil fikse admin-links i Moodle.';
$string['pathssubdataroot'] = '<p>En mappe hvori Moodle kan gemme uploadede filer.</p>
<p>Webserver-brugeren (som regel \'www-data\', \'nobody\', eller \'apache\') skal have læse- og skriveadgang til den.</p>
<p>Mappen  må ikke være tilgængelig direkte fra internettet.</p>
<p>Hvis ikke den allerede eksisterer, vil Installationsprogrammet forsøge at oprette den</p>';
$string['pathssubdirroot'] = '<p>Den fulde sti til mappen med Moodlekoden.</p>';
$string['pathssubwwwroot'] = '<p>Moodles fulde web-adresse, dvs. adressen som den skal stå i browserens adressefelt for at komme ind på Moodle.</p>
<p>Moodle kan ikke bruges fra flere adresser. Hvis dit websted kan tilgås fra flere adresser, skal du vælge den enkleste og opsætte permanent viderestilling for hver af de øvrige.</p>
<p>Hvis dit websted er tilgængeligt fra både internettet og et internt net (nogen gange kaldet intranet), skal du bruge den offentlige adresse her</p>
<p>Hvis ikke adressen er korrekt, skal du ændre URL\'en i din browser og genstarte installationen.</p>';
$string['pathsunsecuredataroot'] = 'Datamappen er ikke sikret';
$string['pathswrongadmindir'] = 'Adminmappe eksisterer ikke';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP er ikke konfigureret korrekt med PHP\'s PGSQL-modul så den kan kommunikere med PostgreSQL. Tjek filen php.ini eller kompiler PHP igen.';
$string['phpextension'] = '{$a} PHP-extension';
$string['phpversion'] = 'PHP-version';
$string['phpversionhelp'] = '<p>Moodle kræver mindst PHP version 5.6.5. eller 7.1 (7.0.x har nogle maskinbegrænsninger).</p>
<p>Webserveren bruger i øjeblikket version {$a}</p>
<p>Du bliver nødt til at opgradere PHP eller flytte systemet over på en anden webserver der har en nyere version af PHP!</p>';
$string['releasenoteslink'] = 'Information om denne version af Moodle: se udgivelsesnoterne på siden {$a}';
$string['safemode'] = 'Safe mode';
$string['safemodeerror'] = 'Moodle kan have problemer med "Safe mode: on"';
$string['safemodehelp'] = '<p>Moodle kan have flere problemer når "safe mode" er slået til, ikke mindst kan systemet sandsynligvis ikke oprette nye filer.</p>

<p>"Safe Mode" er oftest slået til hos paranoide offentlige webhoteller, så det kan være at du bliver nødt til at finde et andet webhotel til Moodle.</p>

<p>Du kan godt fortsætte installationen, men der vil sandsynligvis opstå problemer senere.</p>';
$string['sessionautostart'] = 'Session-autostart';
$string['sessionautostarterror'] = 'Denne skal være deaktiveret';
$string['sessionautostarthelp'] = '<p>Moodle kræver at PHP understøtter sessioner.</p> <p>Sessioner kan aktiveres i php.ini..., kik efter parameteren session.auto_start</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP er ikke korrekt konfigureret med SQLite-udvidelsen. Tjek filen php.ini eller kompiler PHP igen.';
$string['upgradingqtypeplugin'] = 'Opgraderer plugin\'et question/type';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Du ser denne side fordi du har installeret og åbnet pakken <strong>{$a->packname} {$a->packversion}</strong> på din computer.
Tillykke med det!';
$string['welcomep30'] = 'Denne version af <strong>{$a->installername}</strong> indeholder programmerne til at oprette et miljø, hvori <strong>Moodle</strong> vil operere, nemlig:';
$string['welcomep40'] = 'Pakken indeholder også <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Brugen af programmerne i denne pakke reguleres af deres respektive licenser. Hele <strong>{$a->installername}</strong>-pakken er <a href="https://www.opensource.org/docs/definition_plain.html">open source</a> og distribueret under <a href="https://www.gnu.org/copyleft/gpl.html">GPL</a>-licensen.';
$string['welcomep60'] = 'De følgende sider vil hjælpe dig gennem nogle nemme trin til konfiguration og opsætning af <strong>Moodle</strong> på din computer. Du kan acceptere standardindstillingerne, eller vælge at ændre dem så de bedre svarer til dine egne behov.';
$string['welcomep70'] = 'Klik på "Næste" herunder for at forsætte opsætningen af <strong>Moodle</strong>.';
$string['wwwroot'] = 'Webadresse';
$string['wwwrooterror'] = 'Webadressen fremstår ikke korrekt - Moodle-installationen kunne ikke findes der. Værdien herunder er nulstillet.';
