<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_dataprivacy', language 'da', version '4.5'.
 *
 * @package     tool_dataprivacy
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitiesandresources'] = 'Aktiviteter og materialer';
$string['addcategory'] = 'Tilføj kategori';
$string['addnewdefaults'] = 'Tilføj en ny modulstandard';
$string['addpurpose'] = 'Tilføj formål';
$string['addroleoverride'] = 'Tilføj tilsidesættelse af rolle';
$string['allowfiltering'] = 'Tillad eksportfiltrering efter kursus';
$string['allowfiltering_desc'] = 'Hvis aktiveret, kan den databeskyttelsesansvarlige vælge at eksportere brugerdata fra udvalgte kurser i stedet for alle kurser. Når denne funktion er aktiveret, starter eksportanmodninger fra \'Afventer\' og kan kun godkendes efter en baggrundsopgave er afsluttet.';
$string['approve'] = 'Godkend';
$string['approvedrequestsubmitted'] = 'Din forespørgsel er sendt og vil snart blive behandlet.';
$string['approverequest'] = 'Godkend forespørgsel';
$string['approverequestall'] = 'Godkend anmodning (alle data)';
$string['approveselectedcourses'] = 'Godkend udvalgte kurser';
$string['automaticdatadeletionapproval'] = 'Automatisk godkendelse af forespørgsler på sletning af data';
$string['automaticdatadeletionapproval_desc'] = 'Er indstillingen aktiveret, vil forespørgsler på sletning af data automatisk blive godkendt.<br/>Bemærk at den automatiske godkendelse kun påvirker nye forespørgsler. Eksisterende forespørgsler på sletning af data skal stadig håndteres manuelt af privatlivsassistenten.';
$string['automaticdataexportapproval'] = 'Automatisk godkendelse af forespørgsler på eksport af data';
$string['automaticdataexportapproval_desc'] = 'Er indstillingen aktiveret, vil forespørgsler på eksport af data automatisk blive godkendt.<br/>Bemærk at den automatiske godkendelse kun påvirker nye forespørgsler. Eksisterende forespørgsler på eksport af data skal stadig håndteres manuelt af privatlivsassistenten.';
$string['automaticdeletionrequests'] = 'Opret automatiske forespørgsler på sletning af data';
$string['automaticdeletionrequests_desc'] = 'Er indstillingen aktiveret, vil en forespørgsel om sletning af data oprettes automatisk for enhver brugerkonto der er slettet manuelt.';
$string['bulkapproverequests'] = 'Godkend anmodninger';
$string['bulkdenyrequests'] = 'Afvis anmodninger';
$string['cachedef_contextlevel'] = 'Kontekstniveauers formål og kategori';
$string['cachedef_purpose'] = 'Dataformål';
$string['cachedef_purpose_overrides'] = 'Formåls-overstyringer i databeskyttelsesværktøjet';
$string['cancelrequest'] = 'Annuller forespørgsel';
$string['cancelrequestconfirmation'] = 'Ønsker du at annullere denne dataanmodning?';
$string['cannotreset'] = 'Kunne ikke nulstille forespørgslen. Kun afviste forespørgsler kan nulstilles.';
$string['categories'] = 'Kategorier';
$string['categorieslist'] = 'Liste med datakategorier';
$string['category'] = 'Kategori';
$string['category_help'] = 'En kategori i dataregisteret beskriver en datatype. En ny kategori kan tilføjes, eller Nedarv kan vælges, så den overliggende kategori anvendes. Kontekster er (nedefra): Blokke > Aktivitetsmoduler > Kurser > Kursuskategorier > Websted.';
$string['categorycreated'] = 'Kategori oprettet';
$string['categorydefault'] = 'Standardkategori';
$string['categorydefault_help'] = 'Standardkategorien anvendes på nye forekomster. Vælges Nedarv, vil kategorien ovenover anvendes. Kontekster er (nedefra): Blokke > Aktivitetsmoduler > Kurser > Kursuskategorier > Websted.';
$string['categoryupdated'] = 'Kategori opdateret';
$string['close'] = 'Luk';
$string['compliant'] = 'Overensstemmende';
$string['confirmapproval'] = 'Bekræft at du vil godkende denne forespørgsel';
$string['confirmbulkapproval'] = 'Vil du virkelig godkende de valgte dataforespørgsler samlet?';
$string['confirmbulkdenial'] = 'Vil du virkelig masseafvise de valgte dataforespørgsler?';
$string['confirmcompletion'] = 'Vil du virkelig markere denne brugerhenvendelse som gennemført?';
$string['confirmcontextdeletion'] = 'Vil du virkelig bekræfte sletning af de valgte kontekster? Det vil også slette al brugerdata i den respektive underkontekst.';
$string['confirmdenial'] = 'Vil du virkelig afslå denne dataforespørgsel?';
$string['confirmrequestresubmit'] = 'Er du sikker på at du vil annullere den aktuelle {$a->type} forespørgsel på {$a->username} og gensende den?';
$string['contactdataprotectionofficer'] = 'Kontakt vores privatlivsassistent';
$string['contactdataprotectionofficer_desc'] = 'Aktiveres indstillingen kan brugere kontakte privatlivsassistenten og via et link på profilsiden bede om at få en kopi af deres data.';
$string['contactdpoviaprivacypolicy'] = 'Kontakt privatlivsassistenten som beskrevet i politikken angående privatlivsbeskyttelse.';
$string['contextlevelname10'] = 'Websted';
$string['contextlevelname30'] = 'Brugere';
$string['contextlevelname40'] = 'Kursuskategorier';
$string['contextlevelname50'] = 'Kurser';
$string['contextlevelname70'] = 'Aktivitetsmoduler';
$string['contextlevelname80'] = 'Blokke';
$string['contextpurposecategorysaved'] = 'Formål og kategori gemt.';
$string['createcategory'] = 'Opret datakategori';
$string['createdeletedatarequest'] = 'Opret forespørgsel på sletning af data';
$string['createnewdatarequest'] = 'Opret en ny henvendelse om persondata';
$string['createpurpose'] = 'Opret dataformål';
$string['creationauto'] = 'Automatisk';
$string['creationmanual'] = 'Manuelt';
$string['datadeletion'] = 'Sletning af data';
$string['datadeletionpagehelp'] = 'Her vises data for hvilke opbevaringsperioden er udløbet. Gennemse og bekræft sletningen, som vil blive udført automatisk af den planlagte opgave "Slet udløbet data".';
$string['dataprivacy:downloadallrequests'] = 'Download eksporterede data for alle';
$string['dataprivacy:downloadownrequest'] = 'Download dine egne eksporterede data';
$string['dataprivacy:makedatadeletionrequestsforchildren'] = 'Bed om sletning af mindreåriges data';
$string['dataprivacy:makedatarequestsforchildren'] = 'Opret en dataforespørgsel for mindreårige';
$string['dataprivacy:managedataregistry'] = 'Håndter dataregister';
$string['dataprivacy:managedatarequests'] = 'Håndter dataforespørgsler';
$string['dataprivacy:requestdelete'] = 'Bed om sletning af dine egne data';
$string['dataprivacy:requestdeleteforotheruser'] = 'Bed om sletning af data på vegne af en anden bruger';
$string['dataregistry'] = 'Dataregister';
$string['dataregistryinfo'] = 'Dataregisteret muliggør oprettelse af kategorier for al indhold på siden - fra brugere og kurser ned til aktiviteter og blokke. Der kan oprettes kategorier dels til typer af data og dels til formål med databehandlingen. Til hvert formål kan sættes en maksimal opbevaringsperiode. Når perioden udløber, vil data blive markeret til sletning, som først skal godkendes af administrator.';
$string['datarequestcreatedforuser'] = 'Oprettet dataforespørgsel for {$a}';
$string['datarequestcreatedfromscheduledtask'] = 'Automatisk oprettet fra en planlagt opgave (tidligere eksisterende nu slettet bruger).';
$string['datarequestcreatedupondelete'] = 'Automatisk oprettet efter sletning af bruger.';
$string['datarequestemailsubject'] = 'Dataforespørgsel: {$a}';
$string['datarequests'] = 'Henvendelser om data';
$string['dataretentionexplanation'] = 'Denne beskrivelse viser standardkategorier og formål for opbevaring af brugerdata. Visse områder kan have mere specifikke kategorier og formål end dem der er vist her.';
$string['dataretentionsummary'] = 'Beskrivelse af dataopbevaring';
$string['datecomment'] = '[{$a->date}]:
 {$a->comment}';
$string['daterequested'] = 'Dato';
$string['daterequesteddetail'] = 'Dato for efterspørgsel';
$string['defaultexpired'] = 'Data for alle brugere';
$string['defaultexpiredexcept'] = 'Data for alle brugere bortset fra brugere med disse roller:<br> {$a->unexpired}';
$string['defaultsinfo'] = 'Standardkategorier og formål er føjet til alle nyligt oprettede forekomster, der ikke har dem defineret.';
$string['defaultssaved'] = 'Standarder gemt';
$string['defaultswarninginfo'] = 'Advarsel: Ændring af disse standarder kan påvirke opbevaringsperioden for eksisterende forekomster.';
$string['defaultunexpired'] = 'Kun data for brugere med disse roller:<br> {$a->expired}';
$string['defaultunexpiredwithexceptions'] = 'Kun data for brugere med nogle af de følgende roller:<br>
{$a->expired}
Bortset fra hvis de også har nogle af de følgende roller:<br>
{$a->unexpired}';
$string['deletecategory'] = 'Slet kategori';
$string['deletecategorytext'] = 'Er du sikker på at du vil slette kategorien "{$a}"?';
$string['deletedefaults'] = 'Slet standarder: {$a}';
$string['deletedefaultsconfirmation'] = 'Er du sikker på at du vil slette standardkategorien og formålet for {$a} moduler?';
$string['deleteexistingdeleteduserstask'] = 'Opret en forespørgsel på sletning af data for tidligere eksisterende slettede brugere.';
$string['deleteexpiredcontextstask'] = 'Slet udløbet data';
$string['deleteexpireddatarequeststask'] = 'Slet eksportfiler fra udløbne dataforespørgsler';
$string['deletemyaccount'] = 'Slet min brugerkonto';
$string['deletepurpose'] = 'Slet formålet';
$string['deletepurposetext'] = 'Er du sikker på at du vil slette formålet "{$a}"?';
$string['deny'] = 'Afslå';
$string['denyrequest'] = 'Afvis';
$string['deprecated'] = 'Forældet';
$string['deprecatedexplanation'] = 'Dette plugin bruger en gammel version af et privatheds-interface  og skal opdateres.';
$string['download'] = 'Download';
$string['downloadexpireduser'] = 'Download er udløbet. Send en ny forespørgsel hvis du vil eksportere personlige data.';
$string['dporolemapping'] = 'Rolletilknytning for privatlivsassistent';
$string['dporolemapping_desc'] = 'Privatlivsassistenten kan håndtere dataforespørgsler. Beføjelsen tool/dataprivacy:managedatarequests skal være tilladt for en rolle for at den kan være privatlivsassistent.';
$string['duplicaterole'] = 'Rollen er allerede specificeret';
$string['editcategories'] = 'Rediger kategorier';
$string['editcategory'] = 'Rediger kategori';
$string['editdefaults'] = 'Rediger standarder: {$a}';
$string['editmoduledefaults'] = 'Rediger modul-standarder';
$string['editpurpose'] = 'Rediger formål';
$string['editpurposes'] = 'Rediger formål';
$string['effectiveretentionperiodcourse'] = '{$a} (efter kursets slutdato)';
$string['effectiveretentionperioduser'] = '{$a} (siden brugeren sidst besøgte dette websted)';
$string['emailsalutation'] = 'Kære {$a}';
$string['errorcannotrequestdeleteforother'] = 'Du har ikke tilladelse til at oprette en forespørgsel på sletning af data for denne bruger.';
$string['errorcannotrequestdeleteforself'] = 'Du har ikke tilladelse til at oprette en forespørgsel på sletning af data for dig selv.';
$string['errorcannotrequestexportforself'] = 'Du har ikke tilladelse til at oprette en eksportanmodning for dig selv.';
$string['errorcontactdpodisabled'] = 'Muligheden for at kontakte den databeskyttelsesansvarlige er deaktiveret.';
$string['errorcontexthasunexpiredchildren'] = 'Konteksten "{$a}" har stadig underkontekster der endnu ikke er udløbet. Ingen kontekster er markeret til sletning.';
$string['errorinvalidrequestcomments'] = 'Kommentarfeltet kan kun indeholde almindelig tekst.';
$string['errorinvalidrequestcreationmethod'] = 'Ugyldig metode til oprettelse af forespørgsel!';
$string['errorinvalidrequeststatus'] = 'Ugyldig status på forespørgsel!';
$string['errorinvalidrequesttype'] = 'Ugyldig type forespørgsel!';
$string['errornocapabilitytorequestforothers'] = 'Brugeren {$a->requestedby} har ikke beføjelse til at oprette en dataforespørgsel på vegne af brugeren {$a->userid}';
$string['errornoexpiredcontexts'] = 'Der er ingen udløbne kontekster at behandle';
$string['errornoselectedcourse'] = 'Du skal vælge mindst ét kursus';
$string['errorrequestalreadyexists'] = 'Du har allerede en forespørgsel under behandling.';
$string['errorrequestnotfound'] = 'Forespørgslen blev ikke fundet';
$string['errorrequestnotwaitingforapproval'] = 'Forespørgslen venter ikke på godkendelse. Enten er den ikke klar endnu eller den er allerede behandlet.';
$string['errorsendingmessagetodpo'] = 'Der opstod en fejl under forsøg på at sende en besked til {$a}.';
$string['exceptionnotificationbody'] = '<p>Der opstod en undtagelse ved kald af <b>{$a->fullmethodname}</b>.<br>Det betyder at plugin\'et <b>{$a->component}</b> ikke gjorde databehandlingen færdig. Følgende information kan gives til udvikleren af plugin\'et:</p><pre>{$a->message}<br> {$a->backtrace}</pre>';
$string['exceptionnotificationsubject'] = 'Der opstod en undtagelse under behandling af privatlivsdata';
$string['expandplugin'] = 'Udvid eller sammenklap plugin';
$string['expandplugintype'] = 'Udvid og sammenklap plugintypen.';
$string['expiredretentionperiodtask'] = 'Opbevaringsperiode udløbet';
$string['expiredrolewithretention'] = '{$a->retention} (Udløbet)';
$string['expiry'] = 'Udløb';
$string['explanationtitle'] = 'Ikoner brugt på denne side og hvad de betyder.';
$string['external'] = 'Ekstra';
$string['externalexplanation'] = 'Et ekstra plugin installeret på dette websted.';
$string['filterexportdata'] = 'Godkend anmodning (data fra udvalgte kurser)';
$string['filteroption'] = '{$a->category}: {$a->name}';
$string['frontpagecourse'] = 'Forsidekurset';
$string['gdpr_art_6_1_a_description'] = 'Den registrerede har givet samtykke til behandling af sine personoplysninger til et eller flere specifikke formål.';
$string['gdpr_art_6_1_a_name'] = 'Samtykke (GDPR Art. 6.1(a))';
$string['gdpr_art_6_1_b_description'] = 'Behandling er nødvendig af hensyn til opfyldelse af en kontrakt, som den registrerede er part i, eller af hensyn til gennemførelse af foranstaltninger, der træffes på den registreredes anmodning forud for indgåelse af en kontrakt.';
$string['gdpr_art_6_1_b_name'] = 'Samtykke (GDPR Art. 6.1(b))';
$string['gdpr_art_6_1_c_description'] = 'Behandling er nødvendig for at overholde en retlig forpligtelse, som påhviler den dataansvarlige.';
$string['gdpr_art_6_1_c_name'] = 'Retlig forpligtelse (GDPR Art 6.1(c))';
$string['gdpr_art_6_1_d_description'] = 'Behandling er nødvendig for at beskytte den registreredes eller en anden fysisk persons vitale interesser.';
$string['gdpr_art_6_1_d_name'] = 'Vitale interesser (GDPR Art. 6.1(d))';
$string['gdpr_art_6_1_e_description'] = 'Behandling er nødvendig af hensyn til udførelse af en opgave i samfundets interesse eller som henhører under offentlig myndighedsudøvelse, som den dataansvarlige har fået pålagt.';
$string['gdpr_art_6_1_e_name'] = 'Offentlig myndighedsudøvelse (GDPR Art. 6.1(e))';
$string['gdpr_art_6_1_f_description'] = 'Behandling er nødvendig for, at den dataansvarlige eller en tredjemand kan forfølge en legitim interesse, medmindre den registreredes interesser eller grundlæggende rettigheder og frihedsrettigheder, der kræver beskyttelse af personoplysninger, går forud herfor, navnlig hvis den registrerede er et barn.';
$string['gdpr_art_6_1_f_name'] = 'Legitime interesser (GDPR Art. 6.1(f))';
$string['gdpr_art_9_2_a_description'] = 'Den registrerede har givet udtrykkeligt samtykke til behandling af sådanne personoplysninger til et eller flere specifikke formål, medmindre det i EU-retten eller medlemsstaternes nationale ret er fastsat, at det i stk. 1 omhandlede forbud ikke kan hæves ved den registreredes samtykke.';
$string['gdpr_art_9_2_a_name'] = 'Udtrykkeligt samtykke (GDPR Art. 9.2(a))';
$string['gdpr_art_9_2_b_description'] = 'Behandling er nødvendig for at overholde den dataansvarliges eller den registreredes arbejds-, sundheds- og socialretlige forpligtelser og specifikke rettigheder, for så vidt den har hjemmel i EU-retten eller medlemsstaternes nationale ret eller en kollektiv overenskomst i medfør af medlemsstaternes nationale ret, som giver fornødne garantier for den registreredes grundlæggende rettigheder og interesser.';
$string['gdpr_art_9_2_b_name'] = 'Arbejds-, sundheds- og socialretlige forpligtelser og rettigheder (GDPR Art. 9.2(b))';
$string['gdpr_art_9_2_c_description'] = 'Behandling er nødvendig for at beskytte den registreredes eller en anden fysisk persons vitale interesser i tilfælde, hvor den registrerede fysisk eller juridisk ikke er i stand til at give samtykke.';
$string['gdpr_art_9_2_c_name'] = 'Beskyttelse af vitale interesser (GDPR Art. 9.2(c))';
$string['gdpr_art_9_2_d_description'] = 'Behandling foretages af en stiftelse, en sammenslutning eller et andet organ, som ikke arbejder med gevinst for øje, og hvis sigte er af politisk, filosofisk, religiøs eller fagforeningsmæssig art, som led i organets legitime aktivitet er og med de fornødne garantier, og på betingelse af at behandlingen alene vedrører organets medlemmer, tidligere medlemmer eller personer, der på grund af organets formål er i regelmæssig kontakt hermed, og at personoplysningerne ikke videregives uden for organet uden den registreredes samtykke.';
$string['gdpr_art_9_2_d_name'] = 'Stiftelser, sammenslutninger eller andre organer (GDPR Art. 9.2(d))';
$string['gdpr_art_9_2_e_description'] = 'Behandling vedrører personoplysninger, som tydeligvis er offentliggjort af den registrerede.';
$string['gdpr_art_9_2_e_name'] = 'Personoplysninger offentliggjort af den registrerede (GDPR Art. 9.2(e))';
$string['gdpr_art_9_2_f_description'] = 'Behandling er nødvendig, for at retskrav kan fastlægges, gøres gældende eller forsvares, eller når domstole handler i deres egenskab af domstol.';
$string['gdpr_art_9_2_f_name'] = 'Retskrav og domstole (GDPR Art. 9.2(f))';
$string['gdpr_art_9_2_g_description'] = 'Behandling er nødvendig af hensyn til væsentlige samfundsinteresser på grundlag af EU-retten eller medlemsstaternes nationale ret og står i rimeligt forhold til det mål, der forfølges, respekterer det væsentligste indhold af retten til databeskyttelse og sikrer passende og specifikke foranstaltninger til beskyttelse af den registreredes grundlæggende rettigheder og interesser.';
$string['gdpr_art_9_2_g_name'] = 'Væsentlige samfundsinteresser (GDPR Art. 9.2(g))';
$string['gdpr_art_9_2_h_description'] = 'Behandling er nødvendig med henblik på forebyggende medicin eller arbejdsmedicin til vurdering af arbejdstagerens erhvervsevne, medicinsk diagnose, ydelse af social- og sundhedsomsorg eller -behandling eller forvaltning af social- og sundhedsomsorg og -tjenester på grundlag af EU-retten eller medlemsstaternes nationale ret eller i henhold til en kontrakt med en sundhedsperson og underlagt de betingelser og garantier, der er omhandlet i stk. 3.';
$string['gdpr_art_9_2_h_name'] = 'Medicinske formål (GDPR Art. 9.2(h))';
$string['gdpr_art_9_2_i_description'] = 'Behandling er nødvendig af hensyn til samfundsinteresser på folkesundhedsområdet, f.eks. beskyttelse mod alvorlige grænseoverskridende sundhedsrisici eller sikring af høje kvalitets- og sikkerhedsstandarder for sundhedspleje og lægemidler eller medicinsk udstyr på grundlag af EU-retten eller medlemsstaternes nationale ret, som fastsætter passende og specifikke foranstaltninger til beskyttelse af den registreredes rettigheder og frihedsrettigheder, navnlig tavshedspligt.';
$string['gdpr_art_9_2_i_name'] = 'Folkesundhed (GDPR Art. 9.2(i))';
$string['gdpr_art_9_2_j_description'] = 'Behandling er nødvendig til arkivformål i samfundets interesse, til videnskabelige eller historiske forskningsformål eller til statistiske formål i overensstemmelse med artikel 89, stk. 1, på grundlag af EU-retten eller medlemsstater nes nationale ret og står i rimeligt forhold til det mål, der forfølges, respekterer det væsentligste indhold af retten til databeskyttelse og sikrer passende og specifikke foranstaltning er til beskyttelse af den registreredes grundlæggende rettigheder og interesser.';
$string['gdpr_art_9_2_j_name'] = 'Samfundsinteresse, eller videnskabelig/historisk/statistisk forskning (GDPR Art. 9.2(j))';
$string['hide'] = 'Sammenklap alle';
$string['httpwarning'] = 'Data hentet fra dette site er måske ikke krypteret. Kontakt systemets administrator og bed om at få installeret SSL.';
$string['inherit'] = 'Nedarv';
$string['lawfulbases'] = 'Retligt grundlag';
$string['lawfulbases_help'] = 'Vælg mindst et punkt som retligt grundlag for behandling af personlige oplysninger. Lovteksten kan ses på siden <a href="https://gdpr-info.eu/art-6-gdpr/" target="_blank">GDPR Art. 6.1</a>. En dansk udgave kan hentes i en pdf på siden  <a href="https://dbreform.dk/" target="_blank">dbreform.dk</a>';
$string['markcomplete'] = 'Marker som fuldført';
$string['markedcomplete'] = 'Din henvendelse er markeret som ekspederet af privatlivsassistenten.';
$string['message'] = 'Besked';
$string['messagelabel'] = 'Besked:';
$string['messageprovider:contactdataprotectionofficer'] = 'Henvendelser om data';
$string['messageprovider:datarequestprocessingresults'] = 'Resultater for behandling af dataanmodninger';
$string['messageprovider:notifyexceptions'] = 'Meddelelser om undtagelser for dataanmodninger';
$string['moduleinstancename'] = '{$a->instancename} ({$a->modulename})';
$string['mypersonaldatarequests'] = 'Mine personlige dataforespørgsler';
$string['nameandparent'] = '{$a->parent}/{$a->name}';
$string['nameemail'] = '{$a->name} ({$a->email})';
$string['nchildren'] = '{$a} børn';
$string['newrequest'] = 'Ny henvendelse';
$string['noactivitiestoload'] = 'Ingen aktiviteter';
$string['noassignedroles'] = 'Ingen tildelte roller i denne kontekst';
$string['noblockstoload'] = 'Ingen blokke';
$string['nocategories'] = 'Der er endnu ingen kategorier';
$string['nocoursestoload'] = 'Ingen aktiviteter';
$string['nocoursetofilter'] = 'Brugeren er ikke tilmeldt nogen kurser, der kan vælges';
$string['nodatarequests'] = 'Der er ingen dataforespørgsler';
$string['nodatarequestsmatchingfilter'] = 'Ingen dataforespørgsler matcher filteret';
$string['noexpiredcontexts'] = 'Dette kontekstniveau har ingen data med udløbet opbevaringsperiode.';
$string['nopersonaldatarequests'] = 'Du har ingen forespørgsler på personlige data';
$string['nopurposes'] = 'Der er endnu ingen formål';
$string['nosubjectaccessrequests'] = 'Der er ingen datahenvendelser du behøver at reagere på';
$string['nosystemdefaults'] = 'Formål for webstedet og kategorien er endnu ikke defineret.';
$string['notset'] = 'Ikke sat (brug standardværdien)';
$string['notyetexpired'] = '{$a} (endnu ikke udløbet)';
$string['overrideinstances'] = 'Nulstil forekomster med tilpassede værdier';
$string['pluginname'] = 'Databeskyttelse';
$string['pluginname_help'] = 'Databeskyttelsesplugin';
$string['pluginregistry'] = 'Privatlivsregistersplugin';
$string['pluginregistrytitle'] = 'Plugindatabeskyttelsesregister';
$string['privacy'] = 'Privatlivsbeskyttelse';
$string['privacy:metadata:preference:tool_dataprivacy_request-filters'] = 'Aktuelle filtre på siden med dataforespørgsler';
$string['privacy:metadata:preference:tool_dataprivacy_request-perpage'] = 'Det antal dataforespørgsler brugeren foretrækker per side';
$string['privacy:metadata:purpose'] = 'Information fra dataformål lavet for dette site.';
$string['privacy:metadata:purpose:usermodified'] = 'ID’et på brugeren, der ændrede formålet';
$string['privacy:metadata:request'] = 'Information fra persondataanmodninger (adgangs- og sletteanmodninger) lavet for dette site.';
$string['privacy:metadata:request:comments'] = 'Brugerkommentarer i forespørgslen.';
$string['privacy:metadata:request:dpocomment'] = 'Kommentarer fra privatlivsassistenten angående forespørgslen.';
$string['privacy:metadata:request:requestedby'] = 'ID’et på brugeren, der lavede anmodningen, hvis lavet på vegne af en anden bruger.';
$string['privacy:metadata:request:timecreated'] = 'Tidsstemplet, der angiver hvornår anmodningen blev lavet af brugeren.';
$string['privacy:metadata:request:userid'] = 'ID’et på brugeren, som anmodningen tilhører';
$string['privacyofficeronly'] = 'Kun brugere som har en rolle som privatlivsassistent ({$a}) kan tilgå dette indhold';
$string['privacyrequestexpiry'] = 'Udløb af dataforespørgsel';
$string['privacyrequestexpiry_desc'] = 'Det tidsrum godkendte dataforespørgsler vil kunne downloades inden de udløber. Sættes værdien til nul, vil der ikke være nogen grænse.';
$string['protected'] = 'Fortsæt';
$string['protectedlabel'] = 'Opbevaringsperioden for disse data har retlig forrang over brugerens ønske om at blive glemt. Data vil først blive slettet efter udløb af opbevaringsperioden.';
$string['purpose'] = 'Formål';
$string['purpose_help'] = 'Formålet beskriver grunden til databehandlingen. Et nyt formål kan tilføjes eller Nedarv kan vælges, så det overliggende formål anvendes. Kontekster er (nedefra): Blokke > Aktivitetsmoduler > Kurser > Kursuskategorier > Websted.';
$string['purposecreated'] = 'Formål oprettet';
$string['purposedefault'] = 'Standardformål';
$string['purposedefault_help'] = 'Standardformålet anvendes på nye forekomster. Vælges Nedarv, vil formålet ovenover anvendes. Kontekster er (nedefra): Blokke > Aktivitetsmoduler > Kurser > Kursuskategorier > Websted.';
$string['purposeoverview'] = 'Et formål beskriver intentionen og opbevaringspolitikken for de gemte data. Baggrunden for opbevaring af disse data beskrives også i formålet.';
$string['purposes'] = 'Formål';
$string['purposeslist'] = 'Liste med dataformål';
$string['purposeupdated'] = 'Formål opdateret';
$string['replyto'] = 'Svar til';
$string['requestactions'] = 'Handlinger';
$string['requestapproved'] = 'Forespørgslen er blevet godkendt';
$string['requestby'] = 'Forespurgt af';
$string['requestbydetail'] = 'Forespurgt af:';
$string['requestcomments'] = 'Kommentarer';
$string['requestcomments_help'] = 'Her kan du uddybe din henvendelse.';
$string['requestcreation'] = 'Oprettelse';
$string['requestdenied'] = 'Forespørgslen er blevet afvist';
$string['requestemailintro'] = 'Du har modtaget en dataforespørgsel:';
$string['requestfor'] = 'Bruger';
$string['requestmarkedcomplete'] = 'Forespørgslen er blevet markeret som fuldført';
$string['requestorigin'] = 'Websted';
$string['requestsapproved'] = 'Forespørgslen er blevet godkendt';
$string['requestsdenied'] = 'Forespørgslen er blevet afvist';
$string['requeststatus'] = 'Status';
$string['requestsubmitted'] = 'Din henvendelse er sendt til privatlivsassistenten';
$string['requesttype'] = 'Type';
$string['requesttype_help'] = 'Vælg grunden til at du vil kontakte vores privatlivsassistent. Bemærk at sletning af dine data vil resultere i at du vil ikke længere vil kunne logge ind';
$string['requesttypedelete'] = 'Slet alle mine personlige data';
$string['requesttypedeleteshort'] = 'Slet';
$string['requesttypeexport'] = 'Eksporter alle mine personlige data';
$string['requesttypeexportallowfiltering'] = 'Eksporter mine persondata';
$string['requesttypeexportshort'] = 'Eksporter';
$string['requesttypeothers'] = 'Generel henvendelse';
$string['requesttypeothersshort'] = 'Besked';
$string['requesttypeuser'] = '{$a->typename} ({$a->user})';
$string['requireallenddatesforuserdeletion'] = 'Betragt kurser uden slutdato som aktive';
$string['requireallenddatesforuserdeletion_desc'] = 'Ved beregning af brugerens udløb af deltagelsesperiode tages der flere faktorer i betragtning:

* brugerens sidste logintid sammenlignes med opbevaringsperioden for brugere; og
* om brugeren er aktivt tilmeldt nogen kurser.

Når du kontrollerer den aktive tilmelding i et kursus, bruges denne indstilling hvis ikke kurset har nogen slutdato, til at afgøre om kurset betragtes som aktivt eller ej.

Hvis kurset ikke har nogen slutdato, og denne indstilling er aktiveret, kan brugeren ikke slettes.';
$string['requiresattention'] = 'Kræver opmærksomhed';
$string['requiresattentionexplanation'] = 'Dette plugin er ikke kompatibelt med Moodles privatlivs-API. Eventuelle gemte persondata kan ikke eksporteres eller slettes af Moodles privatlivsmodul.';
$string['resubmitrequest'] = 'Gensend forespørgslen {$a->type} for {$a->username}';
$string['resubmitrequestasnew'] = 'Gensend som ny forespørgsel';
$string['resubmittedrequest'] = 'Den eksisterende {$a->type} forespørgsel for {$a->username} blev annulleret og gensendt';
$string['resultdeleted'] = 'Du har for nylig bedt om at få slettet din konto og dine personlige data i {$a}. Det er hermed gjort, og du vil ikke længere kunne logge ind.';
$string['resultdownloadready'] = 'Den kopi du har bedt om af dine personlige data i {$a}, er nu klar til download, og kan hentes via linket herunder.';
$string['retentionperiod'] = 'Opbevaringsperiode';
$string['retentionperiod_help'] = 'Opbevaringsperioden specificerer hvor længe data må behandles. Når perioden udløber, markeres data til sletning, som så afventer godkendelse fra administrator.';
$string['retentionperiodnotdefined'] = 'Der er ikke opgivet en opbevaringsperiode';
$string['retentionperiodzero'] = 'Ingen opbevaringsperiode';
$string['reviewdata'] = 'Gennemse data';
$string['role'] = 'Rolle';
$string['role_help'] = 'Den rolle tilsidesættelsen skal gælde for.';
$string['roleoverride'] = 'Overskrivning af rolle';
$string['roleoverrideoverview'] = 'Standardpolitikken for opbevaring kan overskrives for specifikke brugerroller, sådan at du kan specificere en længere eller kortere opbevaringsperiode.  En bruger udløber først når alle vedkommendes roller er udløbet.';
$string['roleoverrides'] = 'Overskrivninger af roller';
$string['selectbulkaction'] = 'Vælg en massehandling.';
$string['selectcourses'] = 'Vælg kurser til eksport';
$string['selectdatarequests'] = 'Vælg dataforespørgsler';
$string['selectuserdatarequest'] = 'Vælg {$a->username}\'s {$a->requesttype} dataforespørgsel';
$string['send'] = 'Send';
$string['sensitivedatareasons'] = 'Årsag til behandling af personfølsomme data';
$string['sensitivedatareasons_help'] = 'Vælg en eller flere relevante grunde der dispenserer fra forbud mod behandling af personfølsomme data forbundet med dette formål. Se mere information på siden <a href="https://gdpr-info.eu/art-9-gdpr/" target="_blank">GDPR Art. 9.2</a>';
$string['setdefaults'] = 'Sæt standarder';
$string['showdataretentionsummary'] = 'Vis beskrivelse af dataopbevaring';
$string['showdataretentionsummary_desc'] = 'Er indstillingen aktiveret, vil et link til beskrivelse af dataopbevaring vises i sidefoden og i brugerens profil.';
$string['statusapproved'] = 'Godkendt';
$string['statusawaitingapproval'] = 'Afventer godkendelse';
$string['statuscancelled'] = 'Annulleret';
$string['statuscomplete'] = 'Fuldført';
$string['statusdeleted'] = 'Slettet';
$string['statusdetail'] = 'Status:';
$string['statusexpired'] = 'Udløbet';
$string['statuspending'] = 'Venter';
$string['statuspreprocessing'] = 'Forbehandling';
$string['statusprocessing'] = 'Behandler';
$string['statusready'] = 'Download klar';
$string['statusrejected'] = 'Afvist';
$string['subjectscope'] = '';
$string['subjectscope_help'] = 'Emneområdet viser de roller, der kan tildeles i denne kontekst.';
$string['summary'] = 'Oversigt over registerkonfiguration';
$string['systemconfignotsetwarning'] = 'Der er ikke defineret et webstedsformål og en kategori. Når disse ikke er defineret, fjernes alle data når anmodninger om sletning behandles.';
$string['tobedeleted'] = 'Data der skal slettes';
$string['unexpiredrolewithretention'] = '{$a->retention} (Ikke udgået)';
$string['user'] = 'Bruger';
$string['userlistexplanation'] = 'Dette plugin har baseudbyderen, men skal også implementere brugerlisteudbyderen for fuld understøttelse af fortrolighedsfunktionalitet.';
$string['userlistnoncompliant'] = 'Udbyder af brugerliste mangler';
$string['viewrequest'] = 'Se forespørgslen';
$string['visible'] = 'Udvid alle';
