<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'sr_cr', version '4.5'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Процес креирања резервне копије је завршен';
$string['asyncbackupcompletebutton'] = 'Настави';
$string['asyncbackupcompletedetail'] = 'Процес креирања резервне копије је успешно завршен. <br/> Резервној копији можете приступити на <a href="{$a}">страници за рестаурирање.</a>';
$string['asyncbackuperror'] = 'Процес креирања резервне копије није успео';
$string['asyncbackuperrordetail'] = 'Процес креирања резервне копије није успео. Обратите се администратору система.';
$string['asyncbackuppending'] = 'Процес креирања резервне копије је на чекању';
$string['asyncbackupprocessing'] = 'Креирања резервне копије је у току';
$string['asyncbadexecution'] = 'Лош контролер креирања резервне копије. Вредност му је {$a} а треба да буде 2.';
$string['asynccheckprogress'] = 'Напредак можете проверити у било ком тренутку на <a href="{$a}">страници за рестаурирање</a>.';
$string['asyncemailenable'] = 'Омогући обавештења';
$string['asyncemailenabledetail'] = 'Ако је ова опција омогућена, корисници ће примити обавештење када се заврши асинхроно креирање или рестаурирање резервне копије.';
$string['asyncgeneralsettings'] = 'Асинхроно креирање/рестаурирање резервне копије';
$string['asyncmessagebody'] = 'Обавештење';
$string['asyncmessagebodydefault'] = 'Ваше {operation} (ID: {backupid}) успешно је завршено. Можете му приступити овде: <a href="{link}">{link}</a>.';
$string['asyncmessagebodydetail'] = 'Обавештење које ће бити послато када се заврши асинхроно креирање или рестаурирање резервне копије.';
$string['asyncmessagesubject'] = 'Тема';
$string['asyncmessagesubjectdefault'] = 'Moodle {operation} успешно завршен/а/о';
$string['asyncmessagesubjectdetail'] = 'Тема обавештења';
$string['asyncnowait'] = 'Не морате да чекате овде, јер ће се процес наставити у позадини.';
$string['asyncprocesspending'] = 'Процес на чекању';
$string['asyncrestorecomplete'] = 'Процес рестаурирања је завршен';
$string['asyncrestorecompletebutton'] = 'Настави';
$string['asyncrestorecompletedetail'] = 'Процес рестаурирања резервне копије успешно је завршен. Клик на дугме \'Настави\' одвешће вас на <a href="{$a}">курс за рестаурирану ставку.</a>';
$string['asyncrestoreerror'] = 'Процес рестаурирања резервне копије није успео';
$string['asyncrestoreerrordetail'] = 'Процес рестаурирања резервне копије није успео. Обратите се администратору система.';
$string['asyncrestoreinprogress'] = 'Процес рестаурирања резервне копије је у току';
$string['asyncrestoreinprogress_help'] = 'Овде су приказана асинхрона рестаурирања резервних копија курсева која су у току.';
$string['asyncrestorepending'] = 'Процес рестаурирања резервне копије на чекању';
$string['asyncrestoreprocessing'] = 'Рестаурирања резервне копије у току';
$string['asyncreturn'] = 'Повратак на курс';
$string['autoactivedescription'] = 'Изаберите хоће ли резервне копије бити креиране аутоматски или не. Ако је изабрана опција \'Ручно\', аутоматско прављење резервних копија биће могуће једино путем аутоматизоване CLI скрипте. Наведена скрипта може да буде покренута било ручно из командне линије или путем крона.';
$string['autoactivedisabled'] = 'Онемогућено';
$string['autoactiveenabled'] = 'Омогућено';
$string['autoactivemanual'] = 'Ручно';
$string['automatedbackupschedule'] = 'Распоред';
$string['automatedbackupschedulehelp'] = 'Изаберите дане у седмици када ће се аутоматски креирати резервне копије.';
$string['automatedbackupsinactive'] = 'Администратор сајта није омогућио аутоматско креирање резервних копија';
$string['automatedbackupstatus'] = 'Статус аутоматског креирања резервних копија';
$string['automateddeletedays'] = 'Обриши резервне копије старије од';
$string['automatedmaxkept'] = 'Максималан број резервних копија који се чува';
$string['automatedmaxkepthelp'] = 'Ово подешавање одређује максималан број скорашњих аутоматских резервних копија који се чува за сваки курс. Старије резервне копије биће аутоматски обрисане.';
$string['automatedminkept'] = 'Минималан број резервних копија који се чува';
$string['automatedminkepthelp'] = 'Ако се резервне копије, старије од наведеног броја дана, бришу, може се десити да неактивни курсеви буду без резервних копија. Да се ово не би догодило потребно је навести минималан број копија који се чува.';
$string['automatedsettings'] = 'Подешавања за аутоматско креирање резервних копија';
$string['automatedsetup'] = 'Подешавање аутоматског креирања резервних копија';
$string['automatedstorage'] = 'Простор за чување аутоматски креираних резервних копија';
$string['automatedstoragehelp'] = 'Изаберите место на којем желите да сачувате резервне копије када буду аутоматски креиране.';
$string['backupactivity'] = 'Активност креирања резервне копије: {$a}';
$string['backupautoactivitiesdescription'] = 'Поставља подразумевану вредност за укључивање активности у резервну копију. Како би корпа за отпатке функционисала, ово подешавање мора бити омогућено.';
$string['backupcourse'] = 'Резервна копија курса: {$a}';
$string['backupcoursedetails'] = 'Подаци о курсу';
$string['backupcoursesection'] = 'Секција: {$a}';
$string['backupcoursesections'] = 'Секције курса';
$string['backupdate'] = 'Датум';
$string['backupdetails'] = 'Детаљи резервне копије';
$string['backupdetailsnonstandardinfo'] = 'Изабрана датотека није стандардна Moodle датотека резервне копије. Процес рестаурације ће покушати да конвертује датотеку у стандардни формат и потом да је рестаурира.';
$string['backupfile'] = 'Датотека резервне копије';
$string['backupformat'] = 'Формат';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Непознати формат';
$string['backuplog'] = 'Техничке информације и упозорења';
$string['backupmode'] = 'Начин';
$string['backupmode10'] = 'Општи';
$string['backupmode20'] = 'Увоз';
$string['backupmode30'] = 'Чвориште';
$string['backupmode40'] = 'Исти сајт';
$string['backupmode50'] = 'Аутоматизовано';
$string['backupmode60'] = 'Конвертовано';
$string['backupmode70'] = 'Асинхроно';
$string['backupsection'] = 'Резервна копија секције курса: {$a}';
$string['backupsettings'] = 'Подешавања резервне копије';
$string['backupsitedetails'] = 'Детаљи о сајту';
$string['backupstage16action'] = 'Настави';
$string['backupstage1action'] = 'Следеће';
$string['backupstage2action'] = 'Следеће';
$string['backupstage4action'] = 'Креирај резервну копију';
$string['backupstage8action'] = 'Настави';
$string['backupthenrestore'] = 'Резервна копија је креирана. Започните са рестаурирањем.';
$string['backuptype'] = 'Тип';
$string['backuptypeactivity'] = 'Активност';
$string['backuptypecourse'] = 'Курс';
$string['backuptypesection'] = 'Секција';
$string['backupversion'] = 'Верзија резервне копије';
$string['cannotfindassignablerole'] = 'Није могуће пресликати улогу {$a} у датотеци резервне копије ни на једну од улога које Ви можете да доделите.';
$string['choosefilefromactivitybackup'] = 'Простор за резервне копије активности';
$string['choosefilefromactivitybackup_help'] = 'Датотеке резервне копије за ову активност.';
$string['choosefilefromautomatedbackup'] = 'Аутоматско креирање резервних копија';
$string['choosefilefromautomatedbackup_help'] = 'Датотеке резервне копије се аутоматски генеришу.';
$string['choosefilefromcoursebackup'] = 'Простор за резервне копије курса';
$string['choosefilefromcoursebackup_help'] = 'Датотеке резервне копије за овај курс.';
$string['choosefilefromuserbackup'] = 'Простор за приватне резервне копије корисника';
$string['choosefilefromuserbackup_help'] = 'Приватне датотеке резервних копија за све курсеве, са укљученом опцијом \'Анонимизуј информације о кориснику\'.';
$string['config_keep_groups_and_groupings'] = 'Стандардно, задржи текуће групе и груписања.';
$string['config_keep_roles_and_enrolments'] = 'Стандардно, задржи текуће улоге и уписе.';
$string['config_overwrite_conf'] = 'Омогућава кориснику да измени тренутну конфигурацију курса';
$string['config_overwrite_course_fullname'] = 'Стандардно, замените пун назив курса са оним који је у резервној копији. Ово захтева да опција "Измени конфигурацију курса" буде означена и да тренутни корисник има способност да мења пун назив курса (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'Стандардно, замените скраћени назив курса са оним који је у резервној копији. Ово захтева да опција "Измени конфигурацију курса" буде означена и да тренутни корисник има способност да мења скраћени назив курса (moodle/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'Стандардно, замените датум почетка курса са оним који је у резервној копији. Ово захтева да опција "Измени конфигурацију курса" буде означена и да тренутни корисник приликом рестаурирања има способност да мења датум почетка курса (moodle/restore:rolldates)';
$string['configgeneralactivities'] = 'Поставља подразумевану вредност за укључивање активности у резервну копију.';
$string['configgeneralanonymize'] = 'Ако је омогућено ова опција, све информације о корисницима биће сакривене (постаће анонимне).';
$string['configgeneralbadges'] = 'Поставља подразумевану вредност за укључивање беџева у резервне копије.';
$string['configgeneralblocks'] = 'Поставља подразумевану вредност за укључивање блокова у резервну копију.';
$string['configgeneralcalendarevents'] = 'Поставља подразумевану вредност за укључивање догађаја из календара у резервну копију.';
$string['configgeneralcomments'] = 'Поставља подразумевану вредност за укључивање коментара у резервну копију.';
$string['configgeneralcompetencies'] = 'Поставља подразумевану вредност за укључивање компетенција у резервну копију.';
$string['configgeneralcontentbankcontent'] = 'Подешава укључивање садржаја банке садржаја у резервну копију као подразумевано.';
$string['configgeneralcustomfield'] = 'Подешава подразумевану вредност за укључивање прилагођених поља у резервну копију.';
$string['configgeneralfiles'] = 'Подешава укључивање датотека у резервне копије као подразумевано. Имајте у виду: Искључивање овог подешавања резултираће резервном копијом која укључује само референце на датотеке. Ово није проблем ако се резервна копија рестаурира на истом сајту и датотеке нису избрисане у складу са подешавањем \'Очисти датотеке означене као смеће\'.';
$string['configgeneralfilters'] = 'Поставља подразумевану вредност за укључивање филтера у резервну копију.';
$string['configgeneralgroups'] = 'Поставља подразумевано укључивања група и груписања у резервне копије.';
$string['configgeneralhistories'] = 'Поставља подразумевану вредност за укључивање историје корисника у резервну копију.';
$string['configgenerallogs'] = 'Ако је ова опција омогућена, записи о активностима, стандардно ће бити укључени у резервне копије.';
$string['configgeneralpermissions'] = 'Ако је ова опција омогућена, овлашћењ за улогу биће импортоване. Ово може заменити постојећа овлашћења за уписане кориснике.';
$string['configgeneralquestionbank'] = 'Ако омогућите ову опцију, банка питања биће стандардно укључена у резервне копије. НАПОМЕНА: Искључиваање овог подешавања онемогућиће креирање резервне копије оних активности које користе банку питања, као што је то тест.';
$string['configgeneralroleassignments'] = 'Ако је омогућено доделе улога биће, такође, укључене у резервне копије.';
$string['configgeneralusers'] = 'Поставља подразумевану вредност за укључивање корисника у резервну копију.';
$string['configgeneraluserscompletion'] = 'Ако је ова опција омогућена, онда ће информације о томе у којој мери су полазници завршили поједине активности, стандардно бити укључене у резервну копију';
$string['configgeneralxapistate'] = 'Подешава као подразумевану вредност укључивање  у резервној копији статуса корисника у садржајима као што су H5P активности.';
$string['configlegacyfiles'] = 'Поставља, као подразумевано, укључивање наслеђених датотека курса у резервну копију. Наслеђене датотеке курса су из старијих верзија Moodela (пре верзије 2.0).';
$string['configloglifetime'] = 'Ово подешавање одређује колико дуго желите да чувате информације о записима насталим током креирања резервних копија курсева. Записи који су старији биће аутоматски обрисани. Препоручује се да овај временски интервал буде кратак јер наведених информација може бити веома много.';
$string['configrestoreactivities'] = 'Поставља подразумевану вредност за рестаурирање активности.';
$string['configrestorebadges'] = 'Поставља подразумевану вредност за рестаурирање беџева.';
$string['configrestoreblocks'] = 'Поставља подразумевану вредност за рестаурирање блокова.';
$string['configrestorecalendarevents'] = 'Поставља подразумевану вредност за рестаурирање догађаја у календару.';
$string['configrestorecomments'] = 'Поставља подразумевану вредност за рестаурирање коментара.';
$string['configrestorecompetencies'] = 'Поставља подразумевану вредност за рестаурирање компетенција.';
$string['configrestorecontentbankcontent'] = 'Подешава подразумеване вредности за рестаурирање садржаја банке садржаја.';
$string['configrestorecustomfield'] = 'Подешава подразумевану вредност за рестаурирање прилагођених поља.';
$string['configrestoreenrolments'] = 'Поставља подразумевану вредност за рестаурирање метода уписа.';
$string['configrestorefilters'] = 'Поставља подразумевану вредност за рестаурирање филтера.';
$string['configrestoregroups'] = 'Поставља подразумевану вредност за рестаурирање група и груписања ако су укључени у резервну копију.';
$string['configrestorehistories'] = 'Поставља подразумевану вредност за рестаурирање историје корисника ако је укључена у резервну копију.';
$string['configrestorelogs'] = 'Ако је ова опција омогућена, записи ће стандардно бити рестаурисани уколико су укључени у резервну копију.';
$string['configrestorepermissions'] = 'Ако је ова опција омогућена, овлашћења за улогу биће рестауриране. Ово може заменити постојећа овлашћења за уписане кориснике.';
$string['configrestoreroleassignments'] = 'Ако је ова опција омогућена, доделе улога ће стандардно бити рестаурисане уколико су укључене у резервну копију.';
$string['configrestoreusers'] = 'Поставља подразумевану вредност за рестаурирање корисника ако су укључени у резервну копију.';
$string['configrestoreuserscompletion'] = 'Ако је ова опција омогућена, информације о завршетку ће стандардно бити рестаурисане уколико су укључене у резервну копију.';
$string['configrestorexapistate'] = 'Подешава као подразумевану вредност рестаурирање статуса корисника у садржајима као што су H5P активности.';
$string['confirmcancel'] = 'Откажи креирање резервне копије';
$string['confirmcancelimport'] = 'Откажи увоз';
$string['confirmcancelno'] = 'Не отказуј';
$string['confirmcancelquestion'] = 'Да ли сте сигурни да желите да одустанете? Све информације које сте унели биће изгубљене.';
$string['confirmcancelrestore'] = 'Откажи рестаурирање';
$string['confirmcancelyes'] = 'Откажи резервну копију';
$string['confirmnewcoursecontinue'] = 'Упозорење о новом курсу';
$string['confirmnewcoursecontinuequestion'] = 'Процедура за рестаурацију курса ће креирати привремени (сакривени) курс. Да бисте прекинули процедуру кликните на \'Откажи\'. Немојте затварати веб читач док је рестаурација у току.';
$string['copiesinprogress'] = 'Процедура копирања овог курса је у току. <a href="{$a}">Погледајте процедуре копирања које су у току.</a>';
$string['copycoursedesc'] = 'Креирајте копију овог курса у било којој категорији курсева.';
$string['copycourseheading'] = 'Копирај курс';
$string['copycoursetitle'] = 'Копирање курса: {$a}';
$string['copydest'] = 'Одредиште';
$string['copyfieldnotfound'] = 'Потребни подаци поља нису пронађени за поље/а: {$a}';
$string['copyformfail'] = 'AJAX образац за предају копије курса није успео.';
$string['copyingcourse'] = 'У току је копирање курса';
$string['copyingcourseshortname'] = 'копирање';
$string['copyop'] = 'Текуће операције';
$string['copyprogressheading'] = 'Копије курсева у току';
$string['copyprogressheading_help'] = 'Ова табела приказује статус свих ваших недовршених копија курсева.';
$string['copyprogresstitle'] = 'Напредак копије курса';
$string['copyreturn'] = 'Копирај и врати се назад';
$string['copysource'] = 'Извор';
$string['copyview'] = 'Копирај и прегледај';
$string['coursecategory'] = 'Категорија у коју ће курс бити рестауриран';
$string['courseid'] = 'Оригинални ID';
$string['coursesettings'] = 'Подешавања курса';
$string['coursetitle'] = 'Наслов';
$string['currentstage1'] = 'Почетна подешавања';
$string['currentstage16'] = 'Завршено';
$string['currentstage2'] = 'Подешавања шеме';
$string['currentstage4'] = 'Потврда и преглед';
$string['currentstage8'] = 'Креирај резервну копију';
$string['enableasyncbackup'] = 'Омогућите асинхроно креирање резервних копија';
$string['enableasyncbackup_help'] = 'Ако је ова опција омогућена, операције креирања и рестаурирања резервних копија биће извршене асинхроно. Асинхрона креирања и рестаурирања резервних копија омогућавају корисницима да обављају друге операције док су креирање и рестаурирање у току. Ово не утиче на увозе и извозе.';
$string['enterasearch'] = 'Унесите појам за претраживање';
$string['error_block_for_module_not_found'] = 'Пронађена је напуштена инстанца блока (id: {$a}). Резервна копија овог блока неће бити креирана.';
$string['error_course_module_not_found'] = 'Пронађен је напуштен модул курса (id: {$a}). Резервна копија овог модула неће бити креирана.';
$string['error_delegate_section_not_found'] = 'Недостаје секција на модулу курса (са ID ознаком {$a}). Неће бити креирана резервна копија секције.';
$string['errorcopyingbackupfile'] = 'Покушај копирања датотеке резервне копије у привремени директоријум није успео, пре рестауриања.';
$string['errorfilenamemustbezip'] = 'Назив датотеке мора бити ZIP архива и имати mbz екстензију';
$string['errorfilenamerequired'] = 'Морате унети исправан назив датотеке за ову резервну копију';
$string['errorfilenametoolong'] = 'Дужина назива датотеке мора да буде мања од 255 знакова';
$string['errorinvalidformat'] = 'Непознат формат резервне копије';
$string['errorinvalidformatinfo'] = 'Изабрана датотека није исправна Moodle датотека резервне копије и не може бити рестаурирана.';
$string['errorminbackup20version'] = 'Ова датотека резервне копије је креирана помоћу развојне верзије Moodle функције за креирање резервне копије ({$a->backup}). Минималана захтевана верзија је {$a->min}. Ова резервна копија не може бити рестаурирана.';
$string['errorrestorefrontpagebackup'] = 'Резервне копије насловне странице можете рестаурирати само на насловној страници сајта';
$string['executionsuccess'] = 'Датотека резервне копије је успешно креирана';
$string['extractingbackupfileto'] = 'Издвајање датотеке резервне копије у: {$a}';
$string['failed'] = 'Креирање резервне копије није успело';
$string['filealiasesrestorefailures'] = 'Неуспешна рестаурирања алијаса';
$string['filealiasesrestorefailures_help'] = 'Алијаси су симболички линкови ка другим датотекама, укључујући оне које су ускладиштене у екстерним репозиторијумима. У неким случајевима Моodle не може да рестаурира алијасе - на пример, када рестаурира резервну копију на другом сајту или када датотека на коју се референцира не постоји.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Неки алијаси укључени у датотеку резервне копије не могу да се рестаурирају. Следећи списак садржи њихове очекиване локације, као и изворну датотеку на коју алијаси референцирају на оригиналном сајту.';
$string['filename'] = 'Назив датотеке';
$string['filereferencesincluded'] = 'Референцe датотека ка спољашњим садржајима укључене су у резервну копију. Ово неће функционисати ако се резервна копија рестауирише на неком другом сајту.';
$string['filereferencesnotsamesite'] = 'Датотека резервна копије је са другог сајта, тако да референце датотека не могу да се рестауришу.';
$string['filereferencessamesite'] = 'Датотека резервна копије је са овог сајта, тако да референце датотека могу да се рестауришу.';
$string['generalactivities'] = 'Укључи активности и ресурсе';
$string['generalanonymize'] = 'Сакривање информација';
$string['generalbackdefaults'] = 'Општа подразумевана подешавања за креирање резервних копија';
$string['generalbadges'] = 'Укључи беџеве';
$string['generalblocks'] = 'Укључи блокове';
$string['generalcalendarevents'] = 'Укључи догађаје из календара';
$string['generalcomments'] = 'Укључи коментаре';
$string['generalcompetencies'] = 'Укључи компетенције';
$string['generalcontentbankcontent'] = 'Укључи садржај банке садржаја';
$string['generalcustomfield'] = 'Укључите прилагођена поља';
$string['generalenrolments'] = 'Укључи методе уписа';
$string['generalfiles'] = 'Укључи датотеке';
$string['generalfilters'] = 'Укључи филтере';
$string['generalgradehistories'] = 'Укључи историје оцена';
$string['generalgroups'] = 'Укључи групе и груписања';
$string['generalhistories'] = 'Укључи историје';
$string['generallegacyfiles'] = 'Укључи старе наслеђене датотеке курса';
$string['generallogs'] = 'Укључи записе о активностима';
$string['generalpermissions'] = 'Укључи измене овлашћења';
$string['generalquestionbank'] = 'Укључи банку питања';
$string['generalrestoredefaults'] = 'Општа подразумевана подешавања за рестаурирање';
$string['generalrestoresettings'] = 'Општа подешавања за рестаурирање';
$string['generalroleassignments'] = 'Укључи додељене улоге';
$string['generalsettings'] = 'Општа подешавања везана за креирање резервних копија';
$string['generalusers'] = 'Укључи кориснике';
$string['generaluserscompletion'] = 'Укључи корисничке информације о завршетку активности';
$string['generalxapistate'] = 'Укључи статусе корисника у садржајима као што су H5P активности.';
$string['hidetypes'] = 'Сакриј опције типа';
$string['importbackupstage16action'] = 'Настави';
$string['importbackupstage1action'] = 'Следеће';
$string['importbackupstage2action'] = 'Следеће';
$string['importbackupstage4action'] = 'Увези';
$string['importbackupstage8action'] = 'Настави';
$string['importcurrentstage0'] = 'Избор курса';
$string['importcurrentstage1'] = 'Почетна подешавања';
$string['importcurrentstage16'] = 'Завршено';
$string['importcurrentstage2'] = 'Подешавања шеме';
$string['importcurrentstage4'] = 'Потврда и преглед';
$string['importcurrentstage8'] = 'Увези';
$string['importfile'] = 'Отпремите датотеку резервне копије';
$string['importfromccmidtocourse'] = 'Увоз из cmid:{$a->srccmid}  у курс:{$a->dstcourseid}';
$string['importfromcoursetocourse'] = 'Увоз из курса:{$a->srccourseid} у курс:{$a->dstcourseid}';
$string['importgeneralduplicateadminallowed'] = 'Дозволи решавање административног конфликта';
$string['importgeneralduplicateadminallowed_desc'] = 'Ако на сајту постоји налог са корисничким именом \'admin\', покушај рестаурације резервне копије која садржи налог са корисничким именом \'admin\' може проузроковати конфликт. Ако је ово подешавање активирано, конфликт ће бити решен променом корисничког имена у резервној копији на \'admin_xyz\'.';
$string['importgeneralmaxresults'] = 'Максималан број курсева наведених за увоз';
$string['importgeneralmaxresults_desc'] = 'Ова опција контролише број курсева који су наведени током првог корака у процесу увоза';
$string['importgeneralsettings'] = 'Опште подразумевана подешавања увоза';
$string['importrootsettings'] = 'Подешавања увоза';
$string['importsettings'] = 'Општа подешавања увоза';
$string['importsuccess'] = 'Увоз је завршен. Кликни на \'Настави\' за повратак на курс.';
$string['includeactivities'] = 'Укључи';
$string['includeditems'] = 'Укључене ставке';
$string['includefilereferences'] = 'Референцe датотека ка спољашњим датотекама';
$string['includesection'] = 'Секција {$a}';
$string['includeuserinfo'] = 'Укључи корисничке информације';
$string['includeuserinfo_instance'] = 'Укључите корисничке податке {$a} корисника';
$string['inprogress'] = 'Креирање резервне копије у току';
$string['jumptofinalstep'] = 'Иди на завршни корак';
$string['keep'] = 'Задржи';
$string['keptroles'] = 'Укључи уписе улога';
$string['keptroles_help'] = 'Корисници са изабраним улогама биће уписани у нови курс. Ниједан кориснички податак неће се копирати ако није омогућено \'Укључи корисничке податке\'.';
$string['locked'] = 'Закључано';
$string['lockedbyconfig'] = 'Ово подешавање је закључано подразумеваним подешавањима за креирање резервне копије';
$string['lockedbyhierarchy'] = 'Закључано од стране зависних елемената';
$string['lockedbypermission'] = 'Немате довољна овлашћења за промену овог подешавања';
$string['loglifetime'] = 'Чувај записе';
$string['managefiles'] = 'Управљање резервним копијама';
$string['managefiles_activity'] = 'Управљање резервним копијама активности';
$string['managefiles_automated'] = 'Управљање аутоматски креираним резервним копијама';
$string['managefiles_backup'] = 'Управљање приватним резервним копијама';
$string['managefiles_course'] = 'Управљање резервним копијама курсева';
$string['mergerestoredefaults'] = 'Рестаурирај подразумевана подешавања приликом спајања са другим курсом';
$string['missingfilesinpool'] = 'Неке датотеке нису могле бити сачувана током креирања резервне копије, тако да рестаурација тих датотека неће бити могућа.';
$string['module'] = 'Модул';
$string['moodleversion'] = 'Верзија Moodleа';
$string['morecoursesearchresults'] = 'Пронађено је више од {$a} курса/ева, приказује се прва/их {$a} резултата';
$string['moreresults'] = 'Превише резултата, унесите прецизније појмове за претрагу.';
$string['nomatchingcourses'] = 'Нема курсева за приказ';
$string['norestoreoptions'] = 'Нема категорија или постојећих курсева у које се могу ресаурирати резервне копије';
$string['originalwwwroot'] = 'URL адреса резервне копије';
$string['overwrite'] = 'Измени';
$string['pendingasyncdeletedetail'] = 'Овај курс има асинхроно креирање резервне копије на чекању. <br/> Курсеви не могу бити обрисани док се ово креирање резервне копије не заврши.';
$string['pendingasyncdetail'] = 'Асинхроно креирање резервних копија омогућава кориснику да у исто време има само једно креирање резервне копије ресурса на чекању. <br/> На чекању не може бити више асинхроних креирања резервних копија истог ресурса, јер би то вероватно резултирало вишеструким резервним копијама са истим садржајем.';
$string['pendingasyncedit'] = 'За овај курс је затражена резервна копија или копија на чекању. Молимо вас да не уређујете курс док се ово не заврши.';
$string['pendingasyncerror'] = 'Резервна копија за овај ресурс на чекању';
$string['preparingdata'] = 'Припрема података';
$string['preparingui'] = 'Припрема за приказивање странице';
$string['previousstage'] = 'Претходно';
$string['privacy:metadata:backup:detailsofarchive'] = 'Ова архива може да садржи различите корисничке податке везане за курс, као што су оцене, уписи и записи о активностима.';
$string['privacy:metadata:backup:externalpurpose'] = 'Сврха ове архиве је да чува информације везане за курс, које могу бити рестауриране у будућности.';
$string['privacy:metadata:backup_controllers'] = 'Списак операција за креирање резервних копија';
$string['privacy:metadata:backup_controllers:itemid'] = 'Идентификатор курса';
$string['privacy:metadata:backup_controllers:operation'] = 'Операција која је извршена, нпр. рестаурација.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Време када је креирана акција';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Време када је измењена акција';
$string['privacy:metadata:backup_controllers:type'] = 'Тип ставке с којом се ради, нпр. активност.';
$string['qcategory2coursefallback'] = 'Категорија питања "{$a->name}", изворно смештена у контекст система/категорије курса у датотеци резервне копије, биће креирана у контексту курса током рестаурације';
$string['qcategorycannotberestored'] = 'Категорија питања "{$a->name}" не може бити креирана током рестаурације резервне копије';
$string['question2coursefallback'] = 'Kатегорија питања "{$a->name}", изворно смештена у контекст система/категорије курса у датотеци резервне копије, биће креирана у контексту курса, током рестаурације';
$string['questioncannotberestored'] = 'Питања "{$a->name}" не могу бити креирана током рестаурације';
$string['recyclebin_desc'] = 'Имајте на уму да ће ова подешавања бити коришћена и за корпу за отпатке.';
$string['replacerestoredefaults'] = 'Рестаурирај подразумевана подешавања приликом рестаурирања у други курс и брисања његовог садржаја';
$string['restoreactivity'] = 'Рестаурирај активност';
$string['restorecourse'] = 'Рестаурирај курс';
$string['restorecoursesettings'] = 'Подешавања курса';
$string['restoredcourseid'] = 'ID ознака рестаурираног курса: {$a}';
$string['restoreexecutionsuccess'] = 'Курс је успешно рестауриран.';
$string['restorefileweremissing'] = 'Неке датотеке се не могу рестаурисати зато што су недостајале у резервној копији.';
$string['restorenewcoursefullname'] = 'Нови назив курса';
$string['restorenewcourseshortname'] = 'Нови скраћени назив курса';
$string['restorenewcoursestartdate'] = 'Нови датум почетка курса';
$string['restorenofilesbackuparea'] = 'Још увек нема датотека резервних копија.';
$string['restorenofilesbackuparea_activity'] = 'Још увек нема датотека резервних копија за ову активност.';
$string['restorenofilesbackuparea_automated'] = 'Још увек нема аутоматски креираних датотека резервних копија.';
$string['restorenofilesbackuparea_backup'] = 'Још увек немате приватне датотеке резервних копија';
$string['restorenofilesbackuparea_course'] = 'Још увек нема датотека резервних копија за овај курс.';
$string['restorerolemappings'] = 'Одреди улоге';
$string['restorerootsettings'] = 'Подешавања за рестаурирање';
$string['restoresection'] = 'Рестаурирај секцију';
$string['restorestage1'] = 'Потврди';
$string['restorestage16'] = 'Преглед';
$string['restorestage16action'] = 'Покрени рестаурирање';
$string['restorestage1action'] = 'Следеће';
$string['restorestage2'] = 'Одредиште';
$string['restorestage2action'] = 'Следеће';
$string['restorestage32'] = 'Процес';
$string['restorestage32action'] = 'Настави';
$string['restorestage4'] = 'Подешавања';
$string['restorestage4action'] = 'Следеће';
$string['restorestage64'] = 'Завршено';
$string['restorestage64action'] = 'Настави';
$string['restorestage8'] = 'Шема';
$string['restorestage8action'] = 'Следеће';
$string['restoretarget'] = 'Рестаурирај одредишни курс';
$string['restoretocourse'] = 'Рестаурирај у курс';
$string['restoretocurrentcourse'] = 'Рестаурирај у овај курс';
$string['restoretocurrentcourseadding'] = 'Додај резервну копију курса у овај курс';
$string['restoretocurrentcoursedeleting'] = 'Обриши садржај овог курса а онда рестаурирај резервну копију';
$string['restoretoexistingcourse'] = 'Рестаурирај у постојећи курс';
$string['restoretoexistingcourseadding'] = 'Додај резервну копију курса у постојећи курс';
$string['restoretoexistingcoursedeleting'] = 'Обриши садржај постојећег курса и потом рестаурирај резервну копију';
$string['restoretonewcourse'] = 'Рестаурирај као нови курс';
$string['restoringcourse'] = 'Рестаурирање курса у току';
$string['restoringcourseshortname'] = 'рестаурирање';
$string['rootenrolmanual'] = 'Рестаурирај као ручне уписе';
$string['rootsettingactivities'] = 'Укључи активности и ресурсе';
$string['rootsettinganonymize'] = 'Сакриј  корисничке информације';
$string['rootsettingbadges'] = 'Укључи беџеве';
$string['rootsettingblocks'] = 'Укључи блокове';
$string['rootsettingcalendarevents'] = 'Укључи догађаје из календара';
$string['rootsettingcomments'] = 'Укључи коментаре';
$string['rootsettingcompetencies'] = 'Укључи компетенције';
$string['rootsettingcontentbankcontent'] = 'Укључи садржај банке садржаја';
$string['rootsettingcustomfield'] = 'Укључи прилагођена поља';
$string['rootsettingenrolments'] = 'Укључи методе уписа';
$string['rootsettingenrolments_always'] = 'Да, увек';
$string['rootsettingenrolments_never'] = 'Не, рестаурирај кориснике као ручно уписане';
$string['rootsettingenrolments_withusers'] = 'Да, али само ако су корисници укључени';
$string['rootsettingfiles'] = 'Укључи датотеке';
$string['rootsettingfilters'] = 'Укључи филтере';
$string['rootsettinggradehistories'] = 'Укључи историју оцена';
$string['rootsettinggroups'] = 'Укључи групе и груписања';
$string['rootsettingimscc1'] = 'Конвертуј у IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Конвертуј у IMS Common Cartridge 1.1';
$string['rootsettinglegacyfiles'] = 'Укључи старе наслеђене датотеке курса';
$string['rootsettinglogs'] = 'Укључи записе о активностима на курсу';
$string['rootsettingpermissions'] = 'Укључи измене овлашћења';
$string['rootsettingquestionbank'] = 'Укључи банку питања';
$string['rootsettingroleassignments'] = 'Укључи додељене корисничке улоге';
$string['rootsettings'] = 'Подешавања креирања резервне копије';
$string['rootsettingusers'] = 'Укључи уписане кориснике';
$string['rootsettinguserscompletion'] = 'Укључи корисничке детаље о завршетку активности';
$string['rootsettingxapistate'] = 'Укључи статусе корисника у садржајима као што су H5P активности.';
$string['samesitenotification'] = 'Ова резервна копија је креирана само са референцама на датотеке, не са самим датотекама. Рестаурација ће радити само на овом сајту.';
$string['section_prefix'] = 'Секција {$a}:';
$string['sectionactivities'] = 'Активности';
$string['sectioninc'] = 'Укључено у резервну копију (без корисничких информација)';
$string['sectionincanduser'] = 'Укључено у резервну копију заједно са корисничким информацијама';
$string['selectacategory'] = 'Изабери категорију';
$string['selectacourse'] = 'Одабери курс';
$string['setting_course_fullname'] = 'Назив курса';
$string['setting_course_shortname'] = 'Скраћени назив курса';
$string['setting_course_startdate'] = 'Датум почетка курса';
$string['setting_keep_groups_and_groupings'] = 'Задржи текуће групе и груписања';
$string['setting_keep_roles_and_enrolments'] = 'Задржи текуће улоге и уписе';
$string['setting_overwrite_conf'] = 'Измени конфигурацију курса';
$string['setting_overwrite_course_fullname'] = 'Измени пун назив курса';
$string['setting_overwrite_course_shortname'] = 'Измени скраћени назив курса';
$string['setting_overwrite_course_startdate'] = 'Измени датум почетка курса';
$string['showtypes'] = 'Прикажи опције типа';
$string['sitecourseformatwarning'] = 'Ово је резервна копија насловне странице. Она се може рестаурирати само на насловној страници сајта.';
$string['skiphidden'] = 'Прескочи скривене курсеве';
$string['skiphiddenhelp'] = 'Изаберите да ли да прескочите или не скривене курсеве';
$string['skipmodifdays'] = 'Прескочи курсеве који нису промењени';
$string['skipmodifdayshelp'] = 'Изаберите да ли да прескочите курсеве који нису мењани наведени број дана';
$string['skipmodifprev'] = 'Прескочи курсеве који нису промењени од претходног креирања резервне копије';
$string['skipmodifprevhelp'] = 'Изаберите да ли да прескочите или не курсеве који нису мењани од последњег креирања резервне копије. То захтева укључену опцију за креирање записа о коришћењу платформе.';
$string['status'] = 'Статус';
$string['storagecourseandexternal'] = 'Простор за датотеке курса намењен резервним копијама и наведени директоријум';
$string['storagecourseonly'] = 'Простор за датотеке курса намењен резервним копијама';
$string['storageexternalonly'] = 'Наведени директоријум за аутоматски креиране резервне копије';
$string['subsectioncontent'] = 'Садржај подсекције';
$string['successful'] = 'Резервна копија успешно креирана';
$string['successfulcopy'] = 'Копирање је успешно завршено';
$string['successfulrestore'] = 'Резервна копија успешно рестаурирана';
$string['timetaken'] = 'Утрошено време';
$string['title'] = 'Наслов';
$string['totalcategorysearchresults'] = 'Укупно категорија: {$a}';
$string['totalcoursesearchresults'] = 'Укупно курсева: {$a}';
$string['undefinedrolemapping'] = 'Мапирање улога није дефинисано за архетип \'{$a}\'';
$string['unnamedsection'] = 'Неименована секција';
$string['userdata'] = 'Укључи корисничке податке';
$string['userdata_help'] = 'Ако је ова опција омогућена, подаци као што су постови на форуму, предати задаци итд. биће копирани у нови курс за све учеснике који имају улогу изабрану у \'Укључи уписе улога\'';
$string['userinfo'] = 'Информације о кориснику';
