<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'sr_cr', version '4.5'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Акција';
$string['actionsmenu'] = 'Мени акција';
$string['add'] = 'Додај унос';
$string['addcomment'] = 'Додај коментар';
$string['addtemplate'] = 'Шаблон за додавање уноса';
$string['advancedsearch'] = 'Напредно претрага';
$string['allowcomments'] = 'Дозволитe коментарисање уноса';
$string['alttext'] = 'Алтернативни текст';
$string['approvalstatus'] = 'Статус одобрења';
$string['approve'] = 'Одобри';
$string['approved'] = 'Одобрено';
$string['areacontent'] = 'Поља';
$string['ascending'] = 'Растуће';
$string['asearchtemplate'] = 'Шаблон за напредно претраживање';
$string['atmaxentry'] = 'Унели сте максималан дозвољени број уноса!';
$string['authorfirstname'] = 'Име аутора';
$string['authorlastname'] = 'Презиме аутора';
$string['autogenallforms'] = 'Генерисање свих подразумеваних шаблона';
$string['autolinkurl'] = 'Аутоматско линковање URL-a';
$string['availablefromdate'] = 'Доступно од';
$string['availabletags'] = 'Доступне ознаке';
$string['availabletags_help'] = 'Ознаке су резервисана места у шаблону која ће бити замењена подацима или другим ставкама, као што је нпр. иконица за уређивање, када се уређује или приказује унос.

Поља имају формат [[fieldname]]. Све друге ознаке имају формат ##sometag##.

Само ознаке које су на списку  "Доступне ознаке" могу се користити за текући шаблон.';
$string['availabletodate'] = 'Доступно до';
$string['availabletodatevalidation'] = 'Датум \'доступно до\' не може бити пре датума  \'доступно од\'.';
$string['bynameondate'] = 'унео/ла {$a->name} дана {$a->date}';
$string['calendarend'] = '{$a} се затвара';
$string['calendarstart'] = '{$a} се отвара';
$string['cancel'] = 'Откажи';
$string['cannotaccesspresentsother'] = 'Није вам дозвољен приступ предефинсаним шаблонима базе података других корисника';
$string['cannotadd'] = 'Не могу се додати уноси!';
$string['cannotapplypreset'] = 'Грешка приликом примене предефинисаног шаблона базе података.';
$string['cannotdeletepreset'] = 'Грешка приликом брисања предефинисаног шаблона базе података';
$string['cannotoverwritepreset'] = 'Грешка приликом преписивања предефинисаног шаблона базе података';
$string['cannotunziptopreset'] = 'Није могуће распаковати у директоријум предефинисаног шаблона базе података';
$string['checkbox'] = 'Поља за потврду';
$string['chooseexportfields'] = 'Изаберите поља која желите да извезете';
$string['chooseexportformat'] = 'Изаберите формат у који желите да извезете';
$string['chooseorupload'] = 'Одабери датотеку';
$string['choosepreset'] = 'Датотека предефинисаног шаблона базе података';
$string['closebeforeopen'] = 'Навели сте датум завршетка пре датума почетка.';
$string['columns'] = 'колоне';
$string['comment'] = 'Коментар';
$string['commentdeleted'] = 'Коментар је обрисан';
$string['commentempty'] = 'Коментар је био празан';
$string['comments'] = 'Коментари';
$string['commentsaved'] = 'Коментар је сачуван';
$string['commentsn'] = '{$a} коментар(а)';
$string['commentsoff'] = 'Коментарисање није дозвољено';
$string['completiondetail:entries'] = 'Креирајте уносе у базу: {$a}';
$string['completionentries'] = 'Захтевај уносе';
$string['completionentriescount'] = 'Додају уносе';
$string['completionentriesdesc'] = 'Најмањи број потребних уноса: {$a}';
$string['configenablerssfeeds'] = 'Овај прекидач ће омогућити коришћење RSS сервиса за све базе података. Ипак, мораћете ручно да укључите RSS подршку у подешавањима за сваку базу података посебно.';
$string['confirmdeletefield'] = 'Управо ћете обрисати ово поље. Да ли сте сигурни да то желите?';
$string['confirmdeleterecord'] = 'Да ли сте сигурни да желите да обришете овај унос?';
$string['confirmdeleterecords'] = 'Да ли сте сигурни да желите да обришете ове уносе?';
$string['createactivity'] = 'Креирајте сопствена поља за прикупљање података или користите предефинисани шаблон базе податаке која већ укључује поља.';
$string['createfields'] = 'Креирајте поља за прикупљање различитих типова података.';
$string['createtemplates'] = 'Шаблони дефинишу интерфејс ваше активности. Када креирате поља, шаблони ће се бити креирани аутоматски. Алтернативно, можете користити предефинисани шаблон базе података, које укључује поља и шаблоне.';
$string['csstemplate'] = 'Прилагођени CSS';
$string['csvfailed'] = 'Није могуће прочитати необрађене податке из CSV датотеке';
$string['csvfile'] = 'CSV датотека или ZIP архива која садржи CSV датотеку';
$string['csvimport'] = 'Увоз CSV датотеке';
$string['csvimport_help'] = 'Уноси могу бити увезени путем обичне текстуалне датотеке код које се у првој линији налази списак назива поља, раздвојених зарезом, а затим следе подаци, тако што се у сваку линију смешта по један запис.';
$string['csvwithselecteddelimiter'] = '<abbr title="Comma Separated Values">CSV</abbr>';
$string['data:addinstance'] = 'Додавање нове базе';
$string['data:approve'] = 'Одобравање и поништавање одобрених уноса';
$string['data:comment'] = 'Писање коментара';
$string['data:exportallentries'] = 'Извоз свих уноса из базе података';
$string['data:exportentry'] = 'Извоз уноса из базе података';
$string['data:exportownentry'] = 'Извоз сопствених уноса из базе података';
$string['data:exportuserinfo'] = 'Извоз корисничких информација';
$string['data:managecomments'] = 'Управљање коментарима';
$string['data:manageentries'] = 'Управљање уносима';
$string['data:managetemplates'] = 'Управљање шаблонима';
$string['data:manageuserpresets'] = 'Управљање предефинисаним шаблонима базе података';
$string['data:rate'] = 'Оцењивање уноса';
$string['data:readentry'] = 'Читање уноса';
$string['data:view'] = 'Преглед активности базе података';
$string['data:viewallratings'] = 'Преглед свих необрађених оцена које су дате од стране појединаца';
$string['data:viewalluserpresets'] = 'Преглед предефинисаних шаблоне база података свих корисника';
$string['data:viewanyrating'] = 'Преглед укупних оцена које је неко добио';
$string['data:viewentry'] = 'Преглед уноса';
$string['data:viewrating'] = 'Преглед укупне оцене коју сте добили';
$string['data:writeentry'] = 'Уписивање уноса';
$string['date'] = 'Датум';
$string['dateentered'] = 'Датум уноса';
$string['datemodified'] = 'Последњи пут уређено:';
$string['defaultfielddelimiter'] = '(подразумевани знак је зарез)';
$string['defaultfieldenclosure'] = '(подразумевано је ништа)';
$string['defaultsortfield'] = 'Подразумевано сортирање поља';
$string['delcheck'] = 'Поље за потврду масовног брисања';
$string['delete'] = 'Oбриши';
$string['deleteallentries'] = 'Све уноси';
$string['deletecomment'] = 'Да ли сте сигурни да желите да обришете овај коментар?';
$string['deleteconfirm'] = 'Обриши предефинисани шаблон базе података {$a}?';
$string['deleted'] = 'обрисано';
$string['deleteentry'] = 'Обриши унос';
$string['deletefield'] = 'Обриши поље';
$string['deletenotenrolled'] = 'Уноси корисника који нису уписани';
$string['deletewarning'] = 'Брисањем предефинисаног шаблона базе података уклањате га са списка доступних шаблона на свим курсевима.';
$string['descending'] = 'Опадајуће';
$string['directorynotapreset'] = '{$a->directory} није предефинисани шаблон базе података: недостају следеће датотеке:
{$a->missing_files}';
$string['disapprove'] = 'Опозови одобрење';
$string['download'] = 'Преузми';
$string['edit'] = 'Уреди';
$string['editcomment'] = 'Уреди коментар';
$string['editentry'] = 'Уреди унос';
$string['editfield'] = 'Уреди поље';
$string['editordisable'] = 'Онемогући уређивање';
$string['editorenable'] = 'Омогући уређивач кôда';
$string['editpreset'] = 'Уреди предефинисани шаблон базе података';
$string['emptyadd'] = 'Додавање шаблона је празно, генерише се подразумевана форма...';
$string['emptyaddform'] = 'Нисте испунили ниједно поље!';
$string['emptypresetname'] = 'Назив предефинисаног шаблона базе података или датотека не могу бити празни';
$string['enabletemplateeditorcheck'] = 'Да ли сте сигурни да желите да омогућите уређивање? То може довести до тога да се садржај промени када се шаблон сачува.';
$string['entries'] = 'Уноси';
$string['entrieslefttoadd'] = 'Морате да додате још {$a->entriesleft} унос(а) како бисте завршили ову активност.';
$string['entrieslefttoaddtoview'] = 'Морате да додате још {$a->entrieslefttoview} уноса пре него што будете могли да видите уносе других корисника.';
$string['entry'] = 'Унос';
$string['entrysaved'] = 'Ваш унос је сачуван';
$string['errordatafilenotfound'] = 'Датотеку није било могуће импротвати. Прихваћени типови датотека су CSV или ZIP који садржи CSV датотеку у формату који се користи за извоз уноса.';
$string['errormustbeteacher'] = 'Морате бити предавач да бисте користили ову страницу!';
$string['errormustsupplyvalue'] = 'Морате овде задати вредност.';
$string['errorpresetexists'] = 'Већ постоји предефинисани шаблон базе податка са тим називом.';
$string['errorpresetexistsbutnotoverwrite'] = 'Већ постоји предефинисани шаблон базе податка са тим називом. Изберете други назив.';
$string['errorpresetnotfound'] = 'Предефинисани шаблон базе података са називом {$a} није пронађен';
$string['eventfieldcreated'] = 'Поље креирано';
$string['eventfielddeleted'] = 'Поље обрисано';
$string['eventfieldupdated'] = 'Поље ажурирано';
$string['eventrecordcreated'] = 'Запис у бази креиран';
$string['eventrecorddeleted'] = 'Запис у бази обрисан';
$string['eventrecordupdated'] = 'Запис у бази ажуриран';
$string['eventtemplateupdated'] = 'Шаблон ажуриран';
$string['eventtemplateviewed'] = 'Шаблони приказани';
$string['example'] = 'Пример модула \'База података\'';
$string['excel'] = 'Excel';
$string['expired'] = 'Нажалост, ова активност је затворена {$} и више није доступна';
$string['export'] = 'Извези';
$string['exportaszip'] = 'Извези као ZIP архиву';
$string['exportaszip_help'] = 'Опција \'Извези као ZIP датотеку\' вам дозвољава да сачувате предефинисане шаблоне базе података као ZIP датотеку коју можете преузети. Након тога, ZIP датотека може бити увезена у неки други курс.';
$string['exportedtozip'] = 'Извезено у привремену ZIP архиву...';
$string['exportentries'] = 'Извоз уноса';
$string['exportformat'] = 'Извези форум';
$string['exportoptions'] = 'Опције за извоз';
$string['exportownentries'] = 'Извезите само своје уносе? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Извези предефинисани шаблон базе података';
$string['failedpresetdelete'] = 'Дошло је до грешке приликом покушаја брисања предефинисаног шаблона базе података.';
$string['fieldadded'] = 'Поље је додато';
$string['fieldallowautolink'] = 'Дозволити аутоматско линковање';
$string['fielddeleted'] = 'Поље је обрисано';
$string['fielddelimiter'] = 'Знак за раздвајање поља';
$string['fielddescription'] = 'Опис поља';
$string['fieldenclosure'] = 'Прилагање поља';
$string['fieldheight'] = 'Висина';
$string['fieldheightlistview'] = 'Висина (у пикселима) у приказу списка';
$string['fieldheightsingleview'] = 'Висина (у пикселима) у појединачном приказу';
$string['fieldids'] = 'Идентификатори поља';
$string['fieldmappings'] = 'Мапирање поља';
$string['fieldmappings_help'] = 'Овај мени вам дозвољава да сачувате податке из постојеће базе података. Да бисте сачували податке у неком пољу, морате га мапирати на ново поља, где ће се подаци појавити. Било које поље може да остане празно, без икаквих података у њему. Свако старо поље које није мапирано на ново, биће изгубљено, а сви његови подаци уклоњени.
Можете само да мапирате поља истог типа, тако да ће сваки падајући мени имати различита поља. Такође, морате да пазите да не покушате да мапирате једно старо на више од једног новог поља.';
$string['fieldname'] = 'Назив поља';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Следећа поља у Вашој датотеци су непозната у овој бази података: {$a}';
$string['fieldoptions'] = 'Опције (једна по линији)';
$string['fields'] = 'Поља';
$string['fieldshelp'] = 'Креирајте поља за прикупљање различитих типова података. Поља одређују структуру уноса у вашу базу података.';
$string['fieldsinformationtags'] = 'Информације о пољу';
$string['fieldsnavigation'] = 'Поља базе података - терцијарна навигација';
$string['fieldtagdescription'] = 'Опис поља {$a}';
$string['fieldtagid'] = 'ID ознака поља {$a}';
$string['fieldtagname'] = 'Назив поља {$a}';
$string['fieldupdated'] = 'Поље је ажурирано';
$string['fieldwidth'] = 'Ширина';
$string['fieldwidthlistview'] = 'Ширина (у пикселима) у приказу списка';
$string['fieldwidthsingleview'] = 'Ширина  (у пикселима) у појединачном приказу';
$string['file'] = 'Датотека';
$string['fileencoding'] = 'Кодирање';
$string['filesnotgenerated'] = 'Нису све датотеке генерисане: {$a}';
$string['filtername'] = 'Аутоматско линковање базе података';
$string['footer'] = 'Подножје';
$string['forcelinkname'] = 'Обавезан назив за линковање';
$string['foundnorecords'] = 'Није пронађен ниједан запис(<a href="{$a->reseturl}">Обриши све</a>)';
$string['foundrecords'] = 'Пронађени записи: {$a->num} од {$a->max}. (<a href="{$a->reseturl}">Обриши све</a>)';
$string['fromfile'] = 'Увези из ZIP архиве';
$string['fromfile_help'] = 'Опција \'Увези из zip датотеке\' вам омогућава да поставите zip датотеку која садржи предефинисани шаблон базе података.';
$string['generateerror'] = 'Нису све датотеке генерисане!';
$string['header'] = 'Заглавље';
$string['headeraddtemplate'] = 'Дефинишите интерфејс за додавање или уређивање уноса.';
$string['headerasearchtemplate'] = 'Дефинишите интерфејс за напредно претраживање.';
$string['headercsstemplate'] = 'Додајте прилагођени CSS стилове шаблонима.';
$string['headerjstemplate'] = 'Додајте прилагођени Javascript за манипулацију начина на који се елементи приказују на шаблонима за приказ списка уноса и појединачних уносе односно на шаблону за додавање уноса.';
$string['headerlisttemplate'] = 'Дефинишите изглед приказа списка.';
$string['headerrsstemplate'] = 'Дефинише изглед уноса у RSS сервисима.';
$string['headersingletemplate'] = 'Дефинишите изглед приказа појединачног уноса';
$string['id'] = 'ID ознака уноса';
$string['importandapply'] = 'Увези предефинисани шаблон базе података и примени';
$string['importapreset'] = 'Увези предефинисани шаблон базе података';
$string['importentries'] = 'Увези уносе';
$string['importpreset'] = 'Увези предефинисани шаблон базе података';
$string['importpreset_desc'] = 'Предефинисани шаблон базе података биће примењен на ову активност, креирајући поља и шаблоне.
Неће се појавити на списку  предефинисаних шаблона базе података.';
$string['importpresetmissingcapability'] = 'Немате овлашћење да увезете предефинисани шаблон базе података.';
$string['importsuccess'] = 'Предефинисани шаблон базе података је примењен.';
$string['includeapproval'] = 'Укључи статус одобрења';
$string['includefiles'] = 'Укључи датотеке у извоз';
$string['includetags'] = 'Укључи ознаке';
$string['includetime'] = 'Укључи време додавања/измене';
$string['includeuserdetails'] = 'Укључи детаљне податке о кориснику';
$string['indicator:cognitivedepth'] = 'База података - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'База података\'.';
$string['indicator:cognitivedepthdef'] = 'База података - когнитивни аспект';
$string['indicator:cognitivedepthdef_help'] = 'Учесник је постигао овај проценат когнитивног ангажмана који нуде активности База података током овог интервала анализе (Нивои = Без прегледа, Преглед, Предаја уноса)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'База података - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'База података\'.';
$string['indicator:socialbreadthdef'] = 'База података - социјални аспект';
$string['indicator:socialbreadthdef_help'] = 'Учесник је постигао овај проценат социјалног ангажмана који нуде активности База података током овог интервала анализе (Нивои = Без учешћа, Учесник сâм)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'потребно је више уноса за преглед ове базе података';
$string['intro'] = 'Опис';
$string['invalidaccess'] = 'Страници није исправно приступљено';
$string['invalidfieldid'] = 'ID поља није исправан';
$string['invalidfieldname'] = 'Молимо изаберите неко други назив за ово поље';
$string['invalidfieldtype'] = 'Тип поља није исправан';
$string['invalidid'] = 'ID података није исправан';
$string['invalidpreset'] = '{$a} није предефинисани шаблон базе података.';
$string['invalidrecord'] = 'Неисправан запис';
$string['invalidurl'] = 'URL који сте управо унели није исправан';
$string['jstemplate'] = 'Прилагођени Javascript';
$string['latitude'] = 'Ширина';
$string['latlong'] = 'Координате';
$string['latlongboth'] = 'Поља за географску ширина и дужина су обавезна.';
$string['latlongdownloadallhint'] = 'Преузимање линка за све уносе у KML облику';
$string['latlongkmllabelling'] = 'Како означити ставке у KML датотекама (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Линковани сервиси за приказ';
$string['latlongotherfields'] = 'Остала поља';
$string['list'] = 'Прикажи списак';
$string['listtemplate'] = 'Шаблон за приказ списка';
$string['listview'] = 'Приказ списка';
$string['longitude'] = 'Дужина';
$string['manageapproved'] = 'Дозволи уређивање одобрених уноса';
$string['manageapproved_help'] = 'Дозволите полазницима да уређују или бришу своје уносе након што они буду одобрени. Измењени уноси ће морати да буду поново одобрени.';
$string['managefields'] = 'Управљање пољима';
$string['mapexistingfield'] = 'Мапирај као {$a}';
$string['mapnewfield'] = 'Креирај ново поље';
$string['mapping:applypresets'] = 'Примени предефинисани шаблон базе података';
$string['mapping:dialogtitle:usepreset'] = 'Да ли желите да примените предефинисани шаблон базе података?';
$string['mapping:fieldstocreate'] = 'Поља која ће се креирати: {$a}';
$string['mapping:fieldstodelete'] = 'Постојећа поља за брисање: {$a}';
$string['mapping:mapfields'] = 'Мапирање поља';
$string['mapping:warningmessagedelete'] = 'Ако су поља која треба да се обришу истог типа као нова поља у предефинисаном шаблону базе података који планирате да искористите, можда ћете моћи да их мапирате помоћу Мапирања поља.';
$string['mapping:warningmessagedeleteandcreate'] = 'Ако су поља која треба да се обришу истог типа као и поља која ће се креирати, можда ћете моћи да их мапирате помоћу Мапирања поља.';
$string['mappingwarning'] = 'Сва стара поља које нису мапирана на ново поље ће бити изгубљена и сви подаци у тим пољима ће бити уклоњени.';
$string['maxentries'] = 'Максималан број уноса';
$string['maxentries_help'] = '<p align="center">strong>Максималан број уноса(записа)</strong></p>

<p>За ову активност, корисници могу означити максималан број уноса. </p>';
$string['maxsize'] = 'Максимална величина';
$string['menu'] = 'Мени';
$string['menuchoose'] = 'Изаберите...';
$string['missingdata'] = 'ID ознака података или објект морају бити наведени за класу поља.';
$string['missingfield'] = 'Грешка програмера: Морате одредити поље и/или податке када дефинишете класу поља.';
$string['missingfieldtype'] = 'Није пронађен тип поља за {$a->name}';
$string['missingfieldtypeimport'] = 'Следећа поља нису увезена јер њихови одговарајући типови поља нису инсталирани:';
$string['missingfieldtypes'] = 'Следећа поља немају инсталиране одговарајуће типове поља и неће бити укључена у образац за додавање уноса. Морате да проверите шаблон Додај унос и уклоните све називе поља.';
$string['modulename'] = 'База података';
$string['modulename_help'] = 'Модул активности \'База података\' омогућава учесницима да креирају, одржавају и претражују колекције различитих врста података (записа).

Структуру података који се уносе у базу дефинише се различитим типовима поља, као што су кратак текст, падајућа листа, поље за унос текста, URL адреса, слика или датотека.

Као предавач, можете да коментаришете и оцењујете уносе. Такође можете дозволити полазницима да оцењују и коментаришу уносе (вршњачка евалуација). Оцене се могу агрегирати да би се формирала коначна оцена, која се уписује у књигу оцена.

Ако је филтер за аутоматско линковање базе података омогућен, сваки унос у бази података биће аутоматски повезан где год се речи и фразе појављују унутар курса.

Активност \'База података\' може користити за:

* креирање заједничких колекција линкова, књига, рецензија књига, радова, часописа итд.
* за приказивања фотографија које су снимили полазници, постера, веб сајтова или песама, као и за коментарисање и преглед од стране других полазника на курсу.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Базе података';
$string['more'] = 'Још';
$string['moreurl'] = 'Још URL-a';
$string['movezipfailed'] = 'Није могуће преместити ZIP архиву';
$string['multientry'] = 'Поновљени унос';
$string['multimenu'] = 'Мени (могућност вишеструког избора)';
$string['multipletags'] = 'Пронађене су вишеструке ознаке! Шаблон није сачуван';
$string['newentry'] = 'Нови унос';
$string['newfield'] = 'Креирај поље';
$string['newfield_help'] = 'Поље омогућава унос података. Сваки унос у Базу података може имати више поља различитих типова, као што су поље за датум (учесници могу да изаберу дан, месец и годину из падајућег менија), поље за слику (учесници могу да поставе датотеку са сликом) или поље за потврду које даје могућност учесницима да изаберу једну или више опција.

Свако поље мора имати јединствен назив поља. Опис поља је није обавезан.';
$string['noaccess'] = 'Немате приступ овој страници';
$string['nodefinedfields'] = 'Нови предефинисани шаблон базе података нема дефинисана поља!';
$string['nofieldcontent'] = 'Садржај поља није пронађен';
$string['nofieldindatabase'] = 'Нема поља дефинисаних за ову базу података.';
$string['nofields'] = 'Још нема дефинисаних поља';
$string['nolisttemplate'] = 'Шаблон за приказ списак уноса још није дефинисан';
$string['nomatch'] = 'Нема уноса који се поклапају!';
$string['nomaximum'] = 'Нема максимума';
$string['nopreviewavailable'] = 'Није доступан преглед за {$a}';
$string['norecords'] = 'Још нема уноса у базу података';
$string['notapproved'] = 'Унос још није одобрен';
$string['notapprovederror'] = 'Унос још није одобрен.';
$string['notemplates'] = 'Још нема шаблона';
$string['notinjectivemap'] = 'Мапа не може да се убаци';
$string['notopenyet'] = 'Нажалост, ова активност није доступна до {$a}';
$string['number'] = 'Број';
$string['numberrssarticles'] = 'Број уноса у RSS извору';
$string['numnotapproved'] = 'На чекању';
$string['numrecords'] = '{$a} уноса';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'Навели сте датум отварања након датума затварања';
$string['optionaldescription'] = 'Кратак опис (опционо)';
$string['optionalfilename'] = 'Назив датотеке (опционо)';
$string['other'] = 'Друго';
$string['otherfields'] = 'Сва остала поља';
$string['overrwritedesc'] = 'Замени постојећи предефинисани шаблон базе података са овим називом и препишите преко њеног садржаја.';
$string['overwrite'] = 'Препиши';
$string['overwritesettings'] = 'Замените тренутна подешавања као што су коментари, оцене итд.';
$string['page-mod-data-x'] = 'Било која страница модула \'База поодатака\'';
$string['pagesize'] = 'Уноса по страници';
$string['participants'] = 'Учесници';
$string['picture'] = 'Слика';
$string['pluginadministration'] = 'Администрација активности \'База података\'';
$string['pluginname'] = 'База података';
$string['portfolionotfile'] = 'Извези у портфолио а не у датотеку (само за csv и leap2a)';
$string['presetdeleted'] = 'Предефинисани шаблон базе података обрисан.';
$string['presetinfo'] = 'Чување у форми предефинисаног шаблона базе података ће објавити овај шаблон. Други корисници ће моћи да га користе у својим базама података.';
$string['presetnotselected'] = 'Није изабран ниједан предефинисани шаблон базе података.';
$string['presets'] = 'Предефинисани шаблони базе података';
$string['presetshelp'] = 'Изаберите предефинисани шаблон базе података који ћете користити као почетну тачку.';
$string['preview'] = 'Преглед {$a}';
$string['previewaction'] = 'Преглед';
$string['privacy:metadata:commentpurpose'] = 'Коментари на записе у бази';
$string['privacy:metadata:data_content'] = 'Садржај поља';
$string['privacy:metadata:data_content:content'] = 'Садржај';
$string['privacy:metadata:data_content:content1'] = 'Додатни садржај 1';
$string['privacy:metadata:data_content:content2'] = 'Додатни садржај 2';
$string['privacy:metadata:data_content:content3'] = 'Додатни садржај 3';
$string['privacy:metadata:data_content:content4'] = 'Додатни садржај 4';
$string['privacy:metadata:data_content:fieldid'] = 'ID ознака дефиниције поља';
$string['privacy:metadata:data_records'] = 'Записи у активности База података';
$string['privacy:metadata:data_records:approved'] = 'Статус одобрења';
$string['privacy:metadata:data_records:groupid'] = 'Група';
$string['privacy:metadata:data_records:timecreated'] = 'Време када је запис креиран';
$string['privacy:metadata:data_records:timemodified'] = 'Време када је запис последњи пут измењен';
$string['privacy:metadata:data_records:userid'] = 'Корисник који је креирао запис';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Поља за модул активности База података';
$string['privacy:metadata:filepurpose'] = 'Датотека у прилогу записа у бази података';
$string['privacy:metadata:ratingpurpose'] = 'Оцене записа у бази података';
$string['privacy:metadata:tagpurpose'] = 'Ознаке записа у бази података';
$string['radiobutton'] = 'Радио дугмад';
$string['recordapproved'] = 'Унос је одобрен';
$string['recorddeleted'] = 'Унос је обрисан';
$string['recorddisapproved'] = 'Унос није одобрен';
$string['recordsnotsaved'] = 'Није сачуван ниједан унос. Молимо проверите формат постављене датотеке.';
$string['recordssaved'] = 'уноси сачувани';
$string['removealldatatags'] = 'Све ознаке базе података';
$string['requireapproval'] = 'Одобрење обавезно';
$string['requireapproval_help'] = 'Предавач мора да одобри уносе пре него што они буду видљиви свима.';
$string['required'] = 'Обавезно';
$string['requiredentries'] = 'Број уноса неопходних за завршетак (старо)';
$string['requiredentries_help'] = 'Ако је ова опција подешена, биће приказана порука у којој се наводи број уноса неопходних за завршетак. Имајте у виду да ово није повезано за завршетком активности.

Како би се одредио број уноса неопходних за завршетак активности, потребно је користити ново подешавање за завршетак активности \'Захтевај унос\'. Да бисте уклониле ово подешавање у потпуности, изаберите опцију \'Ниједан\', а затим сачувајте промене.
Уместо тога, молимо вас да користите поље \'Неопходан број уноса \' у секцији \'Завршетак активности\'.';
$string['requiredentriestoview'] = 'Уноси потребни пре прегледања';
$string['requiredentriestoview_help'] = 'Број уноса које полазник мора да креира пре него што буде могао да види уносе других полазника.

Ово није компатибилно са филтером за аутоматско линковање базе података.';
$string['requiredentrieswarning'] = 'Ово подешавање је замењено са подешавањем "Захтевај уносе" унутар секције "Завршетак активности"';
$string['requiredfield'] = 'Обавезно поље';
$string['resetalltemplates'] = 'Ресетуј све шаблоне';
$string['resetalltemplatesconfirm'] = 'Спремате се да уклоните све шаблоне за свој текући предефинисани шаблон базе података. Ако желите да вратите шаблоне касније, морате поново да изаберете предефинисани шаблон на картици \'Предефинисани шаблони базе података\'.';
$string['resetalltemplatesconfirmtitle'] = 'Да ли желите да ресетујете све шаблоне?';
$string['resetsettings'] = 'Ресетуј филтере';
$string['resettemplate'] = 'Ресетуј текући шаблон';
$string['resettemplateconfirm'] = 'Ово ће трајно уклонити {$a} из вашег текућег предефинисаног шаблона базе података.';
$string['resettemplateconfirmtitle'] = 'Да ли желите да ресетујете шаблон?';
$string['resizingimages'] = 'Промена величине умањеног приказа слике...';
$string['rows'] = 'редови';
$string['rssglobaldisabled'] = 'Онемогућено. Погледајте променљиве конфигурације сајта.';
$string['rsstemplate'] = 'RSS шаблон';
$string['rsstitletemplate'] = 'Наслов RSS шаблона';
$string['rsstype'] = 'RSS сервис за ову активност';
$string['save'] = 'Сачувај';
$string['saveandadd'] = 'Сачувај и додај још';
$string['saveandview'] = 'Сачувај и прикажи';
$string['saveaspreset'] = 'Објавите предефинисани шаблон базе података на овом сајту';
$string['saveaspreset_help'] = 'Опција \'Сачувај као предифинисани шаблон базе података\' омогућава да текући шаблон буде сачуван и доступан за коришћење другим корисницима овог сајта (можете га обрисати са списка предефинисаних шаблона у било ком тренутку).';
$string['saveaspresetmissingcapability'] = 'Корисник нема овлашћење да сачува базу података као предефинисани шаблон.';
$string['savedataaspreset'] = 'Сачувајте сва поља и шаблоне и објавите предефинисани шаблон базе података на овом сајту';
$string['savesettings'] = 'Сачувај подешавања';
$string['savesuccess'] = 'Предефинисани шаблон базе података сачуван. <a href="{$a->url}">Преглед предефинисаног шаблона базе података</a>';
$string['search'] = 'Тражи';
$string['search:activity'] = 'База података - информације о активности';
$string['search:entry'] = 'База података - уноси';
$string['searchresults'] = 'Уноси који садрже "{$a}"';
$string['selectedrequired'] = 'Све изабрано обавезно';
$string['selectexportoptions'] = 'Изабери опције за извоз';
$string['selectfields'] = 'Изабери поља';
$string['selectfordeletion'] = 'Изаберите унос за брисање';
$string['showall'] = 'Прикажи све уносе';
$string['showmore'] = 'Прикажи више';
$string['single'] = 'Прикажи појединачно';
$string['singletemplate'] = 'Шаблон за појединачни приказ';
$string['singleview'] = 'Појединачни приказ';
$string['startbuilding'] = 'Почните да градите своју активност';
$string['subplugintype_datafield'] = 'Тип поља базе података';
$string['subplugintype_datafield_plural'] = 'Типови поља базе података';
$string['subplugintype_datapreset'] = 'Предефинисани шаблон базе података';
$string['subplugintype_datapreset_plural'] = 'Предефинисани шаблони базе података';
$string['tagarea_data_records'] = 'Записи података';
$string['tags'] = 'Ознаке';
$string['tagsdeleted'] = 'Ознаке базе података су обрисане';
$string['teachersandstudents'] = '{$a->teachers} и {$a->students}';
$string['templatereset'] = 'Ресетовање шаблона';
$string['templateresetall'] = 'Сви шаблони су ресетовани';
$string['templates'] = 'Шаблони';
$string['templatesaved'] = 'Шаблон је сачуван';
$string['templatesnavigation'] = 'Шаблони базе података - терцијарна навигација';
$string['text'] = 'Текст';
$string['textarea'] = 'Текстуална област';
$string['timeadded'] = 'Време додавања';
$string['timemodified'] = 'Време измене';
$string['type'] = 'Тип поља';
$string['undefinedprocessactionmethod'] = 'Не постоји метода дефинисана у Data_Preset да користи акцију "{$a}".';
$string['unknown'] = 'Непознато поље';
$string['unsupportedfields'] = 'Неподржана поља';
$string['unsupportedfieldslist'] = 'Следећа поља не могу бити извезена:';
$string['updatefield'] = 'Ажурирање постојећег поља';
$string['uploadfile'] = 'Постави датотеку';
$string['uploadrecords'] = 'Увоз уноса';
$string['uploadrecords_help'] = 'Увезите уносе које сте извезли из друге базе података, било преко CSV датотеке или ZIP архиве која садржи CSV датотеку (ако су датотеке укључене у извоз).

Алтернативно, да бисте креирали CSV датотеку за увоз, додајте један унос у базу података, а затим га извезите. Уредите CSV датотеку а затим додајте још уноса.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL адреса';
$string['usedate'] = 'Укључи у претраживање.';
$string['usepredefinedset'] = 'Користите унапред дефинисани скуп';
$string['usepreset'] = 'Употребите овај предефинисани шаблон базе података';
$string['usestandard'] = 'Употребите предефинисани шаблон базе података';
$string['usestandard_help'] = 'Да бисте користили предефинисани шаблон базе података доступан на нивоу читавог сајтa, одаберите га са списка. (Ако сте додали предифинисани шаблон списку користећи опцију \'Сачувај као предефинисани шаблон базе података\' онда имате опцију и за његово брисање.)';
$string['viewfromdate'] = 'Може се само читати од';
$string['viewnavigation'] = 'Режим прегеледа базе података - терцијарна навигација';
$string['viewtemplates'] = 'Преглед шаблона';
$string['viewtodate'] = 'Може се само читати до';
$string['viewtodatevalidation'] = 'Датум \'може се само читати до\' не може бити пре датума  \'може се само читати од\'.';
$string['wrongdataid'] = 'Наведена је погрешна ID ознака податка';
