<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_live_services', language 'tr', version '4.5'.
 *
 * @package     block_live_services
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alertsCancelButtonText'] = 'İptal';
$string['alertsCloseButtonText'] = 'Kapat';
$string['calendarAllDayEvent'] = 'Tüm gün aktivitesi';
$string['calendarAllDayEventMessage'] = 'Bu bir Tüm Gün Etkinliğidir';
$string['calendarCancel'] = 'İptal';
$string['emailCancel'] = 'İptal';
$string['faqMoodleA3'] = 'Mevcut e-posta adresinizi kullanabilir veya ücretsiz bir Windows Live e-posta adresi için kaydolabilirsiniz.  Seçim senin.  Bazı özelliklerin yalnızca belirli e-posta hesaplarında kullanılabileceğini unutmayın.  Örneğin, e-posta erişimi Hotmail, MSN&reg; ve Live adresleriyle sınırlıdır.';
$string['faqMoodleA5'] = 'Windows Live ID\'niz ile Moodle\'da oturum açamıyorsanız, aşağıdakileri deneyin:<br/>
<ul>
<li>E-posta adresinizin tamamının (@ işaretinden önce ve sonra) <strong>E-posta adresi</strong> alanına girildiğinden emin olun.  </li>
<li>Parolanızı doğru girdiğinizden emin olun.  Parolalar büyük/küçük harfe duyarlıdır.  Parolanızı unuttuysanız, sıfırlamayı deneyin.  </li>
<li>Hotmail veya MSN e-posta adresinizi uzun süredir kullanmadıysanız devre dışı bırakılmış olabilir.  Hesabınız devre dışı bırakıldıysa, <a href=\\"http://login.live.com/login.srf?wa=wsignin1.0&rpsnv=10&ct=1244735143&rver=5.5.4177.0&wp=MBI&wreply=http://mail.live Yeni bir hesap açmak için .com/default.aspx&lc=1033&id=64855&mkt=en-US\\" target=\\"_blank\\">Hotmail kayıt Web sitesini ziyaret edin</a>.  </li>
<li>Kullanıcı adınız, @ işaretinden sonra msn veya hotmail etki alanını içermiyorsa ve hesabı bir yıldan fazla kullanmadıysanız kullanılamayabilir.  Yeni kimlik bilgilerine kaydolmak için Windows Live ID Web sitesini ziyaret edin.  </li>
<li>Tarayıcınızı çerezlere izin verecek şekilde yapılandırdığınızdan emin olun.  Tarayıcınız tanımlama bilgilerine izin vermiyorsa, Windows Live ID\'niz ile oturum açamazsınız.  </li>
<li>Ağın geçici olarak hizmet dışı olduğunu bildiren bir hata mesajı olup olmadığına bakın.</li>
</ul>';
$string['faqMoodleQ3'] = 'Yeni bir e-posta adresi oluşturmalı mıyım yoksa mevcut e-posta adresimi kullanabilir miyim?';
$string['faqWLIDA1'] = 'Windows Live ID; Windows Live Hotmail, Windows Live Calendar, Windows Live Messenger ve bing&trade;&nbsp;search dahil olmak üzere Microsoft&reg;&nbsp;hizmetlerine erişmenizi sağlar.  Windows Live ID\'nizi (e-posta ve parola) bir kez oluşturabilir, ardından bu hizmetlerde ve Moodle siteniz gibi diğer hizmetlerde oturum açmak için kullanabilirsiniz.
 Windows Live ID hakkında daha fazla bilgi edinmek için bkz. <a target=\\"_blank\\" href=\\"https://accountservices.passport.net/ppnetworkhome.srf?vv=650&lc=1033\\">Oturum açmanızı basitleştirin.<  /a>';
$string['faqWLIDA3'] = 'Kişisel bilgilerinizin korunmasına yardımcı olmak için, parolanızı sık sık değiştirmeniz önerilir.
<br/>Parolanızı değiştirmek için:
<ol>
<li>Windows Live ID\'nizle hesap özeti sayfanızda oturum açın.</li>
<li><strong>Parola sıfırlama bilgileri</strong> altında, <strong\'u tıklayın. <strong>Parola</strong>\'nın yanındaki >Değiştir</strong>.</li>
<li><strong>Windows Live ID</strong> alanındaki e-posta adresinin doğru olduğunu doğrulayın ve ardından yazın <strong>Eski şifre</strong> kutusuna eski şifrenizi yazın.</li>
<li>Yeni bir şifre girin ve onaylayın.</li>
<li>Şifrenizi her 72 günde bir sona erecek şekilde ayarlamak için, < güçlü>

Not: Bazı hizmetler, parolanızı her 72 günde bir değiştirmenizi gerektirir. Bu hizmetlerden birini kullanıyorsanız, otomatik parola geçerlilik süresi önceden ayarlanmış olabilir ve değiştirilemez.';
$string['faqWLIDA4'] = 'Önce şu adımları izleyin:
<ol>
<li>Oturum açma alanında, <strong>Şifrenizi mi unuttunuz?</strong></li>
<li><strong>E-posta adresi</strong> alanında tıklayın. , Windows Live ID\'nizi oluşturmak için kullandığınız adresi girin.</li>
<li><strong>Resim</strong> alanında gördüğünüz karakterleri girin ve ardından <strong>Devam</strong>\'ı tıklayın. </li>
</ol>
Ardından, parolanızı belirlemek veya sıfırlamak için iki seçeneğiniz vardır. Kendinize bir mesaj gönderebilir veya gizli sorunuzu cevaplayabilirsiniz.
Kendinize bir mesaj göndermek için:
<ul>
<li><strong>Kendinize bir şifre sıfırlama e-posta mesajı gönderin</strong> </li> seçeneğini tıklayın.
<li>Kimlik bilgilerinize alternatif bir e-posta eklediyseniz, <strong>Diğer e-posta adresime bir e-posta mesajı gönder</strong>\'i ve ardından <strong>Mesaj Gönder</strong>\'i tıklayın. Veya oturum açarken E-posta adresimi ve şifremi kaydet seçeneğini kullanırsanız, her zamanki e-posta adresinize bir e-posta mesajı göndermek için seçeneğe tıklayın ve ardından Mesaj Gönder\'e tıklayın. Parolanız otomatik olarak kaydedildiği için e-postanıza erişebileceksiniz.</li>
<li>Alternatif e-posta hesabınızı açın ve parola sıfırlama e-posta mesajındaki talimatları izleyin.</li> >
</ul>
Gizli sorunuzu yanıtlamak için:
<ul>
<li><strong>Hesap bilgilerini sağlayın ve gizli sorunuzu yanıtlayın</strong></li> seçeneğini tıklayın.
<li><strong>Ülke/Bölge</strong> menüsünden ülkenizin veya bölgenizin adını seçin, istenirse posta kodunuzu veya posta kodunuzu girin. Ardından, <strong>Gizli Yanıt</strong> alanına, Soru alanındaki sorunun yanıtını girin. </li>
<li><strong>Devam</strong>\'ı tıklayın.</strong></li>
<li>Yeni bir şifre girin ve onaylayın ve ardından <strong>Devam</strong>\'ı tıklayın.</li>
<li> <strong>Bitti</strong></li>
</ul> öğesini tıklayın.';
$string['faqWLSA2'] = 'Hotmail, Live veya MSN\'den olmayan bir e-posta adresi kullanarak bir Windows Live ID\'ye kaydolduysanız, Moodle\'dan e-postaya erişemezsiniz.';
$string['faqWLSA3'] = 'Evet, e-postanıza tam erişiminiz olmasa bile Windows Live ID\'nizi kullanarak bir kişi listesi tutabileceksiniz.';
$string['faqWLSA4'] = 'Evet, Windows Live Takvimi tüm Windows Live ID hesapları tarafından kullanılabilir.';
$string['faqWLSA7'] = 'Varlığı açmak için:<br/>
<ol>
<li><a href=\\"http://settings.messenger.live.com/applications/websettings.aspx?wa=wsignin1.0\\" target=\\ öğesini açın. "_blank\\">Windows Live Messenger Web Ayarları.</a></li>
<li>Henüz oturum açmadıysanız, Windows Live ID\'niz ile oturum açmanız gerekir.</li>
<li ><strong>Web\'deki herkesin varlığımı görmesine ve bana mesaj göndermesine izin ver</strong>\'i tıklayın.</strong></li>
<li><strong>Kaydet</strong></li>
</ol>\' i tıklayın.';
$string['faqWLSA9'] = 'Uyarı, bir grup öğretmen ve öğrenci için yayınlanan bir mesajdır. Uyarılar e-postanıza, Windows Live Messenger\'a ve mobil cihazınıza gönderilebilir. Windows Live Alerts\'e abone olduğunuzda, tercih ettiğiniz teslim yöntemlerini ayarlayabilirsiniz.';
$string['faqWLSQ2'] = 'Neden e-postama erişemiyorum?';
$string['faqWLSQ3'] = 'E-postama erişemezsem, bir kişi listesi tutabilir miyim?';
$string['live_services_help'] = '<style type=\\"text/css\\">

        div#faq
        {
            margin:18px;
        }
        h1
        {
            font-size:1.3em;
        }

        h2
        {
            font-size:1.1em;
        }
        h3
        {
            font-size:1.0em;
        }
        a.questionLink
        {
            display:block;
            margin:10px 4px;
        }

</style>  -->

<h1>Sıkça Sorulan Sorular: Moodle\'da Windows Live&trade;&nbsp;Services\'i Kullanma</h1>
<sa/>
<p>Windows Live&trade;&nbsp;ID\'nizi ayarlama, Moodle\'da oturum açmak için Windows Live ID\'nizi kullanma ve Windows Live hizmetlerini kullanma hakkında sık sorulan soruların yanıtlarını bulun.</p>

<h2>Windows Live Kimliği</h2>
<a href="#WLID1" class="questionLink">Windows Live ID nedir?</a>
<a href="#WLID2" class="questionLink">Nasıl Windows Live ID alabilirim?</a>
<a href="#WLID3" class="questionLink">Windows Live ID şifremi nasıl değiştiririm?</a>
<a href="#WLID4" class="questionLink">Windows Live ID parolamı unutursam ne yapmalıyım?</a>
<h2>Moodle</h2>

<a href="#Moodle1" class="questionLink">Windows Live ID\'m Moodle\'da nasıl kullanılır?</a>
<a href="#Moodle2" class="questionLink">Windows Live\'ın Moodle siteme erişmesine neden izin vermeliyim?</a>
<a href="#Moodle3" class="questionLink">Yeni bir e-posta adresi oluşturmalı mıyım yoksa mevcut e-posta adresimi kullanabilir miyim?</a>
<a href="#Moodle4" class="questionLink">Moodle hesabımı Windows Live ID\'me nasıl bağlarım?  </a>
<a href="#Moodle5" class="questionLink">Giriş yapamazsam ne yapmalıyım?  </a>
<h2>Windows Live Hizmetleri</h2>

<a href="#WLS1" class="questionLink">Moodle\'ımdan hangi Windows Live hizmetlerini kullanabilirim?</a>
<a href="#WLS2" class="questionLink">E-postama neden erişemiyorum?</a>
<a href="#WLS3" class="questionLink">E-postama erişemezsem, bir kişi listesi tutabilir miyim?  </a>
<a href="#WLS4" class="questionLink">Windows Live Takvim, Windows Live ID\'si olan herkes tarafından kullanılabilir mi?</a>
<a href="#WLS5" class="questionLink">Windows Live Calendar\'ı kullanma hakkında daha fazla bilgiyi nereden öğrenebilirim?</a>
<a href="#WLS6" class="questionLink">Sınıf arkadaşlarıma neden anlık ileti gönderemiyorum?  </a>

<a href="#WLS7" class="questionLink">Windows Live Messenger\'da varlığımı nasıl etkinleştiririm?</a>
<a href="#WLS8" class="questionLink">Windows Live Messenger varlığım etkinleştirildiğinde neden çevrimdışı görünüyorum?</a>
<a href="#WLS9" class="questionLink">Windows Live Alert nedir?</a>
<a href="#WLS10" class="questionLink">Kimler Windows Live Uyarısı gönderebilir?</a>
<a href="#WLS11" class="questionLink">Kimler Windows Live Uyarısı alabilir?</a>
<a href="#WLS12" class="questionLink">Bir öğrenciye Windows Live Alert gönderebilir miyim?</a>

<a href="#WLS13" class="questionLink">Kurs uyarılarım neden aniden çalışmayı durdurdu?</a>
<h2>Windows Live Kimliği</h2>
<h3 id="WLID1">Windows Live ID nedir?</h3>
<p>Windows Live ID; Windows Live Hotmail, Windows Live Calendar, Windows Live Messenger ve bing&trade;&nbsp;search dahil olmak üzere Microsoft&reg;&nbsp;hizmetlerine erişmenizi sağlar.  Windows Live ID\'nizi (e-posta ve parola) bir kez oluşturabilir, ardından bu hizmetlerde ve Moodle siteniz gibi diğer hizmetlerde oturum açmak için kullanabilirsiniz.
Windows Live ID hakkında daha fazla bilgi edinmek için bkz. <a target=\\"_blank\\" href=\\"https://accountservices.passport.net/ppnetworkhome.srf?vv=650&lc=1033\\">Oturum açmanızı basitleştirin.< /a></p>
<h3 id="WLID2">Windows Live ID\'yi nasıl edinebilirim?</h3>

<p>Moodle oturum açma sitesinden veya <a target=\\"blank\\" href=\\"https://signup.live.com/signup.aspx?rollrs=12&lic=1 adresinden bir Windows Live ID\'ye kaydolabilirsiniz. \\">Çevrimiçi olun ve bir hesap oluşturun.</a></p>
<h3 id="WLID3">Windows Live ID parolamı nasıl değiştiririm?</h3>
<p>Kişisel bilgilerinizin korunmasına yardımcı olması için şifrenizi sık sık değiştirmeniz önerilir.
<br/>Şifrenizi değiştirmek için:
<ol>
<li>Windows Live ID\'niz ile hesap özeti sayfanızda oturum açın.</li>
<li><strong>Parola sıfırlama bilgileri</strong> altında, <strong>Parola</strong>\'nın yanındaki <strong>Değiştir</strong>\'i tıklayın.</li>

<li><strong>Windows Live ID</strong> alanındaki e-posta adresinin doğru olduğunu doğrulayın ve ardından <strong>Eski parola</strong> kutusuna eski parolanızı yazın.</li>
<li>Yeni bir şifre girin ve onaylayın.</li>
<li>Şifrenizi her 72 günde bir sona erecek şekilde ayarlamak için, <strong>Parolamın süresinin 72 günde bir dolmasını sağla</strong> onay kutusunu ve ardından <strong>Kaydet</strong>\'i tıklayın.</li>

</ol>
Not: Bazı hizmetler, parolanızı her 72 günde bir değiştirmenizi gerektirir.  Bu hizmetlerden birini kullanıyorsanız, otomatik şifre geçerlilik süresi önceden ayarlanmış olabilir ve değiştirilemez.</p>
<h3 id="WLID4">Windows Live ID parolamı unutursam ne yapmalıyım?</h3>
<p>Önce şu adımları izleyin:
<ol>
<li>Oturum açma alanında <strong>Şifrenizi mi unuttunuz?</strong></li> seçeneğini tıklayın.
<li><strong>E-posta adresi</strong> alanına, Windows Live ID\'nizi oluşturmak için kullandığınız adresi girin.</li>

<li><strong>Resim</strong> alanına gördüğünüz karakterleri girin ve ardından <strong>Devam Et</strong>\'i tıklayın.</li>
</ol>
Ardından, parolanızı belirlemek veya sıfırlamak için iki seçeneğiniz vardır.  Kendinize bir mesaj gönderebilir veya gizli sorunuzu cevaplayabilirsiniz.
Kendinize bir mesaj göndermek için:
<ul>
<li><strong>Kendinize bir parola sıfırlama e-posta iletisi gönderin</strong> </li> öğesini tıklayın.
<li>Kimlik bilgilerinize alternatif bir e-posta eklediyseniz, <strong>Diğer e-posta adresime bir e-posta mesajı gönder</strong>\'i ve ardından <strong>Mesaj Gönder</strong>\'i tıklayın.  Veya oturum açarken E-posta adresimi ve şifremi kaydet seçeneğini kullanırsanız, her zamanki e-posta adresinize bir e-posta mesajı göndermek için seçeneğe tıklayın ve ardından Mesaj Gönder\'e tıklayın.  Şifreniz otomatik olarak kaydedildiği için e-postanıza erişebileceksiniz.</li>

<li>Alternatif e-posta hesabınızı açın ve şifre sıfırlama e-posta mesajındaki talimatları izleyin.</li>
</ul>
Gizli sorunuzu cevaplamak için:
<ul>
<li><strong>Hesap bilgilerini sağlayın ve gizli sorunuzu yanıtlayın</strong></li>\'ı tıklayın.
<li><strong>Ülke/Bölge</strong> menüsünden ülkenizin veya bölgenizin adını seçin, istenirse posta kodunuzu veya posta kodunuzu girin.  Ardından, <strong>Gizli Yanıt</strong> alanına, Soru alanındaki sorunun yanıtını girin.  </li>
<li><strong>Devam</strong></li>\'ı tıklayın.

<li>Yeni bir şifre girip onaylayın ve ardından <strong>Devam Et</strong>\'i tıklayın.</li>
<li><strong>Bitti</strong></li>\'yi tıklayın
</ul>
</p>
<h2>Moodle</h2>
<h3 id="Moodle1">Windows Live ID\'m Moodle\'da nasıl kullanılır?</h3>
<p>Moodle için Microsoft Live Services Eklentisi, Windows Live ID\'nizi kullanarak Moodle\'ınızda oturum açma seçeneği sunar.  Ayrıca, Moodle\'ınızda oturum açtığınızda, Windows Live Mail, Takvim ve Messenger gibi bazı popüler Windows Live hizmetlerine de hızlı bir şekilde erişebilirsiniz.</p>

<h3 id="Moodle2">Windows Live\'ın Moodle siteme erişmesine neden izin vermeliyim?</h3>
<p>Windows Live ID\'nizi kullanarak Moodle\'ınızda ilk kez oturum açtığınızda, Windows Live Messenger kişi listenizi görüntülemek için siteye erişim izni vermeniz gerekir, böylece Windows Live ayarlarınızı Moodle\'ınız aracılığıyla gönderebilir.  </p>
<h3 id="Moodle3">Yeni bir e-posta adresi oluşturmalı mıyım yoksa mevcut e-posta adresimi kullanabilir miyim?</h3>
<p>Mevcut e-posta adresinizi kullanabilir veya ücretsiz bir Windows Live e-posta adresi için kaydolabilirsiniz.  Seçim senin.  Bazı özelliklerin yalnızca belirli e-posta hesaplarında kullanılabileceğini unutmayın.  Örneğin, e-posta erişimi Hotmail, MSN&reg; ve Live adresleriyle sınırlıdır.  </p>
<h3 id="Moodle4">Moodle hesabımı Windows Live ID\'me nasıl bağlarım?  </h3>
<p>Bu, Moodle yöneticiniz tarafından sizin için yapılmış olabilir.  Değilse, aşağıdaki adımlarla Moodle ve Windows Live ID hesaplarınızı birbirine bağlayabilirsiniz:

<br/><br/><strong>Not:</strong> Henüz bir Windows Live ID\'niz yoksa, devam etmeden önce kaydolmanız gerekir.
<br/>Moodle ve Windows Live ID hesaplarınızı birbirine bağlamak için:
<ol>
<li>Moodle\'da oturum açın.</li>
<li>Hesabınızı görüntülemek için sağ üst köşedeki adınızı tıklayın.</li>
<li><strong>Profili Düzenle</strong></li>\'yi tıklayın.
<li><strong>Gelişmiş Göster</strong></li>\'i tıklayın.
<li><strong>MSN ID</strong> alanına Windows Live ID\'nizi girin.</li>

<li><strong>Profili Güncelle</strong></li>\'yi tıklayın.
</ol>
</p>
<h3 id="Moodle5">Giriş yapamazsam ne yapmalıyım?  </h3>
<p>Windows Live ID\'niz ile Moodle\'da oturum açamıyorsanız, aşağıdakileri deneyin:<br/>
<ul>
<li>E-posta adresinizin tamamının (@ işaretinden önce ve sonra) <strong>E-posta adresi</strong> alanına girildiğinden emin olun.  </li>

<li>Parolanızı doğru girdiğinizden emin olun.  Parolalar büyük/küçük harfe duyarlıdır.  Parolanızı unuttuysanız, sıfırlamayı deneyin.  </li>
<li>Hotmail veya MSN e-posta adresinizi uzun süredir kullanmadıysanız devre dışı bırakılmış olabilir.  Hesabınız devre dışı bırakıldıysa, <a href=\\"http://login.live.com/login.srf?wa=wsignin1.0&rpsnv=10&ct=1244735143&rver=5.5.4177.0&wp=MBI&wreply=http://mail.live Yeni bir hesap açmak için .com/default.aspx&lc=1033&id=64855&mkt=en-US\\" target=\\"_blank\\">Hotmail kayıt Web sitesini ziyaret edin</a>.  </li>
<li>Kullanıcı adınız, @ işaretinden sonra msn veya hotmail etki alanını içermiyorsa ve hesabı bir yıldan fazla kullanmadıysanız kullanılamayabilir.  Yeni kimlik bilgilerine kaydolmak için Windows Live ID Web sitesini ziyaret edin.  </li>
<li>Tarayıcınızı çerezlere izin verecek şekilde yapılandırdığınızdan emin olun.  Tarayıcınız tanımlama bilgilerine izin vermiyorsa, Windows Live ID\'niz ile oturum açamazsınız.  </li>
<li>Ağın geçici olarak hizmet dışı olduğunu bildiren bir hata mesajı olup olmadığına bakın.</li>
</ul>
</p>
<h2>Windows Live Hizmetleri</h2>

<h3 id="WLS1">Moodle\'ımdan hangi Windows Live hizmetlerini kullanabilirim?</h3>
<p>Moodle için Microsoft Live Services Eklentisi, Windows Live Mail, Calendar, Messenger, Alerts ve Bing aramaya erişim sağlar.<br/><br/>
Not: Moodle sitenizde Windows Live hizmetleri yoksa, Moodle yöneticiniz bu seçeneği yüklememiş olabilir.  </p>
<h3 id="WLS2">E-postama neden erişemiyorum?</h3>
<p>Windows Live ID\'ye Hotmail, Live veya MSN\'den olmayan bir e-posta adresi kullanarak kaydolduysanız, e-postaya Moodle\'dan erişemezsiniz.  </p>
<h3 id="WLS3">E-postama erişemezsem, bir kişi listesi tutabilir miyim?  </h3>

<p>Evet, e-postanıza tam erişiminiz olmasa bile Windows Live ID\'nizi kullanarak bir kişi listesi tutabileceksiniz.</p>
<h3 id="WLS4">Windows Live Takvim, Windows Live ID\'si olan herkes tarafından kullanılabilir mi?</h3>
<p>Evet, Windows Live Takvim tüm Windows Live ID hesapları tarafından kullanılabilir.</p>
<h3 id="WLS5">Windows Live Calendar\'ı kullanma hakkında nereden daha fazla bilgi edinebilirim?</h3>
<p>Takviminizi ayarlama ve sürdürme hakkında daha fazla bilgi edinmek için <a target=\\"_blank\\" href=\\"http://help.live.com/help.aspx?project=Calendar&market=en-WW&querytype= adresini açın. &query=&tmt=main&domain=calendar.live.com\\">Windows Live Takvim Yardımı.</a></p>
<h3 id="WLS6">Sınıf arkadaşlarıma neden anlık ileti gönderemiyorum?  </h3>

<p>Sınıf arkadaşlarınızı Windows Live Messenger için kişi listenize eklediğinizden emin olun.  Siz ve sınıf arkadaşlarınız, siz birbirinizi görüp sohbet etmeden önce insanların varlığınızı görmesine izin vermek için Windows Live Messenger Web ayarlarınızı güncellemeniz gerekebilir.</p>
<h3 id="WLS7">Windows Live Messenger\'da varlığımı nasıl etkinleştiririm?</h3>
<p>Varlığı açmak için:<br/>
<ol>
<li><a href=\\"http://settings.messenger.live.com/applications/websettings.aspx?wa=wsignin1.0\\" target=\\"_blank\\">Windows Live Messenger Web Ayarlarını açın.< /a></li>
<li>Henüz oturum açmadıysanız, Windows Live ID\'niz ile oturum açmanız gerekir.</li>
<li><strong>Web\'deki herkesin varlığımı görmesine ve bana mesaj göndermesine izin ver</strong></li> seçeneğini tıklayın.

<li><strong>Kaydet</strong></li>\'i tıklayın.
</p>
<h3 id="WLS8">Windows Live Messenger varlığım etkinleştirildiğinde neden çevrimdışı görünüyorum?</h3>
<p>Sınıf arkadaşlarınıza çevrimiçi görünmek için şunlardan emin olun:
<ul>
<li>Windows Live Messenger çalışıyor ve oturum açtınız. (Windows Live Messenger sizin için mevcut değilse, Moodle yöneticiniz bu seçeneği yüklememiş olabilir.)</li>
<li>Sınıf arkadaşlarınız sizi kişi listelerine ekledi ve siz de onların davetini kabul ettiniz.</li>
<li>İnsanların varlığınızı görmesine izin vermek için ayarlarınızı güncellediniz.</li>
</ul>

<a target=\\"_blank\\" href=\\"http://help.live.com/help.aspx?mkt=en-us&project=WL_Messengerv9&querytype=keyword&query=nogol\\">Windows Live Messenger Yardımı</a>\'na bakın. daha fazla bilgi için.
</p>
<h3 id="WLS9">Windows Live Uyarısı nedir?</h3>
<p>Uyarı, bir grup öğretmen ve öğrenciye yayınlanan bir mesajdır.  Uyarılar e-postanıza, Windows Live Messenger\'a ve mobil cihazınıza gönderilebilir.  Windows Live Alert';
