<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_ordering', language 'da', version '4.5'.
 *
 * @package     qtype_ordering
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['absoluteposition'] = 'Absolut placering.';
$string['addmultipleanswers'] = 'Tilføj {$a} flere elementer.';
$string['addsingleanswer'] = 'Tilføj et element mere.';
$string['allornothing'] = 'Alt eller ingenting';
$string['answer'] = 'Elementtekst.';
$string['correctitemsnumber'] = 'Korrekte elementer: {$a}';
$string['correctorder'] = 'Den korrekte rækkefølge for disse elementer er som følger:';
$string['defaultanswerformat'] = 'Standard svarformat.';
$string['defaultquestionname'] = 'Træk følgende elementer til den korrekte rækkefølge';
$string['draggableitemno'] = 'Flytbart element {no}';
$string['draggableitems'] = 'Flytbare elementer';
$string['duplicatesnotallowed'] = 'Duplikering af flytbare elementer er ikke tilladt. Strengen "{$a->text}" er allerede brugt i {$a->item}.';
$string['editingordering'] = 'Redigerer sorteringsspørgsmål.';
$string['gradedetails'] = 'Karakterdetaljer';
$string['gradingtype'] = 'Karaktergivningstype.';
$string['gradingtype_help'] = '**Alt eller intet**
&nbsp; Hvis alle elementer er i den korrekte position, tildeles det fulde antal point. Ellers er scoren nul.

**Absolut position**
&nbsp; Et element betragtes som korrekt, hvis det er i samme position som i det korrekte svar. Den højest mulige score for spørgsmålet er **den samme som** antallet af elementer, der vises for den studerende.

**Relativt til korrekt position**
&nbsp; Et element betragtes som korrekt, hvis det er i samme position som i det korrekte svar. Korrekte elementer modtager en score svarende til antallet af viste elementer minus én. Forkerte elementer modtager en score svarende til antallet af viste elementer minus én og minus afstanden mellem elementet og dets korrekte position. Hvis ***n*** elementer vises for den studerende, er antallet af point tilgængelige for hvert element således ***(n - 1)***, og det højeste antal point, der er tilgængelige for spørgsmålet, er ***n x (n - 1)***, hvilket er det samme som ***(n² - n)***.

**Relativt til det næste element (eksklusive det sidste)**
&nbsp; Et element betragtes som korrekt, hvis det efterfølges af det samme element som i det korrekte svar. Elementet i den sidste position kontrolleres ikke. Den højest mulige score for spørgsmålet er således **én mindre end** antallet af elementer, der vises for den studerende.

**Relativt til det næste element (inklusive det sidste)**
&nbsp; Et element betragtes som korrekt, hvis det efterfølges af det samme element som i det korrekte svar. Dette inkluderer det sidste element, som ikke må have et efterfølgende element. Den højest mulige score for spørgsmålet er således **den samme som** antallet af elementer, der vises for den studerende.

**Relativt til både de foregående og næste elementer**
&nbsp; Et element betragtes som korrekt, hvis både de foregående og næste elementer er de samme som i det korrekte svar. Det første element bør ikke have et foregående element, og det sidste element bør ikke have et efterfølgende element. Der er således to mulige point for hvert element, og den højest mulige score for spørgsmålet er **dobbelt** antallet af elementer, der vises for den studerende.

**Relativt til ALLE foregående og næste elementer**
&nbsp; Et element betragtes som korrekt, hvis det er forudgået af alle de samme elementer som i det korrekte svar, og det efterfølges af alle de samme elementer som i det korrekte svar. Rækkefølgen af de foregående elementer er ligegyldig, og det samme gælder rækkefølgen af de efterfølgende elementer. Hvis ***n*** elementer vises for den studerende, er antallet af point tilgængelige for hvert element således ***(n - 1)***, og det højeste antal point, der er tilgængelige for spørgsmålet, er ***n x (n - 1)***, hvilket er det samme som ***(n² - n)***.

**Længste ordnede delmængde**
&nbsp; Karakteren er antallet af elementer i den længste ordnede delmængde af elementer. Den højest mulige karakter er den samme som antallet af viste elementer. En delmængde skal have mindst to elementer. Delmængder behøver ikke at starte ved det første element (men det kan de), og de behøver ikke at være sammenhængende (men det kan de). Hvor der er flere delmængder af lige lang længde, vil elementer i den delmængde, der findes først, når der søges fra venstre mod højre, blive vist som korrekte. Andre elementer vil blive markeret som forkerte.

**Længste sammenhængende delmængde**
&nbsp; Karakteren er antallet af elementer i den længste sammenhængende delmængde af elementer. Den højest mulige karakter er den samme som antallet af viste elementer. En delmængde skal have mindst to elementer. Delmængder behøver ikke at starte ved det første element (men det kan de), og de SKAL VÆRE SAMMENHÆNGENDE. Hvor der er flere delmængder af lige lang længde, vil elementer i den delmængde, der findes først, når der søges fra venstre mod højre, blive vist som korrekte. Andre elementer vil blive markeret som forkerte.';
$string['highlightresponse'] = 'Markér besvarelse som korrekt eller ukorrekt.';
$string['horizontal'] = 'Horisontal';
$string['incorrectitemsnumber'] = 'Ukorrekte elementer: {$a}';
$string['layouttype'] = 'Opsætning af elementer.';
$string['layouttype_help'] = 'Vælg om elementerne skal vises vertikalt eller horisontalt.';
$string['longestcontiguoussubset'] = 'Længste sammenhængende delsæt.';
$string['longestorderedsubset'] = 'Længste ordnede delsæt.';
$string['moved'] = '{$a->item} flyttet. Ny position: {$a->position} af {$a->total}.';
$string['moveleft'] = 'Flyt til venstre.';
$string['moveright'] = 'Flyt til højre.';
$string['noresponsedetails'] = 'Beklager, ingen detaljer om besvarelsen af dette spørgsmål er tilgængelige.';
$string['noscore'] = 'Ingen score';
$string['notenoughanswers'] = 'Sorteringsspørgsmål skal have mere end {$a} svar.';
$string['notenoughsubsetitems'] = 'Et delsæt skal have mindst {$a} elementer.';
$string['numberingstyle'] = 'Nummerere valgmulighederne?';
$string['numberingstyle123'] = '1.,2.,3.,...';
$string['numberingstyleABCD'] = 'A., B., C., ...';
$string['numberingstyleIIII'] = 'I., II., III., ...';
$string['numberingstyle_desc'] = 'Standardnummereringsstil.';
$string['numberingstyle_help'] = 'Vælg nummereringsstil for flytbare elementer i dette spørgsmål.';
$string['numberingstyleabc'] = 'a., b., c., ...';
$string['numberingstyleiii'] = 'i., ii., iii., ...';
$string['numberingstylenone'] = 'Ingen nummerering';
$string['partialitemsnumber'] = 'Delvist korrekte elementer: {$a}';
$string['pluginname'] = 'Sortering';
$string['pluginname_help'] = 'Flere elementer vises i en blandet rækkefølge. Elementerne kan trækkes til en meningsfuld rækkefølge';
$string['pluginname_link'] = 'question/type/ordering';
$string['pluginnameadding'] = 'Tilføjer et sorteringsspørgsmål.';
$string['pluginnameediting'] = 'Redigerer et sorteringsspørgsmål.';
$string['pluginnamesummary'] = 'Sæt rodede elementer i en meningsfuld rækkefølge.';
$string['positionx'] = 'Position {$a}';
$string['privacy:preference:gradingtype'] = 'Karaktertypen';
$string['privacy:preference:layouttype'] = 'Opsætning af elementer.';
$string['privacy:preference:numberingstyle'] = 'Nummereringsstilen for valgmulighederne.';
$string['privacy:preference:selectcount'] = 'Antallet af valg.';
$string['privacy:preference:selecttype'] = 'Typen af elementvalg.';
$string['privacy:preference:showgrading'] = 'Om karakterdetaljer skal vises.';
$string['regradeissuenumitemschanged'] = 'Antallet af flytbare elementer er ændret.';
$string['relativeallpreviousandnext'] = 'Relativt til ALLE tidligere og næste elementer.';
$string['relativenextexcludelast'] = 'Relativt til næste element (med undtagelse af det sidste).';
$string['relativenextincludelast'] = 'Relateret til det næste element (inklusive sidste).';
$string['relativeonepreviousandnext'] = 'Relateret til både de foregående og de næste elementer.';
$string['relativetocorrect'] = 'Relateret til korrekt position';
$string['removeeditor'] = 'Fjern HTML-editor';
$string['removeitem'] = 'Fjern trækbart element.';
$string['scoredetails'] = 'Her er scores for hvert element i dette svar:';
$string['selectall'] = 'Vælg alle elementer';
$string['selectcontiguous'] = 'Vælg et sammenhængende undersæt af elementer.';
$string['selectcount'] = 'Størrelse på undersæt.';
$string['selectcount_help'] = 'Antallet af elementer, der vil blive vist, når spørgsmålet vises i en quiz.';
$string['selectrandom'] = 'Vælg et tilfældigt undersæt af elementer.';
$string['selecttype'] = 'Elementvalgtype.';
$string['selecttype_help'] = 'Vælg, om alle elementer eller et undersæt af elementerne skal vises.';
$string['showgrading'] = 'Bedømmelsesdetaljer.';
$string['showgrading_help'] = 'Vælg om detaljer om scoreberegningen skal vises eller skjules, når en student gennemgår et svar på dette sorteringsspørgsmål.';
$string['vertical'] = 'Vertikal';
