<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'studentquiz', language 'da', version '4.5'.
 *
 * @package     studentquiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['after_answering_end_date'] = 'Denne StudentQuiz lukkede for besvarelse den {$a}.';
$string['after_submission_end_date'] = 'Denne StudentQuiz lukkede for indsendelse af spørgsmål den {$a}.';
$string['anonymous_user_name'] = 'Anonym bruger #{$a}';
$string['answeringndbeforestart'] = 'Fristen for besvarelse kan ikke angives før åbningsdatoen for besvarelse';
$string['api_state_change_error_content'] = 'Dette spørgsmål kan ikke slettes, fordi det er blevet godkendt.';
$string['api_state_change_error_title'] = 'Fejl ved sletning af spørgsmål';
$string['api_state_change_success_content'] = 'Spørgsmålets status/synlighed blev ændret med succes';
$string['api_state_change_success_title'] = 'Succes';
$string['approve'] = 'Godkend';
$string['approve_toggle'] = 'Afvis/Godkend';
$string['approved'] = '✓';
$string['approved_column_name'] = 'Godkendt';
$string['approved_veryshort'] = 'A';
$string['approveselectedscheck'] = 'Er du sikker på, at du vil godkende/afvise følgende spørgsmål?<br /><br />{$a}';
$string['average_column_name'] = 'Gennemsnit';
$string['back_to_course_button'] = 'Tilbage til kursus';
$string['before_answering_end_date'] = 'Denne StudentQuiz lukker for besvarelser den {$a}.';
$string['before_answering_start_date'] = 'Åben for besvarelse fra {$a}.';
$string['before_submission_end_date'] = 'Denne StudentQuiz lukker for spørgsmålsindsendelse den {$a}.';
$string['before_submission_start_date'] = 'Åben for indsendelse af spørgsmål fra {$a}.';
$string['cachedef_permissionssync'] = 'StudentQuiz tilladelsessynkroniseringssporing';
$string['cannotcapturecommenthistory'] = 'Kan ikke fange kommentarhistorikregistrering';
$string['changecurrentstate'] = 'Skift tilstand fra <b>{$a}</b> til:';
$string['changestateto'] = 'Skift tilstand(e) til:';
$string['collapseall'] = 'Fold alle kommentarer sammen';
$string['collapsecomment'] = 'Fold kommentar sammen';
$string['comment'] = 'Kommentar';
$string['comment_author'] = 'Forfatter';
$string['comment_cannot_update'] = 'Kan ikke opdatere kommentar';
$string['comment_column_name'] = 'Kommentarer';
$string['comment_error'] = 'Venligst kommenter';
$string['comment_error_unsaved'] = 'Vil du gemme denne kommentar først?';
$string['comment_help'] = 'Skriv en kommentar';
$string['comment_help_help'] = 'Skriv en kommentar til spørgsmå';
$string['comment_veryshort'] = 'C';
$string['commentcolumnexplainprivate'] = 'Antal offentlige kommentarer. En blå baggrund betyder, at du har mindst én ulæst kommentar.';
$string['commentcolumnexplainpublic'] = 'Kommentarhistorik';
$string['commenthistory'] = 'Kommentarhistorik';
$string['commentplural'] = 'Kommentarer';
$string['completiondetail:approved'] = 'Minimum antal unikke godkendte spørgsmål: {$a}';
$string['completiondetail:point'] = 'Minimum antal point: {$a}';
$string['completiondetail:published'] = 'Minimum antal unikke oprettede spørgsmål: {$a}';
$string['completionpoint'] = 'Minimum antal påkrævede point:';
$string['completionpointgroup'] = 'Kræv point';
$string['completionpointgroup_help'] = 'Studerende optjener point som specificeret under Ranglisteindstillingerne, f.eks. 10 point for at oprette et spørgsmål, 5 point for en lærers godkendelse af en elevs spørgsmål, 3 point for en elevs vurdering af et andet spørgsmål. Ved at indtaste en numerisk værdi i feltet vil studerende kun fuldføre StudentQuiz\'en, når de har akkumuleret tilstrækkeligt med point.';
$string['completionquestionapproved'] = 'Minimum antal unikke godkendte spørgsmål påkrævet:';
$string['completionquestionapprovedgroup'] = 'Kræv oprettede godkendte spørgsmål';
$string['completionquestionapprovedgroup_help'] = 'Det minimum antal unikke spørgsmål, som en studerende skal oprette og få godkendt, før aktiviteten er fuldført. Denne indstilling kan bruges sammen med enten spørgsmålpublikationen "Kræver godkendelse før publicering" eller "Auto-godkendelse", men vil ikke være lige så effektiv med sidstnævnte indstilling, hvis auto-godkendte spørgsmål senere skjules, slettes eller på anden måde fjernes.';
$string['completionquestionpublished'] = 'Minimum antal unikke oprettede spørgsmål påkrævet:';
$string['completionquestionpublishedgroup'] = 'Kræv publicerede spørgsmål';
$string['completionquestionpublishedgroup_help'] = 'Det mindste antal unikke spørgsmål, som en studerende skal oprette, før aktiviteten er fuldført. Bemærk, at dette er en simpel numerisk kontrol - to spørgsmål, der er skjulte/slettede, er stadig blevet oprettet.';
$string['confirmdeletecomment'] = 'Er du sikker på, at du vil slette denne kommentar?';
$string['createnewquestion'] = 'Opret nyt spørgsmål';
$string['createnewquestionfirst'] = 'Opret første spørgsmål';
$string['creator_anonym_fullname'] = 'Anonym studerende';
$string['current_of_total'] = '{$a->current} af {$a->total}';
$string['current_state'] = 'Nuværende tilstand';
$string['daily'] = 'daglig';
$string['delete'] = 'Slet';
$string['deletecomment'] = 'Slet kommentar';
$string['deleted'] = 'Slettet';
$string['deletedbyauthor'] = 'Dette indlæg blev slettet den {$a}.';
$string['deletedbyuser'] = 'Dette indlæg blev slettet af <a href="{$a->profileurl}" >{$a->fullname}</a> den {$a->date}.';
$string['deletedcomment'] = 'Slettet indlæg.';
$string['deleteorphanedquestions'] = 'Slet forældreløse spørgsmål';
$string['deleteorphanedquestionserrormdlquestion'] = '<font color="red">fejl</font>: kunne ikke slette fra mdl_question tabel. Spørgsmålet er sandsynligvis i brug et sted.<br><font color="red">fejl</font>: sletning fra mdl_studentquiz* tabeller er blevet sprunget over.<br>';
$string['deleteorphanedquestionserrorstudentquiz'] = '<font color="red">fejl</font>: kunne ikke slette fra mdl_studentquiz* tabellerne.<br>';
$string['deleteorphanedquestionsfullmessage'] = 'Spørgsmål, der er blevet ikke-godkendt/markeret til sletning:<ul>{$a->fullmessage}</ul>';
$string['deleteorphanedquestionsnonefound'] = '<b>ingen fundet</b>';
$string['deleteorphanedquestionsquestioninfo'] = '<li><b>{$a->name}</b> (Spørgsmålstype: {$a->qtype}, ID: {$a->questionid})</li>';
$string['deleteorphanedquestionssmallmessage'] = 'StudentQuiz: Opgave til at slette forældreløse spørgsmål er blevet kørt';
$string['deleteorphanedquestionssubject'] = 'StudentQuiz';
$string['deleteorphanedquestionssuccessmdlquestion'] = '<font color="green">succes</font>: slettet fra mdl_question tabelen<br>';
$string['deleteorphanedquestionssuccessstudentquiz'] = '<font color="green">succes</font>: slettet fra mdl_studentquiz* tabellerne.<br>';
$string['describe_already_deleted'] = 'Denne kommentar er allerede slettet.';
$string['describe_not_creator'] = 'Dette er ikke din kommentar.';
$string['describe_out_of_time_delete'] = 'Denne kommentar er for sent til at slette.';
$string['describe_out_of_time_edit'] = 'Denne kommentar er for sent til at redigere.';
$string['descriptioncofstate'] = 'Spørgsmål sat til \'{$a->state}\'';
$string['descriptionofstatenew'] = 'Spørgsmål gemt (\'Kladde\')';
$string['descriptionofvisibility'] = 'Spørgsmålssynlighed sat til \'{$a->visibility}\'';
$string['difficulty_all_column_name'] = 'Fællesskabets sværhedsgrad';
$string['difficulty_level_column_name'] = 'Sværhedsgrad';
$string['difficulty_title'] = 'Sværhedsgradsindikator';
$string['editcomment'] = 'Rediger kommentar';
$string['editedcomment_last_edit'] = 'Sidst redigeret:';
$string['editedcommenthistory'] = 'Redigeret af {$a->lastesteditedcommentauthorname} den {$a->lastededitedcommenttime}';
$string['editedcommenthistorylinktext'] = 'Historik';
$string['editedcommenthistorywithuserlink'] = 'Redigeret af <a href="{$a->lastesteditedcommentauthorprofileurl}">{$a->lastesteditedcommentauthorname}</a> den {$a->lastededitedcommenttime}';
$string['editorplaceholder'] = 'Indtast din kommentar her ...';
$string['emailautomationnote'] = 'Bemærk venligst, at dette er en automatisk systembesked - denne e-mailadresse overvåges ikke.';
$string['emailcommentaddedbody'] = 'Kære {$a->recepientname},

Dit spørgsmål \'{$a->questionname}\' i StudentQuiz aktiviteten \'{$a->modulename}\' i kurset \'{$a->coursename}\' er blevet kommenteret af \'{$a->actorname}\' kl. \'{$a->timestamp}\'.

Kommentaren er: \'{$a->commenttext}\'

Du kan gennemgå dette spørgsmål på: {$a->questionurl}.';
$string['emailcommentaddedsmall'] = 'Dit spørgsmål \'{$a->questionname}\' er blevet kommenteret af {$a->actorname}.';
$string['emailcommentaddedsubject'] = 'Spørgsmålet er blevet kommenteret: {$a->questionname}';
$string['emailcommentdeletedbody'] = 'Kære {$a->recepientname},

Kommentaren fra \'{$a->commenttime}\' til dit spørgsmål \'{$a->questionname}\' i StudentQuiz aktivitet \'{$a->modulename}\' i kurset \'{$a->coursename}\' er blevet slettet af \'{$a->actorname}\' kl. \'{$a->timestamp}\'.

Kommentaren var: \'{$a->commenttext}\'

Du kan gennemgå dette spørgsmål på: {$a->questionurl}.';
$string['modulename_link'] = 'mod/studentquiz/view';
