<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'pt', version '4.5'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Conteúdo \'Quem somos\'';
$string['aboutuscontentsetting_desc'] = 'Nesta configuração, pode adicionar conteúdo Rich Text que será exibido na página Quem somos.';
$string['aboutusdisabled'] = 'A página Quem somos está desativada para este site. Não existe nada para ver aqui.';
$string['aboutusheading'] = 'Quem somos';
$string['aboutuslinkpositionboth'] = 'Adicionar uma hiperligação para a página Quem somos na nota de rodapé e no ícone (ponto de interrogação) do rodapé';
$string['aboutuslinkpositionfooter'] = 'Adicionar uma hiperligação para a página Quem somos no ícone (ponto de interrogação) do rodapé';
$string['aboutuslinkpositionfootnote'] = 'Adicionar uma hiperligação para a página Quem somos na nota de rodapé';
$string['aboutuslinkpositionnone'] = 'Não mostrar automaticamente a hiperligação para a página Quem somos';
$string['aboutuslinkpositionsetting'] = 'Posição da hiperligação para Quem somos';
$string['aboutuslinkpositionsetting_desc'] = 'Nesta configuração, pode definir se deve ser adicionada automaticamente à página do Moodle uma hiperligação para a para a página Quem somos. Caso não queira mostrar a hiperligação automaticamente, pode adicionar manualmente uma hiperligação para \'{$a->url}\' em qualquer lugar do Moodle.';
$string['aboutuspagetitledefault'] = 'Quem somos';
$string['aboutuspagetitlesetting'] = 'Título da página Quem somos';
$string['aboutuspagetitlesetting_desc'] = 'Nesta configuração, pode definir o título da página Quem somos. Este texto também será usado como texto de hiperligação para a página Quem somos se configurar adequadamente a \'Posição da hiperligação para Quem somos\'.';
$string['accessibilitydeclarationcontentsetting'] = 'Conteúdo da página de declaração de acessibilidade';
$string['accessibilitydeclarationcontentsetting_desc'] = 'Nesta configuração, pode adicionar conteúdo Rich Text que será apresentado na página de declaração de acessibilidade.';
$string['accessibilitydeclarationdisabled'] = 'A página de informação sobre acessibilidade está desativada para este site. Não existe nada para ver aqui.';
$string['accessibilitydeclarationheading'] = 'Declaração de acessibilidade';
$string['accessibilitydeclarationlinkpositionboth'] = 'Adicionar uma hipeligação para a página de declaração de acessibilidade na nota de rodapé e no ícone de rodapé (ponto de interrogação).';
$string['accessibilitydeclarationlinkpositionfooter'] = 'Adicione uma hiperligação para a página de declaração de acessibilidade no rodapé (ícone de ponto de interrogação).';
$string['accessibilitydeclarationlinkpositionfootnote'] = 'Adicionar uma hiperligação para a página de declaração de acessibilidade na nota de rodapé.';
$string['accessibilitydeclarationlinkpositionnone'] = 'Não mostrar automaticamente a hiperligação para a página de declaração de acessibilidade';
$string['accessibilitydeclarationlinkpositionsetting'] = 'Posição da hiperligação paraa  página de declaração de acessibilidade';
$string['accessibilitydeclarationlinkpositionsetting_desc'] = 'Nesta configuração, pode definir se deve ser adicionada automaticamente uma hiperligação para a página de declaração de acessibilidade à página do Moodle. Caso não pretenda exibir a hiperligação automaticamente, pode adicionar manualmente uma hiperligação para \'{$a->url}\' em qualquer parte do Moodle.';
$string['accessibilitydeclarationpagetitledefault'] = 'Declaração de acessibilidade';
$string['accessibilitydeclarationpagetitlesetting'] = 'Título da página de declaração de acessibilidade';
$string['accessibilitydeclarationpagetitlesetting_desc'] = 'Nesta configuração, pode definir o título da página de declaração de acessibilidade. Este texto também será usado como texto de hiperligação para a página de declaração de acessibilidade se configurar adequadamente a \'Posição da hiperligação para a página de declaração de acessibilidade\'.';
$string['accessibilitydeclarationtab'] = 'Declaração';
$string['accessibilitysupportanonymouscheckbox'] = 'Prefiro enviar o meu pedido de suporte da acessibilidade de forma anónima.';
$string['accessibilitysupportanonymousemail'] = 'anonimo@email.invalido';
$string['accessibilitysupportanonymoususer'] = 'Utilizador anónimo';
$string['accessibilitysupportcontentdefault'] = '<p>Se tiver algum feedback sobre a acessibilidade ou quiser comunicar uma barreira, utilize o formulário abaixo.</p><p>Utiliza alguma tecnologia de apoio, como leitores de ecrã, lupas, controlo de voz ou software de reconhecimento de voz? Em caso afirmativo, especifique quais. Para nos ajudar a processar o seu pedido, pode permitir que o formulário envie automaticamente as seguintes informações juntamente com a sua mensagem: o URL de onde se encontrava quando abriu este formulário de suporte (denominado "referência") e algumas informações sobre o seu navegador.</p>';
$string['accessibilitysupportcontentsetting'] = 'Conteúdo da página de suporte da acessibilidade';
$string['accessibilitysupportcontentsetting_desc'] = 'Nesta configuração, pode adicionar conteúdo Rich Text que será apresentado na página de suporte da acessibilidade, juntamente com um formulário para enviar feedback sobre a acessibilidade ou para comunicar um obstáculo na acessibilidade.';
$string['accessibilitysupportdefaultsubject'] = 'Feedback sobre acessibilidade';
$string['accessibilitysupportdisabled'] = 'A página de suporte da acessibilidade está desativada para este site. Não existe nada para ver aqui.';
$string['accessibilitysupportheading'] = 'Página de suporte da acessibilidade';
$string['accessibilitysupportlinkpositionboth'] = 'Adicionar uma hipeligação para a página de suporte da acessibilidade na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['accessibilitysupportlinkpositionfooter'] = 'Adicionar uma hipeligação para a página de suporte da acessibilidade no ícone de rodapé (ponto de interrogação)';
$string['accessibilitysupportlinkpositionfootnote'] = 'Adicionar uma hipeligação para a página de suporte da acessibilidade na nota de rodapé';
$string['accessibilitysupportlinkpositionnone'] = 'Não mostrar automaticamente a hiperligação para a página de suporte da acessibilidade';
$string['accessibilitysupportlinkpositionsetting'] = 'Posição da hiperligação da página de suporte da acessibilidade';
$string['accessibilitysupportlinkpositionsetting_desc'] = 'Nesta configuração, pode definir se deve ser adicionada automaticamente uma hiperligação para a página de suporte da acessibilidade à página do Moodle. Caso não pretenda exibir a hiperligação automaticamente, pode adicionar manualmente uma hiperligação para \'{$a->url}\' em qualquer parte do Moodle.';
$string['accessibilitysupportmessagenotsent'] = 'Não foi possível enviar o seu pedido de suporte da acessibilidade.';
$string['accessibilitysupportmessagesent'] = 'O seu pedido de suporte da acessibilidade foi enviado.';
$string['accessibilitysupportmessagetryagain'] = 'Por favor, tente mais tarde.';
$string['accessibilitysupportmessagetryalternative'] = 'Por favor, tente mais tarde ou envie um e-mail diretamente para <a href="mailto:{$a}">{$a}</a>.';
$string['accessibilitysupportpagesrlinktitledefault'] = 'Obter suporte da acessibilidade';
$string['accessibilitysupportpagesrlinktitlesetting'] = 'Título da hiperligação para o leitor de ecrã na página de suporte da acessibilidade';
$string['accessibilitysupportpagesrlinktitlesetting_desc'] = 'Nesta configuração, pode definir o título da hiperligação nos leitores de ecrã da página de suporte da acessibilidade. Este texto será utilizado como texto do atalho, sendo apenas apresentado para leitores de ecrã.';
$string['accessibilitysupportpagetitledefault'] = 'Suporte da acessibilidade';
$string['accessibilitysupportpagetitlesetting'] = 'Título da página de suporte da acessibilidade';
$string['accessibilitysupportpagetitlesetting_desc'] = 'Nesta configuração, pode definir o título da página de suporte da acessibilidade. Este texto também será utilizado como hiperligação para a página de suporte da acessibilidade se configurar adequadamente a opção \'Posição da hiperligação da página de suporte da acessibilidade\'.';
$string['accessibilitysupportrecaptcha'] = 'Adicionar reCAPTCHA à página de suporte da acessibilidade';
$string['accessibilitysupportrecaptcha_desc'] = 'Com esta configuração, controla se um reCAPTCHA é, ou não, adicionado à página de suporte de acessibilidade. Isto serve para evitar o spam e o abuso do formulário de suporte de acessibilidade, tal como acontece no <a href="{$a->support}">formulário de suporte do Moodle</a>. No entanto, a adição de reCAPTCHAs cria uma barreira de acessibilidade adicional para os utilizadores que utilizam leitores de ecrã ou outras tecnologias de apoio, o que pode ser contraproducente neste caso. Portanto, escolha com cuidado se pretende ativar esta configuração. Tenha em atenção também que, mesmo que esteja ativada, a reCAPTCHA não será apresentada até que defina as chaves API necessárias nas <a href="{$a->settings}">configurações de autenticação</a>.';
$string['accessibilitysupportsentforanonymoususer'] = 'O utilizador solicitou que este feedback sobre a acessibilidade fosse enviado de forma anónima.';
$string['accessibilitysupportsubmit'] = 'Submeter';
$string['accessibilitysupporttab'] = 'Página de suporte';
$string['accessibilitysupporttechinfo'] = 'Informação técnica';
$string['accessibilitysupporttechinfocheckbox'] = 'Concordo em enviar as seguintes informações técnicas juntamente com a minha mensagem.';
$string['accessibilitysupporttechinfolabel'] = 'Informações técnicas a enviar juntamente';
$string['accessibilitysupporttechinforeferrer'] = 'Página de referência';
$string['accessibilitysupporttechinfosysinfo'] = 'Informação do sistema';
$string['accessibilitysupportuserfirstname'] = 'Acessibilidade';
$string['accessibilitysupportuserlastname'] = 'suporte';
$string['accessibilitysupportusermail'] = 'E-mail do responsável pelo suporte da acessibilidade';
$string['accessibilitysupportusermail_desc'] = 'Aqui define o endereço de e-mail para o qual os pedidos de suporte da acessibilidade devem ser enviados. Se deixar este campo em branco, os pedidos serão enviados para o contacto configurado na página de <a href="{$a->url}">suporte do site</a>.';
$string['accessibilitysupportusermailsubject'] = 'Pedido de suporte da acessibilidade';
$string['activitybrandingtab'] = 'Identidade visual da atividade';
$string['activityiconcoloradministrationsetting'] = 'Cor do ícone de atividade para "Administração"';
$string['activityiconcoloradministrationsetting_desc'] = 'A cor do ícone de atividade para "Administração"';
$string['activityiconcolorassessmentsetting'] = 'Cor do ícone de atividade para "Avaliação"';
$string['activityiconcolorassessmentsetting_desc'] = 'A cor do ícone de atividade para "Avaliação"';
$string['activityiconcolorcollaborationsetting'] = 'Cor do ícone de atividade para "Colaboração"';
$string['activityiconcolorcollaborationsetting_desc'] = 'A cor do ícone de atividade para "Colaboração"';
$string['activityiconcolorcommunicationsetting'] = 'Cor do ícone de atividade para "Comunicação"';
$string['activityiconcolorcommunicationsetting_desc'] = 'A cor do ícone de atividade para "Comunicação"';
$string['activityiconcolorcontentsetting'] = 'Cor do ícone de atividade para "Conteúdo"';
$string['activityiconcolorcontentsetting_desc'] = 'A cor do ícone de atividade para "Conteúdo"';
$string['activityiconcolorinteractivecontentsetting'] = 'Cor do ícone de atividade para "Conteúdo interativo"';
$string['activityiconcolorinteractivecontentsetting_desc'] = 'A cor do ícone de atividade para "Conteúdo interativo"';
$string['activityiconcolorinterfacesetting'] = 'Cor do ícone de atividade para "Interface"';
$string['activityiconcolorinterfacesetting_desc'] = 'A cor do ícone de atividade para "Interface"';
$string['activityiconcolorsheading'] = 'Cores do ícone de atividade';
$string['activitynavigationsetting'] = 'Navegação na atividade e na secção';
$string['activitynavigationsetting_desc'] = 'Com esta configuração, estão visíveis os elementos para navegar entre as atividades/recursos anterior e seguinte, bem como o menu pendente para aceder a uma atividade/recurso específico. Além disso, nas disciplinas que utilizam o modo "uma secção por página", são também apresentados elementos semelhantes para as secções anterior e seguinte. Elementos de interface como estes já existiam no Boost do Moodle até à versão 3.11, mas foram removidos na versão 4.0. Com o Boost Union, podes trazê-los de volta.';
$string['activitypurposeadministration'] = 'Administração';
$string['activitypurposeassessment'] = 'Avaliação';
$string['activitypurposecollaboration'] = 'Colaboração';
$string['activitypurposecommunication'] = 'Comunicação';
$string['activitypurposecontent'] = 'Conteúdo';
$string['activitypurposeheading'] = 'Propósitos do ícone de atividade';
$string['activitypurposeheading_desc'] = 'Com estas configurações, pode substituir a cor de fundo do ícone da atividade, que é definida pela finalidade da atividade (e que é uma funcionalidade codificada em cada atividade).';
$string['activitypurposeheadingtechnote'] = 'Nota técnica: Devido à forma como o core do Moodle implementa os objetivos das atividades e as suas cores, os objetivos das atividades só podem ser alterados via CSS pelo Boost Union. Atualmente, todas as áreas do core do Moodle que exibem ícones de atividades coloridos devem estar cobertas. Se encontrar alguma área ou módulo de terceiros que continue a exibir as cores dos objetivos das atividades sem alterações, por favor, reporte em {$a}.';
$string['activitypurposeinteractivecontent'] = 'Conteúdo interativo';
$string['activitypurposeinterface'] = 'Interface';
$string['activitypurposeother'] = 'Outro';
$string['additionalresourcesfileurlpersistent'] = 'URL (persistente)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (revisto)';
$string['additionalresourcesheading'] = 'Recursos adicionais';
$string['additionalresourceslistsetting'] = 'Lista de recursos adicionais';
$string['additionalresourceslistsetting_desc'] = 'Lista de ficheiros que carregou para a área de recursos adicionais. Os URL fornecidos podem ser utilizados para criar hiperligações para estes ficheiros no seu CSS personalizado, em notas de rodapé ou em qualquer lugar onde necessite de utilizar ficheiros carregados, mas não possa carregá-los diretamente no texto.';
$string['additionalresourcessetting'] = 'Recursos adicionais';
$string['additionalresourcessetting_desc'] = 'Com esta configuração, pode adicionar recursos extra ao tema. A vantagem de enviar ficheiros para esta área é que podem ser entregues sem a necessidade de verificar se o utilizador está autenticado. Por este motivo, apenas deve adicionar ficheiros não críticos, que devem ser de acesso livre para todos e não necessitam de autenticação para proteção. Assim que enviar pelo menos um ficheiro para esta área e guardar as configurações, aparecerá abaixo uma lista com o URL que pode utilizar para referenciar um ficheiro específico.';
$string['addpreferredlangsetting'] = 'Adicionar atalho para o idioma preferido ao menu de idiomas';
$string['addpreferredlangsetting_desc'] = 'Com esta configuração, pode adicionar uma opção "Definir idioma preferido" ao menu de idiomas dentro do menu do utilizador. Obviamente, esta definição só será processada se a opção <a href="{$a->url1}">Mostrar menu de idiomas</a> estiver ativada e se pelo menos um segundo <a href="{$a->url2}">pacote linguístico</a> estiver instalado e <a href="{$a->url3}">disponível para seleção</a>.';
$string['administrationtab'] = 'Administração';
$string['allowaccessibilitysupportwithoutlogin'] = 'Permitir página de suporte da acessibilidade sem autenticação';
$string['allowaccessibilitysupportwithoutlogin_desc'] = 'Se esta configuração estiver ativada, a página de suporte da acessibilidade será apresentada para os utilizadores que não estiverem autenticados. Se desativada, apenas os utilizadores autenticados poderão aceder à página de suporte da acessibilidade.';
$string['allowanonymoussubmitssetting'] = 'Permitir envios anónimos para a página de suporte';
$string['allowanonymoussubmitssetting_desc'] = 'Com esta configuração, permite que o utilizador envie anonimamente feedback sobre a acessibilidade através da página de suporte da acessibilidade. Os utilizadores podem decidir se pretendem, ou não, enviar feedback de forma anónima (sem informar o seu nome de utilizador e endereço de e-mail).';
$string['allowsendtechinfoalongsetting'] = 'Permitir o envio de informação técnica';
$string['allowsendtechinfoalongsetting_desc'] = 'Com esta configuração, pode permitir que o utilizador envie informações técnicas na página de suporte da acessibilidade. Os utilizadores podem decidir se pretendem, ou não, enviar informações técnicas.';
$string['alternativelogolinkurlsetting'] = 'URL da hiperligação alternativa para o logótipo';
$string['alternativelogolinkurlsetting_desc'] = 'Com esta configuração, pode definir um URL alternativo que será utilizado como hiperligação no logótipo da barra de navegação. Pode utilizar esta configuração para, por exemplo, direcionar para o site da sua organização em vez da página inicial do Moodle, mantendo assim uma barra de navegação homogénea em todos os sistemas da sua organização.';
$string['always'] = 'Sempre';
$string['auto'] = 'Automaticamente';
$string['backgroundimagepositionsetting'] = 'Posição da imagem de fundo';
$string['backgroundimagepositionsetting_desc'] = 'Com esta configuração, controla o posicionamento da imagem de fundo dentro da janela do navegador. O primeiro valor representa a posição horizontal e o segundo, a posição vertical.';
$string['backgroundimagesetting'] = 'Imagem de fundo';
$string['backgroundimagesetting_desc'] = 'Aqui pode carregar uma imagem personalizada para exibir como fundo do site. A imagem de fundo que carregar aqui irá substituir a imagem de fundo nos ficheiros de predefinição do seu tema.';
$string['backgroundimagesheading'] = 'Imagens de fundo gerais';
$string['backtotop'] = 'Voltar ao topo';
$string['backtotopbuttonsetting'] = 'Botão Voltar ao topo';
$string['backtotopbuttonsetting_desc'] = 'Com esta configuração, um botão "Voltar ao topo" aparecerá no canto inferior direito da página assim que o utilizador fizer scroll para baixo. Um botão semelhante já existia no Boost do Moodle até à versão 3.11, mas foi removido na versão 4.0. Com o Boost Union, podes trazê-lo de volta.';
$string['blockdrawerwidthsetting'] = 'Largura do painel dos blocos';
$string['blockdrawerwidthsetting_desc'] = 'Pode alterar a largura do painel dos blocos do Moodle sem ter de modificar manualmente o SCSS. Por predefinição, o Moodle utiliza uma largura máxima de conteúdo de 315px. Pode inserir outros valores em píxeis, como 400px, mas os valores com outras unidades, como a percentagem ou a largura da janela de visualização, não funcionarão.';
$string['blockregionfooterwidth'] = 'Largura do bloco para a região \'Rodapé\'';
$string['blockregionfooterwidth_desc'] = 'Com esta configuração, pode definir a largura da região do bloco \'Rodapé\'. Pode escolher entre a largura total, a largura do conteúdo da disciplina e a largura hero.';
$string['blockregionoutsidebottomwidth'] = 'Largura da região do bloco para a região \'Externa (fundo)\'';
$string['blockregionoutsidebottomwidth_desc'] = 'Com esta configuração, pode definir a largura da região do bloco "Externa (inferior)" que é apresentada por baixo do conteúdo principal. Pode escolher entre a largura total, a largura do conteúdo da disciplina e a largura hero.';
$string['blockregionoutsideleftwidth'] = 'Largura da região do bloco para a região \'Externa (esquerda)\'';
$string['blockregionoutsideleftwidth_desc'] = 'Com esta configuração, pode definir a largura da região do bloco "Externa (esquerda)" que é apresentada no lado direito da área de conteúdo principal. Por predefinição, o Boost Union utiliza uma largura de 300px. Pode indicar outros valores em píxeis, como 200px, mas também pode indicar um valor em percentagem, como 10%, ou um valor de largura da janela de visualização, como 10vw.';
$string['blockregionoutsiderightwidth'] = 'Largura da região do bloco para a região \'Externa (direita)\'';
$string['blockregionoutsiderightwidth_desc'] = 'Com esta configuração, pode definir a largura da região do bloco "Externa (direita)" que é apresentada no lado direito da área de conteúdo principal. Por predefinição, o Boost Union utiliza uma largura de 300px. Pode indicar outros valores em píxeis, como 200px, mas também pode indicar um valor em percentagem, como 10%, ou um valor de largura da janela de visualização, como 10vw.';
$string['blockregionoutsidetopwidth'] = 'Largura da região do bloco para a região \'Externa (topo)\'';
$string['blockregionoutsidetopwidth_desc'] = 'Com esta configuração, pode definir a largura da região do bloco "Externa (superior)" que é apresentada na parte superior da página. Pode escolher entre a largura total, a largura do conteúdo da disciplina e a largura hero.';
$string['blockregionsforlayout'] = 'Regiões de bloco adicional para a estrutura \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Com esta configuração, pode ativar regiões de bloco adicionais para a estrutura \'{$a}\'.';
$string['blockregionsheading'] = 'Regiões de bloco adicional';
$string['blocksgeneralheading'] = 'Geral dos blocos';
$string['blockstab'] = 'Blocos';
$string['boost_union:configure'] = 'Para poder configurar o tema como utilizador não administrativo.';
$string['boost_union:editregioncontentlower'] = 'Permite editar a região de blocos de Conteúdo (inferior)';
$string['boost_union:editregioncontentupper'] = 'Permite editar a região de blocos de Conteúdo (superior)';
$string['boost_union:editregionfootercenter'] = 'Permite editar a região de blocos do Rodapé (centro)';
$string['boost_union:editregionfooterleft'] = 'Permite editar a região de blocos do Rodapé (esquerda)';
$string['boost_union:editregionfooterright'] = 'Permite editar a região de blocos do Rodapé (direita)';
$string['boost_union:editregionheader'] = 'Permite editar a região de blocos do Cabeçalho';
$string['boost_union:editregionoffcanvascenter'] = 'Permite editar a região de blocos Fora do ecrã (centro)';
$string['boost_union:editregionoffcanvasleft'] = 'Permite editar a região de blocos Fora do ecrã (esquerda)';
$string['boost_union:editregionoffcanvasright'] = 'Permite editar a região de blocos Fora do ecrã (direita)';
$string['boost_union:editregionoutsidebottom'] = 'Permite editar a região de blocos Externa (inferior)';
$string['boost_union:editregionoutsideleft'] = 'Permite editar a região de blocos externa (esquerda)';
$string['boost_union:editregionoutsideright'] = 'Permite editar a região de blocos Externa (direita)';
$string['boost_union:editregionoutsidetop'] = 'Permite editar a região de blocos Externa (superior)';
$string['boost_union:viewhintcourseguestenrol'] = 'Ser capaz de visualizar uma dica sobre a inscrição de visitante numa disciplina visível.';
$string['boost_union:viewhintcourseselfenrol'] = 'Permite ver uma dica de autoinscrição sem restrições numa disciplina visível.';
$string['boost_union:viewhintinhiddencourse'] = 'Permite ver uma dica numa disciplina oculta.';
$string['boost_union:viewregioncontentlower'] = 'Permite ver a região de blocos de Conteúdo (inferior)';
$string['boost_union:viewregioncontentupper'] = 'Permite ver a região de blocos de Conteúdo (superior)';
$string['boost_union:viewregionfootercenter'] = 'Permite ver a região de blocos do Rodapé (centro)';
$string['boost_union:viewregionfooterleft'] = 'Permite ver a região de blocos do Rodapé (esquerda)';
$string['boost_union:viewregionfooterright'] = 'Permite ver a região de blocos do Rodapé (direita)';
$string['boost_union:viewregionheader'] = 'Permite ver a região de blocos do Cabeçalho';
$string['boost_union:viewregionoffcanvascenter'] = 'Permite ver a região de blocos Fora do ecrã (centro)';
$string['boost_union:viewregionoffcanvasleft'] = 'Permite ver a região de blocos Fora do ecrã (esquerda)';
$string['boost_union:viewregionoffcanvasright'] = 'Permite ver a região de blocos Fora do ecrã (direita)';
$string['boost_union:viewregionoutsidebottom'] = 'Permite ver a região de blocos Externa (inferior)';
$string['boost_union:viewregionoutsideleft'] = 'Permite ver a região de blocos externa (esquerda)';
$string['boost_union:viewregionoutsideright'] = 'Permite ver a região de blocos Externa (direita)';
$string['boost_union:viewregionoutsidetop'] = 'Permite ver a região de blocos Externa (superior)';
$string['bootstrapcolordangersetting'] = 'Cor Bootstrap para "Perigo"';
$string['bootstrapcolordangersetting_desc'] = 'A cor Bootstrap para "Perigo"';
$string['bootstrapcolorinfosetting'] = 'Cor Bootstrap para "Informação"';
$string['bootstrapcolorinfosetting_desc'] = 'A cor Bootstrap para "Informação"';
$string['bootstrapcolorsheading'] = 'Cores Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Cor Bootstrap para "Sucesso"';
$string['bootstrapcolorsuccesssetting_desc'] = 'A cor Bootstrap para "Sucesso"';
$string['bootstrapcolorwarningsetting'] = 'Cor Bootstrap para "Aviso"';
$string['bootstrapcolorwarningsetting_desc'] = 'A cor Bootstrap para "Aviso"';
$string['bootstrapdangercolor'] = 'Cor de Perigo';
$string['bootstrapdarkcolor'] = 'Cor escura';
$string['bootstrapinfocolor'] = 'Cor de Informação';
$string['bootstraplightcolor'] = 'Cor clara';
$string['bootstrapnone'] = 'Sem cor Bootstrap';
$string['bootstrapprimarycolor'] = 'Cor primária';
$string['bootstrapsecondarycolor'] = 'Cor secundária';
$string['bootstrapsuccesscolor'] = 'Cor de Sucesso';
$string['bootstrapwarningcolor'] = 'Cor de Aviso';
$string['brandcolorsheading'] = 'Cores da marca';
$string['breadcrumbsheading'] = 'Caminhos';
$string['cachedef_flavours'] = 'Aspetos que se aplicam à página de uma determinada categoria para o utilizador atual.';
$string['cachedef_fontawesomeicons'] = 'Mapa de ícones do FontAwesome';
$string['cachedef_hooksuppress'] = 'Supressões de hooks';
$string['cachedef_smartmenu_items'] = 'Item de menu inteligente';
$string['cachedef_smartmenus'] = 'Menus inteligentes';
$string['cachedef_touchiconsios'] = 'Ficheiros de ícones táteis para iOS.';
$string['calendarbrandingheading'] = 'Geral da identidade visual do calendário';
$string['calendarbrandingtab'] = 'Identidade visual do calendário';
$string['calendareventcolorbordersetting'] = 'Cor da borda do tipo de evento do calendário "{$a}"';
$string['calendareventcolorbordersetting_desc'] = 'A cor do tipo de evento do calendário "{$a}" que é utilizada para as margens.';
$string['calendareventcolormainsetting'] = 'Cor principal do tipo de evento de calendário "{$a}"';
$string['calendareventcolormainsetting_desc'] = 'A cor principal do tipo de evento de calendário "{$a}", que é utilizada para ícones e fundos.';
$string['calendareventcolorsheading'] = 'Tipo de evento do calendário: {$a}';
$string['calendareventtypecategory'] = 'Categoria';
$string['calendareventtypecourse'] = 'Disciplina';
$string['calendareventtypegroup'] = 'Grupo';
$string['calendareventtypeother'] = 'Outro';
$string['calendareventtypesite'] = 'Site';
$string['calendareventtypeuser'] = 'Utilizador';
$string['calendariconscolorsetting'] = 'Cores dos ícones do calendário';
$string['calendariconscolorsetting_desc'] = 'A cor de alguns ícones utilizados nas visualizações do calendário. A cor predefinida é o azul, mas isto pode entrar em conflito com as cores da identidade visual do calendário que definiu anteriormente.';
$string['categorybreadcrumbs'] = 'Mostrar o caminho da categoria no cabeçalho da disciplina';
$string['categorybreadcrumbs_desc'] = 'Por predefinição, o caminho de navegação entre as categorias de disciplinas não é apresentado no cabeçalho das páginas da disciplina. Com esta configuração, pode apresentar o caminho de navegação entre as categorias de disciplinas no cabeçalho, acima do nome da disciplina.';
$string['categoryindextab'] = 'Índice de categorias / Página inicial';
$string['categorylistingheading'] = 'Lista de categorias';
$string['categorylistingpresentation'] = 'Apresentação da lista de categorias';
$string['categorylistingpresentation_boxlist'] = 'Lista de caixas';
$string['categorylistingpresentation_desc'] = 'Com esta configuração, pode modificar a aparência da lista de categorias nas páginas de índice de categorias e na página inicial do site. Em alternativa à forma como o Moodle as apresenta por predefinição, pode apresentar a lista de categorias como uma lista de caixas atualizada.';
$string['categorylistingpresentation_nochange'] = 'Conforme apresentado pelo Moodle';
$string['categorylistingpresentation_note'] = 'Nota: Se ativou a configuração "Apresentação por lista de disciplinas" acima, recomendamos que ative também esta configuração. Foram concebidas para funcionar em conjunto.';
$string['choosereadme'] = 'O tema Boost Union é um tema melhorado descendente do Boost, que visa, por um lado, tornar o Boost mais configurável e, por outro, fornecer funcionalidades adicionais úteis para a utilização diária do Moodle por administradores, professores e alunos. O Boost Union é mantido pela Moodle an Hochschulen e.V., em cooperação com a ssystems GmbH, juntamente com a bdecent GmbH e a lern.link GmbH.';
$string['closeoffcanvas'] = 'Fechar painel de Fora do ecrã';
$string['configtitle'] = 'Boost Union';
$string['configtitleaccessibility'] = 'Acessibilidade';
$string['configtitlecontent'] = 'Conteúdo';
$string['configtitlefeel'] = 'Aparência';
$string['configtitleflavours'] = 'Aspetos';
$string['configtitlefunctionality'] = 'Funcionalidade';
$string['configtitlelook'] = 'Visual';
$string['configtitlesnippets'] = 'Excertos SCSS';
$string['contactcontentsetting'] = 'Conteúdo da página de contactos';
$string['contactcontentsetting_desc'] = 'Nesta configuração, pode adicionar conteúdo Rich Text que será apresentado numa página de contacto (que não é a mesma que a página "Contactar suporte do site" integrada do Moodle).';
$string['contactdisabled'] = 'A página de contactos está desativada para este site. Não há nada para ver aqui.';
$string['contactheading'] = 'Contacto';
$string['contactlinkpositionboth'] = 'Adicionar uma hiperligação para a página de contacto na nota de rodapé e no ícone de rodapé (ponto de interrogação).';
$string['contactlinkpositionfooter'] = 'Adicionar uma hiperligação para a página de contacto no rodapé (ícone de ponto de interrogação).';
$string['contactlinkpositionfootnote'] = 'Adicione uma hiperligação para a página de contacto na nota de rodapé.';
$string['contactlinkpositionnone'] = 'Não mostrar automaticamente a hiperligação para a página de contacto';
$string['contactlinkpositionsetting'] = 'Posição da hiperligação da página de contacto';
$string['contactlinkpositionsetting_desc'] = 'Nesta configuração, pode definir se deve ser adicionada automaticamente uma hiperligação para a página de contactos à página do Moodle. Caso não pretenda exibir um atalho automaticamente, pode adicionar manualmente uma hiperligação para \'{$a->url}\' em qualquer parte do Moodle.';
$string['contactpagetitledefault'] = 'Contacto';
$string['contactpagetitlesetting'] = 'Título da página de contacto';
$string['contactpagetitlesetting_desc'] = 'Nesta configuração, pode definir o título da página de contacto. Este texto será também utilizado como hiperligação para a página de contacto, caso configure adequadamente a opção "Posição da hiperligação da página de contacto".';
$string['contentwidthheading'] = 'Largura do conteúdo';
$string['coursecardscolumncount'] = 'Colunas de cartões de disciplinas';
$string['coursecardscolumncount_desc'] = 'A grelha de cartões de disciplina será apresentada de forma responsiva e as suas colunas ajustar-se-ão automaticamente em ecrãs mais pequenos. Com esta configuração, controla o número máximo de colunas na grelha de cartões de disciplinas em ecrãs maiores. Definir o número máximo de colunas para 2 em vez de 3 pode fazer com que os cartões de disciplinas pareçam mais espaçosos e menos congestionados. Também é possível definir o número máximo de colunas para 1, o que transformará a lista de disciplinas numa lista vertical de cartões.';
$string['coursecontentmaxwidthsetting'] = 'Largura máxima do conteúdo da disciplina';
$string['coursecontentmaxwidthsetting_desc'] = 'Pode alterar a largura do conteúdo da disciplina no Moodle sem ter de modificar manualmente o SCSS. Esta largura é utilizada como largura da página da disciplina e em diversas atividades. Por predefinição, o Moodle utiliza uma largura máxima de 830px para o conteúdo da disciplina. Pode indicar outros valores em píxeis, como 1200px, mas também pode indicar um valor em percentagem, como 100%, ou um valor de largura da janela de visualização, como 90vw.';
$string['courseheaderheading'] = 'Cabeçalho da disciplina';
$string['courseheaderimageenabled'] = 'Mostrar a imagem da disciplina no cabeçalho da disciplina';
$string['courseheaderimageenabled_desc'] = 'A imagem da disciplina (que pode ser carregada nas configurações da disciplina) é apresentada no cabeçalho da disciplina. As imagens das disciplinas são aí mostradas, para além da página "Minhas disciplinas", onde são sempre apresentadas.';
$string['courseheaderimagefallback'] = 'Imagem alternativa do cabeçalho da disciplina';
$string['courseheaderimagefallback_desc'] = 'Se carregar uma imagem nesta configuração, esta será utilizada como imagem alternativa e apresentada no cabeçalho da disciplina no caso de nenhuma imagem ser carregada nas configurações da disciplina em questão. Se não carregar uma imagem aqui, a imagem do cabeçalho da disciplina só será apresentada se for carregada uma imagem nas configurações dessa disciplina específica.';
$string['courseheaderimageheight'] = 'Altura da imagem do cabeçalho da disciplina';
$string['courseheaderimageheight_desc'] = 'Com esta configuração, controla a altura da imagem do cabeçalho da disciplina.';
$string['courseheaderimagelayout'] = 'Disposição da imagem do cabeçalho da disciplina';
$string['courseheaderimagelayout_desc'] = 'Com esta configuração, controla a estrutura da imagem do cabeçalho da disciplina e do título da disciplina.';
$string['courseheaderimagelayoutheadingabove'] = 'Título da disciplina acima da imagem da disciplina';
$string['courseheaderimagelayoutstackeddark'] = 'Título da disciplina sobreposto à imagem da disciplina (tipo de letra branco para imagens de fundo escuras)';
$string['courseheaderimagelayoutstackedlight'] = 'Título da disciplina sobreposto à imagem da disciplina (tipo de letra preto para imagens de fundo claras)';
$string['courseheaderimageposition'] = 'Posição da imagem do cabeçalho da disciplina';
$string['courseheaderimageposition_desc'] = 'Com esta configuração, controla o posicionamento da imagem do cabeçalho da disciplina dentro do caixa da imagem do cabeçalho. O primeiro valor representa a posição horizontal e o segundo, a posição vertical.';
$string['courseindexcompletioninfoposition'] = 'Posição do indicador de conclusão da atividade';
$string['courseindexcompletioninfoposition_desc'] = 'Escolha a posição onde a indicação da conclusão será apresentada. <em>Fim da linha</em> apresenta o indicador da conclusão predefinido no final da linha no índice da disciplina. <em>Início da linha</em> apresenta o indicador da conclusão predefinido no início da linha no índice da disciplina. <em>Cor do ícone</em> não apresenta o indicador da conclusão predefinido, mas codifica a informação de conclusão como fundo do ícone do módulo da disciplina.';
$string['courseindexcompletioninfopositionendofline'] = 'Fim da linha';
$string['courseindexcompletioninfopositioniconcolor'] = 'Cor do ícone';
$string['courseindexcompletioninfopositionstartofline'] = 'Início da linha';
$string['courseindexdrawerwidthsetting'] = 'Largura do painel do índice da disciplina';
$string['courseindexdrawerwidthsetting_desc'] = 'Pode alterar a largura do painel do índice das disciplinas do Moodle sem ter de modificar manualmente o SCSS. Por predefinição, o Moodle utiliza uma largura de 285px para a largura do índice das disciplinas. Pode inserir outros valores em píxeis, como 320px, mas os valores com outras unidades, como a percentagem ou a largura da janela de visualização, não funcionarão.';
$string['courseindexheading'] = 'Índice da disciplina';
$string['courseindexmodiconenabled'] = 'Mostrar ícones de tipo de atividade no índice da disciplina';
$string['courseindexmodiconenabled_desc'] = 'Quando ativada, o ícone correspondente ao tipo de atividade é apresentado à frente da linha no índice, juntamente com o título da atividade. Desta forma, o tipo de atividade da disciplina substitui o indicador da conclusão da disciplina, que é movido do início para o fim da linha no índice, ou é colorido com a cor correspondente ao estado da conclusão.';
$string['courseistingprogressstyle'] = 'Estilo do progresso da conclusão da disciplina';
$string['courseistingprogressstyle_bar'] = 'Barra de progressão';
$string['courseistingprogressstyle_desc'] = 'Com esta configuração, controla como é apresentado o progresso de conclusão da disciplina. Pode escolher entre um texto simples em percentagem ou uma barra de progresso.';
$string['courseistingprogressstyle_percentage'] = 'Percentagem de texto';
$string['courselistingcontacts'] = 'Contacto da disciplina';
$string['courselistingfields'] = 'Classificação da disciplina';
$string['courselistinggoto'] = 'Ir para a disciplina';
$string['courselistingheading'] = 'Lista de disciplinas';
$string['courselistinghowcategory'] = 'Mostrar a categoria da disciplina na lista de disciplinas';
$string['courselistinghowcategory_desc'] = 'Com esta configuração, controla se a categoria da disciplina é, ou não, apresentada na lista de disciplinas.';
$string['courselistinghowenrolicons'] = 'Mostrar ícones de inscrição na disciplina na lista de disciplinas';
$string['courselistinghowenrolicons_desc'] = 'Com esta configuração, controla se os ícones de inscrição na disciplina são, ou não, apresentados na lista de disciplinas.';
$string['courselistinghowgoto'] = 'Mostrar o  botão Ir para na lista de disciplinas';
$string['courselistinghowgoto_desc'] = 'Com esta configuração, controla se o botão "Ir para a disciplina" será, ou não, apresentado na lista de disciplinas. Se esta configuração estiver desativada, o utilizador poderá ainda aceder à disciplina clicando no título ou na imagem da disciplina.';
$string['courselistinghowimage'] = 'Mostrar imagem da disciplina na lista de disciplinas';
$string['courselistinghowimage_desc'] = 'Com esta configuração, controla se a imagem da disciplina é, ou não, apresentada na lista de disciplinas.';
$string['courselistinghowpopup'] = 'Mostrar detalhes numa janela pop-up na lista de disciplinas';
$string['courselistinghowpopup_desc'] = 'Com esta configuração, controla se o botão "Detalhes da disciplina" será, ou não, apresentado na lista de disciplinas. Ao clicar neste botão, o utilizador poderá abrir uma janela pop-up com os detalhes da disciplina, incluindo o resumo, os contactos e os campos da disciplina. Esta janela pop-up irá exibir estas informações independentemente de a ter ativada ou não no próprio cartão/linha da disciplina.';
$string['courselistinghowprogress'] = 'Mostrar progresso da conclusão da disciplina na lista de disciplinas';
$string['courselistinghowprogress_desc'] = 'Com esta configuração, controla se o progresso da conclusão da disciplina é, ou não, apresentado na lista de disciplinas.';
$string['courselistinghowshortname'] = 'Mostrar o nome curto da disciplina na lista de disciplinas';
$string['courselistinghowshortname_desc'] = 'Com esta configuração, controla se o nome curto da disciplina é, ou não, apresentado na lista de disciplinas.';
$string['courselistingnosummary'] = 'Esta disciplina não tem resumo.';
$string['courselistingpopup'] = 'Detalhes';
$string['courselistingpresentation'] = 'Apresentação por lista de disciplinas';
$string['courselistingpresentation_cards'] = 'Cartões de disciplinas';
$string['courselistingpresentation_desc'] = 'Com esta configuração, pode modificar a aparência da lista de disciplinas nas páginas de índice de categorias e na página inicial do site. Em alternativa à forma como o Moodle as apresenta por predefinição, pode apresentar a lista de disciplinas como cartões (semelhantes aos cartões na página "Minhas disciplinas") ou como uma lista de disciplinas (semelhante à lista de disciplinas na página "Minhas disciplinas").';
$string['courselistingpresentation_list'] = 'Lista de disciplinas';
$string['courselistingpresentation_nochange'] = 'Conforme apresentado pelo Moodle';
$string['courselistingpresentation_note'] = 'Nota: Se ativar os cartões de disciplinas ou as listas de disciplinas, a configuração <a href="{$a->url1}">disciplinas por página</a> será ainda respeitada e controlará quantos cartões/linhas serão apresentados. No entanto, a configuração <a href="{$a->url2}">número máximo de disciplinas com descrição</a> deixará de ter qualquer efeito – todos as disciplinas serão apresentadas com todos os detalhes. Tenha cuidado para não definir <a href="{$a->url1}">disciplinas por página</a> com um valor demasiado elevado para evitar tempos de carregamento longos em páginas com muitas disciplinas.';
$string['courselistingselectfields'] = 'Selecione os campos da disciplina que pretende visualizar na lista de disciplinas.';
$string['courselistingselectfields_desc'] = 'Com esta configuração, pode selecionar quais os campos personalizados específicos da disciplina que serão apresentados na lista de disciplinas. Se nenhum for selecionado, não será apresentado nenhum campo.';
$string['courselistingselectfields_nofield'] = 'Com esta configuração, pode selecionar quais os campos personalizados específicos do curso que serão apresentados na lista de disciplinas. Ainda não existe nenhum campo personalizado de disciplina utilizável. Aceda a <a href="{$a->url}">{$a->linktitle}</a> e crie primeiro um campo personalizado de disciplina.';
$string['courselistingshowcontacts'] = 'Mostrar os contactos da disciplina na lista de disciplinas';
$string['courselistingshowcontacts_desc'] = 'Com esta configuração, controla se as fotografias dos contactos da disciplina serão, ou não, apresentadas na lista de disciplinas. Nota: as fotos dos contactos são apresentadas juntamente com a imagem da disciplina; não é, portanto, possível exibir os contactos da disciplina sem exibir a imagem da disciplina.';
$string['courselistingshowfields'] = 'Mostrar os campos da disciplina na lista de disciplinas';
$string['courselistingshowfields_desc'] = 'Com esta configuração, controla se os campos personalizados da disciplina são, ou não, apresentados na lista de disciplinas.';
$string['courselistingstylefields'] = 'Estilo dos campos da disciplina na lista de disciplinas';
$string['courselistingstylefields_desc'] = 'Com esta configuração, pode controlar a forma como os campos personalizados da disciplina são apresentados na lista de disciplinas. Pode escolher entre mostrá-los como texto (apresentando o valor do campo juntamente com o nome do campo como etiqueta) ou como uma medalha (apresentando apenas o valor do campo).';
$string['courselistingummary'] = 'Resumo da disciplina';
$string['courselistingviewprofile'] = 'Ver perfil';
$string['coursemanagementheading'] = 'Gestão da disciplina';
$string['courseoverviewheading'] = 'Bloco de visão global da disciplina';
$string['courseoverviewshowcourseimagessetting'] = 'Mostrar imagens da disciplina';
$string['courseoverviewshowcourseimagessetting_desc'] = 'Com esta configuração, pode controlar se a imagem da disciplina é, ou não, visível dentro do bloco de visão global da disciplina. É possível escolher uma configuração diferente para a visualização em cartão, a visualização em resumo e a visualização em lista.';
$string['courseoverviewshowprogresssetting'] = 'Mostrar progresso da conclusão da disciplina';
$string['courseoverviewshowprogresssetting_desc'] = 'Com esta configuração, controla se o progresso da conclusão da disciplina é, ou não, apresentado no bloco de visão global da disciplina.';
$string['courserelatedhintsforstudentsheading'] = 'Dicas para alunos relacionadas com a disciplina';
$string['courserelatedhintsforteachersheading'] = 'Dicas para professores relacionadas com a disciplina';
$string['coursestab'] = 'Disciplinas';
$string['coursetab'] = 'Disciplina';
$string['cssh5pheading'] = 'CSS Raw para H5P';
$string['cssh5psetting'] = 'CSS Raw para H5P';
$string['cssh5psetting_desc'] = 'Utilize este campo para fornecer o código CSS que será aplicado à apresentação do conteúdo H5P pelos módulos mod_h5p e mod_hvp. Consulte os tipos de conteúdo H5P para encontrar os seletores CSS necessários.';
$string['customfontsfileurlpersistent'] = 'URL (persistente)';
$string['customfontsfileurlrevisioned'] = 'URL (revisto)';
$string['customfontsheading'] = 'Tipos de letra personalizados';
$string['customfontslistsetting'] = 'Lista dos tipos de letra personalizados';
$string['customfontslistsetting_desc'] = 'Lista de tipos de letra que carregou para a área de ficheiros de tipos de letra personalizados. Os excertos de CSS fornecidos podem ser utilizados para adicionar estes tipos de letra ao seu SCSS personalizado. Tenha em atenção que terá de lidar manualmente com o valor do formato do tipo de letra, bem como com as propriedades CSS `font-family`, `font-style` e `font-weight`, uma vez que o Boost Union ainda não consegue analisar os ficheiros de tipos de letra.';
$string['customfontssetting'] = 'Tipos de letra personalizados';
$string['customfontssetting_desc'] = 'Com esta configuração, pode carregar tipos de letra personalizados para o tema. A vantagem de carregar tipos de letra nesta área de ficheiros é que podem ser apresentadas sem a necessidade de verificar se o utilizador está ligado e podem ser utilizadas como tipos de letra instalados localmente em todo o site. Assim que carregar pelo menos um tipo de letra nesta área de ficheiros e guardar as configurações, será apresentada uma lista abaixo, contendo excertos de código CSS que pode utilizar como modelo para referenciar tipos de letra específicos no seu SCSS personalizado.';
$string['dashboardtab'] = 'Painel do utilizador / Minhas disciplinas';
$string['dontchange'] = 'Não alterar nada';
$string['drawerwidthheading'] = 'Largura do painel';
$string['emailbrandinghtmldemobody'] = '<p>O corpo do e‑mail começa aqui.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra..</p><p>O corpo do e‑mail termina aqui.</p>';
$string['emailbrandinghtmlheading'] = 'Pré-visualização de e-mail HTML';
$string['emailbrandinghtmlintro'] = 'Esta é uma pré-visualização de um e-mail HTML baseada nos prefixos e sufixos definidos no pacote linguítico.';
$string['emailbrandinghtmlnopreview'] = 'Os e-mails em HTML ainda não foram personalizados dentro desta funcionalidade. Os e-mails serão compostos e enviados normalmente.';
$string['emailbrandinginstruction'] = 'Como fazer';
$string['emailbrandinginstruction0'] = 'Com esta funcionalidade do Boost Union, pode aplicar a sua marca a todos os e-mails enviados pelo Moodle.';
$string['emailbrandinginstructionli1'] = 'Aceda à página de <a href="{$a->url}" target="_blank">personalização do idioma</a> para abrir o pacote linguístico <em>{$a->lang}</em> para edição.';
$string['emailbrandinginstructionli2'] = 'Procure e modifique estas strings no pacote linguístico do tema <code>theme_boost_union</code>:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Este excerto será adicionado <em>no início/antes do corpo</em> de todos os <em>e-mails HTML</em> que o Moodle enviar.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Este excerto será adicionado <em>no fina /após o corpo</em> de todos os <em>e-mails HTML</em> que o Moodle enviar.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Este excerto será adicionado <em>no início/antes do corpo</em> de todos os <em>e-mails em texto simples</em> que o Moodle enviar.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Este excerto será adicionado <em>no final/após o corpo</em> de todos os <em>e-mails em texto simples</em> que o Moodle enviar.';
$string['emailbrandinginstructionli3'] = 'Guarde as alterações no pacote linguístico.';
$string['emailbrandinginstructionli4'] = 'Volte a esta página e consulte abaixo as pré-visualizações do e-mail.';
$string['emailbrandingintroheading'] = 'Introdução';
$string['emailbrandingintronote'] = 'Atenção: Esta é uma funcionalidade avançada que usa algumas soluções alternativas para fornecer opções de marca para e-mails. Siga as instruções cuidadosamente.';
$string['emailbrandingpitfalls'] = 'Alertas';
$string['emailbrandingpitfalls0'] = 'Ao utilizar esta funcionalidade, existem alguns cuidados dos quais deve estar ciente:';
$string['emailbrandingpitfallsli1'] = 'É obrigatório que modifique as strings do pacote linguístico do <em>idioma predefinido atual</em> deste site. Mesmo que tenha vários pacotes linguísticos instalados, apenas as alterações ao idioma predefinido terão efeito.';
$string['emailbrandingpitfallsli2'] = 'Não é possível respeitar o idioma do destinatário. Assim, deve utilizar termos neutros em relação ao idioma nos excertos de identidade visual da sua mensagem de e-mail.';
$string['emailbrandingpitfallsli3'] = 'Se alterar o idioma predefinido do site no futuro, terá de migrar as strings do pacote linguístico modificado para o novo pacote linguístico predefinido.';
$string['emailbrandingpitfallsli4'] = 'Nos e-mails em texto simples, são automaticamente adicionadas uma quebra de linha e uma linha em branco após o prefixo e antes do sufixo. Isto garante que o sufixo e o prefixo não são diretamente inseridos no corpo do e-mail.';
$string['emailbrandingpitfallsli5'] = 'Nos e-mails HTML, o prefixo e o sufixo são adicionados diretamente antes e acima do corpo do e-mail. Isto facilita o trabalho com as tags HTML, no entanto terá de lidar manualmente com o espaçamento em torno do corpo do e-mail.';
$string['emailbrandingpitfallsli6'] = 'Nos e-mails HTML, pode abrir uma tag HTML no excerto de prefixo e fechá-la no excerto de sufixo sem problemas. Lembre-se apenas de criar um HTML válido no e-mail resultante.';
$string['emailbrandingtab'] = 'Identidade visual do E-mail';
$string['emailbrandingtextdemobody'] = 'O corpo do e‑mail começa aqui.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

O corpo do e‑mail termina aqui';
$string['emailbrandingtextheading'] = 'Pré-visualização de e-mail em texto simples';
$string['emailbrandingtextintro'] = 'Esta é uma pré-visualização de um e-mail em texto simples baseada nos prefixos e sufixos definidos no pacote linguítico.';
$string['emailbrandingtextnopreview'] = 'Os e-mails em em texto simples ainda não foram personalizados dentro desta funcionalidade. Os e-mails serão compostos e enviados normalmente.';
$string['enableaboutussetting'] = 'Ativar a página Sobre nós';
$string['enableaccessibilitydeclarationsetting'] = 'Ativar de declaração de acessibilidade';
$string['enableaccessibilitydeclarationsetting_desc'] = 'Com esta configuração, pode ativar uma página para a declaração de acessibilidade. Comportar-se-á exatamente como as outras <a href="{$a->url}">páginas estáticas</a> no Boost Union.';
$string['enableaccessibilitysupportfooterbuttonsetting'] = 'Ativar botão de suporte da acessibilidade no rodapé';
$string['enableaccessibilitysupportfooterbuttonsetting_desc'] = 'Com esta configuração, pode adicionar um atalho para a página de suporte da acessibilidade como um ícone flutuante de acessibilidade acima do ícone do rodapé (ponto de interrogação).';
$string['enableaccessibilitysupportsetting'] = 'Ativar a página de suporte da acessibilidade';
$string['enableaccessibilitysupportsetting_desc'] = 'Com esta configuração, pode ativar uma página de suporte da acessibilidade. Funcionará de forma semelhante à <a href="{$a->url}">página de suporte do Moodle</a>.';
$string['enablebuiltinsnippets'] = 'Ativar excertos integrados';
$string['enablebuiltinsnippets_desc'] = 'Com esta configuração, pode ativar ou desativar os excertos de código SCSS integrados que acompanham o código-fonte do Boost Union. Se desativar esta opção, todos os trechos de código SCSS integrados serão ignorados e nunca serão adicionados à pilha SCSS.';
$string['enablecontactsetting'] = 'Ativar página de contacto';
$string['enablefooterbutton'] = 'Ativar rodapé';
$string['enablefooterbutton_desc'] = 'Com "rodapé", entende-se o círculo com o ponto de interrogação na parte inferior da página.<br />Ao clicar nele, o utilizador visualiza uma sobreposição. Dependendo da configuração do site, o Moodle apresenta vários atalhos (como "Documentação desta página" ou "Resumo de retenção de dados") nesta sobreposição.<br />Com esta configuração, pode controlar se o botão do rodapé na parte inferior da página deve ser apresentado ou ocultado.';
$string['enablefooterbutton_note'] = 'Nota: O conteúdo da configuração principal do Moodle <a href="{$a->url}">additionalhtmlfooter</a> é apresentado no rodapé por predefinição. No entanto, se selecionar "Ocultar em todos os dispositivos" para ocultar o rodapé por completo, o conteúdo de \'additionalhtmlfooter\' já não será apresentado em lado nenhum. Para contornar esta limitação, o Boost Union moverá o conteúdo de \'additionalhtmlfooter\' para a parte inferior da página.';
$string['enablefooterbuttonboth'] = 'Ativar em computadores, tablets e dispositivos móveis';
$string['enablefooterbuttondesktop'] = 'Ativar apenas em computadores e tablets, ocultar em dispositivos móveis (conforme apresentado pelo Moodle)';
$string['enablefooterbuttonhidden'] = 'Ocultar em todos os dispositivos';
$string['enablefooterbuttonmobile'] = 'Ativar apenas em dispositivos móveis, ocultar em computadores e tablets';
$string['enablehelpsetting'] = 'Ativar página de ajuda';
$string['enableimprintsetting'] = 'Ativar página de informações legais';
$string['enablemaintenancesetting'] = 'Ativar página de informação de manutenção';
$string['enableofferssetting'] = 'Ativar página de ofertas';
$string['enablepage1setting'] = 'Ativar página genérica 1';
$string['enablepage2setting'] = 'Ativar página genérica 2';
$string['enablepage3setting'] = 'Ativar página genérica 3';
$string['enableuploadedsnippets'] = 'Ativar carregamento de excertos';
$string['enableuploadedsnippets_desc'] = 'Com esta configuração, pode ativar ou desativar o carregamento de excertos de código SCSS aqui nas configurações do Boost Union. Se desativar esta opção, o carregamento de excertos de código SCSS não será possível e todos os excertos de código SCSS carregados anteriormente serão ignorados e nunca serão adicionados à pilha SCSS.';
$string['error:infobannerdismissnonotdismissible'] = 'O banner informativo indicado não pode ser fechado';
$string['error:infobannerdismissnonotvalid'] = 'informativo indicado não é válido';
$string['error:smartmenusmenuitemnotfound'] = 'Item de menu inteligente não encontrado';
$string['error:smartmenusmenunotfound'] = 'Menu inteligente não encontrado';
$string['extscssgithubfilepath_example'] = 'Exemplo: Se conseguires ver o ficheiro no teu GitHub em https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, o caminho será <em>/extscss.scss</em>.';
$string['extscssgithubpostfilepath'] = 'Caminho do ficheiro Post SCSS no GitHub';
$string['extscssgithubpostfilepath_desc'] = 'O caminho dentro do repositório privado do GitHub onde está localizado o ficheiro Post SCSS.';
$string['extscssgithubprefilepath'] = 'Caminho do ficheiro Pré SCSS no GitHub';
$string['extscssgithubprefilepath_desc'] = 'O caminho dentro do repositório privado do GitHub onde está localizado o ficheiro Pré SCSS.';
$string['extscssgithubrepo'] = 'Repositório da API do GitHub para o SCSS externo';
$string['extscssgithubrepo_desc'] = 'O repositório privado do Github onde se encontram os ficheiros SCSS.';
$string['extscssgithubrepo_example'] = 'Exemplo: Se conseguir ver o ficheiro no seu GitHub em https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, o repositório será <em>moodle-theme_boost_union-extscsstest</em>.';
$string['extscssgithubtoken'] = 'Token da API do GitHub para o SCSS externo';
$string['extscssgithubtoken_desc'] = 'O token da API do GitHub que será usado para obter o código SCSS do repositório GitHub privado indicado.';
$string['extscssgithubtoken_docs'] = 'Acede às tuas <a href="https://github.com/settings/tokens">definições de tokens do GitHub</a> para gerar um token e ver a documentação oficial.';
$string['extscssgithubuser'] = 'Utilizador da API do GitHub para o SCSS externo';
$string['extscssgithubuser_desc'] = 'O utilizador ou organização do GitHub que é proprietário do repositório privado.';
$string['extscssgithubuser_example'] = 'Exemplo: Se conseguir ver o ficheiro no seu GitHub em https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, o utilizador será <em>moodle-an-hochschulen</em>.';
$string['extscssheading'] = 'SCSS externo';
$string['extscssheading_desc'] = 'Além das configurações SCSS básicas acima referidas, o Boost Union pode carregar SCSS a partir de origem externa. É incluído antes do código SCSS definido anteriormente, o que significa que pode gerir uma base de código SCSS externa centralizada e ainda modificá-la com adições SCSS locais.';
$string['extscssheading_drop'] = 'Se o Boost Union não conseguir obter o ficheiro SCSS externo por qualquer motivo, irá simplesmente ignorá-lo para evitar problemas com a compilação do SCSS e interfaces de utilizador quebradas.';
$string['extscssheading_instr'] = 'Instruções:';
$string['extscssheading_prepost'] = 'Tal como as configurações do Raw SCSS acima, o SCSS externo está dividido em duas partes: Pré-SCSS e Pós-SCSS. O Pré-SCSS pode ser utilizado para inicializar variáveis SCSS, enquanto o Pós-SCSS é utilizado para o seu código SCSS atual.';
$string['extscssheading_sources'] = 'Pode configurar o Boost Union para procurar o ficheiro SCSS externo a partir de um URL com de acesso público (que será acedido e obtido com um pedido cURL não autenticado) ou de um repositório privado do Github (que será acedido e obtido com um token da API do Github).';
$string['extscssheading_structure'] = 'O ficheiro do SCSS externo deve ser fornecido como um ficheiro de texto simples, sem cabeçalhos ou rodapés, contendo apenas o código SCSS.';
$string['extscssheading_task'] = 'Existe uma <a href="{$a}">tarefa agendada theme_boost_union\\task\\purge_cache</a> que está desativada por defeito, mas que pode ativar se quiser que o Boost Union procure e compile periodicamente o código SCSS externo.';
$string['extscsssource'] = 'Origem do SCSS externo';
$string['extscsssource_desc'] = 'Selecione a origem de onde pretende obter o SCSS externo.';
$string['extscsssourcedownload'] = 'URL público para descarregamento';
$string['extscsssourcegithub'] = 'Repositório privado do Github';
$string['extscsssourcenone'] = 'Nenhum';
$string['extscssurlpost'] = 'URL de descarregamento do Post SCSS externo';
$string['extscssurlpost_desc'] = 'O URL público de onde o Post SCSS externo deve ser obtido.';
$string['extscssurlpre'] = 'URL de descarregamento do Pré SCSS externo';
$string['extscssurlpre_desc'] = 'O URL público de onde o Pré SCSS externo deve ser obtido.';
$string['extscssvalidationsetting'] = 'Validação do SCSS externo';
$string['extscssvalidationsetting_desc'] = 'Se esta configuração estiver ativada, o SCSS externo será validado para verificar se pode ser compilado antes de ser adicionado à pilha SCSS. O código SCSS externo que não possa ser compilado será ignorado silenciosamente e não será utilizado. No entanto, esta validação é apenas executada no código SCSS externo, e não na pilha SCSS combinada que seria o resultado da integração do SCSS externo. Isto significa que, assim que utilizar variáveis SCSS do core do Moodle ou do Bootstrap no seu SCSS externo, terá de desativar a validação e verificar por si próprio se o código SCSS é válido para evitar problemas na interface.';
$string['faviconheading'] = 'Favicon';
$string['faviconheading_desc'] = 'Atenção: o Boost Union tem o seu próprio sistema de carregamento de favicon e não utiliza o favicon da <a href="{$a}">configuração de favicon do Moodle</a>. <br />O Boost Union permite, em particular, substituir o favicon carregado dentro das suas variantes.';
$string['faviconsetting'] = 'Favicon';
$string['faviconsetting_desc'] = 'Pode carregar uma imagem personalizada (formato . ico ou . png) que o navegador irá exibir como favicon do seu site Moodle. Caso não seja carregado nenhum favicon personalizado, será utilizado o favicon predefinido do Moodle.';
$string['flavoursactivityiconcoloradministration'] = 'Cor do ícone de atividade para "Administração"';
$string['flavoursactivityiconcoloradministration_help'] = 'Com esta configuração, o aspeto irá substituir a cor do ícone de atividade "Administração", que é definida nas configurações do visual do Boost Union.';
$string['flavoursactivityiconcolorassessment'] = 'Cor do ícone de atividade para "Avaliação"';
$string['flavoursactivityiconcolorassessment_help'] = 'Com esta configuração, o aspeto irá substituir a cor do ícone de atividade "Avaliação", que é definida nas configurações do visual do Boost Union.';
$string['flavoursactivityiconcolorcollaboration'] = 'Cor do ícone de atividade para "Colaboração"';
$string['flavoursactivityiconcolorcollaboration_help'] = 'Com esta configuração, o aspeto irá substituir a cor do ícone de atividade "Colaboração", que é definida nas configurações do visual do Boost Union.';
$string['flavoursactivityiconcolorcommunication'] = 'Cor do ícone de atividade para "Comunicação"';
$string['flavoursactivityiconcolorcommunication_help'] = 'Com esta configuração, o aspeto irá substituir a cor do ícone de atividade "Comunicação", que é definida nas configurações do visual do Boost Union.';
$string['flavoursactivityiconcolorcontent'] = 'Cor do ícone de atividade para "Conteúdo"';
$string['flavoursactivityiconcolorcontent_help'] = 'Com esta configuração, o aspeto irá substituir a cor do ícone de atividade "Conteúdo", que é definida nas configurações do visual do Boost Union.';
$string['flavoursactivityiconcolorinteractivecontent'] = 'Cor do ícone de atividade para "Conteúdo interativo"';
$string['flavoursactivityiconcolorinteractivecontent_help'] = 'Com esta configuração, o aspeto irá substituir a cor do ícone de atividade "Conteúdo interativo", que é definida nas configurações do visual do Boost Union.';
$string['flavoursactivityiconcolorinterface'] = 'Cor do ícone de atividade para "Interface"';
$string['flavoursactivityiconcolorinterface_help'] = 'Com esta configuração, o aspeto irá substituir a cor do ícone de atividade "Interface", que é definida nas configurações do visual do Boost Union.';
$string['flavoursappliesto'] = 'Aplica-se a';
$string['flavoursapplytocategories'] = 'Aplicar a categorias de disciplinas';
$string['flavoursapplytocategories_help'] = 'Define se este aspeto deve ser aplicado às categorias de disciplinas';
$string['flavoursapplytocategories_ids'] = 'Categorias de disciplinas';
$string['flavoursapplytocategories_ids_help'] = 'Aqui defines uma ou mais categorias de disciplinas às quais este aspeto deve ser aplicado. Sempre que a página Moodle estiver dentro de uma das categorias configuradas, o aspeto é aplicado.';
$string['flavoursapplytocohorts'] = 'Aplicar a grupos globais';
$string['flavoursapplytocohorts_help'] = 'Define se este aspeto deve ser aplicado aos grupos globais.';
$string['flavoursapplytocohorts_ids'] = 'Grupos globais';
$string['flavoursapplytocohorts_ids_help'] = 'Aqui, define um ou mais grupos globais específicos aos quais este aspeto deve ser aplicado. Assim que o utilizador se tornar membro de um dos grupos globais configurados, o aspeto será aplicado. <br /><br />Tenha em atenção que se definir mais do que um grupo global, não é necessário que o utilizador seja membro de todos eles ao mesmo tempo. <br /><br />Note também que, no estado atual de implementação, as categoria de grupos globais são tratadas da mesma forma que os grupos globais do sistema.';
$string['flavoursbackgroundimage'] = 'Imagem de fundo';
$string['flavoursbackgroundimage_help'] = 'Com esta configuração, irá substituir a imagem de fundo definida nas configurações do visual do Boost Union.';
$string['flavoursbackgroundimageposition'] = 'Posição da imagem de fundo';
$string['flavoursbackgroundimageposition_help'] = 'Com esta configuração, irá substituir a posição da imagem de fundo definida nas configurações do visual do Boost Union.';
$string['flavoursbacktooverview'] = 'Voltar à visão global do aspeto';
$string['flavoursbootstrapcolordanger'] = 'Cor Bootstrap para "Perigo"';
$string['flavoursbootstrapcolordanger_help'] = 'Com esta configuração, irá substituir a cor Bootstrap para "Perigo" definida nas configurações do visual do Boost Union.';
$string['flavoursbootstrapcolorinfo'] = 'Cor Bootstrap para "Informação"';
$string['flavoursbootstrapcolorinfo_help'] = 'Com esta configuração, irá substituir a cor Bootstrap para "Informação" definida nas configurações do visual do Boost Union.';
$string['flavoursbootstrapcolorsuccess'] = 'Cor Bootstrap para "Secesso"';
$string['flavoursbootstrapcolorsuccess_help'] = 'Com esta configuração, irá substituir a cor Bootstrap para "Sucesso" definida nas configurações do visual do Boost Union.';
$string['flavoursbootstrapcolorwarning'] = 'Cor Bootstrap para "Aviso"';
$string['flavoursbootstrapcolorwarning_help'] = 'Com esta configuração, irá substituir a cor Bootstrap para "Aviso" definida nas configurações do visual do Boost Union.';
$string['flavoursbrandcolor'] = 'Cor da marca';
$string['flavoursbrandcolor_help'] = 'Com esta configuração, irá substituir a cor da marca definida nas configurações do visual do Boost Union.';
$string['flavourscreateflavour'] = 'Criar aspeto';
$string['flavourscustomscss'] = 'Raw SCSS';
$string['flavourscustomscss_help'] = 'Com esta configuração, pode escrever SCSS personalizado para o aspeto. Será adicionado ao conjunto de código CSS enviado para o navegador assim que o aspeto for aplicado.';
$string['flavourscustomscsspre'] = 'Raw SCSS inicial';
$string['flavourscustomscsspre_help'] = 'Com esta configuração, pode escrever SCSS inicial personalizado para o aspeto. Será utilizado na geração do código CSS que é enviado para o navegador assim que o aspeto é aplicado.';
$string['flavoursdelete'] = 'Apagar';
$string['flavoursdeleteconfirmation'] = 'Tem mesmo a certeza de que pretende apagar o aspeto <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Apagar aspeto';
$string['flavoursdescription'] = 'Descrição';
$string['flavoursdescription_help'] = 'A descrição do aspeto é utilizada apenas internamente para permitir documentar um aspeto específico na lista de aspetos.';
$string['flavoursedit'] = 'Editar';
$string['flavourseditflavour'] = 'Editar o aspeto';
$string['flavoursfavicon'] = 'Favicon';
$string['flavoursfavicon_help'] = 'Com esta configuração, irá substituir o favicon definido nas configurações do visual do Boost Union.';
$string['flavoursflavours'] = 'Aspetos';
$string['flavoursgeneralsettings'] = 'Configurações gerais';
$string['flavoursincludesubcategories'] = 'Incluir subcategorias';
$string['flavoursincludesubcategories_help'] = 'Se for selecionada, o aspeto será também aplicado às subcategorias das categorias escolhidas.';
$string['flavourslogo'] = 'Logótipo';
$string['flavourslogo_help'] = 'Com esta configuração, o aspeto irá substituir o logótipo definido nas configurações do visual do Boost Union.';
$string['flavourslogocompact'] = 'Logótipo compacto';
$string['flavourslogocompact_help'] = 'Com esta configuração, o aspeto irá substituir o logótipo definido nas configurações do visual do Boost Union.';
$string['flavoursnavbarcolor'] = 'Cor da barra de navegação';
$string['flavoursnavbarcolor_help'] = 'Com esta configuração, o aspeto irá substituir a cor da barra de navegação definida nas configurações do visual do Boost Union.';
$string['flavoursnothingtodisplay'] = 'Ainda não foram criados aspetos. Crie o seu primeiro aspeto para dar início ao projeto.';
$string['flavoursnotificationcreated'] = 'O aspeto foi criado com sucesso.';
$string['flavoursnotificationdeleted'] = 'O aspeto foi apagado com sucesso.';
$string['flavoursnotificationedited'] = 'O aspeto foi editado com sucesso.';
$string['flavoursoverview_desc'] = '<p>Os estilos do Boost Union oferecem uma possibilidade de substituir configurações específicas da aparência do Moodle em contextos específicos. Nesta página, pode criar e gerir estilos.</p><p>Dentro de cada estilo, define se ele deve ser aplicado a categorias específicas de disciplinas ou a grupos globais específicos. Depois, durante cada renderização de página do Moodle, o Boost Union verifica se algum estilo se aplica. Tenha em atenção que, para cada renderização de página do Moodle, apenas o primeiro estilo correspondente na lista é aplicado e os restantes estilos são ignorados. Portanto, a ordem dos estilos nesta página é crucial.</p><p>Tenha em atenção também que, após cada alteração que fizer no conjunto de estilos, o cache do tema é limpo. Isto é necessário para garantir que todos os recursos sejam enviados corretamente e atualizados para o navegador.</p>';
$string['flavourspreview'] = 'Pré-visualização';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Pré-visualizar o aspeto';
$string['flavourstitle'] = 'Título';
$string['flavourstitle_help'] = 'O título do aspeto é utilizado apenas internamente para permitir documentar um aspeto específico na lista de aspetos.';
$string['footerheading'] = 'Rodapé';
$string['footerregionsheading'] = 'Regiões do rodapé';
$string['footerregionsheading_desc'] = 'As regiões do rodapé não só podem ser ativadas com as configurações de estrutura acima referidas, como também a sua aparência pode ser personalizada.';
$string['footersuppresschatsetting'] = 'Suprimir "Conversar com os participantes da disciplina"';
$string['footersuppresschatsetting_desc'] = 'Com esta configuração, pode suprimir completamente a hiperligação "Conversar com os participantes da disciplina" no rodapé. Esta hiperligação apareceria normalmente nas disciplinas assim que fosse adicionada uma sala de comunicação nas definições da disciplina.';
$string['footersuppresscontactsetting'] = 'Suprimir o atalho "Contactar suporte do site"';
$string['footersuppresscontactsetting_desc'] = 'Com esta configuração, pode suprimir completamente o atalho "Contactar suporte do site" no rodapé. Este atalho apareceria no caso do atalho <a href="{$a->url}">contactar suporte do site</a> estar ativado.';
$string['footersuppresshelpsetting'] = 'Suprimir o atalho "Documentação para esta página"';
$string['footersuppresshelpsetting_desc'] = 'Com esta configuração, pode suprimir completamente o atalho "Documentação para esta página" no rodapé. Este atalho apareceria no caso do atalho <a href="{$a->url}">documentação para esta página</a> estar ativado.';
$string['footersuppressiconssetting'] = 'Suprimir ícones em frente aos atalhos do rodapé';
$string['footersuppressiconssetting_desc'] = 'Com esta configuração, pode suprimir completamente os ícones em frente aos atalhos do rodapé. \'Documentação para esta página\' tem um ícone de livro, \'Serviços e suporte\' uma boia salva-vidas, etc.';
$string['footersuppresslogininfosetting'] = 'Suprimir informação de autenticação';
$string['footersuppresslogininfosetting_desc'] = 'Com esta configuração, pode suprimir completamente as informações de início de sessão no rodapé. Esta informação, caso contrário, exibiria hiperligações para o perfil do utilizador e para a página de terminar sessão.';
$string['footersuppresspoweredsetting'] = 'Suprimir o atalho \'Fornecido por Moodle\'';
$string['footersuppresspoweredsetting_desc'] = 'Com esta configuração, pode suprimir completamente o atalho "\'Fornecido por Moodle\' no rodapé. Este atalho, caso contrário, exibiria a informação de que este site utiliza o Moodle e forneceria um atalho para o Moodle HQ.';
$string['footersuppressservicessetting'] = 'Suprimir o atalho \'Serviços e suporte\'';
$string['footersuppressservicessetting_desc'] = 'Com esta configuração, pode suprimir completamente o atalho "Serviços e suporte" no rodapé. Este atalho mostraria <a href="{$a->url}">Serviços e suporte</a> aos administradores.';
$string['footersuppressthemeswitchsetting'] = 'Suprimir hiperligações do seletor de temas';
$string['footersuppressthemeswitchsetting_desc'] = 'Com esta configuração, pode suprimir completamente as hiperligações de troca de temas no rodapé. O sistema subjacente para temas específicos de dispositivos foi removido no Moodle 4.3, mas as rotinas de saída ainda estão presentes, pelo que é melhor prevenir do que remediar.';
$string['footersuppressusertoursetting'] = 'Suprimir o atalho "Repetir a demonstração desta página ao utilizador"';
$string['footersuppressusertoursetting_desc'] = 'Com esta configuração, pode suprimir completamente o atalho "Repetir a demonstração desta página ao utilizador" no rodapé. Caso contrário, este atalho permitiria redefinir a demonstração ao utilizador numa página específica.';
$string['footertab'] = 'Rodapé';
$string['footnoteheading'] = 'Nota de rodapé';
$string['footnotesetting'] = 'Nota de rodapé';
$string['footnotesetting_desc'] = 'Tudo o que adicionar a esta área de texto será apresentado no final da página, no rodapé (e não no rodapé flutuante), em todas as páginas que utilizem os layouts "drawers", "columns2" ou "login". O conteúdo desta área pode ser, por exemplo, os direitos de autor, os termos de utilização ou o nome da sua organização. <br/> Se pretender remover a nota de rodapé, basta deixar em branco a área de texto.';
$string['forguestsonly'] = 'Apenas para visitantes e utilizadores não autenticados';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Problemas<a> no Github</a>';
$string['h5pcontentmaxwidthsetting'] = 'Largura máxima do banco de conteúdos H5P';
$string['h5pcontentmaxwidthsetting_desc'] = 'Com esta configuração, pode alterar a largura do banco de conteúdos H5P do Moodle sem modificações manuais no SCSS. Esta largura é utilizada para o editor H5P dentro do banco de conteúdos. <em>não</em> é utilizada para a largura da atividade H5P. Por predefinição, o Moodle utiliza uma largura máxima de 960px para o banco de conteúdos H5P. Pode indicar outros valores em píxeis, como 1200px, mas também pode indicar um valor em percentagem, como 100%, ou um valor de largura da janela de visualização, como 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Conteúdo da página de ajuda';
$string['helpcontentsetting_desc'] = 'Nesta configuração, pode adicionar conteúdo Rich Text que será apresentado na página de ajuda.';
$string['helpdisabled'] = 'A página de ajuda está desativada para este site. Não há nada para ver aqui.';
$string['helpheading'] = 'Ajuda';
$string['helplinkpositionboth'] = 'Adicionar hiperligação para a página de ajuda na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['helplinkpositionfooter'] = 'Adicionar hiperligação para a página de ajuda no ícone de rodapé (ponto de interrogação)';
$string['helplinkpositionfootnote'] = 'Adicionar hiperligação para a página de ajuda na nota de rodapé.';
$string['helplinkpositionnone'] = 'Não mostrar automaticamente a hiperligação para a página de ajuda';
$string['helplinkpositionsetting'] = 'Posição do atalho para página de ajuda';
$string['helplinkpositionsetting_desc'] = 'Nesta configuração, pode definir se deve ser adicionada automaticamente uma hiperligação para a página de ajuda à página do Moodle. Caso não pretenda exibir a hiperligação automaticamente, pode adicionar manualmente uma hiperligação para \'{$a->url}\' em qualquer parte do Moodle.';
$string['helppagetitledefault'] = 'Ajuda';
$string['helppagetitlesetting'] = 'Título da página de ajuda';
$string['helppagetitlesetting_desc'] = 'Nesta configuração, pode definir o título da página de ajuda. Este texto também será utilizado como hiperligação para a página de ajuda se configurar adequadamente a opção "Posição do atalho para página de ajuda".';
$string['hidenodesprimarynavigationsetting'] = 'Ocultar nós na navegação primária';
$string['hidenodesprimarynavigationsetting_desc'] = 'Com esta configuração, pode ocultar um ou vários nós da navegação primária.<br /><br /> Observação: Aqui, pode simplesmente remover os nós de navegação. Mas se quiser adicionar nós de navegação personalizados, considere usar a <a href="{$a->url}">funcionalidade do menu inteligente do Boost Union</a>.';
$string['imageposition_center_bottom'] = 'Centrado horizontalmente, fundo verticalmente';
$string['imageposition_center_center'] = 'Centrado horizontalmente e verticalmente';
$string['imageposition_center_top'] = 'Centrado horizontalmente, topo verticalmente';
$string['imageposition_left_bottom'] = 'Esquerda horizontalmente, fundo verticalmente';
$string['imageposition_left_center'] = 'Esquerda horizontalmente, ao meio verticalmente';
$string['imageposition_left_top'] = 'Esquerda horizontalmente, topo verticalmente';
$string['imageposition_right_bottom'] = 'Direita horizontalmente, fundo verticalmente';
$string['imageposition_right_center'] = 'Direita horizontalmente, ao meio verticalmente';
$string['imageposition_right_top'] = 'Direita horizontalmente, topo verticalmente';
$string['imprintcontentsetting'] = 'Conteúdo das informações legais';
$string['imprintcontentsetting_desc'] = 'Nesta configuração, pode adicionar conteúdo Rich Text que será apresentado na página de informações legais.';
$string['imprintdisabled'] = 'A página de informações legais está desativada para este site. Não há nada para ver aqui.';
$string['imprintheading'] = 'informações legais';
$string['imprintlinkpositionboth'] = 'Hiperligação na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['imprintlinkpositionfooter'] = 'Hiperligação no ícone de rodapé (ponto de interrogação)';
$string['imprintlinkpositionfootnote'] = 'Hiperligação na nota de rodapé';
$string['imprintlinkpositionnone'] = 'Não mostrar automaticamente a hiperligação para a página de informações legais';
$string['imprintlinkpositionsetting'] = 'Posição da hiperligação da página de informações legais';
$string['imprintlinkpositionsetting_desc'] = 'Nesta configuração, pode definir se deve ser adicionada automaticamente uma hiperligação para a página de informações legais à página do Moodle. Caso não pretenda exibir a hiperligação automaticamente, pode adicionar manualmente uma hiperligação para \'{$a->url}\' em qualquer parte do Moodle.';
$string['imprintpagetitledefault'] = 'Informações legais';
$string['imprintpagetitlesetting'] = 'Título da página de informações legais';
$string['imprintpagetitlesetting_desc'] = 'Nesta configuração, pode definir o título da página de informações legais. Este texto também será utilizado como hiperligação para a página de informações legais se configurar adequadamente a opção \'Posição da hiperligação da página de informações legais\'.';
$string['infobannerbsclasssetting'] = 'Classe Bootstrap do banner  informativo {$a->no}';
$string['infobannerbsclasssetting_desc'] = 'Com esta configuração, pode selecionar o estilo Bootstrap com o qual o banner informativo {$a->no} deve ser apresentado. Se escolher a opção \'Sem cor Bootstrap\', o banner informativo será apresentado sem qualquer cor Bootstrap específica, o que lhe dá a liberdade de estilizar o banner por si próprio no editor Rich Text.';
$string['infobannerclose'] = 'Fechar';
$string['infobannercontentsetting'] = 'Conteúdo do banner informativo {$a->no}';
$string['infobannercontentsetting_desc'] = 'Indique as informações que devem ser apresentadas no banner informativo {$a->no}.';
$string['infobannerdismissconfirm'] = 'Pretende realmente repor a visibilidade do banner informativo {$a->no} e voltar a exibi-lo a todos os utilizadores que o dispensaram?';
$string['infobannerdismissfail'] = 'A reposição da visibilidade do banner informativo {$a->no} falhou para pelo menos um utilizador.';
$string['infobannerdismissiblesetting'] = 'Fechar banner informativo {$a->no}';
$string['infobannerdismissiblesetting_desc'] = 'Com esta configuração, pode tornar o banner informativo {$a->no} dispensável. Se o utilizador clicar no botão "x" no banner informativo, o banner será ocultado permanentemente para este utilizador. A visibilidade não é reposta automaticamente, mesmo que altere o conteúdo do banner informativo. Se pretender repor a visibilidade do banner informativo, clique no botão "Repor visibilidade" abaixo.';
$string['infobannerdismissreset'] = 'Repor a visibilidade do banner informativo dispensado';
$string['infobannerdismissresetbutton'] = 'Repor visibilidade do banner informativo {$a->no}';
$string['infobannerdismisssuccess'] = 'A visibilidade do banner informativo {$a->no} foi reposta.';
$string['infobannerenabledsetting'] = 'Ativar banner informativo {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Com esta opção, podes ativar o banner informativo {$a->no}.';
$string['infobannerendsetting'] = 'Fim do banner informativo {$a->no}';
$string['infobannerendsetting_desc'] = 'Define até quando o banner informativo {$a->no} deve ser apresentado (hora do servidor).';
$string['infobannerheading'] = 'Banner informativo {$a->no}';
$string['infobannermodeperpetual'] = 'Perpétuo';
$string['infobannermodesetting'] = 'Modo de visualização do banner informativo {$a->no}';
$string['infobannermodesetting_desc'] = 'Com esta configuração, pode definir até quando o banner informativo {$a->no} deve ser apresentado ou se deve ser sempre apresentado. O horário configurado é interpretado como horário do servidor, e não como horário do utilizador.';
$string['infobannermodetimebased'] = 'Cronometrado';
$string['infobannerordersetting'] = 'Posição na ordem do banner informativo {$a->no}';
$string['infobannerordersetting_desc'] = 'Com esta configuração, define a posição de ordem do banner informativo {$a->no}. Por predefinição, os banners informativos estão ordenados de cima para baixo, como vê nesta página de definições. No entanto, pode definir outra posição de ordem com esta configuração. Se atribuir a mesma posição de ordem a dois ou mais banners informativos, estes serão reordenados de acordo com a ordem definida nesta página de configarações.';
$string['infobannerpageloginpage'] = 'Página de autenticação';
$string['infobannerpagessetting'] = 'Estruturas de página para mostrar banner informativo {$a->no} em';
$string['infobannerpagessetting_desc'] = 'Com esta opção, podes escolher em que páginas o banner informativo {$a->no} deve aparecer.';
$string['infobannerstartsetting'] = 'Início do banner informativo {$a->no}';
$string['infobannerstartsetting_desc'] = 'Com esta configuração, pode definir a partir desde quando o banner informativo {$a->no} deve ser apresentado. O horário configurado é interpretado como horário do servidor, e não como horário do utilizador.';
$string['infobannertab'] = 'Banner informativo';
$string['invalidurl'] = 'O URL indicado não é válido.';
$string['javascriptdisabledhint'] = 'Dica de JavaScript desativado';
$string['javascriptdisabledhint_desc'] = 'Com esta configuração, surgirá uma dica na parte superior da página do Moodle caso o JavaScript esteja desativado. Isto é particularmente útil, uma vez que diversas funcionalidades do Moodle não funcionam sem JavaScript.';
$string['javascriptdisabledhinttext'] = 'O JavaScript está desativado no seu navegador. <br />Muitas funcionalidades do Moodle não estarão disponíveis ou apresentarão problemas. <br />Ative o JavaScript para tirar o máximo partido do Moodle.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Hiperligações';
$string['loginbackgroundimage'] = 'Imagens de fundo da página de autenticação';
$string['loginbackgroundimage_desc'] = 'As imagens a apresentar como fundo da página de autenticação. Uma destas imagens será escolhida aleatoriamente e apresentada quando o utilizador visitar a página de autenticação. Certifique-se de que não utiliza caracteres não ASCII no nome do ficheiro se pretender apresentar texto nas imagens de fundo da página de início de sessão.';
$string['loginbackgroundimagepositionsetting'] = 'Posição da imagem de fundo da página de autenticação';
$string['loginbackgroundimagepositionsetting_desc'] = 'Com esta configuração, controla o posicionamento da imagem de fundo da página de autenticação dentro da janela do navegador. O primeiro valor representa a posição horizontal e o segundo, a posição vertical.';
$string['loginbackgroundimagesheading'] = 'Imagens de fundo da página de autenticação';
$string['loginbackgroundimagetextsetting'] = 'Texto a mostrar em imagens de fundo da autenticação';
$string['loginbackgroundimagetextsetting_desc'] = 'Com esta configuração opcional, pode adicionar texto, como um aviso de direitos de autor, às suas imagens de fundo carregadas. Este texto aparecerá na parte superior do rodapé da página de início de sessão. No entanto, por questões de espaço no ecrã, apenas é apresentado em ecrãs maiores. <br/>
Cada linha é constituída pelo identificador do ficheiro (o nome do ficheiro), pelo texto que deve ser apresentado e pela cor do texto, separados por uma barra vertical. Cada instrução deve ser escrita numa nova linha. <br/>
Por exemplo:<br/>
background-image-1. jpg|Copyright: CC0|dark<br/>
Como cor do texto, pode utilizar os valores "dark" ou "light". <br/>
Pode declarar textos para uma quantidade arbitrária das suas imagens de fundo da autenticação carregadas. Os textos serão adicionados apenas às imagens cujo nome de ficheiro corresponda ao identificador declarado nesta configuração.';
$string['loginformheading'] = 'Formulário de autenticação';
$string['loginformpositionsetting'] = 'Posição do formulário de autenticação';
$string['loginformpositionsetting_center'] = 'Centrado';
$string['loginformpositionsetting_desc'] = 'Com esta configuração, pode otimizar o formulário de início de sessão para se adaptar a uma maior variedade de imagens de fundo. Por predefinição, o formulário de início de sessão é apresentado centrado na página de início de sessão. Em alternativa, pode movê-lo para a esquerda ou para a direita da página de início de sessão para permitir que outras partes da imagem de fundo apareçam. É claro que também pode alterar esta configuração se não for carregada nenhuma imagem de fundo.';
$string['loginformpositionsetting_left'] = 'Esquerda';
$string['loginformpositionsetting_right'] = 'Direita';
$string['loginformtransparencysetting'] = 'Transparência do formulário de autenticação';
$string['loginformtransparencysetting_desc'] = 'Com esta configuração, pode tornar o formulário de início de sessão ligeiramente transparente para que a imagem de fundo se destaque ainda mais.';
$string['loginidpshowintrosetting'] = 'Mensagem da autenticação IDP';
$string['loginidpshowintrosetting_desc'] = 'Com esta configuração, controla se a frase <em>\'{$a}\'</em> é, ou não, apresentada acima dos botões de início de sessão com IDP (provedor de identidade). Por predefinição, a frase é apresentada e os utilizadores serão rapidamente informados sobre a função dos botões IDP. Se desativar esta configuração, a frase na autenticação IDP ficará oculta. Isto permite fornecer uma interface de autenticação de utilizador limpa, caso utilize apenas fornecedores de identidade externos, como OAuth2 ou OIDC.';
$string['loginlinkbuttonenabled'] = 'Mostrar "Entrar" como um botão';
$string['loginlinkbuttonenabled_desc'] = 'Com esta configuração, pode mostrar a hiperligação "Entrar" no topo da página como um botão. Isto pode ajudar os seus utilizadores a perceberem que ainda não estão autenticados.';
$string['loginlocalintro'] = 'Autenticar-se com a sua conta Moodle';
$string['loginlocalloginenablesetting'] = 'Autenticação local';
$string['loginlocalloginenablesetting_desc'] = 'Com esta configuração, controla se o formulário de início de sessão local é, ou não, apresentado na página de início de sessão. Por predefinição, o formulário de início de sessão local é apresentado e os utilizadores podem aceder ao site normalmente. Se desativar esta configuração, o formulário de início de sessão local ficará oculto. Isto permite fornecer apenas botões de autenticação para fornecedores de identidade externos, como OAuth2 ou OIDC.';
$string['loginlocalloginenablesetting_note'] = 'Atenção: Assim que ocultar o formulário de autenticação local, corre o risco de os administradores deixarem de conseguir aceder com uma conta local, caso haja algum problema com o fornecedor de identidade externo. O mesmo acontece se não estiver ativado nenhum outro método de autenticação para além da autenticação manual. <br />Para permitir autenticações locais mesmo nestes casos, a <a href="{$a->url}">página de autenticação local</a> (ver detalhes abaixo) é automaticamente ativada. Adicione este URL aos seus favoritos como medida de segurança.';
$string['loginlocalloginformhead'] = 'Autenticação local';
$string['loginlocalloginlocalnotdisabled'] = 'Não é necessário autenticar-se nesta página de entrada lateral. Utilize a <a href="{$a->url}">página de início de sessão predefinida</a> para iniciar sessão.';
$string['loginlocalshowintrosetting'] = 'Mensagem da autenticação local';
$string['loginlocalshowintrosetting_desc'] = 'Com esta configuração, controla se a frase <em>\'{$a}\'</em> é, ou não, apresentada acima do formulário de início de sessão local. Por predefinição, a frase não é apresentada. Mas, se a ativar, poderá ajudar os utilizadores a compreender quais as credenciais a utilizar no formulário de início de sessão local, especialmente se fornecer mais do que um método de início de sessão ou se tiver alterado a ordem dos métodos de início de sessão.';
$string['loginorderfirsttimesignupsetting'] = 'Informações para visitantes de primeira vez e autorregisto';
$string['loginorderguestsetting'] = 'Visitantes';
$string['loginorderheading'] = 'Ordem da autenticação';
$string['loginorderheading_desc'] = 'Com estas configurações, controla a ordem dos métodos de início de sessão no formulário de início de sessão. A ordem apresentada será definida do menor para o maior número ordinal, ignorando todos os métodos de autenticação e elementos do formulário de autenticação que estejam desativados no Moodle.';
$string['loginorderheading_note'] = 'Nota técnica: A ordem apresentada será obtida com flexbox CSS, e não reorganizando os widgets de autenticação no HTML DOM. Isto deve funcionar bem em todos os navegadores modernos, mas pode não funcionar em navegadores muito antigos.';
$string['loginorderidpsetting'] = 'Autenticação IDP';
$string['loginorderlocalsetting'] = 'Autenticação local';
$string['loginpagetab'] = 'Página de autenticação';
$string['loginprovidersheading'] = 'Fornecedores de autenticação';
$string['loginprovidersheading_desc'] = 'Atenção: o Boost Union tem as suas próprias configurações de fornecedores de autenticação e não utiliza a configuração \'{$a->settingname}\' das <a href="{$a->url}">configurações de autenticação do Moodle</a>.';
$string['logocompactsetting'] = 'Logótipo compacto';
$string['logocompactsetting_desc'] = 'Pode carregar uma versão compacta do mesmo logótipo acima, como um emblema, escudo ou ícone. Esta imagem é especialmente utilizada na barra de navegação no topo de cada página do Moodle. A imagem deve ficar nítida mesmo em tamanhos pequenos.';
$string['logosetting'] = 'Logótipo';
$string['logosetting_desc'] = 'Pode carregar um logótipo completo para ser utilizado como decoração. Esta imagem é especialmente utilizada na página de autenticação. Pode ter uma resolução bastante elevada, pois será redimensionada para utilização.';
$string['logosheading'] = 'Logótipos';
$string['logosheading_desc'] = 'Atenção: o Boost Union tem o seu próprio sistema de carregamento de logótipos e não utiliza o logótipo da <a href="{$a}">configuração do logótipo do Moodle</a>. <br />O Boost Union permite carregar mais formatos de imagem do que os permitidos pelo Moodle, para além de possibilitar a substituição dos logótipos carregados dentro das suas próprias configurações.';
$string['maintenancecontentsetting'] = 'Conteúdo da página de informação de manutenção';
$string['maintenancecontentsetting_desc'] = 'Nesta configuração, pode adicionar conteúdo Rich Text que será apresentado na página de informação de manutenção (que não é a mesma que a página do modo de manutenção integrada do Moodle).';
$string['maintenancedisabled'] = 'A página de informação de manutenção está desativada para este site. Não há nada para ver aqui.';
$string['maintenanceheading'] = 'Manutenção';
$string['maintenancelinkpositionboth'] = 'Adicionar hiperligação para a página de informação de manutenção na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['maintenancelinkpositionfooter'] = 'Adicionar hiperligação para a página de informação de manutenção no ícone de rodapé (ponto de interrogação)';
$string['maintenancelinkpositionfootnote'] = 'Adicionar hiperligação para a página de informações de manutenção na nota de rodapé';
$string['maintenancelinkpositionnone'] = 'Não mostrar automaticamente a hiperligação para a página de informação de manutenção';
$string['maintenancelinkpositionsetting'] = 'Posição da hiperligação da página de informação de manutenção';
$string['maintenancelinkpositionsetting_desc'] = 'Nesta configuração, pode definir se deve ser adicionada automaticamente uma hiperligação para a página de informação de manutenção à página do Moodle. Caso não pretenda exibir a hiperligação automaticamente, pode adicionar manualmente uma hiperligação para \'{$a->url}\' em qualquer parte do Moodle.';
$string['maintenancepagetitledefault'] = 'Manutenção';
$string['maintenancepagetitlesetting'] = 'Título da página de informação de manutenção';
$string['maintenancepagetitlesetting_desc'] = 'Nesta configuração, pode definir o título da página de informação de manutenção. Este texto também será utilizado como hiperligação para a página de informação de manutenção se configurar adequadamente a opção \'Posição da hiperligação da página de informação de manutenção\'.';
$string['markbrokenlinkssetting'] = 'Assinalar hiperligações quebradas';
$string['markbrokenlinkssetting_desc'] = 'Adiciona um ícone de "corrente partida" antes de hiperligações quebradas (por exemplo, ficheiros carregados que não foram processados corretamente) e marca as hiperligações com a cor "danger" do Bootstrap. Ao contrário das opções para hiperligações externas e mailto, aqui não é possível limitar o âmbito, porque estes avisos indicam que algo está errado e precisa de ser corrigido manualmente.';
$string['markexternallinksscopesetting'] = 'Marcar âmbito de hiperligações externas';
$string['markexternallinksscopesetting_desc'] = 'Com esta configuração, controla o âmbito em que o Boost Union deve marcar as hiperligações externas. Por predefinição, o Boost Union marca as hiperligações externas em toda a página do Moodle e faz o seu melhor para abranger alguns casos extremos em que a adição do ícone das hiperligações externas não faz muito sentido. No entanto, também pode limitar o âmbito para evitar melhor estes casos extremos.';
$string['markexternallinkssetting'] = 'Assinalar hiperligações externas';
$string['markexternallinkssetting_desc'] = 'Adicionar um ícone de "hiperligação externa" após as hiperligações externas (que levam o utilizador para um destino fora do Moodle).';
$string['marklinksscopesetting_coursemain'] = 'Apenas dentro da área de conteúdo principal das páginas principais da disciplina';
$string['marklinksscopesetting_wholepage'] = 'Na página inteira';
$string['markmailtolinksscopesetting'] = 'Âmbito para marcar hiperligações mailto';
$string['markmailtolinksscopesetting_desc'] = 'Com esta configuração, controla o âmbito em que o Boost Union deve marcar as hiperligações mailto. Por predefinição, o Boost Union marca as hiperligações mailto em toda a página do Moodle. No entanto, também pode limitar o âmbito para evitar casos extremos.';
$string['markmailtolinkssetting'] = 'Assinalar as hiperligações mailto';
$string['markmailtolinkssetting_desc'] = 'Adiciona um ícone de "envelope" antes dos hiperligações mailto.';
$string['maxlogowidth'] = 'Largura máxima do logótipo na barra de navegação';
$string['maxlogowidth_desc'] = 'O logótipo compacto carregado é normalmente apresentado com 100% de altura e largura proporcional. No entanto, se o logótipo for demasiado largo ou tiver outra proporção especial, pode definir aqui a largura máxima do logótipo na barra de navegação. Pode indicar valores em píxeis, como 120px, mas também pode indicar um valor em percentagem, como 10%, ou um valor de largura da janela de visualização, como 5vw. Se não indicar nenhum valor, o logótipo será apresentado com a apresentação predefinida.';
$string['misctab'] = 'Diversos';
$string['mobileappearanceheading'] = 'Aparência da aplicação móvel';
$string['mobileappheading'] = 'Aplicação móvel';
$string['mobilecss'] = 'CSS adicional para a aplicação móvel';
$string['mobilecss_desc'] = 'Com esta configuração, pode escrever código CSS personalizado para personalizar a interface da sua aplicação móvel. O código CSS será adicionado apenas à representação da aplicação móvel desta instância do Moodle e não será apresentado na versão do navegador web. Mais informações sobre esta funcionalidade na <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">documentação para programadores do Moodle</a>.';
$string['mobilecss_donotchange'] = 'Esta etapa é necessária para enviar o código CSS para a aplicação móvel. Não altere o URL a menos que queira realmente remover o código CSS da aplicação móvel novamente.';
$string['mobilecss_overwrite'] = 'Assim que adicionar qualquer código CSS a esta configuração e guardar a configuração, a <a href="{$a->url}">configuração do core do Moodle <em>mobilecssurl</em></a> será automaticamente substituída por um URL do tema Boost Union. Atualmente, esta configuração está definida como <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Assim que adicionar qualquer código CSS a esta configuração e guardar a configuração, a <a href="{$a->url}">configuração do core do Moodle <em>mobilecssurl</em></a> será automaticamente definida para um URL do tema Boost Union.';
$string['mobiletab'] = 'Dispositivos móveis';
$string['modiconactivity'] = 'Atividade';
$string['modiconactivityunknown'] = 'Desconhecido';
$string['modicongtmoodle4'] = 'Ícone do Moodle 4';
$string['modiconlistsetting'] = 'Lista de ficheiros de ícones personalizados';
$string['modiconlistsetting_desc'] = 'Esta é a lista de ficheiros de ícones personalizados que carregou para a área de ficheiros de ícones personalizados acima. Todos os ficheiros de ícones válidos estão aqui listados. Além disso, outros ficheiros que possa ter carregado, mas que não sejam ficheiros de ícones válidos, também serão apresentados como ficheiros corrompidos.';
$string['modiconltmoodle311'] = 'Ícone antigo do Moodle 3';
$string['modiconnamefail'] = 'Este ficheiro foi carregado para a pasta correta da atividade <em>{$a}</em>, mas o nome do ficheiro não é válido. Altere o nome do ficheiro para <em>monologo. svg</em> / <em>monologo. png</em> (para ícones do Moodle 4) ou para <em>icon. svg</em> / <em>icon. png</em> (para ícones antigos do Moodle 3).';
$string['modiconnotexist'] = 'Este ficheiro foi carregado num local inadequado, uma vez que é impossível deduzir uma atividade específica a partir do caminho do ficheiro <em>{$a}</em>.';
$string['modiconsenablesetting'] = 'Ícones personalizados para atividades e recursos';
$string['modiconsenablesetting_desc'] = 'Com esta configuração, pode modificar os ícones de atividades e recursos que são utilizados pelo Moodle nas páginas da disciplina e no seletor de atividades.';
$string['modiconserrorcreatingpath'] = 'Não foi possível criar a pasta pix_plugins/mod no seu diretório Moodledata. <br />A mensagem de excepção foi:{$a}.';
$string['modiconsfiles'] = 'Ficheiros de ícones personalizados';
$string['modiconsfiles_desc'] = 'Pode carregar ícones personalizados para todos os módulos de atividade instalados nesta instância do Moodle ou apenas para alguns deles.';
$string['modiconsfileshowto'] = 'Para carregar um ícone personalizado específico para uma atividade, comece por criar uma pasta com o nome interno da atividade, por exemplo, <em>assign</em> para a atividade de trabalho. Nessa pasta, carregue o ícone como um ficheiro SVG denominado monologo.svg e, se possível, como um ficheiro PNG alternativo denominado monologo.png. Se quiser personalizar os ícones coloridos que foram utilizados até ao Moodle 3 e que ainda podem ser utilizados pelos módulos mais antigos, também pode carregá-los como ficheiros icon.svg e icon.png. No entanto, para melhores resultados, prefira utilizar ícones SVG monocromáticos, se possível. Em seguida, guarde a página de configurações. Assim que guardar as configurações com pelo menos um ficheiro, será apresentada uma lista de ficheiros abaixo, permitindo verificar se os ícones personalizados foram carregados corretamente.';
$string['modiconsfilestech'] = 'Nota técnica: Após guardar a configuração, a estrutura de pastas e os ficheiros de ícones carregados serão copiados para a pasta pix_plugins/mod no seu diretório Moodledata. É aqui que o Moodle procura ícones de atividades personalizados. Todos os ficheiros de ícones que já existam neste local serão sobrescritos ao guardar esta configuração.';
$string['modiconsheading'] = 'Ícones de atividade';
$string['modiconsuccess3x'] = 'Este ícone será usado para a atividade <em>{$a}</em> como ícone legado do Moodle 3.';
$string['modiconsuccess4x'] = 'Este ícone será utilizado para a atividade <em>{$a}</em> como ícone do Moodle 4.';
$string['modiconversion'] = 'Versão do ícone';
$string['navbarcolorsetting'] = 'Cor da barra de navegação';
$string['navbarcolorsetting_dark'] = 'Barra de navegação escura com cor de tipo de letra clara';
$string['navbarcolorsetting_desc'] = 'Pode alterar a cor da barra de navegação de cor clara predefinida para uma colorida ou de cor escura.';
$string['navbarcolorsetting_light'] = 'Barra de navegação clara com cor de letra escura (conforme apresentado pelo Moodle)';
$string['navbarcolorsetting_primarydark'] = 'Barra de navegação na cor primária com cor clara do tipo de letra';
$string['navbarcolorsetting_primarylight'] = 'Barra de navegação na cor primária com cor escura do tipo de letra';
$string['navbarheading'] = 'Barra de navegação';
$string['navigationheading'] = 'Navegação';
$string['navigationtab'] = 'Navegação';
$string['never'] = 'Nunca';
$string['nochange'] = 'Sem alteração';
$string['offerscontentsetting'] = 'Conteúdo das ofertas';
$string['offerscontentsetting_desc'] = 'Nesta configuração, pode adicionar conteúdo Rich Text que será apresentado na página de ofertas.';
$string['offersdisabled'] = 'A página de ofertas está desativada para este site. Não há nada para ver aqui.';
$string['offersheading'] = 'Ofertas';
$string['offerslinkpositionboth'] = 'Adicionar hiperligação para a página de ofertas na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['offerslinkpositionfooter'] = 'Adicionar hiperligação para a página de ofertas no ícone de rodapé (ponto de interrogação)';
$string['offerslinkpositionfootnote'] = 'Adicionar hiperligação para a página de ofertas na nota de rodapé';
$string['offerslinkpositionnone'] = 'Não mostrar automaticamente a hiperligação para a página de ofertas';
$string['offerslinkpositionsetting'] = 'Posição da hiperligação da página ofertas';
$string['offerslinkpositionsetting_desc'] = 'Nesta configuração, pode definir se deve ser adicionada automaticamente uma hiperligação para a página de ofertas à página do Moodle. Caso não pretenda exibir a hiperligação automaticamente, pode adicionar manualmente uma hiperligação para \'{$a->url}\' em qualquer parte do Moodle.';
$string['offerspagetitledefault'] = 'Ofertas';
$string['offerspagetitlesetting'] = 'Título da página de ofertas';
$string['offerspagetitlesetting_desc'] = 'Nesta configuração, pode definir o título da página ofertas. Este texto também será utilizado como hiperligação para a página ofertas se configurar adequadamente a opção \'Posição da hiperligação da página ofertas\'.';
$string['openoffcanvas'] = 'Fechar painel de Fora do ecrã';
$string['outsideregionsheading'] = 'Regiões externas';
$string['outsideregionsheading_desc'] = 'As regiões externas não só podem ser ativadas com as configurações da estrutura acima referidas, como também a sua aparência pode ser personalizada.';
$string['outsideregionsplacement'] = 'Posicionamento horizontal das regiões externas';
$string['outsideregionsplacement_desc'] = 'Com esta configuração, pode controlar se, em ecrãs maiores, as regiões de bloco \'Externa (esquerda)\' e \'Externa (direita)\' devem ser posicionadas junto à área de conteúdo principal ou junto às margens da janela.';
$string['outsideregionsplacementnearwindowedges'] = 'Mostrar as regiões \'Externa (esquerda)\' e \'Externa (direita)\' junto às margens da janela.';
$string['outsideregionsplacementnextmaincontent'] = 'Mostrar as regiões \'Externa (esquerda)\' e \'Externa (direita)\' junto à área do conteúdo principal.';
$string['outsideregionswidthcoursecontentwidth'] = 'Largura do conteúdo da disciplina';
$string['outsideregionswidthfullwidth'] = 'Largura máxima';
$string['outsideregionswidthherowidth'] = 'Largura Hero';
$string['page1contentsetting'] = 'Conteúdo da página genérica 1';
$string['page1contentsetting_desc'] = 'Nesta configuração, pode adicionar conteúdo Rich Text que será apresentado na página genérica 1.';
$string['page1disabled'] = 'A página genérica 1 está desativada para este site. Não há nada para ver aqui.';
$string['page1heading'] = 'Página genérica 1';
$string['page1linkpositionboth'] = 'Adicionar hiperligação para a página genérica 1 na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['page1linkpositionfooter'] = 'Adicionar hiperligação para a página genérica 1 no ícone de rodapé (ponto de interrogação)';
$string['page1linkpositionfootnote'] = 'Adicionar hiperligação para a página genérica 1 na nota de rodapé';
$string['page1linkpositionnone'] = 'Não mostrar automaticamente a hiperligação para a página genérica 1';
$string['page1linkpositionsetting'] = 'Posição da hiperligação da página genérica 1';
$string['page1linkpositionsetting_desc'] = 'Nesta configuração, pode definir se deve ser adicionada automaticamente uma hiperligação para a página genérica 1 à página do Moodle. Caso não pretenda exibir a hiperligação automaticamente, pode adicionar manualmente uma hiperligação para \'{$a->url}\' em qualquer parte do Moodle.';
$string['page1pagetitledefault'] = 'Página genérica 1';
$string['page1pagetitlesetting'] = 'Título da página genérica 1';
$string['page1pagetitlesetting_desc'] = 'Nesta configuração, pode definir o título da página genérica 1. Este texto também será utilizado como hiperligação para a página genérica 1 se configurar adequadamente a opção \'Posição da hiperligação da página genérica 1\'.';
$string['page2contentsetting'] = 'Conteúdo da página genérica 2';
$string['page2contentsetting_desc'] = 'Nesta configuração, pode adicionar conteúdo Rich Text que será apresentado na página genérica 2.';
$string['page2disabled'] = 'A página genérica 2 está desativada para este site. Não há nada para ver aqui.';
$string['page2heading'] = 'Página genérica 2';
$string['page2linkpositionboth'] = 'Adicionar hiperligação para a página genérica 2 na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['page2linkpositionfooter'] = 'Adicionar hiperligação para a página genérica 2 no ícone de rodapé (ponto de interrogação)';
$string['page2linkpositionfootnote'] = 'Adicionar hiperligação para a página genérica 2 na nota de rodapé';
$string['page2linkpositionnone'] = 'Não mostrar automaticamente a hiperligação para a página genérica 2';
$string['page2linkpositionsetting'] = 'Posição da hiperligação da página genérica 2';
$string['page2linkpositionsetting_desc'] = 'Nesta configuração, pode definir se deve ser adicionada automaticamente uma hiperligação para a página genérica 2 à página do Moodle. Caso não pretenda exibir a hiperligação automaticamente, pode adicionar manualmente uma hiperligação para \'{$a->url}\' em qualquer parte do Moodle.';
$string['page2pagetitledefault'] = 'Página genérica 2';
$string['page2pagetitlesetting'] = 'Título da página genérica 2';
$string['page2pagetitlesetting_desc'] = 'Nesta configuração, pode definir o título da página genérica 2. Este texto também será utilizado como hiperligação para a página genérica 2 se configurar adequadamente a opção \'Posição da hiperligação da página genérica 2\'.';
$string['page3contentsetting'] = 'Conteúdo da página genérica 3';
$string['page3contentsetting_desc'] = 'Nesta configuração, pode adicionar conteúdo Rich Text que será apresentado na página genérica 3.';
$string['page3disabled'] = 'A página genérica 3 está desativada para este site. Não há nada para ver aqui.';
$string['page3heading'] = 'Página genérica 3';
$string['page3linkpositionboth'] = 'Adicionar hiperligação para a página genérica 3 na nota de rodapé e no ícone de rodapé (ponto de interrogação)';
$string['page3linkpositionfooter'] = 'Adicionar hiperligação para a página genérica 3 no ícone de rodapé (ponto de interrogação)';
$string['page3linkpositionfootnote'] = 'Adicionar hiperligação para a página genérica 3 na nota de rodapé';
$string['page3linkpositionnone'] = 'Não mostrar automaticamente a hiperligação para a página genérica 3';
$string['page3linkpositionsetting'] = 'Posição da hiperligação da página genérica 3';
$string['page3linkpositionsetting_desc'] = 'Nesta configuração, pode definir se deve ser adicionada automaticamente uma hiperligação para a página genérica 3 à página do Moodle. Caso não pretenda exibir a hiperligação automaticamente, pode adicionar manualmente uma hiperligação para \'{$a->url}\' em qualquer parte do Moodle.';
$string['page3pagetitledefault'] = 'Página genérica 3';
$string['page3pagetitlesetting'] = 'Título da página genérica 3';
$string['page3pagetitlesetting_desc'] = 'Nesta configuração, pode definir o título da página genérica 3. Este texto também será utilizado como hiperligação para a página genérica 3 se configurar adequadamente a opção \'Posição da hiperligação da página genérica 3\'.';
$string['pagelayoutstab'] = 'Estrutura da página';
$string['pagetab'] = 'Página';
$string['pagewidthheading'] = 'Largura da página';
$string['pluginname'] = 'Boost Union';
$string['policyheading'] = 'Políticas';
$string['policyoverviewnavigationsetting'] = 'Mostrar a navegação na página de visão global da política';
$string['policyoverviewnavigationsetting_desc'] = 'Por predefinição, a página de <a href="{$a->url}">visão global da política (fornecida pela tool_policy)</a> não apresenta um menu de navegação ou um rodapé. Com esta configuração, pode apresentar a navegação principal e o rodapé nessa página.';
$string['presetbutton'] = 'Definir as predefinições no Boost';
$string['presetheading'] = 'Predefinições de tema';
$string['presetheading_desc'] = 'As predefinições do tema podem ser utilizadas para alterar drasticamente a aparência do tema. O Boost Union não reimplementa a configuração das predefinições do tema. Se pretender utilizar predefinições do tema, defina-os diretamente no Boost. O Boost Union herdará e utilizará a predefinição configurada.';
$string['primarynavigationheading'] = 'Navegação primária';
$string['privacy:metadata'] = 'O tema Boost Union não armazena quaisquer dados pessoais de nenhum utilizador.';
$string['region-content-lower'] = 'Conteúdo (inferior)';
$string['region-content-upper'] = 'Conteúdo (superior)';
$string['region-footer-center'] = 'Rodapé (centro)';
$string['region-footer-left'] = 'Rodapé (esquerda)';
$string['region-footer-right'] = 'Rodapé (direita)';
$string['region-header'] = 'Cabeçalho';
$string['region-none'] = 'Nenhum';
$string['region-offcanvas-center'] = 'Fora do ecrã (centro)';
$string['region-offcanvas-left'] = 'Fora do ecrã (esquerda)';
$string['region-offcanvas-right'] = 'Fora do ecrã (direita)';
$string['region-outside-bottom'] = 'Externa (fundo)';
$string['region-outside-left'] = 'Externa (esquerda)';
$string['region-outside-right'] = 'Externa (direita)';
$string['region-outside-top'] = 'Externa (topo)';
$string['resourcescachecontrolnote'] = 'Tenha em atenção que os ficheiros são enviados para o navegador com o cabeçalho \'Cache-Control\' definido, que instrui o navegador a armazenar o ficheiro em cache. Se tiver a certeza de que não irá alterar o ficheiro em breve, pode utilizar o URL permanente para criar uma hiperligação para o ficheiro. No entanto, se planeia modificar um ficheiro, mas manter o mesmo nome de vez em quando, é recomendado utilizar o URL com revisão e criar uma nova hiperligação para o ficheiro sempre que o atualizar, para evitar que os navegadores mostrem versões desatualizadas em cache.';
$string['resourcestab'] = 'Recursos';
$string['scrollspysetting'] = 'Lembrar deslocamento';
$string['scrollspysetting_desc'] = 'Com esta configuração, ao ativar e desativar o modo de edição, é preservada a posição de scroll em que o utilizador se encontrava no momento da ativação/desativação.';
$string['scssheading'] = 'Raw SCSS';
$string['scsstab'] = 'SCSS';
$string['setpreferredlanglink'] = 'Definir idioma preferido';
$string['settingsoverview'] = 'Visão global das configurações';
$string['settingsoverview_accessibility_desc'] = 'As configurações de acessibilidade do seu site Moodle estão localizadas aqui.';
$string['settingsoverview_all'] = 'Todas as configurações numa página';
$string['settingsoverview_all_desc'] = 'Pode aceder à página de configurações padrão da categoria Moodle para o Boost Union, que exibe todas as configurações numa só página. Mas atenção, é realmente denso.';
$string['settingsoverview_content_desc'] = 'Configurações para o conteúdo global do seu site Moodle estão localizadas aqui: rodapé, páginas estáticas, banners informativos, blocos de anúncios e controlos deslizantes.';
$string['settingsoverview_feel_desc'] = 'Configurações para o comportamento geral do seu site Moodle estão localizadas aqui: itens de navegação, auxiliares de navegação, blocos e hiperligações.';
$string['settingsoverview_flavours_desc'] = 'Com os aspetos, pode diversificar o seu site Moodle entre grupos globais e/ou categorias de disciplinas.';
$string['settingsoverview_functionality_desc'] = 'Configurações para funcionalidades globais adicionais ou relacionadas a disciplinas no seu site Moodle estão localizadas aqui.';
$string['settingsoverview_look_desc'] = 'As configurações para personalizar a identidade visual do seu site Moodle estão aqui localizadas: cores, ícones, imagens, tamanhos e, claro, SCSS personalizado.';
$string['settingsoverview_smartmenus_desc'] = 'Com menus inteligentes, pode estender os itens de navegação do seu site Moodle no menu principal e nos menus dos utilizadores, bem como adicionar um menu inferior ou um menu superior.';
$string['settingsoverview_snippets_desc'] = 'Com os excertos de código SCSS, pode adicionar recursos visuais ou melhorias estéticas ao seu site Moodle.';
$string['settingsoverview_title'] = 'Visão global das configurações do Boost Union';
$string['showasbadge'] = 'Mostrar como medalha';
$string['showastext'] = 'Mostrar como texto';
$string['showfullnameinusermenussetting'] = 'Mostrar o nome completo no menu do utilizador';
$string['showfullnameinusermenussetting_desc'] = 'Com esta configuração, pode exibir o nome completo do utilizador autenticado na parte superior do menu de utilizadores. Isto pode ser especialmente útil em situações de exame, onde os professores precisam de confirmar se o utilizador está autenticado com a sua própria conta, mas também pode ser útil para o próprio utilizador. Ao contrário do tema Clássico, que exibe o nome completo do utilizador na barra de navegação junto ao avatar, esta abordagem não ocupa qualquer espaço adicional na barra de navegação.';
$string['showfullnameinusermenussetting_loggedinas'] = 'Está autenticado como:';
$string['showhintcourseguestaccessgeneral'] = 'Está a visualizar esta disciplina com o papel de <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Para ter acesso completo à disciplina, pode <a href="{$a->url}">inscrever-se nesta disciplina</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Com esta configuração, uma dica aparecerá no cabeçalho da disciplina quando um utilizador acede como visitante. Se a disciplina oferecer a opção de autoinscrição, será também apresentado ao utilizador uma hiperligação para essa página.';
$string['showhintcourseguestenrolauthonly'] = 'Todos os utilizadores do Moodle que estejam autenticados podem aceder gratuitamente ao conteúdo desta disciplina, sem necessidade de se inscreverem.';
$string['showhintcourseguestenrolauthonlyalways'] = 'Todos os utilizadores do Moodle que estejam autenticados podem aceder ao conteúdo desta disciplina sem se inscreverem, desde que conheçam a senha de acesso para visitantes.';
$string['showhintcourseguestenrolcallforaction'] = 'Se não pretende conceder livre acesso a esta disciplina, desative o acesso de visitante ou defina uma senha de visitante nas <a href="{$a->url}">configurações da disciplina</a>.';
$string['showhintcourseguestenrolcallforactionalways'] = 'Se não pretende conceder acesso de visitante a esta disciplina, desative o acesso de visitante nas <a href="{$a->url}">configurações da disciplina</a>.';
$string['showhintcourseguestenroleveryone'] = 'Todos os utilizadores do Moodle, incluindo aqueles que não têm conta, podem aceder gratuitamente ao conteúdo desta disciplina, sem necessidade de se inscreverem.';
$string['showhintcourseguestenroleveryonealways'] = 'Todos os utilizadores do Moodle, e mesmo aqueles que não têm conta no Moodle, podem aceder ao conteúdo desta disciplina sem se inscreverem, desde que conheçam a senha de acesso para visitantes.';
$string['showhintcourseguestenrolhint'] = 'Esta disciplina está atualmente visível para todos e permite <strong>acesso de visitante sem senha</strong>.';
$string['showhintcourseguestenrolhintalways'] = 'Esta disciplina está atualmente visível para todos e permite acesso de visitante com senha</strong>.';
$string['showhintcourseguestenrolsetting'] = 'Mostrar dica para a inscrição de visitante';
$string['showhintcourseguestenrolsetting_always'] = 'Sim, mesmo que esteja configurada uma senha de acesso para visitantes';
$string['showhintcourseguestenrolsetting_desc'] = 'Com esta configuração, uma dica aparecerá no cabeçalho da disciplina se a disciplina estiver visível e a inscrição de visitantes for possível no momento.';
$string['showhintcourseguestenrolsetting_note'] = 'Nota: Se quiser melhorar a dica com uma hiperligação para a disciplina de qualquer tipo, tem disponível o marcador {&dollar;a->courseid}, que pode ser utilizado na personalização do idioma.';
$string['showhintcourseguestenrolsetting_withoutpassword'] = 'Sim, mas apenas se não estiver configurada uma senha de acesso para visitantes';
$string['showhintcoursehiddengeneral'] = 'Esta disciplina está atualmente <strong>oculta</strong>. Apenas professores inscritos podem aceder à disciplina enquanto estiver oculta.';
$string['showhintcoursehiddensetting'] = 'Mostrar dica em disciplinas ocultas';
$string['showhintcoursehiddensetting_desc'] = 'Com esta configuração, uma dica aparecerá no cabeçalho da disciplina enquanto a visibilidade da disciplina estiver oculta. Isto ajuda a identificar rapidamente o estado de visibilidade de uma disciplina, sem ter de consultar as definições da disciplina.';
$string['showhintcoursehiddensettingslink'] = 'Pode alterar a visibilidade nas <a href="{$a->url}">configurações da disciplina</a>.';
$string['showhintcourseselfenrolfrom'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição sem restrições a partir de {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição sem restrições de {$a->from} até {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Se pretende que nenhum utilizador do Moodle tenha acesso livre a esta disciplina, restrinja as configurações de autoinscrição.';
$string['showhintcourseselfenrolsetting'] = 'Exibir dica para autoinscrição sem chave de inscrição';
$string['showhintcourseselfenrolsetting_desc'] = 'Com esta configuração, aparecerá uma dica no cabeçalho da disciplina se a disciplina estiver visível e se for possível inscrever-se sem chave de inscrição.';
$string['showhintcourseselfenrolsince'] = 'A instância de inscrição <strong>{$a->name}</strong> permite atualmente a autoinscrição sem restrições.';
$string['showhintcourseselfenrolsinceuntil'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição sem restrições até {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Esta disciplina está visível e permite <strong>autoinscrição sem chave</strong> neste momento.';
$string['showhintcourseselfenrolstartfuture'] = 'Esta disciplina está visível e irá permitir <strong>autoinscrição sem chave</strong> em breve.';
$string['showhintcourseselfenrolunlimited'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição sem restrições por tempo indeterminado.';
$string['showhintcourseselfenroluntil'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição sem restrições até {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Mostrar dica para acesso de visitante';
$string['showhintforumnotifications'] = 'Esta disciplina está atualmente <strong>oculta</strong>. Isto significa que os <strong>alunos não serão notificados</strong> online ou por e-mail sobre quaisquer mensagens que publique neste fórum.';
$string['showhintforumnotificationssetting'] = 'Exibir dica para notificações do fórum em disciplinas ocultas';
$string['showhintforumnotificationssetting_desc'] = 'Com esta configuração, uma dica aparecerá não só no cabeçalho da disciplina, mas também nos fóruns, desde que a visibilidade da disciplina esteja oculta. Isto serve para esclarecer que as notificações dentro de um fórum não são enviadas aos alunos e para ajudar os professores a compreender esta situação.';
$string['shownavbarstarredcourses_config'] = 'Configurar disciplinas com estrela na página \'{$a}\'';
$string['shownavbarstarredcourses_label'] = 'Disciplinas com estrela';
$string['shownavbarstarredcoursessetting'] = 'Disciplinas com estrela na barra de navegação';
$string['shownavbarstarredcoursessetting_desc'] = 'Com esta configuração, pode mostrar um menu pop-up com ligações para as disciplinas com estrela ao lado dos menus de mensagens e notificações.';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Mostrar o painel lateral direito da página inicial do site na primeira autenticação';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'Com esta configuração, o painel lateral direito da página inicial do site será apresentado expandido por predefinição. Isto aplica-se apenas aos utilizadores que acedem ao site pela primeira vez e não altera a configuração de cada utilizador individualmente.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Mostrar o painel lateral direito da página inicial do site ao iniciar sessão como visitante';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'Com esta configuração, o painel lateral direito da página inicial do site será apresentado expandido por predefinição. Isto aplica-se apenas a utilizadores que acedem ao site como visitantes.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Mostrar o painel lateral direito da página inicial do site ao visitar';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'Com esta configuração, o painel lateral direito da página inicial do site será apresentado expandido por predefinição. Isto aplica-se apenas a utilizadores que não estão autenticados e não substitui a configuração individual de cada utilizador.';
$string['showswitchedroleincoursesetting'] = 'Mostrar dica para troca de papel';
$string['showswitchedroleincoursesetting_desc'] = 'Com esta configuração, uma dica aparecerá no cabeçalho da disciplina se o utilizador tiver alterado o seu papel na disciplina. Por predefinição, esta informação é apenas apresentada junto ao avatar do utilizador no menu do utilizador. Ao ativar esta opção, pode exibir esta informação — juntamente com uma hiperligação para reverter a alteração — também na página da disciplina.';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'Por predefinição, na página de <a href="{$a}">gestão de disciplinas</a>, o Moodle exige que abra os detalhes da disciplina ou aceda às configurações da disciplina antes de clicar num elemento adicional da interface para o visualizar. Ao ativar esta configuração, pode adicionar um ícone "Ver disciplina" diretamente à lista de categorias na página de gestão de disciplinas.';
$string['showviewcourseiconincoursemgntsetting'] = 'Mostrar ícone de visualização da disciplina';
$string['sideentranceloginenablesetting'] = 'Ativar autenticação por entrada lateral';
$string['sideentranceloginenablesetting_desc'] = 'Pode ativar uma página de <a href="{$a->url}">início de sessão local por acesso lateral</a>. É automaticamente ativada se desativar o formulário de início de sessão local (ver acima), mas também pode ativá-la permanentemente para permitir que os utilizadores locais ignorem a página de início de sessão principal e o processo de início de sessão, o que é particularmente útil nas definições de SSO. Na página de autenticação local por acesso lateral, todas as medidas de segurança de autenticação do Moodle também se aplicam, é claro.';
$string['sideentranceloginheading'] = 'Autenticação por entrada lateral';
$string['sitebrandingtab'] = 'Identidade visual do site';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Painel lateral direito da página inicial';
$string['slidebackgroundimagealtsetting'] = 'Atributo alt da imagem de fundo do slide {$a->no}';
$string['slidebackgroundimagealtsetting_desc'] = 'Aqui, pode definir um atributo alt para a imagem do slide {$a->no}. Esta configuração é opcional; o slide será apresentado mesmo que não defina um atributo alt. Tenha em atenção que a ausência de um atributo alt reduz a acessibilidade.';
$string['slidebackgroundimagesetting'] = 'Imagem de fundo do slide {$a->no}';
$string['slidebackgroundimagesetting_desc'] = 'Aqui pode carregar um ficheiro de imagem que será apresentado como imagem de fundo atrás do conteúdo do slide {$a->no}. Certifique-se de que o conteúdo ainda está legível sobre a imagem de fundo. Verifique também se a proporção da imagem de fundo de todos os slides é igual (a proporção da imagem de fundo controla a altura do slide e pode querer evitar oscilações na imagem ao trocar de slide). Esta configuração é obrigatória. O slide não será apresentado se não carregar nenhuma imagem de fundo.';
$string['slidecaptionsetting'] = 'Legenda do slide {$a->no}';
$string['slidecaptionsetting_desc'] = 'Aqui insere a legenda que deve ser apresentada no slide {$a->no}. A legenda é apresentada na parte inferior central do slide. É uma configuração opcional. O slide será apresentado mesmo que não defina uma legenda.';
$string['slidecontentsetting'] = 'Conteúdo do slide {$a->no}';
$string['slidecontentsetting_desc'] = 'Aqui insere o conteúdo que deve ser apresentado no slide {$a->no}. O conteúdo é apresentado na parte inferior central do slide. Se for definida uma legenda, o conteúdo será apresentado abaixo dela. Tenha em atenção que o editor de Rich Text alinha o texto à esquerda por predefinição, mas pode alterá-lo para centrado para um aspeto mais agradável. Além disso, evite adicionar demasiado conteúdo ao slide e teste-o em dispositivos pequenos, uma vez que o conteúdo que ultrapasse os limites do slide será simplesmente ocultado. É uma configuração opcional. O slide será apresentado mesmo que não defina nenhum conteúdo.';
$string['slidecontentstylesetting'] = 'Estilo do conteúdo do slide {$a->no}';
$string['slidecontentstylesetting_dark'] = 'Escuro (cor do tipo de letra preta para imagens de fundo claras)';
$string['slidecontentstylesetting_darkshadow'] = 'Escuro e sombra (cor do tipo de letra preta com sombra clara para imagens de fundo claras)';
$string['slidecontentstylesetting_desc'] = 'Aqui pode modificar o estilo do conteúdo do slide {$a->no}. Por predefinição, o estilo do conteúdo é uma cor do tipo de letra branca para imagens de fundo escuro. No entanto, para permitir uma estilização consistente e fácil em todos os tipos de imagens de fundo, pode substituir o estilo aqui. Tenha em atenção que esta configuração substituirá a cor do tipo de letra definida no editor de Rich Text acima.';
$string['slidecontentstylesetting_light'] = 'Claro (cor do tipo de letra branca para imagens de fundo escuras)';
$string['slidecontentstylesetting_lightshadow'] = 'Claro e sombra (cor do tipo de letra branca com sombra escura para imagens de fundo escuras)';
$string['slideenabledsetting'] = 'Ativar slide {$a->no}';
$string['slideenabledsetting_desc'] = 'Com esta configuração, pode ativar o slide {$a->no}.';
$string['slideheading'] = 'Slide {$a->no}';
$string['slidelinksetting'] = 'Hiperligação do slide {$a->no}';
$string['slidelinksetting_desc'] = 'Pode definir um URL (interno ou externo ao Moodle) para o qual o conteúdo do slide {$a->no} será direcionado. Esta configuração é opcional; o slide será apresentado mesmo que não defina um URL.';
$string['slidelinksourcesetting'] = 'Origem da hiperligação do slide {$a->no}';
$string['slidelinksourcesetting_both'] = 'Imagem de fundo e elementos de texto';
$string['slidelinksourcesetting_desc'] = 'Pode controlar quais os elementos do controlo deslizante que serão ligados ao URL fornecido. Pode escolher entre ligar apenas a imagem de fundo, apenas os elementos de texto do slide (legenda e conteúdo) ou ambos.';
$string['slidelinksourcesetting_image'] = 'Apenas imagem de fundo';
$string['slidelinksourcesetting_text'] = 'Apenas elementos de texto';
$string['slidelinktargetsetting'] = 'Destino da hiperligação do slide {$a->no}';
$string['slidelinktargetsetting_desc'] = 'Pode definir o destino da hiperligação que é definido para a hiperligação do slide assim que definir um URL de hiperligação no slide {$a->no}.';
$string['slidelinktargetsetting_newtab'] = 'Novo separador';
$string['slidelinktargetsetting_samewindow'] = 'Mesma janela';
$string['slidelinktitlesetting'] = 'Título da hiperligação do slide {$a->no}';
$string['slidelinktitlesetting_desc'] = 'Pode definir um título para a hiperligação, que será apresentado como uma dica assim que o utilizador passar o cursor sobre o slide {$a->no}. Esta configuração é opcional; o slide será ligado mesmo que não defina um título para a hiperligação. Tenha em atenção que não fornecer um título para a hiperligação reduz a acessibilidade.';
$string['slideordersetting'] = 'Posição de ordem do slide {$a->no}';
$string['slideordersetting_desc'] = 'Com esta configuração, define a posição de ordem do slide {$a->no}. Por predefinição, os slides estão ordenados conforme os vê nesta página de configurações. No entanto, pode atribuir outra posição de ordem com esta configuração. Se atribuir a mesma posição de ordem a dois ou mais slides, estes serão novamente ordenados de acordo com a ordem desta página de configurações.';
$string['slideranimationsetting'] = 'Tipo de animação do controlo deslizante';
$string['slideranimationsetting_fade'] = 'Desvanecer';
$string['slideranimationsetting_slide'] = 'Slide';
$string['sliderarrownavsetting'] = 'Ativar a navegação por setas';
$string['sliderarrownavsetting_desc'] = 'Com esta configuração, pode adicionar setas de navegação em ambos os lados do controlo deslizante.';
$string['sliderfrontpagepositionsetting'] = 'Posição do controlo deslizante na página inicial do site';
$string['sliderfrontpagepositionsetting_afterafter'] = 'Após o conteúdo da página inicial do site (e após os blocos de anúncios)';
$string['sliderfrontpagepositionsetting_afterbefore'] = 'Após o conteúdo da página inicial do site (mas antes dos blocos de anúncios)';
$string['sliderfrontpagepositionsetting_beforeafter'] = 'Antes do conteúdo da página inicial do site (mas após os blocos de anúncios)';
$string['sliderfrontpagepositionsetting_beforebefore'] = 'Antes do conteúdo da página inicial do site (e antes dos blocos de anúncios)';
$string['sliderfrontpagepositionsetting_desc'] = 'O controlo deslizante é apresentado apenas na página inicial do site. Com esta definição, controla se o controlo deslizante é apresentado antes ou depois do conteúdo da página inicial. Se pretende apresentar apenas o controlo deslizante na página inicial e nada mais, todo o restante conteúdo da página inicial pode ser removido alterando as <a href="{$a->url}">configurações da página inicial</a>.';
$string['slidergeneralheading'] = 'Geral do controlo deslizante';
$string['sliderindicatornavsetting'] = 'Ativar indicador de navegação do controlo deslizante';
$string['sliderindicatornavsetting_desc'] = 'Com esta configuração, pode adicionar indicadores de navegação na parte inferior do controlo deslizante.';
$string['sliderintervalsetting'] = 'Velocidade do menu deslizante';
$string['sliderintervalsetting_desc'] = 'Com esta configuração, controla durante quanto tempo um slide é apresentado, em milissegundos. O valor mínimo é 1000 (um segundo) e o valor máximo é 10000 (10 segundos).';
$string['sliderkeyboardsetting'] = 'Permitir a interação do teclado com o menu deslizante';
$string['sliderkeyboardsetting_desc'] = 'Com esta configuração, ativa a utilização do teclado (teclas de seta) para controlar o controlo deslizante. Tenha em atenção que desativar esta opção reduz a acessibilidade.';
$string['sliderpausesetting'] = 'Pausar o menu deslizante ao passar o rato';
$string['sliderpausesetting_desc'] = 'Com esta configuração, impede que o controlo deslizante percorra os diapositivos quando o utilizador passa o cursor sobre um slide. Tenha em atenção que desativar esta opção reduz a acessibilidade.';
$string['sliderridesetting'] = 'Ciclicidade dos slides';
$string['sliderridesetting_afterinteraction'] = 'Após interação';
$string['sliderridesetting_desc'] = 'Com esta configuração, controla o comportamento da ciclicidade do controlo deslizante. "Ao carregar a página" inicia a alternância dos slides após o carregamento completo da página; "Após interação" inicia a alternância após o utilizador interagir com o controlo deslizante; "Nunca" desativa completamente a comutação automática dos slides, exigindo a interação do utilizador para que ocorra a mudança de slide.';
$string['sliderridesetting_never'] = 'Nunca';
$string['sliderridesetting_onpageload'] = 'Ao carregar a página';
$string['slidertab'] = 'Menu deslizante';
$string['sliderwrapsetting'] = 'Apresentar os slides continuamente';
$string['sliderwrapsetting_desc'] = 'Com esta configuração, o menu deslizante percorrerá todos os slides. Se a desativar, o menu deslizante parará no último slide.';
$string['smartmenus'] = 'Menus inteligentes';
$string['smartmenus_desc'] = '<p>Os menus inteligentes permitem que os administradores do site criem menus personalizáveis que podem ser colocados em diferentes locais do site, como o menu principal, o menu inferior em dispositivos móveis e o menu dos utilizadores. Os menus podem ser configurados para exibir diferentes tipos de conteúdo, incluindo hiperligações para outras páginas ou recursos, hiperligações de categorias ou hiperligações para perfis de utilizadores.</p><p>Os administradores do site podem criar um novo menu, especificar os itens do menu e definir configurações de exibição. O administrador também pode escolher onde o menu será exibido no site e se será visível para todos os utilizadores ou apenas para certos papéis de utilizador.</p>';
$string['smartmenusbyadmin'] = 'Mostrar a';
$string['smartmenusbyadmin_admins'] = 'Apenas a administradores';
$string['smartmenusbyadmin_all'] = 'Todos os utilizadores';
$string['smartmenusbyadmin_help'] = 'Restringir a visibilidade com base no facto de o utilizador ser ou não administrador do site.';
$string['smartmenusbyadmin_nonadmins'] = 'Apenas a não administradores';
$string['smartmenusbycohort'] = 'Por grupo global';
$string['smartmenusbycohort_help'] = 'Restringir a visibilidade com base nos grupos globais do utilizador.';
$string['smartmenusbydate'] = 'Por data';
$string['smartmenusbydate_help'] = 'Restringir a visibilidade com base na data';
$string['smartmenusbydatefrom'] = 'Desde';
$string['smartmenusbydatefrom_help'] = 'Restringir a visibilidade antes de ser atingida a data especificada.';
$string['smartmenusbydateuntil'] = 'Até';
$string['smartmenusbydateuntil_help'] = 'Restringir a visibilidade depois de ser atingida a data especificada.';
$string['smartmenusbylanguage'] = 'Por idioma';
$string['smartmenusbylanguage_help'] = 'Restringir a visibilidade com base no idioma do utilizador.';
$string['smartmenusbyrole'] = 'Por papel';
$string['smartmenusbyrole_help'] = 'Restringir a visibilidade com base nos papeis do utilizador.';
$string['smartmenusdynamiccoursescompletionstatus'] = 'Estado da conclusão';
$string['smartmenusdynamiccoursescompletionstatus_help'] = 'A lista de itens do menu de disciplinas dinâmicas conterá todos as disciplinas do utilizador que correspondam ao estado da conclusão selecionado. Por exemplo, se selecionar "A decorrer" como estado da conclusão, a lista de itens do menu de disciplinas dinâmicas conterá apenas as disciplinas em que o utilizador está a trabalhar atualmente.';
$string['smartmenusdynamiccoursescompletionstatuscompleted'] = 'Concluído';
$string['smartmenusdynamiccoursescompletionstatusenrolled'] = 'Inscrito';
$string['smartmenusdynamiccoursescompletionstatusinprogress'] = 'A decorrer';
$string['smartmenusdynamiccoursescoursecategory'] = 'Categoria da disciplina';
$string['smartmenusdynamiccoursescoursecategory_help'] = 'A lista de itens do menu de disciplinas dinâmicas incluirá todos as disciplinas das categorias selecionadas.';
$string['smartmenusdynamiccoursescoursecategorysubcats'] = 'Incluir subcategorias';
$string['smartmenusdynamiccoursescoursecategorysubcats_help'] = 'Se ativado, o menu de disciplinas dinâmicas também incluirá todos as disciplinas das subcategorias das categorias selecionadas.';
$string['smartmenusdynamiccoursesdaterange'] = 'Intervalo de datas';
$string['smartmenusdynamiccoursesdaterange_help'] = 'A lista de itens do menu de disciplinas dinâmicas incluirá todos as disciplinas que estejam dentro do intervalo de datas selecionado.';
$string['smartmenusdynamiccoursesdaterangefuture'] = 'Futuro';
$string['smartmenusdynamiccoursesdaterangepast'] = 'Passado';
$string['smartmenusdynamiccoursesdaterangepresent'] = 'Presente';
$string['smartmenusdynamiccoursesenrolmentrole'] = 'Data da inscrição';
$string['smartmenusdynamiccoursesenrolmentrole_help'] = 'A lista do menu de disciplinas dinâmicas incluirá todos as disciplinas onde o utilizador esteja inscrito com o papel selecionado.';
$string['smartmenusexperimental'] = 'Atenção: A funcionalidade de menus inteligentes é totalmente utilizável no estado atual de implementação, mas deve ser <em>considerada experimental</em> devido à grande quantidade de combinações de configurações que ainda podem gerar problemas inesperados. Por isso, teste cuidadosamente os seus menus inteligentes com as suas configurações individuais. Se encontrar problemas com menus inteligentes, relate-os no <a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github</a> com as etapas claras para reproduzir o problema.';
$string['smartmenusgeneralsectionheader'] = 'Configurações gerais';
$string['smartmenusmenuaddnewitem'] = 'Adicionar item de menu';
$string['smartmenusmenucardform'] = 'Forma de cartão';
$string['smartmenusmenucardform_help'] = 'Selecione o formato do cartão para menus em estilo de cartão, selecionando entre quadrado, retrato, paisagem ou largura total.';
$string['smartmenusmenucardformfullwidth'] = 'Largura total';
$string['smartmenusmenucardformlandscape'] = 'Paisagem';
$string['smartmenusmenucardformportrait'] = 'Retrato';
$string['smartmenusmenucardformsquare'] = 'Quadrado';
$string['smartmenusmenucardoverflowbehavior'] = 'Comportamento do extravasamento do cartão';
$string['smartmenusmenucardoverflowbehavior_help'] = 'Selecione como o menu deve comportar-se quando excede o tamanho do seu recipiente — podes escolher entre mostrar uma barra de scroll ou colocar os itens excedentes numa nova linha.';
$string['smartmenusmenucardoverflowbehaviornowrap'] = 'Não envolver';
$string['smartmenusmenucardoverflowbehaviorwrap'] = 'Envolver';
$string['smartmenusmenucardsize'] = 'Tamanho do cartão';
$string['smartmenusmenucardsize_help'] = 'Selecione o tamanho do cartão para menus em estilo de cartão, escolhendo entre minúsculo, pequeno, médio ou grande.';
$string['smartmenusmenucardsizelarge'] = 'Largo';
$string['smartmenusmenucardsizemedium'] = 'Médio';
$string['smartmenusmenucardsizesmall'] = 'Pequeno';
$string['smartmenusmenucardsizetiny'] = 'Estreito';
$string['smartmenusmenucreate'] = 'Criar menu';
$string['smartmenusmenucreatesuccess'] = 'Menu inteligente criado com sucesso';
$string['smartmenusmenucssclass'] = 'Classe CSS';
$string['smartmenusmenucssclass_help'] = 'Indique uma classe CSS para o menu. Isto pode ser utilizado para aplicar estilos personalizados ao menu.';
$string['smartmenusmenudeleteconfirm'] = 'Tem a certeza de que pretende apagar este menu dos menus inteligentes?';
$string['smartmenusmenudeletesuccess'] = 'Menu inteligente apagado com sucesso';
$string['smartmenusmenudescription'] = 'Descrição';
$string['smartmenusmenudescription_help'] = 'A descrição do menu. Será utilizada principalmente como documentação interna, mas também pode exibi-la dentro do menu utilizando a opção "Mostrar descrição".';
$string['smartmenusmenuduplicate'] = 'Duplicar menu e seus itens';
$string['smartmenusmenuduplicatesuccess'] = 'Menu e seus itens duplicados com sucesso';
$string['smartmenusmenuedit'] = 'Editar o menu';
$string['smartmenusmenueditsuccess'] = 'Menu inteligente atualizado com sucesso';
$string['smartmenusmenuitemcardappearanceheader'] = 'Aparência do cartão';
$string['smartmenusmenuitemcardbackgroundcolor'] = 'Cor de fundo do cartão';
$string['smartmenusmenuitemcardbackgroundcolor_help'] = 'Selecione a cor de fundo do cartão do item de menu.';
$string['smartmenusmenuitemcardimage'] = 'Imagem do cartão';
$string['smartmenusmenuitemcardimage_help'] = 'Selecione uma imagem para apresentar ao lado do título do item de menu no cartão.';
$string['smartmenusmenuitemcardimagealt'] = 'Texto alt da imagem do cartão';
$string['smartmenusmenuitemcardimagealt_help'] = 'Texto alternativo (alt) da imagem do cartão para este item de menu. Pode usar o espaço reservado `{menutitle}` para inserir automaticamente o título configurado do item. Se deixar em branco, o texto do item será usado como alt.';
$string['smartmenusmenuitemcardtextcolor'] = 'Cor do texto do cartão';
$string['smartmenusmenuitemcardtextcolor_help'] = 'Selecione a cor para o cartão do item do menu.';
$string['smartmenusmenuitemcreate'] = 'Criar item de menu';
$string['smartmenusmenuitemcreatesuccess'] = 'Item do menu inteligente criado com sucesso';
$string['smartmenusmenuitemcssclass'] = 'Classe CSS';
$string['smartmenusmenuitemcssclass_help'] = 'Indique uma classe CSS para o item de menu. Isto pode ser utilizado para aplicar estilos personalizados ao item de menu.';
$string['smartmenusmenuitemdeleteconfirm'] = 'Tem a certeza de que pretende apagar este item do menu inteligente?';
$string['smartmenusmenuitemdeletesuccess'] = 'Item do menu inteligente apagado com sucesso';
$string['smartmenusmenuitemdisplayallcourses'] = 'Mostrar disciplinas ocultas';
$string['smartmenusmenuitemdisplayfield'] = 'Apresentação do nome da disciplina';
$string['smartmenusmenuitemdisplayfield_help'] = 'O nome da disciplina que será utilizado como título dos itens do menu de disciplinas dinâmicas. Escolha entre o nome completo ou o nome curto da disciplina.';
$string['smartmenusmenuitemdisplayfieldcoursefullname'] = 'Nome completo da disciplina';
$string['smartmenusmenuitemdisplayfieldcourseshortname'] = 'Nome curto da disciplina';
$string['smartmenusmenuitemdisplayonlyvisiblecourses'] = 'Mostrar disciplinas ocultas';
$string['smartmenusmenuitemdisplayonlyvisiblecourses_help'] = 'Se ativado, a lista de disciplinas não mostrará disciplinas ocultas em nenhum menu inteligente — mesmo para administradores ou utilizadores com a permissão \'moodle/course:viewhiddencourses\'.';
$string['smartmenusmenuitemdisplayoptions'] = 'Apresentação do título';
$string['smartmenusmenuitemdisplayoptions_help'] = 'Selecione como pretende que o título do item de menu seja apresentado.';
$string['smartmenusmenuitemdisplayoptionshidetitle'] = 'Ocultar o título e mostrar apenas o ícone (em todos os dispositivos)';
$string['smartmenusmenuitemdisplayoptionshidetitlemobile'] = 'Ocultar o título e mostrar apenas o ícone (em dispositivos móveis)';
$string['smartmenusmenuitemdisplayoptionsshowtitleicon'] = 'Mostrar texto e ícone como título';
$string['smartmenusmenuitemduplicate'] = 'Duplicar item do menu';
$string['smartmenusmenuitemduplicatesuccess'] = 'Item do menu duplicado com sucesso';
$string['smartmenusmenuitemedit'] = 'Editar item do menu';
$string['smartmenusmenuitemeditsuccess'] = 'Item do menu inteligente atualizado com sucesso';
$string['smartmenusmenuitememail'] = 'E-mail do destinatário';
$string['smartmenusmenuitememail_help'] = 'O endereço de e-mail do destinatário para o item de menu. Este endereço será utilizado para criar uma hiperligação mailto que será aberta quando o item de menu for clicado.';
$string['smartmenusmenuitememail_required'] = 'Obrigatório – Indique um endereço de e-mail válido sem o prefixo ‘mailto:’.';
$string['smartmenusmenuitemhiddencoursesortingend'] = 'Mostrar disciplinas ocultas no final da lista de disciplinas';
$string['smartmenusmenuitemhiddencoursesortingtogether'] = 'Ordenar as disciplinas ocultas e visíveis em conjunto';
$string['smartmenusmenuitemhiddencoursessorting'] = 'Ordem das disciplinas ocultas';
$string['smartmenusmenuitemhiddencoursessorting_help'] = 'Selecione como as disciplinas ocultas devem ser ordenadas na lista de disciplinas dos itens de menu de disciplinas dinâmicas.';
$string['smartmenusmenuitemhidehiddencourses'] = 'Ocultar disciplinas ocultas';
$string['smartmenusmenuitemicon'] = 'Ícone';
$string['smartmenusmenuitemicon_ajaxtoomanyicons'] = 'Demasiados ícones ({$a}) para mostrar. Por favor, refine a sua pesquisa.';
$string['smartmenusmenuitemicon_help'] = 'O ícone a apresentar junto ao título do item de menu. <br /><br />Pode selecionar um ícone da biblioteca de ícones do Moodle ou utilizar um ícone do FontAwesome. Esta é uma diferença importante:<ul><li>Ícones do Moodle:<br />O Moodle define os seus ícones como "pix icons" e mapeia os ícones do FontAwesome para estes pix icons. Não há garantia de que o ícone específico do FontAwesome mapeado seja estável para sempre e pode mudar em versões futuras do Moodle. Além disso, existem pix icons Moodle que têm com uma cor Bootstrap adicional.</li><li>Ícones FontAwesome:<br />Os ícones FontAwesome são utilizados tal como estão e a sua apresentação permanecerá estável em versões futuras do Moodle. Pode acontecer que o glifo do FontAwesome mude se o Moodle for atualizado para uma versão futura do FontAwesome.</li></ul>Em caso de dúvida e se não precisar de utilizar um pix icon específico do Moodle, prefira utilizar um ícone do FontAwesome.';
$string['smartmenusmenuitemicon_noicon'] = 'Nenhum ícone selecionado';
$string['smartmenusmenuitemicon_placeholder'] = 'Selecione o ícone';
$string['smartmenusmenuitemicon_sourcecore'] = 'Core do Moodle';
$string['smartmenusmenuitemicon_sourcefablank'] = 'Ícone vazio do FontAwesome';
$string['smartmenusmenuitemicon_sourcefabrand'] = 'Marcas FontAwesome';
$string['smartmenusmenuitemicon_sourcefasolid'] = 'Ícone sólido do FontAwesome';
$string['smartmenusmenuitemlinktarget'] = 'Destino da hiperligação';
$string['smartmenusmenuitemlinktarget_help'] = 'O destino da hiperligação do item de menu. O item abrirá neste destino quando clicado (por exemplo, na mesma janela ou num novo separador).';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Novo separador';
$string['smartmenusmenuitemlinktargetsamewindow'] = 'Mesma janela';
$string['smartmenusmenuitemlistsort'] = 'Ordenação da lista de disciplinas';
$string['smartmenusmenuitemlistsort_help'] = 'A lista de disciplinas será ordenada pelos critérios e ordem selecionados. Podes escolher entre: nome completo, nome curto, ID da disciplina ou número de ID da disciplina, em combinação com ordem ascendente ou descendente.';
$string['smartmenusmenuitemlistsortcourseidasc'] = 'ID da disciplina ascendente';
$string['smartmenusmenuitemlistsortcourseiddesc'] = 'ID da disciplina descendente';
$string['smartmenusmenuitemlistsortcourseidnumberasc'] = 'ID da disciplina por ordem crescente';
$string['smartmenusmenuitemlistsortcourseidnumberdesc'] = 'ID da disciplina por ordem decrescente';
$string['smartmenusmenuitemlistsortfullnameasc'] = 'Nome completo da disciplina ascendente';
$string['smartmenusmenuitemlistsortfullnamedesc'] = 'Nome completo da disciplina descendente';
$string['smartmenusmenuitemlistsortshortnameasc'] = 'Nome curto da disciplina ascendente';
$string['smartmenusmenuitemlistsortshortnamedesc'] = 'Nome curto da disciplina descendente';
$string['smartmenusmenuitemmode'] = 'Modo do item do menu';
$string['smartmenusmenuitemmode_help'] = '<p>Selecione o modo como o item de menu deve ser apresentado dentro do menu.</p><ul><li>Embutido: O item de menu é apresentado como um item de menu normal dentro do menu. Esta é a opção predefinida.</li><li>Submenu: O item de menu é apresentado como um item de submenu, que pode ser expandido ou contraído clicando no item principal. Este modo é útil para criar um terceiro nível de navegação, bem como para itens de menu de disciplinas dinâmicas, em que as listas de disciplinas podem ser apresentadas como itens de submenu deste item de menu. O título deste item de menu é utilizado como texto do item de submenu.</li></ul>';
$string['smartmenusmenuitemnothingtodisplay'] = 'Ainda não existem itens adicionados a este menu inteligente. Adicione um item a este menu.';
$string['smartmenusmenuitemorder'] = 'Ordem';
$string['smartmenusmenuitemorder_help'] = 'Reorganize a posição deste item, se necessário. Todos os itens do menu serão ordenados com base neste valor.';
$string['smartmenusmenuitempresentationheader'] = 'Apresentação do item do menu';
$string['smartmenusmenuitemresponsive'] = 'Ocultação responsiva';
$string['smartmenusmenuitemresponsive_help'] = 'Ao ativar qualquer uma destas caixas de seleção, o item de menu ficará oculto em dispositivos com o tamanho de ecrã especificado.';
$string['smartmenusmenuitemresponsivedesktop'] = 'Secretária';
$string['smartmenusmenuitemresponsivemobile'] = 'Dispositivos móveis';
$string['smartmenusmenuitemresponsivetablet'] = 'Tablet';
$string['smartmenusmenuitemrestriction'] = 'Regras de acesso';
$string['smartmenusmenuitems'] = 'Itens do menu';
$string['smartmenusmenuitemstructureheader'] = 'Estrutura dos itens do menu';
$string['smartmenusmenuitemtextcount'] = 'Número de palavras';
$string['smartmenusmenuitemtextcount_help'] = 'Define o número máximo de palavras a apresentar como título nos itens do menu das disciplinas dinâmicas. Se deixar este campo em branco, o título será mostrado por completo.';
$string['smartmenusmenuitemtextposition'] = 'Posição do texto do cartão';
$string['smartmenusmenuitemtextposition_help'] = '<p>Selecione a posição do texto do item de menu em relação à imagem do cartão, escolhendo entre abaixo da imagem, sobreposição superior e sobreposição inferior.</p><ul><li>Sobreposição superior: Apresenta o título do item de menu sobre a sobreposição e na parte superior do cartão.</li><li>Sobreposição inferior: Apresenta o título do item de menu sobre a sobreposição e na parte inferior do cartão.</li><li>Abaixo da imagem: Apresenta o título do item de menu abaixo da imagem do cartão.</li></ul>';
$string['smartmenusmenuitemtextpositionbelowimage'] = 'Por baixo da imagem';
$string['smartmenusmenuitemtextpositionoverlaybottom'] = 'Sobreposição inferior';
$string['smartmenusmenuitemtextpositionoverlaytop'] = 'Sobreposição superior';
$string['smartmenusmenuitemtitle'] = 'Título';
$string['smartmenusmenuitemtitle_help'] = 'O título do menu. Será usado como etiqueta deste item do menu.';
$string['smartmenusmenuitemtooltip'] = 'Dica';
$string['smartmenusmenuitemtooltip_help'] = 'A dica que será apresentada quando o utilizador passar o cursor sobre o item de menu.';
$string['smartmenusmenuitemtype'] = 'Tipo dos itens do menu';
$string['smartmenusmenuitemtype_help'] = '<p>Selecione o tipo de item de menu que pretende criar, escolhendo entre estático, mailto, título, documentação do Moodle, disciplinas dinâmicas e divisor.</p><ul><li>Estático: Um item de menu estático é simplesmente uma hiperligação para um URL fixo que não muda.</li><li>Mailto: Um item de menu mailto abre o cliente de e-mail predefinido do utilizador para compor uma mensagem para o endereço de e-mail especificado.</li><li>Título: Um item de menu de título é utilizado para agrupar itens de menu relacionados sob um título comum. Não tem ligação e não é clicável.</li><li>Separador: Um item \'dividerenu\' apresenta uma linha horizontal no menu para separar visualmente grupos de itens de menu.</li><li>Documentação do Moodle: Um item de menu de documentação do Moodle é utilizado para criar uma ligação para o artigo correspondente da documentação do Moodle, semelhante à ligação da documentação do Moodle localizada no rodapé do Moodle (ícone de ponto de interrogação).</li><li>Disciplinas dinâmicas: Um item de menu de disciplinas dinâmicas é utilizado para apresentar uma lista de disciplinas com base em determinados critérios, tais como a categoria da disciplina, o papel de inscrição na disciplina, o estado de conclusão da disciplina ou o intervalo de datas. O conteúdo apresentado num item de menu de disciplinas dinâmicas será atualizado automaticamente à medida que os critérios forem alterados.</li></ul>';
$string['smartmenusmenuitemtypedivider'] = 'Separador';
$string['smartmenusmenuitemtypedocs'] = 'Documentação do Moodle';
$string['smartmenusmenuitemtypedynamiccourses'] = 'Disciplinas dinâmicas';
$string['smartmenusmenuitemtypeheading'] = 'Cabeçalho';
$string['smartmenusmenuitemtypemailto'] = 'Mailto';
$string['smartmenusmenuitemtypestatic'] = 'Estático';
$string['smartmenusmenuitemurl'] = 'URL do item de menu';
$string['smartmenusmenuitemurl_help'] = 'O URL estático do item de menu. É a hiperligação que será acedida ao clicar no item de menu.';
$string['smartmenusmenulocation'] = 'Localização do menu';
$string['smartmenusmenulocation_help'] = '<p>Selecione o(s) local(is) onde pretende que o menu apareça na página:</p><ul><li>A navegação principal encontra-se na parte superior da página, onde o Moodle já apresenta os itens de navegação Página inicial, Painel do utilizador, Minhas disciplinas e Administração do Site.</li><li>A barra de menus está localizada acima da navegação principal, na parte superior da página.</li><li>O menu do utilizador pode ser acedido clicando no avatar do utilizador na barra de navegação.</li><li>A barra inferior encontra-se no inferior do ecrã e pode ser utilizado para implementar uma navegação por miniaturas para facilitar o acesso a áreas importantes, como o Painel do utilizador, a página Minhas disciplinas ou a Página inicial.</li></ul><p>Tenha em atenção que, ao ativar a barra inferior, o ícone do menu (três linhas horizontais) será substituído pelo logótipo do seu site, uma vez que os utilizadores poderão aceder à navegação principal utilizando a barra inferior.</p>';
$string['smartmenusmenulocationbottom'] = 'Barra inferior';
$string['smartmenusmenulocationmain'] = 'Navegação principal';
$string['smartmenusmenulocationmenu'] = 'Barra de menu';
$string['smartmenusmenulocationuser'] = 'Menu do utilizador';
$string['smartmenusmenumode'] = 'Nó de menu';
$string['smartmenusmenumode_help'] = '<p>Selecione o modo como os itens do menu devem ser apresentados.</p><ul><li>Submenu: Os itens do menu são apresentados como um submenu com o título do menu como nó ascendente. Esta é a opção predefinida.</li><li>Embutido: Os itens do menu são apresentados diretamente na navegação, um após o outro. Tenha em atenção que esta opção não é compatível com menus do tipo cartão.</li></ul>';
$string['smartmenusmenumoremenubehavior'] = 'Comportamentos de Mais';
$string['smartmenusmenumoremenubehavior_help'] = '<p>Selecione o que deve acontecer se existirem demasiados menus para caberem no espaço disponível.</p><ul><li>Não alterar nada: não será imposto qualquer comportamento específico; os menus excedentes serão movidos automaticamente para o menu "Mais".</li><li>Forçar o acesso ao menu "Mais": este modo move o menu diretamente para o menu "Mais", mesmo que ainda haja espaço.</li><li>Manter fora do menu "Mais": este modo mantém o menu fora do menu "Mais" tanto quanto possível, movendo os menus subsequentes para o menu "Mais", se necessário.</li></ul><p>Tenha em atenção que esta definição apenas afeta os menus localizados na navegação principal ou na barra de menu.</p>';
$string['smartmenusmenumoremenubehaviorforceinto'] = 'Forçar o acesso ao menu mais';
$string['smartmenusmenumoremenubehaviorkeepoutside'] = 'Manter fora do menu mais';
$string['smartmenusmenunothingtodisplay'] = 'Ainda não existem menus inteligentes criados. Crie o seu primeiro menu inteligente para começar.';
$string['smartmenusmenupresentationheader'] = 'Apresentação do menu';
$string['smartmenusmenushowdescription'] = 'Mostrar descrição';
$string['smartmenusmenushowdescription_help'] = '<p>Selecione se/como a descrição deve ser apresentada no menu, escolhendo entre Nunca, Acima, Abaixo e Ajuda.</p><ul><li>Nunca: Não apresentar a descrição no menu e utilizá-la apenas para fins internos. Esta é a opção predefinida.</li><li>Acima: Apresentar a descrição no topo da lista de itens do menu.</li><li>Abaixo: Apresentar a descrição no final da lista de itens do menu.</li><li>Ajuda: Apresentar a descrição como um ícone de ajuda junto à lista de itens do menu.</li></ul>';
$string['smartmenusmenushowdescriptionabove'] = 'Acima';
$string['smartmenusmenushowdescriptionbelow'] = 'Abaixo';
$string['smartmenusmenushowdescriptionhelp'] = 'Ajuda';
$string['smartmenusmenushowdescriptionnever'] = 'Nunca';
$string['smartmenusmenustructureheader'] = 'Estrutura do menu';
$string['smartmenusmenutitle'] = 'Título';
$string['smartmenusmenutitle_help'] = 'O título do menu. Será usado como etiqueta do nó ascendente deste menu.';
$string['smartmenusmenutype'] = 'Tipo de apresentação';
$string['smartmenusmenutype_help'] = '<p>Selecione o tipo de apresentação para o menu, escolhendo entre lista e cartão.</p><ul><li>Lista: Um menu em lista é composto por ligações de texto simples. Esta é a opção predefinida.</li><li>Cartão: Um menu em cartão é composto por cartões.</li></ul>';
$string['smartmenusmenutypecard'] = 'Cartão';
$string['smartmenusmenutypelist'] = 'Lista';
$string['smartmenusmodeinline'] = 'Embutido';
$string['smartmenusmodesubmenu'] = 'Submenu';
$string['smartmenusnorestrict'] = 'Sem restrições';
$string['smartmenusoperator'] = 'Operador';
$string['smartmenusoperator_help'] = 'Selecione o operador para a condição de grupo global (Qualquer ou Todos)';
$string['smartmenusrestrictbyadminheader'] = 'Restringir a visibilidade por estado de administrador do site';
$string['smartmenusrestrictbycohortsheader'] = 'Restringir a visibilidade por grupo global';
$string['smartmenusrestrictbydateheader'] = 'Restringir a visibilidade por data';
$string['smartmenusrestrictbylanguageheader'] = 'Restringir a visibilidade por idioma';
$string['smartmenusrestrictbyrolesheader'] = 'Restringir a visibilidade por papéis';
$string['smartmenusrolecontext'] = 'Contexto';
$string['smartmenusrolecontext_help'] = 'Selecione o contexto para o qual o papel do utilizador deve ser verificado (qualquer contexto ou apenas contexto do sistema).';
$string['smartmenussavechangesandconfigure'] = 'Guardar e configurar itens';
$string['smartmenussettings'] = 'Configurações do menu inteligente';
$string['snippetsbuiltinsnippetsheading'] = 'Excertos de código SCSS integrados';
$string['snippetscreator'] = 'Criador';
$string['snippetsdescription'] = 'Descrição';
$string['snippetsdetails'] = 'Detalhes';
$string['snippetsdetailspreview'] = 'Pré-visualização';
$string['snippetsdisable'] = 'Desativar';
$string['snippetsenable'] = 'Ativar';
$string['snippetsgoal'] = 'Objetivo';
$string['snippetsgoalaccessibility'] = 'Acessibilidade';
$string['snippetsgoalbugfix'] = 'Correção de erro';
$string['snippetsgoaldevsonly'] = 'Exclusivo para programadores';
$string['snippetsgoaleaseofuse'] = 'Facilidade de utilização';
$string['snippetsgoaleyecandy'] = 'Atração visual';
$string['snippetsnothingtodisplay'] = 'Não existem excertos de código SCSS disponíveis. Aceda ao separador "Configurações" e ative os excertos de código SCSS integrados ou carregue os seus próprios excertos de código SCSS.';
$string['snippetsoverview'] = 'Visão global';
$string['snippetsoverview_desc'] = 'Os excertos SCSS do Boost Union oferecem a possibilidade de adicionar pequenas (ou ligeiramente maiores) quantidades de SCSS ao site Moodle. Isto pode ser particularmente útil para corrigir pequenos problemas visuais no core do Moodle ou para adicionar elementos visuais apelativos ao seu site Moodle.';
$string['snippetsoverview_notes'] = 'Para que possa utilizar excertos de CSS, leia estas instruções básicas:';
$string['snippetsoverview_notes1'] = 'Os excertos de código SCSS podem vir de várias origens. Ative e configure cada origem no separador "Configurações". Assim que ativar pelo menos uma origem, a lista de excertos de código será aqui apresentada.';
$string['snippetsoverview_notes2'] = 'Os excertos de código SCSS são adicionados à pilha SCSS um após o outro. Por isso, a ordem dos excertos nesta página é fundamental.';
$string['snippetsoverview_notes3'] = 'Após cada alteração efetuada nesta página, a cache do tema é limpa. É necessário para garantir que o código SCSS compilado e enviado para o navegador está atualizado e pode demorar alguns segundos.';
$string['snippetsscope'] = 'Âmbito';
$string['snippetsscopecourse'] = 'Disciplina';
$string['snippetsscopedashboard'] = 'Painel do utilizador';
$string['snippetsscopeglobal'] = 'Global';
$string['snippetsscopesitehome'] = 'Página inicial do site';
$string['snippetssettings'] = 'Configurações';
$string['snippetsshowdetails'] = 'Mostrar detalhes';
$string['snippetsshowthecode'] = 'Mostrar o código SCSS';
$string['snippetssnippets'] = 'Excertos SCSS';
$string['snippetssource'] = 'Origem';
$string['snippetssourcetheme_boost_union'] = 'Integrados no Boost Union';
$string['snippetssourceuploaded'] = 'Carregar';
$string['snippetstestedon'] = 'Testado em';
$string['snippetstitle'] = 'Título';
$string['snippetstrackerissue'] = 'Monitor de erros';
$string['snippetsuploadedsnippetsheading'] = 'Excertos carregados';
$string['snippetsuploadedsnippetsheading_desc'] = 'Para além dos excertos SCSS integrados, oficialmente mantidos pela equipa do Boost Union, existe o repositório de <a href="{$a}" target="_blank">excertos SCSS no Github</a>, que funciona como um ponto central da comunidade para os excertos SCSS do Boost Union. Nesse repositório, encontrará instruções para utilizar os excertos SCSS da comunidade, bem como o modelo para criar os seus próprios excertos SCSS locais.';
$string['snippetsusagenote'] = 'Nota de utilização';
$string['speciallinksmarkupheading'] = 'Marcação de hiperligações especiais';
$string['starredcourseslinktargetsetting'] = 'Atalho do ícone das disciplinas com estrela';
$string['starredcourseslinktargetsetting_desc'] = 'Com esta configuração, pode definir o destino da hiperligação do ícone de engrenagem no pop-up das disciplinas com estrela. Por predefinição, o ícone da engrenagem leva à página "Minhas disciplinas". No entanto, também pode adicionar um atalho para a página "Painel do utilizador", especialmente se tiver desativado a página "Minhas disciplinas" na navegação principal.';
$string['staticpagestab'] = 'Páginas estáticas';
$string['switchedroleto'] = 'Neste momento está a visualizar esta disciplina com o papel de: <strong>{$a->role}</strong>';
$string['task_purgecache'] = 'Limpar cache do tema';
$string['tertiarysettings'] = 'Lista das páginas das configurações do Boost Union';
$string['tilebackgroundimagepositionsetting'] = 'Posição da imagem de fundo do bloco de anúncio {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Com esta configuração, controla o posicionamento da imagem de fundo dentro do contentor do bloco de anúncio {$a->no}. O primeiro valor é a posição horizontal e o segundo valor é a posição vertical.';
$string['tilebackgroundimagesetting'] = 'Imagem de fundo do bloco de anúncio {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Pode carregar um ficheiro de imagem que será apresentado como imagem de fundo atrás do conteúdo do bloco de anúncio {$a->no}. Certifique-se de que o conteúdo ainda está legível sobre a imagem de fundo. Esta configuração é opcional; o bloco de anúncio funcionará mesmo que não carregue a imagem de fundo.';
$string['tilecolumnssetting'] = 'Colunas de anúncios por linha';
$string['tilecolumnssetting_desc'] = 'Define o número de colunas por linha na grelha de blocos de anúncios apresentada. Tenha em atenção que este número de colunas aplica-se a computadores/ecrãs maiores. Em ecrãs mais pequenos e dispositivos móveis, as colunas dos blocos de anúncios são ajustadas automaticamente.';
$string['tilecontentsetting'] = 'Conteúdo do bloco de anúncio {$a->no}';
$string['tilecontentsetting_desc'] = 'Aqui, indica o conteúdo que deve ser exibido no bloco de anúncio {$a->no}. O conteúdo é exibido no meio do bloco. Esta é uma configuração opcional, o bloco será mostrado mesmo sem conteúdo definido.';
$string['tilecontentstylesetting'] = 'Estilo do conteúdo do bloco de anúncio {$a->no}';
$string['tilecontentstylesetting_dark'] = 'Escuro (cor do tipo de letra preta para imagens de fundo claras)';
$string['tilecontentstylesetting_darkshadow'] = 'Escuro e sombra (cor do tipo de letra preta com sombra clara para imagens de fundo claras)';
$string['tilecontentstylesetting_desc'] = 'Aqui pode modificar o estilo do conteúdo do bloco de anúncio {$a->no}. Por predefinição, o estilo do conteúdo é controlado pelo estilo definido no editor de Rich Text acima. No entanto, para permitir um estilo fácil e consistente, especialmente ao usar texto em imagens de fundo, pode substituir o estilo aqui.';
$string['tilecontentstylesetting_light'] = 'Claro (cor do tipo de letra branca para imagens de fundo escuras)';
$string['tilecontentstylesetting_lightshadow'] = 'Claro e sombra (cor do tipo de letra branca com sombra escura para imagens de fundo escuras)';
$string['tilecontentstylesetting_nochange'] = 'Sem alteração (controle todo o estilo no editor Rich Text)';
$string['tileenabledsetting'] = 'Ativar bloco de anúncio {$a->no}';
$string['tileenabledsetting_desc'] = 'Com esta configuração, pode ativar o bloco de anúncio {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Posição dos blocos de anúncios no site';
$string['tilefrontpagepositionsetting_after'] = 'Após o conteúdo da página inicial do site';
$string['tilefrontpagepositionsetting_before'] = 'Antes do conteúdo da página inicial do site';
$string['tilefrontpagepositionsetting_desc'] = 'Os blocos de anúncios são apresentados apenas na página inicial do site. Com esta configuração, controla se os blocos de anúncios são apresentados antes ou depois do conteúdo da página inicial. Se pretende apresentar apenas os blocos de anúncios na página inicial e nada mais, todo o restante conteúdo da página inicial pode ser removido alterando as <a href="{$a->url}">configurações da página inicial</a>.';
$string['tileheading'] = 'Título do bloco de anúncio {$a->no}';
$string['tileheightsetting'] = 'Altura do bloco de anúncio';
$string['tileheightsetting_desc'] = 'Com esta configuração, controla a altura dos blocos de anúncios. A altura configurada é a altura mínima de cada bloco. Se o conteúdo de um bloco for superior à altura configurada, toda a linha de blocos será automaticamente elevada conforme necessário.';
$string['tilelinksetting'] = 'Hiperligação do URL do bloco de anúncio {$a->no}';
$string['tilelinksetting_desc'] = 'Pode definir um URL (interno ou externo ao Moodle) que será apresentado como um botão de hiperligação no final do bloco de anúncio {$a->no}. Esta configuração é opcional; o bloco de anúncio funcionará mesmo que não defina nenhum URL.';
$string['tilelinktargetsetting'] = 'Destino da hiperligação do bloco de anúncio {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Pode definir o destino da hiperligação que é definido para o botão de hiperligação assim que definir um URL no bloco de anúncio {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Novo separador';
$string['tilelinktargetsetting_samewindow'] = 'Mesma janela';
$string['tilelinktitlefallback'] = 'Hiperligação';
$string['tilelinktitlesetting'] = 'Título da hiperligação do bloco de anúncio {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Pode definir um título para a hiperligação, que será utilizado como etiqueta do botão da hiperligação assim que definir um URL no bloco de anúncio {$a->no}. Tenha em atenção que se definir um URL, mas não definir um título para a hiperligação, o botão da hiperligação será rotulado apenas com \'Hiperligação\'.';
$string['tileordersetting'] = 'Posição de ordem do bloco de anúncio {$a->no}';
$string['tileordersetting_desc'] = 'Com esta configuração, define a posição de ordem do bloco de anúncio {$a->no}. Por predefinição, os blocos de anúncios estão ordenados de cima para baixo e da esquerda para a direita, como vê nesta página de configurações. No entanto, pode definir outra posição de ordem com esta configuração. Se atribuir a mesma posição de ordem a dois ou mais blocos de anúncios, estes serão reordenados de acordo com a ordem desta página de configurações.';
$string['tilesgeneralheading'] = 'Blocos de anúncio geral';
$string['tilestab'] = 'Blocos de anúncio';
$string['tiletitlesetting'] = 'Título do bloco de anúncio {$a->no}';
$string['tiletitlesetting_desc'] = 'Aqui, indica o título que deve ser exibido no bloco de anúncio {$a->no}. Esta é uma configuração opcional, o bloco de anúncio será mostrado mesmo que não defina um título.';
$string['timelineheading'] = 'Bloco Cronograma';
$string['timelinetintenabled'] = 'Colorir ícones de atividades no cronograma';
$string['timelinetintenabled_desc'] = 'Com esta configuração, pode colorir os ícones de atividades no bloco Cronograma com base nos propósitos da atividade. Por predefinição, o Moodle exibe-os como ícones pretos.';
$string['touchiconfilesios'] = 'Ficheiros de ícones táteis para iOS';
$string['touchiconfilesios_desc'] = 'Nesta configuração, pode carregar ficheiros usados como ícones de ecrã principal quando o site Moodle é adicionado como favorito ao ecrã principal do iOS.';
$string['touchiconfilesios_example'] = 'Exemplo de nome de ficheiro: apple-icon-152x152.png';
$string['touchiconfilesios_note'] = 'Os ficheiros recomendados têm um bom tamanho para serem exibidos adequadamente em dispositivos iOS atuais e devem ser fornecidos. Os ficheiros opcionais são (ou já foram) suportados por dispositivos iOS, mas devem ser considerados opcionais, a menos que necessite de dar suporte a dispositivos legados específicos.';
$string['touchiconfilesios_optional'] = 'Ficheiros opcionais para iOS:';
$string['touchiconfilesios_recommended'] = 'Ficheiros recomendados para iOS:';
$string['touchiconfilesioslist'] = 'Lista de ficheiros de ícones táteis para iOS';
$string['touchiconfilesioslist_desc'] = 'Esta é a lista de ficheiros que carregou na área de ficheiros de ícones táteis para iOS.';
$string['touchiconlistiosoptionalmissing'] = 'Este é um ficheiro opcional para ser usado como ícone tátil em dispositivos iOS, mas não foi carregado.';
$string['touchiconlistiosoptionaluploaded'] = 'Este é um ficheiro opcional para ser usado como ícone tátil em dispositivos iOS e foi carregado.';
$string['touchiconlistiosrecommendedmissing'] = 'Este é um ficheiro recomendado para ser usado como ícone tátil em dispositivos iOS, mas não foi carregado.';
$string['touchiconlistiosrecommendeduploaded'] = 'Este é um ficheiro recomendado para ser usado como ícone tátil em dispositivos iOS e foi carregado.';
$string['upcomingeventsheading'] = 'Bloco Próximos eventos';
$string['upcomingeventstintenabled'] = 'Colorir ícones de atividades em Próximos eventos';
$string['upcomingeventstintenabled_desc'] = 'Com esta configuração, pode colorir os ícones de atividades no bloco Próximos eventos com base nos propósitos da atividade. Por predefinição, o Moodle exibe-os como ícones pretos.';
$string['upgradenotice_2022080922'] = 'A partir desta versão, Boost Union tem as suas próprias configurações de logótipo e logotipo compacto e não usa mais esses arquivos das configurações do núcleo do Moodle.';
$string['upgradenotice_2022080922_copied'] = 'O <strong>{$a}</strong> existente nas configurações principais do Moodle foi copiado para a configuração Boost Union {$a} durante esta atualização. Verifique novamente o resultado.';
$string['upgradenotice_2022080922_logo'] = 'logótipo';
$string['upgradenotice_2022080922_logocompact'] = 'logótipo compacto';
$string['upgradenotice_2022080922_notcopied'] = 'A configuração <strong>{$a}</strong> em Boost Union está vazia agora. Se pretender usar um {$a} dentro do Boost Union a partir de agora, basta carregá-lo na configuração Boost Union {$a} mais tarde.';
$string['upgradenotice_2025041410'] = 'A configuração "Mostrar dica para acesso de visitante" foi atualizada para oferecer mais opções. A sua configuração atual (que estava definida como "Sim") foi migrada para a nova opção "Sim, mas apenas se não estiver configurada uma senha de acesso para visitantes".';
$string['upgradenotice_2025041413'] = 'A configuração “courselistinghowfields” foi renomeada para “courselistingshowfields” para corrigir um erro tipográfico. A tua configuração foi migrada para o novo nome.';
$string['upgradenotice_2025041416'] = 'Os separadores de menu inteligentes estão agora disponíveis como um tipo de item de menu dedicado. Os separadores existentes (criados utilizando o tipo cabeçalho com sinais #) foram automaticamente convertidos para o novo tipo de separador.';
$string['uploadedsnippets'] = 'Carregar excertos';
$string['uploadedsnippets_desc'] = 'Pode enviar ficheiros individuais de excertos de código SCSS ou um ficheiro ZIP contendo vários ficheiros de excertos de código SCSS. O ficheiro ZIP será extraído automaticamente e os excertos de código SCSS nele contidos ficarão disponíveis nesta área como ficheiros individuais.';
$string['uploadedsnippets_note'] = 'Pode encontrar a estrutura e a sintaxe dos excertos SCSS do Boost Union no nosso <a href="{$a->url}" target="_blank">repositório de excertos SCSS</a>. Aí, também encontrará instruções sobre como utilizar excertos existentes da comunidade e contribuir com excertos para a comunidade.';
$string['usermenuheading'] = 'Menu do utilizador';
$string['warningboostunioninactive'] = 'O Boost Union (ou um tema descendente do Boost Union) não é o tema ativo neste momento. As definições destas páginas não terão qualquer efeito se não tornar o Boost Union o tema ativo ou permitir que seja utilizado como tema de categoria/disciplina/utilizador/grupo global.';
$string['warningslashargumentsdisabled'] = 'Atenção: A opção <a href="{$a->url}">slasharguments</a> está desativada na configuração do Moodle. No entanto, esta opção é necessária para o funcionamento correto da seguinte configuração do Boost Union. Ativa os slasharguments, caso contrário esta configuração não terá qualquer efeito.';
