<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_zebra', language 'sr_lt', version '4.5'.
 *
 * @package     theme_zebra
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['backgroundurl'] = 'URL adresa pozadine';
$string['backgroundurldesc'] = '<p>Unesite URL adresu vaše slike pozadine.</p><p>Možete da koristite Moodle Output format putanje (u odnosu na temu), punu ili relativnu putanju.</p>';
$string['bodybgcolor'] = 'Boja pozadine tela stranice';
$string['bodybgcolordesc'] = '<p>Glavna boja pozadine stranice.</p><p>Ovo se primenjuje na HTML tag <code>&lt;body&gt;</code>.</p>';
$string['branding'] = 'Sakrij logotipe u podnožju stranice';
$string['brandingdesc'] = '<p>Sakrij brendirane logotipe u podnožju stranice.</p><p>Ovo su linkovi ka sajtovima koji su sponzori ili su direktno doprineli razvoju ove teme. Detaljnije informacije o temi mogu se naći kada se ona izabere u selektoru tema.</p>';
$string['calcourse'] = 'Kalendar događaja na kursu';
$string['calcoursedesc'] = '<p>Podešava boju koja se koristi za predstavljanje događaja na kursu u kalendaru.</p>';
$string['calglobal'] = 'Kalendar globalnih događaja';
$string['calglobaldesc'] = '<p>Podešava boju koja se koristi za predstavljanje globalnih događaja u kalendaru.</p>';
$string['calgroup'] = 'Kalendar grupnih događaja';
$string['calgroupdesc'] = '<p>Podešava boju koja se koristi za predstavljanje grupnih događaja u kalendaru.</p>';
$string['callink'] = 'Link ka kalendaru';
$string['callinkdesc'] = '<p> Prikaži datum sa linkom ka kalendaru na kraju prilagođenog menija.</p>';
$string['caluser'] = 'Kalendar korisničkih događaja';
$string['caluserdesc'] = '<p>Podešava boju koja se koristi za predstavljanje korisničkih događaja u kalendaru.</p>';
$string['calweekend'] = 'Boja za dane vikenda u kalendaru';
$string['calweekenddesc'] = '<p>Određuje boju fonta koji se koristi za dane vikenda u kalendaru.</p>';
$string['cfmaxversion'] = 'Maksimalna verzija Internet Explorera';
$string['cfmaxversiondesc'] = '<p>Napomena: <a href="#admin-usecf"><code>usecf</code></a> mora biti uključeno da bi ovo radilo.</p><p>Ovo je maksimalna verzija Internet Explorera koja će od korisnika tražiti da instaliraju Chrome Frame. Novije verzije ovo neće tražiti.</p>';
$string['choosereadme'] = '<div class="clearfix"> <h2>Zebra</h2> <hr> <h3>O grafičkoj temi</h3> <p>Zebra je adaptivna tema, prvenstveno namenjena mobilnim uređajima, koja koristi CSS3 kako bi reorganizovala strukturu stranice i prilagodila njen prikaz svakom uređaju.</p>
<p>Zebra, na stranici za podešavanje teme, takođe obezbeđuje veliki broj opcija za prilagođavanje, uključujući boje, logotipe, adaptivna podešavanja, kao i opcije za prilagođeni CSS i JavaScript.</p>
<h3>Matične teme</h3> <p>Ova tema je izgrađena na temi Base, ali koristi prilagođeni prelom stranice i dok. Ova, kao i sve druge teme uključene u osnovni paket Moodlea, objavljene su pod licencom <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p> <p>Osnovni prelom stranice (<a href="http://iyware.com/antioch">antioch</a>), dizajnirao je Danny Wahl @<a href="http://iyware.com">iyWare</a> nezavisno od Moodlea 2.0, i može se koristiti samostalno, takođe pod licencom GNU General Public License v3.</p> <h3>Ostale komponente</h3>
<p>Ova tema koristi druge biblioteke otvorenog kôda i prava nad tim bibliotekama pripadaju njihovim autorima. Više informacije možete naći na stranici <a href="../admin/settings.php?section=themesettingzebra">Podešavanja teme Zebra</a>.</p> <h3>Form o temi:</h3>
<p><a href="https://moodle.org/mod/forum/discuss.php?d=217191">https://moodle.org/mod/forum/discuss.php?d=217191</a></p> <h3>URL adresa teme:</h3> <p><a href="https://moodle.org/plugins/view.php?plugin=theme_zebra">http://moodle.org/plugins/view.php?plugin=theme_zebra</a></p> <h3>Tema – Zasluge (autor teme)</h3> <p><a href="http://iyware.com">Danny Wahl</a></p> <h3>Ne zaboravite da prilagodite svoja podešavanja!</h3> <a href="../admin/settings.php?section=themesettingzebra">Zebra Theme Settings</a> </div> </div>';
$string['colorscheme'] = 'Shema boja';
$string['colorschemedesc'] = '<p>Gradijenti i svetle površine.</p><p>Napomena: Safari 4 ne prihvata fiksnu visinu gradijenta, tako da će uvek prikazati kao "nijedan"..</p>';
$string['colorsinfo'] = 'Opšta podešavanja boja';
$string['colorsinfodesc'] = '<p>Promenite podešavanja za boje stranice.</p><p>Možete da koristite bilo koji važeći tip boje, kao <code>red</code>, <code>#FF0000</code>, <code>rgb(0, 255, 255)</code>, ili <code>rgba(0, 255, 255, 1.0)</code>.</p>';
$string['columnbgcolor'] = 'Boja pozadine kolona';
$string['columnbgcolordesc'] = '<p>Boja pozadine kolone(a).</p><p>Ovo se primenjuje na različite elemente zavisno od trenutnog prikaza (molimo vas, pogledajte pagelayout.css za više informacija), ali generalno, tiče se područja blokova ("region-pre" i "region-post").</p>';
$string['columninfo'] = 'Podešavanja rasporeda elemenata stranice';
$string['columninfodesc'] = '<p>Promenite raspored elemenata stranice. Da biste testirali svoja podešavanja jednostavno promenite veličinu prozora vašeg veb čitača ili okrenite svoj telefon/tablet.</p><figure style="float: left;"><img src="../theme/image.php?theme=zebra&image=core/one_column&component=theme"/><figcaption><ul><li>gore: <code>region-main</code></li><li>u sredini: <code>region-pre</code></li><li>dole: <code>region-post</code></li></ul></figcaption></figure><figure style="float: left;"><img src="../theme/image.php?theme=zebra&image=core/two_columns&component=theme"/><figcaption><ul><li>gore levo: <code>region-pre</code></li><li>dole levo: <code>region-post</code></li><li>desno: <code>region-main</code></li></ul></figcaption></figure><figure style="float: left;"><img src="../theme/image.php?theme=zebra&image=core/three_columns&component=theme"/><figcaption><ul><li>levo: <code>region-pre</code></li><li>centralno: <code>region-main</code></li><li>desno: <code>region-post</code></li></ul </figcaption></figure><br style="clear: left;" />';
$string['colwidth'] = 'Širina stupca';
$string['colwidthdesc'] = '<p>Širina kolona To je <code>region-pre</code> i <code>region-post</code>.</p>';
$string['compatinfo'] = 'Podešavanja kompatibilnosti veb čitača';
$string['compatinfodesc'] = '<p>
Razna podešavanja koja imaju za cilj da pokušaju da poboljšaju kompatibilnost veb čitača sa ovom temom, kako bi korisnici imali što konzistentnije grafičko okruženje za rad.
</p>';
$string['contentbgcolor'] = 'Boja pozadine stranice';
$string['contentbgcolordesc'] = '<p>Boja pozadine sadržaja.</p><p>Ovo se primenjuje na različite elemente u zavisnosti od trenutnog prikaza (pogledajte pagelayout.css za više detalja), ali generalno to je sadržaj stranice. Ovo se, takođe, odnosi na boju linkova prilagođenog menija.</p>';
$string['criticalfontcolor'] = 'Boja slova kritičnih obaveštenja';
$string['criticalfontcolordesc'] = '<p>Određuje boju fonta koji se koriste za stvari koje generišu kritična obaveštenje. Obično, to je <code>.statuscritical</code>, <code>.red</code>, i <code>.notifyproblem</code>.</p>';
$string['customcss'] = 'Prilagođeni CSS';
$string['customcssdesc'] = '<p>Ovde unesite prilagođeni CSS .</p><p>CSS koji se ovde unese je poslednje što se poziva prilikom učitavanja stranice, i ne sme biti prepisan tj. zamenjen od strane bilo kog drugog pravila. Ako se vaša pravila ne prikazuju, pokušajte sledeće:<ol><li>proverite vašu sintaksu</li><li>dodajte <code>!important</code> vašem pravilu </li><li>ručno dodajte pravilo</li></ol></p>';
$string['customjs'] = 'Prilagođeni JavaScript';
$string['customjsdesc'] = '<p>Унесите овде прилагођени JavaScript.</p><p>JS који се овде упише појављује се у подножју странице. Унети текст биће уоквирен <code>script</code> ознакама (таговима).</p>';
$string['dateformat'] = 'Format datuma';
$string['dateformatdesc'] = '<p>Napomena: ovo zahteva da <a href="#admin-callink"><code>callink</code></a> bude omogućen.</p><p>Podesite format za prikaz datuma u prilagođenom meniju. Za više informacija o funkciji date() pogledajte dokumentaciju na php.net <a href="http://php.net/manual/en/function.date.php" title="PHP: date - Manual">ovde</a>.</p>';
$string['donate'] = 'Doniraj putem PayPala';
$string['donatedesc'] = '<p style="text-align:center;">Ako smatrate da je ova tema korisna molimo vas da donirate izvesnu sumu novca kako biste pomogli njen dalji razvoj.<br/><br/><a href="https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=danny%40iywahl%2ecom&lc=US&item_name=iyWare&item_number=Zebra%202%20&currency_code=USD" style="background: url(data:image/png;base64,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) no-repeat scroll 8px 4px #234B6F; padding: 8px 22px 12px 54px; color:#fff; border-radius:4px;box-shadow:1px 1px 1px rgba(0, 0, 0, 0.2), 0 1px 0 rgba(255, 255, 255, 0.2) inset;text-align:center;text-shadow:0 1px 1px rgba(0, 0, 0, 0.3);text-decoration:none;">Doniraj</a></p>';
$string['fontcolor'] = 'Boja slova';
$string['fontcolordesc'] = '<p>Primarna boja slova i natpisa.</p><p>Ovo se primenjuje na sve natpise i fontove koji nemaju određenu klasu koja menja boju, kao što su klase <code>.warning</code> ili <code>.notifysuccess</code>. Ovo se, takođe, primenjuje na boju pozadine "datuma" y prilagođenom meniju.</p>';
$string['footerbgcolor'] = 'Boja pozadine podnožja stranice';
$string['footerbgcolordesc'] = '<p>Boja pozadine podnožja stranice</p><p>Korišćenje opcije <code>transparent</code> prouzrokovaće da podnožje stranice prikaže vrednost za <code>contentbgcolor</code>, a ne <code>bodybgcolor</code>. Ovo treba da bude podešeno na istu vrednost kao i <code>bodybgcolor</code> za efekat transparencije</p>';
$string['headeralt'] = 'Alternativni tekst';
$string['headeraltdesc'] = '<p>Tekst koji se koristi umesto naziva sajta.</p><p>Sugestija: koristite razmak (<code>&amp;nbsp;</code>) ako želite da ništa ne bude prikazano.</p>';
$string['headerbgcolor'] = 'Boja pozadine zaglavlja';
$string['headerbgcolordesc'] = '<p>Boja pozadine zaglavlja</p>';
$string['headerinfo'] = 'Podešavanja zaglavlja';
$string['headerinfodesc'] = '<p>Promenite podešavanja za region zaglavlja.</p>';
$string['homeicon'] = 'Prikaži ikonicu za početnu stranicu';
$string['homeicondesc'] = '<p>Prikaži ikonicu za početnu stranicu na početku prilagođenog menija.</p>';
$string['hovercolor'] = 'Boja lebdećeg linka';
$string['hovercolordesc'] = '<p>Boja lebdećeg linka.</p><p>Ovo se primenjuje na sve linkove (unutar i izvan sadržaja stranice), kao i na prilagođeni meni.</p>';
$string['linkcolor'] = 'Boja linkova';
$string['linkcolordesc'] = '<p>Boja linkova i menija.</p><p>Ovo se primenjuje na sve linkove (unutar i izvan sadržaja stranice), osim na prilagođeni meni i njegovu pozadinu, sa izuzetkom "datuma".</p>';
$string['logourl'] = 'URL adresa logotipa';
$string['logourldesc'] = '<p>Unesite URL adresu vašeg logotipa.</p><p>Ovo se može uraditi na jedan od tri načina:<ul><li><p>Moodle Output format putanje (u odnosu na temu):</p><p><code>logo/companylogo</code></p></li><li><p>Puna putanja:</p><p><code>http://domain.com/theme/image.php?theme=zebra&image=logo&rev=1&component=theme</code><br /><code>http://domain.com/path/to/image.jpg</code></p></li><li><p>Relativna putanja:</p><p><code>/path/to/file/companylogo.png</code></p></li></ul></p>';
$string['menucolorscheme'] = 'Shema boja menija';
$string['menucolorschemedesc'] = '<p>Gradijent menija.</p>';
$string['menuhome'] = 'Početna stranica';
$string['menumyhome'] = 'Moja početna stranica';
$string['menutoday'] = 'Današnji datum';
$string['miscinfo'] = 'Ostala. podešavanja';
$string['miscinfodesc'] = '<p>Promenite podešavanja za razne stvari.</p>';
$string['moodlecolorsinfo'] = 'Podešavanja boja Moodlea';
$string['moodlecolorsinfodesc'] = '<p>Promenite specifične boje koje su definisane u osnovnom paketu Moodlea, a izvan su opštih boja gore definisanih. Ovo uključuje stvari poput <code>.notifysuccess</code> i boja za različite tipove događaja u kalendaru. Ovo verovatno ne treba prilagođavati osim ako imate specifičan konflikt sa gornjim opštim podešavanjima boja.</p>';
$string['notes'] = 'Beleške o temi';
$string['notesdesc'] = '<p>Da biste primenili bilo koje podešavanje jednostavno kliknite na dugme "Sačuvaj promene" na dnu ove stranice.</p><p>Ukoliko režim za dizajniranje teme nije uključen, možda će biti neophodno da odete na administratorsku stranicu <a href="purgecaches.php">Obriši sve zapise iz keš memorije</a> kako biste osvežili izgled grafičke teme sa novim podešavanjim.</p>';
$string['okfontcolor'] = 'OK/Dobra boja fonta';
$string['okfontcolordesc'] = '<p>Određuje boju fonta koji se koriste za stvari koje funkcionišu kao čuvanje podešavanja itd.... Specifični primeri su <code>.green</code> i <code>.notifysuccess</code>.</p>';
$string['pagemaxwidth'] = 'Maksimalna širina stranice';
$string['pagemaxwidthdesc'] = '<p>Maksimalna širina za sadržaj stranice.</p>';
$string['pluginname'] = 'Zebra';
$string['region-side-post'] = 'Desno';
$string['region-side-pre'] = 'Levo';
$string['schemedark'] = 'Tamna';
$string['schemeinfo'] = 'Podešavanja sheme boja';
$string['schemeinfodesc'] = '<p>Promenite podešavanja za shemu boja stranice.</p>';
$string['schemelight'] = 'Sveтla';
$string['schemenone'] = 'Nijedna';
$string['seriousfontcolor'] = 'Boja fonta u važnim porukama';
$string['seriousfontcolordesc'] = '<p>Određuje boju fonta koji se koriste za stvari koje generišu važna obaveštenje. Obično, to je <code>.statusserious</code>.</p>';
$string['simplelogin'] = 'Koristiti osnovni obrazac za prijavu';
$string['simplelogindesc'] = '<p>Ako omogućite ovu opciju, ona će pojednostaviti prelom stranice za prijavu tako što neće prikazati zaglavlje i  podnožje stranice, navigacionu traku, jezički i prilagođeni meni. Ova opcija može da se koristi za one sajtove koji zahtevaju proveru identiteta pre nego što se dozvoli pristup ovim stavkama.</p>';
$string['threecolmin'] = 'Minimalna širina za tri stupca';
$string['threecolmindesc'] = '<p>Minimalna širina za prelom stranice sa tri stupca. Redosled prikaza je:</p>';
$string['twocolmin'] = 'Minimalna širina za dva stupca';
$string['twocolmindesc'] = '<p>Minimalna širina za prelom stranice sa dva stupca.</p>';
$string['useautohide'] = 'Uključi CSS za automatsko sakrivanje';
$string['useautohidedesc'] = '<p>Uključite CSS pravila za automatsko sakrivanje ikonica za korisnike koji su u režimu uređivanja.</p><p>Pročitajte više o ovome <a href="http://moodle.org/mod/forum/discuss.php?d=197470">ovde</a> ili <a href="http://www.moodlenews.com/2012/a-moodle-administrators-dream-come-true-autohide-for-moodle-2-2/"> ovde </a>.</p>';
$string['usecf'] = 'Zatražite od korisnika da instaliraju Google Chrome Frame';
$string['usecfdesc'] = '<p>Google <a href="http://code.google.com/chrome/chromeframe/">Chrome Frame</a> je dodatak za Internet Explorer koji instalira Chromium Rendering engine (mehanizam za vizualizaciju) na starijim veb čitačima i omogućava im da koriste savremene veb tehnologije.</p>';
$string['userespond'] = 'Uključi respond.js u podnožje stranice';
$string['useresponddesc'] = '<p><a href="https://github.com/scottjehl/Respond#readme">Respond.js</a> će pokušati da analizira (parsira) <code>@media</code> upite u CSS-u i da ih ponudi veb čitačima koji ih ne podržavaju u izvornom obliku (kao IE8 i starije verzije).</p>';
$string['userpic'] = 'Prikaži sliku korisnika';
$string['userpicdesc'] = '<p>Prikaži sliku korisničkog profila u zaglavlju</p>';
$string['warningfontcolor'] = 'Boja fonta u upozorenjima';
$string['warningfontcolordesc'] = '<p>Određuje boju fonta koji se koriste za stvari koje generišu upozorenja. Obično, to je <code>.statuswarning</code>.</p>';
