<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'sv', version '4.5'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adress';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Infoga/redigera bokmärke';
$string['advanced:backcolor_desc'] = 'Välj bakgrundsfärg';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Blockcitat';
$string['advanced:blockquote_desc'] = 'Blockcitat';
$string['advanced:bold_desc'] = 'Fet (<kbd>Ctrl+B</kbd>)';
$string['advanced:bullist_desc'] = 'Infoga/ta bort punktlista';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Infoga specialtecken';
$string['advanced:cleanup_desc'] = 'Städa upp rörig kod';
$string['advanced:clipboard_msg'] = 'Kopiera/klipp ut/klistra in är inte tillgängligt i din webbläsare. Vill du veta mer om detta?';
$string['advanced:code'] = 'Kod';
$string['advanced:code_desc'] = 'Redigera HTML-källa';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopiera';
$string['advanced:custom1_desc'] = 'Ange anpassad beskrivning här';
$string['advanced:cut_desc'] = 'Klipp ut';
$string['advanced:dd'] = 'Definitionsbeskrivning';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = 'Definitionsterm';
$string['advanced:font_size'] = 'Teckenstorlek';
$string['advanced:fontdefault'] = 'Fontfamilj';
$string['advanced:forecolor_desc'] = 'Välj textfärg';
$string['advanced:h1'] = 'Rubrik 1';
$string['advanced:h2'] = 'Rubrik 2';
$string['advanced:h3'] = 'Rubrik 3';
$string['advanced:h4'] = 'Rubrik 4';
$string['advanced:h5'] = 'Rubrik 5';
$string['advanced:h6'] = 'Rubrik 6';
$string['advanced:help_desc'] = 'Hjälp';
$string['advanced:help_shortcut'] = 'Tryck <kbd>Alt+F10</kbd> för verktygsrad. Tryck <kbd>Alt+0</kbd> för hjälp.';
$string['advanced:hr_desc'] = 'Infoga horisontell linje';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Infoga/redigera bild';
$string['advanced:image_props_desc'] = 'Bildegenskaper';
$string['advanced:indent_desc'] = 'Öka indrag';
$string['advanced:italic_desc'] = 'Kursiv (<kbd>Ctrl+I</kbd>)';
$string['advanced:justifycenter_desc'] = 'Centrera';
$string['advanced:justifyfull_desc'] = 'Breddjustera';
$string['advanced:justifyleft_desc'] = 'Vänsterjustera';
$string['advanced:justifyright_desc'] = 'Högerjustera';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Infoga/redigera länk';
$string['advanced:more_colors'] = 'Fler färger...';
$string['advanced:newdocument'] = 'Är du säker på att du vill rensa allt innehåll?';
$string['advanced:newdocument_desc'] = 'Nytt dokument';
$string['advanced:numlist_desc'] = 'Infoga/ta bort numrerad lista';
$string['advanced:outdent_desc'] = 'Minska indrag';
$string['advanced:paragraph'] = 'Stycke';
$string['advanced:paste_desc'] = 'Klistra in';
$string['advanced:path'] = 'Element';
$string['advanced:pre'] = 'Förformaterad';
$string['advanced:redo_desc'] = 'Gör om (<kbd>Ctrl+Y</kbd>)';
$string['advanced:removeformat_desc'] = 'Ta bort formatering';
$string['advanced:rich_text_area'] = 'RTF-fält';
$string['advanced:samp'] = 'Kodexempel';
$string['advanced:shortcuts_desc'] = 'Hjälp för tillgänglighetsinställningar';
$string['advanced:striketrough_desc'] = 'Genomstruken';
$string['advanced:style_select'] = 'Stilar';
$string['advanced:sub_desc'] = 'Nedsänkt';
$string['advanced:sup_desc'] = 'Upphöjt';
$string['advanced:toolbar'] = 'Verktygsrad';
$string['advanced:toolbar_focus'] = 'Hoppa till verktygsfältet - Alt+Q, Hoppa till redigeraren - Alt+Z, Hoppa till elementlistan - Alt+X';
$string['advanced:underline_desc'] = 'Understruken (<kbd>Ctrl+U</kbd>)';
$string['advanced:undo_desc'] = 'Ångra (<kbd>Ctrl+Z</kbd>)';
$string['advanced:unlink_desc'] = 'Ta bort länk';
$string['advanced:visualaid_desc'] = 'Visa/dölj visuella hjälpmedel/osynliga element';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Författare';
$string['advanced_dlg:about_general'] = 'Om';
$string['advanced_dlg:about_help'] = 'Hjälp';
$string['advanced_dlg:about_license'] = 'Licens';
$string['advanced_dlg:about_loaded'] = 'Laddade pluginmoduler';
$string['advanced_dlg:about_plugin'] = 'Pluginmodul';
$string['advanced_dlg:about_plugins'] = 'Pluginmoduler';
$string['advanced_dlg:about_title'] = 'Om TinyMCE';
$string['advanced_dlg:about_version'] = 'Version';
$string['advanced_dlg:accessibility_help'] = 'Tillhänglighetshjälp';
$string['advanced_dlg:accessibility_usage_title'] = 'Generell användning';
$string['advanced_dlg:anchor_invalid'] = 'Vänligen ange ett giltigt ankarnamn.';
$string['advanced_dlg:anchor_name'] = 'Namn';
$string['advanced_dlg:anchor_title'] = 'Infoga/redigera ankare';
$string['advanced_dlg:charmap_title'] = 'Välj specialtecken';
$string['advanced_dlg:charmap_usage'] = 'Använd vänster- och högerpil för att navigera.';
$string['advanced_dlg:code_title'] = 'HTML källkodsredigerare';
$string['advanced_dlg:code_wordwrap'] = 'Radbryt';
$string['advanced_dlg:colorpicker_color'] = 'Färg:';
$string['advanced_dlg:colorpicker_name'] = 'Namn:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Namngivna';
$string['advanced_dlg:colorpicker_named_title'] = 'Namngivna färger';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Palett';
$string['advanced_dlg:colorpicker_palette_title'] = 'Palettfärger';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Väljare';
$string['advanced_dlg:colorpicker_picker_title'] = 'Färgväljare';
$string['advanced_dlg:colorpicker_title'] = 'Välj en färg';
$string['advanced_dlg:image_align'] = 'Justering';
$string['advanced_dlg:image_align_baseline'] = 'Baslinje';
$string['advanced_dlg:image_align_bottom'] = 'Botten';
$string['advanced_dlg:image_align_left'] = 'Vänster';
$string['advanced_dlg:image_align_middle'] = 'Mitten';
$string['advanced_dlg:image_align_right'] = 'Höger';
$string['advanced_dlg:image_align_textbottom'] = 'Botten av texten';
$string['advanced_dlg:image_align_texttop'] = 'Toppen av texten';
$string['advanced_dlg:image_align_top'] = 'Överkanten';
$string['advanced_dlg:image_alt'] = 'Bildbeskrivning';
$string['advanced_dlg:image_border'] = 'Ram';
$string['advanced_dlg:image_dimensions'] = 'Dimensioner';
$string['advanced_dlg:image_hspace'] = 'Horisontellt utrymme';
$string['advanced_dlg:image_list'] = 'Bildlista';
$string['advanced_dlg:image_src'] = 'Bildens URL';
$string['advanced_dlg:image_title'] = 'Infoga/redigera bild';
$string['advanced_dlg:image_vspace'] = 'Vertikalt utrymme';
$string['advanced_dlg:invalid_color_value'] = 'Ogiltigt färgvärde';
$string['advanced_dlg:link_is_email'] = 'Länken du angav verkar vara en e-post adress. Vill du lägga till <code>mailto:</code>-prefixet till länken?';
$string['advanced_dlg:link_is_external'] = 'Länken du angav verkar vara en extern adress. Vill du lägga till <code>http://</code>-prefixet till länken?';
$string['advanced_dlg:link_list'] = 'Länklista';
$string['advanced_dlg:link_target'] = 'Mål';
$string['advanced_dlg:link_target_blank'] = 'Öppna länken i ett nytt fönster';
$string['advanced_dlg:link_target_same'] = 'Öppna länken i samma fönster';
$string['advanced_dlg:link_title'] = 'Infoga/redigera länk';
$string['advanced_dlg:link_titlefield'] = 'Titel';
$string['advanced_dlg:link_url'] = 'Länkens URL';
$string['advhr:advhr_desc'] = 'Infoga horisontell linje';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'Ingen skugga';
$string['advhr_dlg:size'] = 'Höjd';
$string['advhr_dlg:width'] = 'Bredd';
$string['advhr_dlg:widthunits'] = 'Enheter';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Infoga/redigera bild';
$string['advimage_dlg:align'] = 'Justering';
$string['advimage_dlg:align_baseline'] = 'Baslinje';
$string['advimage_dlg:align_bottom'] = 'Underkant';
$string['advimage_dlg:align_left'] = 'Vänster';
$string['advimage_dlg:align_middle'] = 'Mitten';
$string['advimage_dlg:align_right'] = 'Höger';
$string['advimage_dlg:align_textbottom'] = 'Botten av texten';
$string['advimage_dlg:align_texttop'] = 'Toppen av texten';
$string['advimage_dlg:align_top'] = 'Överkant';
$string['advimage_dlg:alt'] = 'Bildbeskrivning';
$string['advimage_dlg:alt_image'] = 'Alternativbild';
$string['advimage_dlg:border'] = 'Ram';
$string['advimage_dlg:classes'] = 'Klasser';
$string['advimage_dlg:constrain_proportions'] = 'Bibehåll proportionerna';
$string['advimage_dlg:dialog_title'] = 'Infoga/redigera bild';
$string['advimage_dlg:dimensions'] = 'Dimensioner';
$string['advimage_dlg:example_img'] = 'Exempelbild';
$string['advimage_dlg:general'] = 'Generellt';
$string['advimage_dlg:height'] = 'Höjd';
$string['advimage_dlg:hspace'] = 'Horisontellt utrymme';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Bildlista';
$string['advimage_dlg:langcode'] = 'Språkkod';
$string['advimage_dlg:langdir'] = 'Skrivriktning';
$string['advimage_dlg:list'] = 'Bildlista';
$string['advimage_dlg:long_desc'] = 'Lång beskrivning';
$string['advimage_dlg:ltr'] = 'Vänster till höger';
$string['advimage_dlg:map'] = 'Länkkarta';
$string['advimage_dlg:misc'] = 'Övrigt';
$string['advimage_dlg:missing_alt'] = 'Vill du fortsätta utan att inkludera en bildbeskrivning? Utan den är bilden inte tillgänglig för vissa användare med funktionshinder, eller för de som använder en textwebbläsare eller surfar på webben med visningen av bilder avstängd.';
$string['advimage_dlg:mouseout'] = 'vid musen utanför';
$string['advimage_dlg:mouseover'] = 'vid musen över';
$string['advimage_dlg:preview'] = 'Förhandsgranskning';
$string['advimage_dlg:rtl'] = 'Höger till vänster';
$string['advimage_dlg:src'] = 'Bildens URL';
$string['advimage_dlg:style'] = 'Stil';
$string['advimage_dlg:swap_image'] = 'Växla bild';
$string['advimage_dlg:tab_advanced'] = 'Avancerat';
$string['advimage_dlg:tab_appearance'] = 'Utseende';
$string['advimage_dlg:tab_general'] = 'Generellt';
$string['advimage_dlg:title'] = 'Titel';
$string['advimage_dlg:vspace'] = 'Vertikalt utrymme';
$string['advimage_dlg:width'] = 'Bredd';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Infoga/redigera länk';
$string['advlink_dlg:accesskey'] = 'Tangentbordsgenväg';
$string['advlink_dlg:advanced_props'] = 'Avancerade inställningar';
$string['advlink_dlg:advanced_tab'] = 'Avancerat';
$string['advlink_dlg:anchor_names'] = 'Ankare';
$string['advlink_dlg:classes'] = 'Klasser';
$string['advlink_dlg:encoding'] = 'Teckenformat';
$string['advlink_dlg:event_props'] = 'Händelser';
$string['advlink_dlg:events_tab'] = 'Händelser';
$string['advlink_dlg:general_props'] = 'Allmänna egenskaper';
$string['advlink_dlg:general_tab'] = 'Allmänt';
$string['advlink_dlg:height'] = 'Höjd';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Länken du angav verkar vara en e-post adress. Vill du lägga till <code>mailto:</code>-prefixet till länken?';
$string['advlink_dlg:is_external'] = 'Länken du angav verkar vara en extern adress. Vill du lägga till <code>http://</code>-prefixet till länken?';
$string['advlink_dlg:langcode'] = 'Språkkod';
$string['advlink_dlg:langdir'] = 'Skrivriktning';
$string['advlink_dlg:link_list'] = 'Länklista';
$string['advlink_dlg:list'] = 'Länklista';
$string['advlink_dlg:ltr'] = 'Vänster till höger';
$string['advlink_dlg:mime'] = 'MIME-typ';
$string['advlink_dlg:popup'] = 'JavaScript-popup';
$string['advlink_dlg:popup_dependent'] = 'Beroende av (enbart Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Visa Adressraden';
$string['advlink_dlg:popup_menubar'] = 'Visa Menyrad';
$string['advlink_dlg:popup_name'] = 'Fönsternamn';
$string['advlink_dlg:popup_opts'] = 'Alternativ';
$string['advlink_dlg:popup_position'] = 'Position (x/y)';
$string['advlink_dlg:popup_props'] = 'Pop-Up egenskaper';
$string['advlink_dlg:popup_resizable'] = 'Skalbart fönster';
$string['advlink_dlg:popup_return'] = 'Infoga \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Visa Rullningslister';
$string['advlink_dlg:popup_size'] = 'Storlek';
$string['advlink_dlg:popup_statusbar'] = 'Visa Statusfält';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Visa Verktygsfält';
$string['advlink_dlg:popup_url'] = 'Popup URL';
$string['advlink_dlg:rel'] = 'Relation (rel attribut)';
$string['advlink_dlg:rev'] = 'Omvänd relation (rev)';
$string['advlink_dlg:rtl'] = 'Höger till vänster';
$string['advlink_dlg:style'] = 'Stil';
$string['advlink_dlg:tabindex'] = 'Tabbindex';
$string['advlink_dlg:target'] = 'Mål';
$string['advlink_dlg:target_blank'] = 'Öppna i nytt fönster';
$string['advlink_dlg:target_langcode'] = 'Språk';
$string['advlink_dlg:target_name'] = 'Namn';
$string['advlink_dlg:target_parent'] = 'Öppna i överordnat fönster/ram';
$string['advlink_dlg:target_same'] = 'Öppna i detta fönster/ram';
$string['advlink_dlg:target_top'] = 'Öppna i toppramen (ersätter alla ramar)';
$string['advlink_dlg:title'] = 'Infoga/redigera länk';
$string['advlink_dlg:titlefield'] = 'Titel';
$string['advlink_dlg:url'] = 'Länkens URL';
$string['advlink_dlg:width'] = 'Bredd';
$string['advlist:circle'] = 'Cirkel';
$string['advlist:def'] = 'Standard';
$string['advlist:disc'] = 'Disk';
$string['advlist:lower_alpha'] = 'Gemener';
$string['advlist:lower_greek'] = 'Grekiska gemener';
$string['advlist:lower_roman'] = 'Romerska gemener';
$string['advlist:square'] = 'Fyrkant';
$string['advlist:types'] = 'Typer';
$string['advlist:upper_alpha'] = 'Versaler';
$string['advlist:upper_roman'] = 'Romerska versaler';
$string['aria:rich_text_area'] = 'RTF-fält';
$string['autosave:restore_content'] = 'Återställ automatiskt sparat innehåll';
$string['autosave:unload_msg'] = 'De förändringar du gjort kommer att gå förlorade om du lämnar sidan.';
$string['autosave:warning_message'] = 'Om du återställer det sparade innehållet kommer du förlora allt nuvarande innehåll i textredigeraren.

Är du säker på att du vill återställa det sparade innehållet?';
$string['availablebuttons'] = 'Tillgängliga knappar';
$string['colors:000000'] = 'Svart';
$string['colors:000080'] = 'Marinblå';
$string['colors:0000FF'] = 'Blå';
$string['colors:003300'] = 'Mörkgrön';
$string['colors:003366'] = 'Mörkt azurblå';
$string['colors:008000'] = 'Grön';
$string['colors:008080'] = 'Blågrön';
$string['colors:00CCFF'] = 'Himmelsblå';
$string['colors:00FF00'] = 'Lime';
$string['colors:00FFFF'] = 'Aqua';
$string['colors:333300'] = 'Mörkoliv';
$string['colors:333333'] = 'Mycket mörkgrå';
$string['colors:333399'] = 'Indigo';
$string['colors:3366FF'] = 'Kungligt blått';
$string['colors:339966'] = 'Havsgrön';
$string['colors:33CCCC'] = 'Turkos';
$string['colors:666699'] = 'Gråblå';
$string['colors:800000'] = 'Rödbrun';
$string['colors:800080'] = 'Lila';
$string['colors:808000'] = 'Oliv';
$string['colors:808080'] = 'Grå';
$string['colors:993300'] = 'Bränt orange';
$string['colors:993366'] = 'Brun';
$string['colors:999999'] = 'Mellangrå';
$string['colors:99CC00'] = 'Gulgrön';
$string['colors:99CCFF'] = 'Ljust himmelsblå';
$string['colors:C0C0C0'] = 'Silver';
$string['colors:CC99FF'] = 'Plommon';
$string['colors:CCFFCC'] = 'Blekt grön';
$string['colors:CCFFFF'] = 'Svagt cyan';
$string['colors:FF0000'] = 'Röd';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Orange';
$string['colors:FF9900'] = 'Bärnsten';
$string['colors:FF99CC'] = 'Rosa';
$string['colors:FFCC00'] = 'Guld';
$string['colors:FFCC99'] = 'Persika';
$string['colors:FFFF00'] = 'Gul';
$string['colors:FFFF99'] = 'Ljusgul';
$string['colors:FFFFFF'] = 'Vit';
$string['common:apply'] = 'Använd';
$string['common:browse'] = 'Bläddra';
$string['common:cancel'] = 'Avbryt';
$string['common:class_name'] = 'Klass';
$string['common:clipboard_msg'] = 'Kopiera/klipp ut/klistra in är inte tillgängligt i Mozilla och Firefox. Vill du veta mer om detta?';
$string['common:clipboard_no_support'] = 'Funktionen är inte tillgänglig i din webbläsare, använd tangentbordsgenvägarna i stället.';
$string['common:close'] = 'Stäng';
$string['common:edit_confirm'] = 'Vill du använda WYSIWYG för detta textfält?';
$string['common:insert'] = 'Infoga';
$string['common:invalid_data'] = 'Fel: Felaktiga värden har matats in, dessa är rödmarkerade.';
$string['common:invalid_data_min'] = '{#field} måste vara ett nummer som är större än {#min}';
$string['common:invalid_data_number'] = '{#field} måste vara ett nummer';
$string['common:invalid_data_size'] = '{#field} måste vara ett nummer eller procentsats';
$string['common:more_colors'] = 'Fler färger...';
$string['common:not_set'] = '-- Inte angivet --';
$string['common:popup_blocked'] = 'Popup blockerare detekterad. Stäng av den så att dialogerna kan öppnas.';
$string['common:update'] = 'Uppdatera';
$string['common:value'] = '(värde)';
$string['contextmenu:align'] = 'Justering';
$string['contextmenu:center'] = 'Centrerad';
$string['contextmenu:full'] = 'Fullbredd';
$string['contextmenu:left'] = 'Vänster';
$string['contextmenu:right'] = 'Höger';
$string['customconfig'] = 'Anpassad konfiguration';
$string['customconfig_desc'] = 'Anpassad avancerad TinyMCE-konfiguration i JSON-format, t.ex. <code> {"option1" : "value2", "option2" : "value2"}</code>. Alternativ som specificeras här åsidosätter standardinställningarna för pluginmodulen.';
$string['customtoolbar'] = 'Verktygsrad';
$string['customtoolbar_desc'] = 'Varje rad innehåller en lista med kommaseparerade knappnamn. Använd "wrap" som gruppavgränsare. Tomma rader ignoreras. Se <a href="{$a}" target="_blank">{$a}</a> för en lista över standard TinyMCE-knappar.<br />Den första raden visas alltid, medan synligheten för andra och tredje verktygsfältet kan slås av/på.';
$string['directionality:ltr_desc'] = 'Skrivriktning - vänster till höger';
$string['directionality:rtl_desc'] = 'Skrivriktning - höger till vänster';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Smileys';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Gråter';
$string['emotions_dlg:desc'] = 'Smileys';
$string['emotions_dlg:embarassed'] = 'Generad';
$string['emotions_dlg:foot_in_mouth'] = 'Foten i munnen';
$string['emotions_dlg:frown'] = 'Rynkar på näsan';
$string['emotions_dlg:innocent'] = 'Oskyldig';
$string['emotions_dlg:kiss'] = 'Kyss';
$string['emotions_dlg:laughing'] = 'Skrattande';
$string['emotions_dlg:money_mouth'] = 'Guld i mun';
$string['emotions_dlg:sealed'] = 'Tyst';
$string['emotions_dlg:smile'] = 'Glad';
$string['emotions_dlg:surprised'] = 'Förvånad';
$string['emotions_dlg:title'] = 'Infoga smiley';
$string['emotions_dlg:tongue_out'] = 'Tungan ute';
$string['emotions_dlg:undecided'] = 'Obestämd';
$string['emotions_dlg:usage'] = 'Använd vänster- och högerpilarna för att navigera.';
$string['emotions_dlg:wink'] = 'Flört';
$string['emotions_dlg:yell'] = 'Skrika';
$string['fontselectlist'] = 'Tillgängliga teckensnitt';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Dokumentegenskaper';
$string['fullpage_dlg:active_color'] = 'Aktiv färg';
$string['fullpage_dlg:add'] = 'Lägg till element';
$string['fullpage_dlg:add_base'] = 'Baselement';
$string['fullpage_dlg:add_comment'] = 'Kommentarsnod';
$string['fullpage_dlg:add_link'] = 'Länk-element';
$string['fullpage_dlg:add_meta'] = 'Meta-element';
$string['fullpage_dlg:add_script'] = 'Skript-element';
$string['fullpage_dlg:add_style'] = 'Stil-element';
$string['fullpage_dlg:add_title'] = 'Titel-element';
$string['fullpage_dlg:advanced_props'] = 'Avancerat';
$string['fullpage_dlg:advanced_tab'] = 'Avancerat';
$string['fullpage_dlg:appearance_bgprops'] = 'Bakgrundsegenskaper';
$string['fullpage_dlg:appearance_linkprops'] = 'Länkfärger';
$string['fullpage_dlg:appearance_marginprops'] = 'Marginaler';
$string['fullpage_dlg:appearance_style'] = 'Mall- och stilegenskaper';
$string['fullpage_dlg:appearance_tab'] = 'Utseende';
$string['fullpage_dlg:appearance_textprops'] = 'Textegenskaper';
$string['fullpage_dlg:author'] = 'Författare';
$string['fullpage_dlg:base_element'] = 'Baselement';
$string['fullpage_dlg:bgcolor'] = 'Bakgrundsfärg';
$string['fullpage_dlg:bgimage'] = 'Bakgrundsbild';
$string['fullpage_dlg:bottom_margin'] = 'Bottenmarginal';
$string['fullpage_dlg:charset'] = 'Teckenuppsättning';
$string['fullpage_dlg:comment_element'] = 'Kommentar';
$string['fullpage_dlg:content'] = 'Innehåll';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Skjut upp';
$string['fullpage_dlg:doctypes'] = 'Dokumenttyp';
$string['fullpage_dlg:encoding'] = 'Teckenkodning';
$string['fullpage_dlg:font_face'] = 'Teckensnitt';
$string['fullpage_dlg:font_size'] = 'Teckenstorlek';
$string['fullpage_dlg:fontface'] = 'Teckensnittsfamilj';
$string['fullpage_dlg:fontsize'] = 'Teckenstorlek';
$string['fullpage_dlg:general_props'] = 'Allmänt';
$string['fullpage_dlg:head_elements'] = 'Head element';
$string['fullpage_dlg:hover_color'] = 'Hovringsfärg';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Information';
$string['fullpage_dlg:langcode'] = 'Språkkod';
$string['fullpage_dlg:langdir'] = 'Skrivriktning';
$string['fullpage_dlg:langprops'] = 'Språk och teckenkodning';
$string['fullpage_dlg:language'] = 'Språk';
$string['fullpage_dlg:left_margin'] = 'Vänstermarginal';
$string['fullpage_dlg:link_color'] = 'Länkfärg';
$string['fullpage_dlg:link_element'] = 'Länkelement';
$string['fullpage_dlg:ltr'] = 'Vänster till höger';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Bekrivning';
$string['fullpage_dlg:meta_element'] = 'Meta-element';
$string['fullpage_dlg:meta_index_follow'] = 'Indexera och följ länkarna';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indexera men följ ej länkarna';
$string['fullpage_dlg:meta_keywords'] = 'Nyckelord';
$string['fullpage_dlg:meta_noindex_follow'] = 'Indexera inte men följ länkarna';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Indexera inte och följ inte länkarna';
$string['fullpage_dlg:meta_props'] = 'Metainformation';
$string['fullpage_dlg:meta_robots'] = 'Robotar';
$string['fullpage_dlg:meta_tab'] = 'Allmänna';
$string['fullpage_dlg:meta_title'] = 'Titel';
$string['fullpage_dlg:movedown'] = 'Flytta det markerade elementet nedåt';
$string['fullpage_dlg:moveup'] = 'Flytta det markerade elementet uppåt';
$string['fullpage_dlg:name'] = 'Name';
$string['fullpage_dlg:properties'] = 'Egenskaper';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Ta bort det markerade elementet';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Högermarginal';
$string['fullpage_dlg:rtl'] = 'Höger till vänster';
$string['fullpage_dlg:script_element'] = 'Skript-element';
$string['fullpage_dlg:src'] = 'Källa';
$string['fullpage_dlg:style'] = 'Stil';
$string['fullpage_dlg:style_element'] = 'Stil-element';
$string['fullpage_dlg:stylesheet'] = 'Stilmall';
$string['fullpage_dlg:target'] = 'Mål';
$string['fullpage_dlg:text_color'] = 'Textfärg';
$string['fullpage_dlg:textcolor'] = 'Färg';
$string['fullpage_dlg:title'] = 'Dokumentegenskaper';
$string['fullpage_dlg:title_element'] = 'Titel-element';
$string['fullpage_dlg:top_margin'] = 'Toppmarginal';
$string['fullpage_dlg:type'] = 'Typ';
$string['fullpage_dlg:value'] = 'Värde';
$string['fullpage_dlg:visited_color'] = 'Besökt-färg';
$string['fullpage_dlg:xml_pi'] = 'XML deklaration';
$string['fullscreen:desc'] = 'Slå på/av helskärm';
$string['iespell:download'] = 'ieSpell kunde inte hittas. Vill du installera den nu?';
$string['iespell:iespell_desc'] = 'Kontrollera stavning';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Söndag,Måndag,Tisdag,Onsdag,Torsdag,Fredag,Lördag,Söndag';
$string['insertdatetime:day_short'] = 'Sön,Mån,Tis,Ons,Tors,Fre,Lör,Sön';
$string['insertdatetime:insertdate_desc'] = 'Infoga datum';
$string['insertdatetime:inserttime_desc'] = 'Infoga tid';
$string['insertdatetime:months_long'] = 'Januari,Februari,Mars,April,Maj,Juni,Juli,Augusti,September,Oktober,November,December';
$string['insertdatetime:months_short'] = 'Jan,Feb,Mar,Apr,Maj,Jun,Jul,Aug,Sep,Okt,Nov,Dec';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Slå av/på absolut positionering';
$string['layer:backward_desc'] = 'Flytta bakåt';
$string['layer:content'] = 'Nytt lager...';
$string['layer:forward_desc'] = 'Flytta framåt';
$string['layer:insertlayer_desc'] = 'Infoga nytt lager';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Infoga/redigera inbäddad media';
$string['media:edit'] = 'Redigera inbäddad media';
$string['media_dlg:advanced'] = 'Avancerat';
$string['media_dlg:align'] = 'Justera';
$string['media_dlg:align_bottom'] = 'Nedan';
$string['media_dlg:align_bottom_left'] = 'Nedan till vänster';
$string['media_dlg:align_bottom_right'] = 'Nedan till höger';
$string['media_dlg:align_center'] = 'Centrera';
$string['media_dlg:align_left'] = 'Vänster';
$string['media_dlg:align_right'] = 'Höger';
$string['media_dlg:align_top'] = 'Ovankant';
$string['media_dlg:align_top_left'] = 'Ovan till vänster';
$string['media_dlg:align_top_right'] = 'Ovan till höger';
$string['media_dlg:altsource1'] = 'Alternativ källa 1';
$string['media_dlg:altsource2'] = 'Alternativ källa 2';
$string['media_dlg:audio'] = 'HTML5-ljud';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Starta automatiskt';
$string['media_dlg:balance'] = 'Balans';
$string['media_dlg:base'] = 'Bas';
$string['media_dlg:baseurl'] = 'Bas-URL';
$string['media_dlg:bgcolor'] = 'Bakgrund';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'Textnings-ID';
$string['media_dlg:center'] = 'Centrera';
$string['media_dlg:class_name'] = 'Klass';
$string['media_dlg:console'] = 'Konsol';
$string['media_dlg:constrain_proportions'] = 'Bibehåll proportionerna';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Kontroller';
$string['media_dlg:correction'] = 'Ingen korrigering';
$string['media_dlg:currentmarker'] = 'Nuvarande markör';
$string['media_dlg:currentposition'] = 'Nuvarande position';
$string['media_dlg:defaultframe'] = 'Standardram';
$string['media_dlg:embedded_audio_options'] = 'Alternativ för inbäddat ljud';
$string['media_dlg:embeddedaudio'] = 'Inbäddat ljud';
$string['media_dlg:enabled'] = 'Aktiverad';
$string['media_dlg:enablejavascript'] = 'Aktivera JavaScript';
$string['media_dlg:endtime'] = 'Sluttid';
$string['media_dlg:file'] = 'Fil/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flashalternativ';
$string['media_dlg:flashvars'] = 'Flashvariabler';
$string['media_dlg:fullscreen'] = 'Helskärm';
$string['media_dlg:general'] = 'Allmänt';
$string['media_dlg:hidden'] = 'Dold';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'H-Space';
$string['media_dlg:html5_audio_options'] = 'Ljudalternativ';
$string['media_dlg:html5_video_options'] = 'Alternativ för HTML5-video';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Bildstatus';
$string['media_dlg:invokeurls'] = 'Öppna URL:er';
$string['media_dlg:kioskmode'] = 'Kioskläge';
$string['media_dlg:list'] = 'Lista';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Repetera';
$string['media_dlg:maintainaspect'] = 'Bibehåll proportioner';
$string['media_dlg:menu'] = 'Visa menyn';
$string['media_dlg:mute'] = 'Tysta';
$string['media_dlg:name'] = 'Namn';
$string['media_dlg:nojava'] = 'Ingen Java';
$string['media_dlg:numloop'] = 'Num loops';
$string['media_dlg:play'] = 'Spela upp automatiskt';
$string['media_dlg:playcount'] = 'Visningar';
$string['media_dlg:playeveryframe'] = 'Spela varje bildruta';
$string['media_dlg:poster'] = 'Poster';
$string['media_dlg:prefetch'] = 'Förhämta';
$string['media_dlg:preload'] = 'Förladda';
$string['media_dlg:preload_auto'] = 'Låt användarens webbläsare styra';
$string['media_dlg:preload_metadata'] = 'Förladda video-metadata';
$string['media_dlg:preload_none'] = 'Ladda inte i förväg';
$string['media_dlg:preview'] = 'Förhandsgranska';
$string['media_dlg:progress'] = 'Förlopp';
$string['media_dlg:qt_options'] = 'QuickTime-alternativ';
$string['media_dlg:qt_stream_warn'] = 'Strömmade RTSP-resurser bör läggas till till QT-källan i fliken med avancerade inställningar. Du bör också lägga till en icke-strömmande version till källfältet.';
$string['media_dlg:qtsrc'] = 'QT source';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:quality'] = 'Kvalitet';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Betygsätt';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Alternativ för Real Media-spelare';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Skala';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwavealternativ';
$string['media_dlg:shuffle'] = 'Blanda';
$string['media_dlg:size'] = 'Dimensioner';
$string['media_dlg:sound'] = 'Ljud';
$string['media_dlg:source'] = 'Källa';
$string['media_dlg:starttime'] = 'Starttid';
$string['media_dlg:stretchtofit'] = 'Sträck ut för att passa';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Align';
$string['media_dlg:swstretchstyle'] = 'Utsträckningsstil';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Align';
$string['media_dlg:target'] = 'Mål';
$string['media_dlg:targetcache'] = 'Målcache';
$string['media_dlg:title'] = 'Infoga/redigera inbäddad media';
$string['media_dlg:type'] = 'Typ';
$string['media_dlg:uimode'] = 'UI-läge';
$string['media_dlg:video'] = 'HTML5-video';
$string['media_dlg:volume'] = 'Volym';
$string['media_dlg:vspace'] = 'V-Space';
$string['media_dlg:windowlessvideo'] = 'Fönsterlös video';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Alternativ för Windows Media-spelare';
$string['nonbreaking:nonbreaking_desc'] = 'Infoga icke radbrytande mellanslag';
$string['pagebreak:desc'] = 'Infoga sidbrytning för utskrift';
$string['paste:paste_text_desc'] = 'Klistra in som oformaterad text';
$string['paste:paste_word_desc'] = 'Klistra in från Word';
$string['paste:plaintext_mode'] = 'Klistra in är nu i "oformaterad text"-läge. Klicka igen om du vill växla tillbaka till vanligt inklistringsläge. När du har klistrat in något kommer du att återgå till vanligt inklistringsläge.';
$string['paste:plaintext_mode_stick'] = 'Klistra in är nu i "oformaterad text"-läge. Klicka igen om du vill växla tillbaka till vanligt inklistringsläge.';
$string['paste:selectall_desc'] = 'Markera allt';
$string['paste_dlg:text_linebreaks'] = 'Behåll radbrytningar';
$string['paste_dlg:text_title'] = 'Använd <kbd>Ctrl+V</kbd> på ditt tangentbord för att klistra in i detta fönster.';
$string['paste_dlg:word_title'] = 'Använd <kbd>Ctrl+V</kbd> på ditt tangentbord för att klistra in i detta fönster.';
$string['pluginname'] = 'TinyMCE HTML-redigerare';
$string['preview:preview_desc'] = 'Förhandsgranska';
$string['print:print_desc'] = 'Skriv ut';
$string['privacy:metadata'] = 'Pluginmodulen TinyMCE HTML lagrar ingen personinformation.';
$string['save:cancel_desc'] = 'Ångra alla ändringar';
$string['save:save_desc'] = 'Spara';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Sök/ersätt';
$string['searchreplace:search_desc'] = 'Sök';
$string['searchreplace_dlg:allreplaced'] = 'Alla förekomster har ersatts.';
$string['searchreplace_dlg:direction'] = 'Riktning';
$string['searchreplace_dlg:down'] = 'Nedåt';
$string['searchreplace_dlg:findnext'] = 'Hitta nästa';
$string['searchreplace_dlg:findwhat'] = 'Hitta vad';
$string['searchreplace_dlg:mcase'] = 'Matcha gemener/versaler';
$string['searchreplace_dlg:notfound'] = 'Sökningen har slutförts. Söksträngen kunde inte hittas.';
$string['searchreplace_dlg:replace'] = 'Ersätt';
$string['searchreplace_dlg:replace_title'] = 'Sök/ersätt';
$string['searchreplace_dlg:replaceall'] = 'Ersätt alla';
$string['searchreplace_dlg:replacewith'] = 'Ersätt med';
$string['searchreplace_dlg:search_title'] = 'Sök';
$string['searchreplace_dlg:searchnext_desc'] = 'Sök igen';
$string['searchreplace_dlg:up'] = 'Uppåt';
$string['settings'] = 'Allmänna inställningar';
$string['simple:bold_desc'] = 'Fet (<kbd>Ctrl+B</kbd>)';
$string['simple:bullist_desc'] = 'Infoga/ta bort punktlista';
$string['simple:cleanup_desc'] = 'Städa upp rörig kod';
$string['simple:italic_desc'] = 'Kursiv (<kbd>Ctrl+I</kbd>)';
$string['simple:numlist_desc'] = 'Infoga/ta bort numrerad lista';
$string['simple:redo_desc'] = 'Gör om (<kbd>Ctrl+Y</kbd>)';
$string['simple:striketrough_desc'] = 'Genomstruken';
$string['simple:underline_desc'] = 'Understruken (<kbd>Ctrl+U</kbd>)';
$string['simple:undo_desc'] = 'Ångra (<kbd>Ctrl+Z</kbd>)';
$string['spellchecker:desc'] = 'Slå av/på stavningskontroll';
$string['spellchecker:ignore_word'] = 'Ignorera ord';
$string['spellchecker:ignore_words'] = 'Ignorera alla';
$string['spellchecker:langs'] = 'Språk';
$string['spellchecker:learn_word'] = 'Lär in ord';
$string['spellchecker:menu'] = 'Inställningar för stavningskontroll';
$string['spellchecker:no_mpell'] = 'Inga felstavningar funna.';
$string['spellchecker:no_sug'] = 'Inga förslag';
$string['spellchecker:sug'] = 'Förslag';
$string['spellchecker:wait'] = 'Var god vänta...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Redigera CSS';
$string['style_dlg:apply'] = 'Använd';
$string['style_dlg:background'] = 'Bakgrund';
$string['style_dlg:background_attachment'] = 'Fästpunkt';
$string['style_dlg:background_color'] = 'Bakgrundsfärg';
$string['style_dlg:background_hpos'] = 'Horisontell position';
$string['style_dlg:background_image'] = 'Bakgrundsbild';
$string['style_dlg:background_repeat'] = 'Upprepa';
$string['style_dlg:background_tab'] = 'Bakgrund';
$string['style_dlg:background_vpos'] = 'Vertikal position';
$string['style_dlg:block'] = 'Block';
$string['style_dlg:block_display'] = 'Display';
$string['style_dlg:block_letterspacing'] = 'Teckeavstånd';
$string['style_dlg:block_tab'] = 'Block';
$string['style_dlg:block_text_align'] = 'Textjustering';
$string['style_dlg:block_text_indent'] = 'Textindrag';
$string['style_dlg:block_vertical_alignment'] = 'Vertikal justering';
$string['style_dlg:block_whitespace'] = 'Whitespace';
$string['style_dlg:block_wordspacing'] = 'Ordavstånd';
$string['style_dlg:border'] = 'Kantlinje';
$string['style_dlg:border_tab'] = 'Kantlinje';
$string['style_dlg:bottom'] = 'Nedan';
$string['style_dlg:box'] = 'Ruta';
$string['style_dlg:box_clear'] = 'Rensa';
$string['style_dlg:box_float'] = 'Float';
$string['style_dlg:box_height'] = 'Höjd';
$string['style_dlg:box_tab'] = 'Box';
$string['style_dlg:box_width'] = 'Bredd';
$string['style_dlg:bullet_image'] = 'Bild';
$string['style_dlg:clip'] = 'Beskärning';
$string['style_dlg:color'] = 'Färg';
$string['style_dlg:height'] = 'Höjd';
$string['style_dlg:left'] = 'Vänster';
$string['style_dlg:list'] = 'Lista';
$string['style_dlg:list_tab'] = 'Listor';
$string['style_dlg:list_type'] = 'Listtyp';
$string['style_dlg:margin'] = 'Marginal';
$string['style_dlg:overflow'] = 'Spill';
$string['style_dlg:padding'] = 'Utfyllnad';
$string['style_dlg:placement'] = 'Placering';
$string['style_dlg:position'] = 'Position';
$string['style_dlg:positioning_tab'] = 'Positionering';
$string['style_dlg:positioning_type'] = 'Positionstyp';
$string['style_dlg:right'] = 'Höger';
$string['style_dlg:same'] = 'Samma för alla';
$string['style_dlg:style'] = 'Stil';
$string['style_dlg:text'] = 'Text';
$string['style_dlg:text_blink'] = 'Blinka';
$string['style_dlg:text_case'] = 'Skiftläge';
$string['style_dlg:text_color'] = 'Färg';
$string['style_dlg:text_decoration'] = 'Dekoration';
$string['style_dlg:text_font'] = 'Teckensnitt';
$string['style_dlg:text_lineheight'] = 'Radhöjd';
$string['style_dlg:text_none'] = 'Ingen';
$string['style_dlg:text_overline'] = 'Linje ovanför';
$string['style_dlg:text_props'] = 'Text';
$string['style_dlg:text_size'] = 'Storlek';
$string['style_dlg:text_striketrough'] = 'Genomstruken';
$string['style_dlg:text_style'] = 'Stil';
$string['style_dlg:text_tab'] = 'Text';
$string['style_dlg:text_underline'] = 'Understruken';
$string['style_dlg:text_variant'] = 'Variant';
$string['style_dlg:text_weight'] = 'Tjocklek';
$string['style_dlg:title'] = 'Redigera CSS';
$string['style_dlg:toggle_insert_span'] = 'Infoga span vid urval';
$string['style_dlg:top'] = 'Överst';
$string['style_dlg:visibility'] = 'Synlighet';
$string['style_dlg:width'] = 'Bredd';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Pluginmodul';
$string['subplugintype_tinymce_plural'] = 'Pluginmoduler';
$string['table:cell'] = 'Cell';
$string['table:cell_desc'] = 'Cellegenskaper';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Kolumn';
$string['table:col_after_desc'] = 'Infoga kolumn efter';
$string['table:col_before_desc'] = 'Infoga kolumn före';
$string['table:copy_row_desc'] = 'Kopiera tabellrad';
$string['table:cut_row_desc'] = 'Klipp ut tabellrad';
$string['table:del'] = 'Ta bort tabell';
$string['table:delete_col_desc'] = 'Ta bort kolumn';
$string['table:delete_row_desc'] = 'Ta bort rad';
$string['table:desc'] = 'Infoga/redigera tabell';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Sammanfoga celler';
$string['table:paste_row_after_desc'] = 'Klistra in rad efter';
$string['table:paste_row_before_desc'] = 'Klistra in rad före';
$string['table:props_desc'] = 'Tabellegenskaper';
$string['table:row'] = 'Rad';
$string['table:row_after_desc'] = 'Infoga rad efter';
$string['table:row_before_desc'] = 'Infoga rad före';
$string['table:row_desc'] = 'Radegenskaper';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Dela upp sammanslagna celler';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Avancerade egenskaper';
$string['table_dlg:advanced_tab'] = 'Avancerat';
$string['table_dlg:align'] = 'Justering';
$string['table_dlg:align_bottom'] = 'Nedan';
$string['table_dlg:align_default'] = 'Standard';
$string['table_dlg:align_left'] = 'Vänster';
$string['table_dlg:align_middle'] = 'Centrera';
$string['table_dlg:align_right'] = 'Höger';
$string['table_dlg:align_top'] = 'Ovan';
$string['table_dlg:bgcolor'] = 'Bakgrundsfärg';
$string['table_dlg:bgimage'] = 'Bakgrundsbild';
$string['table_dlg:border'] = 'Kantlinje';
$string['table_dlg:bordercolor'] = 'Kantlinjefärg';
$string['table_dlg:caption'] = 'Tabellrubrik';
$string['table_dlg:cell_all'] = 'Uppdatera alla celler i tabellen';
$string['table_dlg:cell_cell'] = 'Uppdatera aktuell cell';
$string['table_dlg:cell_col'] = 'Uppdatera alla celler i kolumn';
$string['table_dlg:cell_limit'] = 'Du kan inte skapa en tabell med fler än {$cells} celler.';
$string['table_dlg:cell_row'] = 'Uppdatera alla celler i raden';
$string['table_dlg:cell_title'] = 'Tabellcellsegenskaper';
$string['table_dlg:cell_type'] = 'Celltyp';
$string['table_dlg:cellpadding'] = 'Cellutfyllnad';
$string['table_dlg:cellspacing'] = 'Cellsavstånd';
$string['table_dlg:col_limit'] = 'Du kan inte ange fler än {$cols} kolumner.';
$string['table_dlg:colgroup'] = 'Kolumngrupp';
$string['table_dlg:cols'] = 'Kolumner';
$string['table_dlg:frame'] = 'Ram';
$string['table_dlg:frame_all'] = 'alla';
$string['table_dlg:frame_cols'] = 'kolumner';
$string['table_dlg:frame_groups'] = 'grupper';
$string['table_dlg:frame_none'] = 'inga';
$string['table_dlg:frame_rows'] = 'rader';
$string['table_dlg:general_props'] = 'Allmänna egenskaper';
$string['table_dlg:general_tab'] = 'Allmänt';
$string['table_dlg:height'] = 'Höjd';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Språkkod';
$string['table_dlg:langdir'] = 'Språkriktning';
$string['table_dlg:ltr'] = 'Vänster till höger';
$string['table_dlg:merge_cells_title'] = 'Sammanfoga celler';
$string['table_dlg:mime'] = 'MIME-typ';
$string['table_dlg:missing_scope'] = 'Vill du fortsätta utan att ange ett omfång för den här tabellrubrikcellen? Utan det kan det vara svårt för vissa användare med funktionshinder att förstå innehållet eller data som visas i tabellen.';
$string['table_dlg:row_all'] = 'Uppdatera alla rader i tabellen';
$string['table_dlg:row_even'] = 'Uppdatera jämna rader i tabellen';
$string['table_dlg:row_limit'] = 'Du kan inte ange fler än {$rows} rader.';
$string['table_dlg:row_odd'] = 'Uppdatera udda rader i tabellen';
$string['table_dlg:row_row'] = 'Uppdatera nuvarande rad';
$string['table_dlg:row_title'] = 'Tabellradsegenskaper';
$string['table_dlg:rowgroup'] = 'Radgrupp';
$string['table_dlg:rows'] = 'Rader';
$string['table_dlg:rowtype'] = 'Radtyp';
$string['table_dlg:rtl'] = 'Höger till vänster';
$string['table_dlg:rules'] = 'Regler';
$string['table_dlg:rules_above'] = 'över';
$string['table_dlg:rules_below'] = 'under';
$string['table_dlg:rules_border'] = 'kantlinje';
$string['table_dlg:rules_box'] = 'box';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'void';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Omfattning';
$string['table_dlg:style'] = 'Stil';
$string['table_dlg:summary'] = 'Sammanfattning';
$string['table_dlg:tbody'] = 'Innehåll';
$string['table_dlg:td'] = 'Data';
$string['table_dlg:tfoot'] = 'Tabellfot';
$string['table_dlg:th'] = 'Rubrik';
$string['table_dlg:thead'] = 'Tabellhuvud';
$string['table_dlg:title'] = 'Infoga/redigera tabell';
$string['table_dlg:valign'] = 'Vertikal justering';
$string['table_dlg:width'] = 'Bredd';
$string['template:desc'] = 'Infoga en färdig mall';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Söndag,Måndag,Tisdag,Onsdag,Torsdag,Fredag,Lördag,Söndag';
$string['template_dlg:day_short'] = 'Sön,Mån,Tis,Ons,Tors,Fre,Lör,Sön';
$string['template_dlg:desc'] = 'Infoga en färdig mall';
$string['template_dlg:desc_label'] = 'Beskrivning';
$string['template_dlg:label'] = 'Mall';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'Januari,Februari,Mars,April,Maj,Juni,Juli,Augusti,September,Oktober,November,December';
$string['template_dlg:months_short'] = 'Jan,Feb,Mar,Apr,Maj,Jun,Jul,Aug,Sep,Okt,Nov,Dec';
$string['template_dlg:preview'] = 'Förhandsgranska';
$string['template_dlg:select'] = 'Välj en mall';
$string['template_dlg:title'] = 'Mallar';
$string['template_dlg:warning'] = '<strong>Varning!</strong> Att uppdatera en mall med en ny kan innebära dataförlust.';
$string['visualblocks:desc'] = 'Visa/dölj block';
$string['visualchars:desc'] = 'Visa/dölj kontrolltecken';
$string['wordcount:words'] = 'Ord:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Förkortning';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Akronym';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Infoga/ändra attribut';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citat';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Borttagning';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Infogning';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attribut';
$string['xhtmlxtras_dlg:attribs_title'] = 'Infoga/ändra attribut';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attribut';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Händelser';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Snabbtangent';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citat';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klass';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Datum/tid';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Språk';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Skrivriktning';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stil';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Tabbindex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Titel';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Vänster till höger';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Höger till vänster';
$string['xhtmlxtras_dlg:events_tab'] = 'Händelser';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Elementattribut';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Elementhändelser';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Allmänna inställningar';
$string['xhtmlxtras_dlg:general_tab'] = 'Allmänt';
$string['xhtmlxtras_dlg:insert_date'] = 'Infoga aktuellt datum och tid';
$string['xhtmlxtras_dlg:option_ltr'] = 'Vänster till höger';
$string['xhtmlxtras_dlg:option_rtl'] = 'Höger till vänster';
$string['xhtmlxtras_dlg:remove'] = 'Ta bort';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Förkortningselement';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Akronym-element';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Citatelement';
$string['xhtmlxtras_dlg:title_del_element'] = 'Borttagningselement';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Infogning';
