<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'lt', version '4.5'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'N';
$string['Afull'] = 'Nedalyvauta';
$string['Eacronym'] = 'A';
$string['Efull'] = 'Atleista';
$string['Lacronym'] = 'P';
$string['Lfull'] = 'Pavėluota';
$string['Pacronym'] = 'D';
$string['Pfull'] = 'Dalyvauta';
$string['absenteereport'] = 'Nedalyvavusių ataskaita';
$string['acronym'] = 'Santrumpa';
$string['add'] = 'Įtraukti';
$string['addedrecip'] = 'Pridėtas {$a} naujas gavėjas';
$string['addedrecips'] = 'Pridėta {$a} naujų gavėjų';
$string['addmultiplesessions'] = 'Daugkartiniai užsiėmimai';
$string['addsession'] = 'Įtraukti užsiėmimą';
$string['adduser'] = 'Pridėti dalyvius';
$string['addwarning'] = 'Įtraukti įspėjimą';
$string['all'] = 'Visi';
$string['allcourses'] = 'Visi kursai';
$string['allowupdatestatus'] = 'Leisti besimokantiesiems atnaujinti savo dalyvavimą.';
$string['allpast'] = 'Visi praėję';
$string['allsessions'] = 'Visi užsiėmimai';
$string['allsessionstotals'] = 'Pasirinktų seansų sumos';
$string['attendance:addinstance'] = 'Įtraukti naują dalyvavimo veiklą';
$string['attendance:canbelisted'] = 'Rodoma sąraše';
$string['attendance:changeattendances'] = 'Dalyvavimo keitimas';
$string['attendance:changepreferences'] = 'Nuostatų keitimas';
$string['attendance:export'] = 'Ataskaitų eksportavimas';
$string['attendance:import'] = 'Importuoti seansus iš failo (csv)';
$string['attendance:manageattendances'] = 'Valdyti dalyvavimą';
$string['attendance:managetemporaryusers'] = 'Valdyti laikinus dalyvius';
$string['attendance:takeattendances'] = 'Dalyvavimų žymėjimas';
$string['attendance:view'] = 'Dalyvavimų peržiūra';
$string['attendance:viewreports'] = 'Ataskaitų peržiūra';
$string['attendance:viewsummaryreports'] = 'Peržiūrėti kursų santraukos ataskaitą';
$string['attendance:warningemails'] = 'Galima prenumeruoti nedalyvaujančių dalyvių el. laiškus';
$string['attendance_already_submitted'] = 'Jūsų lankomumas jau nustatytas.';
$string['attendance_no_status'] = 'Nėra galimo dalyvavimo statuso - tikriausiai pavėlavote įrašyti savo dalyvavimą.';
$string['attendancedata'] = 'Dalyvavimo duomenys';
$string['attendancefile'] = 'Dalyvavimo failas (csv formatas)';
$string['attendancefile_help'] = 'Failas turi būti CSV failas su antraštės eilute ir laukais, skirtais identifikuoti vartotoją ir įrašytą lankomumą, pvz., (email,scantime) arba (username,time)';
$string['attendancegrade'] = 'Dalyvavimo įvertis';
$string['attendancenotset'] = 'Jūs turite pažymėti savo dalyvavimą';
$string['attendancenotstarted'] = 'Dalyvavimas dar neprasidėjo šiam kursui';
$string['attendancepercent'] = 'Dalyvavimas procentais';
$string['attendancereport'] = 'Dalyvavimas';
$string['attendanceslogged'] = 'Dalyvavimas prisijungiant';
$string['attendancestaken'] = 'Dalyvavimo pateikimas';
$string['attendancesuccess'] = 'Dalyvavimas sėkmingai užregistruotas';
$string['attendanceupdated'] = 'Dalyvavimas sėkmingai atnaujintas';
$string['attendanceuserreport'] = 'Dalyvavimo ataskaita';
$string['attforblockdirstillexists'] = 'senasis mod/attforblock katalogas vis dar egzistuoja - prieš paleidžiant šį naujinimą turite ištrinti šį katalogą savo serveryje.';
$string['attrecords'] = 'Dalyvavimo įrašai';
$string['autoassignstatus'] = 'Automatiškai parinkti aukščiausią būseną';
$string['autoassignstatus_help'] = 'Jei pažymėta, besimokantiesiems automatiškai bus priskirta aukščiausia būsena su didžiausiu galimu įvertinimu.';
$string['automark'] = 'Automatinis žymėjimas';
$string['automark_help'] = 'Leidžia žymėjimą atlikti automatiškai.
Jei "Taip", besimokantieji bus automatiškai pažymėti priklausomai nuo jų pirmosios prieigos prie kurso.
Jei "Nustatyti nepažymėtus sesijos pabaigoje", visiems besimokantiesiems, kurie nepažymėjo savo lankomumo, bus nustatyta pasirinkta nepažymėjimo būsena.';
$string['automarkall'] = 'Taip';
$string['automarkclose'] = 'Nepažymėtus nustatyti užsiėmimo pabaigoje';
$string['automarktask'] = 'Patikrinti dalyvavimo užsiėmimus, kurie reikalauja automatinio žymėjimo';
$string['automarkuseempty'] = 'Automatinio žymėjimo būsenos pasiekiamumo tvarkymas';
$string['autorecorded'] = 'Automatiškai įrašė sistema';
$string['availability'] = 'Savarankiško žymėjimo galimybė';
$string['availability_help'] = 'Apriboti šios būsenos prieinamumą. <br> Jei pasirinkta parinktis "Ribotas laikas", nurodykite minučių skaičių, kiek minučių galima naudotis šia būsena prasidėjus užsiėmimui. Tai taikoma, kai besimokantieji patys pažymi savo lankomumą.';
$string['availabilityalways'] = 'Visada';
$string['availabilitylimitedtime'] = 'Ribotas laikas';
$string['availabilityno'] = 'Ne';
$string['availablebeforesession'] = 'Galimas prieš sesijos pradžią';
$string['availablebeforesession_help'] = 'Kai besimokantieji patys pažymi savo lankomumą, ar leisti šią būseną pasirinkti prieš prasidedant užsiėmimui.';
$string['averageattendance'] = 'Dalyvavimo vidurkis';
$string['averageattendancegraded'] = 'Dalyvavimo vidurkis';
$string['backtoparticipants'] = 'Grįžti į dalyvių sąrašą';
$string['below'] = 'Žemiau {$a}%';
$string['calclose'] = 'Uždaryti';
$string['calendarevent'] = 'Sukurti sesijos kalendoriaus įvykį';
$string['calendarevent_help'] = 'Jei įjungta, šiam seansui bus sukurtas kalendoriaus įvykis.
Jei išjungta, visi esami šios sesijos kalendoriaus įvykiai bus ištrinti.';
$string['caleventcreated'] = 'Kalendoriaus įvykis užsiėmimui sėkmingai sukurtas';
$string['caleventdeleted'] = 'Kalendoriaus įvykis užsiėmimui sėkmingai ištrintas';
$string['calmonths'] = 'Sausis, Vasaris, Kovas, Balandis, Gegužė, Birželis, Liepa, Rugpjūtis, Rugsėjis, Spalis, Lapkritis, Gruodis';
$string['calshow'] = 'Pasirinkti datą';
$string['calweekdays'] = 'S,Pr,A,T,K,P,Š';
$string['cannottakeforgroup'] = 'Jūs negalite pateikti dalyvavimo grupei "{$a}"';
$string['cannottakethisgroup'] = 'Jūs nesate kursų grupės, su kuria susijusi ši dalyvavimo sesija, narys, jūsų dalyvavimas nebuvo įrašytas.';
$string['cantaddstatus'] = 'Pridėdami naują būseną turite nurodyti santrumpą ir aprašymą.';
$string['canthidestatus'] = 'Negalite paslėpti šios būsenos, nes ji jau naudojama šioje dalyvavimo veikloje';
$string['categoryreport'] = 'Kurso kategorijos ataskaita';
$string['changeattendance'] = 'Keisti dalyvavimą';
$string['changeduration'] = 'Keisti trukmę';
$string['changesession'] = 'Keisti užsiėmimą';
$string['checkweekdays'] = 'Parinkti savaitės dienas, kurios patenka į pasirinktą užsiėmimo intervalą.';
$string['closed'] = 'Šioje sesijoje šiuo metu negalima atlikti pasižymėjimo';
$string['column'] = 'stulpelis';
$string['columnmap'] = 'Stulpelių atvaizdavimas';
$string['columnmap_help'] = 'Kiekviename pateiktame lauke pasirinkite atitinkamą csv failo stulpelį.';
$string['columns'] = 'stulpeliai';
$string['commonsession'] = 'Visi besimokantieji';
$string['commonsessions'] = 'Visi besimokantieji';
$string['confirm'] = 'Patvirtinti';
$string['confirmcolumnmappings'] = 'Patvirtinti dailų atvaizdavimą';
$string['confirmdeletehiddensessions'] = 'Ar esate tikri, kad norite pašalinti {$a->count} užsiėmimus, suplanuotus prieš kurso pradžios datą ({$a->date})?';
$string['confirmdeleteuser'] = 'Ar tikrai norite pašalinti naudotoją "{$a->fullname}" ({$a->email})?<br/>Visi jo dalyvavimo įrašai bus pašalinti visam laikui.';
$string['copyfrom'] = 'Kopijuoti dalyvavimo datą iš';
$string['countofselected'] = 'Pasirinktų skaičius';
$string['course'] = 'Kursas';
$string['coursemessage'] = 'Žinutės kurso naudotojams';
$string['courseshortname'] = 'Kurso trumpasis pavadinimas';
$string['coursesummary'] = 'Kursų santraukos ataskaita';
$string['createmultiplesessions'] = 'Kurti daugkartinius užsiėmimus';
$string['createmultiplesessions_help'] = 'Ši funkcija leidžia sukurti kelis užsiėmimus vienu veiksmu. Užsiėmimai prasideda nuo pagrindinės datos ir tęsiasi iki „Kartoti iki“ datos.

* <strong>Kartojama</strong>: pasirinkite savaitės dieną ar dienas, kuriomis vyks susitikimai (pvz., Pirmadienis/Trečiadienis/Penktadienis).
* <strong>Kartoti kas</strong>:  leidžia nustatyti susitikimo dažnį. Jei užsiėmimai vyks kiekvieną savaitę, pasirinkite 1, jei numatomi kas antrą savaitę - pasirinkite 2, kas trečią savaitę - pasirinkite 3 ir t.t.
* <strong>Kartoti iki</strong>:  nurodykite paskutinę susitikimo dieną (paskutinę dieną, iki kurios numatomi užsiėmimo dalyvavimai).';
$string['createonesession'] = 'Sukurkite vieną užsiėmimą kursui';
$string['csvdelimiter'] = 'CSV skyriklis';
$string['currentlyselectedusers'] = 'Šiuo metu pasirinkti naudotojai';
$string['customexportfields'] = 'Eksportuokti pasirinktinius naudotojo profilio laukus';
$string['customexportfields_help'] = 'Eksporto ataskaitoje pateikti papildomi pasirinktiniai naudotojo profilio laukai.';
$string['customfields'] = 'Pasirinktiniai seanso laukai';
$string['date'] = 'Data';
$string['days'] = 'Dienos';
$string['defaultdisplaymode'] = 'Numatytasis rodymo režimas';
$string['defaults'] = 'Numatytieji nustatymai';
$string['defaultsessionsettings'] = 'Numatytieji užsiėmimo nustatymai';
$string['defaultsessionsettings_help'] = 'Šie nustatymai apibrėžia visų naujų seansų numatytuosius parametrus';
$string['defaultsettings'] = 'Numatytieji dalyvavimo nustatymai';
$string['defaultsettings_help'] = 'Šie nustatymai apibrėžia numatytuosius nustatymus visiems naujiems dalyvavimams';
$string['defaultstatus'] = 'Numatytasis būsenos rinkinys';
$string['defaultsubnet'] = 'Numatytasis tinklo adresas';
$string['defaultsubnet_help'] = 'Dalyvavimo įrašymas gali būti ribojamas tik tam tikriems antriniams tinklams, nurodant kableliais atskirtų dalinių arba visiškų IP adresų sąrašą. Tai yra numatytoji vertė, naudojama kuriant naujus užsiėmimus.';
$string['defaultview'] = 'Numatytasis rodinys prisijungiant';
$string['defaultview_desc'] = 'Numatytasis rodinys, pateikiamas dėstytojams pirmojo prisijungimo metu.';
$string['defaultwarnings'] = 'Numatytasis įspėjimo rinkinys';
$string['defaultwarningsettings'] = 'Numatytieji įspėjimo nustatymai';
$string['defaultwarningsettings_help'] = 'Šie nustatymai apibrėžia visų naujų įspėjimų numatytuosius parametrus';
$string['delete'] = 'Naikinti';
$string['deletecheckfull'] = 'Ar tikrai norite visiškai ištrinti {$a}, įskaitant visus naudotojo duomenis?';
$string['deletedgroup'] = 'Grupė, susieta su šiuo užsiėmimu, buvo ištrinta';
$string['deletehiddensessions'] = 'Naikinti visus paslėptus užsiėmimus';
$string['deletelogs'] = 'Naikinti dalyvavimo datą';
$string['deleteselected'] = 'Naikinti pasirinktus';
$string['deletesession'] = 'Naikinti užsiėmimą';
$string['deletesessions'] = 'Naikinti visus užsiėmimus';
$string['deleteuser'] = 'Naikinti dalyvius';
$string['deletewarningconfirm'] = 'Ar esate tikri, kad norite naikinti įspėjimą?';
$string['deletingsession'] = 'Naikinamas kurso užsiėmimas';
$string['deletingstatus'] = 'Naikinama kurso būsena';
$string['description'] = 'Aprašymas';
$string['display'] = 'Rodymas';
$string['displaymode'] = 'Rodymo režimas';
$string['donotusepaging'] = 'Nenaudoti puslapių';
$string['downloadexcel'] = 'Atsisiųsti „Excel“ formatu';
$string['downloadooo'] = 'Atsisiųsti „OpenOffice“ formatu';
$string['downloadtext'] = 'Atsisiųsti tekstiniu formatu';
$string['duration'] = 'Trukmė';
$string['editsession'] = 'Redaguoti užsiėmimą';
$string['edituser'] = 'Redaguoti dalyvį';
$string['emailcontent'] = 'El. laiško turinys';
$string['emailcontent_default'] = 'Sveiki, %userfirstname%,
Jūsų dalyvavimas kurse %coursename% %attendancename% sumažėjo %warningpercent% ir šiuo metu yra %percent% - tikimės, jog Jums viskas gerai!

Efektyvesniam šio kurso įsisavinimui, turėtumėte pagerinti dalyvavimą, prašome susisiekti, jei Jums reikia papildomos pagalbos.';
$string['emailcontent_help'] = 'Šiame lauke pateikiamas turinys, kuris siunčiamas besimokančiajam kaip įspėjimas. Galima naudoti šiuos pakaitos simbolius:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'El. laiško tema';
$string['emailsubject_default'] = 'Dalyvavimo įspėjimas';
$string['emailsubject_help'] = 'Šiame lauke pateikiamas turinys, kuris siunčiamas besimokančiajam kaip įspėjimas.';
$string['emailuser'] = 'El. pašto naudotojas';
$string['emailuser_help'] = 'Jei pažymėta, besimokančiajam bus išsiunčiamas įspėjimas.';
$string['emptyacronym'] = 'Santrumpos laukas negali būti tuščias. Būsenos įrašas neatnaujintas.';
$string['emptydescription'] = 'Aprašymo laukas negali būti tuščias. Būsenos įrašas neatnaujintas.';
$string['enablecalendar'] = 'Kurti kalendoriaus įvykius';
$string['enablecalendar_desc'] = 'Jei įjungta, kiekvienam dalyvavimo užsiėmimui  bus sukurtas įvykis kalendoriuje. Pakeitus šį nustatymą, kalendoriaus ataskaita bus atnaujinta.';
$string['enablewarnings'] = 'Įjungti įspėjimus';
$string['encoding'] = 'Kodavimas';
$string['endofperiod'] = 'Laikotarpio pabaiga';
$string['endtime'] = 'Užsiėmimo pabaiga';
$string['enrolmentend'] = 'Dalyvis išregistruotas {$a}';
$string['enrolmentstart'] = 'Dalyvis įregistruotas {$a}';
$string['enrolmentsuspended'] = 'Registracija sustabdyta';
$string['enterpassword'] = 'Įvesti slaptažodį';
$string['error:coursehasnoattendance'] = 'Kursas, kurio trumpasis pavadinimas {$a}, neturi dalyvavimo veiklos.';
$string['error:coursenotfound'] = 'Kursas, kurio trumpasis pavadinimas {$a}, nerastas.';
$string['error:qrcode'] = 'Leidimas besimokantiesiems patiems fiksuoti lankomumą turi būti įjungtas, kad būtų galima naudoti QR kodą! Praleidžiama.';
$string['error:sessioncourseinvalid'] = 'Klaidingas užsiėmimo kursas! Praleista.';
$string['error:sessiondateinvalid'] = 'Klaidinga užsiėmimo data! Praleista.';
$string['error:sessionendinvalid'] = 'Netinkamas užsiėmimo pabaigos laikas! Praleista.';
$string['error:sessionstartinvalid'] = 'Netinkamas užsiėmimo pradžios laikas! Praleista.';
$string['error:statusnotfound'] = 'Naudotojas: {$a->extuser} turi būsenos reikšmę, kurios nepavyko rasti: {$a->status}';
$string['errorgroupsnotselected'] = 'Pasirinkti vieną ar daugiau grupių';
$string['errorinaddingsession'] = 'Klaida įtraukiant užsiėmimą';
$string['erroringeneratingsessions'] = 'Klaida generuojant užsiėmimą';
$string['eventdurationupdated'] = 'Užsiėmimo trukmė atnaujinta';
$string['eventreportviewed'] = 'Dalyvavimo ataskaita peržiūrėta';
$string['eventscreated'] = 'Kalendoriaus įvykiai sukurti';
$string['eventsdeleted'] = 'Kalendoriaus įvykiai panaikinti';
$string['eventsessionadded'] = 'Užsiėmimas įtrauktas';
$string['eventsessiondeleted'] = 'Užsiėmimas ištrintas';
$string['eventsessionipshared'] = 'Dalyvavimo savarankiško įsirašymo IP konfliktas';
$string['eventsessionsimported'] = 'Užsiėmimai importuoti';
$string['eventsessionupdated'] = 'Užsiėmimas atnaujintas';
$string['eventstatusadded'] = 'Būsena pridėta';
$string['eventstatusupdated'] = 'Būsena atnaujinta';
$string['eventstudentattendancesessionsupdated'] = 'Sesijos ataskaita atnaujinta';
$string['eventstudentattendancesessionsviewed'] = 'Sesijos ataskaita peržiūrėta';
$string['eventtaken'] = 'Dalyvavimas pateiktas';
$string['eventtakenbystudent'] = 'Studento dalyvavimas pateiktas';
$string['export'] = 'Eksportuoti';
$string['extrarestrictions'] = 'Papildomi apribojimai';
$string['formattexttype'] = 'Formatavimas';
$string['from'] = 'nuo:';
$string['gradebookexplanation'] = 'Įvertinimas įvertinimų knygelėje';
$string['graded'] = 'Įvertinti užsiėmimai';
$string['gridcolumns'] = 'Tinklelio stulpeliai';
$string['group'] = 'Grupė';
$string['groups'] = 'Grupės';
$string['groupsession'] = 'Besimokančiųjų grupė';
$string['groupsessionsby'] = 'Grupės užsiėmimai pagal';
$string['hiddensessions'] = 'Paslėpti užsiėmimai';
$string['hiddensessions_help'] = 'Užsiėmimai yra paslėpti, jei jie yra suplanuoti prieš kurso pradžios datą.

Galite naudoti šią funkciją senesniems užsiėmimams vietoj jų pašalinimo. Įverčių knygelėje rodomi tik nepaslėpti užsiėmimai.';
$string['hiddensessionsdeleted'] = 'Visi paslėpti užsiėmimai panaikinti';
$string['hideextrauserdetails'] = 'Slėpti papildomus naudotojo duomenis';
$string['hidensessiondetails'] = 'Slėpti užsiėmimo detales';
$string['identifyby'] = 'Besimokantysis atpažįstamas pagal';
$string['import'] = 'Importuoti';
$string['importfile'] = 'Importuoti failą';
$string['importfile_help'] = 'Importuoti failą';
$string['importsessions'] = 'Užsiėmimų importas';
$string['importstatus'] = 'Būsenos laukas';
$string['includeabsentee'] = 'Įtraukti užsiėmimą į ataskaitos skaičiavimą kaip nedalyvauta';
$string['includeabsentee_help'] = 'Jei pažymėta, ši sesija bus įtraukta į nedalyvavimo ataskaitos skaičiavimus.';
$string['includeall'] = 'Pasirinkti visus užsiėmimumus';
$string['includedescription'] = 'Įtraukti sesijos aprašymą';
$string['includenottaken'] = 'Įtraukti neteiktus užsiėmimus';
$string['includeqrcode'] = 'Įtraukti QR kodą';
$string['includeremarks'] = 'Įtraukti pastabas';
$string['incorrectpassword'] = 'Įvedėte neteisingą slaptažodį ir Jūsų dalyvavimas nebuvo įrašytas. Prašome įvesti teisingą slaptažodį.';
$string['indetail'] = 'Detaliai...';
$string['indicator:cognitivedepth'] = 'Kognityvinis Dalyvavimas';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Turite pasirinkti veiksmą';
$string['invalidemails'] = 'Turite nurodyti esamų naudotojų adresus, nerasta: {$a}';
$string['invalidimportfile'] = 'Failo formatas netinkamas.';
$string['invalidsessionenddate'] = 'Ši data negali būti ankstesnė nei užsiėmimo data';
$string['invalidsessionendtime'] = 'Pabaigos laikas turi būti vėlesnis nei pradžios laikas';
$string['invalidstatus'] = 'Pasirinkote netinkamą būseną, pabandykite dar kartą';
$string['iptimemissing'] = 'Klaidingos minutės atnaujinimui';
$string['jumpto'] = 'Pereiti į';
$string['keepsearching'] = 'Ieškokite toliau';
$string['maxpossible'] = 'Didžiausias galimas';
$string['maxpossible_help'] = 'Rodomas didžiausias galimas rezultatas, kurį kiekvienas gali pasiekti kiekviename užsiėmime, įskaitant tuos, kurie dar nebuvo vykdomi (praeityje ir ateityje):
     <ul>
     <li><strong>Balai</strong>: didžiausi balai, kuriuos gali gauti dalyvis už visus užsiėmimus.</li>
     <li><strong>Procentai</strong>: galimi didžiausi procentai, kuriuos dalyvis gali gauti už visus  užsiėmimus.</li></ul>';
$string['maxpossiblepercentage'] = 'Galimi didžiausi procentai';
$string['maxpossiblepoints'] = 'Galimi didžiausi balai';
$string['maxwarn'] = 'Didžiausias el. laiškų įspėjimų skaičius';
$string['maxwarn_help'] = 'Didžiausias skaičius, nurodantis laiko tarpą, per kurį turi būti išsiųstas (siunčiamas tik vienas įspėjimas apie vieną užsiėmimą)';
$string['mergeuser'] = 'Apjungti dalyvius';
$string['messagedselecteduserfailed'] = 'Nepavyko išsiųsti pranešimo vienam ar keliems naudotojams. Įjunkite derinimą, kad sužinotumėte daugiau.';
$string['mobilesessionto'] = 'Rodyti būsimas sesijas';
$string['mobilesettings'] = 'Programėlės mobiliesiems nustatymai';
$string['modulename'] = 'Dalyvavimas';
$string['modulename_help'] = 'Dalyvavimo veiklos modulis leidžia dėstytojui fiksuoti besimokančiųjų dalyvavimą, besimokantiesiems - peržiūrėti savo dalyvavimo duomenis.

Dėstytojai gali kurti daugkartinius užsiėmimus ir pažymėti atitinkamą dalyvavimo statusą: "Dalyvauta", "Nedalyvauta", "Pavėluota", "Atleista" arba keisti būsenas pagal poreikį.

Ataskaitos prieinamos visiems dalyviams arba individualiai besimokantiesiems.';
$string['modulenameplural'] = 'Dalyvavimai';
$string['months'] = 'Mėnesio';
$string['moreattendance'] = 'Dalyvavimas sėkmingai pateiktas šiame puslapyje';
$string['moveleft'] = 'Perkelti į kairę';
$string['moveright'] = 'Perkelti į dešinę';
$string['multisessionexpanded'] = 'Daugkartiniai užsiėmimai išplėsti';
$string['multisessionexpanded_desc'] = 'Rodyti „Daugkartiniai užsiėmimai“ nustatymus kaip išplėstus pagal numatytuosius nustatymus, kai kuriami nauji užsiėmimai.';
$string['mustselectusers'] = 'Reikia pasirinkti eksportuojamus naudotojus';
$string['name'] = 'Pavadinimas';
$string['newdate'] = 'Nauja data';
$string['newduration'] = 'Nauja trukmė';
$string['newstatusset'] = 'Naujas būsenų rinkinys';
$string['noabsentstatusset'] = 'Naudojamas būsenų rinkinys neturi būsenos, kuri būtų naudojama, kai nepažymėta.';
$string['noattendanceusers'] = 'Nėra galimybės eksportuoti duomenų, nes kurse nėra įregistruota besimokančiųjų.';
$string['noattforuser'] = 'Nėra naudotojo dalyvavimo įrašų';
$string['noautomark'] = 'Išjungta';
$string['nodescription'] = 'Įprastas kurso užsiėmimas';
$string['noeventstoreset'] = 'Kalendorinių įvykių, kuriems reikia atnaujinimo, nėra';
$string['nogroups'] = 'Ši veikla buvo nustatyta naudoti grupes, bet kurse grupių nėra.';
$string['noguest'] = 'Svečiai negali peržiūrėti dalyvavimo';
$string['noofdaysabsent'] = 'Nėra nedalyvavimo dienų';
$string['noofdaysexcused'] = 'Nėra pateisintų dienų';
$string['noofdayslate'] = 'Nėra dienų, kai pavėluota';
$string['noofdayspresent'] = 'Nėra dalyvauta dienų';
$string['nosessiondayselected'] = 'Nepasirinkta užsiėmimo diena';
$string['nosessionexists'] = 'Nėra užsiėmimo šiam kursui';
$string['nosessionsselected'] = 'Nėra pasirinktų užsiėmimų';
$string['notfound'] = 'Dalyvavimo veikla nerasta šiame kurse!';
$string['notifytask'] = 'Siųsti įspėjimus naudotojams';
$string['notmember'] = 'ne&nbsp;narys';
$string['notset'] = 'nenustatyta';
$string['numsessions'] = 'Užsiėmimų skaičius';
$string['olddate'] = 'Sena data';
$string['onactivitycompletion'] = 'Užbaigus veiklą';
$string['onlyselectedusers'] = 'Eksportuoti konkrečius naudotojus';
$string['overallsessions'] = 'Per visus užsiėmimus';
$string['overallsessions_help'] = 'Rodoma visų užsiėmimų statistika, įskaitant tuos, kurie dar nebuvo vykdomi (praeityje ir ateityje):
     <ul>
     <li><strong>Užsiėmimai</strong>: bendras užsiėmimų skaičius.</li>
     <li><strong>Balai</strong>:balai skiriami atsižvelgiant į dalyvavimą užsiėmime.</li>
     <li><strong>Procentai</strong>: procentinė taškų išraiška pagal didžiausią galimą visų užsiėmimų taškus.</li></ul>';
$string['oversessionstaken'] = 'Pateikti užsiėmimai';
$string['oversessionstaken_help'] = 'Rodoma pateiktų užsiėmimų dalyvavimo statistika:
     <ul>
     <li><strong>Užsiėmimai</strong>: jau teiktų užsiėmimų skaičius.</li>
     <li><strong>Balai</strong>: skiriami balai atsižvelgiant į dalyvavimo būseną užsiėmime.</li>
     <li><strong>Procentai</strong>: procentinė balų išraiška pagal didžiausią galimą visų užsiėmimų taškus.</li></ul>';
$string['pageof'] = 'Puslapis {$a->page} iš {$a->numpages}';
$string['participant'] = 'Dalyvis';
$string['password'] = 'Slaptažodis';
$string['passwordgrp'] = 'Besimokančiųjų slaptažodis';
$string['passwordgrp_help'] = 'Jei nustatyta, besimokantieji turės įvesti šį slaptažodį prieš pateikdami savo dalyvavimo būseną užsiėmimui. Jei laukas tuščias, slaptažodžio įvesti nereikalaujama.';
$string['passwordrequired'] = 'Prieš pateikdami savo dalyvavimą, turite įvesti užsiėmimo slaptažodį';
$string['percentage'] = 'Procentai';
$string['percentageallsessions'] = 'Procentai už visus užsiėmimus';
$string['percentagesessionscompleted'] = 'Procentai už pateiktus užsiėmimus';
$string['pluginadministration'] = 'Dalyvavimo administravimas';
$string['pluginname'] = 'Dalyvavimas';
$string['points'] = 'Balai';
$string['pointsallsessions'] = 'Balai už visus užsiėmimus';
$string['pointssessionscompleted'] = 'Balai už pateiktus užsiėmimus';
$string['preferences_desc'] = 'Būsenos rinkinio keitimai įtakos esamus dalyvavimo užsiėmimus ir gali paveikti įvertinimą.';
$string['preventsharederror'] = 'Užsiėmime savarankiškas įsirašymas buvo išjungtas, nes panašu, jog šis įrenginys buvo naudojamas įrašyti kito besimokančiojo dalyvavimą.';
$string['preventsharedip'] = 'Neleisti besimokantiesiems dalintis IP adresu';
$string['preventsharedip_help'] = 'Tai neleis besimokantiesiems naudoti to paties įrenginio (identifikuojamo naudojant IP adresą) kitų besimokančiųjų dalyvavimo pateikimui.';
$string['preventsharediptime'] = 'Laikas leisti pakartotinai naudoti IP adresą (minutėmis)';
$string['preventsharediptime_help'] = 'Leisti pakartotinai naudoti IP adresą dalyvauti užsiėmime praėjus šiam laikui.';
$string['preview'] = 'Failo peržiūra';
$string['previewhtml'] = 'HTML formato peržiūra';
$string['privacy:metadata:attendancelog'] = 'Naudotojo dalyvavimo įrašų žurnalas.';
$string['privacy:metadata:attendancesessions'] = 'Užsiėmimai, į kuriuos dalyvavimas bus įrašytas.';
$string['privacy:metadata:duration'] = 'Užsiėmimo trukmė sekundėmis';
$string['privacy:metadata:lasttaken'] = 'Laikas, kai užsiėmimo dalyvavimas pateiktas paskutinį kartą.';
$string['privacy:metadata:lasttakenby'] = 'Naudotojo, kuris paskutinis pateikė dalyvavimą užsiėmime, ID.';
$string['privacy:metadata:sessionid'] = 'Dalyvavimo užsiėmimo ID';
$string['privacy:metadata:timesent'] = 'Laiko žyma, kai buvo išsiųstas įspėjimas.';
$string['privacy:metadata:timetaken'] = 'Laikas, kai besimokantysis pateikė dalyvavimą.';
$string['privacy:metadata:userid'] = 'Naudotojo, kuriam reikia siųsti įspėjimą, ID.';
$string['processingfile'] = 'Apdorojamas failas';
$string['qr_cookie_error'] = 'Baigėsi QR sesija.';
$string['qr_pass_wrong'] = 'QR slaptažodis neteisingas arba pasibaigęs.';
$string['qrcode'] = 'QR kodas';
$string['qrcodevalidafter'] = 'sekundės';
$string['qrcodevalidbefore'] = 'QR kodas galioja:';
$string['randompassword'] = 'Atsitiktinis slaptažodis';
$string['remark'] = 'Pastaba: {$a}';
$string['remarks'] = 'Pastabos';
$string['repeatasfollows'] = 'Kartoti užsiėmimą kaip nurodyta žemiau';
$string['repeatevery'] = 'Kartoti kas';
$string['repeaton'] = 'Kartojama';
$string['repeatuntil'] = 'Kartoti iki';
$string['report'] = 'Ataskaita';
$string['reportsessiondate'] = 'Sesijos data';
$string['reportsessionduration'] = 'Sesijos trukmė';
$string['required'] = 'Privaloma*';
$string['requiredentry_help'] = '<p align="center"><b>Dalyvavimas</b></p>
<p align="left"><strong>Sulietos paskyros</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Moodle naudotojas</th>
<th>Laikinas dalyvis</th>
<th>Veiksmas</th>
</tr>
<tr>
<td>Dalyvavimo duomenys</td>
<td>Dalyvavimo duomenys</td>
<td>Laikinas dalyvis pakeis Moodle naudotoją</td>
</tr>
<tr>
<td>Nėra dalyvavimo duomenų</td>
<td>Dalyvavimo data</td>
<td>Laikino dalyvio dalyvavimas bus perduotas Moodle naudotojui</td>
</tr>
<tr>
<td>Dalyvavimo duomenys</td>
<td>Nėra dalyvavimo datos</td>
<td>Laikinas dalyvis bus pašalintas</td>
</tr>
<tr>
<td>Nėra dalyvavimo duomenų</td>
<td>Nėra dalyvavimo duomenų/td>
<td>Laikinas dalyvis bus pašalintas</td>
</tr>
</table>

</p>
<p align="left"><strong>Laikinas dalyvis bus pašalintas visais atvejais po suliejimo veiksmo</strong></p>';
$string['requiresubnet'] = 'Reikalauti tinklo adreso';
$string['resetcalendar'] = 'Kalendoriaus atnaujinimas';
$string['resetdescription'] = 'Atminkite, kad dalyvavimo duomenų naikinimas pašalins visą informaciją iš duomenų bazės. Galite tiesiog paslėpti senesnius užsiėmimus, pakeitus pradžios datą kurse!';
$string['resetstatuses'] = 'Atstatyti numatytasias būsenas';
$string['restoredefaults'] = 'Atstatyti numatytuosius';
$string['resultsperpage'] = 'Rezultatai puslapyje';
$string['resultsperpage_desc'] = 'Besimokančiųjų skaičius rodomas viename puslapyje';
$string['rotateqrcode'] = 'Kaitalioti QR kodą';
$string['save'] = 'Išsaugoti dalyvavimą';
$string['saveandshownext'] = 'Išsaugoti ir rodyti kitą puslapį';
$string['search:activity'] = 'Dalyvavimas - veiklos informacija';
$string['selectactivity'] = 'Pasirinkti veiklą';
$string['session'] = 'Užsiėmimas';
$string['session_help'] = 'Užsiėmimas';
$string['sessionadded'] = 'Užsiėmimas sėkmingai įtrauktas';
$string['sessionalreadyexists'] = 'Užsiėmimas šia data jau yra';
$string['sessiondate'] = 'Data';
$string['sessiondays'] = 'Užsiėmimo dienos';
$string['sessiondeleted'] = 'Užsiėmimas sėkmingai pašalintas';
$string['sessiondescription'] = 'Sesijos aprašymas';
$string['sessionduplicate'] = 'Yra pasikartojanti sesija kursui: {$a->course}, dalyvaujantys: {$a->activity}, {$a->date}';
$string['sessionexist'] = 'Užsiėmimas neįtrauktas (jau yra)!';
$string['sessiongenerated'] = 'Sėkmingai sukurtas vienas užsiėmimas';
$string['sessions'] = 'Užsiėmimai';
$string['sessionsallcourses'] = 'Visi kursai';
$string['sessionsbyactivity'] = 'Dalyvavimo atvejis';
$string['sessionsbycourse'] = 'Kursas';
$string['sessionsbydate'] = 'Savaitė';
$string['sessionscompleted'] = 'Pateikti užsiėmimai';
$string['sessionscurrentcourses'] = 'Dabartiniai kursai';
$string['sessionsgenerated'] = '{$a} užsiėmimai sėkmingai sugeneruoti';
$string['sessionsids'] = 'Užsiėmimų ID:';
$string['sessionsnotfound'] = 'Pasirinktame laikotarpyje nėra užsiėmimų';
$string['sessionstartdate'] = 'Užsiėmimo pradžia';
$string['sessionstotal'] = 'Bendras užsiėmimų skaičius';
$string['sessionsupdated'] = 'Sesijos atnaujintos';
$string['sessiontype'] = 'Tipas';
$string['sessiontype_help'] = 'Galite pridėti užsiėmimus visiems besimokantiesiems ar besimokančiųjų grupei. Galimybė pridėti skirtingus tipus priklauso nuo veiklos grupės režimo.

* Grupės režime „Nėra grupių“ galite pridėti tik užsiėmimus visiems besimokantiesiems.
* Grupės režime „Atskiros grupės“ galite pridėti tik užsiėmimus besimokančiųjų grupėms.
* Grupės režime „Matomos grupės“ galite pridėti abiejų tipų užsiėmimus.';
$string['sessiontypeshort'] = 'Tipas';
$string['sessionunknowngroup'] = 'Užsiėmime nežinoma grupė(s): {$a}';
$string['sessionupdated'] = 'Užsiėmimas sėkmingai atnaujintas';
$string['set_by_student'] = 'Savarankiškai įsirašė';
$string['setallstatuses'] = 'Nustatyti būseną';
$string['setallstatusesto'] = 'Nustatyti būseną «{$a}»';
$string['settings'] = 'Nustatymai';
$string['setunmarked'] = 'Kai nėra pažymėta, nustatyti automatiškai';
$string['setunmarked_help'] = 'Jei įjungta, nustatoma ši būsena, jei besimokantysis nėra pažymėjęs savo dalyvavimo užsiėmime,';
$string['showdefaults'] = 'Rodyti numatytąsias parinktis';
$string['showduration'] = 'Rodyti trukmę';
$string['showextrauserdetails'] = 'Rodyti papildomus naudotojo duomenis';
$string['showqrcode'] = 'Rodyti QR kodą';
$string['showsessiondescriptiononreport'] = 'Rodyti užsiėmimo aprašymą ataskaitoje';
$string['showsessiondescriptiononreport_desc'] = 'Rodyti užsiėmimo aprašymą dalyvavimo ataskaitoje.';
$string['showsessiondetails'] = 'Rodyti užsiėmimo detales';
$string['somedisabledstatus'] = '(Kai kurios parinktys buvo pašalintos prasidėjus užsiėmimui.)';
$string['sortedgrid'] = 'Tinklelis';
$string['sortedlist'] = 'Sąrašas';
$string['startofperiod'] = 'Laikotarpio pradžia';
$string['starttime'] = 'Pradžios laikas';
$string['status'] = 'Būsena';
$string['statusall'] = 'visi';
$string['statusdeleted'] = 'Būsena panaikinta';
$string['statuses'] = 'Būsenos';
$string['statusset'] = 'Būsenų rinkinys {$a}';
$string['statussetsettings'] = 'Būsenų rinkinys';
$string['statusunselected'] = 'nepasirinkti';
$string['strftimedm'] = '%b %d d.';
$string['strftimedmw'] = '<nobr>%b %d d. %a</nobr>';
$string['strftimedmy'] = '%Y %b %d d.';
$string['strftimedmyhm'] = '%Y %b %d d. %H.%M';
$string['strftimedmyw'] = '<nobr>%Y %b %d d., %a</nobr>';
$string['strftimeh'] = '%H';
$string['strftimehm'] = '%H:%M';
$string['strftimeshortdate'] = '%Y%m.%d. d.';
$string['studentid'] = 'Besimokančiojo ID';
$string['studentmarked'] = 'Jūsų dalyvavimas šiame užsiėmime įrašytas.';
$string['studentmarking'] = 'Besimokančiųjų įrašymas';
$string['studentpassword'] = 'Besimokančiųjų slaptažodis';
$string['studentrecordingexpanded'] = 'Besimokančiųjų įrašymas išplėsta';
$string['studentrecordingexpanded_desc'] = 'Rodyti "Besimokančiųjų įrašymas" nustatymus, kurie išplečiami pagal numatytuosius nustatymus, kuriant naujus užsiėmimus.';
$string['studentscanmark'] = 'Leisti besimokantiesiems įrašyti savo dalyvavimą';
$string['studentscanmark_desc'] = 'Jei pažymėta, dėstytojai suteikia galimybę besimokantiesiems pažymėti savo dalyvavimą.';
$string['studentscanmark_help'] = 'Jei pažymėta, besimokantieji galės pakeisti savo dalyvavimo būseną užsiėmime.';
$string['studentscanmarksessiontime'] = 'Besimokantieji įsirašo dalyvavimą užsiėmimo metu';
$string['studentscanmarksessiontime_desc'] = 'Jei pažymėta, besimokantieji gali įrašyti savo dalyvavimą tik sesijos metu.';
$string['studentscanmarksessiontimeend'] = 'Užsiėmimo pabaiga (minutėmis)';
$string['studentscanmarksessiontimeend_desc'] = 'Nurodo kiek minučių užsiėmimas turėtų būti prieinamas besimokantiesiems lankomumo įsirašymui, jei užsiėmimas neturi pabaigos laiko.';
$string['studentsearlyopentime'] = 'Išankstinis lankomumo žymėjimo atidarymas';
$string['studentsearlyopentime_help'] = 'Taip dėstytojai gali pradėti užsiėmimą anksčiau, kad lankomumą būtų galima fiksuoti prieš prasidedant tikrajam užsiėmimo laikui.';
$string['submit'] = 'Pateikti';
$string['submitattendance'] = 'Pateikti dalyvavimą';
$string['submitpassword'] = 'Pateikti slaptažodį';
$string['subnet'] = 'Antrinis tinklas';
$string['subnetwrong'] = 'Dalyvavimas gali būti įrašomas tik iš tam tikrų vietų, o šis kompiuteris nėra leidžiamame sąraše.';
$string['summary'] = 'Santrauka';
$string['tablerenamefailed'] = 'Nepavyko pervardyti senos attforblock lentelės į dalyvavimą';
$string['tactions'] = 'Veiksmas';
$string['takeattendance'] = 'Pateikti dalyvavimą';
$string['takensessions'] = 'Pateikti užsiėmimai';
$string['tcreated'] = 'Sukurta';
$string['tempaddform'] = 'Įtraukti laikiną dalyvį';
$string['temptable'] = 'Laikinų dalyvių sąrašas';
$string['tempuser'] = 'Laikinas dalyvis';
$string['tempusers'] = 'Laikini dalyviai';
$string['tempusersedit'] = 'Redaguoti laikiną dalyvį';
$string['tempuserslist'] = 'Laikini dalyviai';
$string['thirdpartyemailsubject'] = 'Dalyvavimo įspėjimas';
$string['thiscourse'] = 'Pasirinktas kursas';
$string['time'] = 'Laikas';
$string['timeahead'] = 'Negalima sukurti daugkartinių užsiėmimų, viršijančių vienerius metus, patikslinkite pradžios ir pabaigos datas.';
$string['timemodified'] = 'Laikas, kada keista';
$string['to'] = 'iki:';
$string['tuseremail'] = 'El. paštas';
$string['tusername'] = 'Pilnas vardas';
$string['unknowngroup'] = 'Nežinoma grupė';
$string['unknownstatus'] = 'Nežinomas būsenos ID: {$a}';
$string['update'] = 'Atnaujinti';
$string['usedefaultsubnet'] = 'Naudoti numatytą';
$string['userexists'] = 'Šiuo el. pašto adresu jau yra naudotojas';
$string['userid'] = 'Naudotojo ID';
$string['userimportto'] = 'Moodle naudotojo laukas';
$string['userimportto_help'] = 'Moodle laukas, atitinkantis duomenis iš CSV eksporto';
$string['users'] = 'Eksportuojami naudotojai';
$string['usersessiongrade'] = 'Naudotojo seanso įvertinimas';
$string['userstatus'] = 'Naudotojo sesijos būsena';
$string['usestatusset'] = 'Būsenų rinkiniai';
$string['variable'] = 'kintamasis';
$string['variablesupdated'] = 'Kintamieji sėkmingai atnaujinti';
$string['versionforprinting'] = 'versija spausdinimui';
$string['viewmode'] = 'Peržiūros režimas';
$string['warnafter'] = 'Pateiktų užsiėmimų skaičius prieš įspėjimą';
$string['warnafter_help'] = 'Įspėjimai bus suaktyvinami tik tuo atveju, kai dalyvis lankys bent nurodytą skaičių užsiėmimų.';
$string['warningdeleted'] = 'Įspėjimas pašalintas';
$string['warningfailed'] = 'Negalite sukurti įspėjimo, kuris naudoja tą patį seansų procentą ir skaičių.';
$string['warningpercent'] = 'Įspėti, jei procentas nesiekia';
$string['warningpercent_help'] = 'Įspėjimas bus suaktyvintas, kai bendras procentas nukris žemiau šio skaičiaus.';
$string['warnings'] = 'Įspėjimų rinkinys';
$string['warningthreshold'] = 'Įspėjimo slenkstis';
$string['warningupdated'] = 'Įspėjimai atnaujinti';
$string['week'] = 'savaitę (-es)';
$string['weekcommencing'] = 'Savaitės pradžia';
$string['weeks'] = 'Savaitės';
$string['youcantdo'] = 'Jūs negalite nieko padaryti';
