<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'lt', version '4.5'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Veiksmai';
$string['activityoresourceis'] = 'Veikla arba išteklius: {$a}';
$string['addacondition'] = 'Pridėti sąlygą';
$string['addarule'] = 'Pridėti taisyklę';
$string['addinstructions'] = 'Pridėti daugiau informacijos';
$string['additionalresources'] = 'Papildomi ištekliai';
$string['addlevel'] = 'Pridėti lygį';
$string['addoninstallationerror'] = 'Aptikome problemą su papildiniu (local_xp), atrodo, kad jis nėra tinkamai įdiegtas. Administratorius turėtų užbaigti jo diegimą.';
$string['addonnotactivated'] = 'Priedas neaktyvuotas.';
$string['addrulesformhelp'] = 'Paskutiniame stulpelyje nurodomas patirties taškų kiekis, gautas įvykdžius kriterijus.';
$string['admindefaultrulesintro'] = 'Kursuose, į kuriuos įtraukiamas blokas, pagal numatytuosius nustatymus bus naudojamos šios taisyklės.';
$string['admindefaultsettingsintro'] = 'Toliau pateikti nustatymai bus naudojami kaip numatytoji reikšmė, kai blokas bus naujai įtrauktas į kursą.';
$string['admindefaultvisualsintro'] = 'Kai blokas naujai įtraukiamas į kursą, kaip numatytieji bus naudojami šie parametrai.';
$string['anonymity'] = 'Anonimiškumas';
$string['anonymity_help'] = 'Šis nustatymas leidžia reguliuoti, ar dalyviai gali matyti vienas kito vardą ir avatarą.';
$string['awardaxpwhen'] = '<strong>{$a}</strong> tšk. bus pridėta, kai:';
$string['basexp'] = 'Algoritminė bazė';
$string['blockappearance'] = 'Bloko išvaizda';
$string['blockappearancemovedtopluginsettings'] = 'Bloko išvaizdos nustatymai perkelti į įskiepio nustatymų puslapį.';
$string['cachedef_filters'] = 'Lygio filtrai';
$string['cachedef_ruleevent_eventslist'] = 'Kai kurių įvykių sąrašas';
$string['cannotshowblockconfig'] = 'Paprastai čia rodyčiau išvaizdos nustatymus, tačiau neradau jūsų bloko. Jei norite pakeisti bloko išvaizdą, grįžkite atgal [here]({$a}) (arba ten, kur pridėjote bloką), įjunkite redagavimo režimą ir bloko išskleidžiamajame lange pasirinkite "Konfigūruoti". Jei bloko nerandate, pridėkite jį į kursą dar kartą.';
$string['cannotshowblockconfigsys'] = 'Paprastai čia rodyčiau išvaizdos nustatymus, tačiau neradau jūsų bloko. Gali būti, kad jo nėra jūsų naudotojų [front page]({$a->fp}) ir [default dashboard]({$a->mysys}) arba jis yra abiejuose. Norėdami redaguoti nustatymus iš čia, įsitikinkite, kad jis rodomas tik viename iš jų.';
$string['changelevelformhelp'] = 'Jei pakeisite lygių skaičių, pasirinktiniai lygių ženkliukai bus laikinai išjungti, kad būtų išvengta lygių be ženkliukų. Jei pakeisite lygių skaičių, eikite į puslapį \'Visuals\', kad išsaugoję šią formą vėl įjungtumėte pasirinktinius ženkliukus.';
$string['cheatguard'] = 'Apsauga nuo apgaudinėjimo';
$string['clicktoselectcm'] = 'Spustelkite norėdami pasirinkti veiklą arba resursą';
$string['cmselector'] = 'Kurso modulio parinkiklis';
$string['coefxp'] = 'Algoritmo koeficientas';
$string['colon'] = '{$a->a}: {$a->b}';
$string['configblockrankingsnapshot'] = 'Rodyti lyderių lentelės iškarpą';
$string['configblockrankingsnapshot_help'] = 'Lyderių iškarpa vaizduoja naudotojo rangą. Taip pat bus bandoma parodyti du naudotoją supančius žmones. Šiai funkcijai įjungti reikia, kad būtų įjungta lyderių lenta ir rodomi jos reitingai.';
$string['configdescription'] = 'Įvadas';
$string['configdescription_help'] = 'Trumpas įvadas rodomas bloke, žemiau studento lygio. Besimokantieji turi galimybę atmesti pranešimą - tokiu atveju jie jo daugiau nematys.';
$string['configheader'] = 'Nustatymai';
$string['configrecentactivity'] = 'Rodyti naujus apdovanojimus';
$string['configrecentactivity_help'] = 'Kai ši funkcija įjungta, bloke bus rodomas trumpas neseniai įvykusių įvykių, už kuriuos mokinys gavo taškų, sąrašas.';
$string['configtitle'] = 'Pavadinimas';
$string['configtitle_help'] = 'Bloko pavadinimas.';
$string['congratulationsyouleveledup'] = 'Sveikinimai!';
$string['coolthanks'] = 'Šaunu, ačiū!';
$string['courselog'] = 'Kurso žurnalas';
$string['coursereport'] = 'Kurso ataskaita';
$string['courserules'] = 'Kurso taisyklės';
$string['courseselectedcolon'] = 'Pasirinktas kursas:';
$string['coursesettings'] = 'Kurso nustatymai';
$string['coursevisuals'] = 'Kurso vizualai';
$string['customizelevels'] = 'Derinti lygius';
$string['dangerzone'] = 'Pavojaus zona';
$string['defaultlevels'] = 'Numatyti lygiai';
$string['defaultrules'] = 'Numatytos taisyklės';
$string['defaultrulesformhelp'] = 'Tai yra įskiepio numatytos numatytos taisyklės, kurios automatiškai suteikia numatytuosius taškus ir ignoruoja kai kuriuos nereikalingus įvykius. Jūsų pačių taisyklės yra viršesnės už jas.';
$string['defaultsettings'] = 'Numatyti nustatymai';
$string['defaultvisuals'] = 'Numatyti vizualai';
$string['deletecondition'] = 'Naikinimo sąlyga';
$string['deleterule'] = 'Naikinimo taisyklė';
$string['description'] = 'Aprašymas';
$string['difference'] = 'Skirtumas';
$string['discoverlevelupplus'] = 'Atrask Level Up XP+';
$string['dismissnotice'] = 'Atmesti žinutę';
$string['displayeveryone'] = 'Rodyti visus';
$string['displaynneighbours'] = 'Rodyti {$a} kaimynus';
$string['displayoneneigbour'] = 'Rodyti vieną kaimyną';
$string['displayparticipantsidentity'] = 'Rodyti dalyvių tapatybę';
$string['displayrank'] = 'Rodyti reitingą';
$string['displayrelativerank'] = 'Rodyti releatyvų reitingą';
$string['documentation'] = 'Dokumentacija';
$string['editinstructions'] = 'Redaguoti informaciją';
$string['enablecheatguard'] = 'Leisti apsaugą nuo apgaulės';
$string['enablecheatguard_help'] = 'Apgaudinėjimo apsauga - tai paprastas mechanizmas, neleidžiantis mokiniams piktnaudžiauti sistema naudojant akivaizdžius apgaulės metodus, pavyzdžiui, be galo atnaujinti tą patį puslapį arba vis kartoti tą patį veiksmą.

[Daugiau informacijos](https://docs.levelup.plus/xp/docs/getting-started/cheat-guard?ref=blockxp_help)';
$string['enableinfos'] = 'Įjungti informacijos puslapį';
$string['enableinfos_help'] = 'Nustačius \'Ne\' (No), besimokantieji negalės peržiūrėti informacinio puslapio.';
$string['enableladder'] = 'Įjungti reitingavimą';
$string['enableladder_help'] = 'Nustačius \'Ne\' (No), besimokantieji negalės peržiūrėti reitingų.';
$string['enablelevelupnotif'] = 'Leisti papildinio žinutes';
$string['enablelevelupnotif_help'] = 'Nustačius \\"Taip\\" (Yes), mokiniams bus rodomas langas, kuriame jie bus pasveikinti su pasiektu nauju lygiu.';
$string['enablelogging'] = 'Įjungti registravimą';
$string['enablexpgain'] = 'Įgalinti taškų prieaugį';
$string['enablexpgain_help'] = 'Kai nustatyta reikšmė \'Ne\' (No), niekas negaus taškų kurse. Tai naudinga norint įšaldyti surinktus taškus arba įjungti juos tam tikru metu.

Atkreipkite dėmesį, kad tai galima kontroliuoti detaliau naudojant funkciją _block/xp:earnxp_.';
$string['entersearchterm'] = 'Įveskite paieškos žodį';
$string['errorcontextcoursemismatchforwholesite'] = 'Šio puslapio <em>Level Up XP</em> URL neatitinka dabartinės įskiepio konfigūracijos. Dabartinėje konfigūracijoje nurodyta, kad <em>Level Up XP</em> turi būti naudojamas \\"Visai svetainei\\", tačiau šiame puslapyje tikimasi, kad jis bus naudojamas \\"Vienam kursui\\". Prašome <a href="{$a->nexturl}">paspausti čia</a> , kad pereitumėte į reikiamą puslapį. Jei norite pakeisti konfigūraciją, ieškokite administratoriaus nustatymo \'block_xp_context\'.';
$string['errorcontextcoursemismatchpercourse'] = 'Šio puslapio <em>Level Up XP</em> URL neatitinka dabartinės įskiepio konfigūracijos. Dabartinėje konfigūracijoje nurodyta, kad <em>Level Up XP</em> turi būti naudojamas \\"Viename kurse\\", tačiau šiame puslapyje tikimasi, kad jis bus naudojamas \\"Visai svetainei\\". Greičiausiai tai atsirado dėl <em>bloko</em>, kuris buvo pridėtas į prietaisų skydelį arba pagrindinį puslapį, kai buvo kita konfigūracija. Turėtumėte pašalinti bloką iš pastarųjų puslapių ir naudoti bloką tik atskiruose kursuose.';
$string['errorformvalues'] = 'Formos reikšmėse yra problemų, prašome jas ištaisyti.';
$string['errorlevelsincorrect'] = 'Mažiausias lygių skaičius - 2';
$string['errornotalllevelsbadgesprovided'] = 'Pateikti ne visi lygio ženkliukai. Trūksta: {$a}';
$string['errorunknownevent'] = 'Klaida: nežinomas įvykis';
$string['errorunknownmodule'] = 'Klaida: nežinomas modulis';
$string['errorxprequiredlowerthanpreviouslevel'] = 'Reikalaujami taškai yra mažesni arba lygūs ankstesniam lygiui.';
$string['event_user_leveledup'] = 'Naudotojas pakėlė lygį';
$string['eventis'] = 'Įvykis yra: {$a}';
$string['eventname'] = 'Įvykio pavadinimas';
$string['eventproperty'] = 'Įvykio savybė';
$string['eventsrules'] = 'Įvykių taisyklės';
$string['eventsrules_help'] = 'Šis įskiepis naudoja įvykius, kad mokinių atliekamiems veiksmams priskirtų taškus.
Naudodamiesi toliau pateikta forma galite pridėti savo taisykles ir keisti numatytąsias.

Patariama patikrinti įskiepio _Log_ puslapį, kad nustatytumėte, kokie įvykiai suveikia mokiniams atliekant veiksmus kurse.

Papildomi ištekliai:

- [How are experience points calculated?](https://docs.levelup.plus/xp/docs/getting-started/points-calculation?ref=blockxp_help)
- [Troubleshooting rules](https://docs.levelup.plus/xp/docs/troubleshooting/event-rule-not-working?ref=blockxp_help)';
$string['eventtime'] = 'Įvykio laikas';
$string['filterbyuser'] = 'Filtravimas pagal naudotoją';
$string['filtermodules'] = 'Filtruoti modulius';
$string['for1day'] = '1 dienai';
$string['for1month'] = 'Mėnesiui';
$string['for1week'] = 'Savaitei';
$string['for3days'] = '3 dienoms';
$string['forever'] = 'Visam laikui';
$string['forthewholesite'] = 'Visam tinklalapiui';
$string['give'] = 'duoti';
$string['gotofullladder'] = 'Eiti į pilną reitingą';
$string['grid'] = 'Tinklelis';
$string['hasnodescription'] = 'Nėra aprašymo';
$string['hasnoname'] = 'Nėra pavadinimo';
$string['hasnopopupmessage'] = 'Nėra iššokančio pranešimo';
$string['hideparticipantsidentity'] = 'Slėpti dalyvių identitetą';
$string['hiderank'] = 'Slėpti reitingą';
$string['incourses'] = 'Kursuose';
$string['ineffective'] = 'Neefektyvu';
$string['infos'] = 'Informacija';
$string['installed'] = 'Įdiegta';
$string['instructions'] = 'Daugiau informacijos';
$string['invalidxp'] = 'Neteisinga taškų reikšmė';
$string['keeplogs'] = 'Saugoti žurnalus';
$string['ladder'] = 'Garbės lenta';
$string['ladderadditionalcols'] = 'Papildomi stulpeliai';
$string['ladderadditionalcols_help'] = 'Šis nustatymas reguliuoja, kurie papildomi stulpeliai bus rodomi reitinge. Norėdami pasirinkti daugiau nei vieną stulpelį arba atmesti pasirinktą stulpelį, paspauskite CTRL arba CMD klavišą.';
$string['ladderempty'] = 'Reitingas šiuo metu tuščias, sugrįškite vėliau!';
$string['learnmore'] = 'Sužinok daugiau';
$string['level'] = 'Lygis';
$string['levelbadges'] = 'Lygių ženkliukai';
$string['levelbadgesformhelp'] = 'Failų vardai [level].[file extension], pavyzdžiui: 1.png, 2.jpg, etc... Rekomenduojamas paveiksliuko dydis yra 100x100.';
$string['levelcount'] = 'Lygių kiekis';
$string['leveldesc'] = 'Lygio aprašymas';
$string['leveldesc_help'] = 'Trumpas lygio aprašymas, kuris rodomas informaciniame puslapyje šalia paties lygio. Jį galite naudoti norėdami aprašyti apdovanojimą mokiniams, pasiekusiems šį lygį, pateikti instrukcijas, kaip siekti šio lygio, apibūdinti lygį žaismingai (pvz., _Tik drąsiausios sielos yra pasiekusios šį lygį_) ir pan.';
$string['levelname'] = 'Lygio pavadinimas';
$string['levelname_help'] = 'Trumpas pavadinimas, rodomas vietoj numatytųjų _Lygis #1_, _Lygis #2_ ir t. t. Jei kai kuriems lygiams suteikiate pavadinimus, rekomenduojame juos visus pavadinti!';
$string['levels'] = 'Lygiai';
$string['levelswillbereset'] = 'Įspėjimas! Išsaugojus šią formą bus perskaičiuoti visų lygiai!';
$string['levelup'] = 'Pasikelk lygį!';
$string['levelupplus'] = 'Level up! XP+';
$string['levelx'] = 'Lygis #{$a}';
$string['likenotice'] = '<strong>Ar jums patinka šis įskiepis?</strong> Prašome skirti šiek tiek laiko ir <a href="{$a->moodleorg}" target="_blank">priskirti jį prie mėgstamiausių</a> Moodle.org svetainėje ir <a href="{$a->github}" target="_blank">pažymėti jį GitHub</a>.';
$string['limitparticipants'] = 'Riboti dalyvius';
$string['limitparticipants_help'] = 'Šiuo nustatymu valdoma, kas bus rodoma lyderių lentelėje. Kaimynai - tai dalyviai, esantys aukščiau ir žemiau dabartinio naudotojo. Pavyzdžiui, pasirinkus "Rodyti 2 kaimynus", bus rodomi tik du dalyviai, esantys aukščiau ir žemiau už dabartinį naudotoją.';
$string['list'] = 'Sąrašas';
$string['logging'] = 'Registravimas';
$string['manually'] = 'Rankiniu būdu';
$string['maxactionspertime'] = 'Daugiausiai veiksmų laiko intervale';
$string['maxactionspertime_help'] = 'Didžiausias veiksmų, už kuriuos bus skaičiuojami taškai per nurodytą laikotarpį, skaičius. Bet koks vėlesnis veiksmas bus ignoruojamas. Kai ši reikšmė yra tuščia arba lygi nuliui, ji netaikoma.';
$string['maxlevelexcl'] = 'Didžiausias lygis!';
$string['menu'] = 'Meniu';
$string['missing'] = 'Trūksta';
$string['movecondition'] = 'Perkėlimo sąlyga';
$string['moverule'] = 'Perkėlimo taisyklė';
$string['name'] = 'Pavadinimas';
$string['naveventrules'] = 'Įvykio taisyklės';
$string['navgraderules'] = 'Įvertinimo taisyklės';
$string['navimport'] = 'Importuoti';
$string['navinfos'] = 'Info';
$string['navladder'] = 'Reitingas';
$string['navlevels'] = 'Lygiai';
$string['navlevelssetup'] = 'Nustatymai';
$string['navlog'] = 'Žurnalas';
$string['navpoints'] = 'Taškai';
$string['navpromo'] = 'XP+';
$string['navreport'] = 'Ataskaita';
$string['navrules'] = 'Taisyklės';
$string['navsettings'] = 'Nustatymai';
$string['navvisuals'] = 'Vizualai';
$string['nextlevelin'] = 'kitas lygis ties';
$string['nodescription'] = 'Nėra aprašymo';
$string['nologsrecordedyet'] = 'Žurnalai dar nebuvo įrašyti.';
$string['noname'] = 'Nėra pavadinimo';
$string['notesomesettingslocked'] = 'Atkreipkite dėmesį, kad kai kurių nustatymų gali būti neįmanoma redaguoti, jei juos užrakino administratorius.';
$string['numberoflevels'] = 'Lygių skaičius';
$string['occasionally'] = 'Kartais';
$string['participant'] = 'Dalyvis';
$string['participants'] = 'Dalyviai';
$string['participatetolevelup'] = 'Dalyvaukite kurse, kad gautumėte patirties taškų ir pakeltumėte lygį!';
$string['perpagecolon'] = 'Puslapyje:';
$string['pickaconditiontype'] = 'Pasirinkite sąlygos tipą';
$string['pluginavailabilityxpdesc'] = 'Šis įskiepis leidžia instruktoriams apriboti prieigą prie veiklos pagal mokinių lygius.';
$string['pluginenrolxpdesc'] = 'Šis įskiepis leidžia automatiškai užsiregistruoti į kursus pagal studento lygį kitame kurse.';
$string['pluginname'] = 'Level up!';
$string['pluginshortcodesdesc'] = 'Šis įskiepis leidžia dėstytojams pritaikyti savo medžiagą įtraukiant į turinį su XP susijusius elementus (taškus, lygį, lentelę, ...), taip pat paslėpti arba rodyti turinį atsižvelgiant į studento lygį.';
$string['pluginsoutofsync'] = '__The plugins are out of sync!__

Tai reiškia, kad atnaujinote _Level Up XP_, bet ne _Level Up XP+_. Nors stengiamės išvengti bet kokių problemų, kai kurios funkcijos, įskaitant pačią programą _Level Up XP_, gali nebeveikti tinkamai. Rekomenduojame atnaujinti _Level Up XP+_ į naujausią jos versiją. [Read more]({$a->url})';
$string['pointsintimelinker'] = 'per';
$string['pointsrequired'] = 'Reikia taškų';
$string['privacy:metadata:log'] = 'Išsaugo įvykių žurnalą';
$string['privacy:metadata:log:eventname'] = 'Įvykio pavadinimas';
$string['privacy:metadata:log:time'] = 'Data, kada tai įvyko';
$string['privacy:metadata:log:userid'] = 'Taškus surinkęs naudotojas';
$string['privacy:metadata:log:xp'] = 'Už įvykį skiriami taškai';
$string['privacy:metadata:prefintro'] = 'Įrašoma, ar naudotojas atmetė bloko įžangą';
$string['privacy:metadata:prefladderpagesize'] = 'Naudotojo pageidaujamas puslapio dydis peržiūrint lyderių lentelę';
$string['privacy:metadata:preflevelup'] = 'Įrašoma, ar naudotojas turi matyti pranešimą apie lygio pakėlimą';
$string['privacy:metadata:prefnotices'] = 'Įrašoma, ar naudotojas uždarė paramos pranešimą';
$string['privacy:metadata:prefseenpromo'] = 'Įrašoma, kada naudotojas peržiūrėjo reklaminį puslapį';
$string['privacy:metadata:xp'] = 'Saugo naudotojų taškus ir lygį';
$string['privacy:metadata:xp:lvl'] = 'Naudotojo lygis';
$string['privacy:metadata:xp:userid'] = 'Naudotojas';
$string['privacy:metadata:xp:xp'] = 'Naudotojo taškai';
$string['privacy:path:addon'] = 'Priedėlis';
$string['privacy:path:level'] = 'Lygis';
$string['privacy:path:logs'] = 'Žurnalai';
$string['progress'] = 'Progresas';
$string['progressbar'] = 'Progreso juosta';
$string['promocheatguard'] = 'Ši apsauga nėra skirta ilgiems laikotarpiams. Apsvarstykite galimybę atnaujinti <em>Level Up XP+</em>, kad atrakintumėte didesnius laiko intervalus ir kitas funkcijas. <a href="{$a->url}">Skaitykite daugiau čia</a>.';
$string['promocontactintro'] = 'Susisiekite su mumis ir gaukite daugiau informacijos. Mes nesikandžiojame ir atsakome greitai!';
$string['promocontactus'] = 'Susisiekite su mumis';
$string['promoemailusat'] = 'Rašykite mums el. paštu _levelup@branchup.tech_.';
$string['promoerrorsendingemail'] = 'O! Mums nepavyko išsiųsti žinutės... prašome rašyti mums tiesiogiai el. paštu: {$a}. Dėkojame!';
$string['promoifpreferemailusat'] = 'Psst! Jei pageidaujate, rašykite mums tiesiogiai el. paštu _{$a}_.';
$string['promointro'] = '_Level up!_ priedėlis, kuris atveria visą potencialą!';
$string['promointroinstalled'] = 'Jūsų sistemoje įdiegtas priedas _Level Up XP+_ ir įjungtos visos jo funkcijos.';
$string['promorulesdidyouknow'] = 'Ar žinojote, kad naudodamiesi <em>Level Up XP+</em> mokiniai gali gauti taškų už <em>užbaigtus kursus</em> ir <em>veiklas</em> arba net gauti taškų pagal <em>įvertinimus</em>? <a href="{$a->url}">Sužinokite daugiau čia</a>.';
$string['promoyourmessagewassent'] = 'Dėkojame, jūsų žinutė išsiųsta. Netrukus su jumis susisieksime.';
$string['property:action'] = 'Įvykio veiksmas';
$string['property:component'] = 'Įvykio komponentas';
$string['property:crud'] = 'Įvykio CRUD';
$string['property:eventname'] = 'Įvykio pavadinimas';
$string['property:target'] = 'Įvykio taikinys';
$string['rank'] = 'Rangas';
$string['ranking'] = 'Reitingas';
$string['ranking_help'] = 'Rangas - tai absoliuti dabartinio naudotojo pozicija reitinge. Santykinis rangas - tai patirties taškų skirtumas tarp naudotojo ir jo kaimynų.';
$string['reallydeleteuserstate'] = 'Naudotojo pašalinimas naudingas tik norint pašalinti jį iš lyderių lentelės. Dėl kitų priežasčių rekomenduojame nustatyti 0 taškų. Atkreipkite dėmesį, kad ištrynimas neturi įtakos jo galimybei ateityje rinkti taškus.

Svarbu tai, kad naudojant _Level Up XP_ visai svetainei, juos ištrynus, jie išnyks iš ataskaitos, ir tokiu atveju negalėsite iš naujo priskirti jiems taškų. Tačiau, jei naudojate _Level Up XP_ kiekvienam kursui, mokinys vis tiek gali būti rodomas ataskaitoje, jei jis yra įrašytas į kursą.

Ar tikrai norite ištrinti šio naudotojo taškus?';
$string['reallydeleteuserstateandlogs'] = 'Ištrynus naudotoją, jis pašalinamas iš lyderių lentelės ir pašalinami visi su juo susiję žurnalai.

Pašalinus žurnalus naudotojas gali iš naujo gauti taškų už ankstesnius veiksmus. Jei ketinate tik iš naujo nustatyti jo taškus, rekomenduojame vietoj to nustatyti 0 taškų. Atkreipkite dėmesį, kad naudotojo pašalinimas neturi įtakos jo galimybei ateityje pelnyti taškų.

Svarbu tai, kad naudojant _Level Up XP_ visai svetainei, ištrynus naudotoją, jis išnyks iš ataskaitos, ir tokiu atveju negalėsite iš naujo priskirti jam taškų. Tačiau, jei naudojate _Level Up XP_ kiekvienam kursui, mokinys vis tiek gali būti rodomas ataskaitoje, jei jis yra užsirašęs į kursą.

Ar tikrai norite ištrinti šio naudotojo taškus ir žurnalus?';
$string['reallyresetallcoursestodefaults'] = 'Ar tikrai nustatyti visų kursų taisykles į numatytąsias? Šis veiksmas nėra atšaukiamas.';
$string['reallyresetcourserulestodefaults'] = 'Ar tikrai nustatyti numatytąsias kurso taisykles? Šis veiksmas negrįžtamas.';
$string['reallyresetdata'] = 'Ar tikrai nunulinti visų šio kurso dalyvių lygius ir taškus?';
$string['reallyresetgroupdata'] = 'Ar tikrai nunulinti visų šios grupės narių lygius ir taškus?';
$string['reallyreverttopluginsdefaults'] = 'Ar tikrai iš naujo nustatyti numatytąsias taisykles į įskiepio siūlomas? Šis veiksmas negrįžtamas.';
$string['recentrewards'] = 'Nauji apdovanojimai';
$string['recommendedplugins'] = 'Rekomenduojami papildiniai';
$string['releasenotes'] = 'Išleidimo pastabos';
$string['remaining'] = 'liko';
$string['removefilter'] = 'Pašalinti filtrą';
$string['reportisempty'] = 'Ataskaita tuščia, besimokantysis dar turi surinkti taškų.';
$string['reportisemptyenrolstudents'] = 'Ataskaita tuščia, ar besimokantieji buvo įtraukti į šį kursą?';
$string['requires'] = 'Reikalauja';
$string['resetallcoursestodefaults'] = 'Visų kursų numatytųjų nustatymų atkūrimas';
$string['resetallcoursestodefaultsintro'] = 'Paspauskite toliau esantį mygtuką, kad iš naujo nustatytumėte visų kursų numatytąsias reikšmes.';
$string['resetcoursedata'] = 'Išvalyti kurso duomenis';
$string['resetcourserulestodefaults'] = 'Kurso taisyklių numatytųjų nustatymų atkūrimas';
$string['resetgroupdata'] = 'Išvalyti grupės duomenis';
$string['resultsfilteredforn'] = 'Results filtered for {$a}.';
$string['reverttopluginsdefaults'] = 'Grįžti prie numatytųjų įskiepio nustatymų';
$string['reverttopluginsdefaultsintro'] = 'Jei norite grąžinti numatytąsias įskiepio nuostatas, naudokite toliau esantį mygtuką.';
$string['reward'] = 'Apdovanojimas';
$string['rule'] = 'Taisyklė';
$string['rule:contains'] = 'įtraukia';
$string['rule:eq'] = 'lygus(i)';
$string['rule:eqs'] = 'tiksliai lygus(i)';
$string['rule:gt'] = 'yra daugiau nei';
$string['rule:gte'] = 'yra daugiau arba lygu nei';
$string['rule:lt'] = 'yra mažiau nei';
$string['rule:lte'] = 'yra mažiau arba lygu nei';
$string['rule:regex'] = 'atitinka regex';
$string['rulecm'] = 'Veikla arba išteklius';
$string['rulecm_help'] = 'Ši sąlyga įvykdoma, kai įvykis įvyksta nurodytoje veikloje arba ištekliuje.';
$string['rulecmdesc'] = 'Veikla arba išteklius yra \'{$a->contextname}\'.';
$string['rulecmdescwithcourse'] = 'Veikla arba išteklius yra: \'{$a->contextname}\', \'{$a->coursename}\'.';
$string['rulecminfo'] = 'Pagal šią sąlygą reikalaujama, kad veiksmas būtų atliekamas konkrečioje veikloje arba resurse.';
$string['ruleevent'] = 'Tam tikras įvykis';
$string['ruleeventdesc'] = 'Įvykis yra \'{$a->eventname}\'';
$string['ruleeventinfo'] = 'Pasirinkite veiksmą, kurį naudotojai turi atlikti, iš pasirinkto įvykių sąrašo.';
$string['ruleproperty'] = 'Įvykio savybė';
$string['rulepropertydesc'] = 'Savybė \'{$a->property}\' {$a->compare} \'{$a->value}\'.';
$string['rulepropertyinfo'] = 'Ši sąlyga skirta patyrusiems naudotojams, turintiems techninį supratimą apie įvykius ir jų savybes.';
$string['ruleset'] = 'Sąlygų rinkinys';
$string['ruleset:all'] = 'VISOS sąlygos yra teisingos';
$string['ruleset:any'] = 'BET KURI iš šių sąlygų yra teisinga';
$string['ruleset:none'] = 'NĖ VIENA iš sąlygų nėra teisinga';
$string['rulesetinfo'] = 'Sujungti kelias sąlygas į vieną.';
$string['rulesformhelp'] = '<p>Šis įskiepis naudoja įvykius, kad mokinių atliekamiems veiksmams priskirtų taškus. Naudodamiesi toliau pateikta forma galite pridėti savo taisykles ir peržiūrėti numatytąsias.</p>
<p>Patariama patikrinti įskiepio <a href="{$a->log}">žurnalą</a>, kad nustatytumėte, kokie įvykiai suveikia, kai atliekate veiksmus kurse. Skaitykite daugiau informacijos apie įvykius: <a href="{$a->list}">visų įvykių sąrašas</a>, <a href="{$a->doc}">kūrėjo dokumentacija</a>.</p>
<p>Galiausiai atkreipkite dėmesį, kad įskiepis visada ignoruoja:
<ul>
    <li>Administratorių, svečių arba neprisijungusių naudotojų atliekamus veiksmus.</li>
    <li>Naudotojų, neturinčių įgaliojimų, atliekami veiksmai <em>block/xp:earnxp</em>.</li>
    <li>Pasikartojantys veiksmai per trumpą laiko tarpą, kad būtų išvengta sukčiavimo.</li>
    <li>Įvykiai, pažymėti kaip <em>anoniminiai</em>, pvz., anoniminiai Atsiliepimai.</li>
    <li>Ir įvykiai, kurių mokymosi lygis nėra lygus <em>Dalyvaujantys</em>.</li>
</ul>
</p>';
$string['searchandselectcourse'] = 'Ieškokite ir pasirinkite kursą';
$string['searchandselectmodule'] = 'Ieškokite ir pasirinkite veiklą arba resursą';
$string['send'] = 'Siųsti';
$string['setpoints'] = 'Nustatyti taškus';
$string['shortcode:xpbadge'] = 'Ženkliukas, atitinkantis dabartinio naudotojo lygį.';
$string['shortcode:xpiflevel'] = 'Rodyti turinį, kai dabartinio naudotojo lygis sutampa.';
$string['shortcode:xpiflevel_help'] = 'Norėdami suformatuoti šį trumpąjį kodą, žr. toliau pateiktus pavyzdžius. Kai griežtai nurodytas lygis, turinys bus rodomas neatsižvelgiant į kitas taisykles.
Kad turinys būtų rodomas, turi sutapti visos _greater_ ir _less than_ lygio taisyklės. Būkite atsargūs, nes kartais dėl to turinys gali būti niekada nerodomas!
Atkreipkite dėmesį, kad mokytojai arba kiti naudotojai, turintys redagavimo galimybes, visada matys viską.

```
[xpiflevel 1 3 5]
    Rodoma, jei naudotojo lygis yra lygiai 1, 3 arba 5.
[/xpiflevel]

[xpiflevel >3]
    Rodoma, jei naudotojo lygis yra didesnis nei 3.
[/xpiflevel]

[xpiflevel >=3]
    Rodoma, jei naudotojo lygis yra didesnis arba lygus 3.
[/xpiflevel]

[xpiflevel >=10 <20 30]
    Rodoma, jei naudotojo lygis yra didesnis arba lygus 10 IR yra griežtai mažesnis nei 20.
    ARBA yra lygiai lygus 30.
[/xpiflevel]

[xpiflevel <=10 >=20]
    Niekada nerodoma, nes naudotojo lygis niekada negali būti mažesnis arba lygus 10 IR didesnis arba lygus 20.
[/xpiflevel]
```

Atkreipkite dėmesį, kad šie trumpieji kodai NEGALI būti įterpti vienas į kitą.';
$string['shortcode:xpladder'] = 'Rodoma kopėčių dalis apie dabartinio naudotojo rangą.';
$string['shortcode:xpladder_help'] = 'Pagal numatytuosius nustatymus bus rodoma dalis lyderių lentelės, kurioje yra dabartinis naudotojas.

```
[xpladder]
```

Jei norite, kad vietoj dabartinio naudotojo kaimynų būtų rodomi 10 geriausių mokinių, nustatykite parametrą `top`. Pasirinktinai galite nustatyti rodomų naudotojų skaičių, pavyzdžiui, taip `top=20`.

```
[xpladder top]
[xpladder top=15]
```

Po lentele automatiškai bus rodoma nuoroda į visą lyderių lentelę, jei tokios nuorodos rodyti nenorite, pridėkite argumentą `hidelink`.

```
[xpladder hidelink]
```

Pagal numatytuosius nustatymus lentelėje nėra pažangos stulpelio, kuriame rodoma pažangos juosta. Jei toks stulpelis buvo pasirinktas papildomų stulpelių nustatymuose, galite naudoti argumentą `withprogress`, kad jis būtų rodomas.

```
[xpladder withprogress]
```

Atkreipkite dėmesį, kad kai kurse naudojamos grupės, lyderių lenta geriausiai atspės, kurios grupės lyderių lentelę rodyti.';
$string['shortcode:xplevelname'] = 'Rodyti lygio pavadinimą.';
$string['shortcode:xplevelname_help'] = 'Pagal numatytuosius nustatymus žyma rodo dabartinio naudotojo lygio pavadinimą.
Alternatyviai galite naudoti argumentą `lygis`, kad būtų rodomas konkretaus lygio pavadinimas.

```
[xplevelname]
[xplevelname level=5]
```

Jei pateikiamas argumentas `level`, o lygis neegzistuoja, nieko nebus rodoma.';
$string['shortcode:xppoints'] = 'Rodyti taškų skaičių, suformatuotą kaip patirties taškus.';
$string['shortcode:xpprogressbar'] = 'Dabartinio naudotojo progresas siekiant kito lygio.';
$string['somefeaturesrequireotherplugins'] = 'Kai kurioms funkcijoms reikia įdiegti papildomų įskiepių.';
$string['someoneelse'] = 'Kažkas kitas';
$string['somethinghappened'] = 'Kažkas atsitiko';
$string['taskcollectionloggerpurge'] = 'Išvalyti žurnalus';
$string['taskusagereport'] = 'Naudojimo ataskaita';
$string['thankyou'] = 'Ačiū!';
$string['timebetweensameactions'] = 'Laikas, reikalingas tarp vienodų veiksmų';
$string['timebetweensameactions_help'] = 'Minimalus laikas, kurio reikia, kad anksčiau jau atliktas veiksmas būtų priimtas dar kartą. Veiksmas laikomas tapačiu, jei jis buvo atliktas tame pačiame kontekste ir objekte; forumo įrašo skaitymas bus laikomas tapačiu, jei tas pats įrašas bus perskaitytas dar kartą. Kai ši reikšmė yra tuščia arba lygi nuliui, ji netaikoma.';
$string['timeformaxactions'] = 'Maksimalus veiksmų laikotarpis';
$string['timeformaxactions_help'] = 'Laikotarpis (sekundėmis), per kurį naudotojas neturėtų viršyti maksimalaus veiksmų skaičiaus.';
$string['tinytimedays'] = '{$a}d';
$string['tinytimehours'] = '{$a}h';
$string['tinytimeminutes'] = '{$a}m';
$string['tinytimenow'] = 'dabar';
$string['tinytimeolderyearformat'] = '%b %Y';
$string['tinytimeseconds'] = '{$a}s';
$string['tinytimeweeks'] = '{$a}w';
$string['tinytimewithinayearformat'] = '%b %e';
$string['total'] = 'Viso';
$string['unknowneventa'] = 'Nežinomas įvykis ({$a})';
$string['updateandpreview'] = 'Atnaujinti ir peržiūrėti';
$string['upgradingplugins'] = 'Įskiepių atnaujinimas';
$string['urlaccessdeprecated'] = 'Prieiga per šį URL adresą yra panaikinta, todėl atnaujinkite nuorodas.';
$string['usagereport'] = 'Bendrinti naudojimo ataskaitą';
$string['usagereport_desc'] = 'Periodiškai dalytis anonimine naudojimo informacija su įskiepių kūrėjais. Ši informacija padės geriau suprasti, kaip naudojamas įskiepis, ir turės įtakos jo tobulinimui. Dalijamoje informacijoje pateikiama pagrindinė informacija apie "Moodle" svetainę (URL, versija) ir informacija apie įskiepio naudojimą (naudotojų, gaunančių taškus, skaičius, nustatymų apžvalga, naudojamos taisyklės...).';
$string['usealgo'] = 'Naudokite algoritmą';
$string['usecustomlevelbadges'] = 'Naudokite pasirinktinius lygio ženkliukus';
$string['usecustomlevelbadges_help'] = 'Kai nustatyta taip, turite pateikti kiekvieno lygio paveikslėlį.';
$string['usingalgo'] = 'Algoritmo naudojimas';
$string['value'] = 'Reikšmė';
$string['valuessaved'] = 'Reikšmės sėkmingai išsaugotos.';
$string['viewas'] = 'Rodyti kaip';
$string['viewlogs'] = 'Rodyti žurnalus';
$string['viewtheladder'] = 'Peržiūrėti reitingą';
$string['visualsintro'] = 'Įkelkite paveikslėlius, kad pritaikytumėte lygių išvaizdą.';
$string['wewillreplyat'] = 'Atsakysime adresu: _{$a}_.';
$string['when'] = 'Kai';
$string['wherearexpused'] = 'Kur naudojami taškai?';
$string['wherearexpused_desc'] = 'Kai nustatyta reikšmė \'Kursuose\', taškai bus skaičiuojami tik už tą kursą, į kurį buvo įtrauktas blokas. Kai nustatyta reikšmė \'Visai svetainei\', naudotojas "kels lygį" svetainėje, o ne pasirinktinai kiekviename kurse. Bus naudojami visi svetainėje surinkti taškai.';
$string['whoops'] = 'Oooops!';
$string['xp'] = 'Patirties taškai';
$string['xp:addinstance'] = 'Pridėti naują bloką';
$string['xp:earnxp'] = 'Taškų rinkimas';
$string['xp:manage'] = 'Valdykite visus patirties taškų aspektus';
$string['xp:myaddinstance'] = 'Įtraukti bloką į mano prietaisų skydelį';
$string['xp:view'] = 'Peržiūrėti bloką ir susijusius puslapius';
$string['xp:viewlogs'] = 'Peržiūrėti įrašus';
$string['xp:viewreport'] = 'Peržiūrėti ataskaitą';
$string['xpgaindisabled'] = 'Taškų gavimas išjungtas';
$string['xprequired'] = 'Reikalingi XP';
$string['xptogo'] = 'liko [[{$a}]]';
$string['youreachedlevel'] = 'Pasiekėte lygį:';
$string['youreachedlevela'] = 'Pasiekėte {$a} lygį!';
$string['yourmessage'] = 'Jūsų žinutė';
$string['yourownrules'] = 'Jūsų pačių taisyklės';
