<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certificate', language 'es', version '4.5'.
 *
 * @package     tool_certificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcertpage'] = 'Agregar página';
$string['addelement'] = 'Agregar elemento';
$string['addelementwithname'] = 'Añadir el elemento \'{$a}\'';
$string['after'] = 'Después';
$string['aissueswerecreated'] = 'Se emitieron {$a} certificados';
$string['aligncentre'] = 'Centrado';
$string['alignleft'] = 'Izquierda';
$string['alignment'] = 'Alineación de texto';
$string['alignment_help'] = 'La alineación del texto a la derecha significará que las coordenadas del elemento (Posición X y Posición Y) se referirán a la esquina superior derecha del cuadro de texto, en la alineación central se referirán a la parte superior central y en la alineación izquierda a la esquina superior izquierda';
$string['alignright'] = 'Derecha';
$string['allowfilters'] = 'Filtros permitidos para el contenido PDF';
$string['allowfilters_desc'] = 'Sólo se aplicarán los filtros seleccionados (si están activados) a los textos de los certificados PDFs';
$string['archived'] = 'Archivado';
$string['availableincourses'] = 'Disponible en subcategorías y cursos';
$string['availableincourses_help'] = 'Al habilitar esta opción, los usuarios (con permisos para emisión) podrán usar esta plantilla en todos los cursos dentro de la categoría seleccionada y también en los cursos dentro de sus subcategorías. Si esta opción está deshabilitada, esta plantilla estará disponible exclusivamente para usuarios con capacidades de emisión en la categoría seleccionada.';
$string['certificate'] = 'Certificado';
$string['certificate:image'] = 'Gestionar las imágenes de certificados';
$string['certificate:issue'] = 'Emitir certificado para usuarios';
$string['certificate:manage'] = 'Gestionar certificados';
$string['certificate:verify'] = 'Verificar cualquier certificado';
$string['certificate:viewallcertificates'] = 'Ver todas las plantillas de certificado y los emitidos para el Sitio actual';
$string['certificate_customfield'] = 'Campos personalizados de certificados';
$string['certificatecopy'] = '{$a} (copia)';
$string['certificateelement'] = 'Elemento del certificado';
$string['certificateimages'] = 'Imágenes de certificados';
$string['certificates'] = 'Certificados';
$string['certificatesettings'] = 'Configuración de certificados';
$string['certificatesissues'] = 'Certificados emitidos';
$string['certificatetemplate'] = 'Plantilla de certificado';
$string['certificatetemplatename'] = 'Nombre de la plantilla de certificado';
$string['certificatetemplates'] = 'Plantillas de certificado';
$string['changeelementsequence'] = 'Traer al frente o mover al fondo';
$string['code'] = 'Código';
$string['codewithlink'] = 'Código con link';
$string['coursecategorywithlink'] = 'Categoría del curso con link';
$string['createtemplate'] = 'Nueva plantilla de certificados';
$string['customfield_previewvalue'] = 'Previsualizar el valor';
$string['customfield_previewvalue_help'] = 'Valor mostrado durante la previsualización de la plantilla';
$string['customfield_visible'] = 'Visible';
$string['customfield_visible_help'] = 'Permitir seleccionar este campo en la plantilla de certificado';
$string['customfieldsettings'] = 'Configuración de campos personalizados de certificados comunes';
$string['deleteelement'] = 'Eliminar elemento';
$string['deleteelementconfirm'] = '¿Estás seguro de querer eliminar el elemento \'{$a}\'?';
$string['deletepage'] = 'Eliminar página';
$string['deletepageconfirm'] = '¿Estás seguro de querer eliminar esta página de certificado?';
$string['deletetemplateconfirm'] = '¿Estás seguro de querer eliminar la plantilla de certificado \'{$a}\' y todos los datos asociados? Esta acción no se puede deshacer.';
$string['demotmpl'] = 'Plantilla demo de certificado';
$string['demotmplawardedon'] = 'Otorgado el';
$string['demotmplawardedto'] = 'El certificado es otorgado a';
$string['demotmplbackground'] = 'Imagen de fondo';
$string['demotmplcoursefullname'] = 'Nombre completo del curso';
$string['demotmpldirector'] = 'Director';
$string['demotmplforcompleting'] = 'Por completar el curso';
$string['demotmplissueddate'] = 'Fecha de emisión';
$string['demotmplqrcode'] = 'Código QR';
$string['demotmplsignature'] = 'Firma';
$string['demotmplusername'] = 'Nombre de usuario';
$string['do_not_show'] = 'No mostrar';
$string['duplicate'] = 'Duplicar';
$string['duplicatetemplateconfirm'] = '¿Estás seguro de querer duplicar la plantilla \'{$a}\'?';
$string['editcertificate'] = 'Editar la plantilla de certificados  \'{$a}\\';
$string['editelement'] = 'Editar \'{$a}\\';
$string['editelementname'] = 'Editar el nombre del elemento';
$string['editpage'] = 'Editar página {$a}';
$string['edittemplatename'] = 'Editar nombre de la plantilla';
$string['elementname'] = 'Nombre del elemento';
$string['elementname_help'] = 'Este será el nombre que se usará para identificar este elemento cuando se esté editando el certificado. Tener en cuenta que esto no será mostrado en el PDF.';
$string['elementwidth'] = 'Ancho, mm';
$string['elementwidth_help'] = 'Especificar el ancho del elemento. Cero (0) significa que no hay restricción de ancho.';
$string['entitycertificate'] = 'Certificado';
$string['entitycertificateissue'] = 'Certificado emitido';
$string['eventcertificateissued'] = 'Certificado emitido';
$string['eventcertificateregenerated'] = 'Certificado regenerado';
$string['eventcertificaterevoked'] = 'Certificado revocado';
$string['eventcertificateverified'] = 'Certificado verificado';
$string['eventtemplatecreated'] = 'Plantilla creada';
$string['eventtemplatedeleted'] = 'Plantilla eliminada';
$string['eventtemplateupdated'] = 'Plantilla actualizada';
$string['expired'] = 'Caducado';
$string['expiredcertificate'] = 'Este certificado caducó';
$string['expirydate'] = 'Fecha de vencimiento';
$string['expirydatetype'] = 'Tipo de fecha de vencimiento';
$string['font'] = 'Fuente';
$string['font_help'] = 'La fuente utilizada para la generación de este elemento';
$string['fontcolour'] = 'Color';
$string['fontcolour_help'] = 'Color de la fuente';
$string['fontsize'] = 'Tamaño, pt';
$string['fontsize_help'] = 'El tamaño de la fuente en puntos.';
$string['hideshow'] = 'Ocultar/mostrar';
$string['invalidcolour'] = 'El color elegido es inválido. Por favor, agregar un nombre de color de HTML válido, o un color hexadecimal de seis o tres dígitos.';
$string['invalidelementwidth'] = 'Por favor ingrese un número positivo';
$string['invalidheight'] = 'La altura debe ser un número mayor a cero.';
$string['invalidmargin'] = 'El margen debe ser mayor a cero.';
$string['invalidposition'] = 'Por favor, elija un número positivo para la posición {$a}.';
$string['invalidwidth'] = 'El ancho debe ser mayor a cero.';
$string['issuecertificates'] = 'Emitir certificados';
$string['issuedcertificates'] = 'Certificados emitidos';
$string['issueddate'] = 'Fecha de emisión';
$string['issuelang'] = 'Emitir certificados en el idioma del usuario';
$string['issuelangdesc'] = 'En sitios multilingües, cuando el idioma del usuario es diferente al idioma del sitio, los certificados se generarán en el idioma del usuario; de lo contrario, todos los certificados se generarán en el idioma predeterminado del sitio.';
$string['issuenewcertificate'] = 'Emitir nuevo certificado a partir de esta plantilla';
$string['issuenotallowed'] = 'No estás autorizado a emitir certificados desde esta plantilla.';
$string['issueormangenotallowed'] = 'No estás autorizado a emitir certificados ni gestionar esta plantilla.';
$string['leftmargin'] = 'Margen izquierdo, mm';
$string['leftmargin_help'] = 'Este es el margen izquierdo del PDF del certificado, en milímetros.';
$string['linkedinorganizationid'] = 'ID de la organización en LinkedIn';
$string['linkedinorganizationid_desc'] = 'El ID de la organización en LinkedIn que emite los certificados.

¿Dónde encuentro el ID de mi organización en LinkedIn?

1. Iniciar sesión en LinkedIn como administrador de la página de la organización.
2. Verificar la URL utilizada cuando iniciaste sesión como administrador. (La URL debe parecerse a "https://linkedin.com/company/xxxxxxx/admin")
3. El ID de tu organización en LinkedIn será el número de siete dígitos en la URL (se muestra como "xxxxxxx" en el punto anterior)';
$string['manageelementplugins'] = 'Gestionar extensiones de elementos del certificado';
$string['managetemplates'] = 'Gestionar plantillas de certificado';
$string['messageprovider:certificateissued'] = 'Certificado recibido';
$string['milimeter'] = 'mm';
$string['mycertificates'] = 'Mis certificados';
$string['mycertificatesdescription'] = 'Estos son los certificados que has emitido vía correo electrónico o descargándolo manualmente.';
$string['name'] = 'Nombre';
$string['nametoolong'] = 'Superaste la longitud máxima permitida para el nombre';
$string['never'] = 'Nunca';
$string['noimage'] = 'Sin imagen';
$string['noissueswerecreated'] = 'Los certificados no se han emitido';
$string['nopermissionform'] = 'No tienes los permisos para acceder a este formulario.';
$string['notificationmsgcertificateissued'] = 'Hola {$a->fullname},<br /><br />¡Tu certificado está disponible! Puedes encontrarlo aquí:
<a href="{$a->url}">My Certificates</a>';
$string['notificationsubjectcertificateissued'] = '¡Tu certificado está disponible!';
$string['notverified'] = 'No verificado';
$string['numberofpages'] = 'Número de páginas';
$string['oneissuewascreated'] = 'Se emitió una vez';
$string['page'] = 'Página {$a}';
$string['pageheight'] = 'Altura de la página, mm';
$string['pageheight_help'] = 'Esta es la altura del certificado PDF en mm. Para tener una referencia, una hoja A4 tiene 297mm de alto y una hoja carta tiene 279mm de alto.';
$string['pagewidth'] = 'Ancho de la página, mm';
$string['pagewidth_help'] = 'Este es el ancho de un certificado PDF en mm. Para tener una referencia, una hoja A4 tiene 210mm de ancho y una hoja carta 216mm de ancho.';
$string['pluginname'] = 'Gestor de certificado';
$string['posx'] = 'Posición X, mm';
$string['posx_help'] = 'Esta es la posición en mm desde la esquina superior izquierda que deseás ubicar el punto de referencia del elemento en la dirección x.';
$string['posy'] = 'Posición Y, mm';
$string['posy_help'] = 'Esta es la posición en mm desde la esquina superior izquierda que deseás ubicar el punto de referencia del elemento en la dirección y.';
$string['privacy:metadata:tool_certificate:issues'] = 'La lista de los certificados emitidos';
$string['privacy:metadata:tool_certificate_issues:code'] = 'El código que pertenece al certificado';
$string['privacy:metadata:tool_certificate_issues:expires'] = 'La marca de tiempo cuando caduca el certificado. 0 si no caduca.';
$string['privacy:metadata:tool_certificate_issues:templateid'] = 'El ID del certificado';
$string['privacy:metadata:tool_certificate_issues:timecreated'] = 'El momento en que el certificado fue emitido';
$string['privacy:metadata:tool_certificate_issues:userid'] = 'El ID del usuario al que se le emitió el certificado';
$string['reg_wpcertificates'] = 'Cantidad de certificados ({$a})';
$string['reg_wpcertificatesissues'] = 'Cantidad de certificados emitidos ({$a})';
$string['regenerate'] = 'Volver a generar';
$string['regeneratefileconfirm'] = '¿Estás seguro de querer volver a generar el certificado emitido para este usuario?';
$string['regenerateissuefile'] = 'Volver a emitir certificado';
$string['revoke'] = 'Revocar';
$string['revokecertificateconfirm'] = '¿Estás seguro de querer volver a generar el certificado emitido para este usuario?';
$string['rightmargin'] = 'Margen derecho, mm';
$string['rightmargin_help'] = 'Margen derecho del certificado en PDF, en milímetros.';
$string['selectdate'] = 'Seleccionar día';
$string['selectuserstoissuecertificatefor'] = 'Seleccionar usuarios a los que emitirle el certificado';
$string['shared'] = 'Compartido';
$string['shareonlinkedin'] = 'Compartir en LinkedIn';
$string['show_link_to_certificate_page'] = 'Mostrar enlace a la página de certificación';
$string['show_link_to_verification_page'] = 'Mostrar enlace a la página de verificación';
$string['show_shareonlinkedin'] = 'Mostrar compartir en LinkedIn';
$string['show_shareonlinkedin_desc'] = 'Si el botón "Compartir en LinkedIn" debe mostrarse en mi página de certificados';
$string['status'] = 'Estado';
$string['subplugintype_certificateelement'] = 'Complemento de elemento de certificado';
$string['subplugintype_certificateelement_plural'] = 'Plugins de elemento de certificado';
$string['template'] = 'Plantilla';
$string['templatepermission'] = 'Permiso para acceder a la plantilla';
$string['templatepermissionany'] = 'No comprobar';
$string['templatepermissionyes'] = 'Verificar el permiso del usuario actual';
$string['timecreated'] = 'Fecha de creación';
$string['uploadimage'] = 'Subir imagen';
$string['valid'] = 'Válido';
$string['validcertificate'] = 'Este certificado es válido';
$string['verified'] = 'Verificado';
$string['verify'] = 'Verificar';
$string['verifycertificates'] = 'Verificar certificados';
$string['verifynotallowed'] = 'No estás habilitado para verificar certificados.';
$string['viewcertificate'] = 'Ver certificado';
