<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_uikit', language 'fr', version '4.5'.
 *
 * @package     theme_uikit
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Accepter';
$string['alert-background'] = 'Couleur de fond';
$string['alert-border'] = 'Couleur des bordures';
$string['alert-color'] = 'Couleur du texte';
$string['alert-danger-background'] = 'Couleur de fond de danger';
$string['alert-danger-border'] = 'Couleur des bordures de danger';
$string['alert-danger-color'] = 'Couleur du texte de danger';
$string['alert-success-background'] = 'Couleur de fond de succès';
$string['alert-success-border'] = 'Couleur des bordures de succès';
$string['alert-success-color'] = 'Couleur du texte de succès';
$string['alert-warning-background'] = 'Couleur de fond d’attention';
$string['alert-warning-border'] = 'Couleur des bordures d’attention';
$string['alert-warning-color'] = 'Couleur du texte d’attention';
$string['allclasses'] = 'Toutes les classes';
$string['allcourses'] = 'Tout les cours';
$string['allmodules'] = 'Tout les modules';
$string['allsubjects'] = 'Toutes les matières';
$string['allunits'] = 'Toutes les unités';
$string['almost-flat'] = 'Presque plat';
$string['alwaysdisplay'] = 'Toujours montrer';
$string['analyticsadmin'] = 'Suivre les administrateurs';
$string['analyticsadmindesc'] = 'Permettre de suivre les administrateurs aussi.';
$string['analyticsclean'] = 'Envoyer des URLs propres';
$string['analyticscleandesc'] = 'Cette fonctionnalité fantastique a été créée par <a href="https://moodle.org/user/profile.php?id=281671" target="_blank">Gavin Henrick</a> et <a href="https://moodle.org/user/view.php?id=907814" target="_blank">Bas Brands</a> et est implémentée dans ce thème. Au lieu d’utiliser les URLs standards de Moodle le thème enverra des URLs propres rendant plus facile l’identification des pages et fournir un rapport avancé. Pour plus d’informations sur l’utilisation de cette fonctionnalité et ces différentes utilisations : <b><a href="http://www.somerandomthoughts.com/blog/2012/04/18/ireland-uk-moodlemoot-analytics-to-the-front/" target="_blank">cliquez ici here</a></b>.';
$string['analyticsdesc'] = 'Ici vous pouvez activer Google Analytics pour votre site moodle. Vous aurez besoin de vous inscrire avec un compte gratuit sur le <a href="http://analytics.google.com" target="_blank">site de Google Analytics</a>.';
$string['analyticsheading'] = 'Google Analytics';
$string['analyticsheadingsub'] = 'Des analyses performantes de Google';
$string['analyticsid'] = 'Votre ID de suivi';
$string['analyticsiddesc'] = 'Entrez l’ID de suivi fournit. Typiquement formaté comme UC-XXXXXXXX-X';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Fournissez une URL à votre application mobile sur le Google Play Store. Si vous n’en avez pas une alors peut être est-il mieux que vous utilisiez l’application gratuite officielle Moodle Mobile.';
$string['auto'] = 'Auto';
$string['auto_refresh'] = 'Rafraichissement automatique';
$string['autohide'] = 'Inclure la fonctionnalité de masquage automatique';
$string['autohidedesc'] = 'La fonctionnalité de masquage automatique est conçue pour rendre Moodle moins intimidant. Lorsque l’édition est activée les icônes d’édition apparaissent seulement lorsque l’élément est survolé.';
$string['backtotop'] = 'Retour en haut';
$string['base-body-background'] = 'Couleur de fond';
$string['base-body-color'] = 'Couleur du texte';
$string['base-body-font-family'] = 'Police pour le corps de le page';
$string['base-body-font-size'] = 'Taille de la police';
$string['base-body-gradient-inner'] = 'Couleur de fond - Dégradé (intérieur)';
$string['base-body-gradient-outer'] = 'Couleur de fond - Dégradé (extérieur)';
$string['base-body-line-height'] = 'Hauteur de ligne';
$string['base-heading-color'] = 'Couleur du texte des titres';
$string['base-heading-font-family'] = 'Police des titres';
$string['base-heading-font-weight'] = 'Corps de police des titres';
$string['base-link-color'] = 'Couleur des liens';
$string['base-link-hover-color'] = 'Couleur des liens survolés';
$string['base-link-hover-text-decoration'] = 'Décoration des liens survolés';
$string['base-link-text-decoration'] = 'Décoration des liens';
$string['base_theme'] = 'Thème de base';
$string['basic'] = 'Basique';
$string['bootstrapcdn'] = 'FontAwesome de CDN';
$string['bootstrapcdndesc'] = 'Si activée, cela chargera FontAwesome depuis Bootstrap CDN en ligne. Activez cette option si vous rencontrez des problèmes pour trouver les icônes de FontAwesome à afficher dans votre site.';
$string['breadcrumbsplacement'] = 'Position du fil d’ariane';
$string['breadcrumbsplacement-mainregion'] = 'Région principale';
$string['breadcrumbsplacement-pagenavbar'] = 'Barre de navigation en haut de la page';
$string['button-active-background'] = 'Normal - Fond actif';
$string['button-active-color'] = 'Normal - Texte actif';
$string['button-background'] = 'Normal - Fond';
$string['button-border'] = 'Couleur des bordures';
$string['button-border-bottom'] = 'Couleur des bordures (en bas)';
$string['button-color'] = 'Normal - Texte';
$string['button-contrast-hover-border'] = 'Couleur des bordures survolés (contraste)';
$string['button-contrast-text-shadow'] = 'Ombre du texte (contraste)';
$string['button-danger-active-background'] = 'Danger - Fond actif';
$string['button-danger-active-color'] = 'Danger - Texte actif';
$string['button-danger-background'] = 'Danger - Fond';
$string['button-danger-color'] = 'Danger - Texte';
$string['button-danger-gradient-bottom'] = 'Danger - Dégradé (en bas)';
$string['button-danger-gradient-top'] = 'Danger - Dégradé (en haut)';
$string['button-danger-hover-background'] = 'Danger - Fond survolé';
$string['button-danger-hover-color'] = 'Danger - Texte survolé';
$string['button-disabled-background'] = 'Disabled - Fond';
$string['button-disabled-color'] = 'Disabled - Texte';
$string['button-gradient-bottom'] = 'Normal - Dégradé (en bas)';
$string['button-gradient-top'] = 'Normal - Dégradé (en haut)';
$string['button-height'] = 'Taille du bouton';
$string['button-hover-background'] = 'Normal - Fond survolé';
$string['button-hover-border'] = 'Couleur de bordure en surbrillance';
$string['button-hover-color'] = 'Normal - Texte survolé';
$string['button-primary-active-background'] = 'Primaire - Fond actif';
$string['button-primary-active-color'] = 'Primaire - Texte actif';
$string['button-primary-background'] = 'Primaire - Fond';
$string['button-primary-color'] = 'Primaire - Texte';
$string['button-primary-gradient-bottom'] = 'Primaire - Dégradé (en bas)';
$string['button-primary-gradient-top'] = 'Primaire - Dégradé (en haut)';
$string['button-primary-hover-background'] = 'Primaire - Fond survolé';
$string['button-primary-hover-color'] = 'Primaire - Texte survolé';
$string['button-small-height'] = 'Hauteur petit bouton';
$string['button-success-active-background'] = 'Succès - Fond actif';
$string['button-success-active-color'] = 'Succès - Texte actif';
$string['button-success-background'] = 'Succès - Fond';
$string['button-success-color'] = 'Succès - Texte';
$string['button-success-gradient-bottom'] = 'Succès - Dégradé (en bas)';
$string['button-success-gradient-top'] = 'Succès - Dégradé (en haut)';
$string['button-success-hover-background'] = 'Succès - Fond en surbrillance';
$string['button-success-hover-color'] = 'Succès - Texte en surbrillance';
$string['button-text-shadow'] = 'Ombre du texte';
$string['cancel'] = 'Annuler';
$string['choosereadme'] = 'Theme basé sur le framework CSS UIKit. Il inclut un Gestionnaire de Style Visuel';
$string['combolistshowonlyenrrolled'] = 'Montrer uniquement les cours suivis dans la liste déroulante';
$string['componentclass-danger'] = 'Danger';
$string['componentclass-link'] = 'Lien';
$string['componentclass-normal'] = 'Normal';
$string['componentclass-primary'] = 'Primaire';
$string['componentclass-success'] = 'Succès';
$string['componentplacement-bottom'] = 'Bas';
$string['componentplacement-center'] = 'Centrer';
$string['componentplacement-left'] = 'Gauche';
$string['componentplacement-right'] = 'Droite';
$string['componentplacement-top'] = 'Haut';
$string['configtitle'] = 'UIKit';
$string['contactinfo'] = 'Information de contact';
$string['contactinfodesc'] = 'Entrez vos informations de contact.';
$string['continue_refreshing'] = 'Continuer à rafraichir ?';
$string['copyright'] = 'Droit d’auteur';
$string['copyrightdesc'] = 'Le nom de votre organisme.';
$string['courselist'] = 'Afficher la liste simplifiée des cours';
$string['custom_less'] = 'Utiliser votre propre code CSS/LESS personnalisé.';
$string['custom_less_default'] = 'Votre code CSS ou LESS personnalisé ici…
    Il sera ajouté à la fin de la feuille de style';
$string['custommenudesc'] = 'Ici les paramètres vous permettent d’ajouter des fonctionnalités dynamique au menu personnalisé (aussi appelé Menu déroulant)';
$string['custommenuheading'] = 'Menu personnalisé';
$string['custommenuheadingsub'] = 'Ajouter des fonctionnalités supplémentaires à votre menu personnalisé.';
$string['displayafterlogin'] = 'Afficher seulement après s’être connecté';
$string['displaybeforelogin'] = 'Afficher seulement avant de se connecter';
$string['displayloggedusermode'] = 'Mode d’affichage d’utilisateur connecté';
$string['displayloggedusermodecomplete'] = 'Compléter les informations';
$string['displayloggedusermodedesc'] = 'Ce paramètre définit comment l’utilisateur connecté est affiché dans le menu personnalisé';
$string['displayloggedusermodehide'] = 'Cacher';
$string['displayloggedusermodeonlylogout'] = 'Déconnexion seulement';
$string['displayloggedusermodeshort'] = 'Informations résumées';
$string['displaymycourses'] = 'Afficher les cours suivis';
$string['displaymycoursesdesc'] = 'Afficher les cours suivis pour les utilisateurs dans le menu personnalisé';
$string['displaymycoursesmode'] = 'Mode d’affichage des cours suivis';
$string['displaymycoursesmodedesc'] = 'Ce paramètre définit comment l’utilisateur connecté est affiché dans le menu personnalisé';
$string['displaymydashboard'] = 'Afficher Mon tableau de bord';
$string['displaymydashboarddesc'] = 'Afficher Mon tableau de bord dans le menu personnalisé';
$string['displaysitename'] = 'Afficher le nom du site';
$string['dontdisplay'] = 'Ne jamais afficher';
$string['dropdown-background'] = 'Couleur de fond des menus déroulants';
$string['dropdown-navbar-background'] = 'Fond des menus déroulants';
$string['export_less'] = 'Exporter dans un fichier LESS';
$string['export_less_tooltip'] = 'Exporter le style personnalisé dans un fichier LESS';
$string['facebook'] = 'URL de Facebook';
$string['facebookdesc'] = 'Entrer l’URL de votre page Facebook. (exemple : http://www.facebook.com/monuniversite)';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Veuillez déposer votre favicon personnalisé ici si vous voulez l’ajouter à la page.';
$string['flickr'] = 'URL de Flickr';
$string['flickrdesc'] = 'Entrez l’URL de votre page Flickr (exemple : http://www.flickr.com/monuniversite)';
$string['footerbackground'] = 'Image de fond du pied de page';
$string['footerbackgrounddesc'] = 'Importer votre propre image de fond du pied de page. Cela s’appliquera à toutes les pages.';
$string['footerblocks'] = 'Activer les blocs dans le pied de page';
$string['footerblocksdesc'] = 'Si cette option est activé 3 nouveaux emplacements de blocs seront affichés dans le pied de page';
$string['footerimage'] = 'Pied de page';
$string['footerimagedesc'] = 'Veuillez déposer votre image personnalisé de pied de page ici si vous voulez l’ajouter au pied de page.<br>Si vous déposez une image elle sera placée au dessus du pied de page HTML. (si il y en a un)';
$string['footerplacement'] = 'Placement du pied de page';
$string['footerplacementaftermaincontent'] = 'Après le contenu principal de la page';
$string['footerplacementpageend'] = 'À la fin de la page';
$string['footnote'] = 'Note en bas de page';
$string['footnotedesc'] = 'Tout ce que vous ajoutez dans ce textarea sera affiché dans le pied de page sur tout votre votre Moodle.';
$string['frontcontentarea'] = 'Contenu de la page d’accueil';
$string['frontcontentareadesc'] = 'Quel que soit ce qui est écrit dans ce champ ce sera affiché sur toute la largeur de la page entre les slides et le spot marketing';
$string['frontcontentdesc'] = 'Cela ajoute une zone de contenu personnalisé en haut du bloc de contenu principal de la page d’accueil pour votre propre contenu personnalisé.';
$string['frontcontentheading'] = 'Paramètres de la page d’accueil';
$string['frontcontentheadingsub'] = 'Changez quelles fonctionnalités vous souhaitez activer sur votre page d’accueil de Moodle';
$string['frontpageblocks'] = 'Alignement des blocs de la page d’accueil';
$string['frontpageblocksdesc'] = 'Ici vous pouvez choisir d’aligner les blocs de la page d’accueil sur la gauche ou sur la droite';
$string['frontpagemiddleblocks'] = 'Activer les blocs centrés sur la page d’accueil';
$string['frontpagemiddleblocksdesc'] = 'Si activé cela affichera 3 nouveaux emplacements de blocs juste en dessus du contenu de la page d’accueil';
$string['fullhierarchy'] = 'Afficher les cours dans leur hiérarchie complète';
$string['geneicsettings'] = 'Réglages généraux';
$string['global-border'] = 'Couleur des bordures';
$string['global-border-radius'] = 'Rayon des bordures';
$string['global-contrast-color'] = 'Contrast Color';
$string['global-danger-background'] = 'Couleur de fond de danger';
$string['global-danger-gradient-bottom'] = 'Couleur de fond danger dégradé (en bas)';
$string['global-danger-gradient-top'] = 'Couleur de fond danger dégradé (en haut)';
$string['global-muted-color'] = 'Muted Text Color';
$string['global-primary-background'] = 'Couleur de fond primaire';
$string['global-primary-gradient-bottom'] = 'Couleur de fond primaire dégradé (en bas)';
$string['global-primary-gradient-top'] = 'Couleur de fond primaire dégradé (en haut)';
$string['global-success-background'] = 'Couleur de fond de succès';
$string['global-success-gradient-bottom'] = 'Couleur de fond de succès dégradé (en bas)';
$string['global-success-gradient-top'] = 'Couleur de fond de succès dégradé (en haut)';
$string['googlefontname'] = 'Numéro de police ($a->number)';
$string['googlefontsheading'] = 'Google Fonts';
$string['googlefontsheadingsub'] = 'Ici vous pouvez ajouter jusqu’à 10 Google Fonts qui seront disponible sur toutes les pages Moodle';
$string['googlefontsnofont'] = '--Pas de police--';
$string['googleplus'] = 'URL de Google+';
$string['googleplusdesc'] = 'Entrer l’URL de votre profile Google+. (exemple : http://plus.google.com/107817105228930159735)';
$string['gradient'] = 'Dégradé';
$string['group-alerts'] = 'Alertes';
$string['group-breadcrumbs'] = 'File d’ariane';
$string['group-buttons'] = 'Boutons';
$string['group-global'] = 'Global';
$string['group-layout'] = 'Disposition';
$string['group-login-page'] = 'Page de connexion';
$string['group-main-region'] = 'Contenu principal';
$string['group-mdl-blocks'] = 'Blocs';
$string['group-navbar'] = 'Navigation (Disposition en grille)';
$string['group-navbar-layout2'] = 'Navigation (Disposition en Flex)';
$string['group-other'] = 'Autre';
$string['group-to-top-button'] = 'aller au bouton du haut';
$string['group-typography'] = 'Typography';
$string['headerbackground'] = 'Image de fond de l’en-tête';
$string['headerbackgrounddesc'] = 'Importer votre propre image de fond de l’en-tête. Cela s’appliquera à toutes les pages.';
$string['headerprofilepic'] = 'Afficher l’avatar de l’utilisateur';
$string['headerprofilepicdesc'] = 'Si coché, affiche l’avatar de l’utilisateur dans l’en-tête de la page.';
$string['hideonphone'] = 'Diaporama sur Mobile';
$string['hideonphonedesc'] = 'Choisir si vous voulez avoir le diaporama sur mobile ou pas.';
$string['import_less'] = 'Importer un fichier LESS';
$string['import_less_tooltip'] = 'Importer le style personnalisé à partir d’un fichier LESS';
$string['instagram'] = 'URL d’Instagram';
$string['instagramdesc'] = 'Entrer l’URL de votre page Instagram (exemple : http://instagram.com/monunviersite)';
$string['ios'] = 'iPhone/iPad (Apple Store)';
$string['iosdesc'] = 'Fournir une URL de votre application mobile sur l’Apple Store. Si vous n’en avez pas une qui vous est propre alors vous pouvez fournir celle de l’application officiel de Moodle.';
$string['iosicon'] = 'Icône de l’écran d’accueil sur iOS';
$string['iosicondesc'] = 'Le thème fournit un icône par défaut pour iOS, Android et Windows Mobile. Vous pouvez importer votre icône personnalisé si vous le souhaitez.';
$string['ipadicon'] = 'Icône pour iPad (Non Retina)';
$string['ipadicondesc'] = 'L’icône doit être un fichier PNG de taille 72px sur 72px.';
$string['ipadretinaicon'] = 'Icône pour iPad (Retina)';
$string['ipadretinaicondesc'] = 'L’icône doit être un fichier PNG de taille 144px sur 144px.';
$string['iphoneicon'] = 'Icône pour iPhone/iPod Touch (Non Retina)';
$string['iphoneicondesc'] = 'L’icône doit être un fichier PNG de taille 57px sur 57px.';
$string['iphoneretinaicon'] = 'Icône pour iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'L’icône doit être un fichier PNG de taille 114px sur 114px.';
$string['js-compile-error'] = 'Une error est survenue lors de la création du style';
$string['js-externalpage-disallowed'] = 'Aller sur une page externe n’est pas autorisé';
$string['js-font-family-placeholder'] = 'Écrire votre police ou liste de polices';
$string['js-home'] = 'Accueil';
$string['js-less-error-help'] = 'Tenter de vider le cache de votre navigateur et assure-vous que votre code CSS/LESS personnalisé est correct';
$string['js-ok'] = 'Ok';
$string['js-reset-all-confirm'] = 'Réinitialiser TOUS les groupes de variables par défaut ?';
$string['js-reset-group'] = 'Réinitialiser le groupe de valeurs par défaut ?';
$string['js-reset-group-confirm'] = 'Réinitialiser le groupe <i>{0}</i> de variables par défaut ?';
$string['js-reset-var-confirm'] = 'Réinitialiser <i>{0}</i> par défaut ?';
$string['js-styles-saved'] = 'Sauvegarde des styles effectué avec succès !';
$string['js-styles-saved-error'] = 'Une erreur est survenue lors de la sauvegarde des styles';
$string['keep_variables'] = 'Garder les valeurs des variables entre les thèmes là où c’est possible';
$string['layoutheading'] = 'Options de disposition';
$string['left'] = 'Gauche';
$string['linkedin'] = 'URL LinkedIn';
$string['linkedindesc'] = 'Saisir l’URL de votre profil LinkedIn (exemple : http://www.linkedin.com/company/monuniversite)';
$string['loginheaderimage'] = 'Image de l’en-tête de la page de connexion';
$string['loginheaderimagedesc'] = 'Si une image est importé, elle remplacera l’en-tête de la page de connexion';
$string['loginpagehasfooter'] = 'Afficher le pied de page';
$string['loginpagehasheader'] = 'Afficher l’en-tête';
$string['loginpagehasnavigation'] = 'Afficher la navigation';
$string['loginpageheading'] = 'Paramètres de la page de connexion';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Veuillez déposer votre logo personnalisé ici si vous voulez l’ajouter à l’en-tête.<br>Si vous déposez un logo, il remplacera l’icône standard et le nom qui étaient affichés par défaut.';
$string['logoshowsummary'] = 'Afficher le résumé du site en dessous du logo.';
$string['logout'] = 'Se déconnecter';
$string['marketing1'] = 'Premier spot de marketing';
$string['marketing2'] = 'Deuxième spot de marketing';
$string['marketing3'] = 'Troisième spot de marketing';
$string['marketingbuttontext'] = 'Texte du lien';
$string['marketingbuttontextdesc'] = 'Texte à faire apparaître sur le bouton';
$string['marketingbuttonurl'] = 'URL du lien';
$string['marketingbuttonurldesc'] = 'URL vers laquelle le bouton pointera';
$string['marketingcontent'] = 'Contenu';
$string['marketingcontentdesc'] = 'Contenu à afficher dans la zone du marketing. Gardez le court et esthétique.';
$string['marketingdesc'] = 'Ce thème fournit l’option d’activer trois spots de marketing ou de pub juste en dessous du diaporama. Cela vous permet de facilement mettre en avant les informations principales pour vos utilisateurs et fournit un lien direct.';
$string['marketingheading'] = 'Spots de marketing';
$string['marketingheadingsub'] = 'Trois emplacements sur la page d’accueil pour ajouter les informations et les liens';
$string['marketingicon'] = 'Icône';
$string['marketingimage'] = 'Image';
$string['marketingtitle'] = 'Titre';
$string['marketingtitledesc'] = 'Titre à afficher dans le spot marketing';
$string['mdl-block-header-font-family'] = 'Famille de police de l’en-tête';
$string['mdl-block-header-font-size'] = 'Taille de la police de l’en-tête';
$string['mdl-block-header-font-weight'] = 'Poids de la police de l’en-tête';
$string['mdl-block-header-icon-color'] = 'En-tête - Couleur de l’icône';
$string['mdl-block-header-text-color'] = 'En-tête - Couleur du texte';
$string['mdl-block-icon-color'] = 'Couleur d’icône dans le menu';
$string['mdl-block-link-color'] = 'Lien dans le manu';
$string['mdl-block-link-color-hover'] = 'Survol des liens dans le menu';
$string['mdl-block-menu-item-font-family'] = 'Famille de police dans le menu';
$string['mdl-block-menu-item-font-size'] = 'Taille de police dans le menu';
$string['mdl-block-menu-item-font-weight'] = 'Poids de la police dans le menu';
$string['mdl-block-text-color'] = 'Couleur du texte dans le menu';
$string['mdl-breadcrumb-link-color'] = 'Couleur des liens';
$string['mdl-breadcrumb-link-hover-color'] = 'Couleur au survol des liens';
$string['mdl-layout2-left-width'] = 'Disposition Flex - Largeur de la colonne de gauche';
$string['mdl-login-box-background'] = 'Fond de la page de connexion';
$string['mdl-login-box-border'] = 'Bordure de la page de connexion';
$string['mdl-login-box-width'] = 'Largeur de la page de connexion';
$string['mdl-main-region-background'] = 'Couleur de fond';
$string['mdl-main-region-border'] = 'Couleur des bordures';
$string['mdl-main-region-padding'] = 'Padding';
$string['mdl-max-additional-frontpage-content-width'] = 'Section Marketing Page d’accueil - Largeur maximum';
$string['mdl-max-page-content-width'] = 'Contenu de la page - Largeur maximum';
$string['mdl-max-page-footer-width'] = 'Pied de page - Largeur maximum';
$string['mdl-max-page-header-content-width'] = 'En-tête de la page - Largeur maximum';
$string['mdl-max-page-navbar-content-width'] = 'Navigation de la page - Largeur maximum';
$string['mdl-navbar-side-margin'] = 'Marge des bords';
$string['mdl-page-breadcrumbs-background'] = 'Couleur de fond (région principale)';
$string['mdl-page-breadcrumbs-border'] = 'Couleur des bordures (région principale)';
$string['mdl-page-footer-background'] = 'Pied de page - Couleur de fond';
$string['mdl-page-footer-background-gradient-bottom'] = 'Pied de page - Dégradé en bas';
$string['mdl-page-footer-background-gradient-top'] = 'Pied de page - Dégradé en haut';
$string['mdl-to-top-background'] = 'Fond';
$string['mdl-to-top-color'] = 'Couleur de l’icône';
$string['mdl-to-top-shadow-background'] = 'Ombre';
$string['mdl-to-top-shadow-background-hover'] = 'Ombre au survol';
$string['mobileappsheading'] = 'Apps mobiles';
$string['mobileappsheadingsub'] = 'Lien vers l’application mobile à télécharger pour que vos étudiants puissent utiliser Moodle avec leur smartphone.';
$string['myclasses'] = 'Mes classes';
$string['mycourses'] = 'Mes cours';
$string['mycoursesinfo'] = 'Liste dynamique des cours suivis';
$string['mycoursesinfodesc'] = 'Afficher une liste dynamique des cours suivis à l’utilisateur.';
$string['mycoursetitle'] = 'Terminologie';
$string['mycoursetitledesc'] = 'Changer la terminologie pour le lien « Mes cours » dans le menu déroulant';
$string['mydashboard'] = 'Mon tableau de bord';
$string['mymodules'] = 'Mes modules';
$string['mysubjects'] = 'Mes matières';
$string['myunits'] = 'Mes unités';
$string['navbar-background'] = 'Couleur de fond';
$string['navbar-border'] = 'Bordure';
$string['navbar-border-bottom'] = 'Bordure (en bas)';
$string['navbar-color'] = 'Couleur du texte';
$string['navbar-gradient-bottom'] = 'Couleur de fond - Couleur en bas du dégradé';
$string['navbar-gradient-top'] = 'Couleur de fond - Couleur en haut du dégradé';
$string['navbar-link-color'] = 'Couleur des liens';
$string['navbar-link-hover-color'] = 'Couleur des liens survolés';
$string['navbar-nav-active-background'] = 'Éléments du fond actif';
$string['navbar-nav-active-color'] = 'Éléments du texte actif';
$string['navbar-text-shadow'] = 'Ombre du texte';
$string['navigationbuttonsclass-danger'] = 'Danger';
$string['navigationbuttonsclass-link'] = 'Lien';
$string['navigationbuttonsclass-normal'] = 'Normal';
$string['navigationbuttonsclass-primary'] = 'Succès';
$string['navigationbuttonssize-large'] = 'Grand';
$string['navigationbuttonssize-mini'] = 'Tout petit';
$string['navigationbuttonssize-normal'] = 'Normal';
$string['navigationbuttonssize-small'] = 'Petit';
$string['navigationtoggletext'] = 'Navigation';
$string['nextsection'] = 'Section suivante';
$string['noenrolments'] = 'Vous n’êtes inscrits à aucun cours';
$string['page_description'] = 'Cette page permet de personnaliser l’apparence de votre site.';
$string['page_description_sub'] = 'Vous pouvez configurer le logo, le favicon et bien d’autres choses ici.';
$string['pagenavbarcontent-custom'] = 'Personnalisé';
$string['pagenavbarcontent-dontshow'] = 'Ne pas afficher';
$string['pagenavbarcontent-pagetitle'] = 'Titre de la page';
$string['pagenavbarcontent-sitename'] = 'Nom du site';
$string['pagenavbarcontent-sitessummary'] = 'Résumé du site';
$string['panel'] = 'Panel';
$string['pinterest'] = 'URL de Pinterest';
$string['pluginname'] = 'UIKit';
$string['previoussection'] = 'Section précédente';
$string['readmore'] = 'Lire plus';
$string['refresh'] = 'Rafraichir';
$string['region-footer-left'] = 'Pied de page (Gauche)';
$string['region-footer-middle'] = 'Pied de page (Centrer)';
$string['region-footer-right'] = 'Pied de page (Droite)';
$string['region-hidden-dock'] = 'Caché des utilisateurs';
$string['region-home-down'] = 'Accueil (En bas)';
$string['region-home-left'] = 'Accueil (Gauche)';
$string['region-home-middle'] = 'Accueil (Centrer)';
$string['region-home-right'] = 'Accueil (Droite)';
$string['region-home-up'] = 'Accueil (En haut)';
$string['region-side-post'] = 'Droite';
$string['region-side-pre'] = 'Left';
$string['reset'] = 'Réinitialiser';
$string['reset_all'] = 'Réinitialiser tout';
$string['right'] = 'Droite';
$string['save_styles'] = 'Sauvegarder et utiliser ce style';
$string['save_styles_tooltip'] = 'Sauvegarder et utiliser ce style personnalisé pour le site actuel';
$string['showmoodledocs'] = 'Montrer la section "Documentation Moodle pour cette page" dans le pied de page.';
$string['siteicon'] = 'Icône du site';
$string['siteicondesc'] = 'Pas de logo ? Entrez le nom de l’icône que vous aimeriez utiliser. La liste des icônes se trouve <a href="http://www.getuikit.com/docs/icon.html" target="_blank">ici</a>. Saisissez juste ce qu’il y a après le "uk-icon-".';
$string['skype'] = 'Compte Skype';
$string['slideshowanimation-scale'] = 'Echelle';
$string['slideshowanimation-scroll'] = 'Défiler';
$string['styleswritepermissionsfail'] = 'Erreur: le dossier theme/uikit/styles n’a pas les droits d’écriture. Veuillez vérifier que votre serveur a bien les droits en écriture dans ce dossier.';
$string['themedesignerenabled'] = 'Le mode concepteur de thème a été activé';
$string['uikit_not_selected'] = 'Le thème Uikit n’est pas sélectionné.';
$string['uikit_select_link'] = 'Veuillez sélectionner ici';
$string['visibleadminonly'] = 'Les blocs déplacés dans la zone ci-dessous ne seront visible que par les administrateurs';
$string['visualstylemanager'] = 'Gestionnaire de Style Visuel UIKit';
$string['warning_saved_styles_different_theme_version'] = 'Il semblerait que vous avez sauvegardé un style personnalisé pour ce site avec une version antérieure du thème Uikit';
$string['warning_saved_styles_different_theme_version_action'] = 'Veuillez mettre à jour le style du thème en allant dans la personnalisation et cliquer sur sauvegarder. Videz le cache de votre navigateur pour vous assurer que cela fonctionne.';
$string['warning_theme_designer_disable'] = 'Vous pouvez le désactiver ici';
$string['warning_theme_designer_enabled'] = 'Le mode concepteur de thème a été automatiquement activé. Assurez vous de le désactiver pour de meilleurs performances quand vous aurez finit de personnaliser le style.';
$string['warning_variables_changed'] = 'Vous êtes sur le point de changer le thème de base et des variables ont des valeurs différentes de celles par défaut.';
