<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'turnitintooltwo', language 'fr', version '4.5'.
 *
 * @package     turnitintooltwo
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addresubmissiontiidesc'] = 'Renvoi d’utilisateur envoyé à Turnitin';
$string['addsubmission'] = 'Ajouter un envoi';
$string['addsubmissiondesc'] = 'L’utilisateur a ajouté l’envoi';
$string['addsubmissiontiidesc'] = 'Envoi d’utilisateur envoyé à Turnitin';
$string['allowlate'] = 'Autoriser les envois après la date limite';
$string['allownonor'] = 'Autoriser tout type de soumission ?';
$string['allownonor_help'] = 'Ce paramètre permet l’envoi de tous types de fichiers. Si cette option est configurée sur &#34;Oui&#34;, le système vérifiera l’originalité des documents envoyés, si cela est possible ; les documents envoyés pourront être téléchargés et les outils de commentaires GradeMark seront aussi disponibles, si cela est possible.';
$string['allsubmissions'] = 'Boîte de réception des envois';
$string['anon'] = 'Anonyme';
$string['anonalert'] = 'Votre date de publication est antérieure à la date actuelle. Si vous sauvegardez, les annotations anonymes pour cet exercice se désactiveront de façon permanente.';
$string['anonblindmarkingnote'] = 'Remarque : le paramètre d’annotations anonymes à part de Turnitin a été supprimé. Turnitin utilisera le paramètre d’anonymat des copies de Moodle pour déterminer le paramètre d’annotations anonymes.';
$string['anonenabled'] = 'Évaluation anonyme activée';
$string['anytype'] = 'Tous les modes d’envoi';
$string['assigngeterror'] = 'Impossible d’obtenir les données de Turnitintooltwo';
$string['assignmenttitle'] = 'Nouveau titre de l&#39;exercice';
$string['attachrubric'] = 'Joindre une grille d&#39;évaluation à cet exercice';
$string['attachrubricnote'] = 'Remarque: les étudiants pourront voir les grilles d&#39;évaluation jointes et leurs contenus avant de soumettre leur devoir.';
$string['autorefreshgrades'] = 'Actualiser les scores / notes automatiquement';
$string['autorefreshgrades_help'] = 'Par défaut, après chaque appel à Turnitin, le plugin d’intégration de Moodle tente de synchroniser automatiquement les changements créés dans Turnitin. Utilisez cette option pour désactiver ce processus. En revanche, pour préserver la synchronisation entre les deux systèmes, il vous faudra actualiser régulièrement et manuellement les notes ainsi que les scores d’originalité à partir de Moodle.';
$string['ced'] = 'Date de fin du cours';
$string['changerubricwarning'] = 'Si vous modifiez ou supprimez une grille d&#39;évaluation, l&#39;ensemble des scores existants des copies de cet exercice (dont les scores des fiches d&#39;évaluation) seront effacés. Les notes globale des copies corrigées précédement resteront inchangées.';
$string['checkagainstnote'] = 'Remarque : si vous ne sélectionnez pas « Oui » pour au moins une des options « Comparer avec… » ci-dessous, AUCUN rapport d’originalité ne sera généré.';
$string['checkingupgrade'] = 'Vérification des actualisations disponibles en cours';
$string['checkupgrade'] = 'Vérifier les actualisations disponibles';
$string['classcreationerror'] = 'La création du cours Turnitin a échoué';
$string['classupdateerror'] = 'Impossible de mettre à jour les données des cours de Turnitin';
$string['close'] = 'Fermer';
$string['closebutton'] = 'Fermer';
$string['code'] = 'Code';
$string['compareinstitution'] = 'Comparer les fichiers envoyés avec les copies soumises à l&#39;établissement';
$string['config'] = 'Configuration';
$string['configupdated'] = 'Configuration mise à jour';
$string['configureerror'] = 'Vous devez configurer entièrement ce module comme administrateur avant de pouvoir l’utiliser dans un cours. Veuillez contacter votre administrateur de Moodle.';
$string['confirmv1deletetitle'] = 'Souhaitez-vous supprimer les devoirs sélectionnés ?';
$string['connecttest'] = 'Essayer de vous connecter à Turnitin';
$string['connecttestcommerror'] = 'Impossible de se connecter à Turnitin. Veuillez vérifier les paramètres de l’URL de l’API.';
$string['connecttesterror'] = 'Une erreur est survenue lors de la connexion à Turnitin. Vous trouverez le message d’erreur ci-dessous :<br />';
$string['connecttestsuccess'] = 'La connexion de Moodle à Turnitin est réussie.';
$string['copyassigndata'] = 'Copier les données de l’exercice Turnitin';
$string['copyrightagreement'] = 'En cochant cette case, je confirme que le document que je transmets est le mien et j’accepte toutes responsabilités concernant les atteintes aux droits d’auteur qui pourraient se produire suite à l’envoi de cette copie.';
$string['copyrightagreementerror'] = 'Veuillez cocher la case pour indiquer que vous acceptez l’accord avant de réaliser votre envoi.';
$string['course'] = 'Cours';
$string['coursebrowserassignmentdesc'] = 'Dans le tableau ci-dessous vous pouvez sélectionner jusqu&#39;à 5 exercices pour qu&#39;ils fassent partis d&#39;un exercice Turnitin dupliqué.';
$string['coursebrowserdesc'] = 'Vous pouvez rechercher dans Turnitin les cours à recréer dans Moodle, comme le cours ci-dessous';
$string['courseexistsmoodle'] = 'Ce cours existe actuellement dans Moodle comme:';
$string['coursegeterror'] = 'Impossible d’obtenir les données du cours';
$string['coursegettiierror'] = 'Impossible d’obtenir les données du cours de Turnitin';
$string['courseiderror'] = 'ID de cours incorrect';
$string['coursemisconfigured'] = 'Le cours n’est pas configuré correctement';
$string['coursemodidincorrect'] = 'Le N° du module du cours est incorrect';
$string['coursemodincorrect'] = 'Le module du cours est incorrect';
$string['coursestomigrate'] = '{$a} cours peuvent être restaurés depuis Turnitin';
$string['coursetitle'] = 'Titre du Cours';
$string['coursetitleerror'] = 'Vous devez donner un titre au cours pour pouvoir le rechercher';
$string['createassignmenterror'] = 'Une erreur est survenue en essayant de créer l´exercice Turnitin';
$string['createcourse'] = 'Créer un nouveau cours Moodle';
$string['created'] = 'Créé';
$string['createmoodleassignments'] = 'Voulez-vous recréer tous les exercices des cours sélectionnés dans Moodle ?';
$string['createmoodlecourses'] = 'Recréer des Cours';
$string['createsubmissionerror'] = 'Une erreur est survenue en essayant de soummettre un document à Turnitin';
$string['cronsubmittedsuccessfully'] = 'Envoi : {$a->title} (n° TII : {$a->submissionid}) pour l’exercice {$a->assignmentname} du cours {$a->coursename} a bien été envoyé à Turnitin.';
$string['crontaskmodeactive'] = 'Turnitintooltwo – appel de cron annulé en raison d’un mode de tâche actif';
$string['defaultassignmenttiititle'] = 'Exercice Turnitin';
$string['defaultcoursetiititle'] = 'Cours Turnitin';
$string['defaultinserterror'] = 'Une erreur est survenue en ajoutant un réglage par défaut dans la base de données';
$string['defaults'] = 'Réglages par défaut';
$string['defaults_desc'] = 'La configuration suivante est la configuration par défaut utilisée pour les nouveaux exemples de l&#39;exercice 2 de Turnitin Moodle Direct';
$string['defaultsdesc'] = 'Les réglages suivants sont configurés par défaut lorsque Turnitin est activé depuis un Module d&#39;activité';
$string['defaultupdated'] = 'Mise à jour de Turnitin par défaut';
$string['defaultupdateerror'] = 'Une erreur est survenue en tentant d&#39;actualiser une valeur par défaut de la base de données.';
$string['deletable'] = 'Peut être supprimé';
$string['delete_selected'] = 'Supprimer la sélection';
$string['deleteassignmenterror'] = 'Une erreur est survenue en essayant de supprimer l&#39;exercice Turnitin';
$string['deleteconfirm'] = 'Voulez-vous vraiment supprimer cet envoi ?\\n\\nCette opération ne peut pas être annulée.';
$string['deletepart'] = 'Supprimer la Partie';
$string['deletesubmission'] = 'Supprimer cet envoi';
$string['deletesubmissiondesc'] = 'L´utilisateur a supprimé l´envoi';
$string['deletesubmissiontiidesc'] = 'L’utilisateur a supprimé l’envoi de Turnitin';
$string['diagnosticoptions_0'] = 'Arrêt';
$string['diagnosticoptions_1'] = 'Standard';
$string['diagnosticoptions_2'] = 'Débogage';
$string['digital_receipt_message'] = 'Cher(e) {$a->firstname} {$a->lastname},<br /><br />Vous avez bien envoyé le fichier <strong>{$a->submission_title}</strong> pour l’exercice <strong>{$a->assignment_name}{$a->assignment_part}</strong> du cours <strong>{$a->course_fullname}</strong> le <strong>{$a->submission_date}</strong>. Votre numéro d’envoi est le <strong>{$a->submission_id}</strong>. Votre accusé de réception électronique peut être consulté dans son intégralité et imprimé dans la boîte de réception des exercices ou à l’aide du bouton Imprimer/Télécharger dans le Visualiseur de documents.<br /><br />Merci d’utiliser Turnitin,<br /><br />L’équipe Turnitin';
$string['digital_receipt_subject'] = 'Voici votre accusé de réception électronique Turnitin';
$string['digitalreceipt'] = 'Accusé de réception électronique';
$string['disableanonconfirm'] = 'En continuant cette action, vous désactiverez de façon permanente les annotations anonymes pour cet exercice. Voulez-vous vraiment continuer ?';
$string['displaygradesas'] = 'Affichage des notes';
$string['displaygradesas_help'] = 'Cette option définit le mode d’affichage des notes. Celles-ci peuvent être affichées sous forme de pourcentage ou de fraction (par exemple, 45/60).';
$string['displaygradesasfraction'] = 'Afficher les notes sous forme de fraction (89/100)';
$string['displaygradesaspercent'] = 'Afficher les notes sous forme de pourcentage (89 &#37;)';
$string['download'] = 'Télécharger';
$string['downloadassignment'] = 'Télécharger un exercice vers Moodle';
$string['downloadexport'] = 'Exporter';
$string['downloadgrademarkzip'] = 'Télécharger les fichiers sélectionnés GradeMark';
$string['downloadgradexls'] = 'Exporter les notes (XLS)';
$string['downloadorigfileszip'] = 'Télécharger les fichiers originaux';
$string['downloadorigzip'] = 'Fichier compressé ZIP (format original)';
$string['downloadpdfzip'] = 'Fichier compressé ZIP (format PDF)';
$string['downloadsubmission'] = 'Télécharger l’envoi';
$string['draftsubmit'] = 'Quand le document doit-il être envoyé à Turnitin ?';
$string['dtdue'] = 'Date limite';
$string['dtpost'] = 'Date de publication';
$string['dtstart'] = 'Date de début';
$string['duplicatesfound'] = 'Il existe des duplicata des mêmes exercices Turnitin. Les duplicata se produisent lorsqu’un ou plusieurs exercices Moodle Direct sont reliés au même exercice Turnitin via l’API Turnitin. Cela peut causer des problèmes, comme des envois vers un exercice dupliqué s’affichant dans la boîte de réception des autres. Pour corriger ce problème, vous devez soit supprimer les exercices dupliqués, soit réinitialiser le cours dans lequel se trouvent les duplicata.<br /><br />Les duplicata retrouvés sont les suivants :';
$string['edit'] = 'Éditer';
$string['editassignmenterror'] = 'Une erreur est survenue en essayant de modifier l´exercice Turnitin';
$string['emptycreatedfile'] = 'Le fichier que vous tentez de soummettre est soit vide soit endommagé';
$string['enableperformancelogs'] = 'Activer l´enregistrement des performances du réseau';
$string['enableperformancelogs_desc'] = 'Une fois activé, toutes les demandes vers le serveur Turnitin seront enregistrées dans {tempdir}/turnitintooltwo/logs';
$string['enablepseudo'] = 'Activer les paramètres de confidentialité de l’étudiant';
$string['enablepseudo_desc'] = 'Si cette option est sélectionnée, les adresses e-mails des étudiants seront transformées en pseudo équivalent aux appels d’API de Turnitin.<br /><i>(<b>Remarque :</b> cette option n’est plus modifiable si les données d’un utilisateur Moodle ont déjà été synchronisées avec Turnitin)</i>';
$string['enrolling'] = 'Inscription des étudiants à Turnitin';
$string['errorenrollingall'] = 'Une erreur est survenue pendant l’inscription de l’ensemble des étudiants sur Turnitin – veuillez consulter votre administrateur système';
$string['errors'] = 'Erreurs';
$string['errorsdesc'] = 'Un problème est survenu en chargeant les fichiers suivant dans Turnitin';
$string['eventremoved'] = 'Cet évènement a été supprimé de cron queue et ne sera plus traité dans le future.';
$string['excludebiblio'] = 'Exclure la bibliographie';
$string['excludebiblio_help'] = 'Cette option permet à l’enseignant d’exclure de la recherche de correspondances les textes apparaissant dans une bibliographie, les œuvres citées ou les sections de références des copies des étudiants lors du traitement du rapport d’originalité. Cette option peut être ignorée individuellement pour chacun des rapports.';
$string['excludepercent'] = 'Pourcentage';
$string['excludequoted'] = 'Exclure les citations';
$string['excludequoted_help'] = 'Cette option permet à l’enseignant d’exclure de la recherche de correspondances le texte des citations entre guillemets lors du traitement du rapport d’originalité. Cette option peut être ignorée individuellement pour chacun des rapports.';
$string['excludevalue'] = 'Exclure les faibles correspondances';
$string['excludevalue_help'] = 'Cette option permet à l&#39;enseignant d&#39;exclure de la recherche, les correspondances de longueur insuffisante (défini par l&#39;enseignant), lors du traitement du Rapport de Similitude. Cette option peut être ignorée individuellement dans chacun des Rapports.';
$string['excludewords'] = 'Mots';
$string['exportpdf'] = 'Exporter au format PDF';
$string['faultcode'] = 'Code d´erreur';
$string['filebrowser'] = 'Navigateur Moodle Direct';
$string['filedeleteconfirm'] = 'Voulez-vous vraiment supprimer ce fichier ? Cette action ne peut pas être annulée.';
$string['filedoesnotexist'] = 'Le fichier été supprimé';
$string['filename'] = 'Nom du fichier';
$string['files'] = 'Fichiers';
$string['filetosubmit'] = 'Document à envoyer';
$string['filetosubmit_help'] = 'Si vous souhaitez envoyer un document pour une partie d’exercice, cliquez sur Parcourir et recherchez votre fichier dans votre ordinateur. Une fois localisé, vous pouvez le charger en utilisant ce formulaire.';
$string['fileupload'] = 'Charger un document';
$string['genduedate'] = 'Générer les rapports à la date limite (les renvois sont autorisés jusqu’à la date limite)';
$string['genimmediately1'] = 'Génrer les rapports immédiatement (les re-soumissions ne sont pas autorisées)';
$string['genimmediately2'] = 'Générer les rapports immédiatement (les re-soumissions sont autorisées jusqu´à la date limite)';
$string['getassignmenterror'] = 'Impossible d’obtenir les exercices de la migration de Turnitin';
$string['grademark'] = 'GradeMark';
$string['grademarkzip'] = 'Fichiers GradeMark sélectionnés';
$string['gradenosubmission'] = 'L’utilisateur a activé l’évaluation sans envoi pour l’utilisateur numéro';
$string['gradingtemplate'] = 'Modèle d’évaluation';
$string['helpdesklink'] = 'Vous avez besoin d’aide avec Turnitin ?';
$string['hidepeermark'] = 'Cacher les exercices Peermark';
$string['hidepeermarkinstructions'] = 'Cacher les instructions Peermark';
$string['hidesummary'] = 'Cacher le résumé de l&#39;exercice';
$string['id'] = 'N°';
$string['inactive'] = 'Inactif';
$string['institutionalcheck'] = 'Comparer avec la base de données de l’établissement';
$string['institutionalchecksettings'] = 'Comparer avec la<br />base de données de l’établissement';
$string['institutionalrepository'] = 'Base de données de l’établissement (le cas échéant)';
$string['instructor'] = 'Enseignant';
$string['instructorreceipt'] = 'Notifier l’enseignant après l’envoi';
$string['instructorreceipt_desc'] = 'Choisissez d’envoyer ou non une notification à chaque enseignant quand un envoi est réalisé pour un exercice.';
$string['integration'] = 'Intégration';
$string['internetcheck'] = 'Comparer avec Internet';
$string['internetcheck_help'] = 'Comparer avec la base de données Internet de Turnitin lors du traitement des rapports d’originalité des copies. L’index de similarité peut diminuer si cette option n’est pas sélectionnée.';
$string['journalcheck'] = 'Comparer avec les journaux,<br />les revues et les publications';
$string['journalcheck_help'] = 'Comparer avec la base de données des journaux, revues et publications de Turnitin lors du traitement des rapports d’originalité des copies. L’index de similarité peut diminuer si cette option n’est pas sélectionnée.';
$string['launchgrademark'] = 'GradeMark';
$string['launchpeermarkmanager'] = 'Démarrer le Gestionnaire Peermark';
$string['launchpeermarkreviews'] = 'Démarrer les évaluations Peermark';
$string['launchquickmarkmanager'] = 'Démarrer le Gestionnaire Quickmark';
$string['launchrubricmanager'] = 'Démarrer le Gestionnaire des grilles d&#39;évaluation';
$string['launchrubricview'] = 'Voir la grille d&#39;évaluation utilisée pour corriger';
$string['launchrubricviewshort'] = 'Rubrique de correction';
$string['layoutoptions_0'] = 'Largeur complète';
$string['layoutoptions_1'] = 'Configuration par défaut de Moodle – avec options de navigation';
$string['line'] = 'Ligne';
$string['linkcourse'] = 'Lien vers le cours Moodle actuel';
$string['listsubmissions'] = 'Lister les documents envoyés';
$string['listsubmissionsdesc'] = 'L´utilisateur a vu la liste des envois vers le cours';
$string['listsubmissionsdesc_student'] = 'L’utilisateur a consulté sa boîte de réception d’envois pour le cours';
$string['loadingdv'] = 'Chargement du Visualiseur de Document Turnitin…';
$string['marksavailable'] = 'Commentaires disponibles';
$string['maxfilesize'] = 'Taille maximum du fichier';
$string['maxfilesize_help'] = 'Ce paramètre détermine la taille maximum du fichier pour les envois d’utilisateurs pour chaque partie de l’exercice. La valeur maximale pouvant être définie pour ce paramètre dépend de la valeur établie dans les paramètres du cours. Cette valeur peut être de 40 Mo maximum, qui correspond à la taille de fichier maximale pour les envois à Turnitin.';
$string['maxlength'] = 'La longueur maximale pour {$a->field} est de {$a->length} caractères';
$string['maxmarks'] = 'Annotations maximum';
$string['maxmarkserror'] = 'Le nombre maximum d’annotations doit être compris entre 0 et 100';
$string['membercheckerror'] = 'Une erreur est survenue en vérifiant les utilisateurs qui sont inscrits au cours';
$string['message'] = 'Message';
$string['messagenonsubmitters'] = 'Notifier ceux qui n’ont rien envoyé';
$string['messageprovider:nonsubmitters'] = 'Notifications à ceux n’ayant rien envoyé pour l’exercice Turnitin';
$string['messageprovider:notify_instructor_of_submission'] = 'Notifications d’accusé de réception électronique d’enseignant pour un exercice Turnitin';
$string['messageprovider:submission'] = 'Notifications d’accusé de réception électronique d’exercice Turnitin';
$string['messagesinbox'] = 'Boite de réception des messages Turnitin';
$string['migrationassignmentcreated'] = 'Migration d’exercice créée – numéro : {$a}';
$string['migrationassignmentcreationerror'] = 'Impossible de créer une migration d’exercice – cours {$a}';
$string['migrationassignmenterror1'] = 'Impossible d’ajouter un nouveau module de cours au cours {$a}';
$string['migrationassignmenterror2'] = 'Impossible d’ajouter le nouveau module de cours à cette section – cours {$a}';
$string['migrationassignmenterror3'] = 'Impossible de créer un événement pour l’exercice migré – cours {$a}';
$string['migrationassignmentgeterror'] = 'Impossible d&#39;obtenir les exercice Turnitin';
$string['migrationassignmentpartcreated'] = 'Migration de partie d’exercice créée – numéro : {$a}';
$string['migrationcoursecreated'] = 'Le cours de Turnitin a été recréé dans Moodle';
$string['migrationcoursecreatederror'] = 'Le cours {$a} a été recréé, mais une erreur est survenue pendant l’enregistrement du lien';
$string['migrationcoursecreateerror'] = 'Le cours {$a} n’a pas pu être créé dans Moodle';
$string['migrationcoursegeterror'] = 'Impossible d&#39;obtenir les cours Turnitin';
$string['module'] = 'Module';
$string['modulename'] = 'Exercice Turnitin 2';
$string['modulename_help'] = 'Crée un exercice Moodle Direct Turnitin qui relie une activité de Moodle à un ou plusieurs exercices Turnitin. Une fois reliée, l&#39;activité permet aux enseignants d’évaluer et de délivrer des observations sur les travaux écrits des étudiants utilisant les outils d&#39;évaluation, disponibles depuis le Visualiseur de documents Turnitin.';
$string['modulenameplural'] = 'Exercices Turnitin';
$string['modulenamewithv2plural'] = 'Exercices Turnitin (V2)';
$string['moduleversion'] = 'Version';
$string['moodlelinked'] = 'Lien vers Moodle';
$string['mysubmissions'] = 'Mes envois';
$string['newcourseenddate'] = 'Nouvelle date de fin du cours';
$string['newenddatedesc'] = 'Choisissez une nouvelle date de fin pour le cours ci-dessous ; cette date sera mise à jour dans Turnitin';
$string['no'] = 'Non';
$string['nogrades'] = 'Non, j’actualiserai moi même les scores d’originalité et les notes';
$string['nointegration'] = 'Aucune intégration';
$string['nolimit'] = 'Illimité';
$string['nombstringlibrary'] = 'Pour utiliser ce plugin, l’extension PHP XMLWriter doit être installée sur votre serveur.';
$string['nonenrolledstudent'] = 'Étudiant non inscrit';
$string['nonmoodleuser'] = 'Aucun utilisateur Moodle';
$string['nonsubmitterserror'] = 'Veuillez saisir un objet et un message pour cet e-mail';
$string['nonsubmittersformdesc'] = 'Rédigez un message ci-dessous pour l’envoyer aux étudiants qui n’ont pas encore envoyé de copie pour cet exercice.';
$string['nonsubmittersformsuccess'] = 'Votre message a été envoyé aux étudiants n’ayant rien envoyé.';
$string['nonsubmittersmessage'] = 'Message';
$string['nonsubmittersmessageerror'] = 'Veuillez saisir un message pour cet e-mail';
$string['nonsubmitterssendtoself'] = 'M’envoyer une copie de ce message';
$string['nonsubmitterssubject'] = 'Objet';
$string['nonsubmitterssubjecterror'] = 'Veuillez saisir un objet pour cet e-mail';
$string['nonsubmitterssubmit'] = 'Envoyer un e-mail';
$string['noofreviewsrequired'] = 'Nbre d&#39;évaluations requises';
$string['noreason'] = 'Aucun motif n&#39;est spécifié';
$string['norepository'] = 'Aucune base de données';
$string['norubric'] = 'Aucune grille d&#39;évaluation';
$string['noscript'] = 'Turnitin requiert JavaScript et JavaScript n’est pas activé dans votre navigateur. Veuillez l’activer afin de pouvoir bénéficier de toutes les fonctionnalités de Turnitin.';
$string['noscriptsummary'] = 'Turnitin requiert Javascript et Javascript n&#39;est pas activé dans votre navigateur. Vous ne pourrez pas accéder à Turnitin sans l&#39;activer.';
$string['noscriptula'] = '(comme vous n&#39;avez pas Javascript activé, vous devez manuellement rafraîchir cette page avant de pouvoir soumettre un document et ce, après avoir accépter les conditions d&#39;utilisation de Turnitin)';
$string['nosubmissiondataavailable'] = 'Aucune autre donnée d’envoi n’est disponible';
$string['nosubmissions'] = 'Aucun envoi n’a été fait';
$string['notadmin'] = 'Les privilèges d’administrateur Moodle sont requis pour l’action demandée.';
$string['notavailableyet'] = 'Non disponible';
$string['notorcapable'] = 'Impossible de produire un rapport d’originalité pour ce fichier.';
$string['noturnitinassignemnts'] = 'Il n´y a aucun exercice Turnitin';
$string['notutors'] = 'Aucun tuteur de ce cours n&#39; est inscrit via Turnitin';
$string['noxmlwriterlibrary'] = 'Pour utiliser le plugin vous devez avoir l&#39;extension PHP XMLWriter installée sur votre';
$string['numberofparts'] = 'Nombre de Parties';
$string['numberofparts_help'] = 'Permet de créer un exercice en plusieurs parties. Les utilisateurs peuvent individuellement envoyer une copie pour chaque section de l’exercice.';
$string['objectid'] = 'N° du document Turnitin';
$string['offlinestatus'] = 'Turnitin est déconnecté. (la variable $CFG>tiioffline est réglée sur « vrai »';
$string['or'] = 'Ou';
$string['origfileszip'] = 'Fichiers originaux';
$string['otherrubric'] = 'Utiliser la grille d&#39;évaluation appartenant à un autre enseignant';
$string['overallgrade'] = 'Note globale';
$string['overallgrade_help'] = 'La note globale définit la note maximale autorisée pour l’ensemble de l’exercice. Chaque partie de l’exercice a un nombre de points maximum attribués qui sera utilisé pour distribuer les points de manière proportionnelle et déterminer la note globale.';
$string['partdberror'] = 'Un problème est survenu lors de l’accès à la partie {$a} dans la base de données<br />';
$string['partdeleted'] = 'La partie de l&#39;exercice a été supprimée';
$string['partdeleteerror'] = 'Impossible de supprimer la partie {$a} de l’exercice';
$string['partdeletewarning'] = 'La partie d’exercice que vous souhaitez supprimer contient des documents envoyés. Vous allez perdre ces envois si vous effacez cette partie d’exercice. \\n\\nVoulez-vous vraiment continuer ?';
$string['partdueerror'] = 'La date limite doit être antérieure à la date de publication.';
$string['partgeterror'] = 'Impossible d’obtenir les données de la partie de l’exercice';
$string['partname'] = 'Partie de l’exercice';
$string['partnameerror'] = 'Le titre de la partie ne peut pas être vide';
$string['partnametoolarge'] = 'Le nom de la partie est trop long. Veuillez vous limiter à 40 caractères.';
$string['partposterror'] = 'La date de début doit être antérieure à la date de publication.';
$string['partupdateerror'] = 'Un problème est survenu lors de l’actualisation de la partie {$a} dans la base de données<br />';
$string['peermark'] = 'Peermark';
$string['peermarkassignments'] = 'Exercices Peermark';
$string['pending'] = 'En attente';
$string['permissiondeniederror'] = 'Vous n’êtes pas autorisé à effectuer l’opération demandée';
$string['pluginadministration'] = 'Administration de l&#39; exercice 2 de Turnitin';
$string['pluginname'] = 'Exercice Turnitin 2';
$string['portfolio'] = 'Dossier';
$string['postdate_warning'] = 'Veuillez noter que la modification des dates de l’exercice peut affecter l’affichage des notes pour les étudiants et le moment où les noms des étudiants sont révélés aux enseignants.';
$string['pp_classcreationerror'] = 'Il est impossible de créer le cours dans Turnitin, veuillez consulter le journal de votre API pour plus d’informations';
$string['pp_createsubmissionerror'] = 'Une erreur est survenue dans le plugin du plagiat lors de la création de la transmission';
$string['pp_submission_error'] = 'Turnitin a renvoyé un message d’erreur pour votre envoi :';
$string['pp_updatesubmissionerror'] = 'Une erreur est survenue dans le plugin du plagiat lors de la mise à jour de la transmission';
$string['ppassignmentcreateerror'] = 'Il est impossible de créer le module dans Turnitin, veuillez consulter le journal de votre API pour plus d’informations';
$string['ppassignmentediterror'] = 'Il est impossible de modifier le module {$a->title} (n° TII : {$a->assignmentid}) dans Turnitin, veuillez consulter le journal de votre API pour plus d’informations';
$string['print'] = 'Imprimer';
$string['privacy:metadata:turnitintooltwo_client:email'] = 'Le courriel de l’utilisateur est partagé par Moodle afin de rendre possible la création d’un compte Turnitin.';
$string['privacy:metadata:turnitintooltwo_client:firstname'] = 'Le prénom de l’utilisateur est envoyé à Turnitin pour que l’utilisateur puisse être identifié.';
$string['privacy:metadata:turnitintooltwo_client:lastname'] = 'Le nom de famille de l’utilisateur est envoyé à Turnitin pour que l’utilisateur puisse être identifié.';
$string['privacy:metadata:turnitintooltwo_client:submission_filename'] = 'Le nom du fichier déposé est envoyé à Turnitin afin d’être identifiable.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_attempts'] = 'Un horodatage indiquant quand l’utilisateur a vu les commentaires sur le devoir envoyé.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_filename'] = 'Le nom du fichier qui a été envoyé à Turnitin.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_modified'] = 'Un horodatage indiquant quand l’utilisateur a modifié pour la dernière fois le document remis.';
$string['privacy:metadata:turnitintooltwo_users:instructor_defaults'] = 'Les réglages par défaut de devoir de l’enseignant';
$string['privacy:metadata:turnitintooltwo_users:userid'] = 'L’identifiant de l’utilisateur lié au compte Turnitin.';
$string['proxypassword'] = 'Mot de passe du Proxy';
$string['proxypassword_desc'] = '<b>[Facultatif]</b><br />Si votre proxy vous demande une authentification, veuillez entrer le mot de passe ici.';
$string['proxyport'] = 'Port du Proxy';
$string['proxyport_desc'] = '<b>[Facultatif]</b><br />Si votre serveur utilise un proxy pour se connecter à Internet, veuillez entrer le port du proxy ici.';
$string['proxyurl'] = 'L’URL du Proxy';
$string['proxyurl_desc'] = '<b>[Facultatif]</b><br />Si votre serveur utilise un proxy pour se connecter à Internet, veuillez entrer l’adresse du proxy ici.';
$string['proxyuser'] = 'Nom d’utilisateur du Proxy';
$string['proxyuser_desc'] = '<b>[Facultatif]</b><br />Si votre proxy vous demande une authentification, veuillez entrer le nom d’utilisateur ici.';
$string['pseudoemailaddress'] = 'Pseudo adresse e-mail';
$string['pseudoemaildomain'] = 'Pseudo nom de domaine';
$string['pseudoemaildomain_desc'] = '<b>[Facultatif]</b><br />Un nom de domaine optionnel pour les pseudo adresses e-mail. (Si ce champ est vierge, le nom de domaine @tiimoodle.com est utilisé par défaut)';
$string['pseudoemailsalt'] = 'Pseudo salage de chiffrement';
$string['pseudoemailsalt_desc'] = '<b>[Facultatif]</b><br />Salage optionnel pour augmenter la complexité de la pseudo adresse e-mail de l’étudiant.<br />(<b>Remarque :</b> le salage doit rester inchangé pour garder une certaine cohérence au niveau des pseudo adresses e-mails)';
$string['pseudofirstname'] = 'Pseudo prénom de l’étudiant';
$string['pseudofirstname_desc'] = '<b>[Facultatif]</b><br />Prénom de l’étudiant qui s’affiche dans le Visualiseur de documents Turnitin';
$string['pseudolastname'] = 'Pseudo nom de famille de l’étudiant';
$string['pseudolastname_desc'] = 'Le nom de l´étudiant qui s´affiche dans le visualiseur de document Turnitin';
$string['pseudolastnamegen'] = 'Générer automatiquement le nom de famille';
$string['pseudolastnamegen_desc'] = 'Si ce paramètre est activé que le pseudo nom de famille est défini sur un champ de profil utilisateur, ce champ sera automatiquement rempli avec un identifiant unique.';
$string['receipt_instructor_copy'] = 'Un envoi intitulé <strong>{$a->submission_title}</strong> a été réalisé pour l’exercice <strong>{$a->assignment_name}{$a->assignment_part}</strong> dans le cours <strong>{$a->course_fullname}</strong>.<br /><br />Numéro d’envoi : <strong>{$a->submission_id}</strong><br />Date d’envoi : <strong>{$a->submission_date}</strong><br />';
$string['receipt_instructor_copy_subject'] = 'Envoi réalisé pour l’exercice';
$string['receiptassignmenttitle'] = 'Titre du document';
$string['receiptparagraph'] = 'Cet accusé de réception atteste que Turnitin a bien reçu votre copie. Vous trouverez ci-dessous des informations relatives à votre envoi.';
$string['recreatemulticlasses'] = 'Les cours que vous avez séléctionnés ont bien été recréés. En fonction du nombre de cours séléctionnés, cette opération peut prendre plusieurs minutes.';
$string['recreatemulticlassescomplete'] = 'Recréation de cours terminée. {$a->completed} sur {$a->total} créé(s) avec succès.';
$string['redirecttoeula'] = 'Vous allez être redirigé vers le contrat de licence d’utilisateur final de Turnitin';
$string['refid'] = 'N° de référence';
$string['relinkusers'] = 'Relier les utilisateurs';
$string['replaceassigndata'] = 'Modifier les informations de l’exercice Turnitin';
$string['reportgenspeed'] = 'Vitesse de traitement du rapport';
$string['reportgenspeed_help'] = 'Il existe 3 paramétrages possibles pour cet exercice : \'Générer les rapports immédiatement (les renvois ne sont pas autorisés)\', \'Générer les rapports immédiatement (les renvois sont autorisés jusqu’à la date limite)\' et \'Générer les rapports à la date limite (les renvois sont autorisés jusqu’à la date limite)\'<br /><br />L’option \'Générer les rapports immédiatement (les renvois ne sont pas autorisés)\' permettra de créer le rapport d’originalité dès que l’étudiant enverra son travail. Si cette option est activée, l’étudiant ne sera pas en mesure de renvoyer un nouveau travail vers le même exercice.<br /><br />Pour autoriser les renvois, vous devez choisir l’option \'Générer les rapports immédiatement (les renvois sont autorisés jusqu’à la date limite)\'. Cette option permet à l’étudiant d’envoyer indéfiniment sa copie pour l’exercice jusqu’à la date limite. Le temps de traitement du rapport d’originalité des renvois peut durer jusqu’à 24 h.<br /><br />L’option \'Générer les rapports à la date limite (les renvois sont autorisés jusqu’à la date limite)\' créera les rapports d’originalité uniquement à la date limite de l’exercice. Grâce à cette option, tous les travaux envoyés vers un exercice seront comparés les uns aux autres au moment de la création des rapports d’originalité.';
$string['repositoryoptions_0'] = 'Activer les options de base de données standard de l’enseignant';
$string['repositoryoptions_1'] = 'Activer les options de stockage élargies de l´enseignant';
$string['repositoryoptions_2'] = 'Soumettre tous les documents vers la base de données standard';
$string['repositoryoptions_3'] = 'Ne pas soumettre les documents dans une base de données';
$string['restorationheader'] = 'Restauration de cours Turnitin';
$string['resubmission'] = 'Renvoyer';
$string['resubmissiongradewarn'] = 'Vous pouvez soumettre des copies autant que vous le souhaitez jusqu’à la date limite de cet exercice. Toutes les annotations seront effacées si la copie est renvoyée. Voulez-vous continuer ?';
$string['resubmissiongradewarnaware'] = 'N´oubliez pas qu´en cas de re-soumission, toutes les annotations seront supprimées.';
$string['resubmit'] = 'Envoyer à nouveau';
$string['resubmitselected'] = 'Renvoyer les fichiers sélectionnés';
$string['resubmitting'] = 'Renvoi en cours';
$string['resubmittoturnitin'] = 'Renvoyer à Turnitin';
$string['reveal'] = 'Révéler';
$string['revealdesc'] = 'Veuillez indiquer ci-dessous un motif pour révéler le nom d&#39;un étudiant.';
$string['revealerror'] = 'Vous devez renseigner un motif valide pour révéler le nom d’un étudiant.';
$string['revealreason'] = 'Motif de révélation';
$string['savecourseenddate'] = 'Enregistrer la nouvelle date de fin du cours';
$string['savecourseenddateerror'] = 'Une erreur est survenue en tentant d’enregistrer la nouvelle date de fin du cours dans Turnitin';
$string['saveusage'] = 'Enregistrer le contenu de la base de données';
$string['searchcourses'] = 'Rechercher les cours';
$string['selectcourse'] = 'Sélectionner un cours Moodle';
$string['selectcoursecategory'] = 'Sélectionner la catégorie du cours';
$string['selectoption'] = 'Sélectionnez une option';
$string['semptytable'] = 'Aucun résultat trouvé';
$string['setinstructordefaults'] = 'Définir ces valeurs comme les valeurs par défaut de l&#39;exercice';
$string['setinstructordefaults_help'] = 'Ce paramètre sera utilisé pour tous les cas des exercices Turnitin Moodle Direct crées par vous. Ce réglage substituera le réglage par défaut spécifié par l&#39;administrateur du système et sera unique à vous.';
$string['settings'] = 'Paramètres';
$string['settingsinserterror'] = 'Une erreur est survenue en ajoutant un paramètre à la base de données';
$string['settingsupdateerror'] = 'Une erreur est survenue en actualisant un paramètre de la base de données';
$string['sharedrubric'] = 'Rubrique partagée';
$string['showpeermark'] = 'Afficher les exercices Peermark';
$string['showpeermarkinstructions'] = 'Afficher les instructions Peermark';
$string['showsummary'] = 'Montrer le résumé de l&#39;exercice';
$string['showusage'] = 'Affichez le contenu de la base de données';
$string['similarity'] = 'Similitude';
$string['sinfo'] = 'Montrer_TOTAL_des_entrées_du_DEBUT_à_la_FIN';
$string['slengthmenu'] = 'Montrer_Entrées_MENU';
$string['snext'] = 'Suivant';
$string['source'] = 'Source';
$string['spapercheck'] = 'Comparer avec la base de données documentaire des étudiants';
$string['spapercheck_help'] = 'Comparer avec la base de données documentaire des étudiants de Turnitin lors du traitement du Rapport de Similitude. Le pourcentage de similitude peut diminuer si cette option n&#39;est pas sélectionnée.';
$string['sprevious'] = 'Précédent';
$string['sprocessing'] = 'Chargement des données Turnitin en cours…';
$string['ssearch'] = 'Rechercher:';
$string['standardrepository'] = 'Base de données standard';
$string['startdatenotyearago'] = 'La date de début ne peut pas être il y a plus d’un an';
$string['student'] = 'Étudiant';
$string['student_notread'] = 'L&#39;étudiant n&#39;a pas consulté cette copie.';
$string['student_read'] = 'L’étudiant a consulté la copie le :';
$string['studentdataprivacy'] = 'Configuration de la confidentialité des données des étudiants';
$string['studentdataprivacy_desc'] = 'Les paramètres suivants peuvent être configurés pour s&#39;assurer que les données personnelles de l’étudiant ne sont pas transmises à Turnitin via l’API.';
$string['studentdisclosure'] = 'Accord de divulgation de l&#39;étudiant';
$string['studentdisclosure_help'] = 'Ce texte apparaîtra aux étudiants sur la page de chargement des fichiers';
$string['studentdisclosuredefault'] = 'L&#39;ensemble des fichiers envoyés seront soumis au service de détection du plagiat Turnitin.com';
$string['studentremoved'] = 'L&#39;étudiant a été supprimé du cours Turnitin';
$string['studentremovingerror'] = 'Un problème est survenu en supprimant l&#39;étudiant du cours Turnitin.';
$string['studentreports'] = 'Montrer les Rapports de Similitude aux étudiants';
$string['studentreports_help'] = 'Cette option vous permet d’autoriser les étudiants à voir leur Rapport de Similitude. En sélectionnant Oui, le rapport d’analyse généré par Turnitin sera disponible pour les étudiants.';
$string['studentstatus'] = 'Envoyé {$a->modified} (n° d’enregistrement de la copie : {$a->objectid})';
$string['submissionagreementerror'] = 'Vous devez accepter cet accord pour envoyer ce document';
$string['submissionauthor'] = 'Auteur de l´envoi';
$string['submissiondate'] = 'Date de l’envoi';
$string['submissiondeleted'] = 'Transmission supprimée';
$string['submissiondeleteerror'] = 'Impossible de supprimer les envois';
$string['submissionextract'] = 'Extrait de l´envoi';
$string['submissionfileerror'] = 'Vous devez attacher un fichier à votre transmission';
$string['submissionfiletypeerror'] = 'Ce type de fichier n’est pas accepté. Les types de fichiers acceptés sont les suivants ({$a})';
$string['submissiongeterror'] = 'Impossible d’obtenir les informations d’envoi';
$string['submissiongrade'] = 'Note';
$string['submissionorig'] = 'Similitude';
$string['submissionpart'] = 'Partie de la transmission';
$string['submissionpart_help'] = 'Sélectionnez la partie de l’exercice Turnitin à associer avec l’envoi de ce document.';
$string['submissions'] = 'Transmissions';
$string['submissiontexterror'] = 'Vous devez inclure un texte pour cette transmission';
$string['submissiontitle'] = 'Titre de l’envoi';
$string['submissiontitle_help'] = 'Entrez le titre de l’envoi pour le travail que vous transmettez';
$string['submissiontitleerror'] = 'Vous de devez inclure un titre pour cette transmission';
$string['submissiontype'] = 'Méthode d’envoi';
$string['submissiontype_help'] = '<p>Indique les modes d’envoi qui peuvent être adressés à Turnitin.</p>';
$string['submissionupdateerror'] = 'Impossible d’actualiser les informations de l’envoi';
$string['submissionuploadsuccess'] = 'Votre soumission a été envoyée vers Turnitin avec succès.';
$string['submitnothing'] = 'Activer l’évaluation pour cet étudiant qui n’a pas envoyé de copie';
$string['submitnothingwarning'] = 'En cliquant sur le crayon gris d&#39;un étudiant qui n’a pas envoyé de fichier, vous verrez apparaître un modèle d’évaluation qui vous permettra de lui laisser des commentaires GradeMark sur cet exercice. Le modèle d’évaluation remplace l’envoi d’un document et empêche l’étudiant de renvoyer un document si les renvois ne sont pas autorisés.<br><br>Voulez-vous vraiment évaluer sans envoi ?';
$string['submitondraft'] = 'Soumettre le document une fois qu&#39;il est chargé';
$string['submitonfinal'] = 'Soumettre le document lorsque l&#39;étudiant l&#39;envoie pour l&#39;évaluation';
$string['submitpaper'] = 'Envoyer une copie';
$string['submitpapersto'] = 'Conserver les travaux des étudiants';
$string['submitpapersto_help'] = 'Cette option permet aux enseignants de choisir de conserver les travaux des étudiants dans la base de données documentaire des étudiants de Turnitin. L’avantage d’un tel choix de stockage est que les travaux soumis à un exercice seront comparés avec l’ensemble des autres copies envoyées par les étudiants pour vos cours actuels et passés. Si vous sélectionnez "Aucune base de données", les travaux de vos étudiants ne seront pas conservés dans la base de données documentaire des étudiants.';
$string['submitted'] = 'Envoyé';
$string['submittoturnitin'] = 'Envoyer à Turnitin';
$string['szerorecords'] = 'Il n´y a aucun document à afficher';
$string['task_name'] = 'Tâche cron Turnitintooltwo';
$string['testingconnection'] = 'Tentatative de connection à Turnitin';
$string['textsubmission'] = 'Envoyer un texte';
$string['texttosubmit'] = 'Texte à soumettre';
$string['texttosubmit_help'] = 'Copiez puis collez le texte de votre document dans cette zone de texte';
$string['tii_submission_failure'] = 'Veuillez consulter votre tuteur ou l’administrateur Moodle pour plus de détails';
$string['tiiaccountconfig'] = 'Configuration de compte Turnitin';
$string['tiiaccountsettings'] = 'Paramètres de compte Turnitin';
$string['tiiaccountsettings_desc'] = 'Veuillez vous assurer que ces paramètres correspondent à ceux configurés dans votre compte Turnitin. Sinon, vous pourriez rencontrer des difficultés lors de la création d’exercices et/ou pour les copies envoyées par les étudiants.';
$string['tiiassignmentgeterror'] = 'Une erreur est survenue en essayant d&#39;obtenir un exercice Turnitin';
$string['tiidebugginglogs'] = 'Dégogage et journalisation';
$string['tiiexplain'] = 'Turnitin est un produit commercial ; pour utiliser ce service, vous devez l’acheter. Pour plus d’informations, veuillez consulter la page <a href=http://docs.moodle.org/en/Turnitin_administration>http://docs.moodle.org/en/Turnitin_administration</a>';
$string['tiimiscsettings'] = 'Paramètres de pluging divers';
$string['tiisubmissiongeterror'] = 'Une erreur est survenue en tentant d&#39;obtenir une transmission de Turnitin';
$string['tiisubmissionsgeterror'] = 'Une erreur est survenue en essayant d&#39;obtenir les travaux envoyés pour cet exercice de Turnitin';
$string['tiiusergeterror'] = 'Une erreur est survenue en essayant d´obtenir les détails de l´utilisateur Turnitin';
$string['title'] = 'Titre';
$string['transmatch'] = 'Traducteur de Similitude';
$string['transmatch_desc'] = 'Détermine si le Traducteur de Similitude peut être activé sur l’écran de configuration de l’exercice.<br /><i>(Utilisez cette option uniquement si le Traducteur de Similitude est activé dans votre compte Turnitin)</i>';
$string['turnitin'] = 'Turnitin';
$string['turnitinaccountid'] = 'Numéro de compte Turnitin';
$string['turnitinaccountid_desc'] = '<b>[Nécessaire]</b><br />Entrez le numéro du compte principal Turnitin';
$string['turnitinanon'] = 'Annotation anonyme';
$string['turnitinanon_help'] = 'Vous pouvez configurer votre exercice Turnitin de façon à utiliser les annotations anonymes en réglant cette valeur sur Oui. Quand un envoi a été rendu anonyme, les annotations anonymes ne peuvent plus être désactivées.';
$string['turnitinapiurl'] = 'L’URL de L’API Turnitin';
$string['turnitinapiurl_desc'] = '<b>[Nécessaire]</b><br />Choisissez une URL pour l’API Turnitin';
$string['turnitinconfig'] = 'Configuration du plugin de plagiat Turnitin';
$string['turnitindefaults'] = 'Paramètres par défaut du plugin de plagiat Turnitin';
$string['turnitindeleteconfirm'] = 'La suppression des copies les efface de votre boite de réception et de votre liste des copies soumises mais ne les supprime pas complètement de la base de données.\\n\\nVoulez-vous vraiment supprimer ce travail ? Cette opération ne peut pas être annulée.';
$string['turnitindeletionerror'] = 'La suppression de la soumission a échouée. La copie locale de Moodle a été supprimée mais pas la transmission à Turnitin.';
$string['turnitindiagnostic'] = 'Activer le mode diagnostique';
$string['turnitindiagnostic_desc'] = '<b>[Attention]</b><br />Le mode Diagnostic ne doit être activé que pour détecter des problèmes liés à l’API de Turnitin.';
$string['turnitinenablepeermark'] = 'Activer les exercice Peermark';
$string['turnitinenablepeermark_desc'] = 'Choisissez d’autoriser ou non la création d’exercices Peermark.<br/><i>(Disponible uniquement pour ceux ayant Peermark configuré pour leur compte)</i>';
$string['turnitinenrolstudents'] = 'Inscrire tous les étudiants';
$string['turnitingmoptions'] = 'Options de GradeMark';
$string['turnitinhelpdesk'] = 'Centre d’assistance Turnitin';
$string['turnitinid'] = 'N° Turnitin';
$string['turnitinloading'] = 'Synchroniser les informations';
$string['turnitinoroptions'] = 'Options du Rapport de Similitude';
$string['turnitinpaperid'] = 'N° de document Turnitin';
$string['turnitinpart'] = 'Partie {$a}';
$string['turnitinpluginsettings'] = 'Paramètres du plugin de plagiat Turnitin';
$string['turnitinppulapost'] = 'Votre fichier n’a pas été renvoyé à Turnitin. Veuillez cliquer ici pour accepter notre CLUF.';
$string['turnitinppulapre'] = 'Pour envoyer un fichier à Turnitin, vous devez d’abord accepter notre CLUF. Si vous ne l’acceptez pas, votre fichier ne sera envoyé qu’à Moodle. Cliquez ici pour accepter.';
$string['turnitinrefreshingsubmissions'] = 'Rafraichir les soumissions';
$string['turnitinrefreshsubmissions'] = 'Actualiser les envois';
$string['turnitinrepositoryoptions'] = 'Base de Données Documentaire';
$string['turnitinrepositoryoptions_desc'] = 'Choisissez l’option de stockage des exercices Turnitin.<br /><i>(Vous ne pouvez choisir la base de données de l’établissement que si celle-ci est disponible pour le compte)</i>';
$string['turnitinrepositoryoptions_help'] = 'Utilisez ce paramètre pour modifier les options de base de données disponibles dans l’écran de configuration de l’exercice.<br /><i>(Vous ne pouvez choisir la base de données de l’établissement que si celle-ci est disponible pour le compte)</i>';
$string['turnitinsecretkey'] = 'Clé Partagée Turnitin';
$string['turnitinsecretkey_desc'] = '<b>[Nécessaire]</b><br />Entrez votre clé partagée Turnitin<br /><i>(définie par votre administrateur Turnitin)</i>';
$string['turnitinsettingshelpwizard'] = 'Activer le centre d’assistance Turnitin pour les enseignants';
$string['turnitinsettingshelpwizard_desc'] = 'Choisissez si les enseignants peuvent accéder ou non au centre d’assistance Turnitin depuis Moodle.';
$string['turnitinstatus'] = 'Statut de Turnitin';
$string['turnitinstudents'] = 'Étudiant Turnitin';
$string['turnitinstudents_desc'] = 'Les utilisateurs sélectionnés ci-dessous sont inscrits à ce cours Turnitin. Les étudiants inscrits peuvent accéder au cours en se connectant au site Internet de Turnitin';
$string['turnitinstudentsremove'] = 'Voulez-vous vraiment supprimer cet étudiant du cours Turnitin ?';
$string['turnitinsubmissionid'] = 'N° de transmission Turnitin';
$string['turnitintoolofflineerror'] = 'Un problème temporaire est survenu. Merci de réessayer.';
$string['turnitintooltwo'] = 'Outil Turnitin';
$string['turnitintooltwo:addinstance'] = 'Ajouter des outils Turnitin';
$string['turnitintooltwo:admin'] = 'Gestion de l’Outil Turnitin';
$string['turnitintooltwo:grade'] = 'Evaluer les exercices de l´outil Turnitin.';
$string['turnitintooltwo:read'] = 'Lire les exercices de l´outil Turnitin';
$string['turnitintooltwo:submit'] = 'Transmettre aux exercices de l’outil Turnitin';
$string['turnitintooltwo:view'] = 'Afficher les exercices de l´outil Turnitin';
$string['turnitintooltwoadministration'] = 'Administration de l&#39;exercice 2 de Turnitin';
$string['turnitintooltwoagreement'] = 'Déclaration légale/ Accord';
$string['turnitintooltwoagreement_default'] = 'En cochant cette case je confirme que la copie que je transmets est la mienne et j’accepte toutes responsabilités concernant la violation des droits d’auteurs qui pourrait se produire suite à l’envoi de ce document.';
$string['turnitintooltwoagreement_desc'] = '<b>[Facultatif]</b><br />Merci d’introduire l’accord de confirmation des envois.<br />(<b>Remarque :</b> si le champ de l’accord reste vierge, aucune confirmation ne sera demandée aux étudiants lors de leur envoi)';
$string['turnitintooltwodeleteerror'] = 'Impossible de supprimer les données de Turnitintooltwo';
$string['turnitintooltwogeterror'] = 'Impossible d&#39;obtenir les données de Turnitintooltwo';
$string['turnitintooltwointro'] = 'Sommaire';
$string['turnitintooltwoname'] = 'Titre de l’exercice Turnitin';
$string['turnitintooltworesetdata0'] = 'Copier les exercices Turnitin <i>(Créer des duplicata, Nouveau cours Turnitin)</i>';
$string['turnitintooltworesetdata1'] = 'Remplacer les exercices Turnitin <i>(Remplacer les parties de l’exercice, Réutiliser le cours Turnitin)</i>';
$string['turnitintooltworesetdata2'] = 'Laisser les exercices Turnitin intactes';
$string['turnitintooltworesetinfo'] = 'Choisir une des options ci-dessous pour l&#39;Exercice Turnitin de ce cours';
$string['turnitintooltwoupdateerror'] = 'Impossible de mettre à jour les données de Turnitintooltwo';
$string['turnitintutors'] = 'Tuteurs Turnitin';
$string['turnitintutors_desc'] = 'Les tuteurs sélectionnés ci-dessous sont inscrits comme tuteurs pour ce cours. Les tuteurs inscrits peuvent avoir accès à ce cours en se connectant sur leur session sur le site Internet de Turnitin.';
$string['turnitintutorsadd'] = 'Ajouter un tuteur Turnitin';
$string['turnitintutorsallenrolled'] = 'Tous les tuteurs sont inscrits dans Turnitin';
$string['turnitintutorsremove'] = 'Voulez-vous vraiment supprimer ce tuteur du cours Turnitin ?';
$string['turnitinula'] = 'Vous devez accepter les dernières conditions d´utilisation avant de soumettre un document.';
$string['turnitinula_btn'] = 'Veuillez cliquer ici pour lire et accepter les conditions d´utilisation.';
$string['turnitinuseanon'] = 'Utilisez les annotations anonymes';
$string['turnitinuseanon_desc'] = 'Choisissez d’autoriser ou non les annotations anonymes pendant l’évaluation des envois.<br /><i>(Disponible uniquement pour ceux ayant configuré les annotations anonymes dans leur compte)</i>';
$string['turnitinusegrademark'] = 'Utiliser GradeMark';
$string['turnitinusegrademark_desc'] = 'Choisissez d’utiliser ou non GradeMark pour l’évaluation des envois.<br /><i>(Disponible uniquement pour ceux ayant configuré GradeMark dans leur compte)</i>';
$string['turnitinusegrademark_help'] = 'Ce paramètre permet de choisir entre GradeMark et Moodle pour l’évaluation des travaux.';
$string['turnitinuserepository'] = 'Utiliser la base de données de l’établissement';
$string['turnitinuserepository_desc'] = 'Choisissez d’autoriser ou non l’utilisation des bases de données de l’établissement dans les exercices Turnitin.<br /><i>(Disponible uniquement pour ceux qui ont la base de données de l’établissement autorisée sur leur compte)</i>';
$string['turnitinuserepository_help'] = 'Utilisez ce paramètre pour activer la base de données de l’établissement sur l’écran de configuration de l’exercice.<br /><i>(Disponible uniquement pour ceux disposant d’une base de données de l’établissement activée dans leur compte)</i>';
$string['tutoradded'] = 'Le tuteur vient d´être ajouté au cours Turnitin';
$string['tutoraddingerror'] = 'Une erreur est survenue en ajoutant le tuteur au cours Turnitin';
$string['tutorremoved'] = 'Le tuteur vient d´être supprimé du cours Turnitin';
$string['tutorremovingerror'] = 'Une erreur est survenue en supprimant le tuteur du cours Turnitin';
$string['tutorstatus'] = '{$a->submitted}/{$a->total} copies envoyées par les étudiants, {$a->graded} copie{$a->gplural} notée(s)';
$string['type'] = 'Mode d’envoi';
$string['types'] = 'Méthode d’envoi';
$string['types_help'] = '<p>Les envois peuvent être réalisés de 2 manières différentes : par copier-coller ou par chargement de fichier.</p>';
$string['unanonymiseerror'] = 'Une erreur est survenue en révélant le nom d&#39;un étudiant';
$string['uniquepartname'] = 'Le nom de la partie doit être unique';
$string['unlinkedusers'] = 'Utilisateurs dissociés';
$string['unlinkrelinkusers'] = 'Dissocier/ Relier les utilisateurs Turnitin';
$string['unlinkusers'] = 'Dissocier les utilisateurs';
$string['updatepart'] = 'Actualiser la partie';
$string['updatesubmissionerror'] = 'Une erreur est survenue en essayant de renvoyer votre document à Turnitin';
$string['upgradeavailable'] = 'Actualisation disponible';
$string['upgradenotavailable'] = 'Aucune mise à jour n´est disponible';
$string['uploadingsubtoturnitin'] = 'Envoyer votre travail à Turnitin';
$string['user'] = 'Utilisateur';
$string['usercreationerror'] = 'La création du profil utilisateur Turnitin a échouée';
$string['userdeleteerror'] = 'Impossible de supprimer les données de l’utilisateur';
$string['userfinderror'] = 'Une erreur est survenue en cherchant l´utilisateur Turnitin';
$string['usergeterror'] = 'Impossible de trouver les données de l’utilisateur';
$string['userjoinerror'] = 'Une erreur est survenue en essayant de joindre un utilisateur à un cours Turnitin';
$string['userremoveerror'] = 'Une erreur est survenue en essayant de supprimer un utilisateur d´un cours Turnitin';
$string['userstounlink'] = 'Utilisateurs devant être dissociés';
$string['usersunlinkrelink'] = 'Utilisateurs à dissocier / relier';
$string['userupdateerror'] = 'Impossible d&#39;actualiser les informations de l’utilisateur';
$string['useturnitin'] = 'Activer Turnitin';
$string['useturnitin_mod'] = 'Activer Turnitin pour {$a}';
$string['usinglatest'] = 'Vous utilisez la dernière version !';
$string['v1assignmentsdeleted'] = 'Les devoirs ont bien été supprimés';
$string['viewdigitalreceipt'] = 'Afficher l’accusé de réception électronique';
$string['viewreport'] = 'Afficher le Rapport';
$string['viewsubmission'] = 'Voir le document';
$string['viewsubmissiondesc'] = 'L´utilisateur a vu l´envoi';
$string['wrongaccountid'] = 'Une erreur est survenue pendant la création d’un lien vers votre cours Turnitin. Le compte que vous avez configuré est {$a->current}. Ce cours vient du compte {$a->backupid}. Vous pouvez seulement restaurer les cours venant du même compte Turnitin.';
$string['yes'] = 'Oui';
$string['yesgrades'] = 'Oui, actualiser automatiquement les scores d’originalité et les notes';
