<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'ar', version '4.5'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'الإجراء';
$string['activityoverview'] = 'لديك استبيانات مستحقة';
$string['additionalinfo'] = 'معلومات إضافية';
$string['additionalinfo_help'] = 'النص الذي سيتم عرضه في الجزء العلوي من الصفحة الأولى لهذا الاستبيان. (أي التعليمات، معلومات الخلفية، وما إلى ذلك).';
$string['addnewquestion'] = 'إضافة {$a} سؤال';
$string['addnewsection'] = 'إضافة قسم جديد';
$string['addquestion'] = 'إضافة سؤال...';
$string['addquestions'] = 'إضافة الأسئلة';
$string['addquestiontosection'] = 'إضافة السؤال إلى القسم';
$string['addselqtype'] = 'إضافة سؤال بالنوع المحدد';
$string['alignment'] = 'محاذاة أزرار الراديو';
$string['alignment_help'] = 'حدد محاذاة الأزرار: عمودي (الافتراضي) أو أفقي.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'الكل';
$string['allnameddegrees'] = 'الدرجات المسمّاة';
$string['allnameddegrees_help'] = 'حدد نصاً لعرضه لقيم التقييم بدلاً من الرقم. اترك القيمة فارغة لعدم استعمالها.';
$string['alreadyfilled'] = 'لقد قمت بالفعل بملء هذا الاستبيان بالنسبة لنا {$a}. شكراً لكم.';
$string['andaveragevalues'] = 'والقيم المتوسطة';
$string['anonymous'] = 'مجهول';
$string['answer'] = 'الإجابة';
$string['answergiven'] = 'هذه الإجابة المقدمة';
$string['answernotgiven'] = 'هذا الجواب لم يعط';
$string['answerquestions'] = 'أجب عن هذا الاستبيان...';
$string['answers'] = 'الأجوبة';
$string['attempted'] = 'تم تقديم هذا الاستبيان.';
$string['attemptstillinprogress'] = 'قيد التفيذ. تم الحفظ في:';
$string['autonumbering'] = 'ترقيم تلقائي';
$string['autonumbering_help'] = 'الترقيم التلقائي للأسئلة والصفحات. قد ترغب في تعطيل الترقيم التلقائي للاستبيانات ذات التفرع الشرطي.';
$string['autonumberno'] = 'لا ترقم الأسئلة أو الصفحات';
$string['autonumberpages'] = 'ترقيم الصفحات آلياً';
$string['autonumberpagesandquestions'] = 'ترقيم الصفحات والأسئلة آلياً';
$string['autonumberquestions'] = 'ترقيم الأسئلة آلياً';
$string['average'] = 'المتوسط';
$string['averageposition'] = 'موقع المتوسط';
$string['averagerank'] = 'رتبة المتوسط';
$string['averagesrow'] = 'المتوسطات (حيثما وجدت):';
$string['bodytext'] = 'نص المتن';
$string['boxesnbexact'] = 'بالضبط {$a} مربع(ات).';
$string['boxesnbmax'] = 'بحد أقصى {$a} مربع(ات).';
$string['boxesnbmin'] = 'ما لا يقل عن {$a} مربع(ات).';
$string['boxesnbreq'] = 'لهذا السؤال ينبغي عليك التأشير';
$string['by'] = 'بواسطة';
$string['cannotviewpublicresponses'] = 'لا يمكنك مشاهدة الردود على هذا الاستبيان العام.';
$string['chart:bipolar'] = 'أشرطة ثنائية';
$string['chart:hbar'] = 'أشرطة أفقية';
$string['chart:radar'] = 'الرادار';
$string['chart:rose'] = 'بشكل وردة';
$string['chart:type'] = 'نوع الرسم البياني';
$string['chart:type_help'] = 'حدد نوع الرسم البياني الذي تريد استعماله لهذه الإفادة';
$string['chart:vprogress'] = 'شريط التقدم العمودي';
$string['checkallradiobuttons'] = 'يرجى التحقق من أزرار الاختيار <strong>{$a}</strong>!';
$string['checkboxes'] = 'مربعات اختيار';
$string['checkboxes_help'] = 'أدخل خياراً واحداً في كل سطر للمستخدم ليختار منها إجابة واحدة أو أكثر.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'فاصل (فواصل) صفحة جديدة مدرجة في الموضع (المواضع):';
$string['checkbreaksok'] = 'جميع فواصل الصفحات المطلوبة موجودة!';
$string['checkbreaksremoved'] = 'تمت إزالة {$a} من فواصل الصفحات الإضافية.';
$string['checknotstarted'] = 'حدد التي لم تبدأ';
$string['checkstarted'] = 'إختر التي بدأت';
$string['clicktoswitch'] = '(انقر للتبديل)';
$string['closebeforeopen'] = 'لقد جعلت تاريخ الإغلاق قبل تاريخ الفتح.';
$string['closed'] = 'تم إغلاق الاستبيان في {$a}. شكراً.';
$string['closedate'] = 'إسمح بالاستجابات حتى';
$string['closeson'] = 'يغلق الاستبيان في {$a}';
$string['completionsubmit'] = 'يجب على الطالب/ ة تعبئة الاستبانة من أجل اكمال النشاط';
$string['condition'] = 'الشرط';
$string['confalts'] = '- أو -
صفحة التأكيد';
$string['configemailreporting'] = 'السماح بالتقارير عبر البريد الالكتروني';
$string['configemailreportinglong'] = 'يسمح بإرسال خيارات بعض التقارير مباشرة إلى عناوين بريد الكتروني معينة.';
$string['configmaxsections'] = 'أقسام ردود الفعل القصوى';
$string['configusergraph'] = 'عرض مخططات الإفادة لـ "اختبار الشخصية"';
$string['configusergraphlong'] = 'استعمال مكتبة <a href="http://www.rgraph.net/">Rgraph</a> لعرض مخططات الإفادة لـ "اختبار الشخصية".';
$string['confirmdelallresp'] = 'هل أنت متأكد من أنك تريد حذف جميع الردود في هذا الاستبيان؟';
$string['confirmdelchildren'] = 'إذا حذفت هذا السؤال، فسيتم أيضاً حذف السؤال (الأسئلة) التابعة:';
$string['confirmdeletesection'] = 'هل تريد بالتأكيد حذف قسم الإفادة "{$a}"؟';
$string['confirmdelgroupresp'] = 'هل أنت متأكد من أنك تريد حذف جميع ردود {$a}؟';
$string['confirmdelquestion'] = 'هل أنت متأكد من أنك تريد حذف السؤال في الموضع {$a}؟';
$string['confirmdelquestionresps'] = 'سيؤدي هذا أيضاً إلى حذف {$a} من الرد (الاستجابات) المقدَّمة بالفعل إلى هذا السؤال.';
$string['confirmdelresp'] = 'هل أنت متأكد من أنك تريد حذف الاستجابة عند {$a} ؟';
$string['confirmremovequestion'] = 'هل تريد بالتأكيد إزالة السؤال "{$a->qname}" من المقطع"{$a->sname}"؟';
$string['confpage'] = 'نص العنوان';
$string['confpage_help'] = 'العنوان (بالخط الغامق) والنص الأساسي لصفحة "التأكيد" المعروضة بعد أن يكمل المستخدم هذا الاستبيان.
(الرابط، إذا كان موجوداً، له الأسبقية على نص التأكيد). إذا تركت هذا الحقل فارغاً، سيتم عرض الرسالة الافتراضية عند الانتهاء من الاستبيان (شكراً لك على إكمال هذا الاستبيان).';
$string['confpagedesc'] = 'العنوان (بالخط الغامق) والنص الأساسي لصفحة "التأكيد" المعروضة بعد أن يكمل المستخدم هذا الاستبيان.
(الرابط، إن وجد، له الأسبقية على نص التأكيد).';
$string['contentoptions'] = 'خيارات المحتوى';
$string['couldnotcreatenewsurvey'] = 'لا يمكن إنشاء استبيان جديد!';
$string['couldnotdelresp'] = 'لا يمكن حذف الرد';
$string['createcontent'] = 'تحديد محتوى جديد';
$string['createcontent_help'] = 'حدد أحد خيارات زر الاختيار. "إنشاء جديد" هو الافتراضي.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'إنشاء جديد';
$string['crontask'] = 'وظيفة تنظيف الاستبيان';
$string['date'] = 'التاريخ';
$string['date_help'] = 'استخدم نوع السؤال هذا إذا كنت تتوقع أن يكون الرد تاريخاً منسقاً بشكل صحيح.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'استعمال التنسيق سنة-شهر-يوم، على سبيل المثال ليوم 4 مارس 1945:  <strong>1945-03-04</strong>';
$string['deleteallresponses'] = 'حذف جميع الردود';
$string['deletecurrentquestion'] = 'حذف السؤال {$a}';
$string['deletedallgroupresp'] = 'تم حذف جميع الردود في المجموعة {$a}';
$string['deletedallresp'] = 'تم حذف ردود الاستبيان';
$string['deletedisabled'] = 'لا يمكن حذف هذا العنصر';
$string['deletedresp'] = 'استجابة محذوفة';
$string['deleteresp'] = 'إحذف هذا الرد';
$string['deletesection'] = 'إحذف هذا القسم';
$string['deletingresp'] = 'حذف الاستجابة';
$string['dependencies'] = 'التبعيات';
$string['dependquestion'] = 'السؤال الأعلى رتبة';
$string['dependquestion_help'] = 'يمكنك تحديد السؤال الأعلى رتبة والخيارات لهذا السؤال.
سيتم عرض سؤال تابع للطالب فقط إذا كان قد تم اختيار السؤال الأعلى رتبة مع الخيار المؤدي إليه مسبقاً.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'لم تجب على هذا السؤال';
$string['directwarnings'] = 'ستتم إزالة التبعيات المباشرة لهذا السؤال. سيؤثر هذا على:';
$string['displaymethod'] = 'طريقة العرض غير محددة للسؤال.';
$string['download'] = 'التنزيل';
$string['downloadpdf'] = 'التنزيل بصيغة PDF';
$string['downloadtextformat'] = 'التنزيل';
$string['downloadtextformat_help'] = 'تتيح لك هذه الميزة حفظ جميع استجابات الاستبيان إلى ملف نصي (CSV). يمكن بعد ذلك استيراد هذا الملف إلى جدول بيانات (مثل MS Excel أو Open Office Calc) أو حزمة إحصائية لمزيد من معالجة البيانات فضلاً عن إرسال الملف تلقائياً إلى مستخدمين منتخبين.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'نوع التقرير';
$string['dropdown'] = 'قائمة منسدلة';
$string['dropdown_help'] = 'لا توجد ميزة حقيقية لاستعمال مربع القائمة المنسدلة على استعمال أزرار الاختيار.. باستثناء ربما لقوائم الخيارات الطويلة، لتوفير مساحة الشاشة.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'تحرير';
$string['editingfeedback'] = 'تحرير إعدادات ردود الأفعال';
$string['editingquestionnaire'] = 'تحرير إعدادات الاستبيان';
$string['editquestion'] = 'تحرير السؤال {$a}';
$string['email'] = 'البريد الإلكتروني';
$string['emailextra'] = 'إرسال التنزيل إلى العناوين البريدية';
$string['emailextra_help'] = 'سيتم إرسال الملف المنزل إلى عناوين البريد الالكتروني المدرجة، والمفصولة بفوارز. لاحظ أنه لا يتم إجراء أي فحوص أمان أو فحوص للخصوصية. للتوصل إلى ذلك، ينبغي تمكين \'allowemailreporting\' في إعدادات الوحدة.';
$string['emailroles'] = 'إرسال التنزيل إلى الأدوار';
$string['emailroles_help'] = 'سيتم إرسال الملف المنزل إلى كل الأدوار التي تمتلك الإمكانية "mod/questionnaire:submissionnotification" عبر البريد الالكتروني. لاحظ أنه لا يتم إجراء أي فحوص أمان أو فحوص للخصوصية. للتوصل إلى ذلك، ينبغي تمكين \'allowemailreporting\' في إعدادات الوحدة.';
$string['emailsend'] = 'إرسال التقارير';
$string['emailsnotspecified'] = 'لم يتم تحديد أي عنوان بريد الكتروني.';
$string['emailssent'] = 'التنزيلات المرسلة إلى عناوين بريد الكتروني معينة.';
$string['errnewname'] = 'عذراً، الاسم مستعمل سلفاً. إنتقِ اسماً آخر.';
$string['erroropening'] = 'خطأ في فتح الاستبيان.';
$string['errortable'] = 'خطأ في النظام، جدول تالف.';
$string['essaybox'] = 'مربع المقالة';
$string['essaybox_help'] = 'سيعرض هذا السؤال مربع نص عادي مع س من أعمدة مناطق النص (أو عرض المنطقة) و ص من صفوف مناطق النص (عدد أسطر النص).

إذا تركت كل من س و ص على القيمة الافتراضية لهما والبالغة 0 (أو إذا قمت بتعيينها على 0)، فسيتم عرض محرر HTML الخاص بمودل بالطول والعرض القياسيين (إذا كان ذلك متاحاً في سياق المساق/المستخدم والملف الشخصي للمستخدم).';
$string['event_all_responses_deleted'] = 'كل الردود تم حذفها';
$string['event_all_responses_saved_as_text'] = 'كل الردود تم حفظها كنص';
$string['event_all_responses_viewed'] = 'تقرير كل الردود تمت معاينته';
$string['event_individual_responses_viewed'] = 'تقرير ردود فردية تمت معاينته';
$string['event_non_respondents_viewed'] = 'تقرير غير المستجيبين تمت معاينته';
$string['event_previewed'] = 'استبيان تم استعراضه';
$string['event_question_created'] = 'سؤال تم إنشاؤه';
$string['event_question_deleted'] = 'سؤال تم حذفه';
$string['event_response_deleted'] = 'رد فردي تم حذفه';
$string['event_resumed'] = 'محاولة تم استئنافها';
$string['event_saved'] = 'ردود تم حفظها';
$string['event_submitted'] = 'ردود تم تقديمها';
$string['feedback'] = 'الإفادة';
$string['feedback_help'] = 'مساعدة عن الإفادة';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'إضافة {no} حقول لإفادات أخرى';
$string['feedbackbysection'] = 'إفادات المقاطع';
$string['feedbackdefaultlabel'] = '[قسم جديد]';
$string['feedbackeditingglobal'] = 'تحرير الإفادة الشاملة للاستبيان';
$string['feedbackeditingmessages'] = 'تحرير رسائل إفادات الاستبيان';
$string['feedbackeditingsections'] = 'تحرير مقاطع إفادات الاستبيان';
$string['feedbackeditmessages'] = 'حفظ إعدادات المقاطع وتعديل رسائل الإفادات';
$string['feedbackeditsections'] = 'حفظ الإعدادات وتعديل مقاطع الإفادات';
$string['feedbackerrorboundaryformat'] = 'يجب أن تكون حدود نقاط الإفادة إما مئوية أو رقماً. لم يتم التعرف على القيمة التي أدخلتها في الحدود {$a}.';
$string['feedbackerrorboundaryoutofrange'] = 'يجب أن تتراوح حدود نقاط الإفادة بين 0٪ و 100٪. القيمة التي أدخلتها في الحدود {$a} خارج النطاق.';
$string['feedbackerrorjunkinboundary'] = 'يجب عليك ملء مربعات حدود نقاط الإفادة دون ترك أيّ ثغرات.';
$string['feedbackerrorjunkinfeedback'] = 'يجب ملء مربعات الإفادات دون ترك أيّ ثغرات.';
$string['feedbackerrororder'] = 'يجب أن تكون حدود نقاط الإفادة بالترتيب بدءاً من الأعلى. القيمة التي أدخلتها في الحد {$a} غير متسلسلة.';
$string['feedbackglobal'] = 'الإفادة الشاملة';
$string['feedbackglobalheading'] = 'عنوان الإفادة الشاملة';
$string['feedbackglobalmessages'] = 'رسائل الإفادة الشاملة';
$string['feedbackhdr'] = 'الإفادات';
$string['feedbackheading'] = 'عنوان الإفادة';
$string['feedbackheading_help'] = 'في حقل عنوان الإفادة، يمكنك استعمال متغيرين هما: $scorepercent و $oppositescorepercent.';
$string['feedbackmessages'] = 'رسائل القسم {$a}';
$string['feedbacknextsection'] = '{$a} القسم التالي';
$string['feedbacknone'] = 'لا توجد رسائل الإفادة';
$string['feedbacknotes'] = 'ملاحظات الإفادة';
$string['feedbacknotes_help'] = 'سيتم عرض النص المدخل هنا على المشاركين في نهاية تقرير الإفادة الخاص بهم';
$string['feedbackoptions'] = 'خيارات الإفادة';
$string['feedbackoptions_help'] = 'تتوفر خيارات الإفادة إذا كان الاستبيان الخاص بك يحتوي على أنواع إعدادات الأسئلة:
أزرار الراديو؛ القائمة المنسدلة؛ صح/خطأ؛ أو أسئلة Rate (مقياس عادي أو مقياس Osgood). يجب تعيين هذه الأسئلة على أنها مطلوبة، ويجب ألا يكون حقل اسم السؤال فارغاً ويجب أن تحتوي خيارات الإجابات المحتملة على قيمة.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'هذا السؤال جزء من قسم الإفادة [{$a}]';
$string['feedbackremovesection'] = 'ستؤدي إزالة هذا السؤال إلى إزالة قسم الإفادة [{$a}] تماماً';
$string['feedbackreport'] = 'تقرير الإفادة';
$string['feedbackscore'] = 'نقاط الإفادة';
$string['feedbackscoreboundary'] = 'حدود نقاط الإفادة';
$string['feedbackscores'] = 'عرض النقاط';
$string['feedbackscores_help'] = 'عرض جدول نقاط الإفادة';
$string['feedbacksection'] = 'القسم';
$string['feedbacksectionheading'] = '{$a} عنوان القسم';
$string['feedbacksectionheadingmissing'] = 'يجب إدخال عنوان لقسم الإفادة هذا!';
$string['feedbacksectionheadingtext'] = 'العنوان';
$string['feedbacksectionlabel'] = 'الملصق';
$string['feedbacksectionlabel_help'] = 'سيتم استخدام هذا التصنيف في المخططات / الرسوم البيانية.
يرجى الاحتفاظ بها قصيرة قدر الإمكان!';
$string['feedbacksectionquestions'] = '{$a} أسئلة القسم';
$string['feedbacksections'] = 'مقاطع الإفادة';
$string['feedbacksectionsselect'] = 'الأقسام';
$string['feedbacksectionsselect_help'] = 'ضع أسئلتك في هذه الأقسام';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'تم حفظ إعدادات الإفادة';
$string['feedbacktype'] = 'نوع الإفادة';
$string['field'] = 'السؤال {$a}';
$string['fieldlength'] = 'طول مربع الإدخال';
$string['fieldlength_help'] = 'بالنسبة لنوع السؤال **مربع النص**، أدخل **طول مربع الإدخال** و**الحد الأقصى لطول النص** للنص الذي سيتم إدخاله بواسطة مقدم الاستبيان.

القيم الافتراضية هي 20 حرفًا لعرض مربع الإدخال و 25 حرفًا للطول الأقصى للنص الذي تم إدخاله.';
$string['finished'] = 'لقد أجبت على جميع الأسئلة في هذا الاستبيان!';
$string['firstrespondent'] = 'المستجيب الأول';
$string['formateditor'] = 'محرر HTML';
$string['formatplain'] = 'نص عادي';
$string['grade'] = 'تقديم التقدير';
$string['gradesdeleted'] = 'تم حذف درجات الاستبيان';
$string['headingtext'] = 'عنوان النص';
$string['horizontal'] = 'الأفقي';
$string['id'] = 'المعرّف';
$string['includechoicecodes'] = 'تضمين رموز اختيار';
$string['includechoicetext'] = 'تضمين نص اختيار';
$string['includeincomplete'] = 'تشمل الاستجابات الغير مكتملة';
$string['incorrectcourseid'] = 'معرّف المادة غير صحيح';
$string['incorrectmodule'] = 'معرّف وحدة المادة كان غير صحيح';
$string['incorrectquestionnaire'] = 'الاستبيان غير صحيح';
$string['indirectwarnings'] = 'تعرض هذه القائمة الأسئلة المتعلقة غير المباشرة والتبِعات المتبقية للأسئلة التابعة مباشرةً:';
$string['invalidresponse'] = 'استجابة محددة غير صالحة.';
$string['invalidresponserecord'] = 'سجل استجابة محددة غير صالحة.';
$string['invalidsectionid'] = 'تم تحديد قسم ردود فعل غير صالح.';
$string['invalidsurveyid'] = 'معرف الاستبيان غير صالح.';
$string['kindofratescale'] = 'نوع معدل المقياس';
$string['kindofratescale_help'] = 'انقر بزر الماوس الأيمن فوق الرابط لمزيد من التعليمات أدناه.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'آخر الإستجابات';
$string['length'] = 'الطول';
$string['managequestions'] = 'إدارة الأسئلة';
$string['managequestions_help'] = 'في قسم إدارة الأسئلة في صفحة تحرير الأسئلة ، يمكنك إجراء عدد من العمليات على أسئلة الاستبيان.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'إلزامي - يجب الوفاء بجميع هذه التبعيات.';
$string['maxdigitsallowed'] = 'أعلى خانات الأرقام المسموح بها';
$string['maxdigitsallowed_help'] = 'استخدام ** أعلى خانات الأرقام المسموح بها ** لتعيين حد لعدد الأحرف التي تم إدخالها لسؤال رقمي. لاحظ أن الفاصلة العشرية تعد أيضًا كحرف واحد!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'الأعلى . استجابة قسرية';
$string['maxforcedresponses_help'] = 'استعمل هذه المعاملات لإجبار المستجيب على تحديد خانات لا تقل عن **الحد الأدنى** ولا تزيد عن **الحد الأقصى**. لفرض عدد محدد من خانات الاختيار المحددة، اضبط **الحد الأدنى** و**الحد الأقصى** على نفس القيمة. إذا كانت قيمة واحدة فقط من الحدين مطلوبة، فما عليك سوى ترك القيمة الأخرى على قيمتها الافتراضية **0**.
إذا قمت بتعيين **الحد الأدنى** أو **الحد الأقصى** على قيم غير قيمتها الافتراضية **0**، فستظهر رسالة تنبيه للمستجيب إن لم يلبي متطلباتك. من الواضح أنك ينبغي أن توضح أي متطلبات للمستجيب، إما في الإرشادات العامة الواردة في استبيانك أو في نص الأسئلة ذات الصلة.';
$string['maxtextlength'] = 'أعلى طول النص';
$string['maxtextlength_help'] = 'بالنسبة للأسئلة من نوع مربع النص، أدخل طول مربع الإدخال وطول النص الأقصى للنص الذي سيتم إدخاله بواسطة المستجيب.
القيم الافتراضية هي 20 حرفًا لعرض مربع الإدخال و 25 حرفًا للطول الأقصى للنص الذي سيتم إدخاله.';
$string['messageprovider:message'] = 'تذكير الاستبيان';
$string['messageprovider:notification'] = 'تقديم الاستبيان';
$string['minforcedresponses'] = 'الأدنى. استجابة قسرية';
$string['minforcedresponses_help'] = 'استعمل هذه المعاملات لإجبار المستجيب على تحديد خانات لا تقل عن **الحد الأدنى** ولا تزيد عن **الحد الأقصى**. لفرض عدد محدد من خانات الاختيار المحددة، اضبط **الحد الأدنى** و**الحد الأقصى** على نفس القيمة. إذا كانت قيمة واحدة فقط من الحدين مطلوبة، فما عليك سوى ترك القيمة الأخرى على قيمتها الافتراضية **0**.
إذا قمت بتعيين **الحد الأدنى** أو **الحد الأقصى** على قيم غير قيمتها الافتراضية **0**، فستظهر رسالة تنبيه للمستجيب إن لم يلبي متطلباتك. من الواضح أنك ينبغي أن توضح أي متطلبات للمستجيب، إما في الإرشادات العامة الواردة في استبيانك أو في نص الأسئلة ذات الصلة.';
$string['misconfigured'] = 'تم تكوين المساق التعليمي بشكل خاطئ';
$string['missingname'] = 'لا يمكن استعمال السؤال {$a} في قسم الإفادة هذا لأنه بلا اسم.';
$string['missingnameandrequired'] = 'لا يمكن استعمال السؤال {$a} في قسم الإفادة هذا لأنه بلا اسم وليس مطلوبًا.';
$string['missingquestion'] = 'الرجاء الإجابة عن السؤال المطلوب';
$string['missingquestions'] = 'الرجاء الإجابة على الأسئلة جميع المطلوبة:';
$string['missingrequired'] = 'لا يمكن استعمال السؤال {$a} في قسم الإفادة هذا لأنه ليس مطلوبًا.';
$string['modulename'] = 'استبيان';
$string['modulename_help'] = 'تتيح لك وحدة الاستبيان إنشاء استبيانات باستخدام مجموعة متنوعة من أنواع الأسئلة ، بغرض جمع البيانات من المستجيبين.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'الاستبيانات';
$string['movedisabled'] = 'لا يمكن نقل هذا العنصر';
$string['myresponses'] = 'كل ردودكم';
$string['myresponsetitle'] = 'استجاباتكم {$a}';
$string['myresults'] = 'نتائج بحثك';
$string['name'] = 'الاسم';
$string['navigate'] = 'السماح بالأسئلة المتفرعة';
$string['navigate_help'] = 'تمكين أسئلة صح/خطأ وأسئلة أزرار الاختيار من الحصول على أسئلة تابعة لها تعتمد على اختياراتها في هذا الاستبيان.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'انتقل إلى قسم ردود الفعل';
$string['next'] = 'التالى';
$string['nextpage'] = 'الصفحة التالية';
$string['nlines'] = 'خطوط {$a}';
$string['noanswer'] = 'لا توجد إجابة';
$string['noattempts'] = 'لم تبذل أيّ محاولات في هذا الاستبيان';
$string['nodata'] = 'لم يتم نشر البيانات.';
$string['noduplicates'] = 'لا توجد خيارات مكررة';
$string['noduplicateschoiceserror'] = 'يجب عليك إدخال إجابتين محتملتين على الأقل لخيار "لا توجد خيارات مكررة"!';
$string['non_respondents'] = 'المستخدمون الذين لم يقدموا بعد ردودهم على هذا الاستبيان';
$string['noneinuse'] = 'لا يحتوي هذا الاستبيان على أيّ أسئلة.';
$string['nopublicsurveys'] = 'لا استبيانات عامة.';
$string['noresponsedata'] = 'لا ردود على هذا السؤال.';
$string['noresponses'] = 'لا إستجابات';
$string['normal'] = 'عادي';
$string['not_started'] = 'لم يبدأ';
$string['notanumber'] = '{$a} ليس تنسيق أرقام مقبول.';
$string['notapplicable'] = 'غير متاح';
$string['notapplicablecolumn'] = 'عمود غير متاح';
$string['notavail'] = 'هذا الاستبيان لم يعد متوفرًا. اطلب من معلّمك حذفه.';
$string['noteligible'] = 'أنت غير مؤهل لأخذ هذا الاستبيان.';
$string['notemplatesurveys'] = 'لا يوجد مظاهر استبيانات.';
$string['notenoughscaleitems'] = 'يجب إدخال الحد الأدنى لقيمة قياس عنصرين!';
$string['notificationfull'] = 'التقديم كامل';
$string['notifications'] = 'إرسال إشعارات التسليم';
$string['notifications_help'] = 'إخطار الأدوار بقدرة "mod/questionnaire: submitnotification" عند تقديم الطلب.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'الإخطار فقط';
$string['notopen'] = 'لن يتم فتح هذا الاستبيان حتى {$a}.';
$string['notrequired'] = 'الرد غير مطلوب';
$string['notset'] = 'غير مضبوط';
$string['nousersselected'] = 'لم يتم اختيار مستخدمين';
$string['num'] = '#';
$string['numattemptsmade'] = 'محاولات تمت {$a} على هذا الاستبيان';
$string['numberfloat'] = 'تمت إعادة تنسيق/تقريب الرقم الذي أدخلته {$a->number} بـ {$a->precision} ( منازل ) عشرية.';
$string['numberofdecimaldigits'] = 'عدد المنازل العشرية';
$string['numberofdecimaldigits_help'] = 'استعمل **عدد المنازل العشرية** لتحديد تنسيق القيمة المتوسطة التي يتم حسابها وعرضها في صفحة تقرير الاستبيان.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'عدد عناصر المقياس';
$string['numberscaleitems_help'] = 'عدد العناصر المقاسة هو * عدد العناصر * المطلوب استخدامها في مقياس المعدل الخاص بك. يمكنك عادةً استخدام قيمة من 3 إلى 5. القيمة الافتراضية: ** 5 **.';
$string['numeric'] = 'رقمية';
$string['numeric_help'] = 'استخدم نوع السؤال هذا إذا كنت تتوقع أن يكون الرد رقمًا مُنسقًا بشكل صحيح.';
$string['of'] = 'من';
$string['opendate'] = 'استخدام تاريخ مفتوح';
$string['option'] = 'الخيار {$a}';
$string['optional'] = 'اختياري - يجب تحقيق واحدة على الأقل من هذه التبعيات.';
$string['optionalname'] = 'اسم السؤال';
$string['optionalname_help'] = 'يتم استخدام اسم السؤال فقط عند تصدير الاستجابات إلى تنسيق CSV / Excel. إذا لم تقم أبدًا بالتصدير إلى ملف CSV ، فلا داعي للقلق بشأن أسماء الأسئلة على الإطلاق. إذا كنت تخطط لتصدير بيانات الاستبيان بانتظام إلى ملف CSV ، فيمكنك اختيار خيارين لتسمية الأسئلة.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- أو -';
$string['order_ascending'] = 'ترتيب تصاعدي';
$string['order_default'] = 'عرض الطلب الافتراضي';
$string['order_descending'] = 'ترتيب تنازلي';
$string['orderresponses'] = 'ترتيب الردود';
$string['orderresponses_help'] = 'عند عرض كل الردود، يمكنك ترتيب الاختيارات حسب عدد الردود (عمود المتوسط) لأنواع الأسئلة الأربعة التالية.

* زر الاختيار المنفرد
* القائمة المنسدلة ذات الخيار المنفرد
* الخيارات المتعددة (خانات الاختيار)
* أسئلة التقييم (بما في ذلك مقاييس Likert).

عندما تصل إلى صفحة "كل الردود"، يتم ترتيب الردود إفتراضيًا بالترتيب الذي أدخل به منشؤ الاستبيان خيارات السؤال. يمكنك اختيار ترتيبها تصاعديًا أو تنازليًا.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'آخر:';
$string['otherempty'] = 'إذا وضعت علامة على هذا الاختيار ، يجب عليك إدخال نص في مربع النص!';
$string['overviewnumresplog'] = 'استجابات';
$string['overviewnumresplog1'] = 'استجابة';
$string['overviewnumrespvw'] = 'استجابات';
$string['overviewnumrespvw1'] = 'استجابة';
$string['owner'] = 'المالك';
$string['page'] = 'الصفحة';
$string['pageof'] = 'الصفحة {$a->page} من {$a->totpages}';
$string['parent'] = 'الأصل';
$string['participant'] = 'مشارك';
$string['pleasecomplete'] = 'يرجى استكمال هذا الاختيار.';
$string['pluginadministration'] = 'إدارة الاستبيان';
$string['pluginname'] = 'الاستبيان';
$string['position'] = 'موضع';
$string['possibleanswers'] = 'الإجابات المُمْكنة';
$string['posteddata'] = 'الصفحة التي تم الوصول إليها مع البيانات المنشورة:';
$string['preview_label'] = 'المعاينة';
$string['preview_questionnaire'] = 'معاينة الاستبيان';
$string['previewing'] = 'معاينة الاستبيان';
$string['previous'] = 'السابق';
$string['previouspage'] = 'الصفحة السابقة';
$string['print'] = 'طباعة هذه الاستجابة';
$string['printblank'] = 'طباعة نسخة فارغة';
$string['printblanktooltip'] = 'يفتح نافذة طباعة سهلة لإستبيان فارغ';
$string['printtooltip'] = 'يفتح نافذة طباعة سهلة لإستبيان الاستجابة الحالية';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'استجابة سؤال الاختيار من متعدد';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'معرّف سجل الاختيار لهذه الاستجابة';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'معرّف سجل السؤال لهذه الاستجابة';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'معرّف سجل الاستجابة لهذه الاستجابة';
$string['privacy:metadata:questionnaire_resp_single'] = 'إستجابة سؤال الاختيار الواحد';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'معرّف سجل الاختيار لهذه الاستجابة';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'معرّف سجل السؤال لهذه الاستجابة';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'معرّف سجل الاستجابة لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response'] = 'الاستجابة في تقدم أو المقدّمة';
$string['privacy:metadata:questionnaire_response:complete'] = 'حال اكتمال الاستجابة';
$string['privacy:metadata:questionnaire_response:grade'] = 'علامة هذه الاستجابة';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'معرّف سجل الاستبيان لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response:submitted'] = 'الطابع الزمني لحفظ الأحدث لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response:userid'] = 'معرّف المستخدم لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_bool'] = 'إجابة سؤال منطقي (نعم/لا)';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'الإجابة المنطقية المحددة';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'معرّف سجل السؤال لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'معرّف سجل الاستجابة لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_date'] = 'تاريخ الإستجابة لهذا السؤال';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'معرّف سجل السؤال لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_date:response'] = 'تاريخ الجواب المحدد';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'معرّف سجل الاستجابة لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_other'] = 'الاستجابة النصية على الخيار \'أخرى\'';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'معرّف سجل الاختيار لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'معرّف سجل السؤال لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_other:response'] = 'نص الجواب المحدد';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'معرّف سجل الاستجابة لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_rank'] = 'رتبة الاستجابة لهذا السؤال';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'معرّف سجل الاختيار لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'معرّف سجل السؤال لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'إجابة الرتبة المحددة';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'معرّف سجل الاستجابة لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_text'] = 'استجابة سؤال نصي';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'معرّف سجل السؤال لهذه الاستجابة';
$string['privacy:metadata:questionnaire_response_text:response'] = 'جواب النص المحدد';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'معرّف سجل الاستجابة لهذه الاستجابة';
$string['private'] = 'خاص';
$string['progresshelp_help'] = 'إنتقل إلى الصفحة التالية لإملاء شريط التقديم';
$string['public'] = 'عام';
$string['publiccopy'] = 'نسخ:';
$string['publicoriginal'] = 'أصلي:';
$string['qtype'] = 'النوع';
$string['qtype_help'] = 'حدد ما إذا كان سيتم السماح للمستخدمين بالرد مرة واحدة أو يوميًا أو أسبوعيًا أو شهريًا أو بعدد غير محدود من المرات (كثير).';
$string['qtypedaily'] = 'الرد يومياً';
$string['qtypemonthly'] = 'الرد شهرياً';
$string['qtypeonce'] = 'رد وحيد';
$string['qtypeunlimited'] = 'الرد المتكرر';
$string['qtypeweekly'] = 'الرد الاسبوعي';
$string['questionnaire:addinstance'] = 'إضافة استبيان جديد';
$string['questionnaire:copysurveys'] = 'نسخ المظهر والاستبيانات الخاصة';
$string['questionnaire:createpublic'] = 'إنشاء استبيانات عامة';
$string['questionnaire:createtemplates'] = 'إنشاء مظهر استبيانات';
$string['questionnaire:deleteresponses'] = 'حذف أيّ رد';
$string['questionnaire:downloadresponses'] = 'قم بتنزيل الردود في ملف CSV';
$string['questionnaire:editquestions'] = 'إنشاء وتحرير أسئلة الاستبيان';
$string['questionnaire:manage'] = 'إنشاء وتحرير الاستبيانات';
$string['questionnaire:message'] = 'إرسال رسالة إلى غير المستجيبين';
$string['questionnaire:preview'] = 'معاينة الاستبيانات';
$string['questionnaire:printblank'] = 'طباعة استبيان فارغ';
$string['questionnaire:readallresponseanytime'] = 'قراءة جميع الردود في أيّ وقت';
$string['questionnaire:readallresponses'] = 'قراءة ملخصات الاستجابة ، رهناً بأوقات مفتوحة';
$string['questionnaire:readownresponses'] = 'قراءة الردود الخاصة';
$string['questionnaire:submissionnotification'] = 'تلقي إشعار لكل تقديم';
$string['questionnaire:submit'] = 'إكمال الاستبيان وإرساله';
$string['questionnaire:view'] = 'عرض الاستبيان';
$string['questionnaire:viewsingleresponse'] = 'عرض الاستجابات الفردية كاملة';
$string['questionnaireadministration'] = 'إدارة الاستبيان';
$string['questionnairecloses'] = 'غلق الاستبيان';
$string['questionnaireopens'] = 'فتح الاستبيان';
$string['questionnairereport'] = 'تقرير الاستبيان';
$string['questionnum'] = 'السؤال #';
$string['questions'] = 'الأسئلة';
$string['questionsinsection'] = 'الأسئلة في هذا القسم:';
$string['questiontypes'] = 'أنواع الأسئلة';
$string['questiontypes_help'] = 'راجع وثائق Moodle أدناه';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'أزرار اختيار';
$string['radiobuttons_help'] = 'في نوع السؤال هذا ، يجب على المستجيب اختيار واحد من الخيارات المتاحة.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'الرتيب';
$string['ratescale'] = 'معدل (مقياس 1..5)';
$string['ratescale_help'] = 'راجع وثائق Moodle أدناه';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'نوع الاستبيان';
$string['realm_help'] = '* **هناك ثلاثة أنواع من الاستبيانات:**
* خاص - ينتمي إلى المقرر الذي تم إنشاؤه فيه فقط.
* مظهر - يمكن نسخه وتحريره.
* عمومي - يمكن مشاركته بين المقررات الدراسية.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'عنوان الرابط الذي تتم إعادة توجيه المستخدم إليه بعد الانتهاء من هذا الاستبيان.';
$string['remove'] = 'احذف';
$string['removeallquestionnaireattempts'] = 'احذف جميع ردود الاستبيان';
$string['removenotinuse'] = 'كان هذا الاستبيان معتمدًا على استبيان عمومي تم حذفه.
لم يعد بالإمكان استعماله وينبغي حذفه.';
$string['required'] = 'الاستجابة مطلوبة';
$string['required_help'] = 'إذا اخترت *** نعم *** ، فستكون الإجابة على هذا السؤال مطلوبة ، أيْ لن يتمكن المستجيب من إرسال الاستبيان حتى يتم الرد على هذا السؤال.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'المعطيات  المطلوبة مفقودة.';
$string['reset'] = 'إعادة تعيين';
$string['respeligiblerepl'] = '(يحل محله بتخطي الأدوار)';
$string['respondent'] = 'المستجيب';
$string['respondenteligibleall'] = 'الكل';
$string['respondenteligiblestudents'] = 'الطلاب فقط';
$string['respondenteligibleteachers'] = 'المعلمين فقط';
$string['respondents'] = 'المستجيبين';
$string['respondenttype'] = 'نوع المستجيبين';
$string['respondenttype_help'] = 'يمكنك عرض أسماء المستخدمين الكاملة مع كل استجابة من خلال تعيين هذا على "fullname".
يمكنك إخفاء هويات المستخدمين في الردود عن طريق تعيين هذا على "anonymous".';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'مجهول';
$string['respondenttypefullname'] = 'الاسم الكامل';
$string['response'] = 'الاستجابة';
$string['responsefieldlines'] = 'حجم مربع الإدخال';
$string['responseformat'] = 'تنسيق الاستجابة';
$string['responseoptions'] = 'خيارات الاستجابة';
$string['responses'] = 'الإستجابات';
$string['responseview'] = 'يمكن للطلاب عرض جميع الردود';
$string['responseview_help'] = 'يمكنك تحديد من يمكنه رؤية ردود جميع المستجيبين على الاستبيانات المقدمة (جداول الإحصاءات العامة).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'دائماً';
$string['responseviewstudentsnever'] = 'أبداً';
$string['responseviewstudentswhenanswered'] = 'بعد الإجابة على هذا الاستبيان';
$string['responseviewstudentswhenclosed'] = 'بعد إغلاق هذا  الاستبيان';
$string['restrictedtoteacher'] = 'هذه الوظائف تقتصر على تحرير المعلمين فقط!';
$string['resume'] = 'حفظ/استئناف الإجابات';
$string['resume_help'] = 'يتيح تعيين هذا الخيار للمستخدمين حفظ إجاباتهم في الاستبيان قبل إرسالها.
يمكن للمستخدمين ترك الاستبيان غير مكتمل واستئنافه من نقطة الحفظ في وقت لاحق.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'استئناف الاستبيان';
$string['return'] = 'إرجاع';
$string['save'] = 'حفظ';
$string['saveasnew'] = 'حفظ كسؤال جديد';
$string['savedbutnotsubmitted'] = 'تم حفظ هذا الاستبيان ولكن لم يتم تسليمه بعد.';
$string['savedprogress'] = 'تم حفظ تقدمك. يمكنك العودة في أيّ وقت لاستكمال هذا الاستبيان.';
$string['saveeditedquestion'] = 'حفظ السؤال {$a}';
$string['savesettings'] = 'احفظ التغييرات';
$string['search:activity'] = 'استبيان - معلومات النشاط';
$string['search:question'] = 'استبيان - الأسئلة';
$string['section'] = 'الوصف';
$string['sectionbreak'] = '----- فاصل صفحة -----';
$string['sectionbreak_help'] = '----- فاصل صفحة -----';
$string['sectionsnotset'] = 'يجب عليك اختيار سؤال واحد على الأقل لكل قسم!
القسم (الأقسام) غير محدد: {$a}';
$string['sectiontext'] = 'ملصق';
$string['sectiontext_help'] = 'هذا ليس سؤالًا ولكن نصًا (قصيرًا) سيتم عرضه لتقديم سلسلة من الأسئلة.';
$string['selecttheme'] = 'حدد القالب (CSS) لاستخدامه مع هذا الاستبيان.';
$string['send'] = 'أنقر هنا لتظهر لك نتيجة القياس (ارسل)';
$string['send_message'] = 'إرسال رسالة إلى المستخدمين المحددين';
$string['send_message_to'] = 'إرسال الرسالة إلى:';
$string['sendemail'] = 'ارسل بريد';
$string['sendemail_help'] = 'يرسل نسخة من كل تسليم إلى العنوان أو العناوين المحددة. يمكنك تقديم أكثر من عنوان واحد عبر الفصل بينها بفوارز.
أتركه فارغاً إذا كنت لا ترغب بنسخة احتياطية في البريد الالكتروني. سنيغي تمكين \'allowemailreporting\' في إعدادات الوحدة لإتاحة هذا الخيار.';
$string['set'] = 'أعدّ';
$string['settings'] = 'الإعدادات';
$string['settingssaved'] = 'تم حفظ الإعدادات';
$string['show_nonrespondents'] = 'غير المستجيبين';
$string['started'] = 'بدأت';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'استخدم تنسيق شهر-يوم ، على سبيل المثال في 4 مارس 1945:  1945-03-04';
$string['subject'] = 'الموضوع';
$string['submissionnotificationhtmlanon'] = 'هناك تقديم  جديد إلى "{$a->name}"  الاستبيان.';
$string['submissionnotificationhtmluser'] = '{$a->username}  لديه تقديم جديد إلى "{$a->name}"  الاستبيان في مادة "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'تقديم استبيان جديد';
$string['submissionnotificationtextanon'] = 'هناك إرسال جديد({$a->submissionurl})  إلى استبيان "{$a->name}" .';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) يحتوي على تقديم جديد ({$a->submiturl}) إلى استبيان "{$a->name}" في المادة "{$a->coursename}".';
$string['submitoptions'] = 'خيارات التقديم';
$string['submitpreview'] = 'معاينة التقديم';
$string['submitpreviewcorrect'] = 'سيتم قبول هذا التقديم كما تم ملؤه بشكل صحيح.';
$string['submitsurvey'] = 'تقديم الاستبيان';
$string['submitted'] = 'تم تقديمه:';
$string['subtitle'] = 'العنوان الثانوي';
$string['subtitle_help'] = 'العنوان الفرعي لهذا الاستبيان. يظهر أسفل العنوان في الصفحة الأولى فقط.';
$string['summary'] = 'الملخص';
$string['surveynotexists'] = 'الاستبيان غير موجود.';
$string['surveyowner'] = 'يجب أن تكون مالك الاستبيان لإجراء هذه العملية.';
$string['surveyresponse'] = 'الاستجابات من الاستبيان';
$string['template'] = 'القالب';
$string['templatenotviewable'] = 'مظاهر الاستبيانات غير قابلة للعرض.';
$string['text'] = 'نص السؤال';
$string['textareacolumns'] = 'أعمدة في مساحة النص';
$string['textareacolumns_help'] = 'سيعرض هذا السؤال مربع نص عادي مع **x** أعمدة في *مساحة النص* (أو *عرض* المنطقة) و **y** من *الصفوف في مساحة النص* (عدد *أسطر* النص).
إذا تركت كل من x و y على القيمة الافتراضية **0** (أو إذا جعلتها **0**)، فسيتم عرض محرر HTML بالطول والعرض القياسيين (إذا كان ذلك متاحًا في سياق المساق/المستخدم) وفي الملف الشخصي للمستخدم).';
$string['textarearows'] = 'صفوف مساحة النص';
$string['textbox'] = 'مربع للكتابة';
$string['textbox_help'] = 'بالنسبة للأسئلة من نوع مربع النص، أدخل طول مربع الإدخال وطول النص الأقصى للنص الذي سيتم إدخاله بواسطة المستجيب.
القيم الافتراضية هي 20 حرفًا لعرض مربع الإدخال و 25 حرفًا للطول الأقصى للنص الذي سيتم إدخاله.';
$string['textdownloadoptions'] = 'خيارات لتنزيل بملف CSV';
$string['thank_head'] = 'شكراً لكم على ملء هذا الاستبيان، انقر على الرابط التالي لمشاهدة التقدير!';
$string['theme'] = 'القالب';
$string['thismonth'] = 'هذا الشهر';
$string['thisresponse'] = 'هذا الرد';
$string['thisweek'] = 'هذا الاسبوع';
$string['thousands'] = 'لا تستخدم فواصل الآلاف .';
$string['title'] = 'العنوان';
$string['title_help'] = 'عنوان هذا الاستبيان، الذي سيظهر في الجزء العلوي من كل صفحة. يتم تعيين العنوان افتراضيًا على اسم الاستبيان، ولكن يمكنك تعديله كما تريد.';
$string['today'] = 'هذا اليوم';
$string['total'] = 'المجموع';
$string['totalofnumbers'] = 'مجموع الأرقام المدخلة';
$string['totalresponses'] = 'مجموع الاستجابات على السؤال';
$string['type'] = 'نوع السؤال';
$string['undefinedquestiontype'] = 'نوع السؤال غير محدد!';
$string['unknown'] = 'غير معروف';
$string['unknownaction'] = 'إجراء غير معروف لاستبيان  محدد  ...';
$string['url'] = 'رابط التأكيد';
$string['url_help'] = 'الرابط الذي تتم إعادة توجيه المستخدم إليه بعد الانتهاء من هذا الاستبيان.';
$string['useprivate'] = 'نسخة موجودة';
$string['usepublic'] = 'استخدام العامة';
$string['usetemplate'] = 'استخدم مظهر';
$string['vertical'] = 'عمودي';
$string['view'] = 'شاهد';
$string['viewallresponses'] = 'عرض جميع الردود';
$string['viewallresponses_help'] = 'إذا تم ضبط الاستبيان على **نمط المجموعات**: *مجموعات مرئية*، أو تم ضبطه على *مجموعات منفصلة* وكانت لدى المستخدم الحالي الإمكانية *moodle/site:accessallgroups* (في السياق الحالي)، والمجموعات تم تعريفها في المساق الحالي، فسيكون للمستخدم وصولٌ إلى القائمة المنسدلة للمجموعات. تمكّن هذه القائمة المستخدم من "ترشيح" ردود الاستبيان حسب المجموعات.
إذا كان الإعداد هو **نمط المجموعات**: *مجموعات منفصلة*، فالمستخدمون الذين ليست لديهم الإمكانية *moodle/site:accessallgroups* (عادةً الطلاب، أو المعلمون غير المحررين، و ما إلى ذلك) سيكونون قادرين فقط على مشاهدة ردود المجموعة/المجموعات التي ينتمون إليها.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'قائمة الردود';
$string['viewindividualresponse'] = 'ردود فردية';
$string['viewindividualresponse_help'] = 'أنقر على أسماء المجيبين في القائمة أدناه لعرض ردودهم الفردية.';
$string['viewresponses'] = 'كل الردود ({$a})';
$string['viewyourresponses'] = 'ردودكم - عرض {$a}';
$string['warning'] = 'تحذير ، واجه خطأ.';
$string['wronganswers'] = 'يوجد خطأ ما في إجاباتك (أنظر أدناه)';
$string['wrongdateformat'] = 'التاريخ الذي تم إدخاله: {$a} لا يتوافق مع التنسيق الموضح في المثال.';
$string['wrongdaterange'] = 'خطأ! يجب تعيين السنة في نطاق 1902 إلى 2037.';
$string['wrongformat'] = 'يوجد خطأ ما في إجابتك على السؤال:';
$string['wrongformats'] = 'يوجد خطأ ما في إجابتك على الأسئلة:';
$string['yesno'] = 'نعم/لا';
$string['yesno_help'] = 'سؤال بسيط نعم/لا.';
$string['yourresponse'] = 'نتيجتك';
$string['yourresponses'] = 'ردودكم';
