<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'pl', version '4.5'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Zaakceptuj';
$string['accept_grades'] = 'Zaakceptuj oceny z narzędzia';
$string['accept_grades_admin'] = 'Zaakceptuj oceny z narzędzia';
$string['accept_grades_admin_help'] = 'Określ, czy dostawca treści może dodawać, aktualizować, czytać i usuwać oceny związane z tym egzemplarzem modułu.

Niektórzy dostawcy treści umożliwiają wysyłanie z powrotem do Moodle ocen działań wykonywanych w zdalnym module, co pozwala doświadczyć jeszcze pełniejszej integracji.';
$string['accept_grades_from_tool'] = 'Zezwól {$a} na dodawanie ocen w dzienniku ocen';
$string['accept_grades_help'] = 'Określ, czy dostawca treści może dodawać, aktualizować, czytać i usuwać oceny związane z tym egzemplarzem modułu.

Niektórzy dostawcy treści umożliwiają wysyłanie z powrotem do Moodle ocen działań wykonywanych w zdalnym module, co pozwala doświadczyć jeszcze pełniejszej integracji.

Należy pamiętać, że to ustawienie może być nadpisane w konfiguracji tego narzędzia.';
$string['accepted'] = 'Zaakceptowane';
$string['action'] = 'Akcja';
$string['activate'] = 'Aktywuj';
$string['activatetoadddescription'] = 'Musisz aktywować to narzędzie zanim będzie można dodać opis.';
$string['active'] = 'Aktywny';
$string['activity'] = 'Aktywność';
$string['add_ltilegacy'] = 'Dodaj starszą wersję LTI';
$string['addnewapp'] = 'Włącz zewnętrzną aplikację';
$string['addserver'] = 'Dodaj nowy zaufany serwer';
$string['addtool'] = 'Dodaj narzędzie';
$string['addtype'] = 'Dodaj konfigurację narzędzia';
$string['allow'] = 'Zezwól';
$string['allowsetting'] = 'Pozwól, aby narzędzie przechowywało do 8 KB ustawień w Moodle';
$string['always'] = 'Zawsze';
$string['autoaddtype'] = 'Dodaj narzędzie';
$string['automatic'] = 'Automatyczna, na podstawie adresu URL';
$string['baseurl'] = 'Podstawowy adres URL/nazwa rejestracji narzędzia';
$string['basiclti'] = 'Learning Tools Interoperability (LTI)';
$string['basiclti_base_string'] = 'Bazowy ciąg LTI OAuth';
$string['basiclti_endpoint'] = 'Punkt wywołania LTI';
$string['basiclti_in_new_window'] = 'Twoja aktywność została otwarta w nowym oknie';
$string['basiclti_in_new_window_open'] = 'Otwórz w nowym oknie';
$string['basiclti_parameters'] = 'Parametry wywołania LTI';
$string['basicltiactivities'] = 'Aktywności LTI';
$string['basicltifieldset'] = 'Przykładowy zestaw pól';
$string['basicltiintro'] = 'Opis aktywności';
$string['basicltiname'] = 'Nazwa aktywności';
$string['basicltisettings'] = 'Ustawienia podstawowe narzędzia LTI';
$string['cancel'] = 'Anuluj';
$string['cancelled'] = 'Anulowano';
$string['cannot_delete'] = 'Nie możesz usunąć tej konfiguracji narzędzia.';
$string['cannot_edit'] = 'Nie możesz edytować tej konfiguracji narzędzia.';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Kliknij aby kontynuować</a>';
$string['clientidadmin'] = 'Identyfikator klienta';
$string['comment'] = 'Komentarz';
$string['configpassword'] = 'Domyślne hasło zdalnego modułu';
$string['configpreferheight'] = 'Domyślna preferowana wysokość';
$string['configpreferwidget'] = 'Ustaw widget jako domyślny';
$string['configpreferwidth'] = 'Domyślna preferowana szerokość';
$string['configresourceurl'] = 'Domyślny URL zasobu';
$string['configtoolurl'] = 'Domyślny URL zdalnego modułu';
$string['configtypes'] = 'Włącz aplikacje LTI';
$string['configured'] = 'Skonfigurowany';
$string['confirmtoolactivation'] = 'Czy na pewno chcesz aktywować to narzędzie?';
$string['contentitem_multiple_description'] = 'Do Twojego kursu zostaną dodane następujące elementy:';
$string['contentitem_multiple_graded'] = 'Oceniona aktywność (maksymalna ocena: {$a})';
$string['course_tool_types'] = 'Narzędzia kursu';
$string['courseactivitiesorresources'] = 'Aktywności lub zasoby kursu';
$string['courseexternaltooladd'] = 'Dodaj nowe zewnętrzne narzędzie LTI';
$string['courseexternaltooladdsuccess'] = '{$a} dodano.';
$string['courseexternaltooledit'] = 'Edytuj {$a}.';
$string['courseexternaltooleditsuccess'] = 'Zmiany zapisane.';
$string['courseexternaltooliconalt'] = 'Ikona dla {$a}.';
$string['courseexternaltools'] = 'Zewnętrzne narzędzia LTI';
$string['courseexternaltoolsnoeditpermissions'] = 'Nie masz uprawnień do edytowania tego narzędzia';
$string['courseexternaltoolsnoviewpermissions'] = 'Zobacz narzędzia zewnętrzne kursu';
$string['courseid'] = 'id kursu';
$string['courseinformation'] = 'Informacje kursu';
$string['courselink'] = 'Idź do kursu';
$string['coursemisconf'] = 'Kurs jest źle skonfigurowany';
$string['coursetooldeleted'] = '{$a} usunięto';
$string['createdon'] = 'Utworzono';
$string['curllibrarymissing'] = 'Dla narzędzia zewnętrznego wymagane jest rozszerzenie PHP cURL.';
$string['custom'] = 'Parametry niestandardowe';
$string['custom_config'] = 'Użyj własnej konfiguracji narzędzia.';
$string['custom_help'] = 'Parametry niestandardowe to parametry wykorzystywane przez dostawcę treści. Na przykład taki parametr może wskazywać określony zasób u dostawcy do wyświetlenia. Bezpiecznie jest pozostawić to pole bez zmian, chyba że dostawca określi inaczej.';
$string['custominstr'] = 'Parametry niestandardowe';
$string['debuglaunch'] = 'Opcja debug';
$string['debuglaunchoff'] = 'Normalne uruchomienie';
$string['debuglaunchon'] = 'Uruchomienie z debugowaniem';
$string['default'] = 'Domyślnie';
$string['default_launch_container'] = 'Domyślny sposób wyświetlenia';
$string['default_launch_container_help'] = 'Domyślny sposób wyświetlenia określa, w jakiej formie na ekranie pokaże się zawartość modułu.

* **Domyślnie** - użyje okna określonego przez konfigurację narzędzia.
* **Wbudowane** - moduł jest wyświetlany w oknie Moodle\'a jak większość innych aktywności.
* **Wbudowane bez bloków** - moduł jest wyświetlany w bieżącym oknie Moodle\'a, bez innych bloków, z kontrolkami nawigacji na górze strony.
* **Nowe okno** - moduł otwiera się w nowym oknie, zajmując całą dostępną przestrzeń. W zależności od przeglądarki, otworzy się nowa karta lub okno popup. Przeglądarka może zablokować otwarcie nowego okna.';
$string['delegate'] = 'Przekaż nauczycielowi';
$string['delete'] = 'Usuń';
$string['delete_confirmation'] = 'Czy na pewno chcesz usunąć tę konfigurację zewnętrznego modułu?';
$string['deletecoursetool'] = 'Usuń {$a}';
$string['deletecoursetoolconfirm'] = 'Spowoduje to usunięcie {$a} z dostępnych narzędzi LTI w Twoim kursie.';
$string['deletetype'] = 'Usuń konfigurację zewnętrznego modułu';
$string['display_description'] = 'Wyświetl opis aktywności podczas jej uruchamiania';
$string['display_description_help'] = 'Jeśli zaznaczono, opis aktywności (określony powyżej) będzie wyświetlany nad treścią dostawcy.

Opis może być wykorzystane w celu udzielenia dodatkowych instrukcji użytkownikom narzędzia, ale nie jest to wymagane.

Opis nie jest wyświetlany, gdy moduł wyświetlany jest w nowym oknie.';
$string['display_name'] = 'Wyświetl nazwę aktywności podczas jej uruchamiania';
$string['display_name_help'] = 'Jeśli zaznaczono, nazwa aktywności (określona powyżej) będzie wyświetlany powyżej treści z serwera.

Możliwe, że w treści również wyświetlany jest tytułu. Przy pomocy tej opcja można zapewnić jednokrotne wyświetlanie tytułu.

Tytuł nie jest wyświetlany, gdy treść z serwera wyświetlana jest w nowym oknie.';
$string['domain_mismatch'] = 'Domena URL wywołania nie pasuje do konfiguracji narzędzia.';
$string['donot'] = 'Nie wysłano';
$string['donotaccept'] = 'Nie zostało zaakceptowane';
$string['donotallow'] = 'Nie wolno';
$string['dontshowinactivitychooser'] = 'Nie pokazuj w selektorze aktywności';
$string['duplicateregurl'] = 'Adres URL rejestracji jest już wykorzystywany';
$string['dynreg_update_btn_new'] = 'Zarejestruj się jako nowe narzędzie zewnętrzne';
$string['dynreg_update_btn_update'] = 'Aktualizacja';
$string['dynreg_update_name'] = 'Nazwa narzędzia';
$string['dynreg_update_url'] = 'Podstawowy adres URL';
$string['dynreg_update_version'] = 'Wersja LTI';
$string['dynreg_update_warn_dupdomain'] = 'Nie zaleca się posiadania wielu zewnętrznych narzędzi w tej samej domenie.';
$string['editdescription'] = 'Kliknij tutaj, aby dodać opis dla tego narzędzia';
$string['edittype'] = 'Edycja konfiguracji zewnętrznych modułów';
$string['embed'] = 'Wbudowane';
$string['embed_no_blocks'] = 'Wbudowane bez bloków';
$string['enableemailnotification'] = 'Wyślij powiadomienia e-mail';
$string['enableemailnotification_help'] = 'Jeśli opcja jest włączona, studenci będą otrzymywać powiadomienia e-mail, gdy ich prace w tym module będą ocenione.';
$string['errorincorrectconsumerkey'] = 'Klucz klienta jest niepoprawny';
$string['errorinvaliddata'] = 'Niepoprawne dane: {$a}';
$string['errorinvalidmediatype'] = 'Niepoprawny typ medium: {$a}';
$string['errormisconfig'] = 'Źle skonfigurowane narzędzie. Poproś administratora Moodle, aby poprawił konfigurację.';
$string['existing_window'] = 'Istniejące okno';
$string['extensions'] = 'Usługi rozszerzeń LTI';
$string['external_tool_type'] = 'Typ zewnętrznego modułu';
$string['external_tool_type_help'] = 'Głównym celem konfiguracji narzędzia jest stworzenie bezpiecznego kanału komunikacyjnego pomiędzy Moodle a zdalnym dostawcą treści. Można tu ustalić wartości domyślne konfiguracji oraz włączyć dodatkowe funkcje świadczonych przez dostawcę.

* **Automatyczny, wg URL wywołania** - To ustawienie powinno być stosowane w prawie wszystkich przypadkach. Moodle wybierze najbardziej odpowiednią konfigurację narzędzia na podstawie URL wywołania. Użyte będą narzędzia skonfigurowane zarówno przez administratora jak w ramach tego kursu. Gdy określi się URL wywołania, Moodle poinformuje czy go rozpoznaje. Jeśli nie - być może trzeba wprowadzić dane konfiguracyjne narzędzia ręcznie.
* **Specjalny typ** - wybierając konkretny typ konfiguracji narzędzia, można spowodować użycie tej konfiguracji podczas komunikowania się z zewnętrznym dostawcą treści. Jeśli adres URL wywołania wydaje się nie należeć do dostawcy, pojawi się komunikat ostrzegawczy. W niektórych przypadkach nie jest konieczne wprowadzać URL wywołania, gdy wybrano specjalny typ (o ile nie wywołuje się konkretnego zasobu u danego dostawcy).
*** Niestandardowa konfiguracja ** - Aby skonfigurować ten egzemplarz narzędzia niestandardowo, wyświetl Zaawansowane opcje, a następnie wprowadź klucz klienta i wspólne tajne hasło samodzielnie. Jeśli nie masz klucza klienta i wspólnego tajnego hasła, może je pobrać od dostawcy treści. Nie wszystkie narzędzia wymagają klucza i hasła, w tym przypadku pola mogą być puste.

### Edycja typów narzędzia

Trzy ikony dostępne są za rozwijaną listą zewnętrznej typu narzędzia :

* **Dodaj** - Tworzy konfigurację narzędzia na poziomie kursu. Wszystkie egzemplarze modułu zewnętrznego w tym kursie mogą użyć tej konfiguracji.
* **Edytuj** - Wybierz konfigurację narzędzia na poziomie kursu z listy rozwijanej, a następnie kliknij tę ikonę. Możesz wtedy edytować szczegóły konfiguracji.
* **Usuń** - Usuwa wybraną konfigurację z poziomu kursu.';
$string['external_tool_types'] = 'Kategorie zewnętrznych modułów';
$string['failedtoconnect'] = 'Moodle nie było w stanie komunikować się z systemem "{$a}"';
$string['failedtocreatetooltype'] = 'Nie udało się utworzyć nowego narzędzia. Sprawdź adres URL i spróbuj ponownie.';
$string['filter_basiclti_configlink'] = 'Skonfiguruj ulubione witryny i ich hasła';
$string['filter_basiclti_password'] = 'Hasło jest obowiązkowe';
$string['filterconfig'] = 'Administracja LTI';
$string['filtername'] = 'Learning Tools Interoperability';
$string['fixexistingconf'] = 'Zastosuj istniejącej konfiguracji do źle skonfigurowanego egzemplarza';
$string['fixnew'] = 'Nowa konfiguracja';
$string['fixnewconf'] = 'Zdefiniuj nową konfigurację dla źle skonfigurowanego egzemplarza';
$string['fixold'] = 'Użyj istniejącego';
$string['force_ssl'] = 'Wymuś SSL';
$string['force_ssl_help'] = 'Wybór tej opcji wymusza użycie SSL przy każdym wywołaniu dostawcy tego modułu.

Ponadto, wszystkie wywołania internetowe od tego dostawcy będą używać SSL.

Gdy włączasz tę opcję, upewnij się, że ta strona Moodle oraz dostawca obsługuje SSL.';
$string['forced_help'] = 'Ta opcja została określona na poziomie konfiguracji kursu lub witryny. Nie można jej zmienić na tej stronie.';
$string['global_tool_types'] = 'Globalne typy narzędzi';
$string['grading'] = 'Przekazywanie ocen';
$string['icon_url'] = 'Ikona URL';
$string['icon_url_help'] = 'Pole to pozwala zmienić ikonę, która jest pokazywana w liście kursów przy tej aktywności. Zamiast używać domyślnej ikony LTI, można wskazać ikonę, która kojarzy się z typem aktywności';
$string['id'] = 'id';
$string['indicator:cognitivedepth'] = 'Poznawczość Narzędzia zewnętrznego LTI';
$string['indicator:cognitivedepth_help'] = 'Ten wskaźnik opiera się na głębi poznawczej osiągniętej przez studenta podczas korzystania z aktywności Narzędzia zewnętrznego LTI.';
$string['indicator:cognitivedepthdef'] = 'Poznawczość Narzędzia zewnętrznego LTI';
$string['indicator:cognitivedepthdef_help'] = 'Uczestnik osiągnął ten procent zaangażowania poznawczego oferowanego przez aktywność Narzędzia zewnętrznego LTI w tym okresie analizy (Poziomy = Brak wyświetlenia, Wyświetlenie, Wysłanie, Wyświetlenie informacji zwrotnej)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidid'] = 'Identyfikator LTI był niepoprawny';
$string['keytype'] = 'Typ klucza publicznego';
$string['keytype_rsa'] = 'Klucz RSA';
$string['launch_in_moodle'] = 'Uruchom narzędzie w Moodle';
$string['launch_in_popup'] = 'Uruchom moduł w oknie wyskakującym (popup)';
$string['launch_url'] = 'Adres URL narzędzia';
$string['launch_url_help'] = 'URL wywołania wskazuje adres internetowy zewnętrznego narzędzia, i może zawierać dodatkowe informacje, takie jak zasób do pokazania. Jeśli nie jesteś pewien, co wpisać do tego pola, poszukaj więcej informacji u dostawcy treści.

Jeśli wybrałeś konkretny rodzaj narzędzia, to możliwe, że nie trzeba wpisywać adresu wywołania. Tak będzie prawdopodobnie w przypadku, gdy link służy tylko do uruchomienia dostawcy treści, a nie wskazania konkretnego zasobu.';
$string['launchinpopup'] = 'Okno uruchomienia';
$string['launchinpopup_help'] = 'Domyślny sposób wyświetlenia określa, w jakiej formie na ekranie pokaże się zawartość modułu.

* **Domyślnie** - użyje okna określonego przez konfigurację narzędzia.
* **Wbudowane** - moduł jest wyświetlany w oknie Moodle\'a jak większość innych aktywności.
* **Wbudowane bez bloków** - moduł jest wyświetlany w bieżącym oknie Moodle\'a, bez innych bloków, z kontrolkami nawigacji na górze strony.
* **Nowe okno** - moduł otwiera się w nowym oknie, zajmując całą dostępną przestrzeń. W zależności od przeglądarki, otworzy się nowa karta lub okno popup. Przeglądarka może zablokować otwarcie nowego okna.';
$string['launchoptions'] = 'Opcje uruchamiania';
$string['lti'] = 'Learning Tools Interoperability';
$string['lti:addcoursetool'] = 'Ocena aktywności LTI';
$string['lti:addinstance'] = 'Dodaj nowe narzędzie zewnętrzne';
$string['lti:grade'] = 'Ocena aktywności LTI';
$string['lti:manage'] = 'Edytuj aktywność LTI';
$string['lti:requesttooladd'] = 'Prześlij do administratorów prośbę o konfigurację narzędzia';
$string['lti:view'] = 'Zobacz aktywności LTI';
$string['lti_administration'] = 'Administracja LTI';
$string['lti_errormsg'] = 'Narzędzie zwróciło następujący komunikat błędu: "{$a}"';
$string['lti_launch_error'] = 'Wystąpił błąd podczas uruchamiania zdalnego modułu:';
$string['lti_launch_error_tool_request'] = '<p> Aby poprosić administratora, o dokończenie konfiguracji narzędzia, kliknij <a href="{$a->admin_request_url}" target="_top">tutaj</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p>
Ten błąd może być wynikiem braku klucza klienta i wspólnego tajnego hasła dla dostawcy treści.</p>
<p>
Jeśli masz klucz klienta i wspólnego tajne hasło, możesz je wprowadzić podczas edycji egzemplarza zewnętrznego modułu (upewnij się, że zaawansowane opcje są widoczne). <br />
Alternatywnie, można utworzyć konfigurację dostawcy na poziomie kursu <a href="{$a->course_tool_editor}">tutaj</a>.
</p>';
$string['lti_tool_request_added'] = 'Prośba o konfigurację narzędzia pomyślnie wysłana. Być może trzeba będzie skontaktować się z administratorem, aby dokończyć konfigurację narzędzia.';
$string['lti_tool_request_existing'] = 'Prośba o konfigurację tego narzędzia była już wcześniej wysłana.';
$string['ltisettings'] = 'Ustawienia LTI';
$string['ltiversion'] = 'Wersja LTI';
$string['main_admin'] = 'Ogólna pomoc';
$string['main_admin_help'] = 'Narzędzie Zewnętrzny Moduł pozwala witrynie Moodle bezproblemowo i płynnie korzystać z zasobów edukacyjnych na zdalnych serwerach. Poprzez specjalny protokół uruchomienia, narzędzie zdalne będzie miało dostęp do pewnych ogólnych informacji na temat użytkownika, który je wywołał. Na przykład: nazwa instytucji, id kursu, id użytkownika i inne informacje, takie jak nazwa użytkownika lub adres e-mail.
Narzędzia wymienione na tej stronie są podzielone na trzy kategorie:
* ** Aktywne ** - Ci dostawcy treści zostali zatwierdzeni i skonfigurowani przez administratora. Mogą być  wykorzystani w dowolnym kursie na tej witrynie Moodle. Jeśli wprowadzi się klucz klienta i wspólne tajne hasło, nawiązywane jest zaufane połączenie między tym Moodle i zdalnym serwerem, zapewniając bezpieczny kanał komunikacji.
* ** Oczekujące ** - Ci dostawcy zostali zainstalowani poprzez import pakietów, ale nie zostali skonfigurowane przez administratora. Nauczyciele mogą korzystać z modułów od tych dostawców, jeśli mają klucz klienta i wspólnego tajne hasło, albo jeśli nie są one wymagane.
* ** Odrzucone ** - Ci dostawcy są oznaczeni jako ci, których administrator nie ma zamiaru udostępniać całej witrynie Moodle. Nauczyciele mogą korzystać z modułów od tych dostawców, jeśli mają klucz klienta i wspólnego tajne hasło, albo jeśli nie są one wymagane.';
$string['manage_external_tools'] = 'Zarządzaj modułami';
$string['manage_tool_proxies'] = 'Zarządzaj rejestracjami zewnętrznych narzędzi.';
$string['manage_tools'] = 'Zarządzaj skonfigurowanymi narzędziami';
$string['manuallyaddtype'] = 'Alternatywnie możesz <a href="{$a}">skonfigurować moduł ręcznie</a>.';
$string['miscellaneous'] = 'Różne';
$string['misconfiguredtools'] = 'Wykryto źle skonfigurowane narzędzia';
$string['missingparameterserror'] = 'Strona jest źle skonfigurowana: &quot;{$a}&quot;';
$string['module_class_type'] = 'Typ modułu Moodle';
$string['modulename'] = 'Narzędzie zewnętrzne';
$string['modulename_help'] = 'Zewnętrzne moduły pozwalają użytkownikom Moodle na interakcję z zasobami dydaktycznymi na innych stronach. Na przykład, zewnętrzne moduł może zapewnić dostęp do nowego rodzaju aktywności lub materiałów dydaktycznych od wydawcy.

Aby skonfigurować egzemplarz zewnętrznego modułu, niezbędny jest dostawca treści, który obsługuje LTI (Learning Tools Interoperability). Jeśli znajdziesz  dostawcę treści, który obsługuje LTI, powinnien on dostarczyć informację, jak skonfigurować egzemplarz zewnętrznego modułu. Dodatkowo, typy skonfigurowane przez administratora strony będą również dostępne.

Moduły zewnętrzne różnią się od zasobów URL na kilka sposobów:
* **Kontekst** - Moduły zewnętrzne mają dostęp do informacji na temat użytkownika, który uruchomił narzędzie, takich jak instytucja, kurs, nazwa i inne.
* **Głęboka integracja** - Moduły zewnętrzne obsługują odczyt, aktualizację i usuwanie ocen związanych z aktywnością. Więcej punktów integracyjnych jest planowanych w przyszłych wydaniach.
* **Bezpieczeństwo** - konfiguracje Zewnętrznych modułów zapewniają bezpieczne połączenie między Moodle i dostawca treści.';
$string['modulename_link'] = 'mod/lti/view';
$string['modulenameplural'] = 'Narzędzia zewnętrzne';
$string['modulenamepluralformatted'] = 'Narzędzia zewnętrzne';
$string['name'] = 'Nazwa';
$string['never'] = 'Nigdy';
$string['new_window'] = 'Nowe okno';
$string['no_lti_configured'] = 'Nie skonfigurowano żadnych aktywnych zewnętrznych narzędzi.';
$string['no_lti_pending'] = 'Brak oczekujących zewnętrznych narzędzi.';
$string['no_lti_rejected'] = 'Brak odrzuconych zewnętrznych narzędzi.';
$string['no_tp_accepted'] = 'Nie ma żadnych rejestracji zewnętrznych narzędzi zaakceptowania.';
$string['no_tp_configured'] = 'Nie ma żadnych skonfigurowanych, niezarejestrowanych zewnętrznych narzędzi';
$string['no_tp_rejected'] = 'Nie ma żadnych odrzuconych rejestracji zewnętrznych narzędzi';
$string['noattempts'] = 'W tym egzemplarzu modułu nie wykonano żadnych prób';
$string['noltis'] = 'Brak zewnętrznych instancji narzędzi';
$string['noservers'] = 'Nie znaleziono serwerów';
$string['notypes'] = 'Obecnie w Moodle nie są skonfigurowane żadne narzędzia LTI. Kliknij link Zainstaluj powyżej, aby dodać nowe narzędzia.';
$string['noviewusers'] = 'Nie znaleziono użytkowników z uprawieniami do użycia tego narzędzia';
$string['optionalsettings'] = 'Ustawienia opcjonalne';
$string['organization'] = 'Szczegóły organizacji';
$string['organizationdescr'] = 'Opis organizacji';
$string['organizationid_default'] = 'Domyślny identyfikator organizacji';
$string['organizationidguid'] = 'Identyfikator organizacji';
$string['organizationurl'] = 'Adres URL organizacji';
$string['organizationurl_help'] = 'Bazowy adres URL tej instancji Moodle.

Jeśli to pole jest puste, będzie używana wartość domyślna z konfiguracji witryny.';
$string['pagesize'] = 'Zgłoszeń na stronie';
$string['password'] = 'Wspólne tajne hasło';
$string['password_admin'] = 'Wspólne tajne hasło';
$string['password_admin_help'] = 'Wspólne tajne hasło można traktować jako hasło używane do uwierzytelniania dostępu do narzędzia.
Należy go użyć wraz z kluczem klienta uzyskanym od dostawcy narzędzia.

Narzędzia, które nie wymagają bezpiecznej komunikacji z Moodle i nie zapewniają dodatkowych usług (jak odsyłanie ocen) mogą nie wymagać wspólnego tajnego hasła.';
$string['password_help'] = 'W przypadku narzędzi wstępnie skonfigurowanych, nie jest konieczne wprowadzanie wspólnego tajnego hasła tutaj, ponieważ zrobiono to już w ramach procesu konfiguracji.

To pole należy wypełnić w przypadku tworzenia łącza do dostawcy, który nie jest jeszcze skonfigurowany. Jeśli dostawca ma być użyty wiele razy w tym kursie, dobrym pomysłem jest dodanie konfiguracji narzędzia na poziomie kursu.

Wspólne tajne hasło można traktować jako hasło używane do uwierzytelniania dostępu do narzędzia.
Należy go użyć wraz z kluczem klienta uzyskanym od dostawcy narzędzia.

Narzędzia, które nie wymagają bezpiecznej komunikacji z Moodle i nie zapewniają dodatkowych usług (jak odsyłanie ocen) mogą nie wymagać wspólnego tajnego hasła.';
$string['pending'] = 'Oczekujące';
$string['pluginadministration'] = 'Administracja zewnętrznymi narzędziami';
$string['pluginname'] = 'Narzędzie zewnętrzne';
$string['preferheight'] = 'Preferowana wysokość';
$string['preferwidth'] = 'Preferowana szerokość';
$string['press_to_submit'] = 'Naciśnij, aby uruchomić tę aktywność';
$string['privacy'] = 'Prywatność';
$string['privacy:metadata:createdby'] = 'Użytkownik, który utworzył rekord';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Ocena użytkownika w procentach';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Oryginalna ocena użytkownika';
$string['publickey'] = 'Klucz publiczny';
$string['quickgrade'] = 'Zezwól na szybkie ocenianie';
$string['quickgrade_help'] = 'Jeśli opcja jest włączona, wiele ocen może być wystawianych na jednym formularzu. Wpisz oceny i komentarze, a następnie kliknij przycisk "Zapisz wszystkie moje opinie", aby zapisać wszystkie zmiany z tej strony.';
$string['redirect'] = 'Zostaniesz przekierowany w ciągu kilku sekund. Jeśli nie, naciśnij przycisk.';
$string['register'] = 'Rejestruj';
$string['registertype'] = 'Skonfiguruj nową rejestrację zewnętrznego narzędzia';
$string['registration_options'] = 'Opcje rejestracji';
$string['registrationurl'] = 'Adres URL rejestracji';
$string['reject'] = 'Odrzuć';
$string['rejected'] = 'Odrzucone';
$string['resource'] = 'Zasób';
$string['resourcekey'] = 'Klucz klienta';
$string['resourcekey_admin'] = 'Klucz klienta';
$string['resourcekey_admin_help'] = 'Klucz klienta można traktować jako nazwę użytkownika używaną do uwierzytelniania dostępu do narzędzia. Może być użyty przez dostawcę treści, aby jednoznacznie zidentyfikować witrynę Moodle, a której użytkownik wywołał narzędzie.

Klucz klienta musi być dostarczony przez dostawcę treści. Sposób uzyskania klucza różni się u różnych dostawców. Może być zautomatyzowany lub wymagać dialogu z dostawcą.

Narzędzia, które nie wymagają bezpiecznej komunikacji z Moodle i nie zapewniają dodatkowych usług (jak odsyłanie ocen) mogą nie wymagać klucza klienta.';
$string['resourcekey_help'] = 'W przypadku narzędzi wstępnie skonfigurowanych, nie jest konieczne wprowadzanie klucza zasobu tutaj, ponieważ zrobiono to już w ramach procesu konfiguracji.

To pole należy wypełnić w przypadku tworzenia łącza do dostawcy, który nie jest jeszcze skonfigurowany. Jeśli dostawca ma być użyty wiele razy w tym kursie, dobrym pomysłem jest dodanie konfiguracji narzędzia na poziomie kursu.

Klucz klienta można traktować jako nazwę użytkownika używaną do uwierzytelniania dostępu do narzędzia. Może być użyty przez dostawcę treści, aby jednoznacznie zidentyfikować witrynę Moodle, a której użytkownik wywołał narzędzie.

Klucz klienta musi być dostarczony przez dostawcę treści. Sposób uzyskania klucza różni się u różnych dostawców. Może być zautomatyzowany lub wymagać dialogu z dostawcą.

Narzędzia, które nie wymagają bezpiecznej komunikacji z Moodle i nie zapewniają dodatkowych usług (jak odsyłanie ocen) mogą nie wymagać klucza zasobu.';
$string['resourceurl'] = 'URL zasobu';
$string['restricttocategory'] = 'Ogranicz do kategorii';
$string['restricttocategory_help'] = 'Aby ograniczyć użycie tego narzędzia do kursów w ramach określonej kategorii, wybierz kategorię lub kategorie z listy.';
$string['return_to_course'] = 'Kliknij <a href="{$a->link}" target="_top">tutaj</a> , aby powrócić do kursu.';
$string['saveallfeedback'] = 'Zapisz wszystkie moje opinie';
$string['search:activity'] = 'Narzędzie zewnętrzne - informacje o aktywności';
$string['secure_icon_url'] = 'Bezpieczny adres URL ikony';
$string['secure_icon_url_help'] = 'Pole używane zamiast ikony URL, jeśli użytkownik łączy się z Moodle przez SSL. Głównym celem tego pola jest to, żeby zapobiec ostrzeżeniom przeglądarki o wyświetlaniu niezabezpieczonych obrazów na stronie zabezpieczonej przez SSL.';
$string['secure_launch_url'] = 'Bezpieczny adres URL narzędzia';
$string['secure_launch_url_help'] = 'Zastępuje URL wywołania, gdy wymagany jest wysoki poziom bezpieczeństwa.
Moodle będzie używać bezpiecznego URL wywołania zamiast zwykłego, jeśli witryna Moodle jest wywołana poprzez protokół SSL, lub jeśli w konfiguracja narzędzia jest ustawione uruchamianie poprzez SSL.

Zwykły URL wywołania może być także ustawiony na adres https:, wtedy użyte będzie SSL, a to pole może być puste.';
$string['selectcontent'] = 'Wybierz zawartość';
$string['selectcontentvalidationerror'] = 'Musisz wybrać zawartość dla tej aktywności.';
$string['send'] = 'Wyślij';
$string['services'] = 'Usługi';
$string['services_help'] = 'Wybierz te usługi, które chcesz zaoferować dostawcy narzędzia. Można wybrać więcej niż jedną usługę.';
$string['setupoptions'] = 'Opcje konfiguracji';
$string['share_email'] = 'Udostępnij dostawcy email użytkownika';
$string['share_email_admin'] = 'Udostępnij dostawcy email użytkownika';
$string['share_email_admin_help'] = 'Określ, czy adres e-mail użytkownika, który wywołał zdalny moduł będzie udostępniony dostawcy treści. Dostawca treści może wymagać adresu e-mail, aby rozróżnić użytkowników o tej samej nazwie wyświetlanej lub wysłać e-mail do użytkowników w związku z funkcjami tego narzędzia.';
$string['share_email_help'] = 'Określ, czy adres e-mail użytkownika, który wywołał zdalny moduł będzie udostępniony dostawcy treści. Dostawca treści może wymagać adresu e-mail, aby rozróżnić użytkowników o tej samej nazwie wyświetlanej lub wysłać e-mail do użytkowników w związku z funkcjami tego narzędzia.
Należy pamiętać, że to ustawienie może być nadpisane w konfiguracji narzędzia.';
$string['share_name'] = 'Udostępnij dostawcy nazwę użytkownika';
$string['share_name_admin'] = 'Udostępnij dostawcy nazwę użytkownika';
$string['share_name_admin_help'] = 'Określ, czy pełna nazwa użytkownika, który wywołał zdalny moduł, będzie udostępniona dostawcy treści. Dostawca treści może wymagać tych nazw, aby wyświetlić informacje w sposób zrozumiały.';
$string['share_name_help'] = 'Określ, czy pełna nazwa użytkownika, który wywołał zdalny moduł, będzie udostępniona dostawcy treści. Dostawca treści może wymagać tych nazw, aby wyświetlić informacje w sposób zrozumiały.

Należy pamiętać, że to ustawienie może być nadpisane w konfiguracji tego narzędzia.';
$string['share_roster'] = 'Zezwól zdalnemu narzędziu na dostęp do listy użytkowników kursu.';
$string['share_roster_admin'] = 'Narzędzie ma dostęp do listy użytkowników';
$string['share_roster_admin_help'] = 'Określ, czy narzędzie ma dostęp do listy użytkowników zapisanych w kursie, z którego jest uruchomione.';
$string['share_roster_help'] = 'Określ, czy narzędzie ma dostęp do listy użytkowników zapisanych w tym kursie.

Należy pamiętać, że to ustawienie może być nadpisane w konfiguracji tego narzędzia.';
$string['showinactivitychooser'] = 'Pokaż w panelu wyboru aktywności';
$string['size'] = 'Parametry rozmiaru';
$string['submission'] = 'Zadanie';
$string['submissions'] = 'Zadania';
$string['submissionsfor'] = 'Zadania dla {$a}';
$string['toggle_debug_data'] = 'Przełączanie danych debugowania';
$string['tool_config_not_found'] = 'Nie znaleziono konfiguracji narzędzia dla tego adresu URL.';
$string['tool_settings'] = 'Ustawienia narzędzia';
$string['toolisbeingused'] = 'To narzędzie jest używane {$a} raz(y)';
$string['toolisnotbeingused'] = 'To narzędzie nie zostało jeszcze użyte';
$string['toolproxy'] = 'Zewnętrzne narzędzia rejestracji';
$string['toolsetup'] = 'Konfiguracja zewnętrznego narzędzia';
$string['toolurl'] = 'Adres URL narzędzia';
$string['toolurl_help'] = 'Adres URL narzędzia jest używany do dopasowania adresów URL narzędzi do prawidłowej konfiguracji narzędzia. Dodanie prefiksu http(s) do adresu URL jest opcjonalne.

Ponadto adres URL bazowy jest używany jako adres URL narzędzia, jeśli adres URL narzędzia nie jest określony w zewnętrznej instancji narzędzia.

Na przykład, podstawowy adres URL *tool.com* będzie pasował do następującego:
* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Podstawowy adres URL *www.tool.com/quizzes* będzie pasował do następującego:
* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Podstawowy adres URL *quiz.tool.com* będzie pasował do następującego:
* quiz.tool.com
* quiz.tool.com/take.php?id=10

Jeśli dwie różne konfiguracje narzędzi są dla tej samej domeny, zostanie użyte najbardziej szczegółowe dopasowanie.

Możesz również wstawić adres URL kasety, jeśli go posiadasz, a szczegóły dotyczące narzędzia zostaną automatycznie wypełnione.';
$string['toolurlplaceholder'] = 'Adres URL narzędzia';
$string['typename'] = 'Nazwa narzędzia';
$string['typename_help'] = 'Nazwa narzędzia jest używana do identyfikacji dostawcy treści w Moodle. Wprowadzona tu nazwa będzie widoczna dla nauczycieli podczas dodawania zewnętrznych treści do kursów.';
$string['types'] = 'Typy';
$string['unabletocreatetooltype'] = 'Nie można utworzyć narzędzia';
$string['unabletofindtooltype'] = 'Nie można znaleźć narzędzia dla {$a->id}';
$string['unknownstate'] = 'Nieznany status';
$string['update'] = 'Aktualizuj';
$string['usage'] = 'Liczba użyć';
$string['useraccountinformation'] = 'Informacje o koncie użytkownika';
$string['userpersonalinformation'] = 'Dane osobowe użytkownika';
$string['using_tool_configuration'] = 'Użyto konfiguracji:';
$string['validurl'] = 'Prawidłowy adres URL musi zaczynać się od http(s)://';
$string['viewsubmissions'] = 'Wyświetl rozwiązania i ekran oceniania';
