<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'taskchain', language 'af', version '4.5'.
 *
 * @package     taskchain
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abandoned'] = 'Afgegooi';
$string['activitycloses'] = 'TaskChain-aktiwiteit sluit';
$string['activitygrade'] = 'Aktiwiteitpunt';
$string['activityname'] = 'Aktiwiteitnaam';
$string['activityopens'] = 'TaskChain-aktiwiteit open';
$string['added'] = 'Bygevoeg';
$string['addtaskchain_help'] = '**Nee**
Slegs een taak sal by die kursus gevoeg word

**Ja**
As die brondokument \'n **taakdokument** is, word dit as die begin van \'n ketting van take behandel en sal alle take in die ketting by die kursus met identiese verstellings gevoeg word. Elke taak in die ketting moet \'n skakel na die volgende dokument in die ketting hê.

As die brondokument \'n **lêer** is, sal alle herkenbare take in die lêer by die kursus gevoeg word om \'n ketting van take met identiese verstellings te vorm.

As die brondokument \'n **kettingdokument** is, soos Hot Potatoes masher-dokument of index.html, sal take wat in die kettingdokument gelys is, by die kursus gevoeg word as \'n ketting van take met identiese verstellings.';
$string['addtasks'] = 'Voeg (meer) take by';
$string['addtype'] = 'Dokumente om by te voeg';
$string['addtype_help'] = 'Watter dokumente behoort as take bygevoeg te word?

**Bespeur outomaties**
: As \'n dokument geselekteer is, word dit óf hanteer as \'n **taakdokument** aan die begin van \'n ketting van take, of as **kettingdokument** wat \'n lys dokumente bevat wat bygevoeg moet word. As geen dokument gekies is nie, word alle herkenbare dokumente in die lêer as take bygevoeg.

**Voeg slegs geselekteerde dokument by**
: Slegs die geselekteerde brondokument sal by hierdie aktiwiteit as taak bygevoeg word.

**Voeg ketting by wat by geselekteerde dokument begin**
: Daar word aanvaar dat die geselekteerde brondokument \'n **taakdokument** aan die begin van \'n ketting van take is. Alle take in die ketting sal by hierdie aktiwiteit gevoeg word. Elke taak moet \'n skakel na die volgende taak in die ketting hê.

**Voeg alle dokumente by wat in geselekteerde dokument gelys is**
: Daar word aanvaar dat die geselekteerde brondokument \'n **kettingdokument** is, soos \'n Hot Potatoes masher-dokument of index.hrml. Enige take wat in die geselekteerde dokument gelys is, sal by hierdie aktiwiteit gevoeg word.


**Voeg alle dokumente in geselekteerde lêer by**
: Alle herkenbare taakdokumente in die bronlêer sal by hierdie aktiwiteit gevoeg word.

**Voeg alle dokumente in alle lêers by**
: Alle herkenbare taakdokumente in die bronlêer en al die sublêers daarvan sal by hierdie aktiwiteit gevoeg word.';
$string['addtypeauto'] = 'Bespeur outomaties';
$string['addtypechainfile'] = 'Voeg alle dokumente wat in geselekteerde dokument gelys is, by';
$string['addtypechainfolder'] = 'Voeg alle dokumente wat in geselekteerde lêer gelys is, by';
$string['addtypechainfolders'] = 'Voeg alle dokumente in alle lêers by';
$string['addtypetaskchain'] = 'Voeg ketting vanaf geselekteerde dokument by';
$string['addtypetaskfile'] = 'Voeg slegs geselekteerde dokument by';
$string['afterattempt'] = 'Ná poging';
$string['afterclose'] = 'Ná sluiting';
$string['aftertaskid'] = 'Ná opdrag';
$string['aftertaskid_help'] = 'Ná opdrag';
$string['allowfreeaccess'] = 'Laat vrye toegang toe';
$string['allowfreeaccess_help'] = 'Hierdie verstelling spesifiseer of studente vrye toegang tot die take in die TaskChain verleen word.

Wanneer studente vrye toegang het, kan hulle toegang tot enige taak in die TaskChain verkry, ongeag die taak se pre-voorwaardes en post-voorwaardes.

**Nee**
: Die studente sal nie vrye toegang tot take in die TaskChain ontvang nie. M.a.w. sal toegang tot die take altyd deur die take se pre-voorwaardes en post-voorwaardes beheer word.

**Ja: Punte**
: Die studente sal vrye toegang tot die take in die TaskChain ontvang sodra hulle die vereiste punt behaal het.

**Ja: Pogings**
: Die studente sal vrye toegang tot die take in die TaskChain ontvang sodra hulle die vereiste aantal pogings voltooi het.';
$string['allowpaste'] = 'Laat plak toe';
$string['allowpaste_help'] = 'As hierdie verstelling ontsper is, sal studente toegelaat word om teks in tekstoevoerbokse te kopieer, plak en te sleep.';
$string['allowresume'] = 'Laat hervat toe';
$string['allowresume_help'] = 'Hierdie verstellings spesifiseer of studente \'n poging kan hervat, of nie.

**Nee**
: Pogings kan nie hervat word nie.

**Ja**
: Studente sal die keuse gegun word om enige vorige pogings wat nog onvoltooid is, te hervat, of om met \'n nuwe poging te begin.

**Dwing**
: As daar \'n vorige poging is wat nog nie voltooi is nie, sal studente gedwing word om daardie poging te hervat. Andersins kan hulle \'n nuwe poging begin.';
$string['allowreview'] = 'Laat revisie toe';
$string['allowreview_help'] = 'Indien ontsper, kan studente hul taakpogings hersien nadat die taak gesluit het.';
$string['allpostconditions'] = 'Alle post-voorwaardes';
$string['allpreconditions'] = 'Alle pre-voorwaardes';
$string['answers'] = 'Antwoorde';
$string['answersshort'] = 'A';
$string['anyattempts'] = 'Enige pogings';
$string['anygroup'] = 'Enige groep';
$string['applydefaults'] = 'Pas gekose verstek waardes toe';
$string['assessment_help'] = 'Die assesseringsverstellings vir TaskChain-kettings en -take definieer die volgende:

<ul>
<li>Hoe die taakpogings gekombineer word om \'n enkele taakpunt te vorm</li>
<li>Die bydrae van die taakpunt tot die punt van \'n enkele kettingpoging</li>
<li>Hoe die kettingpogingpunte gekombineer word om \'n enkele kettingpunt te verkry</li>
</ul>

**Taakpogingpunte**
Die taakpogingpunte word met die volgende berekening genormaliseer:

<table border="0"><tbody><tr>
<td align="center" valign="middle">
<tt>(attempt score - minimum score)</tt>
<tt>------------------------------</tt><br \\>
<tt>maximum score</tt>
</td>
<td align="center" valign="middle"><big><big> &nbsp; X &nbsp; </big></big></td>
<td align="center" valign="middle">
<tt>score limit</tt>
<tt>-----------</tt><br \\>
<tt>100</tt>
</td>
</tr></tbody></table>

**Taakpunt**
Afhangende van die taak se puntmetodeverstelling, word die punt vir die taak gestel op die eerste, laaste, hoogste of gemiddeld van die genormaliseerde taakpogingpunte.

Die taakpunte word dan met die volgende berekening verswaar:

<table border="0"><tbody><tr>
<td align="center" valign="middle">
<tt>task score</tt>
</td>
<td align="center" valign="middle"><big><big> &nbsp; X &nbsp; </big></big></td>
<td align="center" valign="middle">
<tt>score weighting</tt>
<tt>--------------</tt><br \\>
<tt>100</tt>
</td>
</tr></tbody></table>

**Kettingpogingpunt**
Die kettingpogingpunt word op die totaal, hoogste of laagste van die verswaarde taakpunte gestel, afhangend van die ketting se pogingpuntmetodeverstelling.

**Kettingpunt**
Die punt vir die ketting word op die eerste, laaste, hoogste of gemiddelde kettingpogingpunt gestel, afhangend van die ketting se puntmetodeverstelling.

Uiteindelik word die punt volgens die volgende berekening verswaar:

<table border="0"><tbody><tr>
<td align="center" valign="middle">
<tt>chain grade</tt>
</td>
<td align="center" valign="middle"><big><big> &nbsp; X &nbsp; </big></big></td>
<td align="center" valign="middle">
<tt>grade weighting</tt>
<tt>-----------</tt><br \\>
<tt>100</tt>
</td>
</tr></tbody></table>';
$string['assessmenthdr'] = 'Assessering';
$string['attemptcount'] = 'Pogingtelling';
$string['attemptcount_help'] = 'Indien ontsper, spesifiseer hierdie verstelling die maksimum of minimum aantal pogings wat aan die punt- en tydsduurvoorwaardes moet voldoen.

**>=** (groter as of gelyk aan)
Die minimum aantal pogings wat aan die punt- en tydsduurvoorwaardes moet voldoen.

**<=** (minder as of gelyk aan)
Die maksimum aantal pogings wat aan die punt- en tydsduurvoorwaardes moet voldoen.';
$string['attemptdelay'] = 'Pogingvertraging';
$string['attemptdelay_help'] = 'Indien ontsper, spesifiseer hierdie verstelling die minimum of maksimum vertraging sedert die pogings, wat aan die punt- en tellingvoorwaardes voldoen.

**>=** (groter as of gelyk aan)
Die minimum vertraging sedert die pogings, wat aan die punt- en tellingvoorwaardes moet voldoen.

**<=** (minder as of gelyk aan)
Die maksimum vertraging sedert pogings, wat aan die punt- en tellingvoorwaardes moet voldoen.';
$string['attemptduration'] = 'Duur van poging';
$string['attemptduration_help'] = 'Indien ontsper, spesifiseer hierdie verstelling die minimum of maksimum tydsduur van die pogings wat aan die punt- en tellingvoorwaardes moet voldoen.

**>=** (groter as of gelyk aan)
Die minimum tydsduur van die pogings, wat aan die punt- en tellingvoorwaardes moet voldoen.

**<=** (minder as of gelyk aan)
Die maksimum  tydsduur van die pogings, wat aan die punt- en tellingvoorwaardes moet voldoen.';
$string['attempted'] = 'Gepoog';
$string['attemptgrade'] = 'Pogingpunt';
$string['attemptgrademethod'] = 'Graderingsmetode van poging';
$string['attemptgrademethod_help'] = 'Hierdie verstelling definieer hoe die gradering van \'n enkele poging van hierdie TaskChain-aktiwiteit bereken word.

**Totaal**
: Die pogingpunt sal gestel word na die som van die verswaarde taakpunte.

**hoogste**
: Die pogingpunt sal gestel word na die hoogste verswaarde taakpunt.

**Laaste**
: Die pogingpunt sal gestel word na die verswaarde punt van die mees onlangs gepoogde taak.

**Laaste (voltooid)**
: Die pogingpunt sal gestel word na die verswaarde punt van die mees onlangs gepoogde taak waarvan die status "voltooid" is. Ander take sal geïgnoreer word.

**Laaste (tyd verstreke)**
: Die pogingpunt sal gestel word na die verswaarde punt van die mees onlangs gepoogde taak waarvan die status "voltooid" of "tyd verstreke" is. Ander taakpunte sal geïgnoreer word.

**Laaste (afgegooi)**
: Die pogingpunt sal gestel word na die verswaarde punt van die mees onlangs gepoogde taak waarvan die status "voltooid" of "tyd verstreke" of "afgegooi" is. Take waarvan die status "besig" is, sal geïgnoreer word.';
$string['attemptlimit'] = 'Pogingbeperking';
$string['attemptlimit_help'] = 'Die maksimum aantal pogings wat \'n student vir hierdie TaskChain-aktiwiteit kan hê.';
$string['attemptnumber'] = 'Pogingnommer';
$string['attempts'] = 'Pogings';
$string['attemptsallowed'] = 'Pogings toegelaat';
$string['attemptscore'] = 'Pogingpunt';
$string['attemptshdr'] = 'Pogingbeperkings';
$string['attemptsunlimited'] = 'Onbeperkte pogings';
$string['attempttasknow'] = 'Poog taak nou';
$string['attempttype'] = 'Pogingtipe';
$string['attempttype_help'] = 'Hierdie verstelling spesifiseer die tipe pogings wat deur die pogingtelling-voorwaarde oorweeg moet word.

**Enige pogings**
Enige pogings sal oorweeg word.

**Mees onlangse pogings**
Slegs die mees onlangse pogings sal oorweeg word.

**Opeenvolgende pogings**
Enige blok opeenvolgende pogings sal oorweeg word.';
$string['average'] = 'Gemiddeld';
$string['averagegrade'] = 'Gemiddelde punt';
$string['averagescore'] = 'Gemiddelde punt';
$string['bodystyles'] = 'Liggaamstyle';
$string['bodystylesbackground'] = 'Agtergrondkleur en -prent';
$string['bodystylescolor'] = 'Tekskleur';
$string['bodystylesfont'] = 'Fontgrootte en -familie';
$string['bodystylesmargin'] = 'Linker- en regterkantlyn';
$string['cacherecords'] = 'TaskChain-kasrekords';
$string['cannotread'] = 'Kan nie dokument lees nie (of dokument is leeg!) {$a}';
$string['canrestartchain'] = 'Jou uitslae tot dusver sal geberg word, maar as jy hierdie aktiwiteit later weer wil oordoen, sal jy van voor af moet begin.';
$string['canrestarttask'] = 'Jou uitslae tot dusver sal geberg word en jy kan "{$a}" later oordoen';
$string['canresumetask'] = 'Jou uitslae tot dusver sal geberg word en jy kan later met "{$a}" aangaan.';
$string['chain'] = 'TaskChain-aktiwiteit';
$string['chainattempt'] = 'Chain-poging';
$string['chainattemptnotinprogress'] = 'Chain-poging nie aan die gang nie';
$string['chainclosed'] = 'Jammer, hierdie aktiwiteit het op {$a} gesluit';
$string['chaingrade'] = 'Chain-punt';
$string['chainname_help'] = 'Die naam van hierdie TaskChain-aktiwiteit wat op die kursusblad vertoon sal word.';
$string['chainnotavailable'] = 'Jammer, hierdie aktiwiteit is nie voor {$a} aan jou beskikbaar nie.';
$string['chainrequirepasswordmessage'] = 'Om hierdie aktiwiteit te probeer doen, moet jy die wagwoord ken.';
$string['checks'] = 'Merke';
$string['checksomeboxes'] = 'Merk asseblief van die bokse';
$string['classreports'] = 'Klasverslae';
$string['clearcache'] = 'Maak TaskChain-kasgeheue skoon';
$string['cleardetails'] = 'Maak TaskChain-besonderhede skoon';
$string['clearedcache'] = 'Die TaskChain-kasgeheue is skoongemaak';
$string['cleareddetails'] = 'Die TaskChain-besonderhede is skoongemaak';
$string['clickreporting'] = 'Ontsper kliekrapportering';
$string['clickreporting_help'] = 'Indien ontsper, word \'n aparte rekord gehou elke keer wat \'n "wenk-", "leidraad-" of "merk"-knoppie gekliek word. Dit laat toe dat die onderwyser \'n baie gedetailleerde verslag kan sien wat die toestand van die taak met elke kliek toon. Andersins word slegs een rekord per taakpoging behou.';
$string['clues'] = 'Leidrade';
$string['cnumber'] = 'Kettingpoging';
$string['columnlist'] = 'Kolomlys {$a}';
$string['columnlistid'] = 'Vertoon kolomme';
$string['columnlistid_help'] = 'Hierdie kieslys laat jou toe om te kies watter kolomme op hierdie bladsye vertoon word.';
$string['columnlistschain'] = 'Alle ketting-kolomlyste';
$string['columnlistschains'] = 'Kolomlyste vir die wysiging van kettings';
$string['columnliststask'] = 'Alle taak-kolomlyste';
$string['columnliststasks'] = 'Kolomlyste vir die wysiging van take';
$string['completed'] = 'Voltooid';
$string['completedalltasks_close'] = 'As jy hierdie poging wil voltooi en toemaak, kliek die knoppie hieronder.<br />Let daarop dat jy nie take in hierdie poging sal kan oordoen nadat dit toegemaak is nie.';
$string['completedalltasks_redo'] = 'As jy een van die take in hierdie aktiwiteit wil oordoen, kliek op die naam van die taak in die lys hieronder.';
$string['completedalltasks_title'] = 'Veels geluk!<br />Jy het al die take in hierdie aktiwiteit voltooi.';
$string['completioncompleted'] = 'Vereis voltooide status';
$string['completionmingrade'] = 'Vereis minimum punt';
$string['completionpass'] = 'Vereis slaagpunt';
$string['completionwarning'] = 'Hierdie velde word ontsper as die puntbeperking vir hierdie aktiwiteit "Geen punt" is, of as die puntgewig "Geen verswaring" is.';
$string['conditions'] = 'Voorwaardes';
$string['conditionscore'] = 'Voorwaardepunt';
$string['conditionscore_help'] = 'Indien ontsper, spesifiseer hierdie verstelling die maksimum of minimum punt waarteen hierdie voorwaarde bevredig word.

**>=** (meer as of gelyk aan)
Die minimum punt waarteen hierdie voorwaarde bevredig word.

**<=** (minder as of gelyk aan)
Die maksimum punt waarteen hierdie voorwaarde bevredig word.';
$string['conditiontaskid'] = 'Voorwaardetaak';
$string['conditiontaskid_help'] = 'Hierdie verstelling spesifiseer die taak waarna hierdie pre-voorwaarde verwys.

**Vorige taak**
Hierdie voorwaarde verwys na die vorige taak in hierdie ketting,
volgens sorteervolgorde.

**Spesifieke taak**
Die onderwyser kan ook \'n spesifieke taak kies waarna hierdie pre-voorwaarde verwys.
Om verwarring te voorkom wat veroorsaak word deur take met identiese name,
word die taaksorteernommers agteraan die taakname gesit.';
$string['configbodystyles'] = 'By verstek sal Moodle-temastyle Task-Chain-aktiwiteitstyle oorheenskryf. Vir enige style wat hier gekies is, sal die TaskChain-aktiwiteitstyle (wat enige style insluit wat in taakbrondokumente, soos Hot Potatoes-dokumente gedefinieer is) egter voorkeur bo die Moodle-temastyle hê.';
$string['configenablecache'] = 'Handhawing van \'n kasgeheue van TaskChain-take kan dramaties die aflewering van take aan die studente versnel.';
$string['configenablecron'] = 'Spesifiseer die ure in jou tydsone waarin die TaskChain-cron-teks mag loop';
$string['configenablemymoodle'] = 'Hierdie verstellings beheer of TaskChains op die MyMoodle-bladsy gelys word, of nie.';
$string['configenableobfuscate'] = 'Verduistering van die teksstringe en URL\'e in javatekskode maak dit moeiliker om antwoorde te raai deur na die bron van die HTML-blad in die blaaier te kyk.';
$string['configenableswf'] = 'Laat vaslegging van SWF-dokumente in TaskChain-aktiwiteite toe. Indien ontsper, skryf hierdie verstelling filter_mediaplugin_enable_swf oorheen.';
$string['configfile'] = 'Konfigurasiedokument';
$string['configfile_help'] = 'Indien gespesifiseer, sal die konfigurasiedokument gebruik word wanneer die blaaierinhoud uit die brondokument gegenereer word.

Die presiese funksie van die konfigurasiedokument hang van die afvoerformaat af, maar gewoonlik sal die verstellings in die konfigurasie dié in die brondokument oorheenskryf.

Deur dieselfde konfigurasie vir etlike take te gebruik, kan die take dieselfde boodskappe, kleurskema, uitleg of gedrag gedeel laat word.

Vir **Hot Potatoes** take is die konfigurasiedokument \'n &quot;.cfg&quot; dokument. Vir **Qedoc** take word hierdie verstelling nie gebruik nie.';
$string['configfilenotfound'] = 'Konfig-dokument is nie gevind nie: {$a}';
$string['configframeheight'] = 'Wanneer \'n taak in \'n raam vertoon word, is hierdie waarde die hoogte (in beeldelemente) van die boonste raam wat die Moodle-navigasiestaaf bevat.';
$string['configlocation'] = 'Konfigureer dokumentligging';
$string['configlocation_help'] = 'Die ligging van die konfigurasiedokument.';
$string['configlockframe'] = 'As hierdie verstelling ontsper is, sal die navigasieraam, indien dit gebruik word, gesluit word sodat dit nie gerol kan word nie, die grootte nie verstel kan word nie en dit geen raam het nie.';
$string['configmaxeventlength'] = 'As \'n TaskChain beide \'n aanvang- en sluitingstyd gespesifiseer het, en die verskil tussen die twee tye groter is as die aantal dae wat hier gespesifiseer is, sal twee aparte kalendergebeurtenisse by die kursuskalender gevoeg word. Vir korter tydperke of wanneer net een tyd gespesifiseer is, sal slegs een kalendergebeurtenis bygevoeg word. Indien nie een van die tye gespesifiseer is nie, sal geen kalendergebeurtenis bygevoeg word nie.';
$string['configstoredetails'] = 'As hierdie verstelling ontsper is, sal die rou XML-besonderhede van pogings tot TaskChain-take in die taskchain_details-tabel geberg word. Dit laat toe dat taakpogings in die toekoms hergegradeer kan word om veranderinge in die TaskChain-taakpuntestelsel te weerspieël. Die ontsper van hierdie opsie op \'n besige werf sal egter veroorsaak dat die taskchain_details-tabel baie vinnig groei.';
$string['confirmdeleteallpostconditions'] = 'Is jy seker jy wil ALLE post-voorwaardes uitwis?';
$string['confirmdeleteallpreconditions'] = 'Is jy seker jy wil ALLE pre-voorwaardes uitwis?';
$string['confirmdeleteattempts'] = 'Is jy seker jy wil die gekose pogings uitwis?';
$string['confirmdeletechainscolumnlist'] = 'Is jy seker jy wil hierdie kettingkolomlys uitwis: {$a}';
$string['confirmdeletechainscolumnlists'] = 'Is jy seker jy wil ALLE kettingkolomlyste uitwis?';
$string['confirmdeletepostcondition'] = 'Is jy seker jy wil hierdie post-voorwaarde uitwis?';
$string['confirmdeleteprecondition'] = 'Is jy seker jy wil hierdie pre-voorwaarde uitwis?';
$string['confirmdeletetask'] = 'Is jy seker jy wil hierdie taak uitwis?';
$string['confirmdeletetaskscolumnlist'] = 'Is jy seker jy wil hierdie taakkolomlyste uitwis: {$a}';
$string['confirmdeletetaskscolumnlists'] = 'Is jy seker jy wil ALLE taakkolomlyste uitwis?';
$string['confirmregradeattempts'] = 'Is jy seker jy wil die gekose pogings uitwis?';
$string['confirmstop'] = 'Is jy seker jy wil weg van hierdie bladsy navigeer?';
$string['consecutiveattempts'] = 'Opeenvolgende pogings';
$string['correct'] = 'Korrek';
$string['couldnotinsertsubmissionform'] = 'Kon nie indieningsvorm invoeg nie';
$string['d_index'] = 'Diskriminasie-indeks';
$string['delay'] = 'Vertraging';
$string['delay1'] = 'Vertraging 1';
$string['delay1_help'] = 'Die minimum vertraging tussen die eerste en tweede pogings.';
$string['delay1summary'] = 'Tydvertraging tussen eerste en tweede poging';
$string['delay2'] = 'Vertraging 2';
$string['delay2_help'] = 'Die minimum vertraging tussen pogings ná die tweede poging.';
$string['delay2summary'] = 'Tydvertraging tussen latere pogings';
$string['delay3'] = 'Vertraging 3';
$string['delay3_help'] = 'Hierdie verstelling spesifiseer die vertraging tussen voltooiing van die taak en teruggee van beheer van die vertoonskerm aan Moodle.

**Gebruik spesifieke vertraging**
: beheer sal aan Moodle teruggegee word ná die gespesifiseerde vertraging.

**Gebruik verstellings in bron-/templaatdokument**
: beheer sal aan Moodle teruggegee word ná die aantal sekondes wat in die brondokument of die templaatdokumente van hierdie afvoerformaat gespesifiseer is.

**Wag totdat student OK kliek**
: beheer sal aan Moodle teruggegee word ná die student die OK-knoppie op die voltooiingsboodskap in die taak gekliek het.

**Moet nie outomaties voortgaan nie**
: beheer sal nie aan Moodle teruggegee word nadat die taak voltooi is nie. Die student sal vry wees om van die taakblad af weg te navigeer.

Let wel, die taakuitslae word altyd aan Moodle teruggegee direk nadat die taak voltooi of afgegooi word, ongeag hierdie verstelling.';
$string['delay3afterok'] = 'Wag totdat student OK kliek';
$string['delay3disable'] = 'Moet nie outomaties voortgaan nie';
$string['delay3specific'] = 'Gebruik spesifieke vertraging';
$string['delay3summary'] = 'Tydvertraging aan die einde van die taak';
$string['delay3template'] = 'Gebruik verstellings in bron-/templaatdokument';
$string['deleteallattempts'] = 'Wis alle pogings uit';
$string['deleteallcolumnlistschain'] = 'Wis ALLE kettingkolomlyste uit';
$string['deleteallcolumnliststask'] = 'Wis ALLE taakkolomlyste uit';
$string['deleteallpostconditions'] = 'Wis ALLE post-voorwaardes uit';
$string['deleteallpreconditions'] = 'Wis ALLE pre-voorwaardes uit';
$string['deleteattempts'] = 'Wis pogings uit';
$string['deletecolumnlistchain'] = 'Wis kettingkolomlys {$a} uit';
$string['deletecolumnlisttask'] = 'Wis taakkolomlys {$a} uit';
$string['deletepostcondition'] = 'Wis \'n post-voorwaarde uit';
$string['deleteprecondition'] = 'Wis \'n pre-voorwaarde uit';
$string['deletetasks'] = 'Wis gekose take uit';
$string['detailsrecords'] = 'TaskChain-besonderhederekords';
$string['discarddetails'] = 'Verwerp besonderhede';
$string['discarddetails_help'] = 'As hierdie verstelling op "Ja" gestel is, sal die XML-besonderhede van elke poging van hierdie taak verwerp word, andersins sal die XML-besonderhede in die databasis geberg word vir moontlike toekomstige verwysing.';
$string['duration'] = 'Tydsduur';
$string['duringattempt'] = 'Tydens poging';
$string['editchains'] = 'Wysig kettings';
$string['editcolumnlistschain'] = 'Wysig kolomme vir TaskChain-kettings';
$string['editcolumnliststask'] = 'Wysig kolomme vir TaskChain-kettings';
$string['edittasks'] = 'Wysig take';
$string['enablecache'] = 'Ontsper TaskChain-kasgeheue';
$string['enablecron'] = 'Ontsper TaskChain-cron';
$string['enablemymoodle'] = 'Vertoon TaskChains op MyMoodle';
$string['enableobfuscate'] = 'Ontsper verdoeseling van teks- en mediaspelers';
$string['enableswf'] = 'Laat vaslegging van SWF-dokumente in TaskChain-aktiwiteite toe';
$string['endofchain'] = 'Einde van ketting';
$string['entry_attempts'] = 'Pogings';
$string['entry_dates'] = 'Datums';
$string['entry_grading'] = 'Gradering';
$string['entry_title'] = 'Kettingnaam as titel';
$string['entrycm'] = 'Vorige aktiwiteit';
$string['entrycm_help'] = 'Hierdie verstelling spesifiseer \'n Moodle-aktiwiteit en \'n minimum punt vir daardie aktiwiteit wat behaal moet word voordat hierdie TaskChain-aktiwiteit gepoog kan word.

Die onderwyser kan \'n spesifieke aktiwiteit kies,
of een van die volgende algemene doelwit-verstellings:

* Vorige aktiwiteit in hierdie kursus
* Vorige aktiwiteit in hierdie afdeling
* Vorige gegradeerde aktiwiteit in hierdie kursus
* Vorige gegradeerde aktiwiteit in hierdie afdeling
* Vorige TaskChain in hierdie kursus
* Vorige TaskChain in hierdie afdeling';
$string['entrycmcourse'] = 'Vorige aktiwiteit in hierdie kursus';
$string['entrycmsection'] = 'Vorige aktiwiteit in hierdie kursusafdeling';
$string['entrycompletionwarning'] = 'Voordat jy met hierdie aktiwiteit begin, moet jy na {$a} kyk.';
$string['entrygrade'] = 'Punt van vorige aktiwiteit';
$string['entrygradedcourse'] = 'Vorige gegradeerde aktiwiteit in hierdie kursus';
$string['entrygradedsection'] = 'Vorige gegradeerde aktiwiteit in hierdie kursusafdeling';
$string['entrygradewarning'] = 'Jy kan nie met hierdie aktiwiteit begin voordat jy {$a->entrygrade}% op {$a->entryactivity} verkry nie. Tans is jou punt vir daardie aktiwiteit {$a->usergrade}%';
$string['entryoptions'] = 'Toegangsbladopsies';
$string['entryoptions_help'] = 'Hierdie merkbokse ontsper en versper die vertoon van items op die TaskChain se toegangsblad.

**Kettingnaam as titel**
: Indien gemerk, sal die kettingnaam as titel van die toegangsblad vertoon word.

**Gradering**
: Indien gemerk, sal die TaskChain se graderingsinligting op die toegangsblad vertoon word.

**Datums**
: Indien gemerk, sal die TaskChain se aanvang- en sluitingsdatums op die toegangsblad vertoon word.

**Pogings**
: Indien gemerk, sal \'n tabel wat die besonderhede van \'n gebruiker se vorige pogings van hierdie TaskChain vertoon, op die toegangsblad vertoon word. Pogings wat hervat kan word, sal \'n hervat-knoppie in die regterkantste kolom hê.';
$string['entrypage'] = 'Vertoon toegangsblad';
$string['entrypage_help'] = 'Behoort \'n aanvanklike blad aan studente vertoon te word voordat die TaskChain-aktiwiteit begin?

**Ja**
: Daar sal \'n toegangsblad aan die studente vertoon word voordat hulle met die TaskChain begin. Die inhoud van die toegangsblad word deur die TaskChain se toegangsbladopsies bepaal.

**Nee**
: Daar sal nie \'n toegangsblad aan die studente vertoon word nie en die TaskChain sal onmiddellik begin.

\'n Toegangsblad word altyd aan die onderwyser vertoon, om toegang tot die verslae en wysig take-blad te bied.';
$string['entrypagehdr'] = 'Toegangsblad';
$string['entrytaskchaincourse'] = 'Vorige TaskChain in hierdie kursus';
$string['entrytaskchainsection'] = 'Vorige TaskChain in hierdie kursusafdeling';
$string['entrytext'] = 'Teks van Toegangsblad';
$string['error_formhelperclassnotfound'] = 'TaskChain-vorm hulpklas is nie gevind nie: {$a}';
$string['error_formhelperfilenotfound'] = 'TaskChain-vorm hulpdokument is nie gevind nie: {$a}';
$string['error_getprivateproperty'] = 'Kan nie direk toegang tot privaat eiendom, {$a->property}, van {$a->class}-voorwerp kry nie. Gebruik eerder {$a->method}.';
$string['error_getunknownproperty'] = 'Kan nie toegang tot onbekende eiendom, {$a->property}, van {$a->class}-voorwerp kry nie.';
$string['error_insertrecord'] = 'Kon nie rekorddatabasistabel {$a} invoeg nie.';
$string['error_missingclass'] = 'Voorwerpklas is nie gevind nie: {$a}';
$string['error_nocolumns'] = 'Kies asseblief kolomme';
$string['error_nocourseid'] = 'Geen kursus-id nie';
$string['error_nodatabaseinfo'] = 'Geen databasisinligting is beskikbaar nie';
$string['error_noinputparameters'] = 'Geen toevoerparameters nie';
$string['error_norecordsfound'] = 'Geen rekords is gevind nie';
$string['error_recordclassnotfound'] = 'TaskChain-rekordklas is nie gevind nie: {$a}';
$string['error_setprivateproperty'] = 'Kan nie privaat eiendom {$a->property}, van {$a->class}-voorwerp direk wysig nie. Gebruik eerder {$a->method}.';
$string['error_setpropertydirectly'] = 'Kan nie {$a->property} eiendom van {$a->class}-voorwerp direk wysig nie. Gebruik eerder {$a->method}.';
$string['error_setunknownproperty'] = 'Kan nie onbekende eiendom, {$a->property}, van {$a->class}-voorwerp wysig nie.';
$string['error_unrecognizedpageid'] = 'TaskChain-bladsy-id word nie herken nie: {$a}';
$string['error_updaterecord'] = 'Kon nie rekord in databasistabel bywerk nie: {$a}';
$string['event_attempt_started'] = 'TaskChain-poging is begin';
$string['event_attempt_started_description'] = 'Die gebruiker met id "{$a->userid}" het \'n poging van \'n taak in die "taskchain"-aktiwiteit met kursusmodule-id "{$a->cmid}" begin.';
$string['event_attempt_started_explanation'] = '\'n Gebruiker het pas \'n poging van \'n TaskChain-aktiwiteit begin';
$string['event_attempt_submitted'] = 'TaskChain-poging is ingedien';
$string['event_attempt_submitted_description'] = 'Die gebruiker met id "{$a->userid}" het \'n poging van \'n taak op die "taskchain"-aktiwiteit met kursusmodule-id "{$a->cmid}" begin.';
$string['event_attempt_submitted_explanation'] = '\'n Gebruiker het pas \'n poging van \'n TaskChain-aktiwiteit ingedien.';
$string['event_base'] = 'HotPot-gebeurtenis is bespeur';
$string['event_base_description'] = 'Die gebruiker met id "{$a->userid}" het \'n poging van \'n taak in die "taskchain"-aktiwiteit met kursusmodule-id "{$a->cmid}" begin.';
$string['event_base_explanation'] = '\'n Gebeurtenis is deur die TaskChain-module bespeur';
$string['event_chains_edited'] = 'TaskChain-kettings is gewysig';
$string['event_chains_edited_description'] = 'Die gebruiker met id "{$a->userid}" het alle TaskChain-kettings op die kursus met id "{$a->courseid}" gewysig.';
$string['event_chains_edited_explanation'] = '\'n Gebruiker het pas al die TaskChain-kettings van \'n kursus gewysig';
$string['event_columnlists_edited'] = 'TaskChain-kolomlyste is gewysig';
$string['event_columnlists_edited_description'] = 'DIe gebruiker met id "{$a->userid}" het kolomlyste op die "taskchain"-aktiwiteit met kursusmodule-id "{$a->cmid}" gewysig';
$string['event_columnlists_edited_explanation'] = '\'n Gebruiker het pas die kolomlyste van \'n TaskChain-aktiwiteit gewysig';
$string['event_condition_edited'] = 'TaskChain-voorwaarde is gewysig';
$string['event_condition_edited_description'] = 'Die gebruiker met id "{$a->userid}" het \'n voorwaarde op die "taskchain"-aktiwiteit met kursusmodule-id "{$a->cmid}" gewysig.';
$string['event_condition_edited_explanation'] = '\'n Gebruiker het pas \'n voorwaarde op \'n TaskChain-aktiwiteit gewysig';
$string['event_report_viewed'] = 'TaskChain-verslag is besigtig';
$string['event_report_viewed_description'] = 'Die gebruiker met id "{$a->userid}" het \'n verslag van die "taskchain"-aktiwiteit met kursusmodule-id "{$a->cmid}" besigtig.';
$string['event_report_viewed_explanation'] = '\'n Gebruiker het pas \'n verslag van pogings van \'n TaskChain-aktiwiteit besigtig';
$string['event_task_edited'] = 'TaskChain-taak is gewysig';
$string['event_task_edited_description'] = 'Die gebruiker met id "{$a->userid}" het \'n verslag van die "taskchain"-aktiwiteit met kursusmodule-id "{$a->cmid}" gewysig.';
$string['event_task_edited_explanation'] = '\'n Gebruiker het pas \'n taak op \'n TaskChain-aktiwiteit gewysig';
$string['event_tasks_edited'] = 'TaskChain-take is gewysig';
$string['event_tasks_edited_description'] = 'Die gebruiker met id "{$a->userid}" het alle take op die "taskchain"-aktiwiteit met kursusmodule-id "{$a->cmid}" gewysig.';
$string['event_tasks_edited_explanation'] = '\'n Gebruiker het pas alle take op \'n TaskChain-aktiwiteit gewysig';
$string['exit_areyouok'] = 'Hallo, is jy nog daar?';
$string['exit_attemptscore'] = 'Jou punt vir daardie poging was {$a}';
$string['exit_course'] = 'Kursus';
$string['exit_course_text'] = 'Keer terug na die hoof kursusblad';
$string['exit_encouragement'] = 'Aanmoediging';
$string['exit_excellent'] = 'Uitstekend!';
$string['exit_feedback'] = 'Verlaatblad-terugvoer';
$string['exit_feedback_help'] = 'Hierdie opsies ontsper en versper die vertoon van terugvoeritems op \'n TaskChain se verlaatblad.

**Kettingnaam as titel**
: Indien gemerk, sal die kettingnaam as die titel van die verlaatblad vertoon word.

**Aanmoediging**
: Indien gemerk, sal aanmoediging op die verlaatblad vertoon word. Die aanmoediging hang af van die TaskChain-punt:
: **> 90%**: Uitstekend!
: **> 60%**: Welgedaan
: **> 0%**: Goeie probeerslag
: **= 0%**: Is jy OK?

**Kettingpogingpunt**
: Indien gemerk, sal die punt vir die kettingpoging wat pas voltooi is, op die verlaatblad vertoon word.

**Kettingpunt**
: Indien gemerk, sal die TaskChain-punt op die verlaatblad vertoon word.

Boonop sal \'n boodskap vertoon word wanneer die kettingpunt-metode die hoogste is, om aan die gebruiker te sê of die mees onlangse poging gelyk aan of beter as hul vorige was.';
$string['exit_goodtry'] = 'Goeie probeerslag!';
$string['exit_grades'] = 'Punte';
$string['exit_grades_text'] = 'Kyk na jou punte vir hierdie kursus tot dusver';
$string['exit_index'] = 'Indeks';
$string['exit_index_text'] = 'Gaan na die indeks van aktiwiteite';
$string['exit_links'] = 'Verlaatbladskakels';
$string['exit_links_help'] = 'Hierdie opsies ontsper en versper die vertoon van sekere navigasieskakels op \'n TaskChain se verlaatblad.

**Herprobeer**
: As etlike pogings van hierdie TaskChain toegelaat word en die student steeds pogings oor het, sal \'n skakel vertoon word om die student toe te laat om die TaskChain te herprobeer.

**Indeks**
: Indien gemerk, sal \'n skakel na die TaskChain-indeksblad vertoon word.

**Kursus**
: Indien gemerk, sal \'n skakel na die Moodle-kursusblad vertoon word.

**Punte**
: Indien gemerk, sal \'n skakel na die Moodle-punteboek vertoon word.';
$string['exit_next'] = 'Volgende';
$string['exit_next_text'] = 'Probeer die volgende aktiwiteit';
$string['exit_nograde'] = 'Jy het hierdie aktiwiteit suksesvol voltooi!';
$string['exit_retry'] = 'Herprobeer';
$string['exit_retry_text'] = 'Herprobeer hierdie aktiwiteit';
$string['exit_taskchaingrade'] = 'Jou punt vir hierdie aktiwiteit is {$a}';
$string['exit_taskchaingrade_average'] = 'Jou gemiddelde punt vir hierdie aktiwiteit tot dusver is {$a}';
$string['exit_taskchaingrade_highest'] = 'Jou hoogste punt vir hierdie aktiwiteit tot dusver is {$a}';
$string['exit_taskchaingrade_highest_equal'] = 'Jy het jou vorige beste vir hierdie aktiwiteit geëwenaar!';
$string['exit_taskchaingrade_highest_previous'] = 'Jou vorige hoogste punt vir hierdie aktiwiteit was {$a}';
$string['exit_taskchaingrade_highest_zero'] = 'Jy het nog nie hoër as {$a} vir hierdie aktiwiteit behaal nie';
$string['exit_welldone'] = 'Welgedaan!';
$string['exit_whatnext_0'] = 'Wat wil jy volgende doen?';
$string['exit_whatnext_1'] = 'Kies jou bestemming ...';
$string['exit_whatnext_default'] = 'Kies asseblief een van die volgende:';
$string['exitcm'] = 'Volgende aktiwiteit';
$string['exitcm_help'] = 'Hierdie verstelling spesifiseer \'n Moodle-aktiwiteit wat gedoen moet word nadat hierdie TaskChain-aktiwiteit voltooi is. Die opsionele punt is die minimum punt vir hierdie TaskChain wat vir die volgende aktiwiteit se vertoon vereis word.

Die onderwyser kan \'n spesifieke aktiwiteit kies of een van die volgende verstellings vir algemene doeleindes kies:

* Volgende aktiwiteit in hierdie kursus
* Volgende aktiwiteit in hierdie afdeling
* Volgende gegradeerde aktiwiteit in hierdie kursus
* Volgende gegradeerde aktiwiteit in hierdie afdeling
* Volgende TaskChain in hierdie kursus
* Volgende TaskChain in hierdie afdeling

As ander verlaatblad-opsies versper is en die student die vereiste punt op hierdie TaskChain-aktiwiteit verkry het, sal die volgende aktiwiteit dadelik vertoon word. Andersins sal \'n skakel na die volgende aktiwiteit aan die student vertoon word, waarop hulle kan kliek wanneer hulle gereed is.';
$string['exitcmcourse'] = 'Volgende aktiwiteit in hierdie kursus';
$string['exitcmsection'] = 'Volgende aktiwiteit in hierdie kursusafdeling';
$string['exitgrade'] = 'Volgende aktiwiteitpunt';
$string['exitgradedcourse'] = 'Volgende gegradeerde aktiwiteit in hierdie kursus';
$string['exitgradedsection'] = 'Volgende gegradeerde aktiwiteit in hierdie kursusafdeling';
$string['exitoptions'] = 'Verlaatopsies';
$string['exitpage'] = 'Vertoon verlaatblad';
$string['exitpage_help'] = 'Behoort \'n verlaatblad vertoon te word nadat die TaskChain-taak voltooi is?

**Ja**
: Daar sal \'n verlaatblad aan studente vertoon word wanneer die TaskChain voltooi is. Die inhoud van die verlaatblad word bepaal deur die verstellings van die TaskChain se verlaatblad-terugvoer en -skakels.

**Nee**
: Daar sal nie \'n verlaatblad aan studente vertoon word nie. Pleks daarvan sal hulle óf dadelik na die volgende aktiwiteit gaan, óf na die Moodle-kursusblad terugkeer.';
$string['exitpagehdr'] = 'Verlaatblad';
$string['exittaskchaincourse'] = 'Volgende TaskChain in hierdie kursus';
$string['exittaskchainsection'] = 'Volgende TaskChain in hierdie kursusafdeling';
$string['exittext'] = 'Verlaatbladteks';
$string['feedback'] = 'Terugvoer';
$string['feedbackdiscuss'] = 'Bespreek hierdie taak in \'n forum';
$string['feedbackformmail'] = 'Terugvoervorm';
$string['feedbackmoodleforum'] = 'Moodle-forum';
$string['feedbackmoodlemessaging'] = 'Moodle-boodskapdiens';
$string['feedbacknone'] = 'Geen';
$string['feedbacksendmessage'] = 'Stuur \'n boodskap na jou instrukteur';
$string['feedbackshort'] = 'F';
$string['feedbackwebpage'] = 'Webblad';
$string['filename'] = 'Dokumentnaam';
$string['filetype'] = 'Dokumenttipe';
$string['filteredchains'] = 'TaskChains wat met die volgende filters ooreenstem:';
$string['filteredtasks'] = 'Take wat met die volgende filters ooreenstem:';
$string['finishandclose'] = 'Voltooi en maak hierdie poging toe';
$string['firstattempt'] = 'Eerste poging';
$string['fix_boms'] = 'Lap BOM\'e';
$string['fix_installxml'] = 'Lap db/install.xml';
$string['forceplugins'] = 'Dwing mediainvoegtoepassings';
$string['forceplugins_help'] = 'Indien ontsper, sal Moodle-versoenbare mediaspelers dokumente speel soos avi, mpeg, mpg, mp3, mov en wmv. Andersins sal Moodle nie enige van die mediaspelers in die taak se verstellings verander nie.';
$string['frameheight'] = 'Raamhoogte';
$string['giveup'] = 'Gee op';
$string['grade'] = 'Punt';
$string['gradeignore'] = 'Ignoreer leë pogings';
$string['gradeignore_help'] = 'Hierdie verstelling spesifiseer of leë pogings, d.w.s. afgegooide pogings met \'n punt van 0%, geïgnoreer of ingesluit sal word wanneer studente se punte vir hierdie TaskChain bereken word.

**Ja**
: Leë pogings word tydens die berekening van punte vir hierdie TaskChain-aktiwiteit geïgnoreer.

**Nee**
: Leë pogings word *nie geïgnoreer nie*, d.w.s. dit word in die berekening van punte vir hierdie TaskChain-aktiwiteit *ingesluit*.

Leë pogings kom voor wanneer \'n student met \'n TaskChain-aktiwiteit begin, maar dan geen van die vrae in enige take probeer beantwoord voordat hy die aktiwiteit verlaat nie. Sulke pogings kan \'n beduidende impak op die punt hê wanneer die graderingsmetode Gemiddeld, Eerste of Laaste is. In sulke situasies kan die onderwyser besluit dat dit beter is om die leë pogings te ignoreer wanneer die punt bereken word.';
$string['gradelimit'] = 'Puntbeperking';
$string['gradelimit_help'] = 'Die punte vir kettingpogings word aangepas om in die omvang 0 tot puntbeperking te pas.

Die maksimum punt vir \'n TaskChain-aktiwiteit in die Moodle-punteboek word soos volg bereken:

: maksimum punt x (puntgewig / 100)';
$string['grademethod'] = 'Graderingsmetode';
$string['grademethod_help'] = 'Hierdie verstelling definieer hoe die TaskChain-aktiwiteitpunt uit die pogingpunte bereken word.

**Hoogste punt**
: Die aktiwiteitpunt sal volgens die hoogste punt vir pogings in hierdie TaskChain-aktiwiteit gestel word.

**Gemiddelde punt**
: Die punt sal volgens die gemiddelde punt vir pogings in hierdie TaskChain-aktiwiteit gestel word.

**Eerste poging**
: Die punt sal volgens die punt van die eerste poging van hierdie TaskChain-aktiwiteit gestel word.

**Laaste poging**
: Die punt sal volgens die punt van die mees onlangse poging van hierdie TaskChain-aktiwiteit gestel word.';
$string['gradeweighting'] = 'Puntgewig';
$string['gradeweighting_help'] = 'Punte vir hierdie TaskChain-aktiwiteit sal tot hierdie getal in die Moodle-punteboek aangepas word.';
$string['groupid'] = 'Groep';
$string['groupid_help'] = 'Die Moodle-gebruikersgroep waarop hierdie voorwaarde van toepassing is';
$string['guestsno'] = 'Jammer, gaste kan nie TaskChain-aktiwiteite sien of probeer doen nie';
$string['highestgrade'] = 'Hoogste punt';
$string['highestscore'] = 'Hoogste telling';
$string['highesttaskscore'] = 'Hoogste taaktelling';
$string['hints'] = 'Wenke';
$string['ignored'] = 'Geïgnoreer';
$string['incorrecttask'] = 'Taak wat verkeerd beantwoord is';
$string['inprogress'] = 'Aan die gang';
$string['isgreaterthan'] = 'is meer as';
$string['islessthan'] = 'is minder as';
$string['lastaccess'] = 'Laaste toegang';
$string['lastattempt'] = 'Laaste poging';
$string['lasttaskabandoned'] = 'Punt van laaste afgegooide taak';
$string['lasttaskattempted'] = 'Punt van laaste gepoogde taak';
$string['lasttaskcompleted'] = 'Punt van laaste voltooide taak';
$string['lasttasktimedout'] = 'Punt van laaste taak wat die afsnytyd bereik het';
$string['lockframe'] = 'Sluit raam';
$string['manualcompletion'] = 'Voltooiing per hand';
$string['manualcompletion_help'] = 'Hierdie verstelling bepaal die aksie wat gedoen moet word wanneer alle take voltooi is, maar die post-voorwaardes van die finale taak spesifiseer _NIE_ wat om volgende te doen nie.

**Nee**
: Nadat alle take voltooi is, sal die kettingpoging outomaties as voltooid gemerk word en sal studente nie take kan oordoen nie.

**Ja**
: Nadat alle take voltooi is, sal studente take kan oordoen en moet hulle per hand \'n knoppie kliek om \'n kettingpoging te voltooi.';
$string['maxeventlength'] = 'Maksimum aantal dae vir \'n enkele kalendergebeurtenis';
$string['maximum'] = '&lt;=';
$string['mediafilter_moodle'] = 'Moodle se standaard mediafilters';
$string['mediafilter_taskchain'] = 'TaskChain-mediafilter';
$string['menuofalltasks'] = 'Kieslys van alle take';
$string['menuofalltasksone'] = 'Kieslys van alle take (een skakel)';
$string['menuofnexttasks'] = 'Kieslys van volgende take';
$string['menuofnexttasksone'] = 'Kieslys van volgende take (een skakel)';
$string['migratingfiles'] = 'TaskChain-taakdokumente word migreer';
$string['migratinglogs'] = 'TaskChain-logs word migreer';
$string['minimum'] = '&gt;=';
$string['missingsourcetype'] = 'TaskChain-rekord benodig brontipe';
$string['mods_help'] = '<img src="http://localhost/24/mod/taskchain/icon.gif" alt="" /> **TaskChain**

Die TaskChain-module laat onderwysers toe om interaktiewe leermateriale via Moodle te versprei en besonderhede van die studente se antwoorde te besigtig.

Die materiaal word op die onderwyser se rekenaar met outeursagteware geskep, soos
<a href="http://web.uvic.ca/hrd/halfbaked/" target="_blank">Hot Potatoes</a> and
<a href="http://www.qedoc.org/" target="_blank">Qedoc</a>, en dan na die Moodle-kursus opgelaai.

Nadat studente die take gepoog het, is \'n aantal verslae beskikbaar, wat aantoon hoe individuele vrae beantwoord is, asook \'n aantal statistiese neigings in die punte.';
$string['modulename'] = 'TaskChain';
$string['modulename_help'] = 'Die TaskChain-module laat onderwysers toe om interaktiewe leermateriaal via Moodle na hul studente te versprei en verslae van die studente se antwoorde en uitslae te besigtig.

\'n Enkele TaskChain-aktiwiteit bestaan uit \'n opsionele toegangsblad, \'n ketting take en \'n opsionele verlaatblad. Elke taak kan \'n statiese of interaktiewe webblad wees wat aan studente teks-, oudio- en visuele aanporboodskappe bied, en hul antwoorde aanteken. Die take word op die onderwyser se rekenaar met outeursagteware geskep en dan na Moodle opgelaai.

Die onderwyser kan leerpaaie deur \'n ketting definieer deur pre-voorwaardes en post-voorwaardes by die take te voeg. \'n Taak kan nie gepoog word voordat al die pre-voorwaardes bevredig is nie. Nadat die taak voltooi is, definieer die post-voorwaardes wat volgende aan die student vertoon moet word.

\'n TaskChain-aktiwiteit kan take bevat wat met die volgende outeursagteware geskep is:

* Hot Potatoes (weergawe 6)
* Qedoc
* Xerte
* iSpring
* enige HTML-wysiger';
$string['modulename_link'] = 'mod/taskchain/view';
$string['modulenameplural'] = 'TaskChains';
$string['movetasks'] = 'Skuif geselekteerde take';
$string['myattempts'] = 'My pogings';
$string['name'] = 'Naam';
$string['name_help'] = 'Die spesifieke teks wat aan studente vertoon word';
$string['nameadd'] = 'Naam';
$string['nameadd_help'] = 'Die naam kan spesifieke teks wees wat deur die onderwyser ingevoer is, of dit kan outomaties gegenereer word.

**Verkry vanaf brondokument**
Die naam sal uit die brondokument geneem word.

**Gebruik brondokumentnaam**
Die brondokumentnaam sal as naam gebruik word.

**Gebruik brondokumentpad**
Die brondokumentpad sal as naam gebruik word.
Enige skuinsstrepe in die dokumentpad sal met spasies vervang word.

**Spesifieke teks**
Die spesifieke teks wat deur die onderwyser ingevoer is, sal as die naam gebruik word.';
$string['navigation'] = 'Navigasie';
$string['navigation_embed'] = 'Vasgelegde webblad';
$string['navigation_frame'] = 'Moodle-navigasieraamwerk';
$string['navigation_give_up'] = '\'n Enkele &quot;Gee op&quot; knoppie';
$string['navigation_help'] = 'Hierdie verstelling spesifiseer die navigasie wat in die taak gebruik word:

**Moodle-navigasiestaaf**
: Die Moodle-navigasiestaaf sal in dieselfde venster as die taak boaan die bladsy vertoon word.

**Moodle-navigasieraam**
: Die Moodle-navigasiestaaf sal in \'n aparte raam boaan die taak vertoon word.

**Vasgelegde webblad**
: Die Moodle-navigasiestaaf sal saam met die taak wat in die venster vasgelê is, vertoon word.

**Oorspronklike navigasiehulpmiddels**
: Die taak sal met die navigasieknoppies, indien enige, wat in die taak gedefinieer is, vertoon word.

**\'n Enkele "Gee Op" knoppie**
: Die taak sal met \'n enkele "Gee Op" knoppie boaan die bladsy vertoon word.

**Geen**
: Die taak sal sonder enige navigasiehulpmiddels vertoon word, dus sal Moodle óf terugkeer na die die kursusbladsy, óf die volgende taak vertoon wanneer alle vrae korrek beantwoord is, afhangend van die "Vertoon volgende taan?"-verstelling.';
$string['navigation_moodle'] = 'Standaard Moodle-navigasiestawe (bo en aan die kant)';
$string['navigation_none'] = 'Geen';
$string['navigation_original'] = 'Oorspronklike navigasiehulpmiddels';
$string['navigation_topbar'] = 'Slegs boonste Moodle-navigasiestaaf (geen kantstawe nie)';
$string['next1task'] = 'Volgende taak';
$string['next2task'] = 'Slaan volgende taak oor';
$string['next3task'] = 'Slaan 2 take oor';
$string['next4task'] = 'Slaan 3 take oor';
$string['next5task'] = 'Slaan 4 take oor';
$string['nexttaskid'] = 'Volgende taak';
$string['nexttaskid_help'] = 'Hierdie verstelling spesifiseer die taak wat vertoon moet word as daar aan die post-voorwaarde voldoen is.

**Dieselfde taak**
Vertoon die taak wat pas voltooi is.

**Volgende taak**
Vertoon die volgende taak in hierdie ketting, volgens sorteervolgorde.

**Slaan taak oor**
Vertoon die taak ná die volgende taak, volgens die sorteervolgorde.

**Vorige taak**
Vertoon die vorige taak in hierdie ketting, volgens sorteervolgorde.

**Ongesiene taak**
Vertoon \'n taak uit hierdie ketting wat die huidige gebruiker nog nie gesien het nie.

**Onbeantwoorde taak**
Vertoon \'n taak uit hierdie ketting wat die gebruiker nog nie gesien het nie,
of gesien het maar nog geen antwoorde op enige vrae in hierdie taak gegee het nie.

**Verkeerd beantwoorde taak**
Vertoon \'n taak wat nog nie korrek beantwoord is nie,
d.w.s. \'n taak waarvan die punt nie 100% is nie.

**Lukrake taak**
Vertoon \'n lukrake taak uit hierdie ketting.
Die taak kon moontlik reeds gepoog gewees het.

**Kieslys van volgende take**
Vertoon \'n kieslys van take uit hierdie ketting wat, volgens die pre-voorwaardes en ander toegangsbeperkings van die take, aan die student beskikbaar is.

**Kieslys van alle take**
Vertoon \'n kieslys van alle take uit hierdie ketting.
Take is aan studente beskikbaar en sal skakels na die begin van die taak hê.
Take wat nie beskikbaar is nie, sal nie so \'n skakel hê nie.

**Einde van ketting**
Die einde van die ketting is bereik. Die status van die ketting sal gestel word na voltooid, en - afhangend van die ketting se verlaatbladverstellings - sal die student óf die verlaatblad getoon word, óf die volgende Moodle-aktiwiteit, óf die Moodle-kursusblad.

**Spesifieke taak**
Die onderwyser kan ook \'n spesifieke taak as die volgende taak kies.
Om verwarring te voorkom wat kan voorkom met take met identiese name,
word die taak se sorteringsname aan die taakname geheg.';
$string['noactivity'] = 'Geen aktiwiteit nie';
$string['nograde'] = 'Geen punte nie';
$string['nolastchainattempt'] = 'Vorige kettingpoging se rekord is nie gevind nie';
$string['nolasttaskattempt'] = 'Vorige taakpoging se rekord is nie gevind nie';
$string['nomorechainattempts'] = 'Jammer, jy het geen meer pogings vir hierdie aktiwiteit oor nie';
$string['nomoretaskattempts'] = 'Jammer, jy het geen meer pogings vir hierdie taak oor nie';
$string['noresponses'] = 'Geen inligting oor individuele vrae en antwoorde is gevind nie.';
$string['noreview'] = 'Jammer, jy word nie toegelaat om die besonderhede van hierdie taakpoging te besigtig nie.';
$string['noreviewafterclose'] = 'Jammer, hierdie taak is gesluit. Jy word nie meer toegelaat om besonderhede van hierdie taakpoging te besigtig nie.';
$string['noreviewbeforeclose'] = 'Jammer, jy word nie toegelaat om besonderhede van hierdie taakpoging voor {$a} te besigtig nie.';
$string['noscore'] = 'Geen punt nie';
$string['nosourcefilesettings'] = 'TaskChain-rekord ontbreek brondokumentinligting';
$string['notaskchains'] = 'Geen TaskChains is gevind nie';
$string['notasksforyou'] = 'Jammer, daar is tans geen take vir jou om te doen nie.';
$string['notasksinchain'] = 'Daar is geen take in hierdie TaskChain-ketting nie';
$string['notattemptedyet'] = 'Nog nie gepoog nie';
$string['notavailable'] = 'Jammer, hierdie aktiwiteit is nie tans aan jou beskikbaar nie.';
$string['notendswith'] = 'eindig nie met';
$string['notisempty'] = 'is nie leeg nie';
$string['notisequalto'] = 'is nie gelyk aan nie';
$string['notstartswith'] = 'begin nie met';
$string['or'] = 'of';
$string['orless'] = '{$a} (of minder)';
$string['ormore'] = '{$a} (of meer)';
$string['outputformat'] = 'Afvoerformaat';
$string['outputformat_best'] = 'Beste';
$string['outputformat_help'] = 'Die afvoerformaat spesifiseer hoe die inhoud aan die student gepresenteer sal word.

Die afvoerformate wat beskikbaar is, hang af van die tipe brondokument. Sommige tipes brondokumente het slegs een afvoerformaat, terwyl ander tipes brondokumente etlike afvoerformate het.

Die "beste verstelling" sal die inhoud vertoon met die optimale afvoerformaat vir die student se blaaier.';
$string['outputformat_hp_6_jcloze_html'] = 'JCloze (v6) van html';
$string['outputformat_hp_6_jcloze_html_dropdown'] = 'DropDown van html';
$string['outputformat_hp_6_jcloze_html_findit_a'] = 'FindIt (a) van HP6 JCloze html';
$string['outputformat_hp_6_jcloze_html_findit_b'] = 'FindIt (b) van HP6 JCloze html';
$string['outputformat_hp_6_jcloze_html_jgloss'] = 'JGloss van html';
$string['outputformat_hp_6_jcloze_xml_anctscan'] = 'ANCT-Scan van HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_anctscan_autoadvance'] = 'ANCT-Scan van HP6 JCloze xml (outovoortgaan)';
$string['outputformat_hp_6_jcloze_xml_dropdown'] = 'DropDown van HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_a'] = 'FindIt (a) van HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_b'] = 'FindIt (b) van HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_jgloss'] = 'JGloss van HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_v6'] = 'JCloze (v6) van HP6 xml';
$string['outputformat_hp_6_jcloze_xml_v6_autoadvance'] = 'JCloze (v6) van HP6 xml (outovoortgaan)';
$string['outputformat_hp_6_jcross_xml_v6'] = 'JCross (v6) van xml';
$string['outputformat_hp_6_jmatch_html'] = 'JMatch (v6) van html';
$string['outputformat_hp_6_jmatch_xml_flashcard'] = 'JMatch (flashcard) van xml';
$string['outputformat_hp_6_jmatch_xml_jmemori'] = 'JMemori van xml';
$string['outputformat_hp_6_jmatch_xml_sort'] = 'JMatch Sort van xml';
$string['outputformat_hp_6_jmatch_xml_v6'] = 'JMatch (v6) van xml';
$string['outputformat_hp_6_jmatch_xml_v6_plus'] = 'JMatch (v6+) van xml';
$string['outputformat_hp_6_jmatch_xml_v6_plus_duplicates'] = 'JMatch (v6+) van xml (laat duplikate toe)';
$string['outputformat_hp_6_jmix_html'] = 'JQuiz (v6) van html';
$string['outputformat_hp_6_jmix_xml_v6'] = 'JMix (v6) van xml';
$string['outputformat_hp_6_jmix_xml_v6_plus'] = 'JMix (v6+) van xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_deluxe'] = 'JMix (v6+ met prefiks, suffiks en afleiers) van xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_keypress'] = 'JMix (v6+ met sleuteldruk) van xml';
$string['outputformat_hp_6_jquiz_xml_v6'] = 'JQuiz (v6) van xml';
$string['outputformat_hp_6_jquiz_xml_v6_autoadvance'] = 'JQuiz (v6) van xml (outovoortgaan';
$string['outputformat_hp_6_jquiz_xml_v6_exam'] = 'JQuiz (v6) van xml (Eksamen)';
$string['outputformat_hp_6_jquiz_xml_v6_intro'] = 'JQuiz (v6) van xml (Intro)';
$string['outputformat_hp_6_rhubarb_html'] = 'Rhubarb (v6) van html';
$string['outputformat_hp_6_rhubarb_xml'] = 'Rhubarb (v6) van xml';
$string['outputformat_hp_6_sequitur_html'] = 'Sequitur (v6) van html';
$string['outputformat_hp_6_sequitur_html_incremental'] = 'Sequitur (v6) van html, inkrementele puntetoekenning';
$string['outputformat_hp_6_sequitur_xml'] = 'Sequitur (v6) van xml';
$string['outputformat_hp_6_sequitur_xml_incremental'] = 'Sequitur (v6) van xml, inkrementele puntetoekenning';
$string['outputformat_html_ispring'] = 'iSpring HTML-dokument';
$string['outputformat_html_xerte'] = 'Xerte HTML-dokument';
$string['outputformat_html_xhtml'] = 'Standaard HTML-dokument';
$string['outputformat_qedoc'] = 'Qedoc-dokument';
$string['passworderror'] = 'Die wagwoord wat ingevoer is, was verkeerd';
$string['penalties'] = 'Straftoekennings';
$string['pending'] = 'Hangende voltooiing';
$string['percent'] = 'Persent';
$string['pluginadministration'] = 'TaskChain-administrasie';
$string['pluginname'] = 'TaskChain-module';
$string['postcondition'] = 'Post-voorwaarde';
$string['postconditions'] = 'Post-voorwaardes';
$string['postconditions_help'] = 'Nadat die taak voltooi is, sal die aksie van die *eerste* ooreenstemmende post-voorwaarde in hierdie lys toegepas word.';
$string['precondition'] = 'Pre-voorwaarde';
$string['preconditions'] = 'Pre-voorwaardes';
$string['preconditions_help'] = 'Hierdie taak kan slegs geneem word as *al* die pre-voorwaardes in hierdie lys bevredig is.';
$string['pressoktocontinue'] = 'Druk OK om voort te gaan, of Kanselleer om op die huidige bladsy te bly.';
$string['preview'] = 'Voorskou';
$string['previewchainnow'] = 'Besigtig TaskChain-aktiwiteit nou';
$string['previewtasknow'] = 'Besigtig taak nou';
$string['previoustask'] = 'Besigtig vorige taak';
$string['questionshort'] = 'Q-{$a}';
$string['randomtask'] = 'Lukrake taak';
$string['reattempttask'] = 'Herprobeer taak';
$string['recentattempts'] = 'Mees onlangse pogings';
$string['redo'] = 'Doen oor';
$string['reordertasks'] = 'Hersorteer take';
$string['requirepassword'] = 'Vereis wagwoord';
$string['requirepassword_help'] = 'As \'n wagwoord gespesifiseer is, moet \'n student dit invoer om die vasvra te kan doen.';
$string['requiresubnet'] = 'Vereis netwerkadres';
$string['requiresubnet_help'] = 'Vasvratoegang kan beperk word tot spesifieke subnette op die LAN of Internet deur \'n komma-geskeide lys met gedeeltelike of volledige IP-adresnommers te spesifiseer. Dit kan nuttig wees vir \'n vasvra waar toesig (waarneming) moet plaasvind, om te verseker dat slegs mense in \'n sekere plek toegang tot die vasvra kan hê.';
$string['responses'] = 'Antwoorde';
$string['responsesshort'] = 'R';
$string['resume'] = 'Hervat';
$string['reviewafterattempt'] = 'Laat oorsig ná poging toe';
$string['reviewafterclose'] = 'Laat oorsig toe ná HotPot sluit';
$string['reviewduringattempt'] = 'Laat oorsig tydens poging toe';
$string['reviewoptions'] = 'Oorsig-opsies';
$string['sametask'] = 'Dieselfde taak';
$string['score'] = 'Punt';
$string['scoreignore'] = 'Ignoreer leë pogings';
$string['scoreignore_help'] = 'Hierdie verstelling spesifiseer of leë pogings, d.w.s. afgegooide pogings met \'n punt van 0%, geïgnoreer word of ingesluit word wanneer studente se punte vir hierdie taak bereken word.

**Ja**
Leë pogings word met die berekening van punte vir hierdie taak *geïgnoreer*.

**Nee**
Leë pogings word *nie geïgnoreer nie*, d.w.s. dit word in die berekening van punte vir hierdie taak *ingesluit*.

Leë pogings kom voor wanneer \'n student met \'n taak begin, maar dan geen poging aanwend om vrae te beantwoord voordat hy die taak verlaat nie. Sulke pogings kan \'n beduidende impak op die punt hê wanneer die graderingsmetode Gemiddeld, Eerste of Laaste is. In sulke gevalle kan die onderwyser besluit dat dit beter is om leë pogings te ignoreer wanneer die punt bereken word.';
$string['scorelimit'] = 'Puntbeperking';
$string['scorelimit_help'] = 'Hierdie verstelling spesifiseer die hoogste moontlike punt vir hierdie taak. Daar word aanvaar dat alle taakpogings persentasies is en dit sal aangepas word sodat geen taakpoging se punt hoër as die punt se puntbeperking is nie.';
$string['scoremethod'] = 'Graderingsmetode';
$string['scoremethod_help'] = 'Hierdie verstelling definieer hoe die taakpunt uit die taakpogings bereken word.

**Hoogste**
Die taakpunt sal gestel word op die hoogste punt vir \'n poging van hierdie taak.

**Gemiddeld**
Die taakpunt sal gestel word op die gemiddelde punt vir pogings van hierdie taak.

**Eerste**
Die taakpunt sal gestel word op die punt van die eerste poging van hierdie taak.

**Laaste**
Die taakpunt sal gestel word op die punt van die mees onlangse poging van hierdie taak.';
$string['scores'] = 'Punte';
$string['scoresshort'] = 'S';
$string['scoreweighting'] = 'Puntverswaring';
$string['scoreweighting_help'] = 'Die puntverswaring is die bydrae van die punt vir hierdie taak tot die kettingpuntpoging.

Indien etlike take ewe veel verswaring vereis, behoort hulle dieselfde gelyke gewigskategorie te ontvang.';
$string['securityhdr'] = 'Sekuriteitbeperkinge';
$string['selectattempts'] = 'Kies pogings';
$string['selectedchains'] = 'Gekose TaskChains in hierdie kursus';
$string['selectedtasks'] = 'Gekose take in hierdie TaskChain';
$string['showdescription'] = 'Vertoon beskrywing';
$string['showdescription_help'] = 'As hierdie verstelling ontsper is, sal die toegangteks hieronder op die kursusbladsy as beskrywing van hierdie aktiwiteit verskyn.';
$string['showerrormessage'] = 'TaskChain-fout: {$a}';
$string['showpopup'] = 'Venster';
$string['showpopup_help'] = '**Dieselfde venster**
Die TaskChain-aktiwiteit sal in dieselfde venster as die Moodle-kursusblad vertoon word.

**Nuwe venster**
Die TaskChain-aktiwiteit sal in \'n opspringvenster vertoon word.
Etlike funksies van die opspringvenster kan met merkbokse ontsper of versper word.
Die vereiste breedte en hoogte van die opspringvenster word as \'n getal beeldelemente gespesifiseer.';
$string['singlefieldhdr'] = 'Enkele veld';
$string['sortdirection'] = 'Sorteringrigting';
$string['sortdirection_help'] = 'Die rigting waarin jy hierdie rekords wil sorteer';
$string['sortfield'] = 'Sorteerveld';
$string['sortfield_help'] = 'Die veld waarop jy hierdie rekords wil sorteer';
$string['sortincrement'] = 'Sorteerinkrement';
$string['sortincrement_help'] = 'Wanneer die take hersorteer word, sal die sorteernommers met die hoeveelheid wat hier gespesifiseer word, verhoog';
$string['sortorder'] = 'Sorteervolgorde';
$string['sortorder_help'] = 'Die volgorde van hierdie taak binne hierdie ketting';
$string['sourcefile'] = 'Brondokument';
$string['sourcefile_help'] = 'Hierdie verstelling spesifiseer die dokument wat die inhoud bevat wat aan die studente vertoon gaan word.

Gewoonlik sal die brondokument buite Moodle geskep word en dan na die dokumentarea van \'n Moodle-kursus opgelaai word.
Dit kan \'n html-dokument wees of \'n ander tipe dokument wat met outeursagteware, soos Hot Potatoes of Qedoc, geskep is.

Die brondokument kan as \'n lêer en dokumentpad in die Moodle-kursusdokumentarea gespesifiseer wees, of dit kan \'n url wees wat met http:// of https:// begin.

Vir Qedoc-materiaal moet die brondokument die url van \'n Qedoc-module wees, wat na die Qedoc-bediener opgelaai is.

* bv. http://www.qedoc.net/library/ABCDE_123.zip
* Vir inligting oor die oplaai van Qedoc-modules, sien: [Qedoc-dokumentasie: Uploading_modules](http://www.qedoc.org/en/index.php?title=Uploading_modules)';
$string['sourcefilenotfound'] = 'Brondokument nie gevind nie (of leeg): {$a}';
$string['sourcelocation'] = 'Brondokumentposisie';
$string['sourcelocation_help'] = 'Die posisie van die brondokument.';
$string['sourcetype'] = 'Brondokumenttipe';
$string['sourcetype_help'] = 'Die tipe van hierdie brondokument';
$string['startchainattempt'] = 'Begin nuwe kettingpoging';
$string['startofchain'] = 'Begin van ketting';
$string['starttaskattempt'] = 'Begin nuwe taakpoging';
$string['status'] = 'Status';
$string['stopbutton'] = 'Vertoon Stop-knoppie';
$string['stopbutton_help'] = 'As hierdie verstelling ontsper is, sal \'n stop-knoppie in die taak ingevoeg word.

As \'n student die stop-knoppie kliek, sal die uitslae tot dusver na Moodle teruggestuur word en die status van die taakpoging sal na afgegooi gestel word.

Die teks wat op die stop-knoppie vertoon word, kan een van die vooraf gestelde frases uit Moodle se taalpakkette wees, geformatteer as component_stringname (bv. portfolio_returntowhereyouwere), of die onderwyser kan sy eie, spesifieke teks vir die knoppie spesifiseer.';
$string['stopbuttonlangpack'] = 'Uit taalpakket';
$string['stopbuttonspecific'] = 'Gebruik spesifieke teks';
$string['stoptext'] = 'Teks van stop-knoppie';
$string['stoptext_help'] = 'Hierdie teks word gebruik as die "Vertoon Stop-knoppie" se verstelling spesifiseer "Ja - Gebruik spesifieke teks"';
$string['storedetails'] = 'Berg die rou XML-besonderhede van TaskChain-taakpogings';
$string['studentfeedback'] = 'Studentterugvoer';
$string['studentfeedback_help'] = 'Indien ontsper, sal \'n skakel na \'n opspring-terugvoervenster vertoon word wanneer die student op die "Kontroleer"-knoppie kliek. Die terugvoervenster laat studente toe om hierdie taak met hul onderwyser en klasmaats op een van die volgende maniere te bespreek:

**Webblad**
: vereis URL van die webblad, byvoorbeeld
http://myserver.com/feedbackform.html

**Terugvoervorm**
: vereis URL van die vormteks, byvoorbeeld
http://myserver.com/cgi-bin/formmail.pl

**Moodle-forum**
: die forumindeks vir die kursus sal vertoon word

**Moodle-boodskapdiens**
: die Moodle direkte boodskapvenster sal vertoon word. As die kursus etlike onderwysers het, sal studente gevra word om \'n onderwyser te kies voordat die boodskapvenster verskyn.';
$string['studentfeedbackurl'] = 'Studentterugvoer-URL';
$string['submits'] = 'Indienings';
$string['subplugintype_taskchainattempt'] = 'Afvoerformaat';
$string['subplugintype_taskchainattempt_plural'] = 'Afvoerformate';
$string['subplugintype_taskchainreport'] = 'Verslag';
$string['subplugintype_taskchainreport_plural'] = 'Verslae';
$string['subplugintype_taskchainsource'] = 'Brondokument';
$string['subplugintype_taskchainsource_plural'] = 'Brondokumente';
$string['task'] = 'Taak';
$string['taskaction_help'] = 'Hierdie opsies spesifiseer watter aksie sal plaasvind wanneer die "Gaan"-knoppie gekliek word.

*Hersorteer take**
: Die take sal volgens die nuwe sorteringsnommers hersorteer word.

**Voeg (meer) take by**
: \'n Nuwe webblad sal vertoon word, vanwaar jy een of meer nuwe take by hierdie TaskChain-aktiwiteit kan voeg.

**Skuif take**
: Die gekose take sal na \'n ander plek in hierdie TaskChain-aktiwiteit geskuif word, of na \'n ander TaskChain-aktiwiteit.

**Pas gekose verstek waardes toe**
: Die gekose verstek waardes sal op die gekose take toegepas word.

**Wis take uit**
: Die gekose take sal uit die TaskChain-aktiwiteit gewis word.';
$string['taskattempt'] = 'Taakpoging';
$string['taskattemptnotinprogress'] = 'Taakpoging nie aan die gang nie';
$string['taskchain:addinstance'] = 'Voeg \'n nuwe TaskChain-aktiwiteit by';
$string['taskchain:attempt'] = 'Poog \'n TaskChain-aktiwiteit en dien uitslae in';
$string['taskchain:deleteallattempts'] = 'Wis enige gebruiker se pogings van \'n TaskChain-aktiwiteit uit';
$string['taskchain:deletemyattempts'] = 'Wis jou eie pogings van \'n TaskChain-aktiwiteit uit';
$string['taskchain:ignoretimelimits'] = 'Ignoreer tydbeperkings van \'n TaskChain-aktiwiteit';
$string['taskchain:manage'] = 'Verander die verstellings van \'n TaskChain-aktiwiteit';
$string['taskchain:preview'] = 'Besigtig \'n TaskChain-aktiwiteit vooraf';
$string['taskchain:regrade'] = 'Hermerk \'n TaskChain-aktiwiteit';
$string['taskchain:reviewallattempts'] = 'Besigtig enige gebruiker se pogings van \'n TaskChain-aktiwiteit';
$string['taskchain:reviewmyattempts'] = 'Besigtig jou eie pogings van \'n TaskChain-aktiwiteit';
$string['taskchain:view'] = 'Besigtig toegangsblad van \'n TaskChain-aktiwiteit';
$string['taskchainname'] = 'TaskChain-naam';
$string['taskclosed'] = 'Jammer, hierdie taak het op {$a} gesluit';
$string['taskname'] = 'Taaknaam';
$string['taskname_help'] = 'hulpteks vir Taaknaam';
$string['tasknameadd_help'] = 'Die taakname kan afgelei word van spesifieke teks wat deur die onderwyser ingevoer is, of dit kan outomaties gegenereer word.

**Verkry uit brondokument**
Die taakname sal uit die brondokumente verkry word.

**Gebruik bondokumentnaam**
Die brondokumentname sal as die taakname gebruik word.

**Gebruik brondokumentpad**
Die brondokumentpad van elke taak sal as die naam van daardie taak gebruik word.
Enige skuinsstrepe in die dokumentpad sal met spasies vervang word.

**Spesifieke teks**
\'n Unieke naam vir elke taak sal geskep word deur die taaksorteringnommer aan die spesifieke teks wat deur die onderwyser ingevoer is, te voeg.';
$string['tasknames'] = 'Taakname';
$string['tasknames_help'] = 'Die taakname kan afgelei word van spesifieke teks wat deur die onderwyser ingevoer is, of dit kan outomaties gegenereer word.

**Verkry uit brondokument**
Die taakname sal uit die brondokumente verkry word.

**Gebruik bondokumentnaam**
Die brondokumentname sal as die taakname gebruik word.

**Gebruik brondokumentpad**
Die brondokumentpad van elke taak sal as die naam van daardie taak gebruik word. Enige skuinsstrepe in die dokumentpad sal met spasies vervang word.

**Spesifieke teks**
\'n Unieke naam vir elke taak sal geskep word deur die taaksorteringnommer aan die spesifieke teks wat deur die onderwyser ingevoer is, te voeg.';
$string['tasknotavailable'] = 'Jammer, hierdie taak is nie voor {$a} aan jou beskikbaar nie.';
$string['taskposition'] = 'Taakposisie';
$string['taskrequirepasswordmessage'] = 'Om hierdie taak te poog, moet jy die wagwoord ken.';
$string['tasks'] = 'Take';
$string['taskscore'] = 'Taakpunt';
$string['tasktype'] = 'Taaktipe';
$string['textsourcefile'] = 'Verkry uit brondokument';
$string['textsourcefilename'] = 'Gebruik brondokumentnaam';
$string['textsourcefilepath'] = 'Gebruik brondokumentpad';
$string['textsourcespecific'] = 'Gebruik spesifieke teks';
$string['textsourcetaskname'] = 'Gebruik die taaknaam';
$string['timeclose'] = 'Beskikbaar tot';
$string['timedout'] = 'Tyd verstreke';
$string['timehdr'] = 'Tydbeperkings';
$string['timelimit'] = 'Tydbeperking';
$string['timelimit_help'] = 'Hierdie verstelling spesifiseer die maksimum tydsduur van \'n enkele poging.

**Gebruik verstellings in bron-/templaatdokument**
: Die tydbeperking sal uit die bron- of templaatdokumente vir hierdie afvoerformaat geneem word.

**Gebruik spesifieke tyd**
: Die tydbeperking wat op die TaskChain-taakverstellingsblad gespesifiseer is, sal as die tydbeperking vir \'n poging van hierdie taak gebruik word. Hierdie verstelling skryf tydbeperkings in die brondokument, konfigurasiedokument of templaatdokumente vir hierdie afvoerformaat oorheen.

**Versper**
: Geen tydbeperking sal vir pogings van hierdie taak gestel word nie.

Let daarop dat, as \'n poging hervat word, die tydklokkie voortgaan vanwaar die poging voorheen gestaak is.';
$string['timelimitexpired'] = 'Die tydbeperking vir hierdie poging het verval';
$string['timelimitspecific'] = 'Gebruik spesifieke tyd';
$string['timelimitsummary'] = 'Tydbeperking vir een poging';
$string['timelimittemplate'] = 'Gebruik verstellings in bron-/templaatdokument';
$string['timeopen'] = 'Beskikbaar vanaf';
$string['timeopenclose'] = 'Aanvang- en sluitingstye';
$string['timeopenclose_help'] = 'Jy kan tye spesifiseer wanneer die taak toeganklik is vir mense om pogings aan te wend. Voor openingstyd en ná sluitingstyd sal die taak nie beskikbaar wees nie.';
$string['title'] = 'Titel';
$string['title_help'] = 'Hierdie stelling spesifiseer die titel wat op die webblad vertoon moet word.

**Gebruik taaknaam**
: Die taaknaam, soos op hierdie bladsy gedefinieer, sal as webbladtitel vertoon word.

**Verkry uit brondokument**
: Die titel (indien enige) wat in die brondokument gedefinieer is, sal as die webbladtitel gebruik word. Let daarop dat hierdie opsie nie doeltreffend vir die bediener is nie, omdat die brondokument elke keer gelees moet word wat die titel vertoon word.

**Gebruik brondokumentnaam**
: Die brondokumentnaam (enige lêername is hierby uitgesluit) sal as die webbladtitel gebruik word.

**Gebruik brondokumentpad**
: Die brondokumentpad, wat enige lêername insluit, sal as die webbladtitel gebruik word.

**Gebruik spesifieke teks**
: Die teks in die teksboks sal as webbladtitel gebruik word.';
$string['titleappendsortorder'] = 'Heg sorteervolgorde agteraan';
$string['titleprependchainname'] = 'Heg sorteervolgorde vooraan';
$string['titletext'] = 'Titelteks';
$string['titletext_help'] = 'Hierdie teks word gebruik as die "Titel"-verstelling "Gebruik spesifieke teks" is.';
$string['tnumber'] = 'Taakpoging';
$string['toolsindex'] = 'TaskChain-hulpmiddelindeks';
$string['totaltaskscores'] = 'Totaal van taakpunte';
$string['unansweredtask'] = 'Onbeantwoorde taak';
$string['unseentask'] = 'Ongesiende taak';
$string['updated'] = 'Bygewerk';
$string['updatinggrades'] = 'TaskChain-punte word bygewerk';
$string['usefilters'] = 'Gebruik filters';
$string['usefilters_help'] = 'As hierdie verstelling ontsper is, sal die inhoud deur die Moodle-filters gestuur word voordat dit na die blaaier gestuur word.';
$string['useglossary'] = 'Gebruik woordelys';
$string['useglossary_help'] = 'As hierdie verstelling ontsper is, sal die inhoud deur Moodle se Woordelys-Outoskakeling gestuur word, voordat dit na die blaaier gestuur word.

Let daarop dat hierdie verstelling die werfadministrasieverstelling, om die Woordelys-outoskakelingsfilter te ontsper of versper, oorheenskryf.';
$string['usemediafilter'] = 'Gebruik mediafilter';
$string['usemediafilter_help'] = 'Hierdie verstelling spesifiseer die mediafilter wat gebruik moet word.

**Geen**
: Die inhoud sal nie deur enige mediafilters gestuur word nie,

**Moodle se standaard mediafilters**
: Die inhoud sal deur Moodle se standaard mediafilters gestuur word. Hierdie filters soek na skakels na algemene tipes klank- en fliekdokument, en skakel daardie skakels om na geskikte mediaspelers.

**TaskChain-mediafilter**
: Die inhoud sal deur filters gestuur word wat skakels, prente, klanke en flieks bespeur om met \'n blokhakienotasie gespesifiseer te word.

Die blokhakienotasie het die volgende sintaksis:
<code>[url speler breedte hoogte opsies]</code>

**url**
: Die relatiewe of absolute url van die mediadokument

**speler** (opsioneel)
: Die naam van die speler om ingevoeg te word. Die verstek waarde vir hierdie verstelling is "moodle". Die standaard weergawe van die TaskChain-module bied ook die volgende spelers:
: **dew**: \'n mp3-speler
: **dyer**: mp3-speler deur Bernard Dyer
: **hbs**: mp3-speler van Half-Baked Software
: **image**: voeg \'n prent in die webblad in
: **link**: voeg \'n skakel na \'n ander webblad in

**breedte** (opsioneel)
: Die vereiste breedte van die speler

**hoogte** (opsioneel)
: Die vereiste hoogte van die speler. Indien uitgelaat, sal hierdie waarde gestel word na dieselfde as die breedteverstelling.

**opsies** (opsioneel)
: \'n Komma-geskeide lys opsies om na die speler te stuur. Elke opsie kan \'n eenvoudige aan-/af-skakelaar wees, of \'n naamwaardepaar.
: *naam*
: *naam=waarde*
: *naam="waarde met spasies"*';
$string['viewreports'] = 'Besigtig verslae vir {$a} gebruiker(s)';
$string['views'] = 'Besigtigings';
$string['weighting'] = 'Verswaring';
$string['weightingequal'] = 'Gelyke verswaring';
$string['weightingnone'] = 'Geen verswaring';
$string['window'] = 'Venster';
$string['window_help'] = 'Vertoon die aktiwiteit in die hoof Moodle-venster of in \'n opspringvenster.

**Dieselfde venster**
: Die TaskChain-aktiwiteit sal in dieselfde venster as die Moodle-kursusblad vertoon word.

**Nuwe venster**
: Die TaskChain-aktiwiteit sal in \'n opspringvenster vertoon word. Etlike funksies van die opspringvenster kan met merkbokse ontsper of versper word. Die vereiste breedte en hoogte van die opspringventers word as \'n getal van beeldelemente gespesifiseer.';
$string['windowdirectories'] = 'Vertoon die gidsskakels';
$string['windowheight'] = 'Verstek vensterhoogte (in beeldelemente)';
$string['windowlocation'] = 'Vertoon die posisiestafie';
$string['windowmenubar'] = 'Vertoon die kieslysstafie';
$string['windowmoodlebutton'] = 'Vertoon knoppie om venster toe te maak';
$string['windowmoodlefooter'] = 'Vertoon Moodle-bladsyonderskrif';
$string['windowmoodleheader'] = 'Vertoon Moodle-bladsyopskrif';
$string['windowmoodlenavbar'] = 'Vertoon Moodle-navigasiestafie';
$string['windownew'] = 'Nuwe venster';
$string['windowresizable'] = 'Laat toe dat venster se grootte verstel word';
$string['windowsame'] = 'Dieselfde venster';
$string['windowscrollbars'] = 'Laat toe dat venster gerol word';
$string['windowstatus'] = 'Vertoon die statusstafie';
$string['windowtoolbar'] = 'Vertoon die hulpstafie';
$string['windowwidth'] = 'Verstek vensterbreedte (in beeldelemente)';
$string['wrong'] = 'Verkeerd';
$string['youneedtoenrol'] = 'Jy moet in hierdie kursus inskryf voordat jy hierdie TaskChain-aktiwiteit kan poog.';
$string['zeroduration'] = 'Geen tydsduur';
$string['zerograde'] = 'Nulpunt';
$string['zeroscore'] = 'Nultelling';
