<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'af', version '4.5'.
 *
 * @package     theme_essential
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Bo';
$string['activitynavigationposition'] = 'Posisie van aktiwiteitnavigasie';
$string['activitynavigationpositiondesc'] = 'Kies tussen \'Bo\' en \'Onder\' vir die aktiwiteitnavigasie. Waar \'Bo\' bokant die aktiwiteit en \'Onder\' daaronder is. As jy doelgemaakte CSS wil gebruik, gebruik die kieser \'#activitynavigation\'.';
$string['advert_alttext'] = 'Advertensiebanier van Temaontwerp Vlak 1';
$string['advert_heading'] = 'Temaontwerp Vlak 1';
$string['advert_tagline'] = 'Wil jy weet hoe om temas te doelmaak, maar jy het nie \'n agtergrond in ontwikkeling, ervaring met php en ervaring met Moodle-Temas nie, dan is \'MoodleBites Temaontwerp Vlak 1\' net vir jou! Dit bied aan jou \'n gemaklike inleiding tot Moodle-Temaontwikkeling, en bied \'n goeie grondslag indien jy verder sou wou vorder. Kliek asseblief hier vir meer inligting.';
$string['aftercontent'] = 'Ná inhoud';
$string['alert1'] = 'Eerste waarskuwing';
$string['alert2'] = 'Tweede waarskuwing';
$string['alert3'] = 'Derde waarskuwing';
$string['alert_edit'] = 'Wysig waarskuwings';
$string['alert_general'] = 'Aankondiging';
$string['alert_info'] = 'Inligting';
$string['alert_warning'] = 'Waarskuwing';
$string['alertinfodesc'] = 'Voer die verstellings van jou waarskuwing in.';
$string['alertsdesc'] = 'Dit sal \'n waarskuwing (of meer) in drie verskillende style aan jou gebruikers op die Moodle-voorblad vertoon. Onthou asseblief om dit te versper wanneer dit nie meer benodig word nie.';
$string['alertsheading'] = 'Gebruikerwaarskuwings';
$string['alertsheadingsub'] = 'Vertoon belangrike waarskuwings aan jou gebruikers op die voorblad';
$string['alerttext'] = 'Waarskuwingsteks';
$string['alerttextdesc'] = 'Wat is die teks wat jy in jou waarskuwing wil vertoon.';
$string['alerttitle'] = 'Titel';
$string['alerttitledesc'] = 'Hooftitel/opskrif van jou waarskuwing.';
$string['alerttype'] = 'Vlak';
$string['alerttypedesc'] = 'Stel die geskikte waarskuwingsvlak/-tipe om jou gebruikers die beste in te lig.';
$string['allclasses'] = 'Alle klasse';
$string['allcourses'] = 'Alle kursusse';
$string['allmodules'] = 'Alle modules';
$string['allunits'] = 'Alle eenhede';
$string['alternativecolors'] = 'Alternatiewe kleure {$a}';
$string['alternativethemecolor'] = 'Alternatiewe temakleur';
$string['alternativethemecolordesc'] = 'Watter kleur behoort jou tema vir die alternatiewe temakleure {$a} te wees.';
$string['alternativethemecolorname'] = 'Naam van alternatiewe kleurstel {$a}';
$string['alternativethemecolornamedesc'] = 'Verskaf \'n herkenbare naam vir hierdie stel alternatiewe temakleure';
$string['alternativethemecolors'] = 'Alternatiewe temakleure';
$string['alternativethemecolorsdesc'] = 'Definieer alternatiewe temakleure wat die gebruiker kan kies.';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'Verstek knoppie-agtergrondkleur {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'Stel die agtergrondkleur vir alle verstek knoppies {$a}.';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = 'Verstek knoppie-agtergrondsweefkleur {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = 'Stel die agtergrondsweefkleur vir alle verstek knoppies {$a}';
$string['alternativethemedefaultbuttontextcolour'] = 'Verstek knoppie-tekskleur {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'Stel die tekskleur vir alle verstek knoppies {$a}.';
$string['alternativethemedefaultbuttontexthovercolour'] = 'Verstek knoppie-sweeftekskleur {$a}';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = 'Stel die sweeftekskleur vir alle verstek knoppies {$a}';
$string['alternativethemefooterblockbackgroundcolour'] = 'Agtergrondkleur van onderskrifblok vir die alternatiewe temakleure {$a}';
$string['alternativethemefooterblockbackgroundcolourdesc'] = 'Stel die kleur van die blokagtergrond in die onderskrif vir die alternatiewe temakleure {$a}.';
$string['alternativethemefooterblockhovercolour'] = 'Onderskrifblok-skakelsweefkleur vir die alternatiewe temakleure {$a}';
$string['alternativethemefooterblockhovercolourdesc'] = 'Stel die kleur vir jou geskakelde blokteks wanneer daar oor die onderskrif gesweef word, vir die alternatiewe temakleure {$a}.';
$string['alternativethemefooterblocktextcolour'] = 'Onderskrifblok-tekskleur vir die alternatiewe temakleure {$a}';
$string['alternativethemefooterblocktextcolourdesc'] = 'Stel die kleur wat jy wil hê jou blokteks in die onderskrif moet wees, vir die alternatiewe temakleure {$a}.';
$string['alternativethemefooterblockurlcolour'] = 'Onderskrifblok-skakelkleur vir die alternatiewe temakleure {$a}';
$string['alternativethemefooterblockurlcolourdesc'] = 'Stel die kleur van jou geskakelde blokteks in die onderskrif vir die alternatiewe temakleure {$a}.';
$string['alternativethemefootercolor'] = 'Agtergrondkleur van die onderskrif vir die alternatiewe temakleure {$a}';
$string['alternativethemefootercolordesc'] = 'Stel watter kleur die agtergrond van die Onderskrifboks vir die alternatiewe temakleure {$a} behoort te wees.';
$string['alternativethemefooterheadingcolor'] = 'Opskrifkleur in onderskrif vir die alternatiewe temakleure {$a}';
$string['alternativethemefooterheadingcolordesc'] = 'Stel die kleur van opskrifte in die onderskrif vir die alternatiewe temakleure {$a}.';
$string['alternativethemefooterhovercolor'] = 'Sweefkleur van onderskrifskakel vir die alternatiewe temakleure {$a}';
$string['alternativethemefooterhovercolordesc'] = 'Stel die kleur van jou geskakelde teks wanneer daaroor in die onderskrif gesweef word, vir die alternatiewe temakleure {$a}.';
$string['alternativethemefootersepcolor'] = 'Skeierkleur in onderskrif vir die alternatiewe temakleure {$a}';
$string['alternativethemefootersepcolordesc'] = 'Skeiers is lyne wat gebruik word om inhoud te skei. Stel hul kleur hier vir die alternatiewe temakleure {$a}.';
$string['alternativethemefootertextcolor'] = 'Tekskleur van onderskrif vir die alternatiewe temakleure {$a}';
$string['alternativethemefootertextcolordesc'] = 'Stel die kleur wat jy jou teks in die onderskrif wil hê vir die alternatiewe temakleure {$a}.';
$string['alternativethemefooterurlcolor'] = 'Onderskrifskakelkleur vir die alternatiewe temakleure {$a}';
$string['alternativethemefooterurlcolordesc'] = 'Stel die kleur van jou geskakelde teks in die onderskrif vir die alternatiewe temakleure {$a}.';
$string['alternativethemehovercolor'] = 'Alternatiewe tema sweefkleur {$a}';
$string['alternativethemehovercolordesc'] = 'Watter kleur behoort jou temaswewe vir die alternatiewe temakleure {$a} te wees.';
$string['alternativethemeiconcolor'] = 'Alternatiewe ikoonkleur {$a}';
$string['alternativethemeiconcolordesc'] = 'Stel die alternatiewe {$a} kleur vir alle ikone.';
$string['alternativethememycoursesorderenrolbackcolour'] = 'Alternatiewe {$a} ingeskrewe en nie binnegegaande kursusagtergrondkleur';
$string['alternativethememycoursesorderenrolbackcolourdesc'] = 'Stel alternatiewe {$a} agtergrondkleur vir ingeskrewe maar nie binnegegaande kursusse. Vir wanneer \'mykursussevolgorde\' gestel is op \'Laaste toegang verkry ...\'';
$string['alternativethemename'] = 'Naam van kleurskema';
$string['alternativethemenamedesc'] = 'Verskaf \'n naam vir jou alternatiewe temakleure';
$string['alternativethemenavcolor'] = 'Navigasietekskleur {$a}';
$string['alternativethemenavcolordesc'] = 'Stel die alternatiewe {$a} tekskleur vir navigasie. D.w.s. die navigasiestafie en die breadcrumb fancy-styl.';
$string['alternativethemequizsubmitbackgroundcolour'] = 'Vasvra \'Dien alles in en voltooi\' agtergrondkleur {$a}';
$string['alternativethemequizsubmitbackgroundcolourdesc'] = 'Stel die alternatiewe {$a} agtergrondkleur vir die vasvra \'Dien alles in en voltooi\'-knoppie.';
$string['alternativethemequizsubmitbackgroundhovercolour'] = 'Vasvra \'Dien alles in en voltooi\' agtergrondsweefkleur {$a}';
$string['alternativethemequizsubmitbackgroundhovercolourdesc'] = 'Stel die alternatiewe {$a} agtergrondsweefkleur vir die vasvra \'Dien alles in en voltooi\'-knoppie.';
$string['alternativethemequizsubmittextcolour'] = 'Vasvra \'Dien alles in en voltooi\' tekskleur {$a}';
$string['alternativethemequizsubmittextcolourdesc'] = 'Stel die alternatiewe {$a} tekskleur vir die vasvra \'Dien alles in en voltooi\'-knoppie.';
$string['alternativethemequizsubmittexthovercolour'] = 'Vasvra \'Dien alles in en voltooi\' tekssweefkleur {$a}';
$string['alternativethemequizsubmittexthovercolourdesc'] = 'Stel die alternatiewe {$a} tekssweefkleur vir die vasvra \'Dien alles in en voltooi\'-knoppie.';
$string['alternativethemesidepreblockbackgroundcolour'] = 'Alternatiewe {$a}\'side-pre\'-blok agtergrondkleur';
$string['alternativethemesidepreblockbackgroundcolourdesc'] = 'Stel die alternatiewe {$a} agtergrondkleur vir die \'side-pre\'-blok.';
$string['alternativethemesidepreblockhovercolour'] = 'Alternatiewe {$a} \'side-pre\'-blok skakelsweefkleur';
$string['alternativethemesidepreblockhovercolourdesc'] = 'Stel die alternatiewe {$a} skakelsweefkleur vir die \'side-pre\'-blok.';
$string['alternativethemesidepreblocktextcolour'] = 'Alternatiewe {$a} \'side-pre\'-blok tekskleur';
$string['alternativethemesidepreblocktextcolourdesc'] = 'Stel die alternatiewe {$a} tekskleur vir die \'side-pre\'-blok.';
$string['alternativethemesidepreblockurlcolour'] = 'Alternatiewe {$a} \'side-pre\'-blok skakelkleur';
$string['alternativethemesidepreblockurlcolourdesc'] = 'Stel die alternatiewe {$a} skakelkleur vir die \'side-pre\'-blok.';
$string['alternativethemeslidebuttoncolor'] = 'Alternatiewe tema skyfieknoppiekleur {$a}';
$string['alternativethemeslidebuttoncolordesc'] = 'Watter kleur behoort jou tema skyfieknoppie te wees vir die alternatiewe temakleure {$a}.';
$string['alternativethemeslidebuttonhovercolor'] = 'Alternatiewe tema skyfieknoppie sweefkleur {$a}';
$string['alternativethemeslidebuttonhovercolordesc'] = 'Watter sweefkleur behoort jou tema skyfieknoppie vir die alternatiewe temakleure {$a} te wees.';
$string['alternativethemeslidecaptionbackgroundcolor'] = 'Alternatiewe tema skyfieopskrif agtergrondkleur {$a}';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = 'Watter kleur behoort jou tema skyfieopskrif agtergrond vir die alternatiewe temakleure {$a} te wees. Nie van toepassing op \'Langs\' skyfieopskrifopsie nie.';
$string['alternativethemeslidecaptiontextcolor'] = 'Alternatiewe tema skyfieopskrif tekskleur {$a}';
$string['alternativethemeslidecaptiontextcolordesc'] = 'Watter kleur behoort jou tema skyfieopskrifteks vir die alternatiewe temakleure {$a} te wees. Nie van toepassing op \'Langs\' skyfieopskrifopsie nie.';
$string['alternativethemeslidecolors'] = 'Alternatiewe tema skyfiekleure';
$string['alternativethemeslidecolorsdesc'] = 'Definieer alternatiewe tema skyfiekleure wat die gebruiker kan kies.';
$string['alternativethemestripebackgroundcolour'] = 'Alternatiewe streep agtergrondkleur {$a}';
$string['alternativethemestripebackgroundcolourdesc'] = 'Stel die alternatiewe {$a} agtergrondkleur vir strepe in tabelle.';
$string['alternativethemestripetextcolour'] = 'Alternatiewe streeptekskleur {$a}';
$string['alternativethemestripetextcolourdesc'] = 'Stel die alternatiewe {$a} tekskleur vir strepe in tabelle.';
$string['alternativethemestripeurlcolour'] = 'Alternatiewe streep-URL kleur {$a}';
$string['alternativethemestripeurlcolourdesc'] = 'Stel die alternatiewe {$a} URL kleur vir strepe in tabelle.';
$string['alternativethemetextcolor'] = 'Alternatiewe tekskleur {$a}';
$string['alternativethemetextcolordesc'] = 'Stel die kleur van jou alternatiewe teks {$a}.';
$string['alternativethemeurlcolor'] = 'Alternatiewe skakelkleur {$a}';
$string['alternativethemeurlcolordesc'] = 'Stel die kleur van jou alternatiewe geskakelde teks {$a}';
$string['alwaysdisplay'] = 'Vertoon altyd';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Verskaf \'n URL na jou mobiele toep op die Google Play Store. As jy nie een van jou eie het nie, oorweeg om moontlik aan die amptelike Moodle Mobiele toep te koppel. (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['androidurl'] = 'Android (Google Play)-URL';
$string['asconfigintlower'] = '{$a->value} is minder as die onderste meetgrens van {$a->lower}';
$string['asconfigintnan'] = '{$a->value} is nie \'n getal nie';
$string['asconfigintupper'] = '{$a->value} is meer as die boonste meetgrens van {$a->upper}';
$string['backtotop'] = 'Terug na bo';
$string['badgepreferences'] = 'Kenteken';
$string['badgesmi'] = 'Kentekens';
$string['badgesmidesc'] = 'Vertoon die kentekenkieslysitem as die gebruiker die \'moodle/kentekens:bestuureiekentekens\' vermoë het en kentekens op werfvlak ontsper is.';
$string['beforecontent'] = 'Voor inhoud';
$string['below'] = 'Onder';
$string['breadcrumbsimple'] = 'Eenvoudig';
$string['breadcrumbstyle'] = 'Breadcrumb-styl';
$string['breadcrumbstyled'] = 'Spoggerig';
$string['breadcrumbstyledesc'] = 'Hier kan jy die styl van die breadcrumbs verander.';
$string['breadcrumbstylednocollapse'] = 'Spoggerig met geen toevou';
$string['breadcrumbthin'] = 'Smal';
$string['cachesused'] = 'Gebruikte gekas';
$string['calendarmi'] = 'Kalender';
$string['calendarmidesc'] = 'Vertoon die kalenderkieslysitem as die gebruiker die
\'moodle/kalender:bestuureieinvoere\' vermoë het.';
$string['categoryctidesc'] = 'Indien ontsper, sal dit jou toelaat om prente vir elke kategorie te stel.';
$string['categoryctiheading'] = 'Kategorie kursustitelprente';
$string['categoryctiheadingcategory'] = 'Kategorie kursustitelprente vir: {$a->category}';
$string['categoryctiheadingcs'] = 'Konfigurasie van kategorie kursustitelprente';
$string['categoryctiheadingsub'] = 'Gebruik prente om jou kategorieë in \'n kursus voor te stel';
$string['categoryctiheight'] = 'Prenthoogte van Kategorie \'{$a->category}\' kursustitel';
$string['categoryctiheightdesc'] = 'Prentgroote vir die kursustitel in kategorie \'{$a->category}\' tussen {$a->lower} en {$a->upper} beeldelemente. Moet nie \'px\' agterna bylas nie, voer slegs die getal in.';
$string['categoryctiinfo'] = '{$a->category} verstellings';
$string['categoryctiinfodesc'] = 'Kategorie kursustitel-prentverstellings vir: {$a->category}';
$string['categoryctimage'] = 'Kategorie \'{$a->category}\' kursustite-lprentdokument';
$string['categoryctimagedesc'] = 'Prentdokument vir die kursustitel in kategorie \'{$a->category}\'.';
$string['categoryctimageurl'] = 'Kategorie \'{$a->category}\' kursustitelprent-URL';
$string['categoryctimageurldesc'] = 'Prent-URL vir die kursustitel in kategorie \'{$a->category}\'. As die dokument opgelaai is, sal dit hierdie oorheenskryf.';
$string['categoryctitextbackgroundcolour'] = 'Kategorie \'{$a->category}\' kursustitel-teksagtergrondkleur';
$string['categoryctitextbackgroundcolourdesc'] = 'Teksagtergrondkleur vir die kursustitel in kategorie \'{$a->category}\'.';
$string['categoryctitextbackgroundopacity'] = 'Agtergronddeursigtigheid van Kategorie \'{$a->category}\' kursustitelteks';
$string['categoryctitextbackgroundopacitydesc'] = 'Teksagtergronddeursigtigheid vir die kursustitel in kategorie \'{$a->category}\'.';
$string['categoryctitextcolour'] = 'Kategorie \'{$a->category}\' kursustitel-tekskleur';
$string['categoryctitextcolourdesc'] = 'Tekskleur vir die kursustitel in kategorie \'{$a->category}\'.';
$string['categoryiconcategory'] = 'DIe ikoon vir die kategorie: \'{$a->category}\'';
$string['categoryicondesc'] = 'Indien ontsper, sal dit jou toelaat om ikone/prente vir elke kategorie te stel.';
$string['categoryiconheading'] = 'Kategorie-ikone/-prente';
$string['categoryiconheadingsub'] = 'Gebruik ikone om jou kategorieë voor te stel';
$string['categoryiconinfo'] = 'Stel doelgemaakte kategorie-ikone';
$string['categoryiconinfodesc'] = 'Voer die naam in van die ikoon of laai \'n prent op wat jy wil gebruik. Die lys kan <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a> gevind word. Voer slegs in wat ná "fa-" is.';
$string['categoryimagecategory'] = 'Die prent vir die kategorie: {$a->category}.';
$string['categoryincoursebreadcrumbfeature'] = 'Kategorieë in die kursus-breadcrumb';
$string['categoryincoursebreadcrumbfeaturedesc'] = 'Vertoon die kategorieskakels in die kursus se breadcrumb.';
$string['ccd'] = 'Kursus geskep op (datum)';
$string['ced'] = 'Einddatum van kursus';
$string['cfn'] = 'Volnaam van kursus';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" alt="Essential screen shot"/></p>
</div>
<div class="well">
<h3>Inligting oor Essential</h3>
<p>Essential is gebaseer op die Bootstrap-tema, wat vir Moodle 2.5 geskep is met die hulp van:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Temakrediete</h3>
<p>Oorspronklike Outeur: Julian Ridden<br>
Werk in Julie 2014 oorgeneem deur:<br>
Gareth J. Barnard<br>
David Bezemer<br>
Werk op 9 Oktober 2014 oorgeneem deur:<br>
Gareth J. Barnard<br>
</p>
<h3>Borgskappe</h3>
<p>Hierdie tema word gratis aan jou verskaf en as jy jou dankbaarheid vir die gebruik daarvan wil betoon, oorweeg asseblief \'n borgskap deur:
<h4>PayPal</h4>
<p>Kontak my asseblief deur my <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle-profiel\'</a> vir besonderhede, aangesien ek \'n individu is en kragtens hul bepalings nie \'koop my nou\'-knoppies kan hê nie.</p>
<br>Borgskappe help om onderhoud moontlik te maak en laat my toe om meer en beter funksies aan jou te bied. Sonder jou ondersteuning kan die tema nie onderhou word nie.</p>
<p>
<h3>Borge</h3>
<p>Borgskappe is met dankbaarheid ontvang vanaf:</p>
<ul>
<li>Mihai Bojonca, TCM Internasionale Instituut.</li>
<li>Guido Hornig, actXcellence <a href="//actxcellence.de" target="_blank">actxcellence.de</a></li>
<li>Delvon Forrester, Esparanza co uk</li>
<li>iZone</li>
<li>Anis Jradah</li>
<li>Ute Hlasek, <a href="//hlasek-it.de/moodle" target="_blank">hlasek-it.de/moodle</a></li>
</ul>
</p>
<p>
<h3>Essential vir Moodle 3.3 vriendelik geborg deur:</h3>
<ul>
<li>ClassroomRevolution, LLC - Moodle Partner</li>
<li>Daniel Méthot - e-learning-facile.com/formations/</li>
<li>Floyd Saner, Learning Contexts, LLC</li>
<li>Gemma Lesterhuis</li>
<li>Mihai Bojonca, TCM Internasionale Instituut</li>
</ul>
</p>
<h3>Doelmaking</h3>
<p>As jy van hierdie tema hou en wil hê ek moet dit doelmaak, funksionaliteit transponeer, \'n nuwe tema van nuuts af bou, of \'n nasaattema skep, bied ek mededingende pryse.  Kontak my asseblief deur  \'http://moodle.org/user/profile.php?id=442195\' om jou vereistes te bespreek.</p>
</div></div>';
$string['cid'] = 'Kursus-ID';
$string['colordesc'] = 'Hier kan jy verskillende verstellings vind om baie van die kleure wat in hierdie tema voorkom, te verander.';
$string['colorheading'] = 'Kleur';
$string['colorheadingsub'] = 'Stel die kleure wat in jou tema gebruik word';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Kontakinligting';
$string['contactinfodesc'] = 'Voer jou kontakinligting in';
$string['copyright'] = 'Kopiereg';
$string['copyrightdesc'] = 'Die naam van jou instelling.';
$string['coursecategorysettingstitle'] = 'Kursuskategorieverstellings';
$string['coursecontentsearch'] = 'Deursoek kursusinhoud';
$string['coursecontentsearchdesc'] = 'Ontsper kursusinhoud op die \'Paneelbord\'-blad. Werk slegs wanneer Essential nie in \'\\$CFG->themedir\' is nie.';
$string['coursecontentsearchsortattribute'] = 'Sorteerkenmerk van kursusinhoudsoektog';
$string['coursecontentsearchsortattributedesc'] = 'Sorteer die soekuitslae volgens hierdie kenmerk.';
$string['coursecontentsearchsortorder'] = 'Sorteervolgorde van kursusinhoudsoektog';
$string['coursecontentsearchsortorderdesc'] = 'Sorteer die soekuitslae in stygende of dalende volgorde.';
$string['coursegrades'] = 'Kursuspunte';
$string['coursegradesmi'] = 'Kursuspunte';
$string['coursegradesmidesc'] = 'Vertoon die kursuspuntekieslys as die gebruiker die \'punteverslag/gebruiker:besigtig\'-vermoë het en die kursusverstelling van \'vertoonpunte\' in \'n kursus gestel is.';
$string['courselistteachericon'] = 'Kursuslys-onderwyserikoon';
$string['courselistteachericondesc'] = 'Naam van die ikoon wat jy wil gebruik, of leeg vir geen. Die lys is <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voer net in wat ná die "fa-" is, bv. "star".';
$string['coursesettingstitle'] = 'Kursusverstellings';
$string['coursetitleposition'] = 'Posisie van Kursustitel';
$string['coursetitlepositiondesc'] = 'Kies tussen \'Bo\' en \'Binne\' vir die kursus. Waar \'Bo\' bokant die side-pre-, bladsybokant- en kursusinhoudafdelings is en \'Binne\' binne die kursusinhoudarea is, soos wat dit was voor hierdie verstelling bekendgestel is.';
$string['csd'] = 'Aanvangsdatum van kursus';
$string['ctioverride'] = 'Oorheenskryf van kategorieprente in \'n kursus';
$string['ctioverridedesc'] = 'As jy die titelprent van die kategoriekursus in \'n kursus wil oorheenskryf, wanneer dit met die \'enablecategorycti\'-verstelling ontsper is, wysig dan die kursusopsomming in die kursusverstellings en voeg \'n prent by. In HTML-modus verwyder jy dan die omringende \'p\'-merkers en \'br\'-merker, verwyder dan die \'styl\', \'breedte\' en \'hoogte\' kenmerke en enige \'klasse\' wat deur die tekswysiger op die \'img\'-merker bygevoeg is. Voeg dan die klas \'categorycti\' by. Om die hoogte (px) te en die titeltekskleur wat bevat word, te spesifiseer, asook die agtergrondkleur en deursigtigheid, gebruik die volgende kenmerke onderskeidelik: \'ctih\', \'ctit\', \'ctib\' en \'ctio\', byvoorbeeld:<br/><br/>&lt;img src=&quot;https://mymoodleinstall.me/pluginfile.php/493/course/section/237/myimage.jpg&quot; alt=&quot;Replacement image&quot; class=&quot;categorycti&quot; ctih=&quot;250&quot; ctit=&quot;#afafaf&quot; ctib=&quot;#222222&quot; ctio=&quot;0.5&quot;&gt;<br/><br/>Hierdie prent sal nie in die opsomming self vertoon word wanneer die kursuslys besigtig word nie.';
$string['ctioverrideheight'] = 'Verstek oorheengeskrewe prenthoogte van kursustitel';
$string['ctioverrideheightdesc'] = 'Verstek oorheengeskrewe prenthoogte vir die kursustitel tussen {$a->lower} en {$a->upper} beeldelemente. Moet nie \'px\' as agtervoegsel bysit nie, voer slegs die getal in.';
$string['ctioverridetextbackgroundcolour'] = 'Verstek oorheengeskrewe teksagtergrondkleur van kursustitel';
$string['ctioverridetextbackgroundcolourdesc'] = 'Verstek oorheengeskrewe teksagtergrondkleur vir die kursustitel.';
$string['ctioverridetextbackgroundopacity'] = 'Verstek oorheengeskrewe deursigtigheid van teksagtergrond van kursustitel';
$string['ctioverridetextbackgroundopacitydesc'] = 'Verstek oorheengeskrewe deursigtigheid van teksagtergrond vir die kursustitel.';
$string['ctioverridetextcolour'] = 'Verstek oorheengeskrewe tekskleur van kursustitel';
$string['ctioverridetextcolourdesc'] = 'Verstek oorheengeskrewe tekskleur vir die kursustitel.';
$string['customcss'] = 'Doelgemaakte CSS';
$string['customcssdesc'] = 'Watter CSS-reëls jy ook al by hierdie teksarea voeg, sal op elke bladsy weerspieël word, wat die doelmaak van hierdie tema vergemaklik.';
$string['customscrollbars'] = 'Doelgemaakte rolstawe';
$string['customscrollbarsdesc'] = 'Gebruik doelgemaakte rolstawe. Dit sal die standaard blaaierrolstawe vervang.';
$string['dbqueries'] = 'DB Lees/Skryf';
$string['dbtime'] = 'DB Navraetyd';
$string['defaultcategoryicon'] = 'Verstek kategorie-ikoon';
$string['defaultcategoryicondesc'] = 'Stel \'n verstek kategorie-ikoon.';
$string['defaultcategoryimage'] = 'Verstek kategorieprent';
$string['defaultcategoryimagedesc'] = 'Stel \'n verstek kategorieprent. Sal die ikoon oorheenskryf wanneer bevolk.';
$string['defaultcolors'] = 'Verstek kleure';
$string['displayafterlogin'] = 'Vertoon slegs ná intekening';
$string['displaybeforelogin'] = 'Vertoon slegs voor intekening';
$string['displayeditingmenu'] = 'Vertoon wysig-knoppie';
$string['displayeditingmenudesc'] = 'Vertoon \'n knoppie met dieselfde funksionaliteit as die verstek bladsywysig-knoppie op die hofie.';
$string['displayhiddenmycourses'] = 'Vertoon versteekte kursusse';
$string['displayhiddenmycoursesdesc'] = 'Vertoon versteekte kursusse aan gebruikers in die \'Kursusse kieslys\' as hulle toestemming het om versteekte kursusse te besigtig.';
$string['displaymycourses'] = 'Vertoon kursusse';
$string['displaymycoursesdesc'] = 'Vertoon ingeskrewe kursusse van gebruikers op die \'Navstafie\'.';
$string['docking'] = 'Ontsper vasmeer.';
$string['dockingdesc'] = 'Indien ontsper, sal vasmeer beskikbaar wees.';
$string['dontdisplay'] = 'Vertoon nooit';
$string['dropdownmenumaxheight'] = 'Maksimum hoogte van Aftrekkieslys';
$string['dropdownmenumaxheightdesc'] = 'Maksimum hoogte van aftrekkieslys wanneer rolstawe ontsper is. Tussen {$a->lower} en {$a->upper} beeldelemente.';
$string['dropdownmenuscroll'] = 'Rolstawe in die aftrekkieslyste';
$string['dropdownmenuscrolldesc'] = 'Hê \'n rolstaaf op die aftrekkieslys waar die hoogte van die kieslys beperk is.';
$string['editingmenu'] = 'Bladsywysigingskakelaar';
$string['editingmenudesc'] = 'Vertoon \'n knoppie om die wysiging van die huidige bladsy aan/af te skakel as die gebruiker toegelaat word om die bladsy te wysig. Dieselfde funksionaliteit as die normale bladsywysiging-knoppie.';
$string['enablealert'] = 'Ontsper waarskuwings';
$string['enablealertdesc'] = 'Ontsper of versper waarskuwings';
$string['enablealternativethemecolors'] = 'Ontsper alternatiewe temakleure {$a}';
$string['enablealternativethemecolorsdesc'] = 'Indien ontsper, sal die gebruiker die alternatiewe temakleure {$a} kan kies.';
$string['enablecategorycti'] = 'Ontsper titelprente van kategoriekursus';
$string['enablecategoryctics'] = 'Ontsper kategoriekursus se titelprentkategorie-verstellingblaaie';
$string['enablecategorycticsdesc'] = 'Indien ontsper, sal elke topvlak-kategorie sy eie verstellingsblad hê.';
$string['enablecategoryctidesc'] = 'Indien ontsper, sal jy kategoriekursus-titelprente kan kies nadat jy "Berg veranderinge" gekliek het.';
$string['enablecategoryicon'] = 'Ontsper kategorie-ikone/-prente';
$string['enablecategoryicondesc'] = 'Indien ontsper, sal jy kategorie-ikone/-prente kan kies nadat jy "Berg veranderinge" gekliek het.';
$string['enablecustomcategoryicon'] = 'Ontsper doelgemaakte kategorie-ikone/-prente';
$string['enablecustomcategoryicondesc'] = 'Indien ontsper, sal jy onder hierdie afdeling elke kategorie sien met \'n doelmaakbare opsie agter elkeen. Berg asseblief ná hierdie ontsper/versper word.';
$string['extperfinfoheading'] = 'Verlengde Prestasie-inligting';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'Voer die URL van jou Facebook-blad in (d.w.s. https://www.facebook.com/mycollege)';
$string['facebookurl'] = 'Facebook-URL';
$string['favicon'] = 'Doelgemaakte favicon';
$string['favicondesc'] = 'Laai jou eie favicon op. Dit behoort \'n .ico-dokument te wees.';
$string['featuredesc'] = 'Hier kan jy verskillende verstellings kry om baie van die eienskappe wat in hierdie tema voorkom, te verander.';
$string['featureheading'] = 'Eienskappe';
$string['featureheadingsub'] = 'Stel die eienskappe wat in jou tema gebruik word.';
$string['findcoursecontent'] = 'Kursussoektog:';
$string['fitvids'] = 'Gebruik FitVids';
$string['fitvidsdesc'] = 'Ontsper FitVids (fitvidsjs.com) om jou vasgelegde video\'s responsief te maak. As FitVids aan is en jy wil \'n video uitsluit, voeg dan \'class="fitvidsignore" by die \'iframe\'-merker in die HTML-modus van die wysiger. Byvoorbeeld: \'iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe\'.';
$string['fixedwidthnarrow'] = 'Vasgestelde breedte - Smal';
$string['fixedwidthnormal'] = 'Vasgestelde breedte - Normaal';
$string['fixedwidthwide'] = 'Vasgestelde breedte - Breed';
$string['flatnavigation'] = 'Ontsper plat navigasie';
$string['flatnavigationdesc'] = 'As plat navigasie ontsper word, sal dit in stede van die navigasie- en verstellingsblokke gebruik word.';
$string['flickr'] = 'Flickr';
$string['flickrdesc'] = 'Voer die URL van jou Flickr-blad in (d.w.s. http://www.flickr.com/photos/mycollege)';
$string['flickrurl'] = 'Flickr-URL';
$string['floatingsubmitbuttons'] = 'Drywende dien in-knoppies';
$string['floatingsubmitbuttonsdesc'] = 'Hê \'n \'drywende\' area wat die knoppies bevat wat gebruik word wanneer \'n vorm op rekenaartoestelle ingedien word. Dit help om rol op sekere bladsye te verminder. Word nie op kursusinskrywing of forumplasings gebruik nie.';
$string['fontcharacterset'] = 'Google font addisionele karakterstel';
$string['fontcharactersetcyrillic'] = 'Cyrillic';
$string['fontcharactersetcyrillicext'] = 'Cyrillic Verleng';
$string['fontcharactersetdesc'] = 'Kies bykomende karakterstelle vir verskillende tale.
                                   Om baie karakterstelle te gebruik, kan jou Moodle vertraag, kies dus slegs die karakterstelle wat jy werklik benodig.';
$string['fontcharactersetgreek'] = 'Grieks';
$string['fontcharactersetgreekext'] = 'Grieks Verleng';
$string['fontcharactersetlatinext'] = 'Latyn Verleng';
$string['fontcharactersetvietnamese'] = 'Viëtnamees';
$string['fontfileeotbody'] = 'Liggaam EOT-fontdokument';
$string['fontfileeotheading'] = 'Opskrif EOT-fontdokument';
$string['fontfileotfbody'] = 'Liggaam OTF-fontdokument';
$string['fontfileotfheading'] = 'Opskrif OTF-fontdokument';
$string['fontfiles'] = 'Fontdokumente';
$string['fontfilesdesc'] = 'Laai jou fontdokumente hier op.';
$string['fontfilesvgbody'] = 'Liggaam SVG-fontdokument';
$string['fontfilesvgheading'] = 'Opskrif SVG-fontdokument';
$string['fontfilettfbody'] = 'Liggaam TTF-fontdokument';
$string['fontfilettfheading'] = 'Opskrif TTF-fontdokument';
$string['fontfilewoffbody'] = 'Liggaam WOFF-fontdokument';
$string['fontfilewoffheading'] = 'Opskrif WOFF-fontdokument';
$string['fontfilewofftwobody'] = 'Liggaam WOFF2-fontdokument';
$string['fontfilewofftwoheading'] = 'Opskrif WOFF2-fontdokument';
$string['fontheadingdesc'] = 'Kies en voer die fonte in wat jy in jou Moodle-omgewing wil gebruik.';
$string['fontheadingsub'] = 'Fontverstellings';
$string['fontnamebody'] = 'Teksfont';
$string['fontnamebodydesc'] = 'Voer die presiese naam in van die font om vir alle ander teks te gebruik.';
$string['fontnameheading'] = 'Opskriffont';
$string['fontnameheadingdesc'] = 'Voer die presiese naam van die font in om vir opskrifte te gebruik.';
$string['fontselect'] = 'Fonttipe-kieser';
$string['fontselectdesc'] = 'Kies uit die lys van beskikbare fontdefiniëringsmeganismes:<ul><li>\'Gebruikerfonte\' is waar die font reeds op die gebruiker se toestel geïnstalleer is en jy net die naam spesifiseer.</li><li>\'Google webfonte\' is waar jy \'n font op \'{$a->googlewebfonts}\' vind en die naam spesifiseer.</li><li>\'Doelgemaakte fonte\' is waar jy die naam spesifiseer en die fontdokumente vir die font oplaai.</li></ul>Berg asseblief om die opsies van jou keuse te vertoon.';
$string['fontsettings'] = 'Font';
$string['fonttypecustom'] = 'Doelgemaakte fonte';
$string['fonttypegoogle'] = 'Google webfonte';
$string['fonttypeuser'] = 'Gebruikerfonte';
$string['footerblockbackgroundcolour'] = 'Agtergrondkleur van onderskrifblok';
$string['footerblockbackgroundcolourdesc'] = 'Stel die kleur van die blokagtergrond in die ondersrkif.';
$string['footerblockhovercolour'] = 'Skakelsweefkleur van onderskrifblok';
$string['footerblockhovercolourdesc'] = 'Stel die kleur van jou geskakelde blokteks waaroor daar in die onderskrif gesweef word.';
$string['footerblocktextcolour'] = 'Tekskleur van onderskrifblok';
$string['footerblocktextcolourdesc'] = 'Stel die kleur wat jy wil hê die blokteks in die onderskrif moet wees.';
$string['footerblockurlcolour'] = 'Skakelkleur van onderskrifblok';
$string['footerblockurlcolourdesc'] = 'Stel die kleur van jou geskakelde blokteks in die onderskrif.';
$string['footercolor'] = 'Agtergrondkleur van onderskrif';
$string['footercolordesc'] = 'Stel watter kleur die agtergrond van die Onderskrifboks moet wees.';
$string['footercolors'] = 'Onderskrifkleure';
$string['footercolorsdesc'] = 'Verander die kleure van die bladsyonderskrif.';
$string['footerheading'] = 'Onderskrif';
$string['footerheadingcolor'] = 'Opskrifkleur in onderskrif';
$string['footerheadingcolordesc'] = 'Stel die kleur van opskrifte in die onderskrif.';
$string['footerhovercolor'] = 'Skakelsweefkleur in onderskrif';
$string['footerhovercolordesc'] = 'Stel die kleur van jou geskakelde teks in die onderskrif waaroor gesweef word.';
$string['footersepcolor'] = 'Kleur van onderskrifskeier';
$string['footersepcolordesc'] = 'Skeiers is lyne wat gebruik word om inhoud te skei. Stel die kleur daarvan hier.';
$string['footertextcolor'] = 'Tekskleur van onderskrif';
$string['footertextcolordesc'] = 'Stel jou verkose kleur van die teks in die onderskrif.';
$string['footerurlcolor'] = 'Skakelkleur in onderskrif';
$string['footerurlcolordesc'] = 'Stel die kleure van jou geskakelde teks in die onderskrif.';
$string['footnote'] = 'Voetnoot';
$string['footnotedesc'] = 'Wat jy ook al by hierdie teksarea voeg, sal regdeur jou Moodle-werf in die onderskrif vertoon word.';
$string['forumdiscussionsmi'] = 'Besprekings';
$string['forumdiscussionsmidesc'] = 'Vertoon die besprekings- (forum-) kieslysitem as die gebruiker oor die \'mod/forum:viewdiscussion\' vermoë beskik.';
$string['forumpostsmi'] = 'Forumplasings';
$string['forumpostsmidesc'] = 'Vertoon die forumplasings-kieslysitem as die gebruiker oor die \'mod/forum:viewdiscussion\' vermoë beskik.';
$string['fppagetopblocks'] = 'Ontsper bykomende voorblad \'Bokant van Bladsy\'-blokke';
$string['fppagetopblocksdesc'] = 'Indien ontsper, sal hierdie \'n bykomende blokposisie langs die kantblokke en bokant die inhoudarea vertoon. Let wel: Die aantal blokke per ry hang af van die verstelling \'fppagetopblocksperrow\'.';
$string['fppagetopblocksperrow'] = 'Bladsybokant blokke per ry';
$string['fppagetopblocksperrowdesc'] = 'Stel hoevel blokke per ry tussen {$a->lower} en {$a->upper} vir die \'Bladsybokant\' blokarea op die voorblad.';
$string['frontcontent'] = 'Aktiveer voorbladinhoudarea';
$string['frontcontentarea'] = 'Voorbladinhoud areainhoud';
$string['frontcontentareadesc'] = 'Wat ook al in hierdie boks getik word, sal oor die volle breedte van die bladsy tussen die skyfievertoning en die Bemarkingsplekke vertoon word';
$string['frontcontentdesc'] = 'Indien ontsper, voeg dit doelgemaakte inhoud tussen die \'Skyfievertoning\' en die \'Bemarkingsbokse\' vir jou eie doelgemaakte inhoud.';
$string['frontcontentheading'] = 'Voorbladinhoudarea';
$string['frontpageblocks'] = 'Voorbladblokbelyning';
$string['frontpageblocksdesc'] = 'Hier kan jy bepaal of die standaard Moodle-blokke op die voorblad voor of ná die inhoud belyn.';
$string['frontpageblocksheading'] = 'Voorbladblokke';
$string['frontpageheading'] = 'Voorblad';
$string['frontpageheadingdesc'] = 'Konfigureer hier watter bykomende items jy op die voorblad wil vertoon.';
$string['frontpagehomeblocksperrow'] = 'Tuis (was \'Middel\') blokke per ry';
$string['frontpagehomeblocksperrowdesc'] = 'Stel hoeveel blokke per ry tussen {$a->lower} en {$a->upper} vir die \'Tuisblokke\'-blokarea. Let wel: T.w.v. gemak tydens wysiging, sal twee blokke per ry vertoon word, ongeag hierdie verstellling.';
$string['frontpagemiddleblocks'] = 'Ontsper bykomende voorblad \'Tuis\' (was \'Middel\') -blokke';
$string['frontpagemiddleblocksdesc'] = 'Indien ontsper, sal hierdie \'n bykomende blokplek net onder die bemarkingsplekke vertoon.';
$string['frontpagesettingstitle'] = 'Voorbladverstellings';
$string['fullname'] = 'Volle naam van Werf';
$string['fullnamesummary'] = 'Volle naam en opsomming';
$string['generalheadingdesc'] = 'Konfigureer die algemene verstellings van die tema hier.';
$string['generalheadingsub'] = 'Algemene verstellings';
$string['genericsettings'] = 'Algemeen';
$string['googleplus'] = 'Google+';
$string['googleplusdesc'] = 'Voer die URL van jou Google+ profiel in (d.w.s. https://plus.google.com/+mycollege)';
$string['googleplusurl'] = 'Google+ URL';
$string['gotobottom'] = 'Gaan na die onderkant van die bladsy';
$string['gotopeople'] = 'Gaan na mense';
$string['haveheaderblock'] = 'Hofieblokarea';
$string['haveheaderblockdesc'] = 'Hê \'n hofieblokarea net onder die breadcrumb.';
$string['headerbackground'] = 'Hofieagtergrondprent';
$string['headerbackgrounddesc'] = 'Laai jou eie agtergrondprent op.';
$string['headerbackgroundstyle'] = 'Agtergrondstyl van hofie';
$string['headerbackgroundstyledesc'] = 'Kies die styl van die hofie se agtergrond.';
$string['headerblocksperrow'] = 'Hofieblokke per ry';
$string['headerblocksperrowdesc'] = 'Stel hoeveel blokke per ry tussen {$a->lower} en {$a->upper} vir bladsye met die \'Hofieblokarea\'.';
$string['headerheading'] = 'Hofie';
$string['headertextcolor'] = 'Tekskleur van hofie';
$string['headertextcolordesc'] = 'Stel die tekskleur van die hofie.';
$string['headertitle'] = 'Hofietitel';
$string['headertitledesc'] = 'Konfigureer hier watter titel om in die hofie te plaas. Let wel: Die hofietitel sal slegs gebruik word as daar geen logo is nie.';
$string['helplink'] = 'Hulpskakel';
$string['helplinkdesc'] = 'As jy URL hierbo kies, vul die volledige URL na jou hulpwerf in (moet http:// or https:// insluit). As jy e-posadres kies, vul jou e-posadres in.';
$string['helplinktype'] = 'Ontsper hulpskakel in kieslys';
$string['helplinktypedesc'] = 'Kies of jy \'n hulpopsie in die gebruikerskieslys wil ontsper. Jy kan kies om \'n URL te verskaf, wat in \'n nuwe venster oopgemaak sal word, of \'n e-posadres.';
$string['hidedefaulteditingbutton'] = 'Versteek verstek bladsywysig-knoppie';
$string['hidedefaulteditingbuttondesc'] = 'Versteek die verstek bladsywysig-knoppie van enige bladsy. Hierdie verstelling tree slegs in werking as die "Vertoon wysig-knoppie"-verstelling ontsper is.';
$string['hideonphone'] = 'Versteek skyfievertoning op mobiele toestelle';
$string['hideonphonedesc'] = 'Kies as jy skyfievertonings op mobiele toestelle wil versper.';
$string['hideontablet'] = 'Versteek skyfievertoning op tablette';
$string['hideontabletdesc'] = 'Kies as jy skyfievertonings op tablette wil versper.';
$string['hvpcustomcss'] = 'H5P Doelgemaakte CSS';
$string['hvpcustomcssdesc'] = 'Doelgemaakte CSS vir die H5P-module (moodle.org/plugins/mod_hvp) indien geïnstalleer.';
$string['icon'] = 'ikoon';
$string['image'] = 'prent';
$string['included'] = 'Dokumente Ingesluit';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'Voer die URL van jou Instagram-blad in (d.w.s. http://instagram.com/mycollege)';
$string['instagramurl'] = 'Instagram-URL';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Verskaf \'n URL na jou mobiele Toep op die App Store. As jy nie een van jou eie het nie, kan jy oorweeg om na die amptelike Moodle Mobiele toep te skakel (https://itunes.apple.com/en/app/moodle-mobile/id633359593).';
$string['iosicon'] = 'iOS tuisskermikone';
$string['iosicondesc'] = 'Die tema verskaf \'n verstek ikoon vir iOS en androïed-tuisskerms. Jy kan jou doelgemaakte ikone oplaai as jy sou wou.';
$string['iosurl'] = 'iPhone/iPad (App Store) URL';
$string['ipadicon'] = 'iPad-ikoon (nie-retina)';
$string['ipadicondesc'] = 'Ikoon behoort \'n PNG-dokument te wees wat 72 px by 72 px groot is.';
$string['ipadretinaicon'] = 'iPad-ikoon (retina)';
$string['ipadretinaicondesc'] = 'Ikoon behoort \'n PNG-dokument te wees wat 144 px by 144 px groot is.';
$string['iphoneicon'] = 'iPhone/iPod Touch-ikoon (nie-retina)';
$string['iphoneicondesc'] = 'Ikoon behoort \'n PNG-dokument te wees wat 57 px by 57 px groot is.';
$string['iphoneretinaicon'] = 'iPhone/iPod Touch-ikoon (retina)';
$string['iphoneretinaicondesc'] = 'Ikoon behoort \'n PNG-dokument te wees wat 114 px by 114 px groot is.';
$string['layout'] = 'Gebruik \'n standaard kursusuitleg';
$string['layoutdesc'] = 'Hierdie tema is ontwerp om blokkolomme aan die kant te sit. As jy die standaard Moodle-kursusuitleg verkies, kan jy hierdie boks merk en terugkeer na die ou drie-kolom uitleg.';
$string['left'] = 'Links';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'Voer die URL van jou LinkedIn-profiel in (d.w.s. https://www.linkedin.com/company/mycollege)';
$string['linkedinurl'] = 'LinkedIn-URL';
$string['loadtime'] = 'Laaityd';
$string['loggedinas'] = 'ingeteken as';
$string['loggedinfrom'] = 'Ingeteken vanaf';
$string['loggedinfrommi'] = 'Ingeteken vanaf';
$string['loggedinfrommidesc'] = 'Vertoon die ingeteken vanaf-kieslys as die gebruiker \'n MNET-afstandsgebruiker is.';
$string['loginbackground'] = 'Inteken-agtergrondprent';
$string['loginbackgrounddesc'] = 'Laai jou eie inteken-agtergrondprent op. Kies die styl van die prent hieronder.';
$string['loginbackgroundopacity'] = 'Agtergronddeursigtigheid van intekenboks wanneer daar \'n agtergrondprent is';
$string['loginbackgroundopacitydesc'] = 'Agtergronddeursigtigheid van intekenboks wanneer daar \'n agtergrondprent is.';
$string['loginbackgroundstyle'] = 'Agtergrondstyl van inteken';
$string['loginbackgroundstyledesc'] = 'Kies die styl van die opgelaaide prent.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Laai asseblief jou doelgemaakte logo hier op as jy dit by die hofie wil voeg.<br>Die prent sal verskaal word om in die beskikbare persentasiegrootte, wat hieronder vir die toestel gespesifiseer is, te pas. Dit bied \'n responsiewe oplossing. As jy baie sosiale/toep-ikone het, maak dubbeld seker van die resultaat.<br>As jy \'n logo oplaai, sal dit die standaard ikoon en naam vervang wat by verstek vertoon is.';
$string['logodesktopwidth'] = 'Werkskerm-breedte van logo';
$string['logodesktopwidthdesc'] = 'Die breedte van die logoprenthouer op \'n werkskerm, > = 980 px.<br>Stel asseblief as persentasie van die beskikbare spasie tussen {$a->lower} en {$a->upper}.<br>Die beskikbare spasie is die breedte wat deur die \'bladsybreedte\'-verstelling toegelaat word. Die prent sal die gestelde persentasie tot met die resolusiebreedte volmaak.<br>Let wel: Die minimum hoogte van die houer is 64 beeldelemente, dus sal daar \'n gaping onder wees as die berekening van die prenthoogte minder is.';
$string['logodimerror'] = 'is ongeldig. Stel asseblief \'px\' of \'em\' direk ná die eenheidwaarde en niks voor die eenheidwaarde nie.';
$string['logomobilewidth'] = 'Mobiele breedte van logo';
$string['logomobilewidthdesc'] = 'Die breedte van die logoprenthouer op \'n mobiele toestel, < 980 px.<br>Stel asseblief as \'n persentasie van die beskikbare spasie tussen {$a->lower} en {$a->upper}.<br>Die beskikbare spasie is die breedte wat deur die \'bladsybreedte\'-verstelling toegelaat word. Die prent sal die gestelde persentasie tot met die resolusiebreedte volmaak.<br>Let wel: Die minimum hoogte van die houer is 52 beeldelemente, dus sal daar \'n gaping onder wees as die berekening van die prenthoogte minder is.';
$string['marketing1'] = 'Bemarkingsplek een';
$string['marketing2'] = 'Bemarkingsplek twee';
$string['marketing3'] = 'Bemarkingsplek drie';
$string['marketingbuttontext'] = 'Skakelteks';
$string['marketingbuttontextdesc'] = 'Teks wat op die knoppie moet verskyn.';
$string['marketingbuttonurl'] = 'Skakel-URL';
$string['marketingbuttonurldesc'] = 'URL waarheen die knoppie sal wys.';
$string['marketingcontent'] = 'Inhoud';
$string['marketingcontentdesc'] = 'Inhoud om in die bemarkingsboks te vertoon. Hou dit kort en kragtig.';
$string['marketingdesc'] = 'Hierdie tema bied die opsie om drie "bemarking"- of "advertensie"-plekke net onder die skyfievertoning te ontsper. Dit sal jou toelaat om kerninligting aan jou gebruikers maklik te identifiseer en direkte skakels te verskaf.';
$string['marketingheading'] = 'Bemarkingsplekke';
$string['marketingheadingsub'] = 'Drie plekke op die voorblad om inligting en skakels by te voeg.';
$string['marketingheight'] = 'Hoogte van bemarkingsplekhouer (px)';
$string['marketingheightdesc'] = 'Spesifiseer die hoogte van die bemarkingsplekhouer in beeldelemente. Pas dit aan om by jou inhoud te pas. As enige plek \'n prent of skakel bevat, sal dit vir alle plekke hierby gevoeg word.';
$string['marketingicon'] = 'Ikoon';
$string['marketingicondesc'] = 'Naam van die ikoon wat jy wil gebruik. Die lys is <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voer net in wat ná die "fa-"staan, bv. "star".';
$string['marketingimage'] = 'Prent';
$string['marketingimagedesc'] = 'Dit bied die opsie om \'n prent bokant die teks in die bemarkingsplek te vertoon.';
$string['marketingimageheight'] = 'Hoogte van bemarkingsprente (px)';
$string['marketingimageheightdesc'] = 'As jy prente in die bemarkingsbokse wil vertoon, kan jy hul hoogte in beeldelemente hier invoer.';
$string['marketinginfodesc'] = 'Voer die verstellings van jou bemarkingsplek in.';
$string['marketingtitle'] = 'Titel';
$string['marketingtitledesc'] = 'Titel om in hierdie bemarkingsplek te vertoon';
$string['marketingurltarget'] = 'Skakelteiken';
$string['marketingurltargetdesc'] = 'Kies hoe die skakel oopgemaak moet word';
$string['marketingurltargetnew'] = 'Nuwe bladsy';
$string['marketingurltargetparent'] = 'Moederraam';
$string['marketingurltargetself'] = 'Huidige bladsy';
$string['memused'] = 'Geheue Gebruik';
$string['messagesmi'] = 'Boodskappe';
$string['messagesmidesc'] = 'Vertoon die boodskappe-kieslysitem as boodskapdiens ontsper is.';
$string['mobileappsdesc'] = 'Het jy \'n webtoepassing in die App Store of Google Play Store? Verskaf \'n skakel hier, sodat jou gebruikers die toepassings aanlyn kan kry.';
$string['mobileappsheading'] = 'Toepassings';
$string['mobileappsheadingsub'] = 'Skakel na jou toep om jou studente met mobiele toestelle te bereik';
$string['modulesettingstitle'] = 'Moduleverstellings';
$string['myclasses'] = 'My klasse';
$string['mycourses'] = 'My kursusse';
$string['mycoursescatsubmenu'] = 'Kategorie en kursus subkieslys';
$string['mycoursescatsubmenudesc'] = 'Organiseer kursusse in \'n subkieslys, gebaseer op die topvlak-kategorie waarin dit is. Wanneer \'ontsperkategorieikoon\' \'onwaar\' is, sal die kategorie-ikoon wat gebruik word, die temaverstek wees, wanneer \'waar\' sal dit óf die waarde van \'verstekkategorieikoon\' óf die kategorie self as \'ontsperdoelgemaaktekategorieikoon\' waar is. Die \'mykursussemaks.\'-verstelling sal steeds van toepassing wees, maar op \'n per-kategorie vlak.';
$string['mycoursesinfo'] = 'Kursusse-kieslys';
$string['mycoursesinfodesc'] = 'Vertoon \'n dinamiese lys van ingeskrewe kursusse aan die gebruiker.';
$string['mycoursesmax'] = 'Maks. kursusse';
$string['mycoursesmaxdesc'] = 'Stel tot hoeveel kursusse tussen {$a->lower} en {$a->upper} gelys moet word, waar \'{$a->lower}\' alle voorstel.';
$string['mycoursesorder'] = 'Volgorde van kursusse';
$string['mycoursesorderdesc'] = 'Stel hoe kursusse gesorteer moet word. Die sorteringsvolgorde van die kursus kan gestel word deur die kernnavigasieverstelling \'navsortmycoursessort\'.';
$string['mycoursesorderenrolbackcolour'] = 'Agtergrondkleur van ingeskrewe en nie-ingegaande kursus';
$string['mycoursesorderenrolbackcolourdesc'] = 'Die agtergrondkleur vir ingeskrewe maar nie-ingegaande kursusse. Vir wanneer \'mykursusvolgorde\' op \'Laaste toegang verkry ...\' gestel is.';
$string['mycoursesorderid'] = 'Kursus-ID';
$string['mycoursesorderidasc'] = 'Stygend';
$string['mycoursesorderiddes'] = 'Dalend';
$string['mycoursesorderidorder'] = 'Volgorde van Kursus-ID';
$string['mycoursesorderidorderdesc'] = 'Volgorde van Kursus-ID vir wanneer \'Kursus-ID\' gestel is as die \'Kursus-sorteringsvolgorde\'.';
$string['mycoursesorderlast'] = 'Tyd wat laaste toegang verkry is, of aanvangstyd van inskrywing indien daar nooit toegang verkry is nie';
$string['mycoursesordersort'] = 'Kursus-sorteringsvolgorde';
$string['mycoursetitle'] = 'Terminologie';
$string['mycoursetitledesc'] = 'Verander die terminologie vir die "My kursusse"-kieslystitel. Wanneer \'mykursusvolgorde\' gestel is op \'Laaste toegang verkry ...\' sal die woord \'nuutste\' bygevoeg word.';
$string['mygrades'] = 'My punte';
$string['mygradesmi'] = 'My punte';
$string['mygradesmidesc'] = 'Vertoon die my punte-kieslysitem as die gebruiker die \'punteverslag/oorsig:besigtig\' vermoë in \'n kursus het. Word nie op werfvlak nagegaan nie.';
$string['mylatestclasses'] = 'My nuutste klasse';
$string['mylatestcourses'] = 'My nuutste kursusse';
$string['mylatestmodules'] = 'My nuutste modules';
$string['mylatestunits'] = 'My nuutste eenhede';
$string['mymodules'] = 'My modules';
$string['myunits'] = 'My eenhede';
$string['navbarabove'] = 'Navstafie bo die hofie';
$string['navbarbelow'] = 'Navstafie onder die hofie';
$string['navbartitle'] = 'Navigasiestafietitel';
$string['navbartitledesc'] = 'Konfigureer hier watter titel in die navigasiestafie geplaas moet word.';
$string['nextsection'] = 'Volgende afdeling';
$string['nobreadcrumb'] = 'Versteek';
$string['noenrolments'] = 'Jy het geen huidige inskrywings nie';
$string['noslidetitle'] = 'Geen titel vir skyfie {$a->slide} nie';
$string['notitle'] = 'Geen Titel';
$string['numberofcoursesandsubcatcourses'] = 'Aantal kursusse - subkategoriekursusse';
$string['numberofslides'] = 'Aantal skyfies';
$string['numberofslides_desc'] = 'Aantal skyfies op die glyer.';
$string['oldnavbar'] = 'Gebruik die ou navstafieposisie';
$string['oldnavbardesc'] = 'Ontsper hierdie opsie om die ou navstafieposisie te gebruik, wat dit onder die hofie plaas.';
$string['pagebackground'] = 'Agtergrondprent van bladsy';
$string['pagebackgrounddesc'] = 'Laai jou eie agtergrondprent op. Kies die styl van die prent hieronder.';
$string['pagebackgroundstyle'] = 'Agtergrondstyl van bladsy';
$string['pagebackgroundstyledesc'] = 'Kies die styl van die opgelaaide prent.';
$string['pagebottomblocksperrow'] = 'Bladsy-onderkantblokke per ry';
$string['pagebottomblocksperrowdesc'] = 'Stel hoeveel blokke per ry tussen {$a->lower} en {$a->upper} vir bladsye met \'Bladsy-onderkantblokke\'. Huidige bladsye is: Admin, Kursusbestuur, Gradering en Vasvrawysiging.';
$string['pagetopblocks'] = 'Ontsper bykomende bladsy \'Bladsy-bokant\'-blokke';
$string['pagetopblocksdesc'] = 'Indien ontsper, sal dit \'n bykomende blokplek langs die kantblokke en bokant die inhoudarea vertoon op alle bladsye behalwe die \'Voorblad\', wat sy eie verstelling het. Let wel: Die aantal blokke per ry hang af van die verstelling \'bladsybokantblokkeperry\'.';
$string['pagetopblocksperrow'] = 'Bladsybokantblokke per ry';
$string['pagetopblocksperrowdesc'] = 'Stel hoeveel blokke per ry tussen {$a->lower} en {$a->upper} vir bladsye met \'Bladsybokantblokke\'. Huidige bladsye is: Kursus, Kursuskategorie, Paneelbord, My Publiek en Druk.';
$string['pagewidth'] = 'Stel bladsybreedte';
$string['pagewidthdesc'] = 'Kies uit die lys beskikbare bladsybreedtes vir jou werf.';
$string['participantsmenu'] = 'Deelnemerskieslys';
$string['participantsmenudesc'] = 'Vertoon die deelnemerskieslys in die kursus- en modulebladsye.';
$string['paypal_click'] = 'Moodle-profiel';
$string['paypal_desc'] = '{$a->url}\' vir besonderhede, aangesien ek \'n individu is en dus nie \'koop my nou\'-knoppies kragtens hul bepalings kan hê nie, of';
$string['peakmem'] = 'Piekgeheue';
$string['perf_max'] = 'Gedetailleerd';
$string['perf_min'] = 'Minimaal';
$string['perfinfo'] = 'Prestasie-inligtingsmodus';
$string['perfinfodesc'] = 'Baie werwe benodig nie die volledig gedetailleerde prestasie-inligting nie, veral wanneer dit deur gebruikers besigtig word. Wanneer ontsper, vertoon dit \'n opgeruimde, minimale vorm met basiese bladsyladingsinligting.';
$string['perfinfoheading'] = 'Prestasie-inligting';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = 'Voer die URL van jou Pinterest-blad in (d.w.s. http://pinterest.com/mycollege/mypinboard)';
$string['pinteresturl'] = 'Pinterest-URL';
$string['pluginname'] = 'Essential';
$string['preferencesmi'] = 'Voorkeure';
$string['preferencesmidesc'] = 'Vertoon die Voorkeure-kieslysitem';
$string['previoussection'] = 'Vorige afdeling';
$string['privacy:metadata:preference:courseitemsearchtype'] = 'Die gebruiker se keuse van kursussoektog (\'volle naam van kursus\' - \'0\' of alle kursusinhoud - \'1\') indien ooit geberg wanneer \'kursusinhoudsoektog\' gemerk is. As niks gestel is nie, is die kursussoektog óf af, of die gebruiker het nooit die paneelbord besigtig toe dit aan was nie.';
$string['privacy:request:preference:courseitemsearchtype'] = 'Die gebruiker het "{$a->value}" gekies vir die kursussoektog-gebruikersvoorkeur "{$a->name}" waar \'0\' die \'slegs volle naam van kursus\' is en \'1\' \'alle kursusinhoud\' is.';
$string['privatefilesmi'] = 'Private dokumente';
$string['privatefilesmidesc'] = 'Vertoon die private dokumente-kieslysitem as die gebruiker die \'moodle/gebruiker:bestuureiedokumente\' vermoë het.';
$string['profilebarcustomtitle'] = 'Profielstafie doelgemaakte bloktitel';
$string['profilebarcustomtitledesc'] = 'Titel van doelgemaakte profielstafieblok.';
$string['profilelinkmi'] = 'Profielskakel';
$string['profilelinkmidesc'] = 'Vertoon die profielskakel-kieslysitem.';
$string['properties'] = 'Eienskappe';
$string['propertiesdesc'] = 'Lys van eienskappe.';
$string['propertiesexport'] = 'Voer eienskappe as JSON-string uit';
$string['propertiesproperty'] = 'Eienskap';
$string['propertiesreturn'] = 'Keer terug';
$string['propertiessub'] = 'Die eienskappe';
$string['propertiesvalue'] = 'Waarde';
$string['putpropertiesadded'] = 'Bygevoeg:';
$string['putpropertieschanged'] = 'Verander:';
$string['putpropertiesdesc'] = 'Plak die JSON-string en \'Berg veranderinge\'. Waarskuwing! Dit valideer nie verstellingswaardes nie en voer \'n \'Skrap alle kasgeheue\' uit.';
$string['putpropertiesfrom'] = 'van';
$string['putpropertiesignorecti'] = 'Alle kursustitelprent-verstellings word geïgnoreer.';
$string['putpropertiesignored'] = 'Geïgnoreer:';
$string['putpropertiesname'] = 'Stel eienskappe - Eksperimenteel!';
$string['putpropertiesreportfiles'] = 'Onthou om die volgende dokumente na hul verstellings op te laai:';
$string['putpropertiessettingsreport'] = 'Verstellingsverslag:';
$string['putpropertiesunchanged'] = 'Onveranderd:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Ons';
$string['putpropertyproperties'] = 'Eienskappe';
$string['putpropertyreport'] = 'Verslag:';
$string['putpropertyversion'] = 'weergawe:';
$string['readme_click'] = 'kliek hier vir die LEESMY.md';
$string['readme_desc'] = '{$a->url} dokument, asseblief, wat meer inligting aangaande die Essential-tema bevat, wat doelmaak insluit.';
$string['readme_title'] = 'Essential leesmy';
$string['readmore'] = 'Lees meer';
$string['region-footer-left'] = 'Onderskrif (Links)';
$string['region-footer-middle'] = 'Onderskrif (Middel)';
$string['region-footer-right'] = 'Onderskrif (Regs)';
$string['region-header'] = 'Hofie';
$string['region-hidden-dock'] = 'Vir gebruikers versteek';
$string['region-home'] = 'Tuis';
$string['region-page-top'] = 'Bladsy bo';
$string['region-side-post'] = 'Regs';
$string['region-side-pre'] = 'Links';
$string['returntosection'] = 'Keer terug na: {$a->section}';
$string['returntosectionfeature'] = 'Keer terug na afdeling';
$string['returntosectionfeaturedesc'] = 'Ontsper keer terug na afdeling-funksie binne kursusmodules.';
$string['returntosectiontextlimitfeature'] = 'Keer terug na afdeling-naamtekslimiet';
$string['returntosectiontextlimitfeaturedesc'] = 'Lengtebeperking vir die \'naam\' van die afdeling op die knoppie tussen {$a->lower} en {$a->upper} karakters.';
$string['right'] = 'Regs';
$string['searchallcoursecontent'] = 'Deursoek alle kursusinhoud';
$string['searchallcoursecontentdefault'] = 'Verstek deursoek alle kursusinhoud';
$string['searchallcoursecontentdefaultdesc'] = 'Stel die waarde van die \'Deursoek alle kursusinhoud\'-merkboks op die kursusinhoudsoektog. As \'Deursoek alle kursusinhoud\' nie gemerk is nie, sal slegs die volle naam van kursus vir ooreenstemming deursoek word.';
$string['searchallcoursecontentenable'] = 'Ontsper deursoek alle kursusinhoud';
$string['searchallcoursecontentenabledesc'] = 'Laat gebruiker toe om te besluit of hulle deur alle kursusinhoud wil soek. Indien versper, sal die waarde van \'verstekdeursoekallekursusinhoud\' op die kursussoektog toegepas word.';
$string['serverload'] = 'Bedienerlading';
$string['sessionsize'] = 'Grootte van sessie';
$string['shortname'] = 'Kortnaam van werf';
$string['shortnamesummary'] = 'Kortnaam en opsomming';
$string['siteicon'] = 'Werfikoon';
$string['siteicondesc'] = 'Het jy nie \'n ikoon nie? Voer die naam in van die ikoon wat jy wil gebruik. Die lys is <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voer net in wat ná die "fa-" is.';
$string['skype'] = 'Skype-rekening';
$string['skypedesc'] = 'Voer die Skype-gebruikersnaam-URL van jou instelling se Skype-rekening in (d.w.s. skype://my.college)';
$string['skypeuri'] = 'Skype-rekening-URL';
$string['slidebuttoncolor'] = 'Kleur van skyfieknoppie';
$string['slidebuttoncolordesc'] = 'Watter kleur die skyfie se navigasieknoppie moet wees.';
$string['slidebuttonhovercolor'] = 'Kleur van skyfieknoppiesweef';
$string['slidebuttonhovercolordesc'] = 'Watter kleur die skyfie se navigasieknoppiesweef moet wees.';
$string['slidecaption'] = 'Skyfie-opskrif';
$string['slidecaptionbackgroundcolor'] = 'Agtergrondkleur van skyfie-opskrif';
$string['slidecaptionbackgroundcolordesc'] = 'Watter kleur die agtergrond van die skyfie-opskrif moet wees. Nie van toepassing op \'Langs\' skyfie-opskrifopsie nie.';
$string['slidecaptionbelow'] = 'Skyfie-opskrif onder prent';
$string['slidecaptionbelowdesc'] = 'Of die skyfie-opskrif onder die prent moet wees.';
$string['slidecaptionbeside'] = 'Langs';
$string['slidecaptioncentred'] = 'Skyfie-opskrif gesentreer';
$string['slidecaptioncentreddesc'] = 'Of die skyfie-opskrif gesentreer moet wees.';
$string['slidecaptiondesc'] = 'Voer die opskrifteks om vir die skyfie te gebruik, in';
$string['slidecaptionontop'] = 'Bo-op';
$string['slidecaptionoptions'] = 'Skyfie-opskrifopsies';
$string['slidecaptionoptionsdesc'] = 'Waar die opskrifte m.b.t. die prent moet verskyn.';
$string['slidecaptiontextcolor'] = 'Tekskleur van skyfie-opskrif';
$string['slidecaptiontextcolordesc'] = 'Watter kleur die teks van die skyfie-opskrif moet wees. Nie van toepassing op \'Langs\' skyfie-opskrifopsie nie.';
$string['slidecaptionunderneath'] = 'Onder';
$string['slidecolor'] = 'Kleur van skyfieteks';
$string['slidecolordesc'] = 'Watter kleur die skyfie-opskrifteks moet wees.';
$string['slideimage'] = 'Skyfieprent';
$string['slideimagedesc'] = 'Prent werk die beste as dit deursigtig is.';
$string['slideinterval'] = 'Skyfie-interval';
$string['slideintervaldesc'] = 'Skyfie-oorganginterval in millisekondes.';
$string['slideno'] = 'Skyfie {$a->slide}';
$string['slidenodesc'] = 'Voer die verstellings in vir skyfie {$a->slide}.';
$string['slideshowdesc'] = 'Dit skep vir jou \'n dinamiese skyfievertoning van tot sestien skyfies om belangrike elemente van jou werf te promoveer. Die vertoning is responsief, waar prenthoogte volgens skermgrootte gestel word. Die aanbevole hoogte is 300 px. Die breedte word op 100% gestel en dus sal die werklike hoogte minder wees as die breedte meer as die skermgrootte is. Op kleiner skerms word die hoogte dinamies verminder, sonder dat aparte prente verskaf moet word. Vir verwysing: skermbreedte < 767 px = hoogte 165 px, breedte tussen 768 px en 979 px = hoogte 225 px, en breedte > 980 px = hoogte 300 px. As geen prent vir \'n skyfie gekies word nie, sal die verstek skyfieprent in die pix-lêer gebruik word.';
$string['slideshowheading'] = 'Skyfievertoning';
$string['slideshowheadingsub'] = 'Dinamiese skyfievertoning vir die voorblad';
$string['slidetitle'] = 'Skyfietitel';
$string['slidetitledesc'] = 'Voer \'n beskrywende titel vir jou skyfie in.';
$string['slideurl'] = 'Skyfieskakel';
$string['slideurldesc'] = 'Voer die teikenbestemming van die skyfie se prentskakel in';
$string['slideurltarget'] = 'Skakelteiken';
$string['slideurltargetdesc'] = 'Kies hoe die skakel oopgemaak moet word';
$string['slideurltargetnew'] = 'Nuwe bladsy';
$string['slideurltargetparent'] = 'Moederraam';
$string['slideurltargetself'] = 'Huidige bladsy';
$string['socialdesc'] = 'Bied direkte skakels na die sosiale netwerke wat jou handelsnaam sal bevorder. Hierdie sal in die hofie van elke bladsy verskyn.';
$string['socialheading'] = 'Sosiale netwerkwerk';
$string['socialheadingsub'] = 'Voer gesprek met jou gebruikers d.m.v. sosiale netwerkwerk';
$string['socialnetworks'] = 'Sosiale Netwerke';
$string['sponsor_desc'] = 'Borg asseblief via PayPal deur my te kontak deur \'';
$string['sponsor_desc2'] = 'om die Essential-ontwikkeling te laat voortgaan, of sommer net om jou dankbaarheid te betoon.';
$string['sponsor_title'] = 'Borg Essential';
$string['stylecover'] = 'Bedek';
$string['stylefixed'] = 'Vasgestel';
$string['styleguide'] = 'Stylriglyn';
$string['styleguidedesc'] = 'Oorspronklike dokumentasiekode \'{$a->origcodelicenseurl}\' gelisensieer. Holder.js is \'{$a->holderlicenseurl}\' gelisensieer. Addisionele kode \'{$a->thiscodelicenseurl}\' gelisensieer, wat \'n \'{$a->compatible}\' lisensie is. Inhoud \'{$a->contentlicenseurl}\' gelisensieer. Die dokumentasie is vir Moodle-afvoer geformatteer, met byvoeging van geskikte FontAwesome-ikone. Bykomende CSS kan in die dokument \'essential_admin_setting_styleguide.php\' onder die kommentaar \'// Beyond docs.css.\' gevind word. Die \'{$a->globalsettings}\' afdeling is verwyder.';
$string['styleguidesub'] = 'Bootstrap W2.3.2 Stylriglyn';
$string['stylestretch'] = 'Gestrek';
$string['styletiled'] = 'Teëls';
$string['switchrolemi'] = 'Verander van rol';
$string['switchrolemidesc'] = 'Vertoon die Verander van rol-kieslysitem as die gebruiker van rolle kan verander.';
$string['tallyinoftotal'] = '{$a->rtally} in {$a->ctally} van {$a->ctotal}';
$string['tallyoftotal'] = '{$a->tally} van {$a->total}';
$string['themecolor'] = 'Temakleur';
$string['themecolordesc'] = 'Wat die kleur van jou tema moet wees. Dit sal etlike komponente verander om die kleur van jou keuse regoor die Moodle-werf te produseer';
$string['themecolors'] = 'Temakleure';
$string['themedefaultbuttonbackgroundcolour'] = 'Verstek knoppieagtergrondkleur';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'Stel die agtergrondkleur van alle verstek knoppies.';
$string['themedefaultbuttonbackgroundhovercolour'] = 'Verstek knoppieagtergrondsweefkleur';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'Stel die agtergrondsweefkleur van alle verstek knoppies.';
$string['themedefaultbuttontextcolour'] = 'Verstek knoppietekskleur';
$string['themedefaultbuttontextcolourdesc'] = 'Stel die tekskleur van alle verstek knoppies.';
$string['themedefaultbuttontexthovercolour'] = 'Verstek knoppietekssweefkleur';
$string['themedefaultbuttontexthovercolourdesc'] = 'Stel die tekssweefkleur van alle verstek knoppies.';
$string['themehovercolor'] = 'Temasweefkleur';
$string['themehovercolordesc'] = 'Die kleur van jou temaswewe. Dit word vir skakels, kieslyste, ens. gebruik.';
$string['themeiconcolor'] = 'Ikoonkleur';
$string['themeiconcolordesc'] = 'Stel die kleur van alle ikone.';
$string['themenavcolor'] = 'Navigasietekskleur';
$string['themenavcolordesc'] = 'Stel die tekskleur vir navigasie. D.w.s. die navigasiestafie en die breadcrumb spoggerig-styl.';
$string['themequizsubmitbackgroundcolour'] = 'Vasvra \'Dien alles in en voltooi\' agtergrondkleur';
$string['themequizsubmitbackgroundcolourdesc'] = 'Stel die agtergrondkleur van die Vasvra \'Dien alles in en voltooi\'-knoppie.';
$string['themequizsubmitbackgroundhovercolour'] = 'Vasvra \'Dien alles in en voltooi\' agtergrondsweefkleur';
$string['themequizsubmitbackgroundhovercolourdesc'] = 'Stel die agtergrondsweefkleur van die Vasvra \'Dien alles in en voltooi\'-knoppie.';
$string['themequizsubmittextcolour'] = 'Vasvra \'Dien alles in en voltooi\' tekskleur';
$string['themequizsubmittextcolourdesc'] = 'Stel die tekskleur van die Vasvra \'Dien alles in en voltooi\'-knoppie.';
$string['themequizsubmittexthovercolour'] = 'Vasvra \'Dien alles in en voltooi\' tekssweefkleur';
$string['themequizsubmittexthovercolourdesc'] = 'Stel die tekssweefkleur van die Vasvra \'Dien alles in en voltooi\'-knoppie.';
$string['themesidepreblockbackgroundcolour'] = '\'side-pre\'-blok agtergrondkleur';
$string['themesidepreblockbackgroundcolourdesc'] = 'Stel die agtergrondkleur van die \'side-pre\'-blok.';
$string['themesidepreblockhovercolour'] = '\'side-pre\'-skakelsweef agtergrondkleur';
$string['themesidepreblockhovercolourdesc'] = 'Stel die skakelsweefkleur van die \'side-pre\'-blok.';
$string['themesidepreblocktextcolour'] = '\'side-pre\'-blok tekskleur';
$string['themesidepreblocktextcolourdesc'] = 'Stel die tekskleur van die \'side-pre\'-blok.';
$string['themesidepreblockurlcolour'] = '\'side-pre\'-blok skakelkleur';
$string['themesidepreblockurlcolourdesc'] = 'Stel die skakelkleur van die \'side-pre\'-blok.';
$string['themestripebackgroundcolour'] = 'Agtergrondkleur van streep';
$string['themestripebackgroundcolourdesc'] = 'Stel die agtergrondkleur van strepe in tabelle.';
$string['themestripetextcolour'] = 'Streeptekskleur';
$string['themestripetextcolourdesc'] = 'Stel die tekskleur van strepe in tabelle.';
$string['themestripeurlcolour'] = 'Streep-URL-kleur';
$string['themestripeurlcolourdesc'] = 'Stel die URL-kleur van strepe in tabelle.';
$string['themetextcolor'] = 'Tekskleur';
$string['themetextcolordesc'] = 'Stel die kleur van jou teks.';
$string['themeurlcolor'] = 'Skakelkleur';
$string['themeurlcolordesc'] = 'Stel die kleur van jou geskakelde teks.';
$string['thiscourse'] = 'Hierdie kursus';
$string['togglemarketing'] = 'Tokkel vertoon van bemarkingsplek';
$string['togglemarketingdesc'] = 'Kies of jy die drie bemarkingsplekke wil versteek of vertoon.';
$string['toggleslideshow'] = 'Tokkel vertoon van skyfievertoning';
$string['toggleslideshowdesc'] = 'Kies of jy die skyfievertoning wil versteek of vertoon.';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'Voer die URL van jou Twitter-voer in (d.w.s. https://www.twitter.com/mycollege)';
$string['twitterurl'] = 'Twitter-URL';
$string['userimageborderradius'] = 'Gebruik prentrantradius';
$string['userimageborderradiusdesc'] = 'Spesifiseer die rantradius tussen {$a->lower} en {$a->upper} beeldelemente van die gebruikerprent regdeur die werf, behalwe die hofie, wat die verstelling \'gebruikerkieslysgebruikerprentrantradius\' gebruik.';
$string['usermenu'] = 'Gebruikerkieslys';
$string['usermenudesc'] = 'Die kieslys vir die gebruiker.';
$string['usermenuuserimageborderradius'] = 'Gebruikerkieslys-prentrantradius';
$string['usermenuuserimageborderradiusdesc'] = 'Spesifiseer die rantradius tussen {$a->lower} en {$a->upper} beeldelemente van die gebruikerprent op die gebruikerkieslys.';
$string['usersettingstitle'] = 'Gebruikerverstellings';
$string['usesiteicon'] = 'Gebruik werfikoon';
$string['usesiteicondesc'] = 'Gebruik die werfikoon as daar geen logo is nie.';
$string['variablewidth'] = 'Veranderlike breedte';
$string['versionalerttext1'] = 'Tema is nie vir Moodle-weergawe ontwerp nie.';
$string['versionalerttext2'] = 'Onverwagse probleme kan voorkom, verkry assbelief die korrekte temaweergawe vir jou Moodle-weergawe.';
$string['versionalerttitle'] = 'Weergawe waarskuwing:';
$string['visibleadminonly'] = 'Blokke wat na die area geskuif word, sal slegs deur admins gesien word';
$string['vk'] = 'VKontakte';
$string['vkdesc'] = 'Voer die URL van jou VKontakte-blad in (d.w.s. http://www.vk.com/mycollege)';
$string['vkurl'] = 'VKontakte-URL';
$string['website'] = 'Webwerf-URL';
$string['websitedesc'] = 'Voer die URL van jou eie webwerf in (d.w.s. http://about.me/gjbarnard)';
$string['websiteurl'] = 'Webwerf-URL';
$string['windows'] = 'Windows Desktop';
$string['windowsdesc'] = 'Verskaf \'n URL na jou mobiele Toep op die Windows Store. As jy nie een van jou eie het nie, oorweeg miskien om na die amptelike Moodle Mobiele toep te skakel. (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)';
$string['windowsurl'] = 'Windows Desktop-URL';
$string['winphone'] = 'Windows Mobile';
$string['winphonedesc'] = 'Verskaf \'n URL na jou mobiele Toep op die Google Play Store. As jy nie een van jou eie het nie, oorweeg miskien om na die amptelike Moodle Mobiele toep te skakel. (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)';
$string['winphoneurl'] = 'Windows Mobile-URL';
$string['within'] = 'Binne';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'Voer die URL van jou YouTube-kanaal in (d.w.s. https://www.youtube.com/user/mycollege)';
$string['youtubeurl'] = 'YouTube-URL';
