<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_ldap', language 'sl', version '5.0'.
 *
 * @package     enrol_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignrole'] = 'Določanje vloge \'{$a->role_shortname}\' uporabniku \'{$a->user_username}\' v predmetu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['assignrolefailed'] = 'Neuspešna dodelitev vloge \'{$a->role_shortname}\' uporabniku \'{$a->user_username}\' v predmetu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['autocreate'] = '<p>Predmeti se lahko samodejno ustvarijo, če obstajajo vpisi v predmet, ki še ne obstaja v Moodlu.</p><p>Če uporabljate avtomatsko ustvarjanje predmetov je priporočljivo, da odstranite sledeče zmožnosti: moodle/course:changeidnumber, moodle/course:changeshortname, moodle/course:changefullname and moodle/course:changesummary iz ustreznih vlog, da preprečite spreminjanje štirih, zgoraj naštetih polj (ID številka, kratko ime, polno ime in opis).</p>';
$string['autocreate_key'] = 'Samodejno ustvari';
$string['autocreation_settings'] = 'Nastavitve samodejnega ustvarjanja predmetov';
$string['autoupdate_settings'] = 'Nastavitve samodejne posodobitve predmeta';
$string['autoupdate_settings_desc'] = '<p>Izberite polja za posodobitev, ko je načrtovano opravilo za ‚Sinhronizacijo LDAP vpisov\' v teku.</p><p>Ko je izbrano najmanj eno polje, bo posodobitev izvršena.</p>';
$string['bind_dn'] = 'Če želite uporabiti povezovalnega uporabnika (bind-user) za iskanje uporabnikov, ga tu navedite. Nekaj kot \'cn=ldapuser,ou=public,o=org\'';
$string['bind_dn_key'] = 'Ime povezovalnega uporabnika (bind user)';
$string['bind_pw'] = 'Geslo za bind-user';
$string['bind_pw_key'] = 'Geslo';
$string['bind_settings'] = 'Nastavitve';
$string['cannotcreatecourse'] = 'Ne morem ustvariti predmeta: manjkajo potrebmi podatki iz LDAP zapisa!';
$string['cannotupdatecourse'] = 'Ne morem posodobiti predmeta: manjkajo podatki z LDAP zapisa! ID številka predmeta: \'{$a->idnumber}\'';
$string['cannotupdatecourse_duplicateshortname'] = 'Ne morem posodobiti predmeta: podvoji kratko ime. Preskoči predmet z ID številko \'{$a->idnumber}\'...';
$string['category'] = 'Kategorija za samodejno ustvarjene predmete';
$string['category_key'] = 'Kategorija';
$string['contexts'] = 'Konteksti LDAP';
$string['couldnotfinduser'] = 'Ni mogoče najti uporabnika \'{$a}\', preskočeno';
$string['course_fullname'] = 'Neobvezno: LDAP polje za pridobitev polnega imena';
$string['course_fullname_key'] = 'Polno ime';
$string['course_fullname_updateonsync'] = 'Posodobi polno ime med skripto za sinhronizacijo';
$string['course_fullname_updateonsync_key'] = 'Posodobi polno ime';
$string['course_idnumber'] = 'LDAP atribut, ki posreduje ID številko predmeta. Običajno \'cn\' ali \'uid\'.';
$string['course_idnumber_key'] = 'Številka ID';
$string['course_search_sub'] = 'Išči članstva v skupini od podvsebin';
$string['course_search_sub_key'] = 'Išči po podvsebinah';
$string['course_settings'] = 'Nastavitve vpisa predmeta';
$string['course_shortname'] = 'Neobvezno: LDAP polje za pridobitev kratkega imena';
$string['course_shortname_key'] = 'Kratko ime';
$string['course_shortname_updateonsync'] = 'Posodobi kratko ime med skripto za sinhronizacijo';
$string['course_shortname_updateonsync_key'] = 'Posodobi kratko ime';
$string['course_summary'] = 'Neobvezno: LDAP polje za pridobitev povzetka';
$string['course_summary_key'] = 'Povzetek';
$string['course_summary_updateonsync'] = 'Posodobi povzetek med sinhronizacijskim programom';
$string['course_summary_updateonsync_key'] = 'Posodobi povzetek';
$string['coursenotexistskip'] = 'Predmet \'{$a}" ne obstaja, samodejno ustvarjanje onemogočeno, preskakovanje';
$string['courseupdated'] = 'Predmet z ID številko \'{$a->idnumber}\' je bil uspešno posodobljen.';
$string['courseupdateskipped'] = 'Predmet z ID številko \'{$a->idnumber}\' ne potrebuje posodobitve. Preskakovanje ...';
$string['createcourseextid'] = 'USTVARI Uporabnik vpisan v neobstoječ predmet \'{$a->courseextid}\'';
$string['createnotcourseextid'] = 'Uporabnik vpisan v neobstoječ predmet \'{$a->courseextid}';
$string['creatingcourse'] = 'Ustvarjanje predmeta \'{$a}\'...';
$string['duplicateshortname'] = 'Ustvarjanje predmeta neuspešno. Podvoji kratko ime. Preskakovanje predmeta z ID številko \'{$a->idnumber}\'...';
$string['editlock'] = 'Zakleni vrednost';
$string['emptyenrolment'] = 'Prazna vloga vpisa \'{$a->role_shortname}\' v predmetu \'{$a->course_shortname}\'';
$string['enrolname'] = 'LDAP';
$string['enroluser'] = 'Vpiši uporabnika \'{$a->user_username}\' v predmet \'{$a->course_shortname}\' (id {$a->course_id})';
$string['enroluserenable'] = 'Omogočen vpis za uporabnika \'{$a->user_username}\' v predmet \'{$a->course_shortname}\' (id {$a->course_id})';
$string['explodegroupusertypenotsupported'] = 'ldap_explode_group() ne podpira označene vrste uporabnika: {$a}';
$string['extcourseidinvalid'] = 'Zunanji id predmeta ni pravilen!';
$string['extremovedsuspend'] = 'Onemogočen vpis za uporabnika \'{$a->user_username}\' v predmetu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedsuspendnoroles'] = 'Onemogočen vpis in odstranjene vloge za uporabnika \'{$a->user_username}\' v predmetu \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedunenrol'] = 'Izpiši uporabnika \'{$a->user_username}\' iz predmeta \'{$a->course_shortname}\' (id {$a->course_id})';
$string['failed'] = 'Ni uspelo!';
$string['general_options'] = 'Splošne možnosti';
$string['group_memberofattribute'] = 'Ime atributa ki določa kateri skupini pripada dan uporabnik ali skupina (npr., članOd, članstvo Skupine, itd.)';
$string['group_memberofattribute_key'] = '\'Član od\' atribut';
$string['host_url'] = 'Navedite ime LDAP gostitelja v URL obliki npr.: \'ldap://ldap.myorg.com/\' ali \'ldaps://ldap.myorg.com/\'';
$string['host_url_key'] = 'URL gostitelja';
$string['idnumber_attribute'] = 'Če članstvo v skupini vsebuje prepoznavna imena, določite iste atribute, kot ste jih uporabili za uporabnika \'ID Število\' preslikane v LDAP nastavitve pristnosti.';
$string['idnumber_attribute_key'] = 'Atribut ID številke';
$string['ignorehiddencourses'] = 'Ne upoštevaj skritih predmetov';
$string['ignorehiddencourses_desc'] = 'Če je omogočeno, uporabniki ne bodo vpisani v predmete, ki so nastavljeni, da niso na voljo za udeležence.';
$string['ldap:manage'] = 'Upravljaj vpisane primere LDAP';
$string['ldap_encoding'] = 'Določite kodiranje uporabljano v LDAP strežniku. Najverjetneje utf-8, MS AD v2 uporablja privzeto platformo kodiranja kot cp1252, cp1250, itd.';
$string['ldap_encoding_key'] = 'LDAP kodiranje';
$string['memberattribute'] = 'Atribut člana LDAP';
$string['memberattribute_isdn'] = 'Če članstvo v skupini vsebuje prepoznavna imena, jih morate tukaj določiti. Če jih določite, morate tudi nastaviti ostale nastavitve tega odseka.';
$string['memberattribute_isdn_key'] = 'Atribut člana uporablja dn';
$string['nested_groups'] = 'Želite za vpis uporabljati vgnezdene skupine (skupine skupin)?';
$string['nested_groups_key'] = 'Vgnezdene skupine';
$string['nested_groups_settings'] = 'Nastavitve vgnezdenih skupin';
$string['nosuchrole'] = 'Ni takšne vloge: \'{$a}\'';
$string['objectclass'] = 'objectClass uporabljen za iskanje predmetov. Običajno \'group\' ali \'posixGroup\'';
$string['objectclass_key'] = 'Predmet razreda';
$string['ok'] = 'OK!';
$string['opt_deref'] = 'Če članstvo v skupini vsebuje prepoznavna imena, določite kako rokovati z vzdevki med iskanjem. Izberite eno od naštetih vrednosti: \'Ne\' (LDAP_DEREF_NEVER) ali \'Da\' (LDAP_DEREF_ALWAYS).';
$string['opt_deref_key'] = 'Odpriporoči vzdevke';
$string['phpldap_noextension'] = '<em>Izgleda, da PHP LDAP modul ni prisoten. Zagotovite, da bo nameščen in omogčen, če želite uporabljati ta vtičnik za vpis.</em>';
$string['pluginname'] = 'LDAP vpisi';
$string['pluginname_desc'] = '<p>Za nadzor vaših vpisov ahko uporabite LDAP strežnik. Predvideno je, da drevo LDAP vsebuje skupine, ki se ujemajo s predmeti in vsaka izmed teh skupin oz. predmetov bo imela vnose članstva, ki se bodo ujemali z udeleženci.</p><p>Predvideno je, da so predmeti definirani kot skupine v LDAP-u, kjer ima vsaka skupina več polj za članstvo (<em>member</em> ali <em>memberUid</em>), ki vsebujejo enolično identifikacijo uporabnika.</p><p>Za uporabo LDAP vpisovanja, <strong>morajo</strong> vaši uporabniki imeti veljavno polje idnumber. Skupine LDAP morajo imeti isto idnumber oznako v poljih member, da je uporabnik vpisan v predmet. To bo običajno delovalo dobro, če že uporabljate LDAP overitev.</p><p>Vpisi v predmete bodo posodobljeni, ko se uporabnik prijavi. Lahko tudi zaženete skripto, za ohranjanje sinhroniziranih vpisov. Poglejte v <em>enrol/ldap/cli/sync.php</em>.</p><p>Ta vtičnik lahko nastavite za samodejno ustvarjanje novih predmetov, ko se nova skupina pojavi v LDAP-u.</p>';
$string['pluginnotenabled'] = 'Vtičnik ni omogočen!';
$string['privacy:metadata'] = 'Vtičnik za LDAP vpise ne shranjuje osebnih podatkov.';
$string['role_mapping'] = '<p>Za vsako vlogo iz LDAP, ki jo želite dodeliti, morate določiti seznam vsebin, kjer se nahajajo vloge skupin predmetov. Različne vsebine ločite z \';\'.</p><p>Določiti morate tudi atribute, ki jih uporablja vaš LDAP strežnik da drži uporabnike skupine. Ponavadi \'uporabnik\' ali \'uporabnikUid‘.</p>';
$string['role_mapping_attribute'] = 'Atribut člana LDAP za {$a}';
$string['role_mapping_context'] = 'Kontekst LDAP za {$a}';
$string['role_mapping_key'] = 'Mapiraj vloge iz LDAP';
$string['roles'] = 'Preslikovanje vlog';
$string['server_settings'] = 'Nastavitve strežnika LDAP';
$string['synccourserole'] = '== Sinhroniziraj predmet \'{$a->idnumber}\' za vlogo \'{$a->role_shortname}\'';
$string['syncenrolmentstask'] = 'Sinhroniziraj naloge za vpise LDAP';
$string['template'] = 'Neobvezno: samodejno ustvarjeni predmeti lahko kopirajo svoje nastavitve iz predloge predmeta';
$string['template_key'] = 'Predloga';
$string['unassignrole'] = 'Razveljavi dodelitev vloge \'{$a->role_shortname}\' uporabniku \'{$a->user_username}\' iz predmeta \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignrolefailed'] = 'Neuspešna razveljavitev vloge \'{$a->role_shortname}\' uporabniku \'{$a->user_username}\' iz predmeta \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignroleid'] = 'Razveljavljanje ID vloge \'{$a->role_id}\' ID uporabnika \'{$a->user_id}\'';
$string['updatelocal'] = 'Posodobi lokalne podatke';
$string['user_attribute'] = 'Če članstvo v skupini vsebuje prepoznavna imena, določite uporabljene atribute za ime/išči uporabnike. Če uporabljate LDAP preverjanje pristnosti, se mora ta vrednost ujemati z določenim atributom v \'ID Številki\' preslikani v LDAP avtentikavijski vtičnik.';
$string['user_attribute_key'] = 'Atribut ID številke';
$string['user_contexts'] = 'Če članstvo v skupini vsebuje prepoznavna imena, določite seznam vsebin kjer se nahajajo uporabniki. Različne vsebine ločite z \';\'. Na primer: \'ou=uporabniki,o=org; ou=ostali,o=org\'.';
$string['user_contexts_key'] = 'Konteksti';
$string['user_search_sub'] = 'Če članstvo v skupini vsebuje prepoznavna imena, določite, ali je iskanje uporabnikov izvedeno tudi v podvsebinah.';
$string['user_search_sub_key'] = 'Išči po podvsebinah';
$string['user_settings'] = 'Nastavitve poizvedb uporabnikov';
$string['user_type'] = 'Če članstvo v skupini vsebuje prepoznavna imena, določite kako so uporabniki shranjeni v LDAP';
$string['user_type_key'] = 'Vrsta uporabnika';
$string['version'] = 'Različica protokola LDAP, ki ga uporablja vaš strežnik';
$string['version_key'] = 'Različica';
