<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'treasurehunt', language 'sl', version '5.0'.
 *
 * @package     treasurehunt
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitytoend'] = 'Prej dokončaj izbrano dejavnost';
$string['activitytoend_help'] = 'Pred prikazom naslednje sledi mora biti izbrana dejavnost dokončana. Da se v seznamu prikažejo dejavnosti predmeta, se mora v nastavitvah Moodla, predmeta in same dejavnosti omogočiti dokončanje dejavnosti.';
$string['activitytoendovercome'] = 'Dejavnost \'<strong>{$a}</strong>\' premagana';
$string['activitytoendwarning'] = 'Pred reševanjem morate dokončati dejavnost';
$string['actnotavailableyet'] = 'Dejavnost še ni na voljo';
$string['add'] = 'Dodaj';
$string['addingroad'] = 'Dodajanje poti';
$string['addingstage'] = 'Dodajanje scene';
$string['addroad_tour'] = 'Dodaj eno ali več poti, katerim bodo učenci sledili';
$string['addsimplequestion'] = 'Dodaj preprosto vprašanje';
$string['addsimplequestion_help'] = 'Dodaj preprosto vprašanje pred prikazom sledi v tej sceni';
$string['addstage_tour'] = 'Vsaka pot mora imeti dve ali več scen. Vsaka scena poda sled za iskanje naslednje.';
$string['aerialmap'] = 'Zračno';
$string['aerialview'] = 'Zračni pogled';
$string['allowattemptsfromdate'] = 'Dovoli poskuse od';
$string['allowattemptsfromdate_help'] = 'Če je nastavitev omogočena, učenci ne bodo morali igrati pred določenim časom.';
$string['alwaysshowdescription'] = 'Vedno prikaži opis';
$string['alwaysshowdescription_help'] = 'Če je nastavitev onemogočena, se bo zgornje besedilo prikazalo šele po času, določenem z nastavitvijo "Dovoli poskuse od".';
$string['answerwarning'] = 'Prej morate odgovoriti na vprašanje';
$string['areyousure'] = 'Ali ste prepričani?';
$string['attempt'] = 'Poskus';
$string['attempthistory'] = 'Zgodovina poskusov';
$string['attemptsdeleted'] = 'Poskusi lova na zaklad izbrisani';
$string['autolocate_tour'] = 'Pokažite svojo <b>trenutno lokacijo</b>.<br>(podajte dovoljenje za uporabo lokacije, ko se le-to pojavi)';
$string['availability'] = 'Dostopnost';
$string['availableplayerstyles'] = 'Stili zaslona igre na voljo';
$string['back'] = 'Nazaj';
$string['backtocourse'] = 'Nazaj na predmet';
$string['baselayers'] = 'Osnovne plasti';
$string['basemaps'] = 'Osnovni zemljevidi';
$string['bigbutton_play_tour'] = 'To je vaš najboljši prijatelj.<br>S klikom vam pokaže <b>izzive</b> ali <b>namige</b>.';
$string['browsemode'] = 'Brskaj';
$string['cancel'] = 'Prekliči';
$string['changecamera'] = 'Spremeni pogled';
$string['changetogroupmode'] = 'Način igre se je spremenil na igro v skupinah';
$string['changetoindividualmode'] = 'Način igre se je spremenil na individualno igro';
$string['changetoplaywithmove'] = 'Način igre se je spremenil na dinamično igro';
$string['changetoplaywithoutmoving'] = 'Način igre se je spremenil na statično igro';
$string['cleartreasurehunt'] = 'Ponastavi Lov na zaklad';
$string['cleartreasurehunt_done'] = 'Dejavnost je bila ponastavljena. Vse uporabniške dejavnosti udeležencev so bile izbrisane.';
$string['cleartreasurehuntconfirm'] = 'Pozor! Vsa beležena dejavnost bo izbrisana, če nadaljujete s trenutnim dejanjem. To dejanje je ponavadi potrebno le v primeru, da želite spremeniti število poti ali stopenj, vendar je dejavnost blokirana, ker je uporabnik že pričel z igranjem.';
$string['clue'] = 'Sled';
$string['completionfinish'] = 'Zahtevaj za dokončanje poti';
$string['completionfinish_help'] = 'Dokončaj, ko uporabnik reši vse scene na poti.';
$string['configintro'] = 'Določite vrednosti, ki bodo privzeto nastavljene v obrazcu ob ustvarjanju novega lova na zaklad.';
$string['configmaximumgrade'] = 'Privzeta ocena, iz katere se raččuna ocena Lova na zaklad';
$string['confirm'] = 'Potrdi';
$string['confirmdeletestage'] = 'Scena je bila uspešno odstranjena';
$string['continue'] = 'Nadaljuj';
$string['correctanswer'] = 'Pravilni odgovor';
$string['customlayername'] = 'Naslov plasti';
$string['customlayername_help'] = 'Uporaba plasti po meri zahteva naslov plasti za prikaz uporabnikom ali na zemljevidu. Če je naslov prazen, je plast po meri onemogočena.';
$string['customlayertype'] = 'Tip plasti';
$string['customlayertype_help'] = 'Plast je lahko edina vidna plast v ozadju ali pa v ospredju nad osnovnimi zemljevidi.';
$string['customlayerwms'] = 'WMS storitev';
$string['customlayerwms_help'] = 'Uporabite plast zemljevida iz OGS WMS. (Primer: EUNIS gozdni ekosistemi se lahko nastavijo z: WMS: <code style="overflow-wrap: break-word;word-wrap: break-word;">http://bio.discomap.eea.europa.eu/arcgis/services/Ecosystem/Ecosystems/MapServer/WMSServer</code> PARAMETRI: <code>LAYERS=4</code>)';
$string['custommapbaselayer'] = 'Slika je prikazana kot DODATNA možnost ozadja zemljevida';
$string['custommapimageerror'] = 'Slike po meri ni mogoče naložiti. Preglejte možnosti dejavnosti.';
$string['custommapimagefile'] = 'Slika po meri za zemljevid';
$string['custommapimagefile_help'] = 'Naložite sliko z dovolj visoko ločljivostjo in izpolnite naslednja 4 polja s koordinatami';
$string['custommapmaxlat'] = 'Severna zemljepisna širina';
$string['custommapmaxlat_help'] = 'Sevena zemljepisna širina slike. Uporabite "." kot decimalno vejico. Manjše od 85 stopinj in večje od južne širine.';
$string['custommapmaxlon'] = 'Vzhodna zemljepisna višina';
$string['custommapmaxlon_help'] = 'Vzhodna zemljepisna višina slike. Uporabite "." kot decimalno vejico. Manjše od 180 stopinj in večje od zahodne višine.';
$string['custommapminlat'] = 'Južna zemljepisna širina';
$string['custommapminlat_help'] = 'Južna zemljepisna širina slike. Uporabite "." kot decimalno vejico. Večje od -85 stopinj in manjše od severne širine.';
$string['custommapminlon'] = 'Zahodna zemljepisna višina';
$string['custommapminlon_help'] = 'Zahodna zemljepisna višina slike. Uporabite "." kot decimalno vejico. Večje od -180 stopinj in manjše od vzhodne višine.';
$string['custommapnongeographic'] = 'Slika ni geografska';
$string['custommaponlybaselayer'] = 'Slika je prikazana kot EDINA možnost ozadja zemljevida';
$string['custommapoverlaylayer'] = 'Slika se izriše nad osnovnim zemljevidom';
$string['custommapping'] = 'Zemljevid po meri';
$string['customwmsparams'] = 'WMS parametri';
$string['customwmsparams_help'] = 'Ti parametri določijo izgled zemljevida. Oblika sledi smernicam: "LAYERS=background,streets&STYLES=blue,default". (Primer: EUNIS gozdni ekosistemi se lahko nastavijo z: WMS: <code style="overflow-wrap: break-word;word-wrap: break-word;">http://bio.discomap.eea.europa.eu/arcgis/services/Ecosystem/Ecosystems/MapServer/WMSServer</code> PARAMETRI: <code>LAYERS=4</code>)';
$string['cutoffdate'] = 'Dovoli poskuse do';
$string['cutoffdate_help'] = 'Če je nastavitev določena, se poskusi, mlajši od nastavljene vrednosti, ne bodo upoštevali.';
$string['cutoffdatefromdatevalidation'] = 'Nastavitev "Dovoli poskuse do" mora biti kasnejša od nastavitve "Dovoli poskuse od"';
$string['defaultplayerstyle'] = 'Privzeti stil zaslona med igro';
$string['discoveredlocation'] = 'Odkrita lokacija';
$string['donetutorial'] = 'Konec';
$string['drawmode'] = 'Neodločeno';
$string['editactivity_help'] = 'Navodila za ustvarjanje lovov na zaklade lahko najdete na <a href="http://juacas.github.io/moodle-mod_treasurehunt/create_activity.html"> tej strani.</a>';
$string['editend_tour'] = 'Uživajte ob ustvarjanju razburljivih iger za vaše učence!';
$string['editingroad'] = 'Urejanje poti';
$string['editingstage'] = 'Urejanje scene';
$string['editingtreasurehunt'] = 'Urejanje lova na zaklad';
$string['edition'] = 'Vrstica urejanja';
$string['edition_help'] = 'Za omogočanje gumbov v vrstici urejanja in ustvarjanja geometrijskih teles, mora biti izbrana željena scena.';
$string['editmode'] = 'Uredi';
$string['editroad'] = 'Uredi pot';
$string['editstage'] = 'Uredi sceno';
$string['edittreasurehunt'] = 'Spremeni poti in scene';
$string['errcorrectanswers'] = 'Izbrati morate pravilen odgovor';
$string['errcorrectsetanswerblank'] = 'Pravilen odgovor je nastavljen, vendar je polje z odgovorom prazno';
$string['erremptystage'] = 'Vse scene morajo imeti vsaj eno geometrično obliko, da je pot pravilna.';
$string['errnocorrectanswers'] = 'Pravilen mora biti samo en odgovor.';
$string['errnumeric'] = 'Vnesti morate veljavno decimalno število.';
$string['error'] = 'Napaka';
$string['errpenalizationexceed'] = 'Kazen ne mora biti večja od 100.';
$string['errpenalizationfall'] = 'Kazen ne mora biti manjša od 0.';
$string['errsendinganswer'] = 'Pot se je spremenila, med pošiljanjem odgovora, poskusite ponovno';
$string['errsendinglocation'] = 'Pot se je spremenila, med pošiljanjem lokacije, poskusite ponovno';
$string['errvalidroad'] = 'Da je pot veljavna, mora vsebovati vsaj dve sceni in vsaj eno geometrično obliko';
$string['eventattemptsubmitted'] = 'Poskus oddan';
$string['eventattemptsucceded'] = 'Scena opravljena';
$string['eventhuntsucceded'] = 'Lov na zaklad uspečno dokončan';
$string['eventplayerentered'] = 'Igralec pričel igro';
$string['eventroadcreated'] = 'Pot ustvarjena';
$string['eventroaddeleted'] = 'Pot izbrisana';
$string['eventroadupdated'] = 'Pot posodobljena';
$string['eventstagecreated'] = 'Scena ustvarjena';
$string['eventstagedeleted'] = 'Scena izbrisana';
$string['eventstageupdated'] = 'Scena posodobljena';
$string['exit'] = 'Nazaj na predmet';
$string['failedlocation'] = 'Spodletela lokacija';
$string['faillocation'] = 'Nepravilna lokacija';
$string['findplace'] = 'Najdi prostor';
$string['gamemode'] = 'Način igre';
$string['gamemodeinfo'] = 'Način igre: {$a}';
$string['gameupdatetime'] = 'Čas posodobitve igre';
$string['gameupdatetime_help'] = 'Časovni interval v sekundah med uporabnikovimi posodobitvami igre. Večji, kot je, manj poizvedb za posodobitve se bo poslalo, čas za možnost nove spremembe pa bo daljši. Mora biti večji od 0 sekund, privzeto se nastavi samodejno.';
$string['geolocation_needed'] = 'Za igranje te igre je potrebna geolokacija.
<p>Za aktivacijo geolokacije, v brskalniku kliknite Nastavitve->Nastavitve strani->Lokacija in odstranite to spletišče iz seznama onemogočenih strani.</p>
<p>Osvežite stran v brskalniku in potrdite "Da", ko vas brskalnik vpraša za dovoljenje za deljenje lokacije</p>
<p>Za uporabo GPS tehnologije, mora biti spletišče dosegljivo preko varnes HTTPS povezave, sicer bo na voljo le način igranja brez premikanja, kjer uporabniki namesto premikanja svojo lokacijo predstavljajo s klikanjem po zemljevidu.</p>
<p>Če vam težave ne uspe odpraviti, kontaktirajte skrbnika spletišča.</p>';
$string['geolocation_needed_title'] = 'Ta aplikacija potrebuje geolokacijo.';
$string['grade_explaination_fromabsolutetime'] = '{$a->rawscore}-{$a->penalization}%: Lov na zaklad ste končali v {$a->yourtime}. Najboljši čas je {$a->besttime}. Kazensko se odbije {$a->penalization}% zaradi {$a->nolocationsfailed} napačnih mest in {$a->noanswersfailed} napačnih odgovorov.';
$string['grade_explaination_fromposition'] = '{$a->rawscore}-{$a->penalization}%: Odkrili ste {$a->nosuccessfulstages} scen na mestu {$a->position}.  Kazensko se odbije {$a->penalization}% zaradi {$a->nolocationsfailed} napačnih mest in {$a->noanswersfailed} napačnih odgovorov.';
$string['grade_explaination_fromstages'] = '{$a->rawscore}-{$a->penalization}%: Odkrili ste {$a->nosuccessfulstages} scen od skupno {$a->nostages}.  Kazensko se odbije {$a->penalization}% zaradi {$a->nolocationsfailed} napačnih mest in {$a->noanswersfailed} napačnih odgovorov.';
$string['grade_explaination_fromtime'] = '{$a->rawscore}-{$a->penalization}%: Lov na zaklad ste končali v {$a->yourtime}. Najboljši čas je {$a->besttime}. Kazensko se odbije {$a->penalization}% zaradi {$a->nolocationsfailed} napačnih mest in {$a->noanswersfailed} napačnih odgovorov.';
$string['grade_explaination_temporary'] = 'Nedokončan lov na zaklad dobi 50% scen: {$a->rawscore}-{$a->penalization}%: Odkrili ste {$a->nosuccessfulstages} scen od skupno {$a->nostages}. Kazensko se odbije {$a->penalization}% zaradi {$a->nolocationsfailed} napačnih mest in {$a->noanswersfailed} napačnih odgovorov.';
$string['gradefromabsolutetime'] = 'Ocena iz trajanja lova';
$string['gradefromposition'] = 'Ocena iz pozicije';
$string['gradefromstages'] = 'Ocena scen';
$string['gradefromtime'] = 'Ocena časa dokončanja';
$string['grademethod'] = 'Metoda ocenjevanja';
$string['grademethod_help'] = '<p><b>Ocena stopenj</b></p>
<p>Vsek igralec (ali ekipa) je točkovan glede na število rešenih stopenj, kjer 100% ponazarja popolnoma rešeno pot in 0% ponazarja 0 rešenih stopenj.</p>
<p><b>Ocena trajanja lova</b></p>
<p>Lovec, ki konča lov na zaklad v najhitrejšem času, zmaga lov in določi najboljši čas.
Čas se meri od trenutka, ko se omogoči reševanje prve stopnje lova.
To pomeni, da lahko udeleženci igrajo ob različnih časih.
Ocena se izračuna z interpolacijo končnega časa, ki predstavlja 50% ocene, in najboljšega časa lova, ki predstavlja 100%. Igralci, ki lova niso dokončali, prejmejo oceno, nižjo od 50%, izračunano iz števila rešenih stopenj.</p>
<p><b>Ocena končnega časa</b></p>
<p>Igralec, ki prvi konča lov, je zmagovalec igre. Predvideva se, da vsi igralci igrajo sočasno.
Ocena se izračuna z interpolacijo končnega časa, ki predstavlja 50% ocene, in najboljšega časa lova, ki predstavlja 100%. Igralci, ki lova niso dokončali, prejmejo oceno, nižjo od 50%, izračunano iz števila rešenih stopenj.</p>
<p><b>Ocena zaporednega mesta</b></p>
<p>Ocena se izračuna z interpolacijo končnega točkovanega zaporednega mesta uporabnika, kjer 100% predstavlja prvo mesto in 50% zadnje. Igralci, ki lova niso dokončali, prejmejo oceno, nižjo od 50%, izračunano iz števila rešenih stopenj.</p>';
$string['grademethodinfo'] = 'Metoda ocenjevanja: {$a->type}. Lokacijska kazen: {$a->gradepenlocation}%. Kazen zaradi nepravilnih odgovorov: {$a->gradepenanswer}%';
$string['gradepenanswer'] = 'Kazen za nepravilni odgovor';
$string['gradepenlocation'] = 'Kazen za nepravilno lokacijo';
$string['gradepenlocation_help'] = 'Kazen se izraža v odstotkih ocene. Na primer: Če kazen znaša 5.4, se bo igralcu s 3 nepravilnimi poskusi odbilo 16.2% končne ocene, kar pomeni, da se mu bo 83.8% ocene izračunalo preko drugih kriterijev.';
$string['gradesdeleted'] = 'Ocene lova na zaklad izbrisane';
$string['gradingsummary'] = 'Povzetek ocenjevanja';
$string['group'] = 'Skupina';
$string['groupactivityovercome'] = 'Dejavnost za sceno {$a->position} uspešno opravljena s strani {$a->user} na {$a->date}';
$string['groupid'] = 'Skupina, dodeljena na poti';
$string['groupid_help'] = 'Uporabniki te skupine so ob začetku igre dodeljeni na to pot.
Če obstaja samo ena pot in je nastavljena možnost "brez", bodo na njej igrali vsi igralci.';
$string['groupingid'] = 'Razvrščanje po skupinah, dodeljenih na poti';
$string['groupingid_help'] = 'Skupine tega skupka so ob začetku igre dodeljene na to pot';
$string['groupinvalidroad'] = '{$a} dodeljena neveljavna pot.';
$string['grouplocationfailed'] = '<b>Spodletela "scena {$a->position}" lokacija</b> uporabnik: {$a->user} na {$a->date}';
$string['grouplocationovercome'] = '<b>Uspešno opravljena "scena {$a->position}" lokacija</b> uporabnik: {$a->user} na {$a->date}';
$string['groupmode'] = 'Učenci igrajo v skupinah';
$string['groupmode_help'] = 'Če je ta nastavitev omogočena, se bodo igralci delili po skupinah, določenih v nastavitvah predmeta. Vsak član skupine lahko reši trenutno sceno. Napredek je skupen, kar omogoča hitrejše, vzporedno reševanje nalog in pokrivanjem terena.';
$string['groupmultipleroads'] = '{$a} je dodeljena več kot ena pot.';
$string['groupquestionfailed'] = '<b>Spodletela scena {$a->position} answer</b> uporabnika {$a->user} {$a->date}';
$string['groupquestionovercome'] = '<b>Pravilen odgovor scena {$a->position}</b> uporabnika {$a->user} {$a->date}';
$string['groups'] = 'Skupine';
$string['groupstageovercome'] = '<b>Scena {$a->position} pokrita</b> s strani {$a->user} {$a->date}';
$string['hello'] = 'Živjo';
$string['history'] = 'Zgodovina';
$string['huntcompleted'] = 'Ta Lov za zakladom ste že dokočnali';
$string['incorrectanswer'] = 'Nepravilni odgovor.';
$string['info'] = 'Informacije';
$string['infovalidatelocation'] = 'Potrdi lokacijo te scene';
$string['invalidassignedroad'] = 'Dodeljena pot ni potrjena';
$string['invalroadid'] = 'Pot ni potrjena';
$string['lastsuccessfulstage_tour'] = 'Na tej plošči lahko najdete zadnjo uspešno dokončano sceno.';
$string['layers'] = 'Plasti';
$string['loading'] = 'Nalaganje';
$string['lockedaclue'] = 'Za odkrivanje sledi morate prej dokončati dejavnost <strong>{$a}</strong>';
$string['lockedaqclue'] = 'Za odkrivanje sledi morate prej dokončati dejavnost <strong>{$a}</strong> in pravilno odgovoriti na naslednje vprašanje.';
$string['lockedclue'] = 'Zakrita sled';
$string['lockedqclue'] = 'Za odkrivanje sledi morate prej pravilno odgovoriti na naslednje vprašanje.';
$string['locktimeediting'] = 'Urejanje zaklepanja';
$string['locktimeediting_help'] = 'Čas v sekundah, med katerim lahko uporabnik še popravi igro brez obnovitve zaklepanja.
Večji, kot je ta čas, manj obnovitvenih zahtevkov je lahko poslanih in več časa je stran za urejanje onemogočena, ko uporabnik konča z urejanjem.
Mora biti večji od 5 sekund, sicer se nastavi na privzeto vrednost.';
$string['map_tour'] = 'Na tem zenljevidu lahko uporavljate z deli zabavne igre z geolokacijo.';
$string['mapplay_tour'] = '<b>Zemljevid</b> prikaže vse vaše poskuse.<br>Uspešni: <img src="pix/success_mark.png" width="28"/><br>Neuspešni: <img src="pix/failure_mark.png" width="28"/>';
$string['mapplaymobile_tour'] = '<b>Zemljevid</b> prikaže vse vaše poskuse.<br>Uspešni: <img src="{$a->successurl}" width="28"/><br>Neuspešni: <img src="{$a->failureurl}" width="28"/>';
$string['mapview'] = 'Pogled zemljevida';
$string['modify'] = 'Spremeni';
$string['modulename'] = 'Lov na zaklad';
$string['modulename_help'] = 'Lov na zaklad omogoča igranje notranje, zunanje ali virtualne igre lova na zaklad z uporabo geolokacijske tehnologije ali skeniranjem QR kod.
Vključuje urejevalnik in igro v brskalniku, ki se lahko prilagodi s širokim naborom možnosti.
<p><b><a href = "https://juacas.github.io/moodle-mod_treasurehunt/index.html">More info and step-by-step tutorial in this online presentation.</a></b></p>';
$string['modulenameplural'] = 'Lovi na zaklad';
$string['movingplay'] = 'Premikajoča igra';
$string['multiplegroupingsplay'] = 'Vaša skupina ima dodeljeno več kot eno pot, zaradi česar ne morate igrati dejavnosti.';
$string['multiplegroupsplay'] = 'Dodeljeno imate več kot eno pot, zaradi česar ne morate igrati dejavnosti.';
$string['multiplegroupssameroadplay'] = 'Pripadate večim skupinam, katere imajo dodeljeno isto pot, zaradi česar ne morate igrati dejavnosti.';
$string['multipleteamsplay'] = 'Pripadate večim skupinam, zaradi česar ne morate ustvariti dejavnosti.';
$string['mustanswerquestion'] = 'Pred nadaljevanjem morate pravilno odgovoriti na vprašanje';
$string['mustcompleteactivity'] = 'Pred nadaljevanjem morate dokončati dejavnost';
$string['mustcompleteboth'] = 'Pred nadaljevanjem morate dokončati dejavnost in odgovoriti na vprašanje';
$string['nextcamera'] = 'Spremeni kamero';
$string['nextstep'] = 'Naslednje';
$string['noanswerselected'] = 'Izbrati morate odgovor';
$string['noattempts'] = 'Niste še poskušali z reševanjem';
$string['noexsitsstage'] = 'V podatkovni bazi ni vnosa {$a}. Ponovno naložite stran.';
$string['nogroupassigned'] = 'Na to pot ni dodeljene skupine.';
$string['nogroupingplay'] = 'Na tej poti nimate dodeljene skupine, zaradi česar ne morete igrati dejavnosti.';
$string['nogroupplay'] = 'Nimate dodeljenih poti, zaradi česar ne morete igrati dejavnosti.';
$string['nogrouproad'] = '{$a} nima dodeljenih poti';
$string['nomarks'] = 'Najprej označite željeno mesto na zemljevidu. Postavite <img src="pix/my_location.png" width="28"/>';
$string['nomarksmobile'] = 'Najprej označite željeno mesto na zemljevidu.';
$string['noresults'] = 'Ni najdenih rezultatov.';
$string['noroads'] = 'Poti še niso bile dodane';
$string['notchangeorderstage'] = 'Vrstnega reda poti ne morate spreminjati, ko so se že zgodili poskusi reševanja na njej';
$string['notcreatestage'] = 'Ne morate dodajati scen, ko so se že zgodili poskusi reševanja na poti';
$string['notdeletestage'] = 'Ne morate brisati scen, ko so se že zgodili poskusi reševanja na poti';
$string['noteam'] = 'Ni član nobene skupine';
$string['notreasurehunts'] = 'V predmetu ni lova na zaklad';
$string['nouserassigned'] = 'Na tej poti ni dodeljenih uporabikov';
$string['nouserattempts'] = '{$a} ni poskušal z reševanjem';
$string['nouserroad'] = '{$a} nima dodeljene poti';
$string['nousersprogress'] = 'Na tej poti ni napredoval noben učenec / skupina.';
$string['outoftime'] = 'Zmanjkalo časa.';
$string['overcomefirststage'] = 'Za odkritje prve stopnje, začnite z označenim območjem na zemljevidu.';
$string['overlaylayers'] = 'Plasti za prekrivanje';
$string['pegmanlabel'] = 'Pogled naokoli z StreetView';
$string['play'] = 'Igraj';
$string['playend_tour'] = '<span style="font-size: 1.5em; font-weight: bold">Uživajte v Lovu na zaklad</span><br>with your mates!';
$string['playerbootstrap'] = 'Vezava';
$string['playerclassic'] = 'Klasično';
$string['playerhelp_tour'] = 'Ta voden ogled se lahko pregleda, kadarkoli želite.';
$string['playerstyle'] = 'Stil zaslona igre';
$string['playerstyle_help'] = 'Učitelji lahko izbirajo med večimi stili zaslona igre';
$string['playstagewithoutmoving'] = 'Odkrivanje scene brez premikanja';
$string['playstagewithoutmoving_help'] = 'Če je ta nastavitev omogočena, lahko igralci odkrijejo to sceno brez, da se kamorkoli premaknejo. Vsakič, ko uporabnik klikne na zemljevid, se tam ustvari zaznamek za zadnjo ogledano točko, prejšnji pa se pobriše. Ko se scena uspešno dokonča, se nastavitve spremenijo na privzete nastavitve dejavnosti.';
$string['playstagewithqr'] = 'Odkrivanje scene z branjem QR kode';
$string['playstagewithqr_help'] = 'Če ima ta nastavitev nastavljeno vsebino, lahko igralci sceno odkrijejo s skeniranjem QR kode na določeni lokaciji.';
$string['playwithoutmoving'] = 'Igranje brez premikanja';
$string['playwithoutmoving_help'] = 'Če je ta možnost omogočena, lahko uporabniki igrajo igro brez fizičnega obiskovanja lokacij. Vsakič, ko uporabnik klikne na zemljevid, se ustvari zaznamek, ki ponazarja uporabnikovo zadnjo željeno lokacijo.';
$string['pluginadministration'] = 'Nastavitve lova na zaklad';
$string['pluginname'] = 'Lov na zaklad';
$string['prevstep'] = 'Prejšnje';
$string['qrreaded'] = 'Prebrana QR koda:';
$string['question'] = 'Vprašanje';
$string['remove'] = 'Izbriši';
$string['remove_tour'] = 'Izbrišete lahko dele geometričnih oblik. Izberite lik in kliknite ta gumb.';
$string['removealltreasurehuntattempts'] = 'Izbriši vse poskuse reševanja Lova na zaklad';
$string['removedactivitytoend'] = 'Dejavnost za dokončanje je bila odstranjena';
$string['removedquestion'] = 'Vprašanje je bilo odstranjeno';
$string['removeroadwarning'] = 'Če odstranite pot, se bodo nepreklicno odstranile tudi povezane scene.';
$string['removewarning'] = 'Kar je odstranjeno, se ne more odnoviti.';
$string['restrictionsdiscoverstage'] = 'Omejevanje odkrivanja scene';
$string['reviewofplay'] = 'Pregled igre';
$string['road'] = 'Pot';
$string['roadended'] = 'Pot je dokončana. Čestitke! Dokončali ste lov na zaklad. Zgodovino lahko pogledate na zemljevidu.';
$string['roadmap'] = 'Pot';
$string['roadname'] = 'Ime poti';
$string['roads_tour'] = 'Na tem območju se najdejo razne poti vaše igre. Izberite eno za urejanje njenih scen.';
$string['roadview'] = 'Pot';
$string['save'] = 'Shrani';
$string['save_tour'] = 'Ne pozabite na shranjevanje vaših lokacij, ko jih narišete.';
$string['saveemptyridle'] = 'Vse spremenjene scene morajo imeti geometrične oblike pred shranjevanjem';
$string['savewarning'] = 'Sprememb niste shranili';
$string['scanQR_generatebutton'] = 'Ustvari QR kodo';
$string['scanQR_scanbutton'] = 'Skeniraj QR kodo';
$string['search'] = 'Išči';
$string['searching'] = 'Iskanje';
$string['searchlocation'] = 'Išči lokacijo';
$string['searchlocation_tour'] = 'S tem iskalnikom lahko hitro najdete svojo pot';
$string['send'] = 'Pošji';
$string['sendlocationcontent'] = 'Tega dejanja ne morete kasneje spremeniti.';
$string['sendlocationtitle'] = 'Ali ste prepričani, da želite poslati to lokacijo?';
$string['showclue'] = 'Prikaži sled';
$string['skiptutorial'] = 'Izhod';
$string['stage'] = 'Scena';
$string['stageclue'] = 'Sled za iskanje naslednje scene';
$string['stageclue_help'] = 'Tukaj opišete sled do naslednje lokacije.
Če gre za zadnjo stopnjo lova na zaklad, pustite sporočilo, da se lov na zaklad zaključuje.';
$string['stagename'] = 'Ime scene';
$string['stageovercome'] = 'Stopnja premagana';
$string['stages'] = 'Scene';
$string['stages_tour'] = 'Tu se najdejo stopnje izbrane poti. Izberite stopnjo, da približate dejanjsko lokacijo na zemljevidu in začnete z urejanjem njenih geometrijskih teles.';
$string['start'] = 'Začetek';
$string['startfromhere'] = 'Začnete lahko samo od tukaj';
$string['state'] = 'Stanje';
$string['successlocation'] = 'Pravilno mesto!';
$string['timeago'] = 'pred {$a->shortduration}';
$string['timeagolong'] = 'pred {$a->shortduration} ({$a->data})';
$string['timeat'] = 'dne {$a->date}';
$string['timeexceeded'] = 'Prekoračili ste časovno omejitev za dejavnost. To okno služi samo pregledu igre.';
$string['timetocome'] = 'v {$a->shortduration}';
$string['timetocomelong'] = 'v {$a->shortduration} ({$a->date})';
$string['totalprogress'] = 'Skupni napredek';
$string['totaltime'] = 'Skupni čas';
$string['trackusers'] = 'Sledi uporabnikovim potem';
$string['trackusers_help'] = 'Beleži poti, po katerih se je uporabnik sprehodil. Pregledajo se lahko v meniju "Pregled poti".<br/>
Uporabnikova lokacija se beleži med potrditvenimi zahtevki (z vsakim zahtevkom).<br/>
Če je uporabnikov GPS onemogočen, lahko uporabnik javlja lokacijo le s skeniranjem QR kod.<br/>
Če je ta možnost <b>onemogočena</b>, se beležijo le lokacije, poslane skupaj s poskusi potrditev.';
$string['trackviewer'] = 'Pregled poti';
$string['trackviewerrefreshtracks'] = 'Posodobi sledi na poteh vsakih {$a} sekund';
$string['treasurehunt'] = 'Lov na zaklad';
$string['treasurehunt:addinstance'] = 'Dodaj nov lov na zaklad';
$string['treasurehunt:addroad'] = 'Dodaj pot';
$string['treasurehunt:addstage'] = 'Dodaj sceno';
$string['treasurehunt:editroad'] = 'Uredi pot';
$string['treasurehunt:editstage'] = 'Uredi sceno';
$string['treasurehunt:managetreasure'] = 'Upravljal lov na zaklad';
$string['treasurehunt:managetreasurehunt'] = 'Upravljal lov na zaklad';
$string['treasurehunt:play'] = 'Igraj';
$string['treasurehunt:view'] = 'Ogled lova na zaklad';
$string['treasurehunt:viewusershistoricalattempts'] = 'Prikaži zgodovino poskusov uporabnikov';
$string['treasurehuntclosed'] = 'Ta lov na zaklad zapre {$a}';
$string['treasurehuntcloses'] = 'Ta lov na zaklad zapre';
$string['treasurehuntcloseson'] = 'Ta lov na zaklad bo zaprl {$a}';
$string['treasurehuntislocked'] = '{$a} trenutno že ureja ta lov na zaklad. Poskusite z urejanjem čez nekaj minut.';
$string['treasurehuntname'] = 'Ime lova na zaklad';
$string['treasurehuntnotavailable'] = 'Ta lov na zaklad bo na voljo {$a}';
$string['treasurehuntopenedon'] = 'Ta lov na zaklad se bo odprl {$a}';
$string['treasurehuntopens'] = 'Ta lov na zaklad se odpre';
$string['updates'] = 'Posodobitve';
$string['updatetimes'] = 'Časi posodobitv';
$string['user'] = 'Uporabnik';
$string['useractivityovercome'] = '<b>Moodle dejavnost za "scena {$a->position}" uspešno opravljena</b> {$a->date}';
$string['userattempthistory'] = 'Zgodovina poskusov {$a}';
$string['userinvalidroad'] = '{$a} je dodelil/a neveljavno pot.';
$string['userlocationfailed'] = '<b>Spodletela lokacija "scena {$a->position}"</b> {$a->date}';
$string['userlocationovercome'] = '<b>Uspešno končana lokacija "scena {$a->position}"</b> {$a->date}';
$string['usermultipleroads'] = '{$a} ima dodeljeno več kot eno pot.';
$string['usermultiplesameroad'] = '{$a} pripada več kot eni skupini, dodeljeni na isto pot.';
$string['userprogress'] = 'Uporabnikov napredek uspešno posodobljen';
$string['userquestionfailed'] = '<b>Neuspešen odgovor "scena {$a->position}"</b> {$a->date}';
$string['userquestionovercome'] = '<b>Uspešno dokončan odgovor "scena {$a->position}"</b> {$a->date}';
$string['usersprogress'] = 'Uporabnikov napredek';
$string['usersprogress_help'] = 'Ponazarja napredek uporabnika ali skupine po stopnjah glede na barve:
<p><b>Zelena</b> ponazarja stopnjo, premagano brez neuspehov.</p>
<p><b>Rumena</b> ponazarja stopnjo, premagano po nekaj poskusih.</p>
<p><b>Rdeča</b> ponazarja stopnjo, kjer so bili podani samo neuspeli poskusi.</p>
<p><b>Siva</b> ponazarja stopnjo, ki še ni bila premagana in na kateri še ni bilo neuspelih poskusov.</p>';
$string['userstageovercome'] = '<b>Stopnja {$a->position} premagana</b>: {$a->date}';
$string['validatelocation'] = 'Potrdi lokacijo';
$string['validatelocation_tour'] = 'Ste prepričani o lokaciji stopnje?<br><b>Oddajte vaše nahajališče</b> in odkrijte, ali imate prav.';
$string['validateqr'] = 'Skeniraj QR';
$string['warmatchanswer'] = 'Odgovor nima povezave z vprašanjem';
$string['warnqrscanner'] = '<table><tr><td> Ta Lov na zaklad vključuje {$a} stopenj s QR kodami. Prepričajte se, da lahko vaša naprava bere kode iz brskalnika. Spodaj bi se moral pojaviti pogled vaše kamere, poskusite tako prebrati QR kodo.</td><td> <a href="pix/qr.png">
 <img src="pix/qr.png" align="top" width="100"></a></td></tr></table>';
$string['warnqrscannererror'] = 'Ta Lov na zaklad vključuje {$a} stopenj s QR kodami.
Izgleda, da vaša naprava ne more uporabljati kamere s to aplikacijo. Poskusite podati dovoljenje napravi za uporabo kamere. Če kamere ne morete aktivirati, vaša naprava morda ni primerna za igranje Lova na zaklad.';
$string['warnqrscannersuccess'] = 'Ta Lov na zaklad vključuje {$a} scen s QR kodami. Izgleda, da ste s to napravo prestali QR test.';
$string['warnunsecuregeolocation'] = 'Geolokacija morda ne bo delovala na vašem strežniku. To je <b>HUDA NAPAKA</b> v nastavitvah strežnika. Geolokacija je onemogočena za strežnike, ki ne podpirajo varne povezave HTTPS namesto HTTP. Za uporabo GPS tehnologije med igranjem Lova na zaklad, mora strežnik urediti TLS podporo, sicer se lahko uporablja le način igranja brez premikanja, kjer morajo igralci ročno izbrati vsako lokacijo zemljevida.
Prosimo da napako sporočite skrbniku strežnika.
(Sklici: <a href="https://www.chromestatus.com/feature/5636088701911040">Chrome</a>, <a href="https://blog.mozilla.org/security/2015/04/30/deprecating-non-secure-http/">Firefox</a>)';
$string['warnusersgroup'] = 'Naslednji uporabniki pripadajo več kot eni skupini: {$a}, zaradi česar se ne morejo udeležiti v dejavnosti.';
$string['warnusersgrouping'] = 'Naslednje skupine pripadajo več kot enen skupku: {$a}, zaradi česar se ne morejo udeležiti v dejavnosti.';
$string['warnusersoutside'] = 'Naslednji uporabniki ne pripadajo nobeni skupini/skupku: {$a}, zaradi česar se ne morejo udeležiti v dejavnosti.';
$string['welcome_edit_tour'] = 'Dobrodošli na stran urejevalnika Lova na zaklad';
$string['welcome_play_tour'] = '<span style="font-size: 1.5em; font-weight: bold">Dobrodošli na vaš Lov na zaklad!</span><br>Ta zemljevid in sledi vas bodo vodile do cilja.';
