<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap_syncplus', language 'de', version '5.0'.
 *
 * @package     auth_ldap_syncplus
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_syncplusdescription'] = '<p>Diese Anmeldemethode ermöglicht die Authentifizierung über einen externen LDAP-Server.

<p>Um ein neues LDAP-basiertes Nutzerkonto in Moodle anzulegen, muss vorher das LDAP-Nutzerkonto existieren. Beim ersten Login wird automatisch ein neues Nutzerkonto in der Moodle-Datenbank, wobei Anmeldename und Kennwort vorher von LDAP geprüft werden. Das Modul sorgt dafür, dass ausgewählte Nutzerdaten von LDAP in die Moodle-Datenbank übernommen werden können. Wenn das Kennwort weiterhin ausschließlich von LDAP verwaltet wird, ermöglicht dies einheitliche Anmeldedaten in unterschiedlichen Moodle-Instanzen und bei anderen Servern.

<p>Bei allen weiteren Logins werden weiterhin Anmeldename und Kennwort vom LDAP-Server überprüft.';
$string['auth_remove_deletewithgraceperiod'] = 'Intern sperren und erst nach der Wartefrist endgültig intern löschen';
$string['dangerzone'] = 'Gefahrenzone';
$string['dangerzone_desc'] = 'Normalerweise sollten Sie die folgenden Einstellungen nicht ändern, es sei denn, Sie möchtet riskieren, dass etwas kaputtgeht.';
$string['nouserentriestosuspend'] = 'Keine Nutzerkonten zum Sperren gefunden';
$string['pluginname'] = 'LDAP server (Sync Plus)';
$string['privacy:metadata'] = 'Das Plugin \'Authentifizierung LDAP-Server (Sync Plus)\' speichert keine personenbezogenen Daten.';
$string['removeuser_graceperiod'] = 'Wartefrist bis zur endgültigen Löschung';
$string['removeuser_graceperiod_desc'] = 'Wenn ein Nutzerkonto intern gesperrt wurde, wartet das Synchronisierungsskript die angegebene Anzahl von Tagen, bevor das Nutzerkonto endgültig intern gelöscht wird. Falls das LDAP-Nutzerkonto im LDAP Server während der Wartefrist wieder erscheint, wird der zugehörige Moodle-Account reaktiviert. Hinweis: Diese Einstellung wird nur verarbeitet, wenn die Einstellung "Entfernte externe Nutzer/innen" auf "Intern sperren und erst nach der Wartefrist endgültig intern löschen" gesetzt ist.';
$string['sync_authtype'] = 'Moodle-Authentifizierungstyp beim Synchronisieren von Nutzern';
$string['sync_authtype_desc'] = 'Es kann Moodle Setups geben, bei denen sich Nutzer nicht über LDAP authentifizieren, LDAP Sync Plus jedoch für das Anlegen und Entfernen von Moodle Nutzern verwendet werden soll.
Ein Beispiel wäre die Vorprovisionierung und Deprovisionierung von Shibboleth Acsounts. Shibboleth verfügt nicht direkt über eine eigene Möglichkeit, Benutzer vorzuprovisionieren oder zu deprovisionieren. Ein Shibboleth-IDP könnte jedoch zusätzlich seine Nutzerdatenbank über LDAP verfügbar machen, wodurch Sie den geplanten Task von LDAP Sync Plus verwenden könnten, um diese Provisionierungen durchzuführen. In einem solchen Setup müssen Sie diese Einstellung hier ändern, um den Moodle-Authentifizierungstyp für Benutzerkonten zu steuern, die durch die den geplanten Task erstellt, entfernt oder aktualisiert werden.';
$string['sync_filter'] = 'LDAP Filter zur Synchronisierung von Nutzern';
$string['sync_filter_desc'] = 'Wenn Sie LDAP Sync Plus verwenden, um Nutzer mit einem anderen Authentifizierungstyp als LDAP zu synchronisieren, können Sie hier einen eigenen LDAP-Filter konfigurieren, der bei der Suche der Nutzer in LDAP verwendet wird. Dies kann notwendig sein, wenn der LDAP-Server, der die zu synchronisierenden Nutzer enthält, mehr Nutzer enthält als Sie synchronisieren möchten, und wenn Sie keinen geeigneten Filter mit den Einstellungen user_attribute und objectclass realisieren können (diese werden standardmäßig in einer fest codierten Weise zum LDAP-Filter <code>{$a}</code> kombiniert). Sobald Sie diese Einstellung auf einen nicht-leeren Wert setzen, wird diese als LDAP-Filter verwendet, um die LDAP-Nutzer zu ermitteln, die im Rahmen der LDAP Synchronisierung erstellt, aktualisiert oder gelöscht werden sollen. Bitte überprüfen Sie sorgfältig, dass der konfigurierte Filter genau die Nutzer zurückgibt, die Sie synchronisieren möchten – nicht mehr und nicht weniger.';
$string['sync_filter_nouserattribute'] = 'Warnung: Ein ermittelter LDAP-Eintrag hat kein Nutzerattribut gesetzt. Dieser Eintrag muss übersprungen werden. Bitte überprüfen Sie Ihre sync_filter Einstellung, um sicherzustellen, dass keine Einträge ohne gesetztes Nutzerattribut zurückgegeben werden.';
$string['sync_scope'] = 'Namensraum zur Synchronisierung von Nutzern';
$string['sync_scope_desc'] = 'Wenn Sie LDAP Sync Plus verwenden, um Nutzer mit einem anderen Authentifizierungstyp als LDAP zu synchronisieren, können Sie hier einen zusätzlichen Namensraum konfigurieren. Dies kann notwendig werden, wenn das Nutzerattribut in LDAP nicht vollständig mit dem Nutzernamen in Moodle übereinstimmt, insbesondere wenn der Moodle-Nutzername dem eduPersonPrincipalName entspricht und der Benutzername in LDAP nur das uid ist. Der Namensraum wird dann beim Synchronisieren der Benutzer an den LDAP-Nutzernamen angehängt. Zusätzlich werden Benutzer, deren Moodle Nutzername diesen Namensraum nicht enthält, während der Synchronisierung ignoriert. Ein typisches Beispiel für einen Namensraum wäre „@example.org“.';
$string['sync_scope_note'] = 'Bitte beachten Sie: Je nach Ihrem Setup kann es völlig in Ordnung sein, den Namensraum leer zu lassen. Wenn Ihr Setup jedoch einen Namensraum erfordern würde und Sie vergessen, diesen zu setzen, besteht die Gefahr, dass alle Ihre Nutzer aufgrund der Diskrepanz zwischen Moodle- und LDAP-Nutzernamen aus Moodle deprovisioniert werden. Stellen Sie bitte sicher, dass der konfigurierte Namensraum wirklich korrekt ist, und testen Sie die Synchronisierung gründlich, bevor Sie sie in der Produktion aktivieren.';
$string['sync_script_createuser_enabled'] = 'Wenn diese Option aktiviert ist (Standard), wird das Cron-Synchronisierungsskript Moodle-Accounts für alle LDAP Nutzer, welche sich noch nie in Moodle eingeloggt haben, anlegen.
Wenn diese Option deaktiviert ist, wird das Cron-Synchronisierungsskript keine Moodle-Accounts für alle LDAP Nutzer anlegen.';
$string['sync_script_createuser_enabled_key'] = 'Neue Nutzer/innen erstellen';
$string['syncroles'] = 'Synchronisierung von LDAP-Nutzerrollen (Sync Plus)';
$string['synctask'] = 'Synchronisierung von LDAP-Nutzerkonten (Sync Plus)';
$string['userentriestoadddone'] = 'Transaktion abgeschlossen – Nutzerkonten hinzugefügt: {$a}';
$string['userentriestoremovedone'] = 'Transaktion abgeschlossen – Nutzerkonten entfernt: {$a}';
$string['userentriestorevivedone'] = 'Transaktion abgeschlossen – Nutzerkonten reaktiviert: {$a}';
$string['userentriestosuspend'] = 'Nutzerkonten zum Sperren: {$a}';
$string['userentriestosuspenddone'] = 'Transaktion abgeschlossen – Nutzerkonten deaktiviert: {$a}';
$string['userentriestoupdate'] = 'Zu überprüfende Nutzerkonten: {$a}';
$string['userentriestoupdatedone'] = 'Transaktion abgeschlossen – Nutzerkonten aktualisiert: {$a->updated}, Nutzerkonten übersprungen: {$a->skipped}';
$string['waitinginremovalqueue'] = 'Vorgemerkt zur endgültigen Löschung nach der {$a->days}-tägigen Wartefrist: {$a->name} ID {$a->id}';
