<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'de', version '5.0'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Über mich';
$string['actingasrole'] = 'Sie sind derzeit in einer anderen Rolle tätig';
$string['activatetemplateoverride'] = 'Aktivieren Sie die Überschreibung der Vorlage für';
$string['activatetemplateoverridedesc'] = 'Wenn diese Option aktiviert ist, wird der Wert in der Einstellung "{$a->setting}" als "{$a->template}"-Vorlage verwendet, wenn sie Text enthält.';
$string['activitiesheading'] = 'Aktivitäten';
$string['alertaccess'] = 'Alarmsichtbarkeit';
$string['alertaccessadmins'] = 'Sichtbar für Administratoren';
$string['alertaccessdesc'] = 'Legen Sie die Art der Zugriffsbeschränkung für die Sichtbarkeit der Warnbox fest.  Hinweis: Wenn Sie "Benutzerdefinierte Profilfeldbeschränkung hinzufügen" verwenden, müssen Sie unten Werte für die Profilfelder hinzufügen.';
$string['alertaccessglobal'] = 'Sichtbar für alle';
$string['alertaccessprofile'] = 'Benutzerdefinierte Profilfeldbeschränkung hinzufügen';
$string['alertaccessusers'] = 'Sichtbar für angemeldete Nutzer/innen';
$string['alertannounce'] = 'Ankündigung';
$string['alertannouncedesc'] = 'Zeigen Sie eine Meldung in der Alarmbox an.';
$string['alertbackgroundcolorinfo'] = 'Info Hintergrundfarbe';
$string['alertbackgroundcolorinfodesc'] = 'Hintergrundfarbe der Info-Typ-Warnfelder.';
$string['alertbackgroundcolorsuccess'] = 'Hintergrundfarbe der Ankündigung';
$string['alertbackgroundcolorsuccessdesc'] = 'Hintergrundfarbe der Warnfelder, des Typs Ankündigung.';
$string['alertbackgroundcolorwarning'] = 'Farbe des Warnhintergrundes';
$string['alertbackgroundcolorwarningdesc'] = 'Hintergrundfarbe der Warnfelder, vom Typ Warnung.';
$string['alertbordercolorinfo'] = 'Farbe des Info-Rahmens';
$string['alertbordercolorinfodesc'] = 'Farbe der Umrandung der Info-Typ-Warnbox.';
$string['alertbordercolorsuccess'] = 'Farbe des Ankündigungsrahmens';
$string['alertbordercolorsuccessdesc'] = 'Rahmenfarbe der Warnfelder, vom Typ Ankündigung.';
$string['alertbordercolorwarning'] = 'Farbe des Warnrahmens';
$string['alertbordercolorwarningdesc'] = 'Rahmenfarbe der Warnfelder vom Typ Warnung.';
$string['alertcolorinfo'] = 'Info Farbe';
$string['alertcolorinfodesc'] = 'Symbolfarbe, der Warnfelder vom Typ Info.';
$string['alertcolorsheading'] = 'Anpassen der oberen Warnfelder';
$string['alertcolorsuccess'] = 'Farbe der Ankündigung';
$string['alertcolorsuccessdesc'] = 'Farbe des Symbols, für die Warnfelder, des Typs Ankündigung.';
$string['alertcolorwarning'] = 'Warnfarbe';
$string['alertcolorwarningdesc'] = 'Symbolfarbe der Warnfelder, vom Typ Warnung.';
$string['alertcount'] = 'Anzahl der Warnmeldungen';
$string['alertcountdesc'] = 'Die Einstellung legt fest, wie viele Hinweise im Eingabebereich gezeigt werden sollen.';
$string['alertdesc'] = 'Geben Sie einen Text ein und passen Sie ihn an, der oben auf der Website als Benachrichtigung angezeigt werden soll. Es ist möglich, mehr als eine Warnung festzulegen, um unterschiedliche Benutzertypen anzusprechen. Sie haben auch die Möglichkeit, Benachrichtigungen auf der gesamten Website oder nur auf Startseiten anzuzeigen. <br /><br /><strong>Hinweis:</strong> Es ist jetzt auch möglich, Benachrichtigungen innerhalb von Kursseiten anzuzeigen, um Trainer/innen zu warnen, dass Kurse ausgeblendet sind.';
$string['alertdisabled'] = 'Deaktiviert';
$string['alertdisabledesc'] = 'Deaktivieren Sie diesen Alarm.';
$string['alerthiddencourse'] = 'Kurswarnungen aktivieren';
$string['alerthiddencoursedesc'] = 'Anzeige von Warnhinweisen auf der Kursseite.';
$string['alerticoninfo'] = 'Info-Symbol';
$string['alerticoninfodesc'] = 'Legen Sie das \'<a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a>\' fest, das in Infoboxen verwendet werden soll.  Geben Sie den Namen des Symbols ohne das Präfix fa- ein.';
$string['alerticonsuccess'] = 'Ankündigungssymbol';
$string['alerticonsuccessdesc'] = 'Legen Sie das \'<a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a>\' fest, das in Benachrichtigungsfeldern des Typs Ankündigung verwendet werden soll.  Geben Sie den Namen des Symbols ohne das Präfix fa- ein.';
$string['alerticonwarning'] = 'Warn-Symbol';
$string['alerticonwarningdesc'] = 'Legen Sie das \'<a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a>\' fest, das in Warnfeldern verwendet werden soll.  Geben Sie den Namen des Symbols ohne das Präfix fa- ein.';
$string['alertinfo'] = 'Info';
$string['alertinfodesc'] = 'Informationen in den Warnfeldern anzeigen.';
$string['alertkeyvalue'] = 'Alarm-Schlüssel';
$string['alertkeyvalue_details'] = 'Der Schlüssel, der diese Warnung von früheren Warnungen unterscheidet.  Wenn Sie diesen Wert ändern, sehen alle Nutzer/innen, die die Warnung zuvor ignoriert haben, sie erneut. Wenn Sie die Warnung ändern, sollten Sie dies tun, um sicherzustellen, dass alle Nutzer/innen sie sehen.';
$string['alertprofilefield'] = 'Benutzerdefiniertes Profilfeld name=Value (optional)';
$string['alertprofilefielddesc'] = 'Fügen Sie eine Zugriffsregel für ein benutzerdefiniertes Profilfeld hinzu, z.B.: usertype=student.';
$string['alertsettings'] = 'Warnfeld {$a}';
$string['alertsettingscourse'] = 'Einstellungen für Kurswarnungen';
$string['alertsettingsgeneral'] = 'Allgemeine Hinweiseinstellungen';
$string['alertsettingsheading'] = 'Passen Sie das Warnfeld an, z.B. mit diesem <a href="./../theme/adaptable/pix/layout.png" target="_blank"> Layout </a>';
$string['alerttext'] = 'Warntext';
$string['alerttextdesc'] = 'Geben Sie den Text ein, der später als Hinweis angezeigt werden soll.';
$string['alerttype'] = 'Hinweisfeld: Typ';
$string['alerttypedesc'] = 'Wählen Sie den Hinweis-Typ aus: Info (blau), Warnung (gelb), oder Ankündigung (grün)';
$string['alertwarning'] = 'Warnung';
$string['alertwarningdesc'] = 'Anzeige einer Warnung, im Warnfeld.';
$string['analyticscount'] = 'Analytics-Zählung';
$string['analyticscountdesc'] = 'Die Anzahl der Analysefelder, die im Bearbeitungsbereich darunter angezeigt werden sollen.';
$string['analyticsprofilefield'] = 'Benutzerdefiniertes Profilfeld Name=Wert (optional)';
$string['analyticsprofilefielddesc'] = 'Fügen Sie eine Zugriffsregel für ein benutzerdefiniertes Profilfeld hinzu, z. B.: usertype=student.';
$string['analyticssettings'] = 'Analytics';
$string['analyticssettingsdesc'] = 'Sie können für Google Analytics verschiedene Codes einrichten und diese auf Nutzerprofile einstellen.';
$string['analyticssettingsheading'] = 'Richten Sie Google Analytics ein';
$string['analyticstext'] = 'Analyse-ID';
$string['analyticstextdesc'] = 'Geben Sie die Google Analytics ID ein';
$string['anonymizega'] = 'Anonymisierung der Nutzer-IP';
$string['anonymizegadesc'] = 'Anonymisierung der Nutzer-IP an Google Analytics senden.';
$string['bcustyle'] = 'BCU-Stil';
$string['blockbackgroundcolor'] = 'Block-Hintergrundfarbe';
$string['blockbackgroundcolordesc'] = 'Wählen Sie die Hintergrundfarbe für alle Blöcke aus.';
$string['blockbordercolor'] = 'Block-Randfarbe';
$string['blockbordercolordesc'] = 'Wählen Sie die Block-Randfarbe aus.';
$string['blockheaderbackgroundcolor'] = 'Blocküberschrift Hintergrundfarbe';
$string['blockheaderbackgroundcolordesc'] = 'Wählen Sie die Überschrift-Hintergrundfarbe für alle Blöcke aus.';
$string['blockheaderborderbottom'] = 'Block Kopfzeile: Breite des unteren Rands';
$string['blockheaderborderbottomdesc'] = 'Wählen Sie die Breite des unteren Rands der Block-Kopfzeilen';
$string['blockheaderborderleft'] = 'Dicke des linken Randes der Blocküberschrift';
$string['blockheaderborderleftdesc'] = 'Legen Sie die Dicke des linken Randes von Blocküberschriften fest.';
$string['blockheaderborderright'] = 'Dicke des rechten Randes der Blocküberschrift';
$string['blockheaderborderrightdesc'] = 'Legen Sie die Dicke des rechten Randes von Blocküberschriften fest.';
$string['blockheaderbordertop'] = 'Dicke des oberen Randes, des Blockkopfes';
$string['blockheaderbordertopdesc'] = 'Legen Sie die Dicke des oberen Randes von Blocküberschriften fest.';
$string['blockheaderbordertopstyle'] = 'Umrandungsstil des Blockkopfes';
$string['blockheaderbordertopstyledesc'] = 'Legen Sie den Stil des Rahmens von Blocküberschriften fest.';
$string['blockheaderbottomradius'] = 'Radius des Blockkopfes unten';
$string['blockheaderbottomradiusdesc'] = 'Stellen Sie den Radius des unteren Kopfblocks ein, um einen geschwungenen / abgerundeten Effekt zu erzielen.';
$string['blockheadercolor'] = 'Schriftfarbe des Blockkopfes';
$string['blockheadercolordesc'] = 'Legen Sie die Schriftfarbe der Blocküberschrift fest.';
$string['blockheadertopradius'] = 'Oberer Radius des Blockkopfes';
$string['blockheadertopradiusdesc'] = 'Stellen Sie den Radius des oberen Kopfblocks ein, um einen geschwungenen / abgerundeten Effekt zu erzielen.';
$string['blockicons'] = 'Blocksymbole';
$string['blockiconsdesc'] = 'Stellen Sie dies ein, um Blocksymbole im Blockkopfbereich anzuzeigen.';
$string['blockiconsheadersize'] = 'Blockiert die Größe des Kopfzeilen-Symbols';
$string['blockiconsheadersizedesc'] = 'Legen Sie die Größe, des in der Kopfzeile der Moodle-Blöcke verwendeten Schriftzeichens fest.  Wählen Sie einen Wert aus der Liste.';
$string['blocklayoutbuilder'] = 'Startseite: Blockbereiche';
$string['blocklayoutbuilderdesc'] = 'Hier können Sie Ihre eigenen Blockbereiche definieren.
Um Inhalte hinzuzufügen, müssen Sie <strong>auf der Startseite Bearbeiten einschalten</strong>.
Dann können Sie anfangen, Blöcke in die von Ihnen angelegten Bereiche zu ziehen.';
$string['blocklayoutlayoutcheck'] = 'Überprüfen Sie Ihr Layout';
$string['blocklayoutlayoutcheckdesc'] = 'Verwenden Sie das unten stehende Tool, um die Anzahl der verwendeten Blöcke zu überprüfen und eine Darstellung Ihres neuen Layouts zu sehen.';
$string['blocklayoutlayoutcount1'] = 'Sie können einen Höchstanzahl felstlegen';
$string['blocklayoutlayoutcount2'] = 'Blockbereiche. Sie nutzen zur Zeit:';
$string['blocklayoutlayoutrow'] = 'Blockbereich: Zeile';
$string['blocklayoutlayoutrowdesc'] = 'Hinzufügen / definieren eines Layouts für Blockbereiche auf der Startseite';
$string['blockmainborderbottom'] = 'Dicke, des unteren randes, des Hauptblocks';
$string['blockmainborderbottomdesc'] = 'Legen Sie die Dicke, des unteren Randes, des Hauptblockbereichs fest.';
$string['blockmainborderleft'] = 'Dicke, des linken randes, des Hauptblocks';
$string['blockmainborderleftdesc'] = 'Legen Sie die Dicke, des linken Randes, des Hauptblockbereichs fest.';
$string['blockmainborderright'] = 'Dicke, des rechten randes, des Hauptblocks';
$string['blockmainborderrightdesc'] = 'Legen Sie die Dicke, des rechten Randes, des Hauptblockbereichs fest.';
$string['blockmainbordertop'] = 'Dicke, des oberen randes, des Hauptblocks';
$string['blockmainbordertopdesc'] = 'Legen Sie die Dicke, des oberen Randes, des Hauptblockbereichs fest.';
$string['blockmainbordertopstyle'] = 'Rahmenstil des Hauptblocks';
$string['blockmainbordertopstyledesc'] = 'Legen Sie den Stil des Rahmens, des Blockinhaltsbereichs fest.';
$string['blockmainbottomradius'] = 'Unterer Radius des Hauptblocks';
$string['blockmainbottomradiusdesc'] = 'Stellen Sie den unteren Radius des Hauptblocks ein, um einen geschwungenen / abgerundeten Effekt zu erzielen.';
$string['blockmaintopradius'] = 'Oberer Radius des Hauptblocks';
$string['blockmaintopradiusdesc'] = 'Stellen Sie den oberen Radius des Hauptblocks ein, um einen geschwungenen / abgerundeten Effekt zu erzielen.';
$string['blockregionbackground'] = 'Blockbereich: Hintergrundfarbe';
$string['blockregionbackgrounddesc'] = 'Hintergrundfarbe des Containers, der benutzerdefinierte Blocklayouts auf der Startseite enthält.';
$string['blockside'] = 'Position der Blöcke';
$string['blocksidedesc'] = 'Legen Sie fest, ob die Blöcke links oder rechts auf der Seite erscheinen.';
$string['breadcrumb'] = 'Breadcrumb-Navigation';
$string['breadcrumbbackgroundcolor'] = 'Breadcrumb-Hintergrundfarbe';
$string['breadcrumbbackgroundcolordesc'] = 'Legen Sie die Hintergrundfarbe der Breadcrumb-Navigation fest.';
$string['breadcrumbdisplay'] = 'Anzeige der Breadcrumb-Navigation';
$string['breadcrumbdisplaydesc'] = 'Legen Sie fest, was im Breadcrumb-Bereich eines Kurses angezeigt werden soll.';
$string['breadcrumbhome'] = 'Breadcrumb-Startseite';
$string['breadcrumbhomedesc'] = 'Anzeige des Breadcrumbs, als Symbol oder Text.';
$string['breadcrumbhomeicon'] = 'Icon';
$string['breadcrumbhometext'] = 'Text';
$string['breadcrumbseparator'] = 'Breadcrumb Trenner';
$string['breadcrumbseparatordesc'] = 'Legen Sie das <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome Icon</a> fest, das als Elementtrenner im Breadcrumb verwendet werden soll. Geben Sie den Icon-Namen ohne das Präfix fa- ein.';
$string['breadcrumbtextcolor'] = 'Breadcrumb-Schriftfarbe';
$string['breadcrumbtextcolordesc'] = 'Wählen Sie die Schriftfarbe für die Breadcrumb-Leise aus.';
$string['breadcrumbtitle'] = 'Breadcrumb-Kursname';
$string['breadcrumbtitledesc'] = 'Legen Sie den Modus für die Anzeige, des Kurstitels in der Breadcrumb-Ansicht fest.';
$string['bs4all'] = 'Extra klein - Extra groß';
$string['bs4extralarge'] = 'Nur extra groß';
$string['bs4large'] = 'Groß - Extra groß';
$string['bs4medium'] = 'Mittel - Extra groß';
$string['bs4none'] = 'Keinen';
$string['bs4small'] = 'Klein - Extra groß';
$string['buttoncolor'] = 'Tastenfarbe';
$string['buttoncolorcancel'] = 'Farbe der Schaltfläche aufheben';
$string['buttoncolordesc'] = 'Die Farbe der Hauptschaltflächen, die auf der gesamten Website verwendet werden.';
$string['buttoncolordesccancel'] = 'Hintergrundfarbe für die Schaltfläche aufheben.<br />Geben Sie transparent in das Feld für Transparenz ein.';
$string['buttoncolordescscnd'] = 'Die Farbe der sekundären Schaltflächen, die auf der gesamten Website verwendet werden.';
$string['buttoncolorscnd'] = 'Farbe der sekundären Schaltfläche';
$string['buttondesc'] = 'Ändern Sie das Aussehen, der in diesem Thema verwendeten Schaltflächen.';
$string['buttondropshadow'] = 'Schlagschatten, am unteren Rand der Schaltfläche';
$string['buttondropshadowdesc'] = 'Einen Schlagschatten (Schattierung) am unteren Rand der Schaltfläche anzeigen.';
$string['buttonhovercolor'] = 'Schaltfläche, Hover-Farbe';
$string['buttonhovercolorcancel'] = 'Aufhebe-Schaltfläche, Hover-Farbe';
$string['buttonhovercolordesc'] = 'Die Farbe, die die Schaltfläche annimmt, wenn der Mauszeiger über die Schaltfläche bewegt wird.';
$string['buttonhovercolordesccancel'] = 'Die Farbe, in die sich die Schaltfläche "Abbruch" ändert, wenn der Mauszeiger über die Schaltfläche bewegt wird. <br />Geben Sie transparent in das Feld für Transparenz ein.';
$string['buttonhovercolordescscnd'] = 'Die Farbe, die die sekundäre Schaltfläche annimmt, wenn der Mauszeiger über der Schaltfläche schwebt.';
$string['buttonhovercolorscnd'] = 'Sekundäre Schaltfläche, Hover-Farbe';
$string['buttonlogincolor'] = 'Login-Tastenfarbe';
$string['buttonlogincolordesc'] = 'Die Farbe der Anmeldeschaltfläche.';
$string['buttonloginheight'] = 'Legen Sie die Höhe für die Anmeldeschaltfläche fest';
$string['buttonloginheightdesc'] = 'Nur wirksam bei Verwendung eines Anmeldeformulars in der oberen Kopfzeile.';
$string['buttonloginhovercolor'] = 'Login-Schaltfläche, Hover-Farbe';
$string['buttonloginhovercolordesc'] = 'Die Hover-Farbe der Login-Schaltfläche.';
$string['buttonloginmargintop'] = 'Legen Sie den oberen Rand für die Anmeldeschaltfläche fest';
$string['buttonloginmargintopdesc'] = 'Ermöglicht die Änderung des Abstands / der Position der Login-Schaltfläche.';
$string['buttonloginpadding'] = 'Einstellen der Innenabstände für die Anmeldeschaltfläche';
$string['buttonloginpaddingdesc'] = 'Höhere Zahl = größere Schaltfläche.';
$string['buttonlogintextcolor'] = 'Login-Schaltfläche, Textfarbe';
$string['buttonlogintextcolordesc'] = 'Die Farbe des Textes, der auf der Login-Schaltfläche verwendet wird.';
$string['buttonradius'] = 'Tastenradius setzen';
$string['buttonradiusdesc'] = 'Höherer Radius = Schaltfläche mit gebogenen Ecken, niedriger Radius = Schaltfläche mit liniaren Seiten.';
$string['buttonsettings'] = 'Tasten';
$string['buttonsettingsheading'] = 'Selbstanpassen der Schaltflächen';
$string['buttontextcolor'] = 'Tastentextfarbe';
$string['buttontextcolorcancel'] = 'Aufhebe-Schaltfläche, Textfarbe';
$string['buttontextcolordesc'] = 'Die Farbe des Textes auf den Schaltflächen.';
$string['buttontextcolordesccancel'] = 'Die Farbe des Textes, die auf den Schaltflächen-Aufheben verwendet wird.';
$string['buttontextcolordescscnd'] = 'Die Farbe des Textes, der auf sekundären Schaltflächen verwendet wird.';
$string['buttontextcolorscnd'] = 'Sekundäre Schaltfläche, Textfarbe';
$string['categoryhavecustomheader'] = 'Kategorie benutzerdefinierte Kopfzeile';
$string['categoryhavecustomheaderdesc'] = 'Wählen Sie die Kategorien der obersten Ebene aus, die eine benutzerdefinierte Kopfzeile erhalten sollen.  Um mehr als eine auszuwählen oder die Auswahl einer Kategorie aufzuheben, drücken Sie die Taste "Strg".  Speichern Sie und rufen Sie die Seite erneut auf, um sie zu aktualisieren Hinweis: Die Unterkategorien der ausgewählten Kategorien übernehmen die Einstellungswerte.';
$string['categoryheaderbgimage'] = 'Kategorie \'{$a->name}\' mit id \'{$a->id}\' Hintergrundbild';
$string['categoryheaderbgimagedesc'] = 'Legen Sie ein Hintergrundbild für die oberste Kategorie \'{$a->name}\' mit der ID \'{$a->id}\' in der Kopfzeile fest.  Die Mindestgröße beträgt 1600x180px (1900x180px empfohlen).  Das Bild wird die gesamte Kopfzeile abdecken.';
$string['categoryheaderbgimagedescchildren'] = 'Legen Sie ein Hintergrundbild für die oberste Kategorie "{$a->name}" mit der ID "{$a->id}" und den darunter folgenden Kinder, "{$a->children}" in der Kopfzeile fest.  Die Mindestgröße beträgt 1600x180px (1900x180px empfohlen).  Das Bild soll die gesamte Kopfzeile abdecken. test';
$string['categoryheadercustomcss'] = 'Kategorie \'{$a->name}\' mit id \'{$a->id}\' benutzerdefiniertes CSS';
$string['categoryheadercustomcssdesc'] = 'Legen Sie benutzerdefiniertes CSS für die oberste Kategorie "{$a->name}" mit der ID "{$a->id}" fest.  Dadurch wird CSS für den Themenselektor mit dem Präfix \'.category-{$a->id}\' erzeugt.  Wenn das CSS nicht angewendet zu werden scheint, überprüfen Sie die PHP-Protokolldatei.';
$string['categoryheadercustomcssdescchildren'] = 'Legen Sie benutzerdefiniertes CSS für die oberste Kategorie "{$a->name}" mit der ID "{$a->id}" und ihre Kinder "{$a->children}" fest.  Dies erzeugt CSS für den Themenselektor mit dem Präfix ".category-{$a->id}" und für alle Kind-Ids.  Wenn das CSS nicht angewendet zu werden scheint, überprüfen Sie die PHP-Protokolldatei.';
$string['colorsettings'] = 'Farben';
$string['colorsettingsheading'] = 'Mit diesen Einstellungen können Sie die Farben für das Design anpassen.';
$string['configtitle'] = 'Adaptable';
$string['coursesectionbordercolor'] = 'Kursabschnitt Randfarbe';
$string['coursesectionbordercolordesc'] = 'Wählen Sie die Randfarbe der Kursabschnitte.';
$string['coursesectionborderradius'] = 'Kursabschnitt Rand-Radius';
$string['coursesectionborderradiusdesc'] = 'Wählen Sie den Radius der Kursabschnittsgrenzen (runde Ecken).';
$string['coursesectionborderstyle'] = 'Kursabschnitt Rand-Typ';
$string['coursesectionborderstyledesc'] = 'Wählen Sie den Rand-Typ für die Kursabschnitte.';
$string['coursesections'] = 'Kursabschnitte';
$string['coursesettings'] = 'Kursformate';
$string['coursesettingsheading'] = 'Kursformat: Einstellungen';
$string['coursetitlefullname'] = 'Vollständiger Kursname';
$string['coursetitleshortname'] = 'Kurzer Kursname';
$string['customcss'] = 'Änderungen für CSS';
$string['displayloginbutton'] = 'Taste';
$string['displayloginno'] = 'Kein Login';
$string['enableanalyticsdesc'] = 'Google Analytics für die Moodleseite aktivieren.';
$string['enableavailablecourses'] = 'Verfügbare Kurse anzeigen';
$string['enableavailablecoursesdesc'] = 'Das Label / die Überschrift für die verfügbaren Kurse auf der Startseite anzeigen';
$string['enableeditprofile'] = 'Profil bearbeiten';
$string['enablegrades'] = 'Noten';
$string['enablehomedesc'] = 'Einen Link zur Startseite anzeigen';
$string['enablemy'] = 'Dashboard';
$string['enablenote'] = 'Benachrichtigungen';
$string['enableposts'] = 'Meine Beiträge';
$string['enablepostsdesc'] = 'Einen Link zur Meine-Beiträge-Seite anzeigen';
$string['enablepref'] = 'Favoriten';
$string['enableprefdesc'] = 'Einen Link anzeigen zur Favoritenseite des Nutzers';
$string['enableprivatefiles'] = 'Meine Dateien';
$string['enableprivatefilesdesc'] = 'Einen Link zu \'Meinen Dateien\' des Nutzers anzeigen';
$string['enableprofile'] = 'Nutzerprofil';
$string['enableprofiledesc'] = 'Einen Link zum Nutzerprofil anzeigen';
$string['enableshowhideblocks'] = '"Blöcke verbergen" anzeigen';
$string['enableshowhideblocksdesc'] = 'Nutzer/innen erlauben, alle Blöcke zu verbergen und anzeigen zu lassen';
$string['enablezoomdesc'] = 'Nutzer/innen können zwischen fester Breite und voller Breite wechseln.';
$string['events'] = 'Termine';
$string['footerlayoutrowdesc'] = 'Layout für Blockbereiche im  Footer';
$string['frnt-footer'] = 'Blöcke in diesem Bereich sind ausschließlich für Administratoren sichtbar.';
$string['frontpageblocksenabled'] = 'Blockbereich auf der Startseite aktivieren';
$string['frontpageblocksenableddesc'] = 'Sie können Blockbereiche auf der Startseite aktivieren oder deaktivieren.
Dann können Sie Blöcke in die Bereiche ziehen, die Sie erstellt haben.';
$string['frontpageblocksettings'] = 'Marketingblöcke';
$string['frontpagecoursesettings'] = 'Kurse der Startseite';
$string['frontpagedesc'] = 'Die Art und Weise einstellen wie die Kursboxen auf der Startseite gerendert werden.';
$string['frontpagemarketenabled'] = 'Marketingblöcke aktivieren';
$string['frontpagemarketenableddesc'] = 'Die Marketingblöcke auf der Startseite setzen.';
$string['frontpagemarketoption'] = 'Mit diesen Einstellungen wählen Sie aus Aussehen der Marketingblöcke.';
$string['frontpagerenderer'] = 'Startseite: Kursboxen';
$string['frontpagesettingsheading'] = 'Startseite: Rendern';
$string['frontpageslidersettings'] = 'Startseite: Slider';
$string['fullscreen'] = 'Volle Breite';
$string['fullscreenwidth'] = 'Volle Breite des Browserfensters';
$string['headerdesc'] = 'Laden Sie Ihr Favicon und Logo hoch, setzen Sie ein Login-Formular im Header und passen Sie die Titel im Header an.<br />
<strong>Sie können die Schriftgröße und Styles für die Titel in den "Schrift"-Einstellungen setzen.</strong>';
$string['hide'] = 'Verstecken';
$string['home'] = 'Startseite';
$string['homebk'] = 'Startseite: Hintergrundbild';
$string['infobox'] = 'Startseite: Infobox';
$string['infobox2'] = 'Startseite: zweite Infobox';
$string['infobox2desc'] = 'Zweite Infobox der Startseite (<a href="./../theme/adaptable/README.txt" target="_blank">README</a> Datei anschauen für weiter Hinweise ).';
$string['infoboxdesc'] = 'HTML der Infobox der Startseite (<a href="./../theme/adaptable/README.txt" target="_blank">README</a> Datei für weitere Hinweise anschauen).';
$string['layoutcount2'] = 'Blockbereiche. Sie nutzen derzeit:';
$string['linkhover'] = 'Link-Hoverfarbe';
$string['loadingcolor'] = 'Ladefarbe';
$string['logintextbutton'] = 'Login';
$string['marketblocksbackgroundcolor'] = 'Hintergrundfarbe der Marketingblöcke';
$string['marketblocksbackgroundcolordesc'] = 'Die Hintergrundfarbe der Marketingblöcke setzen.';
$string['marketingbuilderdesc'] = 'Nutzen Sie das Tool unten, um die Marketing Blöcke zu definieren. Wenn diese einmal gesetzt sind, erscheinen sie weiter unten auf dieser Seite.';
$string['marketingsettings'] = 'Marketingblöcke';
$string['menuoverrideprofilefielddefault'] = 'Hauptmenüeinstellungen';
$string['menusdesc'] = '(…)';
$string['menusession'] = 'Zugangsdaten während der Sitzung speichern.';
$string['menusessiondesc'] = 'Für einen störungsfreien Ablauf wird empfohlen, dies zu aktivieren. Sie können es im Testlauf deaktivieren.';
$string['menusessionttl'] = 'Minuten, um Zugangsregeln während der Sitzung zu speichern';
$string['menusessionttldesc'] = 'Anzahl der Minuten, nach denen die Menü-Zugangsregeln aktualisiert werden (während der Sitzung des Nutzers).';
$string['menusettings'] = 'Kopfzeilen Menüs';
$string['menusettingsheading'] = 'Passen Sie die Menüs in der Kopfzeile der Kopfzeile dieses Themes an.';
$string['menusheading'] = 'Navigation konfigurieren für die Link-Menüs in der oberen Kopfzeile';
$string['menusheadingvisibility'] = 'Allgemeine Einstellungen für die Sichtbarkeit des Hauptmenüs';
$string['menusheadingvisibilitydesc'] = 'Mit den folgenden Einstellungen können Sie kontrollieren, wo Menüs auftauchen, und optional kann hier Nutzern erlaubt werden, ihre Einstellungen anzupassen.';
$string['menuuseroverride'] = 'Dem Nutzer \'Überspringen\' erlauben';
$string['menuuseroverridedesc'] = 'Diese Einstellungen können genutzt werden, um Nutzer/innen die Kontrolle darüber zu geben wo Menüs angezeigt werden. Um die Option zu nutzen, müssen Sie ein Profilfeld im Listenformat anlegen mit Werten in der folgenden Anordnung:
<pre>1. Überall (das erste Element in der Liste gilt für die Sichtbarkeit des Menüs auf allen Seiten)
2. Startseite (das zweite Element auf der Liste gilt für die Sichtbarkeit nur auf der Startseite oder einzelner Seite)
3. Versteckt (das dritte Element dieser Liste wird Menüs komplett verstecken)</pre>
Sie sollten NICHT die Option "Menüs auf Kursseiten deaktivieren" nutzen, in Verbindug mit Profileinstellungen. Setzen Sie stattdessen den Wert für die  Voreinstellung auf "nur Startseite".';
$string['mobilemenubkcolor'] = 'Wählen Sie eine Hintergrundfarbe auf Mobilgeräten';
$string['mobilemenubkcolordesc'] = 'Wählen Sie eine Hintergrundfarbe für das Hauptmenü auf Mobilgeräten (reduziert)';
$string['moodledocs'] = 'Moodle Docs-Link';
$string['moodledocsdesc'] = 'Den Moodle Docs-Link in der Fußzeile anzeigen.';
$string['myblogs'] = 'Meine Blogs';
$string['mysites'] = 'Meine Kurse';
$string['mysitesdisabled'] = 'Deaktivieren';
$string['mysitesexclude'] = 'Aktivieren (außer verborgene Kurse)';
$string['mysitesinclude'] = 'Aktivieren (auch verborgene Kurse)';
$string['newmenurequirelogin'] = 'Log-In erforderlich';
$string['newmenutitledefault'] = 'Menü';
$string['nextsection'] = 'Nächster Abschnitt';
$string['noenrolments'] = 'Keine Einschreibungen gefunden.';
$string['pastcourses'] = 'Frühere Kurse';
$string['people'] = 'Personen';
$string['piwikimagetrackdesc'] = 'Image-Tracking aktivieren, falls für die Website ein Browser mit deaktiviertem Javascript verwendet wird.';
$string['previoussection'] = 'Vorheriger Abschnitt';
$string['region-side-post'] = 'rechts';
$string['region-side-pre'] = 'links';
$string['settingsanalytics'] = 'Analytics';
$string['settingsfonts'] = 'Schriften';
$string['settingsinfoboxcolors'] = 'Farben für Infobox';
$string['settingsmaincolors'] = 'Hauptfarben';
$string['settingsmarketingcolors'] = 'Farben für Marketingblöcke';
$string['settingsnavbarcolors'] = 'Farben für die Navigation (navbar)';
$string['settingssecondinfoboxcolors'] = 'Farben für zweite Infobox';
$string['showfooterblocks'] = 'Fußbereichsblöcke anzeigen';
$string['showfooterblocksdesc'] = 'Vier konfigurierbare Blöcke in Fußbereich anzeigen';
$string['sitetitle'] = 'Namen der Website anzeigen';
$string['sitetitledesc'] = 'Den standardmäßigen Seitentitel von Moodle anzeigen aus den <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Einstellungen der Startseite</a> oder einen Seitentitel in der Box hier unten eingeben. Wenn Sie ein Logo einfügen wird der Titel nicht angezeigt.';
$string['sitetitleoff'] = 'Namen der Website deaktivieren';
$string['sitetitletext'] = 'Name der Website';
$string['slideroption2desc'] = 'Slidertyp wählen <strong>dann auf SPEICHERN klicken </strong>, um die Einstellungen für die Farben zu sehen.';
$string['socialsearchicon'] = 'Moodle durchsuchen';
$string['standardview'] = 'Feste Breite';
$string['tabbedlayouttablabelcourse'] = 'Kursinhalt';
$string['tabbedlayouttablabelcourse1'] = 'Registerkarte eins';
$string['tabbedlayouttablabelcourse2'] = 'Registerkarte zwei';
$string['tabbedlayouttablabeldashboard1'] = 'Registerkarte eins';
$string['tabbedlayouttablabeldashboard2'] = 'Registerkarte zwei';
$string['targetnewwindow'] = 'neues Fenster';
$string['targetsamewindow'] = 'gleiches Fenster';
$string['thiscourse'] = 'Dieser Kurs';
$string['ticker'] = 'Ankündigungen';
$string['tilescontactstitledesc'] = 'Rollen für Kurskontakte anzeigen. Wenn die Rollen nicht sichtbar sind, wird ein Icon vor jedem Kontakt angezeigt.';
$string['tilesshowcontactsdesc'] = 'Kurskontakte anzeigen';
$string['toolsmenudesc'] = 'Fügen Sie ein Dropdown-Menü zur Hauptnavigationsleiste hinzu';
$string['toolsmenufield'] = 'Nutzerprofil Feld Name = Wert (optional)';
$string['toolsmenufielddesc'] = 'Fügen Sie eine Zugangsregel für das Nutzerprofil hinzu, zum Beispiel: usertype=student';
$string['toolsmenuheading'] = 'Werkzeugmenü';
$string['toolsmenuscount'] = 'Anzahl der Werkzeugmenüs';
$string['toolsmenuscountdesc'] = 'Legen Sie die Anzahl der Werkzeugmenüs fest, die Sie zu der Hauptnavigationsleiste hinzufügen wollen';
$string['toolsmenutitle'] = 'Werkzeugmenü Titel';
$string['toolsmenutitledefault'] = 'Werkzeuge';
$string['toolsmenutitledesc'] = 'Fügen Sie den den Titel des Menüs hinzu, welches in der Hauptnavigationsleiste angezeigt werden soll';
$string['topmenuscount'] = 'Anzahl der Hauptmenüs';
