<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certification', language 'no', version '5.0'.
 *
 * @package     tool_certification
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handling';
$string['actions'] = 'Handlinger';
$string['active'] = 'Aktiv';
$string['activecertifications'] = 'Aktive sertifiseringer';
$string['afteractualcertcompletion'] = 'Etter gjeldende sertifiseringsfullføring';
$string['afteractualcertcompletionwithrelativedate'] = '{$a} etter gjeldende sertifiseringsfullføring';
$string['afterallocationdate'] = 'Etter tildelingsdato';
$string['afterallocationdatewithrelativedate'] = '{$a} etter tildelingsdato';
$string['aftercompletion'] = 'Etter fullføring';
$string['aftercompletionwithrelativedate'] = '{$a} etter fullføring';
$string['afterduedate'] = 'Etter frist';
$string['afterduedatewithrelativedate'] = '{$a} etter fristen';
$string['afterlatest'] = 'Etter sistnevnte av nåværende fullføring eller utløp';
$string['afterlatestwithrelativedate'] = '{$a} etter sistnevnte av gjeldende fullføring eller utløp';
$string['afterpreviouscertexpdate'] = 'Etter forrige utløpte sertifisering';
$string['afterpreviouscertexpdatewithrelativedate'] = '{$a} etter forrige utløpsdato for sertifisering';
$string['afterstartdate'] = 'Etter startdato';
$string['afterstartdatewithrelativedate'] = '{$a} etter startdato';
$string['allocatetocertification'] = 'Tildel til sertifisering';
$string['allocatetocertifications'] = 'Tildel sertifiseringer';
$string['allocateusers'] = 'Tildel brukere';
$string['allocateuserstocertification'] = 'Legg til brukere i sertifiseringer';
$string['allocationdate'] = 'Tildelingsdato';
$string['allocationdateisonorafter'] = 'Tildelingsdato på eller etter';
$string['allocationdefaultvalue'] = 'Samme som definert i sertifiseringer (standard)';
$string['allocationenddate'] = 'Sluttdato for tildeling';
$string['allocationfor'] = 'Tildeling for \'{$a}\'';
$string['allocationsource'] = 'Tildelingskilde';
$string['allocationstartdate'] = 'Startdato for tildeling';
$string['allocationwindowenddate'] = 'Sluttdato';
$string['allocationwindowenddate_help'] = 'Sluttdato for tildelingsperioden';
$string['allocationwindowendedon'] = 'Tildelingsvinduet for denne sertifiseringen utløp {$a}.';
$string['allocationwindowstartdate'] = 'Startdato';
$string['allocationwindowstartdate_help'] = 'Startdato for tildelingsperioden';
$string['allocationwindowstartson'] = 'Tildelingsvinduet for denne sertifiseringen starter {$a}.';
$string['archive'] = 'Arkivér';
$string['archived'] = 'Arkivert';
$string['archivedcertifications'] = 'Arkiverte sertifiseringer';
$string['archivedconfirmation'] = 'Er du sikker på at du vil arkivere sertifiseringen \'{$a}\'?  Arkiverte sertifiseringer vil ikke lenger bli tilgjengelige for superbrukere eller brukere og kan bare vises i historiske rapporter.';
$string['archivedon'] = 'Arkivert den';
$string['autocreategroups'] = 'Legg til i kursgrupper';
$string['autocreategroups_help'] = 'Når brukere er påmeldt programkursene, kan de automatisk legges til samme gruppe. I tilfelle hvor "for denne sertifiseringen" er valgt, vil en egen gruppe for denne sertifiseringen bli brukt, og den vil være forskjellig fra de andre sertifiseringene som bruker samme program.';
$string['autocreategroupsasinprogram'] = 'Som definert i programmet';
$string['autocreategroupscertification'] = 'Lag grupper for denne sertifiseringen';
$string['becamecertified'] = 'Ble sertifisert ({$a})';
$string['beforepreviouscertexpdate'] = 'før forrige utløpsdato for sertifisering';
$string['calendarduedate'] = 'Sertifiseringsfrist for {$a}';
$string['calendarexpirydate'] = 'Utløpsdato for sertifisering {$a}';
$string['certification'] = 'Sertifisering';
$string['certification:allocateuser'] = 'Tillatelse til å tildele brukere';
$string['certification:configurecustomfields'] = 'Konfigurer tilpassede felt for sertifiseringer';
$string['certification:edit'] = 'Tillat å redigere';
$string['certificationdates'] = 'Datoer';
$string['certificationdates_help'] = 'Velg aktuelle datoer for denne sertifiseringstildelingen:

* **Samme som definert i sertifisering:** Den vil benytte datoene definert i sertifiseringene.
* **Velg dato:** Du kan velge datoer (start, forfall) for denne sertifiseringstildelingen.';
$string['certificationfullname'] = 'Sertifiseringens fulle navn';
$string['certificationfullname_help'] = 'Sertifiseringens fulle navn';
$string['certificationidnumber'] = 'Sertifiseringens ID nummer';
$string['certificationidnumber_help'] = 'ID-nummeret for en sertifisering brukes bare i forbindelse med treff relatert til eksterne systemer og vil ikke vises noe sted på portalen. Hvis sertifiseringen har en offisiell kode kan den skrives inn, ellers kan du la feltet være tomt.';
$string['certificationname'] = 'Sertifiseringens navn';
$string['certificationnamewitheditlink'] = 'Sertifiseringsnavn med lenke for redigering';
$string['certificationprogress'] = 'Sertifiseringsfremdrift';
$string['certificationprogressexport'] = '{$a} sertifiseringsfremgang';
$string['certificationrules'] = 'Sertifiseringsregler';
$string['certifications'] = 'Sertifiseringer';
$string['certificationscustomfield'] = 'Tilpassede felt for sertifiseringer';
$string['certificationslink'] = '<a href="{$a->href}">{$a->count} sertifisering</a>';
$string['certificationslink_plural'] = '<a href="{$a->href}">{$a->count} sertifiseringer</a>';
$string['certificationstatus'] = 'Sertifiseringsstatus';
$string['certificationstatus_help'] = 'Status for gjeldende sertifisering';
$string['certificationtags'] = 'Sertifiseringstagger';
$string['certificationtags_help'] = 'Tagger for denne sertifiseringern';
$string['certificationtenant'] = 'Sertifiserings-tenant';
$string['certificationuserlog'] = '{$a} aktivitetslogg';
$string['certificationuserlogempty'] = 'Det er ingen hendelseslogger for denne brukersertifiseringen.';
$string['certificationuserlogfilename'] = '{$a->user} aktivitetslogg for {$a->certification}';
$string['certified'] = 'Sertifisert';
$string['certifiedandrevoked'] = 'Sertifisert og tilbakekalt';
$string['certifiedby'] = 'Sertifisert av';
$string['certifiedcertificationslink'] = '<a href="{$a->href}">Sertifiserte godkjenninger: {$a->count}</a>';
$string['certifieddate'] = 'Sertifiseringsdato';
$string['certifieddateisonorafter'] = 'Sertifiseringsdato på eller etter';
$string['certifiednotification'] = 'Brukeren er sertifisert';
$string['certifiedtype'] = 'Sertifiseringstype';
$string['certify'] = 'Sertifisere';
$string['certifycertifieddate'] = 'Sertifiseringsdato';
$string['certifycertifieddate_help'] = 'Velg en sertifiseringsdato (dagens dato eller tidligere) for denne brukeren.';
$string['certifyexpirydate'] = 'Utløpsdato';
$string['certifyexpirydate_help'] = 'Velg en utløpsdato for denne sertifiserte brukeren mellom "Standard" (bruker da standardinnstillingene), "Aldri" eller en egendefinert dato.';
$string['certifyuser'] = 'Sertifiser bruker';
$string['completedtheprogram'] = 'Fullførte programmet {$a}';
$string['conditioncertificationcertified'] = 'Sertifisering godkjent';
$string['conditioncertificationcertifieddescription'] = 'Brukere som er sertifisert i sertifiseringen \'{$a->fullname}\'';
$string['conditioncertificationcertifieddescriptionall'] = 'Brukere som har status Sertifisert i alle følgende sertifiseringer: \'{$a->fullname}\'';
$string['conditioncertificationcertifieddescriptionallwithdate'] = 'Brukere som har statusen Sertifisert i alle følgende sertifiseringer: \'{$a->fullname}\'<br />
Sertifisert dato er på eller etter \'{$a->conditiondate}\'';
$string['conditioncertificationcertifieddescriptionany'] = 'Brukere som er sertifisert i minst én av følgende sertifiseringer: \'{$a->fullname}\'';
$string['conditioncertificationcertifieddescriptionanywithdate'] = 'Brukere som er sertifisert i minst én av følgende sertifiseringer: \'{$a->fullname}\'<br />
Sertifiseringsdatoen er på eller etter \'{$a->conditiondate}\'';
$string['conditioncertificationcertifieddescriptiononrecert'] = 'Utfør for hver resertifisering';
$string['conditioncertificationcertifieddescriptionstatusonly'] = 'Utfør kun ved statusendring';
$string['conditioncertificationcertifieddescriptionwithdate'] = 'Brukere som har status Sertifisert i sertifiseringen \'{$a->fullname}\'<br />
Sertifiseringsdato er på eller etter \'{$a->conditiondate}\'';
$string['conditioncertificationcertifiedonrecert'] = 'Utfør alltid handlinger på alle resertifiseringer';
$string['conditioncertificationcertifiedonrecert_help'] = 'Dette vil effektivt endre betingelsen til <b>"Bruker er sertifisert og re-sertifiseringsperioden er ikke åpen"</b>. Dette vil sikre at brukeren blir merket som "umatchet" når resertifiseringen åpner, og handlingene utføres for dem igjen når programmet er fullført, selv om de fortsetter å være sertifisert hele tiden.';
$string['conditioncertificationcertifiedstatusonly'] = 'Utfør bare handlinger når brukerstatusen endres fra "ikke sertifisert" til "sertifisert"';
$string['conditioncertificationcertifiedstatusonly_help'] = 'I dette tilfellet kan handlingene utføres eller ikke utføres ved re-sertifisering, avhengig av om den forrige sertifiseringen har utløpt eller ikke. For å være sikker på at handlinger <b>aldri</b> blir utført under resertifisering, bør du vurdere å angi "Regelhandlingsgrensen" i regelinnstillingene.';
$string['conditioncertificationexpired'] = 'Sertifisering utløpt';
$string['conditioncertificationexpireddescription'] = 'Brukere hvis sertifisering \'{$a}\' er utløpt';
$string['conditioncertificationexpireddescriptionwithdate'] = 'Brukere som har status Utløpt i sertifiseringen \'{$a->fullname}\'<br />
Utløpsdato er på eller etter \'{$a->conditiondate}\'';
$string['conditioncertificationnotcertified'] = 'Sertifisering ikke godkjent';
$string['conditioncertificationnotcertifieddescription'] = 'Brukere som ikke er sertifisert i sertifiseringen \'{$a}\'';
$string['conditioncertificationoverdue'] = 'Sertifisering forfalt';
$string['conditioncertificationoverduedescription'] = 'Brukere som er forsinket i sertifiseringen \'{$a}\'';
$string['conditioncertificationoverduedescriptionwithdate'] = 'Brukere med status Forfalt i sertifiseringen  \'{$a->fullname}\'<br />
Forfalt-dato er på eller etter \'{$a->conditiondate}\'';
$string['conditioncertificationsuspended'] = 'Sertifiseringen er suspendert';
$string['conditioncertificationsuspendeddescription'] = 'Brukere som er suspendert i sertifiseringen «{$a}»';
$string['conditioncertificationsuspendeddescriptionwithdate'] = 'Brukere som har status Suspendert i sertifiseringen \'{$a->fullname}\'<br />
Suspenderingsdato er på eller etter \'{$a->conditiondate}\'';
$string['conditionrecertificationgraceperiod'] = 'Gyldighetsperiode for resertifisering avsluttes';
$string['conditionrecertificationgraceperiodendsdescription'] = 'Brukere hvis henstandsperiodeperiode ender med sertifisering \'{$a->fullname}\'';
$string['conditionrecertificationgraceperiodendsdescriptionwithdate'] = 'Brukere hvor henstandsperioden utløper i sertifiseringen \'{$a->fullname}\'<br />
Resertifiseringsperioden utløper på eller etter \'{$a->conditiondate}\'';
$string['conditionrecertificationstarted'] = 'Resertifiseringsperioden startet';
$string['conditionrecertificationstarteddescription'] = 'Brukere som har startet en resertifiseringsperiode i sertifiseringen \'{$a->fullname}\'';
$string['conditionrecertificationstarteddescriptionwithdate'] = 'Brukere som har startet resertifisering for sertifiseringen \'{$a->fullname}\'<br />
Resertifisering startet på eller etter \'{$a->conditiondate}\'';
$string['conditionuserallocated'] = 'Brukere tildelt for sertifisering';
$string['conditionuserallocateddescription'] = 'Brukere tildelt sertifisering {$a}';
$string['conditionuserallocateddescriptionwithdate'] = 'Brukere tildelt sertifiseringen {$a->fullname}<br />
Tildelingsdato er på eller etter \'{$a->conditiondate}\'';
$string['conditionusernotallocated'] = 'Brukere som ikke er tildelt sertifisering';
$string['conditionusernotallocateddescription'] = 'Brukere som ikke er tildelt sertifisering {$a}';
$string['confirmdeallocateusers'] = 'Denne handlingen vil slette tildeling og tilknyttede data for alle valgte brukere. Denne handlingen kan ikke angres.';
$string['confirmdeallocateusersheader'] = 'Fradelte brukere';
$string['confirmdeletecertification'] = 'Er du sikker på at du vil slette sertifisering {$a} med tilhørende data? Denne handlingen kan ikke angres.';
$string['confirmdeleteuserallocation'] = 'Er du sikker på at du vil slette tildelingen av bruker \'{$a}\' med tilhørende data? Denne handlingen kan ikke angres.';
$string['confirmduplicate'] = 'En kopi av sertifiseringen med dens innstillinger vil bli opprettet og du vil kunne endre program og andre egenskaper. Ingen brukertildelinger blir med over i kopien.';
$string['content'] = 'Innhold';
$string['criteriaall'] = 'Alle de utvalgte sertifiseringene er sertifisert';
$string['criteriaany'] = 'Minst én av de valgte sertifiseringene er sertifisert';
$string['criteriaany_help'] = 'Når en bruker allerede er sertifisert i en av sertifiseringene, vil ikke sertifisering i den andre sertifiseringen utløse handlingene igjen';
$string['criteriaeach'] = 'Hver gang en bruker er sertifisert i noen av de valgte sertifiseringene';
$string['criteriaeach_help'] = 'Tilsvarer å lage flere regler, én for hver av de valgte sertifiseringene';
$string['currentcertification'] = 'Nåværende sertifisering';
$string['currentprogram'] = 'Gjeldende program';
$string['currentprogram_help'] = 'Dette er det gjeldende programmet denne brukeren tar';
$string['currentprogramprogress'] = 'Programprogresjon';
$string['currentprogramstatus'] = 'Programstatus';
$string['dateoverrided'] = 'Dato overstyrt';
$string['dayssinceallocation'] = 'Dager siden tildeling';
$string['daystakingcertification'] = 'Dager siden sertifisering';
$string['deallocateusers'] = 'Fradel brukere';
$string['default'] = 'Standard';
$string['deleteallocation'] = 'Slett tildeling';
$string['deleteuserallocation'] = 'Slett brukertildeling';
$string['displaycertificationdate'] = 'Sertifiseringsdato';
$string['displaycertificationduedate'] = 'Sertifiseringsfrist';
$string['expired'] = 'Utløpt';
$string['recertgraceperiodends'] = 'Henstandsperioden avsluttes';
$string['recertification'] = 'Resertifisering';
$string['recertificationgraceperiodendsonorbefore'] = 'Henstandsperioden for resertifisering slutter på eller før';
$string['recertificationprogram'] = 'Resertifiseirngsprogram';
$string['recertificationprogram_help'] = 'Velg et program som skal brukes i resertifiseringen. Dette programmet må være forskjellig fra det opprinnelige sertifiseringsprogrammet.';
$string['recertificationstartdate'] = 'Startdato for resertifisering';
$string['recertificationstartedonorafter'] = 'Resertifisering startet på eller etter';
$string['recertstartdaterelative'] = 'Startdato';
$string['recertstartdaterelative_help'] = 'Dette er datoen da resertifiseringsprogrammet begynner å være tilgjengelig for brukeren.';
$string['recertstartdatewarning'] = 'På denne datoen tilbakestilles resertifiseringsprogrammet. Forsikre deg om at brukere ikke er påmeldt programkursene andre steder, blir tildelt direkte til det samme programmet eller tildelt via andre sertifiseringer, fordi de kan miste fremgangen.';
$string['reg_wpcertifications'] = 'Antall sertifiseringer ({$a})';
$string['requirerecertification'] = 'Krev resertifisering';
$string['requirerecertification_help'] = 'Velg "Ja" for å aktivere resertifisering for denne sertifiseringen.';
$string['resetadditionalcourses'] = 'Tilbakestill tilleggskurs';
$string['resetadditionalcourses_help'] = 'Tilbakestiller kursene som er en del av det nye programmet som ikke var en del av det gamle programmet';
$string['restore'] = 'Gjenopprett';
$string['revokecertification'] = 'Tilbakekall sertifisering';
$string['revoked'] = 'Opphevet';
$string['revokedby'] = 'Opphevet av';
$string['revokednotification'] = 'Sertifiseringen er trukket tilbake.';
$string['revokedon'] = 'Opphevet';
$string['revokedthisuser'] = 'Sertifiseringen for {$a} er trukket tilbake';
$string['revokewarning'] = 'Er du sikker på at du vil tilbakekalle sertifiseringen fra \'{$a}\'? Utmerkelser som kan ha blitt tildelt ved fullføring vil ikke bli tilbakekalt.';
$string['rolemanager'] = 'Sertifiseringsadministrator';
$string['rolemanagerdescription'] = 'Tillater å opprette og administrere sertifiseringer innen gjeldende organisasjon og tildele brukere til dem.';
$string['schedule'] = 'Sertifiseringsdatoer';
$string['selectactiveandarchivedcertifications'] = 'Velg aktive og arkiverte sertifiseringer';
$string['selectadifferentprogram'] = 'Velg et annet program';
$string['selectallactivecertifications'] = 'Velg alle aktive sertifiseringer';
$string['selectallcertificationsinthisfile'] = 'Velg alle sertifiseringer i denne fila';
$string['selectatleastonecertification'] = 'Velg minst en sertifisering';
$string['selectcertificationcondition'] = 'Sertifisering';
$string['selectcertificationcondition_help'] = 'Velg sertifiseringen hvor denne betingelsen skal brukes';
$string['selectcertificationoutcome'] = 'Sertifisering';
$string['selectcertificationoutcome_help'] = 'Velg sertifiseringen hvor denne handlingen skal brukes';
$string['selectcertificationstoallocate'] = 'Sertifiseringer';
$string['selectcertificationstoallocate_help'] = 'Velg sertifiseringen brukere skal tildeles';
$string['selectdate'] = 'Velg dato';
$string['selectmanually'] = 'Velg manuelt...';
$string['selectprogram'] = 'Velg program';
$string['selectprogram_help'] = 'Velg et program som skal knyttes til denne sertifiseringen';
$string['separatetenantsingroupswarning'] = 'I kurs som er delt mellom tenants, vil brukere fra hver tenant legges til separate grupper.';
$string['startdate'] = 'Startdato';
$string['startdate_help'] = 'Datoen sertifiseringen starter';
$string['status'] = 'Status';
$string['suspended'] = 'Suspendert';
$string['suspendeddateisonorafter'] = 'Suspendert  på eller etter dato';
$string['system'] = 'System';
$string['tagarea_tool_certification'] = 'Sertifiseringer';
$string['tags'] = 'Tagger';
$string['timecreated'] = 'Opprettet';
$string['timemodified'] = 'Sist endret';
$string['timesuspended'] = 'Suspendert';
$string['toomanycertificationstoshow'] = 'For mange sertifiseringer å vise';
$string['uponcompletion'] = 'Ved ferdigstillelse';
$string['userallocation'] = 'Brukertildeling';
$string['usercompletion'] = 'Brukerfullføring';
$string['userduedate'] = 'Frist';
$string['userduedate_help'] = 'Velg en sertifiseringsfrist for denne brukeren.';
$string['usergotsuspended'] = 'Bruker ble suspendert';
$string['userlist'] = 'Velg brukere';
$string['userlist_help'] = 'Velg brukere som skal tildeles denne sertifiseringen';
$string['users'] = 'Brukere';
$string['usersallocatedsuccess'] = '{$a} brukere ble tildelt';
$string['usersallocationnotavailable'] = 'Brukertildeling er ikke tilgjengelig';
$string['usersdeallocatedsuccess'] = '{$a} bruker(e) ble fradelt';
$string['userseditedsuccess'] = '{$a} bruker(e) ble endret';
$string['usersskipped'] = '{$a} bruker(e) ble utelatt fordi valget ikke var tilgjengelig for dem';
$string['userstartdate'] = 'Startdato';
$string['userstartdate_help'] = 'Velg datoen for når denne brukeren skal kunne starte på sertifiseringen. Denne datoen blir gjeldende kun for denne brukeren.';
$string['userstatus'] = 'Status';
$string['userstatus_help'] = 'Suspendert status vil skjule denne sertifiseringen for denne brukeren, mens Standard status vil vise den.';
$string['viewcertificationuserlog'] = 'Sertifiseringens aktivitetslogg';
