<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_oauth2', language 'pl', version '5.0'.
 *
 * @package     auth_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountexists'] = 'Użytkownik z taką nazwą użytkownika już istnieje na tej stronie. Jeśli jest to twoje konto, zaloguj się, podając swoją nazwę użytkownika i hasło, a następnie dodaj je jako połączone logowanie na swojej stronie preferencji.';
$string['alreadylinked'] = 'To zewnętrzne konto jest już połączone z kontem na tej stronie';
$string['auth_oauth2description'] = 'Uwierzytelnianie oparte na standardzie OAuth 2';
$string['auth_oauth2settings'] = 'Ustawienia uwierzytelniania OAuth 2.';
$string['confirmaccountemail'] = 'Drogi użytkowniku: {$a->firstname},
zgłoszono prośbę o utworzenie nowego konta w serwisie {$a->sitename} z wykorzystaniem Twojego adresu e-mail.

Aby potwierdzić założenie konta, kliknij w ten link: {$a->link}

W większości programów pocztowych powyższy adres powinien być aktywny, Jeżeli nie możesz go kliknąć, skopiuj go i wklej w oknie przeglądarki internetowej.

Jeśli nie rozpoznajesz tej prośby, ktoś inny może próbować włamać się na Twoje konto.
Skontaktuj się natychmiast z administratorem witryny {$a->admin}';
$string['confirmaccountemailsubject'] = '{$a}: potwierdzenie konta';
$string['confirmationinvalid'] = 'Link potwierdzający jest nieprawidłowy lub wygasł. Rozpocznij proces logowania ponownie, aby wygenerować nowy e-mail z potwierdzeniem.';
$string['confirmationpending'] = 'To konto oczekuje na potwierdzenie przez e-mail.';
$string['confirmlinkedloginemail'] = 'Drogi użytkowniku: {$a->firstname},
wysłano prośbę z użyciem Twojego adresu email o połączenie loginu {$a->issuername} {$a->linkedemail} z Twoim kontem w serwisie {$a->sitename}.

Aby potwierdzić tę prośbę i połączyć te loginy, kliknij ten link: {$a->link}

W większości programów pocztowych powyższy adres powinien być aktywny, Jeżeli nie możesz go kliknąć, skopiuj go i wklej w oknie przeglądarki internetowej.

Jeśli nie rozpoznajesz tej prośby, ktoś inny może próbować włamać się na Twoje konto.
Skontaktuj się natychmiast z administratorem witryny {$a->admin}';
$string['confirmlinkedloginemailsubject'] = '{$a}: potwierdzenie połączonego logowania';
$string['createaccountswarning'] = 'Ta wtyczka uwierzytelniania pozwala użytkownikom tworzyć konta w Twojej witrynie. Jeśli korzystasz z tej wtyczki, możesz chcieć włączyć ustawienie "authpreventaccountcreation".';
$string['createnewlinkedlogin'] = 'Powiąż nowe konto ({$a})';
$string['emailconfirmlink'] = 'Powiąż swoje konta';
$string['emailconfirmlinksent'] = 'Znaleziono istniejące konto z tym adresem e-mail, ale nie jest ono jeszcze powiązane. Konta muszą być połączone, zanim będzie można się zalogować. <br>
Na Twój adres <b>{$a}</b> została wysłana wiadomość, która zawiera proste instrukcje powiązania kont. Jeśli masz jakiekolwiek trudności, skontaktuj się z administratorem witryny.';
$string['emailpasswordchangeinfo'] = 'Drogi użytkowniku: {$a->firstname},
ktoś (prawdopodobnie Ty) na stronie {$a->sitename} zażądał wygenerowania nowego hasła dla Twojego konta.

Nie możesz zresetować swojego hasła, ponieważ do logowania używasz konta w innym serwisie.


Jeśli potrzebujesz pomocy, skontaktuj się z administratorem witryny
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Zmień informacje dotyczące hasła';
$string['info'] = 'Zewnętrzne konto';
$string['issuer'] = 'Usługa OAuth 2';
$string['issuernologin'] = 'Tego wystawcy nie można użyć do logowania';
$string['key'] = 'Klucz';
$string['linkedlogins'] = 'Połączone logowania';
$string['linkedloginshelp'] = 'Pomoc z połączonymi logowaniami';
$string['loggedin'] = 'Użytkownik pomyślnie uwierzytelnił się u dostawcy.';
$string['loginerror_authenticationfailed'] = 'Proces uwierzytelniania nie powiódł się.';
$string['loginerror_cannotcreateaccounts'] = 'Nie można znaleźć konta z tym adresem e-mail.';
$string['loginerror_invaliddomain'] = 'Adres e-mail nie jest dozwolony na tej stronie.';
$string['loginerror_nouserinfo'] = 'Nie zwrócono żadnych informacji o użytkowniku. Usługa OAuth 2 może być nieprawidłowo skonfigurowana.';
$string['loginerror_userincomplete'] = 'Zwrócone informacje o użytkowniku nie zawierały nazwy użytkownika i adresu e-mail. Usługa OAuth 2 może być nieprawidłowo skonfigurowana.';
$string['noconfiguredidps'] = 'Brak skonfigurowanych dostawców OAuth2.';
$string['noissuersavailable'] = 'Żadna ze skonfigurowanych usług OAuth2 nie pozwala na połączenie kont logowania';
$string['notenabled'] = 'Przepraszamy, wtyczka uwierzytelniania OAuth 2 nie jest włączona';
$string['notloggedindebug'] = 'Próba logowania nie powiodła się. Powód: {$a}';
$string['notwhileloggedinas'] = 'Nie można zarządzać połączonymi logowaniami, gdy jesteś zalogowany jako inny użytkownik.';
$string['oauth2:managelinkedlogins'] = 'Zarządzaj własnymi połączonymi kontami logowania';
$string['plugindescription'] = 'Ta wtyczka uwierzytelniania wyświetla listę skonfigurowanych dostawców tożsamości na stronie logowania. Wybór dostawcy tożsamości umożliwia użytkownikom logowanie przy użyciu poświadczeń od dostawcy OAuth 2.';
$string['pluginname'] = 'OAuth 2';
$string['privacy:metadata:auth_oauth2'] = 'Uwierzytelnianie OAuth 2';
$string['privacy:metadata:auth_oauth2:authsubsystem'] = 'Ta wtyczka jest podłączona do podsystemu uwierzytelniania.';
$string['privacy:metadata:auth_oauth2:confirmtoken'] = 'Token potwierdzenia.';
$string['privacy:metadata:auth_oauth2:confirmtokenexpires'] = 'Znacznik czasu wygaśnięcia tokenu potwierdzenia.';
$string['privacy:metadata:auth_oauth2:email'] = 'Zewnętrzny adres e-mail mapowany na to konto.';
$string['privacy:metadata:auth_oauth2:tableexplanation'] = 'Konta OAuth 2 połączone z kontem Moodle użytkownika.';
$string['privacy:metadata:auth_oauth2:timecreated'] = 'Znacznik czasu powiązania konta użytkownika z logowaniem OAuth 2.';
$string['privacy:metadata:auth_oauth2:timemodified'] = 'Znacznikk czasu modyfikacji tego rekordu.';
$string['privacy:metadata:auth_oauth2:userid'] = 'Identyfikator konta użytkownika, z którym powiązany jest login OAuth 2.';
$string['privacy:metadata:auth_oauth2:usermodified'] = 'Identyfikator użytkownika, który zmodyfikował to konto.';
$string['privacy:metadata:auth_oauth2:username'] = 'Zewnętrzna nazwa użytkownika przypisana do tego konta.';
$string['testidplogin'] = 'Testuj logowanie za pomocą:';
$string['userinfo'] = 'Dane użytkownika od dostawcy:';
$string['value'] = 'Wartość';
