<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'pl', version '5.0'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Działanie';
$string['actions'] = 'Działania';
$string['addappointment'] = 'Dodaj kolejną osobę';
$string['addcommands'] = 'Dodaj terminy';
$string['addondays'] = 'Dodaj terminy w';
$string['addsession'] = 'Dodaj serię terminów';
$string['addsingleslot'] = 'Dodaj pojedynczy termin';
$string['addslot'] = 'Możesz utworzyć nowe terminy spotkań w dowolnym momencie';
$string['addstudenttogroup'] = 'Dodaj studenta do umówionej grupy';
$string['allappointments'] = 'Wszystkie spotkania';
$string['allononepage'] = 'Wszystkie terminy na jednej stronie';
$string['allowgroup'] = 'Termin dla jednej osoby - kliknij, aby zmienić';
$string['alreadyappointed'] = 'Nie możesz umówić spotkania. Ten termin jest już zajęty.';
$string['appointagroup_help'] = 'Wybierz czy chcesz umówić spotkanie tylko dla siebie czy dla całej grupy.';
$string['appointfor'] = 'Umów spotkanie dla';
$string['appointforgroup'] = 'Umów spotkania dla: {$a}';
$string['appointingstudent'] = 'Spotkanie w ramach terminu';
$string['appointingstudentinnew'] = 'Spotkanie w nowym terminie';
$string['appointment'] = 'Spotkanie';
$string['appointmentmode'] = 'Ustawienie trybu spotkania';
$string['appointmentmode_help'] = '<p>Możesz wybrać sposób umawiania spotkań. </p>
<p><ul>
<li><strong>"<emph>n</emph> spotkań w tym terminarzu":</strong> Student może jedynie umówić ustaloną ilość spotkań w ramach tej aktywności. Nawet jeśli nauczyciel oznaczy, że spotkanie "odbyło się",  student nie będzie mógł rezerwować kolejnych spotkań. Jedynym sposobem zresetowania tej możliwości rezerwacji spotkań przez studenta jest usunięcie istniejących danych dotyczących "odbytych" spotkań.</li>
<li><strong>"<emph>n</emph> spotkań jednocześnie":</strong> Student może umówić ustaloną ilość spotkań. Gdy spotkanie się zakończy i nauczyciel oznaczy, że się "odbyło", student może umówić kolejne spotkania. Jednak student jest ograniczony do <emph>n</emph> "otwartych" (nieodbytych) terminów jednocześnie.
</li>
</ul>
</p>';
$string['appointmentno'] = 'Spotkanie {$a}';
$string['appointmentnote'] = 'Notatki do spotkania (widoczne dla studenta)';
$string['appointments'] = 'Spotkania';
$string['appointmentsgrouped'] = 'Spotkania grupowane według terminu';
$string['appointmentsummary'] = 'Spotkanie dnia {$a->startdate} od {$a->starttime} do {$a->endtime} z {$a->teacher}';
$string['appointsolo'] = 'tylko ja';
$string['appointsomeone'] = 'Dodaj nowe spotkanie';
$string['areaappointmentnote'] = 'Pliki w notatkach ze spotkania';
$string['areaslotnote'] = 'Pliki w notatkach dla terminu';
$string['areateachernote'] = 'Pliki w notatkach prywatnych';
$string['attendable'] = 'Spotkania możliwe do odbycia';
$string['attendablelbl'] = 'Liczba wszystkich potencjalnych osób do umówienia';
$string['attended'] = 'Zrealizowane';
$string['attendedlbl'] = 'Liczba studentów, którzy odbyli spotkania';
$string['attendedslots'] = 'Terminy zrealizowane';
$string['availableslots'] = 'Dostępne terminy';
$string['availableslotsall'] = 'Wszystkie terminy';
$string['availableslotsnotowned'] = 'Organizowane nie przeze mnie';
$string['availableslotsowned'] = 'Organizowane przeze mnie';
$string['bookaslot'] = 'Rezerwuj termin';
$string['bookingdetails'] = 'Szczegóły rezerwacji';
$string['bookingformoptions'] = 'Formularz rezerwacji i informacje od studentów';
$string['bookinginstructions'] = 'Instrukcje rezerwacji';
$string['bookinginstructions_help'] = 'Ten tekst jest wyświetlany studentom zanim dokonają rezerwacji. Może to być na przykład instrukcja dla studentów jak wypełnić opcjonalne pole z wiadomością lub jakie pliki wgrać.';
$string['bookslot'] = 'Zarezerwuj termin';
$string['bookwithteacher'] = 'Nauczyciel';
$string['bookwithteacher_help'] = 'Wybierz nauczyciela dla rezerwacji.';
$string['break'] = 'Przerwa pomiędzy terminami';
$string['breaknotnegative'] = 'Długość przerwy nie może być ujemna.';
$string['canbook1appointment'] = 'Możesz umówić się na jeszcze jedno spotkanie.';
$string['canbooknappointments'] = 'Możesz umówić się na jeszcze {$a} spotkań.';
$string['canbooknofurtherappointments'] = 'Nie możesz umówić się na więcej spotkań.';
$string['canbooksingleappointment'] = 'Możesz umówić się na jedno spotkanie.';
$string['canbookunlimitedappointments'] = 'Możesz umówić się na dowolną liczbę spotkań w tym terminarzu.';
$string['cancelbooking'] = 'Anuluj rezerwację';
$string['chooseexisting'] = 'Wybierz istniejący';
$string['choosingslotstart'] = 'Wybór czasu rozpoczęcia';
$string['choosingslotstart_help'] = 'Zmień (lub wybierz) czas rozpoczęcia spotkania. Jeśli spotkanie koliduje z innymi terminami zostaniesz zapytany czy chcesz, żeby ten termin zastąpił wszystkie kolidujące spotkania. Zwróć uwagę, że parametry nowego terminu nadpiszą wszystkie poprzednie ustawienia.';
$string['comments'] = 'Uwagi';
$string['complete'] = 'Zarezerwowane';
$string['confirmbooking'] = 'Potwierdź rezerwację';
$string['confirmdelete-all'] = 'Nastąpi usunięcie <b>wszystkich</b> terminów w tym terminarzu. Tej operacji nie można cofnąć. Kontynuować?';
$string['confirmdelete-mine'] = 'Nastąpi usunięcie wszystkich Twoich terminów w tym terminarzu. Tej operacji nie można cofnąć. Kontynuować?';
$string['confirmdelete-myunused'] = 'Nastąpi usunięcie wszystkich Twoich pustych terminów w tym terminarzu. Tej operacji nie można cofnąć. Kontynuować?';
$string['confirmdelete-one'] = 'Usunąć termin?';
$string['confirmdelete-selected'] = 'Nastąpi usunięcie wszystkich zaznaczonych terminów. Tej operacji nie można cofnąć. Kontynuować?';
$string['confirmdelete-unused'] = 'Nastąpi usunięcie wszystkich pustych terminów w tym terminarzu. Tej operacji nie można cofnąć. Kontynuować?';
$string['confirmrevoke'] = 'Odwołać wszystkie spotkania w ramach wybranego terminu_';
$string['conflictingslots'] = 'Termin w dniu {$a} nie może zostać utworzony z powodu kolidujących terminów:';
$string['conflictlocal'] = '{$a->datetime} ({$a->duration} minutes) w tym terminarzu';
$string['conflictremote'] = '{$a->datetime} ({$a->duration} minutes) w terminarzu {$a->schedulername} dla kursu {$a->courseshortname}';
$string['contentformat'] = 'Format';
$string['contentformat_help'] = '<p>Są trzy formaty eksportu danych, różniące się sposobem przetwarzania terminów z wieloma spotkaniami.
     <dl>
         <dt>Jednen termin w każdej linii</dt>:
         <dd>
             Plik z danymi wyjściowymi będzie zawierał każdy termin w jednej linijce. Jeśli termin zawiera wiele spotkań, zamiast imienia studenta, itp. wyświetlone zostanie oznaczenie "(wiele)".
         </dd>
         <dt>Jedno spotkanie w każdej linii</dt>:
         <dd>
              Plik z danymi wyjściowymi będzie zawierał każde spotkanie w jednej linijce. Jeśli termin zawiera wiele spotkań, pojawi się wielokrotnie na liście (wraz z powtórzonymi danymi).
         </dd>
         <dt>Spotkania zgrupowane według terminu</dt>:
         <dd>
             Wszystkie spotkania w ramach jednego terminu są zgrupowane, poprzedzone nagłówkiem opisującym wybrany termin. Ten format może nie współpracować z formatem danych wyjściowych typu CSV ponieważ liczba kolumn nie jest stała.
         </dd>
    </dl>
    Możesz podejrzeć jaki jest efekt tych opcji klikają przycisk "Podgląd".</p>';
$string['copytomyself'] = 'Wyślij mi kopię';
$string['course'] = 'Kurs';
$string['createexport'] = 'Utwórz raport';
$string['csvfieldseparator'] = 'Separator pola CSV';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'Łączny czas trwania spotkań';
$string['datatoinclude'] = 'Dane do uwzględnienia w raporcie';
$string['datatoinclude_help'] = 'Wybierz pola, które mają zostać uwzględnione w eksporcie. Każde z nich pojawi się w jednej kolumnie pliku wyjściowego.';
$string['date'] = 'Data';
$string['datelist'] = 'Przegląd';
$string['defaultslotduration'] = 'Domyślna długość terminu spotkań';
$string['defaultslotduration_help'] = 'Domyślna długość (w minutach) dla skonfigurowanych terminów spotkań.';
$string['deleteallslots'] = 'Usuń wszystkie terminy';
$string['deleteallunusedslots'] = 'Usuń niewykorzystane terminy';
$string['deletecommands'] = 'Usuń terminy';
$string['deletedconflictingslots'] = 'Dla terminu w dniu {$a}, kolidujące terminy zostały usunięte:';
$string['deletemyslots'] = 'Usuń wszystkie moje terminy';
$string['deleteonsave'] = 'Usuń spotkanie (przy zapisywaniu tego formularza)';
$string['deleteselection'] = 'Usuń wybrane terminy';
$string['deletetheseslots'] = 'Usuń te terminy';
$string['deleteunusedslots'] = 'Usuń moje niewykorzystane terminy';
$string['department'] = 'Skąd (Wydział)?';
$string['disengage'] = 'Odwołaj wszystkie moje spotkania';
$string['displayfrom'] = 'Pokaż termin spotkania studentom od';
$string['distributetoslot'] = 'Podziel na całą grupę';
$string['divide'] = 'Podzielić na terminy?';
$string['duration'] = 'Czas trwania';
$string['durationrange'] = 'Czas trwania terminu musi być pomiędzy {$a->min} a {$a->max} minut.';
$string['editbooking'] = 'Zmień rezerwację';
$string['email_applied_html'] = '<p>Spotkanie w dniu {$a->date} o {$a->time},<br/>
zostało zarezerwowane przez studenta <a href="{$a->attendee_url}">{$a->attendee}</a> w ramach kursu:

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p>

<p>w terminarzu o nazwie "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" na stronie internetowej: <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = 'Spotkanie w dniu {$a->date} o {$a->time},
zostało zarezerwowane przez studenta {$a->attendee} w ramach kursu:

{$a->course_short}: {$a->course}

przy użyciu terminarza o nazwie "{$a->module}" na stronie internetowej: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Nowe spotkanie';
$string['email_cancelled_html'] = '<p>Twoje spotkanie w dniu <strong>{$a->date}</strong> o <strong>{$a->time}</strong>,<br/>
ze studentem <strong><a href="{$a->attendee_url}">{$a->attendee}</a></strong> w ramach kursu :</p>

<p><strong>{$a->course_short} : <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>przy użyciu terminarza o nazwie "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" na stronie internetowej : <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">zostało odwołane lub przesunięte</span></strong>.</p>';
$string['email_cancelled_plain'] = 'Twoje spotkanie w dniu  {$a->date} o {$a->time},
ze studentem {$a->attendee} w ramach kursu:

{$a->course_short} : {$a->course}

przy użyciu terminarza o nazwie "{$a->module}" na stronie internetowej : {$a->site}

zostało odwołane lub przesunięte.';
$string['email_cancelled_subject'] = '{$a->course_short}: Spotkanie odwołane lub przesunięte przez studenta';
$string['email_invite_html'] = '<p>Wybierz termin spotkania na stronie:</p> <p>{$a->scheduler_url}</p>';
$string['email_invite_subject'] = 'Zaproszenie: {$a->module}';
$string['email_invitereminder_html'] = '<p>To jest przypomnienie, że nadal nie masz zarezerwowanego spotkania. Wybierz termin jak najszybciej pod adresem:</p><p>{$a->scheduler_url}</p>';
$string['email_invitereminder_subject'] = 'Przypomnienie: {$a->module}';
$string['email_reminder_html'] = '<p>Masz nadchodzące spotkanie w dniu <strong>{$a->date}</strong>
od <strong>{$a->time}</strong> do <strong>{$a->endtime}</strong><br/>
z <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>.</p>

<p>Lokalizacja: <strong>{$a->location}</strong></p>';
$string['email_reminder_plain'] = 'Masz nadchodzące spotkanie
w dniu {$a->date} od {$a->time} do {$a->endtime}
z {$a->attendant}.

Lokalizacja: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Przypomnienie o spotkaniu';
$string['email_teachercancelled_html'] = '<p>Twoje spotkanie w dniu strong>{$a->date}</strong> o <strong>{$a->time} </strong>,<br/>
z {$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> w ramach kursu:</p>

<p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>przy użyciu terminarza "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" na stronie internetowej : <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">zostało odwołane</span></strong>. Zarezerwuj nowy termin.</p>';
$string['email_teachercancelled_plain'] = 'Twoje spotkanie w dniu {$a->date} o {$a->time},
z {$a->staffrole} {$a->attendant} w ramach kursu:

{$a->course_short}: {$a->course}

przy użyciu terminarza o nazwie "{$a->module}" na stronie: {$a->site}

zostało odwołane. Zarezerwuj nowy termin.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Spotkanie anulowane przez nauczyciela';
$string['emailreminder'] = 'Wyślij przypomnienie';
$string['emailreminderondate'] = 'Wyślij przypomnienie w dniu';
$string['end'] = 'Koniec';
$string['enddate'] = 'Powtarzaj kolejne terminy aż do';
$string['event_appointmentlistviewed'] = 'Wyświetlono listę spotkań w terminarzu';
$string['event_bookingadded'] = 'Dodano rezerwację w terminarzu';
$string['event_bookingformviewed'] = 'Wyświetlono formularz rezerwacji w terminarzu';
$string['event_bookingremoved'] = 'Usunięto rezerwację w terminarzu';
$string['event_slotadded'] = 'Dodano termin w terminarzu';
$string['event_slotdeleted'] = 'Termin został usunięty';
$string['everyone'] = 'Wszyscy';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Ograniczone';
$string['exclusivity'] = 'Ograniczenie';
$string['exclusivity_help'] = '<p>Możesz ustalić limit liczby studentów, które mogą umówć się na wybrany termin. </p>
<p>Ustawienie limitu 1 (domyślny) oznacza, że tylko jeden student może zapisać się na dany termin.</p>
<p>Ustawienie limitu, np. 3  oznacza, że maksymalnie trzech studentów może zapisać się na dany termin.</p>
<p>Jeśli wyłączysz to ustawienie, dowolna liczba studentów może zapisać się na termin; nigdy nie zostanie oznaczony jako "pełny".</p>';
$string['exclusivityoverload'] = 'Termin ma {$a} zapisanych studentów, więcej niż dozwolone przez tę opcję.';
$string['exclusivitypositive'] = 'Licza studentów na termin musi być conajmniej 1.';
$string['explaingeneralconfig'] = 'Te opcje można ustawić tylko z poziomu całej strony i będą dotyczyć wszystkich terminarzy w ramach tej instalacji Moodle.';
$string['export'] = 'Eksportuj';
$string['exporthdr'] = 'Eksportuj terminy i spotkania';
$string['exporttimerange'] = 'Zakres czasowy';
$string['exporttimerangeall'] = 'Terminy nadchodzące i przeszłe';
$string['exporttimerangefuture'] = 'Tylko nadchodzące terminy';
$string['exporttimerangepast'] = 'Tylko przeszłe terminy';
$string['field-appointmentnote'] = 'Notatki ze spotkania (dla studenta)';
$string['field-attended'] = 'Zrealizowane';
$string['field-date'] = 'Data';
$string['field-endtime'] = 'Czas zakończenia';
$string['field-filecount'] = 'Tylko przeszłe terminy';
$string['field-grade'] = 'Ocena';
$string['field-groupsmulti'] = 'Grupy (podział na kolumny)';
$string['field-groupssingle'] = 'Grupy';
$string['field-groupssingle-label'] = 'Grupy (w jednej kolumnie)';
$string['field-location'] = 'Miejsce';
$string['field-maxstudents'] = 'Maks. liczba studentów';
$string['field-slotnotes'] = 'Notatki do terminu';
$string['field-starttime'] = 'Czas rozpoczęcia';
$string['field-studentemail'] = 'E-mail studenta';
$string['field-studentfirstname'] = 'Imię studenta';
$string['field-studentfullname'] = 'Imię i nazwisko studenta';
$string['field-studentidnumber'] = 'Numer id studenta';
$string['field-studentlastname'] = 'Nazwisko studenta';
$string['field-studentnote'] = 'Wiadomość od studenta';
$string['field-studentusername'] = 'Nazwa użytkownika studenta';
$string['field-teachernote'] = 'Notatka poufna (tylko dla nauczyciela)';
$string['fileformat'] = 'Format pliku';
$string['fileformat_help'] = 'Dostępne są następujące formaty:
     <ul>
          <li>Wartości oddzielone przecinkami (CSV) w pliku tekstowym. Znak oddzielający, domyślnie przecinek, można wybrać poniżej.
               Pliki CSV można otworzyć w większości arkuszy kalkulacyjnych;</li>
          <li>Pliki Microsoft Excel (format Excel 2007);</li>
          <li>Arkusze kalkulacyjne Open Document (ODS);</li>
          <li>Format HTML - strona internetowa wyświetlająca tabelkę z danymi wyjściowymi, które można wydrukować za pomocą wbudowanej funkcji druku w przeglądarce;</li>
          <li>Dokument PDF. Możesz wybrać orientację pionową lub poziomą. </li>
     </ul>';
$string['finalgrade'] = 'Ocena końcowa';
$string['firstslotavailable'] = 'Pierwszy termin zostanie otwarty w dniu: {$a}';
$string['forbidgroup'] = 'Termin grupowy - kliknij, aby zmienić';
$string['forcewhenoverlap'] = 'Wymuś w przypadku kolizji';
$string['forcewhenoverlap_help'] = '<h3>Wymuś utworzenie terminu w przypadku kolizji</h3>
<p>To ustawienie określa co się stanie z nowymi terminami w przypadku kolizji z innymi, już istniejącymi terminami. </p>
<p>Jeśli włączysz tę opcję, kolidujący istniejący termin zostanie usunięty i nowy termin zostanie utworzony .</p>
<p>Jeśli wyłączysz tę opcję, istniejący kolidujący termin zostanie zachowany a nowy termin <em>nie</em> zostanie utworzony.</p>';
$string['forcewhenoverlap_link'] = 'mod/scheduler/conflict';
$string['forcourses'] = 'Wybierz studentów w kursach';
$string['friday'] = 'Piątek';
$string['generalconfig'] = 'Ogólna konfiguracja';
$string['grade'] = 'Ocena';
$string['gradeingradebook'] = 'Ocena w dzienniku ocen';
$string['gradingstrategy'] = 'Sposób oceniania';
$string['gradingstrategy_help'] = 'W terminarzu, w którym studenci mogą mieć kilka spotkań, wybierz sposób agregowania ocen.
  Dziennik ocen może wyświetlać <ul><li>średnią ocenę lub</li><li>najlepszą ocenę</li></ul> uzyskaną przez studenta.';
$string['group'] = 'grupa';
$string['groupbookings'] = 'Rezerwacje grupowe';
$string['groupbookings_help'] = 'Pozwól studentom na umawianie terminów dla wszystkich członków grupy. (Zwróć uwagę, że to ustawienie jest osobnym ustawieniem niż "tryb grupowy", określający które terminy student widzi.)';
$string['groupbreakdown'] = 'Liczebności grup';
$string['groupmodeyourgroups'] = 'Tryb grupowy: {$a->groupmode}. Tylko studenci w grupie {$a->grouplist} mogą umawiać spotkania z Tobą.';
$string['groupmodeyourgroupsempty'] = 'Tryb grupowy: {$a->groupmode}. Nie należysz do żadnej grupy i dlatego studenci nie mogą umwawiać spotkań z Tobą.';
$string['groupscheduling'] = 'Włącz umwaianie grupowe';
$string['groupscheduling_desc'] = 'Zezwalaj na jednoczesne umawianie spotkań dla całych grup.
(Oprócz opcji globalnej, ustawienie "Rezerwacje w grupach" musi być włączone w odpowiedniej instancji terminarza.)';
$string['groupsession'] = 'Sesja grupowa';
$string['groupsize'] = 'Liczebność grupy';
$string['guardtime'] = 'Czas ochronny';
$string['guardtime_help'] = 'Czas ochrony uniemożliwia studentom zmianę rezerwacji na krótko przed spotkaniem.
<p>Jeśli czas ochrony jest włączony i ustawiony na przykład na 2 godziny, studenci nie będą mogli zarezerwować terminu, który rozpocznie się za mniej niż 2 godziny od teraz,
i nie będą mogli anulować spotkania, jeśli rozpocznie się ono za mniej niż 2 godziny.</p>';
$string['guestscantdoanything'] = 'Goście nie mogą tu nic zrobić.';
$string['howtoaddstudents'] = 'Aby dodać uczniów do globalnego terminarza, użyj ustawienia roli dla modułu.<br/>Możesz także użyć definicji ról modułu, aby zdefiniować swoich studentów jako uczestników.';
$string['htmlformat'] = 'HTML';
$string['ignoreconflicts'] = 'Ignoruj konflikty terminów';
$string['ignoreconflicts_help'] = 'Jeśli to pole jest zaznaczone, termin zostanie przeniesiony na żądaną datę i godzinę, nawet jeśli w tym samym czasie istnieją inne terminy. Może to prowadzić do kolizji terminów dla niektórych nauczycieli lub studentów, dlatego należy z tego korzystać ostrożnie.';
$string['ignoreconflicts_link'] = 'mod/scheduler/conflict';
$string['includeemptyslots'] = 'Uwzględnij puste terminy';
$string['includeslotsfor'] = 'Uwzględnij terminy dla';
$string['incourse'] = 'w kursie';
$string['introduction'] = 'Wprowadzenie';
$string['isnonexclusive'] = 'Nieograniczone';
$string['landscape'] = 'Orientaja pozioma';
$string['lengthbreakdown'] = 'Długości terminów';
$string['limited'] = 'Ograniczony ({$a} pozostało)';
$string['location'] = 'Miejsce spotkania';
$string['location_help'] = 'Ustal miejsce spotkania.';
$string['markasseennow'] = 'Oznacz spotkanie jako zrealizowane';
$string['markseen'] = 'Po spotkaniu oznacz je jako "zrealizowane", klikając w okienko obok obrazka profilowego studenta na liście powyżej.';
$string['maxgrade'] = 'Zastosuj najwyższą ocenę';
$string['maxstudentlistsize'] = 'Maksymalna długość listy studentów';
$string['maxstudentlistsize_desc'] = 'Maksymalna długość listy studentów, którzy muszą umówić się na spotkanie, wyświetlana w widoku dla nauczyciela w terminarzu. Jeśli liczba uczniów przekracza tę wartość, lista nie zostanie wyświetlona.';
$string['maxstudentsperslot'] = 'Maksymalna liczba studentów w terminie';
$string['maxstudentsperslot_desc'] = 'Terminy grupowe / nieograniczone mogą mieć co najwyżej taką liczbę studentów. Należy pamiętać, że dodatkowo dla terminu zawsze można wybrać ustawienie „nieograniczony”.';
$string['meangrade'] = 'Wylicz średnią';
$string['meetingwith'] = 'Spotkanie z Twoim';
$string['meetingwithplural'] = 'Spotkanie z Twoimi';
$string['message'] = 'Wiadomość';
$string['messagebody'] = 'Treść wiadomości';
$string['messageprovider:bookingnotification'] = 'Powiadomienie o utworzeniu lub odwołaniu spotkania';
$string['messageprovider:invitation'] = 'Zaproszenie do rezerwacji terminu spotkania';
$string['messageprovider:reminder'] = 'Przypomnienie o nadchodzącym spotkaniu';
$string['messagesent'] = 'Wysłano wiadomość do {$a} odbiorców';
$string['messagesubject'] = 'Temat';
$string['minutes'] = 'minut(y)';
$string['minutesperslot'] = 'minut na termin';
$string['missingstudents'] = '{$a} studentów jeszcze nie ma umówionego spotkania';
$string['missingstudentsmany'] = '{$a} studentów nadal musi umówić się na spotkanie. Lista nie jest wyświetlana ze względu na wielkość.';
$string['mixindivgroup'] = 'Mieszaj rezerwacje indywidualne i grupowe';
$string['mixindivgroup_desc'] = 'W przypadku włączonej rezerwacji grupowej, zezwalaj również na rezerwacje indywidualne';
$string['mode'] = 'Tryb działania';
$string['modeappointments'] = 'spotkań';
$string['modeintro'] = 'Studenci mogą rezerwować';
$string['modeoneatatime'] = 'równolegle na raz';
$string['modeoneonly'] = 'w tym terminarzu';
$string['modulename'] = 'Terminarz';
$string['modulename_help'] = 'Terminarz pomaga w planowaniu spotkań ze studentami.

Nauczyciele określają przedziały czasowe dla spotkań, a uczniowie wybierają jeden z nich na Moodle.
Nauczyciele z kolei mogą zapisać wynik spotkania - i opcjonalnie ocenę - w terminarzu.

Obsługiwane są rezerwacje grupowe; oznacza to, że każdy termin może pomieścić kilku studentów, a opcjonalnie można zaplanować spotkania dla całych grup w tym samym czasie.';
$string['modulename_link'] = 'mod/scheduler/view';
$string['modulenameplural'] = 'Terminarze';
$string['monday'] = 'Poniedziałek';
$string['multiple'] = '(wiele)';
$string['myappointments'] = 'Moje spotkania';
$string['myself'] = 'ja';
$string['name'] = 'Nazwa terminarza';
$string['needteachers'] = 'Nie można dodać terminów ponieważ ten kurs nie ma nauczyciela';
$string['negativerange'] = 'Zakres nie może być ujemny.';
$string['negativetimerange'] = 'Czas zakończenia musi być późniejszy niż czas rozpoczęcia.';
$string['never'] = 'Nigdy';
$string['nfiles'] = '{$a} plików';
$string['noappointments'] = 'Brak spotkań';
$string['noexistingstudents'] = 'Nie ma studentów, z którymi można umówić spotkanie.';
$string['nogroups'] = 'Nie ma grup, z którymi można umówić spotkanie.';
$string['noresults'] = 'Nie znaleziono wyników.';
$string['noschedulers'] = 'Brak terminarzy';
$string['noslots'] = 'Nie ma dostępnych terminów.';
$string['noslotsavailable'] = 'Obecnie nie ma dostępnych terminów do rezerwacji.';
$string['noslotsopennow'] = 'Żaden termin nie jest dostępny w tej chwili.';
$string['nostudents'] = 'Brak umówionych studentów.';
$string['nostudenttobook'] = 'Brak studentów do zapisania.';
$string['note'] = 'Ocena';
$string['noteacherforslot'] = 'Brak nauczyciela dla terminów';
$string['noteachershere'] = 'Nauczyciele niedostępni';
$string['notenoughplaces'] = 'Niestety nie ma wystarczającej ilości spotkań w tym terminie';
$string['notesrequired'] = 'Musisz coś wpisać w to pole przed rezerwacją terminu.';
$string['notifications'] = 'Powiadomienia';
$string['notifications_help'] = 'Gdy ta opcja jest włączona, nauczyciele i studenci będą otrzymywać powiadomienia, gdy spotkania zostaną zarezerwowane lub odwołane.';
$string['notseen'] = 'Nie zrealizowano';
$string['now'] = 'Teraz';
$string['occurrences'] = 'Liczba wystąpień';
$string['odsformat'] = 'ODS';
$string['on'] = 'kiedy';
$string['onedaybefore'] = '1 dzień przed terminem';
$string['onelineperappointment'] = 'Jedno spotkanie w każdej linii';
$string['onelineperslot'] = 'Jeden termin w każdej linii';
$string['oneslotadded'] = 'Dodano 1 termin';
$string['oneslotdeleted'] = 'Usunięto 1 termin';
$string['oneweekbefore'] = '1 tydzień przed terminem';
$string['onthemorningofappointment'] = 'Rano, w dniu spotkania';
$string['options'] = 'Ustawienia';
$string['otherstudents'] = 'Inni uczestnicy';
$string['outlineappointments'] = '{$a->attended} spotkań zrealizowanych, {$a->upcoming} nadhodzących.';
$string['outlinegrade'] = 'Ocena: {$a}';
$string['overall'] = 'Ogółem';
$string['overlappings'] = 'Inne terminy kolidują';
$string['pageperteacher'] = 'Jeden {$a} na stronę';
$string['pagination'] = 'Podział na strony';
$string['pagination_help'] = 'Wybierz, czy eksport ma zawierać oddzielną stronę dla każdego nauczyciela.
   W programie Excel i w formacie pliku ODS strony te odpowiadają zakładkom (arkuszom) w skoroszycie.';
$string['pdfformat'] = 'PDF';
$string['pdforientation'] = 'Orientacja strony (PDF)';
$string['pluginadministration'] = 'Administracja terminarzem';
$string['pluginname'] = 'Terminarz';
$string['portrait'] = 'Orientacja pionowa';
$string['preview'] = 'Podgląd';
$string['previewlimited'] = '(Podgląd jest ograniczony do {$a} wierszy.)';
$string['privacy:metadata:filepurpose'] = 'Plik używany w notatkach dla terminu lub spotkania';
$string['privacy:metadata:scheduler_appointment'] = 'Reprezentuje spotkanie studenta w terminarzu';
$string['privacy:metadata:scheduler_appointment:appointmentnote'] = 'Notatka nauczyciela (widoczna dla studenta)';
$string['privacy:metadata:scheduler_appointment:appointmentnoteformat'] = 'Format notatki nauczyciela';
$string['privacy:metadata:scheduler_appointment:attended'] = 'Czy spotkanie się odbyło';
$string['privacy:metadata:scheduler_appointment:grade'] = 'Ocena za spotkanie';
$string['privacy:metadata:scheduler_appointment:studentid'] = 'Student rezerwujący spotkanie';
$string['privacy:metadata:scheduler_appointment:studentnote'] = 'Notatka studenta';
$string['privacy:metadata:scheduler_appointment:studentnoteformat'] = 'Format notatki studenta';
$string['privacy:metadata:scheduler_appointment:teachernote'] = 'Notatka nauczyciela (prywatna)';
$string['privacy:metadata:scheduler_appointment:teachernoteformat'] = 'Format prywatnej notatki nauczyciela';
$string['privacy:metadata:scheduler_slots'] = 'Reprezentuje jeden termin w terminarzu';
$string['privacy:metadata:scheduler_slots:appointmentlocation'] = 'Miejsce spotkania';
$string['privacy:metadata:scheduler_slots:duration'] = 'Czas trwania spotkania w minutach';
$string['privacy:metadata:scheduler_slots:exclusivity'] = 'Maksymalna liczba studentów na termin';
$string['privacy:metadata:scheduler_slots:notes'] = 'Notatki o terminie';
$string['privacy:metadata:scheduler_slots:notesformat'] = 'Format notatek';
$string['privacy:metadata:scheduler_slots:starttime'] = 'Czas rozpoczęcia terminu';
$string['privacy:metadata:scheduler_slots:teacherid'] = 'Nauczyciel przypisany do terminu';
$string['purgeunusedslots'] = 'Usuń niewykorzystane terminy przeszłe';
$string['recipients'] = 'Odbiorcy';
$string['registeredlbl'] = 'Studentów umówionych';
$string['reminder'] = 'Przypomnienie';
$string['requireupload'] = 'Wymagaj załączników';
$string['resetappointments'] = 'Usuń spotkania i oceny';
$string['resetslots'] = 'Usuń terminy w terminarzu';
$string['return'] = 'Powrót do kursu';
$string['revealteachernotes'] = 'Wyświetlaj notatki nauczyciela w prywatnych eksportach';
$string['revealteachernotes_desc'] = 'Jeśli ta opcja jest zaznaczona, poufne notatki nauczyciela (które normalnie nie są widoczne dla studentów)
będą ujawniane studentom w zapytania o eksport danych, tj. za pośrednictwem interfejsu prywatnego API. Należy zdecydować na podstawie indywidualnego wykorzystania tego pola
czy musi być ono uwzględnione w eksporcie danych dla studentów zgodnie z RODO.';
$string['revoke'] = 'Odwołaj / unieważnij spotkanie';
$string['saturday'] = 'Sobota';
$string['save'] = 'Zapisz';
$string['savechoice'] = 'Zapisz mój wybór';
$string['saveseen'] = 'Zapisz zrealizowane';
$string['schedule'] = 'Zaplanuj';
$string['scheduleappointment'] = 'Zaplanuj spotkanie dla {$a}';
$string['schedulecancelled'] = '{$a} : Twoje spotkanie odwołane lub przesunięte';
$string['schedulegroups'] = 'Zaplanuj wg grupy';
$string['scheduleinnew'] = 'Zaplanuj nowy termin';
$string['scheduleinslot'] = 'Wyznacz termin';
$string['scheduler'] = 'Terminarz';
$string['scheduler:addinstance'] = 'Dodaj nowy terminarz';
$string['scheduler:appoint'] = 'Zarezerwuj terminy';
$string['scheduler:attend'] = 'Zapisz studentów';
$string['scheduler:canscheduletootherteachers'] = 'Zaplanuj spotkania dla innych członków kadry';
$string['scheduler:canseeotherteachersbooking'] = 'Zobacz i przeglądaj rezerwacje innych nauczycieli';
$string['scheduler:disengage'] = 'Ta funkcja jest przestarzała i nic nie robi';
$string['scheduler:editallattended'] = 'Oznacz wszystkie spotkania ze studentami jako zrealizowane / niezrealizowane';
$string['scheduler:editallgrades'] = 'Edytuj oceny z wszystkich spotkań';
$string['scheduler:editallnotes'] = 'Edytuj notatki ze spotkań we wszystkich spotkaniach';
$string['scheduler:manage'] = 'Zarządzaj swoimi terminami i spotkaniami';
$string['scheduler:manageallappointments'] = 'Zarządzaj wszystkimi danymi terminarza';
$string['scheduler:seeotherstudentsbooking'] = 'Zobacz innych studentów zapisanych na termin';
$string['scheduler:seeotherstudentsresults'] = 'Zobacz wyniki innych studentów w ramach terminu';
$string['scheduler:seeoverviewoutsideactivity'] = 'Ekran przeglądu umożliwia wyświetlanie terminów poza bieżącą aktywnością harmonogramu.';
$string['scheduler:viewfullslots'] = 'Wyświetlanie terminów, nawet jeśli są w pełni zarezerwowane (w widoku dla studenta)';
$string['scheduler:viewslots'] = 'Zobacz wolne terminy, które można zarezerwować (w widoku dla studenta).';
$string['schedulestudents'] = 'Wyznacz spotkania studentom';
$string['scopemenu'] = 'Pokaż terminy z: {$a}';
$string['scopemenuself'] = 'Pokaż moje terminy w: {$a}';
$string['search:activity'] = 'Terminarz - informacje o aktywności';
$string['seen'] = 'Zrealizowane';
$string['selectedtoomany'] = 'Wybrano zbyt wiele terminów. Nie można wybrać więcej niż {$a}.';
$string['sendinvitation'] = 'Wyślij zaproszenie';
$string['sendmessage'] = 'Wyślij wiadomość';
$string['sendreminder'] = 'Wyślij przypomnienie';
$string['sendreminders'] = 'Wyślij przypomnienia email dla nadchodzących spotkań.';
$string['sepcolon'] = 'Dwukropek';
$string['sepcomma'] = 'Przecinek';
$string['sepsemicolon'] = 'Średnik';
$string['septab'] = 'Tabulator';
$string['showemailplain'] = 'Pokaż adresy email jako zwykły tekst.';
$string['showemailplain_desc'] = 'W widoku terminarza dla nauczyciela wyświetlaj adresy e-mail studentów, którzy chcą umówić się na spotkanie, w postaci zwykłego tekstu, oprócz linków mailto:.';
$string['showparticipants'] = 'Pokaż uczestników';
$string['slot'] = 'Termin';
$string['slot_is_just_in_use'] = 'Niestety ten termin został przed chwilą wybrany przez innego studenta! Spróbuj ponowanie.';
$string['slotdatetime'] = '{$a->shortdatetime} przez {$a->duration} min.';
$string['slotdatetimelabel'] = 'Data i godzina';
$string['slotdatetimelong'] = '{$a->date}, {$a->starttime} &ndash; {$a->endtime}';
$string['slotdescription'] = '{$a->status} w dniu {$a->startdate} od {$a->starttime} do {$a->endtime} w {$a->location} z {$a->facilitator}.';
$string['slots'] = 'Terminy';
$string['slotsadded'] = 'Dodano {$a} terminów';
$string['slotsdeleted'] = 'Usunięto {$a} terminów';
$string['slottype'] = 'Rodzaj terminu';
$string['slotupdated'] = '1 termin zaktualizowano';
$string['slotwarning'] = '<strong>Uwaga:</strong>Przeniesienie tego terminu na wybraną godzinę powoduje konflikt z terminami wymienionymi poniżej. Zaznacz opcję „Ignoruj konflikty terminarza”, jeśli mimo to chcesz przenieść termin.';
$string['staffbreakdown'] = 'Podział wg: {$a}';
$string['staffrolename'] = 'Zmiana nazwy roli prowadzącego';
$string['staffrolename_help'] = 'Nazwa roli osoby która obsługuje studentów. Nie musi to być "nauczyciel".';
$string['start'] = 'Początek';
$string['startpast'] = 'Nie można rozpocząć pustego terminu spotkania w przeszłości.';
$string['statistics'] = 'Statystyki';
$string['student'] = 'Student';
$string['studentbreakdown'] = 'Studenci';
$string['studentcomments'] = 'Wiadomość studenta';
$string['studentdetails'] = 'Dane studenta';
$string['studentfiles'] = 'Wgraj pliki';
$string['studentmultiselect'] = 'Każdy student może zostać wybrany tylko raz w tym terminie';
$string['studentnote'] = 'Wiadomość od studenta';
$string['studentprovided'] = 'Student przesłał: {$a}';
$string['students'] = 'Studenci';
$string['sunday'] = 'Niedziela';
$string['tab-otherappointments'] = 'Wszystkie spotkania tego studenta';
$string['tab-otherstudents'] = 'Studentci w tym terminie';
$string['tab-thisappointment'] = 'To spotkanie';
$string['teacher'] = 'Nauczyciel / Organizator';
$string['teachernote'] = 'Notatki poufne (widoczne tylko dla nauczyciela)';
$string['teachersmenu'] = 'Pokaż terminy dla: {$a}';
$string['thiscourse'] = 'terminy z całego kursu';
$string['thisscheduler'] = 'ten terminarz';
$string['thissite'] = 'terminy z całego serwisu';
$string['thursday'] = 'Czwartek';
$string['timefrom'] = 'Od:';
$string['timerange'] = 'Przedział czasowy';
$string['timeto'] = 'Do:';
$string['totalgrade'] = 'Ocena całościowa';
$string['tuesday'] = 'Wtorek';
$string['unattended'] = 'Niezrealizowane';
$string['unlimited'] = 'Bez ograniczeń';
$string['unregisteredlbl'] = 'Studentów nieumówionych';
$string['upcomingslots'] = 'Nadchodzące terminy';
$string['updategrades'] = 'Aktualizuj oceny';
$string['uploadmaxfiles'] = 'Maksymalna liczba załączników';
$string['uploadmaxfiles_help'] = 'Maksymalna liczba plików, które student może przesłać w formularzu rezerwacji. Przesyłanie plików jest opcjonalne, chyba że pole „Wymagane przesyłanie plików” jest zaznaczone. Jeśli ustawiono 0, studenci nie zobaczą pola przesyłania plików.';
$string['uploadmaxfilesglobal'] = 'Maksymalna liczba załączników';
$string['uploadmaxfilesglobal_desc'] = 'Maksymalna liczba plików, które student może przesłać w formularzu rezerwacji. Liczbę tę można jeszcze bardziej ograniczyć na poziomie poszczególnych terminarzy.';
$string['uploadmaxsize'] = 'Maksymalny rozmiar pliku';
$string['uploadmaxsize_help'] = 'Maksymalny rozmiar pliku wysyłanego przez studenta. Ograniczenie dotyczy pojedynczego pliku.';
$string['uploadrequired'] = 'Musisz wgrać pliki tutaj zanim zarezerwujesz termin.';
$string['uploadstudentfiles'] = 'Wgraj pliki';
$string['usebookingform'] = 'Włącz formularz rezerwacji';
$string['usebookingform_help'] = 'Jeśli opcja ta jest włączona, uczestnik zobaczy osobny ekran rezerwacji, zanim będzie mógł zarezerwować termin. Ekran rezerwacji może wymagać wprowadzenia danych, przesłania plików lub rozwiązania captcha; zobacz opcje poniżej.';
$string['usebookingform_link'] = 'mod/scheduler/bookingform';
$string['usecaptcha'] = 'Użyj CAPTCHA dla nowych rezerwacji';
$string['usecaptcha_help'] = 'Jeśli ta opcja jest włączona, studenci będą musieli rozwiązać pytanie bezpieczeństwa CAPTCHA przed dokonaniem nowej rezerwacji.
Użyj tego ustawienia, jeśli podejrzewasz, że studenci używają automatycznych programów do zajmowania wolnych miejsc.
<p> Captcha nie będzie wyświetlany, jeśli student edytuje istniejącą rezerwację.</p>';
$string['usenotes'] = 'Korzystaj z notatek do spotkań';
$string['usenotesboth'] = 'Oba rodzaje notatek';
$string['usenotesnone'] = 'Bez notatek';
$string['usenotesstudent'] = 'Notatki ze spotkania - widoczne dla nauczyciela i studenta';
$string['usenotesteacher'] = 'Notatki poufne przeznaczone tylko dla nauczyciela';
$string['usestudentnotes'] = 'Zezwól studentom na wpisanie wiadomości';
$string['usestudentnotes_help'] = 'Jeśli opcja ta jest włączona, ekran rezerwacji będzie zawierał pole tekstowe, w którym studenci mogą wprowadzić wiadomość. Użyj „instrukcji rezerwacji” powyżej, aby poinstruować studentów, jakie informacje powinni podać.';
$string['viewbooking'] = 'Zobacz szczegóły';
$string['wednesday'] = 'Środa';
$string['welcomebackstudent'] = 'Możesz zarezerwować dodatkowe terminy, klikając odpowiedni przycisk „Zarezerwuj termin” poniżej.';
$string['welcomenewstudent'] = 'Poniższa tabela przedstawia wszystkie dostępne terminy spotkań. Dokonaj wyboru, klikając odpowiedni przycisk „Zarezerwuj termin”. Jeśli chcesz dokonać zmiany później, możesz ponownie odwiedzić tę stronę.';
$string['welcomenewteacher'] = 'Kliknij na guzik poniżej, aby utworzyć terminy spotkań.';
$string['what'] = 'O czym?';
$string['whathappened'] = 'Co się działo?';
$string['whatresulted'] = 'Jaki skutek?';
$string['when'] = 'Kiedy?';
$string['where'] = 'Gdzie?';
$string['who'] = 'Z kim?';
$string['whosthere'] = 'Kto tam?';
$string['xdaysbefore'] = '{$a} dni przed terminem';
$string['xweeksbefore'] = '{$a} tygodni przed terminem';
$string['yesallgroups'] = 'Tak, dla wszystkich grup';
$string['yesingrouping'] = 'Tak, w grupie nadrzędnej {$a}';
$string['yesoptional'] = 'Tak, opcjonalnie dla studenta';
$string['yesrequired'] = 'Tak, student musi wpisać wiadomość';
$string['yourappointmentnote'] = 'Komentarze tylko dla Twoich oczu';
$string['yourslotnotes'] = 'Uwagi o spotkaniu';
$string['yourstudentnote'] = 'Twoja wiadomość';
$string['yourtotalgrade'] = 'Twoja ocena całościowa za tę aktywność to: <strong>{$a}</strong>.';
