<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'da', version '5.0'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Backup\'en er færdig';
$string['asyncbackupcompletebutton'] = 'Fortsæt';
$string['asyncbackupcompletedetail'] = 'Backup\'en er færdig. Du kan se den på <a href="{$a}">gendannelsessiden.</a>';
$string['asyncbackuperror'] = 'Backup\'en mislykkedes';
$string['asyncbackuperrordetail'] = 'Backup\'en mislykkedes. Kontakt systemets administrator.';
$string['asyncbackuppending'] = 'Backup\'en er i venteposition';
$string['asyncbackupprocessing'] = 'Backup\'en kører';
$string['asyncbadexecution'] = 'Dårlig kørsel af backup-kontrollen. Den er {$a}, men den skulle være 2.';
$string['asynccheckprogress'] = 'Du kan altid følge gendannelsen på <a href="{$a}">gendannelsessiden</a>.';
$string['asyncemailenable'] = 'Aktiver notifikationer';
$string['asyncemailenabledetail'] = 'Er indstillingen aktiveret, vil brugere modtage en notifikation når en asynkron backup eller gendannelse er færdig.';
$string['asyncgeneralsettings'] = 'Asynkron backup/gendannelse';
$string['asyncmessagebody'] = 'Notifikation';
$string['asyncmessagebodydefault'] = 'Din {operation} (ID: {backupid}) er færdig.

Du kan se den her: <a href="{link}">{link}</a>.';
$string['asyncmessagebodydetail'] = 'Den notifkation, der sendes når en asynkron backup eller gendannelse er færdig.';
$string['asyncmessagesubject'] = 'Emne';
$string['asyncmessagesubjectdefault'] = 'Moodle {operation} er færdig';
$string['asyncmessagesubjectdetail'] = 'Notifikationens emne';
$string['asyncnowait'] = 'Du behøver ikke at vente her, processen vil fortsætte i baggrunden.';
$string['asyncprocesspending'] = 'Processen er i venteposition';
$string['asyncrestorecomplete'] = 'Gendannelsen er færdig';
$string['asyncrestorecompletebutton'] = 'Fortsæt';
$string['asyncrestorecompletedetail'] = 'Gendannelsen er færdig. Klik på fortsæt vil føre dig til <a href="{$a}">kurset med gendannelsen</a>';
$string['asyncrestoreerror'] = 'Gendannelsen mislykkedes';
$string['asyncrestoreerrordetail'] = 'Gendannelsen mislykkedes. Kontakt systemets administrator.';
$string['asyncrestoreinprogress'] = 'Gendannelsen kører';
$string['asyncrestoreinprogress_help'] = 'Kørende asynkrone kursusgendannelser vises her.';
$string['asyncrestorepending'] = 'Gendannelsen er i venteposition';
$string['asyncrestoreprocessing'] = 'Gendannelsen kører';
$string['asyncreturn'] = 'Returner til kurset';
$string['autoactivedescription'] = 'Vælg om der skal køre automatisk backup. Hvis manuel er valgt, vil det kun være muligt gennem det automatiske script til backup med CLI. Dette kan enten gøres manuelt fra en kommandolinje eller via cron.';
$string['autoactivedisabled'] = 'Deaktiveret';
$string['autoactiveenabled'] = 'Aktiveret';
$string['autoactivemanual'] = 'Manuel';
$string['automatedbackupschedule'] = 'Planlægge';
$string['automatedbackupschedulehelp'] = 'Vælg hvilke dage i ugen der skal foretages automatisk backup.';
$string['automatedbackupsinactive'] = 'Administrator har ikke aktiveret automatiske backups';
$string['automatedbackupstatus'] = 'Status for planlagte backups';
$string['automateddeletedays'] = 'Slet backups ældre end';
$string['automatedmaxkept'] = 'Maks. antal backups der gemmes';
$string['automatedmaxkepthelp'] = 'Dette angiver det højeste antal nyligt automatisk gennemførte backups der skal gemmes for hvert kursus. Ældre backups vil automatisk blive slettet.';
$string['automatedminkept'] = 'Minimum antal backups der gemmes';
$string['automatedminkepthelp'] = 'Hvis backups der er ældre end et angivet antal dage, slettes, kan det ske at et inaktivt kursus ikke har et sæt backupfiler. For at undgå det, skal du angive et minimum antal backups der skal gemmes.';
$string['automatedsettings'] = 'Indstillinger for automatisk backup';
$string['automatedsetup'] = 'Opsætning af automatisk backup';
$string['automatedstorage'] = 'Lager til automatisk backup';
$string['automatedstoragehelp'] = 'Vælg hvor den automatiske backup skal gemmes.';
$string['backupactivity'] = 'Backup af aktivitet: {$a}';
$string['backupautoactivitiesdescription'] = 'Indstiller standarden for at inkludere aktiviteter i en backup. For at papirkurven skal fungere, skal denne indstilling være aktiveret.';
$string['backupcoursedetails'] = 'Kursusoplysninger';
$string['backupcoursesection'] = 'Sektion: {$a}';
$string['backupcoursesections'] = 'Kursussektioner';
$string['backupdate'] = 'Backupdato';
$string['backupdetails'] = 'Backupoplysninger';
$string['backupdetailsnonstandardinfo'] = 'Den valgte fil er ikke en standard Moodle-backupfil. Gendannelsesprocessen vil prøve at konvertere filen til standardformatet og derpå gendanne den.';
$string['backupfile'] = 'Backupfil';
$string['backupformat'] = 'Format';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Ukendt format';
$string['backuplog'] = 'Teknisk information og advarsler';
$string['backupmode'] = 'Tilstand';
$string['backupmode10'] = 'Generel';
$string['backupmode20'] = 'Import';
$string['backupmode30'] = 'Hub';
$string['backupmode40'] = 'Samme websted';
$string['backupmode50'] = 'Automatiseret';
$string['backupmode60'] = 'Konverteret';
$string['backupmode70'] = 'Asynkron';
$string['backupsection'] = 'Backup af kursussektion: {$a}';
$string['backupsettings'] = 'Backup-indstillinger';
$string['backupsitedetails'] = 'Webstedsoplysninger';
$string['backupstage16action'] = 'Fortsæt';
$string['backupstage1action'] = 'Næste';
$string['backupstage2action'] = 'Næste';
$string['backupstage4action'] = 'Udfør backup';
$string['backupstage8action'] = 'Fortsæt';
$string['backupthenrestore'] = 'Backup fuldført. Start gendannelse.';
$string['backuptype'] = 'Type';
$string['backuptypeactivity'] = 'Aktivitet';
$string['backuptypecourse'] = 'Kursus';
$string['backuptypesection'] = 'Sektion';
$string['backupversion'] = 'Backup-version';
$string['cannotfindassignablerole'] = 'Rollen {$a} i backupfilen kan ikke knyttes til nogen af de roller, som du må tildele.';
$string['choosefilefromactivitybackup'] = 'Backupfiler - aktivitet';
$string['choosefilefromactivitybackup_help'] = 'Backupfiler for denne aktivitet.';
$string['choosefilefromautomatedbackup'] = 'Automatiske backups';
$string['choosefilefromautomatedbackup_help'] = 'Backupfiler automatisk genereret.';
$string['choosefilefromcoursebackup'] = 'Backupfiler - kursus';
$string['choosefilefromcoursebackup_help'] = 'Backupfiler for dette kursus';
$string['choosefilefromuserbackup'] = 'Anonymiserede backup';
$string['choosefilefromuserbackup_help'] = 'Private backupfiler for alle kurser med anonymiserede brugeroplysninger.';
$string['config_keep_groups_and_groupings'] = 'Bevar som standard aktuelle grupper og grupperinger.';
$string['config_keep_roles_and_enrolments'] = 'Bevar aktuelle roller og tilmeldinger.';
$string['config_overwrite_conf'] = 'Tillader bruger at overskrive den aktuelle kursuskonfiguration';
$string['config_overwrite_course_fullname'] = 'Overskriv som standard kursets fulde navn med det fra backup-filen. Det kræver at "Overskriv kursuskonfiguration" er valgt, og at den aktuelle bruger har rettighed til at ændre kursets fulde navn (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'Overskriv som standard kursets korte navn med det fra backup-filen. Det kræver at "Overskriv kursuskonfiguration" er valgt, og at den aktuelle bruger har rettighed til at ændre kursets korte navne (moodle/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'Overskriv som standard kursets startdato med det fra backup-filen. Det kræver at "Overskriv kursuskonfiguration" er valgt, og at den aktuelle bruger har rettighed til at ændre startdato på et kursus ved gendannelse (moodle/restore:rolldates)';
$string['configgeneralactivities'] = 'Sætter standard for inkludering af aktiviteter i en backup.';
$string['configgeneralanonymize'] = 'Er indstillingen aktiveret, vil alle oplysninger vedrørende brugere som standard blive anonymiseret.';
$string['configgeneralbadges'] = 'Sætter standard for inkludering af badges i en backup.';
$string['configgeneralblocks'] = 'Sætter standard for inkludering af blokke i en backup.';
$string['configgeneralcalendarevents'] = 'Sætter standard for inkludering af kalenderbegivenheder i en backup.';
$string['configgeneralcomments'] = 'Sætter standard for inkludering af kommentarer i en backup.';
$string['configgeneralcompetencies'] = 'Sætter standard for inkludering af kompetencer i en backup.';
$string['configgeneralcontentbankcontent'] = 'Standard for inkludering af indhold i indholdsbanken i en backup.';
$string['configgeneralcustomfield'] = 'Indstiller standarden for at inkludere brugerdefinerede felter i en backup.';
$string['configgeneralfiles'] = 'Sætter standard for at tage filer med i en backup. Bemærk: Deaktivering af indstillingen vil medføre at en backup kun vil indeholde referencer til filer. Det er helt fint hvis backuppen gendannes på samme websted og filerne ikke er slettede i overensstemmelse med indstillingen "Ryd filer i affaldsdyngen" (filescleanupperiod).';
$string['configgeneralfilters'] = 'Sætter standard for inkludering af filtre i en backup.';
$string['configgeneralgroups'] = 'Sætter standard for inkludering af grupper og grupperinger i en backup';
$string['configgeneralhistories'] = 'Sætter standard for inkludering af brugerhistorik i en backup.';
$string['configgenerallogs'] = 'Er indstillingen aktiveret, vil logs som standard inkluderes i backups.';
$string['configgeneralpermissions'] = 'Hvis indstillingen er aktiveret, vil rolletilladelserne blive importeret. Dette kan tilsidesætte eksisterende tilladelser for tilmeldte brugere.';
$string['configgeneralquestionbank'] = 'Er indstillingen aktiveret, vil spørgsmålsbanken som standard inkluderes i backups. OBS: Er denne indstilling deaktiveret, vil backup af aktiviteter som bruger spørgsmålsbanken (eksempelvis quizzer), også være deaktiveret.';
$string['configgeneralroleassignments'] = 'Er indstillingen aktiveret, vil tildelte roller som standard inkluderes i backups.';
$string['configgeneralusers'] = 'Sætter standard for inkludering af brugerne i backups.';
$string['configgeneraluserscompletion'] = 'Er indstillingen aktiveret, vil oplysninger om brugergennemførelse som standard inkluderes i backups.';
$string['configgeneralxapistate'] = 'Indstiller standarden for at inkludere brugerens tilstand i indhold såsom H5P-aktiviteter i en backup.';
$string['configlegacyfiles'] = 'Sætter standarden for inkludering af ældre kursusfiler i en sikkerhedskopi. Ældre kursusfiler er fra versioner af Moodle før 2.0.';
$string['configloglifetime'] = 'Dette specificerer den periode hvori du vil beholde backuplogs. Logs, som er ældre end angivet her, bliver automatisk slettet. Det anbefales at have en kort periode, da backuplogs kan være ret omfangsrige.';
$string['configrestoreactivities'] = 'Sætter standard for gendannelse af aktiviteter.';
$string['configrestorebadges'] = 'Sætter standard for gendannelse af badges.';
$string['configrestoreblocks'] = 'Sætter standard for gendannelse af blokke.';
$string['configrestorecalendarevents'] = 'Sætter standard for gendannelse af begivenheder i kalenderen.';
$string['configrestorecomments'] = 'Sætter standard for gendannelse af kommentarer.';
$string['configrestorecompetencies'] = 'Sætter standard for gendannelse af kompetencer.';
$string['configrestorecontentbankcontent'] = 'Standard for gendannelse af indhold i indholdsbanken.';
$string['configrestorecustomfield'] = 'Indstiller standardindstillingen for gendannelse af brugerdefinerede felter.';
$string['configrestoreenrolments'] = 'Sætter standard for gendannelse af tilmeldingsmetoder.';
$string['configrestorefilters'] = 'Sætter standard for gendannelse af filtre.';
$string['configrestoregroups'] = 'Sætter standard for gendannelse af grupper og grupperinger hvis de er en del af backup\'en.';
$string['configrestorehistories'] = 'Sætter standard for gendannelse af brugerhistorik hvis den er en del af backup\'en.';
$string['configrestorelogs'] = 'Er indstillingen aktiveret, vil logge som standard gendannes hvis de er en del af backup\'en.';
$string['configrestorepermissions'] = 'Er indstillingen aktiveret, vil rolletilladelserne blive gendannet. Dette kan tilsidesætte eksisterende tilladelser for tilmeldte brugere.';
$string['configrestoreroleassignments'] = 'Er indstillingen aktiveret, vil rolletildelinger som standard gendannes hvis de er en del af backup\'en.';
$string['configrestoreusers'] = 'Sætter standard for hvorvidt brugere skal gendannes hvis de er en del af backup\'en.';
$string['configrestoreuserscompletion'] = 'Er indstillingen aktiveret, vil brugeres gennemførelsesdata som standard gendannes hvis de er en del af backup\'en.';
$string['configrestorexapistate'] = 'Indstiller standarden for gendannelse af brugerens tilstand i indhold såsom H5P-aktiviteter.';
$string['confirmcancel'] = 'Annuller backup';
$string['confirmcancelimport'] = 'Annuller import';
$string['confirmcancelno'] = 'Annuller ikke';
$string['confirmcancelquestion'] = 'Er du sikker på du vil annullere?

Alle oplysninger, du har indtastet, vil blive tabt.';
$string['confirmcancelrestore'] = 'Annuller gendannelse';
$string['confirmcancelyes'] = 'Annuller backup';
$string['confirmnewcoursecontinue'] = 'Ny kursus-advarsel';
$string['confirmnewcoursecontinuequestion'] = 'Et midlertidigt (skjult) kursus vil blive oprettet af kursusgendannelsesprocessen. For at afbryde gendannelsen tryk "Afbryd". Luk ikke din browser imens gendannelsen finder sted.';
$string['copiesinprogress'] = 'Dette kursus er ved at blive kopieret. <a href="{$a}">View in progress copies.</a>';
$string['copycoursedesc'] = 'Opret en kopi af dette kursus i en hvilken som helst kursuskategori.';
$string['copycoursetitle'] = 'Kopier kurset: {$a}';
$string['copydest'] = 'Destination';
$string['copyfieldnotfound'] = 'De krævede feltdata blev ikke fundet for felt(er): {$a}';
$string['copyformfail'] = 'AJAX-afsendelse af formularen med kursuskopier er mislykkedes.';
$string['copyingcourse'] = 'Kursuskopiering i gang';
$string['copyingcourseshortname'] = 'kopierer';
$string['copyop'] = 'Aktuel operation';
$string['copyprogressheading'] = 'Kursuskopiering i gang';
$string['copyprogressheading_help'] = 'Tabellen viser status på alle ufærdige kursuskopieringer';
$string['copyprogresstitle'] = 'Kursuskopiering i gang';
$string['copyreturn'] = 'Kopier og returner';
$string['copysource'] = 'Kilde';
$string['copyview'] = 'Kopier og vis';
$string['coursecategory'] = 'Den kategori kurset vil blive gendannet i';
$string['courseid'] = 'Original id';
$string['coursesettings'] = 'Kursusindstillinger';
$string['coursetitle'] = 'Titel';
$string['currentstage1'] = 'Første indstillinger';
$string['currentstage16'] = 'Fuldført';
$string['currentstage2'] = 'Vælg elementer';
$string['currentstage4'] = 'Kontroller valg';
$string['currentstage8'] = 'Udfør backup';
$string['enableasyncbackup'] = 'Aktiver asynkrone backups';
$string['enableasyncbackup_help'] = 'Er indstillingen aktiveret, kan backups og gendannelser køre asynkront. Det påvirker ikke import og eksport. Asynkrone backups og gendannelser gør det muligt for brugere at navigere på sitet, mens backups og gendannelser gennemføres.  Indstillingen påvirker ikke import og eksport.';
$string['enterasearch'] = 'Tast en søgetekst';
$string['error_block_for_module_not_found'] = 'Der er en hjemløs blok (id: {$a->bid}) til modulet (id: {$a->mid}). Blokken kommer ikke med i backup\'en.';
$string['error_course_module_not_found'] = 'Der er et hjemløst modul (id: {$a}) på kurset. Dette modul kommer ikke med i backuppen.';
$string['error_delegate_section_not_found'] = 'Mangler deligations sektion fra kursusmodul (ID {$a}). Sektionen vil ikke blive sikkerhedskopieret.';
$string['errorcopyingbackupfile'] = 'Det mislykkedes at kopiere backupfilen til den midlertidige mappe inden gendannelsen.';
$string['errorfilenamemustbezip'] = 'Det filnavn, du indtaster, skal være en zip-fil og have endelsen .mbz';
$string['errorfilenamerequired'] = 'Du skal indtaste et gyldigt filnavn til denne backup';
$string['errorfilenametoolong'] = 'Filnavnet skal have mindre end 255 tegn';
$string['errorinvalidformat'] = 'Ukendt backupformat.';
$string['errorinvalidformatinfo'] = 'Den valgte fil er ikke en gyldig Moodle-backupfil og kan ikke gendannes.';
$string['errorminbackup20version'] = 'Backupfilen er oprettet med en udviklingsversion af Moodle-backup ({$a->backup}). Der kræves mindst {$a->min}. Backuppen kan ikke gendannes.';
$string['errorrestorefrontpagebackup'] = 'Du kan kun gendanne forside-backupfiler på forsiden';
$string['executionsuccess'] = 'Der blev oprettet en backupfil.';
$string['extractingbackupfileto'] = 'Udpak backupfilen til: {$a}';
$string['failed'] = 'Backup\'en mislykkedes';
$string['filealiasesrestorefailures'] = 'Alias-gendannelsesfejl';
$string['filealiasesrestorefailures_help'] = 'Aliasser er symbolske links til andre filer, også dem der er gemt i eksterne filarkiver. I nogle tilfælde kan Moodle ikke gendanne dem - for eksempel når den skal gendanne backup fra andre websteder eller når kildefilen ikke eksisterer.

Flere oplysninger og den faktiske grund til fejlen kan findes i gendannelseslogfilen.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Nogle aliasser, herunder dem i backupfilen, kunne ikke gendannes. Den følgende liste indeholder deres forventede lokation og kilden de refererede til på det originale websted.';
$string['filename'] = 'Filnavn';
$string['filereferencesincluded'] = 'Filreferencer til eksternt indhold inkluderet i backuppakken, vil ikke virke hvis backuppen gendannes  på et andet site.';
$string['filereferencesnotsamesite'] = 'Backuppen er fra et andet websted, filreferencer kan derfor ikke gendannes.';
$string['filereferencessamesite'] = 'Backuppen er fra dette websted, så filreferencer kan gendannes';
$string['generalactivities'] = 'Inkluder aktiviteter og materialer';
$string['generalanonymize'] = 'Anonymiser information';
$string['generalbackdefaults'] = 'Generelle backupstandarder';
$string['generalbadges'] = 'Inkluder badges';
$string['generalblocks'] = 'Inkluder blokke';
$string['generalcalendarevents'] = 'Inkluder kalenderbegivenheder';
$string['generalcomments'] = 'Inkluder kommentarer';
$string['generalcompetencies'] = 'Inkluder kompetencer';
$string['generalcontentbankcontent'] = 'Medtag indhold i indholdsbanken';
$string['generalcustomfield'] = 'Inkluder brugerdefinerede felter';
$string['generalenrolments'] = 'Inkluder tilmeldingsmetoder';
$string['generalfiles'] = 'Inkluder filer';
$string['generalfilters'] = 'Inkluder filtre';
$string['generalgradehistories'] = 'Inkluder historik';
$string['generalgroups'] = 'Inkluder grupper og grupperinger';
$string['generalhistories'] = 'Inkluder historik';
$string['generallegacyfiles'] = 'Inkluder ældre kursusfiler';
$string['generallogs'] = 'Inkluder logs';
$string['generalpermissions'] = 'Medtag tilsidesættelse af tilladelser';
$string['generalquestionbank'] = 'Inkluder spørgsmålsbank';
$string['generalrestoredefaults'] = 'Generelle gendannelsesstandarder';
$string['generalrestoresettings'] = 'Generelle gendannelsesindstillinger';
$string['generalroleassignments'] = 'Inkluder tildelte roller';
$string['generalsettings'] = 'Generelle backupindstillinger';
$string['generalusers'] = 'Inkluder brugere';
$string['generaluserscompletion'] = 'Inkluder data om brugeres progression';
$string['generalxapistate'] = 'Inkluder brugerens tilstand i indhold såsom H5P-aktiviteter';
$string['hidetypes'] = 'Skjul typeindstillinger';
$string['importbackupstage16action'] = 'Fortsæt';
$string['importbackupstage1action'] = 'Næste';
$string['importbackupstage2action'] = 'Næste';
$string['importbackupstage4action'] = 'Udfør import';
$string['importbackupstage8action'] = 'Fortsæt';
$string['importcurrentstage0'] = 'Vælg kursus';
$string['importcurrentstage1'] = 'Første indstillinger';
$string['importcurrentstage16'] = 'Fuldført';
$string['importcurrentstage2'] = 'Vælg elementer';
$string['importcurrentstage4'] = 'Bekræft og gennemse';
$string['importcurrentstage8'] = 'Udfør import';
$string['importfile'] = 'Upload en backupfil';
$string['importfromccmidtocourse'] = 'Importer fra cmid:{$a->srccmid} til kursus:{$a->dstcourseid}';
$string['importfromcoursetocourse'] = 'Importer fra kursus:{$a->srccourseid} til kursus:{$a->dstcourseid}';
$string['importgeneralduplicateadminallowed'] = 'Tillad adminkonfliktløsning';
$string['importgeneralduplicateadminallowed_desc'] = 'Hvis sitet har en konto med brugernavnet \'admin\', kan det resultere i en konflikt hvis den backupfil der forsøges gendannet, også har en konto med brugernavn \'admin\'. Hvis denne indstilling aktiveres, vil konflikten løses ved at brugernavnet i backupfilen ændres til \'admin_xyx\'.';
$string['importgeneralmaxresults'] = 'Maksimum antal kurser på importlisten';
$string['importgeneralmaxresults_desc'] = 'Antal kurser oplistet ved de første trin af importprocessen';
$string['importgeneralsettings'] = 'Generelle importstandarder';
$string['importrootsettings'] = 'Importindstillinger';
$string['importsettings'] = 'Generelle importindstillinger';
$string['importsuccess'] = 'Importen er fuldført. Klik på fortsæt for at returnere til kurset.';
$string['includeactivities'] = 'Inkluder:';
$string['includeditems'] = 'Inkluderede dele:';
$string['includefilereferences'] = 'Filreferencer til eksternt indhold';
$string['includesection'] = 'Sektion {$a}';
$string['includeuserinfo'] = 'Brugerdata';
$string['includeuserinfo_instance'] = 'Inkluder {$a} brugerdata';
$string['inprogress'] = 'Backup\'en kører';
$string['jumptofinalstep'] = 'Gå til sidste trin';
$string['keep'] = 'Bevar';
$string['keptroles'] = 'Inkluder rolletilmeldinger';
$string['keptroles_help'] = 'Brugere med de valgte roller vil blive meldt ind i det nye kursus. Ingen brugerdata vil blive kopieret med mindre "Inkluder brugerdata" er aktiveret.';
$string['locked'] = 'Låst';
$string['lockedbyconfig'] = 'Denne indstilling er låst af standardindstillingerne for backup';
$string['lockedbyhierarchy'] = 'Låst af afhængigheder';
$string['lockedbypermission'] = 'Du har ikke tilstrækkelige tilladelser til at ændre denne indstilling';
$string['loglifetime'] = 'Behold logs i';
$string['managefiles'] = 'Administrer backupfiler';
$string['managefiles_activity'] = 'Administrer aktivitetsbackups';
$string['managefiles_automated'] = 'Administrer automatiske backups';
$string['managefiles_backup'] = 'Administrer private backups';
$string['managefiles_course'] = 'Administrer kursusbackups';
$string['mergerestoredefaults'] = 'Gendan standarder ved sammenfletning ind i et andet kursus.';
$string['missingfilesinpool'] = 'Nogle filer kunne ikke gemmes under backup, så det er ikke muligt at gendanne dem.';
$string['module'] = 'Modul';
$string['moodleversion'] = 'Moodleversion';
$string['morecoursesearchresults'] = 'Mere end {$a} kurser fundet, viser de første {$a} resultater';
$string['moreresults'] = 'Der er for mange resultater, indtast noget mere specifikt at søge på.';
$string['nomatchingcourses'] = 'Der er ingen kurser at vise';
$string['norestoreoptions'] = 'Der er ingen kategorier eller eksisterende kurser, du kan gendanne til.';
$string['originalwwwroot'] = 'Backuppens URL';
$string['overwrite'] = 'Overskriv';
$string['pendingasyncdeletedetail'] = 'Dette kursus har en afventende asynkron backup. Kurser kan ikke slettes før denne backup er afsluttet.';
$string['pendingasyncdetail'] = 'En bruger kan kun have en asynkron backup kørende ad gangen.<br>Flere asynkrone backups af samme ressource sættes ikke i kø, da det ville resultere i flere backups med samme indhold.';
$string['pendingasyncedit'] = 'Dette kursus har en afventende backup. Vent med at redigere kurset til backup\'en er gennemført.';
$string['pendingasyncerror'] = 'Afventende backup for dette kursus';
$string['preparingdata'] = 'Forbereder data';
$string['preparingui'] = 'Forbereder at vise siden';
$string['previousstage'] = 'Forrige';
$string['privacy:metadata:backup:detailsofarchive'] = 'Dette arkiv kan indeholde brugeroplysninger relateret til et kursus så som karakterer, tilmeldinger og aktivitetsdata.';
$string['privacy:metadata:backup:externalpurpose'] = 'Formålet med dette arkiv er at gemme information relateret til et kursus, som kan blive gendannet i fremtiden.';
$string['privacy:metadata:backup_controllers'] = 'Liste over backupoperationer';
$string['privacy:metadata:backup_controllers:itemid'] = 'Kursets id';
$string['privacy:metadata:backup_controllers:operation'] = 'Den operation der kørte, f.eks. gendannelse.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Hvornår handlingen blev oprettet';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Hvornår handlingen blev ændret';
$string['privacy:metadata:backup_controllers:type'] = 'Den type element der arbejdes på, f.eks. aktivitet.';
$string['qcategory2coursefallback'] = 'Spørgsmåls kategorien "{$a->name}", oprindeligt i system|kursus|kursuskategori kontekst i backupfilen, vil blive oprettet i en spørgsmålbankmodulkontekst ved gendannelse.';
$string['qcategorycannotberestored'] = 'Kursuskategorien "{$a->name}" kan ikke gendannes af gendannelsesprogrammet';
$string['question2coursefallback'] = 'Spørgsmåls kategorien "{$a->name}", oprindeligt i system|kursus|kursuskategori i backupfilen, vil blive oprettet i en spørgsmålbankmodulkontekst ved gendannelse.';
$string['questioncannotberestored'] = 'Spørgsmålene "{$a->name}" kan ikke gendannes af gendannelsesprogrammet';
$string['recyclebin_desc'] = 'Bemærk at disse indstillinger også gælder for papirkurven.';
$string['replacerestoredefaults'] = 'Gendannelsesstandarder ved gendannelse til et andet kursus hvor indholdet slettes';
$string['restoreactivity'] = 'Gendan aktivitet';
$string['restorecourse'] = 'Gendan kursus';
$string['restorecoursesettings'] = 'Kursusindstillinger';
$string['restoredcourseid'] = 'ID på gendannet kursus: {$a}';
$string['restoreexecutionsuccess'] = 'Kurset er gendannet.';
$string['restorefileweremissing'] = 'Nogle filer kunne ikke gendannes fordi de manglede i backupen.';
$string['restorenewcoursefullname'] = 'Navn på nyt kursus';
$string['restorenewcourseshortname'] = 'Kort navn på nyt kursus';
$string['restorenewcoursestartdate'] = 'Ny startdato';
$string['restorenofilesbackuparea'] = 'Der er ingen backupfiler endnu';
$string['restorenofilesbackuparea_activity'] = 'Der er ingen backupfiler for denne aktivitet endnu';
$string['restorenofilesbackuparea_automated'] = 'Der er ingen automatiske backupfiler endnu';
$string['restorenofilesbackuparea_backup'] = 'Du har ingen private backupfiler endnu';
$string['restorenofilesbackuparea_course'] = 'Der er ingen backupfiler for dette kursus endnu';
$string['restorerolemappings'] = 'Gendan rolletilknytninger';
$string['restorerootsettings'] = 'Gendannelsesindstillinger';
$string['restoresection'] = 'Gendan sektion';
$string['restorestage1'] = 'Bekræft';
$string['restorestage16'] = 'Se valg';
$string['restorestage16action'] = 'Udfør gendannelsen';
$string['restorestage1action'] = 'Næste';
$string['restorestage2'] = 'Destination';
$string['restorestage2action'] = 'Næste';
$string['restorestage32'] = 'Gendannelse';
$string['restorestage32action'] = 'Fortsæt';
$string['restorestage4'] = 'Indstillinger';
$string['restorestage4action'] = 'Næste';
$string['restorestage64'] = 'Fuldført';
$string['restorestage64action'] = 'Fortsæt';
$string['restorestage8'] = 'Vælg elementer';
$string['restorestage8action'] = 'Næste';
$string['restoretarget'] = 'Gendan til';
$string['restoretocourse'] = 'Gendan til kursus:';
$string['restoretocurrentcourse'] = 'Gendan i dette kursus';
$string['restoretocurrentcourseadding'] = 'Inkluder backupkurset i dette kursus';
$string['restoretocurrentcoursedeleting'] = 'Slet indholdet af dette kursus inden gendannelsen';
$string['restoretoexistingcourse'] = 'Gendan til et eksisterende kursus';
$string['restoretoexistingcourseadding'] = 'Inkluder backupkurset i et eksisterende kursus';
$string['restoretoexistingcoursedeleting'] = 'Slet indholdet af det eksisterende kursus inden gendannelsen';
$string['restoretonewcourse'] = 'Gendan til et nyt kursus';
$string['restoringcourse'] = 'Kursusgendannelse i gang';
$string['restoringcourseshortname'] = 'gendanner';
$string['rootenrolmanual'] = 'Gendan som manuelle tilmeldinger';
$string['rootsettingactivities'] = 'Inkluder aktiviteter og materialer';
$string['rootsettinganonymize'] = 'Anonymiser brugerinformation';
$string['rootsettingbadges'] = 'Inkluder badges';
$string['rootsettingblocks'] = 'Inkluder blokke';
$string['rootsettingcalendarevents'] = 'Inkluder begivenheder fra kalenderen';
$string['rootsettingcomments'] = 'Inkluder kommentarer';
$string['rootsettingcompetencies'] = 'Inkluder kompetencer';
$string['rootsettingcontentbankcontent'] = 'Medtag indhold i indholdsbanken';
$string['rootsettingcustomfield'] = 'Inkluder brugerdefinerede felter';
$string['rootsettingenrolments'] = 'Inkluder tilmeldingsmetoder';
$string['rootsettingenrolments_always'] = 'Ja, altid';
$string['rootsettingenrolments_never'] = 'Nej, gendan som manuelle tilmeldinger';
$string['rootsettingenrolments_withusers'] = 'Ja, men kun hvis brugere er inkluderet';
$string['rootsettingfiles'] = 'Inkluder filer';
$string['rootsettingfilters'] = 'Inkluder filtre';
$string['rootsettinggradehistories'] = 'Inkluder karakterhistorik';
$string['rootsettinggroups'] = 'Inkluder grupper og grupperinger';
$string['rootsettingimscc1'] = 'Konverter til IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Konverter til IMS Common Cartridge 1.1';
$string['rootsettinglegacyfiles'] = 'Inkluder ældre kursusfiler';
$string['rootsettinglogs'] = 'Inkluder kursuslogs';
$string['rootsettingpermissions'] = 'Medtag tilsidesættelse af tilladelser';
$string['rootsettingquestionbank'] = 'Inkluder spørgsmålsbank';
$string['rootsettingroleassignments'] = 'Inkluder rolletildelinger';
$string['rootsettings'] = 'Backupindstillinger';
$string['rootsettingusers'] = 'Inkluder deltagere';
$string['rootsettinguserscompletion'] = 'Inkluder data om brugergennemførelse';
$string['rootsettingxapistate'] = 'Inkluder brugerens tilstand i indhold såsom H5P-aktiviteter';
$string['samesitenotification'] = 'Denne backup er oprettet kun med links til filer, ikke med selve filerne. Gendannelse vil kun fungere på dette websted.';
$string['section_prefix'] = 'Sektion {$a}:';
$string['sectionactivities'] = 'Aktiviteter';
$string['sectioninc'] = 'Inkluderet i backup (uden brugerinformationer)';
$string['sectionincanduser'] = 'Inkluderet i backup med brugerinformationer';
$string['selectacategory'] = 'Vælg kategori';
$string['selectacourse'] = 'Vælg kursus';
$string['setting_course_fullname'] = 'Kursusnavn';
$string['setting_course_shortname'] = 'Kursets korte navn';
$string['setting_course_startdate'] = 'Kursets startdato';
$string['setting_keep_groups_and_groupings'] = 'Behold nuværende grupper og grupperinger';
$string['setting_keep_roles_and_enrolments'] = 'Behold nuværende roller og tilmeldinger';
$string['setting_overwrite_conf'] = 'Overskriv kursuskonfiguration';
$string['setting_overwrite_course_fullname'] = 'Overskriv kursets fulde navn';
$string['setting_overwrite_course_shortname'] = 'Overskriv kursets korte navn';
$string['setting_overwrite_course_startdate'] = 'Overskriv kursets startdato';
$string['showtypes'] = 'Vis typeindstillinger';
$string['sitecourseformatwarning'] = 'Dette er en forsidebackupfil, som kun kan gendannes på forsiden.';
$string['skiphidden'] = 'Spring over skjulte kurser';
$string['skiphiddenhelp'] = 'Vælg om du vil springe over skjulte kurser';
$string['skipmodifdays'] = 'Spring over kurser som ikke er ændret siden';
$string['skipmodifdayshelp'] = 'Vælg at springe over kurser som ikke er blevet ændret i et antal dage';
$string['skipmodifprev'] = 'Spring over kurser som ikke er ændret siden sidste backup';
$string['skipmodifprevhelp'] = 'Vælg om du vil springe kurser over, som ikke er blevet ændret siden sidste automatiske backup. For at dette er tilgængeligt kræves at logning er aktiveret.';
$string['status'] = 'Status';
$string['storagecourseandexternal'] = 'Backupfiler - kursus - og det angivne bibliotek';
$string['storagecourseonly'] = 'Backupfiler - kursus';
$string['storageexternalonly'] = 'Specificeret bibliotek til automatiseret backup';
$string['subsectioncontent'] = 'Undersektionindhold';
$string['successful'] = 'Backup\'en er færdig';
$string['successfulcopy'] = 'Kopiering fuldendt';
$string['successfulrestore'] = 'Gendannelsen er færdig';
$string['timetaken'] = 'Tidspunkt';
$string['title'] = 'Titel';
$string['totalcategorysearchresults'] = 'Kategorier i alt: {$a}';
$string['totalcoursesearchresults'] = 'Kurser i alt: {$a}';
$string['undefinedrolemapping'] = 'Rolletilknytning er ikke defineret for arketypen "{$a}".';
$string['unnamedsection'] = 'Unavngivet sektion';
$string['userdata'] = 'Inkluder brugerdata';
$string['userdata_help'] = 'Er indstillingen aktiveret, vil data såsom forumindlæg, opgaveafleveringer osv. kopieres over i det nye kursus for brugere med en rolle som valgt i "Inkluder rolletilmeldinger".';
$string['userinfo'] = 'Brugerinfo';
