<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plagiarism_turnitinsim', language 'da', version '5.0'.
 *
 * @package     plagiarism_turnitinsim
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessoptions'] = 'Studerendes adgang';
$string['accessoptions_help'] = 'Studerende vil have adgang til lighedsrapporten for deres aflevering, efter den er genereret.';
$string['accessstudents'] = 'Tillad studerende at se lighedsrapporter';
$string['addtoindex'] = 'Indeksér alle afleveringer';
$string['code'] = 'Kode';
$string['connecttest'] = 'Test Turnitin-forbindelse';
$string['connecttestfailed'] = 'Forbindelsestest mislykkedes.';
$string['connecttestsuccess'] = 'Forbindelsestest vellykket';
$string['dbexport'] = 'Eksport af database';
$string['dbexporttable'] = 'Eksporter {$a}-data';
$string['defaultsettings'] = 'Standardindstillinger';
$string['errorenabledfeatures'] = 'Kunne ikke hente listen med aktiverede funktioner';
$string['errortoolarge'] = 'Denne fil sendes ikke til Turnitin, da den overskrider den maksimalt tilladte størrelse på {$a}';
$string['eulaaccept'] = 'Jeg accepterer Turnitins slutbrugerlicensaftale';
$string['eulaaccepted'] = 'Tak, fordi du har accepteret Turnitins nye slutbrugerlicensaftale. Alle fremtidige afleveringer sendes nu til behandling hos Turnitin.';
$string['eulaalreadyaccepted'] = 'Du har allerede accepteret den seneste Turnitin EULA.';
$string['euladecline'] = 'Jeg afviser Turnitins slutbrugerlicensaftale';
$string['euladeclined'] = 'Dine afleveringer sendes ikke til Turnitin, da du ikke har accepteret Turnitins slutbrugerlicensaftale.';
$string['eulaheader'] = 'Turnitins slutbrugerlicensaftale';
$string['eulalink'] = 'For at denne aflevering kan sendes til Turnitin, skal du acceptere <a href="{$a}" target="_blank">Turnitins slutbrugerlicensaftale</a>.';
$string['eulalinkgeneric'] = 'Hvis du ønsker, at dine fremtidige afleveringer skal sendes til Turnitin, skal du acceptere <a href="{$a}" target="_blank">Turnitins slutbrugerlicensaftale</a>.';
$string['eulalinkmodal'] = 'For at denne aflevering kan sendes til Turnitin, skal du acceptere <a href="#" class="eula_link">Turnitins slutbrugerlicensaftale</a>.';
$string['eulanotrequired'] = 'Det er ikke obligatorisk at acceptere Turnitin EULA.';
$string['excludebiblio'] = 'Bibliografi';
$string['excludeoptions'] = 'Ekskluder fra lighedsrapporter';
$string['excludeoptions_help'] = 'De valgte indstillinger vises ikke som et match i lighedsrapporter.';
$string['excludequotes'] = 'Citeringer';
$string['faultcode'] = 'Fejlkode';
$string['getwebhookfailure:message'] = 'Der kan være et problem med den webhook, du har registreret hos Turnitin for plagiat-pluginnet. Den planlagte opgave til kontrol af den kunne ikke forbinde til Turnitin. Kontroller dine logge.';
$string['getwebhookfailure:subject'] = 'Fejl ved kontrol af Turnitin-webhook';
$string['indexoptions'] = 'Afleveringsindeksering';
$string['indexoptions_help'] = 'Indekserede afleveringer vil være tilgængelige til sammenligning i lighedsrapporter.';
$string['invalidtablename'] = 'Tabel {$a} kunne ikke eksporteres';
$string['line'] = 'Linje';
$string['message'] = 'Besked';
$string['messageprovider:digital_receipt_instructor'] = 'Turnitin-instruktør – digital kvittering';
$string['messageprovider:digital_receipt_student'] = 'Turnitin – digital kvittering for studerende';
$string['messageprovider:get_webhook_failure'] = 'Fejl ved kontrol af Turnitin-webhook';
$string['messageprovider:new_eula'] = 'Turnitins nye version af slutbrugerlicensaftalen';
$string['neweula:message'] = 'Turnitin har udgivet en ny slutbrugerlicensaftale. Læs mere <a href="{$a}">her</a>.';
$string['neweula:subject'] = 'Turnitins nye slutbrugerlicensaftale udgivet';
$string['pluginname'] = 'Turnitins integritetsplugin';
$string['pluginsetup'] = 'Konfiguration';
$string['privacy:metadata:plagiarism_turnitinsim_client'] = 'For at foretage en aflevering til Turnitin skal der udveksles specifikke brugerdata mellem Moodle og Turnitin. Få mere at vide om Moodle Plugins og GDPR på: https://help.turnitin.com/feedback-studio/moodle/moodle-plugins-and-gdpr.htm';
$string['privacy:metadata:plagiarism_turnitinsim_client:firstname'] = 'Brugerens fornavn sendes til Turnitin ved start af Turnitin Viewer, så brugeren kan identificeres.';
$string['privacy:metadata:plagiarism_turnitinsim_client:lastname'] = 'Brugerens efternavn sendes til Turnitin ved start af Turnitin Viewer, så brugeren kan identificeres.';
$string['privacy:metadata:plagiarism_turnitinsim_client:submission_content'] = 'Vær opmærksom på, at indholdet i en fil/aflevering sendes til behandling hos Turnitin.';
$string['privacy:metadata:plagiarism_turnitinsim_client:submission_filename'] = 'Navnet på den afleverede fil sendes til Turnitin, så den kan identificeres.';
$string['privacy:metadata:plagiarism_turnitinsim_client:submission_title'] = 'Afleveringens titel sendes til Turnitin, så den kan identificeres.';
$string['privacy:metadata:plagiarism_turnitinsim_sub'] = 'Oplysninger, der forbinder en Moodle-aflevering til en Turnitin-aflevering.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:identifier'] = 'Et hash, der bruges af Moodle til at identificere den afleverede fil.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:itemid'] = 'Id, der identificerer afleveringen for den relevante modultype.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:overallscore'] = 'Afleveringens overordnede lighedsscore.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:submittedtime'] = 'Et tidsstempel, der indikerer, hvornår brugerens aflevering blev sendt til Turnitin.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:turnitinid'] = 'Id\'et, der bruges af Turnitin som reference til afleveringen.';
$string['privacy:metadata:plagiarism_turnitinsim_sub:userid'] = 'Id\'et for den bruger, der har foretaget en aflevering.';
$string['privacy:metadata:plagiarism_turnitinsim_users'] = 'Oplysninger, der forbinder en Moodle-bruger til en Turnitin-bruger.';
$string['privacy:metadata:plagiarism_turnitinsim_users:lasteulaaccepted'] = 'Den seneste version af den Turnitin-slutbrugerlicensaftale, som brugeren har accepteret.';
$string['privacy:metadata:plagiarism_turnitinsim_users:lasteulaacceptedlang'] = 'Det sprog, hvormed brugeren sidst accepterede Turnitins slutbrugerlicensaftale.';
$string['privacy:metadata:plagiarism_turnitinsim_users:lasteulaacceptedtime'] = 'Et tidsstempel der indikerer hvornår brugeren sidst accepterede Turnitins slutbrugerlicensaftale.';
$string['privacy:metadata:plagiarism_turnitinsim_users:turnitinid'] = 'Det id Turnitin bruger som reference til brugeren.';
$string['privacy:metadata:plagiarism_turnitinsim_users:userid'] = 'Id\'et for den bruger, der har foretaget afleveringen.';
$string['queuedrafts'] = 'Behandl kladdeafleveringer';
$string['queuedrafts_help'] = 'Bemærk, at kladdeafleveringer ikke indekseres i Turnitin til sammenligning';
$string['receiptsinstructor:message'] = 'En aflevering med titlen <strong>{$a->submission_title}</strong> foretaget til modulet <strong>{$a->module_name}</strong> i klassen <strong>{$a->course_fullname}</strong> er blevet sendt til Turnitin.<br /><br />Afleverings-id: <strong>{$a->submission_id}</strong><br />Afleveringsdato: <strong>{$a->submission_date}</strong>';
$string['receiptsinstructor:subject'] = 'Aflevering sendt til Turnitin';
$string['receiptstudent:message'] = 'Kære {$a->firstname} {$a->lastname}<br /><br />Din fil <strong>{$a->submission_title}</strong> til modulet <strong>{$a->module_name}</strong> i klassen <strong>{$a->course_fullname}</strong> er blevet afleveret til Turnitin <strong>{$a->submission_date}</strong>. Dit afleverings-id er <strong>{$a->submission_id}</strong>.<br /><br />Tak, fordi du bruger Turnitin,<br /><br />Team Turnitin';
$string['receiptstudent:subject'] = 'Dette er din digitale Turnitin-kvittering';
$string['reportgen0'] = 'Øjeblikkeligt';
$string['reportgen1'] = 'Øjeblikkeligt, og generer igen på deadline-dato';
$string['reportgen2'] = 'Deadline-dato';
$string['reportgenoptions'] = 'Generer lighedsrapporter';
$string['reportgenoptions_help'] = '<strong>Øjeblikkeligt:</strong> Lighedsrapporter genereres, øjeblikkeligt efter filen er blevet afleveret.<br/><br/><strong>Ved deadline:</strong> Lighedsrapporter genereres kun på opgavens deadline-dato.<br/><br/><strong>Øjeblikkeligt og på deadline-dato:</strong> Der genereres en lighedsrapport, øjeblikkeligt efter filen er blevet afleveret. Lighedsrapporten genereres igen på opgavens deadline-dato. Denne indstilling kan bruges til at kontrollere for aftalt spil i en klasse.';
$string['resubmittoturnitin'] = 'Send til Turnitin igen';
$string['savesuccess'] = 'Ændringer gemt';
$string['settingslearnmore'] = 'Få mere at vide om Turnitin-indstillinger';
$string['submissiondisplayerror:cannotextracttext'] = 'Rapport utilgængelig';
$string['submissiondisplayerror:cannotextracttext_help'] = 'Der kunne ikke genereres en rapport for denne aflevering. Det kan skyldes, at denne type fil ikke kan generere en rapport, eller at der ikke er tekst nok.';
$string['submissiondisplayerror:corruptfile'] = 'Beskadiget fil';
$string['submissiondisplayerror:corruptfile_help'] = 'Den uploadede fil lader til at være beskadiget.';
$string['submissiondisplayerror:eulanotaccepted'] = 'Slutbrugerlicensaftalen ikke accepteret';
$string['submissiondisplayerror:eulanotaccepted_help'] = 'Turnitins slutbrugerlicensaftale skal accepteres af den studerende før afleveringen kan kontrolleres for lighed.';
$string['submissiondisplayerror:filelocked'] = 'Fil låst';
$string['submissiondisplayerror:filelocked_help'] = 'Den uploadede fil kræver en adgangskode for at åbne.';
$string['submissiondisplayerror:generic'] = 'Filen blev ikke sendt til Turnitin';
$string['submissiondisplayerror:generic_help'] = 'Denne fil er ikke blevet sendt til Turnitin. Kontakt din systemadministrator';
$string['submissiondisplayerror:notsent'] = 'Fil ikke sendt til Turnitin';
$string['submissiondisplayerror:notsent_help'] = 'Denne fil er ikke blevet afleveret til Turnitin, fordi Turnitin ikke var aktiveret på afleveringstidspunktet. Rediger eller upload din aflevering igen, hvis du ønsker den sendt til Turnitin.';
$string['submissiondisplayerror:processingerror'] = 'Behandlingsfejl';
$string['submissiondisplayerror:processingerror_help'] = 'Der opstod en uspecificeret fejl ved behandling af afleveringerne.';
$string['submissiondisplayerror:toolarge'] = 'Filen er for stor';
$string['submissiondisplayerror:toolarge_help'] = 'Denne fil er for stor til at blive sendt til Turnitin. Send en fil på under 100 MB for at kontrollere for originalitet.';
$string['submissiondisplayerror:toolittletext'] = 'Ikke nok tekst';
$string['submissiondisplayerror:toolittletext_help'] = 'Afleveringen har ikke tekst nok til at generere en lighedsrapport (en aflevering skal indeholde mindst 20 ord)';
$string['submissiondisplayerror:toomanypages'] = 'For mange sider';
$string['submissiondisplayerror:toomanypages_help'] = 'Afleveringen har for mange sider til at generere en lighedsrapport (en aflevering må have maks. 400 sider)';
$string['submissiondisplayerror:toomuchtext'] = 'For meget tekst';
$string['submissiondisplayerror:toomuchtext_help'] = 'Afleveringen har for meget tekst til at generere en lighedsrapport (efter udtrukket tekst er konverteret til UTF-8, skal afleveringen indeholde under {$a} tekst)';
$string['submissiondisplayerror:unknown'] = 'Fejl med din aflevering';
$string['submissiondisplayerror:unknown_help'] = 'Der opstod en ukendt fejl med din aflevering, og denne fil er ikke blevet sendt til Turnitin. Kontakt din systemadministrator.';
$string['submissiondisplayerror:unsupportedfiletype'] = 'Ikke-understøttet filtype';
$string['submissiondisplayerror:unsupportedfiletype_help'] = 'Den uploadede filtype understøttes ikke.';
$string['submissiondisplaystatus:awaitingeula'] = 'Afventer slutbrugerlicensaftale';
$string['submissiondisplaystatus:cannotextracttext'] = 'Rapport utilgængelig';
$string['submissiondisplaystatus:error'] = 'Fejl';
$string['submissiondisplaystatus:notsent'] = 'Ikke sendt';
$string['submissiondisplaystatus:pending'] = 'Afventer';
$string['submissiondisplaystatus:queued'] = 'I kø';
$string['submissiondisplaystatus:unknown'] = 'Ukendt fejl';
$string['taskadminupdate'] = 'Opdater lokal konfiguration for Turnitin-integritetsplugin';
$string['taskgetreportscores'] = 'Hent rapportscorer for Turnitins integritetsplugin';
$string['taskoutputenabledfeaturesnotretrieved'] = 'Turnitin-aktiverede funktioner kunne ikke hentes';
$string['taskoutputenabledfeaturesretrievalfailure'] = 'Kald af Turnitin-aktiverede funktioner mislykkedes';
$string['taskoutputenabledfeaturesretrieved'] = 'Turnitin-aktiverede funktioner hentet';
$string['taskoutputfailedconnection'] = 'Der opstod et problem med at oprette forbindelse til Turnitin API';
$string['taskoutputfailedcvlaunchurl'] = 'Der opstod et problem med at anmode om en Turnitin Viewer URL fra Turnitin API\'en for afleverings-id: {$a}';
$string['taskoutputfailedreportrequest'] = 'Der opstod et problem med at anmode om en generering af en originalitetsrapport fra Turnitin API for afleverings-id: {$a}';
$string['taskoutputfailedscorerequest'] = 'Der opstod et problem med at anmode om en originalitetsrapportscore fra Turnitin API\'en for afleverings-id: {$a}';
$string['taskoutputfailedupload'] = 'Der opstod et problem med at uploade en fil til Turnitin API\'en for afleverings-id: {$a}';
$string['taskoutputfileuploaded'] = 'Fil uploadet til Turnitin-aflevering: {$a}';
$string['taskoutputlatesteulanotretrieved'] = 'Den seneste version af slutbrugerlicensaftalen kunne ikke hentes';
$string['taskoutputlatesteularetrievalfailure'] = 'Kald af seneste version af slutbrugerlicensaftalen mislykkedes.';
$string['taskoutputlatesteularetrieved'] = 'Slutbrugerlicensaftale version {$a} hentet.';
$string['taskoutputpluginnotconfigured'] = 'Opgaven til {$a} kunne ikke køres, fordi Turnitins integritetsplugin ikke er konfigureret. <br/>Gå til pluginkonfigurationssiden i Webstedsadministration for at tilføje dine Turnitin API-loginoplysninger.';
$string['taskoutputsubmissioncreated'] = 'Aflevering oprettet i Turnitin: {$a}';
$string['taskoutputsubmissionnotcreatedeula'] = 'Afleveringen kunne ikke oprettes i Turnitin, fordi den studerende ikke har accepteret slutbrugerlicensaftalen.';
$string['taskoutputsubmissionnotcreatedgeneral'] = 'Afleveringen kunne ikke oprettes i Turnitin. Tjek dine logge.';
$string['taskoutputwebhookcreated'] = 'Webhook oprettet. Turnitin vil sende tilbagekald til {$a}';
$string['taskoutputwebhookcreationfailure'] = 'Anmodning om webhook-oprettelse mislykkedes. Kontroller dine logge.';
$string['taskoutputwebhookdeleted'] = 'Webhook {$a} er blevet slettet.';
$string['taskoutputwebhookdeletefailure'] = 'Webhook kunne ikke slettes. Kontroller dine logge.';
$string['taskoutputwebhooknotcreated'] = 'Webhook kunne ikke oprettes. Kontroller dine logge.';
$string['taskoutputwebhooknotdeleted'] = 'Webhook {$a} kunne ikke slettes.';
$string['taskoutputwebhooknotretrieved'] = 'Webhook {$a} kunne ikke hentes. En ny webhook oprettes';
$string['taskoutputwebhookretrievalfailure'] = 'Kald til hentning af webhook {$a} mislykkedes.';
$string['taskoutputwebhookretrieved'] = 'Webhook {$a} hentet. Webhook er aktiv.';
$string['tasksendqueuedsubmissions'] = 'Send filer i kø fra Turnitin-integritetspluginnet';
$string['turnitinapikey'] = 'Turnitin API-nøgle';
$string['turnitinapiurl'] = 'Turnitin API URL';
$string['turnitinconfig'] = 'Pluginkonfiguration';
$string['turnitinenablelogging'] = 'Aktiver diagnostisk tilstand';
$string['turnitinfeatures'] = 'Turnitin-integritetsfunktioner';
$string['turnitinfeatures::eulanotrequired'] = 'Accept af Turnitins slutbrugerlicensaftale kræves ikke af brugere';
$string['turnitinfeatures::eularequired'] = 'Det kræves, at alle brugere accepterer Turnitins slutbrugerlicensaftale';
$string['turnitinfeatures::header'] = 'Turnitin-integritetsfunktioner';
$string['turnitinfeatures::moreinfo'] = 'Få mere at vide om de aktiverede funktioner og pakker, der er tilgængelige fra Turnitin, på <a href="http://www.turnitin.com" target="_blank">http://www.turnitin.com</a>.';
$string['turnitinfeatures::repositories'] = 'Lagre sammenholdt med:';
$string['turnitinfeatures::viewoptions'] = 'Turnitin Viewer-indstillinger:';
$string['turnitinhideidentity'] = 'Skjul den studerendes identitet for Turnitin';
$string['turnitinmodenabled'] = 'Aktiver Turnitin-integritet for {$a}';
$string['turnitinpluginenabled'] = 'Aktiver Turnitin';
$string['turnitinpluginsettings'] = 'Indstillinger for Turnitin-integritetsplugin';
$string['turnitinsim'] = 'Turnitins integritetsplugin';
$string['turnitinsim:enable'] = 'Aktiver Turnitin-integritet';
$string['turnitinsim:viewfullreport'] = 'Vis originalitetsrapport';
$string['turnitinsiminternet'] = 'Sammenhold med internetindhold';
$string['turnitinsimprivate'] = 'Sammenhold med privat indhold';
$string['turnitinviewermatchsubinfo'] = 'Tillad instruktører i din institution at se afleveringsoplysninger for interne matches';
$string['turnitinviewersavechanges'] = 'Gem seerændringer';
$string['turnitinviewerviewfullsource'] = 'Tillad instruktører i din institution at se den fulde tekst af afleveringer for interne matches';
$string['viewapilog'] = 'Vis API-logge fra {$a}';
$string['viewerpermissionferpa'] = 'Følgende tilladelser påvirker, hvordan data kan deles på tværs af din institution. Disse data er ene og alene din institutions ansvar, så når disse tilladelser gives, skal du overveje, om de fuldt ud overholder din institutions politikker om studerendes journaler.';
$string['viewerpermissionoptions'] = 'Seertilladelser';
$string['viewlogs'] = 'Logge';
$string['webhook_description'] = 'Webhook for {$a}';
$string['webhookincorrectsignature'] = 'Webhook-tilbagekald mislykkedes, da signaturen er forkert';
