<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'da', version '5.0'.
 *
 * @package     report_security
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_antivirus_details'] = 'Denne status kontrollerer, om der er blevet registreret en nylig fejl baseret på den grænseværdi, der er indstillet i de primære antivirusindstillinger.';
$string['check_antivirus_error'] = 'Der er blevet registreret {$a->errors} fejl inden for de sidste {$a->lookback}';
$string['check_antivirus_info'] = 'Ingen antivirus-scannere er i øjeblikket aktiveret';
$string['check_antivirus_logstore_not_supported'] = 'Det er ikke muligt at verificere tilstanden af antivirus-scannere på grund af den valgte type logopbevaring';
$string['check_antivirus_name'] = 'Antivirus';
$string['check_antivirus_ok'] = '{$a->scanners} antivirus scanner(e) aktiveret, der er ikke blevet registreret nogen problemer i de sidste {$a->lookback}';
$string['check_configrw_details'] = '<p>It is recommended that the file permissions of <code>config.php</code> are changed after installation so that the file cannot be modified by the web server.
Please note that this measure does not improve security of the server significantly, though it may slow down or limit general exploits.</p>';
$string['check_configrw_name'] = 'Skrivbar config.php';
$string['check_configrw_ok'] = 'config.php kan ikke ændres af PHP-scripts.';
$string['check_configrw_warning'] = 'PHP scripts kan ændre config.php.';
$string['check_cookiesecure_details'] = '<p>Hvis https-kommunikation er aktiveret, anbefales det at aktivere afsendelse af sikre cookies. Du bør have permanent omdirigering fra http til https og ideelt set også servere HSTS-overskrifter.</p>';
$string['check_cookiesecure_error'] = 'Venligst aktiver sikre cookies';
$string['check_cookiesecure_http'] = 'Du skal aktivere https for at kunne bruge sikre cookies';
$string['check_cookiesecure_name'] = 'Sikre cookies';
$string['check_cookiesecure_ok'] = 'Sikre cookies er aktiveret.';
$string['check_crawlers_details'] = '<p>Indstillingen "Åben for søgemaskiner" giver søgemaskiner mulighed for at få adgang til kurser med gæsteadgang. Der er ingen grund til at aktivere denne indstilling, hvis gæstlogin ikke er tilladt.</p>';
$string['check_crawlers_error'] = 'Adgang for søgemaskiner er tilladt, men gæsteadgang er deaktiveret.';
$string['check_crawlers_info'] = 'Søgemaskiner kan deltage som gæster.';
$string['check_crawlers_name'] = 'Åben for søgemaskiner';
$string['check_crawlers_ok'] = 'Adgang til søgemaskiner er ikke aktiveret.';
$string['check_defaultuserrole_details'] = '<p>Alle brugere, der er logget ind, tildeles rettighederne for standardbrugerrollen. Sørg venligst for, at der ikke er tilladt risikable rettigheder i denne rolle</p>
<p>Den eneste understøttede ældre type for standardbrugerrollen er <em>Godkendt bruger</em>. Rettigheden til at se kursus må ikke være aktiveret</p>
<p>Kontroller venligst, om indstillingen til automatisk godkendelse af anmodning om sletning af data (tool_dataprivacy | automaticdatadeletionapproval) er aktiveret. Brugere kan anmode om sletninger, der kan slette store mængder data</p>';
$string['check_defaultuserrole_error'] = 'Den standard brugerrolle "{$a}" er forkert defineret!';
$string['check_defaultuserrole_name'] = 'Standardrolle for alle brugere';
$string['check_defaultuserrole_notset'] = 'Standardrolle er ikke indstillet.';
$string['check_defaultuserrole_ok'] = 'Standardrollen for alle brugere er defineret korrekt.';
$string['check_dirindex_info'] = 'Katalogindekset bør ikke være aktiveret';
$string['check_displayerrors_details'] = '<p>Det anbefales ikke at aktivere PHP-indstillingen <code>display_errors</code> på produktionssider, da fejlmeddelelser kan afsløre følsomme oplysninger om din server.</p>';
$string['check_displayerrors_error'] = 'PHP-indstillingen til at vise fejl er aktiveret. Det anbefales, at denne deaktiveres.';
$string['check_displayerrors_name'] = 'Visning af PHP-fejl';
$string['check_displayerrors_ok'] = 'Visning af PHP-fejl er deaktiveret.';
$string['check_dotfiles_info'] = 'Alle dotfiler undtagen /.well-known/* bør ikke være offentlige';
$string['check_emailchangeconfirmation_details'] = '<p>It is recommended that an email confirmation step is required when users change their email address in their profile. If disabled, spammers may try to exploit the server to send spam.</p>
<p>Email field may be also locked from authentication plugins, this possibility is not considered here.</p>';
$string['check_emailchangeconfirmation_error'] = 'Brugere kan indtaste enhver e-mailadresse.';
$string['check_emailchangeconfirmation_info'] = 'Brugere må kun indtaste e-mailadresser fra tilladte domæner.';
$string['check_emailchangeconfirmation_name'] = 'Bekræftelse af ændring af e-mail';
$string['check_emailchangeconfirmation_ok'] = 'Bekræftelse af ændring af e-mailadresse i brugerprofil.';
$string['check_embed_details'] = '<p>Ubegrænset objektindlejring er meget farligt - enhver registreret bruger kan udføre et XSS-angreb mod andre serverbrugere. Denne indstilling bør deaktiveres på produktionsservere.</p>';
$string['check_embed_error'] = 'Ubegrænset objektindlejring aktiveret - dette er meget farligt for flertallet af servere.';
$string['check_embed_name'] = 'Tillad EMBED og OBJECT';
$string['check_embed_ok'] = 'Ubegrænset objektindlejring er ikke tilladt.';
$string['check_frontpagerole_details'] = '<p>Standardrollen for webstedets forside tildeles alle godkendte brugere til aktiviteter på webstedets forside. Sørg venligst for, at der ikke er tilladt risikable rettigheder for denne rolle</p>
<p>Det anbefales, at der oprettes en særlig rolle til dette formål, og at en ældre typerolle ikke anvendes</p>';
$string['check_frontpagerole_error'] = 'Forkert defineret rolle for site-hjem "{$a}" registreret!';
$string['check_frontpagerole_name'] = 'Rolle på hjemmesiden';
$string['check_frontpagerole_notset'] = 'Rollen for site-hjemmet er ikke indstillet.';
$string['check_frontpagerole_ok'] = 'Definitionen af rolle på hjemmesiden er i orden.';
$string['check_guestrole_details'] = '<p>Gæsterollen bruges til gæster, ikke-loggede brugere og midlertidig gæsteadgang til kursus. Sørg venligst for, at der ikke er tilladt risikable rettigheder i denne rolle</p>
<p>Den eneste understøttede ældre type for gæsterollen er <em>Gæst</em></p>';
$string['check_guestrole_error'] = 'Gæsterollen "{$a}" er forkert defineret!';
$string['check_guestrole_name'] = 'Gæsterolle';
$string['check_guestrole_notset'] = 'Gæsterolle er ikke indstillet.';
$string['check_guestrole_ok'] = 'Definitionen af gæsterolle er i orden.';
$string['check_nodemodules_details'] = '<p>Biblioteket <code>{$a->path}</code> indeholder Node.js-moduler og deres afhængigheder, typisk installeret af NPM-værktøjet. Disse moduler kan være nødvendige for lokal Moodle-udvikling, såsom til brug af grunt-rammen. De er ikke nødvendige for at køre en Moodle-side i produktion, og de kan indeholde potentielt farlig kode, der udsætter din side for fjernangreb.</p><p>Det anbefales stærkt at fjerne biblioteket, hvis siden er tilgængelig via en offentlig URL, eller i det mindste forbyde webadgang til det i din webserverkonfiguration.</p>';
$string['check_nodemodules_info'] = 'Node_modules-mappen bør ikke være til stede på offentlige websteder.';
$string['check_nodemodules_name'] = 'Node.js moduler katalog';
$string['check_openprofiles_details'] = 'Åbne brugerprofiler kan misbruges af spammer. Det anbefales, at enten <code>Force users to log in for profiles</code> eller <code>Force users to log in</code> aktiveres.';
$string['check_openprofiles_error'] = 'Alle kan se brugerprofiler uden at logge ind.';
$string['check_openprofiles_name'] = 'Åbn brugerprofiler';
$string['check_openprofiles_ok'] = 'Login er påkrævet før visning af brugerprofiler.';
$string['check_passwordpolicy_details'] = '<p>It is recommended that a password policy is set, since password guessing is very often the easiest way to gain unauthorised access.
Do not make the requirements too strict though, as this can result in users not being able to remember their passwords and either forgetting them or writing them down.</p>';
$string['check_passwordpolicy_error'] = 'Adgangskodepolitikken er ikke sat.';
$string['check_passwordpolicy_name'] = 'Adgangskodepolitik';
$string['check_passwordpolicy_ok'] = 'Adgangskodepolitikken er aktiveret.';
$string['check_preventexecpath_details'] = '<p>At tillade eksekverbare stier at blive indstillet via Admin GUI er en vektor for privilegieoptrapning. Dette skal tvinges i config.php:</p><p><code>$CFG->preventexecpath = true;</code></p>';
$string['check_preventexecpath_name'] = 'Kørbare stier';
$string['check_preventexecpath_ok'] = 'Udførelsesstier kan kun indstilles i config.php.';
$string['check_preventexecpath_warning'] = 'Kørbare stier kan indstilles i Admin GUI.';
$string['check_publicpaths_403'] = '(Returnerede en 403, ideelt set burde det være 404)';
$string['check_publicpaths_generic'] = '{$a} filer bør ikke være offentlige';
$string['check_publicpaths_name'] = 'Tjek alle offentlige / private stier';
$string['check_publicpaths_ok'] = 'Alle interne stier er ikke offentligt tilgængelige';
$string['check_publicpaths_warning'] = 'Nogle interne stier er offentligt tilgængelige';
$string['check_riskadmin_detailsok'] = '<p>Venligst bekræft følgende liste over systemadministratorer:</p>{$a}';
$string['check_riskadmin_detailswarning'] = '<p>Please verify the following list of system administrators:</p>{$a->admins}
<p>It is recommended to assign administrator role in the system context only. The following users have (unsupported) admin role assignments in other contexts:</p>{$a->unsupported}';
$string['check_riskadmin_name'] = 'Administratorer';
$string['check_riskadmin_ok'] = 'Fundet {$a} serveradministrator(er).';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) gennemgå rolle tildeling</a>';
$string['check_riskadmin_warning'] = 'Fundet {$a->admincount} serveradministratorer og {$a->unsupcount} ikke-understøttede administratorrolle tildelinger.';
$string['check_riskbackup_details_overriddenroles'] = '<p>Disse aktive overstyringer giver brugerne mulighed for at inkludere brugerdata i sikkerhedskopier. Venligst sørg for, at denne tilladelse er nødvendig.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>De følgende systemroller tillader i øjeblikket brugere at inkludere brugerdata i sikkerhedskopier. Venligst sørg for, at denne tilladelse er nødvendig.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>På grund af de ovennævnte roller eller lokale overstyringer har de følgende brugerkonti i øjeblikket tilladelse til at lave sikkerhedskopier, der indeholder private data fra enhver bruger, der er tilmeldt deres kursus. Sørg for, at de er (a) betroede og (b) beskyttede af stærke adgangskoder:</p> {$a}';
$string['check_riskbackup_detailsok'] = 'Ingen roller tillader eksplicit sikkerhedskopiering af brugerdata. Bemærk dog, at administratorer med "doanything" rettigheden stadig sandsynligvis vil være i stand til at gøre dette';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} i {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'Sikkerhedskopiering af brugerdata';
$string['check_riskbackup_ok'] = 'Ingen roller tillader eksplicit backup af brugerdata';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) i {$a->contextname}</a>';
$string['check_riskbackup_warning'] = 'Fundet {$a->rolecount} roller, {$a->overridecount} overstyringer og {$a->usercount} brugere med mulighed for at tage backup af brugerdata.';
$string['check_riskxss_details'] = '<p>RISK_XSS angiver alle farlige rettigheder, som kun betroede brugere må anvende</p>
<p>Kontroller venligst følgende liste over brugere og sørg for, at du fuldt ud stoler på dem på denne server:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS betroede brugere';
$string['check_riskxss_warning'] = 'RISK_XSS - fundet {$a} brugere, der skal være betroet.';
$string['check_unsecuredataroot_details'] = '<p>The dataroot directory must not be accessible via web. The best way to make sure the directory is not accessible is to use a directory outside the public web directory.</p>
<p>If you move the directory, you need to update the <code>$CFG->dataroot</code> setting in <code>config.php</code> accordingly.</p>';
$string['check_unsecuredataroot_error'] = 'Din dataroot-mappe <code>{$a}</code> er i den forkerte placering og er eksponeret for internettet!';
$string['check_unsecuredataroot_name'] = 'Usikker dataroot';
$string['check_unsecuredataroot_ok'] = 'Dataroot-mappen må ikke være tilgængelig via internettet.';
$string['check_unsecuredataroot_warning'] = 'Din dataroot-mappe <code>{$a}</code> er i den forkerte placering og kan være eksponeret for internettet.';
$string['check_upgradefile_info'] = 'Opgraderingsnotefiler bør ikke være offentlige';
$string['check_vendordir_details'] = '<p>Biblioteket <code>{$a->path}</code> indeholder forskellige tredjepartsbiblioteker og deres afhængigheder, typisk installeret af PHP Composer. Disse biblioteker kan være nødvendige for lokal Moodle-udvikling, såsom til installation af PHPUnit-rammen. De er ikke nødvendige for at køre en Moodle-side i produktion, og de kan indeholde potentielt farlig kode, der udsætter din side for fjernangreb.</p><p>Det anbefales kraftigt at fjerne biblioteket, hvis siden er tilgængelig via en offentlig URL, eller i det mindste forbyde webadgang til det i din webserverkonfiguration.</p>';
$string['check_vendordir_info'] = 'Vendor-kataloget bør ikke være til stede på offentlige sider.';
$string['check_vendordir_name'] = 'Leverandørkatalog';
$string['check_webcron_details'] = '<p>At køre cron fra en webbrowser kan afsløre privilegeret information til anonyme brugere. Det anbefales kun at køre cron fra kommandolinjen eller at sætte en cron-adgangskode for fjernadgang.</p>';
$string['check_webcron_name'] = 'Web cron';
$string['check_webcron_ok'] = 'Anonyme brugere kan ikke få adgang til cron.';
$string['check_webcron_warning'] = 'Anonyme brugere kan få adgang til cron.';
$string['configuration'] = 'Konfiguration';
$string['description'] = 'Beskrivelse';
$string['details'] = 'Detaljer';
$string['eventreportviewed'] = 'Set sikkerhedstjekrapport';
$string['issue'] = 'Problem';
$string['pluginname'] = 'Sikkerhedstjek';
$string['privacy:metadata'] = 'Sikkerhedsoverblik-pluginet gemmer ikke nogen personlige data.';
$string['security:view'] = 'Se sikkerhedsrapport';
$string['timewarning'] = 'Databehandlingen kan tage lang tid, vær venlig at være tålmodig...';
