<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qbank_questiongen', language 'ja', version '5.0'.
 *
 * @package     qbank_questiongen
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitylist'] = '活動の一覧';
$string['activitylist_help'] = '質問を生成するために使用するアクティビティを選択してください。複数のアクティビティを選択できます。 <strong>大量のコンテンツを送信すると高額なコストが発生する場合がありますのでご注意ください。また、すべてのアクティビティタイプがサポートされているわけではありません。</strong><br/>
現在サポートされているのは以下のとおりです：
<ul>
  <li>Text and media area</li>
  <li>Page</li>
  <li>File (text-based files types, images and PDF)</li>
  <li>Folder (all folder files with text-based file types, images or PDF, including subdirectories)</li>
  <li>Lesson</li>
  <li>Book</li>
</ul>';
$string['addidentifier'] = '質問名に事前設定されたプレフィックス ("{$a}") を追加する';
$string['addpreset'] = 'プリセットを追加';
$string['aiidentifiersetting'] = '質問名のプレフィックス';
$string['aiidentifiersettingdesc'] = '問題バンクにインポートする際に、質問名に追加するプレフィックスを指定してください。プレフィックスを追加しない場合は空欄のままにします。プレフィックスは質問名の直前にそのまま追加されます。ハイフン、コロン、スペースなどの区切り文字を追加したい場合は、プレフィックスに含めて指定してください。';
$string['aiidentifiertagsetting'] = '質問タグ';
$string['aiidentifiertagsettingdesc'] = '問題バンクにインポートする際に、質問に追加するタグ名を指定してください。タグを追加しない場合は空欄のままにします。';
$string['backtocourse'] = 'コースに戻る';
$string['category'] = '質問カテゴリ';
$string['category_help'] = 'カテゴリの選択が空の場合は、このコースの問題バンクを一度開いてください。';
$string['cleanupdelay'] = 'クリーンアップの待機時間';
$string['cleanupdelaydesc'] = '生成された質問に関するログが "qbank_questiongen"テーブルから削除されるまでに経過する必要のある待機時間。';
$string['cleanuptask'] = 'qbank_questiongenのクリーンアップタスク';
$string['configurepreset'] = 'プリセットを設定';
$string['createdquestionssuccess'] = '質問が正常に作成されました';
$string['createdquestionsuccess'] = '質問が正常に作成されました';
$string['cronoverdue'] = 'cronタスクが実行されていないようです。
質問の生成は、cronタスクによって作成されるアドホックタスクに依存しています。cronの設定を確認してください。
詳細は<a href="https://docs.moodle.org/en/Cron#Setting_up_cron_on_your_system">
https://docs.moodle.org/en/Cron#Setting_up_cron_on_your_system
</a>を参照してください。';
$string['editpreset'] = 'AIに送信する前にプリセットを編集';
$string['errorcoursecontentsempty'] = '選択されたアクティビティの内容が空です。質問を生成できません。';
$string['errorcreatingquestions'] = '質問の作成中にエラーが発生しました： {$a->failed} 件中 {$a->total}件が失敗しました。';
$string['errorcreatingquestionscritical'] = '質問の作成中にエラーが発生しました。質問の生成を再試行してください。';
$string['errorformfieldempty'] = 'フィールドを空にすることはできません。';
$string['errorimagetotextnotavailable'] = 'AIベースの画像からテキストへの変換は利用できません。PDFや画像をコンテンツとして使用することはできません。';
$string['errornoactivitiesselected'] = 'コースのコンテンツを使用して質問を生成する場合は、少なくとも1つのアクティビティを選択する必要があります。';
$string['errornogenerateentriesfound'] = '質問を生成するためのエントリが見つかりませんでした。';
$string['errornotcreated'] = 'エラー：質問が作成されませんでした。';
$string['errorpdfnotsupported'] = '使用しようとしたPDFは互換性がないようです：{$a}';
$string['errorquestiongenunavailable'] = 'AIによる質問生成は利用できません。';
$string['errorstoryempty'] = '質問を生成するには、コンテンツを提供する必要があります。';
$string['errortopicempty'] = '質問を生成するには、トピックを指定する必要があります。';
$string['example'] = '例';
$string['example_help'] = 'この例は、AIに出力の一例を示し、フォーマットを明確に伝えるためのものです。';
$string['exception_presetidmissing'] = 'プリセットIDが見つかりません。';
$string['exception_presetnotfound'] = '{$a} のプリセットが見つかりません。';
$string['generate'] = '質問を生成';
$string['generatemore'] = 'さらに質問を生成';
$string['generating'] = '質問を生成中です…（このページを離れても問題ありません。後で問題バンクで確認できます）';
$string['generationfailed'] = '{$a}回の試行後に質問の生成に失敗しました。';
$string['gotoquestionbank'] = '問題バンクへ移動';
$string['instructions'] = '手順';
$string['instructions_help'] = '手順は、AIに実行内容を指示するものです。';
$string['linktomanagepresetspage'] = 'プリセット管理ページへのリンク';
$string['managepresets'] = 'グローバルプリセットを管理';
$string['managepresetswarning'] = 'このリンクは、プリセットのグローバル管理ページに移動します。このページで行った変更は、プラットフォーム全体に影響します。';
$string['mode'] = 'モード';
$string['mode_help'] = 'モードを選択してください。3つのモードから選択できます：
<ul>
<li><strong>Topic:</strong>生成される質問のトピックを指定します。LLMには、そのトピックに関する質問を学習データから生成するよう指示されます。</li>
<li><strong>コンテンツを提供:</strong>質問を作成するためのコンテンツを提供します。LLMには、提供されたデータ以外を使用しないよう指示されます。十分なデータを提供してください。</li>
<li><strong>Course contents:</strong>現在のコースのコンテンツをもとに質問を作成します。どのコースコンテンツをLLMに送信するかを選択できます。LLMには、提供されたデータ以外を使用しないよう指示されます。十分なデータを提供してください。</li>
</ul>';
$string['modecoursecontents'] = 'コースコンテンツ';
$string['modestory'] = 'コンテンツを提供';
$string['modetopic'] = 'トピック';
$string['name'] = 'プリセット名';
$string['numofquestions'] = '生成する質問数';
$string['numoftries'] = '試行回数：<b>{$a}</b>';
$string['numoftriesdesc'] = '質問の生成またはインポートが失敗した場合に再試行を行う回数';
$string['numoftriesset'] = '再試行回数';
$string['pluginname'] = 'AI質問生成ツール';
$string['pluginname_desc'] = 'この機能を使用すると、大規模言語モデルを利用して、テキストやコースコンテンツから自動的に質問を生成できます。';
$string['pluginname_help'] = 'このプラグインは、コース管理メニューまたは問題バンクから使用できます。';
$string['pluginname_userfaced'] = 'AIベースの質問生成';
$string['preset'] = 'プリセット';
$string['presetdeleteconfirm'] = 'このプリセットを本当に削除しますか？';
$string['presetdeleted'] = 'プリセットが削除されました';
$string['presetformat'] = 'プリセット形式';
$string['presetformatdesc'] = 'LLMが返す例の形式を選択してください。';
$string['presetinstructions'] = 'プリセット手順';
$string['presetname'] = 'プリセット名';
$string['presetnamedesc'] = 'ユーザーに表示される名前';
$string['presetprimer'] = 'プリセットプライマー';
$string['presets'] = 'プリセット';
$string['presetsaved'] = 'プリセットが保存されました。';
$string['primer'] = 'プライマー';
$string['primer_help'] = 'プライマーは、AIに最初に送信される情報であり、タスクの実行に向けてAIを準備させるためのものです。';
$string['privacy:metadata'] = 'AIテキスト質問生成ツールは、個人データを一切保存しません。';
$string['provider'] = 'LLMプロバイダ';
$string['providerdesc'] = '使用するAIバックエンドを選択してください。';
$string['purposeplacedescription_itt'] = '画像およびPDFファイルからテキスト情報を抽出';
$string['purposeplacedescription_questiongeneration'] = '基本的な質問生成機能';
$string['questiongen:manage'] = '質問プリセットを管理';
$string['questiongeneratingfinished'] = '{$a}件の質問生成がすべて処理されました。';
$string['questiongeneratingstatus'] = '{$a->total} 件中{$a->current}件の質問を処理しました。';
$string['sendexistingquestionsascontext'] = '既存の質問をコンテキストとして送信';
$string['sendexistingquestionsascontext_help'] = 'この設定を有効にすると、現在のカテゴリ内にあるすべての質問のタイトルと本文を外部AIシステムに送信し、既存の質問と異なる質問を生成できるようにします。';
$string['story'] = 'コンテンツ';
$string['story_help'] = 'LLMが質問を生成するためのコンテンツを提供してください。このオプションを使用する場合、LLMには自身の学習データを使用せず、ここに入力した内容のみを利用するよう指示されます。
Wikipediaなどから記事全体をコピー＆ペーストすることも可能です。適切な質問を生成するために、十分な内容を提供してください。';
$string['tasksuccess'] = '質問生成タスクが正常に作成されました。';
$string['topic'] = 'トピック';
$string['topic_help'] = '質問のトピックです。LLMに生成させたい質問のトピックを説明してください。';
$string['waitingforadhoctaskstart'] = 'バックグラウンドタスクの開始を待機しています。';
