<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'uk', version '5.0'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Оцінки завершуються:';
$string['activitydate:assessmentsclosed'] = 'Оцінки закриті:';
$string['activitydate:assessmentsopen'] = 'Відкриті оцінки:';
$string['activitydate:assessmentsopened'] = 'Початок оцінювання:';
$string['activitydate:submissionsclose'] = 'Завершення подання:';
$string['activitydate:submissionsclosed'] = 'Подання закрито:';
$string['activitydate:submissionsopen'] = 'Відкриті матеріали:';
$string['activitydate:submissionsopened'] = 'Початок приймання:';
$string['aggregategrades'] = 'Перерахунок оцінок';
$string['aggregation'] = 'Об’єднання оцінок';
$string['allocate'] = 'Розподілення робіт';
$string['allocatedetails'] = 'очікується: {$a->expected}<br />надано: {$a->submitted}<br />до розміщення: {$a->allocate}';
$string['allocation'] = 'Розподілення робіт';
$string['allocationconfigured'] = 'Розподілення налаштовано';
$string['allocationdone'] = 'Розподілення виконано';
$string['allocationerror'] = 'Помилка розподілення';
$string['allowedfiletypesforoverallfeedback'] = 'Дозволені типи файлів, які можна прикріпити до відгуку';
$string['allowedfiletypesforoverallfeedback_help'] = 'Типи вкладених файлів відгуків можна обмежити, надавши список дозволених типів файлів. Якщо поле залишити порожнім, то дозволені всі типи файлів.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'Дозволені типи файлів, які можна прикріпляти до відповіді';
$string['allowedfiletypesforsubmission_help'] = 'Типи вкладених файлів для надсилання можна обмежити, надавши список дозволених типів файлів. Якщо поле залишити порожнім, то дозволені всі типи файлів.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Усі роботи';
$string['alreadygraded'] = 'Вже оцінено';
$string['areaconclusion'] = 'Текст рецензії';
$string['areainstructauthors'] = 'Інструкція до роботи';
$string['areainstructreviewers'] = 'Інструкція до оцінювання';
$string['areaoverallfeedbackattachment'] = 'Долучення загальної рецензії';
$string['areaoverallfeedbackcontent'] = 'Текст загальної рецензії';
$string['areasubmissionattachment'] = 'Долучення до роботи';
$string['areasubmissioncontent'] = 'Текст роботи';
$string['assess'] = 'Оцінити';
$string['assessedexample'] = 'Приклад оцінювання роботи';
$string['assessedsubmission'] = 'Оцінена робота';
$string['assessingexample'] = 'Оцінка прикладу роботи';
$string['assessingsubmission'] = 'Оцінка роботи';
$string['assessment'] = 'Оцінка';
$string['assessmentby'] = 'від <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Оцінка від {$a}';
$string['assessmentbyyourself'] = 'Самооцінка';
$string['assessmentdeleted'] = 'Оцінювання видалено';
$string['assessmentend'] = 'Кінець оцінювання';
$string['assessmentendbeforestart'] = 'Кінець оцінювання не може бути раніше ніж дата початку оцінювання';
$string['assessmentenddatetime'] = 'Кінець оцінювання: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} кінцевий термін оцінки';
$string['assessmentform'] = 'Форма оцінки';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">Оцінення</a>для <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'Рекомендована оцінка';
$string['assessmentreferenceconflict'] = 'Неможливо оцінити приклад роботи, для якої надано посилання оцінювання.';
$string['assessmentreferenceneeded'] = 'Вам потрібно оцінити цей варіант роботи близько до рекомендованої оцінки. Клацніть \'Продовжити\' для оцінювання відповіді.';
$string['assessments'] = 'Оцінки';
$string['assessmentsettings'] = 'Параметри оцінки';
$string['assessmentstart'] = 'Початок оцінювання';
$string['assessmentstartdatetime'] = 'Початок оцінювання {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} відкривається для оцінки';
$string['assessmentweight'] = 'Вага оцінки';
$string['assignedassessments'] = 'Роботи надані для оцінювання';
$string['assignedassessmentsnone'] = 'У вас немає поданих до оцінювання робіт';
$string['backtoeditform'] = 'Повернутися до редагування';
$string['byfullname'] = 'від <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'автор {$a}';
$string['calculategradinggrades'] = 'Вирахувати бали за оцінювання';
$string['calculategradinggradesdetails'] = 'очікується:  {$a->expected}<br />вирахувано: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Вирахувати оцінки за роботи';
$string['calculatesubmissiongradesdetails'] = 'очікується:  {$a->expected}<br />вирахувано: {$a->calculated}';
$string['chooseuser'] = 'Виберіть користувача...';
$string['clearaggregatedgrades'] = 'Очистити всі підсумкові оцінки';
$string['clearaggregatedgrades_help'] = 'Підсумкові оцінки за роботи та бали за оцінювання буде скинуто. Ви можете перерахувати ці бали з нуля використовуючи знову етап оцінювання.';
$string['clearaggregatedgradesconfirm'] = 'Ви впевнені, що хочете очистити обраховані бали за роботи та бали за оцінювання?';
$string['clearassessments'] = 'Очистити оцінки';
$string['clearassessments_help'] = 'Пораховані бали за роботи та бали оцінювання було скинуто. Інформація у формі оцінки буде збережена, але всі рецензенти повинні відкрити знову форму оцінювання та перезберегти оцінки, для нового перерахунку.';
$string['clearassessmentsconfirm'] = 'Ви впевнені, що хочете очистити всі бали оцінювання?  Ви не зможете все повернути назад, всі відповіді потрібно буде переоцінити знову.';
$string['conclusion'] = 'Висновок';
$string['conclusion_help'] = 'Текст висновку показується учасникам в кінці семінару.';
$string['configexamplesmode'] = 'Стандартний режим оцінки параметрів у  семінарах.';
$string['configgrade'] = 'Типова максимальна оцінка за роботу у семінарах.';
$string['configgradedecimals'] = 'Типова кількість знаків після коми при показі оцінки.';
$string['configgradinggrade'] = 'Типовий максимальний бал за оцінювання у семінарах.';
$string['configmaxbytes'] = 'Типовий розмір файлу роботи для всіх семінарів на сайті (у межах ліміту курсу та інших обмеженнях)';
$string['configstrategy'] = 'Типова стратегія оцінювання у семінарах';
$string['createsubmission'] = 'Додати подання';
$string['crontask'] = 'Фонова обробка для модуля семінару';
$string['daysago'] = '{$a} дні(в) тому';
$string['daysleft'] = '{$a} дні(в) до закінчення';
$string['daystoday'] = 'сьогодні';
$string['daystomorrow'] = 'завтра';
$string['daysyesterday'] = 'вчора';
$string['deadlinesignored'] = 'Тимчасові обмеження не застосовуються до вас';
$string['deletesubmission'] = 'Вилучити відповідь';
$string['editassessmentform'] = 'Редагувати форму оцінювання';
$string['editassessmentformstrategy'] = 'Редагувати форму оцінювання ({$a})';
$string['editingassessmentform'] = 'Редагування форми оцінювання';
$string['editingsubmission'] = 'Редагування роботи';
$string['editsubmission'] = 'Редагувати роботу';
$string['err_multiplesubmissions'] = 'Поки редагувалася ця форма, було збережено ще один варіант роботи. Кілька представлень робіт на одного користувача не дозволяється.';
$string['err_removegrademappings'] = 'Не вдається видалити співставлення невикористаних оцінок';
$string['evaluategradeswait'] = 'Будь ласка, почекайте, поки розраховуються оцінки та бали за оцінювання';
$string['evaluation'] = 'Оцінювання оцінок';
$string['evaluationmethod'] = 'Метод оцінювання оцінок';
$string['evaluationmethod_help'] = 'Метод оцінювання оцінок визначає, як будуть розраховуватися бали за оцінювання . Ви можете дозволити багаторазово перераховувати бали з різними налаштуваннями, поки не отримаєте прийнятний результат.';
$string['evaluationsettings'] = 'Параметри оцінки';
$string['eventassessableuploaded'] = 'Завантажено роботу';
$string['eventassessmentevaluated'] = 'Оцінено оцінку';
$string['eventassessmentevaluationsreset'] = 'Скинуто оцінення оцінок';
$string['eventassessmentreevaluated'] = 'Переоцінено оцінювання';
$string['eventphaseautomaticallyswitched'] = 'Фаза автоматично перемикається';
$string['eventphaseswitched'] = 'Переключено етап';
$string['eventsubmissionassessed'] = 'Оцінено роботу';
$string['eventsubmissionassessmentsreset'] = 'Очищено оцінення роботи';
$string['eventsubmissioncreated'] = 'Створено рообту';
$string['eventsubmissiondeleted'] = 'Вилучено відповідь';
$string['eventsubmissionreassessed'] = 'Переоцінно роботу';
$string['eventsubmissionupdated'] = 'Оновлено роботу';
$string['eventsubmissionviewed'] = 'Переглянуто роботу';
$string['example'] = 'Варіант роботи';
$string['exampleadd'] = 'Додати варіант роботи';
$string['exampleassess'] = 'Оцінити варіант роботи';
$string['exampleassessments'] = 'Варіант роботи для оцінювання';
$string['exampleassesstask'] = 'Оцінити варіант';
$string['exampleassesstaskdetails'] = 'очікується: {$a->expected}<br />оцінено: {$a->assessed}';
$string['examplecomparing'] = 'Порівняння оцінок варіанту роботи';
$string['exampledelete'] = 'Видалити варіант';
$string['exampledeleteconfirm'] = 'Ви впевнені, що бажаєте видалити вибраний варіант роботи? Клацніть \'Продовжити\' для видалення роботи.';
$string['exampleedit'] = 'Редагувати варіант';
$string['exampleediting'] = 'Редагування варіанту';
$string['exampleneedassessed'] = 'Вам спочатку потрібно оцінити всі надані робіт';
$string['exampleneedsubmission'] = 'Вам спочатку потрібно відправити свою роботу та оцінити всі надані роботи';
$string['examplesbeforeassessment'] = 'Роботи інших доступні після подачі власної роботи та повинні бути оцінені перед отриманням експертної оцінки';
$string['examplesbeforesubmission'] = 'Роботи повинні бути оцінені до власної відповіді';
$string['examplesmode'] = 'Режим оцінювання робіт';
$string['examplesubmissions'] = 'Варіанти робіт';
$string['examplesvoluntary'] = 'Добровільна оцінка варіанту роботи';
$string['exportsubmission'] = 'Експортувати цю сторінку';
$string['feedbackauthor'] = 'Відгук для автора';
$string['feedbackauthorattachment'] = 'Долучення';
$string['feedbackby'] = 'Відгук на {$a}';
$string['feedbackreviewer'] = 'Відгук для рецензента';
$string['feedbacksettings'] = 'Відгук';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Надані оцінки';
$string['grade_grading_name'] = 'Оцінка';
$string['grade_submission_name'] = 'Подання';
$string['gradecalculated'] = 'Розрахунок оцінки за роботу';
$string['gradedecimals'] = 'Кількість десяткових знаків в оцінках';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Оцінка: {$a->received} з {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (оцінка)';
$string['gradeitemsubmission'] = '{$a->workshopname} (робота)';
$string['gradeover'] = 'Перевизначення балів за роботу';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Звіт балів семінару';
$string['gradetopassgrading'] = 'Бали оцінювання для проходження';
$string['gradetopasssubmission'] = 'Бали роботи для проходження';
$string['gradinggrade'] = 'Бали за оцінювання';
$string['gradinggrade_help'] = 'Це налаштування визначає максимальний бал, який може бути отриманим при оцінюванні відповіді.';
$string['gradinggradecalculated'] = 'Розрахунок балів за оцінювання';
$string['gradinggradeof'] = 'Бали за оцінювання (з {$a})';
$string['gradinggradeover'] = 'Перевизначення балів за оцінювання';
$string['gradingsettings'] = 'Налаштування оцінювання';
$string['groupnoallowed'] = 'Вам не надано доступу до жодної з груп в Семінарі';
$string['iamsure'] = 'Так, я впевнений';
$string['indicator:cognitivedepth'] = 'Семінар: пізнавальний аспект';
$string['indicator:cognitivedepth_help'] = 'Цей показник базується на глибині пізнання, досягнутої студентом під час семінару.';
$string['indicator:cognitivedepthdef'] = 'Практикум пізнавальний';
$string['indicator:cognitivedepthdef_help'] = 'Учасник досяг цього відсотка когнітивної активності, запропонованої за допомогою семінару протягом цього інтервалу аналізу (Рівні = Немає перегляду, Переглянути, Надіслати, Переглянути відгук, Коментар до відгуку, Повторно надіслати після перегляду відгуку)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Семінар: соціальний аспект';
$string['indicator:socialbreadth_help'] = 'Цей показник базується на соціальному широті, досягнутої студентом під час семінарської діяльності.';
$string['indicator:socialbreadthdef'] = 'Майстерня соц';
$string['indicator:socialbreadthdef_help'] = 'Учасник досяг цього відсотка соціальної залученості, запропонованої заходами семінару протягом цього інтервалу аналізу (Рівні = Без участі, Учасник сам, Учасник з іншими)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Інформація';
$string['instructauthors'] = 'Інструкція до роботи';
$string['instructreviewers'] = 'Інструкція для оцінювання';
$string['introduction'] = 'Опис';
$string['latesubmissions'] = 'Запізнілі відповіді';
$string['latesubmissions_desc'] = 'Дозволити відповіді після кінцевого терміну';
$string['latesubmissions_help'] = 'Якщо включено, то автор може здати свою роботу після кінцевого терміну або під час етапу оцінювання. Але прострочені відповіді не можуть бути змінені.';
$string['latesubmissionsallowed'] = 'Запізнілі відповіді дозволено';
$string['maxbytes'] = 'Максимальний розмір долученого файлу';
$string['modulename'] = 'Семінар';
$string['modulename_help'] = '<p>Модуль <b>Семінар</b> дозволяє студентам не тільки виконувати власну роботу, а й оцінювати результати роботи інших студентів. Проведення семінару сприяє координації колективу та дозволяє різноманітними способами оцінювати роботи.</p>
<p>Студенти можуть надавати свою роботу у вигляді будь-яких файлів, наприклад документи Word та електронні таблиці, а також можуть вводити текст безпосередньо у текстовий редактор на сторінці семінару.</p>
<p>Викладач може керувати процесом оцінювання та оцінювати сам процес. Матеріали оцінюються за допомогою критеріїв оцінки, визначених викладачем. Викладач може надати зразок роботи для того, щоб студенти могли попрактикуватися, зрозуміти як відбувається процес оцінювання, щоб пізніше об’єктивно оцінити роботи однокурсників. Викладач може самостійно призначити хто які роботи буде оцінювати, або призначення може відбутись випадковим чином. Представлені роботи та рецензії можуть бути анонімними, якщо потрібно.</p>
<p>Студенти отримують дві оцінки за семінар: оцінку за свою роботу та бали за своє оцінювання робіт однокурсників. Обидві оцінки заносяться в журнал оцінок.</p>';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Семінари';
$string['myassessments'] = 'Мої оцінки';
$string['mysubmission'] = 'Моя робота';
$string['nattachments'] = 'Максимальна кількість долучених до роботи файлів';
$string['noexamples'] = 'Ще немає відповідей';
$string['noexamplesformready'] = 'Ви повинні визначити форму оцінювання, перш ніж надавати варіант роботи';
$string['nogradeyet'] = 'Ще не оцінено';
$string['nosubmissionfound'] = 'Не знайдено робіт цього користувача';
$string['nosubmissions'] = 'У цьому семінарі ще не подано жодної роботи';
$string['nosubmissiontype'] = 'Повинен бути доступний принаймні один тип подання';
$string['notassessed'] = 'Ще не оцінювалося';
$string['nothingfound'] = 'Нічого показувати';
$string['nothingtoreview'] = 'Нічого переглядати';
$string['notoverridden'] = 'Не перевизначено';
$string['noworkshops'] = 'Немає семінарів у цьому курсі';
$string['noyoursubmission'] = 'Ви ще не відправляли вашу роботу';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Загальний відгук';
$string['overallfeedbackfiles'] = 'Максимальна кількість долучень до загального відгуку';
$string['overallfeedbackmaxbytes'] = 'Максимальний розмір файлу';
$string['overallfeedbackmode'] = 'Режим загального відгуку';
$string['overallfeedbackmode_0'] = 'Відключено';
$string['overallfeedbackmode_1'] = 'Включено (додатково)';
$string['overallfeedbackmode_2'] = 'Включено (обов’язково)';
$string['overallfeedbackmode_help'] = 'Якщо включено, то текстове поле показується внизу форми оцінювання. Там рецензенти можуть написати загальний відгук на роботу або надати додаткові пояснення своєї оцінки.';
$string['page-mod-workshop-x'] = 'Будь-яка сторінка модуля Семінар';
$string['participant'] = 'Учасник';
$string['participantrevierof'] = 'Учасник рецензент';
$string['participantreviewedby'] = 'Учасник рецензований';
$string['phaseassessment'] = 'Етап оцінювання';
$string['phaseclosed'] = 'Закрито';
$string['phaseevaluation'] = 'Етап оцінювання оцінок';
$string['phasesetup'] = 'Етап налаштування';
$string['phasesoverlap'] = 'Етапи задачі робіт та оцінювання не можуть перетинатися';
$string['phasesubmission'] = 'Етап здачі робіт';
$string['pluginadministration'] = 'Керування семінарами';
$string['pluginname'] = 'Семінар';
$string['prepareexamples'] = 'Попередній варіант відповіді';
$string['previewassessmentform'] = 'Перегляд';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Зведена оцінка за всі оцінки, зроблені користувачем у даній діяльності семінару';
$string['privacy:metadata:assessmentgrade'] = 'Сукупна оцінка за подання, запропонована цим оцінюванням';
$string['privacy:metadata:assessmentgradinggrade'] = 'Оцінка за надання цієї оцінки';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Значення оцінки, змінене вручну для надання цієї оцінки';
$string['privacy:metadata:assessmentid'] = 'Ідентифікатор оцінки';
$string['privacy:metadata:authorid'] = 'Ідентифікатор автора подання';
$string['privacy:metadata:dimensiongrade'] = 'Оцінка за даним виміром оцінки';
$string['privacy:metadata:dimensionid'] = 'Ідентифікатор вимірювання оцінки';
$string['privacy:metadata:example'] = 'Чи є цей запис прикладом подання';
$string['privacy:metadata:feedbackauthor'] = 'Відгук для автора';
$string['privacy:metadata:feedbackauthorformat'] = 'Текстовий формат відгуку для автора';
$string['privacy:metadata:feedbackreviewer'] = 'Зворотній зв\'язок для користувача, який надає оцінку';
$string['privacy:metadata:feedbackreviewerformat'] = 'Текстовий формат відгуку для користувача, який надає оцінку';
$string['privacy:metadata:late'] = 'Чи було подано подання після кінцевого терміну';
$string['privacy:metadata:peercomment'] = 'Прокоментуйте надану оцінку користувачем, який надає оцінку';
$string['privacy:metadata:peercommentformat'] = 'Текстовий формат коментаря до даної оцінки';
$string['privacy:metadata:preference:perpage'] = 'Кількість матеріалів, які користувач вважає за краще бачити на одній сторінці';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Приклад поданих матеріалів".';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Звіт про подані роботи на семінар".';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Форма оцінки".';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Призначені матеріали для оцінки".';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Набір інструментів Workshop".';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Висновок".';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Приклади подання для оцінки".';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Приклади подання для оцінки".';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Звіт про оцінки семінару".';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Інструкції для подання".';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Інструкції для оцінювання".';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Вступ".';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Загальний відгук".';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Ваша подача".';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Опубліковані матеріали".';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Згорнутий/розгорнутий стан для вікна перегляду "Ваші оцінки".';
$string['privacy:metadata:published'] = 'Чи слід опублікувати подання для всіх учасників після закриття семінару';
$string['privacy:metadata:reviewerid'] = 'Ідентифікатор користувача, який надає оцінку';
$string['privacy:metadata:strategy'] = 'Назва підплагіна стратегії оцінювання, що інтерпретує значення запису';
$string['privacy:metadata:submissioncontent'] = 'Зміст подання';
$string['privacy:metadata:submissioncontentformat'] = 'Текстовий формат змісту подання';
$string['privacy:metadata:submissiongrade'] = 'Зведена оцінка за роботу, записана у вигляді десяткового числа з інтервалом 0..100';
$string['privacy:metadata:submissiongradeover'] = 'Значення зведеної оцінки, змінене вручну';
$string['privacy:metadata:submissionid'] = 'Ідентифікатор подання';
$string['privacy:metadata:submissiontitle'] = 'Назва подання';
$string['privacy:metadata:subsystem:corefiles'] = 'Модуль Workshop зберігає файли, вбудовані в текст подання';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Модуль Workshop має вбудовану підтримку систем запобігання плагіату';
$string['privacy:metadata:timeaggregated'] = 'Коли востаннє обчислювався агрегований рейтинг';
$string['privacy:metadata:timecreated'] = 'Коли цей запис створено в базі даних';
$string['privacy:metadata:timemodified'] = 'Коли цей запис востаннє змінювався в базі даних';
$string['privacy:metadata:userid'] = 'Ідентифікатор користувача, для якого обчислюється зведена оцінка';
$string['privacy:metadata:weight'] = 'Вага оцінки';
$string['privacy:metadata:workshopaggregations'] = 'Утримує агреговані оцінки для оцінювання';
$string['privacy:metadata:workshopassessments'] = 'Зберігає інформацію про призначені оцінки модулів семінару';
$string['privacy:metadata:workshopgrades'] = 'Зберігає інформацію про те, як форми оцінювання були заповнені оцінками та коментарями';
$string['privacy:metadata:workshopid'] = 'Ідентифікатор діяльності майстерні';
$string['privacy:metadata:workshopsubmissions'] = 'Зберігає інформацію про подані модулі семінару';
$string['privacy:request:delete:content'] = 'Вміст видалено (за запитом користувача або термін його дії закінчився)';
$string['privacy:request:delete:title'] = '[Видалено]';
$string['publishedsubmissions'] = 'Опубліковані роботи';
$string['publishsubmission'] = 'Публікувати роботу';
$string['publishsubmission_help'] = 'Опубліковані роботи доступні іншим після закінчення семінару.';
$string['reassess'] = 'Переоцінити';
$string['receivedgrades'] = 'Отримані оцінки';
$string['recentassessments'] = 'Оцінки семінару:';
$string['recentsubmissions'] = 'Роботи семінару:';
$string['resetassessments'] = 'Видалити всі оцінювання';
$string['resetassessments_help'] = 'Ви можете вибрати для видалення тільки виділені оцінки, не зачіпаючи роботи. Якщо роботи повинні бути видалені, то їх оцінки будуть видалені також і цей параметр буде проігноровано. Врахуйте, це також розповсюджується і на оцінки прикладів робіт.';
$string['resetphase'] = 'Перемикнути до етапу налаштування';
$string['resetphase_help'] = 'Якщо включено, то всі семінари будуть переведені в початковий етап налаштування.';
$string['resetsubmissions'] = 'Видалити всі роботи';
$string['resetsubmissions_help'] = 'Всі роботи та їх оцінки буде видалено. Це не вплине на приклади робіт.';
$string['saveandclose'] = 'Зберегти та закрити';
$string['saveandcontinue'] = 'Зберегти та продовжити редагування';
$string['saveandpreview'] = 'Зберегти та переглянути';
$string['saveandshownext'] = 'Зберегти та показати наступне';
$string['search:activity'] = 'Семінар - інформація про діяльність';
$string['selfassessmentdisabled'] = 'Самооцінювання заборонене';
$string['showingperpage'] = 'Показати по {$a} елементів на сторінку';
$string['showingperpagechange'] = 'Змінити ...';
$string['someuserswosubmission'] = 'Існує принаймні один автор, який ще не представив свою роботу';
$string['sortasc'] = 'Сортувати за зростанням';
$string['sortdesc'] = 'Сортувати за спаданням';
$string['strategy'] = 'Стратегія оцінювання';
$string['strategy_help'] = 'Стратегія оцінювання визначає, яка форма оцінювання та метод оцінювання будуть використовуватися. Може бути 4 опції:

* Сукупна оцінка - Коментарі та бали надаються згідно зазначених критеріїв
* Коментарі - Коментарі надаються згідно зазначених критеріїв але не оцінюються
* Кількість помилок - Коментарі та оцінювання (так/ні) надаються відповідно зазначених тверджень
* Рубрика - Оцінка надається відповідно специфічного зазначеного критерію';
$string['strategyhaschanged'] = 'Стратегія оцінювання семінару була змінена, оскільки форма була відкрита для редагування.';
$string['submission'] = 'Робота';
$string['submissionattachment'] = 'Долучення';
$string['submissionby'] = 'Робота {$a}';
$string['submissioncontent'] = 'Вміст роботи';
$string['submissiondeleteconfirm'] = 'Ви точно хочете видалити цю відповідь?';
$string['submissiondeleteconfirmassess'] = 'Ви впевнені, що хочете видалити цю відповідь? Зверніть увагу, що це також видалить {$a->count} оцінок пов’язаних з цією відповіддю, що може вплинути на оцінки рецензентів.';
$string['submissionend'] = 'Кінцевий термін здачі';
$string['submissionendbeforestart'] = 'Кінцевий термін здачі не може бути перед датою початку здачі робіт';
$string['submissionenddatetime'] = 'Кінцевий термін: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = 'Кінцевий термін подання: {$a}';
$string['submissionendswitch'] = 'Перемикнути до наступного етапу після кінцевого терміну здачі';
$string['submissionendswitch_help'] = 'Якщо задано закінчення терміну подачі робіт та встановлено цю позначку, то семінар буде автоматично перемикатися на етап оцінювання після закінчення строку подачі робіт.

Якщо ця функція включена, то також рекомендується задати метод планового розподілення. Якщо роботи не розподіляються, то оцінювання не може бути здійснено, навіть якщо семінар знаходиться на етапі оцінювання.';
$string['submissiongrade'] = 'Оцінка за роботу';
$string['submissiongrade_help'] = 'Цей параметр визначає максимальну оцінку, яку можна отримати за представлені роботи.';
$string['submissiongradeof'] = 'Оцінка за роботу (від {$a})';
$string['submissionlastmodified'] = 'Востаннє змінено';
$string['submissionrequiredcontent'] = 'Вам потрібно ввести текст або додати файл.';
$string['submissionrequiredfile'] = 'Вам потрібно додати файл або ввести текст.';
$string['submissionsallocation'] = 'Розподіл подання';
$string['submissionsettings'] = 'Параметри роботи';
$string['submissionsreport'] = 'Звіт по роботах семінару';
$string['submissionstart'] = 'Початок подання робіт';
$string['submissionstartdatetime'] = 'Відкрито для подання робіт з {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} відкривається для подання';
$string['submissiontitle'] = 'Заголовок';
$string['submissiontypedisabled'] = 'Цей тип подання вимкнено для цього семінару.';
$string['submissiontypefileavailable'] = '<span class="accesshide"> Доступне</span> вкладення файлу';
$string['submissiontypefilerequired'] = 'Обов’язковий <span class="accesshide">вкладений файл</span>';
$string['submissiontypes'] = 'Типи подання';
$string['submissiontypetextavailable'] = '<span class="accesshide">Доступний</span> текст онлайн';
$string['submissiontypetextrequired'] = 'Обов’язковий <span class="accesshide">текст онлайн</span>';
$string['submittednotsubmitted'] = 'Здано ({$a->submitted}) / не здано ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Метод розподілу робіт';
$string['subplugintype_workshopallocation_plural'] = 'Методи розподілу робіт';
$string['subplugintype_workshopeval'] = 'Метод виставлення балів за оцінювання';
$string['subplugintype_workshopeval_plural'] = 'Методи виставлення балів за оцінювання';
$string['subplugintype_workshopform'] = 'Стратегія оцінювання';
$string['subplugintype_workshopform_plural'] = 'Стратегії оцінювання';
$string['switchingphase'] = 'Перемикання етапів';
$string['switchphase'] = 'Перемикнути етап';
$string['switchphase10'] = 'Перейдіть до фази налаштування';
$string['switchphase10info'] = 'Ви збираєтеся перемикнути Семінар у <strong>режим Налаштування</strong>. В цьому режимі користувачі не можуть редагувати свої відповіді або свої оцінювання. Викладачі можуть використовувати цей режим для зміни налаштувань, модифікації стратегії оцінювання.';
$string['switchphase20'] = 'Перейдіть до фази подання';
$string['switchphase20info'] = 'Ви збираєтеся перемикнути Семінар у <strong>режим Здачі</strong>. Студенти можуть здавати свої роботи (протягом визначеного для цього часу). Викладачі можуть виділяти роботи для перегляду іншими студентами.';
$string['switchphase30'] = 'Перейдіть на етап оцінювання';
$string['switchphase30auto'] = 'Семінар автоматично перемикнеться до етапу оцінювання після {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Ви збираєтеся перемикнути Семінар у <strong>режим Оцінювання</strong>. На цьому етапі рецензенти можуть оцінювати представлені їм роботи  (протягом визначеного для цього часу).';
$string['switchphase40'] = 'Перейдіть до етапу оцінки';
$string['switchphase40info'] = 'Ви збираєтеся перемикнути Семінар у <strong>режим Оцінювання оцінок</strong>. На цьому етапі користувачі не можуть змінювати свої роботи або свої оцінювання. Викладачі можуть використовувати інструментарій аналізу балів для визначення кінцевих оцінок та написання коментарів рецензентам.';
$string['switchphase50'] = 'Закрити майстерню';
$string['switchphase50info'] = 'Ви збираєтеся закрити семінар. Це призведе до перенесення фінальних оцінок до журналу оцінок. Студенти можуть переглядати свої роботи та  оцінювання свої робіт.';
$string['switchphaseauto'] = 'Перехід заплановано';
$string['switchphasenext'] = 'Перейдіть до наступного етапу';
$string['taskassesspeers'] = 'Оцінення колег';
$string['taskassesspeersdetails'] = 'всього: {$a->total}<br />очікується: {$a->todo}';
$string['taskassessself'] = 'Оцінити себе';
$string['taskconclusion'] = 'Написати висновок для семінару';
$string['taskdone'] = 'Завдання виконано';
$string['taskfail'] = 'Не вдалося виконати завдання';
$string['taskinfo'] = 'Інформація про завдання';
$string['taskinstructauthors'] = 'Надати інструкції по роботі';
$string['taskinstructreviewers'] = 'Надати інструкції по оцінюванню';
$string['taskintro'] = 'Задати вступ до семінару';
$string['tasksubmit'] = 'Здати роботу';
$string['tasktodo'] = 'Завдання виконати';
$string['toolbox'] = 'Інструментарій семінару';
$string['undersetup'] = 'Семінар створено. Будь ласка, зачекайте поки він перейде в наступний етап.';
$string['useexamples'] = 'Використати приклади';
$string['useexamples_desc'] = 'Приклади відповідей надаються для практиці в оцінюванні';
$string['useexamples_help'] = 'Якщо включено, то користувачі можуть спробувати оцінювання однієї або кількох робіт та порівняти їх з рекомендованим оцінюванням. Бали не враховуються в балах за оцінювання.';
$string['usepeerassessment'] = 'Використати оцінювання колеги';
$string['usepeerassessment_desc'] = 'Студенти можуть оцінити роботи інших';
$string['usepeerassessment_help'] = 'Якщо включено, то користувач може переглядати та оцінювати роботи інших і буде отримувати бали за таке оцінювання на додаток до балів за власну роботу.';
$string['userdatecreated'] = 'здано <span>{$a}</span>';
$string['userdatemodified'] = 'змінено <span>{$a}</span>';
$string['userplan'] = 'План семінару';
$string['userplan_help'] = 'План семінару показує всі етапи діяльності та список задач для кожного етапу. Поточний етап буде виділено, а задача закінчення буде позначена спеціальною позначкою.';
$string['userplanaccessibilityskip'] = 'Пропустити до поточних задач';
$string['userplanaccessibilitytitle'] = 'Графік скмінару з {$a} етапами';
$string['userplancurrentphase'] = 'Поточний етап';
$string['useselfassessment'] = 'Використовувати самооцінювання';
$string['useselfassessment_desc'] = 'Студенти можуть оцінити свою власну роботу';
$string['useselfassessment_help'] = 'Якщо включено, то користувач може оцінювати свою власну роботу та отримувати бали за оцінювання до балів за свою роботу.';
$string['viewworkshopsummary'] = 'Переглянути підсумок семінару';
$string['weightinfo'] = 'Вага: {$a}';
$string['withoutsubmission'] = 'Рецензенти без власної роботи';
$string['workshop:addinstance'] = 'Додавати новий семінар';
$string['workshop:allocate'] = 'Розподіляти роботи для оцінювання';
$string['workshop:deletesubmissions'] = 'Видалити відповіді';
$string['workshop:editdimensions'] = 'Редагувати форми оцінювання';
$string['workshop:exportsubmissions'] = 'Експортні подання';
$string['workshop:ignoredeadlines'] = 'Ігнорувати обмеження часу';
$string['workshop:manageexamples'] = 'Управляти варіантами роботи';
$string['workshop:overridegrades'] = 'Перевизначати розраховані оцінки';
$string['workshop:peerassess'] = 'Оцінювати однокурсників';
$string['workshop:publishsubmissions'] = 'Публікувати роботи';
$string['workshop:submit'] = 'Надіслати';
$string['workshop:switchphase'] = 'Перемикати етапи';
$string['workshop:view'] = 'Переглядати семінар';
$string['workshop:viewallassessments'] = 'Переглядати всі оцінювання';
$string['workshop:viewallsubmissions'] = 'Переглядати всі роботи';
$string['workshop:viewauthornames'] = 'Переглядати імена авторів';
$string['workshop:viewauthorpublished'] = 'Бачити автора опублікованої роботи';
$string['workshop:viewpublishedsubmissions'] = 'Переглядати опубліковані роботи';
$string['workshop:viewreviewernames'] = 'Переглядати імена рецензентів';
$string['workshopname'] = 'Назва семінару';
$string['yourassessmentfor'] = 'Ваша оцінка для {$a}';
$string['yourgrades'] = 'Ваші оцінки';
$string['yoursubmission'] = 'Ваша робота';
$string['yoursubmissionwithassessments'] = 'Ваша заявка з оцінками';
