<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'ru', version '5.0'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'Конечная точка API';
$string['action:explain_text:model'] = 'Модель ИИ';
$string['action:explain_text:model_help'] = 'Модель, используемая для объяснения предоставленного текста.';
$string['action:explain_text:systeminstruction'] = 'Системная инструкция';
$string['action:explain_text:systeminstruction_help'] = 'Эта инструкция отправляется в модель ИИ вместе с подсказкой пользователя. Редактирование этой инструкции не рекомендуется, если только это не является абсолютно необходимым.';
$string['action:generate_image:endpoint'] = 'Конечная точка API';
$string['action:generate_image:model'] = 'Модель ИИ';
$string['action:generate_image:model_desc'] = 'Модель, используемая для создания изображений на основе пользовательских подсказок.';
$string['action:generate_image:model_help'] = 'Модель, используемая для создания изображений на основе пользовательских подсказок.';
$string['action:generate_text:endpoint'] = 'Конечная точка API';
$string['action:generate_text:model'] = 'Модель ИИ';
$string['action:generate_text:model_desc'] = 'Модель, используемая для создания текстового ответа.';
$string['action:generate_text:model_help'] = 'Модель, используемая для сощдания текстового ответа.';
$string['action:generate_text:systeminstruction'] = 'Системная инструкция';
$string['action:generate_text:systeminstruction_desc'] = 'Эта инструкция отправляется в модель ИИ вместе с подсказкой пользователя. Редактирование этой инструкции не рекомендуется, если только это не является абсолютно необходимым.';
$string['action:generate_text:systeminstruction_help'] = 'Эта инструкция отправляется в модель ИИ вместе с подсказкой пользователя. Редактирование этой инструкции не рекомендуется, если только это не является абсолютно необходимым.';
$string['action:summarise_text:endpoint'] = 'Конечная точка API';
$string['action:summarise_text:model'] = 'Модель ИИ';
$string['action:summarise_text:model_desc'] = 'Модель, используемая для резюмирования предоставленного текста.';
$string['action:summarise_text:model_help'] = 'Модель, используемая для создания описания предоставленного текста.';
$string['action:summarise_text:systeminstruction'] = 'Системная инструкция';
$string['action:summarise_text:systeminstruction_desc'] = 'Эта инструкция отправляется в модель ИИ вместе с подсказкой пользователя. Редактирование этой инструкции не рекомендуется, если только это не является абсолютно необходимым.';
$string['action:summarise_text:systeminstruction_help'] = 'Эта инструкция отправляется в модель ИИ вместе с подсказкой пользователя. Редактирование этой инструкции не рекомендуется, если только это не является абсолютно необходимым.';
$string['apikey'] = 'Ключ API OpenAI.';
$string['apikey_desc'] = 'Получите ключ из своих <a href="https://platform.openai.com/account/api-keys">ключей API OpenAI</a>.';
$string['apikey_help'] = 'Получите ключ из своих <a href="https://platform.openai.com/account/api-keys" target="_blank">ключей API OpenAI</a>.';
$string['custom_model_name'] = 'Название пользовательской модели';
$string['enableglobalratelimit'] = 'Установить ограничение скорости на уровне всего сайта';
$string['enableglobalratelimit_desc'] = 'Ограничьте количество запросов, которые поставщик API OpenAI может каждый час получать со всего сайта.';
$string['enableuserratelimit'] = 'Установить ограничение скорости для пользователя';
$string['enableuserratelimit_desc'] = 'Ограничьте количество запросов, которые каждый пользователь может сделать поставщику API OpenAI за час.';
$string['extraparams'] = 'Дополнительные параметры';
$string['extraparams_help'] = 'Здесь можно настроить дополнительные параметры. Поддерживается формат JSON. Например:
<pre>
{
    "temperature": 0.5,
    "max_completion_tokens": 100
}
</pre>';
$string['globalratelimit'] = 'Максимальное количество запросов по всему сайту';
$string['globalratelimit_desc'] = 'Количество разрешенных запросов по всему сайту за час.';
$string['invalidjson'] = 'Недопустимая строка JSON';
$string['orgid'] = 'ID организации OpenAI';
$string['orgid_desc'] = 'Получите ID своей организации OpenAI из своей <a href="https://platform.openai.com/account/org-settings">учетной записи OpenAI</a>.';
$string['orgid_help'] = 'Получите ID своей организации OpenAI из своей <a href="https://platform.openai.com/account/org-settings" target="_blank">учетной записи OpenAI</a>.';
$string['pluginname'] = 'Поставщик API OpenAI';
$string['privacy:metadata'] = 'Плагин «Поставщик API OpenAI» не хранит никаких персональных данных.';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Эта информация отправляется в API OpenAI для создания ответа. Настройки вашей учетной записи OpenAI могут изменить способ хранения и запоминание этих данных в OpenAI.  Этим плагином никакие пользовательские данные явно не отправляются в OpenAI и не сохраняются в LMS Moodle.';
$string['privacy:metadata:aiprovider_openai:model'] = 'Модель, используемая для создания ответа.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'Количество изображений, используемых в ответе при создании изображений.';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'Введенная пользователем текстовая подсказка, используемая при создании ответа.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'Формат ответа при создании изображений.';
$string['settings'] = 'Настройки';
$string['settings_frequency_penalty'] = 'штраф за частоту повторений';
$string['settings_frequency_penalty_help'] = 'Штраф за частоту регулирует частоту повторения слов. Чем выше штраф, тем меньше повторений в сгенерированном тексте.';
$string['settings_help'] = 'Отрегулируйте настройки ниже, чтобы настроить способ отправки запросов в OpenAI.';
$string['settings_max_completion_tokens'] = 'max_completion_tokens';
$string['settings_max_completion_tokens_help'] = 'Максимальное количество токенов, используемых в генерируемом тексте.';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Максимальное количество токенов, используемых в генерируемом тексте.';
$string['settings_presence_penalty'] = 'штраф за присутствие повторений';
$string['settings_presence_penalty_help'] = 'Штраф за присутствие повторений побуждает модель использовать новые слова, увеличивая вероятность выбора слов, которые она не использовала ранее. Более высокое значение делает сгенерированный текст более разнообразным, тогда как более низкое значение допускает больше повторений.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'top_p определяет, сколько возможных слов следует рассмотреть. Высокое значение (например, 0,9) означает, что модель рассматривает больше слов, что делает сгенерированный текст более разнообразным.';
$string['userratelimit'] = 'Максимальное количество запросов для пользователя';
$string['userratelimit_desc'] = 'Задайте максимально допустимое количество запросов за час для пользователя.';
