<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'sv', version '5.0'.
 *
 * @package     glossary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcategory'] = 'Lägg till kategori';
$string['addcomment'] = 'Lägg till kommentarer';
$string['addentry'] = 'Nytt uppslagsord';
$string['addingcomment'] = 'Lägg till kommentar';
$string['addsingleentry'] = 'Nytt uppslagsord';
$string['alias'] = 'Nyckelord';
$string['aliases'] = 'Alias';
$string['aliases_help'] = 'Varje uppslagsord kan ha en associerad lista med sökord (eller alias). Om posten är auto-länkad kommer sökorden också vara auto-länkade.

Ange varje sökord på en ny rad (inte avgränsat med kommatecken).';
$string['allcategories'] = 'Alla kategorier';
$string['allentries'] = 'ALLA';
$string['allowcomments'] = 'Tillåt kommentarer för uppslagsord';
$string['allowcomments_help'] = 'Om aktiverad kommer alla deltagare med behörighet att skapa kommentarer att kunna lägga till kommentarer till uppslagsorden.';
$string['allowduplicatedentries'] = 'Tillåt dubbletter';
$string['allowduplicatedentries_help'] = 'Om aktiverat kan flera uppslagsord ha samma begreppsnamn.';
$string['allowprintview'] = 'Tillåt utskriftsvy';
$string['allowprintview_help'] = 'Om detta är aktiverat ser deltagarna en länk till en utskriftsvänlig version av ordlistan. Länken är alltid tillgänglig för lärare.';
$string['andmorenewentries'] = 'och ytterligare {$a} nya uppslagsord.';
$string['answer'] = 'Svar';
$string['approvaldisplayformat'] = 'Visningsformat för godkännande';
$string['approvaldisplayformat_help'] = 'När du godkänner uppslagsord kanske du vill använda ett annat visningsformat';
$string['approve'] = 'Godkänn';
$string['areaattachment'] = 'Bilagor';
$string['areaentry'] = 'Definitioner';
$string['areyousuredelete'] = 'Är du säker på att du vill ta bort det här uppslagsordet?';
$string['areyousuredeletecomment'] = 'Är du säker på att du vill ta bort den här kommentaren?';
$string['areyousureexport'] = 'Är du säker på att du vill exportera det här uppslagsordet till';
$string['ascending'] = 'stigande';
$string['attachment'] = 'Bilaga';
$string['attachment_help'] = 'Du kan valfritt bifoga en eller flera filer till ett uppslagsord.';
$string['author'] = 'författare';
$string['authorview'] = 'Bläddra efter författare';
$string['back'] = 'Tillbaka';
$string['cachedef_concepts'] = 'Begreppslänkning';
$string['cantinsertcat'] = 'Kan inte infoga kategori';
$string['cantinsertrec'] = 'Kan inte infoga post';
$string['cantinsertrel'] = 'Det går inte att infoga relation kategori-post';
$string['casesensitive'] = 'Det här uppslagsordet är skiftlägeskänsligt';
$string['casesensitive_help'] = 'Den här inställningen anger om auto-länkningen av ett uppslagsord är skiftlägeskänslig.';
$string['cat'] = 'kategori';
$string['categories'] = 'Kategorier';
$string['category'] = 'Kategori';
$string['categorydeleted'] = 'Kategori borttagen';
$string['categoryview'] = 'Bläddra efter kategori';
$string['changeto'] = 'ändra till {$a}';
$string['cnfallowcomments'] = 'Ange om en ordlista tillåter kommentarer på uppslagsord som standard.';
$string['cnfallowdupentries'] = 'Ange om en ordlista tillåter dubbletter som standard.';
$string['cnfapprovalstatus'] = 'Ange standard för godkännandestatus för uppslagsord skapade av studenter.';
$string['cnfcasesensitive'] = 'Definiera om en post, när den är länkad, är skiftlägeskänslig som standard';
$string['cnfdefaulthook'] = 'Välj standardurvalet som ska visas när ordlistan visas första gången';
$string['cnfdefaultmode'] = 'Välj standardramen som ska visad när ordlistan visas första gången';
$string['cnffullmatch'] = 'Ange om ett uppslagsord som standard är skiftlägeskänsligt då det matchas mot måltexten';
$string['cnflinkentry'] = 'Ange om ett uppslagsord som standard ska auto-länkas';
$string['cnflinkglossaries'] = 'Ange om en ordlista ska auto-länkas som standard';
$string['cnfrelatedview'] = 'Välj visningsformat för visning av auto-länkning och uppslagsord.';
$string['cnfshowgroup'] = 'Ange om grupp-brytningen ska visas eller ej';
$string['cnfsortkey'] = 'Välj sorteringsnyckeln som standard';
$string['cnfsortorder'] = 'Välj sorteringsordningen som standard';
$string['cnfstudentcanpost'] = 'Ange om studenter som standard kan bidra med uppslagsord';
$string['cnftabs'] = 'Välj synliga flikar för detta ordlisteformat';
$string['comment'] = 'Kommentar';
$string['commentdeleted'] = 'Kommentaren har tagits bort';
$string['comments'] = 'Kommentarer';
$string['commentson'] = 'Kommentarer för';
$string['commentupdated'] = 'Kommentaren har uppdaterats';
$string['completiondetail:entries'] = 'Skapa poster: {$a}';
$string['completionentries'] = 'Studenten måste skapa uppslagsord:';
$string['completionentriesdesc'] = 'Studenten måste skapa minst {$a} uppslagsord';
$string['concept'] = 'Begrepp';
$string['concepts'] = 'Begrepp';
$string['configenablerssfeeds'] = 'Denna inställningen aktiverar möjligheten för RSS-flöden för alla ordlistor. Du kommer fortfarande att behöva aktivera flöden manuellt i inställningarna för varje ordlista.';
$string['current'] = 'För närvarande sorterad {$a}';
$string['currentglossary'] = 'Aktuell ordlista';
$string['date'] = 'datum';
$string['dateview'] = 'Bläddra efter datum';
$string['defaultapproval'] = 'Godkänt som standard';
$string['defaultapproval_help'] = 'Om inställt på nej kräver uppslagsorden godkännande av en lärare innan de kan visas för alla.';
$string['defaulthook'] = 'Förvald \'krok\'';
$string['defaultmode'] = 'Standardläge';
$string['defaultsortkey'] = 'Förvald sorteringsnyckel';
$string['defaultsortorder'] = 'Förvald sorteringsordning';
$string['definition'] = 'Definition';
$string['definitions'] = 'Definitioner';
$string['deletecategory'] = 'Ta bort kategori';
$string['deleteentry'] = 'Ta bort uppslagsord';
$string['deleteentrya'] = 'Ta bort uppslagsord: {$a}';
$string['deletenotenrolled'] = 'Ta bort uppslagsord från användare som inte är registrerade';
$string['deletingcomment'] = 'Tar bort kommentar';
$string['deletingnoneemptycategory'] = 'Om du tar bort den här kategorin tas inte de poster den innehåller bort - de markeras som okategoriserade.';
$string['descending'] = 'fallande';
$string['destination'] = 'Mål för importerade uppslagsord';
$string['destination_help'] = 'Uppslagsord kan antingen importeras och läggas till i den aktuella ordlistan eller i en ny ordlista, vilket i så fall medför att en ny ordlista kommer skapas baserat på information i XML-filen.';
$string['disapprove'] = 'Återkalla godkännande';
$string['displayformat'] = 'Visningsformat';
$string['displayformat_help'] = 'Det finns 7 visningsformat:

* Enkelt - Inga författare visas och bilagor visas som länkar
* Kontinuerligt, utan författare - Uppslagsord visas ett efter ett tillsammans med en redigeringsikon
* Fullständigt, med författare - Ett forum-liknande visningsformat som visar information om författaren samt med bilagor som visas som länkar
* Fullständigt, utan författare - Ett forum-liknande visningsformat utan författarinformation samt med bilagor som visas som länkar
* Encyklopedi - Samma som för "Fullständigt, med författare" men bifogade bilder visas inbäddade
* Lista med uppslagsord - Uppslagsorden är listade som länkar
* FAQ - Orden FRÅGA och SVAR är tillagda till begreppet respektive definitionen';
$string['displayformatcontinuous'] = 'Kontinuerligt, utan författare';
$string['displayformatdefault'] = 'Använd samma som visningsformatet';
$string['displayformatdictionary'] = 'Enkelt';
$string['displayformatencyclopedia'] = 'Encyklopedi';
$string['displayformatentrylist'] = 'Lista med uppslagsord';
$string['displayformatfaq'] = 'FAQ';
$string['displayformatfullwithauthor'] = 'Fullständigt, med författare';
$string['displayformatfullwithoutauthor'] = 'Fullständigt, utan författare';
$string['displayformats'] = 'Visningsformat';
$string['displayformatssetup'] = 'Inställningar för visningsformat';
$string['duplicatecategory'] = 'Dubblettkategori';
$string['duplicateentry'] = 'Dubblettpost';
$string['editalways'] = 'Tillåt alltid redigering';
$string['editalways_help'] = 'Den här inställningen anger om poster alltid kan redigeras eller om deltagarna bara kan redigera sina poster under en förkonfigurerad redigeringstid (vanligtvis 30 minuter).';
$string['editcategories'] = 'Redigera kategorier';
$string['editcategory'] = 'Redigera kategori';
$string['editentry'] = 'Redigera uppslagsord';
$string['editentrya'] = 'Redigera uppslagsord: {$a}';
$string['editingcomment'] = 'Redigerar kommentar';
$string['entbypage'] = 'Antal uppslagsord per sida';
$string['entries'] = 'Uppslagsord';
$string['entrieswithoutcategory'] = 'Uppslagsord utan kategori';
$string['entry'] = 'Uppslagsord';
$string['entryalreadyexist'] = 'Uppslagsordet finns redan';
$string['entryapproved'] = 'Det här uppslagsordet har godkänts';
$string['entrydeleted'] = 'Uppslagsordet borttaget';
$string['entryexported'] = 'Uppslagsordet exporterades';
$string['entryishidden'] = '(detta uppslagsord är dolt)';
$string['entryleveldefaultsettings'] = 'Standardval för inställningar på ingångsnivån ';
$string['entrylink'] = 'Länk till uppslagsord: {$a}';
$string['entrynotapproved'] = 'Uppslagsordet har inte godkänts';
$string['entrysaved'] = 'Det här uppslagsordet har sparats';
$string['entryupdated'] = 'Det här uppslagsordet har uppdaterats';
$string['entryusedynalink'] = 'Det här uppslagsordet bör vara automatiskt länkat';
$string['entryusedynalink_help'] = 'Om webbplatsövergripande ordliste auto-länkning har aktiverats av en administratör och denna checkbox är ikryssad kommer uppslagsordet automatiskt att länkas överallt där ordet och fraserna visas i kursen.';
$string['errcannoteditothers'] = 'Du kan inte redigera andra personers uppslagsord.';
$string['errconceptalreadyexists'] = 'Det här begreppet finns redan med. Det är inte tillåtet med dubbletter i den här ordlistan.';
$string['errdeltimeexpired'] = 'Du kan inte ta bort det här. Tiden har gått ut!';
$string['erredittimeexpired'] = 'Tiden för att redigera det här uppslagsordet har gått ut.';
$string['errorparsingxml'] = 'Det uppstod fel när filen skulle parsas. Säkerställ att det är en giltig syntax för XML.';
$string['eventcategorycreated'] = 'Katagori skapad';
$string['eventcategorydeleted'] = 'Kategori borttagen';
$string['eventcategoryupdated'] = 'Kategori uppdaterad';
$string['evententryapproved'] = 'Uppslagsordet har godkänts';
$string['evententrycreated'] = 'Uppslagsord skapat';
$string['evententrydeleted'] = 'Uppslagsord borttaget';
$string['evententrydisapproved'] = 'Uppslagsordet godkändes ej';
$string['evententryupdated'] = 'Uppslagsordet har uppdaterats';
$string['evententryviewed'] = 'Uppslagsordet har visats';
$string['explainaddentry'] = 'Lägg till ett nytt uppslagsord till den aktuella ordlistan.<br /><b>Begrepp</b> och <b>Definition</b> är obligatoriska fält.';
$string['explainall'] = 'Visar ALLA uppslagsord på en sida';
$string['explainalphabet'] = 'Bläddra i ordlistan med hjälp av detta index';
$string['explainexport'] = 'En fil har skapats.<br />Ladda ned den och spara den på ett säkert ställe. Du kan importera den när helst du vill, i den här kursen eller i någon annan.';
$string['explainimport'] = 'Du måste ange vilken fil som ska importeras och villkoren för processen.<p>Skicka in din förfrågan och titta på resultaten igen.</p>';
$string['explainspecial'] = 'Visa uppslagsord som inte börjar med en bokstav';
$string['export'] = 'Exportera';
$string['exportedentry'] = 'Exporterat uppslagsord';
$string['exportentries'] = 'Exportera uppslagsord';
$string['exportentriestoxml'] = 'Exportera uppslagsorden till en XML-fil';
$string['exportfile'] = 'Exportera uppslagsord till fil';
$string['exportglossary'] = 'Exportera ordlista';
$string['exporttomainglossary'] = 'Exportera till den övergripande ordlistan';
$string['filetoimport'] = 'Fil att importera';
$string['filetoimport_help'] = 'Bläddra efter och välj den XML-fil på din dator som innehåller de uppslagsord du vill importera.';
$string['fillfields'] = '\'Begrepp\' och \'Definition\' är obligatoriska fält';
$string['filtername'] = 'Auto-länkning av ordlista';
$string['fullmatch'] = 'Matcha endast hela ord';
$string['fullmatch_help'] = 'Den här inställningen anger om endast hela ord kommer att länkas. Till exempel kommer inte uppslagsordet "Kaffe" skapa en länk i "Kaffebryggare".';
$string['glossary:addinstance'] = 'Lägg till ny ordlista';
$string['glossary:approve'] = 'Godkänn och ångra godkända uppslagsord';
$string['glossary:comment'] = 'Skapa kommentarer';
$string['glossary:export'] = 'Exportera uppslagsord';
$string['glossary:exportentry'] = 'Exportera enskilt uppslagsord';
$string['glossary:exportownentry'] = 'Exportera enskilt eget uppslagsord';
$string['glossary:import'] = 'Importera uppslagsord';
$string['glossary:managecategories'] = 'Hantera kategorier';
$string['glossary:managecomments'] = 'Hantera kommentarer';
$string['glossary:manageentries'] = 'Hantera uppslagsord';
$string['glossary:rate'] = 'Bedöm uppslagsord';
$string['glossary:view'] = 'Visa ordlista';
$string['glossary:viewallratings'] = 'Visa alla betyg som har avgivits av individer';
$string['glossary:viewanyrating'] = 'Visa alla betyg som någon har erhållit';
$string['glossary:viewrating'] = 'Visa det sammanlagda betyget du fått';
$string['glossary:write'] = 'Skapa nya uppslagsord';
$string['glossaryleveldefaultsettings'] = 'Standardinställningar på ordlistenivå';
$string['glossarytype'] = 'Ordlistetyp';
$string['glossarytype_help'] = 'En huvudordlista är en ordlista till vilken uppslagsord från sekundära ordlistor kan importeras. Det kan bara finnas en huvudordlista i en kurs. Om import av uppslagsord inte är nödvändigt kan samtliga ordlistor i kursen vara sekundära.';
$string['guestnoedit'] = 'Gäster kan inte redigera ordlistor';
$string['importcategories'] = 'Importera kategorier';
$string['importedcategories'] = 'Importerade kategorier';
$string['importedentries'] = 'Importerade uppslagsord';
$string['importentries'] = 'Importera uppslagsord';
$string['importentriesfromxml'] = 'Importera uppslagsord från XML-fil';
$string['includegroupbreaks'] = 'Ta med gruppbrytningar';
$string['indicator:cognitivedepth'] = 'Ordlista kognitivt';
$string['indicator:cognitivedepth_help'] = 'Denna indikator baserad på det kognitiva djup som uppnåtts av studenten i en Ordliste-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'Ordlista kognitivt';
$string['indicator:cognitivedepthdef_help'] = 'Deltagaren har uppnått denna procentandel av det kognitiva engagemanget i Ordliste-aktiviteter under detta analysintervall (Nivåer = Ej visat, Visat, Inlämnat)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Ordlista socialt';
$string['indicator:socialbreadth_help'] = 'Denna indikator baserad på den sociala bredd som uppnåtts av studenten i en Ordliste-aktivitet.';
$string['indicator:socialbreadthdef'] = 'Ordlista socialt';
$string['indicator:socialbreadthdef_help'] = 'Deltagaren har uppnått denna procentandel av det sociala engagemanget i Ordlisteaktiviteterna under detta analysintervall (Nivåer = Inget deltagande, Deltagaren ensamt)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['isglobal'] = 'Detta är en global ordlista';
$string['isglobal_help'] = 'En global ordlista har uppslagsord som är länkade till från hela webbplatsen, snarare än bara i den kurs som ordlistan är definierad i. Endast administratörer kan ange en ordlista som global.';
$string['letter'] = 'bokstav';
$string['linkcategory'] = 'Länka den här kategorin automatiskt';
$string['linkcategory_help'] = 'Om ordliste auto-länkning har aktiverats och den här inställningen är aktiverad, kommer kategorinamnet automatiskt att länkas överallt där det visas i kursen. När en deltagare följer en kategorinamnslänk kommer de till sidan "Bläddra efter kategori" i ordlistan.';
$string['linking'] = 'Automatisk länkning';
$string['mainglossary'] = 'Huvudordlista';
$string['maxtimehaspassed'] = 'Maxtiden för att redigera den här kommentaren har tyvärr gått ut ({$a})';
$string['modulename'] = 'Ordlista';
$string['modulename_help'] = 'Aktiviteten <em>Ordlista</em> gör det möjligt för kursdeltagare att skapa och underhålla en lista över definitioner, som en uppslagsbok, eller att samla in och organisera resurser eller information.

En lärare kan tillåta att filer bifogas till uppslagsord. Bifogade bilder visas i artikeln. Det går att söka på uppslagsord. Det går att bläddra i ordlistan, efter alfabetisk ordning, efter kategori eller efter datum eller författare. Nya uppslagsord kan godkännas som standard eller kräva godkännande av en lärare innan de kan visas för alla.

Om filtret för automatisk länkning av ordlistan är aktiverat kommer uppslagsord att länkas automatiskt där begreppet visas i kursen.

En lärare kan tillåta kommentarer på uppslagsord. Uppslagsorden kan också betygsättas av lärare eller elever (peer evaluation). Betyg kan aggregeras för att bilda ett slutbetyg som registreras i betygsboken.

Ordlistor har många användningsområden, som till exempel

* En samarbetsbank för viktiga termer
* Ett \'lära känna dig\'-utrymme där nya studenter lägger till sina namn och personliga detaljer
* En "praktiska tips"-resurs i för ämne
* En delad yta med användbara videor, bilder eller ljudfiler
* En reviderbar resurs med fakta att komma ihåg';
$string['modulename_link'] = 'mod/glossary/view';
$string['modulenameplural'] = 'Ordlistor';
$string['newentries'] = 'Nya uppslagsord';
$string['newglossary'] = 'Ny ordlista';
$string['newglossarycreated'] = 'En ny ordlista skapad';
$string['newglossaryentries'] = 'Nya uppslagsord:';
$string['nocomment'] = 'Kunde inte hitta någon kommentar';
$string['nocomments'] = '(Det gick inte att hitta någon kommentar till det här uppslagsordet)';
$string['noconceptfound'] = 'Det gick inte att hitta något begrepp eller definition';
$string['noentries'] = 'Hittade inga uppslagsord i det här avsnittet';
$string['noentry'] = 'Hittade inget uppslagsord';
$string['nopermissiontodelcomment'] = 'Du kan inte ta bort andra användares kommentarer!';
$string['nopermissiontodelinglossary'] = 'Du kan inte lämna kommentarer i den här ordlistan.';
$string['nopermissiontoviewresult'] = 'Du kan bara söka resultat bland dina egna uppslagsord';
$string['notapproved'] = 'uppslagsord ännu ej godkänt';
$string['notcategorised'] = 'Ej kategoriserat';
$string['numberofentries'] = 'Antal uppslagsord';
$string['onebyline'] = '(en per rad)';
$string['page-mod-glossary-edit'] = 'Lägg till/ta bort-sida för ordlista';
$string['page-mod-glossary-view'] = 'Visa redigeringssida';
$string['page-mod-glossary-x'] = 'Godtycklig ordlistesida';
$string['pendingapproval'] = 'Väntar på godkännande';
$string['pluginadministration'] = 'Hantera ordlista';
$string['pluginname'] = 'Ordlista';
$string['popupformat'] = 'Popup-format';
$string['print'] = 'Skriv ut';
$string['printerfriendly'] = 'Utskriftsvänlig version';
$string['printviewnotallowed'] = 'Visning av utskrift är inte tillåten.';
$string['privacy'] = 'Resultatsekretess';
$string['privacy:metadata:core_comments'] = 'Kommentarer för ordlistans definitioner lagras med hjälp av <code>core_comment</code>-systemet.';
$string['privacy:metadata:core_files'] = 'Filer länkade till ordlistans definitioner lagras med hjälp av <code>core_files</code>-systemet.';
$string['privacy:metadata:core_rating'] = 'Bedömningar som läggs till för ordlistans definitioner lagras med hjälp av <code>core_rating</code>-systemet.';
$string['privacy:metadata:core_tag'] = 'Etiketter som adderas till ordlistans definitioner lagras med hjälp av <code>core_tag</code>-systemet.';
$string['privacy:metadata:glossary_entries'] = 'Information om användarens ord för en given ordliste-aktivitet';
$string['privacy:metadata:glossary_entries:attachment'] = 'Den bilaga till uppslagsordet som användaren lade till';
$string['privacy:metadata:glossary_entries:concept'] = 'Konceptet för uppslagsordet användare lade till';
$string['privacy:metadata:glossary_entries:definition'] = 'Definitionen av ordet användaren lade till';
$string['privacy:metadata:glossary_entries:glossaryid'] = 'ID:t för ordlisteaktiviteten';
$string['privacy:metadata:glossary_entries:timemodified'] = 'Tidsstämpel som anger när ordlistans post ändrades av användaren';
$string['privacy:metadata:glossary_entries:userid'] = 'Användar-ID:t för användaren som lägger till detta ord i ordlistan';
$string['question'] = 'Fråga';
$string['rejectedentries'] = 'Nekade ord';
$string['rejectionrpt'] = 'Avvisade poster';
$string['removeallglossarytags'] = 'Ta bort alla ordliste-etiketter';
$string['resetglossaries'] = 'Ta bort uppslagsord från';
$string['resetglossariesall'] = 'Ta bort uppslagsord från alla ordlistor';
$string['rssarticles'] = 'Antal senaste RSS-artiklar';
$string['rssarticles_help'] = '<p>Det här alternativet gör det möjligt för dig att markera det antal
artiklar som du vill ta med i RSS-flödet.</p>
<p>Ett antal mellan 5 och 20 bör vara lagom för de flesta ord- och begreppslistor.
 Öka detta antal om ord- och begreppslistan används mycket flitigt.</p>';
$string['rssfeed'] = 'RSS-flöde';
$string['rsssubscriberss'] = 'Visa RSS-flöden för \'{$a}\' koncept';
$string['rsstype'] = 'RSS-flöde för den här aktiviteten';
$string['rsstype_help'] = '<p>Det här alternativet låter dig aktivera RSS-flödentill denna ord- och begreppslista.</p>
<p>Du kan välja mellan två sorters matningar:</p>
<ul>
<li><b>Med författare:</b>Om du använder detta, så kommer de genererade flödena att ta med
namnet på författaren i varje artikel.</li>
<li><b>Utan författare:</b>Om du använder detta, så kommer de genererade flödena INTE att ta med
namnet på författaren i varje artikel.</li>
</ul>';
$string['search:activity'] = 'Ordlista - aktivitetsinformation';
$string['search:entry'] = 'Ordlista - uppslagsord';
$string['searchindefinition'] = 'Fulltextsökning';
$string['secondaryglossary'] = 'Sekundär ordlista';
$string['showall'] = 'Visa länken \'ALLA\'';
$string['showall_help'] = 'Om aktiverat kan studenter söka bland alla uppslagsord samtidigt.';
$string['showalphabet'] = 'Visa alfabetetlänkar';
$string['showalphabet_help'] = 'Om aktiverat kan studenter söka i ordlistan via bokstäverna i alfabetet.';
$string['showspecial'] = 'Visa länken \'Special\'';
$string['showspecial_help'] = 'Om aktiverat kan deltagare söka i ordlistan med hjälp av specialtecken som t.ex. @ och #.';
$string['sortby'] = 'Sortera efter';
$string['sortbycreation'] = 'Efter skapandedatum';
$string['sortbylastupdate'] = 'Efter senaste uppdateringen';
$string['sortchronogically'] = 'Sortera kronologiskt';
$string['special'] = 'Special';
$string['standardview'] = 'Sök med bokstäver';
$string['studentcanpost'] = 'Studenter kan lägga till uppslagsord';
$string['tagarea_glossary_entries'] = 'Uppslagsord';
$string['tagsdeleted'] = 'Ordlisteetiketter har tagits bort';
$string['totalentries'] = 'Totalt antal uppslagsord';
$string['usedynalink'] = 'Länka uppslagsord automatiskt';
$string['usedynalink_help'] = 'Om automatisk länkning av ordlistan har aktiverats globalt av en administratör och den här inställningen är aktiverad innehåller formuläret "Lägg till en ny post" alternativet att automatiskt länka posten där begreppsorden och fraserna visas i kursen.';
$string['visibletabs'] = 'Synliga flikar';
$string['warningstudentcapost'] = '(Gäller enbart om ordlistan inte är huvudordlistan)';
$string['withauthor'] = 'Begrepp med författare';
$string['withoutauthor'] = 'Begrepp utan författare';
$string['writtenby'] = 'av';
$string['youarenottheauthor'] = 'Du är inte författare av denna kommentar och kan därför inte redigera den.';
