<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_stack', language 'sv', version '5.0'.
 *
 * @package     qtype_stack
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ATAlgEquiv_SA_not_equation'] = 'Ditt svar borde vara en ekvation, men är inte det.';
$string['ATAlgEquiv_SA_not_expression'] = 'Ditt svar borde vara ett uttryck, inte en ekvation, olikhet, lista, mängd eller matris.';
$string['ATAlgEquiv_SA_not_inequality'] = 'Ditt svar borde vara en olikhet, men är inte det.';
$string['ATAlgEquiv_SA_not_list'] = 'Ditt svar borde vara en lista, men är inte det. Märk att en lista matas in i formatet [a,b,c].';
$string['ATAlgEquiv_SA_not_matrix'] = 'Ditt svar borde vara en matris, men är inte det.';
$string['ATAlgEquiv_SA_not_set'] = 'Ditt svar borde vara en mängd, men är inte det. Mängder matas in i formatet {a,b,c}.';
$string['ATAlgEquiv_TA_not_equation'] = 'Ditt svar är en ekvation, men borde inte vara det. Matade du möjligen in något i stil med "y=2*x+1" i en situation där du bara behövde mata in "2*x+1"?';
$string['ATCompSquare_false_no_summands'] = 'Den kompletterade kvadraten är av formen ( a(cdotscdots)^2 + b), där (a) och (b) är oberoende av din variabel.  Flera än en av termerna i ditt svar verkar bero på variabeln.';
$string['ATCompSquare_not_AlgEquiv'] = 'Ditt svar verkar vara skrivet på rätt form, men det stämmer inte överens med det rätta svaret.';
$string['ATDiff_error_list'] = 'Svarstestet misslyckades. Var vänlig och kontakta din systemadministratör';
$string['ATDiff_int'] = 'Det ser ut som om du integrerade istället!';
$string['ATFacForm_error_list'] = 'Svarstestet misslyckades. Var vänlig och kontakta din systemadministratör';
$string['ATFacForm_isfactored'] = 'Ditt svar är faktoriserat.';
$string['ATFacForm_notalgequiv'] = 'Ditt svar är inte inte algebraiskt ekvivalent med det rätta svaret. Du måste ha gjort något fel.';
$string['ATFacForm_notfactored'] = 'Ditt svar är inte faktoriserat.';
$string['ATInequality_backwards'] = 'Ditt olikhetstecken verkar vara fel väg.';
$string['ATInequality_nonstrict'] = 'Din olikhet borde vara sträng, men är inte det.';
$string['ATInequality_strict'] = 'Din olikhet borde inte vara sträng.';
$string['ATInt_EqFormalDiff'] = 'Den formella derivatan av ditt svar är densamma som funktionen du ombads att integrera. Trots det, så skiljer ditt svar sig väsentligen från rätt svar, dvs. inte bara med en integrationskonstant. Kontakta din lärare.';
$string['ATInt_const'] = 'Du behöver addera en integrationskonstant. Annars verkar detta stämma.';
$string['ATInt_const_int'] = 'Du behöver addera en integrationskonstant. Konstanten ska vara en symbol för ett godtyckligt tal, inte ett givet tal.';
$string['ATInt_diff'] = 'Det verkar som om du har deriverat i stället!';
$string['ATInt_error_list'] = 'Svarstestet misslyckades. Var vänlig och kontakta din systemadministratör';
$string['ATInt_generic'] = 'Derivatan av ditt svar borde sammanfall amed den funktion du ombads att integrera, nämnligen {$a->m0}  Derivatan av ditt svar, med avseende på {$a->m1} är {$a->m2} så du måste ha gjort något fel.';
$string['ATList_wrongentries'] = 'Felen är markerade med rött: {$a->m0}';
$string['ATLowestTerms_entries'] = 'Följande termer i ditt svar är inte förkortade så långt som möjligt. {$a->m0} Var så vänlig och pröva igen.';
$string['ATLowestTerms_wrong'] = 'Du behöver förenkla bråk i ditt svar.';
$string['ATMatrix_wrongentries'] = 'Felen är markerade med rött: {$a->m0}';
$string['ATMatrix_wrongsz'] = 'Din matris borde ha dimensionerna {$a->m0} gånger {$a->m1}, men den är de facto {$a->m2} gånger {$a->m3}.';
$string['ATNumSigFigs_Inaccurate'] = 'Precisionen i ditt svar är felaktig. Antingen har du avrundat fel, eller så har du använt ett avrundat mellansvar, som ger upphov till senare fel.';
$string['ATNumSigFigs_NotDecimal'] = 'Ditt svar borde vara ett decimaltal, men är inte det.';
$string['ATNumSigFigs_WrongDigits'] = 'Ditt svar innehåller fel antal gällande siffror.';
$string['ATNumSigFigs_WrongSign'] = 'Ditt svar har fel förtecken.';
$string['ATNumSigFigs_error_list'] = 'Svarstestet misslyckades. Kontakta din systemadministratör';
$string['ATPartFrac_denom_ret'] = 'Om ditt svar skrivs som ett enda bråk, så blir nämnaren {$a->m0}. Den borde bli {$a->m1}.';
$string['ATPartFrac_diff_variables'] = 'Du använder andra variabler än de som har getts i frågan. Var vänlig och kontrollera dem.';
$string['ATPartFrac_error_list'] = 'Svarstestet misslyckades. Kontakta din systemadministratör';
$string['ATPartFrac_ret_expression'] = 'Ditt svar skrivet som ett enda bråk är: {$a->m0}';
$string['ATSet_wrongentries'] = 'Följande svar är felaktiga. De kan vara återgivna i en förenklad form jämfört med vad du matade in. {$a->m0}';
$string['ATSet_wrongsz'] = 'Din mängd borde ha {$a->m0} olika element, men den har {$a->m1}.';
$string['ATSingleFrac_div'] = 'Ditt svar innehåller bråk inuti bråk. Du behöver förenkla dessa och svara som ett enda bråk.';
$string['ATSingleFrac_error_list'] = 'Svarstestet misslyckades. Kontakta din systemadministratör';
$string['ATSingleFrac_part'] = 'Ditt svar ska vara ett enda bråk av formen $frac ab$.';
$string['ATSingleFrac_ret_exp'] = 'Ditt svar stämmer inte. Du måste ha gjort något fel.';
$string['ATSingleFrac_var'] = 'Du använder andra variabler än de som har getts i frågan. Var vänlig och kontrollera dem.';
$string['ATSysEquiv_SA_extra_variables'] = 'Ditt svar innehåller för många variabler.';
$string['ATSysEquiv_SA_missing_variables'] = 'Ditt svar saknar en eller flera variabler.';
$string['ATSysEquiv_SA_not_eq_list'] = 'Ditt svar borde vara en lista av ekvationer.';
$string['ATSysEquiv_SA_not_list'] = 'Ditt svar borde vara en lista.';
$string['ATSysEquiv_SA_not_poly_eq_list'] = 'En eller flera av dina ekvationer är inte ett polynom.';
$string['ATSysEquiv_SA_system_overdetermined'] = 'Felen är markerade med rött: {$a->m0}';
$string['ATSysEquiv_SA_system_underdetermined'] = 'De givna ekvationerna verkar stämma, men du behöver flera till.';
$string['ATSysEquiv_SB_not_eq_list'] = 'Lärarens svar är inte en lista av ekvationer.';
$string['ATSysEquiv_SB_not_list'] = 'Lärarens svar är inte en lista. Kontakta din lärare.';
$string['ATSysEquiv_SB_not_poly_eq_list'] = 'Lärarens svar borde vara en lista med polynomekvationer, men är inte det. Kontakta din lärare.';
$string['ATUnits_compatible_units'] = 'Kontrollera dina enheter noggrant.';
$string['ATUnits_incompatible_units'] = 'Dina enheter stämmer inte överens med de som används av läraren.';
$string['AT_InvalidOptions'] = 'Parameterfältet är felaktigt: {$a->errors}';
$string['AT_MissingOptions'] = 'Variabelnamnet saknas i DAS-parameterfältet.';
$string['FacForm_UnPick_morework'] = 'Du kan ännu förenkla {$a->m0} vidare.';
$string['Illegal_floats'] = 'Ditt svar innehåller flyttal, vilket är förbjudet i denhär frågan. Du behöver mata in flyttal som bråk. 0,33... ska t.ex. matas in som 1/3.';
$string['Lowest_Terms'] = 'Ditt svar innehåller oförkortade bråk. Var snäll och förkorta och försök igen.';
$string['Maxima_DivisionZero'] = 'Division med noll.';
$string['Subst'] = 'Ditt svar skulle vara rätt ifall du gjorde följande variabelbyte: {$a->m0}';
$string['TEST_FAILED'] = 'Svarstestet kunde inte utföras på rätt sätt. Var så vänlig och kontakta din lärare. {$a->errors}';
$string['addanothernode'] = 'Lägg till en ny nod';
$string['addanothertestcase'] = 'Lägg till ett nytt testfall...';
$string['addatestcase'] = 'Lägg till ett testfall...';
$string['addingatestcase'] = 'Lägger till ett testfall till fråga {$a}';
$string['all'] = 'Alla';
$string['allowwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Allow_Words';
$string['answernote'] = 'Svarsnot';
$string['answernote_err'] = 'Svarsnoter får inte innehålla tecknet |. Detta tecken läggs till av STACK för att automatiskt dela svarsnoter.';
$string['answernote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md#Answer_note';
$string['answernotedefaultfalse'] = '{$a->prtname}-{$a->nodename}-F';
$string['answernotedefaulttrue'] = '{$a->prtname}-{$a->nodename}-T';
$string['answertest'] = 'Svarstest';
$string['answertest_help'] = 'Ett svarstest används för att jämföra två uttryck och fastställa huruvida de tillfredsställer något givet matematiskt kriterium.';
$string['answertest_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['assumepositive'] = 'Anta positivt';
$string['assumepositive_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Positive';
$string['assumereal_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Real';
$string['autosimplify'] = 'Förenkla automatiskt';
$string['autosimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['autosimplifyprt_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['boxsize'] = 'Inmatningsfältets storlek';
$string['boxsize_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Box_Size';
$string['casdisplay'] = 'DAS-visning';
$string['cassuitecolerrors'] = 'DAS-fel';
$string['casvalid'] = 'V2';
$string['casvalidatemismatch'] = '[DAS-valideringsfel]';
$string['casvalue'] = 'DAS-värde';
$string['chat'] = 'Sänd till DAS';
$string['chat_desc'] = '<a href="{$a->link}">DAS-chatskriptet</a> låter dig testa kopplingen till DAS och Maxima-syntax.';
$string['chatintro'] = 'Den här sidan låter dig evaluera DAS-text direkt. Det enkla skriptet utgör ett minimalt exempel och låter dig testa om DAS fungerar och diverse inmatning.';
$string['chattitle'] = 'Testa kopplingen till DAS';
$string['checkanswertype'] = 'Kontrollera svarets typ';
$string['checkanswertype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Check_Type';
$string['clearthecache'] = 'Töm cacheminnet';
$string['completetestcase'] = 'Fyll i resten av formuläret så, att testet lyckas';
$string['complexno'] = 'Betydelse och visning av sqrt(-1)';
$string['complexno_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#sqrt_minus_one.';
$string['createtestcase'] = 'Skapa ett testfall';
$string['currentlyselectedvariant'] = 'Det här är varianten som visas nedan';
$string['debuginfo'] = 'Felsökningsinformation';
$string['defaultprtcorrectfeedback'] = 'Rätt svar, fint jobbat!';
$string['defaultprtincorrectfeedback'] = 'Ditt svar är tyvärr felaktigt. Försök på nytt!';
$string['defaultprtpartiallycorrectfeedback'] = 'Ditt svar är delvist korrekt. Du uppmanas att försöka på nytt.';
$string['deletetestcase'] = 'Radera testfall {$a->no} för fråga {$a->question}';
$string['deletetestcaseareyousure'] = 'Är du säker på att du vill radera testfall {$a->no} för fråga {$a->question}?';
$string['deletethistestcase'] = 'Radera detta testfall...';
$string['deploy'] = 'Ta i bruk';
$string['deployedvariants'] = 'I bruk tagna slumpvarianter';
$string['editingtestcase'] = 'Redigerar frågans {$a->question} testfall nr. {$a->no}';
$string['editthistestcase'] = 'Redigera detta testfall...';
$string['errors'] = 'Fel';
$string['exceptionmessage'] = '{$a}';
$string['expectedanswernote'] = 'Förväntad svarsnot';
$string['expectedoutcomes'] = 'Förväntat resultat';
$string['expectedpenalty'] = 'Förväntat avdrag';
$string['expectedscore'] = 'Förväntad poäng';
$string['false'] = 'Falskt';
$string['feedbackstyle_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['feedbackvariables'] = 'Feedbackvariabler';
$string['feedbackvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Feedback_variables';
$string['forbidfloat'] = 'Förbjud flyttal';
$string['forbidfloat_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbid_Floats';
$string['forbidwords'] = 'Förbjudna ord';
$string['forbidwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbidden_Words';
$string['generalfeedback'] = 'Allmän feedback';
$string['generalfeedback_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#general_feedback';
$string['healthcheck'] = 'STACK systemkontroll';
$string['healthcheck_desc'] = '<a href="{$a->link}">Systemkontrollskriptet</a> hjälper dig att kontrollera att alla apekter av STACK fungerar korrekt.';
$string['healthcheckcache_db'] = 'DAS-resultaten mellanlagras i databasen.';
$string['healthcheckcache_none'] = 'DAS-resultaten lagras inte i mellanminnet.';
$string['healthcheckconnect'] = 'Försöker koppla upp till DAS.';
$string['healthcheckconnectintro'] = 'Vi försöker evaluera följande DAS-text:';
$string['healthchecklatex'] = 'Kontrollera att LaTeX visas på rätt sätt';
$string['healthchecklatexintro'] = 'STACK genererar LaTeX-kod, och låter Lärare skriva LaTeX-kod i frågor. STACK antar att LaTeX omvandlas till användarvänlig text av ett Moodle-filter. Nedanför finns exempel på formler i LaTeX, som borde visas på rätt sätt i din webbläsare. Om detta inte fungerar, så har du troligen problem med Moodles formelvisning, inte med STACK. Stack använder enbart $ och $ för att indikera LaTeX, men vissa författare använder eventuellt andra format.';
$string['healthchecklatexmathjax'] = 'Ett sätt att få formler att visas på rätt sätt är att kopiera följande kodsnutt till <b>Inom HEAD</b> i <a href="{$a}">Utseende -> Kompletterande HTML</a>.';
$string['healthcheckplots'] = 'Grafritning';
$string['healthcheckplotsintro'] = 'Du borde se två olika grafer. Om du ser två identiska grafer, så har ett problem med namngivning av graffiler uppstått. Om inga felmeddelanden visas, trots att inga grafer syns, så kan en av följande åtgärder eventuellt hjälpa: (i) Kontrollera läsrättigheterna för det två temp-katalogerna. (ii) Ändra inställningarna för GNUPlot. För närvarande finns dessa inställningar inte med i webbgränssnittet.';
$string['healthchecksstackmaximaversionfixserver'] = 'Var god bygg om Maxima-koden på din MaximaPool-server.';
$string['inputdisplayed'] = 'Visas som';
$string['inputentered'] = 'Inmatat värde';
$string['inputexpression'] = 'Testets inmatning';
$string['inputextraoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Extra options';
$string['inputheading'] = 'Inmatning: {$a}';
$string['inputname'] = 'Inmatningens namn';
$string['inputstatus'] = 'Status';
$string['inputstatusname'] = 'Tom';
$string['inputstatusnameinvalid'] = 'Ogiltig';
$string['inputstatusnamescore'] = 'Poäng';
$string['inputstatusnamevalid'] = 'Giltig';
$string['inputtest'] = 'Inmatningstest';
$string['inputtype'] = 'Inmatningstyp';
$string['inputtype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md';
$string['inputtypealgebraic'] = 'Algebraisk inmatning';
$string['inputtypeboolean'] = 'Sant/Falskt';
$string['inputtypedropdown'] = 'Rullgardinsmeny';
$string['inputtypesinglechar'] = 'Ett enda tecken';
$string['inputtypetextarea'] = 'Textruta';
$string['insertstars'] = 'Lägg till asterisker';
$string['insertstars_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Insert_Stars';
$string['inversetrig_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#inverse_trig';
$string['irred_Q_commonint'] = 'Du behöver bryta ut en gemensam faktor.';
$string['irred_Q_optional_fac'] = 'Du kunde ännu faktorisera {$a->m0}, men du behöver inte göra det.';
$string['logicsymbol_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#logicsymbol';
$string['matrixparens_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Matrix.md#matrixparens';
$string['multcross'] = 'Kryss';
$string['multdot'] = 'Punkt';
$string['multiplicationsign'] = 'Tecken för multiplikation';
$string['multiplicationsign_help'] = 'Kontrollerar hur multiplikationstecken visas.';
$string['multiplicationsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#multiplication';
$string['mustverify'] = 'Studenten måste bekräfta';
$string['mustverify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Student_must_verify';
$string['next'] = 'Nästa';
$string['nodehelp'] = 'Nod i responsträd';
$string['nodenotused'] = 'Inga andra noder i PRTt länkar till denna nod.';
$string['nodex'] = 'Nod {$a}';
$string['nodexdelete'] = 'Ta bort nod {$a}';
$string['nodexfalsefeedback'] = 'Nod {$a} feedback vid falsk';
$string['nodextruefeedback'] = 'Nod {$a} feedback vid sann';
$string['nodexwhenfalse'] = 'Om nod {$a} falsk';
$string['nodexwhentrue'] = 'Om nod {$a} sann';
$string['nonempty'] = 'Detta får inte vara tomt.';
$string['notanswered'] = 'Obesvarad';
$string['notestcasesyet'] = 'Inga testfall har ännu lagts till.';
$string['options'] = 'Alternativ';
$string['penalty'] = 'Avdrag';
$string['penalty_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Feedback.md';
$string['penaltyerror'] = 'Avdraget måste vara ett tal mellan 0 och 1.';
$string['penaltyerror2'] = 'Avdraget måste vara tomt eller ett tal mellan 0 och 1.';
$string['phpcasstring'] = 'Visning av PHP';
$string['phpsuitecolerror'] = 'PHP-fel';
$string['phpvalid'] = 'V1';
$string['phpvalidatemismatch'] = '[PHP-valideringsfel]';
$string['pluginname'] = 'STACK';
$string['pluginname_help'] = 'STACK är ett automatiskt bedömningssystem för matematik.';
$string['pluginnameadding'] = 'Lägger till en STACK-fråga';
$string['pluginnameediting'] = 'Redigerar en STACK-fråga';
$string['pluginnamesummary'] = 'STACK möjliggör matematikfrågor i Moodle-test. Ett datoralgebrasystem (DAS) används för att fastställa matematiska egenskaper hos studentens svar.';
$string['prtcorrectfeedback'] = 'Standardfeedback för rätt svar';
$string['prtheading'] = 'Potentiellt responsträd: {$a}';
$string['prtincorrectfeedback'] = 'Standardfeedback för fel svar';
$string['prtname'] = 'PRT:s namn';
$string['prtpartiallycorrectfeedback'] = 'Standardfeedback för delvist korrekt';
$string['prtwillbecomeactivewhen'] = 'Det här PRT:t aktiveras då studerande har besvarat {$a}';
$string['qm_error'] = 'Ditt svar innehåller frågetecken, ?, vilket inte tillåts i svar. Du borde ersätta dessa med ett specifikt värde.';
$string['questiondoesnotuserandomisation'] = 'Denna fråga använder inte randomisering.';
$string['questionnotdeployedyet'] = 'Inga slumpvarianter av den här frågan har ännu tagits i bruk.';
$string['questionnote'] = 'Frågenot';
$string['questionnote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Question_note.md';
$string['questionnotempty'] = 'Frågenoten får inte vara tom då rand() förekommer i frågevariablerna. Frågenoten används för att skilja olika slumpvarianter av frågan åt.';
$string['questionpreview'] = 'Förhandsgranskning av fråga';
$string['questionsimplify'] = 'Förenkla på frågenivå';
$string['questionsimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['questiontests'] = 'Automatisk testning av frågor';
$string['questiontext'] = 'Frågetext';
$string['questiontext_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#question_text';
$string['questiontextfeedbackonlycontain'] = 'Frågetexten kombinerat med den specifika feedbacken innehåller för många kopior av följande texter: {$a}. Dessa måste förekomma en och en gång.';
$string['questiontextmustcontain'] = 'Frågetexten måste innehålla följande texter: {$a}.';
$string['questiontextnonempty'] = 'Frågetexten får inte vara tom.';
$string['questiontextonlycontain'] = 'Frågetexten innehåller för många kopior av följande texter: {$a}. Dessa måste förekomma en och en gång.';
$string['questionvalue'] = 'Frågans värde';
$string['questionvariables'] = 'Frågevariabler';
$string['questionvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Question_variables';
$string['quiet'] = 'Tyst';
$string['requirelowestterms'] = 'Kräv förkortade bråk';
$string['requirelowestterms_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Require_lowest_terms';
$string['runquestiontests'] = 'Kör automatiska frågetest...';
$string['sans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['score'] = 'Poäng';
$string['scoreerror'] = 'Poängen måste vara ett tal mellan 0 och 1.';
$string['settingcasdebugging'] = 'DAS-debugging';
$string['settingcasdebugging_desc'] = 'Väljer om debuginformation om kopplingen till DAS ska sparas.';
$string['settingcasmaximaversion'] = 'Maxima-version';
$string['settingcasmaximaversion_desc'] = 'Version av Maxima som används.';
$string['settingcasresultscache'] = 'Mellanlagring av DAS-resultat';
$string['settingcasresultscache_db'] = 'Cacheminne i databasen';
$string['settingcasresultscache_desc'] = 'Den här inställningen avgör om DAS-anrop lagras i cacheminnet. Inställningen ska vara aktiverad om du inte utvecklar Maxima-koden. Cacheminnets tillstånd visas i systemkontrollskriptet. Om du ändrar dina inställningar, t.ex. för GNUPlot, så måste cacheminnet tömmas innan ändringarna syns.';
$string['settingcasresultscache_none'] = 'Använd inte cacheminne';
$string['settingcastimeout'] = 'Väntetid för svar från DAS';
$string['settingcastimeout_desc'] = 'Hur länge ska STACK vänta på svar från Maxima?';
$string['settingplatformmaximacommand'] = 'Maxima-kommando';
$string['settingplatformmaximacommand_desc'] = 'Stack behöver veta hur Maxima ska startas, och gör en kvalificerad gissning ifall fältet är tomt.';
$string['settingplatformplotcommand'] = 'Kommando för grafritning';
$string['settingplatformplotcommand_desc'] = 'Stack behöver veta hur gnuplot ska köras, och gör en kvalificerad gissning ifall fältet är tomt.';
$string['settingplatformtype'] = 'Serverplattform';
$string['settingplatformtype_desc'] = 'STACK behöver veta vilken typ av operativsystem det körs på. Server- och MaximaPool-alternativen ger bättre prestanda på bekostnad av att en ytterligare server behöver sättas upp. Alternativet "Linux (optimerad)" förklaras på sidan om optimering av Maxima i dokumentationen.';
$string['settingplatformtypeserver'] = 'Server';
$string['showingundeployedvariant'] = 'Visar oanvänd slumpvariant {$a}';
$string['showvalidation'] = 'Visa validering';
$string['showvalidation_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Show_validation';
$string['showvalidationno'] = 'Nej';
$string['specificfeedback'] = 'Specifik feedback';
$string['sqrtsign'] = 'Använd kvadratrotstecken';
$string['sqrtsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#surd';
$string['stackCas_CASError'] = 'DAS gav följande fel:';
$string['stackCas_CASErrorCaused'] = 'orsakade följande fel:';
$string['stackCas_MissingAt'] = 'Du saknar @.';
$string['stackCas_MissingCloseDisplay'] = 'Saknar ]';
$string['stackCas_MissingCloseInline'] = 'Saknar )';
$string['stackCas_MissingDollar'] = 'Du saknar $';
$string['stackCas_MissingOpenDisplay'] = 'Saknar [';
$string['stackCas_MissingOpenInline'] = 'Saknar (';
$string['stackCas_MissingStars'] = 'Du verkar sakna asterisker *. Tänkte du kanske skriva {$a->cmd}?';
$string['stackCas_allFailed'] = 'DAS returnerade inga evaluerade uttryck. Kontrollera din koppling till DAS (Maxima).';
$string['stackCas_apostrophe'] = 'Apostrofer är förbjudna i svaret.';
$string['stackCas_failedReturn'] = 'DAS gav inget data.';
$string['stackCas_failedValidation'] = 'DAS-texten kunde inte valideras';
$string['stackCas_finalChar'] = '\'{$a->char}\' är ett felaktigt sista tecken i {$a->cmd}';
$string['stackCas_forbiddenChar'] = 'DAS-kommandon får inte innehålla följande tecken: {$a->char}.';
$string['stackCas_forbiddenWord'] = 'Uttrycket {$a->forbid} är förbjudet.';
$string['stackCas_invalidCommand'] = 'Ogiltiga DAS-kommandon.';
$string['stackCas_missingLeftBracket'] = 'Du saknar en vänsterparentes <span class="stacksyntaxexample">{$a->bracket}</span> i uttrycket {$a->cmd}.';
$string['stackCas_missingRightBracket'] = 'Du saknar en högerparentes <span class="stacksyntaxexample">{$a->bracket}</span> i uttrycket {$a->cmd}.';
$string['stackCas_newline'] = 'Radbyten är förbjudna i svar.';
$string['stackCas_percent'] = 'Förbudet procenttecken % i uttrycket {$a->expr}.';
$string['stackCas_spaces'] = 'Förbjudna mellanslag i uttrycket {$a->expr}.';
$string['stackCas_unknownFunction'] = 'Obekant funktion: {$a->forbid}.';
$string['stackDoc_404'] = 'Fel 404';
$string['stackDoc_404message'] = 'Filen hittades inte.';
$string['stackDoc_directoryStructure'] = 'Katalogstruktur';
$string['stackDoc_docs'] = 'Dokumentation av STACK';
$string['stackDoc_docs_desc'] = '<a href="{$a->link}">Dokumentation av STACK</a>: en lokal statisk wiki.';
$string['stackDoc_home'] = 'Dokumentationens ingångssida';
$string['stackDoc_index'] = 'Kategoriindex';
$string['stackDoc_siteMap'] = 'Karta över webbplatsen';
$string['stackInstall_input_intro'] = 'Denna sida låter dig testa hur STACK tolkar studentens inmatning. För närvarande används bara de friaste inställningarna. Ett informellt syntax eftersträvas och multiplikationstecken * infogas.<br />\'V\' anger giltighet bedömd av PHP DAS. V1 = PHP giltig, V2 = DAS giltig.';
$string['stackInstall_input_title'] = 'En samling test för att validera studentens inmatning';
$string['stackInstall_input_title_desc'] = '<a href="{$a->link}">Inmatningstesten</a> testar hur STACK tolkar matematiska uttryck. Frågeskapare kan lära sig hur inmatningstesten fungerar via exempel.';
$string['stackInstall_testsuite_choose'] = 'Välj ett svarstest.';
$string['stackInstall_testsuite_fail'] = 'Vissa test misslyckades!';
$string['stackInstall_testsuite_intro'] = 'Den här sidan låter dig test att STACK:s svarstest fungerar som de ska. Märk att endast svarstest kan kontrolleras via webbgränssnittet. Andra Maxima-kommandon behöver kontrolleras via kommandoraden, se unittests.mac.';
$string['stackInstall_testsuite_pass'] = 'Alla test lyckades!';
$string['stackInstall_testsuite_title'] = 'Automatisk testning av STACK:s svarstest';
$string['stackInstall_testsuite_title_desc'] = '<a href="{$a->link}">Automatisk testning av svarstest</a> kontrollerar att Stack:s svarstest fungerar som de ska. Frågeskapare kan också lära sig hur svarstesten fungerar genom exempel.';
$string['stop'] = '[stopp]';
$string['strictsyntax'] = 'Strängt syntax';
$string['strictsyntax_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/';
$string['studentValidation_invalidAnswer'] = 'Detta svar är ogiltigt.';
$string['studentValidation_yourLastAnswer'] = 'Ditt senaste svar tolkades på följande sätt: {$a}';
$string['studentanswer'] = 'Studentens svar';
$string['switchtovariant'] = 'Byt till slumpmässig variant';
$string['syntaxattribute_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['syntaxhint'] = 'Syntaxtips';
$string['syntaxhint_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['tans'] = 'TAns';
$string['tans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['teacheranswer'] = 'Lärarens svar';
$string['teacheranswershow'] = 'Ett rätt svar är \\( {$a->display} \\), vilket kan matas in på följande sätt: {$a->value}';
$string['teacheranswershow_disp'] = 'Ett rätt svar är \\( {$a->display} \\) .';
$string['teachersanswer'] = 'Modellsvar';
$string['teachersanswer_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#model_answer';
$string['testcasexresult'] = 'Testfall {$a->no} {$a->result}';
$string['testingquestion'] = 'Testar fråga {$a}';
$string['testinputs'] = 'Testets inmatningar';
$string['testoptions'] = 'Testets parametrar';
$string['testoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['testoptionsrequired'] = 'Detta test kräver parametrar.';
$string['testsuitecolerror'] = 'DAS-fel';
$string['testsuitecolpassed'] = 'Resultat';
$string['testsuitefail'] = 'Misslyckades';
$string['testsuitepass'] = 'Lyckades';
$string['testthisvariant'] = 'Byt till att testa denna variant';
$string['true'] = 'Sant';
$string['undeploy'] = 'Ta ur bruk';
$string['variantsselectionseed'] = 'Slumpgrupp';
$string['verifyquestionandupdate'] = 'Verifiera frågetexten och uppdatera formuläret';
