<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_o365', language 'da', version '5.0'.
 *
 * @package     local_o365
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acp_healthcheck'] = 'Helbredstjek';
$string['acp_maintenance'] = 'Vedligeholdelsesredskaber';
$string['acp_maintenance_debugdata'] = 'Generer debug-datapakke';
$string['acp_maintenance_debugdata_desc'] = 'Dette vil generere en pakke, der indeholder forskellige oplysninger om dit Moodle- og Microsoft 365-miljø for at hjælpe udviklere med at løse eventuelle problemer, du måtte have. Hvis en udvikler beder om det, skal du køre dette værktøj og sende den resulterende fil til download. Bemærk: Selvom denne pakke ikke indeholder følsomme token-data, beder vi dig om ikke at offentliggøre denne fil eller sende den til en ikke-betroet part.';
$string['acp_maintenance_desc'] = 'Disse værktøjer kan hjælpe dig med at løse hyppigt forekommende problemer.';
$string['acp_maintenance_warning'] = 'Advarsel: Dette er avancerede værktøjer. Brug dem kun hvis du forstår, hvad du gør.';
$string['acp_parentsite_desc'] = 'Site for delte Moodlekursusdata';
$string['acp_parentsite_name'] = 'Moodle';
$string['acp_usermatch'] = 'Brugermatch';
$string['acp_usermatch_desc'] = 'Dette redskab gør det muligt at matche Moodle-brugere med Office 365-brugere. Du skal uploade en fil med Moodle-brugere og de tilknyttede Office 365-brugere og et cron-job vil efterfølgende verificere data og matche brugerne.';
$string['acp_usermatch_matchqueue'] = 'Skridt 2: Matckkø';
$string['acp_usermatch_matchqueue_clearall'] = 'Ryd alle';
$string['acp_usermatch_matchqueue_clearerrors'] = 'Ryd fejl';
$string['acp_usermatch_matchqueue_clearqueued'] = 'Ryd kø';
$string['acp_usermatch_matchqueue_clearsuccess'] = 'Ryd succesfulde';
$string['acp_usermatch_matchqueue_column_muser'] = 'Moodle-brugernavn';
$string['acp_usermatch_matchqueue_column_o365user'] = 'Office 365-brugernavn';
$string['acp_usermatch_matchqueue_column_openidconnect'] = 'OpenId Connect';
$string['acp_usermatch_matchqueue_column_status'] = 'Status';
$string['acp_usermatch_matchqueue_desc'] = 'Denne tabel viser den aktuelle status på matchningen. Hver gang cron-jobbet kører, behandles et udsnit af de følgende brugere. <br/> <b>Bemærk</b> Denne side opdateres ikke dynamisk, så du skal manuelt opdatere siden for se den aktuelle status.';
$string['acp_usermatch_matchqueue_empty'] = 'Matchkøen er tom. Upload en datafil for at tilføje brugere til køen.';
$string['acp_usermatch_matchqueue_status_error'] = 'Fejl: {$a}';
$string['acp_usermatch_matchqueue_status_queued'] = 'Sat i kø';
$string['acp_usermatch_matchqueue_status_success'] = 'Succesfuld';
$string['acp_usermatch_upload'] = 'Skridt 1: Upload nye matches';
$string['acp_usermatch_upload_desc'] = 'Upload en datafil som indeholder Moodle- og Office 365-brugernavne for at matche Moodle-brugere med Office 365-brugere. <br /><br />Filen er en simpel CSV-fil som indeholder tre felter pr. linje: Moodle-brugernavn, Office365-brugernavn og 1 eller 0 som angiver om brugerens login-metode skal skiftes til OpenId Connect. Tilføj ikke andre felter eller yderligere data. <br />Eksempelvis
<pre>moodlebruger1,allan.andersen@eksempel.onmicrosoft.com,1<br />moodlebruger2,bent.bentsen@eksempel.onmicrosoft.com,0</pre>';
$string['acp_usermatch_upload_err_badmime'] = 'Typen {$a} er ikke understøttet. Upload en  CSV-fil';
$string['acp_usermatch_upload_err_data'] = 'Linje  #{$a} indeholder ugyldige data. Hver linje i CSV-filen skal have to felter: Moodle-brugernavn og Office 365-brugernavn';
$string['acp_usermatch_upload_err_fileopen'] = 'Kan ikke åbne og behandle filen. Er rettighederne korrekt i din Moodledata-mappe?';
$string['acp_usermatch_upload_err_nofile'] = 'Der er ikke modtaget nogen fil til køen.';
$string['acp_usermatch_upload_submit'] = 'Tilføj datafil til matchkøen.';
$string['calendar_event'] = 'Vis detaljer';
$string['calendar_setting'] = 'Aktiver synkronisering af Outlook-kalender';
$string['calendar_site'] = 'Site-kalender';
$string['calendar_user'] = 'Personlig kalender';
$string['erroracpauthoidcnotconfig'] = 'Udfyld først applikationens loginoplysninger i auth_oidc-plugin\'et.';
$string['erroracplocalo365notconfig'] = 'Konfigurer local_o365-plugin\'et først.';
$string['errorcouldnotrefreshtoken'] = 'Kunne ikke genopfriske token.';
$string['errorhttpclientbadtempfileloc'] = 'Kunne ikke åbne temp-placering til at gemme fil.';
$string['errorhttpclientnofileinput'] = 'Ingen filparamtre i httpclient::pu';
$string['erroro365apibadcall'] = 'Fejl i API-kald';
$string['erroro365apibadcall_message'] = 'Fejl i API-kald: {$a}';
$string['erroro365apibadpermission'] = 'Tilladelse er ikke fundet';
$string['erroro365apicouldnotcreatesite'] = 'Problem med et oprette site';
$string['erroro365apicoursenotfound'] = 'Kurset blev ikke fundet';
$string['erroro365apiinvalidmethod'] = 'Ugyldig http-metode videresendt til apicall';
$string['erroro365apiinvalidtoken'] = 'Ugyldig eller udløbet token';
$string['erroro365apinoparentinfo'] = 'Kunne ikke finde information om overliggende mappe';
$string['erroro365apinotimplemented'] = 'Dette skal overskrives';
$string['erroro365apinotoken'] = 'Fik ikke en token for den angivne ressource og bruger og kunne ikke hente en. Er brugerens "opdater token" mon udløbet?';
$string['erroro365apisiteexistsnolocal'] = 'Sitet eksisterer allerede, men en lokal post blev ikke fundet.';
$string['errorusermatched'] = 'Office 365-kontoen "{$a->aadupn}" er allerede matchet med Moodle-brugeren  "{$a->username}". Færdiggør forbindelsen ved at logge ind i Moodle som denne bruger og følg instruktionerne i Microsoft-blokken.';
$string['eventapifail'] = 'API-fejl';
$string['eventcalendarsubscribed'] = 'Bruger abonnerer nu på en kalender';
$string['eventcalendarunsubscribed'] = 'Bruger har stoppet abonnement på en kalender';
$string['healthcheck_fixlink'] = 'Klik her for at fikse problemet.';
$string['healthcheck_ratelimit_result_disabled'] = 'Begræsningsfunktion er deaktiveret.';
$string['healthcheck_ratelimit_result_notice'] = 'Kø-funktion i Office 365-integrationen er aktiveret pga. en forøget Moodle-belastning. <br/> <br />Alle Office 365-funktioner er fuldt funktionelle, køen sørger blot for at integrationen ikke overbelaster Office 365. <br />(Level {$a->level} / startet {$a->timestart})';
$string['healthcheck_ratelimit_result_passed'] = 'Office 365 API-kald afvikles med fuld hastighed';
$string['healthcheck_ratelimit_result_warning'] = 'Kø-funktion i Office 365-integrationen er aktiveret pga. en forøget Moodle-belastning. <br/> <br />Alle Office 365-funktioner fungerer, men Office 365-forespørgsler kan tage længere tid. Så snart aktiviteten på Moodle er faldet vil alt køre normalt igen. <br />(Level {$a->level} / startet {$a->timestart})';
$string['healthcheck_ratelimit_title'] = 'API kø-funktion';
$string['help_user_appassign'] = 'Hjælp til tildeling af brugere til applikationen.';
$string['help_user_appassign_help'] = 'Dette vil tildele af Azure AD-konti som er matchet med Moodle-konti til Azure-applikatioen oprettet i denne Moodleinstallation, hvis ikke de er det allerede';
$string['help_user_create'] = 'Hjælp til oprettelse af konti';
$string['help_user_create_help'] = 'Dette vil oprette brugere i Moodle for hver konto i det tilknyttede Azure AD. Kun brugere som endnu ikke har en Moodle-konto vil blive oprettet. Nye konti vil oprettes så de logger ind med deres Office 365 loginoplysninger (ved hjælp af plugin\'et OpenID Connect) og vil kunne bruge alle Office 365/moodle integrationsfunktioner.';
$string['help_user_delete'] = 'Hjælp til sletning af konti.';
$string['help_user_delete_help'] = 'Dette vil slette brugere i Moodle hvis de er markeret som slettede i Azure AD. Moodle-kontoen vil blive slettet og alle brugerdata vil blive fjernet fra Moodle. Vær forsigtig!';
$string['help_user_match'] = 'Hjælp til match konti';
$string['help_user_match_help'] = 'Det vil se på hver bruger i det forbunde Azure Active Directory og forsøge at matche dem med en bruger i Moodle. Denne match er baseret på brugernavne i Azure AD og Moodle. Matchene er versalfølsomme og ignorerer Office 365-lejer. For eksempel ville "Allan.Andersen" i Moodle matche "allan.andersen@eksempel.onmicrosoft.com". Brugere, der matcher vil have forbundet deres Moodle- og Office-konti og vil kunne bruge alle Office 365-/ Moodle-integrationsfunktioner. Brugerens godkendelsesmetode ændres kun hvis indstillingen nedenfor er aktiveret.';
$string['help_user_matchswitchauth'] = 'Skift matchet konti hjælp';
$string['help_user_matchswitchauth_help'] = 'Dette kræver at indstillingen "Match allerede eksisterende Moodle-brugere" er aktiveret. Når en bruger er matchet, vil aktivering af denne indstilling skifte deres godkendelsesmetode til OpenID Connect. De vil så være i stand til at logge ind på Moodle med deres Office 365-legitimationsoplysninger. Bemærk: Sørg for at OpenID Connects godkendelsesplugin er aktiveret hvis du vil bruge denne indstilling.';
$string['help_user_photosync'] = 'Hjælp til Synkroniser Office 365 profilbilleder (cron).';
$string['help_user_photosync_help'] = 'Dette vil synkronisere alle Moodle-profilbilleder med deres Office 365 profil-billede';
$string['help_user_photosynconlogin'] = 'Hjælp til Synkroniser Office 365 profilbilleder (login)';
$string['help_user_photosynconlogin_help'] = 'Dette vil synkronisere alle Moodle-profilbilleder med deres Office 365 profil-billede når brugerne logger ind.';
$string['o365:manageconnectionlink'] = 'Administrer forbindelselink';
$string['o365:manageconnectionunlink'] = 'Administrer afbrydelse af forbindelse til Office 365';
$string['o365:managegroups'] = 'Administrer grupper';
$string['o365:viewgroups'] = 'Vis grupper';
$string['personal_calendar'] = 'Personlig';
$string['pluginname'] = 'Microsoft Office 365-integration';
$string['settings_debugmode'] = 'Registrer debug-beskeder.';
$string['settings_debugmode_details'] = 'Er indstillingen aktiveret, vil der blive logget information til Moodle-loggen som kan hjælpe med at løse problemer.<a href="{$a}">Vis registrerede logbeskeder.</a>';
$string['settings_detectoidc'] = 'Applikations loginoplysninger';
$string['settings_detectoidc_credsinvalid'] = 'Loginoplysninger ikke angivet eller er ikke komplette';
$string['settings_detectoidc_credsvalid'] = 'Loginoplysninger er angivet.';
$string['settings_detectoidc_details'] = 'For at kunne kommunikere med Office&nbsp;365 skal Moodle bruge loginoplysninger. Disse angives i godkendelses-plugin\'et "OpenID Connect".';
$string['settings_detectperms'] = 'Applikationstilladelser.';
$string['settings_detectperms_details'] = 'For at bruge alle funktioner i dette plugin skal du opsætte korrekte tilladelser for applikationen i Azure AD.';
$string['settings_detectperms_errorfix'] = 'Der opstod en fejl i forsøget på at fikse tilladelser. Rediger indstillingerne manuelt i Azure AD.';
$string['settings_detectperms_fixperms'] = 'Fiks tilladelser';
$string['settings_detectperms_invalid'] = 'Tjek tilladelser i Azure AD';
$string['settings_detectperms_missing'] = 'Mangler:';
$string['settings_detectperms_nocreds'] = 'Applikationens loginoplysingerne skal angives først. Se ovenstående indstilling.';
$string['settings_detectperms_nounified'] = 'Microsoft Graph API er ikke tilstede. Nogle features virker måske ikke.';
$string['settings_detectperms_unifiednomissing'] = 'Alle tilladelser er tilstede';
$string['settings_detectperms_update'] = 'Opdater';
$string['settings_detectperms_valid'] = 'Tilladelserne er indstillet.';
$string['settings_fieldmap'] = 'Brugerfelttilknytning';
$string['settings_fieldmap_details'] = 'Konfigurer tilknytning mellem brugerfelter i Office 365 og Moodle';
$string['settings_header_sds'] = 'Skole Data Sync sup>preview</sup>';
$string['settings_header_setup'] = 'Indstillinger';
$string['settings_header_tools'] = 'Værktøjer';
$string['settings_healthcheck'] = 'Helbredstjek';
$string['settings_healthcheck_details'] = 'Hvis noget ikke virker korrekt, vil et helbredstjek som regel kunne identificere problemet og foreslå en løsning';
$string['settings_healthcheck_linktext'] = 'Gennemfør helbredstjek';
$string['settings_maintenance'] = 'Vedligeholdelse';
$string['settings_maintenance_details'] = 'Forskellige vedligeholdelsesopgaver som kan løse almindelige problemer';
$string['settings_maintenance_linktext'] = 'Vis vedligeholdelsesværktøjer';
$string['settings_o365china'] = 'Office&nbsp;365 for Kina';
$string['settings_o365china_details'] = 'Sæt kryds her hvis du anvender Office&nbsp;365 for Kina';
$string['settings_odburl'] = 'OneDrive for Business URL';
$string['settings_odburl_details'] = 'Den URL bruges til at få adgang OneDrive til Business. Dette kan normalt bestemmes af din Azure AD-lejer. Hvis for eksempel din Azure AD-lejer er "contoso.onmicrosoft.com"er det sandsynligvis "contoso-my.sharepoint.com". Indtast kun domænenavnet, ikke http: // eller https: //';
$string['settings_odburl_error'] = 'Vi kunne ikke bestemme din OneDrive til Business-URL. <br />Sørg for at "Office 365 SharePoint Online" er blevet tilføjet til din registrerede applikation i Azure AD.';
$string['settings_options_usersync'] = 'Brugersynkronisering';
$string['settings_options_usersync_desc'] = 'Indstillingen herunder styrer brugersynkroniseringen mellem Office 365 og Moodle';
$string['settings_photoexpire'] = 'Opdateringstid for profilbillede';
$string['settings_photoexpire_details'] = 'Antal timer før profilbilleder opdateres. Længere tider kan øge ydeevnen.';
$string['settings_sds_coursecreation'] = 'Kursusoprettelse';
$string['settings_sds_coursecreation_desc'] = 'Disse indstillinger styrer kursusoprettelse baseret på information i SDS';
$string['settings_sds_coursecreation_enabled'] = 'Opret kurser';
$string['settings_sds_coursecreation_enabled_desc'] = 'Opret kurser til disse skoler';
$string['settings_sds_enrolment_enabled'] = 'Tilmeld brugere';
$string['settings_sds_enrolment_enabled_desc'] = 'Tilmeld lærere og studerende på kurser oprettet fra SDS';
$string['settings_sds_intro_desc'] = 'Værktøjet Synkroniser skoledata ("SDS") giver dig mulighed for at synkronisere oplysninger importeret til Azure AD fra eksterne SIS-systemer til Moodle. <a href="https://sis.microsoft.com/" target="_blank">Få flere oplysninger</a> <br /><br />Processen synkronisering af skoledata sker i Moodles cron kl. 03:00 lokal servertid. Tidspunktet kan ændres på siden <a href="{$a}">Planlagte opgaver</a>. <br /><br />';
$string['settings_sds_intro_previewwarning'] = '<Div class = "alert"> <b>Dette er en forhåndsvisning</b> <br />Forhåndsvisning virker muligvis ikke efter hensigten, eller kan gå ned uden varsel. Fortsæt med forsigtighed.</ Div>';
$string['settings_sds_noschools'] = '<div class="alert alert-info">Der er ingen skoler tilgængelige i SDS</div>';
$string['settings_sds_profilesync'] = 'Profildata-synkronisering';
$string['settings_sds_profilesync_desc'] = 'Disse indstillinger styrer synkronisering af profildata mellem SDS og Moodle';
$string['settings_serviceresourceabstract_detect'] = 'Detekter';
$string['settings_serviceresourceabstract_detecting'] = 'Detekterer…';
$string['settings_serviceresourceabstract_empty'] = 'Angiv en værdi eller klik på "Detekter" for at forsøge at finde den korrekte værdi';
$string['settings_serviceresourceabstract_error'] = 'Der opstod en fejl i forbindelse med detektering. Indstil manuelt';
$string['settings_serviceresourceabstract_invalid'] = 'Denne værdi ser ikke korrekt ud.';
$string['settings_serviceresourceabstract_nocreds'] = 'Angiv applikationens loginoplysninger først';
$string['settings_serviceresourceabstract_valid'] = '{$a} kan bruges.';
$string['settings_setup_step1'] = 'Trin 1: Registrer Moodle med Azure AD';
$string['settings_setup_step1_desc'] = 'Smut over til Azure (<a href="https://manage.windowsazure.com"> manage.windowsazure.com</a>), gå til "Azure AD", og registrer en applikation i din Azure AD-lejer til Moodle med følgende information. Forsikr dig om at informationen skrives i Azure præcis som den står her, da små forskelle kan ødelægge funktionaliteten.';
$string['settings_setup_step2'] = 'Trin 2: Sæt en system API-bruger';
$string['settings_setup_step2_desc'] = 'Systemets API-bruger er en brugerkonto vi bruger til at udføre administration og opgaver i baggrunden med Office 365. Til systemoperationer såsom brugersynkronisering vil Moodle kommunikere med Office 365 som denne bruger.';
$string['settings_setup_step3'] = 'Trin 3: Find yderligere oplysninger og bekræft din opsætning';
$string['settings_setup_step3_desc'] = 'Dette sidste trin samler nogle oplysninger om dit Office 365-miljø, og kontrollerer din konfigurerede Azure AD-applikation. Klik på de to Knapper "Detekter" nedenfor og derefter "Opdater" til Azures opsætning.';
$string['settings_switchauthminupnsplit0'] = 'Mindste længde på upræcist brugernavn for at skifte til Office 365';
$string['settings_switchauthminupnsplit0_details'] = 'Hvis du aktiverer indstillingen "Skift matchede brugere til Office 365-godkendelse", sættes en mindstelængde for brugernavne uden en lejer (@eksample.onmicrosoft.com-delen), som vil blive skiftet. Dette hjælper til at undgå at skifte konti med generiske navne, som "admin", som ikke nødvendigvis er ens i Moodle og Azure AD.';
$string['settings_usermatch'] = 'Brugermatchning';
$string['settings_usermatch_details'] = 'Dette værktøj gør det muligt at matche Moodlebrugere med Office 365-brugere baseret på en uploadet datafil.';
$string['settings_usersynccreationrestriction'] = 'Brugeroprettelsesbegrænsinger';
$string['settings_usersynccreationrestriction_details'] = 'Er indstillingen aktiveret, vil kun brugere der har den angivne værdi for det angivne felt i Azure AD, blive oprettet i løbet af brugersynkroniseringen.';
$string['settings_usersynccreationrestriction_o365group'] = 'Office 365-gruppemedlemsskab';
$string['spsite_group_contributors_desc'] = 'Alle brugere med adgang til at vedligeholde filer på kurset {$a}';
$string['task_calendarsyncin'] = 'Overfør Office 365-begivenheder til Moodle';
$string['task_processmatchqueue'] = 'Afvikl matchkøen';
$string['task_processmatchqueue_err_museralreadymatched'] = 'Moodlebrugeren er allerede matchet med en Office 365-bruger';
$string['task_processmatchqueue_err_museralreadyo365'] = 'Moodle-brugeren er allerede forbundet med Office 365';
$string['task_processmatchqueue_err_nomuser'] = 'Ingen Moodle-bruger blev fundet med dette brugernavn';
$string['task_processmatchqueue_err_noo365user'] = 'Ingen Office 365-bruger blev fundet med dette brugernavn';
$string['task_processmatchqueue_err_o365useralreadyconnected'] = 'Office 365-brugeren er allerede forbundet med en Moodle-bruger';
$string['task_processmatchqueue_err_o365useralreadymatched'] = 'Office 365-brugeren er allerede matchet med en Moodle-bruger';
$string['task_sds_sync'] = 'Synkroniser med SDS';
$string['task_syncusers'] = 'Synkroniser brugere med Azure AD';
$string['ucp_calsync_availcal'] = 'Tilgængelige Moodle-kalendere';
$string['ucp_calsync_desc'] = 'De markerede kalendere vil blive synkroniseret fra Moodle til din Outlook-kalender';
$string['ucp_calsync_title'] = 'Outlook-kalenders synkroniseringsinstillinger';
$string['ucp_connection_desc'] = 'Her kan du konfigurere hvordan du opretter forbindelse til Office&nbsp;365. For at bruge Office 365\'s funktioner, skal du være forbundet til en Office 365-konto. Dette kan opnås som beskrevet nedenfor.';
$string['ucp_connection_disconnected'] = 'Du har ikke forbindelse til Office 365.';
$string['ucp_connection_linked'] = 'Forbind din Moodle- og Office 365-konto';
$string['ucp_connection_linked_active'] = 'Du er forbundet til Office 365-kontoen "{$a}".';
$string['ucp_connection_linked_desc'] = 'Når du knytter din Moodle- og Office 365-konto sammen, kan du bruge Office 365-funktionerne i Moodle uden at ændre hvordan du logger ind i Moodle. <br />Når du klikker på linket herunder, vil du blive sendt til Office 365 en enkelt gang for at logge ind. Når du er logget ind, vil du blive sendt tilbage hertil. Du vil kunne bruge alle Microsoft 365-funktionerne uden at foretage andre ændringer på din Moodle-konto - du logger ind på Moodle, som du altid har gjort.';
$string['ucp_connection_linked_migrate'] = 'Skift til sammenknyttet konto.';
$string['ucp_connection_linked_start'] = 'Knyt din Moodle-konto til en Office 365-konto';
$string['ucp_connection_linked_stop'] = 'Ophæv sammenknytningen mellem din Moodle-konto og din Office 365-konto.';
$string['ucp_connection_options'] = 'Forbindelsesmuligheder:';
$string['ucp_connection_start'] = 'Forbind til Office&nbsp;365';
$string['ucp_connection_status'] = 'Office&nbsp;365-forbindelse er:';
$string['ucp_connection_stop'] = 'Afbryd forbindelsen til Office&nbsp;365';
$string['ucp_connectionstatus'] = 'Forbindelsesstatus';
$string['ucp_features'] = 'Office&nbsp;365-funktioner';
$string['ucp_features_intro'] = 'Herunder er en liste med funktioner du kan bruge til udbygning af Moodle med Office 365.';
$string['ucp_features_intro_notconnected'] = 'Nogle af disse funktioner er ikke tilgængelige før du har forbundet din konto til Office&nbsp;365.';
$string['ucp_general_intro'] = 'Her kan du styre din forbindelse til Office&nbsp;365.';
$string['ucp_general_intro_notconnected_nopermissions'] = 'For at forbinde til Office&nbsp;365 skal du kontakte din siteadministrator.';
$string['ucp_index_calendar_desc'] = 'Her kan du angive synkronisering mellem dine Moodle- og Outlook-kalendere. Du kan eksportere Moodles kalenderbegivenheder til Outlook og hente Outlook-begivenheder ind i Moodle.';
$string['ucp_index_calendar_title'] = 'Indstillinger for kalendersynkronisering i Outlook';
$string['ucp_index_connection_desc'] = 'Konfigurer hvordan du vil forbinde til Office 365';
$string['ucp_index_connection_title'] = 'Office&nbsp;365\'s forbindelsesindstillinger';
$string['ucp_index_connectionstatus_connect'] = 'Klik for at forbinde';
$string['ucp_index_connectionstatus_connected'] = 'Du er forbundet til Office&nbsp;365';
$string['ucp_index_connectionstatus_disconnect'] = 'Afbryd forbindelse';
$string['ucp_index_connectionstatus_login'] = 'Klik her for at logge ind';
$string['ucp_index_connectionstatus_manage'] = 'Administrer forbindelse';
$string['ucp_index_connectionstatus_matched'] = 'Du er matchet med denne Office&nbsp;365-bruger <small>"{$a}"</small>. For at færdiggøre forbindelsen skal du klikke på linket herunder og logge ind i Office&nbsp;365.';
$string['ucp_index_connectionstatus_notconnected'] = 'Du er ikke forbundet til Office&nbsp;365.';
$string['ucp_index_connectionstatus_reconnect'] = 'Genopfrisk forbindelsen';
$string['ucp_index_connectionstatus_title'] = 'Status for forbindelse';
$string['ucp_index_connectionstatus_usinglinked'] = 'Du er knyttet til en Office 365-konto.';
$string['ucp_index_connectionstatus_usinglogin'] = 'Du anvender Office 365 til at logge ind i Moodle med.';
$string['ucp_index_onenote_desc'] = 'OneNote-integration giver dig mulighed for at bruge Office 365\'s OneNote sammen med Moodle. Du kan aflevere opgaver med OneNote og let tage noter undervejs.';
$string['ucp_index_onenote_title'] = 'OneNote';
$string['ucp_notconnected'] = 'Forbind til Office&nbsp;365 før du bruger denne funktion';
$string['ucp_o365accountconnected'] = 'Denne Office 365-konto er allerede forbundet med en anden Moodle-konto';
$string['ucp_options'] = 'Valgmuligheder';
$string['ucp_status_disabled'] = 'Ikke forbundet';
$string['ucp_status_enabled'] = 'Aktiv';
$string['ucp_syncdir_both'] = 'Opdater både Outlook og Moodle';
$string['ucp_syncdir_in'] = 'Fra Outlook til Moodle';
$string['ucp_syncdir_out'] = 'Fra Moodle til Outlook';
$string['ucp_syncdir_title'] = 'Synkroniseringsopførsel:';
$string['ucp_syncwith_title'] = 'Navn på Outlook-kalenderen der skal synkroniseres med:';
$string['ucp_title'] = 'Office 365 / Moodles kontrolpanel';
$string['webservices_error_assignnotfound'] = 'Opgaven kunne ikke findes.';
$string['webservices_error_invalidassignment'] = 'Det modtagede opgave-id kan ikke anvendes med denne webservice-funktion.';
$string['webservices_error_modulenotfound'] = 'Det modtagne modul-id blev ikke fundet.';
$string['webservices_error_sectionnotfound'] = 'Kursussektionen blev ikke fundet.';
