<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'ja', version '5.0'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility:rate:choice'] = '行 {$a->rowposition}, {$a->choicetitle}: カラム {$a->colposition}, {$a->choiceanswer}';
$string['action'] = '操作';
$string['activityoverview'] = 'あなたには期限のあるアンケートがあります。';
$string['additionalinfo'] = '追加情報';
$string['additionalinfo_help'] = 'このアンケートの最初のページの上部に表示されるテキストです (例 インストラクション、背景情報等)。';
$string['addnewquestion'] = '質問 {$a} を追加する';
$string['addnewsection'] = '新しいセクションを追加する';
$string['addquestion'] = '質問を追加する ...';
$string['addquestions'] = '質問を追加する';
$string['addquestiontosection'] = 'セクションに質問を追加する';
$string['addselqtype'] = '選択した質問タイプを追加する';
$string['alignment'] = 'ラジオボタン配置';
$string['alignment_help'] = 'ボタン配置を選択する: 「縦」 (初期値) または「横」';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'すべて';
$string['allnameddegrees'] = '名前付きランク';
$string['allnameddegrees_help'] = '評価値に対して数値の代わりに表示するテキストを指定してください。使用しない場合、空白にしてください。';
$string['alreadyfilled'] = 'あなたはすでにこのアンケート {$a} に回答済みです。ありがとうございます。';
$string['andaveragevalues'] = 'および平均値';
$string['anonymous'] = '匿名';
$string['answer'] = '回答';
$string['answergiven'] = 'この回答がされている';
$string['answernotgiven'] = 'この回答がされていない';
$string['answerquestions'] = 'アンケートに回答する ...';
$string['answers'] = '回答';
$string['attempted'] = 'このアンケートは回答済みです。';
$string['attemptstillinprogress'] = '進行中です。次に保存します:';
$string['autonumbering'] = '自動番号設定';
$string['autonumbering_help'] = '質問およびページの自動番号設定です。条件分岐を使用したアンケートの場合、自動番号設定を無効にした方がよいかもしれません。';
$string['autonumberno'] = '質問またはページに番号を付けない。';
$string['autonumberpages'] = 'ページ番号の自動設定';
$string['autonumberpagesandquestions'] = 'ページおよび質問の番号自動設定';
$string['autonumberquestions'] = '質問の番号自動設定';
$string['average'] = '平均';
$string['averageposition'] = '平均の位置';
$string['averagerank'] = '平均ランク';
$string['averagesrow'] = '平均 (該当する場合):';
$string['bodytext'] = '本文';
$string['boxesnbexact'] = '項目数: {$a}';
$string['boxesnbmax'] = '項目の最大数: {$a}';
$string['boxesnbmin'] = '項目の最小数: {$a}';
$string['boxesnbreq'] = '選択必須';
$string['by'] = 'by';
$string['cannotviewpublicresponses'] = 'あなたはこの公開アンケートの回答を閲覧できません。';
$string['centerlabel'] = '中央ラベル';
$string['chart:bipolar'] = 'バイポーラバー';
$string['chart:hbar'] = '水平バー';
$string['chart:radar'] = 'レーダー';
$string['chart:rose'] = '鶏頭図';
$string['chart:type'] = 'グラフの種類';
$string['chart:type_help'] = 'このフィードバックに使用するグラフの種類を選択してください';
$string['chart:vprogress'] = '縦型プログレスバー';
$string['checkallradiobuttons'] = 'ラジオボタン <strong>{$a}</strong> をチェックしてください！';
$string['checkboxes'] = 'チェックボックス';
$string['checkboxes_help'] = '1つまたは複数の回答を選択するユーザのために1行につき1つのオプションを入力してください。';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = '新しい改ページが挿入されました:';
$string['checkbreaksok'] = '必要なすべての改ページがあります!';
$string['checkbreaksremoved'] = '余分な改ページ {$a} を削除しました。';
$string['checknotstarted'] = 'まだ開始しない';
$string['checkstarted'] = '開始する';
$string['clicktoswitch'] = '(クリックして切り替える)';
$string['closebeforeopen'] = 'あなたは開始日の前に終了日を指定しました。';
$string['closed'] = 'アンケートは {$a} に終了しました。ありがとうございます。';
$string['closedate'] = '終了日';
$string['closeson'] = 'アンケートは {$a} に終了しました。';
$string['completionsubmit'] = '学生が完了するためにはこのアンケートに回答しなければなりません';
$string['condition'] = '条件';
$string['confalts'] = '- または - <br />確認ページ';
$string['configemailreporting'] = 'メールによるレポートを許可する';
$string['configemailreportinglong'] = '指定したメールアドレス宛に直接メールを送信するオプションを有効にします。';
$string['configmaxsections'] = '最大フィードバックセクション';
$string['configusergraph'] = '「性格検査」フィードバックにグラフを表示する';
$string['configusergraphlong'] = '「性格検査」フィードバックグラフの表示にライブラリ<a href="http://www.rgraph.net/">Rgraph</a>を使用します。';
$string['confirmdelallresp'] = 'このアンケートの回答をすべて消去してよろしいですか?';
$string['confirmdelchildren'] = 'あなたがこの質問を削除した場合、その下位質問も削除されます。';
$string['confirmdeletesection'] = '本当にフィードバックセクション「 {$a} 」を削除してもよろしいですか?';
$string['confirmdelgroupresp'] = '本当に {$a} の回答すべてを削除してもよろしいですか?';
$string['confirmdelquestion'] = '本当に {$a} で質問を削除してもよろしいですか?';
$string['confirmdelquestionresps'] = 'これは質問にすでに与えられた {$a} の回答も削除します。';
$string['confirmdelresp'] = '本当に {$a} の回答を削除してよろしいですか?';
$string['confirmremovequestion'] = '本当にセクション「 {$a->sname} 」の質問「 {$a->qname} 」を削除してもよろしいですか?';
$string['confpage'] = '見出し';
$string['confpage_help'] = '見出し (太字) およびユーザがこのアンケートを完了した後に表示される「確認」ページの本文テキストです (特定のURLが存在する場合、確認テキストよりも優先されます)。このフィールドを空白にした場合、次のようなメッセージがアンケート終了時に表示されます (このアンケートに回答していただきありがとうございます)。';
$string['confpagedesc'] = 'ユーザがこの調査を完了した後、「確認」ページで表示される見出し (太字) および本文です (URLが入力されている場合、確認テキストに優先します)。';
$string['contentoptions'] = 'コンテンツオプション';
$string['couldnotcreatenewsurvey'] = '新しいアンケートを作成できませんでした!';
$string['couldnotdelresp'] = '回答を削除できませんでした。';
$string['createcontent'] = '新しいコンテンツを定義する';
$string['createcontent_help'] = 'ラジオボタンのオプションを1つ選択してください。「新規作成」がデフォルトです。';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = '新規作成';
$string['crontask'] = 'アンケートクリーンアップジョブ';
$string['date'] = '日付';
$string['date_help'] = 'あなたが正しくフォーマットされた日付の回答を期待する場合、この質問タイプを使用してください。';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = '「年/月/日」形式を使用してください。例) 1945年3月14日の場合: <strong>1945/3/14</strong>';
$string['deleteallresponses'] = 'すべての回答を削除する';
$string['deletecurrentquestion'] = '質問 {$a} を削除する';
$string['deletedallgroupresp'] = 'グループ {$a} のすべての回答を削除する';
$string['deletedallresp'] = 'アンケートの回答が削除されました。';
$string['deletedisabled'] = 'この項目は削除できません';
$string['deletedresp'] = '削除済み回答';
$string['deleteresp'] = 'この回答を削除する';
$string['deletesection'] = 'このセクションを削除する';
$string['deletingresp'] = '回答削除中';
$string['dependencies'] = '依存関係';
$string['dependquestion'] = '上位の質問';
$string['dependquestion_help'] = 'あなたは上位の質問およびこの質問への誘導オプションを選択できます。上位の質問および該当する誘導オプションが選択されている場合のみ、学生に下位の質問が表示されます。';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = '質問未回答';
$string['directwarnings'] = 'この質問に対する直接の依存関係が削除されます。これは次に影響します:';
$string['displaymethod'] = '回答方法未定義の質問を表示します。';
$string['download'] = 'ダウンロード';
$string['downloadpdf'] = 'PDFをダウンロードする';
$string['downloadtextformat'] = 'ダウンロード';
$string['downloadtextformat_help'] = 'この機能を有効にした場合、あなたはアンケートのすべての回答をサポートされている選択可能なファイル形式に保存できます。
ファイルはスプレッドシートプログラム (例: MS ExcelまたはOpenOffice Calc) または統計解析ソフトウェアで開いてさらに処理できます。';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'レポートタイプ';
$string['dropdown'] = 'ドロップダウンボックス';
$string['dropdown_help'] = '画面のスペースを節約するためにドロップダウンボックスの長めのリストが表示されるような場合を除いて、ラジオボタンの代わりにドロップダウンボックスを使用する実際の利点はありません。';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = '編集';
$string['editingfeedback'] = 'フィードバック設定を編集する';
$string['editingquestionnaire'] = 'アンケート設定を編集する';
$string['editquestion'] = '質問 {$a} を編集する';
$string['email'] = 'メール';
$string['emailextra'] = 'メールにダウンロードを送信する';
$string['emailextra_help'] = 'カンマ区切りのメールアドレス宛にダウンロードファイルを送信します。セキュリティまたはプライバシーに関してチェックされないことに注意してください。 これにアクセスするにはモジュール設定で「allowemailreporting」を有効にする必要があります。';
$string['emailroles'] = 'ロールにダウンロードを送信する';
$string['emailroles_help'] = '「mod/questionnaire:submissionnotification」ケイパビリティを持つすべてのロールにダウンロードファイルをメール送信します。 これにアクセスするにはモジュール設定で「allowemailreporting」を有効にする必要があります。';
$string['emailsend'] = 'レポートを送信する';
$string['emailsnotspecified'] = 'メールアドレスが指定されていません。';
$string['emailssent'] = '指定されたメールアドレス宛にダウンロードが送信されました。';
$string['errnewname'] = '申し訳ございません、このアンケート名はすでに使用されています。新しいアンケート名を入力してください。';
$string['erroropening'] = 'アンケートを開く際にエラーが発生しました。';
$string['errortable'] = 'システムテーブルが壊れているためエラーが発生しました。';
$string['essaybox'] = '長文回答';
$string['essaybox_help'] = 'この質問は**x**「テキストエリア列」 (またはエリア*幅*) および**y**「テキストエリア行」 (テキストの*行数*) のプレインテキストボックスを表示します。あなたがxおよびyの両方をデフォルト値の**0**のままにしている場合 (または**0**を設定している場合)、MoodleのHTMLエディタは標準的な高さおよび幅（コース/ユーザコンテクストおよびユーザプロファイルで設定可) で表示されます。';
$string['event_all_responses_deleted'] = 'すべての回答が削除されました。';
$string['event_all_responses_saved_as_text'] = 'すべての回答がテキストとして保存されました。';
$string['event_all_responses_viewed'] = 'すべての回答が閲覧されました。';
$string['event_individual_responses_viewed'] = '個別の回答が閲覧されました。';
$string['event_non_respondents_viewed'] = '非回答者が閲覧されました。';
$string['event_previewed'] = 'アンケートがプレビューされました。';
$string['event_question_created'] = '質問が作成されました。';
$string['event_question_deleted'] = '質問が削除されました。';
$string['event_response_deleted'] = '個別の回答が削除されました。';
$string['event_resumed'] = '回答が再開されました。';
$string['event_saved'] = '回答が保存されました。';
$string['event_submitted'] = '回答が提出されました。';
$string['feedback'] = 'フィードバック';
$string['feedback_help'] = 'フィードバックヘルプ';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'さらに {no} のフィードバックフィールドを追加する';
$string['feedbackbysection'] = 'セクションフィードバック';
$string['feedbackdefaultlabel'] = '[新しいセクション]';
$string['feedbackeditingglobal'] = 'アンケートグローバルフィードバックを編集する';
$string['feedbackeditingmessages'] = 'アンケートフィードバックメッセージを編集する';
$string['feedbackeditingsections'] = 'アンケートフィードバックセクションを編集する';
$string['feedbackeditmessages'] = 'セクション設定を保存してフィードバックメッセージを編集する';
$string['feedbackeditsections'] = '設定を保存してフィードバックセクションを編集する';
$string['feedbackerrorboundaryformat'] = 'フィードバックスコアの区間はパーセンテージまたは数値のいずれかである必要があります。あなたが区間 {$a} に入力した値は認識されません。';
$string['feedbackerrorboundaryoutofrange'] = 'フィードバックスコアの区間は0％から100％の間でなければなりません。あなたが区間 {$a} に入力した値は範囲外です。';
$string['feedbackerrorjunkinboundary'] = 'あなたはフィードバックスコアの区間に途切れることのないよう値を入力しなければなりません。';
$string['feedbackerrorjunkinfeedback'] = 'あなたはフィードバックボックスに途切れることがないよう値を入力しなければなりません。';
$string['feedbackerrororder'] = 'フィードバックスコアの区間は順番に並べて最初が最高値でなければなりません。あなたが区間 {$a} に入力した値は順番を外れています。';
$string['feedbackglobal'] = 'グローバルフィードバック';
$string['feedbackglobalheading'] = 'グローバルフィードバック見出し';
$string['feedbackglobalmessages'] = 'グローバルフィードバックメッセージ';
$string['feedbackhdr'] = 'フィードバック';
$string['feedbackheading'] = 'フィードバック見出し';
$string['feedbackheading_help'] = 'フィードバック見出しフィールドには次の2つの変数を使用できます: $scorepercentおよび$oppositescorepercent。';
$string['feedbackmessages'] = '{$a} セクションメッセージ';
$string['feedbacknextsection'] = '次のセクション {$a}';
$string['feedbacknone'] = 'フィードバックメッセージはありません。';
$string['feedbacknotes'] = 'フィードバック注意点';
$string['feedbacknotes_help'] = 'ここで入力したテキストはフィードバックレポート最後で回答者に提示されます。';
$string['feedbackoptions'] = 'フィードバックオプション';
$string['feedbackoptions_help'] = 'フィードバックオプションはアンケートに以下の質問タイプおよび質問設定が含まれている場合に利用できます:
「ラジオボタン」「ドロップダウンボックス」「Yes/No」または「評価 (標準またはOsgoodスケール)」これらの質問は「必須」に設定して「質問名」フィールドを空白にせずに可能な回答の選択肢に値を含める必要があります。
スライダ質問では最小スライダ範囲に負の値は使用できません。';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'この質問はフィードバックセクション [{$a}] の部分です。';
$string['feedbackremovesection'] = 'この質問を削除した場合、フィードバックセクション [{$a}] を完全に削除されます。';
$string['feedbackreport'] = 'フィードバックレポート';
$string['feedbackscore'] = 'フィードバックスコア';
$string['feedbackscoreboundary'] = 'フィードバックスコア区間';
$string['feedbackscores'] = 'スコアを表示する';
$string['feedbackscores_help'] = 'フィードバックスコアテーブルを表示する';
$string['feedbacksection'] = 'セクション';
$string['feedbacksectionheading'] = '{$a} セクション見出し';
$string['feedbacksectionheadingmissing'] = 'あなたはこのフィードバックセクションの見出しを入力する必要があります!';
$string['feedbacksectionheadingtext'] = '見出し';
$string['feedbacksectionlabel'] = 'ラベル';
$string['feedbacksectionlabel_help'] = 'このラベルは、グラフ・図で使用されます。できるだけ簡潔にしてください！';
$string['feedbacksectionquestions'] = '{$a} セクション質問';
$string['feedbacksections'] = 'フィードバックセクション';
$string['feedbacksectionsselect'] = 'セクション';
$string['feedbacksectionsselect_help'] = 'これらのセクションにあなたの質問を入力してください。';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'フィードバック設定が保存されました。';
$string['feedbacktype'] = 'フィードバックタイプ';
$string['field'] = '質問 {$a}';
$string['fieldlength'] = '入力ボックス幅';
$string['fieldlength_help'] = 'テキストボックスの質問タイプでは入力ボックス長さおよび回答者が入力するテキストの最大文字数を入力してください。
デフォルト値は入力ボックス幅が半角20文字，入力テキスト最大文字数が半角25文字です。';
$string['finished'] = 'あなたはこのアンケートのすべての質問に回答しました!';
$string['firstrespondent'] = '最初の回答者';
$string['formateditor'] = 'HTMLエディタ';
$string['formatplain'] = 'プレインテキスト';
$string['grade'] = '提出評定';
$string['gradesdeleted'] = 'アンケート評定が削除されました';
$string['headingtext'] = '見出しテキスト';
$string['horizontal'] = '横並び';
$string['id'] = 'ID';
$string['includechoicecodes'] = '選択コードを含む';
$string['includechoicetext'] = '選択テキストを含む';
$string['includeincomplete'] = '未完了の回答を含む';
$string['includerankaverages'] = 'ランク問題の平均値を含む';
$string['incorrectcourseid'] = 'コースIDが正しくありません。';
$string['incorrectmodule'] = 'コースモジュールIDが正しくありません。';
$string['incorrectquestionnaire'] = 'アンケートが正しくありません。';
$string['indirectwarnings'] = 'このリストは間接的な依存質問および直接依存質問の残りの依存質問を示しています:';
$string['invalidincrement'] = '値の増分は最大値より小さくなければならないことに留意してください。例えば1～10の尺度の場合、増分値はおそらく「1」となります。';
$string['invalidminmaxrange'] = 'この質問タイプでは-100から+100の絶対最大範囲をサポートしています。私たちは大半のアンケートで1～10または-10～+10の範囲の使用を想定しています。';
$string['invalidrange'] = 'スライダの最大値はスライダの最小値より大きくする必要があります。';
$string['invalidresponse'] = '無効な回答が特定されました。';
$string['invalidresponserecord'] = '無効な回答レコードが特定されました。';
$string['invalidsectionid'] = '無効なフィードバックセクションが指定されました。';
$string['invalidstartingvalue'] = '開始値は最小値または最大値に等しいか、その間の値にする必要があります。例えば1～10の尺度を使用する場合、開始値は5となります。';
$string['invalidsurveyid'] = '無効なアンケートIDです。';
$string['kindofratescale'] = '評価尺度のタイプ';
$string['kindofratescale_help'] = 'ヘルプ詳細を表示するには下のリンクを右クリックしてください。';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = '最後の回答者';
$string['leftlabel'] = '左ラベル';
$string['leftpart'] = '{$a->min} = {$a->leftlabel}';
$string['leftpartdefault'] = '{$a->min} = 最小スライダ範囲';
$string['length'] = '長さ';
$string['managequestions'] = '質問を管理する';
$string['managequestions_help'] = 'あなたは質問編集ページの「質問を管理する」セクションでアンケート質問に対して様々な操作を実施できます。';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = '必須 - すべての依存関係を満たす必要があります。';
$string['maxdigitsallowed'] = '最大許容桁数';
$string['maxdigitsallowed_help'] = '**最大許容桁数**を使用して数値質問に入力する文字数の制限を設定します。小数点も1文字としてカウントされることに留意してください!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = '最大強制回答数';
$string['maxforcedresponses_help'] = 'これらのパラメータを使用して回答者に最小のチェックボックス**最小**および最大のチェックボックス**最大**にチェックを入れるよう強制します。チェックボックスの正確な数を強制的にチェックするには**最小**および**最大**を同じ値に設定してください。最小値または最大値のみが必要な場合、もう一方の値をデフォルトの**0**のままにしてください。あなたが**最小**または**最大** をデフォルトの**0**以外の値に設定した場合、回答者があなたの要件を満たさない場合は警告メッセージが表示されます。もちろん、あなたはアンケートの一般的な指示または関連する質問のテキストのいずれかで回答者に対して要件を明確にする必要があります。';
$string['maxrange'] = '最大スライダ幅 (右)';
$string['maxrange_help'] = '右側の範囲の最大値を設定します。デフォルトは100ですが、1～100の間の任意の数値を指定できます。左側の最小値が負の値の場合、最大範囲は正の記号 (+) で表されます。';
$string['maxtextlength'] = '最大文字数';
$string['maxtextlength_help'] = 'テキストボックスの質問タイプでは入力ボックス長さおよび回答者が入力するテキストの最大文字数を入力してください。
デフォルト値は入力ボックス幅が半角20文字，入力テキスト最大文字数が半角25文字です。';
$string['messageprovider:message'] = 'アンケートリマインダ';
$string['messageprovider:notification'] = 'アンケート提出';
$string['middlepart'] = ', {$a->centreval} = {$a->middlelabel}';
$string['middlepartdefault'] = ', {$a->centreval} = 平均';
$string['middlepartwithtwovalues'] = ', {$a->centreval1} & {$a->centreval2} = {$a->middlelabel}';
$string['middlepartwithtwovaluesdefault'] = ', {$a->centreval1} & {$a->centreval2} = 平均';
$string['minforcedresponses'] = '最小強制回答数';
$string['minforcedresponses_help'] = 'これらのパラメータを使用して回答者に最小のチェックボックス**最小**および最大のチェックボックス**最大**にチェックを入れるよう強制します。チェックボックスの正確な数を強制的にチェックするには**最小**および**最大**を同じ値に設定してください。最小値または最大値のみが必要な場合、もう一方の値をデフォルトの**0**のままにしてください。あなたが**最小**または**最大** をデフォルトの**0**以外の値に設定した場合、回答者があなたの要件を満たさない場合は警告メッセージが表示されます。もちろん、あなたはアンケートの一般的な指示または関連する質問のテキストのいずれかで回答者に対して要件を明確にする必要があります。';
$string['minrange'] = '最小スライダ幅 (左)';
$string['minrange_help'] = '左側の範囲の最小値を設定します。デフォルトは1ですが、-100まで設定できます。負の数 (-100～-1) を使用した場合、右側の最大値は正の記号 (+) で表されます。';
$string['misconfigured'] = 'コース設定が正しくありません。';
$string['missingname'] = '質問 {$a} に質問名がないため、このフィードバックセクションでは使用できません。';
$string['missingnameandrequired'] = '質問 {$a} に質問名がないため、また必須でもないため、このフィードバックセクションでは使用できません。';
$string['missingquestion'] = '必須質問に回答してください。';
$string['missingquestions'] = '必須質問に回答してください:';
$string['missingrequired'] = '質問 {$a} が必須でないため、このフィードバックセクションでは使用できません。';
$string['modulename'] = 'アンケート';
$string['modulename_help'] = 'アンケートモジュールではユーザからデータを収集する目的で様々な質問タイプを使用してアンケートを作成できます。';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'アンケート';
$string['movedisabled'] = 'このアイテムは移動できません。';
$string['myresponses'] = 'あなたのすべての回答';
$string['myresponsetitle'] = 'あなたの {$a} 回答';
$string['myresults'] = 'あなたの結果';
$string['name'] = 'アンケート名';
$string['navigate'] = '質問の分岐を許可する';
$string['navigate_help'] = '「Yes/No」および「ラジオボタン」質問を有効にた場合、あなたのアンケートの選択肢に依存する下位質問を作成できます。';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'フィードバックセクションに移動する';
$string['next'] = '次へ';
$string['nextpage'] = '次のページ';
$string['nlines'] = '{$a} 行';
$string['noanswer'] = '未回答';
$string['noattempts'] = 'このアンケートはまだ回答されていません。';
$string['nodata'] = '投稿データはありません。';
$string['noduplicates'] = '重複選択なし';
$string['noduplicateschoiceserror'] = 'あなたは「重複選択なし」オプション設定用に少なくとも2つの選択候補を入力する必要があります!';
$string['non_respondents'] = 'まだこのアンケートへの回答を提出していないユーザ';
$string['noneinuse'] = 'このアンケートには質問がありません。';
$string['nopermissions'] = '申し訳ございません。現在、あなたにはこのページを閲覧またはこの操作を実行する権限がありません。';
$string['nopublicsurveys'] = '公開アンケートはありません。';
$string['noresponsedata'] = 'この質問には回答はありません。';
$string['noresponses'] = '回答なし';
$string['normal'] = 'ノーマル';
$string['not_started'] = '開始されていない';
$string['notanumber'] = '<strong>{$a}</strong>は受け入れ可能な数値フォーマットではありません。';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'N/Aカラム';
$string['notavail'] = 'このアンケートは終了しました。先生に削除を依頼してください。';
$string['noteligible'] = 'あなたはこのアンケートに回答できません。';
$string['notemplatesurveys'] = 'アンケートのテンプレートはありません。';
$string['notenoughscaleitems'] = 'あなたは最低2つの尺度項目を入力する必要があります!';
$string['notificationfull'] = 'すべての提出';
$string['notifications'] = '提出通知を送信する';
$string['notifications_help'] = '回答が提出された際に「mod/questionnaire:submissionnotification」ケイパビリティを持つロールに通知します';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = '通知のみ';
$string['notopen'] = 'このアンケートは {$a} まで開始されません。';
$string['notrequired'] = '回答の必要はありません。';
$string['notset'] = 'が設定されていない場合';
$string['nousersselected'] = 'ユーザが選択されていません。';
$string['num'] = '#';
$string['numattemptsmade'] = 'このアンケートの回答数: {$a}';
$string['numberfloat'] = 'あなたが入力した値<strong>{$a->number}</strong>は小数点<strong>{$a->precision}</strong>で変換/四捨五入されます。';
$string['numberofdecimaldigits'] = '小数点以下の桁数';
$string['numberofdecimaldigits_help'] = 'アンケートレポートページで集計および表示される平均値の書式を**小数点以下の桁数**で指定します。';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = '尺度項目の個数';
$string['numberscaleitems_help'] = '尺度項目の個数はあなたの評価尺度で使用される「項目の個数」です。あなたは通常3から5の間の値を使用すべきです。デフォルト値は次のとおりです: **5**';
$string['numeric'] = '数値形式';
$string['numeric_help'] = '回答が正しくフォーマットされた数値であることが予想される場合、この質問タイプを使用してください。';
$string['of'] = '/';
$string['openafterclose'] = 'あなたは終了日の後に開始日を指定しました。';
$string['opendate'] = '開始日';
$string['option'] = 'オプション {$a}';
$string['optional'] = '任意 - 1つ以上の依存関係を満たす必要があります。';
$string['optionalname'] = '質問名';
$string['optionalname_help'] = '質問名はCSV/Excel形式での回答エクスポート時のみ使用されます。CSVファイルにエクスポートすることがない場合，あなたはアンケート名を気にする必要はありません。あなたがアンケートデータを定期的にCSVファイルにエクスポートする場合、質問名を2つのオプションから選択できます。';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- または -';
$string['order_ascending'] = '昇順';
$string['order_default'] = 'デフォルトの並べ替え順を表示する';
$string['order_descending'] = '降順';
$string['orderresponses'] = '回答の並べ替え順';
$string['orderresponses_help'] = 'すべての回答を表示する場合、あなたは次の4 種類の質問に対して回答数 (平均カラム) で選択肢を並べ替えれます。

* 単一選択のラジオボタン
* 単一選択のドロップダウンリスト
* 複数選択 (チェックボックス)
*  レート質問 (リッカート尺度を含む)

あなたがすべての回答のページにアクセスした場合、デフォルトではすべての回答がアンケート作成者の質問選択肢入力順で並べられます。

 あなたは回答を昇順または降順で並べ替えれます。';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'その他:';
$string['otherempty'] = 'このオプションをチェックした場合、あなたは何らかのテキストを入力する必要があります!';
$string['overviewnumresplog'] = '回答 (複数)';
$string['overviewnumresplog1'] = '回答';
$string['overviewnumrespvw'] = '回答 (複数)';
$string['overviewnumrespvw1'] = '回答';
$string['owner'] = 'オーナー';
$string['page'] = 'ページ';
$string['pageof'] = 'ページ {$a->page} / {$a->totpages}';
$string['parent'] = '親';
$string['participant'] = '参加者';
$string['pleasecomplete'] = 'この選択を完了してください。';
$string['pluginadministration'] = 'アンケート管理';
$string['pluginname'] = 'アンケート';
$string['position'] = 'ポジション';
$string['possibleanswers'] = '考えられる回答';
$string['posteddata'] = '投稿さらたデータでの到達ページ:';
$string['preview_label'] = 'プレビュー';
$string['preview_questionnaire'] = 'アンケートプレビュー';
$string['previewing'] = 'アンケートプレビュー';
$string['previous'] = '前へ';
$string['previouspage'] = '前のページ';
$string['print'] = 'この回答を印刷する';
$string['printblank'] = '空欄を印刷する';
$string['printblanktooltip'] = '空白のアンケートを含むプリンタフレンドリなウィンドウを開く';
$string['printtooltip'] = '現在の回答のプリンタフレンドリなウィンドウを開く';
$string['privacy:metadata:questionnaire_resp_multiple'] = '多肢選択質問の回答です。';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'この回答の選択肢レコードIDです。';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'この回答の質問レコードIDです。';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'この回答の回答レコードIDです。';
$string['privacy:metadata:questionnaire_resp_single'] = '単一選択質問への回答です。';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'この回答の選択肢レコードIDです。';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'この回答の質問レコードIDです。';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'この回答の回答レコードIDです。';
$string['privacy:metadata:questionnaire_response'] = '進行中または提出された回答です。';
$string['privacy:metadata:questionnaire_response:complete'] = '回答完了ステータスです。';
$string['privacy:metadata:questionnaire_response:grade'] = 'この回答に対する評定です。';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'この回答のアンケートレコードIDです。';
$string['privacy:metadata:questionnaire_response:submitted'] = 'この回答の最新の保存タイムスタンプです。';
$string['privacy:metadata:questionnaire_response:userid'] = 'この回答のユーザIDです。';
$string['privacy:metadata:questionnaire_response_bool'] = 'ブール値 (Yes/No) の質問回答です。';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = '特定のブール値の回答です。';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'この回答の質問レコードIDです。';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'この回答の回答レコードIDです。';
$string['privacy:metadata:questionnaire_response_date'] = '日付の質問回答です。';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'この回答の質問レコードIDです。';
$string['privacy:metadata:questionnaire_response_date:response'] = '特定の日付の回答です。';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'この回答の回答レコードIDです。';
$string['privacy:metadata:questionnaire_response_other'] = '「その他」の選択肢のテキスト回答です。';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'この回答の選択肢レコードIDです。';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'この回答の質問レコードIDです。';
$string['privacy:metadata:questionnaire_response_other:response'] = '特定のテキストの回答です。';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'この回答の回答レコードIDです。';
$string['privacy:metadata:questionnaire_response_rank'] = 'ランク付けされた質問への回答です。';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'この回答の選択肢レコードIDです。';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'この回答の質問レコードIDです。';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = '特定のランク付けされた回答です。';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'この回答の回答レコードIDです。';
$string['privacy:metadata:questionnaire_response_text'] = 'テキスト質問に対する回答です。';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'この回答の質問レコードIDです。';
$string['privacy:metadata:questionnaire_response_text:response'] = '具体的なテキストの答えです。';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'この回答の回答レコードIDです。';
$string['private'] = 'プライベート';
$string['progressbar'] = 'プログレスバーを表示する';
$string['progressbar_info'] = 'アンケート {$a} 完了';
$string['progresshelp'] = 'プログレスバー';
$string['progresshelp_help'] = 'プログレスバーを埋めるために次のページに進む';
$string['public'] = '公開';
$string['publiccopy'] = 'コピー:';
$string['publicoriginal'] = 'オリジナル:';
$string['qtype'] = 'タイプ';
$string['qtype_help'] = 'ユーザが回答できる回数を1回、毎日、毎週、毎月または回数無制限 (多数) のどれにするか選択してください。';
$string['qtypedaily'] = '毎日回答';
$string['qtypemonthly'] = '毎月回答';
$string['qtypeonce'] = '1回のみ回答';
$string['qtypeunlimited'] = '何回でも回答';
$string['qtypeweekly'] = '毎週回答';
$string['questionnaire:addinstance'] = '新しいアンケートを追加する';
$string['questionnaire:copysurveys'] = 'テンプレートおよびプライベートアンケートをコピーする';
$string['questionnaire:createpublic'] = '公開アンケートを作成する';
$string['questionnaire:createtemplates'] = 'テンプレートアンケートを作成する';
$string['questionnaire:deleteresponses'] = 'すべての回答を削除する';
$string['questionnaire:downloadresponses'] = 'CSVファイルで回答をダウンロードする';
$string['questionnaire:editquestions'] = 'アンケート質問を作成および編集する';
$string['questionnaire:manage'] = 'アンケートを作成および編集する';
$string['questionnaire:message'] = '非回答者にメッセージを送信する';
$string['questionnaire:preview'] = 'アンケートをプレビューする';
$string['questionnaire:printblank'] = '空白のアンケートを印刷する';
$string['questionnaire:readallresponseanytime'] = 'いつでもすべての回答を閲覧する';
$string['questionnaire:readallresponses'] = '回答概要を閲覧する (オープン時間に準ずる)';
$string['questionnaire:readownresponses'] = '自分の回答のみ閲覧する';
$string['questionnaire:submissionnotification'] = '提出ごとに通知を受信する';
$string['questionnaire:submit'] = 'アンケートを完了して提出する';
$string['questionnaire:view'] = 'アンケートを閲覧する';
$string['questionnaire:viewsingleresponse'] = '完了した回答を個別に閲覧する';
$string['questionnaireadministration'] = 'アンアンケート管理';
$string['questionnairecloses'] = 'アンケート終了';
$string['questionnaireopens'] = 'アンケート開始';
$string['questionnairereport'] = 'アンケートレポート';
$string['questionnum'] = '質問 #';
$string['questions'] = '質問';
$string['questionsinsection'] = 'このセクションの質問:';
$string['questiontypes'] = '質問タイプ';
$string['questiontypes_help'] = '以下のMoodleドキュメントをご覧ください。';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'ラジオボタン';
$string['radiobuttons_help'] = 'この質問タイプでは回答者は提供された選択肢のうちいずれかを選択する必要があります。';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'ランク';
$string['ratescale'] = '測定尺度 (尺度 1..5)';
$string['ratescale_help'] = '以下のMoodleドキュメントをご覧ください。';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'アンケートタイプ';
$string['realm_help'] = '* **アンケートには以下の3種類があります:**
 * プライベート - アンケートが作成されたコース内でのみ使用できます。
 * テンプレート - 複製および編集できます。
 * 公開 - 他のコースからも利用できます。';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'このアンケート完了後、ユーザがリダイレクトされるURLです。';
$string['remove'] = '削除';
$string['removeallquestionnaireattempts'] = 'アンケート回答をすべて削除します。';
$string['removenotinuse'] = 'このアンケートはすでに削除された公開済みアンケートに依存しています。もはや使用できないため、削除すべきです。';
$string['required'] = '必須回答';
$string['required_help'] = 'あなたが***Yes***を選択した場合，この質問への回答が必須となります。すなわち、この質問に回答するまで回答者はアンケートを提出できません。';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = '必要パラメータが欠如してます。';
$string['reset'] = 'リセット';
$string['respeligiblerepl'] = '(ロールによる置き換え)';
$string['respondent'] = '回答者';
$string['respondenteligibleall'] = 'すべて';
$string['respondenteligiblestudents'] = '学生のみ';
$string['respondenteligibleteachers'] = '教師のみ';
$string['respondents'] = '回答者';
$string['respondenttype'] = '回答者タイプ';
$string['respondenttype_help'] = 'ここを「フルネーム」に設定した場合、ああんたはそれぞれの回答に回答者の氏名を表示できます。「匿名」に設定した場合、あなたはそれぞれの回答からユーザ識別情報を秘匿できます。';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = '匿名';
$string['respondenttypefullname'] = 'フルネーム';
$string['response'] = '回答';
$string['responsefieldlines'] = '入力ボックスサイズ';
$string['responseformat'] = '回答形式';
$string['responseoptions'] = '回答オプション';
$string['responses'] = '回答';
$string['responseview'] = '学生はすべての回答を閲覧できる';
$string['responseview_help'] = 'あなたは提出されたアンケート (一般統計テーブル) のすべての回答者の回答を閲覧できる人を指定できます。';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = '常に';
$string['responseviewstudentsnever'] = '不可';
$string['responseviewstudentswhenanswered'] = 'アンケート回答後';
$string['responseviewstudentswhenclosed'] = 'アンケート終了後に可';
$string['restrictedtoteacher'] = 'これらの機能は編集権限のある教師のみに制限されています!';
$string['resume'] = '回答を保存/再開する';
$string['resume_help'] = 'このオプションを設定した場合、ユーザはアンケートの回答を送信する前に保存できます。
 ユーザはアンケートを未完成のままにして、後日保存ポイントから再開できます。';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'アンケートを再開する';
$string['return'] = '戻る';
$string['rightlabel'] = '右ラベル';
$string['rightpart'] = 'および {$a->max} = {$a->rightlabel}';
$string['rightpartdefault'] = 'および {$a->max} = 最大スライダ';
$string['save'] = '保存する';
$string['save_and_exit'] = '保存して終了する';
$string['saveasnew'] = '新規質問として追加する';
$string['savedbutnotsubmitted'] = 'このアンケートは保存されましたが，まだ提出されていません。';
$string['savedprogress'] = 'あなたの進捗状況が保存されました。あなたはいつでも戻ってこのアンケートを完了できます。';
$string['saveeditedquestion'] = '質問 {$a} を保存する';
$string['savesettings'] = '設定を保存する';
$string['search:activity'] = 'アンケート - 活動情報';
$string['search:question'] = 'アンケート - 質問';
$string['section'] = '説明';
$string['sectionbreak'] = '----- ページ区切り -----';
$string['sectionbreak_help'] = '----- ページ区切り -----';
$string['sectionsnotset'] = 'あなたはセクションごとに少なくとも1つの質問を選択する必要があります!<br />選択されていないセクション: {$a}';
$string['sectiontext'] = 'ラベル';
$string['sectiontext_help'] = 'これは質問ではありませんが，一連の質問を紹介する際に表示される (短い) テキストです。';
$string['selecttheme'] = 'このアンケートで使用するテーマ (CSS) を選択してください。';
$string['send'] = '送信する';
$string['send_message'] = '選択したユーザ宛てにメッセージを送信する';
$string['send_message_to'] = 'メッセージを送信する:';
$string['sendemail'] = 'メールを送信する';
$string['sendemail_help'] = '提出コピーを指定されたメールアドレス宛に送信します。あなたはカンマで区切って複数のメールアドレスを指定できます。メールバックアップしない場合、空白のままにしてください。これにアクセスするにはモジュール設定で「allowemailreporting」を有効にする必要があります。';
$string['set'] = 'が設定された場合';
$string['settings'] = '設定';
$string['settingssaved'] = '設定が保存されました。';
$string['show_nonrespondents'] = '非回答者';
$string['slider'] = 'スライダ';
$string['slider_help'] = 'スライダ質問では回答者は2つの極端な値の間でスライダをドラッグすることで連続した範囲から値を選択できます。中央値を設定することもできます。';
$string['started'] = '開始';
$string['startingvalue'] = 'スライダ開始値';
$string['startingvalue_help'] = 'スライダの開始値では回答者に対してスライダを最初に表示する場所を指定します。範囲が不明なため、デフォルトは 1です。中心値  (1-100の範囲の中心値は50です) を指定して範囲の中央から開始もできます。';
$string['stepvalue'] = 'スライダ増分値';
$string['stepvalue_help'] = 'スライダ増分値では回答者が範囲内でどの程度細かく回答を示すかを指定します。この質問のデフォルトは1～100の範囲で増分値は1です。回答者は70、71、72、73、74等の値を指定できます。しかし、あなたは回答者が60、65、70、75、80などの値を指定できるよう5刻みを設定したり、1刻みで1～10の範囲も指定できます。';
$string['strfdate'] = '%Y/%m/%d';
$string['strfdateformatcsv'] = 'Y/m/d H:i:s';
$string['strictdateformatting'] = '以下の日付ピッカで日付を入力してください。';
$string['subject'] = '件名';
$string['submissionnotificationhtmlanon'] = 'アンケート「 {$a->name} 」に新しい<a href="{$a->submissionurl}">回答</a>があります。';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> がコース 「 {$a->coursename} 」のアンケート「 {$a->name} 」に新しい<a href="{$a->submissionurl}">回答</a>を提出しました。';
$string['submissionnotificationsubject'] = '新しいアンケート提出';
$string['submissionnotificationtextanon'] = 'これはアンケート「 {$a->name} 」に対する新しい提出 ({$a->submissionurl}) です。';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) がコース 「 {$a->coursename} 」のアンケート「 {$a->name} 」に新しい<a href="{$a->submissionurl}">回答</a>を提出しました。';
$string['submitoptions'] = '提出オプション';
$string['submitpreview'] = 'プレビューを提出する';
$string['submitpreviewcorrect'] = 'この提出は正しく記入されたものとして受理されます。';
$string['submitsurvey'] = '回答を提出する';
$string['submitted'] = '提出完了:';
$string['subtitle'] = 'サブタイトル';
$string['subtitle_help'] = 'このアンケートのサブタイトルです。最初のページのタイトルの下に表示されます。';
$string['summary'] = '概要';
$string['summaryreportattached'] = 'アンケート概要レポート添付';
$string['surveynotexists'] = 'アンケートがありません。';
$string['surveyowner'] = 'あなたがこの操作を実施するアンケートのオーナーでなければなりません。';
$string['surveyresponse'] = 'アンケート回答';
$string['template'] = 'テンプレート';
$string['templatenotviewable'] = 'テンプレートアンケートを表示できません。';
$string['text'] = '質問文';
$string['textareacolumns'] = 'テキストエリア列';
$string['textareacolumns_help'] = 'この質問は**x**「テキストエリア列」 (またはエリア*幅*) および**y**「テキストエリア行」 (テキストの*行数*) のプレインテキストボックスを表示します。あなたがxおよびyの両方をデフォルト値の**0**のままにしている場合 (または**0**を設定している場合)、MoodleのHTMLエディタは標準的な高さおよび幅（コース/ユーザコンテクストおよびユーザプロファイルで設定可) で表示されます。';
$string['textarearows'] = 'テキストエリア行';
$string['textbox'] = 'テキストボックス';
$string['textbox_help'] = 'テキストボックスの質問タイプでは入力ボックス長さおよび回答者が入力するテキストの最大文字数を入力してください。
デフォルト値は入力ボックス幅が半角20文字，入力テキスト最大文字数が半角25文字です。';
$string['textdownloadoptions'] = 'CSVダウンロードオプション';
$string['thank_head'] = 'このアンケートにご協力いただき、ありがとうございます。';
$string['theme'] = 'テーマ';
$string['thismonth'] = '今月';
$string['thisresponse'] = 'この回答';
$string['thisweek'] = '今週';
$string['thousands'] = '3桁ごとの桁区切り文字を使用しないでください。';
$string['title'] = 'タイトル';
$string['title_help'] = 'このアンケートのタイトルは各ページの上部に表示されます。デフォルトのタイトルにはアンケート名が設定されていますが、あなたが好きなように編集できます。';
$string['today'] = '本日';
$string['total'] = '合計';
$string['totalofnumbers'] = '入力値の合計';
$string['totalresponses'] = '質問に対する回答総数';
$string['type'] = '質問タイプ';
$string['unanswered'] = '未回答';
$string['undefinedquestiontype'] = '未定義の質問タイプです!';
$string['unknown'] = '不明';
$string['unknownaction'] = '不明なアンケートアクションの指定されました ...';
$string['url'] = '確認URL';
$string['url_help'] = 'ユーザがこのアンケートを完了した後にリダイレクトされるURLです。';
$string['useprivate'] = '既存のものをコピーする';
$string['usepublic'] = '公開の利用';
$string['usetemplate'] = 'テンプレートの利用';
$string['vertical'] = '縦置き';
$string['view'] = '閲覧';
$string['viewallresponses'] = 'すべての回答を閲覧する';
$string['viewallresponses_help'] = 'アンケートが**グループモード**: *可視グループ*または*分離グループ*に設定されている場合や、利用者が (現在のコンテクストにおいて) *moodle/site:accessallgroups*ケイパビリティを有している場合、また現在のコースでグループが設定されている場合、ユーザはグループドロップダウンリストにアクセスできます。
このドロップダウンリストによりユーザは質問の回答をグループごとに「フィルタ」できます。
**グループモード**: *分離グループ* に設定されている場合、*moodle/site:accessallgroups*ケイパビリティを有さない利用者 (通常、学生または編集権限のない教師等) は所属グループの回答のみ閲覧できます。';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = '回答リスト';
$string['viewindividualresponse'] = '個別回答';
$string['viewindividualresponse_help'] = '個別回答を表示するには以下のリストの回答者の氏名をクリックしてください。';
$string['viewresponses'] = 'すべての回答 ({$a})';
$string['viewyourresponses'] = 'あなたの回答を表示する';
$string['warning'] = '警告: エラーが発生しました。';
$string['where'] = '-';
$string['wronganswers'] = 'あなたの回答に何らかの問題があります (以下をご覧ください)。';
$string['wrongdateformat'] = '入力された日付: <strong>{$a}</strong>は例に示されている書式に対応していません。';
$string['wrongdaterange'] = 'エラー! 年は1902年から2037年までの間に設定してください。';
$string['wrongformat'] = '質問に対するあなたの回答に何らかの問題があります:&nbsp;';
$string['wrongformats'] = '質問に対するあなたの回答に何らかの問題があります:&nbsp;';
$string['yesno'] = 'Yes/No';
$string['yesno_help'] = 'シンプルなYes/No質問です。';
$string['yourresponse'] = 'あなたの回答を表示する';
$string['yourresponses'] = 'あなたの回答を表示する';
